/************************************************************************
*FILE: AppHmi_PhoneStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_PhoneStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed May 28 16:37:50 2025
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_PhoneStateMachineSEMLibB.h"


#include "AppHmi_PhoneStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_UINT32 CurrentView = 0ul;

VS_INT DeviceTypeConnected = 0;

VS_INT IsAcceptRequested = 0;

VS_INT IsContactListPersistent = 0;

VS_INT IsDTMFActive = 0;

VS_BOOL IsDeviceConnected = 0;

VS_BOOL IsDeviceConnectingActive = 0;

VS_BOOL IsDeviceListOperationProgress = 0;

VS_BOOL IsDialed = 0;

VS_BOOL IsIntercomCallActive = 0;

VS_BOOL IsParingActive = 0;

VS_BOOL IsReadAloudActive = 0;

VS_BOOL IsRejectRequested = 0;

VS_BOOL IsSMSContactActive = 0;

VS_INT ListViewID = 0;

VS_INT Sm_ActiveSource = 0;

VS_BOOL bBTVRViewShown = 0;

VS_BOOL bChangeDeviceStateReq = 0;

VS_INT g_SM_CPWhileBTConn = 0;

VS_BOOL g_SM_IsRVCViewEnabled = 0;

VS_INT g_SM_SpiSessionStatus = 0;

VS_BOOL sm_variant_intercom = 1;

VS_BOOL sm_variant_kitchen = 1;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_PhoneStateMachine::SEM_InitInternalVariables (void)
{
  CallListDownloadStatus = 0;
  CallStatus = 0;
  ContactsCallListNotPersistant = 0;
  IntercomCallScreenInfo = 0;
  IsAppActivatedInternally = 0;
  IsContactsBackSelected = 0;
  IsDeviceInDiscoverableMode = 0;
  IsDeviceReseted = 1;
  IsHomeScreenActive = 0;
  IsSMSActive = 0;
  IsSMSExpandActive = 0;
  PhoneBookDownloadStatus = 0;
  PreviousActiveStateForCallAction = 0L;
  PreviousActiveStateForOPT = 0L;
  PreviousActiveStateForPhoneSelection = 0L;
  PreviousCallStaus = 0;
  PreviousScreenEntry = 0ul;
  PreviousScreenEntryBTVR = 0ul;
  RequestEntryState = 0ul;
  WasCallListLoadingActive = 0;
  WasContactListLoadingActive = 0;
  WasDTMFActive = 0;
}


void AppHmi_PhoneStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  if (EventNo >= 298)
  {
    EventNo -= 21;
  }
  switch (EventNo)
  {
  case 6:
    VSDBVar.DB6.VS_INTVar[0] = IsAcceptRequested;
    break;
  case 27:
    VSDBVar.DB27.VS_BOOLVar[0] = IsRejectRequested;
    break;
  case 72:
    VSDBVar.DB72.VS_UINT32Var[0] = PreviousScreenEntryBTVR;
    break;
  case 158:
    VSDBVar.DB158.VS_UINT32Var[0] = PreviousScreenEntry;
    break;
  case 176:
    VSDBVar.DB180.VS_BOOLVar[0] = IsReadAloudActive;
    break;
  case 180:
    VSDBVar.DB180.VS_BOOLVar[0] = IsReadAloudActive;
    break;
  case 194:
    VSDBVar.DB194.VS_INTVar[0] = IsAppActivatedInternally;
    break;
  case 226:
    VSDBVar.DB226.VS_INT32Var[0] = PreviousActiveStateForOPT;
    break;
  case 303:
    VSDBVar.DB194.VS_INTVar[0] = WasContactListLoadingActive;
    break;
  case 306:
    VSDBVar.DB194.VS_INTVar[0] = IntercomCallScreenInfo;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_PhoneStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 218:
    EventArgsVar.DB219.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 219:
    EventArgsVar.DB219.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 269:
    EventArgsVar.DB275.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 273:
    EventArgsVar.DB275.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 274:
    EventArgsVar.DB275.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 275:
    EventArgsVar.DB275.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 276:
    EventArgsVar.DB276.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 277:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 278:
    EventArgsVar.DB278.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 288:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 289:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 290:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 291:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 292:
    EventArgsVar.DB292.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 293:
    EventArgsVar.DB292.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 294:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 295:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 296:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 297:
    EventArgsVar.DB292.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;
  SEM.OriginalEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_PhoneStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB219.VS_INT8Var[0] == INCOMING_CALL_DEVICETYPE_ACTIVE);
  case 1:
    return (VS_BOOL)(IsIntercomCallActive == 0);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB219.VS_INT8Var[0] == INCOMING_CALL_DEVICETYPE_PASSIVE);
  case 3:
    return (VS_BOOL)(CallStatus == 9);
  case 4:
    return (VS_BOOL)(IsAcceptRequested != 1);
  case 5:
    return (VS_BOOL)(IsRejectRequested != 1);
  case 6:
    return (VS_BOOL)(IsReadAloudActive == 1);
  case 7:
    return (VS_BOOL)(VS_BOOL_FALSE == g_SM_IsRVCViewEnabled);
  case 8:
    return (VS_BOOL)(IsParingActive == 1);
  case 9:
    return (VS_BOOL)(CallStatus == 2 || CallStatus == 1);
  case 10:
    return (VS_BOOL)(CallStatus == 4 || CallStatus == 3);
  case 11:
    return (VS_BOOL)(CallStatus > 4 && CallStatus <= 8);
  case 12:
    return (VS_BOOL)(CallStatus != 0 && CallStatus != 9);
  case 13:
    return (VS_BOOL)(DeviceTypeConnected == 1);
  case 14:
    return (VS_BOOL)(CallStatus == 0 || CallStatus == 9);
  case 15:
    return (VS_BOOL)(DeviceTypeConnected != 1);
  case 16:
    return (VS_BOOL)(CallStatus == 0);
  case 17:
    return (VS_BOOL)(CallStatus == PreviousCallStaus);
  case 18:
    return (VS_BOOL)(PhoneBookDownloadStatus != 2);
  case 19:
    return (VS_BOOL)(PhoneBookDownloadStatus == 2);
  case 20:
    return (VS_BOOL)(g_SM_SpiSessionStatus != SPI_SESSION_ANDROID_AUTO_ACTIVE && g_SM_SpiSessionStatus != SPI_SESSION_CARPLAY_ACTIVE);
  case 21:
    return (VS_BOOL)(CallListDownloadStatus != 2);
  case 22:
    return (VS_BOOL)(CallListDownloadStatus == 2);
  case 23:
    return (VS_BOOL)(CallStatus == 3);
  case 24:
    return (VS_BOOL)(g_SM_SpiSessionStatus == SPI_SESSION_ANDROID_AUTO_ACTIVE || g_SM_SpiSessionStatus == SPI_SESSION_CARPLAY_ACTIVE);
  case 25:
    return (VS_BOOL)(IsHomeScreenActive != 1);
  case 26:
    return (VS_BOOL)(CallStatus != 0);
  case 27:
    return (VS_BOOL)(IsHomeScreenActive == 1);
  case 28:
    return (VS_BOOL)(IsDeviceConnectingActive != 1);
  case 29:
    return (VS_BOOL)(CallStatus == 3 || CallStatus == 4);
  case 30:
    return (VS_BOOL)(CallStatus != 0 && CallStatus != 3 && CallStatus != 4 && CallStatus != 9);
  case 31:
    return (VS_BOOL)(IsDeviceInDiscoverableMode == 1);
  case 32:
    return (VS_BOOL)(IsAppActivatedInternally == 1);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == 3 && sm_variant_intercom == 1 && sm_variant_kitchen == 1 && fnGetVariantType() != Enum_VARIANT_TYPE_CABIN_ONLY);
  case 34:
    return (VS_BOOL)(Sm_ActiveSource == 0);
  case 35:
    return (VS_BOOL)(Sm_ActiveSource == 1);
  case 36:
    return (VS_BOOL)(IsIntercomCallActive == 1);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == 3 && sm_variant_kitchen == 1 && sm_variant_intercom == 1 && fnGetVariantType() != Enum_VARIANT_TYPE_CABIN_ONLY);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == 3 && sm_variant_intercom == 0 && sm_variant_kitchen == 0);
  case 39:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == 27 && sm_variant_kitchen == 1 && sm_variant_intercom == 1);
  case 40:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == 3 && fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY);
  case 41:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == 3 && sm_variant_intercom == 0 && sm_variant_kitchen == 0);
  case 42:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == 27 && sm_variant_kitchen == 1 && sm_variant_intercom == 1);
  case 43:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == 3 && fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY);
  case 44:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
  case 45:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
  case 46:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
  case 47:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
  case 48:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
  case 49:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
  case 50:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
  case 51:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
  case 52:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
  case 53:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
  case 54:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
  case 55:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
  case 56:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
  case 57:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
  case 58:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
  case 59:
    return (VS_BOOL)(VSDBVar.DB6.VS_INTVar[0] != 1);
  case 60:
    return (VS_BOOL)(VSDBVar.DB27.VS_BOOLVar[0] != 1);
  case 61:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
  case 62:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
  case 63:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
  case 64:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
  case 65:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
  case 66:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
  case 67:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
  case 68:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
  case 69:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
  case 70:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
  case 71:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
  case 72:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
  case 73:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
  case 74:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
  case 75:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
  case 76:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
  case 77:
    return (VS_BOOL)(IsSMSContactActive == 1);
  case 78:
    return (VS_BOOL)(VSDBVar.DB180.VS_BOOLVar[0] == 0);
  case 79:
    return (VS_BOOL)(VSDBVar.DB180.VS_BOOLVar[0] == 1);
  case 80:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
  case 81:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
  case 82:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
  case 83:
    return (VS_BOOL)(EventArgsVar.DB275.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
  case 84:
    return (VS_BOOL)(EventArgsVar.DB276.VS_UINT32Var[0] == AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
  case 85:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
  case 86:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
  case 87:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
  case 88:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
  case 89:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
  case 90:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
  case 91:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
  case 92:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
  case 93:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
  case 94:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
  case 95:
    return (VS_BOOL)(EventArgsVar.DB292.VS_UINT32Var[0] == AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
  case 96:
    return (VS_BOOL)(CallStatus != 9);
  case 97:
    return (VS_BOOL)(CallStatus != 1);
  case 98:
    return (VS_BOOL)(CallStatus != 3);
  case 99:
    return (VS_BOOL)(CallStatus != 2);
  case 100:
    return (VS_BOOL)(CallStatus != 4);
  case 101:
    return (VS_BOOL)(CallStatus != 7);
  case 102:
    return (VS_BOOL)(CallStatus != 5);
  case 103:
    return (VS_BOOL)(CallStatus != 6);
  case 104:
    return (VS_BOOL)(CallStatus != 8);
  case 105:
    return (VS_BOOL)(VSDBVar.DB226.VS_INT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection && CallStatus == 0 && DeviceTypeConnected == 1 || CallStatus == 0 && DeviceTypeConnected != 1);
  case 106:
    return (VS_BOOL)(VSDBVar.DB226.VS_INT32Var[0] != AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 107:
    return (VS_BOOL)(CallStatus == 1 || CallStatus == 2);
  case 108:
    return (VS_BOOL)(CallStatus >= 4 && CallStatus <= 8);
  case 109:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call && PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
  case 110:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_MultipleCall && PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
  case 111:
    return (VS_BOOL)(PreviousActiveStateForOPT != AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
  case 112:
    return (VS_BOOL)(IsDeviceConnected == 1);
  case 113:
    return (VS_BOOL)(PreviousActiveStateForCallAction == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection && VSDBVar.DB194.VS_INTVar[0] != 1);
  case 114:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 1 && g_SM_CPWhileBTConn == 0);
  case 115:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 1 && g_SM_CPWhileBTConn == 1);
  case 116:
    return (VS_BOOL)(VSDBVar.DB158.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_CallList);
  case 117:
    return (VS_BOOL)(IntercomCallScreenInfo == 1 || IntercomCallScreenInfo == 5 || IntercomCallScreenInfo == 0);
  case 118:
    return (VS_BOOL)(VSDBVar.DB158.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_Contacts);
  case 119:
    return (VS_BOOL)(VSDBVar.DB158.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_DialPad);
  case 120:
    return (VS_BOOL)(VSDBVar.DB158.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 121:
    return (VS_BOOL)(VSDBVar.DB158.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_I_Contacts);
  case 122:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] > 1 && VSDBVar.DB194.VS_INTVar[0] < 5);
  case 123:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 2);
  case 124:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 4);
  case 125:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 3);
  case 126:
    return (VS_BOOL)(0 < CallStatus && CallStatus < 9);
  case 127:
    return (VS_BOOL)(IntercomCallScreenInfo == 2 || IntercomCallScreenInfo == 4 || IntercomCallScreenInfo == 3);
  case 128:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection);
  case 129:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_DialPad);
  case 130:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_Contacts);
  case 131:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_CallList);
  case 132:
    return (VS_BOOL)(VSDBVar.DB72.VS_UINT32Var[0] == AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
  case 133:
    return (VS_BOOL)(IsParingActive != 1);
  case 134:
    return (VS_BOOL)(DeviceTypeConnected == 0);
  case 135:
    return (VS_BOOL)(RequestEntryState == Enum_EntryRequest_ToPhoneSelection);
  case 136:
    return (VS_BOOL)(RequestEntryState == Enum_EntryRequest_ToCallList);
  case 137:
    return (VS_BOOL)(IsDialed != 1);
  case 138:
    return (VS_BOOL)(WasCallListLoadingActive != 1);
  case 139:
    return (VS_BOOL)(WasCallListLoadingActive == 1);
  case 140:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] != 1);
  case 141:
    return (VS_BOOL)(IsContactListPersistent == 0);
  case 142:
    return (VS_BOOL)(VSDBVar.DB194.VS_INTVar[0] == 1);
  case 143:
    return (VS_BOOL)(IsContactListPersistent == 1);
  case 144:
    return (VS_BOOL)(ContactsCallListNotPersistant != 1);
  }
  return (VS_BOOL)(ContactsCallListNotPersistant == 1);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_PhoneStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Activate_BT_SR_Session();
    break;
  case 1:
    BTVROnExitAction();
    break;
  case 2:
    DeActivate_BT_SR_Session();
    break;
  case 3:
    Halt_BT_SR_Session();
    break;
  case 4:
    Language_Update();
    break;
  case 5:
    Perform_Activate_BTPhone_Application_Call_Connecting();
    break;
  case 6:
    Perform_Activate_BTPhone_Application_Call_List();
    break;
  case 9:
    Perform_Activate_BTPhone_Application_On_Call();
    break;
  case 10:
    Perform_Activate_BTPhone_Application_On_Intercomcall();
    break;
  case 11:
    Perform_Activate_BTPhone_Application_On_Multiparty_Call();
    break;
  case 13:
    Perform_Activate_Listen();
    break;
  case 14:
    Perform_Activate_Media_Application();
    break;
  case 15:
    Perform_Activate_Media_Source_Selection();
    break;
  case 16:
    Perform_Activate_Navi_Application();
    break;
  case 17:
    Perform_Activate_Radio_Application();
    break;
  case 18:
    Perform_Activate_SPI_Application();
    break;
  case 19:
    Perform_AppHmi_PhoneModule_AcceptCall();
    break;
  case 20:
    Perform_AppHmi_PhoneModule_AddNewDevice();
    break;
  case 21:
    Perform_AppHmi_PhoneModule_BackButtonPressReq();
    break;
  case 22:
    Perform_AppHmi_PhoneModule_CallListReq();
    break;
  case 23:
    Perform_AppHmi_PhoneModule_CancelDialing();
    break;
  case 24:
    Perform_AppHmi_PhoneModule_ChangeRingtoneSettingsReq();
    break;
  case 25:
    Perform_AppHmi_PhoneModule_ChangeSMSSettingsReq();
    break;
  case 26:
    Perform_AppHmi_PhoneModule_Clear_EditFieldReq();
    break;
  case 27:
    Perform_AppHmi_PhoneModule_ContactDetailsListEntryReq();
    break;
  case 28:
    Perform_AppHmi_PhoneModule_ContactListReq_Begining();
    break;
  case 29:
    Perform_AppHmi_PhoneModule_ContactListReq_History();
    break;
  case 30:
    Perform_AppHmi_PhoneModule_DeleteDeviceConfirmationReq();
    break;
  case 31:
    Perform_AppHmi_PhoneModule_DeviceListReq();
    break;
  case 32:
    Perform_AppHmi_PhoneModule_DialCall_Model();
    break;
  case 33:
    Perform_AppHmi_PhoneModule_DisconnectDeviceConfirmationReq();
    break;
  case 34:
    Perform_AppHmi_PhoneModule_Handsfree_Status_ChangeReq();
    break;
  case 35:
    Perform_AppHmi_PhoneModule_HangUpCall();
    break;
  case 36:
    Perform_AppHmi_PhoneModule_IContactsReq();
    break;
  case 37:
    Perform_AppHmi_PhoneModule_IntercomGadgetUpdate();
    break;
  case 38:
    Perform_AppHmi_PhoneModule_IntercomStatusMsg();
    break;
  case 40:
    Perform_AppHmi_PhoneModule_MessageCall();
    break;
  case 41:
    Perform_AppHmi_PhoneModule_MicMute_Status_ChangeReq();
    break;
  case 42:
    Perform_AppHmi_PhoneModule_Pairing_Cancel();
    break;
  case 43:
    Perform_AppHmi_PhoneModule_Pairing_No();
    break;
  case 44:
    Perform_AppHmi_PhoneModule_Pairing_Yes();
    break;
  case 45:
    Perform_AppHmi_PhoneModule_PlayReadMessageAloudReq();
    break;
  case 46:
    Perform_AppHmi_PhoneModule_PrivateMode();
    break;
  case 47:
    Perform_AppHmi_PhoneModule_RejectCall();
    break;
  case 48:
    Perform_AppHmi_PhoneModule_ResetCallListDataReq();
    break;
  case 50:
    Perform_AppHmi_PhoneModule_Ringtone_Mute();
    break;
  case 51:
    Perform_AppHmi_PhoneModule_StopReadMessageAloudReq();
    break;
  case 52:
    Perform_AppHmi_PhoneModule_SwapMultipleCallReq();
    break;
  case 53:
    Perform_Deactivate_BTPhone_Application();
    break;
  case 54:
    Perform_IConference_RejectCall();
    break;
  case 55:
    Perform_Intercom_AcceptCall();
    break;
  case 56:
    Perform_Intercom_RejectCall();
    break;
  case 58:
    Perform_Network_Operator_Req();
    break;
  case 59:
    Phone_ActivityId();
    break;
  case 77:
    RequestEntryState = Enum_EntryRequest_AppInBackground;
    break;
  case 78:
    IsAcceptRequested = 0;
    break;
  case 79:
    IsRejectRequested = 0;
    break;
  case 80:
    CallStatus = 9;
    break;
  case 81:
    IsAcceptRequested = 1;
    break;
  case 82:
    IsRejectRequested = 1;
    break;
  case 83:
    IsParingActive = 0;
    break;
  case 84:
    IsDeviceInDiscoverableMode = 0;
    break;
  case 85:
    IsDeviceListOperationProgress = 0;
    break;
  case 86:
    IsDialed = 0;
    break;
  case 87:
    IsDTMFActive = 0;
    break;
  case 88:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call;
    break;
  case 89:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting;
    break;
  case 90:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_MultipleCall;
    break;
  case 91:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 92:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 93:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 94:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 95:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_PhoneSelection;
    break;
  case 96:
    ListViewID = 0;
    break;
  case 97:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_OPT;
    break;
  case 98:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 99:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 100:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 101:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 102:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 103:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_DialPad;
    break;
  case 104:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 105:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 106:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 107:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_CallList_Loading;
    break;
  case 108:
    WasCallListLoadingActive = 0;
    break;
  case 109:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 110:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 111:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 112:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 113:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 114:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_CallList;
    break;
  case 115:
    ListViewID = 2;
    break;
  case 116:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 117:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 118:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 119:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 120:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 121:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts;
    break;
  case 122:
    ListViewID = 3;
    break;
  case 123:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 124:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 125:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 126:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Loading;
    break;
  case 127:
    WasContactListLoadingActive = 1;
    break;
  case 128:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 129:
    PreviousActiveStateForPhoneSelection = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 130:
    PreviousActiveStateForCallAction = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 131:
    PreviousActiveStateForOPT = AppHmi_PhoneModule_PhoneScenes_P_Contacts_Call;
    break;
  case 132:
    ListViewID = 4;
    break;
  case 133:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting;
    break;
  case 134:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad;
    break;
  case 135:
    IsDTMFActive = 1;
    break;
  case 136:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad;
    break;
  case 137:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main;
    break;
  case 138:
    PreviousScreenEntryBTVR = AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS;
    break;
  case 139:
    PreviousScreenEntry = AppHmi_PhoneModule_PhoneScenes_I_Contacts;
    break;
  case 140:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_I_Contacts;
    break;
  case 141:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting;
    break;
  case 142:
    IntercomCallScreenInfo = 2;
    break;
  case 143:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_IntercomCall;
    break;
  case 144:
    IntercomCallScreenInfo = 3;
    break;
  case 145:
    CurrentView = AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall;
    break;
  case 146:
    IntercomCallScreenInfo = 4;
    break;
  case 147:
    PhoneBookDownloadStatus = 0;
    break;
  case 148:
    CallListDownloadStatus = 0;
    break;
  case 149:
    IsDeviceReseted = 1;
    break;
  case 150:
    IsSMSActive = 1;
    break;
  case 151:
    PhoneBookDownloadStatus = 2;
    break;
  case 152:
    PhoneBookDownloadStatus = 1;
    break;
  case 153:
    CallListDownloadStatus = 2;
    break;
  case 154:
    CallListDownloadStatus = 1;
    break;
  case 155:
    CallStatus = 0;
    break;
  case 156:
    IsHomeScreenActive = 0;
    break;
  case 157:
    IsHomeScreenActive = 1;
    break;
  case 158:
    IsDeviceConnectingActive = 0;
    break;
  case 159:
    IsAppActivatedInternally = 0;
    break;
  case 160:
    RequestEntryState = Enum_EntryRequest_ToPhoneSelection;
    break;
  case 161:
    RequestEntryState = Enum_EntryRequest_ToCallList;
    break;
  case 162:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE;
    break;
  case 163:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart;
    break;
  case 164:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI;
    break;
  case 165:
    CurrentView = AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN;
    break;
  case 166:
    IsReadAloudActive = 1;
    break;
  case 167:
    IsContactListPersistent = 0;
    break;
  case 168:
    CurrentView = 0;
    break;
  case 169:
    PreviousCallStaus = CallStatus;
    break;
  case 170:
    CallStatus = 7;
    break;
  case 171:
    CallStatus = 5;
    break;
  case 172:
    CallStatus = 6;
    break;
  case 173:
    CallStatus = 8;
    break;
  case 174:
    CallStatus = 3;
    break;
  case 175:
    CallStatus = 1;
    break;
  case 176:
    CallStatus = 2;
    break;
  case 177:
    CallStatus = 4;
    break;
  case 178:
    IsAppActivatedInternally = 1;
    break;
  case 179:
    IntercomCallScreenInfo = 0;
    break;
  case 180:
    IsDeviceInDiscoverableMode = 1;
    break;
  case 181:
    IsParingActive = 1;
    break;
  case 182:
    IsDeviceReseted = 0;
    break;
  case 183:
    IsDialed = 1;
    break;
  case 184:
    ContactsCallListNotPersistant = 1;
    break;
  case 185:
    WasContactListLoadingActive = 0;
    break;
  case 186:
    IsContactsBackSelected = 0;
    break;
  case 187:
    ContactsCallListNotPersistant = 0;
    break;
  case 188:
    gacViewHideReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 189:
    gacViewDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 190:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 191:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN);
    break;
  case 192:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 193:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 194:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 195:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 196:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 197:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 198:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 199:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 200:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 201:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 202:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 203:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 204:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 205:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 206:
    gacViewDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 207:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 208:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 209:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 210:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 211:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 212:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 213:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 214:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 215:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 216:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 217:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 218:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 219:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 220:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 221:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 222:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 223:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 224:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 225:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 226:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 227:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 228:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 229:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 230:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 231:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 232:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 233:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 234:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 235:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 236:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 237:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 238:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 239:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 240:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 241:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 242:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 243:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 244:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 245:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 246:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 247:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 248:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 249:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 250:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 251:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 252:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 253:
    gacViewHideReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 254:
    gacViewClearReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 255:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 256:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 257:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 258:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 259:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 260:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairing);
    break;
  case 261:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 262:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 263:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 264:
    gacViewHideReq(CurrentView);
    break;
  case 265:
    gacViewDestroyReq(CurrentView);
    break;
  case 266:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 267:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 268:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 269:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 270:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 271:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 272:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 273:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 274:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 275:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 276:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 277:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 278:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 279:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 280:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
    break;
  case 281:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 282:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 283:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 284:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 285:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 286:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 287:
    gacViewHideReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 288:
    gacViewDestroyReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 289:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 290:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call);
    break;
  case 291:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 292:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Connecting);
    break;
  case 293:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 294:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall);
    break;
  case 295:
    gacViewCreateReq(CurrentView);
    break;
  case 296:
    gacViewShowReq(CurrentView);
    break;
  case 297:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 298:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_Disconnecting);
    break;
  case 299:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 300:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Call_DialPad);
    break;
  case 301:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 302:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_MultipleCall_DialPad);
    break;
  case 303:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 304:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_SR_SIRI_Main);
    break;
  case 305:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_PhoneScenes_P_OPT_SETTINGS);
    break;
  case 306:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 307:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_I_Contacts);
    break;
  case 308:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 309:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_I_Call_Connecting);
    break;
  case 310:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 311:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_IntercomCall);
    break;
  case 312:
    gacViewCreateReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 313:
    gacViewShowReq(AppHmi_PhoneModule_PhoneScenes_P_Intercom_ConferenceCall);
    break;
  case 314:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 315:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 316:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 317:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 318:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 319:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 320:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 321:
    ActivatePhoneGadgetResponse(0);
    break;
  case 322:
    ActivatePhoneGadgetResponse(1);
    break;
  case 323:
    ActivatePhoneGadgetResponse(2);
    break;
  case 324:
    ActivatePhoneGadgetResponse(10);
    break;
  case 325:
    ActivatePhoneGadgetResponse(11);
    break;
  case 326:
    gacViewCreateReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 327:
    gacViewShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE);
    break;
  case 328:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart);
    break;
  case 329:
    gacViewCreateReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 330:
    gacViewShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 331:
    gacViewCreateReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN);
    break;
  case 332:
    gacViewShowReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN);
    break;
  case 333:
    gacViewHideAndDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_Smart);
    break;
  case 334:
    gacViewHideReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 335:
    gacViewDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_NON_NAVI);
    break;
  case 336:
    gacViewHideReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN);
    break;
  case 337:
    gacViewDestroyReq(AppHmi_PhoneModule_Gadget_Phone_MASTER__GADGET_PHONE_CABIN);
    break;
  case 338:
    ActivatePhoneGadgetResponse(14);
    break;
  case 339:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 340:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 341:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 342:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 343:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_BT);
    break;
  case 344:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 345:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 346:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 347:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 348:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PriorityCall_Intercom);
    break;
  case 349:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 350:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 351:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 352:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_PhoneCall);
    break;
  case 353:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 354:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 355:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 356:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_IntercomCall);
    break;
  case 357:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 358:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 359:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 360:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_MIC_CallHistory_Contacts);
    break;
  case 361:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 362:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 363:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_RTP_stream_failure);
    break;
  case 364:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 365:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 366:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 367:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 368:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 369:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 370:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 371:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 372:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 373:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 374:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 375:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 376:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 377:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 378:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 379:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 380:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 381:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 382:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 383:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 384:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 385:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 386:
    gacViewHideReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 387:
    gacViewClearReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 388:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_Intercom_IncomingCall);
    break;
  case 389:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 390:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PassiveDeviceIncomingCall);
    break;
  case 391:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 392:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_SR_SIRI_Main);
    break;
  case 393:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 394:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_ConnectionFailed);
    break;
  case 395:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 396:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLFailed);
    break;
  case 397:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 398:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 399:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_PhonebookDLIncomplete);
    break;
  case 400:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 401:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SIRI_EyeFree);
    break;
  case 402:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceConnected);
    break;
  case 403:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_DeviceDisConnected);
    break;
  case 404:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 405:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 406:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 407:
    gacPopupSBCloseReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 408:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMSExpand);
    break;
  case 409:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 410:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_SMS);
    break;
  case 411:
    acPostBeep(Enum_hmibase_BEEPTYPE_SMS_INCOMING);
    break;
  case 412:
    gacViewCreateReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 413:
    gacViewShowReq(AppHmi_PhoneModule_Sys_Popup_Pfo_IncomingCall);
    break;
  case 414:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceConnecting);
    break;
  case 415:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 416:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 417:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 418:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleting);
    break;
  case 419:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 420:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 421:
    gacViewDestroyReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 422:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 423:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;
  case 424:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_WaitForConfirmation);
    break;
  case 425:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_NumCompPairing);
    break;
  case 426:
    gacViewCreateAndShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 427:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_JustWorksPairingWaiting);
    break;
  case 428:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 429:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceListFull);
    break;
  case 430:
    gacPopupSBCloseReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 431:
    gacViewShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 432:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeleteDeviceConfirmation);
    break;
  case 433:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDisconnectConfirmation);
    break;
  case 434:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_DeviceDeleted);
    break;
  case 435:
    gacPopupCreateAndSBShowReq(AppHmi_PhoneModule_App_Popup_Pfo_PairingInitiate);
    break;

  default:
    break;
  }
}
