/************************************************************************
*FILE: AppHmi_PhoneDatabinding.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_PhoneDatabinding_h)
#define AppHmi_PhoneDatabinding_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <AppHmi_PhoneTypes.h>
#include <AppHmi_PhoneConstants.h>
#include <ProjectBaseDataBinding.h>
#include <CanderaWidget/String/String.h>
#include <Candera/Engine2D/Core/Image2D.h>

// =========================================================================
struct ListId_FlexData {
    Candera::UInt32 mPairedDeviceListId;
    Candera::UInt32 mPhoneContactListId;
    Candera::UInt32 mMatchListId;
    Candera::UInt32 mContactCallListId;
    Candera::UInt32 mCallListId;
    Candera::UInt32 mSettingListId;
    Candera::UInt32 mDropDownListId;
    Candera::UInt32 mIntercomContactsListId;
    Candera::UInt32 mIntercomConfCallListId;
    Candera::UInt32 mIntercomGadgetListId;

    ListId_FlexData();
};

// =========================================================================
struct ListDataSizeData {
    Candera::UInt16 mPairedDeviceListSize;
    Candera::UInt16 mContactListSize;
    Candera::UInt16 mMatchListSize;
    Candera::UInt16 mContactCallListSize;
    Candera::UInt16 mCallListSize;
    Candera::UInt16 mSortOrderSize;
    Candera::UInt16 mIContactsSize;
    Candera::UInt16 mIConfCallSize;
    Candera::UInt16 mIGadgetListSize;

    ListDataSizeData();
};

// =========================================================================
struct PairedDevice_ListItemData {
    Candera::UInt16 mDeviceTypeIndex;
    Candera::String mDeviceName;
    bool mProfilePhone;
    bool mProfileAudio;
    bool mBTIcon;
    Candera::Color mDeviceNameTxtColor;

    PairedDevice_ListItemData();
};

// =========================================================================
struct CallList_ListItemData {
    Candera::UInt8 mCallInfoIcon;
    Candera::String mCallerName;
    Candera::String mCallNumberOfTimes;
    Candera::String mCallDate;
    Candera::UInt8 mCallListFocusIndex;
};

// =========================================================================
struct ContactList_ListItemData {
    Candera::String mContactName;
    Candera::String mPhoneNumberCount;
    Candera::UInt8 mContactsFocusIndex;
};

// =========================================================================
struct MatchList_ListItemData {
    Candera::String mMatchedNumber;
    Candera::String mMatchedContactName;
};

// =========================================================================
struct IContactsList_ListItemData {
    Candera::String mIContactName;
    Candera::UInt8 mIContacttype;
    Candera::String mICallStatus;
};

// =========================================================================
struct Intercom_SupportStatusData {
    bool mIntercom_Supported;
    bool mIntercom_NotSupported;

    Intercom_SupportStatusData();
};

// =========================================================================
struct IGadgetContactList_ListItemData {
    bool mIGadgetRestCabinActive;
    bool mIGadgetRestCabinEnable;
    bool mIGadgetRestCabinVisible;
    Candera::Vector2 mIGadgetRestCabinSize;
    bool mIGadgetKitchenActive;
    bool mIGadgetKitchenEnable;
    bool mIGadgetKitchenVisible;
    Candera::Vector2 mIGadgetKitchenSize;
    bool mIGadgetUpperDeckActive;
    bool mIGadgetUpperDeckEnable;
    bool mIGadgetUpperDeckVisible;
    Candera::Vector2 mIGadgetUpperDeckSize;

    IGadgetContactList_ListItemData();
};

// =========================================================================
struct ContactCall_ListItemData {
    Candera::UInt8 mContactInfoIcon;
    Candera::String mContactPhoneNumber;
    bool mPrimaryIcon;
};

// =========================================================================
struct ViewPortStartIndexData {
    Candera::UInt16 mContactListIndex;

    ViewPortStartIndexData();
};

// =========================================================================
struct ConnectedActiveBTDeviceNameData {
    Candera::String mDeviceName;
};

// =========================================================================
struct ConnectedBTDeviceNameData {
    Candera::String mDeviceName;
};

// =========================================================================
struct DisconnectedBTDeviceNameData {
    Candera::String mDeviceName;
};

// =========================================================================
struct VarientTypeData {
    Candera::UInt8 mSwitcherIndex;
    bool mEnableNavi;

    VarientTypeData();
};

// =========================================================================
struct SPIStatusData {
    bool mEnableSPI;

    SPIStatusData();
};

// =========================================================================
struct IsListNotemptyData {
    bool mCallList;
    bool mContactList;

    IsListNotemptyData();
};

// =========================================================================
struct ContactCallNameData {
    Candera::String mCallerName;
};

// =========================================================================
struct FriendlyVehicleNameData {
    Candera::String mHUDName;
};

// =========================================================================
struct PairingDeviceInfoData {
    Candera::String mDeviceName;
    Candera::String mPairingPIN;
};

// =========================================================================
struct DeviceInfoData {
    Candera::String mDeviceName;
};

// =========================================================================
struct MatchedItemsData {
    Candera::String mCount;
};

// =========================================================================
struct PhoneButtonTextData {
    Candera::String mSource;
};

// =========================================================================
struct MicEnableData {
    Candera::UInt8 mIsSelected;
    bool mEnabled;

    MicEnableData();
};

// =========================================================================
struct VehicleAudioStatusData {
    Candera::UInt8 mIsSelected;

    VehicleAudioStatusData();
};

// =========================================================================
struct PrivateModeStatusData {
    Candera::UInt8 mIsSelected;
    Candera::UInt8 mPrivateModeIndex;

    PrivateModeStatusData();
};

// =========================================================================
struct SettingsData {
    Candera::UInt8 mUsePhoneRingtone_IsSelected;
    Candera::UInt8 mShowIncomingText_IsSelected;
    Candera::String mSortPhoneBookTypeText;
    Candera::UInt8 mSelectedLine;
    bool mIsInBandSupported;
    bool mEnableDisableSortOrder;

    SettingsData();
};

// =========================================================================
struct CallProgressData {
    Candera::String mCallDuration;
    Candera::String mCallerID;
    Candera::String mContactType;
    Candera::String mCallStatus;
    Candera::String mGadgetCallerID;
};

// =========================================================================
struct IntercomIncomingCallData {
    Candera::String mCallerID;
    Candera::UInt16 mContactType;
};

// =========================================================================
struct IntercomMissedIncomingCallData {
    Candera::String mMissedCallerInfo;
};

// =========================================================================
struct IntercomCallProgressData {
    Candera::String mCallerID;
    Candera::UInt16 mContactType;
};

// =========================================================================
struct IntercomConfCallData {
    Candera::String mCallerID;
    Candera::UInt16 mContactType;
    Candera::String mCallStatus;
};

// =========================================================================
struct PhoneStatusData {
    Candera::UInt16 mBatteryStatus;
    Candera::UInt16 mSignalStatus;
    bool mNetworkStatus;
    Candera::UInt32 mMissedCallStatus;
    Candera::UInt16 mSignalStatusinGadget;
    Candera::UInt16 mBatteryStatusinGadget;
};

// =========================================================================
struct ValidCharSetData {
    Candera::String mCharacterSet;
};

// =========================================================================
struct SuggesstionTextData {
    Candera::String mText;
};

// =========================================================================
struct EntryTextData {
    Candera::String mText;
};

// =========================================================================
struct PhoneDialPadInputTextData {
    Candera::String mText;
};

// =========================================================================
struct BTTelltalesData {
    Candera::UInt16 mImagePath;
    bool mLoadAssetBitmap;
};

// =========================================================================
struct RoamingData {
    bool mEnabled;
};

// =========================================================================
struct DialButtonData {
    bool mEnabled;
};

// =========================================================================
struct MatchListData {
    bool mEnabled;
};

// =========================================================================
struct DialPadButtonData {
    bool mEnabled;
};

// =========================================================================
struct IsActiveData {
    bool mIsAddPhoneDisabled;
};

// =========================================================================
struct IsVisibleCabinonlyIconData {
    bool mIsCabinonlyIcon;

    IsVisibleCabinonlyIconData();
};

// =========================================================================
struct IsTouchableCabinonlyIconData {
    bool mIsIconTouchable;

    IsTouchableCabinonlyIconData();
};

// =========================================================================
struct PhoneGadgetInfoData {
    Candera::UInt8 mPhoneHandle;
    Candera::UInt8 mPhoneSignalStatus;
    Candera::UInt8 mPhoneBatteryStatus;
    Candera::UInt8 mIndexForGadgetBG;
    Candera::UInt8 mIndexForGadgetContent;
    Candera::UInt8 mIndexForIntercomTextInfo;
};

// =========================================================================
struct MsgProgressData {
    Candera::String mCallerID;
    Candera::String mTimeHour;
    Candera::String mSubject;
    Candera::String mShortMessage;
    bool mValidContact;
    bool mPlayBackAction;
    bool mIsEnableReadOutAloud;
};

// =========================================================================
struct MultipleCallProgressData {
    Candera::String mActiveCallerID;
    Candera::String mOnHoldCallerID;
    Candera::String mActiveCallDuration;
    Candera::String mOnHoldCallDuration;
    Candera::String mActiveCallStatus;
    Candera::String mOnHoldCallerStatus;
    Candera::String mActiveContactType;
    Candera::String mOnHoldContactType;
    Candera::String mCallType;
    bool mIsEnableDialPad;
    bool mIsEnableSwap;
};

// =========================================================================
struct IncomingCallData {
    Candera::String mCallerID;
    Candera::String mContactType;
    Candera::String mCount;
    Candera::String mDeviceName;
};

// =========================================================================
struct NetworkOperatorData {
    Candera::String mOperatorName;
    Candera::Vector2 mTextNodeMaxSize;
};

// =========================================================================
struct BTVRDeviceNameData {
    Candera::String mDeviceName;
};

// =========================================================================
struct BTVRIconSRStatusData {
    Candera::String mIconSRStatus;
};

// =========================================================================
struct BTVRIconSRStatusIndexData {
    Candera::UInt8 mIconSRStatusIndex;

    BTVRIconSRStatusIndexData();
};

// =========================================================================
struct QuickScrollSearchData {
    Candera::UInt8 mScrollVisible;
    Candera::String mScrollSearchChar;
};

// =========================================================================
struct LoadingAnimationInfoData {
    Candera::String mChannel1_Phonebook;
    Candera::String mChannel1_Calllist;
    Candera::String mChannel2_Phonebook;
    Candera::String mChannel2_Calllist;
};

// =========================================================================
struct AndroidAutoSessionInfoData {
    bool mSessionStatus;
    Candera::UInt8 mSessionStatusIndex;

    AndroidAutoSessionInfoData();
};

// =========================================================================
struct BTONOFFData {
    bool mBTONOFFStatus;
};

// =========================================================================
struct IntercomenableData {
    bool mIntercomenable;
};

// =========================================================================
struct IntercomTileEnableData {
    bool mIntercomTileEnableStatus;
};

// =========================================================================
struct IntercomGadgetInfoData {
    Candera::UInt8 mIndexForGadgetBG;
};

// =========================================================================
struct IntercomStatusCCData {
    Candera::UInt8 mIntercomAvailablestatus;
};

// =========================================================================
struct AddCallEnableData {
    bool mAddCallEnable;
};

// =========================================================================
struct SpeedLockData {
    bool mSpeedLockStatus;
    bool mDialPadCallButtonStatus;

    SpeedLockData();
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
template<> ::FeatStd::UInt32 StringBufferAppender< ::ListId_FlexData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListId_FlexData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ListDataSizeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListDataSizeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PairedDevice_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PairedDevice_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CallList_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CallList_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ContactList_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ContactList_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MatchList_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MatchList_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IContactsList_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IContactsList_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::Intercom_SupportStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::Intercom_SupportStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IGadgetContactList_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IGadgetContactList_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ContactCall_ListItemData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ContactCall_ListItemData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ViewPortStartIndexData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ViewPortStartIndexData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ConnectedActiveBTDeviceNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ConnectedActiveBTDeviceNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ConnectedBTDeviceNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ConnectedBTDeviceNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DisconnectedBTDeviceNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DisconnectedBTDeviceNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VarientTypeData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VarientTypeData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SPIStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SPIStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IsListNotemptyData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IsListNotemptyData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ContactCallNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ContactCallNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::FriendlyVehicleNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::FriendlyVehicleNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PairingDeviceInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PairingDeviceInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DeviceInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DeviceInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MatchedItemsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MatchedItemsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PhoneButtonTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PhoneButtonTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MicEnableData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MicEnableData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::VehicleAudioStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::VehicleAudioStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PrivateModeStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PrivateModeStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SettingsData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SettingsData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::CallProgressData >::Append(::FeatStd::StringBuffer& stringBuffer, ::CallProgressData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomIncomingCallData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomIncomingCallData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomMissedIncomingCallData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomMissedIncomingCallData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomCallProgressData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomCallProgressData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomConfCallData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomConfCallData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PhoneStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PhoneStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::ValidCharSetData >::Append(::FeatStd::StringBuffer& stringBuffer, ::ValidCharSetData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SuggesstionTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SuggesstionTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::EntryTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::EntryTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PhoneDialPadInputTextData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PhoneDialPadInputTextData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTTelltalesData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTTelltalesData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::RoamingData >::Append(::FeatStd::StringBuffer& stringBuffer, ::RoamingData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DialButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DialButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MatchListData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MatchListData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::DialPadButtonData >::Append(::FeatStd::StringBuffer& stringBuffer, ::DialPadButtonData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IsActiveData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IsActiveData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IsVisibleCabinonlyIconData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IsVisibleCabinonlyIconData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IsTouchableCabinonlyIconData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IsTouchableCabinonlyIconData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::PhoneGadgetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::PhoneGadgetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MsgProgressData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MsgProgressData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::MultipleCallProgressData >::Append(::FeatStd::StringBuffer& stringBuffer, ::MultipleCallProgressData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IncomingCallData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IncomingCallData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::NetworkOperatorData >::Append(::FeatStd::StringBuffer& stringBuffer, ::NetworkOperatorData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTVRDeviceNameData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTVRDeviceNameData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTVRIconSRStatusData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTVRIconSRStatusData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTVRIconSRStatusIndexData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTVRIconSRStatusIndexData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::QuickScrollSearchData >::Append(::FeatStd::StringBuffer& stringBuffer, ::QuickScrollSearchData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::LoadingAnimationInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::LoadingAnimationInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AndroidAutoSessionInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AndroidAutoSessionInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::BTONOFFData >::Append(::FeatStd::StringBuffer& stringBuffer, ::BTONOFFData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomenableData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomenableData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomTileEnableData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomTileEnableData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomGadgetInfoData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomGadgetInfoData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::IntercomStatusCCData >::Append(::FeatStd::StringBuffer& stringBuffer, ::IntercomStatusCCData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::AddCallEnableData >::Append(::FeatStd::StringBuffer& stringBuffer, ::AddCallEnableData const & object);
template<> ::FeatStd::UInt32 StringBufferAppender< ::SpeedLockData >::Append(::FeatStd::StringBuffer& stringBuffer, ::SpeedLockData const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_PhoneDatabinding_h
