/************************************************************************
*FILE: AppHmi_NavigationStateMachine.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_NavigationStateMachine_h)
#define AppHmi_NavigationStateMachine_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <AppHmi_NavigationStateMachineSEMLibB.h>
#include <AppHmi_NavigationStateMachineData.h>
#if !defined COURIER_DISABLED
#include <Courier/DataBinding/DataBinding.h>
#endif
#include <Cit/VisualStateGlueLayer/DeductResult.h>
#ifdef CIT_SIMULATION
#include <json/value.h>
#endif
#include <AppHmi_NavigationTypes.h>
#include <AppHmi_NavigationMessages.h>
#include <AppHmi_NavigationConstants.h>
#include <AppHmi_NavigationDatabinding.h>
#include <AppHmi_NavigationViews.h>
#include <AppHmi_NavigationController.h>
// ------------------------------------------------------------------------
class AppHmi_NavigationStateMachineImpl : public AppHmi_NavigationStateMachine
{
public:
    typedef AppHmi_NavigationStateMachine Base;

#ifdef VISUALSTATE_7_TRACE
    // Mapping of data types of API to get rid of include dependencies
    //typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
	using Base::VS_Type_ActionExpression;
    //typedef SEM_EVENT_TYPE VS_Type_Event;
	//typedef SEM_STATE_TYPE VS_Type_State;
	//typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
	//typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
	using Base::VS_Type_Event;
	using Base::VS_Type_State;
	using Base::VS_Type_Explanation;
	using Base::VS_Type_Statemachine;

    // Mapping of enums and defines of API to get rid of include dependencies
    //enum { VS_Ret_Ok = SES_OKAY };
    //enum { VS_Ret_Found = SES_FOUND };
	enum { VS_Ret_Ok = Base::VS_Ret_Ok };
	enum { VS_Ret_Found = Base::VS_Ret_Found };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
#ifndef VISUALSTATE_HCODER
    typedef SEM_ACTION_EXPRESSION_TYPE VS_Type_ActionExpression;
    typedef SEM_EVENT_TYPE VS_Type_Event;
    typedef SEM_STATE_TYPE VS_Type_State;
    typedef SEM_EXPLANATION_TYPE VS_Type_Explanation;
    typedef SEM_STATE_MACHINE_TYPE VS_Type_Statemachine;
    enum { VS_Ret_Ok = SES_OKAY };
    enum { VS_Ret_Found = SES_FOUND };
    enum { VS_Evt_Reset = SE_RESET };
    enum { VS_Ret_Error = SES_RANGE_ERR };
#else
    enum { VS_Ret_Ok = 0U };
    enum { VS_Ret_Found = 1U };
    enum { VS_Evt_Reset = 0U };
    enum { VS_Ret_Error = 4U };
#endif
#endif
// ------------------------------------------------------------------------

    // Mapping of args passed as hashId to corresponding identifier
    static const ::FeatStd::Char *GetNameFromId(::FeatStd::UInt32 id);

// ------------------------------------------------------------------------
    virtual void Notify_Init_Finished();
    virtual void ac_N_SpellerEdit_Ok_touch(::FeatStd::UInt32 aSceneType);
    virtual void acInitDestinationInput(::FeatStd::UInt32 aRequestScene, bool aRetainDetails);
    virtual void acAcceptTrafficAlternativeReqMsg();
    virtual void acRejectTrafficAlternativeReqMsg();
    virtual void acSwitchContextFromTrafficDetour();
    virtual void acStartTrafficDetourTimer();
    virtual void acDeleteAllUPOIsReqMsg();
    virtual void acImportUPOIsReqMsg(bool aImportUPOIsRequest);
    virtual void acSkipWaypointReqMsg(bool aSkipWaypoint);
    virtual void acLeaveFormBasedAddressInput();
    virtual void acInavlidateSpellerEntry(bool aIsResetSpellerEntry);
    virtual void acReplaceHomeFav();
    virtual void acValidateNaviEntryCondition(bool aIsDisclaimerConfirmed);
    virtual void acSaveFavoriteWithDisplayedName(::FeatStd::UInt32 aCurrentDetailedInfo);
    virtual void acEnableGuidanceButton_NewAddress(::FeatStd::UInt8 aGuidanceEnable);
    virtual void acShowPopupText(::FeatStd::UInt8 aPopupType);
    virtual void acFavDelete(::FeatStd::UInt8 aPopupType, bool aIsHomeEntry);
    virtual void acWaypointDelete(::FeatStd::UInt8 aPopupType);
    virtual void acInitPOICategoryBrowse(::FeatStd::UInt8 aSearchScope);
    virtual void acSetPOISearchLocation();
    virtual void acSetPickInMapLocation();
    virtual void acSavePickInMapCoordinates();
    virtual void acUpdateDeletePopupText(::FeatStd::UInt8 aPopupTextID);
    virtual void acUpdateSpeedLockPopupText();
    virtual void acUpdateResetOrDestinationPopupTextReqMsg(bool aIsDestGuidance);
    virtual void acShowAllPOICategory();
    virtual void acResetTripCountReqMsg();
    virtual void acSetMapLayerVisibility(bool aIsMapLayerVisible);
    virtual void acFreezeMapAction();
    virtual void acUnfreezeMapAction();
    virtual void acFreezeAndHideMapAction();
    virtual void acSetBackButtonLevel(::FeatStd::UInt8 aBackButtonLevel);
    virtual void acToggleSouthNorth();
    virtual void acToggleEastWest();
    virtual void acInitializeLatLongSpellerEntry();
    virtual void acChangeCoordinateFormat();
    virtual void acSetLatLongInputValues();
    virtual void acSetLatDegreesActive();
    virtual void acSetLatMinutesActive();
    virtual void acSetLatSecondsActive();
    virtual void acSetLatDecimalsActive();
    virtual void acSetLongDegreesActive();
    virtual void acSetLongMinutesActive();
    virtual void acSetLongSecondsActive();
    virtual void acSetLongDecimalsActive();
    virtual void acResetLatLongPopUpStatus();
    virtual void acNavigationPopUpVisible(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopTimer(::FeatStd::UInt32 aViewId);
    virtual void acEnableWhereAmI();
    virtual void acDisableWhereAmI();
    virtual void acSetMapCameraModeAction(::FeatStd::UInt32 aMapCameraMode);
    virtual void acStartPicking(::FeatStd::UInt32 aMapPickingType);
    virtual void acTriggerMapPicking();
    virtual void acSetPickingTimer(bool aActivateTimer, ::FeatStd::UInt32 aTimerDuration);
    virtual void acStoreLocationOnByMapOkPress();
    virtual void acMapScreen();
    virtual void acCompassOrientation(bool aIsSecondaryViewActive);
    virtual void acReleasePickInMap();
    virtual void acRecenterMap();
    virtual void acResetDetailedAddress();
    virtual void acChangeRouteTypeItem(::FeatStd::UInt32 aRouteOptions);
    virtual void acChangeCustomRouteItem(::FeatStd::UInt32 aCustomRouteTypeOption);
    virtual void acChangeEstimatedTimeItem(::FeatStd::UInt32 aEstimatedTimeOption);
    virtual void acChangeTimeOnMapItem(::FeatStd::UInt32 aTimeOnMapOption);
    virtual void acChangeUseTrafficInfoItem(::FeatStd::UInt32 aUseTrafficInfoOption);
    virtual void acChangeUseTollRoadItem(::FeatStd::UInt32 aUseTollRoadOption);
    virtual void acFetchPremiumTrafficSettings();
    virtual void acApplyPremiumTrafficSettings();
    virtual void acApplyRoutePreferenceOptions();
    virtual void acApplyDetailedRoutepreferencesOptions();
    virtual void acApplyGuidanceSettings();
    virtual void acApplyTrafficIconsSettings();
    virtual void acCheckIsSatelliteSourceChanged();
    virtual void acCheckIsVehicleSettingsChanged();
    virtual void acChangeActiveProfile();
    virtual void acSaveVehicleProfileSettings();
    virtual void acResetVehicleProfileSettings();
    virtual void acResetVehicleProfileInfo();
    virtual void acUpdateStartupVehicleProfileInfo();
    virtual void acUpdateVehicleProfilePopupStatus(bool aIsGuidanceRetriggered);
    virtual void acResetAllNaviSettings();
    virtual void acApplySettings();
    virtual void acHardRestrictionConfirmMultiple();
    virtual void acSoftRestrictionMsg(bool aIsRestrictionAccepted);
    virtual void acAcceptCarModeWarning();
    virtual void acDeclineCarModeWarning();
    virtual void acDeletePreviousDestination(::FeatStd::UInt8 aPopupID);
    virtual void acPOICategoryBrowseBack();
    virtual void acUPOIBrowseBack();
    virtual void acPOIStartFts();
    virtual void acPOILeaveFts();
    virtual void acResetCoordinates();
    virtual void acUPOIResetCoordinates();
    virtual void acUPOIStartInput(bool aIsFreeTextSearch);
    virtual void acUPOILeaveInput();
    virtual void acPOILeaveInput();
    virtual void acApplyMapViewSettings();
    virtual void acMapZoomIn(bool aIsSecondaryViewActive, bool aZoomBtnType);
    virtual void acMapZoomOut(bool aIsSecondaryViewActive, bool aZoomBtnType);
    virtual void acDeleteTrackingPoint();
    virtual void acActivateMapSettingOthersList(::FeatStd::UInt32 aMapSettingsOthersListID);
    virtual void acActivateStreamMapSettingSubOptionList(::FeatStd::UInt32 aSubOptionsListID);
    virtual void acSetMaxFavPopupVisibilityStatus(bool aIsPopupEnabled);
    virtual void acSetWaypointoption(bool aWaypointoptionactivated);
    virtual void acStartRouteGuidance();
    virtual void acCancelActiveRouteGuidance();
    virtual void acToggleRouteOverviewBtn(bool aIsRouteOverViewActive);
    virtual void acSetPreviosulyActiveSceneName(::FeatStd::UInt32 aSceneName);
    virtual void acShowRouteListView(bool aIsRouteListShown);
    virtual void acShowPoisOnMapView(bool aIsListShown);
    virtual void acShowWaypointListView(bool aIsListShown);
    virtual void acHighlightActiveRoute(::FeatStd::UInt8 aRouteCriterion);
    virtual void acRouteStartGuidance();
    virtual void acMapTimerExpired();
    virtual void acLeftMapViewSetMapScaleSettings();
    virtual void acAvoidTollRoad();
    virtual void acCancelMultipleRouteIfAvailable();
    virtual void acNAVDATAUPDATE_Nav_FullMapUpdateYes(bool aIsMapUpdateTriggered);
    virtual void acNAVDATAUPDATE_Nav_FullMapUpdateNo();
    virtual void acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk();
    virtual void acUpdateNAVDATAUPDATE_PopupText(::FeatStd::UInt32 aPopupID);
    virtual void acCheckIsNaviUpdateAvailable();
    virtual void acSwitchContextFromNavDataUpdate();
    virtual void acContextSwitch(::FeatStd::UInt32 aContextSwitchFromID, ::FeatStd::UInt32 aContextSwitchToID);
    virtual void acSendContext(::FeatStd::UInt32 aContextFromActivityID);
    virtual void acUpdateContextonBackground(::FeatStd::UInt32 aCurrentViewID);
    virtual void acCheckVehicleParameterStatus();
    virtual void acRetriggerLastGuidedRoute();
    virtual void acEnterEngineeringMenu();
    virtual void acDeselectEngineeringMenu();
    virtual void acExitEngineeringMenu();
    virtual void acResetEngineeringMenu();
    virtual void acReleaseXUrgentTrafficMessageReqMsg();
    virtual void gacChangeLanguageReq(::FeatStd::Int32 aLanguageId);
    virtual void gacHideFocusInViewReq(::FeatStd::UInt32 aView);
    virtual void NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos);
    virtual void FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView);
    virtual void gacWaitAnimationStartReq();
    virtual void acFocusOnRightEncoderReqUpd(bool aIsFocusUsed);
    virtual void acSetGadgetSceenActiveStatus(bool aIsGadgetAtive);
    virtual void acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState);
    virtual void acPerform_CloseAllDropdowns();
    virtual void acPerform_CloseDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_OpenDropdown(::FeatStd::UInt32 aListId);
    virtual void acPerform_ToggleDropdown(::FeatStd::UInt32 aListId);
    virtual void acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout);
    virtual void acStopAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void acPostBeep(::FeatStd::Int8 aBeepType);
    virtual void gacCheckToClosePopup(::FeatStd::UInt32 aPopupId);
    virtual void acRestartAppPopupTimer(::FeatStd::UInt32 aViewId);
    virtual void gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId);
    virtual void gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId);
    virtual void gacCurrentScreenDisplayReq();
    virtual void gacLaunchBarDisplayReq(bool aVisibility);
    virtual void gacNavTBTSwipe();
    virtual void gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId);
    virtual void gacScrollListUp();
    virtual void gacScrollListDown();
    virtual void gacScrollPageUp();
    virtual void gacScrollPageDown();
    virtual void gacScrollListFocusUp(::FeatStd::UInt32 aListId);
    virtual void gacScrollListFocusDown(::FeatStd::UInt32 aListId);
    virtual void gacPerformListFocusLockDataResetUpd();
    virtual void gacSetApplicationMode(::FeatStd::UInt32 aModeId);
    virtual void gacSpellerBbehaviorReq(bool aEnable);
    virtual void gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType);
    virtual void gacTBTRetriggerAcousticOutput();
    virtual void gacWaitAnimationStopReq();
    virtual void gacViewCreateReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAllReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewClearReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId);
    virtual void gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId);
    virtual void gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId);
    virtual void gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint);
    virtual void gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType);
    virtual void gacDisplayFooterLineReq();
    virtual void gacHideFooterLineReq();
    virtual void gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID);
    virtual void gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId);
    virtual void gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId);
    virtual void gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio);
    virtual void gacPopupFilterAllEnableReq();
    virtual void gacPopupFilterDisableReq();
    virtual void gacProfileChange(::FeatStd::Int8 aProfile);
    virtual void gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID);
    virtual void gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2);
    virtual void gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
    virtual ::FeatStd::UInt16 fnGetVariantType();

// ------------------------------------------------------------------------
    virtual bool dgPOITopCategoryStatus();
    virtual bool dgPOIResultListStatus();
    virtual bool dgLatLongPopUpActive();
    virtual ::FeatStd::UInt8 dgMainMapScreenStateValue();
    virtual ::FeatStd::UInt8 dgRouteOverViewBtnEnabled();
    virtual bool dgEngineeringMenuListStatus();
    virtual bool dgEngineeringMenuTopListStatus();
    virtual bool dgNaviMiddlewareStatus();

#ifdef CIT_SIMULATION
    bool CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response);
    const ::FeatStd::Char* GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArgument);
#endif
    // Added function for deduction of one event to simplify the event loop
    bool HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & message, ::FeatStd::UInt32& eventId) const;
    bool HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const;

    ::Cit::DeductResult::Enum DeductEvent(::Courier::Message const & message, ::FeatStd::UInt32 eventId);

    //====  member function with TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====

	virtual unsigned short GetTraceClass();
	int GetNumberOfStatemachines();
    //====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ====
};

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg();
bool SendSpellerOKBtnPressedMsg(Courier::UInt32 const & aSceneType);
bool SendInitDestinationInputReqMsg(Courier::UInt32 const & aRequestScene, bool const & aRetainDetails);
bool SendAcceptTrafficAlternativeReqMsg();
bool SendRejectTrafficAlternativeReqMsg();
bool SendSwitchContextFromTrafficDetourReqMsg();
bool SendStartTrafficDetourTimerReqMsg();
bool SendDeleteAllUPOIsReqMsg();
bool SendImportUPOIsReqMsg(bool const & aImportUPOIsRequest);
bool SendSkipWaypointReqMsg(bool const & aSkipWaypoint);
bool SendLeaveFormBasedAddressInputReqMsg();
bool SendResetSpellerEntryMsg(bool const & aIsResetSpellerEntry);
bool SendReplaceHomeFavReqMsg();
bool SendValidateNaviEntryConditionReqMsg(bool const & aIsDisclaimerConfirmed);
bool SendSaveFavoriteWithDisplayedNameReqMsg(Courier::UInt32 const & aCurrentDetailedInfo);
bool SendEnableGuidanceButton_NewAddressReqMsg(Courier::UInt8 const & aGuidanceEnable);
bool SendShowPopupTextMsg(Courier::UInt8 const & aPopupType);
bool SendFavDeleteReqMsg(Courier::UInt8 const & aPopupType, bool const & aIsHomeEntry);
bool SendWaypointDeleteReqMsg(Courier::UInt8 const & aPopupType);
bool SendInitPOICategoryBrowseReqMsg(enLocationSearchScope const & aSearchScope);
bool SendSetPOISearchLocationReqMsg();
bool SendSetPickInMapLocationReqMsg();
bool SendSavePickInMapCoordinatesReqMsg();
bool SendUpdateDeletePopupTextReqMsg(Courier::UInt8 const & aPopupTextID);
bool SendUpdateSpeedLockPopupTextReqMsg();
bool SendUpdateResetOrDestinationPopupTextReqMsg(bool const & aIsDestGuidance);
bool SendShowAllPOICategoryReqMsg();
bool SendResetTripCountReqMsg();
bool SendSetMapLayerVisibilityReqMsg(bool const & aIsMapLayerVisible);
bool SendFreezeMapReqMsg();
bool SendUnfreezeMapReqMsg();
bool SendFreezeAndHideMapReqMsg();
bool SendSetBackButtonLevelReqMsg(Courier::UInt8 const & aBackButtonLevel);
bool SendToggleSouthNorthReqMsg();
bool SendToggleEastWestReqMsg();
bool SendInitializeLatLongSpellerEntryReqMsg();
bool SendChangeCoordinateFormatReqMsg();
bool SendShowCoordinatesInMapReqMsg();
bool SendChangeActiveEditFieldReqMsg(enLatLongInputDataType const & aActiveInputDataType);
bool SendResetLatLongPopUpActiveStatusReqMsg();
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendEnableWhereAmIReqMsg();
bool SendDisableWhereAmIReqMsg();
bool SendSetMapCameraModeReqMsg(enMapCameraAndViewModeMode const & aMapCameraMode);
bool SendStartPickingReqMsg(enMapPickingType const & aMapPickingType);
bool SendTriggerMapPickingReqMsg();
bool SendSetPickingTimerReqMsg(bool const & aActivateTimer, Courier::UInt32 const & aTimerDuration);
bool SendStoreLocationOnByMapReqMsg();
bool SendEnteredMapScreenReqMsg();
bool SendCompassOrientationReqMsg(bool const & aIsSecondaryViewActive);
bool SendReleasePickInMapReqMsg();
bool SendReCenterMapScrollReqMsg();
bool SendResetDetailedAddressMsg();
bool SendChangeRouteTypeItemReqMsg(enRouteTypeOptions const & aRouteOptions, enReaction const & aReaction);
bool SendChangeCustomRouteItemReqMsg(enCustomizeRouteOptions const & aCustomRouteTypeOption, enReaction const & aReaction);
bool SendChangeEstimatedTimeItemReqMsg(enEstimatedTimeOptions const & aEstimatedTimeOption, enReaction const & aReaction);
bool SendChangeTimeOnMapItemReqMsg(enTimeOnMapOptions const & aTimeOnMapOption, enReaction const & aReaction);
bool SendChangeUseTrafficInfoReqMsg(enRoadInformationOptions const & aUseTrafficInfoOption, enReaction const & aReaction);
bool SendChangeUseTollRoadReqMsg(enRoadInformationOptions const & aUseTollRoadOption, enReaction const & aReaction);
bool SendFetchPremiumTrafficSettingsReqMsg();
bool SendApplyPremiumTrafficSettingsReqMsg();
bool SendApplyRoutePreferenceOptionsReqMsg();
bool SendApplyDetailedRoutePreferenceOptionsReqMsg();
bool SendApplyGuidanceSettingsReqMsg();
bool SendApplyTrafficIconsSettingsReqMsg();
bool SendCheckIsSatelliteSourceChangedReqMsg();
bool SendCheckIsVehicleSettingsChangedReqMsg();
bool SendChangeActiveProfileReqMsg();
bool SendSaveVehicleProfileSettingsReqMsg();
bool SendResetVehicleProfileSettingsReqMsg();
bool SendResetVehicleProfileInfoReqMsg();
bool SendUpdateStartupVehicleProfileReqMsg();
bool SendUpdateVehicleProfilePopupStatusReqMsg(bool const & aIsGuidanceRetriggered);
bool SendResetAllNaviSettingsReqMsg();
bool SendApplySettingsReqMsg();
bool SendHardRestrictionConfirmMultipleReqMsg();
bool SendSoftRestrictionMsg(bool const & aIsRestrictionAccepted);
bool SendAcceptCarModeWarningReqMsg();
bool SendDeclineCarModeWarningReqMsg();
bool SendDeletePreviousDestinationReqMsg(Courier::UInt8 const & aPopupID);
bool SendPOICategoryBrowseBackReqMsg();
bool SendUPOIBrowseBackReqMsg();
bool SendPOIStartFtsReqMsg();
bool SendPOILeaveFtsReqMsg();
bool SendResetCoordinatesReqMsg();
bool SendUPOIResetCoordinatesReqMsg();
bool SendUPOIStartInputReqMsg(bool const & aIsFreeTextSearch);
bool SendUPOILeaveInputReqMsg();
bool SendPOILeaveInputReqMsg();
bool SendApplyMapViewSettingsReqMsg();
bool SendZoomInReqMsg(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType);
bool SendZoomOutReqMsg(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType);
bool SendDeleteTrackingPointReqMsg();
bool SendActivateOthersMapSettingListReqMsg(Candera::UInt32 const & aMapSettingsOthersListID);
bool SendActivateStreamedMapSubOptionListReqMsg(Candera::UInt32 const & aSubOptionsListID);
bool SendMaxFavPopupVisibilityReqsMsg(bool const & aIsPopupEnabled);
bool SendSetWayPointEnableReqMsg(bool const & aWaypointoptionactivated);
bool SendStartRouteGuidanceReqMsg();
bool SendCancelRouteGuidanceReqMsg();
bool SendToggleRouteOverViewBtnMsg(bool const & aIsRouteOverViewActive);
bool SendSetPreviosulyActiveSceneName(Candera::UInt32 const & aSceneName);
bool SendShowRouteListViewReqMsg(bool const & aIsRouteListShown);
bool SendShowPoisOnMapViewReqMsg(bool const & aIsListShown);
bool SendShowWaypointListViewReqMsg(bool const & aIsListShown);
bool SendHighlightActiveRouteReqMsg(enRouteTypeOptions const & aRouteCriterion);
bool SendRouteStartGuidanceReqMsg();
bool SendExpiredTimerResMsg();
bool SendLeftMapViewSetMapScaleReqMsg();
bool SendAvoidTollRoadReqMsg();
bool SendCancelMultipleRouteReqMsg();
bool SendNAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg(bool const & aIsMapUpdateTriggered);
bool SendNAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg();
bool SendNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg();
bool SendUpdateNAVDATAUPDATE_PopupTextMsg(Candera::UInt32 const & aPopupID);
bool SendCheckIsNaviUpdateAvailableReqMsg();
bool SendSwitchContextFromNavDataUpdateReqMsg();
bool SendContextSwitchReqMsg(enContextSwitchFromType const & aContextSwitchFromID, enContextSwitchToType const & aContextSwitchToID);
bool SendSendContextReqMsg(enContextSwitchFromType const & aContextFromActivityID);
bool SendUpdateContextonBackgroundReqMsg(Courier::UInt32 const & aCurrentViewID);
bool SendCheckVehicleParameterStatusMsg();
bool SendRetriggerLastGuidedRouteReqMsg();
bool SendEnterEngineeringMenuReqMsg();
bool SendDeselectEngineeringMenuReqMsg();
bool SendExitEngineeringMenuReqMsg();
bool SendResetEngineeringMenuReqMsg();
bool SendReleaseXUrgentTrafficMessageReqMsg();
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId);
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed);
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive);
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId);
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType);
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId);
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId);
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType);
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
bool SendCurrentScreenDisplayReqMsg();
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility);
bool SendNavTBTSwipeReqMsg();
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning);
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps);
bool SendListFocusLockDataResetReqMsg();
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId);
bool SendSpellerBbehaviorReqMsg(bool const & aEnable);
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType);
bool SendTBTRetriggerAcousticMsg();
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene);
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering);
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad);
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID);
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface);
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
bool SendPopupFilterAllEnableReqMsg();
bool SendPopupFilterDisableReqMsg();
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile);
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
bool SendNotifierMessage();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_Notify_Init_Finished();
#ifdef CIT_SIMULATION
bool CallAction_ac_N_SpellerEdit_Ok_touch(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ac_N_SpellerEdit_Ok_touch(Courier::UInt32 const & aSceneType);
#ifdef CIT_SIMULATION
bool CallAction_acInitDestinationInput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acInitDestinationInput(Courier::UInt32 const & aRequestScene, bool const & aRetainDetails);
#ifdef CIT_SIMULATION
bool CallAction_acAcceptTrafficAlternativeReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acAcceptTrafficAlternativeReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acRejectTrafficAlternativeReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRejectTrafficAlternativeReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSwitchContextFromTrafficDetour(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSwitchContextFromTrafficDetour();
#ifdef CIT_SIMULATION
bool CallAction_acStartTrafficDetourTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartTrafficDetourTimer();
#ifdef CIT_SIMULATION
bool CallAction_acDeleteAllUPOIsReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeleteAllUPOIsReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acImportUPOIsReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acImportUPOIsReqMsg(bool const & aImportUPOIsRequest);
#ifdef CIT_SIMULATION
bool CallAction_acSkipWaypointReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSkipWaypointReqMsg(bool const & aSkipWaypoint);
#ifdef CIT_SIMULATION
bool CallAction_acLeaveFormBasedAddressInput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acLeaveFormBasedAddressInput();
#ifdef CIT_SIMULATION
bool CallAction_acInavlidateSpellerEntry(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acInavlidateSpellerEntry(bool const & aIsResetSpellerEntry);
#ifdef CIT_SIMULATION
bool CallAction_acReplaceHomeFav(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReplaceHomeFav();
#ifdef CIT_SIMULATION
bool CallAction_acValidateNaviEntryCondition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acValidateNaviEntryCondition(bool const & aIsDisclaimerConfirmed);
#ifdef CIT_SIMULATION
bool CallAction_acSaveFavoriteWithDisplayedName(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSaveFavoriteWithDisplayedName(Courier::UInt32 const & aCurrentDetailedInfo);
#ifdef CIT_SIMULATION
bool CallAction_acEnableGuidanceButton_NewAddress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acEnableGuidanceButton_NewAddress(Courier::UInt8 const & aGuidanceEnable);
#ifdef CIT_SIMULATION
bool CallAction_acShowPopupText(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowPopupText(Courier::UInt8 const & aPopupType);
#ifdef CIT_SIMULATION
bool CallAction_acFavDelete(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFavDelete(Courier::UInt8 const & aPopupType, bool const & aIsHomeEntry);
#ifdef CIT_SIMULATION
bool CallAction_acWaypointDelete(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acWaypointDelete(Courier::UInt8 const & aPopupType);
#ifdef CIT_SIMULATION
bool CallAction_acInitPOICategoryBrowse(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acInitPOICategoryBrowse(enLocationSearchScope const & aSearchScope);
#ifdef CIT_SIMULATION
bool CallAction_acSetPOISearchLocation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetPOISearchLocation();
#ifdef CIT_SIMULATION
bool CallAction_acSetPickInMapLocation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetPickInMapLocation();
#ifdef CIT_SIMULATION
bool CallAction_acSavePickInMapCoordinates(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSavePickInMapCoordinates();
#ifdef CIT_SIMULATION
bool CallAction_acUpdateDeletePopupText(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateDeletePopupText(Courier::UInt8 const & aPopupTextID);
#ifdef CIT_SIMULATION
bool CallAction_acUpdateSpeedLockPopupText(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateSpeedLockPopupText();
#ifdef CIT_SIMULATION
bool CallAction_acUpdateResetOrDestinationPopupTextReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateResetOrDestinationPopupTextReqMsg(bool const & aIsDestGuidance);
#ifdef CIT_SIMULATION
bool CallAction_acShowAllPOICategory(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowAllPOICategory();
#ifdef CIT_SIMULATION
bool CallAction_acResetTripCountReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetTripCountReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_acSetMapLayerVisibility(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetMapLayerVisibility(bool const & aIsMapLayerVisible);
#ifdef CIT_SIMULATION
bool CallAction_acFreezeMapAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFreezeMapAction();
#ifdef CIT_SIMULATION
bool CallAction_acUnfreezeMapAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUnfreezeMapAction();
#ifdef CIT_SIMULATION
bool CallAction_acFreezeAndHideMapAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFreezeAndHideMapAction();
#ifdef CIT_SIMULATION
bool CallAction_acSetBackButtonLevel(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetBackButtonLevel(Courier::UInt8 const & aBackButtonLevel);
#ifdef CIT_SIMULATION
bool CallAction_acToggleSouthNorth(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleSouthNorth();
#ifdef CIT_SIMULATION
bool CallAction_acToggleEastWest(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleEastWest();
#ifdef CIT_SIMULATION
bool CallAction_acInitializeLatLongSpellerEntry(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acInitializeLatLongSpellerEntry();
#ifdef CIT_SIMULATION
bool CallAction_acChangeCoordinateFormat(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeCoordinateFormat();
#ifdef CIT_SIMULATION
bool CallAction_acSetLatLongInputValues(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLatLongInputValues();
#ifdef CIT_SIMULATION
bool CallAction_acSetLatDegreesActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLatDegreesActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLatMinutesActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLatMinutesActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLatSecondsActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLatSecondsActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLatDecimalsActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLatDecimalsActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLongDegreesActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLongDegreesActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLongMinutesActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLongMinutesActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLongSecondsActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLongSecondsActive();
#ifdef CIT_SIMULATION
bool CallAction_acSetLongDecimalsActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetLongDecimalsActive();
#ifdef CIT_SIMULATION
bool CallAction_acResetLatLongPopUpStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetLatLongPopUpStatus();
#ifdef CIT_SIMULATION
bool CallAction_acNavigationPopUpVisible(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acNavigationPopUpVisible(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acEnableWhereAmI(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acEnableWhereAmI();
#ifdef CIT_SIMULATION
bool CallAction_acDisableWhereAmI(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDisableWhereAmI();
#ifdef CIT_SIMULATION
bool CallAction_acSetMapCameraModeAction(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetMapCameraModeAction(enMapCameraAndViewModeMode const & aMapCameraMode);
#ifdef CIT_SIMULATION
bool CallAction_acStartPicking(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartPicking(enMapPickingType const & aMapPickingType);
#ifdef CIT_SIMULATION
bool CallAction_acTriggerMapPicking(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acTriggerMapPicking();
#ifdef CIT_SIMULATION
bool CallAction_acSetPickingTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetPickingTimer(bool const & aActivateTimer, Courier::UInt32 const & aTimerDuration);
#ifdef CIT_SIMULATION
bool CallAction_acStoreLocationOnByMapOkPress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStoreLocationOnByMapOkPress();
#ifdef CIT_SIMULATION
bool CallAction_acMapScreen(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMapScreen();
#ifdef CIT_SIMULATION
bool CallAction_acCompassOrientation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCompassOrientation(bool const & aIsSecondaryViewActive);
#ifdef CIT_SIMULATION
bool CallAction_acReleasePickInMap(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReleasePickInMap();
#ifdef CIT_SIMULATION
bool CallAction_acRecenterMap(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRecenterMap();
#ifdef CIT_SIMULATION
bool CallAction_acResetDetailedAddress(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetDetailedAddress();
#ifdef CIT_SIMULATION
bool CallAction_acChangeRouteTypeItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeRouteTypeItem(enRouteTypeOptions const & aRouteOptions);
#ifdef CIT_SIMULATION
bool CallAction_acChangeCustomRouteItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeCustomRouteItem(enCustomizeRouteOptions const & aCustomRouteTypeOption);
#ifdef CIT_SIMULATION
bool CallAction_acChangeEstimatedTimeItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeEstimatedTimeItem(enEstimatedTimeOptions const & aEstimatedTimeOption);
#ifdef CIT_SIMULATION
bool CallAction_acChangeTimeOnMapItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeTimeOnMapItem(enTimeOnMapOptions const & aTimeOnMapOption);
#ifdef CIT_SIMULATION
bool CallAction_acChangeUseTrafficInfoItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeUseTrafficInfoItem(enRoadInformationOptions const & aUseTrafficInfoOption);
#ifdef CIT_SIMULATION
bool CallAction_acChangeUseTollRoadItem(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeUseTollRoadItem(enRoadInformationOptions const & aUseTollRoadOption);
#ifdef CIT_SIMULATION
bool CallAction_acFetchPremiumTrafficSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFetchPremiumTrafficSettings();
#ifdef CIT_SIMULATION
bool CallAction_acApplyPremiumTrafficSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyPremiumTrafficSettings();
#ifdef CIT_SIMULATION
bool CallAction_acApplyRoutePreferenceOptions(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyRoutePreferenceOptions();
#ifdef CIT_SIMULATION
bool CallAction_acApplyDetailedRoutepreferencesOptions(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyDetailedRoutepreferencesOptions();
#ifdef CIT_SIMULATION
bool CallAction_acApplyGuidanceSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyGuidanceSettings();
#ifdef CIT_SIMULATION
bool CallAction_acApplyTrafficIconsSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyTrafficIconsSettings();
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsSatelliteSourceChanged(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCheckIsSatelliteSourceChanged();
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsVehicleSettingsChanged(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCheckIsVehicleSettingsChanged();
#ifdef CIT_SIMULATION
bool CallAction_acChangeActiveProfile(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acChangeActiveProfile();
#ifdef CIT_SIMULATION
bool CallAction_acSaveVehicleProfileSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSaveVehicleProfileSettings();
#ifdef CIT_SIMULATION
bool CallAction_acResetVehicleProfileSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetVehicleProfileSettings();
#ifdef CIT_SIMULATION
bool CallAction_acResetVehicleProfileInfo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetVehicleProfileInfo();
#ifdef CIT_SIMULATION
bool CallAction_acUpdateStartupVehicleProfileInfo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateStartupVehicleProfileInfo();
#ifdef CIT_SIMULATION
bool CallAction_acUpdateVehicleProfilePopupStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateVehicleProfilePopupStatus(bool const & aIsGuidanceRetriggered);
#ifdef CIT_SIMULATION
bool CallAction_acResetAllNaviSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetAllNaviSettings();
#ifdef CIT_SIMULATION
bool CallAction_acApplySettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplySettings();
#ifdef CIT_SIMULATION
bool CallAction_acHardRestrictionConfirmMultiple(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHardRestrictionConfirmMultiple();
#ifdef CIT_SIMULATION
bool CallAction_acSoftRestrictionMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSoftRestrictionMsg(bool const & aIsRestrictionAccepted);
#ifdef CIT_SIMULATION
bool CallAction_acAcceptCarModeWarning(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acAcceptCarModeWarning();
#ifdef CIT_SIMULATION
bool CallAction_acDeclineCarModeWarning(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeclineCarModeWarning();
#ifdef CIT_SIMULATION
bool CallAction_acDeletePreviousDestination(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeletePreviousDestination(Courier::UInt8 const & aPopupID);
#ifdef CIT_SIMULATION
bool CallAction_acPOICategoryBrowseBack(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPOICategoryBrowseBack();
#ifdef CIT_SIMULATION
bool CallAction_acUPOIBrowseBack(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUPOIBrowseBack();
#ifdef CIT_SIMULATION
bool CallAction_acPOIStartFts(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPOIStartFts();
#ifdef CIT_SIMULATION
bool CallAction_acPOILeaveFts(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPOILeaveFts();
#ifdef CIT_SIMULATION
bool CallAction_acResetCoordinates(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetCoordinates();
#ifdef CIT_SIMULATION
bool CallAction_acUPOIResetCoordinates(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUPOIResetCoordinates();
#ifdef CIT_SIMULATION
bool CallAction_acUPOIStartInput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUPOIStartInput(bool const & aIsFreeTextSearch);
#ifdef CIT_SIMULATION
bool CallAction_acUPOILeaveInput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUPOILeaveInput();
#ifdef CIT_SIMULATION
bool CallAction_acPOILeaveInput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPOILeaveInput();
#ifdef CIT_SIMULATION
bool CallAction_acApplyMapViewSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acApplyMapViewSettings();
#ifdef CIT_SIMULATION
bool CallAction_acMapZoomIn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMapZoomIn(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType);
#ifdef CIT_SIMULATION
bool CallAction_acMapZoomOut(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMapZoomOut(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType);
#ifdef CIT_SIMULATION
bool CallAction_acDeleteTrackingPoint(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeleteTrackingPoint();
#ifdef CIT_SIMULATION
bool CallAction_acActivateMapSettingOthersList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateMapSettingOthersList(Candera::UInt32 const & aMapSettingsOthersListID);
#ifdef CIT_SIMULATION
bool CallAction_acActivateStreamMapSettingSubOptionList(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acActivateStreamMapSettingSubOptionList(Candera::UInt32 const & aSubOptionsListID);
#ifdef CIT_SIMULATION
bool CallAction_acSetMaxFavPopupVisibilityStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetMaxFavPopupVisibilityStatus(bool const & aIsPopupEnabled);
#ifdef CIT_SIMULATION
bool CallAction_acSetWaypointoption(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetWaypointoption(bool const & aWaypointoptionactivated);
#ifdef CIT_SIMULATION
bool CallAction_acStartRouteGuidance(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartRouteGuidance();
#ifdef CIT_SIMULATION
bool CallAction_acCancelActiveRouteGuidance(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCancelActiveRouteGuidance();
#ifdef CIT_SIMULATION
bool CallAction_acToggleRouteOverviewBtn(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acToggleRouteOverviewBtn(bool const & aIsRouteOverViewActive);
#ifdef CIT_SIMULATION
bool CallAction_acSetPreviosulyActiveSceneName(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetPreviosulyActiveSceneName(Candera::UInt32 const & aSceneName);
#ifdef CIT_SIMULATION
bool CallAction_acShowRouteListView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowRouteListView(bool const & aIsRouteListShown);
#ifdef CIT_SIMULATION
bool CallAction_acShowPoisOnMapView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowPoisOnMapView(bool const & aIsListShown);
#ifdef CIT_SIMULATION
bool CallAction_acShowWaypointListView(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acShowWaypointListView(bool const & aIsListShown);
#ifdef CIT_SIMULATION
bool CallAction_acHighlightActiveRoute(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHighlightActiveRoute(enRouteTypeOptions const & aRouteCriterion);
#ifdef CIT_SIMULATION
bool CallAction_acRouteStartGuidance(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRouteStartGuidance();
#ifdef CIT_SIMULATION
bool CallAction_acMapTimerExpired(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acMapTimerExpired();
#ifdef CIT_SIMULATION
bool CallAction_acLeftMapViewSetMapScaleSettings(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acLeftMapViewSetMapScaleSettings();
#ifdef CIT_SIMULATION
bool CallAction_acAvoidTollRoad(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acAvoidTollRoad();
#ifdef CIT_SIMULATION
bool CallAction_acCancelMultipleRouteIfAvailable(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCancelMultipleRouteIfAvailable();
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateYes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acNAVDATAUPDATE_Nav_FullMapUpdateYes(bool const & aIsMapUpdateTriggered);
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateNo(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acNAVDATAUPDATE_Nav_FullMapUpdateNo();
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk();
#ifdef CIT_SIMULATION
bool CallAction_acUpdateNAVDATAUPDATE_PopupText(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateNAVDATAUPDATE_PopupText(Candera::UInt32 const & aPopupID);
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsNaviUpdateAvailable(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCheckIsNaviUpdateAvailable();
#ifdef CIT_SIMULATION
bool CallAction_acSwitchContextFromNavDataUpdate(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSwitchContextFromNavDataUpdate();
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitch(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acContextSwitch(enContextSwitchFromType const & aContextSwitchFromID, enContextSwitchToType const & aContextSwitchToID);
#ifdef CIT_SIMULATION
bool CallAction_acSendContext(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSendContext(enContextSwitchFromType const & aContextFromActivityID);
#ifdef CIT_SIMULATION
bool CallAction_acUpdateContextonBackground(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acUpdateContextonBackground(Courier::UInt32 const & aCurrentViewID);
#ifdef CIT_SIMULATION
bool CallAction_acCheckVehicleParameterStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acCheckVehicleParameterStatus();
#ifdef CIT_SIMULATION
bool CallAction_acRetriggerLastGuidedRoute(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRetriggerLastGuidedRoute();
#ifdef CIT_SIMULATION
bool CallAction_acEnterEngineeringMenu(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acEnterEngineeringMenu();
#ifdef CIT_SIMULATION
bool CallAction_acDeselectEngineeringMenu(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acDeselectEngineeringMenu();
#ifdef CIT_SIMULATION
bool CallAction_acExitEngineeringMenu(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acExitEngineeringMenu();
#ifdef CIT_SIMULATION
bool CallAction_acResetEngineeringMenu(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acResetEngineeringMenu();
#ifdef CIT_SIMULATION
bool CallAction_acReleaseXUrgentTrafficMessageReqMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acReleaseXUrgentTrafficMessageReqMsg();
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView);
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos);
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView);
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStartReq();
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed);
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive);
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseAllDropdowns();
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout);
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType);
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId);
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId);
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId);
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacCurrentScreenDisplayReq();
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility);
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacNavTBTSwipe();
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageUp();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollPageDown();
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId);
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPerformListFocusLockDataResetUpd();
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId);
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable);
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType);
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacTBTRetriggerAcousticOutput();
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacWaitAnimationStopReq();
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineReq();
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReq();
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID);
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2);
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& parameters, ::Json::Value &response);
#endif
void Action_gacDecrementActiveAnimationCount();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantType(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt16 fnGetVariantType();

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgPOITopCategoryStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgPOITopCategoryStatus();
#ifdef CIT_SIMULATION
bool CallAction_dgPOIResultListStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgPOIResultListStatus();
#ifdef CIT_SIMULATION
bool CallAction_dgLatLongPopUpActive(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgLatLongPopUpActive();
#ifdef CIT_SIMULATION
bool CallAction_dgMainMapScreenStateValue(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt8 Action_dgMainMapScreenStateValue();
#ifdef CIT_SIMULATION
bool CallAction_dgRouteOverViewBtnEnabled(const ::Json::Value& parameters, ::Json::Value &response);
#endif
::FeatStd::UInt8 Action_dgRouteOverViewBtnEnabled();
#ifdef CIT_SIMULATION
bool CallAction_dgEngineeringMenuListStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgEngineeringMenuListStatus();
#ifdef CIT_SIMULATION
bool CallAction_dgEngineeringMenuTopListStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgEngineeringMenuTopListStatus();
#ifdef CIT_SIMULATION
bool CallAction_dgNaviMiddlewareStatus(const ::Json::Value& parameters, ::Json::Value &response);
#endif
bool Action_dgNaviMiddlewareStatus();

// overall number of HierarchyNodes
static const ::FeatStd::UInt32 cGlobalDataItemHierarchyNodeCount = 492;
// overall number of DataItemDescriptor nodes
static const ::FeatStd::UInt32 cDataItemDescriptorCount = 492;
// overall number of BindingSources
static const ::FeatStd::UInt32 cBindingSourceCount = 107;
// maximum number of HierarchyNodes in a BindingSource
static const ::FeatStd::UInt32 cBindingSourceItemCountMax = 31;

// =========================================================================

class SignpostTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 12;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 1;
    static const ::Courier::DataItemKey cDataItemKey = 162;

    typedef ::SignpostTextData Data;

    SignpostTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< SignpostTextDataBindingSource > SignpostTextDataItemMsg;

// =========================================================================

class HlgImageDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 2;
    static const ::Courier::DataItemKey cDataItemKey = 95;

    typedef ::HlgImageDataData Data;

    HlgImageDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< HlgImageDataDataBindingSource > HlgImageDataDataItemMsg;

// =========================================================================

class RoadIconsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 3;
    static const ::Courier::DataItemKey cDataItemKey = 48;

    typedef ::RoadIconsData Data;

    RoadIconsDataBindingSource();
};

typedef ::Courier::DataItemMsg< RoadIconsDataBindingSource > RoadIconsDataItemMsg;

// =========================================================================

class MapModeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 4;
    static const ::Courier::DataItemKey cDataItemKey = 375;

    typedef ::MapModeData Data;

    MapModeDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapModeDataBindingSource > MapModeDataItemMsg;

// =========================================================================

class BTTetheringStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 5;
    static const ::Courier::DataItemKey cDataItemKey = 60;

    typedef ::BTTetheringStateData Data;

    BTTetheringStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< BTTetheringStateDataBindingSource > BTTetheringStateDataItemMsg;

// =========================================================================

class AddressInputValueDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 6;
    static const ::Courier::DataItemKey cDataItemKey = 25;

    typedef ::AddressInputValueData Data;

    AddressInputValueDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressInputValueDataBindingSource > AddressInputValueDataItemMsg;

// =========================================================================

class ChangeCountryButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 7;
    static const ::Courier::DataItemKey cDataItemKey = 10;

    typedef ::ChangeCountryButtonData Data;

    ChangeCountryButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< ChangeCountryButtonDataBindingSource > ChangeCountryButtonDataItemMsg;

// =========================================================================

class PreviousDestinationValDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 8;
    static const ::Courier::DataItemKey cDataItemKey = 214;

    typedef ::PreviousDestinationValData Data;

    PreviousDestinationValDataBindingSource();
};

typedef ::Courier::DataItemMsg< PreviousDestinationValDataBindingSource > PreviousDestinationValDataItemMsg;

// =========================================================================

class VariantButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 9;
    static const ::Courier::DataItemKey cDataItemKey = 203;

    typedef ::VariantButtonData Data;

    VariantButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< VariantButtonDataBindingSource > VariantButtonDataItemMsg;

// =========================================================================

class DEDisableButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 10;
    static const ::Courier::DataItemKey cDataItemKey = 16;

    typedef ::DEDisableButtonData Data;

    DEDisableButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< DEDisableButtonDataBindingSource > DEDisableButtonDataItemMsg;

// =========================================================================

class AddressInputValPOIDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 11;
    static const ::Courier::DataItemKey cDataItemKey = 412;

    typedef ::AddressInputValPOIData Data;

    AddressInputValPOIDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressInputValPOIDataBindingSource > AddressInputValPOIDataItemMsg;

// =========================================================================

class AddressInputValDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 12;
    static const ::Courier::DataItemKey cDataItemKey = 482;

    typedef ::AddressInputValDetailsData Data;

    AddressInputValDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressInputValDetailsDataBindingSource > AddressInputValDetailsDataItemMsg;

// =========================================================================

class PlaceInfoButtonsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 13;
    static const ::Courier::DataItemKey cDataItemKey = 9;

    typedef ::PlaceInfoButtonsData Data;

    PlaceInfoButtonsDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaceInfoButtonsDataBindingSource > PlaceInfoButtonsDataItemMsg;

// =========================================================================

class PlaceInfoDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 14;
    static const ::Courier::DataItemKey cDataItemKey = 163;

    typedef ::PlaceInfoDetailsData Data;

    PlaceInfoDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< PlaceInfoDetailsDataBindingSource > PlaceInfoDetailsDataItemMsg;

// =========================================================================

class TwoLinePopuptextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 15;
    static const ::Courier::DataItemKey cDataItemKey = 303;

    typedef ::TwoLinePopuptextData Data;

    TwoLinePopuptextDataBindingSource();
};

typedef ::Courier::DataItemMsg< TwoLinePopuptextDataBindingSource > TwoLinePopuptextDataItemMsg;

// =========================================================================

class MultiLinePopuptextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 16;
    static const ::Courier::DataItemKey cDataItemKey = 308;

    typedef ::MultiLinePopuptextData Data;

    MultiLinePopuptextDataBindingSource();
};

typedef ::Courier::DataItemMsg< MultiLinePopuptextDataBindingSource > MultiLinePopuptextDataItemMsg;

// =========================================================================

class ThreeLinePopuptextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 17;
    static const ::Courier::DataItemKey cDataItemKey = 141;

    typedef ::ThreeLinePopuptextData Data;

    ThreeLinePopuptextDataBindingSource();
};

typedef ::Courier::DataItemMsg< ThreeLinePopuptextDataBindingSource > ThreeLinePopuptextDataItemMsg;

// =========================================================================

class RouteInfoPopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 18;
    static const ::Courier::DataItemKey cDataItemKey = 210;

    typedef ::RouteInfoPopupTextData Data;

    RouteInfoPopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteInfoPopupTextDataBindingSource > RouteInfoPopupTextDataItemMsg;

// =========================================================================

class FourLinePopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 19;
    static const ::Courier::DataItemKey cDataItemKey = 234;

    typedef ::FourLinePopupTextData Data;

    FourLinePopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< FourLinePopupTextDataBindingSource > FourLinePopupTextDataItemMsg;

// =========================================================================

class FiveLinePopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 6;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 20;
    static const ::Courier::DataItemKey cDataItemKey = 389;

    typedef ::FiveLinePopupTextData Data;

    FiveLinePopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< FiveLinePopupTextDataBindingSource > FiveLinePopupTextDataItemMsg;

// =========================================================================

class SpellerPressedKeyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 21;
    static const ::Courier::DataItemKey cDataItemKey = 477;

    typedef ::SpellerPressedKeyInfoData Data;

    SpellerPressedKeyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpellerPressedKeyInfoDataBindingSource > SpellerPressedKeyInfoDataItemMsg;

// =========================================================================

class SpellerPagesDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 22;
    static const ::Courier::DataItemKey cDataItemKey = 139;

    typedef ::SpellerPagesData Data;

    SpellerPagesDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpellerPagesDataBindingSource > SpellerPagesDataItemMsg;

// =========================================================================

class SpellerTextInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 23;
    static const ::Courier::DataItemKey cDataItemKey = 290;

    typedef ::SpellerTextInfoData Data;

    SpellerTextInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpellerTextInfoDataBindingSource > SpellerTextInfoDataItemMsg;

// =========================================================================

class NaviSpellerInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 24;
    static const ::Courier::DataItemKey cDataItemKey = 35;

    typedef ::NaviSpellerInfoData Data;

    NaviSpellerInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< NaviSpellerInfoDataBindingSource > NaviSpellerInfoDataItemMsg;

// =========================================================================

class AddressEntryTitleTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 25;
    static const ::Courier::DataItemKey cDataItemKey = 136;

    typedef ::AddressEntryTitleTextData Data;

    AddressEntryTitleTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressEntryTitleTextDataBindingSource > AddressEntryTitleTextDataItemMsg;

// =========================================================================

class NaviMiddlewareStatusDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 26;
    static const ::Courier::DataItemKey cDataItemKey = 293;

    typedef ::NaviMiddlewareStatusData Data;

    NaviMiddlewareStatusDataBindingSource();
};

typedef ::Courier::DataItemMsg< NaviMiddlewareStatusDataBindingSource > NaviMiddlewareStatusDataItemMsg;

// =========================================================================

class FreeTextListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 27;
    static const ::Courier::DataItemKey cDataItemKey = 190;

    typedef ::FreeTextListItemData Data;

    FreeTextListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< FreeTextListItemDataBindingSource > FreeTextListItemDataItemMsg;

// =========================================================================

class SpellerEntryTextReceivedInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 28;
    static const ::Courier::DataItemKey cDataItemKey = 313;

    typedef ::SpellerEntryTextReceivedInfoData Data;

    SpellerEntryTextReceivedInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< SpellerEntryTextReceivedInfoDataBindingSource > SpellerEntryTextReceivedInfoDataItemMsg;

// =========================================================================

class AddressEntryInputMatchesDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 29;
    static const ::Courier::DataItemKey cDataItemKey = 424;

    typedef ::AddressEntryInputMatchesData Data;

    AddressEntryInputMatchesDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressEntryInputMatchesDataBindingSource > AddressEntryInputMatchesDataItemMsg;

// =========================================================================

class GuidanceBlockUnblockButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 30;
    static const ::Courier::DataItemKey cDataItemKey = 469;

    typedef ::GuidanceBlockUnblockButtonData Data;

    GuidanceBlockUnblockButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< GuidanceBlockUnblockButtonDataBindingSource > GuidanceBlockUnblockButtonDataItemMsg;

// =========================================================================

class POICategoryRootItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 31;
    static const ::Courier::DataItemKey cDataItemKey = 165;

    typedef ::POICategoryRootItemData Data;

    POICategoryRootItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< POICategoryRootItemDataBindingSource > POICategoryRootItemDataItemMsg;

// =========================================================================

class ShowPOIsOnMapItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 32;
    static const ::Courier::DataItemKey cDataItemKey = 475;

    typedef ::ShowPOIsOnMapItemData Data;

    ShowPOIsOnMapItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< ShowPOIsOnMapItemDataBindingSource > ShowPOIsOnMapItemDataItemMsg;

// =========================================================================

class ShowRouteListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 33;
    static const ::Courier::DataItemKey cDataItemKey = 164;

    typedef ::ShowRouteListItemData Data;

    ShowRouteListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< ShowRouteListItemDataBindingSource > ShowRouteListItemDataItemMsg;

// =========================================================================

class BlockRouteListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 34;
    static const ::Courier::DataItemKey cDataItemKey = 247;

    typedef ::BlockRouteListItemData Data;

    BlockRouteListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< BlockRouteListItemDataBindingSource > BlockRouteListItemDataItemMsg;

// =========================================================================

class POICategoryListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 35;
    static const ::Courier::DataItemKey cDataItemKey = 130;

    typedef ::POICategoryListItemData Data;

    POICategoryListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< POICategoryListItemDataBindingSource > POICategoryListItemDataItemMsg;

// =========================================================================

class POIDetailedInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 36;
    static const ::Courier::DataItemKey cDataItemKey = 432;

    typedef ::POIDetailedInfoData Data;

    POIDetailedInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< POIDetailedInfoDataBindingSource > POIDetailedInfoDataItemMsg;

// =========================================================================

class POICategoryBrowseCheckDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 37;
    static const ::Courier::DataItemKey cDataItemKey = 53;

    typedef ::POICategoryBrowseCheckData Data;

    POICategoryBrowseCheckDataBindingSource();
};

typedef ::Courier::DataItemMsg< POICategoryBrowseCheckDataBindingSource > POICategoryBrowseCheckDataItemMsg;

// =========================================================================

class StoredLocationIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 38;
    static const ::Courier::DataItemKey cDataItemKey = 94;

    typedef ::StoredLocationIconData Data;

    StoredLocationIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< StoredLocationIconDataBindingSource > StoredLocationIconDataItemMsg;

// =========================================================================

class AddressDetailedInfoIconDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 39;
    static const ::Courier::DataItemKey cDataItemKey = 187;

    typedef ::AddressDetailedInfoIconData Data;

    AddressDetailedInfoIconDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressDetailedInfoIconDataBindingSource > AddressDetailedInfoIconDataItemMsg;

// =========================================================================

class AddressInputButtonVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 40;
    static const ::Courier::DataItemKey cDataItemKey = 166;

    typedef ::AddressInputButtonVisibilityData Data;

    AddressInputButtonVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< AddressInputButtonVisibilityDataBindingSource > AddressInputButtonVisibilityDataItemMsg;

// =========================================================================

class TrafficIconsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 41;
    static const ::Courier::DataItemKey cDataItemKey = 238;

    typedef ::TrafficIconsData Data;

    TrafficIconsDataBindingSource();
};

typedef ::Courier::DataItemMsg< TrafficIconsDataBindingSource > TrafficIconsDataItemMsg;

// =========================================================================

class GuidanceSettingsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 42;
    static const ::Courier::DataItemKey cDataItemKey = 455;

    typedef ::GuidanceSettingsData Data;

    GuidanceSettingsDataBindingSource();
};

typedef ::Courier::DataItemMsg< GuidanceSettingsDataBindingSource > GuidanceSettingsDataItemMsg;

// =========================================================================

class CheckBoxListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 43;
    static const ::Courier::DataItemKey cDataItemKey = 413;

    typedef ::CheckBoxListItemData Data;

    CheckBoxListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< CheckBoxListItemDataBindingSource > CheckBoxListItemDataItemMsg;

// =========================================================================

class RoutePreferenceCheckBoxListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 44;
    static const ::Courier::DataItemKey cDataItemKey = 215;

    typedef ::RoutePreferenceCheckBoxListItemData Data;

    RoutePreferenceCheckBoxListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< RoutePreferenceCheckBoxListItemDataBindingSource > RoutePreferenceCheckBoxListItemDataItemMsg;

// =========================================================================

class RoutePreferenceAdjustmentListItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 45;
    static const ::Courier::DataItemKey cDataItemKey = 182;

    typedef ::RoutePreferenceAdjustmentListItemData Data;

    RoutePreferenceAdjustmentListItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< RoutePreferenceAdjustmentListItemDataBindingSource > RoutePreferenceAdjustmentListItemDataItemMsg;

// =========================================================================

class NavigationGadgetInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 46;
    static const ::Courier::DataItemKey cDataItemKey = 468;

    typedef ::NavigationGadgetInfoData Data;

    NavigationGadgetInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< NavigationGadgetInfoDataBindingSource > NavigationGadgetInfoDataItemMsg;

// =========================================================================

class LatLongSpellerPressedKeyInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 47;
    static const ::Courier::DataItemKey cDataItemKey = 299;

    typedef ::LatLongSpellerPressedKeyInfoData Data;

    LatLongSpellerPressedKeyInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongSpellerPressedKeyInfoDataBindingSource > LatLongSpellerPressedKeyInfoDataItemMsg;

// =========================================================================

class LatLongSpellerTextReceivedDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 48;
    static const ::Courier::DataItemKey cDataItemKey = 380;

    typedef ::LatLongSpellerTextReceivedData Data;

    LatLongSpellerTextReceivedDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongSpellerTextReceivedDataBindingSource > LatLongSpellerTextReceivedDataItemMsg;

// =========================================================================

class LatLongEditFieldBGImageItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 49;
    static const ::Courier::DataItemKey cDataItemKey = 346;

    typedef ::LatLongEditFieldBGImageItemData Data;

    LatLongEditFieldBGImageItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongEditFieldBGImageItemDataBindingSource > LatLongEditFieldBGImageItemDataItemMsg;

// =========================================================================

class LatLongDataValuesDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 50;
    static const ::Courier::DataItemKey cDataItemKey = 306;

    typedef ::LatLongDataValuesData Data;

    LatLongDataValuesDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongDataValuesDataBindingSource > LatLongDataValuesDataItemMsg;

// =========================================================================

class LatLongCoordinatesDirectionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 51;
    static const ::Courier::DataItemKey cDataItemKey = 336;

    typedef ::LatLongCoordinatesDirectionData Data;

    LatLongCoordinatesDirectionDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongCoordinatesDirectionDataBindingSource > LatLongCoordinatesDirectionDataItemMsg;

// =========================================================================

class ToggleButtonTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 52;
    static const ::Courier::DataItemKey cDataItemKey = 209;

    typedef ::ToggleButtonTextData Data;

    ToggleButtonTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< ToggleButtonTextDataBindingSource > ToggleButtonTextDataItemMsg;

// =========================================================================

class LatLongCoordinatesFormatDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 53;
    static const ::Courier::DataItemKey cDataItemKey = 310;

    typedef ::LatLongCoordinatesFormatData Data;

    LatLongCoordinatesFormatDataBindingSource();
};

typedef ::Courier::DataItemMsg< LatLongCoordinatesFormatDataBindingSource > LatLongCoordinatesFormatDataItemMsg;

// =========================================================================

class EnableSetLatLongButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 54;
    static const ::Courier::DataItemKey cDataItemKey = 400;

    typedef ::EnableSetLatLongButtonData Data;

    EnableSetLatLongButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< EnableSetLatLongButtonDataBindingSource > EnableSetLatLongButtonDataItemMsg;

// =========================================================================

class PickFromMapDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 21;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 55;
    static const ::Courier::DataItemKey cDataItemKey = 39;

    typedef ::PickFromMapDataData Data;

    PickFromMapDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< PickFromMapDataDataBindingSource > PickFromMapDataDataItemMsg;

// =========================================================================

class EnableOkButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 56;
    static const ::Courier::DataItemKey cDataItemKey = 263;

    typedef ::EnableOkButtonData Data;

    EnableOkButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< EnableOkButtonDataBindingSource > EnableOkButtonDataItemMsg;

// =========================================================================

class EnablePhoneButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 57;
    static const ::Courier::DataItemKey cDataItemKey = 444;

    typedef ::EnablePhoneButtonData Data;

    EnablePhoneButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< EnablePhoneButtonDataBindingSource > EnablePhoneButtonDataItemMsg;

// =========================================================================

class EnableGuidanceButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 58;
    static const ::Courier::DataItemKey cDataItemKey = 480;

    typedef ::EnableGuidanceButtonData Data;

    EnableGuidanceButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< EnableGuidanceButtonDataBindingSource > EnableGuidanceButtonDataItemMsg;

// =========================================================================

class CompassButtonDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 59;
    static const ::Courier::DataItemKey cDataItemKey = 298;

    typedef ::CompassButtonData Data;

    CompassButtonDataBindingSource();
};

typedef ::Courier::DataItemMsg< CompassButtonDataBindingSource > CompassButtonDataItemMsg;

// =========================================================================

class MapoutScreenDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 60;
    static const ::Courier::DataItemKey cDataItemKey = 410;

    typedef ::MapoutScreenDataData Data;

    MapoutScreenDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapoutScreenDataDataBindingSource > MapoutScreenDataDataItemMsg;

// =========================================================================

class MapScreenDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 31;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 61;
    static const ::Courier::DataItemKey cDataItemKey = 384;

    typedef ::MapScreenDataData Data;

    MapScreenDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapScreenDataDataBindingSource > MapScreenDataDataItemMsg;

// =========================================================================

class SplitMapScreenDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 62;
    static const ::Courier::DataItemKey cDataItemKey = 176;

    typedef ::SplitMapScreenDataData Data;

    SplitMapScreenDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< SplitMapScreenDataDataBindingSource > SplitMapScreenDataDataItemMsg;

// =========================================================================

class MapMainScreenStateDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 63;
    static const ::Courier::DataItemKey cDataItemKey = 143;

    typedef ::MapMainScreenStateData Data;

    MapMainScreenStateDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapMainScreenStateDataBindingSource > MapMainScreenStateDataItemMsg;

// =========================================================================

class TurnListETAItemDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 64;
    static const ::Courier::DataItemKey cDataItemKey = 442;

    typedef ::TurnListETAItemData Data;

    TurnListETAItemDataBindingSource();
};

typedef ::Courier::DataItemMsg< TurnListETAItemDataBindingSource > TurnListETAItemDataItemMsg;

// =========================================================================

class ODRDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 65;
    static const ::Courier::DataItemKey cDataItemKey = 354;

    typedef ::ODRDataData Data;

    ODRDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< ODRDataDataBindingSource > ODRDataDataItemMsg;

// =========================================================================

class RouteOverviewBtnDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 66;
    static const ::Courier::DataItemKey cDataItemKey = 38;

    typedef ::RouteOverviewBtnData Data;

    RouteOverviewBtnDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteOverviewBtnDataBindingSource > RouteOverviewBtnDataItemMsg;

// =========================================================================

class MapSettingOthersListIDDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 67;
    static const ::Courier::DataItemKey cDataItemKey = 72;

    typedef ::MapSettingOthersListIDData Data;

    MapSettingOthersListIDDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapSettingOthersListIDDataBindingSource > MapSettingOthersListIDDataItemMsg;

// =========================================================================

class NaviBackButtonLevelDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 68;
    static const ::Courier::DataItemKey cDataItemKey = 266;

    typedef ::NaviBackButtonLevelData Data;

    NaviBackButtonLevelDataBindingSource();
};

typedef ::Courier::DataItemMsg< NaviBackButtonLevelDataBindingSource > NaviBackButtonLevelDataItemMsg;

// =========================================================================

class MapSettingsOthersTitleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 69;
    static const ::Courier::DataItemKey cDataItemKey = 149;

    typedef ::MapSettingsOthersTitleData Data;

    MapSettingsOthersTitleDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapSettingsOthersTitleDataBindingSource > MapSettingsOthersTitleDataItemMsg;

// =========================================================================

class ZoomBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 70;
    static const ::Courier::DataItemKey cDataItemKey = 23;

    typedef ::ZoomBarInfoData Data;

    ZoomBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ZoomBarInfoDataBindingSource > ZoomBarInfoDataItemMsg;

// =========================================================================

class MultiLinePopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 71;
    static const ::Courier::DataItemKey cDataItemKey = 138;

    typedef ::MultiLinePopupTextData Data;

    MultiLinePopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< MultiLinePopupTextDataBindingSource > MultiLinePopupTextDataItemMsg;

// =========================================================================

class SettingSliderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 72;
    static const ::Courier::DataItemKey cDataItemKey = 20;

    typedef ::SettingSliderData Data;

    SettingSliderDataBindingSource();
};

typedef ::Courier::DataItemMsg< SettingSliderDataBindingSource > SettingSliderDataItemMsg;

// =========================================================================

class WhereAmIScreenDataDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 73;
    static const ::Courier::DataItemKey cDataItemKey = 408;

    typedef ::WhereAmIScreenDataData Data;

    WhereAmIScreenDataDataBindingSource();
};

typedef ::Courier::DataItemMsg< WhereAmIScreenDataDataBindingSource > WhereAmIScreenDataDataItemMsg;

// =========================================================================

class WaypointListInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 74;
    static const ::Courier::DataItemKey cDataItemKey = 152;

    typedef ::WaypointListInfoData Data;

    WaypointListInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< WaypointListInfoDataBindingSource > WaypointListInfoDataItemMsg;

// =========================================================================

class GPSInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 16;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 75;
    static const ::Courier::DataItemKey cDataItemKey = 305;

    typedef ::GPSInfoData Data;

    GPSInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< GPSInfoDataBindingSource > GPSInfoDataItemMsg;

// =========================================================================

class SwitchindexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 76;
    static const ::Courier::DataItemKey cDataItemKey = 92;

    typedef ::SwitchindexData Data;

    SwitchindexDataBindingSource();
};

typedef ::Courier::DataItemMsg< SwitchindexDataBindingSource > SwitchindexDataItemMsg;

// =========================================================================

class LaneGuidanceDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 10;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 77;
    static const ::Courier::DataItemKey cDataItemKey = 453;

    typedef ::LaneGuidanceData Data;

    LaneGuidanceDataBindingSource();
};

typedef ::Courier::DataItemMsg< LaneGuidanceDataBindingSource > LaneGuidanceDataItemMsg;

// =========================================================================

class RouteGuidancetextImageUpdationDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 78;
    static const ::Courier::DataItemKey cDataItemKey = 63;

    typedef ::RouteGuidancetextImageUpdationData Data;

    RouteGuidancetextImageUpdationDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteGuidancetextImageUpdationDataBindingSource > RouteGuidancetextImageUpdationDataItemMsg;

// =========================================================================

class TrafficMessagesDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 79;
    static const ::Courier::DataItemKey cDataItemKey = 364;

    typedef ::TrafficMessagesData Data;

    TrafficMessagesDataBindingSource();
};

typedef ::Courier::DataItemMsg< TrafficMessagesDataBindingSource > TrafficMessagesDataItemMsg;

// =========================================================================

class POITitleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 80;
    static const ::Courier::DataItemKey cDataItemKey = 67;

    typedef ::POITitleData Data;

    POITitleDataBindingSource();
};

typedef ::Courier::DataItemMsg< POITitleDataBindingSource > POITitleDataItemMsg;

// =========================================================================

class POITopCategoryTitleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 81;
    static const ::Courier::DataItemKey cDataItemKey = 70;

    typedef ::POITopCategoryTitleData Data;

    POITopCategoryTitleDataBindingSource();
};

typedef ::Courier::DataItemMsg< POITopCategoryTitleDataBindingSource > POITopCategoryTitleDataItemMsg;

// =========================================================================

class PreviousDestCountDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 82;
    static const ::Courier::DataItemKey cDataItemKey = 425;

    typedef ::PreviousDestCountData Data;

    PreviousDestCountDataBindingSource();
};

typedef ::Courier::DataItemMsg< PreviousDestCountDataBindingSource > PreviousDestCountDataItemMsg;

// =========================================================================

class HeaderTimeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 83;
    static const ::Courier::DataItemKey cDataItemKey = 466;

    typedef ::HeaderTimeData Data;

    HeaderTimeDataBindingSource();
};

typedef ::Courier::DataItemMsg< HeaderTimeDataBindingSource > HeaderTimeDataItemMsg;

// =========================================================================

class HardRestrictionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 84;
    static const ::Courier::DataItemKey cDataItemKey = 155;

    typedef ::HardRestrictionData Data;

    HardRestrictionDataBindingSource();
};

typedef ::Courier::DataItemMsg< HardRestrictionDataBindingSource > HardRestrictionDataItemMsg;

// =========================================================================

class TimeDisplayDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 85;
    static const ::Courier::DataItemKey cDataItemKey = 31;

    typedef ::TimeDisplayData Data;

    TimeDisplayDataBindingSource();
};

typedef ::Courier::DataItemMsg< TimeDisplayDataBindingSource > TimeDisplayDataItemMsg;

// =========================================================================

class StreamMapContentDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 9;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 86;
    static const ::Courier::DataItemKey cDataItemKey = 146;

    typedef ::StreamMapContentData Data;

    StreamMapContentDataBindingSource();
};

typedef ::Courier::DataItemMsg< StreamMapContentDataBindingSource > StreamMapContentDataItemMsg;

// =========================================================================

class NavDataPopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 7;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 87;
    static const ::Courier::DataItemKey cDataItemKey = 342;

    typedef ::NavDataPopupTextData Data;

    NavDataPopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< NavDataPopupTextDataBindingSource > NavDataPopupTextDataItemMsg;

// =========================================================================

class AlternativeRouteItemsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 19;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 88;
    static const ::Courier::DataItemKey cDataItemKey = 274;

    typedef ::AlternativeRouteItemsData Data;

    AlternativeRouteItemsDataBindingSource();
};

typedef ::Courier::DataItemMsg< AlternativeRouteItemsDataBindingSource > AlternativeRouteItemsDataItemMsg;

// =========================================================================

class RouteSwitchbtnDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 89;
    static const ::Courier::DataItemKey cDataItemKey = 407;

    typedef ::RouteSwitchbtnData Data;

    RouteSwitchbtnDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteSwitchbtnDataBindingSource > RouteSwitchbtnDataItemMsg;

// =========================================================================

class GuidanceRouteSwitchbtnDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 90;
    static const ::Courier::DataItemKey cDataItemKey = 125;

    typedef ::GuidanceRouteSwitchbtnData Data;

    GuidanceRouteSwitchbtnDataBindingSource();
};

typedef ::Courier::DataItemMsg< GuidanceRouteSwitchbtnDataBindingSource > GuidanceRouteSwitchbtnDataItemMsg;

// =========================================================================

class TrafficDetourDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 8;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 91;
    static const ::Courier::DataItemKey cDataItemKey = 420;

    typedef ::TrafficDetourDetailsData Data;

    TrafficDetourDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< TrafficDetourDetailsDataBindingSource > TrafficDetourDetailsDataItemMsg;

// =========================================================================

class XUrgentTrafficMessageDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 5;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 92;
    static const ::Courier::DataItemKey cDataItemKey = 360;

    typedef ::XUrgentTrafficMessageData Data;

    XUrgentTrafficMessageDataBindingSource();
};

typedef ::Courier::DataItemMsg< XUrgentTrafficMessageDataBindingSource > XUrgentTrafficMessageDataItemMsg;

// =========================================================================

class EngineeringMenuDetailsDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 93;
    static const ::Courier::DataItemKey cDataItemKey = 223;

    typedef ::EngineeringMenuDetailsData Data;

    EngineeringMenuDetailsDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringMenuDetailsDataBindingSource > EngineeringMenuDetailsDataItemMsg;

// =========================================================================

class EngineeringMenuTitleDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 94;
    static const ::Courier::DataItemKey cDataItemKey = 355;

    typedef ::EngineeringMenuTitleData Data;

    EngineeringMenuTitleDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringMenuTitleDataBindingSource > EngineeringMenuTitleDataItemMsg;

// =========================================================================

class EngineeringMenuListCheckDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 3;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 95;
    static const ::Courier::DataItemKey cDataItemKey = 275;

    typedef ::EngineeringMenuListCheckData Data;

    EngineeringMenuListCheckDataBindingSource();
};

typedef ::Courier::DataItemMsg< EngineeringMenuListCheckDataBindingSource > EngineeringMenuListCheckDataItemMsg;

// =========================================================================

class VehicleProfileInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 15;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 96;
    static const ::Courier::DataItemKey cDataItemKey = 213;

    typedef ::VehicleProfileInfoData Data;

    VehicleProfileInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< VehicleProfileInfoDataBindingSource > VehicleProfileInfoDataItemMsg;

// =========================================================================

class StreamedMapSettingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 97;
    static const ::Courier::DataItemKey cDataItemKey = 229;

    typedef ::StreamedMapSettingData Data;

    StreamedMapSettingDataBindingSource();
};

typedef ::Courier::DataItemMsg< StreamedMapSettingDataBindingSource > StreamedMapSettingDataItemMsg;

// =========================================================================

class MyPOIsAvailabilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 98;
    static const ::Courier::DataItemKey cDataItemKey = 321;

    typedef ::MyPOIsAvailabilityData Data;

    MyPOIsAvailabilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< MyPOIsAvailabilityDataBindingSource > MyPOIsAvailabilityDataItemMsg;

// =========================================================================

class RouteOptionsBorderDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 99;
    static const ::Courier::DataItemKey cDataItemKey = 241;

    typedef ::RouteOptionsBorderData Data;

    RouteOptionsBorderDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteOptionsBorderDataBindingSource > RouteOptionsBorderDataItemMsg;

// =========================================================================

class RouteRestrictionsPopupTextDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 4;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 100;
    static const ::Courier::DataItemKey cDataItemKey = 161;

    typedef ::RouteRestrictionsPopupTextData Data;

    RouteRestrictionsPopupTextDataBindingSource();
};

typedef ::Courier::DataItemMsg< RouteRestrictionsPopupTextDataBindingSource > RouteRestrictionsPopupTextDataItemMsg;

// =========================================================================

class SoftRestrictionDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 101;
    static const ::Courier::DataItemKey cDataItemKey = 231;

    typedef ::SoftRestrictionData Data;

    SoftRestrictionDataBindingSource();
};

typedef ::Courier::DataItemMsg< SoftRestrictionDataBindingSource > SoftRestrictionDataItemMsg;

// =========================================================================

class MapOptionOthersSettingDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 102;
    static const ::Courier::DataItemKey cDataItemKey = 490;

    typedef ::MapOptionOthersSettingData Data;

    MapOptionOthersSettingDataBindingSource();
};

typedef ::Courier::DataItemMsg< MapOptionOthersSettingDataBindingSource > MapOptionOthersSettingDataItemMsg;

// =========================================================================

class SwitchVehicleParameterindexDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 103;
    static const ::Courier::DataItemKey cDataItemKey = 454;

    typedef ::SwitchVehicleParameterindexData Data;

    SwitchVehicleParameterindexDataBindingSource();
};

typedef ::Courier::DataItemMsg< SwitchVehicleParameterindexDataBindingSource > SwitchVehicleParameterindexDataItemMsg;

// =========================================================================

class VehicleProfileTypeDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 104;
    static const ::Courier::DataItemKey cDataItemKey = 37;

    typedef ::VehicleProfileTypeData Data;

    VehicleProfileTypeDataBindingSource();
};

typedef ::Courier::DataItemMsg< VehicleProfileTypeDataBindingSource > VehicleProfileTypeDataItemMsg;

// =========================================================================

class ListScrollBarInfoDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 105;
    static const ::Courier::DataItemKey cDataItemKey = 129;

    typedef ::ListScrollBarInfoData Data;

    ListScrollBarInfoDataBindingSource();
};

typedef ::Courier::DataItemMsg< ListScrollBarInfoDataBindingSource > ListScrollBarInfoDataItemMsg;

// =========================================================================

class CarModeVisibilityDataBindingSource : public ::Courier::Internal::AsyncModelBindingSource {
public:
    static const ::Courier::HierarchyNodeIndex cHierarchyNodeCount = 2;
    static const ::Courier::BindingSourceIndex cBindingSourceIndex = 106;
    static const ::Courier::DataItemKey cDataItemKey = 14;

    typedef ::CarModeVisibilityData Data;

    CarModeVisibilityDataBindingSource();
};

typedef ::Courier::DataItemMsg< CarModeVisibilityDataBindingSource > CarModeVisibilityDataItemMsg;

namespace ItemKey {
        static const ::Courier::DataItemKey InvalidItem = 0;
        static const ::Courier::DataItemKey PlaceInfoButtonsItem = 9;
        static const ::Courier::DataItemKey ChangeCountryButtonItem = 10;
        static const ::Courier::DataItemKey CarModeVisibilityItem = 14;
        static const ::Courier::DataItemKey DEDisableButtonItem = 16;
        static const ::Courier::DataItemKey SettingSliderItem = 20;
        static const ::Courier::DataItemKey ZoomBarInfoItem = 23;
        static const ::Courier::DataItemKey AddressInputValueItem = 25;
        static const ::Courier::DataItemKey TimeDisplayItem = 31;
        static const ::Courier::DataItemKey NaviSpellerInfoItem = 35;
        static const ::Courier::DataItemKey VehicleProfileTypeItem = 37;
        static const ::Courier::DataItemKey RouteOverviewBtnItem = 38;
        static const ::Courier::DataItemKey PickFromMapDataItem = 39;
        static const ::Courier::DataItemKey RoadIconsItem = 48;
        static const ::Courier::DataItemKey POICategoryBrowseCheckItem = 53;
        static const ::Courier::DataItemKey BTTetheringStateItem = 60;
        static const ::Courier::DataItemKey RouteGuidancetextImageUpdationItem = 63;
        static const ::Courier::DataItemKey POITitleItem = 67;
        static const ::Courier::DataItemKey POITopCategoryTitleItem = 70;
        static const ::Courier::DataItemKey MapSettingOthersListIDItem = 72;
        static const ::Courier::DataItemKey SwitchindexItem = 92;
        static const ::Courier::DataItemKey StoredLocationIconItem = 94;
        static const ::Courier::DataItemKey HlgImageDataItem = 95;
        static const ::Courier::DataItemKey GuidanceRouteSwitchbtnItem = 125;
        static const ::Courier::DataItemKey ListScrollBarInfoItem = 129;
        static const ::Courier::DataItemKey POICategoryListItemItem = 130;
        static const ::Courier::DataItemKey AddressEntryTitleTextItem = 136;
        static const ::Courier::DataItemKey MultiLinePopupTextItem = 138;
        static const ::Courier::DataItemKey SpellerPagesItem = 139;
        static const ::Courier::DataItemKey ThreeLinePopuptextItem = 141;
        static const ::Courier::DataItemKey MapMainScreenStateItem = 143;
        static const ::Courier::DataItemKey StreamMapContentItem = 146;
        static const ::Courier::DataItemKey MapSettingsOthersTitleItem = 149;
        static const ::Courier::DataItemKey WaypointListInfoItem = 152;
        static const ::Courier::DataItemKey HardRestrictionItem = 155;
        static const ::Courier::DataItemKey RouteRestrictionsPopupTextItem = 161;
        static const ::Courier::DataItemKey SignpostTextItem = 162;
        static const ::Courier::DataItemKey PlaceInfoDetailsItem = 163;
        static const ::Courier::DataItemKey ShowRouteListItemItem = 164;
        static const ::Courier::DataItemKey POICategoryRootItemItem = 165;
        static const ::Courier::DataItemKey AddressInputButtonVisibilityItem = 166;
        static const ::Courier::DataItemKey SplitMapScreenDataItem = 176;
        static const ::Courier::DataItemKey RoutePreferenceAdjustmentListItemItem = 182;
        static const ::Courier::DataItemKey AddressDetailedInfoIconItem = 187;
        static const ::Courier::DataItemKey FreeTextListItemItem = 190;
        static const ::Courier::DataItemKey VariantButtonItem = 203;
        static const ::Courier::DataItemKey ToggleButtonTextItem = 209;
        static const ::Courier::DataItemKey RouteInfoPopupTextItem = 210;
        static const ::Courier::DataItemKey VehicleProfileInfoItem = 213;
        static const ::Courier::DataItemKey PreviousDestinationValItem = 214;
        static const ::Courier::DataItemKey RoutePreferenceCheckBoxListItemItem = 215;
        static const ::Courier::DataItemKey EngineeringMenuDetailsItem = 223;
        static const ::Courier::DataItemKey StreamedMapSettingItem = 229;
        static const ::Courier::DataItemKey SoftRestrictionItem = 231;
        static const ::Courier::DataItemKey FourLinePopupTextItem = 234;
        static const ::Courier::DataItemKey TrafficIconsItem = 238;
        static const ::Courier::DataItemKey RouteOptionsBorderItem = 241;
        static const ::Courier::DataItemKey BlockRouteListItemItem = 247;
        static const ::Courier::DataItemKey EnableOkButtonItem = 263;
        static const ::Courier::DataItemKey NaviBackButtonLevelItem = 266;
        static const ::Courier::DataItemKey AlternativeRouteItemsItem = 274;
        static const ::Courier::DataItemKey EngineeringMenuListCheckItem = 275;
        static const ::Courier::DataItemKey SpellerTextInfoItem = 290;
        static const ::Courier::DataItemKey NaviMiddlewareStatusItem = 293;
        static const ::Courier::DataItemKey CompassButtonItem = 298;
        static const ::Courier::DataItemKey LatLongSpellerPressedKeyInfoItem = 299;
        static const ::Courier::DataItemKey TwoLinePopuptextItem = 303;
        static const ::Courier::DataItemKey GPSInfoItem = 305;
        static const ::Courier::DataItemKey LatLongDataValuesItem = 306;
        static const ::Courier::DataItemKey MultiLinePopuptextItem = 308;
        static const ::Courier::DataItemKey LatLongCoordinatesFormatItem = 310;
        static const ::Courier::DataItemKey SpellerEntryTextReceivedInfoItem = 313;
        static const ::Courier::DataItemKey MyPOIsAvailabilityItem = 321;
        static const ::Courier::DataItemKey LatLongCoordinatesDirectionItem = 336;
        static const ::Courier::DataItemKey NavDataPopupTextItem = 342;
        static const ::Courier::DataItemKey LatLongEditFieldBGImageItemItem = 346;
        static const ::Courier::DataItemKey ODRDataItem = 354;
        static const ::Courier::DataItemKey EngineeringMenuTitleItem = 355;
        static const ::Courier::DataItemKey XUrgentTrafficMessageItem = 360;
        static const ::Courier::DataItemKey TrafficMessagesItem = 364;
        static const ::Courier::DataItemKey MapModeItem = 375;
        static const ::Courier::DataItemKey LatLongSpellerTextReceivedItem = 380;
        static const ::Courier::DataItemKey MapScreenDataItem = 384;
        static const ::Courier::DataItemKey FiveLinePopupTextItem = 389;
        static const ::Courier::DataItemKey EnableSetLatLongButtonItem = 400;
        static const ::Courier::DataItemKey RouteSwitchbtnItem = 407;
        static const ::Courier::DataItemKey WhereAmIScreenDataItem = 408;
        static const ::Courier::DataItemKey MapoutScreenDataItem = 410;
        static const ::Courier::DataItemKey AddressInputValPOIItem = 412;
        static const ::Courier::DataItemKey CheckBoxListItemItem = 413;
        static const ::Courier::DataItemKey TrafficDetourDetailsItem = 420;
        static const ::Courier::DataItemKey AddressEntryInputMatchesItem = 424;
        static const ::Courier::DataItemKey PreviousDestCountItem = 425;
        static const ::Courier::DataItemKey POIDetailedInfoItem = 432;
        static const ::Courier::DataItemKey TurnListETAItemItem = 442;
        static const ::Courier::DataItemKey EnablePhoneButtonItem = 444;
        static const ::Courier::DataItemKey LaneGuidanceItem = 453;
        static const ::Courier::DataItemKey SwitchVehicleParameterindexItem = 454;
        static const ::Courier::DataItemKey GuidanceSettingsItem = 455;
        static const ::Courier::DataItemKey HeaderTimeItem = 466;
        static const ::Courier::DataItemKey NavigationGadgetInfoItem = 468;
        static const ::Courier::DataItemKey GuidanceBlockUnblockButtonItem = 469;
        static const ::Courier::DataItemKey ShowPOIsOnMapItemItem = 475;
        static const ::Courier::DataItemKey SpellerPressedKeyInfoItem = 477;
        static const ::Courier::DataItemKey EnableGuidanceButtonItem = 480;
        static const ::Courier::DataItemKey AddressInputValDetailsItem = 482;
        static const ::Courier::DataItemKey MapOptionOthersSettingItem = 490;

    namespace PlaceInfoButtons {
            static const ::Courier::DataItemKey GoHereVisibilityItem = 343;
    } // namespace PlaceInfoButtons

    namespace ChangeCountryButton {
            static const ::Courier::DataItemKey IsVisibleItem = 233;
            static const ::Courier::DataItemKey CountryIconItem = 46;
    } // namespace ChangeCountryButton

    namespace CarModeVisibility {
            static const ::Courier::DataItemKey VisibleStatusItem = 45;
    } // namespace CarModeVisibility

    namespace DEDisableButton {
            static const ::Courier::DataItemKey CityItem = 188;
            static const ::Courier::DataItemKey StreetItem = 219;
            static const ::Courier::DataItemKey InterSectionItem = 1;
            static const ::Courier::DataItemKey HousenumItem = 416;
            static const ::Courier::DataItemKey DetailsItem = 458;
            static const ::Courier::DataItemKey GuidanceItem = 40;
            static const ::Courier::DataItemKey POISearchItem = 261;
    } // namespace DEDisableButton

    namespace SettingSlider {
            static const ::Courier::DataItemKey IncreasableItem = 100;
            static const ::Courier::DataItemKey DecreasableItem = 153;
            static const ::Courier::DataItemKey CurrentValueItem = 81;
            static const ::Courier::DataItemKey ButtonIsActiveItem = 180;
    } // namespace SettingSlider

    namespace ZoomBarInfo {
            static const ::Courier::DataItemKey IsZoomTimerStartItem = 109;
            static const ::Courier::DataItemKey IsZoomBarDisplayedItem = 418;
    } // namespace ZoomBarInfo

    namespace AddressInputValue {
            static const ::Courier::DataItemKey CountryItem = 372;
            static const ::Courier::DataItemKey StateItem = 382;
            static const ::Courier::DataItemKey CityItem = 337;
            static const ::Courier::DataItemKey StreetItem = 258;
            static const ::Courier::DataItemKey HousenumItem = 22;
            static const ::Courier::DataItemKey IntersectionItem = 200;
    } // namespace AddressInputValue

    namespace TimeDisplay {
            static const ::Courier::DataItemKey HourItem = 386;
            static const ::Courier::DataItemKey MinuteItem = 327;
    } // namespace TimeDisplay

    namespace NaviSpellerInfo {
            static const ::Courier::DataItemKey CountryCodeItem = 110;
            static const ::Courier::DataItemKey LanguageCodeItem = 154;
    } // namespace NaviSpellerInfo

    namespace VehicleProfileType {
            static const ::Courier::DataItemKey ProfileItem = 334;
    } // namespace VehicleProfileType

    namespace RouteOverviewBtn {
            static const ::Courier::DataItemKey IsRouteOverviewBtnEnabledItem = 348;
    } // namespace RouteOverviewBtn

    namespace PickFromMapData {
            static const ::Courier::DataItemKey MapPickingImageItem = 148;
            static const ::Courier::DataItemKey MapPickingTypeItem = 324;
            static const ::Courier::DataItemKey MapPickingPhoneNumberItem = 373;
            static const ::Courier::DataItemKey SelectedRoadItem = 239;
            static const ::Courier::DataItemKey MapPickingInfoItem = 452;
            static const ::Courier::DataItemKey MapPickingNumberItem = 19;
            static const ::Courier::DataItemKey MapPickingSizeItem = 132;
            static const ::Courier::DataItemKey PhoneNumberAvailableItem = 392;
            static const ::Courier::DataItemKey IsValidLocationAvailableItem = 257;
            static const ::Courier::DataItemKey MapPickingInfoAvailableItem = 250;
            static const ::Courier::DataItemKey LineSwitchIndexItem = 7;
            static const ::Courier::DataItemKey FirstLineInfoItem = 371;
            static const ::Courier::DataItemKey SecondLineInfoItem = 489;
            static const ::Courier::DataItemKey EnablePreviousInfoArrowItem = 41;
            static const ::Courier::DataItemKey EnableNextInfoArrowItem = 383;
            static const ::Courier::DataItemKey CurrentAndTotalPageNumberDisplayItem = 297;
            static const ::Courier::DataItemKey WaypointNumberItem = 34;
            static const ::Courier::DataItemKey PickedDirectionItem = 202;
            static const ::Courier::DataItemKey PickedDistanceItem = 218;
            static const ::Courier::DataItemKey DetailPickingInfoItem = 352;
    } // namespace PickFromMapData

    namespace RoadIcons {
            static const ::Courier::DataItemKey RoadIconImageItem = 379;
    } // namespace RoadIcons

    namespace POICategoryBrowseCheck {
            static const ::Courier::DataItemKey POITopCategoryStatusItem = 356;
            static const ::Courier::DataItemKey POIResultListStatusItem = 42;
    } // namespace POICategoryBrowseCheck

    namespace BTTetheringState {
            static const ::Courier::DataItemKey TetheringIndexItem = 262;
    } // namespace BTTetheringState

    namespace RouteGuidancetextImageUpdation {
            static const ::Courier::DataItemKey TextItem = 174;
            static const ::Courier::DataItemKey Icon_NormalItem = 394;
            static const ::Courier::DataItemKey Icon_PressedItem = 183;
    } // namespace RouteGuidancetextImageUpdation

    namespace POITitle {
            static const ::Courier::DataItemKey POITitleValueItem = 131;
    } // namespace POITitle

    namespace POITopCategoryTitle {
            static const ::Courier::DataItemKey POITopCategoryTitleValueItem = 325;
    } // namespace POITopCategoryTitle

    namespace MapSettingOthersListID {
            static const ::Courier::DataItemKey ListIDItem = 235;
    } // namespace MapSettingOthersListID

    namespace Switchindex {
            static const ::Courier::DataItemKey IndexValueItem = 18;
    } // namespace Switchindex

    namespace StoredLocationIcon {
            static const ::Courier::DataItemKey LocationIconActiveBitmapItem = 2;
            static const ::Courier::DataItemKey LocationIconActiveFocusesBitmapItem = 456;
            static const ::Courier::DataItemKey LocationIconNormalBitmapItem = 106;
            static const ::Courier::DataItemKey LocationIconFocusedBitmapItem = 398;
            static const ::Courier::DataItemKey LocationIconPressedBitmapItem = 137;
            static const ::Courier::DataItemKey LocationNameInfoItem = 147;
    } // namespace StoredLocationIcon

    namespace HlgImageData {
            static const ::Courier::DataItemKey HlgImageItem = 108;
            static const ::Courier::DataItemKey HlgImageVisibleItem = 77;
            static const ::Courier::DataItemKey ToggleLaneGuidanceVisibilityItem = 103;
    } // namespace HlgImageData

    namespace GuidanceRouteSwitchbtn {
            static const ::Courier::DataItemKey ButtonIsActiveItem = 357;
            static const ::Courier::DataItemKey NaviIconNormalItem = 192;
            static const ::Courier::DataItemKey NaviIconPressedItem = 430;
            static const ::Courier::DataItemKey NaviIconDisabledItem = 415;
    } // namespace GuidanceRouteSwitchbtn

    namespace ListScrollBarInfo {
            static const ::Courier::DataItemKey EnabledItem = 443;
    } // namespace ListScrollBarInfo

    namespace POICategoryListItem {
            static const ::Courier::DataItemKey DirectionIconActiveBitmapItem = 55;
            static const ::Courier::DataItemKey DirectionIconActiveFocusesBitmapItem = 242;
            static const ::Courier::DataItemKey DirectionIconNormalBitmapItem = 411;
            static const ::Courier::DataItemKey DirectionIconFocusedBitmapItem = 177;
            static const ::Courier::DataItemKey DirectionIconPressedBitmapItem = 464;
            static const ::Courier::DataItemKey NameItem = 254;
            static const ::Courier::DataItemKey DistanceItem = 160;
            static const ::Courier::DataItemKey AddressItem = 269;
            static const ::Courier::DataItemKey VisibleItem = 367;
    } // namespace POICategoryListItem

    namespace AddressEntryTitleText {
            static const ::Courier::DataItemKey TitleValueItem = 473;
    } // namespace AddressEntryTitleText

    namespace MultiLinePopupText {
            static const ::Courier::DataItemKey ThreeLinePopupText1Item = 396;
            static const ::Courier::DataItemKey ThreeLinePopupText2Item = 433;
            static const ::Courier::DataItemKey ThreeLinePopupText3Item = 463;
    } // namespace MultiLinePopupText

    namespace SpellerPages {
            static const ::Courier::DataItemKey SpellerPageNumberItem = 252;
    } // namespace SpellerPages

    namespace ThreeLinePopuptext {
            static const ::Courier::DataItemKey TextLine1Item = 406;
            static const ::Courier::DataItemKey TextLine2Item = 159;
            static const ::Courier::DataItemKey TextLine3Item = 181;
    } // namespace ThreeLinePopuptext

    namespace MapMainScreenState {
            static const ::Courier::DataItemKey MapMainScreenStateValueItem = 387;
    } // namespace MapMainScreenState

    namespace StreamMapContent {
            static const ::Courier::DataItemKey LatitudeItem = 289;
            static const ::Courier::DataItemKey LongtitudeItem = 157;
            static const ::Courier::DataItemKey SpeedItem = 249;
            static const ::Courier::DataItemKey NextMajorStationItem = 409;
            static const ::Courier::DataItemKey IsLatitudeEnabledItem = 449;
            static const ::Courier::DataItemKey IsLongtitudeEnabledItem = 52;
            static const ::Courier::DataItemKey IsSpeedEnabledItem = 171;
            static const ::Courier::DataItemKey IsNextMajorStationEnabledItem = 362;
    } // namespace StreamMapContent

    namespace MapSettingsOthersTitle {
            static const ::Courier::DataItemKey MapOtherSettingsTitleValueItem = 57;
    } // namespace MapSettingsOthersTitle

    namespace WaypointListInfo {
            static const ::Courier::DataItemKey WaypointListItemItem = 172;
            static const ::Courier::DataItemKey WaypointNormalIconItem = 260;
            static const ::Courier::DataItemKey WaypointPressedIconItem = 419;
    } // namespace WaypointListInfo

    namespace HardRestriction {
            static const ::Courier::DataItemKey IsFullRGEnabledItem = 476;
    } // namespace HardRestriction

    namespace RouteRestrictionsPopupText {
            static const ::Courier::DataItemKey TextLine1Item = 333;
            static const ::Courier::DataItemKey TextLine2Item = 244;
            static const ::Courier::DataItemKey TextLine3Item = 270;
    } // namespace RouteRestrictionsPopupText

    namespace SignpostText {
            static const ::Courier::DataItemKey SignpostfirstlineItem = 68;
            static const ::Courier::DataItemKey SignpostsecondlineItem = 76;
            static const ::Courier::DataItemKey TextLinesColorItem = 450;
            static const ::Courier::DataItemKey BackgroundImageColorItem = 317;
            static const ::Courier::DataItemKey ExitNumberItem = 101;
            static const ::Courier::DataItemKey ExitNumberPositioningItem = 287;
            static const ::Courier::DataItemKey SignpostActiveItem = 481;
            static const ::Courier::DataItemKey ExitNumberExistsItem = 359;
            static const ::Courier::DataItemKey SignpostRegionTypeItem = 278;
            static const ::Courier::DataItemKey SignpostDirectionNameItem = 302;
            static const ::Courier::DataItemKey SignpostPositionItem = 224;
    } // namespace SignpostText

    namespace PlaceInfoDetails {
            static const ::Courier::DataItemKey NameItem = 319;
            static const ::Courier::DataItemKey AddressItem = 363;
            static const ::Courier::DataItemKey PhonenumberItem = 445;
            static const ::Courier::DataItemKey Line4Item = 126;
    } // namespace PlaceInfoDetails

    namespace ShowRouteListItem {
            static const ::Courier::DataItemKey RouteListItemItem = 226;
            static const ::Courier::DataItemKey DistanceInfoItem = 26;
            static const ::Courier::DataItemKey TurnIconActiveBitmapItem = 462;
            static const ::Courier::DataItemKey RoadIconActiveBitmapItem = 133;
            static const ::Courier::DataItemKey RouteSelectionActiveBitmapItem = 5;
            static const ::Courier::DataItemKey RouteList_BlockUnblockNormalIconItem = 264;
            static const ::Courier::DataItemKey RouteList_BlockUnblockPressedIconItem = 309;
    } // namespace ShowRouteListItem

    namespace POICategoryRootItem {
            static const ::Courier::DataItemKey IconNormalBitmapItem = 399;
            static const ::Courier::DataItemKey NameItem = 107;
    } // namespace POICategoryRootItem

    namespace AddressInputButtonVisibility {
            static const ::Courier::DataItemKey DetailInfoButtonVisibilityItem = 82;
            static const ::Courier::DataItemKey Guidance_HomeNormalIconEnabledItem = 390;
            static const ::Courier::DataItemKey Guidance_HomePressedIconEnabledItem = 167;
            static const ::Courier::DataItemKey Guidance_HomeIconDisabledItem = 448;
    } // namespace AddressInputButtonVisibility

    namespace SplitMapScreenData {
            static const ::Courier::DataItemKey LaneGuidanceSplitViewPositionItem = 304;
            static const ::Courier::DataItemKey EnableSplitMapItemsItem = 49;
    } // namespace SplitMapScreenData

    namespace RoutePreferenceAdjustmentListItem {
            static const ::Courier::DataItemKey RouteTypeOptionItem = 205;
            static const ::Courier::DataItemKey OptionValueItem = 461;
    } // namespace RoutePreferenceAdjustmentListItem

    namespace AddressDetailedInfoIcon {
            static const ::Courier::DataItemKey Fav_EditNormalIconItem = 272;
            static const ::Courier::DataItemKey Fav_EditPressedIconItem = 86;
            static const ::Courier::DataItemKey DeleteIconButtonVisibilityItem = 32;
            static const ::Courier::DataItemKey DeleteAllIconButtonVisibilityItem = 281;
    } // namespace AddressDetailedInfoIcon

    namespace FreeTextListItem {
            static const ::Courier::DataItemKey NameItem = 404;
    } // namespace FreeTextListItem

    namespace VariantButton {
            static const ::Courier::DataItemKey VisibleCountryItem = 340;
            static const ::Courier::DataItemKey VisibleStateItem = 212;
            static const ::Courier::DataItemKey VisibleProvinceItem = 472;
    } // namespace VariantButton

    namespace ToggleButtonText {
            static const ::Courier::DataItemKey SouthNorthButtonTextItem = 366;
            static const ::Courier::DataItemKey EastWestButtonTextItem = 421;
    } // namespace ToggleButtonText

    namespace RouteInfoPopupText {
            static const ::Courier::DataItemKey TextLine1Item = 105;
            static const ::Courier::DataItemKey TextLine2Item = 228;
    } // namespace RouteInfoPopupText

    namespace VehicleProfileInfo {
            static const ::Courier::DataItemKey PositionItem = 423;
            static const ::Courier::DataItemKey LengthItem = 134;
            static const ::Courier::DataItemKey HeightItem = 33;
            static const ::Courier::DataItemKey WidthItem = 316;
            static const ::Courier::DataItemKey TotalWeightItem = 85;
            static const ::Courier::DataItemKey TrailerTypeItem = 30;
            static const ::Courier::DataItemKey MaxSpeedItem = 80;
            static const ::Courier::DataItemKey GoodsTypeItem = 339;
            static const ::Courier::DataItemKey LoadPerAxleItem = 485;
            static const ::Courier::DataItemKey IsTruckTypeItem = 119;
            static const ::Courier::DataItemKey CoachActiveItem = 29;
            static const ::Courier::DataItemKey CarActiveItem = 296;
            static const ::Courier::DataItemKey IconNormalBitmapItem = 243;
            static const ::Courier::DataItemKey IconPressedBitmapItem = 405;
    } // namespace VehicleProfileInfo

    namespace PreviousDestinationVal {
            static const ::Courier::DataItemKey POIaddressItem = 59;
    } // namespace PreviousDestinationVal

    namespace RoutePreferenceCheckBoxListItem {
            static const ::Courier::DataItemKey CheckBoxStatusItem = 196;
    } // namespace RoutePreferenceCheckBoxListItem

    namespace EngineeringMenuDetails {
            static const ::Courier::DataItemKey EngineeringMenuTextDetailsItem = 104;
            static const ::Courier::DataItemKey IsDemoModeEnabledItem = 185;
    } // namespace EngineeringMenuDetails

    namespace StreamedMapSetting {
            static const ::Courier::DataItemKey StreamedMapTypeSettingStatusItem = 488;
    } // namespace StreamedMapSetting

    namespace SoftRestriction {
            static const ::Courier::DataItemKey IsSoftPhysicalRestrictionItem = 36;
    } // namespace SoftRestriction

    namespace FourLinePopupText {
            static const ::Courier::DataItemKey MultiLineTextItem = 198;
    } // namespace FourLinePopupText

    namespace TrafficIcons {
            static const ::Courier::DataItemKey TrafficIconNameItem = 236;
            static const ::Courier::DataItemKey TrafficIconImageItem = 474;
            static const ::Courier::DataItemKey ToggleIconSwitchIndexItem = 300;
    } // namespace TrafficIcons

    namespace RouteOptionsBorder {
            static const ::Courier::DataItemKey FastestIconItem = 208;
            static const ::Courier::DataItemKey ShortestIconItem = 393;
            static const ::Courier::DataItemKey OptimisedIconItem = 471;
    } // namespace RouteOptionsBorder

    namespace BlockRouteListItem {
            static const ::Courier::DataItemKey RecalcEnableDisableItem = 245;
            static const ::Courier::DataItemKey RecalculateIconItem = 446;
    } // namespace BlockRouteListItem

    namespace EnableOkButton {
            static const ::Courier::DataItemKey IsOKButtonVisibleItem = 388;
            static const ::Courier::DataItemKey NaviIconNormalItem = 259;
            static const ::Courier::DataItemKey NaviIconPressedItem = 78;
            static const ::Courier::DataItemKey IsCarModeNaviIconVisibleItem = 344;
    } // namespace EnableOkButton

    namespace NaviBackButtonLevel {
            static const ::Courier::DataItemKey BackButtonLevelItem = 54;
    } // namespace NaviBackButtonLevel

    namespace AlternativeRouteItems {
            static const ::Courier::DataItemKey DistanceToDestinationFirstItem = 113;
            static const ::Courier::DataItemKey DistanceToDestinationSecondItem = 288;
            static const ::Courier::DataItemKey DistanceToDestinationThirdItem = 428;
            static const ::Courier::DataItemKey TimeToDestinationFirstItem = 64;
            static const ::Courier::DataItemKey TimeToDestinationSecondItem = 320;
            static const ::Courier::DataItemKey TimeToDestinationThirdItem = 194;
            static const ::Courier::DataItemKey MoreRouteFirstBtnActiveItem = 65;
            static const ::Courier::DataItemKey MoreRouteSecondBtnActiveItem = 221;
            static const ::Courier::DataItemKey MoreRouteThirdBtnActiveItem = 335;
            static const ::Courier::DataItemKey MoreRouteFirstBtnEnabledItem = 256;
            static const ::Courier::DataItemKey MoreRouteSecondBtnEnabledItem = 61;
            static const ::Courier::DataItemKey MoreRouteThirdBtnEnabledItem = 251;
            static const ::Courier::DataItemKey MoreRouteFirstBtnLoadingItem = 273;
            static const ::Courier::DataItemKey MoreRouteSecondBtnLoadingItem = 326;
            static const ::Courier::DataItemKey MoreRouteThirdBtnLoadingItem = 436;
            static const ::Courier::DataItemKey MoreRouteFirstBtnTouchableItem = 158;
            static const ::Courier::DataItemKey MoreRouteSecondBtnTouchableItem = 222;
            static const ::Courier::DataItemKey MoreRouteThirdBtnTouchableItem = 13;
    } // namespace AlternativeRouteItems

    namespace EngineeringMenuListCheck {
            static const ::Courier::DataItemKey EngineeringMenuListStatusItem = 253;
            static const ::Courier::DataItemKey EngineeringMenuTopListStatusItem = 365;
    } // namespace EngineeringMenuListCheck

    namespace SpellerTextInfo {
            static const ::Courier::DataItemKey TextItem = 184;
    } // namespace SpellerTextInfo

    namespace NaviMiddlewareStatus {
            static const ::Courier::DataItemKey IsNaviMiddlewareActiveItem = 271;
    } // namespace NaviMiddlewareStatus

    namespace CompassButton {
            static const ::Courier::DataItemKey CompassOrientationItem = 284;
    } // namespace CompassButton

    namespace LatLongSpellerPressedKeyInfo {
            static const ::Courier::DataItemKey PressedKey_LatLongEditFieldItem = 98;
    } // namespace LatLongSpellerPressedKeyInfo

    namespace TwoLinePopuptext {
            static const ::Courier::DataItemKey PopuptextLine1Item = 381;
            static const ::Courier::DataItemKey PopuptextLine2Item = 345;
    } // namespace TwoLinePopuptext

    namespace GPSInfo {
            static const ::Courier::DataItemKey DateValueItem = 90;
            static const ::Courier::DataItemKey AltitudeValueItem = 83;
            static const ::Courier::DataItemKey CapturedSatelliteNumberItem = 276;
            static const ::Courier::DataItemKey SearchingSatelliteNumberItem = 120;
            static const ::Courier::DataItemKey GnssModeTypeItem = 193;
            static const ::Courier::DataItemKey LatViaSensorItem = 438;
            static const ::Courier::DataItemKey LongViaSensorItem = 114;
            static const ::Courier::DataItemKey VisibleSatelliteItem = 175;
            static const ::Courier::DataItemKey GNSSTypeInfoItem = 204;
            static const ::Courier::DataItemKey TimeInfoItem = 189;
            static const ::Courier::DataItemKey HeadingInfoItem = 429;
            static const ::Courier::DataItemKey GPSCoordinateItem = 206;
            static const ::Courier::DataItemKey GPSUnAvailableItem = 248;
            static const ::Courier::DataItemKey SatelliteIconItem = 323;
            static const ::Courier::DataItemKey SatelliteIconVisibilityItem = 431;
    } // namespace GPSInfo

    namespace LatLongDataValues {
            static const ::Courier::DataItemKey LatDegreesInputValuesItem = 73;
            static const ::Courier::DataItemKey LongDegreesInputValuesItem = 51;
            static const ::Courier::DataItemKey LatMinutesInputValuesItem = 74;
            static const ::Courier::DataItemKey LongMinutesInputValuesItem = 230;
            static const ::Courier::DataItemKey LatSecondsInputValuesItem = 467;
            static const ::Courier::DataItemKey LongSecondsInputValuesItem = 350;
            static const ::Courier::DataItemKey LatDecimalsInputValuesItem = 50;
            static const ::Courier::DataItemKey LongDecimalsInputValuesItem = 3;
    } // namespace LatLongDataValues

    namespace MultiLinePopuptext {
            static const ::Courier::DataItemKey TextLine1Item = 150;
            static const ::Courier::DataItemKey TextLine2Item = 47;
    } // namespace MultiLinePopuptext

    namespace LatLongCoordinatesFormat {
            static const ::Courier::DataItemKey LatLongFormatIndexItem = 220;
    } // namespace LatLongCoordinatesFormat

    namespace SpellerEntryTextReceivedInfo {
            static const ::Courier::DataItemKey EntryTextItem = 21;
            static const ::Courier::DataItemKey SuggestedTextItem = 460;
            static const ::Courier::DataItemKey ValidCharItem = 232;
            static const ::Courier::DataItemKey MatchesItem = 440;
            static const ::Courier::DataItemKey EnteredCharItem = 8;
            static const ::Courier::DataItemKey CandidateListVisibilityItem = 186;
            static const ::Courier::DataItemKey StateNameVisibilityItem = 268;
    } // namespace SpellerEntryTextReceivedInfo

    namespace MyPOIsAvailability {
            static const ::Courier::DataItemKey IsMyPOIsAvailableItem = 465;
    } // namespace MyPOIsAvailability

    namespace LatLongCoordinatesDirection {
            static const ::Courier::DataItemKey NorthSouthEditFieldTxtItem = 427;
            static const ::Courier::DataItemKey EastWestEditFieldTxtItem = 11;
            static const ::Courier::DataItemKey NorthSouthButtonTxtItem = 27;
            static const ::Courier::DataItemKey EastWestButtonTxtItem = 478;
            static const ::Courier::DataItemKey ActiveNorthSouthEditFieldItem = 75;
            static const ::Courier::DataItemKey ActiveEastWestEditFieldItem = 347;
    } // namespace LatLongCoordinatesDirection

    namespace NavDataPopupText {
            static const ::Courier::DataItemKey CurrentNavDataVersionItem = 89;
            static const ::Courier::DataItemKey NewNavDataVersionItem = 451;
            static const ::Courier::DataItemKey EstimatedUpdateTimeItem = 237;
            static const ::Courier::DataItemKey RemainingTimeItem = 145;
            static const ::Courier::DataItemKey ErrorMsgLine1Item = 99;
            static const ::Courier::DataItemKey ProgressValueItem = 265;
    } // namespace NavDataPopupText

    namespace LatLongEditFieldBGImageItem {
            static const ::Courier::DataItemKey LatitudeDegreesBGBitmapItem = 15;
            static const ::Courier::DataItemKey LatitudeMinutesBGBitmapItem = 58;
            static const ::Courier::DataItemKey LatitudeSecondsBGBitmapItem = 87;
            static const ::Courier::DataItemKey LatitudeDecimalsBGBitmapItem = 225;
            static const ::Courier::DataItemKey LongitudeDegreesBGBitmapItem = 97;
            static const ::Courier::DataItemKey LongitudeMinutesBGBitmapItem = 255;
            static const ::Courier::DataItemKey LongitudeSecondsBGBitmapItem = 361;
            static const ::Courier::DataItemKey LongitudeDecimalsBGBitmapItem = 66;
    } // namespace LatLongEditFieldBGImageItem

    namespace ODRData {
            static const ::Courier::DataItemKey TurnToStreetItem = 311;
            static const ::Courier::DataItemKey TurnToStreetWithDistanceItem = 217;
            static const ::Courier::DataItemKey DistanceToManeuverItem = 483;
            static const ::Courier::DataItemKey DistanceToManeuverUnitItem = 402;
            static const ::Courier::DataItemKey ManeuverBargraphValueItem = 43;
            static const ::Courier::DataItemKey ShowManeuverBargraphItem = 377;
            static const ::Courier::DataItemKey ManeuverSymbolIndexItem = 328;
    } // namespace ODRData

    namespace EngineeringMenuTitle {
            static const ::Courier::DataItemKey TitleDetailItem = 331;
    } // namespace EngineeringMenuTitle

    namespace XUrgentTrafficMessage {
            static const ::Courier::DataItemKey TrafficIncidentIconItem = 295;
            static const ::Courier::DataItemKey DirectionItem = 447;
            static const ::Courier::DataItemKey DistanceItem = 197;
            static const ::Courier::DataItemKey DetailsItem = 349;
    } // namespace XUrgentTrafficMessage

    namespace TrafficMessages {
            static const ::Courier::DataItemKey TrafficMessageTextItem = 17;
            static const ::Courier::DataItemKey DistanceInfoItem = 417;
            static const ::Courier::DataItemKey DirectionIconActiveBitmapItem = 123;
            static const ::Courier::DataItemKey TrafficIconActiveBitmapItem = 280;
    } // namespace TrafficMessages

    namespace MapMode {
            static const ::Courier::DataItemKey IsDayModeActiveItem = 422;
    } // namespace MapMode

    namespace LatLongSpellerTextReceived {
            static const ::Courier::DataItemKey TextReceive_LatLongEditFieldItem = 4;
    } // namespace LatLongSpellerTextReceived

    namespace MapScreenData {
            static const ::Courier::DataItemKey PickingResultLatitudeLongitudeItem = 370;
            static const ::Courier::DataItemKey CurrentStreetItem = 117;
            static const ::Courier::DataItemKey CurrentCityItem = 391;
            static const ::Courier::DataItemKey DistanceToDestinationItem = 240;
            static const ::Courier::DataItemKey TimeToDestinationItem = 414;
            static const ::Courier::DataItemKey ArrivalTimeToBeShownOnMapItem = 486;
            static const ::Courier::DataItemKey ETATextLabelValueItem = 111;
            static const ::Courier::DataItemKey CompassArrowDirectionItem = 56;
            static const ::Courier::DataItemKey CompassArrowDirectionIconItem = 397;
            static const ::Courier::DataItemKey ZoomLevelItem = 121;
            static const ::Courier::DataItemKey ZoomSliderCurrentValueItem = 216;
            static const ::Courier::DataItemKey SecMapCompassArrowDirectionIconItem = 69;
            static const ::Courier::DataItemKey SecZoomLevelItem = 6;
            static const ::Courier::DataItemKey ScaleImageSwitchItem = 318;
            static const ::Courier::DataItemKey SpeedLimitItem = 199;
            static const ::Courier::DataItemKey isSpeedLimitPresentItem = 315;
            static const ::Courier::DataItemKey isOverSpeedWarningItem = 211;
            static const ::Courier::DataItemKey SpeedlimitWithUnitItem = 195;
            static const ::Courier::DataItemKey SpeedcountryCodeItem = 435;
            static const ::Courier::DataItemKey SpeedLimitIconPositionItem = 151;
            static const ::Courier::DataItemKey ShowMapActiveRGButtonsItem = 286;
            static const ::Courier::DataItemKey StartShowMapActiveRGButtonTimerItem = 156;
            static const ::Courier::DataItemKey IsGuidanceVoiceEnabledItem = 341;
            static const ::Courier::DataItemKey MuteUnmuteTextItem = 127;
            static const ::Courier::DataItemKey MuteUnmuteNormalIconItem = 353;
            static const ::Courier::DataItemKey MuteUnmutePressedIconItem = 169;
            static const ::Courier::DataItemKey MuteUnmuteDisabledIconItem = 282;
            static const ::Courier::DataItemKey NaviGadgetIconItem = 24;
            static const ::Courier::DataItemKey MapActiveRGNaviIconNormalItem = 312;
            static const ::Courier::DataItemKey MapActiveRGNaviIconPressedItem = 434;
    } // namespace MapScreenData

    namespace FiveLinePopupText {
            static const ::Courier::DataItemKey PopupTextLine1Item = 283;
            static const ::Courier::DataItemKey PopupTextLine2Item = 291;
            static const ::Courier::DataItemKey PopupTextLine3Item = 179;
            static const ::Courier::DataItemKey PopupTextLine4Item = 470;
            static const ::Courier::DataItemKey PopupTextLine5Item = 84;
    } // namespace FiveLinePopupText

    namespace EnableSetLatLongButton {
            static const ::Courier::DataItemKey IsButtonVisibleItem = 332;
            static const ::Courier::DataItemKey IsPopUpVisibleItem = 91;
    } // namespace EnableSetLatLongButton

    namespace RouteSwitchbtn {
            static const ::Courier::DataItemKey IsAlternativeRouteBtnEnabledItem = 267;
    } // namespace RouteSwitchbtn

    namespace WhereAmIScreenData {
            static const ::Courier::DataItemKey CurrentStreetInfoItem = 135;
            static const ::Courier::DataItemKey CurrentCityInfoItem = 439;
            static const ::Courier::DataItemKey CurrentStreetRoadNrImageItem = 351;
    } // namespace WhereAmIScreenData

    namespace MapoutScreenData {
            static const ::Courier::DataItemKey ETADestinationItem = 459;
            static const ::Courier::DataItemKey ETAWaypointItem = 128;
            static const ::Courier::DataItemKey IsWaypointPresentItem = 401;
            static const ::Courier::DataItemKey ShowEtaItem = 93;
            static const ::Courier::DataItemKey DurationCabinOnlyItem = 294;
            static const ::Courier::DataItemKey ETACabinOnlyItem = 329;
            static const ::Courier::DataItemKey ShowEtaDurationCabinOnlyItem = 207;
    } // namespace MapoutScreenData

    namespace AddressInputValPOI {
            static const ::Courier::DataItemKey CountryItem = 118;
            static const ::Courier::DataItemKey CityItem = 178;
            static const ::Courier::DataItemKey POISearchItem = 201;
    } // namespace AddressInputValPOI

    namespace CheckBoxListItem {
            static const ::Courier::DataItemKey ListItemNameItem = 441;
            static const ::Courier::DataItemKey ToggleIconSwitchIndexItem = 338;
    } // namespace CheckBoxListItem

    namespace TrafficDetourDetails {
            static const ::Courier::DataItemKey TimeDifferenceItem = 292;
            static const ::Courier::DataItemKey DistanceDifferenceItem = 437;
            static const ::Courier::DataItemKey DistanceToTrafficItem = 28;
            static const ::Courier::DataItemKey TrafficIncidentDetailsItem = 277;
            static const ::Courier::DataItemKey TrafficIncidentNameItem = 491;
            static const ::Courier::DataItemKey TrafficIncidentIconItem = 279;
            static const ::Courier::DataItemKey HasTrafficMessageDescriptionItem = 142;
    } // namespace TrafficDetourDetails

    namespace AddressEntryInputMatches {
            static const ::Courier::DataItemKey NoOfMatchesItem = 285;
    } // namespace AddressEntryInputMatches

    namespace PreviousDestCount {
            static const ::Courier::DataItemKey TotalPreviousDestCountItem = 457;
    } // namespace PreviousDestCount

    namespace POIDetailedInfo {
            static const ::Courier::DataItemKey NameItem = 301;
            static const ::Courier::DataItemKey AddressItem = 374;
    } // namespace POIDetailedInfo

    namespace TurnListETAItem {
            static const ::Courier::DataItemKey DistanceToDestinationItem = 403;
            static const ::Courier::DataItemKey TimeToDestinationItem = 170;
            static const ::Courier::DataItemKey DestinationNameItem = 369;
    } // namespace TurnListETAItem

    namespace EnablePhoneButton {
            static const ::Courier::DataItemKey IsPhoneButtonVisibleItem = 330;
    } // namespace EnablePhoneButton

    namespace LaneGuidance {
            static const ::Courier::DataItemKey BitmapImage1Item = 122;
            static const ::Courier::DataItemKey BitmapImage2Item = 88;
            static const ::Courier::DataItemKey BitmapImage3Item = 173;
            static const ::Courier::DataItemKey BitmapImage4Item = 426;
            static const ::Courier::DataItemKey BitmapImage5Item = 385;
            static const ::Courier::DataItemKey BitmapImage6Item = 227;
            static const ::Courier::DataItemKey BitmapImage7Item = 307;
            static const ::Courier::DataItemKey BitmapImage8Item = 378;
            static const ::Courier::DataItemKey HovOccupancyItem = 479;
    } // namespace LaneGuidance

    namespace SwitchVehicleParameterindex {
            static const ::Courier::DataItemKey IndexValueItem = 246;
    } // namespace SwitchVehicleParameterindex

    namespace GuidanceSettings {
            static const ::Courier::DataItemKey CurrentGuidanceVolumeItem = 124;
            static const ::Courier::DataItemKey GuidanceVoiceStatusItem = 358;
            static const ::Courier::DataItemKey TrafficAnnouncementStatusItem = 79;
            static const ::Courier::DataItemKey TollBothGuideStatusItem = 376;
    } // namespace GuidanceSettings

    namespace HeaderTime {
            static const ::Courier::DataItemKey TextItem = 44;
    } // namespace HeaderTime

    namespace NavigationGadgetInfo {
            static const ::Courier::DataItemKey IsGuidanceActiveItem = 395;
            static const ::Courier::DataItemKey HomeTileStreetStrItem = 144;
    } // namespace NavigationGadgetInfo

    namespace GuidanceBlockUnblockButton {
            static const ::Courier::DataItemKey BlockUnblockTextItem = 168;
            static const ::Courier::DataItemKey BlockUnblockNormalIconItem = 322;
            static const ::Courier::DataItemKey BlockUnblockPressedIconItem = 314;
            static const ::Courier::DataItemKey BlockUnblockEnableItem = 112;
    } // namespace GuidanceBlockUnblockButton

    namespace ShowPOIsOnMapItem {
            static const ::Courier::DataItemKey IconNormalBitmapItem = 115;
    } // namespace ShowPOIsOnMapItem

    namespace SpellerPressedKeyInfo {
            static const ::Courier::DataItemKey PressedKeyItem = 12;
    } // namespace SpellerPressedKeyInfo

    namespace EnableGuidanceButton {
            static const ::Courier::DataItemKey IsGuidanceButtonVisibleItem = 484;
            static const ::Courier::DataItemKey IsFavButtonVisibleItem = 102;
            static const ::Courier::DataItemKey BackButtonLevelIndexItem = 368;
            static const ::Courier::DataItemKey IsCarModeNaviIconVisibleItem = 191;
    } // namespace EnableGuidanceButton

    namespace AddressInputValDetails {
            static const ::Courier::DataItemKey Line1Item = 71;
            static const ::Courier::DataItemKey Line2Item = 487;
            static const ::Courier::DataItemKey Line3Item = 140;
            static const ::Courier::DataItemKey Line4Item = 96;
            static const ::Courier::DataItemKey POIAmbiguousDetails2Item = 62;
    } // namespace AddressInputValDetails

    namespace MapOptionOthersSetting {
            static const ::Courier::DataItemKey MapOptionOthersSettingStatusItem = 116;
    } // namespace MapOptionOthersSetting
} // namespace ItemKey

bool InitDataBinding();

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SignpostTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SignpostTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HlgImageDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HlgImageDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RoadIconsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RoadIconsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapModeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapModeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BTTetheringStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BTTetheringStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressInputValueDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressInputValueDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ChangeCountryButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ChangeCountryButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PreviousDestinationValDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PreviousDestinationValDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VariantButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VariantButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::DEDisableButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::DEDisableButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressInputValPOIDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressInputValPOIDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressInputValDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressInputValDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaceInfoButtonsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaceInfoButtonsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PlaceInfoDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PlaceInfoDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TwoLinePopuptextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TwoLinePopuptextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MultiLinePopuptextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MultiLinePopuptextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ThreeLinePopuptextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ThreeLinePopuptextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteInfoPopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteInfoPopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FourLinePopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FourLinePopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FiveLinePopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FiveLinePopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerPressedKeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerPressedKeyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerPagesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerPagesDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerTextInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerTextInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NaviSpellerInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NaviSpellerInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressEntryTitleTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressEntryTitleTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NaviMiddlewareStatusDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NaviMiddlewareStatusDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::FreeTextListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::FreeTextListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SpellerEntryTextReceivedInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SpellerEntryTextReceivedInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressEntryInputMatchesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressEntryInputMatchesDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GuidanceBlockUnblockButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GuidanceBlockUnblockButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POICategoryRootItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POICategoryRootItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ShowPOIsOnMapItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ShowPOIsOnMapItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ShowRouteListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ShowRouteListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::BlockRouteListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::BlockRouteListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POICategoryListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POICategoryListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POIDetailedInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POIDetailedInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POICategoryBrowseCheckDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POICategoryBrowseCheckDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StoredLocationIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StoredLocationIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressDetailedInfoIconDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressDetailedInfoIconDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AddressInputButtonVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AddressInputButtonVisibilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TrafficIconsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TrafficIconsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GuidanceSettingsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GuidanceSettingsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CheckBoxListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RoutePreferenceCheckBoxListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RoutePreferenceCheckBoxListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RoutePreferenceAdjustmentListItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RoutePreferenceAdjustmentListItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NavigationGadgetInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NavigationGadgetInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongSpellerPressedKeyInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongSpellerPressedKeyInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongSpellerTextReceivedDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongSpellerTextReceivedDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongEditFieldBGImageItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongEditFieldBGImageItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongDataValuesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongDataValuesDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongCoordinatesDirectionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongCoordinatesDirectionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ToggleButtonTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ToggleButtonTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LatLongCoordinatesFormatDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LatLongCoordinatesFormatDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EnableSetLatLongButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EnableSetLatLongButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PickFromMapDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PickFromMapDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EnableOkButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EnableOkButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EnablePhoneButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EnablePhoneButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EnableGuidanceButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EnableGuidanceButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CompassButtonDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CompassButtonDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapoutScreenDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapoutScreenDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapScreenDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapScreenDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SplitMapScreenDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SplitMapScreenDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapMainScreenStateDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapMainScreenStateDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TurnListETAItemDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TurnListETAItemDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ODRDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ODRDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteOverviewBtnDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteOverviewBtnDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapSettingOthersListIDDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapSettingOthersListIDDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NaviBackButtonLevelDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NaviBackButtonLevelDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapSettingsOthersTitleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapSettingsOthersTitleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ZoomBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ZoomBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MultiLinePopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MultiLinePopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SettingSliderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SettingSliderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WhereAmIScreenDataDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WhereAmIScreenDataDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::WaypointListInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::WaypointListInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GPSInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GPSInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwitchindexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwitchindexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::LaneGuidanceDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::LaneGuidanceDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteGuidancetextImageUpdationDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteGuidancetextImageUpdationDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TrafficMessagesDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TrafficMessagesDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POITitleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POITitleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::POITopCategoryTitleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::POITopCategoryTitleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::PreviousDestCountDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::PreviousDestCountDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HeaderTimeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HeaderTimeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::HardRestrictionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::HardRestrictionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TimeDisplayDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TimeDisplayDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StreamMapContentDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StreamMapContentDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::NavDataPopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::NavDataPopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::AlternativeRouteItemsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::AlternativeRouteItemsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteSwitchbtnDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteSwitchbtnDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::GuidanceRouteSwitchbtnDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::GuidanceRouteSwitchbtnDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::TrafficDetourDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::TrafficDetourDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::XUrgentTrafficMessageDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::XUrgentTrafficMessageDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringMenuDetailsDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringMenuDetailsDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringMenuTitleDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringMenuTitleDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::EngineeringMenuListCheckDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::EngineeringMenuListCheckDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VehicleProfileInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VehicleProfileInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::StreamedMapSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::StreamedMapSettingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MyPOIsAvailabilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MyPOIsAvailabilityDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteOptionsBorderDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteOptionsBorderDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::RouteRestrictionsPopupTextDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::RouteRestrictionsPopupTextDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SoftRestrictionDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SoftRestrictionDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::MapOptionOthersSettingDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::MapOptionOthersSettingDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::SwitchVehicleParameterindexDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::SwitchVehicleParameterindexDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::VehicleProfileTypeDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::VehicleProfileTypeDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::ListScrollBarInfoDataBindingSource > const& dataItemContainer);

// ------------------------------------------------------------------------
    template<> FeatStd::UInt32 FeatStd::StringBufferAppender< ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > >::Append(FeatStd::StringBuffer& stringBuffer, ::Courier::DataItemContainer< ::CarModeVisibilityDataBindingSource > const& dataItemContainer);
} // namespace FeatStd
#endif // FEATSTD_STRINGBUFFER_APPENDER_ENABLED
#endif // AppHmi_NavigationStateMachine_h
