/************************************************************************
*FILE: AppHmi_NavigationStateMachine.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#include "AppHmi_NavigationStateMachine.h"
#include <FeatStd/Util/StaticObject.h>
#include <Cit/VisualStateGlueLayer/VisualStateGlueLayer.h>
#include <Courier/Util/Util.h>
using namespace ::hmibase;

//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
#include "hmi_trace_if.h"
#include "View/CGI/CourierMsgTracing/CourierMessageMapTrace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_SM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/AppHmi_NavigationStateMachine.cpp.trc.h"
#endif                            
//====  defines and includes TTFis output - end                        key: SM_TTFis_SBHFMSRF ====

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool SendGuiStartupFinishedUpdMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::GuiStartupFinishedUpdMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerOKBtnPressedMsg(Courier::UInt32 const & aSceneType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerOKBtnPressedMsg)(aSceneType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendInitDestinationInputReqMsg(Courier::UInt32 const & aRequestScene, bool const & aRetainDetails)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::InitDestinationInputReqMsg)(aRequestScene, aRetainDetails);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAcceptTrafficAlternativeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AcceptTrafficAlternativeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRejectTrafficAlternativeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RejectTrafficAlternativeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchContextFromTrafficDetourReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchContextFromTrafficDetourReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartTrafficDetourTimerReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartTrafficDetourTimerReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeleteAllUPOIsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeleteAllUPOIsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendImportUPOIsReqMsg(bool const & aImportUPOIsRequest)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ImportUPOIsReqMsg)(aImportUPOIsRequest);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSkipWaypointReqMsg(bool const & aSkipWaypoint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SkipWaypointReqMsg)(aSkipWaypoint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLeaveFormBasedAddressInputReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LeaveFormBasedAddressInputReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetSpellerEntryMsg(bool const & aIsResetSpellerEntry)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetSpellerEntryMsg)(aIsResetSpellerEntry);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReplaceHomeFavReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReplaceHomeFavReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendValidateNaviEntryConditionReqMsg(bool const & aIsDisclaimerConfirmed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ValidateNaviEntryConditionReqMsg)(aIsDisclaimerConfirmed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSaveFavoriteWithDisplayedNameReqMsg(Courier::UInt32 const & aCurrentDetailedInfo)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SaveFavoriteWithDisplayedNameReqMsg)(aCurrentDetailedInfo);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnableGuidanceButton_NewAddressReqMsg(Courier::UInt8 const & aGuidanceEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnableGuidanceButton_NewAddressReqMsg)(aGuidanceEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowPopupTextMsg(Courier::UInt8 const & aPopupType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowPopupTextMsg)(aPopupType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFavDeleteReqMsg(Courier::UInt8 const & aPopupType, bool const & aIsHomeEntry)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FavDeleteReqMsg)(aPopupType, aIsHomeEntry);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendWaypointDeleteReqMsg(Courier::UInt8 const & aPopupType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::WaypointDeleteReqMsg)(aPopupType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendInitPOICategoryBrowseReqMsg(enLocationSearchScope const & aSearchScope)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::InitPOICategoryBrowseReqMsg)(aSearchScope);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetPOISearchLocationReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetPOISearchLocationReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetPickInMapLocationReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetPickInMapLocationReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSavePickInMapCoordinatesReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SavePickInMapCoordinatesReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateDeletePopupTextReqMsg(Courier::UInt8 const & aPopupTextID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateDeletePopupTextReqMsg)(aPopupTextID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateSpeedLockPopupTextReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateSpeedLockPopupTextReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateResetOrDestinationPopupTextReqMsg(bool const & aIsDestGuidance)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateResetOrDestinationPopupTextReqMsg)(aIsDestGuidance);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowAllPOICategoryReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowAllPOICategoryReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetTripCountReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetTripCountReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetMapLayerVisibilityReqMsg(bool const & aIsMapLayerVisible)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetMapLayerVisibilityReqMsg)(aIsMapLayerVisible);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFreezeMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FreezeMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUnfreezeMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UnfreezeMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFreezeAndHideMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FreezeAndHideMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetBackButtonLevelReqMsg(Courier::UInt8 const & aBackButtonLevel)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetBackButtonLevelReqMsg)(aBackButtonLevel);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendToggleSouthNorthReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ToggleSouthNorthReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendToggleEastWestReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ToggleEastWestReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendInitializeLatLongSpellerEntryReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::InitializeLatLongSpellerEntryReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeCoordinateFormatReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeCoordinateFormatReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowCoordinatesInMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowCoordinatesInMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeActiveEditFieldReqMsg(enLatLongInputDataType const & aActiveInputDataType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeActiveEditFieldReqMsg)(aActiveInputDataType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetLatLongPopUpActiveStatusReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetLatLongPopUpActiveStatusReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPopupTimerReqMsg(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPopupTimerReqMsg)(aViewId, aTimeout);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStopPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StopPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnableWhereAmIReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnableWhereAmIReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDisableWhereAmIReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DisableWhereAmIReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetMapCameraModeReqMsg(enMapCameraAndViewModeMode const & aMapCameraMode)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetMapCameraModeReqMsg)(aMapCameraMode);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartPickingReqMsg(enMapPickingType const & aMapPickingType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartPickingReqMsg)(aMapPickingType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTriggerMapPickingReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TriggerMapPickingReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetPickingTimerReqMsg(bool const & aActivateTimer, Courier::UInt32 const & aTimerDuration)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetPickingTimerReqMsg)(aActivateTimer, aTimerDuration);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreLocationOnByMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreLocationOnByMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnteredMapScreenReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnteredMapScreenReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCompassOrientationReqMsg(bool const & aIsSecondaryViewActive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CompassOrientationReqMsg)(aIsSecondaryViewActive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReleasePickInMapReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReleasePickInMapReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReCenterMapScrollReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReCenterMapScrollReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetDetailedAddressMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetDetailedAddressMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeRouteTypeItemReqMsg(enRouteTypeOptions const & aRouteOptions, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeRouteTypeItemReqMsg)(aRouteOptions, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeCustomRouteItemReqMsg(enCustomizeRouteOptions const & aCustomRouteTypeOption, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeCustomRouteItemReqMsg)(aCustomRouteTypeOption, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeEstimatedTimeItemReqMsg(enEstimatedTimeOptions const & aEstimatedTimeOption, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeEstimatedTimeItemReqMsg)(aEstimatedTimeOption, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeTimeOnMapItemReqMsg(enTimeOnMapOptions const & aTimeOnMapOption, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeTimeOnMapItemReqMsg)(aTimeOnMapOption, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeUseTrafficInfoReqMsg(enRoadInformationOptions const & aUseTrafficInfoOption, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeUseTrafficInfoReqMsg)(aUseTrafficInfoOption, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeUseTollRoadReqMsg(enRoadInformationOptions const & aUseTollRoadOption, enReaction const & aReaction)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeUseTollRoadReqMsg)(aUseTollRoadOption, aReaction);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFetchPremiumTrafficSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FetchPremiumTrafficSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyPremiumTrafficSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyPremiumTrafficSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyRoutePreferenceOptionsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyRoutePreferenceOptionsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyDetailedRoutePreferenceOptionsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyDetailedRoutePreferenceOptionsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyGuidanceSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyGuidanceSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyTrafficIconsSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyTrafficIconsSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckIsSatelliteSourceChangedReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckIsSatelliteSourceChangedReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckIsVehicleSettingsChangedReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckIsVehicleSettingsChangedReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeActiveProfileReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeActiveProfileReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSaveVehicleProfileSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SaveVehicleProfileSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetVehicleProfileSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetVehicleProfileSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetVehicleProfileInfoReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetVehicleProfileInfoReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateStartupVehicleProfileReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateStartupVehicleProfileReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateVehicleProfilePopupStatusReqMsg(bool const & aIsGuidanceRetriggered)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateVehicleProfilePopupStatusReqMsg)(aIsGuidanceRetriggered);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetAllNaviSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetAllNaviSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplySettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplySettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardRestrictionConfirmMultipleReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardRestrictionConfirmMultipleReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSoftRestrictionMsg(bool const & aIsRestrictionAccepted)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SoftRestrictionMsg)(aIsRestrictionAccepted);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAcceptCarModeWarningReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AcceptCarModeWarningReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeclineCarModeWarningReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeclineCarModeWarningReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeletePreviousDestinationReqMsg(Courier::UInt8 const & aPopupID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeletePreviousDestinationReqMsg)(aPopupID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPOICategoryBrowseBackReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::POICategoryBrowseBackReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUPOIBrowseBackReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UPOIBrowseBackReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPOIStartFtsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::POIStartFtsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPOILeaveFtsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::POILeaveFtsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetCoordinatesReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetCoordinatesReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUPOIResetCoordinatesReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UPOIResetCoordinatesReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUPOIStartInputReqMsg(bool const & aIsFreeTextSearch)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UPOIStartInputReqMsg)(aIsFreeTextSearch);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUPOILeaveInputReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UPOILeaveInputReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPOILeaveInputReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::POILeaveInputReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendApplyMapViewSettingsReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ApplyMapViewSettingsReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendZoomInReqMsg(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ZoomInReqMsg)(aIsSecondaryViewActive, aZoomBtnType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendZoomOutReqMsg(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ZoomOutReqMsg)(aIsSecondaryViewActive, aZoomBtnType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeleteTrackingPointReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeleteTrackingPointReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateOthersMapSettingListReqMsg(Candera::UInt32 const & aMapSettingsOthersListID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateOthersMapSettingListReqMsg)(aMapSettingsOthersListID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivateStreamedMapSubOptionListReqMsg(Candera::UInt32 const & aSubOptionsListID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ActivateStreamedMapSubOptionListReqMsg)(aSubOptionsListID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMaxFavPopupVisibilityReqsMsg(bool const & aIsPopupEnabled)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MaxFavPopupVisibilityReqsMsg)(aIsPopupEnabled);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetWayPointEnableReqMsg(bool const & aWaypointoptionactivated)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetWayPointEnableReqMsg)(aWaypointoptionactivated);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStartRouteGuidanceReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StartRouteGuidanceReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCancelRouteGuidanceReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CancelRouteGuidanceReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendToggleRouteOverViewBtnMsg(bool const & aIsRouteOverViewActive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ToggleRouteOverViewBtnMsg)(aIsRouteOverViewActive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetPreviosulyActiveSceneName(Candera::UInt32 const & aSceneName)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetPreviosulyActiveSceneName)(aSceneName);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowRouteListViewReqMsg(bool const & aIsRouteListShown)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowRouteListViewReqMsg)(aIsRouteListShown);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowPoisOnMapViewReqMsg(bool const & aIsListShown)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowPoisOnMapViewReqMsg)(aIsListShown);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowWaypointListViewReqMsg(bool const & aIsListShown)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowWaypointListViewReqMsg)(aIsListShown);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHighlightActiveRouteReqMsg(enRouteTypeOptions const & aRouteCriterion)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HighlightActiveRouteReqMsg)(aRouteCriterion);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRouteStartGuidanceReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RouteStartGuidanceReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExpiredTimerResMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExpiredTimerResMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLeftMapViewSetMapScaleReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LeftMapViewSetMapScaleReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAvoidTollRoadReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::AvoidTollRoadReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCancelMultipleRouteReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CancelMultipleRouteReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg(bool const & aIsMapUpdateTriggered)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg)(aIsMapUpdateTriggered);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateNAVDATAUPDATE_PopupTextMsg(Candera::UInt32 const & aPopupID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateNAVDATAUPDATE_PopupTextMsg)(aPopupID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckIsNaviUpdateAvailableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckIsNaviUpdateAvailableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSwitchContextFromNavDataUpdateReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SwitchContextFromNavDataUpdateReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchReqMsg(enContextSwitchFromType const & aContextSwitchFromID, enContextSwitchToType const & aContextSwitchToID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchReqMsg)(aContextSwitchFromID, aContextSwitchToID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSendContextReqMsg(enContextSwitchFromType const & aContextFromActivityID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SendContextReqMsg)(aContextFromActivityID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendUpdateContextonBackgroundReqMsg(Courier::UInt32 const & aCurrentViewID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::UpdateContextonBackgroundReqMsg)(aCurrentViewID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckVehicleParameterStatusMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckVehicleParameterStatusMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRetriggerLastGuidedRouteReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RetriggerLastGuidedRouteReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendEnterEngineeringMenuReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::EnterEngineeringMenuReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDeselectEngineeringMenuReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DeselectEngineeringMenuReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExitEngineeringMenuReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExitEngineeringMenuReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendResetEngineeringMenuReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ResetEngineeringMenuReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendReleaseXUrgentTrafficMessageReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ReleaseXUrgentTrafficMessageReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendChangeLanguageReqMsg(enLanguageId const & aLanguageId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ChangeLanguageReqMsg)(aLanguageId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusReqMsg(FocusActionEnum const & aAction, FocusTimerActionEnum const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusReqMsg)(aAction, aTimerAction, aView, aWidget);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDummyMess(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DummyMess)(aFirstView, aSecondView, aPos);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAnimationReqMsg(Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ViewId const & aViewId, Courier::CompositePath const & aCompositePath, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AnimationReqMsg)(aAnimationAction, aViewId, aCompositePath, aAnimationId, aAnimationProperties);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendFocusOnRightEncoderReqUpdMsg(bool const & aIsFocusUsed)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::FocusOnRightEncoderReqUpdMsg)(aIsFocusUsed);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStoreActiveGadgetReqMsg(bool const & aIsGadgetAtive)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StoreActiveGadgetReqMsg)(aIsGadgetAtive);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendHardKeyPressNotificationMsg(Courier::UInt8 const & aDummy, Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::HardKeyPressNotificationMsg)(aDummy, aHKCode, aHKState);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendDropdownChangeMsg(::Candera::DropdownChangeType const & aDropdownChangeType, ::Courier::UInt32 const & aListId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::DropdownChangeMsg)(aDropdownChangeType, aListId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPlayBeepReqMsg(Courier::Int32 const & aBeepType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PlayBeepReqMsg)(aBeepType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCheckToClosePopupMsg(Courier::UInt32 const & aPopupId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CheckToClosePopupMsg)(aPopupId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRestartPopupTimerReqMsg(Courier::UInt32 const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RestartPopupTimerReqMsg)(aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchInResMsg(Courier::UInt32 const & aSwitchId, Courier::UInt32 const & aResponseType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchInResMsg)(aSwitchId, aResponseType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendContextSwitchOutReqMsg(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ContextSwitchOutReqMsg)(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCurrentScreenDisplayReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CurrentScreenDisplayReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendLaunchBarDisplayReqMsg(bool const & aVisibility)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::LaunchBarDisplayReqMsg)(aVisibility);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNavTBTSwipeReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NavTBTSwipeReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListItemRightEncoderChangeUpdMsg(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListItemRightEncoderChangeUpdMsg)(aSteps, aListId, aRowId, aColumnId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListChangeMsg(::Courier::UInt32 const & aListId, ListChangeType const & aListChangeType, ::Courier::Int32 const & aValue, ListChangeMsgSourceType const & aListChangeMsgSource, bool const & aImmediatePositioning)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListChangeMsg)(aListId, aListChangeType, aValue, aListChangeMsgSource, aImmediatePositioning);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusScrollReqMsg(Courier::UInt32 const & aListId, Courier::Int32 const & aSteps)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusScrollReqMsg)(aListId, aSteps);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendListFocusLockDataResetReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ListFocusLockDataResetReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSetApplicationModeReqMsg(Courier::UInt32 const & aModeId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SetApplicationModeReqMsg)(aModeId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendSpellerBbehaviorReqMsg(bool const & aEnable)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::SpellerBbehaviorReqMsg)(aEnable);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendStatusBarDisplayReqMsg(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::StatusBarDisplayReqMsg)(aVisibility, aHeaderType);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendTBTRetriggerAcousticMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::TBTRetriggerAcousticMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendViewReqMsg(Courier::ViewAction::Enum const & aViewAction, ::Courier::ViewId const & aViewId, bool const & aShallInitScene, bool const & aShallLoadScene)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(aViewAction, aViewId, aShallInitScene, aShallLoadScene);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendActivationReqMsg(::Courier::ViewId const & aViewId, bool const & aActivation, bool const & aEnableRendering)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::ActivationReqMsg)(aViewId, aActivation, aEnableRendering);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendAsyncLoadReqMsg(::Courier::ViewId const & aViewId, bool const & aLoad)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::Courier::AsyncLoadReqMsg)(aViewId, aLoad);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupReqMsg)(aCommand, aViewId, aPopupDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ExtendedViewReqMsg)(aCommand, aViewId, aHint);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID, bool const & aLockSubSurface)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ShowHMISubSurfaceReqMsg)(aDisplayRegion, aDisplayRegionType, aShowSubSurface, aDisplayID, aLockSubSurface);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendRegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::RegisterForCloseOnTouchSessionReqMsg)(aRegister, aViewId);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterPrioEnableReqMsg)(aPrio);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterAllEnableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterAllEnableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendPopupFilterDisableReqMsg()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::PopupFilterDisableReqMsg)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendProfileSwitchMsg(Courier::UInt32 const & aProfile)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::ProfileSwitchMsg)(aProfile);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendMultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::MultiDisplayPopupFilterReqMsg)(aPopupFilterType, aPrio, aDisplayID);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendCreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::CreateNewDestroyOld)(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------
bool SendNotifierMessage()
{
    bool rc = false;
    ::Courier::Message* msg = COURIER_MESSAGE_NEW(::NotifierMessage)();
    COURIER_DEBUG_ASSERT(0 != msg);
    if (0 != msg) {
        rc = msg->Post();
        COURIER_DEBUG_ASSERT(rc);
        msg = 0;
    }
    return rc;
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_Notify_Init_Finished(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_Notify_Init_Finished();
    return true;
}
#endif
void Action_Notify_Init_Finished()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action Notify_Init_Finished()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendGuiStartupFinishedUpdMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ac_N_SpellerEdit_Ok_touch(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_ac_N_SpellerEdit_Ok_touch(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_ac_N_SpellerEdit_Ok_touch(Courier::UInt32 const & aSceneType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action ac_N_SpellerEdit_Ok_touch(aSceneType = %d)", aSceneType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerOKBtnPressedMsg(aSceneType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acInitDestinationInput(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acInitDestinationInput(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acInitDestinationInput(Courier::UInt32 const & aRequestScene, bool const & aRetainDetails)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acInitDestinationInput(aRequestScene = %d, aRetainDetails = %d)", aRequestScene,aRetainDetails));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendInitDestinationInputReqMsg(aRequestScene, aRetainDetails);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acAcceptTrafficAlternativeReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acAcceptTrafficAlternativeReqMsg();
    return true;
}
#endif
void Action_acAcceptTrafficAlternativeReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acAcceptTrafficAlternativeReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAcceptTrafficAlternativeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRejectTrafficAlternativeReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRejectTrafficAlternativeReqMsg();
    return true;
}
#endif
void Action_acRejectTrafficAlternativeReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acRejectTrafficAlternativeReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRejectTrafficAlternativeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSwitchContextFromTrafficDetour(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSwitchContextFromTrafficDetour();
    return true;
}
#endif
void Action_acSwitchContextFromTrafficDetour()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSwitchContextFromTrafficDetour()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchContextFromTrafficDetourReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartTrafficDetourTimer(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartTrafficDetourTimer();
    return true;
}
#endif
void Action_acStartTrafficDetourTimer()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStartTrafficDetourTimer()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartTrafficDetourTimerReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeleteAllUPOIsReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDeleteAllUPOIsReqMsg();
    return true;
}
#endif
void Action_acDeleteAllUPOIsReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDeleteAllUPOIsReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeleteAllUPOIsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acImportUPOIsReqMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acImportUPOIsReqMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acImportUPOIsReqMsg(bool const & aImportUPOIsRequest)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acImportUPOIsReqMsg(aImportUPOIsRequest = %d)", aImportUPOIsRequest));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendImportUPOIsReqMsg(aImportUPOIsRequest);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSkipWaypointReqMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSkipWaypointReqMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSkipWaypointReqMsg(bool const & aSkipWaypoint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSkipWaypointReqMsg(aSkipWaypoint = %d)", aSkipWaypoint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSkipWaypointReqMsg(aSkipWaypoint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acLeaveFormBasedAddressInput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acLeaveFormBasedAddressInput();
    return true;
}
#endif
void Action_acLeaveFormBasedAddressInput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acLeaveFormBasedAddressInput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLeaveFormBasedAddressInputReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acInavlidateSpellerEntry(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acInavlidateSpellerEntry(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acInavlidateSpellerEntry(bool const & aIsResetSpellerEntry)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acInavlidateSpellerEntry(aIsResetSpellerEntry = %d)", aIsResetSpellerEntry));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetSpellerEntryMsg(aIsResetSpellerEntry);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReplaceHomeFav(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReplaceHomeFav();
    return true;
}
#endif
void Action_acReplaceHomeFav()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acReplaceHomeFav()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReplaceHomeFavReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acValidateNaviEntryCondition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acValidateNaviEntryCondition(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acValidateNaviEntryCondition(bool const & aIsDisclaimerConfirmed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acValidateNaviEntryCondition(aIsDisclaimerConfirmed = %d)", aIsDisclaimerConfirmed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendValidateNaviEntryConditionReqMsg(aIsDisclaimerConfirmed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSaveFavoriteWithDisplayedName(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSaveFavoriteWithDisplayedName(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSaveFavoriteWithDisplayedName(Courier::UInt32 const & aCurrentDetailedInfo)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSaveFavoriteWithDisplayedName(aCurrentDetailedInfo = %d)", aCurrentDetailedInfo));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSaveFavoriteWithDisplayedNameReqMsg(aCurrentDetailedInfo);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acEnableGuidanceButton_NewAddress(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acEnableGuidanceButton_NewAddress(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acEnableGuidanceButton_NewAddress(Courier::UInt8 const & aGuidanceEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acEnableGuidanceButton_NewAddress(aGuidanceEnable = %d)", aGuidanceEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableGuidanceButton_NewAddressReqMsg(aGuidanceEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowPopupText(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acShowPopupText(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acShowPopupText(Courier::UInt8 const & aPopupType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acShowPopupText(aPopupType = %d)", aPopupType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowPopupTextMsg(aPopupType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFavDelete(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acFavDelete(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acFavDelete(Courier::UInt8 const & aPopupType, bool const & aIsHomeEntry)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acFavDelete(aPopupType = %d, aIsHomeEntry = %d)", aPopupType,aIsHomeEntry));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFavDeleteReqMsg(aPopupType, aIsHomeEntry);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acWaypointDelete(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acWaypointDelete(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acWaypointDelete(Courier::UInt8 const & aPopupType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acWaypointDelete(aPopupType = %d)", aPopupType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendWaypointDeleteReqMsg(aPopupType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acInitPOICategoryBrowse(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acInitPOICategoryBrowse(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acInitPOICategoryBrowse(enLocationSearchScope const & aSearchScope)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acInitPOICategoryBrowse(aSearchScope = ?enLocationSearchScope?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendInitPOICategoryBrowseReqMsg(aSearchScope);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetPOISearchLocation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetPOISearchLocation();
    return true;
}
#endif
void Action_acSetPOISearchLocation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetPOISearchLocation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetPOISearchLocationReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetPickInMapLocation(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetPickInMapLocation();
    return true;
}
#endif
void Action_acSetPickInMapLocation()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetPickInMapLocation()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetPickInMapLocationReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSavePickInMapCoordinates(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSavePickInMapCoordinates();
    return true;
}
#endif
void Action_acSavePickInMapCoordinates()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSavePickInMapCoordinates()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSavePickInMapCoordinatesReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateDeletePopupText(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acUpdateDeletePopupText(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acUpdateDeletePopupText(Courier::UInt8 const & aPopupTextID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateDeletePopupText(aPopupTextID = %d)", aPopupTextID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateDeletePopupTextReqMsg(aPopupTextID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateSpeedLockPopupText(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUpdateSpeedLockPopupText();
    return true;
}
#endif
void Action_acUpdateSpeedLockPopupText()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateSpeedLockPopupText()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateSpeedLockPopupTextReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateResetOrDestinationPopupTextReqMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acUpdateResetOrDestinationPopupTextReqMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acUpdateResetOrDestinationPopupTextReqMsg(bool const & aIsDestGuidance)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateResetOrDestinationPopupTextReqMsg(aIsDestGuidance = %d)", aIsDestGuidance));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateResetOrDestinationPopupTextReqMsg(aIsDestGuidance);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowAllPOICategory(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acShowAllPOICategory();
    return true;
}
#endif
void Action_acShowAllPOICategory()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acShowAllPOICategory()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowAllPOICategoryReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetTripCountReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetTripCountReqMsg();
    return true;
}
#endif
void Action_acResetTripCountReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetTripCountReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetTripCountReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetMapLayerVisibility(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetMapLayerVisibility(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetMapLayerVisibility(bool const & aIsMapLayerVisible)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetMapLayerVisibility(aIsMapLayerVisible = %d)", aIsMapLayerVisible));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetMapLayerVisibilityReqMsg(aIsMapLayerVisible);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFreezeMapAction(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acFreezeMapAction();
    return true;
}
#endif
void Action_acFreezeMapAction()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acFreezeMapAction()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFreezeMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUnfreezeMapAction(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUnfreezeMapAction();
    return true;
}
#endif
void Action_acUnfreezeMapAction()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUnfreezeMapAction()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUnfreezeMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFreezeAndHideMapAction(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acFreezeAndHideMapAction();
    return true;
}
#endif
void Action_acFreezeAndHideMapAction()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acFreezeAndHideMapAction()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFreezeAndHideMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetBackButtonLevel(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSetBackButtonLevel(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSetBackButtonLevel(Courier::UInt8 const & aBackButtonLevel)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetBackButtonLevel(aBackButtonLevel = %d)", aBackButtonLevel));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetBackButtonLevelReqMsg(aBackButtonLevel);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleSouthNorth(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acToggleSouthNorth();
    return true;
}
#endif
void Action_acToggleSouthNorth()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acToggleSouthNorth()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendToggleSouthNorthReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleEastWest(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acToggleEastWest();
    return true;
}
#endif
void Action_acToggleEastWest()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acToggleEastWest()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendToggleEastWestReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acInitializeLatLongSpellerEntry(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acInitializeLatLongSpellerEntry();
    return true;
}
#endif
void Action_acInitializeLatLongSpellerEntry()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acInitializeLatLongSpellerEntry()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendInitializeLatLongSpellerEntryReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeCoordinateFormat(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acChangeCoordinateFormat();
    return true;
}
#endif
void Action_acChangeCoordinateFormat()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeCoordinateFormat()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeCoordinateFormatReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLatLongInputValues(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLatLongInputValues();
    return true;
}
#endif
void Action_acSetLatLongInputValues()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLatLongInputValues()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowCoordinatesInMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLatDegreesActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLatDegreesActive();
    return true;
}
#endif
void Action_acSetLatDegreesActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLatDegreesActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LAT_DEGREES_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLatMinutesActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLatMinutesActive();
    return true;
}
#endif
void Action_acSetLatMinutesActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLatMinutesActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LAT_MINUTES_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLatSecondsActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLatSecondsActive();
    return true;
}
#endif
void Action_acSetLatSecondsActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLatSecondsActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LAT_SECONDS_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLatDecimalsActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLatDecimalsActive();
    return true;
}
#endif
void Action_acSetLatDecimalsActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLatDecimalsActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LAT_DECIMALS_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLongDegreesActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLongDegreesActive();
    return true;
}
#endif
void Action_acSetLongDegreesActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLongDegreesActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LONG_DEGREES_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLongMinutesActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLongMinutesActive();
    return true;
}
#endif
void Action_acSetLongMinutesActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLongMinutesActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LONG_MINUTES_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLongSecondsActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLongSecondsActive();
    return true;
}
#endif
void Action_acSetLongSecondsActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLongSecondsActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LONG_SECONDS_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetLongDecimalsActive(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSetLongDecimalsActive();
    return true;
}
#endif
void Action_acSetLongDecimalsActive()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetLongDecimalsActive()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveEditFieldReqMsg(LONG_DECIMALS_DATA);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetLatLongPopUpStatus(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetLatLongPopUpStatus();
    return true;
}
#endif
void Action_acResetLatLongPopUpStatus()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetLatLongPopUpStatus()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetLatLongPopUpActiveStatusReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acNavigationPopUpVisible(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acNavigationPopUpVisible(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acNavigationPopUpVisible(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acNavigationPopUpVisible(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStopTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acEnableWhereAmI(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acEnableWhereAmI();
    return true;
}
#endif
void Action_acEnableWhereAmI()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acEnableWhereAmI()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnableWhereAmIReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDisableWhereAmI(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDisableWhereAmI();
    return true;
}
#endif
void Action_acDisableWhereAmI()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDisableWhereAmI()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDisableWhereAmIReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetMapCameraModeAction(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSetMapCameraModeAction(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSetMapCameraModeAction(enMapCameraAndViewModeMode const & aMapCameraMode)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetMapCameraModeAction(aMapCameraMode = ?enMapCameraAndViewModeMode?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetMapCameraModeReqMsg(aMapCameraMode);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartPicking(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStartPicking(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStartPicking(enMapPickingType const & aMapPickingType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStartPicking(aMapPickingType = ?enMapPickingType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPickingReqMsg(aMapPickingType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acTriggerMapPicking(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acTriggerMapPicking();
    return true;
}
#endif
void Action_acTriggerMapPicking()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acTriggerMapPicking()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTriggerMapPickingReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetPickingTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acSetPickingTimer(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acSetPickingTimer(bool const & aActivateTimer, Courier::UInt32 const & aTimerDuration)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetPickingTimer(aActivateTimer = %d, aTimerDuration = %d)", aActivateTimer,aTimerDuration));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetPickingTimerReqMsg(aActivateTimer, aTimerDuration);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStoreLocationOnByMapOkPress(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStoreLocationOnByMapOkPress();
    return true;
}
#endif
void Action_acStoreLocationOnByMapOkPress()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStoreLocationOnByMapOkPress()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreLocationOnByMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMapScreen(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acMapScreen();
    return true;
}
#endif
void Action_acMapScreen()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acMapScreen()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnteredMapScreenReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCompassOrientation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acCompassOrientation(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acCompassOrientation(bool const & aIsSecondaryViewActive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCompassOrientation(aIsSecondaryViewActive = %d)", aIsSecondaryViewActive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCompassOrientationReqMsg(aIsSecondaryViewActive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReleasePickInMap(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReleasePickInMap();
    return true;
}
#endif
void Action_acReleasePickInMap()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acReleasePickInMap()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReleasePickInMapReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRecenterMap(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRecenterMap();
    return true;
}
#endif
void Action_acRecenterMap()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acRecenterMap()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReCenterMapScrollReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetDetailedAddress(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetDetailedAddress();
    return true;
}
#endif
void Action_acResetDetailedAddress()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetDetailedAddress()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetDetailedAddressMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeRouteTypeItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeRouteTypeItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeRouteTypeItem(enRouteTypeOptions const & aRouteOptions)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeRouteTypeItem(aRouteOptions = ?enRouteTypeOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeRouteTypeItemReqMsg(aRouteOptions, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeCustomRouteItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeCustomRouteItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeCustomRouteItem(enCustomizeRouteOptions const & aCustomRouteTypeOption)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeCustomRouteItem(aCustomRouteTypeOption = ?enCustomizeRouteOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeCustomRouteItemReqMsg(aCustomRouteTypeOption, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeEstimatedTimeItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeEstimatedTimeItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeEstimatedTimeItem(enEstimatedTimeOptions const & aEstimatedTimeOption)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeEstimatedTimeItem(aEstimatedTimeOption = ?enEstimatedTimeOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeEstimatedTimeItemReqMsg(aEstimatedTimeOption, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeTimeOnMapItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeTimeOnMapItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeTimeOnMapItem(enTimeOnMapOptions const & aTimeOnMapOption)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeTimeOnMapItem(aTimeOnMapOption = ?enTimeOnMapOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeTimeOnMapItemReqMsg(aTimeOnMapOption, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeUseTrafficInfoItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeUseTrafficInfoItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeUseTrafficInfoItem(enRoadInformationOptions const & aUseTrafficInfoOption)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeUseTrafficInfoItem(aUseTrafficInfoOption = ?enRoadInformationOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeUseTrafficInfoReqMsg(aUseTrafficInfoOption, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeUseTollRoadItem(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acChangeUseTollRoadItem(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acChangeUseTollRoadItem(enRoadInformationOptions const & aUseTollRoadOption)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeUseTollRoadItem(aUseTollRoadOption = ?enRoadInformationOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeUseTollRoadReqMsg(aUseTollRoadOption, enReaction());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFetchPremiumTrafficSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acFetchPremiumTrafficSettings();
    return true;
}
#endif
void Action_acFetchPremiumTrafficSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acFetchPremiumTrafficSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFetchPremiumTrafficSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyPremiumTrafficSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyPremiumTrafficSettings();
    return true;
}
#endif
void Action_acApplyPremiumTrafficSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyPremiumTrafficSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyPremiumTrafficSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyRoutePreferenceOptions(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyRoutePreferenceOptions();
    return true;
}
#endif
void Action_acApplyRoutePreferenceOptions()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyRoutePreferenceOptions()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyRoutePreferenceOptionsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyDetailedRoutepreferencesOptions(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyDetailedRoutepreferencesOptions();
    return true;
}
#endif
void Action_acApplyDetailedRoutepreferencesOptions()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyDetailedRoutepreferencesOptions()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyDetailedRoutePreferenceOptionsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyGuidanceSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyGuidanceSettings();
    return true;
}
#endif
void Action_acApplyGuidanceSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyGuidanceSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyGuidanceSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyTrafficIconsSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyTrafficIconsSettings();
    return true;
}
#endif
void Action_acApplyTrafficIconsSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyTrafficIconsSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyTrafficIconsSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsSatelliteSourceChanged(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCheckIsSatelliteSourceChanged();
    return true;
}
#endif
void Action_acCheckIsSatelliteSourceChanged()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCheckIsSatelliteSourceChanged()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckIsSatelliteSourceChangedReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsVehicleSettingsChanged(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCheckIsVehicleSettingsChanged();
    return true;
}
#endif
void Action_acCheckIsVehicleSettingsChanged()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCheckIsVehicleSettingsChanged()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckIsVehicleSettingsChangedReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acChangeActiveProfile(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acChangeActiveProfile();
    return true;
}
#endif
void Action_acChangeActiveProfile()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acChangeActiveProfile()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeActiveProfileReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSaveVehicleProfileSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSaveVehicleProfileSettings();
    return true;
}
#endif
void Action_acSaveVehicleProfileSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSaveVehicleProfileSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSaveVehicleProfileSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetVehicleProfileSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetVehicleProfileSettings();
    return true;
}
#endif
void Action_acResetVehicleProfileSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetVehicleProfileSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetVehicleProfileSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetVehicleProfileInfo(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetVehicleProfileInfo();
    return true;
}
#endif
void Action_acResetVehicleProfileInfo()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetVehicleProfileInfo()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetVehicleProfileInfoReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateStartupVehicleProfileInfo(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUpdateStartupVehicleProfileInfo();
    return true;
}
#endif
void Action_acUpdateStartupVehicleProfileInfo()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateStartupVehicleProfileInfo()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateStartupVehicleProfileReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateVehicleProfilePopupStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acUpdateVehicleProfilePopupStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acUpdateVehicleProfilePopupStatus(bool const & aIsGuidanceRetriggered)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateVehicleProfilePopupStatus(aIsGuidanceRetriggered = %d)", aIsGuidanceRetriggered));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateVehicleProfilePopupStatusReqMsg(aIsGuidanceRetriggered);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetAllNaviSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetAllNaviSettings();
    return true;
}
#endif
void Action_acResetAllNaviSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetAllNaviSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetAllNaviSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplySettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplySettings();
    return true;
}
#endif
void Action_acApplySettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplySettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplySettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHardRestrictionConfirmMultiple(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acHardRestrictionConfirmMultiple();
    return true;
}
#endif
void Action_acHardRestrictionConfirmMultiple()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acHardRestrictionConfirmMultiple()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardRestrictionConfirmMultipleReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSoftRestrictionMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSoftRestrictionMsg(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSoftRestrictionMsg(bool const & aIsRestrictionAccepted)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSoftRestrictionMsg(aIsRestrictionAccepted = %d)", aIsRestrictionAccepted));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSoftRestrictionMsg(aIsRestrictionAccepted);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acAcceptCarModeWarning(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acAcceptCarModeWarning();
    return true;
}
#endif
void Action_acAcceptCarModeWarning()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acAcceptCarModeWarning()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAcceptCarModeWarningReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeclineCarModeWarning(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDeclineCarModeWarning();
    return true;
}
#endif
void Action_acDeclineCarModeWarning()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDeclineCarModeWarning()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeclineCarModeWarningReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeletePreviousDestination(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acDeletePreviousDestination(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acDeletePreviousDestination(Courier::UInt8 const & aPopupID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDeletePreviousDestination(aPopupID = %d)", aPopupID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeletePreviousDestinationReqMsg(aPopupID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPOICategoryBrowseBack(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPOICategoryBrowseBack();
    return true;
}
#endif
void Action_acPOICategoryBrowseBack()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPOICategoryBrowseBack()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPOICategoryBrowseBackReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUPOIBrowseBack(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUPOIBrowseBack();
    return true;
}
#endif
void Action_acUPOIBrowseBack()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUPOIBrowseBack()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUPOIBrowseBackReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPOIStartFts(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPOIStartFts();
    return true;
}
#endif
void Action_acPOIStartFts()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPOIStartFts()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPOIStartFtsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPOILeaveFts(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPOILeaveFts();
    return true;
}
#endif
void Action_acPOILeaveFts()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPOILeaveFts()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPOILeaveFtsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetCoordinates(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetCoordinates();
    return true;
}
#endif
void Action_acResetCoordinates()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetCoordinates()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetCoordinatesReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUPOIResetCoordinates(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUPOIResetCoordinates();
    return true;
}
#endif
void Action_acUPOIResetCoordinates()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUPOIResetCoordinates()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUPOIResetCoordinatesReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUPOIStartInput(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acUPOIStartInput(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acUPOIStartInput(bool const & aIsFreeTextSearch)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUPOIStartInput(aIsFreeTextSearch = %d)", aIsFreeTextSearch));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUPOIStartInputReqMsg(aIsFreeTextSearch);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUPOILeaveInput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acUPOILeaveInput();
    return true;
}
#endif
void Action_acUPOILeaveInput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUPOILeaveInput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUPOILeaveInputReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPOILeaveInput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPOILeaveInput();
    return true;
}
#endif
void Action_acPOILeaveInput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPOILeaveInput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPOILeaveInputReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acApplyMapViewSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acApplyMapViewSettings();
    return true;
}
#endif
void Action_acApplyMapViewSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acApplyMapViewSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendApplyMapViewSettingsReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMapZoomIn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acMapZoomIn(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acMapZoomIn(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acMapZoomIn(aIsSecondaryViewActive = %d, aZoomBtnType = %d)", aIsSecondaryViewActive,aZoomBtnType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendZoomInReqMsg(aIsSecondaryViewActive, aZoomBtnType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMapZoomOut(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isBool())) { return false; }
    Action_acMapZoomOut(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asBool());
    return true;
}
#endif
void Action_acMapZoomOut(bool const & aIsSecondaryViewActive, bool const & aZoomBtnType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acMapZoomOut(aIsSecondaryViewActive = %d, aZoomBtnType = %d)", aIsSecondaryViewActive,aZoomBtnType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendZoomOutReqMsg(aIsSecondaryViewActive, aZoomBtnType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeleteTrackingPoint(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDeleteTrackingPoint();
    return true;
}
#endif
void Action_acDeleteTrackingPoint()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDeleteTrackingPoint()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeleteTrackingPointReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateMapSettingOthersList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acActivateMapSettingOthersList(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acActivateMapSettingOthersList(Candera::UInt32 const & aMapSettingsOthersListID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acActivateMapSettingOthersList(aMapSettingsOthersListID = ?Candera::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateOthersMapSettingListReqMsg(aMapSettingsOthersListID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acActivateStreamMapSettingSubOptionList(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acActivateStreamMapSettingSubOptionList(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acActivateStreamMapSettingSubOptionList(Candera::UInt32 const & aSubOptionsListID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acActivateStreamMapSettingSubOptionList(aSubOptionsListID = ?Candera::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivateStreamedMapSubOptionListReqMsg(aSubOptionsListID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetMaxFavPopupVisibilityStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetMaxFavPopupVisibilityStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetMaxFavPopupVisibilityStatus(bool const & aIsPopupEnabled)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetMaxFavPopupVisibilityStatus(aIsPopupEnabled = %d)", aIsPopupEnabled));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMaxFavPopupVisibilityReqsMsg(aIsPopupEnabled);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetWaypointoption(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetWaypointoption(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetWaypointoption(bool const & aWaypointoptionactivated)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetWaypointoption(aWaypointoptionactivated = %d)", aWaypointoptionactivated));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetWayPointEnableReqMsg(aWaypointoptionactivated);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartRouteGuidance(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acStartRouteGuidance();
    return true;
}
#endif
void Action_acStartRouteGuidance()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStartRouteGuidance()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartRouteGuidanceReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCancelActiveRouteGuidance(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCancelActiveRouteGuidance();
    return true;
}
#endif
void Action_acCancelActiveRouteGuidance()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCancelActiveRouteGuidance()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCancelRouteGuidanceReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acToggleRouteOverviewBtn(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acToggleRouteOverviewBtn(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acToggleRouteOverviewBtn(bool const & aIsRouteOverViewActive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acToggleRouteOverviewBtn(aIsRouteOverViewActive = %d)", aIsRouteOverViewActive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendToggleRouteOverViewBtnMsg(aIsRouteOverViewActive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetPreviosulyActiveSceneName(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSetPreviosulyActiveSceneName(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSetPreviosulyActiveSceneName(Candera::UInt32 const & aSceneName)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetPreviosulyActiveSceneName(aSceneName = ?Candera::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetPreviosulyActiveSceneName(aSceneName);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowRouteListView(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acShowRouteListView(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acShowRouteListView(bool const & aIsRouteListShown)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acShowRouteListView(aIsRouteListShown = %d)", aIsRouteListShown));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowRouteListViewReqMsg(aIsRouteListShown);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowPoisOnMapView(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acShowPoisOnMapView(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acShowPoisOnMapView(bool const & aIsListShown)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acShowPoisOnMapView(aIsListShown = %d)", aIsListShown));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowPoisOnMapViewReqMsg(aIsListShown);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acShowWaypointListView(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acShowWaypointListView(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acShowWaypointListView(bool const & aIsListShown)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acShowWaypointListView(aIsListShown = %d)", aIsListShown));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowWaypointListViewReqMsg(aIsListShown);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHighlightActiveRoute(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acHighlightActiveRoute(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acHighlightActiveRoute(enRouteTypeOptions const & aRouteCriterion)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acHighlightActiveRoute(aRouteCriterion = ?enRouteTypeOptions?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHighlightActiveRouteReqMsg(aRouteCriterion);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRouteStartGuidance(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRouteStartGuidance();
    return true;
}
#endif
void Action_acRouteStartGuidance()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acRouteStartGuidance()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRouteStartGuidanceReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acMapTimerExpired(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acMapTimerExpired();
    return true;
}
#endif
void Action_acMapTimerExpired()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acMapTimerExpired()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExpiredTimerResMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acLeftMapViewSetMapScaleSettings(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acLeftMapViewSetMapScaleSettings();
    return true;
}
#endif
void Action_acLeftMapViewSetMapScaleSettings()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acLeftMapViewSetMapScaleSettings()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLeftMapViewSetMapScaleReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acAvoidTollRoad(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acAvoidTollRoad();
    return true;
}
#endif
void Action_acAvoidTollRoad()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acAvoidTollRoad()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAvoidTollRoadReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCancelMultipleRouteIfAvailable(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCancelMultipleRouteIfAvailable();
    return true;
}
#endif
void Action_acCancelMultipleRouteIfAvailable()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCancelMultipleRouteIfAvailable()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCancelMultipleRouteReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateYes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acNAVDATAUPDATE_Nav_FullMapUpdateYes(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acNAVDATAUPDATE_Nav_FullMapUpdateYes(bool const & aIsMapUpdateTriggered)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acNAVDATAUPDATE_Nav_FullMapUpdateYes(aIsMapUpdateTriggered = %d)", aIsMapUpdateTriggered));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg(aIsMapUpdateTriggered);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateNo(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acNAVDATAUPDATE_Nav_FullMapUpdateNo();
    return true;
}
#endif
void Action_acNAVDATAUPDATE_Nav_FullMapUpdateNo()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acNAVDATAUPDATE_Nav_FullMapUpdateNo()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk();
    return true;
}
#endif
void Action_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateNAVDATAUPDATE_PopupText(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acUpdateNAVDATAUPDATE_PopupText(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acUpdateNAVDATAUPDATE_PopupText(Candera::UInt32 const & aPopupID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateNAVDATAUPDATE_PopupText(aPopupID = ?Candera::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateNAVDATAUPDATE_PopupTextMsg(aPopupID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCheckIsNaviUpdateAvailable(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCheckIsNaviUpdateAvailable();
    return true;
}
#endif
void Action_acCheckIsNaviUpdateAvailable()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCheckIsNaviUpdateAvailable()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckIsNaviUpdateAvailableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSwitchContextFromNavDataUpdate(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acSwitchContextFromNavDataUpdate();
    return true;
}
#endif
void Action_acSwitchContextFromNavDataUpdate()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSwitchContextFromNavDataUpdate()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSwitchContextFromNavDataUpdateReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acContextSwitch(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acContextSwitch(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acContextSwitch(enContextSwitchFromType const & aContextSwitchFromID, enContextSwitchToType const & aContextSwitchToID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acContextSwitch(aContextSwitchFromID = ?enContextSwitchFromType?, aContextSwitchToID = ?enContextSwitchToType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchReqMsg(aContextSwitchFromID, aContextSwitchToID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSendContext(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acSendContext(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acSendContext(enContextSwitchFromType const & aContextFromActivityID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSendContext(aContextFromActivityID = ?enContextSwitchFromType?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSendContextReqMsg(aContextFromActivityID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acUpdateContextonBackground(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acUpdateContextonBackground(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acUpdateContextonBackground(Courier::UInt32 const & aCurrentViewID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acUpdateContextonBackground(aCurrentViewID = %d)", aCurrentViewID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendUpdateContextonBackgroundReqMsg(aCurrentViewID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acCheckVehicleParameterStatus(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acCheckVehicleParameterStatus();
    return true;
}
#endif
void Action_acCheckVehicleParameterStatus()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acCheckVehicleParameterStatus()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckVehicleParameterStatusMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRetriggerLastGuidedRoute(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acRetriggerLastGuidedRoute();
    return true;
}
#endif
void Action_acRetriggerLastGuidedRoute()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acRetriggerLastGuidedRoute()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRetriggerLastGuidedRouteReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acEnterEngineeringMenu(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acEnterEngineeringMenu();
    return true;
}
#endif
void Action_acEnterEngineeringMenu()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acEnterEngineeringMenu()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendEnterEngineeringMenuReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acDeselectEngineeringMenu(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acDeselectEngineeringMenu();
    return true;
}
#endif
void Action_acDeselectEngineeringMenu()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acDeselectEngineeringMenu()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDeselectEngineeringMenuReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acExitEngineeringMenu(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acExitEngineeringMenu();
    return true;
}
#endif
void Action_acExitEngineeringMenu()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acExitEngineeringMenu()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExitEngineeringMenuReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acResetEngineeringMenu(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acResetEngineeringMenu();
    return true;
}
#endif
void Action_acResetEngineeringMenu()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acResetEngineeringMenu()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendResetEngineeringMenuReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acReleaseXUrgentTrafficMessageReqMsg(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acReleaseXUrgentTrafficMessageReqMsg();
    return true;
}
#endif
void Action_acReleaseXUrgentTrafficMessageReqMsg()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acReleaseXUrgentTrafficMessageReqMsg()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendReleaseXUrgentTrafficMessageReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacChangeLanguageReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacChangeLanguageReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacChangeLanguageReq(enLanguageId const & aLanguageId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacChangeLanguageReq(aLanguageId = ?enLanguageId?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendChangeLanguageReqMsg(aLanguageId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFocusInViewReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacHideFocusInViewReq(::Courier::ViewId const & aView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacHideFocusInViewReq(aView = %50s)", aView.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusReqMsg(FOCUS_HIDE, FOCUS_TIMER_NO_ACTION, aView, Candera::String());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_NextLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_NextLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_NextLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action NextLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PreviousLevelTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PreviousLevelTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PreviousLevelTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action PreviousLevelTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewLeftTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewLeftTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewLeftTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action DualViewLeftTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_DualViewRightTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_DualViewRightTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_DualViewRightTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action DualViewRightTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipBackTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipBackTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipBackTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action PageFlipBackTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_PageFlipFrontTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_PageFlipFrontTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_PageFlipFrontTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action PageFlipFrontTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomInTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomInTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomInTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action ZoomInTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_ZoomOutTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt() && parameters[(::Json::Value::UInt)2].isInt())) { return false; }
    Action_ZoomOutTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt(), parameters[(::Json::Value::UInt)2].asInt());
    return true;
}
#endif
void Action_ZoomOutTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView, Candera::UInt8 const & aPos)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action ZoomOutTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?, aPos = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, aPos);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_FadeTransition(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_FadeTransition(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_FadeTransition(Candera::UInt8 const & aFirstView, Candera::UInt8 const & aSecondView)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action FadeTransition(aFirstView = ?Candera::UInt8?, aSecondView = ?Candera::UInt8?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDummyMess(aFirstView, aSecondView, Candera::UInt8());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStartReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStartReq();
    return true;
}
#endif
void Action_gacWaitAnimationStartReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStartReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Start, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acFocusOnRightEncoderReqUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acFocusOnRightEncoderReqUpd(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acFocusOnRightEncoderReqUpd(bool const & aIsFocusUsed)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acFocusOnRightEncoderReqUpd(aIsFocusUsed = %d)", aIsFocusUsed));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendFocusOnRightEncoderReqUpdMsg(aIsFocusUsed);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acSetGadgetSceenActiveStatus(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_acSetGadgetSceenActiveStatus(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_acSetGadgetSceenActiveStatus(bool const & aIsGadgetAtive)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acSetGadgetSceenActiveStatus(aIsGadgetAtive = %d)", aIsGadgetAtive));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStoreActiveGadgetReqMsg(aIsGadgetAtive);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acHKNotificationMsg(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_acHKNotificationMsg(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_acHKNotificationMsg(Courier::UInt8 const & aHKCode, Courier::UInt8 const & aHKState)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acHKNotificationMsg(aHKCode = %d, aHKState = %d)", aHKCode,aHKState));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendHardKeyPressNotificationMsg(1, aHKCode, aHKState);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseAllDropdowns(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_acPerform_CloseAllDropdowns();
    return true;
}
#endif
void Action_acPerform_CloseAllDropdowns()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPerform_CloseAllDropdowns()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_CloseDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_CloseDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_CloseDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPerform_CloseDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeClose, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_OpenDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_OpenDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_OpenDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPerform_OpenDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeOpen, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPerform_ToggleDropdown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acPerform_ToggleDropdown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acPerform_ToggleDropdown(::Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPerform_ToggleDropdown(aListId = ?::Courier::UInt32?)"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendDropdownChangeMsg(Candera::DropdownChangeToggle, aListId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_acStartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_acStartAppPopupTimer(Courier::UInt32 const & aViewId, Courier::UInt32 const & aTimeout)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStartAppPopupTimer(aViewId = %d, aTimeout = %d)", aViewId,aTimeout));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStartPopupTimerReqMsg(aViewId, aTimeout);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acStopAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acStopAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acStopAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acStopAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStopPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acPostBeep(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_acPostBeep(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_acPostBeep(Courier::Int32 const & aBeepType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acPostBeep(aBeepType = %d)", aBeepType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPlayBeepReqMsg(aBeepType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCheckToClosePopup(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacCheckToClosePopup(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacCheckToClosePopup(Courier::UInt32 const & aPopupId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacCheckToClosePopup(aPopupId = %d)", aPopupId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCheckToClosePopupMsg(aPopupId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_acRestartAppPopupTimer(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_acRestartAppPopupTimer(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_acRestartAppPopupTimer(Courier::UInt32 const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action acRestartAppPopupTimer(aViewId = %d)", aViewId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRestartPopupTimerReqMsg(aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchBackRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchBackRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchBackRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacContextSwitchBackRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_BACK);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchCompleteRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchCompleteRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchCompleteRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacContextSwitchCompleteRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_COMPLETE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchFailedRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchFailedRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchFailedRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacContextSwitchFailedRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_FAILED);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchDoneRes(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacContextSwitchDoneRes(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchDoneRes(Courier::UInt32 const & aSwitchId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacContextSwitchDoneRes(aSwitchId = %d)", aSwitchId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchInResMsg(aSwitchId, CONTEXT_TRANSITION_DONE);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacContextSwitchOutReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 3) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt())) { return false; }
    Action_gacContextSwitchOutReq(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt());
    return true;
}
#endif
void Action_gacContextSwitchOutReq(Courier::UInt32 const & aTargetContextId, Courier::UInt32 const & aSourceContextId, Courier::UInt32 const & aTargetAppId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacContextSwitchOutReq(aTargetContextId = %d, aSourceContextId = %d, aTargetAppId = %d)", aTargetContextId,aSourceContextId,aTargetAppId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendContextSwitchOutReqMsg(aTargetContextId, aSourceContextId, aTargetAppId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacCurrentScreenDisplayReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacCurrentScreenDisplayReq();
    return true;
}
#endif
void Action_gacCurrentScreenDisplayReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacCurrentScreenDisplayReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCurrentScreenDisplayReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacLaunchBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacLaunchBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacLaunchBarDisplayReq(bool const & aVisibility)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacLaunchBarDisplayReq(aVisibility = %d)", aVisibility));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendLaunchBarDisplayReqMsg(aVisibility);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacNavTBTSwipe(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacNavTBTSwipe();
    return true;
}
#endif
void Action_gacNavTBTSwipe()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacNavTBTSwipe()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNavTBTSwipeReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListBtnRightEncoderChangeUpd(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isUInt())) { return false; }
    Action_gacPerformListBtnRightEncoderChangeUpd(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt(), parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asUInt());
    return true;
}
#endif
void Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8 const & aSteps, Courier::UInt32 const & aListId, Courier::UInt32 const & aRowId, Courier::UInt32 const & aColumnId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPerformListBtnRightEncoderChangeUpd(aSteps = %d, aListId = %d, aRowId = %d, aColumnId = %d)", aSteps,aListId,aRowId,aColumnId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListItemRightEncoderChangeUpdMsg(aSteps, aListId, aRowId, aColumnId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListUp();
    return true;
}
#endif
void Action_gacScrollListUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollListUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollListDown();
    return true;
}
#endif
void Action_gacScrollListDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollListDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangeDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageUp(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageUp();
    return true;
}
#endif
void Action_gacScrollPageUp()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollPageUp()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageUp, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollPageDown(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacScrollPageDown();
    return true;
}
#endif
void Action_gacScrollPageDown()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollPageDown()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListChangeMsg(::Courier::UInt32(), ListChangePageDown, 1, ListChangeMsgSourceUnknown, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusUp(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusUp(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusUp(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusUp(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, -1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacScrollListFocusDown(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacScrollListFocusDown(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacScrollListFocusDown(Courier::UInt32 const & aListId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacScrollListFocusDown(aListId = %d)", aListId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusScrollReqMsg(aListId, 1);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPerformListFocusLockDataResetUpd(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPerformListFocusLockDataResetUpd();
    return true;
}
#endif
void Action_gacPerformListFocusLockDataResetUpd()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPerformListFocusLockDataResetUpd()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendListFocusLockDataResetReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSetApplicationMode(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacSetApplicationMode(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacSetApplicationMode(Courier::UInt32 const & aModeId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacSetApplicationMode(aModeId = %d)", aModeId));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSetApplicationModeReqMsg(aModeId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSpellerBbehaviorReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool())) { return false; }
    Action_gacSpellerBbehaviorReq(parameters[(::Json::Value::UInt)0].asBool());
    return true;
}
#endif
void Action_gacSpellerBbehaviorReq(bool const & aEnable)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacSpellerBbehaviorReq(aEnable = %d)", aEnable));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendSpellerBbehaviorReqMsg(aEnable);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStatusBarDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isBool() && parameters[(::Json::Value::UInt)1].isInt())) { return false; }
    Action_gacStatusBarDisplayReq(parameters[(::Json::Value::UInt)0].asBool(), parameters[(::Json::Value::UInt)1].asInt());
    return true;
}
#endif
void Action_gacStatusBarDisplayReq(bool const & aVisibility, Courier::Int32 const & aHeaderType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacStatusBarDisplayReq(aVisibility = %d, aHeaderType = %d)", aVisibility,aHeaderType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendStatusBarDisplayReqMsg(aVisibility, aHeaderType);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacTBTRetriggerAcousticOutput(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacTBTRetriggerAcousticOutput();
    return true;
}
#endif
void Action_gacTBTRetriggerAcousticOutput()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacTBTRetriggerAcousticOutput()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendTBTRetriggerAcousticMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacWaitAnimationStopReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacWaitAnimationStopReq();
    return true;
}
#endif
void Action_gacWaitAnimationStopReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacWaitAnimationStopReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAnimationReqMsg(Courier::AnimationAction::Stop, ::Courier::ViewId(), Courier::CompositePath(), ::Courier::ItemId("Global#Animations#WAIT_ANIMATION"), Courier::AnimationProperties());
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewCreateReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAllReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAllReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewCreateAllReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::CreateAll, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Destroy, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewClearReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewClearReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewClearReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Clear, aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewHideReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateWithoutLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateWithoutLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewCreateWithoutLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendViewReqMsg(Courier::ViewAction::Create, aViewId, false, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewAsyncLoadReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewAsyncLoadReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewAsyncLoadReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendAsyncLoadReqMsg(aViewId, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewActivateWithoutRenderingReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewActivateWithoutRenderingReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendActivationReqMsg(aViewId, true, false);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupCreateAndSBShowReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupCreateAndSBShowReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Show, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupSBCloseReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupSBCloseReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupSBCloseReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::Hide, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, hmibase::DEFAULT_UNKNOWN_DISPLAY);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupRestartTimerReqForMultiDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupRestartTimerReqForMultiDisplay(parameters[(::Json::Value::UInt)0].asUInt(), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt())));
    return true;
}
#endif
void Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32 const & aPopupDisplayID, ::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupRestartTimerReqForMultiDisplay(aPopupDisplayID = %d, aViewId = %50s)", aPopupDisplayID,aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupReqMsg(hmibase::popups::RestartTimer, aViewId, aPopupDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewCreateAndShowReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewCreateAndShowReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewCreateAndShowReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::CreateAndShow, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacViewHideAndDestroyReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacViewHideAndDestroyReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacViewHideAndDestroyReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::HideAndDestroy, aViewId, 0);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionEnter(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionEnter(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionEnter(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionEnter, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacSceneTransitionLeave(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacSceneTransitionLeave(::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacSceneTransitionLeave(aViewId = %50s, aHint = %d)", aViewId.CStr(),aHint));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendExtendedViewReqMsg(hmibase::views::TransitionLeave, aViewId, aHint);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacDisplayStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacHideStatusLineReq(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacHideStatusLineReq(Courier::Int32 const & aDisplayRegionType)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineReq(aDisplayRegionType = %d)", aDisplayRegionType));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDisplayFooterLineReq();
    return true;
}
#endif
void Action_gacDisplayFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), true, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacHideFooterLineReq();
    return true;
}
#endif
void Action_gacHideFooterLineReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, Courier::Int32(), false, hmibase::DEFAULT_UNKNOWN_DISPLAY, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDisplayStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideStatusLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideStatusLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideStatusLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacHideStatusLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::STATUS_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDisplayFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacDisplayFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDisplayFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, true, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacHideFooterLineMultiDisplayReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacHideFooterLineMultiDisplayReq(parameters[(::Json::Value::UInt)0].asInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacHideFooterLineMultiDisplayReq(Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacHideFooterLineMultiDisplayReq(aDisplayRegionType = %d, aDisplayID = %d)", aDisplayRegionType,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendShowHMISubSurfaceReqMsg(hmibase::FOOTER_LINE, aDisplayRegionType, false, aDisplayID, true);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacRegisterForCloseOnTouchSession(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacRegisterForCloseOnTouchSession(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(true, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDeregisterForCloseOnTouchSessionReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt())));
    return true;
}
#endif
void Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId const & aViewId)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDeregisterForCloseOnTouchSessionReq(aViewId = %50s)", aViewId.CStr()));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendRegisterForCloseOnTouchSessionReqMsg(false, aViewId);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReq(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReq(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReq(Courier::UInt32 const & aPrio)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReq(aPrio = %d)", aPrio));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterPrioEnableReqMsg(aPrio);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterAllEnableReq();
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterAllEnableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReq(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacPopupFilterDisableReq();
    return true;
}
#endif
void Action_gacPopupFilterDisableReq()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReq()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendPopupFilterDisableReqMsg();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacProfileChange(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isInt())) { return false; }
    Action_gacProfileChange(parameters[(::Json::Value::UInt)0].asInt());
    return true;
}
#endif
void Action_gacProfileChange(Courier::UInt32 const & aProfile)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacProfileChange(aProfile = %d)", aProfile));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendProfileSwitchMsg(aProfile);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterPrioEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 2) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt())) { return false; }
    Action_gacPopupFilterPrioEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt(), parameters[(::Json::Value::UInt)1].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32 const & aPrio, Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterPrioEnableReqForDisplay(aPrio = %d, aDisplayID = %d)", aPrio,aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_PRIO, aPrio, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterAllEnableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterAllEnableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterAllEnableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::ENABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacPopupFilterDisableReqForDisplay(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 1) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt())) { return false; }
    Action_gacPopupFilterDisableReqForDisplay(parameters[(::Json::Value::UInt)0].asUInt());
    return true;
}
#endif
void Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32 const & aDisplayID)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacPopupFilterDisableReqForDisplay(aDisplayID = %d)", aDisplayID));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendMultiDisplayPopupFilterReqMsg(hmibase::DISABLE_ALL, 0, aDisplayID);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacStartSceneTransitionAnimation(const ::Json::Value& parameters, ::Json::Value &/* response */)
{
    if (!parameters.isArray()) { return false; }
    if (parameters.size() != 4) { return false; }
    if (!(parameters[(::Json::Value::UInt)0].isUInt() && parameters[(::Json::Value::UInt)1].isUInt() && parameters[(::Json::Value::UInt)2].isUInt() && parameters[(::Json::Value::UInt)3].isInt())) { return false; }
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)0].asUInt(), ))::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(parameters[(::Json::Value::UInt)1].asUInt(), ))parameters[(::Json::Value::UInt)2].asUInt(), parameters[(::Json::Value::UInt)3].asInt());
    return true;
}
#endif
void Action_gacStartSceneTransitionAnimation(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1, Courier::Int8 const & aUserData2)
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacStartSceneTransitionAnimation(aSourceView = %50s, aDestinationView = %50s, aUserData1 = %d, aUserData2 = %d)", aSourceView.CStr(),aDestinationView.CStr(),aUserData1,aUserData2));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendCreateNewDestroyOld(aSourceView, aDestinationView, aUserData1, aUserData2);
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_gacDecrementActiveAnimationCount(const ::Json::Value& /* parameters */, ::Json::Value &/* response */)
{
    Action_gacDecrementActiveAnimationCount();
    return true;
}
#endif
void Action_gacDecrementActiveAnimationCount()
{
// ==== added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====
    ETG_TRACE_USR1_DCL((TR_CLASS_APPHMI_NAVIGATION_SM, "SM_ACTIONS:    Trigger action gacDecrementActiveAnimationCount()"));
// ==== key: SM_TTFis_SBHFMSRF ====
    bool ok = SendNotifierMessage();
    COURIER_UNUSED(ok);
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_fnGetVariantType(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)fnGetVariantType();
    return true;
}
#endif
// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgPOITopCategoryStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgPOITopCategoryStatus();
    return true;
}
#endif
bool Action_dgPOITopCategoryStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::POICategoryBrowseCheck::POITopCategoryStatusItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgPOIResultListStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgPOIResultListStatus();
    return true;
}
#endif
bool Action_dgPOIResultListStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::POICategoryBrowseCheck::POIResultListStatusItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgLatLongPopUpActive(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgLatLongPopUpActive();
    return true;
}
#endif
bool Action_dgLatLongPopUpActive()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::EnableSetLatLongButton::IsPopUpVisibleItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgMainMapScreenStateValue(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)Action_dgMainMapScreenStateValue();
    return true;
}
#endif
::FeatStd::UInt8 Action_dgMainMapScreenStateValue()
{
    const Courier::UInt8* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const Courier::UInt8 >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::MapMainScreenState::MapMainScreenStateValueItem);
    return (dataItem == 0) ? ::FeatStd::UInt8() : (::FeatStd::UInt8)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgRouteOverViewBtnEnabled(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (::Json::Value::UInt)Action_dgRouteOverViewBtnEnabled();
    return true;
}
#endif
::FeatStd::UInt8 Action_dgRouteOverViewBtnEnabled()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::RouteOverviewBtn::IsRouteOverviewBtnEnabledItem);
    return (dataItem == 0) ? ::FeatStd::UInt8() : (::FeatStd::UInt8)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgEngineeringMenuListStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgEngineeringMenuListStatus();
    return true;
}
#endif
bool Action_dgEngineeringMenuListStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::EngineeringMenuListCheck::EngineeringMenuListStatusItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgEngineeringMenuTopListStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgEngineeringMenuTopListStatus();
    return true;
}
#endif
bool Action_dgEngineeringMenuTopListStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::EngineeringMenuListCheck::EngineeringMenuTopListStatusItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}

// ------------------------------------------------------------------------
#ifdef CIT_SIMULATION
bool CallAction_dgNaviMiddlewareStatus(const ::Json::Value& /* parameters */, ::Json::Value &response)
{
    response["result"] = (bool)Action_dgNaviMiddlewareStatus();
    return true;
}
#endif
bool Action_dgNaviMiddlewareStatus()
{
    const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool >(
        ::Courier::ComponentId(::Courier::ComponentType::Controller),
        ItemKey::NaviMiddlewareStatus::IsNaviMiddlewareActiveItem);
    return (dataItem == 0) ? bool() : (bool)*dataItem;
}
//====  defines and includes TTFis output - added by SM_TTFis script!  key: SM_TTFis_SBHFMSRF ====    

unsigned short AppHmi_NavigationStateMachineImpl::GetTraceClass (){  
   return TR_CLASS_APPHMI_NAVIGATION_SM; 
}

//====  member function with TTFis output - end                        key: SM_TTFis_SBHFMSRF ==== 

#include "hmibase/util/Macros.h"

#ifdef CIT_SIMULATION
#define CIT_EVENT_ID(eventId, hashId) hashId
#else
#define CIT_EVENT_ID(eventId, hashId) eventId
#endif
// ------------------------------------------------------------------------
static bool HandleEventMappingForNavigationViewMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onNavigationViewMsg, 0xDDA1D21B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNavigationViewMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onMapOkButton
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onMapOkButton 0xffff
#pragma _REMINDER("Using dummy value symbol onMapOkButton ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onMapOkButton -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onEvCompass
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEvCompass 0xffff
#pragma _REMINDER("Using dummy value symbol onEvCompass ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEvCompass -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onEVLocationMapScroll
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEVLocationMapScroll 0xffff
#pragma _REMINDER("Using dummy value symbol onEVLocationMapScroll ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEVLocationMapScroll -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_N_SpellerEdit_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_SpellerEdit_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_SpellerEdit_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_SpellerEdit_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_N_Map_ZoomIn_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_Map_ZoomIn_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_Map_ZoomIn_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_Map_ZoomIn_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_N_Map_ZoomOut_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_Map_ZoomOut_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_Map_ZoomOut_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_Map_ZoomOut_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForButtonReactionMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);

#ifdef ev_N_Disclaimer_Confirm_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Disclaimer")) && (message.GetSender() == ::Courier::Identifier(0xfd3966dc /* Layer_Confirm/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Disclaimer_Confirm_touch, 0xB4A58C3A); return true; }
#endif
#ifdef ev_N_Pfo_LastDest_Delete_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MultiLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_LastDest_Delete_No_touch, 0xF45329CC); return true; }
#endif
#ifdef ev_N_Pfo_LastDest_Delete_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MultiLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_LastDest_Delete_Yes_touch, 0x3E808BD1); return true; }
#endif
#ifdef ev_N_AddressInputDetails_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDest_AddressInput")) && (message.GetSender() == ::Courier::Identifier(0xcb7d191b /* Layer_Details/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_AddressInputDetails_touch, 0xEA787173); return true; }
#endif
#ifdef ev_N_DetailedInfo_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Address_DetailedInfo")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_DetailedInfo_Back_touch, 0x3B58F7C7); return true; }
#endif
#ifdef ev_N_SpellerExpander_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Speller_MatchList")) && (message.GetSender() == ::Courier::Identifier(0xfb6d39e0 /* Layer_SpellerExpander/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SpellerExpander_touch, 0x65F77E34); return true; }
#endif
#ifdef ev_N_Dest_Guidance_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Dest_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Dest_Guidance_Back_touch, 0x4C8CA81C); return true; }
#endif
#ifdef ev_N_MyPOIs_AddressInput_CategoryRoot_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MyPOIs_AddressInput")) && (message.GetSender() == ::Courier::Identifier(0x0ea2607c /* Layer_POISearch/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MyPOIs_AddressInput_CategoryRoot_touch, 0x1EF09283); return true; }
#endif
#ifdef ev_N_POI_FreeTextSearch_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_POI_CategoryRoot")) && (message.GetSender() == ::Courier::Identifier(0xb60daaf3 /* Layer_Search/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_POI_FreeTextSearch_touch, 0x727C4C8C); return true; }
#endif
#ifdef ev_N_FavoritesNewtab_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Favorites")) && (message.GetSender() == ::Courier::Identifier(0x0743e435 /* Layer_New/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_FavoritesNewtab_touch, 0x9279AC87); return true; }
#endif
#ifdef ev_N_Favorites_Prevtab_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Favorites")) && (message.GetSender() == ::Courier::Identifier(0xf8a04344 /* Layer_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Favorites_Prevtab_touch, 0x809877AD); return true; }
#endif
#ifdef ev_N_Favorites_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x0c2f68c4 /* Layer_Favorites/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Favorites_touch, 0x4B37E7CD); return true; }
#endif
#ifdef ev_Favorites_Home_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Fav_SetHome")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Favorites_Home_back_touch, 0x0D824A39); return true; }
#endif
#ifdef ev_N_ShowRouteList_BackTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance_ShowRouteList")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_ShowRouteList_BackTouch, 0x91C81897); return true; }
#endif
#ifdef ev_N_BlockRouteList_BackTouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance_BlockRouteList")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_BlockRouteList_BackTouch, 0x8B6C9ED9); return true; }
#endif
#ifdef ev_N_Map_POINearBy_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0x4a94ee72 /* Layer_POIsNearby/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_POINearBy_touch, 0xC30F8252); return true; }
#endif
#ifdef ev_N_OPTMapOptions_MapColor_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOption_MapColor")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_MapColor_back_touch, 0xC1FBA0B0); return true; }
#endif
#ifdef ev_N_OPTMapOptions_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_Back_touch, 0x931B9263); return true; }
#endif
#ifdef ev_N_Pfo_LastDest_Delete_all_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Address_DetailedInfo")) && (message.GetSender() == ::Courier::Identifier(0x7d68c369 /* Layer_DeleteAll/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_LastDest_Delete_all_touch, 0x65161EC6); return true; }
#endif
#ifdef ev_N_OPTMapOptions_OnMap_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOptions_OnMap")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_OnMap_Back_touch, 0x70E56B3F); return true; }
#endif
#ifdef ev_N_Pfo_LastDest_Delete_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Address_DetailedInfo")) && (message.GetSender() == ::Courier::Identifier(0x619e287d /* Layer_Delete/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_LastDest_Delete_touch, 0x68B7CB05); return true; }
#endif
#ifdef ev_N_POI_CategorySublevel_Back_1_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_POI_CategorySublevel")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_POI_CategorySublevel_Back_1_touch, 0x38FE4A1F); return true; }
#endif
#ifdef ev_N_Favorite_Map_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Favorites")) && (message.GetSender() == ::Courier::Identifier(0xb88e7e87 /* Layer_TouchArea_Map/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Favorite_Map_touch, 0x2E097943); return true; }
#endif
#ifdef ev_N_Favorite_Home_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Favorites")) && (message.GetSender() == ::Courier::Identifier(0x468170f5 /* Layer_TouchArea_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Favorite_Home_touch, 0x81B931EC); return true; }
#endif
#ifdef ev_N_Guidance_Map_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0xb88e7e87 /* Layer_TouchArea_Map/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Map_touch, 0xFF4B0BB3); return true; }
#endif
#ifdef ev_N_Guidance_Home_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x468170f5 /* Layer_TouchArea_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Home_touch, 0x6409C3C5); return true; }
#endif
#ifdef ev_N_NewDest_AddressInput_Back_1_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDest_AddressInput")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDest_AddressInput_Back_1_touch, 0xA5A1B2A1); return true; }
#endif
#ifdef ev_N_Destination_Previous_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0xf8a04344 /* Layer_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Destination_Previous_touch, 0x7B9E961F); return true; }
#endif
#ifdef ev_N_LastDestinations_New_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LastDestinations")) && (message.GetSender() == ::Courier::Identifier(0x0743e435 /* Layer_New/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LastDestinations_New_touch, 0xF0C07B6B); return true; }
#endif
#ifdef ev_N_LastDestinations_fav_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LastDestinations")) && (message.GetSender() == ::Courier::Identifier(0x0c2f68c4 /* Layer_Favorites/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LastDestinations_fav_touch, 0x39D2BBF5); return true; }
#endif
#ifdef ev_N_SpellerEdit_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_SpellerEdit")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SpellerEdit_Back_touch, 0x80A4C892); return true; }
#endif
#ifdef ev_N_SpellerMatchList_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Speller_MatchList")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SpellerMatchList_Back_touch, 0x76D9CED4); return true; }
#endif
#ifdef ev_N_NewDestination_POI_Nearby_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x4a94ee72 /* Layer_POIsNearby/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_POI_Nearby_touch, 0x4915BA8B); return true; }
#endif
#ifdef ev_N_NewDestination_My_POI_Nearby_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0xf5077a3b /* Layer_MyPOIsNearby/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_My_POI_Nearby_touch, 0xDF842EF4); return true; }
#endif
#ifdef ev_N_NewDestination_POI_Search_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x0ea2607c /* Layer_POISearch/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_POI_Search_touch, 0xBC7D3575); return true; }
#endif
#ifdef ev_N_NewDestination_My_POI_Search_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x062e0008 /* Layer_MyPOIsSearch/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_My_POI_Search_touch, 0x8B1D0C98); return true; }
#endif
#ifdef ev_N_MyPOIs_AddressInput_NewDestination_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MyPOIs_AddressInput")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MyPOIs_AddressInput_NewDestination_touch, 0x1D7F21E9); return true; }
#endif
#ifdef ev_N_Address_DetailedInfo_Fav_AddFavorites_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Address_DetailedInfo")) && (message.GetSender() == ::Courier::Identifier(0xb28ca96a /* Layer_Favourites/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Address_DetailedInfo_Fav_AddFavorites_touch, 0x9226AE0D); return true; }
#endif
#ifdef ev_N_POI_CategoryRoot_Back_1_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_POI_CategoryRoot")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_POI_CategoryRoot_Back_1_touch, 0x1B8132A1); return true; }
#endif
#ifdef ev_N_POI_List_Back_1_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_POI_List")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_POI_List_Back_1_touch, 0x277D1059); return true; }
#endif
#ifdef ev_N_OPTMapOptions_Others_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOption_Others")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_Others_Back_touch, 0x2C94970F); return true; }
#endif
#ifdef ev_N_MapMove_ZoomIn_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0x7e5e8db0 /* Layer_ZoomIn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapMove_ZoomIn_touch, 0x753866F6); return true; }
#endif
#ifdef ev_N_MapMove_ZoomOut_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0x3906ee6a /* Layer_ZoomOut/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapMove_ZoomOut_touch, 0x47FF854B); return true; }
#endif
#ifdef ev_N_Previous_Route_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LastDestinations")) && (message.GetSender() == ::Courier::Identifier(0xb1de7bab /* Layer_Route/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Previous_Route_touch, 0x8B3B7AF1); return true; }
#endif
#ifdef ev_N_Guidance_Favorites_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x0c2f68c4 /* Layer_Favorites/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Favorites_touch, 0x473E2FEB); return true; }
#endif
#ifdef ev_N_Favorites_Route_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Favorites")) && (message.GetSender() == ::Courier::Identifier(0xb1de7bab /* Layer_Route/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Favorites_Route_touch, 0x33FBB14F); return true; }
#endif
#ifdef ev_N_ShowRouteList_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x37a73479 /* Layer_ShowRouteList/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_ShowRouteList_touch, 0x0439DDCE); return true; }
#endif
#ifdef ev_N_Alternateroute_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Alternateroute")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Alternateroute_Yes_touch, 0x03466B12); return true; }
#endif
#ifdef ev_N_Alternateroute_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Alternateroute")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Alternateroute_No_touch, 0x3E98E72C); return true; }
#endif
#ifdef ev_N_Dest_Guidance_Map_Display_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Dest_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Dest_Guidance_Map_Display_touch, 0x314AF035); return true; }
#endif
#ifdef ev_N_Dest_Guidance_Replace_Destination_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Dest_Guidance")) && (message.GetSender() == ::Courier::Identifier(0xa0a19283 /* Layer_EditName/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Dest_Guidance_Replace_Destination_touch, 0x62E41263); return true; }
#endif
#ifdef ev_N_Map_ActivateRGFastestSelectionBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0xc0365861 /* Button_Multipletext_Fastest/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ActivateRGFastestSelectionBtn, 0xEB62D68D); return true; }
#endif
#ifdef ev_N_Map_ActivateRGEconomicSelectionBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0x51e85924 /* Button_Multipletext_Economic/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ActivateRGEconomicSelectionBtn, 0x587887FC); return true; }
#endif
#ifdef ev_N_Map_ActivateRGShortestSelectionBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0x57d96fdc /* Button_Multipletext_Shortest/ButtonWidget2D */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ActivateRGShortestSelectionBtn, 0x6BB8E327); return true; }
#endif
#ifdef ev_N_Map_ActivateRGstartGuidanceSelectionBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0xbd88953a /* Layer_GuidanceForRoute/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ActivateRGstartGuidanceSelectionBtn, 0xF6B25AC4); return true; }
#endif
#ifdef ev_NavDataUpdate_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Interactive")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_NavDataUpdate_No_touch, 0xF3EB342F); return true; }
#endif
#ifdef ev_NavDataUpdate_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Interactive")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_NavDataUpdate_Yes_touch, 0xD5CF5E82); return true; }
#endif
#ifdef ev_NavDataUpdateError_OK_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Error")) && (message.GetSender() == ::Courier::Identifier(0x0f5c304a /* Layer_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_NavDataUpdateError_OK_touch, 0x8435458C); return true; }
#endif
#ifdef ev_NavDataUpdateProgress_OK_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Progress")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_NavDataUpdateProgress_OK_touch, 0xBE519690); return true; }
#endif
#ifdef ev_OnNavigationButton_Backtouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Testmode_EngineeringMenu")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnNavigationButton_Backtouch, 0x5F60DF88); return true; }
#endif
#ifdef ev_N_Guidance_Previous_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0xf8a04344 /* Layer_Previous/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Previous_touch, 0x5E7CBF66); return true; }
#endif
#ifdef ev_N_Guidance_POIsatDestination_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0xb57c49b1 /* Layer_POIsAtDestination/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_POIsatDestination_touch, 0x16B4C964); return true; }
#endif
#ifdef ev_N_PickInMapOption_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_PickInMapOption")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_PickInMapOption_Back_touch, 0x2CB72C98); return true; }
#endif
#ifdef ev_N_Guidance_Waypoint_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Waypoints")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Waypoint_Back_touch, 0xC198D341); return true; }
#endif
#ifdef ev_N_LeftMapScale_ZoomIn_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MapScale")) && (message.GetSender() == ::Courier::Identifier(0x7e5e8db0 /* Layer_ZoomIn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LeftMapScale_ZoomIn_touch, 0x1DC94BDF); return true; }
#endif
#ifdef ev_N_LeftMapScale_ZoomOut_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MapScale")) && (message.GetSender() == ::Courier::Identifier(0x3906ee6a /* Layer_ZoomOut/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LeftMapScale_ZoomOut_touch, 0x7FBB27FF); return true; }
#endif
#ifdef ev_N_Alternateroute_ZoomIn_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Alternateroute")) && (message.GetSender() == ::Courier::Identifier(0x7e5e8db0 /* Layer_ZoomIn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Alternateroute_ZoomIn_touch, 0x2FDD556D); return true; }
#endif
#ifdef ev_N_Alternateroute_ZoomOut_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Alternateroute")) && (message.GetSender() == ::Courier::Identifier(0x3906ee6a /* Layer_ZoomOut/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Alternateroute_ZoomOut_touch, 0x144F9439); return true; }
#endif
#ifdef ev_N_StreamedMap_Settings_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_StreamedMap_Settings")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_StreamedMap_Settings_Back_touch, 0xE62300B5); return true; }
#endif
#ifdef ev_N_StreamedMap_SettingsSubOptions_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_StreamedMap_SubOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_StreamedMap_SettingsSubOptions_Back_touch, 0x4C7D13ED); return true; }
#endif
#ifdef ev_N_MapActiveRG_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapActiveRG_back_touch, 0xADBF6DC7); return true; }
#endif
#ifdef ev_N_MapActiveRG_RoutePreference_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0xdc294380 /* Layer_RoutePreference/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapActiveRG_RoutePreference_touch, 0x2B7D8530); return true; }
#endif
#ifdef ev_OnEnggDetails_Backtouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Testmode_EngineeringMenuDetails")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnEnggDetails_Backtouch, 0x06B172D9); return true; }
#endif
#ifdef ev_N_MapActiveRG_RouteOverview
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x3a12a768 /* Layer_RouteOverview/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapActiveRG_RouteOverview, 0x50AF6E2D); return true; }
#endif
#ifdef ev_N_Pfo_DestVehicleInfo_StartGuidance_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_Dest_VehicleInfo")) && (message.GetSender() == ::Courier::Identifier(0xb2ec3415 /* Layer_StartGuidance/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_DestVehicleInfo_StartGuidance_touch, 0x2ABAF108); return true; }
#endif
#ifdef ev_N_Pfo_DestVehicleInfo_ChangeProfile_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_Dest_VehicleInfo")) && (message.GetSender() == ::Courier::Identifier(0x800d72ac /* Layer_ChangeProfile/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_DestVehicleInfo_ChangeProfile_touch, 0x62C227C4); return true; }
#endif
#ifdef ev_N_Pfo_FourLine_SingleButton_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_FourLine_SingleButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_FourLine_SingleButton_Yes_touch, 0x0B48E710); return true; }
#endif
#ifdef ev_N_Guidance_StopGuidance_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x7e51342d /* Layer_StopGuidance/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_StopGuidance_touch, 0x9D407C51); return true; }
#endif
#ifdef ev_N_Guidance_New_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x0743e435 /* Layer_New/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_New_touch, 0x53EC8EC9); return true; }
#endif
#ifdef ev_N_NewDestination_Route_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0xb1de7bab /* Layer_Route/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_Route_touch, 0xF5DBC32E); return true; }
#endif
#ifdef ev_N_Guidance_POIsonRoute_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0x024b3f78 /* Layer_POIsonRoute/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_POIsonRoute_touch, 0x6CF22BC6); return true; }
#endif
#ifdef ev_N_Guidance_Waypoint_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance")) && (message.GetSender() == ::Courier::Identifier(0xda33be1c /* Layer_Waypoints/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Guidance_Waypoint_touch, 0x2E2889F8); return true; }
#endif
#ifdef ev_N_MapActiveRG_NormalMapView
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x1bbd982e /* Layer_MapOverview/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapActiveRG_NormalMapView, 0x654E4085); return true; }
#endif
#ifdef ev_N_NewDestination_Map_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0xb88e7e87 /* Layer_TouchArea_Map/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_Map_touch, 0xAD803C65); return true; }
#endif
#ifdef ev_N_NewDestination_Home_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x468170f5 /* Layer_TouchArea_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_Home_touch, 0x08C22AFD); return true; }
#endif
#ifdef ev_N_LastDestinations_Home_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LastDestinations")) && (message.GetSender() == ::Courier::Identifier(0x468170f5 /* Layer_TouchArea_Home/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LastDestinations_Home_touch, 0xAA0065BF); return true; }
#endif
#ifdef ev_N_ShowPOIDetailForCoordinates
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x9b0c8427 /* Layer_SetLatlLong/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_ShowPOIDetailForCoordinates, 0x59489D8C); return true; }
#endif
#ifdef ev_N_Fav_AddFavorites_Edit_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Fav_AddFavorites")) && (message.GetSender() == ::Courier::Identifier(0xa0a19283 /* Layer_EditName/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Fav_AddFavorites_Edit_touch, 0x460BF28F); return true; }
#endif
#ifdef ev_N_GeoCordinates_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_GeoCordinates_Back_touch, 0x343AD03D); return true; }
#endif
#ifdef ev_N_SpellerEdit_FreeText_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_SpellerEdit_FreeText")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SpellerEdit_FreeText_Back_touch, 0xF4FA9AAE); return true; }
#endif
#ifdef ev_N_Fav_AddFavorites_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Fav_AddFavorites")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Fav_AddFavorites_Back_touch, 0x54A697D9); return true; }
#endif
#ifdef ev_N_Fav_AddFavorites_Save_Displayed_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Fav_AddFavorites")) && (message.GetSender() == ::Courier::Identifier(0x9664a16a /* Layer_SaveWithDisplayedName/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Fav_AddFavorites_Save_Displayed_touch, 0x54553B2A); return true; }
#endif
#ifdef ev_N_MaxFavReached_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MaxFavReached_Yes_touch, 0xCDA17FBA); return true; }
#endif
#ifdef ev_N_MaxFavReached_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MaxFavReached_No_touch, 0x0BBF1EFD); return true; }
#endif
#ifdef ev_Pfo_AvoidTollRoad_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_AvoidTollRoad")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_AvoidTollRoad_Yes_touch, 0x2024F18A); return true; }
#endif
#ifdef ev_Pfo_AvoidTollRoad_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_AvoidTollRoad")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_AvoidTollRoad_No_touch, 0x96896ECA); return true; }
#endif
#ifdef ev_N_Pfo_FiveLine_TwoButton_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_FiveLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_FiveLine_TwoButton_Yes_touch, 0xECA1F091); return true; }
#endif
#ifdef ev_N_Pfo_FiveLine_TwoButton_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_FiveLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Pfo_FiveLine_TwoButton_No_touch, 0x24D8921D); return true; }
#endif
#ifdef ev_N_GeoCordinates_ToggleSouthNorth
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x6e876d66 /* Layer_Dial_Alternate_Latitude/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_GeoCordinates_ToggleSouthNorth, 0x5B0386F7); return true; }
#endif
#ifdef ev_N_GeoCordinates_ToggleEastWest
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0xa8684b5d /* Layer_Dial_Alternate_Longitude/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_GeoCordinates_ToggleEastWest, 0xF1766B33); return true; }
#endif
#ifdef ev_N_GeoCordinates_ChangeLatLongFormat
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x2486b1c9 /* Layer_Dial_ChangePecision/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_GeoCordinates_ChangeLatLongFormat, 0xCAD4B145); return true; }
#endif
#ifdef ev_Set_LatDegreesActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x85f03bdc /* Layer_LatDegrees/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LatDegreesActive, 0x1D5865C6); return true; }
#endif
#ifdef ev_N_NewDestination_NewAddress_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x7e0ffc14 /* Layer_NewAddress/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_NewDestination_NewAddress_touch, 0xF61CBDFD); return true; }
#endif
#ifdef ev_N_GeoCordinates_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0xc878a059 /* Layer_GeoCoordinates/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_GeoCordinates_touch, 0xE10B7A97); return true; }
#endif
#ifdef ev_Set_LatMinutesActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x224f1551 /* Layer_LatMinutes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LatMinutesActive, 0x8F304B4C); return true; }
#endif
#ifdef onEvMapCenterBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0x2f3e96ce /* Layer_MapCenter/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvMapCenterBtn, 0x74B6BF44); return true; }
#endif
#ifdef onEvCompassLeftMapScaleBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MapScale")) && (message.GetSender() == ::Courier::Identifier(0xeb7fd048 /* Layer_Compass/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvCompassLeftMapScaleBtn, 0x307CEC79); return true; }
#endif
#ifdef ev_N_Map_Destination_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0x805c9071 /* Layer_TouchArea_Destinations/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_Destination_touch, 0x0A0DAFAB); return true; }
#endif
#ifdef ev_Favorites_AddressInput_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Fav_SetHome")) && (message.GetSender() == ::Courier::Identifier(0xdccfb501 /* Layer_EnterAddress/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Favorites_AddressInput_touch, 0x48AA0BF4); return true; }
#endif
#ifdef ev_N_Navigation_Gadget_NavigationTitle_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Navigation_Gadget")) && (message.GetSender() == ::Courier::Identifier(0xe66c1f99 /* TouchArea_NaviBtn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Navigation_Gadget_NavigationTitle_touch, 0xBB61861D); return true; }
#endif
#ifdef ev_N_Navigation_Gadget_NavigationBG_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Navigation_Gadget")) && (message.GetSender() == ::Courier::Identifier(0x2684214a /* TouchArea_NaviTile_Bg/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Navigation_Gadget_NavigationBG_touch, 0x1B361EBB); return true; }
#endif
#ifdef ev_N_Map_TMC_Touch_ActiveRouteGuidance
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x87f62864 /* Button_TMC/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_TMC_Touch_ActiveRouteGuidance, 0x32AC175F); return true; }
#endif
#ifdef ev_N_TMC_OnRoute_Button_All
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_TMC_OnRoute")) && (message.GetSender() == ::Courier::Identifier(0x03a62ca0 /* Layer_All/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_TMC_OnRoute_Button_All, 0xFA741BB2); return true; }
#endif
#ifdef ev_N_TMC_Map_ActiveRG_OnRoute
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_TMC_AllActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x5d831679 /* Layer_onRoute/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_TMC_Map_ActiveRG_OnRoute, 0x334FC07C); return true; }
#endif
#ifdef ev_N_TMC_Map_ActiveRG_TouchareaBack
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_TMC_AllActiveRG")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_TMC_Map_ActiveRG_TouchareaBack, 0x484C6E7D); return true; }
#endif
#ifdef ev_N_TMC_OnRoute_TouchAreaBack
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_TMC_OnRoute")) && (message.GetSender() == ::Courier::Identifier(0x805c9071 /* Layer_TouchArea_Destinations/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_TMC_OnRoute_TouchAreaBack, 0x4E5453C8); return true; }
#endif
#ifdef ev_N_TMC_AllNoRG_TouchAreaBack
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_TMC_AllNoRG")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_TMC_AllNoRG_TouchAreaBack, 0x157702DD); return true; }
#endif
#ifdef ev_N_Map_NoRG_Move_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x732df284 /* Layer_ByMap/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_NoRG_Move_touch, 0x088D477D); return true; }
#endif
#ifdef ev_N_Map_NoRG_Move_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_NoRG_Move_Back_touch, 0x09635AFB); return true; }
#endif
#ifdef ev_N_MapScale_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_MapScale")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapScale_Back_touch, 0x28533CAB); return true; }
#endif
#ifdef ev_N_POIInfo_Back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_POIInfo")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_POIInfo_Back_touch, 0x8BDDF654); return true; }
#endif
#ifdef onMapPOIOkButton
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0x2bf43478 /* Layer_POI_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onMapPOIOkButton, 0xC94AA027); return true; }
#endif
#ifdef onEvCompassMapSplitView
    if ((message.GetSender() == ::Courier::Identifier(0xef2ecac8 /* Layer_Compass_SplitMap/ButtonWidget */)) && (message.GetEnReaction() == enRelease) && (message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map"))) { eventId = CIT_EVENT_ID(onEvCompassMapSplitView, 0x0A49EA5B); return true; }
#endif
#ifdef onEvCompassMapMoveBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map_Move")) && (message.GetSender() == ::Courier::Identifier(0xeb7fd048 /* Layer_Compass/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvCompassMapMoveBtn, 0x0C649D11); return true; }
#endif
#ifdef onEvCompassTrafficDetourBtn
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Alternateroute")) && (message.GetSender() == ::Courier::Identifier(0xeb7fd048 /* Layer_Compass/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvCompassTrafficDetourBtn, 0x3884FD9C); return true; }
#endif
#ifdef ev_Set_LatSecondsActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x7bf14681 /* Layer_LatSeconds/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LatSecondsActive, 0xDF1FDBB3); return true; }
#endif
#ifdef ev_Pfo_XUrgent_Message_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_XUrgent_Message")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_XUrgent_Message_Yes_touch, 0xC90EE55C); return true; }
#endif
#ifdef ev_Set_LatDecimalsActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0xa2aa825b /* Layer_LatDecimals/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LatDecimalsActive, 0x5C898A0C); return true; }
#endif
#ifdef ev_N_OptPremiumTraffic_Disclaimer_Decline_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_PremiumTraffic_Disclaimer")) && (message.GetSender() == ::Courier::Identifier(0xb61c123d /* Layer_Decline/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptPremiumTraffic_Disclaimer_Decline_touch, 0x53CF7870); return true; }
#endif
#ifdef ev_N_OPT_TrafficIcons_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficOptions")) && (message.GetSender() == ::Courier::Identifier(0x65fe8c5b /* Layer_TrafficIcons/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_TrafficIcons_touch, 0xCA0F1260); return true; }
#endif
#ifdef ev_N_OptTrafficIcons_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficIcons")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptTrafficIcons_back_touch, 0xC1697C56); return true; }
#endif
#ifdef ev_ResetAllNaviSettings_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_SingleLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_ResetAllNaviSettings_No_touch, 0x0798B0C6); return true; }
#endif
#ifdef ev_ResetAllNaviSettings_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_SingleLine_TwoButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_ResetAllNaviSettings_Yes_touch, 0x01E354F2); return true; }
#endif
#ifdef ev_Pfo_SingleLine_SingleButton_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_SingleLine_SingleButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_SingleLine_SingleButton_Yes_touch, 0xDB73B368); return true; }
#endif
#ifdef ev_Pfo_ThreeLine_OneButton_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_OneButton")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_ThreeLine_OneButton_Yes_touch, 0xBEA799EB); return true; }
#endif
#ifdef ev_Pfo_LCVRestrictionInfo_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LCVRestrictionInfo")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_LCVRestrictionInfo_Yes_touch, 0xAA8EEC84); return true; }
#endif
#ifdef ev_ReplaceFavorite_Backtouch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_ReplaceFavorites")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_ReplaceFavorite_Backtouch, 0xF3B28149); return true; }
#endif
#ifdef ev_Pfo_SoftPhysicalRestrictionInfo_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_SoftPhysicalRestrictionInfo")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_SoftPhysicalRestrictionInfo_Yes_touch, 0x317896C4); return true; }
#endif
#ifdef ev_Pfo_PremiumTrafficDisabled_Ok_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_PremiumTrafficDisabled")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_PremiumTrafficDisabled_Ok_touch, 0xFE3206D8); return true; }
#endif
#ifdef ev_Pfo_LCVHardRestrictionInfo_Multiple_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionInfo_Multiple")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_LCVHardRestrictionInfo_Multiple_Yes_touch, 0x8665C59F); return true; }
#endif
#ifdef ev_Pfo_LCVHardRestrictionConfirm_Multiple_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionConfirm_Multiple")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_LCVHardRestrictionConfirm_Multiple_Yes_touch, 0xA90957A8); return true; }
#endif
#ifdef ev_Pfo_LCVHardRestrictionConfirm_Multiple_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionConfirm_Multiple")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_LCVHardRestrictionConfirm_Multiple_No_touch, 0xCBE53344); return true; }
#endif
#ifdef ev_Pfo_LCVHardRestrictionInfo_ActiveRG_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionInfo_ActiveRG")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_LCVHardRestrictionInfo_ActiveRG_Yes_touch, 0xFE0F2C75); return true; }
#endif
#ifdef ev_Pfo_Warning_CarModeSelection_Yes_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_Warning_CarModeSelection")) && (message.GetSender() == ::Courier::Identifier(0xeaebbe6c /* Layer_Yes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_Warning_CarModeSelection_Yes_touch, 0xF2BE5666); return true; }
#endif
#ifdef ev_Pfo_Warning_CarModeSelection_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_Warning_CarModeSelection")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_Warning_CarModeSelection_No_touch, 0x62D24D8B); return true; }
#endif
#ifdef ev_N_LastDestinations_Map_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LastDestinations")) && (message.GetSender() == ::Courier::Identifier(0xb88e7e87 /* Layer_TouchArea_Map/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LastDestinations_Map_touch, 0xAAFA4ED2); return true; }
#endif
#ifdef ev_Pfo_SoftPhysicalRestrictionInfo_No_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_SoftPhysicalRestrictionInfo")) && (message.GetSender() == ::Courier::Identifier(0xb5018479 /* Layer_No/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Pfo_SoftPhysicalRestrictionInfo_No_touch, 0xA275FA19); return true; }
#endif
#ifdef ev_N_OptPremiumTraffic_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_PremiumTraffic")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptPremiumTraffic_back_touch, 0xD6C79322); return true; }
#endif
#ifdef ev_N_OptPremiumTraffic_Disclaimer_OK_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_PremiumTraffic_Disclaimer")) && (message.GetSender() == ::Courier::Identifier(0x0f5c304a /* Layer_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptPremiumTraffic_Disclaimer_OK_touch, 0x5D38A234); return true; }
#endif
#ifdef ev_N_OptPremiumTraffic_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficOptions")) && (message.GetSender() == ::Courier::Identifier(0x76eac1fe /* Layer_PremiumTraffic/Button */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptPremiumTraffic_touch, 0x5CCED270); return true; }
#endif
#ifdef ev_N_Opt_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_NewDestination")) && (message.GetSender() == ::Courier::Identifier(0x202ad7c0 /* Layer_Settings/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Opt_touch, 0xC14B9692); return true; }
#endif
#ifdef ev_N_Opt_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Opt_back_touch, 0x88B623CE); return true; }
#endif
#ifdef ev_N_SettingsVehicleParameter_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_VehicleOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SettingsVehicleParameter_back_touch, 0x2B26EF67); return true; }
#endif
#ifdef ev_Set_LongSecondsActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x3f457728 /* Layer_LongSeconds/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LongSecondsActive, 0xDDEB6848); return true; }
#endif
#ifdef ev_N_OPT_POsitionAndGpsInfo_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_PositionAndGPSInfo")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_POsitionAndGpsInfo_back_touch, 0xC1401EEE); return true; }
#endif
#ifdef ev_N_OPT_POsitionAndGpsInfoCabinOnly_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_PositionAndGPSInfo_CabinOnly")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_POsitionAndGpsInfoCabinOnly_back_touch, 0x9A11AE20); return true; }
#endif
#ifdef ev_N_OPT_MyPOIs_POIOPT_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_MyPOIs_POIOPT")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_MyPOIs_POIOPT_back_touch, 0x32FB39B0); return true; }
#endif
#ifdef ev_Set_LongDecimalsActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x01f6292a /* Layer_LongDecimals/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LongDecimalsActive, 0xD7BFC39F); return true; }
#endif
#ifdef ev_Set_LongMinutesActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x1bf00ed7 /* Layer_LongMinutes/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LongMinutesActive, 0x8186352B); return true; }
#endif
#ifdef ev_N_OptRouteOptions_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_RouteOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptRouteOptions_back_touch, 0x8D03FF0C); return true; }
#endif
#ifdef ev_Set_LongDegreesActive
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_LatLongInput")) && (message.GetSender() == ::Courier::Identifier(0x5c20ea7c /* Layer_LongDegrees/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_Set_LongDegreesActive, 0x6376DC73); return true; }
#endif
#ifdef ev_N_OptRouteOptions_Others_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_RouteOptions_Others")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptRouteOptions_Others_back_touch, 0x1AF75D90); return true; }
#endif
#ifdef ev_N_OptGuidanceOptions_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_GuidanceOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptGuidanceOptions_back_touch, 0x6CE0C1F3); return true; }
#endif
#ifdef ev_N_OptSafetySettings_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_SpeedLimitOption")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptSafetySettings_back_touch, 0xA1D5C8FC); return true; }
#endif
#ifdef ev_N_OptTrafficOption_back_touch
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficOptions")) && (message.GetSender() == ::Courier::Identifier(0x560fb425 /* Layer_TouchArea_Back/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptTrafficOption_back_touch, 0x971DB5ED); return true; }
#endif
#ifdef ev_CloseLatLongInvalidPopUp
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#Pfo_LatLong_Invalid")) && (message.GetSender() == ::Courier::Identifier(0xef048109 /* Button_Text_Image/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_CloseLatLongInvalidPopUp, 0x1E89782F); return true; }
#endif
#ifdef ev_N_Map_ZoomOut_touch
    if ((message.GetSender() == ::Courier::Identifier(0x3906ee6a /* Layer_ZoomOut/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ZoomOut_touch, 0x7AEC8E5F); return true; }
#endif
#ifdef onEvAllPOICategory
    if ((message.GetSender() == ::Courier::Identifier(0x85ee3c28 /* Layer_All_POIs/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvAllPOICategory, 0xBEF69ED6); return true; }
#endif
#ifdef onEVLocationMapScroll
    if ((message.GetSender() == ::Courier::Identifier(0x7fe42903 /* Layer_Splitter/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEVLocationMapScroll, 0xA39F01FD); return true; }
#endif
#ifdef onMapOkButton
    if ((message.GetSender() == ::Courier::Identifier(0x0f5c304a /* Layer_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onMapOkButton, 0x5C6AF210); return true; }
#endif
#ifdef ev_N_SpellerEdit_touch
    if ((message.GetSender() == ::Courier::Identifier(0xeecb978a /* Layer_Speller_OK/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SpellerEdit_touch, 0x22AFD4E8); return true; }
#endif
#ifdef onEvCompass
    if ((message.GetSender() == ::Courier::Identifier(0xeb7fd048 /* Layer_Compass/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(onEvCompass, 0x85B88531); return true; }
#endif
#ifdef ev_N_Map_TMC_Touch_NoRouteGuidance
    if ((message.GetView() == ::Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Map")) && (message.GetSender() == ::Courier::Identifier(0x87f62864 /* Button_TMC/ButtonWidget */))) { eventId = CIT_EVENT_ID(ev_N_Map_TMC_Touch_NoRouteGuidance, 0xA3370687); return true; }
#endif
#ifdef ev_N_Map_ZoomIn_touch
    if ((message.GetSender() == ::Courier::Identifier(0x7e5e8db0 /* Layer_ZoomIn/ButtonWidget */)) && (message.GetEnReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_Map_ZoomIn_touch, 0x75E0DA9F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonReactionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
#ifdef onMapOkButton
    if (eventId == onMapOkButton) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onMapOkButton.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onEvCompass
    if (eventId == onEvCompass) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEvCompass.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onEVLocationMapScroll
    if (eventId == onEVLocationMapScroll) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEVLocationMapScroll.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_N_SpellerEdit_touch
    if (eventId == ev_N_SpellerEdit_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_SpellerEdit_touch.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_N_Map_ZoomIn_touch
    if (eventId == ev_N_Map_ZoomIn_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_Map_ZoomIn_touch.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_N_Map_ZoomOut_touch
    if (eventId == ev_N_Map_ZoomOut_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_Map_ZoomOut_touch.View = (::FeatStd::UInt32) (message.GetView()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onTopPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onTopPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onTopPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onTopPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onTopPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceInvisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceInvisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceInvisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceInvisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onCenterPopupSurfaceQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onCenterPopupSurfaceQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onCenterPopupSurfaceQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onCenterPopupSurfaceQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupVisible
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupVisible 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupVisible ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupVisible -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupUnqueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupUnqueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupUnqueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupUnqueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupQueued
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupQueued 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupQueued ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupQueued -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSurfaceStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);

#ifdef onTopPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceInvisible, 0x3598CF84); return true; }
#endif
#ifdef onTopPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceVisible, 0x984F8ED8); return true; }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceUnqueued, 0x912024BE); return true; }
#endif
#ifdef onTopPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_TOP_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onTopPopupSurfaceQueued, 0xB630DDBD); return true; }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_INVISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceInvisible, 0x9BDB722F); return true; }
#endif
#ifdef onCenterPopupSurfaceVisible
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceVisible, 0x23B97E51); return true; }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceUnqueued, 0xAA79C7DD); return true; }
#endif
#ifdef onCenterPopupSurfaceQueued
    if ((message.GetSurfaceId() == SURFACEID_CENTER_POPUP_SURFACE_NAVIGATION) && (message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onCenterPopupSurfaceQueued, 0xFC0D2293); return true; }
#endif
#ifdef onPopupVisible
    if ((message.GetState() == SURFACESTATE_VISIBLE)) { eventId = CIT_EVENT_ID(onPopupVisible, 0xB78D7AE0); return true; }
#endif
#ifdef onPopupUnqueued
    if ((message.GetState() == SURFACESTATE_UNQUEUED)) { eventId = CIT_EVENT_ID(onPopupUnqueued, 0xDB0D29F4); return true; }
#endif
#ifdef onPopupQueued
    if ((message.GetState() == SURFACESTATE_QUEUED)) { eventId = CIT_EVENT_ID(onPopupQueued, 0xBBE6896C); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSurfaceStateChangedUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
#ifdef onTopPopupSurfaceInvisible
    if (eventId == onTopPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceVisible
    if (eventId == onTopPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceUnqueued
    if (eventId == onTopPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onTopPopupSurfaceQueued
    if (eventId == onTopPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onTopPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceInvisible
    if (eventId == onCenterPopupSurfaceInvisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceInvisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceVisible
    if (eventId == onCenterPopupSurfaceVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceUnqueued
    if (eventId == onCenterPopupSurfaceUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onCenterPopupSurfaceQueued
    if (eventId == onCenterPopupSurfaceQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onCenterPopupSurfaceQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupVisible
    if (eventId == onPopupVisible) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupVisible.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupUnqueued
    if (eventId == onPopupUnqueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupUnqueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupQueued
    if (eventId == onPopupQueued) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupQueued.ViewId = (::FeatStd::UInt32) (message.GetViewId()).GetHashId().HashValue();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForLocationSelectionDoneResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_By_Map_Location_Selected, 0x3A0E9B64);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForLocationSelectionDoneResMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateMapScrollReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEVMapScroll, 0xB0128FFA);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateMapScrollReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowDetailInfoOfPickedPOIReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEVShowDetailInfoOfPickedPOI, 0x36FC3FC7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowDetailInfoOfPickedPOIReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNavigationInitializedReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvNavigationInitialized, 0xC20CD2C8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNavigationInitializedReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEvNavigationMWInitialized
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEvNavigationMWInitialized 0xffff
#pragma _REMINDER("Using dummy value symbol onEvNavigationMWInitialized ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEvNavigationMWInitialized -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForNavigationInitializedUpReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvNavigationMWInitialized, 0x02AC9AE8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNavigationInitializedUpReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::NavigationInitializedUpReqMsg const & message = static_cast< ::NavigationInitializedUpReqMsg const &>(aMessage);
#ifdef onEvNavigationMWInitialized
    if (eventId == onEvNavigationMWInitialized) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetMwStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEvNavigationMWInitialized.MwStatus = message.GetMwStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForRefreshMapOnBackGroundReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvRefreshMapOnBackGround, 0x3966047B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForRefreshMapOnBackGroundReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShow_TMC_DetailedInfoReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_TMC_DetailedInfo_touch, 0xF097E342);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShow_TMC_DetailedInfoReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowWaypointDetailedInfoReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Waypoint_DetailedInfo_touch, 0x75E14F2E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowWaypointDetailedInfoReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowPOIDetailsInfoForCoordinatesReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_LatLong_DetailedInfo_touch, 0xCC54D8B8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowPOIDetailsInfoForCoordinatesReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_MapTimerExpired
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_MapTimerExpired 0xffff
#pragma _REMINDER("Using dummy value symbol ev_MapTimerExpired ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_MapTimerExpired -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onPopupTimerExpiry
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onPopupTimerExpiry 0xffff
#pragma _REMINDER("Using dummy value symbol onPopupTimerExpiry ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onPopupTimerExpiry -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForExpiredPopupTimerResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_MapTimerExpired, 0x2260456D);
    return true;
    eventId = CIT_EVENT_ID(onPopupTimerExpiry, 0xF3C96D17);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForExpiredPopupTimerResMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
#ifdef ev_MapTimerExpired
    if (eventId == ev_MapTimerExpired) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_MapTimerExpired.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onPopupTimerExpiry
    if (eventId == onPopupTimerExpiry) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetViewId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onPopupTimerExpiry.ViewId = message.GetViewId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_ShowMapOrnewDestFromGadget
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_ShowMapOrnewDestFromGadget 0xffff
#pragma _REMINDER("Using dummy value symbol ev_ShowMapOrnewDestFromGadget ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_ShowMapOrnewDestFromGadget -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForShowMapOrnewDestFromGadgetReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowMapOrnewDestFromGadget, 0x38A08E7A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowMapOrnewDestFromGadgetReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ShowMapOrnewDestFromGadgetReqMsg const & message = static_cast< ::ShowMapOrnewDestFromGadgetReqMsg const &>(aMessage);
#ifdef ev_ShowMapOrnewDestFromGadget
    if (eventId == ev_ShowMapOrnewDestFromGadget) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetActiveContextID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_ShowMapOrnewDestFromGadget.ActiveContextID = message.GetActiveContextID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_ShowPosandGPSFromCabinGNSSSettings
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_ShowPosandGPSFromCabinGNSSSettings 0xffff
#pragma _REMINDER("Using dummy value symbol ev_ShowPosandGPSFromCabinGNSSSettings ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_ShowPosandGPSFromCabinGNSSSettings -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForShowPosandGPSFromCabinGNSSSettingstReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowPosandGPSFromCabinGNSSSettings, 0x9178F44D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowPosandGPSFromCabinGNSSSettingstReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ShowPosandGPSFromCabinGNSSSettingstReqMsg const & message = static_cast< ::ShowPosandGPSFromCabinGNSSSettingstReqMsg const &>(aMessage);
#ifdef ev_ShowPosandGPSFromCabinGNSSSettings
    if (eventId == ev_ShowPosandGPSFromCabinGNSSSettings) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetActiveContextID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_ShowPosandGPSFromCabinGNSSSettings.ActiveContextID = message.GetActiveContextID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleParameterStatusUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_UpdateVehicleParameterStatus, 0x7F903D7C);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleParameterStatusUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_UpdateVehicleSettingsChangeDuringRG
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_UpdateVehicleSettingsChangeDuringRG 0xffff
#pragma _REMINDER("Using dummy value symbol ev_UpdateVehicleSettingsChangeDuringRG ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_UpdateVehicleSettingsChangeDuringRG -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForUpdateVehicleSettingsChangeDuringRGReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_UpdateVehicleSettingsChangeDuringRG, 0x95CB66E0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUpdateVehicleSettingsChangeDuringRGReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::UpdateVehicleSettingsChangeDuringRGReqMsg const & message = static_cast< ::UpdateVehicleSettingsChangeDuringRGReqMsg const &>(aMessage);
#ifdef ev_UpdateVehicleSettingsChangeDuringRG
    if (eventId == ev_UpdateVehicleSettingsChangeDuringRG) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetIsSettingsSavedDuringRG()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_UpdateVehicleSettingsChangeDuringRG.IsSettingsSavedDuringRG = message.GetIsSettingsSavedDuringRG();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForValidateNaviEntryConditionResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ValidateNaviEntryConditionFailed, 0xE9AB040E);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForValidateNaviEntryConditionResMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSettingsContextReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Context_Opt_touch, 0x7AA17150);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSettingsContextReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForActivateEngineeringMenuReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Activate_EnggMenu, 0x393FC7BD);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateEngineeringMenuReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_OnButtonPressRouteTypeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressRouteTypeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressRouteTypeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressRouteTypeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressCustomRouteItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressCustomRouteItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressCustomRouteItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressCustomRouteItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressEstimatedTimeItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressEstimatedTimeItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressEstimatedTimeItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressEstimatedTimeItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressTimeOnMapItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressTimeOnMapItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressTimeOnMapItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressTimeOnMapItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressUseTrafficInfoItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressUseTrafficInfoItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressUseTrafficInfoItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressUseTrafficInfoItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined ev_OnButtonPressUseTollRoadItem
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnButtonPressUseTollRoadItem 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnButtonPressUseTollRoadItem ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnButtonPressUseTollRoadItem -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForButtonListItemUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);

#ifdef ev_N_SettingsVehicleParameter_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == VEHICLE_PARAMETERS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_SettingsVehicleParameter_touch, 0x3534B12E); return true; }
#endif
#ifdef ev_N_MapSettingsTrackingDots_Delete_touch
    if ((message.GetListId() == LIST_ID_MAP_SETTINGS_OTHERS) && (message.GetHdl() == MAP_SETTINGS_MAP_TEXT_SIZE) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_MapSettingsTrackingDots_Delete_touch, 0x71D1BEA7); return true; }
#endif
#ifdef ev_N_OPTMapOptions_Others_touch
    if ((message.GetListId() == LIST_ID_MAP_SETTINGS) && (message.GetHdl() == MAP_SETTINGS_OTHERS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_Others_touch, 0x7B4A80D3); return true; }
#endif
#ifdef ev_N_OPTMapOptions_ShowPOIOnMap_touch
    if ((message.GetListId() == LIST_ID_MAP_SETTINGS) && (message.GetHdl() == MAP_SETTINGS_SHOW_POI_ON_MAP) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_ShowPOIOnMap_touch, 0x03C82F61); return true; }
#endif
#ifdef ev_N_OptMapSettingsOptions_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == MAP_VIEW) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptMapSettingsOptions_touch, 0x32840E52); return true; }
#endif
#ifdef ev_N_OptTrafficOption_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == TRAFFIC_ICON_SETTING) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptTrafficOption_touch, 0xE140D19B); return true; }
#endif
#ifdef ev_N_OptSafetySettings_touch
    if ((message.GetListId() == LIST_ID_NAV_GUIDANCE_OPTION) && (message.GetHdl() == SAFETY_SETTINGS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptSafetySettings_touch, 0x7C267F12); return true; }
#endif
#ifdef ev_N_OptGuidanceOptions_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == GUIDANCE_SETTINGS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptGuidanceOptions_touch, 0x490A5E13); return true; }
#endif
#ifdef ev_N_OptRouteOptions_Others_touch
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE) && (message.GetHdl() == OTHER_SETTINGS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptRouteOptions_Others_touch, 0xBC50C969); return true; }
#endif
#ifdef ev_OnButtonPressUseTollRoadItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE_OTHERS) && (message.GetHdl() == USE_TOLL_ROADS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressUseTollRoadItem, 0x14B51C0D); return true; }
#endif
#ifdef ev_OnButtonPressUseTrafficInfoItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE_OTHERS) && (message.GetHdl() == USE_REAL_TIME_TRAFFIC_INFORMATION) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressUseTrafficInfoItem, 0xB5F016E6); return true; }
#endif
#ifdef ev_OnButtonPressTimeOnMapItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE) && (message.GetHdl() == ETA_SHOWN_ON_MAP) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressTimeOnMapItem, 0x81C6BE9A); return true; }
#endif
#ifdef ev_OnButtonPressEstimatedTimeItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE) && (message.GetHdl() == ESTIMATED_TIME_OPTIONS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressEstimatedTimeItem, 0xC9D5EA50); return true; }
#endif
#ifdef ev_OnButtonPressCustomRouteItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE) && (message.GetHdl() == CUSTOMIZE_MORE_ROUTES) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressCustomRouteItem, 0x4A87AF31); return true; }
#endif
#ifdef ev_OnButtonPressRouteTypeItem
    if ((message.GetListId() == LIST_ID_NAV_ROUTE_PREFERENCE) && (message.GetHdl() == ROUTE_TYPE) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_OnButtonPressRouteTypeItem, 0xEACB1A77); return true; }
#endif
#ifdef ev_N_OPT_MyPOIs_POIOPT_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == MY_POIS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_MyPOIs_POIOPT_touch, 0x9B740D33); return true; }
#endif
#ifdef ev_N_OPT_POsitionAndGpsInfo_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == Position_And_GPSInfo) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OPT_POsitionAndGpsInfo_touch, 0x4956DBDB); return true; }
#endif
#ifdef ev_N_OptRouteOptions_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetHdl() == ROUTE_PREFERENCES) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_OptRouteOptions_touch, 0x35B5584E); return true; }
#endif
#ifdef ev_N_LeftSplitMap_MapScale_touch
    if ((message.GetListId() == LIST_ID_MAP_SETTINGS_OTHERS) && (message.GetHdl() == MAP_SETTINGS_LEFT_SPLIT_MAP) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_LeftSplitMap_MapScale_touch, 0xBEAED657); return true; }
#endif
#ifdef ev_N_StreamedMap_Settings_touch
    if ((message.GetListId() == LIST_ID_NAV_SETTINGS) && (message.GetReaction() == enRelease)) { eventId = CIT_EVENT_ID(ev_N_StreamedMap_Settings_touch, 0x08E259D4); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForButtonListItemUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
#ifdef ev_OnButtonPressRouteTypeItem
    if (eventId == ev_OnButtonPressRouteTypeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressRouteTypeItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressCustomRouteItem
    if (eventId == ev_OnButtonPressCustomRouteItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressCustomRouteItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressEstimatedTimeItem
    if (eventId == ev_OnButtonPressEstimatedTimeItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressEstimatedTimeItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressTimeOnMapItem
    if (eventId == ev_OnButtonPressTimeOnMapItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressTimeOnMapItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressUseTrafficInfoItem
    if (eventId == ev_OnButtonPressUseTrafficInfoItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressUseTrafficInfoItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef ev_OnButtonPressUseTollRoadItem
    if (eventId == ev_OnButtonPressUseTollRoadItem) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubHdl()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnButtonPressUseTollRoadItem.SubHdl = message.GetSubHdl();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowNaviResetSettingsAppliedMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowNaviResetSettingsApplied_touch, 0x316E1D58);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowNaviResetSettingsAppliedMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowVehicleInfoReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowVehicleInfo, 0x47A97E5B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowVehicleInfoReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForev_N_SplitScreenMap_disabled(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Onev_N_SplitScreenMap_disabled, 0x43BE5677);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForev_N_SplitScreenMap_disabled(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForev_N_HorizonEventChanged(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Onev_N_HorizonEventChanged, 0xA28FFAFC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForev_N_HorizonEventChanged(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForev_N_PremiumTraffic_Disclaimer_Msg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(Onev_N_PremiumTraffic_Disclaimer_Msg, 0x5A2A2AEB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForev_N_PremiumTraffic_Disclaimer_Msg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNewAddressInputBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_NewDest_AddressInput_touch, 0x818723A2);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNewAddressInputBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForLastDestinationsBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_LastDestinations_DetailedInfo_touch, 0xE1784D36);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForLastDestinationsBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForStopGuidanceMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Stopguidance, 0xCD80D9B2);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForStopGuidanceMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDestoinationInfoBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Guidance_DestinationInfo_touch, 0xF37D3EE2);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDestoinationInfoBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPOIListBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_POIList_DetailedInfo_touch, 0xA73BECC9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPOIListBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUPOIListBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_UPOIList_DetailedInfo_touch, 0xD02AC3F0);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUPOIListBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForUPOIInvalidateUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnUPOIInvalidateUpdateMsg, 0xE858FFF3);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForUPOIInvalidateUpdateMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPOIIconSelectionOnMapMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_POI_Icon_OnMap_touch, 0x1789A37C);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPOIIconSelectionOnMapMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSaveWithDisplayedNameBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_SaveWithDisplayedName_DetailedInfo_touch, 0xC6B7F551);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSaveWithDisplayedNameBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForSaveAsHomeBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_SaveAsHome_DetailedInfo_touch, 0x99ABAFF6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSaveAsHomeBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForFavHomeBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_FavHome_DetailedInfo_touch, 0x8AC2E13B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForFavHomeBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowReplaceFavPopup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ReplaceFavHomePopup, 0x9AB5705B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowReplaceFavPopup(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForFavoriteListBtnSelectionMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Favorite_DetailedInfo_touch, 0xA21222ED);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForFavoriteListBtnSelectionMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAddressInputMatchSelectionDoneMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_NewDest_AddressInput_MatchSelection_done, 0x8B8B6E37);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAddressInputMatchSelectionDoneMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowNaviMapOnHardKeyPress, 0xE0651FD6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowFavAddFavView_ReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ReplaceFavList_touch, 0x07AD97C6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowFavAddFavView_ReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowMapActiveRGReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowMapActiveRG, 0x2B1CED0F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowMapActiveRGReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowMapReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowMap, 0xF1AD2565);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowMapReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowNewDestOnNaviHomeTitlePress(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowNewDestOnNaviHomeTitlePress, 0x530D4A4B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowNewDestOnNaviHomeTitlePress(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowMapOnNaviHomeBtnPress(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowMapOnNaviHomeBtnPress, 0xCFB289C7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowMapOnNaviHomeBtnPress(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowRouteBlockListReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowRouteBlockList, 0x3DD0AC0C);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowRouteBlockListReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForPOICategoryBrowseResponseMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvPOICategoryBrowse, 0x153669AC);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPOICategoryBrowseResponseMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEnableSpellerMatchListMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_SpellerMathchList_Enable, 0xA6C5E637);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableSpellerMatchListMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowLocationOnMapReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvShowLocationOnMap, 0x290F59EE);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowLocationOnMapReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForFavHomeBackCurPosMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Favorites_Home_back_CurPos, 0x3377F3AE);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForFavHomeBackCurPosMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForFavoritesHometouchMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Favorites_Home_touch, 0x96D375CB);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForFavoritesHometouchMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForAddressInputHometouchMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_AddressInputHome_touch, 0xB05A5B90);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAddressInputHometouchMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_Pfo_Dest_CalcRoute_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_Pfo_Dest_CalcRoute_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_Pfo_Dest_CalcRoute_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_Pfo_Dest_CalcRoute_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForAddressInputGuidancetouchMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Pfo_Dest_CalcRoute_touch, 0x6A82F509);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForAddressInputGuidancetouchMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::AddressInputGuidancetouchMsg const & message = static_cast< ::AddressInputGuidancetouchMsg const &>(aMessage);
#ifdef ev_Pfo_Dest_CalcRoute_touch
    if (eventId == ev_Pfo_Dest_CalcRoute_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetGuidanceActive()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_Pfo_Dest_CalcRoute_touch.GuidanceActive = message.GetGuidanceActive();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowMaxWaypointReachedPopup(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_Pfo_MaxWaypoint_Reached, 0x1E1DD183);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowMaxWaypointReachedPopup(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNoChangeInVehicleSettingsRespMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_VehicleSettings_NoChange, 0x03C9560F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNoChangeInVehicleSettingsRespMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleSettingsChangedRespMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_VehicleSettings_Changed, 0x48E0D32B);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleSettingsChangedRespMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_Map_GoToHome_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_Map_GoToHome_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_Map_GoToHome_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_Map_GoToHome_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForGotoHomeReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Map_GoToHome_touch, 0x2D5235FF);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForGotoHomeReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::GotoHomeReqMsg const & message = static_cast< ::GotoHomeReqMsg const &>(aMessage);
#ifdef ev_N_Map_GoToHome_touch
    if (eventId == ev_N_Map_GoToHome_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetIsGoToHome()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_Map_GoToHome_touch.IsGoToHome = message.GetIsGoToHome();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_OPTMapOptions_Others_ListUpdate_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_OPTMapOptions_Others_ListUpdate_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_OPTMapOptions_Others_ListUpdate_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_OPTMapOptions_Others_ListUpdate_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForMapSettingsOthersListUpdateMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::MapSettingsOthersListUpdateMsg const & message = static_cast< ::MapSettingsOthersListUpdateMsg const &>(aMessage);

#ifdef ev_N_OPTMapOptions_MapColor_touch
    if ((message.GetMapSettingsOthersListID() == MAP_SETTINGS_MAP_COLOR)) { eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_MapColor_touch, 0xF99967D7); return true; }
#endif
    eventId = CIT_EVENT_ID(ev_N_OPTMapOptions_Others_ListUpdate_touch, 0x5FDA4593);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForMapSettingsOthersListUpdateMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::MapSettingsOthersListUpdateMsg const & message = static_cast< ::MapSettingsOthersListUpdateMsg const &>(aMessage);
#ifdef ev_N_OPTMapOptions_Others_ListUpdate_touch
    if (eventId == ev_N_OPTMapOptions_Others_ListUpdate_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetMapSettingsOthersListID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_OPTMapOptions_Others_ListUpdate_touch.MapSettingsOthersListID = message.GetMapSettingsOthersListID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForStreamedMapSubOptionsListUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch, 0x832E18D9);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForStreamedMapSubOptionsListUpdateMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::StreamedMapSubOptionsListUpdateMsg const & message = static_cast< ::StreamedMapSubOptionsListUpdateMsg const &>(aMessage);
#ifdef ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch
    if (eventId == ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetSubOptionsListID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch.SubOptionsListID = message.GetSubOptionsListID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_Enable_StreamedMap_Timer
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_Enable_StreamedMap_Timer 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_Enable_StreamedMap_Timer ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_Enable_StreamedMap_Timer -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEnableStreamedMapTimerReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Enable_StreamedMap_Timer, 0x6E06BB21);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEnableStreamedMapTimerReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EnableStreamedMapTimerReqMsg const & message = static_cast< ::EnableStreamedMapTimerReqMsg const &>(aMessage);
#ifdef ev_N_Enable_StreamedMap_Timer
    if (eventId == ev_N_Enable_StreamedMap_Timer) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetIsStreamedMapEnabled(), message.GetTimerDuration()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_Enable_StreamedMap_Timer.IsStreamedMapEnabled = message.GetIsStreamedMapEnabled();
        onClickParam.VSEPS_ev_N_Enable_StreamedMap_Timer.TimerDuration = message.GetTimerDuration();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForVehicleProfileChangedResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Pfo_DestVehicleInfo_Changed, 0xB6D77E1F);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForVehicleProfileChangedResMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_PickInMap_options_touch
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_PickInMap_options_touch 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_PickInMap_options_touch ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_PickInMap_options_touch -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForPickInMapOptionsUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_PickInMap_options_touch, 0x1B460D2A);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPickInMapOptionsUpdateMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::PickInMapOptionsUpdateMsg const & message = static_cast< ::PickInMapOptionsUpdateMsg const &>(aMessage);
#ifdef ev_N_PickInMap_options_touch
    if (eventId == ev_N_PickInMap_options_touch) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPickInMapOptionID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_PickInMap_options_touch.PickInMapOptionID = message.GetPickInMapOptionID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForRouteGuidancePopUpCloseReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_CalculateRouteGuidancePopUpClosed, 0x796E1AC5);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForRouteGuidancePopUpCloseReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForShowTrafficDetailedInfoViewMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_ShowTrafficDetailedInfoView, 0x46891BD1);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForShowTrafficDetailedInfoViewMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForDisplaySpeedLockPopuponSpellerReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_DisplaySpeedLockPopup, 0x222F2161);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplaySpeedLockPopuponSpellerReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHideSpeedLockPopuponSpellerReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_HideSpeedLockPopup, 0xA0CD2C27);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHideSpeedLockPopuponSpellerReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_N_Map_ActivatePOIInfoSelectedOnMap
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_N_Map_ActivatePOIInfoSelectedOnMap 0xffff
#pragma _REMINDER("Using dummy value symbol ev_N_Map_ActivatePOIInfoSelectedOnMap ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_N_Map_ActivatePOIInfoSelectedOnMap -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivatePOIInfoSelectedOnMapMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_N_Map_ActivatePOIInfoSelectedOnMap, 0xFC5369E7);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivatePOIInfoSelectedOnMapMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ActivatePOIInfoSelectedOnMapMsg const & message = static_cast< ::ActivatePOIInfoSelectedOnMapMsg const &>(aMessage);
#ifdef ev_N_Map_ActivatePOIInfoSelectedOnMap
    if (eventId == ev_N_Map_ActivatePOIInfoSelectedOnMap) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetIsMultiplePOIAvailable()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_N_Map_ActivatePOIInfoSelectedOnMap.IsMultiplePOIAvailable = message.GetIsMultiplePOIAvailable();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_NAVDATAUPDATE_InternalUpdateStatus
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_NAVDATAUPDATE_InternalUpdateStatus 0xffff
#pragma _REMINDER("Using dummy value symbol ev_NAVDATAUPDATE_InternalUpdateStatus ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_NAVDATAUPDATE_InternalUpdateStatus -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForNAVDATAUPDATE_InternalUpdateStatusUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_NAVDATAUPDATE_InternalUpdateStatus, 0xDE67ADB6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNAVDATAUPDATE_InternalUpdateStatusUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::NAVDATAUPDATE_InternalUpdateStatusUpdMsg const & message = static_cast< ::NAVDATAUPDATE_InternalUpdateStatusUpdMsg const &>(aMessage);
#ifdef ev_NAVDATAUPDATE_InternalUpdateStatus
    if (eventId == ev_NAVDATAUPDATE_InternalUpdateStatus) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetStatus()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_NAVDATAUPDATE_InternalUpdateStatus.Status = message.GetStatus();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNAVDATAUPDATE_Nav_GotoNavUpdateScreenResMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_NAVDATAUPDATE_Nav_GotoNavUpdateScreen, 0xE2FA5002);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNAVDATAUPDATE_Nav_GotoNavUpdateScreenResMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForonNAVDATAUPDATE_UpdateInfoStopedUpdMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_NAVDATAUPDATE_UpdateInfoStoped, 0x417A3196);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForonNAVDATAUPDATE_UpdateInfoStopedUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForNAVDATAUPDATE_UpdateBlockedBySWUpdateUpdMsd(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_NAVDATAUPDATE_UpdateBlockedBySWUpdate, 0x94BA5255);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForNAVDATAUPDATE_UpdateBlockedBySWUpdateUpdMsd(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForEngineeringMenuResponseMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(onEvEngineeringMenu, 0x8EB6889D);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEngineeringMenuResponseMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_OnPopupTypeUpdate
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_OnPopupTypeUpdate 0xffff
#pragma _REMINDER("Using dummy value symbol ev_OnPopupTypeUpdate ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_OnPopupTypeUpdate -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForPopupTypeUpdateMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_OnPopupTypeUpdate, 0xDCE125B8);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForPopupTypeUpdateMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::PopupTypeUpdateMsg const & message = static_cast< ::PopupTypeUpdateMsg const &>(aMessage);
#ifdef ev_OnPopupTypeUpdate
    if (eventId == ev_OnPopupTypeUpdate) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetPopupType()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_OnPopupTypeUpdate.PopupType = message.GetPopupType();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined ev_DisplayLastActiveNaviContext
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define ev_DisplayLastActiveNaviContext 0xffff
#pragma _REMINDER("Using dummy value symbol ev_DisplayLastActiveNaviContext ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol ev_DisplayLastActiveNaviContext -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForDisplayLastNaviContextReqMsg(::Courier::Message const & /* aMessage */, ::FeatStd::UInt32& eventId)
{
    eventId = CIT_EVENT_ID(ev_DisplayLastActiveNaviContext, 0xFAAF20E6);
    return true;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForDisplayLastNaviContextReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::DisplayLastNaviContextReqMsg const & message = static_cast< ::DisplayLastNaviContextReqMsg const &>(aMessage);
#ifdef ev_DisplayLastActiveNaviContext
    if (eventId == ev_DisplayLastActiveNaviContext) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetLastActiveContextID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_ev_DisplayLastActiveNaviContext.LastActiveContextID = message.GetLastActiveContextID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onEncoderStatusChanged_RIGHT_ENC
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onEncoderStatusChanged_RIGHT_ENC 0xffff
#pragma _REMINDER("Using dummy value symbol onEncoderStatusChanged_RIGHT_ENC ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onEncoderStatusChanged_RIGHT_ENC -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForEncoderStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);

#ifdef onEncoderStatusChanged_RIGHT_ENC
    if ((message.GetEncCode() == ENCCODE_RIGHT_ENCODER)) { eventId = CIT_EVENT_ID(onEncoderStatusChanged_RIGHT_ENC, 0x67E5D82B); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForEncoderStatusChangedUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
#ifdef onEncoderStatusChanged_RIGHT_ENC
    if (eventId == onEncoderStatusChanged_RIGHT_ENC) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetEncSteps()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onEncoderStatusChanged_RIGHT_ENC.EncSteps = message.GetEncSteps();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHKStatusChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);

#ifdef onHKStatusChanged_HK_SELECT_UP
    if ((message.GetHKCode() == HARDKEYCODE_HK_SELECT) && (message.GetHKState() == HARDKEYSTATE_UP)) { eventId = CIT_EVENT_ID(onHKStatusChanged_HK_SELECT_UP, 0x263EAF7F); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHKStatusChangedUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HKStatusChangedUpdMsg const & message = static_cast< ::HKStatusChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onActivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onActivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onActivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onActivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onDeactivateImageProviderRequest
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onDeactivateImageProviderRequest 0xffff
#pragma _REMINDER("Using dummy value symbol onDeactivateImageProviderRequest ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onDeactivateImageProviderRequest -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForActivateImageProviderReqMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);

#ifdef onActivateImageProviderRequest
    if ((message.GetActivate() == 1)) { eventId = CIT_EVENT_ID(onActivateImageProviderRequest, 0xDD62EA5B); return true; }
#endif
#ifdef onDeactivateImageProviderRequest
    if ((message.GetActivate() == 0)) { eventId = CIT_EVENT_ID(onDeactivateImageProviderRequest, 0x9FE98C1E); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForActivateImageProviderReqMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
#ifdef onActivateImageProviderRequest
    if (eventId == onActivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onActivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onDeactivateImageProviderRequest
    if (eventId == onDeactivateImageProviderRequest) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetInstanceId()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onDeactivateImageProviderRequest.InstanceId = message.GetInstanceId();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForHMISubStateChangedUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);

#ifdef onHMISubStateChanged_ON
    if ((message.GetSubState() == HMISTATE_SHOW_HMI)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_ON, 0x76CF2B88); return true; }
#endif
#ifdef onHMISubStateChanged_CLOCK
    if ((message.GetSubState() == HMISTATE_SHOW_CLOCK)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_CLOCK, 0xF96478DC); return true; }
#endif
#ifdef onHMISubStateChanged_OFF
    if ((message.GetSubState() == HMISTATE_SHOW_OFF)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_OFF, 0x776D7D8A); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY_RESTRICTED
    if ((message.GetSubState() == HMISTATE_STANDBY_RESTRICTED)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY_RESTRICTED, 0xA15C3CEE); return true; }
#endif
#ifdef onHMISubStateChanged_STANDBY
    if ((message.GetSubState() == HMISTATE_STANDBY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_STANDBY, 0x0D0F5602); return true; }
#endif
#ifdef onHMISubStateChanged_PHONE
    if ((message.GetSubState() == HMISTATE_PHONE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_PHONE, 0xC8D83B8B); return true; }
#endif
#ifdef onHMISubStateChanged_NO_DISPLAY
    if ((message.GetSubState() == HMISTATE_SHOW_NO_DISPLAY)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_NO_DISPLAY, 0xE4658CFD); return true; }
#endif
#ifdef onHMISubStateChanged_SECURE
    if ((message.GetSubState() == HMISTATE_SECURE)) { eventId = CIT_EVENT_ID(onHMISubStateChanged_SECURE, 0xAB89D7A8); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForHMISubStateChangedUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::HMISubStateChangedUpdMsg const & message = static_cast< ::HMISubStateChangedUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForApplicationStateUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);

#ifdef onAppStatusChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_FOREGROUND, 0xDE9448E3); return true; }
#endif
#ifdef onAppStatusChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusChanged_BACKGROUND, 0x6D1B3A68); return true; }
#endif
#ifdef onAppStatusPrepare_BACKGROUND
    if ((message.GetState() == hmibase::TO_BACKGROUND)) { eventId = CIT_EVENT_ID(onAppStatusPrepare_BACKGROUND, 0x4C8518AE); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForApplicationStateUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::ApplicationStateUpdMsg const & message = static_cast< ::ApplicationStateUpdMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------

#if !defined onSubSurfaceUpdMsgChanged_FOREGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_FOREGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_FOREGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_FOREGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
#if !defined onSubSurfaceUpdMsgChanged_BACKGROUND
#if defined VARIANT_S_FTR_ENABLE_HMICONTRACT_ACTION_DUMMY
#define onSubSurfaceUpdMsgChanged_BACKGROUND 0xffff
#pragma _REMINDER("Using dummy value symbol onSubSurfaceUpdMsgChanged_BACKGROUND ->Statemachine needs to be resynced with HMIContract")
#else
#error "Undefined symbol onSubSurfaceUpdMsgChanged_BACKGROUND -> Statemachine needs to be resynced with HMIContract"
#endif
#endif
static bool HandleEventMappingForSubSurfaceUpdMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);

#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if ((message.GetState() == hmibase::IN_FOREGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_FOREGROUND, 0x9D4DF4FC); return true; }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if ((message.GetState() == hmibase::IN_BACKGROUND)) { eventId = CIT_EVENT_ID(onSubSurfaceUpdMsgChanged_BACKGROUND, 0x5790D8C1); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForSubSurfaceUpdMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
#ifdef onSubSurfaceUpdMsgChanged_FOREGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_FOREGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_FOREGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
#ifdef onSubSurfaceUpdMsgChanged_BACKGROUND
    if (eventId == onSubSurfaceUpdMsgChanged_BACKGROUND) {
        typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId), message.GetDisplayRegion(), message.GetDisplayID()));
#else
        VSEventParType onClickParam;
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayRegion = message.GetDisplayRegion();
        onClickParam.VSEPS_onSubSurfaceUpdMsgChanged_BACKGROUND.DisplayID = message.GetDisplayID();
        return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), &onClickParam));
#endif
    }
#endif
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
static bool HandleEventMappingForTransitionIndMsg(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);

#ifdef OnNextLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("NextLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnNextLevelTransitionFinished, 0xE7DCE080); return true; }
#endif
#ifdef OnPreviousLevelTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PreviousLevelTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPreviousLevelTransitionFinished, 0x26C30D04); return true; }
#endif
#ifdef OnPageFlipBackFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipBackTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipBackFinished, 0x74F534EE); return true; }
#endif
#ifdef OnPageFlipFrontFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("PageFlipFrontTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnPageFlipFrontFinished, 0x437D9EFE); return true; }
#endif
#ifdef OnZoomInFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomInTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomInFinished, 0xFBEEA58F); return true; }
#endif
#ifdef OnZoomOutFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("ZoomOutTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnZoomOutFinished, 0xF84B3BD1); return true; }
#endif
#ifdef OnFadeAnimationFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("FadeTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnFadeAnimationFinished, 0xE9A6D56C); return true; }
#endif
#ifdef OnDualViewLeftTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewLeftTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewLeftTransitionFinished, 0x403A65A4); return true; }
#endif
#ifdef OnDualViewRightTransitionFinished
    if ((message.GetTransitionId() == ::Courier::ItemId("DualViewRightTransition")) && (message.GetReset() == false)) { eventId = CIT_EVENT_ID(OnDualViewRightTransitionFinished, 0x50B4DCCA); return true; }
#endif
    return false;
}

// ------------------------------------------------------------------------
static ::Cit::DeductResult::Enum HandleEventDeductionForTransitionIndMsg(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId)
{
    FEATSTD_UNUSED(aMessage);
    ::Courier::TransitionIndMsg const & message = static_cast< ::Courier::TransitionIndMsg const &>(aMessage);
    typedef Cit::Internal::VSDeductHelper< AppHmi_NavigationStateMachineImpl::VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
    return VSDeductHelper::ProcessOutput(*sm, (*sm.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
}

// ------------------------------------------------------------------------
struct EventMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mEventCallHandler)(::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

struct EventDeductionMapping
{
    ::FeatStd::UInt32 mHashId;
    ::Cit::DeductResult::Enum (*mEventCallHandler)(AppHmi_NavigationStateMachine *sm, ::Courier::Message const & aMessage, ::FeatStd::UInt32& eventId);
};

static ::FeatStd::Int EventMappingCmp(::FeatStd::UInt32 hash, const EventMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

static ::FeatStd::Int EventDeductionMappingCmp(::FeatStd::UInt32 hash, const EventDeductionMapping& em)
{
    return (hash == em.mHashId) ? 0 : ((hash < em.mHashId) ? -1 : 1);
}

bool AppHmi_NavigationStateMachineImpl::HandleEventMapping(::Courier::Message const & message, ::FeatStd::UInt32& eventId) const
{
    static EventMapping events[82] = {
        { 0x04B8AFB9, HandleEventMappingForHKStatusChangedUpdMsg },
        { 0x0635BEB5, HandleEventMappingForFavoriteListBtnSelectionMsg },
        { 0x0C588C94, HandleEventMappingForValidateNaviEntryConditionResMsg },
        { 0x11DC1ABF, HandleEventMappingForDestoinationInfoBtnSelectionMsg },
        { 0x11E10EE9, HandleEventMappingForShowNewDestOnNaviHomeTitlePress },
        { 0x12937C1A, HandleEventMappingForHideSpeedLockPopuponSpellerReqMsg },
        { 0x12FE3ECD, HandleEventMappingForVehicleSettingsChangedRespMsg },
        { 0x13EF665E, HandleEventMappingForShowTrafficDetailedInfoViewMsg },
        { 0x1536C3F4, HandleEventMappingForButtonListItemUpdMsg },
        { 0x17C34720, HandleEventMappingForShowDetailInfoOfPickedPOIReqMsg },
        { 0x1ACF9B8B, HandleEventMappingForLastDestinationsBtnSelectionMsg },
        { 0x1DE08B9E, HandleEventMappingForPOIIconSelectionOnMapMsg },
        { 0x1F98DB2B, HandleEventMappingForev_N_PremiumTraffic_Disclaimer_Msg },
        { 0x20AB0413, HandleEventMappingForAddressInputHometouchMsg },
        { 0x20BED100, HandleEventMappingForEnableStreamedMapTimerReqMsg },
        { 0x2C79F7D0, HandleEventMappingForVehicleProfileChangedResMsg },
        { 0x2D939CAB, HandleEventMappingForShowFavAddFavView_ReqMsg },
        { 0x2F95AD71, HandleEventMappingForFavoritesHometouchMsg },
        { 0x2FB1067F, HandleEventMappingForEnableSpellerMatchListMsg },
        { 0x33835F4B, HandleEventMappingForShowReplaceFavPopup },
        { 0x36178116, HandleEventMappingForSettingsContextReqMsg },
        { 0x3824FE1D, HandleEventMappingForApplicationStateUpdMsg },
        { 0x3DE931A9, HandleEventMappingForShowMapActiveRGReqMsg },
        { 0x404F9FDE, HandleEventMappingForAddressInputGuidancetouchMsg },
        { 0x46B34D4D, HandleEventMappingForNoChangeInVehicleSettingsRespMsg },
        { 0x4A69141E, HandleEventMappingForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventMappingForEncoderStatusChangedUpdMsg },
        { 0x5ED80AF2, HandleEventMappingForPOIListBtnSelectionMsg },
        { 0x5F0B530D, HandleEventMappingForShowMapOrnewDestFromGadgetReqMsg },
        { 0x628AA8BB, HandleEventMappingForRefreshMapOnBackGroundReqMsg },
        { 0x69FAC6F1, HandleEventMappingForSubSurfaceUpdMsg },
        { 0x6A3C6DB1, HandleEventMappingForShowMapOnNaviHomeBtnPress },
        { 0x6AE0FD3C, HandleEventMappingForButtonReactionMsg },
        { 0x6BC3B8EB, HandleEventMappingForGotoHomeReqMsg },
        { 0x76661693, HandleEventMappingForShowNaviResetSettingsAppliedMsg },
        { 0x8356BF92, HandleEventMappingForHKStatusChangedMsg },
        { 0x83CBB6B1, HandleEventMappingForShowRouteBlockListReqMsg },
        { 0x89D7BD72, HandleEventMappingForShow_TMC_DetailedInfoReqMsg },
        { 0x8A8A40BD, HandleEventMappingForPopupTypeUpdateMsg },
        { 0x8D3778E2, HandleEventMappingForPOICategoryBrowseResponseMsg },
        { 0x90F6951A, HandleEventMappingForSaveAsHomeBtnSelectionMsg },
        { 0x91A1572D, HandleEventMappingForStreamedMapSubOptionsListUpdateMsg },
        { 0x951A85D1, HandleEventMappingForSaveWithDisplayedNameBtnSelectionMsg },
        { 0x953616C5, HandleEventMappingForFavHomeBtnSelectionMsg },
        { 0x9A756CB3, HandleEventMappingForVehicleParameterStatusUpdMsg },
        { 0x9F76BF39, HandleEventMappingForActivatePOIInfoSelectedOnMapMsg },
        { 0xA78078E1, HandleEventMappingForActivateEngineeringMenuReqMsg },
        { 0xAC0BF243, HandleEventMappingForActivateMapScrollReqMsg },
        { 0xAE3CAAA7, HandleEventMappingForExpiredPopupTimerResMsg },
        { 0xB0FA7E3C, HandleEventMappingForUPOIListBtnSelectionMsg },
        { 0xBB1A43CA, HandleEventMappingForFavHomeBackCurPosMsg },
        { 0xBE893230, HandleEventMappingForDisplaySpeedLockPopuponSpellerReqMsg },
        { 0xBFC77EAC, HandleEventMappingForNewAddressInputBtnSelectionMsg },
        { 0xC318B5C5, HandleEventMappingForLocationSelectionDoneResMsg },
        { 0xC3CAE839, HandleEventMappingForev_N_HorizonEventChanged },
        { 0xC53FCBC0, HandleEventMappingForShowVehicleInfoReqMsg },
        { 0xC613E40C, HandleEventMappingForActivateImageProviderReqMsg },
        { 0xC678F353, HandleEventMappingForDisplayLastNaviContextReqMsg },
        { 0xC6F3CC1A, HandleEventMappingForEngineeringMenuResponseMsg },
        { 0xC7B455FB, HandleEventMappingForTransitionIndMsg },
        { 0xC9DB0087, HandleEventMappingForonNAVDATAUPDATE_UpdateInfoStopedUpdMsg },
        { 0xCAA2F2FC, HandleEventMappingForNAVDATAUPDATE_UpdateBlockedBySWUpdateUpdMsd },
        { 0xCFDBA6BE, HandleEventMappingForNavigationViewMsg },
        { 0xD2C7164D, HandleEventMappingForShowPosandGPSFromCabinGNSSSettingstReqMsg },
        { 0xD36C4CBE, HandleEventMappingForNavigationInitializedUpReqMsg },
        { 0xD49D677A, HandleEventMappingForNAVDATAUPDATE_InternalUpdateStatusUpdMsg },
        { 0xD62D925B, HandleEventMappingForRouteGuidancePopUpCloseReqMsg },
        { 0xD728F8F4, HandleEventMappingForUPOIInvalidateUpdateMsg },
        { 0xD741FC97, HandleEventMappingForShowWaypointDetailedInfoReqMsg },
        { 0xD808128F, HandleEventMappingForNAVDATAUPDATE_Nav_GotoNavUpdateScreenResMsg },
        { 0xD91D61D0, HandleEventMappingForev_N_SplitScreenMap_disabled },
        { 0xDB620B78, HandleEventMappingForStopGuidanceMsg },
        { 0xE2F61D55, HandleEventMappingForSurfaceStateChangedUpdMsg },
        { 0xE3E37B08, HandleEventMappingForShowPOIDetailsInfoForCoordinatesReqMsg },
        { 0xEAE3D24C, HandleEventMappingForNavigationInitializedReqMsg },
        { 0xEAE9A6B1, HandleEventMappingForShowLocationOnMapReqMsg },
        { 0xF0506D85, HandleEventMappingForShowMaxWaypointReachedPopup },
        { 0xF0C98922, HandleEventMappingForAddressInputMatchSelectionDoneMsg },
        { 0xF2F3BA48, HandleEventMappingForPickInMapOptionsUpdateMsg },
        { 0xF860F439, HandleEventMappingForMapSettingsOthersListUpdateMsg },
        { 0xFEC4814B, HandleEventMappingForUpdateVehicleSettingsChangeDuringRGReqMsg },
        { 0xFFA5ED5B, HandleEventMappingForShowMapReqMsg },
    };
    ::FeatStd::UInt32 hashId = message.GetId();
    const EventMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 82, &EventMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        return eventEntry->mEventCallHandler(message, eventId);
    }
    return false;
}

// ------------------------------------------------------------------------
::Cit::DeductResult::Enum AppHmi_NavigationStateMachineImpl::DeductEvent(::Courier::Message const & aMessage, ::FeatStd::UInt32 eventId)
{
    ::Cit::DeductResult::Enum deductResult = Cit::DeductResult::DeductOk;
    static EventDeductionMapping events[82] = {
        { 0x04B8AFB9, HandleEventDeductionForHKStatusChangedUpdMsg },
        { 0x0635BEB5, HandleEventDeductionForFavoriteListBtnSelectionMsg },
        { 0x0C588C94, HandleEventDeductionForValidateNaviEntryConditionResMsg },
        { 0x11DC1ABF, HandleEventDeductionForDestoinationInfoBtnSelectionMsg },
        { 0x11E10EE9, HandleEventDeductionForShowNewDestOnNaviHomeTitlePress },
        { 0x12937C1A, HandleEventDeductionForHideSpeedLockPopuponSpellerReqMsg },
        { 0x12FE3ECD, HandleEventDeductionForVehicleSettingsChangedRespMsg },
        { 0x13EF665E, HandleEventDeductionForShowTrafficDetailedInfoViewMsg },
        { 0x1536C3F4, HandleEventDeductionForButtonListItemUpdMsg },
        { 0x17C34720, HandleEventDeductionForShowDetailInfoOfPickedPOIReqMsg },
        { 0x1ACF9B8B, HandleEventDeductionForLastDestinationsBtnSelectionMsg },
        { 0x1DE08B9E, HandleEventDeductionForPOIIconSelectionOnMapMsg },
        { 0x1F98DB2B, HandleEventDeductionForev_N_PremiumTraffic_Disclaimer_Msg },
        { 0x20AB0413, HandleEventDeductionForAddressInputHometouchMsg },
        { 0x20BED100, HandleEventDeductionForEnableStreamedMapTimerReqMsg },
        { 0x2C79F7D0, HandleEventDeductionForVehicleProfileChangedResMsg },
        { 0x2D939CAB, HandleEventDeductionForShowFavAddFavView_ReqMsg },
        { 0x2F95AD71, HandleEventDeductionForFavoritesHometouchMsg },
        { 0x2FB1067F, HandleEventDeductionForEnableSpellerMatchListMsg },
        { 0x33835F4B, HandleEventDeductionForShowReplaceFavPopup },
        { 0x36178116, HandleEventDeductionForSettingsContextReqMsg },
        { 0x3824FE1D, HandleEventDeductionForApplicationStateUpdMsg },
        { 0x3DE931A9, HandleEventDeductionForShowMapActiveRGReqMsg },
        { 0x404F9FDE, HandleEventDeductionForAddressInputGuidancetouchMsg },
        { 0x46B34D4D, HandleEventDeductionForNoChangeInVehicleSettingsRespMsg },
        { 0x4A69141E, HandleEventDeductionForHMISubStateChangedUpdMsg },
        { 0x4FF79763, HandleEventDeductionForEncoderStatusChangedUpdMsg },
        { 0x5ED80AF2, HandleEventDeductionForPOIListBtnSelectionMsg },
        { 0x5F0B530D, HandleEventDeductionForShowMapOrnewDestFromGadgetReqMsg },
        { 0x628AA8BB, HandleEventDeductionForRefreshMapOnBackGroundReqMsg },
        { 0x69FAC6F1, HandleEventDeductionForSubSurfaceUpdMsg },
        { 0x6A3C6DB1, HandleEventDeductionForShowMapOnNaviHomeBtnPress },
        { 0x6AE0FD3C, HandleEventDeductionForButtonReactionMsg },
        { 0x6BC3B8EB, HandleEventDeductionForGotoHomeReqMsg },
        { 0x76661693, HandleEventDeductionForShowNaviResetSettingsAppliedMsg },
        { 0x8356BF92, HandleEventDeductionForHKStatusChangedMsg },
        { 0x83CBB6B1, HandleEventDeductionForShowRouteBlockListReqMsg },
        { 0x89D7BD72, HandleEventDeductionForShow_TMC_DetailedInfoReqMsg },
        { 0x8A8A40BD, HandleEventDeductionForPopupTypeUpdateMsg },
        { 0x8D3778E2, HandleEventDeductionForPOICategoryBrowseResponseMsg },
        { 0x90F6951A, HandleEventDeductionForSaveAsHomeBtnSelectionMsg },
        { 0x91A1572D, HandleEventDeductionForStreamedMapSubOptionsListUpdateMsg },
        { 0x951A85D1, HandleEventDeductionForSaveWithDisplayedNameBtnSelectionMsg },
        { 0x953616C5, HandleEventDeductionForFavHomeBtnSelectionMsg },
        { 0x9A756CB3, HandleEventDeductionForVehicleParameterStatusUpdMsg },
        { 0x9F76BF39, HandleEventDeductionForActivatePOIInfoSelectedOnMapMsg },
        { 0xA78078E1, HandleEventDeductionForActivateEngineeringMenuReqMsg },
        { 0xAC0BF243, HandleEventDeductionForActivateMapScrollReqMsg },
        { 0xAE3CAAA7, HandleEventDeductionForExpiredPopupTimerResMsg },
        { 0xB0FA7E3C, HandleEventDeductionForUPOIListBtnSelectionMsg },
        { 0xBB1A43CA, HandleEventDeductionForFavHomeBackCurPosMsg },
        { 0xBE893230, HandleEventDeductionForDisplaySpeedLockPopuponSpellerReqMsg },
        { 0xBFC77EAC, HandleEventDeductionForNewAddressInputBtnSelectionMsg },
        { 0xC318B5C5, HandleEventDeductionForLocationSelectionDoneResMsg },
        { 0xC3CAE839, HandleEventDeductionForev_N_HorizonEventChanged },
        { 0xC53FCBC0, HandleEventDeductionForShowVehicleInfoReqMsg },
        { 0xC613E40C, HandleEventDeductionForActivateImageProviderReqMsg },
        { 0xC678F353, HandleEventDeductionForDisplayLastNaviContextReqMsg },
        { 0xC6F3CC1A, HandleEventDeductionForEngineeringMenuResponseMsg },
        { 0xC7B455FB, HandleEventDeductionForTransitionIndMsg },
        { 0xC9DB0087, HandleEventDeductionForonNAVDATAUPDATE_UpdateInfoStopedUpdMsg },
        { 0xCAA2F2FC, HandleEventDeductionForNAVDATAUPDATE_UpdateBlockedBySWUpdateUpdMsd },
        { 0xCFDBA6BE, HandleEventDeductionForNavigationViewMsg },
        { 0xD2C7164D, HandleEventDeductionForShowPosandGPSFromCabinGNSSSettingstReqMsg },
        { 0xD36C4CBE, HandleEventDeductionForNavigationInitializedUpReqMsg },
        { 0xD49D677A, HandleEventDeductionForNAVDATAUPDATE_InternalUpdateStatusUpdMsg },
        { 0xD62D925B, HandleEventDeductionForRouteGuidancePopUpCloseReqMsg },
        { 0xD728F8F4, HandleEventDeductionForUPOIInvalidateUpdateMsg },
        { 0xD741FC97, HandleEventDeductionForShowWaypointDetailedInfoReqMsg },
        { 0xD808128F, HandleEventDeductionForNAVDATAUPDATE_Nav_GotoNavUpdateScreenResMsg },
        { 0xD91D61D0, HandleEventDeductionForev_N_SplitScreenMap_disabled },
        { 0xDB620B78, HandleEventDeductionForStopGuidanceMsg },
        { 0xE2F61D55, HandleEventDeductionForSurfaceStateChangedUpdMsg },
        { 0xE3E37B08, HandleEventDeductionForShowPOIDetailsInfoForCoordinatesReqMsg },
        { 0xEAE3D24C, HandleEventDeductionForNavigationInitializedReqMsg },
        { 0xEAE9A6B1, HandleEventDeductionForShowLocationOnMapReqMsg },
        { 0xF0506D85, HandleEventDeductionForShowMaxWaypointReachedPopup },
        { 0xF0C98922, HandleEventDeductionForAddressInputMatchSelectionDoneMsg },
        { 0xF2F3BA48, HandleEventDeductionForPickInMapOptionsUpdateMsg },
        { 0xF860F439, HandleEventDeductionForMapSettingsOthersListUpdateMsg },
        { 0xFEC4814B, HandleEventDeductionForUpdateVehicleSettingsChangeDuringRGReqMsg },
        { 0xFFA5ED5B, HandleEventDeductionForShowMapReqMsg },
    };
    ::FeatStd::UInt32 hashId = aMessage.GetId();
    const EventDeductionMapping* eventEntry = ::Courier::BinarySearch(hashId, events, 82, &EventDeductionMappingCmp);
    if (eventEntry && (hashId == eventEntry->mHashId)) {
        deductResult = eventEntry->mEventCallHandler(this, aMessage, eventId);
    }
    else {
        typedef Cit::Internal::VSDeductHelper<VS_Ret_Ok, AppHmi_NavigationStateMachine > VSDeductHelper;
#ifndef VISUALSTATE_HCODER
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<SEM_EVENT_TYPE>(eventId)));
#else
        return VSDeductHelper::ProcessOutput(*this, (*this.*VSDeductHelper::GetPointer())(static_cast<VS_UINT8>(eventId), 0));
#endif
    }
    return deductResult;
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::HandleDataBindingEventMapping(::Courier::AbstractDataItemMsg const & /* message */, ::FeatStd::UInt32 & /* eventId */) const
{
    return false;
}

#ifdef CIT_SIMULATION
struct EventNameMapping
{
    ::FeatStd::UInt32 mEventId;
    const ::FeatStd::Char* mEventName;
    void (*mGetEventArguments)(::Courier::Message const & message, Json::Value& eventArguments);
};

static ::FeatStd::Int EventNameMappingCmp(::FeatStd::UInt32 eventId, const EventNameMapping& em)
{
    return (eventId == em.mEventId) ? 0 : ((eventId < em.mEventId) ? -1 : 1);
}

static void GetEventArgumentsForonEvNavigationMWInitialized(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::NavigationInitializedUpReqMsg const & message = static_cast< ::NavigationInitializedUpReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (bool)message.GetMwStatus();
}

static void GetEventArgumentsForev_OnButtonPressUseTollRoadItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForev_N_PickInMap_options_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::PickInMapOptionsUpdateMsg const & message = static_cast< ::PickInMapOptionsUpdateMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPickInMapOptionID();
}

static void GetEventArgumentsForev_MapTimerExpired(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForev_N_SpellerEdit_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_N_Map_GoToHome_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::GotoHomeReqMsg const & message = static_cast< ::GotoHomeReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (bool)message.GetIsGoToHome();
}

static void GetEventArgumentsForonTopPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_ShowMapOrnewDestFromGadget(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ShowMapOrnewDestFromGadgetReqMsg const & message = static_cast< ::ShowMapOrnewDestFromGadgetReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetActiveContextID();
}

static void GetEventArgumentsForev_OnButtonPressCustomRouteItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonMapOkButton(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForev_N_OPTMapOptions_Others_ListUpdate_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::MapSettingsOthersListUpdateMsg const & message = static_cast< ::MapSettingsOthersListUpdateMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetMapSettingsOthersListID();
}

static void GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EncoderStatusChangedUpdMsg const & message = static_cast< ::EncoderStatusChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetEncSteps();
}

static void GetEventArgumentsForev_Pfo_Dest_CalcRoute_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::AddressInputGuidancetouchMsg const & message = static_cast< ::AddressInputGuidancetouchMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetGuidanceActive();
}

static void GetEventArgumentsForev_N_Enable_StreamedMap_Timer(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::EnableStreamedMapTimerReqMsg const & message = static_cast< ::EnableStreamedMapTimerReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (bool)message.GetIsStreamedMapEnabled();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetTimerDuration();
}

static void GetEventArgumentsForev_N_Map_ZoomIn_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForev_N_Map_ZoomOut_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressTimeOnMapItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::StreamedMapSubOptionsListUpdateMsg const & message = static_cast< ::StreamedMapSubOptionsListUpdateMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubOptionsListID();
}

static void GetEventArgumentsForonEvCompass(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForonTopPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_ShowPosandGPSFromCabinGNSSSettings(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ShowPosandGPSFromCabinGNSSSettingstReqMsg const & message = static_cast< ::ShowPosandGPSFromCabinGNSSSettingstReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetActiveContextID();
}

static void GetEventArgumentsForev_UpdateVehicleSettingsChangeDuringRG(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::UpdateVehicleSettingsChangeDuringRGReqMsg const & message = static_cast< ::UpdateVehicleSettingsChangeDuringRGReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetIsSettingsSavedDuringRG();
}

static void GetEventArgumentsForonTopPopupSurfaceVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceInvisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SubSurfaceUpdMsg const & message = static_cast< ::SubSurfaceUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::Int)message.GetDisplayRegion();
    eventArguments[(::Json::Value::UInt)1] = (::Json::Value::UInt)message.GetDisplayID();
}

static void GetEventArgumentsForonDeactivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForonEVLocationMapScroll(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonReactionMsg const & message = static_cast< ::ButtonReactionMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetView().GetHashId().HashValue();
}

static void GetEventArgumentsForonCenterPopupSurfaceUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressUseTrafficInfoItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonTopPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupVisible(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForonPopupQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnButtonPressEstimatedTimeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonPopupUnqueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_OnPopupTypeUpdate(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::PopupTypeUpdateMsg const & message = static_cast< ::PopupTypeUpdateMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetPopupType();
}

static void GetEventArgumentsForonActivateImageProviderRequest(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::hmibase::gadget::ActivateImageProviderReqMsg const & message = static_cast< ::hmibase::gadget::ActivateImageProviderReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetInstanceId();
}

static void GetEventArgumentsForev_NAVDATAUPDATE_InternalUpdateStatus(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::NAVDATAUPDATE_InternalUpdateStatusUpdMsg const & message = static_cast< ::NAVDATAUPDATE_InternalUpdateStatusUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetStatus();
}

static void GetEventArgumentsForev_OnButtonPressRouteTypeItem(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ButtonListItemUpdMsg const & message = static_cast< ::ButtonListItemUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetSubHdl();
}

static void GetEventArgumentsForonPopupTimerExpiry(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ExpiredPopupTimerResMsg const & message = static_cast< ::ExpiredPopupTimerResMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId();
}

static void GetEventArgumentsForev_DisplayLastActiveNaviContext(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::DisplayLastNaviContextReqMsg const & message = static_cast< ::DisplayLastNaviContextReqMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetLastActiveContextID();
}

static void GetEventArgumentsForonCenterPopupSurfaceQueued(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::SurfaceStateChangedUpdMsg const & message = static_cast< ::SurfaceStateChangedUpdMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (::Json::Value::UInt)message.GetViewId().GetHashId().HashValue();
}

static void GetEventArgumentsForev_N_Map_ActivatePOIInfoSelectedOnMap(::Courier::Message const & aMessage, Json::Value& eventArguments) {
    ::ActivatePOIInfoSelectedOnMapMsg const & message = static_cast< ::ActivatePOIInfoSelectedOnMapMsg const &>(aMessage);
    eventArguments[(::Json::Value::UInt)0] = (bool)message.GetIsMultiplePOIAvailable();
}

const ::FeatStd::Char* AppHmi_NavigationStateMachineImpl::GetEventName(::FeatStd::UInt32 eventId, ::Courier::Message const & message, Json::Value& eventArguments)
{
    static EventNameMapping events[305] = {
        { 0x01E354F2, "ev_ResetAllNaviSettings_Yes_touch", 0 },
        { 0x02AC9AE8, "onEvNavigationMWInitialized", GetEventArgumentsForonEvNavigationMWInitialized },
        { 0x03466B12, "ev_N_Alternateroute_Yes_touch", 0 },
        { 0x03C82F61, "ev_N_OPTMapOptions_ShowPOIOnMap_touch", 0 },
        { 0x03C9560F, "ev_N_VehicleSettings_NoChange", 0 },
        { 0x0439DDCE, "ev_N_ShowRouteList_touch", 0 },
        { 0x06B172D9, "ev_OnEnggDetails_Backtouch", 0 },
        { 0x0798B0C6, "ev_ResetAllNaviSettings_No_touch", 0 },
        { 0x07AD97C6, "ev_ReplaceFavList_touch", 0 },
        { 0x088D477D, "ev_N_Map_NoRG_Move_touch", 0 },
        { 0x08C22AFD, "ev_N_NewDestination_Home_touch", 0 },
        { 0x08E259D4, "ev_N_StreamedMap_Settings_touch", 0 },
        { 0x09635AFB, "ev_N_Map_NoRG_Move_Back_touch", 0 },
        { 0x0A0DAFAB, "ev_N_Map_Destination_touch", 0 },
        { 0x0A49EA5B, "onEvCompassMapSplitView", 0 },
        { 0x0B48E710, "ev_N_Pfo_FourLine_SingleButton_Yes_touch", 0 },
        { 0x0BBF1EFD, "ev_N_MaxFavReached_No_touch", 0 },
        { 0x0C649D11, "onEvCompassMapMoveBtn", 0 },
        { 0x0D0F5602, "onHMISubStateChanged_STANDBY", 0 },
        { 0x0D824A39, "ev_Favorites_Home_back_touch", 0 },
        { 0x144F9439, "ev_N_Alternateroute_ZoomOut_touch", 0 },
        { 0x14B51C0D, "ev_OnButtonPressUseTollRoadItem", GetEventArgumentsForev_OnButtonPressUseTollRoadItem },
        { 0x153669AC, "onEvPOICategoryBrowse", 0 },
        { 0x157702DD, "ev_N_TMC_AllNoRG_TouchAreaBack", 0 },
        { 0x16B4C964, "ev_N_Guidance_POIsatDestination_touch", 0 },
        { 0x1789A37C, "ev_N_POI_Icon_OnMap_touch", 0 },
        { 0x1AF75D90, "ev_N_OptRouteOptions_Others_back_touch", 0 },
        { 0x1B361EBB, "ev_N_Navigation_Gadget_NavigationBG_touch", 0 },
        { 0x1B460D2A, "ev_N_PickInMap_options_touch", GetEventArgumentsForev_N_PickInMap_options_touch },
        { 0x1B8132A1, "ev_N_POI_CategoryRoot_Back_1_touch", 0 },
        { 0x1D5865C6, "ev_Set_LatDegreesActive", 0 },
        { 0x1D7F21E9, "ev_N_MyPOIs_AddressInput_NewDestination_touch", 0 },
        { 0x1DC94BDF, "ev_N_LeftMapScale_ZoomIn_touch", 0 },
        { 0x1E1DD183, "ev_Pfo_MaxWaypoint_Reached", 0 },
        { 0x1E89782F, "ev_CloseLatLongInvalidPopUp", 0 },
        { 0x1EF09283, "ev_N_MyPOIs_AddressInput_CategoryRoot_touch", 0 },
        { 0x2024F18A, "ev_Pfo_AvoidTollRoad_Yes_touch", 0 },
        { 0x222F2161, "ev_DisplaySpeedLockPopup", 0 },
        { 0x2260456D, "ev_MapTimerExpired", GetEventArgumentsForev_MapTimerExpired },
        { 0x22AFD4E8, "ev_N_SpellerEdit_touch", GetEventArgumentsForev_N_SpellerEdit_touch },
        { 0x23B97E51, "onCenterPopupSurfaceVisible", GetEventArgumentsForonCenterPopupSurfaceVisible },
        { 0x24D8921D, "ev_N_Pfo_FiveLine_TwoButton_No_touch", 0 },
        { 0x263EAF7F, "onHKStatusChanged_HK_SELECT_UP", 0 },
        { 0x26C30D04, "OnPreviousLevelTransitionFinished", 0 },
        { 0x277D1059, "ev_N_POI_List_Back_1_touch", 0 },
        { 0x28533CAB, "ev_N_MapScale_Back_touch", 0 },
        { 0x290F59EE, "onEvShowLocationOnMap", 0 },
        { 0x2ABAF108, "ev_N_Pfo_DestVehicleInfo_StartGuidance_touch", 0 },
        { 0x2B1CED0F, "ev_ShowMapActiveRG", 0 },
        { 0x2B26EF67, "ev_N_SettingsVehicleParameter_back_touch", 0 },
        { 0x2B7D8530, "ev_N_MapActiveRG_RoutePreference_touch", 0 },
        { 0x2C94970F, "ev_N_OPTMapOptions_Others_Back_touch", 0 },
        { 0x2CB72C98, "ev_N_PickInMapOption_Back_touch", 0 },
        { 0x2D5235FF, "ev_N_Map_GoToHome_touch", GetEventArgumentsForev_N_Map_GoToHome_touch },
        { 0x2E097943, "ev_N_Favorite_Map_touch", 0 },
        { 0x2E2889F8, "ev_N_Guidance_Waypoint_touch", 0 },
        { 0x2FDD556D, "ev_N_Alternateroute_ZoomIn_touch", 0 },
        { 0x307CEC79, "onEvCompassLeftMapScaleBtn", 0 },
        { 0x314AF035, "ev_N_Dest_Guidance_Map_Display_touch", 0 },
        { 0x316E1D58, "ev_ShowNaviResetSettingsApplied_touch", 0 },
        { 0x317896C4, "ev_Pfo_SoftPhysicalRestrictionInfo_Yes_touch", 0 },
        { 0x32840E52, "ev_N_OptMapSettingsOptions_touch", 0 },
        { 0x32AC175F, "ev_N_Map_TMC_Touch_ActiveRouteGuidance", 0 },
        { 0x32FB39B0, "ev_N_OPT_MyPOIs_POIOPT_back_touch", 0 },
        { 0x334FC07C, "ev_N_TMC_Map_ActiveRG_OnRoute", 0 },
        { 0x3377F3AE, "ev_Favorites_Home_back_CurPos", 0 },
        { 0x33FBB14F, "ev_N_Favorites_Route_touch", 0 },
        { 0x343AD03D, "ev_N_GeoCordinates_Back_touch", 0 },
        { 0x3534B12E, "ev_N_SettingsVehicleParameter_touch", 0 },
        { 0x3598CF84, "onTopPopupSurfaceInvisible", GetEventArgumentsForonTopPopupSurfaceInvisible },
        { 0x35B5584E, "ev_N_OptRouteOptions_touch", 0 },
        { 0x36FC3FC7, "onEVShowDetailInfoOfPickedPOI", 0 },
        { 0x3884FD9C, "onEvCompassTrafficDetourBtn", 0 },
        { 0x38A08E7A, "ev_ShowMapOrnewDestFromGadget", GetEventArgumentsForev_ShowMapOrnewDestFromGadget },
        { 0x38FE4A1F, "ev_N_POI_CategorySublevel_Back_1_touch", 0 },
        { 0x393FC7BD, "ev_Activate_EnggMenu", 0 },
        { 0x3966047B, "onEvRefreshMapOnBackGround", 0 },
        { 0x39D2BBF5, "ev_N_LastDestinations_fav_touch", 0 },
        { 0x3A0E9B64, "ev_By_Map_Location_Selected", 0 },
        { 0x3B58F7C7, "ev_N_DetailedInfo_Back_touch", 0 },
        { 0x3DD0AC0C, "ev_ShowRouteBlockList", 0 },
        { 0x3E808BD1, "ev_N_Pfo_LastDest_Delete_Yes_touch", 0 },
        { 0x3E98E72C, "ev_N_Alternateroute_No_touch", 0 },
        { 0x403A65A4, "OnDualViewLeftTransitionFinished", 0 },
        { 0x417A3196, "ev_NAVDATAUPDATE_UpdateInfoStoped", 0 },
        { 0x437D9EFE, "OnPageFlipFrontFinished", 0 },
        { 0x43BE5677, "Onev_N_SplitScreenMap_disabled", 0 },
        { 0x460BF28F, "ev_N_Fav_AddFavorites_Edit_touch", 0 },
        { 0x46891BD1, "ev_ShowTrafficDetailedInfoView", 0 },
        { 0x473E2FEB, "ev_N_Guidance_Favorites_touch", 0 },
        { 0x47A97E5B, "ev_ShowVehicleInfo", 0 },
        { 0x47FF854B, "ev_N_MapMove_ZoomOut_touch", 0 },
        { 0x484C6E7D, "ev_N_TMC_Map_ActiveRG_TouchareaBack", 0 },
        { 0x48AA0BF4, "ev_Favorites_AddressInput_touch", 0 },
        { 0x48E0D32B, "ev_N_VehicleSettings_Changed", 0 },
        { 0x490A5E13, "ev_N_OptGuidanceOptions_touch", 0 },
        { 0x4915BA8B, "ev_N_NewDestination_POI_Nearby_touch", 0 },
        { 0x4956DBDB, "ev_N_OPT_POsitionAndGpsInfo_touch", 0 },
        { 0x4A87AF31, "ev_OnButtonPressCustomRouteItem", GetEventArgumentsForev_OnButtonPressCustomRouteItem },
        { 0x4B37E7CD, "ev_N_Favorites_touch", 0 },
        { 0x4C7D13ED, "ev_N_StreamedMap_SettingsSubOptions_Back_touch", 0 },
        { 0x4C8518AE, "onAppStatusPrepare_BACKGROUND", 0 },
        { 0x4C8CA81C, "ev_N_Dest_Guidance_Back_touch", 0 },
        { 0x4E5453C8, "ev_N_TMC_OnRoute_TouchAreaBack", 0 },
        { 0x50AF6E2D, "ev_N_MapActiveRG_RouteOverview", 0 },
        { 0x50B4DCCA, "OnDualViewRightTransitionFinished", 0 },
        { 0x530D4A4B, "ev_ShowNewDestOnNaviHomeTitlePress", 0 },
        { 0x53CF7870, "ev_N_OptPremiumTraffic_Disclaimer_Decline_touch", 0 },
        { 0x53EC8EC9, "ev_N_Guidance_New_touch", 0 },
        { 0x54553B2A, "ev_N_Fav_AddFavorites_Save_Displayed_touch", 0 },
        { 0x54A697D9, "ev_N_Fav_AddFavorites_Back_touch", 0 },
        { 0x5790D8C1, "onSubSurfaceUpdMsgChanged_BACKGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_BACKGROUND },
        { 0x587887FC, "ev_N_Map_ActivateRGEconomicSelectionBtn", 0 },
        { 0x59489D8C, "ev_N_ShowPOIDetailForCoordinates", 0 },
        { 0x5A2A2AEB, "Onev_N_PremiumTraffic_Disclaimer_Msg", 0 },
        { 0x5B0386F7, "ev_N_GeoCordinates_ToggleSouthNorth", 0 },
        { 0x5C6AF210, "onMapOkButton", GetEventArgumentsForonMapOkButton },
        { 0x5C898A0C, "ev_Set_LatDecimalsActive", 0 },
        { 0x5CCED270, "ev_N_OptPremiumTraffic_touch", 0 },
        { 0x5D38A234, "ev_N_OptPremiumTraffic_Disclaimer_OK_touch", 0 },
        { 0x5E7CBF66, "ev_N_Guidance_Previous_touch", 0 },
        { 0x5F60DF88, "ev_OnNavigationButton_Backtouch", 0 },
        { 0x5FDA4593, "ev_N_OPTMapOptions_Others_ListUpdate_touch", GetEventArgumentsForev_N_OPTMapOptions_Others_ListUpdate_touch },
        { 0x62C227C4, "ev_N_Pfo_DestVehicleInfo_ChangeProfile_touch", 0 },
        { 0x62D24D8B, "ev_Pfo_Warning_CarModeSelection_No_touch", 0 },
        { 0x62E41263, "ev_N_Dest_Guidance_Replace_Destination_touch", 0 },
        { 0x6376DC73, "ev_Set_LongDegreesActive", 0 },
        { 0x6409C3C5, "ev_N_Guidance_Home_touch", 0 },
        { 0x65161EC6, "ev_N_Pfo_LastDest_Delete_all_touch", 0 },
        { 0x654E4085, "ev_N_MapActiveRG_NormalMapView", 0 },
        { 0x65F77E34, "ev_N_SpellerExpander_touch", 0 },
        { 0x67E5D82B, "onEncoderStatusChanged_RIGHT_ENC", GetEventArgumentsForonEncoderStatusChanged_RIGHT_ENC },
        { 0x68B7CB05, "ev_N_Pfo_LastDest_Delete_touch", 0 },
        { 0x6A82F509, "ev_Pfo_Dest_CalcRoute_touch", GetEventArgumentsForev_Pfo_Dest_CalcRoute_touch },
        { 0x6BB8E327, "ev_N_Map_ActivateRGShortestSelectionBtn", 0 },
        { 0x6CE0C1F3, "ev_N_OptGuidanceOptions_back_touch", 0 },
        { 0x6CF22BC6, "ev_N_Guidance_POIsonRoute_touch", 0 },
        { 0x6D1B3A68, "onAppStatusChanged_BACKGROUND", 0 },
        { 0x6E06BB21, "ev_N_Enable_StreamedMap_Timer", GetEventArgumentsForev_N_Enable_StreamedMap_Timer },
        { 0x70E56B3F, "ev_N_OPTMapOptions_OnMap_Back_touch", 0 },
        { 0x71D1BEA7, "ev_N_MapSettingsTrackingDots_Delete_touch", 0 },
        { 0x727C4C8C, "ev_N_POI_FreeTextSearch_touch", 0 },
        { 0x74B6BF44, "onEvMapCenterBtn", 0 },
        { 0x74F534EE, "OnPageFlipBackFinished", 0 },
        { 0x753866F6, "ev_N_MapMove_ZoomIn_touch", 0 },
        { 0x75E0DA9F, "ev_N_Map_ZoomIn_touch", GetEventArgumentsForev_N_Map_ZoomIn_touch },
        { 0x75E14F2E, "ev_N_Waypoint_DetailedInfo_touch", 0 },
        { 0x76CF2B88, "onHMISubStateChanged_ON", 0 },
        { 0x76D9CED4, "ev_N_SpellerMatchList_Back_touch", 0 },
        { 0x776D7D8A, "onHMISubStateChanged_OFF", 0 },
        { 0x796E1AC5, "ev_CalculateRouteGuidancePopUpClosed", 0 },
        { 0x7AA17150, "ev_Context_Opt_touch", 0 },
        { 0x7AEC8E5F, "ev_N_Map_ZoomOut_touch", GetEventArgumentsForev_N_Map_ZoomOut_touch },
        { 0x7B4A80D3, "ev_N_OPTMapOptions_Others_touch", 0 },
        { 0x7B9E961F, "ev_N_Destination_Previous_touch", 0 },
        { 0x7C267F12, "ev_N_OptSafetySettings_touch", 0 },
        { 0x7F903D7C, "ev_UpdateVehicleParameterStatus", 0 },
        { 0x7FBB27FF, "ev_N_LeftMapScale_ZoomOut_touch", 0 },
        { 0x809877AD, "ev_N_Favorites_Prevtab_touch", 0 },
        { 0x80A4C892, "ev_N_SpellerEdit_Back_touch", 0 },
        { 0x8186352B, "ev_Set_LongMinutesActive", 0 },
        { 0x818723A2, "ev_N_NewDest_AddressInput_touch", 0 },
        { 0x81B931EC, "ev_N_Favorite_Home_touch", 0 },
        { 0x81C6BE9A, "ev_OnButtonPressTimeOnMapItem", GetEventArgumentsForev_OnButtonPressTimeOnMapItem },
        { 0x832E18D9, "ev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch", GetEventArgumentsForev_N_StreamedMap_SettingsSubOptions_ListUpdate_touch },
        { 0x8435458C, "ev_NavDataUpdateError_OK_touch", 0 },
        { 0x85B88531, "onEvCompass", GetEventArgumentsForonEvCompass },
        { 0x8665C59F, "ev_Pfo_LCVHardRestrictionInfo_Multiple_Yes_touch", 0 },
        { 0x88B623CE, "ev_N_Opt_back_touch", 0 },
        { 0x8AC2E13B, "ev_FavHome_DetailedInfo_touch", 0 },
        { 0x8B1D0C98, "ev_N_NewDestination_My_POI_Search_touch", 0 },
        { 0x8B3B7AF1, "ev_N_Previous_Route_touch", 0 },
        { 0x8B6C9ED9, "ev_N_BlockRouteList_BackTouch", 0 },
        { 0x8B8B6E37, "ev_N_NewDest_AddressInput_MatchSelection_done", 0 },
        { 0x8BDDF654, "ev_N_POIInfo_Back_touch", 0 },
        { 0x8D03FF0C, "ev_N_OptRouteOptions_back_touch", 0 },
        { 0x8EB6889D, "onEvEngineeringMenu", 0 },
        { 0x8F304B4C, "ev_Set_LatMinutesActive", 0 },
        { 0x912024BE, "onTopPopupSurfaceUnqueued", GetEventArgumentsForonTopPopupSurfaceUnqueued },
        { 0x9178F44D, "ev_ShowPosandGPSFromCabinGNSSSettings", GetEventArgumentsForev_ShowPosandGPSFromCabinGNSSSettings },
        { 0x91C81897, "ev_N_ShowRouteList_BackTouch", 0 },
        { 0x9226AE0D, "ev_N_Address_DetailedInfo_Fav_AddFavorites_touch", 0 },
        { 0x9279AC87, "ev_N_FavoritesNewtab_touch", 0 },
        { 0x931B9263, "ev_N_OPTMapOptions_Back_touch", 0 },
        { 0x94BA5255, "ev_NAVDATAUPDATE_UpdateBlockedBySWUpdate", 0 },
        { 0x95CB66E0, "ev_UpdateVehicleSettingsChangeDuringRG", GetEventArgumentsForev_UpdateVehicleSettingsChangeDuringRG },
        { 0x96896ECA, "ev_Pfo_AvoidTollRoad_No_touch", 0 },
        { 0x96D375CB, "ev_Favorites_Home_touch", 0 },
        { 0x971DB5ED, "ev_N_OptTrafficOption_back_touch", 0 },
        { 0x984F8ED8, "onTopPopupSurfaceVisible", GetEventArgumentsForonTopPopupSurfaceVisible },
        { 0x99ABAFF6, "ev_SaveAsHome_DetailedInfo_touch", 0 },
        { 0x9A11AE20, "ev_N_OPT_POsitionAndGpsInfoCabinOnly_back_touch", 0 },
        { 0x9AB5705B, "ev_ReplaceFavHomePopup", 0 },
        { 0x9B740D33, "ev_N_OPT_MyPOIs_POIOPT_touch", 0 },
        { 0x9BDB722F, "onCenterPopupSurfaceInvisible", GetEventArgumentsForonCenterPopupSurfaceInvisible },
        { 0x9D407C51, "ev_N_Guidance_StopGuidance_touch", 0 },
        { 0x9D4DF4FC, "onSubSurfaceUpdMsgChanged_FOREGROUND", GetEventArgumentsForonSubSurfaceUpdMsgChanged_FOREGROUND },
        { 0x9FE98C1E, "onDeactivateImageProviderRequest", GetEventArgumentsForonDeactivateImageProviderRequest },
        { 0xA0CD2C27, "ev_HideSpeedLockPopup", 0 },
        { 0xA15C3CEE, "onHMISubStateChanged_STANDBY_RESTRICTED", 0 },
        { 0xA1D5C8FC, "ev_N_OptSafetySettings_back_touch", 0 },
        { 0xA21222ED, "ev_Favorite_DetailedInfo_touch", 0 },
        { 0xA275FA19, "ev_Pfo_SoftPhysicalRestrictionInfo_No_touch", 0 },
        { 0xA28FFAFC, "Onev_N_HorizonEventChanged", 0 },
        { 0xA3370687, "ev_N_Map_TMC_Touch_NoRouteGuidance", 0 },
        { 0xA39F01FD, "onEVLocationMapScroll", GetEventArgumentsForonEVLocationMapScroll },
        { 0xA5A1B2A1, "ev_N_NewDest_AddressInput_Back_1_touch", 0 },
        { 0xA6C5E637, "ev_N_SpellerMathchList_Enable", 0 },
        { 0xA73BECC9, "ev_N_POIList_DetailedInfo_touch", 0 },
        { 0xA90957A8, "ev_Pfo_LCVHardRestrictionConfirm_Multiple_Yes_touch", 0 },
        { 0xAA0065BF, "ev_N_LastDestinations_Home_touch", 0 },
        { 0xAA79C7DD, "onCenterPopupSurfaceUnqueued", GetEventArgumentsForonCenterPopupSurfaceUnqueued },
        { 0xAA8EEC84, "ev_Pfo_LCVRestrictionInfo_Yes_touch", 0 },
        { 0xAAFA4ED2, "ev_N_LastDestinations_Map_touch", 0 },
        { 0xAB89D7A8, "onHMISubStateChanged_SECURE", 0 },
        { 0xAD803C65, "ev_N_NewDestination_Map_touch", 0 },
        { 0xADBF6DC7, "ev_N_MapActiveRG_back_touch", 0 },
        { 0xB0128FFA, "onEVMapScroll", 0 },
        { 0xB05A5B90, "ev_AddressInputHome_touch", 0 },
        { 0xB4A58C3A, "ev_N_Disclaimer_Confirm_touch", 0 },
        { 0xB5F016E6, "ev_OnButtonPressUseTrafficInfoItem", GetEventArgumentsForev_OnButtonPressUseTrafficInfoItem },
        { 0xB630DDBD, "onTopPopupSurfaceQueued", GetEventArgumentsForonTopPopupSurfaceQueued },
        { 0xB6D77E1F, "ev_N_Pfo_DestVehicleInfo_Changed", 0 },
        { 0xB78D7AE0, "onPopupVisible", GetEventArgumentsForonPopupVisible },
        { 0xBB61861D, "ev_N_Navigation_Gadget_NavigationTitle_touch", 0 },
        { 0xBBE6896C, "onPopupQueued", GetEventArgumentsForonPopupQueued },
        { 0xBC50C969, "ev_N_OptRouteOptions_Others_touch", 0 },
        { 0xBC7D3575, "ev_N_NewDestination_POI_Search_touch", 0 },
        { 0xBE519690, "ev_NavDataUpdateProgress_OK_touch", 0 },
        { 0xBEA799EB, "ev_Pfo_ThreeLine_OneButton_Yes_touch", 0 },
        { 0xBEAED657, "ev_N_LeftSplitMap_MapScale_touch", 0 },
        { 0xBEF69ED6, "onEvAllPOICategory", 0 },
        { 0xC1401EEE, "ev_N_OPT_POsitionAndGpsInfo_back_touch", 0 },
        { 0xC14B9692, "ev_N_Opt_touch", 0 },
        { 0xC1697C56, "ev_N_OptTrafficIcons_back_touch", 0 },
        { 0xC198D341, "ev_N_Guidance_Waypoint_Back_touch", 0 },
        { 0xC1FBA0B0, "ev_N_OPTMapOptions_MapColor_back_touch", 0 },
        { 0xC20CD2C8, "onEvNavigationInitialized", 0 },
        { 0xC30F8252, "ev_N_Map_POINearBy_touch", 0 },
        { 0xC6B7F551, "ev_SaveWithDisplayedName_DetailedInfo_touch", 0 },
        { 0xC8D83B8B, "onHMISubStateChanged_PHONE", 0 },
        { 0xC90EE55C, "ev_Pfo_XUrgent_Message_Yes_touch", 0 },
        { 0xC94AA027, "onMapPOIOkButton", 0 },
        { 0xC9D5EA50, "ev_OnButtonPressEstimatedTimeItem", GetEventArgumentsForev_OnButtonPressEstimatedTimeItem },
        { 0xCA0F1260, "ev_N_OPT_TrafficIcons_touch", 0 },
        { 0xCAD4B145, "ev_N_GeoCordinates_ChangeLatLongFormat", 0 },
        { 0xCBE53344, "ev_Pfo_LCVHardRestrictionConfirm_Multiple_No_touch", 0 },
        { 0xCC54D8B8, "ev_N_LatLong_DetailedInfo_touch", 0 },
        { 0xCD80D9B2, "ev_Stopguidance", 0 },
        { 0xCDA17FBA, "ev_N_MaxFavReached_Yes_touch", 0 },
        { 0xCFB289C7, "ev_ShowMapOnNaviHomeBtnPress", 0 },
        { 0xD02AC3F0, "ev_N_UPOIList_DetailedInfo_touch", 0 },
        { 0xD5CF5E82, "ev_NavDataUpdate_Yes_touch", 0 },
        { 0xD6C79322, "ev_N_OptPremiumTraffic_back_touch", 0 },
        { 0xD7BFC39F, "ev_Set_LongDecimalsActive", 0 },
        { 0xDB0D29F4, "onPopupUnqueued", GetEventArgumentsForonPopupUnqueued },
        { 0xDB73B368, "ev_Pfo_SingleLine_SingleButton_Yes_touch", 0 },
        { 0xDCE125B8, "ev_OnPopupTypeUpdate", GetEventArgumentsForev_OnPopupTypeUpdate },
        { 0xDD62EA5B, "onActivateImageProviderRequest", GetEventArgumentsForonActivateImageProviderRequest },
        { 0xDDA1D21B, "onNavigationViewMsg", 0 },
        { 0xDDEB6848, "ev_Set_LongSecondsActive", 0 },
        { 0xDE67ADB6, "ev_NAVDATAUPDATE_InternalUpdateStatus", GetEventArgumentsForev_NAVDATAUPDATE_InternalUpdateStatus },
        { 0xDE9448E3, "onAppStatusChanged_FOREGROUND", 0 },
        { 0xDF1FDBB3, "ev_Set_LatSecondsActive", 0 },
        { 0xDF842EF4, "ev_N_NewDestination_My_POI_Nearby_touch", 0 },
        { 0xE0651FD6, "ev_ShowNaviMapOnHardKeyPress", 0 },
        { 0xE10B7A97, "ev_N_GeoCordinates_touch", 0 },
        { 0xE140D19B, "ev_N_OptTrafficOption_touch", 0 },
        { 0xE1784D36, "ev_N_LastDestinations_DetailedInfo_touch", 0 },
        { 0xE2FA5002, "ev_NAVDATAUPDATE_Nav_GotoNavUpdateScreen", 0 },
        { 0xE4658CFD, "onHMISubStateChanged_NO_DISPLAY", 0 },
        { 0xE62300B5, "ev_N_StreamedMap_Settings_Back_touch", 0 },
        { 0xE7DCE080, "OnNextLevelTransitionFinished", 0 },
        { 0xE858FFF3, "ev_OnUPOIInvalidateUpdateMsg", 0 },
        { 0xE9A6D56C, "OnFadeAnimationFinished", 0 },
        { 0xE9AB040E, "ev_ValidateNaviEntryConditionFailed", 0 },
        { 0xEA787173, "ev_N_AddressInputDetails_touch", 0 },
        { 0xEACB1A77, "ev_OnButtonPressRouteTypeItem", GetEventArgumentsForev_OnButtonPressRouteTypeItem },
        { 0xEB62D68D, "ev_N_Map_ActivateRGFastestSelectionBtn", 0 },
        { 0xECA1F091, "ev_N_Pfo_FiveLine_TwoButton_Yes_touch", 0 },
        { 0xF097E342, "ev_N_TMC_DetailedInfo_touch", 0 },
        { 0xF0C07B6B, "ev_N_LastDestinations_New_touch", 0 },
        { 0xF1766B33, "ev_N_GeoCordinates_ToggleEastWest", 0 },
        { 0xF1AD2565, "ev_ShowMap", 0 },
        { 0xF2BE5666, "ev_Pfo_Warning_CarModeSelection_Yes_touch", 0 },
        { 0xF37D3EE2, "ev_N_Guidance_DestinationInfo_touch", 0 },
        { 0xF3B28149, "ev_ReplaceFavorite_Backtouch", 0 },
        { 0xF3C96D17, "onPopupTimerExpiry", GetEventArgumentsForonPopupTimerExpiry },
        { 0xF3EB342F, "ev_NavDataUpdate_No_touch", 0 },
        { 0xF45329CC, "ev_N_Pfo_LastDest_Delete_No_touch", 0 },
        { 0xF4FA9AAE, "ev_N_SpellerEdit_FreeText_Back_touch", 0 },
        { 0xF5DBC32E, "ev_N_NewDestination_Route_touch", 0 },
        { 0xF61CBDFD, "ev_N_NewDestination_NewAddress_touch", 0 },
        { 0xF6B25AC4, "ev_N_Map_ActivateRGstartGuidanceSelectionBtn", 0 },
        { 0xF84B3BD1, "OnZoomOutFinished", 0 },
        { 0xF96478DC, "onHMISubStateChanged_CLOCK", 0 },
        { 0xF99967D7, "ev_N_OPTMapOptions_MapColor_touch", 0 },
        { 0xFA741BB2, "ev_N_TMC_OnRoute_Button_All", 0 },
        { 0xFAAF20E6, "ev_DisplayLastActiveNaviContext", GetEventArgumentsForev_DisplayLastActiveNaviContext },
        { 0xFBEEA58F, "OnZoomInFinished", 0 },
        { 0xFC0D2293, "onCenterPopupSurfaceQueued", GetEventArgumentsForonCenterPopupSurfaceQueued },
        { 0xFC5369E7, "ev_N_Map_ActivatePOIInfoSelectedOnMap", GetEventArgumentsForev_N_Map_ActivatePOIInfoSelectedOnMap },
        { 0xFE0F2C75, "ev_Pfo_LCVHardRestrictionInfo_ActiveRG_Yes_touch", 0 },
        { 0xFE3206D8, "ev_Pfo_PremiumTrafficDisabled_Ok_touch", 0 },
        { 0xFF4B0BB3, "ev_N_Guidance_Map_touch", 0 },
    };
    const EventNameMapping* eventEntry = ::Courier::BinarySearch(eventId, events, 305, &EventNameMappingCmp);
    if (eventEntry && (eventId == eventEntry->mEventId)) {
        if (0 != eventEntry->mGetEventArguments) {
            eventEntry->mGetEventArguments(message, eventArguments);
        }
        return eventEntry->mEventName;
    }
    return 0;
}
#endif
// ------------------------------------------------------------------------
struct IdToNameMapping
{
    ::FeatStd::UInt32 mId;
    const ::FeatStd::Char* mName;
};

static ::FeatStd::Int IdToNameMappingCmp(::FeatStd::UInt32 id, const IdToNameMapping& nm)
{
    return (id == nm.mId) ? 0 : ((id < nm.mId) ? -1 : 1);
}

const ::FeatStd::Char * AppHmi_NavigationStateMachineImpl::GetNameFromId(::FeatStd::UInt32 id)
{
    static IdToNameMapping names[89] = {
        { 0x010D5A2C, "AppHmi_NavigationModule#NavigationScenes#N_SpellerEdit" },
        { 0x0E81324C, "AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionConfirm_Multiple" },
        { 0x10BC8137, "AppHmi_NavigationModule#NavigationScenes#N_OPT_MyPOIs_POIOPT" },
        { 0x121B3A09, "AppHmi_NavigationModule#NavigationScenes#Pfo_Dest_CalcRoute" },
        { 0x18A4A4A7, "AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_OneButton" },
        { 0x1C4E3137, "AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_TwoButton" },
        { 0x1D69C573, "AppHmi_NavigationModule#NavigationScenes#N_MapOverlay_TBT" },
        { 0x1E5F873E, "AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionInfo_Multiple" },
        { 0x26EE2E38, "AppHmi_NavigationModule#NavigationScenes#N_MapScale" },
        { 0x278DAD32, "AppHmi_NavigationModule#NavigationScenes#Pfo_SpeedLockInfo" },
        { 0x2E53A4D8, "AppHmi_NavigationModule#NavigationScenes#N_Disclaimer" },
        { 0x2FF4B0A9, "AppHmi_NavigationModule#NavigationScenes#N_Map_TravelerCabin_Glass" },
        { 0x30851E53, "AppHmi_NavigationModule#NavigationScenes#N_PickInMapOption" },
        { 0x30A1ACE1, "AppHmi_NavigationModule#NavigationScenes#N_TMC_AllActiveRG" },
        { 0x31F4A6C6, "AppHmi_NavigationModule#NavigationScenes#N_OPT_PositionAndGPSInfo_CabinOnly" },
        { 0x331648F4, "AppHmi_NavigationModule#NavigationScenes#N_OPT_PremiumTraffic" },
        { 0x3328B4B3, "AppHmi_NavigationModule#NavigationScenes#N_Guidance_ShowRouteList" },
        { 0x333CA148, "AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOption_Others" },
        { 0x33C71F01, "AppHmi_NavigationModule#NavigationScenes#N_OPT_PremiumTraffic_Disclaimer" },
        { 0x35D46C1E, "AppHmi_NavigationModule#NavigationScenes#N_Fav_SetHome" },
        { 0x35FECC53, "AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOptions" },
        { 0x36CC8697, "AppHmi_NavigationModule#NavigationScenes#N_StreamedMap_Settings" },
        { 0x37FD9B86, "AppHmi_NavigationModule#NavigationScenes#N_Map" },
        { 0x3AE47D94, "AppHmi_NavigationModule#NavigationScenes#Pfo_Dest_VehicleInfo" },
        { 0x3B75216B, "AppHmi_NavigationModule#NavigationScenes#N_ReplaceFavorites" },
        { 0x415AE0A4, "AppHmi_NavigationModule#NavigationScenes#N_POI_List" },
        { 0x41A4A81D, "AppHmi_NavigationModule#NavigationScenes#Pfo_PremiumTrafficDisabled" },
        { 0x41E3F72B, "AppHmi_NavigationModule#NavigationScenes#N_SpellerEdit_FreeText" },
        { 0x460A10A3, "AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Progress" },
        { 0x4AF69888, "AppHmi_NavigationModule#NavigationScenes#N_POI_CategoryRoot" },
        { 0x4B19BD33, "AppHmi_NavigationModule#NavigationScenes#N_LatLongInput" },
        { 0x4B77EC38, "AppHmi_NavigationModule#NavigationScenes#Pfo_LCVRestrictionInfo" },
        { 0x51DC2B1F, "AppHmi_NavigationModule#NavigationScenes#Pfo_FiveLine_TwoButton" },
        { 0x527565DD, "AppHmi_NavigationModule#NavigationScenes#N_StreamedMap_SubOptions" },
        { 0x5655905F, "AppHmi_NavigationModule#NavigationScenes#N_Favorites" },
        { 0x57B13425, "AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Interactive" },
        { 0x5895811D, "AppHmi_NavigationModule#NavigationScenes#N_MapOverlay_ETA" },
        { 0x5DE7C862, "AppHmi_NavigationModule#NavigationScenes#N_OPT_GuidanceOptions" },
        { 0x60125033, "AppHmi_NavigationModule#NavigationScenes#N_MyPOIs_AddressInput" },
        { 0x68713867, "AppHmi_NavigationModule#NavigationScenes#N_POIInfo" },
        { 0x7BB9DF69, "AppHmi_NavigationModule#NavigationScenes#N_Map_Move" },
        { 0x7C77F1AB, "AppHmi_NavigationModule#NavigationScenes#Pfo_HomeEdit_Info_ThreeLine" },
        { 0x8034D066, "AppHmi_NavigationModule#NavigationScenes#N_Testmode_EngineeringMenu" },
        { 0x858A9D30, "AppHmi_NavigationModule#NavigationScenes#N_OPT_SpeedLimitOption" },
        { 0x8935B6BD, "AppHmi_NavigationModule#NavigationScenes#Pfo_LCVHardRestrictionInfo_ActiveRG" },
        { 0x89B2392E, "AppHmi_NavigationModule#NavigationScenes#N_Dest_Guidance" },
        { 0x89ED02F1, "AppHmi_NavigationModule#NavigationScenes#Pfo_FourLine_SingleButton" },
        { 0x8AA3DF23, "AppHmi_NavigationModule#NavigationScenes#N_Map_TravelerCabin_GlassCabinOnly" },
        { 0x8AC38FF9, "AppHmi_NavigationModule#NavigationScenes#Pfo_SingleLine_SingleButton" },
        { 0x8E56BAA5, "AppHmi_NavigationModule#NavigationScenes#N_POI_CategorySublevel" },
        { 0x90BD6B07, "AppHmi_NavigationModule#NavigationScenes#N_Speller_MatchList" },
        { 0x918EB350, "AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOption_MapColor" },
        { 0x925D1292, "AppHmi_NavigationModule#NavigationScenes#N_OPT_MapOptions_OnMap" },
        { 0x94361B2E, "AppHmi_NavigationModule#NavigationScenes#N_Testmode_EngineeringMenuDetails" },
        { 0x9492A0D6, "AppHmi_NavigationModule#NavigationScenes#N_Address_DetailedInfo" },
        { 0x96408680, "AppHmi_NavigationModule#NavigationScenes#Pfo_MultiLine_Text" },
        { 0x9AC6F4E9, "AppHmi_NavigationModule#NavigationScenes#N_Guidance" },
        { 0x9DAE8B7A, "AppHmi_NavigationModule#NavigationScenes#N_OPT_RouteOptions_Others" },
        { 0x9E493CDE, "AppHmi_NavigationModule#NavigationScenes#N_OPT" },
        { 0x9F75767A, "AppHmi_NavigationModule#NavigationScenes#N_Map_ActiveRG" },
        { 0xA616A4D8, "AppHmi_NavigationModule#NavigationScenes#N_NewDest_AddressInput" },
        { 0xAEAD30E6, "AppHmi_NavigationModule#NavigationScenes#Pfo_MapUpdate_Error" },
        { 0xB6A2FEE1, "AppHmi_NavigationModule#NavigationScenes#N_MapOverlay_CurrentStreet" },
        { 0xB78D8804, "AppHmi_NavigationModule#NavigationScenes#N_Guidance_BlockRouteList" },
        { 0xB9E9AB5E, "AppHmi_NavigationModule#NavigationScenes#N_OPT_VehicleOptions" },
        { 0xBAC71684, "AppHmi_NavigationModule#NavigationScenes#Pfo_ThreeLine_Text" },
        { 0xBD7A396F, "AppHmi_NavigationModule#NavigationScenes#N_Navigation_Gadget" },
        { 0xBED4F3F4, "AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficIcons" },
        { 0xBF34019F, "AppHmi_NavigationModule#NavigationScenes#Pfo_SoftPhysicalRestrictionInfo" },
        { 0xC0250EED, "AppHmi_NavigationModule#NavigationScenes#N_Fav_AddFavorites" },
        { 0xC039023F, "AppHmi_NavigationModule#NavigationScenes#N_TMC_OnRoute" },
        { 0xC16751A9, "AppHmi_NavigationModule#NavigationScenes#Pfo_AvoidTollRoad" },
        { 0xC5582A68, "AppHmi_NavigationModule#NavigationScenes#N_NewDestination" },
        { 0xC89D2DF7, "AppHmi_NavigationModule#NavigationScenes#Pfo_LatLong_Invalid" },
        { 0xCCF0E44C, "AppHmi_NavigationModule" },
        { 0xCEF2F74C, "AppHmi_NavigationModule#NavigationScenes#N_OPT_PositionAndGPSInfo" },
        { 0xD6E48DFF, "AppHmi_NavigationModule#NavigationScenes#N_LastDestinations" },
        { 0xDB86EC41, "AppHmi_NavigationModule#NavigationScenes#N_Alternateroute" },
        { 0xDBEEFBAF, "AppHmi_NavigationModule#NavigationScenes#N_TMC_AllNoRG" },
        { 0xE910EAFB, "AppHmi_NavigationModule#NavigationScenes#Pfo_SingleLine_TwoButton" },
        { 0xEE157D45, "AppHmi_NavigationModule#NavigationScenes#Pfo_XUrgent_Message" },
        { 0xEFF64EC9, "AppHmi_NavigationModule#NavigationScenes#Pfo_Sys_ThreeLine_Text" },
        { 0xF389FA53, "AppHmi_NavigationModule#NavigationScenes#Pfo_MultiLine_TwoButton" },
        { 0xF47E5297, "AppHmi_NavigationModule#NavigationScenes#N_Waypoints" },
        { 0xF59C4AEE, "AppHmi_NavigationModule#NavigationScenes#Pfo_MapOut_Notification" },
        { 0xF8F20AE8, "AppHmi_NavigationModule#NavigationScenes#N_OPT_RouteOptions" },
        { 0xF9ED4C64, "AppHmi_NavigationModule#NavigationScenes#N_OPT_TrafficOptions" },
        { 0xFD8E09D4, "AppHmi_NavigationModule#NavigationScenes#Pfo_Warning_CarModeSelection" },
        { 0xFEAA44A1, "AppHmi_NavigationModule#NavigationScenes#Pfo_RouteInfo" },
    };
    const IdToNameMapping *nameEntry = ::Courier::BinarySearch(id, names, 89, &IdToNameMappingCmp);
    if(nameEntry != 0 && id == nameEntry->mId) {
        return nameEntry->mName;
    }
    return "";
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::Notify_Init_Finished()
{
    Action_Notify_Init_Finished();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::ac_N_SpellerEdit_Ok_touch(::FeatStd::UInt32 aSceneType)
{
    Action_ac_N_SpellerEdit_Ok_touch(Courier::UInt32(aSceneType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acInitDestinationInput(::FeatStd::UInt32 aRequestScene, bool aRetainDetails)
{
    Action_acInitDestinationInput(Courier::UInt32(aRequestScene), bool(aRetainDetails));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acAcceptTrafficAlternativeReqMsg()
{
    Action_acAcceptTrafficAlternativeReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acRejectTrafficAlternativeReqMsg()
{
    Action_acRejectTrafficAlternativeReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSwitchContextFromTrafficDetour()
{
    Action_acSwitchContextFromTrafficDetour();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStartTrafficDetourTimer()
{
    Action_acStartTrafficDetourTimer();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDeleteAllUPOIsReqMsg()
{
    Action_acDeleteAllUPOIsReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acImportUPOIsReqMsg(bool aImportUPOIsRequest)
{
    Action_acImportUPOIsReqMsg(bool(aImportUPOIsRequest));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSkipWaypointReqMsg(bool aSkipWaypoint)
{
    Action_acSkipWaypointReqMsg(bool(aSkipWaypoint));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acLeaveFormBasedAddressInput()
{
    Action_acLeaveFormBasedAddressInput();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acInavlidateSpellerEntry(bool aIsResetSpellerEntry)
{
    Action_acInavlidateSpellerEntry(bool(aIsResetSpellerEntry));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acReplaceHomeFav()
{
    Action_acReplaceHomeFav();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acValidateNaviEntryCondition(bool aIsDisclaimerConfirmed)
{
    Action_acValidateNaviEntryCondition(bool(aIsDisclaimerConfirmed));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSaveFavoriteWithDisplayedName(::FeatStd::UInt32 aCurrentDetailedInfo)
{
    Action_acSaveFavoriteWithDisplayedName(Courier::UInt32(aCurrentDetailedInfo));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acEnableGuidanceButton_NewAddress(::FeatStd::UInt8 aGuidanceEnable)
{
    Action_acEnableGuidanceButton_NewAddress(Courier::UInt8(aGuidanceEnable));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acShowPopupText(::FeatStd::UInt8 aPopupType)
{
    Action_acShowPopupText(Courier::UInt8(aPopupType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acFavDelete(::FeatStd::UInt8 aPopupType, bool aIsHomeEntry)
{
    Action_acFavDelete(Courier::UInt8(aPopupType), bool(aIsHomeEntry));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acWaypointDelete(::FeatStd::UInt8 aPopupType)
{
    Action_acWaypointDelete(Courier::UInt8(aPopupType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acInitPOICategoryBrowse(::FeatStd::UInt8 aSearchScope)
{
    Action_acInitPOICategoryBrowse(enLocationSearchScope(aSearchScope));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetPOISearchLocation()
{
    Action_acSetPOISearchLocation();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetPickInMapLocation()
{
    Action_acSetPickInMapLocation();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSavePickInMapCoordinates()
{
    Action_acSavePickInMapCoordinates();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateDeletePopupText(::FeatStd::UInt8 aPopupTextID)
{
    Action_acUpdateDeletePopupText(Courier::UInt8(aPopupTextID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateSpeedLockPopupText()
{
    Action_acUpdateSpeedLockPopupText();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateResetOrDestinationPopupTextReqMsg(bool aIsDestGuidance)
{
    Action_acUpdateResetOrDestinationPopupTextReqMsg(bool(aIsDestGuidance));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acShowAllPOICategory()
{
    Action_acShowAllPOICategory();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetTripCountReqMsg()
{
    Action_acResetTripCountReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetMapLayerVisibility(bool aIsMapLayerVisible)
{
    Action_acSetMapLayerVisibility(bool(aIsMapLayerVisible));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acFreezeMapAction()
{
    Action_acFreezeMapAction();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUnfreezeMapAction()
{
    Action_acUnfreezeMapAction();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acFreezeAndHideMapAction()
{
    Action_acFreezeAndHideMapAction();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetBackButtonLevel(::FeatStd::UInt8 aBackButtonLevel)
{
    Action_acSetBackButtonLevel(Courier::UInt8(aBackButtonLevel));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acToggleSouthNorth()
{
    Action_acToggleSouthNorth();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acToggleEastWest()
{
    Action_acToggleEastWest();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acInitializeLatLongSpellerEntry()
{
    Action_acInitializeLatLongSpellerEntry();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeCoordinateFormat()
{
    Action_acChangeCoordinateFormat();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLatLongInputValues()
{
    Action_acSetLatLongInputValues();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLatDegreesActive()
{
    Action_acSetLatDegreesActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLatMinutesActive()
{
    Action_acSetLatMinutesActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLatSecondsActive()
{
    Action_acSetLatSecondsActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLatDecimalsActive()
{
    Action_acSetLatDecimalsActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLongDegreesActive()
{
    Action_acSetLongDegreesActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLongMinutesActive()
{
    Action_acSetLongMinutesActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLongSecondsActive()
{
    Action_acSetLongSecondsActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetLongDecimalsActive()
{
    Action_acSetLongDecimalsActive();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetLatLongPopUpStatus()
{
    Action_acResetLatLongPopUpStatus();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acNavigationPopUpVisible(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acNavigationPopUpVisible(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStopTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acEnableWhereAmI()
{
    Action_acEnableWhereAmI();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDisableWhereAmI()
{
    Action_acDisableWhereAmI();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetMapCameraModeAction(::FeatStd::UInt32 aMapCameraMode)
{
    Action_acSetMapCameraModeAction(enMapCameraAndViewModeMode(aMapCameraMode));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStartPicking(::FeatStd::UInt32 aMapPickingType)
{
    Action_acStartPicking(enMapPickingType(aMapPickingType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acTriggerMapPicking()
{
    Action_acTriggerMapPicking();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetPickingTimer(bool aActivateTimer, ::FeatStd::UInt32 aTimerDuration)
{
    Action_acSetPickingTimer(bool(aActivateTimer), Courier::UInt32(aTimerDuration));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStoreLocationOnByMapOkPress()
{
    Action_acStoreLocationOnByMapOkPress();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acMapScreen()
{
    Action_acMapScreen();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCompassOrientation(bool aIsSecondaryViewActive)
{
    Action_acCompassOrientation(bool(aIsSecondaryViewActive));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acReleasePickInMap()
{
    Action_acReleasePickInMap();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acRecenterMap()
{
    Action_acRecenterMap();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetDetailedAddress()
{
    Action_acResetDetailedAddress();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeRouteTypeItem(::FeatStd::UInt32 aRouteOptions)
{
    Action_acChangeRouteTypeItem(enRouteTypeOptions(aRouteOptions));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeCustomRouteItem(::FeatStd::UInt32 aCustomRouteTypeOption)
{
    Action_acChangeCustomRouteItem(enCustomizeRouteOptions(aCustomRouteTypeOption));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeEstimatedTimeItem(::FeatStd::UInt32 aEstimatedTimeOption)
{
    Action_acChangeEstimatedTimeItem(enEstimatedTimeOptions(aEstimatedTimeOption));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeTimeOnMapItem(::FeatStd::UInt32 aTimeOnMapOption)
{
    Action_acChangeTimeOnMapItem(enTimeOnMapOptions(aTimeOnMapOption));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeUseTrafficInfoItem(::FeatStd::UInt32 aUseTrafficInfoOption)
{
    Action_acChangeUseTrafficInfoItem(enRoadInformationOptions(aUseTrafficInfoOption));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeUseTollRoadItem(::FeatStd::UInt32 aUseTollRoadOption)
{
    Action_acChangeUseTollRoadItem(enRoadInformationOptions(aUseTollRoadOption));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acFetchPremiumTrafficSettings()
{
    Action_acFetchPremiumTrafficSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyPremiumTrafficSettings()
{
    Action_acApplyPremiumTrafficSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyRoutePreferenceOptions()
{
    Action_acApplyRoutePreferenceOptions();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyDetailedRoutepreferencesOptions()
{
    Action_acApplyDetailedRoutepreferencesOptions();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyGuidanceSettings()
{
    Action_acApplyGuidanceSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyTrafficIconsSettings()
{
    Action_acApplyTrafficIconsSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCheckIsSatelliteSourceChanged()
{
    Action_acCheckIsSatelliteSourceChanged();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCheckIsVehicleSettingsChanged()
{
    Action_acCheckIsVehicleSettingsChanged();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acChangeActiveProfile()
{
    Action_acChangeActiveProfile();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSaveVehicleProfileSettings()
{
    Action_acSaveVehicleProfileSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetVehicleProfileSettings()
{
    Action_acResetVehicleProfileSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetVehicleProfileInfo()
{
    Action_acResetVehicleProfileInfo();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateStartupVehicleProfileInfo()
{
    Action_acUpdateStartupVehicleProfileInfo();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateVehicleProfilePopupStatus(bool aIsGuidanceRetriggered)
{
    Action_acUpdateVehicleProfilePopupStatus(bool(aIsGuidanceRetriggered));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetAllNaviSettings()
{
    Action_acResetAllNaviSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplySettings()
{
    Action_acApplySettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acHardRestrictionConfirmMultiple()
{
    Action_acHardRestrictionConfirmMultiple();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSoftRestrictionMsg(bool aIsRestrictionAccepted)
{
    Action_acSoftRestrictionMsg(bool(aIsRestrictionAccepted));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acAcceptCarModeWarning()
{
    Action_acAcceptCarModeWarning();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDeclineCarModeWarning()
{
    Action_acDeclineCarModeWarning();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDeletePreviousDestination(::FeatStd::UInt8 aPopupID)
{
    Action_acDeletePreviousDestination(Courier::UInt8(aPopupID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPOICategoryBrowseBack()
{
    Action_acPOICategoryBrowseBack();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUPOIBrowseBack()
{
    Action_acUPOIBrowseBack();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPOIStartFts()
{
    Action_acPOIStartFts();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPOILeaveFts()
{
    Action_acPOILeaveFts();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetCoordinates()
{
    Action_acResetCoordinates();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUPOIResetCoordinates()
{
    Action_acUPOIResetCoordinates();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUPOIStartInput(bool aIsFreeTextSearch)
{
    Action_acUPOIStartInput(bool(aIsFreeTextSearch));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUPOILeaveInput()
{
    Action_acUPOILeaveInput();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPOILeaveInput()
{
    Action_acPOILeaveInput();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acApplyMapViewSettings()
{
    Action_acApplyMapViewSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acMapZoomIn(bool aIsSecondaryViewActive, bool aZoomBtnType)
{
    Action_acMapZoomIn(bool(aIsSecondaryViewActive), bool(aZoomBtnType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acMapZoomOut(bool aIsSecondaryViewActive, bool aZoomBtnType)
{
    Action_acMapZoomOut(bool(aIsSecondaryViewActive), bool(aZoomBtnType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDeleteTrackingPoint()
{
    Action_acDeleteTrackingPoint();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acActivateMapSettingOthersList(::FeatStd::UInt32 aMapSettingsOthersListID)
{
    Action_acActivateMapSettingOthersList(Candera::UInt32(aMapSettingsOthersListID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acActivateStreamMapSettingSubOptionList(::FeatStd::UInt32 aSubOptionsListID)
{
    Action_acActivateStreamMapSettingSubOptionList(Candera::UInt32(aSubOptionsListID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetMaxFavPopupVisibilityStatus(bool aIsPopupEnabled)
{
    Action_acSetMaxFavPopupVisibilityStatus(bool(aIsPopupEnabled));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetWaypointoption(bool aWaypointoptionactivated)
{
    Action_acSetWaypointoption(bool(aWaypointoptionactivated));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStartRouteGuidance()
{
    Action_acStartRouteGuidance();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCancelActiveRouteGuidance()
{
    Action_acCancelActiveRouteGuidance();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acToggleRouteOverviewBtn(bool aIsRouteOverViewActive)
{
    Action_acToggleRouteOverviewBtn(bool(aIsRouteOverViewActive));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetPreviosulyActiveSceneName(::FeatStd::UInt32 aSceneName)
{
    Action_acSetPreviosulyActiveSceneName(Candera::UInt32(aSceneName));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acShowRouteListView(bool aIsRouteListShown)
{
    Action_acShowRouteListView(bool(aIsRouteListShown));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acShowPoisOnMapView(bool aIsListShown)
{
    Action_acShowPoisOnMapView(bool(aIsListShown));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acShowWaypointListView(bool aIsListShown)
{
    Action_acShowWaypointListView(bool(aIsListShown));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acHighlightActiveRoute(::FeatStd::UInt8 aRouteCriterion)
{
    Action_acHighlightActiveRoute(enRouteTypeOptions(aRouteCriterion));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acRouteStartGuidance()
{
    Action_acRouteStartGuidance();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acMapTimerExpired()
{
    Action_acMapTimerExpired();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acLeftMapViewSetMapScaleSettings()
{
    Action_acLeftMapViewSetMapScaleSettings();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acAvoidTollRoad()
{
    Action_acAvoidTollRoad();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCancelMultipleRouteIfAvailable()
{
    Action_acCancelMultipleRouteIfAvailable();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acNAVDATAUPDATE_Nav_FullMapUpdateYes(bool aIsMapUpdateTriggered)
{
    Action_acNAVDATAUPDATE_Nav_FullMapUpdateYes(bool(aIsMapUpdateTriggered));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acNAVDATAUPDATE_Nav_FullMapUpdateNo()
{
    Action_acNAVDATAUPDATE_Nav_FullMapUpdateNo();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk()
{
    Action_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateNAVDATAUPDATE_PopupText(::FeatStd::UInt32 aPopupID)
{
    Action_acUpdateNAVDATAUPDATE_PopupText(Candera::UInt32(aPopupID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCheckIsNaviUpdateAvailable()
{
    Action_acCheckIsNaviUpdateAvailable();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSwitchContextFromNavDataUpdate()
{
    Action_acSwitchContextFromNavDataUpdate();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acContextSwitch(::FeatStd::UInt32 aContextSwitchFromID, ::FeatStd::UInt32 aContextSwitchToID)
{
    Action_acContextSwitch(enContextSwitchFromType(aContextSwitchFromID), enContextSwitchToType(aContextSwitchToID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSendContext(::FeatStd::UInt32 aContextFromActivityID)
{
    Action_acSendContext(enContextSwitchFromType(aContextFromActivityID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acUpdateContextonBackground(::FeatStd::UInt32 aCurrentViewID)
{
    Action_acUpdateContextonBackground(Courier::UInt32(aCurrentViewID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acCheckVehicleParameterStatus()
{
    Action_acCheckVehicleParameterStatus();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acRetriggerLastGuidedRoute()
{
    Action_acRetriggerLastGuidedRoute();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acEnterEngineeringMenu()
{
    Action_acEnterEngineeringMenu();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acDeselectEngineeringMenu()
{
    Action_acDeselectEngineeringMenu();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acExitEngineeringMenu()
{
    Action_acExitEngineeringMenu();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acResetEngineeringMenu()
{
    Action_acResetEngineeringMenu();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acReleaseXUrgentTrafficMessageReqMsg()
{
    Action_acReleaseXUrgentTrafficMessageReqMsg();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacChangeLanguageReq(::FeatStd::Int32 aLanguageId)
{
    Action_gacChangeLanguageReq(enLanguageId(aLanguageId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacHideFocusInViewReq(::FeatStd::UInt32 aView)
{
    Action_gacHideFocusInViewReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aView)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::NextLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_NextLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::PreviousLevelTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PreviousLevelTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::DualViewLeftTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewLeftTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::DualViewRightTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_DualViewRightTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::PageFlipBackTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipBackTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::PageFlipFrontTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_PageFlipFrontTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::ZoomInTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomInTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::ZoomOutTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView, ::FeatStd::Int8 aPos)
{
    Action_ZoomOutTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView), Candera::UInt8(aPos));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::FadeTransition(::FeatStd::Int8 aFirstView, ::FeatStd::Int8 aSecondView)
{
    Action_FadeTransition(Candera::UInt8(aFirstView), Candera::UInt8(aSecondView));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacWaitAnimationStartReq()
{
    Action_gacWaitAnimationStartReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acFocusOnRightEncoderReqUpd(bool aIsFocusUsed)
{
    Action_acFocusOnRightEncoderReqUpd(bool(aIsFocusUsed));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acSetGadgetSceenActiveStatus(bool aIsGadgetAtive)
{
    Action_acSetGadgetSceenActiveStatus(bool(aIsGadgetAtive));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acHKNotificationMsg(::FeatStd::Int8 aHKCode, ::FeatStd::Int8 aHKState)
{
    Action_acHKNotificationMsg(Courier::UInt8(aHKCode), Courier::UInt8(aHKState));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPerform_CloseAllDropdowns()
{
    Action_acPerform_CloseAllDropdowns();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPerform_CloseDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_CloseDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPerform_OpenDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_OpenDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPerform_ToggleDropdown(::FeatStd::UInt32 aListId)
{
    Action_acPerform_ToggleDropdown(::Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStartAppPopupTimer(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aTimeout)
{
    Action_acStartAppPopupTimer(Courier::UInt32(aViewId), Courier::UInt32(aTimeout));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acStopAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acStopAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acPostBeep(::FeatStd::Int8 aBeepType)
{
    Action_acPostBeep(Courier::Int32(aBeepType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacCheckToClosePopup(::FeatStd::UInt32 aPopupId)
{
    Action_gacCheckToClosePopup(Courier::UInt32(aPopupId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::acRestartAppPopupTimer(::FeatStd::UInt32 aViewId)
{
    Action_acRestartAppPopupTimer(Courier::UInt32(aViewId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacContextSwitchBackRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchBackRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacContextSwitchCompleteRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchCompleteRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacContextSwitchFailedRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchFailedRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacContextSwitchDoneRes(::FeatStd::UInt32 aSwitchId)
{
    Action_gacContextSwitchDoneRes(Courier::UInt32(aSwitchId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacContextSwitchOutReq(::FeatStd::UInt32 aTargetContextId, ::FeatStd::UInt32 aSourceContextId, ::FeatStd::UInt32 aTargetAppId)
{
    Action_gacContextSwitchOutReq(Courier::UInt32(aTargetContextId), Courier::UInt32(aSourceContextId), Courier::UInt32(aTargetAppId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacCurrentScreenDisplayReq()
{
    Action_gacCurrentScreenDisplayReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacLaunchBarDisplayReq(bool aVisibility)
{
    Action_gacLaunchBarDisplayReq(bool(aVisibility));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacNavTBTSwipe()
{
    Action_gacNavTBTSwipe();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPerformListBtnRightEncoderChangeUpd(::FeatStd::Int8 aSteps, ::FeatStd::UInt32 aListId, ::FeatStd::UInt32 aRowId, ::FeatStd::UInt32 aColumnId)
{
    Action_gacPerformListBtnRightEncoderChangeUpd(Courier::Int8(aSteps), Courier::UInt32(aListId), Courier::UInt32(aRowId), Courier::UInt32(aColumnId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollListUp()
{
    Action_gacScrollListUp();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollListDown()
{
    Action_gacScrollListDown();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollPageUp()
{
    Action_gacScrollPageUp();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollPageDown()
{
    Action_gacScrollPageDown();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollListFocusUp(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusUp(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacScrollListFocusDown(::FeatStd::UInt32 aListId)
{
    Action_gacScrollListFocusDown(Courier::UInt32(aListId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPerformListFocusLockDataResetUpd()
{
    Action_gacPerformListFocusLockDataResetUpd();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacSetApplicationMode(::FeatStd::UInt32 aModeId)
{
    Action_gacSetApplicationMode(Courier::UInt32(aModeId));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacSpellerBbehaviorReq(bool aEnable)
{
    Action_gacSpellerBbehaviorReq(bool(aEnable));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacStatusBarDisplayReq(bool aVisibility, ::FeatStd::Int32 aHeaderType)
{
    Action_gacStatusBarDisplayReq(bool(aVisibility), Courier::Int32(aHeaderType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacTBTRetriggerAcousticOutput()
{
    Action_gacTBTRetriggerAcousticOutput();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacWaitAnimationStopReq()
{
    Action_gacWaitAnimationStopReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewCreateReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewCreateAllReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAllReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewDestroyReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewClearReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewClearReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewHideReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewCreateWithoutLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateWithoutLoadReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewAsyncLoadReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewAsyncLoadReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewActivateWithoutRenderingReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewActivateWithoutRenderingReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupCreateAndSBShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupCreateAndSBShowReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupCreateAndSBShowReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupSBCloseReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupSBCloseReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupSBCloseReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupRestartTimerReq(::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupRestartTimerReqForMultiDisplay(::FeatStd::UInt32 aPopupDisplayID, ::FeatStd::UInt32 aViewId)
{
    Action_gacPopupRestartTimerReqForMultiDisplay(Courier::UInt32(aPopupDisplayID), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewCreateAndShowReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewCreateAndShowReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacViewHideAndDestroyReq(::FeatStd::UInt32 aViewId)
{
    Action_gacViewHideAndDestroyReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacSceneTransitionEnter(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionEnter(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacSceneTransitionLeave(::FeatStd::UInt32 aViewId, ::FeatStd::UInt32 aHint)
{
    Action_gacSceneTransitionLeave(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)), Courier::UInt32(aHint));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDisplayStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacDisplayStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacHideStatusLineReq(::FeatStd::Int32 aDisplayRegionType)
{
    Action_gacHideStatusLineReq(Courier::Int32(aDisplayRegionType));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDisplayFooterLineReq()
{
    Action_gacDisplayFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacHideFooterLineReq()
{
    Action_gacHideFooterLineReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDisplayStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacHideStatusLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideStatusLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDisplayFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacDisplayFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacHideFooterLineMultiDisplayReq(::FeatStd::Int32 aDisplayRegionType, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacHideFooterLineMultiDisplayReq(Courier::Int32(aDisplayRegionType), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacRegisterForCloseOnTouchSession(::FeatStd::UInt32 aViewId)
{
    Action_gacRegisterForCloseOnTouchSession(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDeregisterForCloseOnTouchSessionReq(::FeatStd::UInt32 aViewId)
{
    Action_gacDeregisterForCloseOnTouchSessionReq(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aViewId)));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterPrioEnableReq(::FeatStd::UInt32 aPrio)
{
    Action_gacPopupFilterPrioEnableReq(Courier::UInt32(aPrio));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterAllEnableReq()
{
    Action_gacPopupFilterAllEnableReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterDisableReq()
{
    Action_gacPopupFilterDisableReq();
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacProfileChange(::FeatStd::Int8 aProfile)
{
    Action_gacProfileChange(Courier::UInt32(aProfile));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterPrioEnableReqForDisplay(::FeatStd::UInt32 aPrio, ::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterPrioEnableReqForDisplay(Courier::UInt32(aPrio), Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterAllEnableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterAllEnableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacPopupFilterDisableReqForDisplay(::FeatStd::UInt32 aDisplayID)
{
    Action_gacPopupFilterDisableReqForDisplay(Courier::UInt32(aDisplayID));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacStartSceneTransitionAnimation(::FeatStd::UInt32 aSourceView, ::FeatStd::UInt32 aDestinationView, ::FeatStd::UInt32 aUserData1, ::FeatStd::Int8 aUserData2)
{
    Action_gacStartSceneTransitionAnimation(::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aSourceView)), ::Courier::ViewId(AppHmi_NavigationStateMachineImpl::GetNameFromId(aDestinationView)), Courier::UInt32(aUserData1), Courier::Int8(aUserData2));
}

// ------------------------------------------------------------------------
void AppHmi_NavigationStateMachineImpl::gacDecrementActiveAnimationCount()
{
    Action_gacDecrementActiveAnimationCount();
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
static inline ::FeatStd::UInt16 Action_fnGetVariantType()
{
    return fnGetVariantType();
}

::FeatStd::UInt16 AppHmi_NavigationStateMachineImpl::fnGetVariantType()
{
    return Action_fnGetVariantType();
}

// ------------------------------------------------------------------------

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgPOITopCategoryStatus()
{
    return Action_dgPOITopCategoryStatus();
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgPOIResultListStatus()
{
    return Action_dgPOIResultListStatus();
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgLatLongPopUpActive()
{
    return Action_dgLatLongPopUpActive();
}

// ------------------------------------------------------------------------
::FeatStd::UInt8 AppHmi_NavigationStateMachineImpl::dgMainMapScreenStateValue()
{
    return Action_dgMainMapScreenStateValue();
}

// ------------------------------------------------------------------------
::FeatStd::UInt8 AppHmi_NavigationStateMachineImpl::dgRouteOverViewBtnEnabled()
{
    return Action_dgRouteOverViewBtnEnabled();
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgEngineeringMenuListStatus()
{
    return Action_dgEngineeringMenuListStatus();
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgEngineeringMenuTopListStatus()
{
    return Action_dgEngineeringMenuTopListStatus();
}

// ------------------------------------------------------------------------
bool AppHmi_NavigationStateMachineImpl::dgNaviMiddlewareStatus()
{
    return Action_dgNaviMiddlewareStatus();
}
#ifdef CIT_SIMULATION
struct ActionMapping
{
    ::FeatStd::UInt32 mHashId;
    bool (*mActionCallHandler)(const ::Json::Value& parameters, ::Json::Value &response);
};

static ::FeatStd::Int ActionMappingCmp(::FeatStd::UInt32 hash, const ActionMapping& am)
{
    return (hash == am.mHashId) ? 0 : ((hash < am.mHashId) ? -1 : 1);
}

bool AppHmi_NavigationStateMachineImpl::CallAction(const ::FeatStd::Char* actionName, const ::Json::Value& parameters, ::Json::Value &response)
{
    static ActionMapping actions[226] = {
        { 0x001CA3EC, CallAction_acRecenterMap },
        { 0x01E96BAF, CallAction_acResetCoordinates },
        { 0x031D4853, CallAction_acSetWaypointoption },
        { 0x053C016B, CallAction_acTriggerMapPicking },
        { 0x0884F877, CallAction_gacScrollListUp },
        { 0x090A895B, CallAction_gacScrollListFocusDown },
        { 0x098788FB, CallAction_dgEngineeringMenuTopListStatus },
        { 0x09B00E5F, CallAction_acPOILeaveInput },
        { 0x0A4C5DC9, CallAction_gacDisplayStatusLineMultiDisplayReq },
        { 0x0C279721, CallAction_gacDecrementActiveAnimationCount },
        { 0x0DF41D26, CallAction_acResetVehicleProfileInfo },
        { 0x11915CFE, CallAction_acStopAppPopupTimer },
        { 0x11A5A301, CallAction_acEnableGuidanceButton_NewAddress },
        { 0x132800BA, CallAction_acInitPOICategoryBrowse },
        { 0x14D553E1, CallAction_acShowWaypointListView },
        { 0x15061065, CallAction_gacViewShowReq },
        { 0x154A8A16, CallAction_acResetDetailedAddress },
        { 0x155F2AE3, CallAction_acStartRouteGuidance },
        { 0x163A145D, CallAction_acSetMaxFavPopupVisibilityStatus },
        { 0x169F0373, CallAction_acSetLatSecondsActive },
        { 0x1763130C, CallAction_dgLatLongPopUpActive },
        { 0x1782170A, CallAction_acWaypointDelete },
        { 0x186A69F1, CallAction_gacWaitAnimationStopReq },
        { 0x187DA604, CallAction_acPerform_OpenDropdown },
        { 0x19F8C809, CallAction_acSetPOISearchLocation },
        { 0x1BC6E0A9, CallAction_ZoomInTransition },
        { 0x1BCC88DE, CallAction_acChangeRouteTypeItem },
        { 0x1E101A4E, CallAction_acContextSwitch },
        { 0x1FC8E7B5, CallAction_acSetLongDecimalsActive },
        { 0x2089FBF3, CallAction_acValidateNaviEntryCondition },
        { 0x21E3828E, CallAction_gacDisplayStatusLineReq },
        { 0x22D27496, CallAction_acSetLatDecimalsActive },
        { 0x251DE22F, CallAction_gacContextSwitchCompleteRes },
        { 0x254E0D94, CallAction_gacViewHideReq },
        { 0x258104C2, CallAction_DualViewLeftTransition },
        { 0x264B8E81, CallAction_gacPopupRestartTimerReqForMultiDisplay },
        { 0x266B76B9, CallAction_acResetAllNaviSettings },
        { 0x27CE647F, CallAction_gacScrollListFocusUp },
        { 0x2937F10B, CallAction_acSetBackButtonLevel },
        { 0x29CB291E, CallAction_acDeclineCarModeWarning },
        { 0x29D14586, CallAction_gacDisplayFooterLineMultiDisplayReq },
        { 0x2A1E6CB2, CallAction_gacDeregisterForCloseOnTouchSessionReq },
        { 0x2A9935F8, CallAction_acChangeEstimatedTimeItem },
        { 0x2AE0BBE0, CallAction_acInitDestinationInput },
        { 0x2AE288D8, CallAction_gacViewDestroyReq },
        { 0x2B15FA6E, CallAction_acShowPopupText },
        { 0x2E99B322, CallAction_acRouteStartGuidance },
        { 0x2EDA53CE, CallAction_acUpdateNAVDATAUPDATE_PopupText },
        { 0x30C8D840, CallAction_gacStartSceneTransitionAnimation },
        { 0x325BE13A, CallAction_gacViewCreateReq },
        { 0x334571BF, CallAction_acHKNotificationMsg },
        { 0x33AB6817, CallAction_acFreezeMapAction },
        { 0x34129935, CallAction_acStartTrafficDetourTimer },
        { 0x35311A65, CallAction_acSetMapLayerVisibility },
        { 0x3884B2C7, CallAction_acExitEngineeringMenu },
        { 0x3892C8A6, CallAction_acCheckIsSatelliteSourceChanged },
        { 0x3BB18A69, CallAction_gacPopupFilterAllEnableReq },
        { 0x3E2891E0, CallAction_acNavigationPopUpVisible },
        { 0x3E45E1CD, CallAction_acActivateMapSettingOthersList },
        { 0x3E4CE5A1, CallAction_gacContextSwitchDoneRes },
        { 0x3E7F9726, CallAction_gacSceneTransitionEnter },
        { 0x3ED1ED3F, CallAction_acSetLatMinutesActive },
        { 0x41201119, CallAction_acStartAppPopupTimer },
        { 0x4160C705, CallAction_acCancelActiveRouteGuidance },
        { 0x42864351, CallAction_acFetchPremiumTrafficSettings },
        { 0x438154B8, CallAction_acSetLatLongInputValues },
        { 0x45271CF6, CallAction_acAcceptTrafficAlternativeReqMsg },
        { 0x48842A20, CallAction_acSetMapCameraModeAction },
        { 0x4A4269F1, CallAction_dgMainMapScreenStateValue },
        { 0x5047D766, CallAction_acSendContext },
        { 0x54142D63, CallAction_dgEngineeringMenuListStatus },
        { 0x5443F7FD, CallAction_acDeselectEngineeringMenu },
        { 0x568D5581, CallAction_acUpdateContextonBackground },
        { 0x56E855A9, CallAction_acSetLongMinutesActive },
        { 0x573EB339, CallAction_gacContextSwitchFailedRes },
        { 0x57A1E70E, CallAction_dgNaviMiddlewareStatus },
        { 0x57AA275B, CallAction_gacViewCreateWithoutLoadReq },
        { 0x59148CB0, CallAction_FadeTransition },
        { 0x59672DB5, CallAction_acUnfreezeMapAction },
        { 0x59C82D8E, CallAction_NextLevelTransition },
        { 0x59F03621, CallAction_gacChangeLanguageReq },
        { 0x5D92F3C8, CallAction_acUPOIResetCoordinates },
        { 0x5E7F5ABB, CallAction_acShowAllPOICategory },
        { 0x5FD251FF, CallAction_acResetVehicleProfileSettings },
        { 0x5FE3FC87, CallAction_fnGetVariantType },
        { 0x60E513C0, CallAction_gacTBTRetriggerAcousticOutput },
        { 0x6137F765, CallAction_dgPOIResultListStatus },
        { 0x629132A7, CallAction_gacPopupFilterDisableReq },
        { 0x646860E1, CallAction_acUpdateStartupVehicleProfileInfo },
        { 0x66E133E0, CallAction_acUPOILeaveInput },
        { 0x67AA3FF0, CallAction_acAcceptCarModeWarning },
        { 0x67B7653B, CallAction_gacDisplayFooterLineReq },
        { 0x68419819, CallAction_acRetriggerLastGuidedRoute },
        { 0x6A734282, CallAction_acUPOIBrowseBack },
        { 0x6BE4CC8D, CallAction_acReplaceHomeFav },
        { 0x6C269CB9, CallAction_acStartPicking },
        { 0x6C3B5129, CallAction_acEnableWhereAmI },
        { 0x71146D81, CallAction_acLeftMapViewSetMapScaleSettings },
        { 0x7345D8A6, CallAction_acSetPreviosulyActiveSceneName },
        { 0x7531D066, CallAction_Notify_Init_Finished },
        { 0x75E49D1D, CallAction_gacPerformListFocusLockDataResetUpd },
        { 0x7661103A, CallAction_acNAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOk },
        { 0x76EE4CA4, CallAction_gacHideStatusLineMultiDisplayReq },
        { 0x785762A7, CallAction_acEnterEngineeringMenu },
        { 0x78CD5DA8, CallAction_acApplyGuidanceSettings },
        { 0x78E169A3, CallAction_acImportUPOIsReqMsg },
        { 0x791DF896, CallAction_acPerform_CloseAllDropdowns },
        { 0x7A8F3638, CallAction_acSwitchContextFromTrafficDetour },
        { 0x7D04FF33, CallAction_acChangeTimeOnMapItem },
        { 0x7D7B49B4, CallAction_acFocusOnRightEncoderReqUpd },
        { 0x7EE4AB88, CallAction_gacPopupRestartTimerReq },
        { 0x7FE3D609, CallAction_acApplyRoutePreferenceOptions },
        { 0x8029658E, CallAction_acActivateStreamMapSettingSubOptionList },
        { 0x804816C1, CallAction_acCheckIsNaviUpdateAvailable },
        { 0x80D6ACAB, CallAction_acSwitchContextFromNavDataUpdate },
        { 0x81478246, CallAction_acResetTripCountReqMsg },
        { 0x828C26A7, CallAction_acFavDelete },
        { 0x82D15005, CallAction_PageFlipBackTransition },
        { 0x85D3C5C1, CallAction_acSoftRestrictionMsg },
        { 0x881D2454, CallAction_gacPopupFilterAllEnableReqForDisplay },
        { 0x89164645, CallAction_acApplyDetailedRoutepreferencesOptions },
        { 0x8A967DA7, CallAction_acApplyMapViewSettings },
        { 0x8CFDE4F9, CallAction_acSetLatDegreesActive },
        { 0x8DE6ADD2, CallAction_acPOILeaveFts },
        { 0x8F0EFC9F, CallAction_acToggleSouthNorth },
        { 0x8F3957C3, CallAction_acHighlightActiveRoute },
        { 0x8FA2CBDC, CallAction_acChangeUseTrafficInfoItem },
        { 0x9071D1AC, CallAction_acAvoidTollRoad },
        { 0x91A77F0D, CallAction_acSetLongSecondsActive },
        { 0x91BB105A, CallAction_gacLaunchBarDisplayReq },
        { 0x91D62495, CallAction_acCancelMultipleRouteIfAvailable },
        { 0x92CF8A50, CallAction_acRejectTrafficAlternativeReqMsg },
        { 0x93218F8C, CallAction_gacContextSwitchOutReq },
        { 0x933F77E6, CallAction_acMapZoomOut },
        { 0x940100DB, CallAction_acUpdateDeletePopupText },
        { 0x948F96CC, CallAction_gacScrollListDown },
        { 0x951D7C13, CallAction_acSetPickingTimer },
        { 0x96350312, CallAction_acSetGadgetSceenActiveStatus },
        { 0x96D2670D, CallAction_acResetEngineeringMenu },
        { 0x96D3C730, CallAction_gacPopupSBCloseReqForMultiDisplay },
        { 0x982729D2, CallAction_acReleaseXUrgentTrafficMessageReqMsg },
        { 0x99258E0B, CallAction_gacStatusBarDisplayReq },
        { 0x9A2C95FF, CallAction_acToggleRouteOverviewBtn },
        { 0x9A6A7A4D, CallAction_acApplySettings },
        { 0x9F7B54D6, CallAction_acShowRouteListView },
        { 0x9F87F08B, CallAction_acPostBeep },
        { 0x9FA26D73, CallAction_gacPopupFilterDisableReqForDisplay },
        { 0xA01C693A, CallAction_acSkipWaypointReqMsg },
        { 0xA03B174E, CallAction_acDeleteAllUPOIsReqMsg },
        { 0xA0A6F9FA, CallAction_gacViewHideAndDestroyReq },
        { 0xA0D60DE9, CallAction_acInitializeLatLongSpellerEntry },
        { 0xA11786C1, CallAction_acSetPickInMapLocation },
        { 0xA7B62A65, CallAction_gacPopupFilterPrioEnableReqForDisplay },
        { 0xA84DC23C, CallAction_gacHideFocusInViewReq },
        { 0xA8B416AB, CallAction_acDeleteTrackingPoint },
        { 0xA9C7F42F, CallAction_gacHideStatusLineReq },
        { 0xAB49461E, CallAction_gacViewCreateAndShowReq },
        { 0xAD947FF9, CallAction_gacCurrentScreenDisplayReq },
        { 0xAE48BF55, CallAction_DualViewRightTransition },
        { 0xAFB14254, CallAction_gacWaitAnimationStartReq },
        { 0xB17A2827, CallAction_acPOICategoryBrowseBack },
        { 0xB2C03450, CallAction_acApplyTrafficIconsSettings },
        { 0xB967AF07, CallAction_acUpdateSpeedLockPopupText },
        { 0xBA193CB2, CallAction_acMapZoomIn },
        { 0xBAC66E44, CallAction_acDeletePreviousDestination },
        { 0xBB441DAC, CallAction_gacRegisterForCloseOnTouchSession },
        { 0xBCDA91D2, CallAction_acStoreLocationOnByMapOkPress },
        { 0xBDECE418, CallAction_gacSetApplicationMode },
        { 0xBEF6021E, CallAction_acPerform_ToggleDropdown },
        { 0xC33F96D5, CallAction_acHardRestrictionConfirmMultiple },
        { 0xC37EE8E9, CallAction_gacPopupFilterPrioEnableReq },
        { 0xC4B99E59, CallAction_acSavePickInMapCoordinates },
        { 0xC51CE603, CallAction_gacViewCreateAllReq },
        { 0xC5DD5738, CallAction_gacProfileChange },
        { 0xC65CAED0, CallAction_gacSpellerBbehaviorReq },
        { 0xC66F9732, CallAction_acReleasePickInMap },
        { 0xC7A49403, CallAction_acSaveVehicleProfileSettings },
        { 0xC8539D8B, CallAction_gacSceneTransitionLeave },
        { 0xC87D2AB1, CallAction_acToggleEastWest },
        { 0xC8EA8B79, CallAction_acRestartAppPopupTimer },
        { 0xC9EB88D6, CallAction_gacViewClearReq },
        { 0xCB8DBDEF, CallAction_gacHideFooterLineReq },
        { 0xCCA4E3DC, CallAction_acUPOIStartInput },
        { 0xCCD0DDCF, CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateYes },
        { 0xCCF1A98B, CallAction_PreviousLevelTransition },
        { 0xCD183BE9, CallAction_acUpdateVehicleProfilePopupStatus },
        { 0xCD37C225, CallAction_acApplyPremiumTrafficSettings },
        { 0xCE86D007, CallAction_acFreezeAndHideMapAction },
        { 0xD1421323, CallAction_dgRouteOverViewBtnEnabled },
        { 0xD1648381, CallAction_acLeaveFormBasedAddressInput },
        { 0xD1AA4F4D, CallAction_ZoomOutTransition },
        { 0xD1ADBF7A, CallAction_acChangeActiveProfile },
        { 0xD2A10A69, CallAction_acMapScreen },
        { 0xD2AB9FDA, CallAction_acResetLatLongPopUpStatus },
        { 0xD3E0430C, CallAction_acSetLongDegreesActive },
        { 0xD5F685D5, CallAction_PageFlipFrontTransition },
        { 0xD63C2357, CallAction_gacViewAsyncLoadReq },
        { 0xD82082C8, CallAction_acInavlidateSpellerEntry },
        { 0xD98C6419, CallAction_gacViewActivateWithoutRenderingReq },
        { 0xD9A5B199, CallAction_acChangeUseTollRoadItem },
        { 0xDB665FD5, CallAction_acPerform_CloseDropdown },
        { 0xDBA2BC23, CallAction_dgPOITopCategoryStatus },
        { 0xDC70C014, CallAction_acNAVDATAUPDATE_Nav_FullMapUpdateNo },
        { 0xDCD03083, CallAction_acCheckIsVehicleSettingsChanged },
        { 0xDD4D179D, CallAction_gacHideFooterLineMultiDisplayReq },
        { 0xDD71F921, CallAction_gacPerformListBtnRightEncoderChangeUpd },
        { 0xE0EF3086, CallAction_gacPopupCreateAndSBShowReqForMultiDisplay },
        { 0xE25C746F, CallAction_acChangeCustomRouteItem },
        { 0xE500B03C, CallAction_gacContextSwitchBackRes },
        { 0xE61B2989, CallAction_acCheckVehicleParameterStatus },
        { 0xEAA80A11, CallAction_acDisableWhereAmI },
        { 0xEB51CB7E, CallAction_gacPopupSBCloseReq },
        { 0xEB5B7654, CallAction_acSaveFavoriteWithDisplayedName },
        { 0xEC3A2599, CallAction_ac_N_SpellerEdit_Ok_touch },
        { 0xEC64DB0F, CallAction_gacScrollPageDown },
        { 0xEE11F57F, CallAction_gacScrollPageUp },
        { 0xEE131A83, CallAction_gacNavTBTSwipe },
        { 0xEF205B84, CallAction_acShowPoisOnMapView },
        { 0xEF973E14, CallAction_acCompassOrientation },
        { 0xF0A1D4B5, CallAction_gacCheckToClosePopup },
        { 0xF17E085D, CallAction_gacPopupCreateAndSBShowReq },
        { 0xF1ADE39A, CallAction_acStopTimer },
        { 0xF345DB73, CallAction_acUpdateResetOrDestinationPopupTextReqMsg },
        { 0xF3906E56, CallAction_acPOIStartFts },
        { 0xF4CC262A, CallAction_acChangeCoordinateFormat },
        { 0xFF1BF7D1, CallAction_acMapTimerExpired },
    };
    ::FeatStd::UInt32 hashId = ::Courier::Identifier::CalcHash(actionName);
    const ActionMapping* action = ::Courier::BinarySearch(hashId, actions, 226, &ActionMappingCmp);
    if (action && (hashId == action->mHashId)) {
        return action->mActionCallHandler(parameters, response);
    }
    return false;
}
#endif
namespace Courier {
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewRenderingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMessagingResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupActivationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::DelayedUnloadMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TryAsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AsyncLoadIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CameraGroupLoadResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ThemeResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::AnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetPropertyResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetFocusResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::InvalidateReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::RenderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LayerResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewActivateEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewRenderingEnabledEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewInitContentEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ParentViewLoadEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::FocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::LostFocusEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionStartedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::TransitionFinishedEvent, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::SetCultureResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::CultureChangeIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewPlaceholderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::ViewMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::WidgetMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataBindingMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::BindingSourceBaseMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ReleaseDataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::DataItemMsgBase, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Courier::Internal::ListEventMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchAbort, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStartEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::input::TouchSessionStopEvent, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::IdUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ConsumerMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ProviderUpdateIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchForwardReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::TouchAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ActivateImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::ExternalImageProviderGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmAllocationStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGarbageCollectorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DrmGCTimeoutMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::DirectTextureConsumerContentIndicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::PositionInfoResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::gadget::SlaveSurfaceRepositionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetCheckReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NotifierMessage, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerExpiredMsg, 15);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuiStartupFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateNewDestroyOld, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterKeyStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusControlReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusGroupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshFocusSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusSessionFinishedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterFocusableWidgetsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::JoystickStatusChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SurfaceStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LayerStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SBPopupTimerExpiryUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HMISubStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::QueryTraceInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FollowUpActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WidgetPropertySetterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SimTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CloseOnTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RegisterForCloseOnTouchSessionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetClosePopupExternalTouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ClosePopupOnExternalTouchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeHmiSubStateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EvalSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExecuteSubSurfaceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExtendedViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalizationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DecrementActiveAnimationCountMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationAsMandatoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationRenderedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplicationSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSurfaceSwitchCompleteUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbAnimationStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SbCurrentStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupDisplayStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowHMISubSurfaceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartLayerAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterPrioEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterAllEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupFilterDisableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MultiDisplayPopupFilterReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartMenuTimeoutTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RenderingCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CreateTextMetaDataCollectionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DumpScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TraverseViewsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckSourceResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCheckDestinationResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropCompleteResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropAbortReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DragDropStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ProfileSwitchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TransitionMediatorOnDataCompleteMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ManualSceneActionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EglWaitNativeResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetGadgetCacheReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AttachedAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::SenderMessage, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::TouchUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AnimationWidgetIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonListItemUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonReactionMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonSlideMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ButtonGroupReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ColorBarDataUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::combobox::ComboBoxReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DropdownChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::editfield::EditFieldHightlightReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::GestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::TapGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::DragGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::SwipeGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::PinchSpreadGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gesture::RotateGestureMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::gizmo::GizmoUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDateProviderResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListDataProviderUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangeMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListAnimatedChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMovementFinishedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisibiltyUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusChangeReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SliderCurrentValueChangedMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LockOutMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemExpandEndUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationResMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCustomAnimationIndMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListMorphReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListContentUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListVisualContentUpdateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListCacheReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::hmibase::widget::pageedit::PageEditUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelSlideReqMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PanelStateMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerCtrlKeyPressed, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerStatusChangedUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SubSpellerStatusUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimerWidgetExpiryMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_CandidateUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HWR_TextWidgetUpdate, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ScrollableTextUpdMsg, 10);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActiveSurfaceViewUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeLanguageReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RestartPopupTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredPopupTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchApplicationStateReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableCameraRenderingReq, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DummyMess, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivityMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateApplicationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardKeyPressNotificationMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FocusOnRightEncoderReqUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreActiveGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckToClosePopupMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchInResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CurrentScreenDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LaunchBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavTBTSwipeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListItemRightEncoderChangeUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusLockDataResetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ListFocusScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetApplicationModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerBbehaviorReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StatusBarDisplayReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TBTRetriggerAcousticMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartGadgetAnimationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ControlPanelButtonPressInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationCarModeInfo, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeactivateLimitedModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetBackButtonLevelReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExpiredTimerResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NewAddressInputBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LastDestinationsBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StopGuidanceMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HKStatusChangedMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HKStateUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DestoinationInfoBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POIListBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIListBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POIIconSelectionOnMapMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SaveWithDisplayedNameBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SaveAsHomeBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FavHomeBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FavoriteListBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowReplaceFavPopup, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POIAddressInputBtnSelectionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddressInputMatchSelectionDoneMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowFavAddFavView_ReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableSpellerMatchListMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpellerOKBtnPressedMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::InitDestinationInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LeaveFormBasedAddressInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetPOISearchLocationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetPickInMapLocationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SavePickInMapCoordinatesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AcceptTrafficAlternativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RejectTrafficAlternativeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SkipWaypointReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetSpellerEntryMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowMapActiveRGReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowNewDestOnNaviHomeTitlePress, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowMapOnNaviHomeBtnPress, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowRouteBlockListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowDetailedAddressMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetDetailedAddressMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowFavEditIcon_Enable_Delete_Guidance_Buttons, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::InitPOINearbyInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::InitPOICategoryBrowseReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POICategoryBrowseResponseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowAllPOICategoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POICategoryBrowseBackReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIBrowseBackReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POIStartFtsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POILeaveFtsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetCoordinatesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIResetCoordinatesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIStartInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOILeaveInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::POILeaveInputReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationViewMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeleteAllUPOIsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ImportUPOIsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIInvalidateUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PopupTypeUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowVehicleInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ToggleSouthNorthReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ToggleEastWestReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeCoordinateFormatReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::InitializeLatLongSpellerEntryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowCoordinatesInMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::Show_TMC_DetailedInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowWaypointDetailedInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPOIDetailsInfoForCoordinatesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetLatLongPopUpActiveStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeActiveEditFieldReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartPickingReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TriggerMapPickingReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetPickingTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnteredMapScreenReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocationSelectionDoneResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StoreLocationOnByMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CompassOrientationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PickingTimerExpiredReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReleasePickInMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateMapScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateLocationMapScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowDetailInfoOfPickedPOIReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReCenterMapScrollReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableWhereAmIReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisableWhereAmIReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GuidanceVolumeUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetGuidanceVolumeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PlayUserBeepReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SettingsContextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetVehicleProfileType, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeRouteTypeItemReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeCustomRouteItemReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeEstimatedTimeItemReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeTimeOnMapItemReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeTimeRestrictedRoadInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeSeasonRestrictedRoadInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeUseTrafficInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyRoutePreferenceOptionsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyDetailedRoutePreferenceOptionsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyGuidanceSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyTrafficIconsSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckIsSatelliteSourceChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckIsVehicleSettingsChangedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NoChangeInVehicleSettingsRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleSettingsChangedRespMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeActiveProfileReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SaveVehicleProfileSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetVehicleProfileSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetVehicleProfileInfoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateVehicleProfilePopupStatusReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateStartupVehicleProfileReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleProfileChangedResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetAllNaviSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplySettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ContextSwitchReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SendContextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckVehicleParameterStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VehicleParameterStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateVehicleSettingsChangeDuringRGReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RetriggerLastGuidedRouteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateMapSettingsListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateContextonBackgroundReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowNaviResetSettingsAppliedMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpeedLockStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplaySpeedLockPopuponSpellerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HideSpeedLockPopuponSpellerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowMapOrnewDestFromGadgetReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPosandGPSFromCabinGNSSSettingstReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ValidateNaviEntryConditionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ValidateNaviEntryConditionResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SoftRestrictionMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HardRestrictionConfirmMultipleReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AcceptCarModeWarningReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeclineCarModeWarningReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetMapLayerVisibilityReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowLocationOnMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetMapCameraModeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FreezeMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UnfreezeMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FreezeAndHideMapReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeletePreviousDestinationReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateDeletePopupTextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateSpeedLockPopupTextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateResetOrDestinationPopupTextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReplaceHomeFavReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableGuidanceButton_NewAddressReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPopupTextMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FavDeleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WaypointDeleteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FavoritesHometouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FavHomeBackCurPosMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SaveFavoriteWithDisplayedNameReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddressInputHometouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddressInputGuidancetouchMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowMaxWaypointReachedPopup, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyMapViewSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MapSettingsOthersListUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateOthersMapSettingListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ZoomInReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ZoomOutReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeleteTrackingPointReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LeftMapViewSetMapScaleReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateStreamedMapSubOptionListReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StreamedMapSubOptionsListUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnableStreamedMapTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartStopMapStreamReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartRouteGuidanceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartRouteGuidanceFromSpeechReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CancelRouteGuidanceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RouteGuidanceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowRouteCalcPopupReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::WaypointInsertReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetWayPointEnableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::GotoHomeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PickInMapOptionsUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RouteGuidancePopUpCloseReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetPreviosulyActiveSceneName, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowRouteListViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowPoisOnMapViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowWaypointListViewReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ToggleRouteOverViewBtnMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartCalculateTourReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetTripCountReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowTrafficDetailedInfoViewMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivatePOIInfoSelectedOnMapMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MaxFavPopupVisibilityReqsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalTimeChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LocalTimeOffsetInfoUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TimeFormatChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DateFormatChangeReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AudioActiveSourceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetNaviSDSHandoverScreenIDReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SetNaviSdsFTSOptionReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationInitializedReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationInitializedUpReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NavigationLifeCycleStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ShowCityInputAndGetCityAddressResponseReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateRouteCriteriaReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::VoiceTagOptionsMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AddressGadgetItemSelectedMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RefreshMapOnBackGroundReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::AvoidTollRoadReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_SpmStartMapUpdateLockResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_Nav_FullMapUpdateYesReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_Nav_FullMapUpdateNoReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_Nav_ErrorMsgDuringUpdatePressOkReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_InternalUpdateStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_Nav_GotoNavUpdateScreenResMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_SpmStartMapUpdateLockReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_SpmMapUpdateUnLockReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::onNAVDATAUPDATE_UpdateInfoStopedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_UpdateBlockedBySWUpdateUpdMsd, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CheckIsNaviUpdateAvailableReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpmSystemStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UpdateNAVDATAUPDATE_PopupTextMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MapDownloadLockStateChangedUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_DiagPerformFullUpdateViaUSBReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_DiagFullUpdateViaUSBAckUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_DiagFullUpdateViaUSBResultUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::NAVDATAUPDATE_PerformFullUpdateViaUSBReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchContextFromNavDataUpdateReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::HighlightActiveRouteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::RouteStartGuidanceReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetEngineeringMenuReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DeselectEngineeringMenuReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EnterEngineeringMenuReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ExitEngineeringMenuReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::EngineeringMenuResponseMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ActivateEngineeringMenuReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTActiveDeviceUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTConnectedDeviceUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::BTPhoneDialReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::LanguageRelevantForNavigationUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CountryCodeUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::CancelMultipleRouteReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UnitSettingsStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DimmingModeStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::OverSpeedTimerExpiredReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::DisplayLastNaviContextReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SwitchContextFromTrafficDetourReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartTrafficDetourTimerReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::TrafficDetourTimerExpiredReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ResetFactoryReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ev_N_SplitScreenMap_disabled, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ev_N_HorizonEventChanged, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ev_N_PremiumTraffic_Disclaimer_Msg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ApplyPremiumTrafficSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::FetchPremiumTrafficSettingsReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PANConnectionStatusMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ETAAvailableUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::StartStopBtTetheringReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PANConnectionTimerExpiredMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::PANPollingTimerExpiredMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::SpeedLimitStatusUpdateMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::MapOutStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ChangeUseTollRoadReqMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::UPOIDeviceStatusUpdMsg, 5);

// ------------------------------------------------------------------------
    COURIER_MESSAGE_CONFIGURATION( ::ReleaseXUrgentTrafficMessageReqMsg, 5);
} // namespace Courier

// ------------------------------------------------------------------------
SignpostTextDataBindingSource::SignpostTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SignpostTextItem)
{
}

// ------------------------------------------------------------------------
HlgImageDataDataBindingSource::HlgImageDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HlgImageDataItem)
{
}

// ------------------------------------------------------------------------
RoadIconsDataBindingSource::RoadIconsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RoadIconsItem)
{
}

// ------------------------------------------------------------------------
MapModeDataBindingSource::MapModeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapModeItem)
{
}

// ------------------------------------------------------------------------
BTTetheringStateDataBindingSource::BTTetheringStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BTTetheringStateItem)
{
}

// ------------------------------------------------------------------------
AddressInputValueDataBindingSource::AddressInputValueDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressInputValueItem)
{
}

// ------------------------------------------------------------------------
ChangeCountryButtonDataBindingSource::ChangeCountryButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ChangeCountryButtonItem)
{
}

// ------------------------------------------------------------------------
PreviousDestinationValDataBindingSource::PreviousDestinationValDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PreviousDestinationValItem)
{
}

// ------------------------------------------------------------------------
VariantButtonDataBindingSource::VariantButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VariantButtonItem)
{
}

// ------------------------------------------------------------------------
DEDisableButtonDataBindingSource::DEDisableButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::DEDisableButtonItem)
{
}

// ------------------------------------------------------------------------
AddressInputValPOIDataBindingSource::AddressInputValPOIDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressInputValPOIItem)
{
}

// ------------------------------------------------------------------------
AddressInputValDetailsDataBindingSource::AddressInputValDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressInputValDetailsItem)
{
}

// ------------------------------------------------------------------------
PlaceInfoButtonsDataBindingSource::PlaceInfoButtonsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaceInfoButtonsItem)
{
}

// ------------------------------------------------------------------------
PlaceInfoDetailsDataBindingSource::PlaceInfoDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PlaceInfoDetailsItem)
{
}

// ------------------------------------------------------------------------
TwoLinePopuptextDataBindingSource::TwoLinePopuptextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TwoLinePopuptextItem)
{
}

// ------------------------------------------------------------------------
MultiLinePopuptextDataBindingSource::MultiLinePopuptextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MultiLinePopuptextItem)
{
}

// ------------------------------------------------------------------------
ThreeLinePopuptextDataBindingSource::ThreeLinePopuptextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ThreeLinePopuptextItem)
{
}

// ------------------------------------------------------------------------
RouteInfoPopupTextDataBindingSource::RouteInfoPopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteInfoPopupTextItem)
{
}

// ------------------------------------------------------------------------
FourLinePopupTextDataBindingSource::FourLinePopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FourLinePopupTextItem)
{
}

// ------------------------------------------------------------------------
FiveLinePopupTextDataBindingSource::FiveLinePopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FiveLinePopupTextItem)
{
}

// ------------------------------------------------------------------------
SpellerPressedKeyInfoDataBindingSource::SpellerPressedKeyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpellerPressedKeyInfoItem)
{
}

// ------------------------------------------------------------------------
SpellerPagesDataBindingSource::SpellerPagesDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpellerPagesItem)
{
}

// ------------------------------------------------------------------------
SpellerTextInfoDataBindingSource::SpellerTextInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpellerTextInfoItem)
{
}

// ------------------------------------------------------------------------
NaviSpellerInfoDataBindingSource::NaviSpellerInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NaviSpellerInfoItem)
{
}

// ------------------------------------------------------------------------
AddressEntryTitleTextDataBindingSource::AddressEntryTitleTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressEntryTitleTextItem)
{
}

// ------------------------------------------------------------------------
NaviMiddlewareStatusDataBindingSource::NaviMiddlewareStatusDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NaviMiddlewareStatusItem)
{
}

// ------------------------------------------------------------------------
FreeTextListItemDataBindingSource::FreeTextListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::FreeTextListItemItem)
{
}

// ------------------------------------------------------------------------
SpellerEntryTextReceivedInfoDataBindingSource::SpellerEntryTextReceivedInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SpellerEntryTextReceivedInfoItem)
{
}

// ------------------------------------------------------------------------
AddressEntryInputMatchesDataBindingSource::AddressEntryInputMatchesDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressEntryInputMatchesItem)
{
}

// ------------------------------------------------------------------------
GuidanceBlockUnblockButtonDataBindingSource::GuidanceBlockUnblockButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GuidanceBlockUnblockButtonItem)
{
}

// ------------------------------------------------------------------------
POICategoryRootItemDataBindingSource::POICategoryRootItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POICategoryRootItemItem)
{
}

// ------------------------------------------------------------------------
ShowPOIsOnMapItemDataBindingSource::ShowPOIsOnMapItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ShowPOIsOnMapItemItem)
{
}

// ------------------------------------------------------------------------
ShowRouteListItemDataBindingSource::ShowRouteListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ShowRouteListItemItem)
{
}

// ------------------------------------------------------------------------
BlockRouteListItemDataBindingSource::BlockRouteListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::BlockRouteListItemItem)
{
}

// ------------------------------------------------------------------------
POICategoryListItemDataBindingSource::POICategoryListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POICategoryListItemItem)
{
}

// ------------------------------------------------------------------------
POIDetailedInfoDataBindingSource::POIDetailedInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POIDetailedInfoItem)
{
}

// ------------------------------------------------------------------------
POICategoryBrowseCheckDataBindingSource::POICategoryBrowseCheckDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POICategoryBrowseCheckItem)
{
}

// ------------------------------------------------------------------------
StoredLocationIconDataBindingSource::StoredLocationIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::StoredLocationIconItem)
{
}

// ------------------------------------------------------------------------
AddressDetailedInfoIconDataBindingSource::AddressDetailedInfoIconDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressDetailedInfoIconItem)
{
}

// ------------------------------------------------------------------------
AddressInputButtonVisibilityDataBindingSource::AddressInputButtonVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AddressInputButtonVisibilityItem)
{
}

// ------------------------------------------------------------------------
TrafficIconsDataBindingSource::TrafficIconsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TrafficIconsItem)
{
}

// ------------------------------------------------------------------------
GuidanceSettingsDataBindingSource::GuidanceSettingsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GuidanceSettingsItem)
{
}

// ------------------------------------------------------------------------
CheckBoxListItemDataBindingSource::CheckBoxListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CheckBoxListItemItem)
{
}

// ------------------------------------------------------------------------
RoutePreferenceCheckBoxListItemDataBindingSource::RoutePreferenceCheckBoxListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RoutePreferenceCheckBoxListItemItem)
{
}

// ------------------------------------------------------------------------
RoutePreferenceAdjustmentListItemDataBindingSource::RoutePreferenceAdjustmentListItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RoutePreferenceAdjustmentListItemItem)
{
}

// ------------------------------------------------------------------------
NavigationGadgetInfoDataBindingSource::NavigationGadgetInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NavigationGadgetInfoItem)
{
}

// ------------------------------------------------------------------------
LatLongSpellerPressedKeyInfoDataBindingSource::LatLongSpellerPressedKeyInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongSpellerPressedKeyInfoItem)
{
}

// ------------------------------------------------------------------------
LatLongSpellerTextReceivedDataBindingSource::LatLongSpellerTextReceivedDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongSpellerTextReceivedItem)
{
}

// ------------------------------------------------------------------------
LatLongEditFieldBGImageItemDataBindingSource::LatLongEditFieldBGImageItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongEditFieldBGImageItemItem)
{
}

// ------------------------------------------------------------------------
LatLongDataValuesDataBindingSource::LatLongDataValuesDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongDataValuesItem)
{
}

// ------------------------------------------------------------------------
LatLongCoordinatesDirectionDataBindingSource::LatLongCoordinatesDirectionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongCoordinatesDirectionItem)
{
}

// ------------------------------------------------------------------------
ToggleButtonTextDataBindingSource::ToggleButtonTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ToggleButtonTextItem)
{
}

// ------------------------------------------------------------------------
LatLongCoordinatesFormatDataBindingSource::LatLongCoordinatesFormatDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LatLongCoordinatesFormatItem)
{
}

// ------------------------------------------------------------------------
EnableSetLatLongButtonDataBindingSource::EnableSetLatLongButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EnableSetLatLongButtonItem)
{
}

// ------------------------------------------------------------------------
PickFromMapDataDataBindingSource::PickFromMapDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PickFromMapDataItem)
{
}

// ------------------------------------------------------------------------
EnableOkButtonDataBindingSource::EnableOkButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EnableOkButtonItem)
{
}

// ------------------------------------------------------------------------
EnablePhoneButtonDataBindingSource::EnablePhoneButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EnablePhoneButtonItem)
{
}

// ------------------------------------------------------------------------
EnableGuidanceButtonDataBindingSource::EnableGuidanceButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EnableGuidanceButtonItem)
{
}

// ------------------------------------------------------------------------
CompassButtonDataBindingSource::CompassButtonDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CompassButtonItem)
{
}

// ------------------------------------------------------------------------
MapoutScreenDataDataBindingSource::MapoutScreenDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapoutScreenDataItem)
{
}

// ------------------------------------------------------------------------
MapScreenDataDataBindingSource::MapScreenDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapScreenDataItem)
{
}

// ------------------------------------------------------------------------
SplitMapScreenDataDataBindingSource::SplitMapScreenDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SplitMapScreenDataItem)
{
}

// ------------------------------------------------------------------------
MapMainScreenStateDataBindingSource::MapMainScreenStateDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapMainScreenStateItem)
{
}

// ------------------------------------------------------------------------
TurnListETAItemDataBindingSource::TurnListETAItemDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TurnListETAItemItem)
{
}

// ------------------------------------------------------------------------
ODRDataDataBindingSource::ODRDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ODRDataItem)
{
}

// ------------------------------------------------------------------------
RouteOverviewBtnDataBindingSource::RouteOverviewBtnDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteOverviewBtnItem)
{
}

// ------------------------------------------------------------------------
MapSettingOthersListIDDataBindingSource::MapSettingOthersListIDDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapSettingOthersListIDItem)
{
}

// ------------------------------------------------------------------------
NaviBackButtonLevelDataBindingSource::NaviBackButtonLevelDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NaviBackButtonLevelItem)
{
}

// ------------------------------------------------------------------------
MapSettingsOthersTitleDataBindingSource::MapSettingsOthersTitleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapSettingsOthersTitleItem)
{
}

// ------------------------------------------------------------------------
ZoomBarInfoDataBindingSource::ZoomBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ZoomBarInfoItem)
{
}

// ------------------------------------------------------------------------
MultiLinePopupTextDataBindingSource::MultiLinePopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MultiLinePopupTextItem)
{
}

// ------------------------------------------------------------------------
SettingSliderDataBindingSource::SettingSliderDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SettingSliderItem)
{
}

// ------------------------------------------------------------------------
WhereAmIScreenDataDataBindingSource::WhereAmIScreenDataDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::WhereAmIScreenDataItem)
{
}

// ------------------------------------------------------------------------
WaypointListInfoDataBindingSource::WaypointListInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::WaypointListInfoItem)
{
}

// ------------------------------------------------------------------------
GPSInfoDataBindingSource::GPSInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GPSInfoItem)
{
}

// ------------------------------------------------------------------------
SwitchindexDataBindingSource::SwitchindexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SwitchindexItem)
{
}

// ------------------------------------------------------------------------
LaneGuidanceDataBindingSource::LaneGuidanceDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::LaneGuidanceItem)
{
}

// ------------------------------------------------------------------------
RouteGuidancetextImageUpdationDataBindingSource::RouteGuidancetextImageUpdationDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteGuidancetextImageUpdationItem)
{
}

// ------------------------------------------------------------------------
TrafficMessagesDataBindingSource::TrafficMessagesDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TrafficMessagesItem)
{
}

// ------------------------------------------------------------------------
POITitleDataBindingSource::POITitleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POITitleItem)
{
}

// ------------------------------------------------------------------------
POITopCategoryTitleDataBindingSource::POITopCategoryTitleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::POITopCategoryTitleItem)
{
}

// ------------------------------------------------------------------------
PreviousDestCountDataBindingSource::PreviousDestCountDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::PreviousDestCountItem)
{
}

// ------------------------------------------------------------------------
HeaderTimeDataBindingSource::HeaderTimeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HeaderTimeItem)
{
}

// ------------------------------------------------------------------------
HardRestrictionDataBindingSource::HardRestrictionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::HardRestrictionItem)
{
}

// ------------------------------------------------------------------------
TimeDisplayDataBindingSource::TimeDisplayDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TimeDisplayItem)
{
}

// ------------------------------------------------------------------------
StreamMapContentDataBindingSource::StreamMapContentDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::StreamMapContentItem)
{
}

// ------------------------------------------------------------------------
NavDataPopupTextDataBindingSource::NavDataPopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::NavDataPopupTextItem)
{
}

// ------------------------------------------------------------------------
AlternativeRouteItemsDataBindingSource::AlternativeRouteItemsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::AlternativeRouteItemsItem)
{
}

// ------------------------------------------------------------------------
RouteSwitchbtnDataBindingSource::RouteSwitchbtnDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteSwitchbtnItem)
{
}

// ------------------------------------------------------------------------
GuidanceRouteSwitchbtnDataBindingSource::GuidanceRouteSwitchbtnDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::GuidanceRouteSwitchbtnItem)
{
}

// ------------------------------------------------------------------------
TrafficDetourDetailsDataBindingSource::TrafficDetourDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::TrafficDetourDetailsItem)
{
}

// ------------------------------------------------------------------------
XUrgentTrafficMessageDataBindingSource::XUrgentTrafficMessageDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::XUrgentTrafficMessageItem)
{
}

// ------------------------------------------------------------------------
EngineeringMenuDetailsDataBindingSource::EngineeringMenuDetailsDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringMenuDetailsItem)
{
}

// ------------------------------------------------------------------------
EngineeringMenuTitleDataBindingSource::EngineeringMenuTitleDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringMenuTitleItem)
{
}

// ------------------------------------------------------------------------
EngineeringMenuListCheckDataBindingSource::EngineeringMenuListCheckDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::EngineeringMenuListCheckItem)
{
}

// ------------------------------------------------------------------------
VehicleProfileInfoDataBindingSource::VehicleProfileInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VehicleProfileInfoItem)
{
}

// ------------------------------------------------------------------------
StreamedMapSettingDataBindingSource::StreamedMapSettingDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::StreamedMapSettingItem)
{
}

// ------------------------------------------------------------------------
MyPOIsAvailabilityDataBindingSource::MyPOIsAvailabilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MyPOIsAvailabilityItem)
{
}

// ------------------------------------------------------------------------
RouteOptionsBorderDataBindingSource::RouteOptionsBorderDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteOptionsBorderItem)
{
}

// ------------------------------------------------------------------------
RouteRestrictionsPopupTextDataBindingSource::RouteRestrictionsPopupTextDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::RouteRestrictionsPopupTextItem)
{
}

// ------------------------------------------------------------------------
SoftRestrictionDataBindingSource::SoftRestrictionDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SoftRestrictionItem)
{
}

// ------------------------------------------------------------------------
MapOptionOthersSettingDataBindingSource::MapOptionOthersSettingDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::MapOptionOthersSettingItem)
{
}

// ------------------------------------------------------------------------
SwitchVehicleParameterindexDataBindingSource::SwitchVehicleParameterindexDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::SwitchVehicleParameterindexItem)
{
}

// ------------------------------------------------------------------------
VehicleProfileTypeDataBindingSource::VehicleProfileTypeDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::VehicleProfileTypeItem)
{
}

// ------------------------------------------------------------------------
ListScrollBarInfoDataBindingSource::ListScrollBarInfoDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::ListScrollBarInfoItem)
{
}

// ------------------------------------------------------------------------
CarModeVisibilityDataBindingSource::CarModeVisibilityDataBindingSource() : 
    ::Courier::Internal::AsyncModelBindingSource(ItemKey::CarModeVisibilityItem)
{
}

typedef void InvalidData;
struct InvalidDataBindingSource {
    static const ::FeatStd::UInt32 cHierarchyNodeCount = 1;
};

// table of shared DataItemDescriptor
static const ::Courier::Internal::DataBinding::DataItemDescriptor gItemDesc[cDataItemDescriptorCount] = {
    {   // 0 - ::InvalidData
        COURIER_DATA_ITEM_TYPE_ID(::InvalidData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 1 - ::SignpostTextData
        COURIER_DATA_ITEM_TYPE_ID(::SignpostTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 2 - ::SignpostTextData::mSignpostfirstline
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostfirstline)
    },
    {   // 3 - ::SignpostTextData::mSignpostsecondline
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostsecondline)
    },
    {   // 4 - ::SignpostTextData::mTextLinesColor
        COURIER_DATA_ITEM_TYPE_ID(Candera::Color),
        COURIER_ITEM_MEMBER(::SignpostTextData, mTextLinesColor)
    },
    {   // 5 - ::SignpostTextData::mBackgroundImageColor
        COURIER_DATA_ITEM_TYPE_ID(Candera::Color),
        COURIER_ITEM_MEMBER(::SignpostTextData, mBackgroundImageColor)
    },
    {   // 6 - ::SignpostTextData::mExitNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SignpostTextData, mExitNumber)
    },
    {   // 7 - ::SignpostTextData::mExitNumberPositioning
        COURIER_DATA_ITEM_TYPE_ID(Candera::Margin),
        COURIER_ITEM_MEMBER(::SignpostTextData, mExitNumberPositioning)
    },
    {   // 8 - ::SignpostTextData::mSignpostActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostActive)
    },
    {   // 9 - ::SignpostTextData::mExitNumberExists
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SignpostTextData, mExitNumberExists)
    },
    {   // 10 - ::SignpostTextData::mSignpostRegionType
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostRegionType)
    },
    {   // 11 - ::SignpostTextData::mSignpostDirectionName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostDirectionName)
    },
    {   // 12 - ::SignpostTextData::mSignpostPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::HorizontalAlignment),
        COURIER_ITEM_MEMBER(::SignpostTextData, mSignpostPosition)
    },
    {   // 13 - ::HlgImageDataData
        COURIER_DATA_ITEM_TYPE_ID(::HlgImageDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 14 - ::HlgImageDataData::mHlgImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::HlgImageDataData, mHlgImage)
    },
    {   // 15 - ::HlgImageDataData::mHlgImageVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HlgImageDataData, mHlgImageVisible)
    },
    {   // 16 - ::HlgImageDataData::mToggleLaneGuidanceVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HlgImageDataData, mToggleLaneGuidanceVisibility)
    },
    {   // 17 - ::RoadIconsData
        COURIER_DATA_ITEM_TYPE_ID(::RoadIconsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 18 - ::RoadIconsData::mRoadIconImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RoadIconsData, mRoadIconImage)
    },
    {   // 19 - ::MapModeData
        COURIER_DATA_ITEM_TYPE_ID(::MapModeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 20 - ::MapModeData::mIsDayModeActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapModeData, mIsDayModeActive)
    },
    {   // 21 - ::BTTetheringStateData
        COURIER_DATA_ITEM_TYPE_ID(::BTTetheringStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 22 - ::BTTetheringStateData::mTetheringIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::BTTetheringStateData, mTetheringIndex)
    },
    {   // 23 - ::AddressInputValueData
        COURIER_DATA_ITEM_TYPE_ID(::AddressInputValueData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 24 - ::AddressInputValueData::mCountry
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mCountry)
    },
    {   // 25 - ::AddressInputValueData::mState
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mState)
    },
    {   // 26 - ::AddressInputValueData::mCity
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mCity)
    },
    {   // 27 - ::AddressInputValueData::mStreet
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mStreet)
    },
    {   // 28 - ::AddressInputValueData::mHousenum
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mHousenum)
    },
    {   // 29 - ::AddressInputValueData::mIntersection
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValueData, mIntersection)
    },
    {   // 30 - ::ChangeCountryButtonData
        COURIER_DATA_ITEM_TYPE_ID(::ChangeCountryButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 31 - ::ChangeCountryButtonData::mIsVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ChangeCountryButtonData, mIsVisible)
    },
    {   // 32 - ::ChangeCountryButtonData::mCountryIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ChangeCountryButtonData, mCountryIcon)
    },
    {   // 33 - ::PreviousDestinationValData
        COURIER_DATA_ITEM_TYPE_ID(::PreviousDestinationValData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 34 - ::PreviousDestinationValData::mPOIaddress
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PreviousDestinationValData, mPOIaddress)
    },
    {   // 35 - ::VariantButtonData
        COURIER_DATA_ITEM_TYPE_ID(::VariantButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 36 - ::VariantButtonData::mVisibleCountry
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantButtonData, mVisibleCountry)
    },
    {   // 37 - ::VariantButtonData::mVisibleState
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantButtonData, mVisibleState)
    },
    {   // 38 - ::VariantButtonData::mVisibleProvince
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VariantButtonData, mVisibleProvince)
    },
    {   // 39 - ::DEDisableButtonData
        COURIER_DATA_ITEM_TYPE_ID(::DEDisableButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 40 - ::DEDisableButtonData::mCity
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mCity)
    },
    {   // 41 - ::DEDisableButtonData::mStreet
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mStreet)
    },
    {   // 42 - ::DEDisableButtonData::mInterSection
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mInterSection)
    },
    {   // 43 - ::DEDisableButtonData::mHousenum
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mHousenum)
    },
    {   // 44 - ::DEDisableButtonData::mDetails
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mDetails)
    },
    {   // 45 - ::DEDisableButtonData::mGuidance
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mGuidance)
    },
    {   // 46 - ::DEDisableButtonData::mPOISearch
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::DEDisableButtonData, mPOISearch)
    },
    {   // 47 - ::AddressInputValPOIData
        COURIER_DATA_ITEM_TYPE_ID(::AddressInputValPOIData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 48 - ::AddressInputValPOIData::mCountry
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValPOIData, mCountry)
    },
    {   // 49 - ::AddressInputValPOIData::mCity
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValPOIData, mCity)
    },
    {   // 50 - ::AddressInputValPOIData::mPOISearch
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValPOIData, mPOISearch)
    },
    {   // 51 - ::AddressInputValDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::AddressInputValDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 52 - ::AddressInputValDetailsData::mLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValDetailsData, mLine1)
    },
    {   // 53 - ::AddressInputValDetailsData::mLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValDetailsData, mLine2)
    },
    {   // 54 - ::AddressInputValDetailsData::mLine3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValDetailsData, mLine3)
    },
    {   // 55 - ::AddressInputValDetailsData::mLine4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValDetailsData, mLine4)
    },
    {   // 56 - ::AddressInputValDetailsData::mPOIAmbiguousDetails2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressInputValDetailsData, mPOIAmbiguousDetails2)
    },
    {   // 57 - ::PlaceInfoButtonsData
        COURIER_DATA_ITEM_TYPE_ID(::PlaceInfoButtonsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 58 - ::PlaceInfoButtonsData::mGoHereVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PlaceInfoButtonsData, mGoHereVisibility)
    },
    {   // 59 - ::PlaceInfoDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::PlaceInfoDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 60 - ::PlaceInfoDetailsData::mName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaceInfoDetailsData, mName)
    },
    {   // 61 - ::PlaceInfoDetailsData::mAddress
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaceInfoDetailsData, mAddress)
    },
    {   // 62 - ::PlaceInfoDetailsData::mPhonenumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaceInfoDetailsData, mPhonenumber)
    },
    {   // 63 - ::PlaceInfoDetailsData::mLine4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PlaceInfoDetailsData, mLine4)
    },
    {   // 64 - ::TwoLinePopuptextData
        COURIER_DATA_ITEM_TYPE_ID(::TwoLinePopuptextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 65 - ::TwoLinePopuptextData::mPopuptextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TwoLinePopuptextData, mPopuptextLine1)
    },
    {   // 66 - ::TwoLinePopuptextData::mPopuptextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TwoLinePopuptextData, mPopuptextLine2)
    },
    {   // 67 - ::MultiLinePopuptextData
        COURIER_DATA_ITEM_TYPE_ID(::MultiLinePopuptextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 68 - ::MultiLinePopuptextData::mTextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultiLinePopuptextData, mTextLine1)
    },
    {   // 69 - ::MultiLinePopuptextData::mTextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultiLinePopuptextData, mTextLine2)
    },
    {   // 70 - ::ThreeLinePopuptextData
        COURIER_DATA_ITEM_TYPE_ID(::ThreeLinePopuptextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 71 - ::ThreeLinePopuptextData::mTextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ThreeLinePopuptextData, mTextLine1)
    },
    {   // 72 - ::ThreeLinePopuptextData::mTextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ThreeLinePopuptextData, mTextLine2)
    },
    {   // 73 - ::ThreeLinePopuptextData::mTextLine3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ThreeLinePopuptextData, mTextLine3)
    },
    {   // 74 - ::RouteInfoPopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::RouteInfoPopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 75 - ::RouteInfoPopupTextData::mTextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteInfoPopupTextData, mTextLine1)
    },
    {   // 76 - ::RouteInfoPopupTextData::mTextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteInfoPopupTextData, mTextLine2)
    },
    {   // 77 - ::FourLinePopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::FourLinePopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 78 - ::FourLinePopupTextData::mMultiLineText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FourLinePopupTextData, mMultiLineText)
    },
    {   // 79 - ::FiveLinePopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::FiveLinePopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 80 - ::FiveLinePopupTextData::mPopupTextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FiveLinePopupTextData, mPopupTextLine1)
    },
    {   // 81 - ::FiveLinePopupTextData::mPopupTextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FiveLinePopupTextData, mPopupTextLine2)
    },
    {   // 82 - ::FiveLinePopupTextData::mPopupTextLine3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FiveLinePopupTextData, mPopupTextLine3)
    },
    {   // 83 - ::FiveLinePopupTextData::mPopupTextLine4
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FiveLinePopupTextData, mPopupTextLine4)
    },
    {   // 84 - ::FiveLinePopupTextData::mPopupTextLine5
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FiveLinePopupTextData, mPopupTextLine5)
    },
    {   // 85 - ::SpellerPressedKeyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SpellerPressedKeyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 86 - ::SpellerPressedKeyInfoData::mPressedKey
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerPressedKeyInfoData, mPressedKey)
    },
    {   // 87 - ::SpellerPagesData
        COURIER_DATA_ITEM_TYPE_ID(::SpellerPagesData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 88 - ::SpellerPagesData::mSpellerPageNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerPagesData, mSpellerPageNumber)
    },
    {   // 89 - ::SpellerTextInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SpellerTextInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 90 - ::SpellerTextInfoData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerTextInfoData, mText)
    },
    {   // 91 - ::NaviSpellerInfoData
        COURIER_DATA_ITEM_TYPE_ID(::NaviSpellerInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 92 - ::NaviSpellerInfoData::mCountryCode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::NaviSpellerInfoData, mCountryCode)
    },
    {   // 93 - ::NaviSpellerInfoData::mLanguageCode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::NaviSpellerInfoData, mLanguageCode)
    },
    {   // 94 - ::AddressEntryTitleTextData
        COURIER_DATA_ITEM_TYPE_ID(::AddressEntryTitleTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 95 - ::AddressEntryTitleTextData::mTitleValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressEntryTitleTextData, mTitleValue)
    },
    {   // 96 - ::NaviMiddlewareStatusData
        COURIER_DATA_ITEM_TYPE_ID(::NaviMiddlewareStatusData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 97 - ::NaviMiddlewareStatusData::mIsNaviMiddlewareActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::NaviMiddlewareStatusData, mIsNaviMiddlewareActive)
    },
    {   // 98 - ::FreeTextListItemData
        COURIER_DATA_ITEM_TYPE_ID(::FreeTextListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 99 - ::FreeTextListItemData::mName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::FreeTextListItemData, mName)
    },
    {   // 100 - ::SpellerEntryTextReceivedInfoData
        COURIER_DATA_ITEM_TYPE_ID(::SpellerEntryTextReceivedInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 101 - ::SpellerEntryTextReceivedInfoData::mEntryText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mEntryText)
    },
    {   // 102 - ::SpellerEntryTextReceivedInfoData::mSuggestedText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mSuggestedText)
    },
    {   // 103 - ::SpellerEntryTextReceivedInfoData::mValidChar
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mValidChar)
    },
    {   // 104 - ::SpellerEntryTextReceivedInfoData::mMatches
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mMatches)
    },
    {   // 105 - ::SpellerEntryTextReceivedInfoData::mEnteredChar
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mEnteredChar)
    },
    {   // 106 - ::SpellerEntryTextReceivedInfoData::mCandidateListVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mCandidateListVisibility)
    },
    {   // 107 - ::SpellerEntryTextReceivedInfoData::mStateNameVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SpellerEntryTextReceivedInfoData, mStateNameVisibility)
    },
    {   // 108 - ::AddressEntryInputMatchesData
        COURIER_DATA_ITEM_TYPE_ID(::AddressEntryInputMatchesData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 109 - ::AddressEntryInputMatchesData::mNoOfMatches
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AddressEntryInputMatchesData, mNoOfMatches)
    },
    {   // 110 - ::GuidanceBlockUnblockButtonData
        COURIER_DATA_ITEM_TYPE_ID(::GuidanceBlockUnblockButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 111 - ::GuidanceBlockUnblockButtonData::mBlockUnblockText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GuidanceBlockUnblockButtonData, mBlockUnblockText)
    },
    {   // 112 - ::GuidanceBlockUnblockButtonData::mBlockUnblockNormalIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GuidanceBlockUnblockButtonData, mBlockUnblockNormalIcon)
    },
    {   // 113 - ::GuidanceBlockUnblockButtonData::mBlockUnblockPressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GuidanceBlockUnblockButtonData, mBlockUnblockPressedIcon)
    },
    {   // 114 - ::GuidanceBlockUnblockButtonData::mBlockUnblockEnable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GuidanceBlockUnblockButtonData, mBlockUnblockEnable)
    },
    {   // 115 - ::POICategoryRootItemData
        COURIER_DATA_ITEM_TYPE_ID(::POICategoryRootItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 116 - ::POICategoryRootItemData::mIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryRootItemData, mIconNormalBitmap)
    },
    {   // 117 - ::POICategoryRootItemData::mName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POICategoryRootItemData, mName)
    },
    {   // 118 - ::ShowPOIsOnMapItemData
        COURIER_DATA_ITEM_TYPE_ID(::ShowPOIsOnMapItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 119 - ::ShowPOIsOnMapItemData::mIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowPOIsOnMapItemData, mIconNormalBitmap)
    },
    {   // 120 - ::ShowRouteListItemData
        COURIER_DATA_ITEM_TYPE_ID(::ShowRouteListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 121 - ::ShowRouteListItemData::mRouteListItem
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mRouteListItem)
    },
    {   // 122 - ::ShowRouteListItemData::mDistanceInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mDistanceInfo)
    },
    {   // 123 - ::ShowRouteListItemData::mTurnIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mTurnIconActiveBitmap)
    },
    {   // 124 - ::ShowRouteListItemData::mRoadIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mRoadIconActiveBitmap)
    },
    {   // 125 - ::ShowRouteListItemData::mRouteSelectionActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mRouteSelectionActiveBitmap)
    },
    {   // 126 - ::ShowRouteListItemData::mRouteList_BlockUnblockNormalIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mRouteList_BlockUnblockNormalIcon)
    },
    {   // 127 - ::ShowRouteListItemData::mRouteList_BlockUnblockPressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::ShowRouteListItemData, mRouteList_BlockUnblockPressedIcon)
    },
    {   // 128 - ::BlockRouteListItemData
        COURIER_DATA_ITEM_TYPE_ID(::BlockRouteListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 129 - ::BlockRouteListItemData::mRecalcEnableDisable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::BlockRouteListItemData, mRecalcEnableDisable)
    },
    {   // 130 - ::BlockRouteListItemData::mRecalculateIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::BlockRouteListItemData, mRecalculateIcon)
    },
    {   // 131 - ::POICategoryListItemData
        COURIER_DATA_ITEM_TYPE_ID(::POICategoryListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 132 - ::POICategoryListItemData::mDirectionIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDirectionIconActiveBitmap)
    },
    {   // 133 - ::POICategoryListItemData::mDirectionIconActiveFocusesBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDirectionIconActiveFocusesBitmap)
    },
    {   // 134 - ::POICategoryListItemData::mDirectionIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDirectionIconNormalBitmap)
    },
    {   // 135 - ::POICategoryListItemData::mDirectionIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDirectionIconFocusedBitmap)
    },
    {   // 136 - ::POICategoryListItemData::mDirectionIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDirectionIconPressedBitmap)
    },
    {   // 137 - ::POICategoryListItemData::mName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mName)
    },
    {   // 138 - ::POICategoryListItemData::mDistance
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mDistance)
    },
    {   // 139 - ::POICategoryListItemData::mAddress
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mAddress)
    },
    {   // 140 - ::POICategoryListItemData::mVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::POICategoryListItemData, mVisible)
    },
    {   // 141 - ::POIDetailedInfoData
        COURIER_DATA_ITEM_TYPE_ID(::POIDetailedInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 142 - ::POIDetailedInfoData::mName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POIDetailedInfoData, mName)
    },
    {   // 143 - ::POIDetailedInfoData::mAddress
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POIDetailedInfoData, mAddress)
    },
    {   // 144 - ::POICategoryBrowseCheckData
        COURIER_DATA_ITEM_TYPE_ID(::POICategoryBrowseCheckData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 145 - ::POICategoryBrowseCheckData::mPOITopCategoryStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::POICategoryBrowseCheckData, mPOITopCategoryStatus)
    },
    {   // 146 - ::POICategoryBrowseCheckData::mPOIResultListStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::POICategoryBrowseCheckData, mPOIResultListStatus)
    },
    {   // 147 - ::StoredLocationIconData
        COURIER_DATA_ITEM_TYPE_ID(::StoredLocationIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 148 - ::StoredLocationIconData::mLocationIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationIconActiveBitmap)
    },
    {   // 149 - ::StoredLocationIconData::mLocationIconActiveFocusesBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationIconActiveFocusesBitmap)
    },
    {   // 150 - ::StoredLocationIconData::mLocationIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationIconNormalBitmap)
    },
    {   // 151 - ::StoredLocationIconData::mLocationIconFocusedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationIconFocusedBitmap)
    },
    {   // 152 - ::StoredLocationIconData::mLocationIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationIconPressedBitmap)
    },
    {   // 153 - ::StoredLocationIconData::mLocationNameInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StoredLocationIconData, mLocationNameInfo)
    },
    {   // 154 - ::AddressDetailedInfoIconData
        COURIER_DATA_ITEM_TYPE_ID(::AddressDetailedInfoIconData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 155 - ::AddressDetailedInfoIconData::mFav_EditNormalIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AddressDetailedInfoIconData, mFav_EditNormalIcon)
    },
    {   // 156 - ::AddressDetailedInfoIconData::mFav_EditPressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AddressDetailedInfoIconData, mFav_EditPressedIcon)
    },
    {   // 157 - ::AddressDetailedInfoIconData::mDeleteIconButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AddressDetailedInfoIconData, mDeleteIconButtonVisibility)
    },
    {   // 158 - ::AddressDetailedInfoIconData::mDeleteAllIconButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AddressDetailedInfoIconData, mDeleteAllIconButtonVisibility)
    },
    {   // 159 - ::AddressInputButtonVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::AddressInputButtonVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 160 - ::AddressInputButtonVisibilityData::mDetailInfoButtonVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AddressInputButtonVisibilityData, mDetailInfoButtonVisibility)
    },
    {   // 161 - ::AddressInputButtonVisibilityData::mGuidance_HomeNormalIconEnabled
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AddressInputButtonVisibilityData, mGuidance_HomeNormalIconEnabled)
    },
    {   // 162 - ::AddressInputButtonVisibilityData::mGuidance_HomePressedIconEnabled
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AddressInputButtonVisibilityData, mGuidance_HomePressedIconEnabled)
    },
    {   // 163 - ::AddressInputButtonVisibilityData::mGuidance_HomeIconDisabled
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::AddressInputButtonVisibilityData, mGuidance_HomeIconDisabled)
    },
    {   // 164 - ::TrafficIconsData
        COURIER_DATA_ITEM_TYPE_ID(::TrafficIconsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 165 - ::TrafficIconsData::mTrafficIconName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficIconsData, mTrafficIconName)
    },
    {   // 166 - ::TrafficIconsData::mTrafficIconImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::TrafficIconsData, mTrafficIconImage)
    },
    {   // 167 - ::TrafficIconsData::mToggleIconSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::TrafficIconsData, mToggleIconSwitchIndex)
    },
    {   // 168 - ::GuidanceSettingsData
        COURIER_DATA_ITEM_TYPE_ID(::GuidanceSettingsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 169 - ::GuidanceSettingsData::mCurrentGuidanceVolume
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::GuidanceSettingsData, mCurrentGuidanceVolume)
    },
    {   // 170 - ::GuidanceSettingsData::mGuidanceVoiceStatus
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::GuidanceSettingsData, mGuidanceVoiceStatus)
    },
    {   // 171 - ::GuidanceSettingsData::mTrafficAnnouncementStatus
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::GuidanceSettingsData, mTrafficAnnouncementStatus)
    },
    {   // 172 - ::GuidanceSettingsData::mTollBothGuideStatus
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::GuidanceSettingsData, mTollBothGuideStatus)
    },
    {   // 173 - ::CheckBoxListItemData
        COURIER_DATA_ITEM_TYPE_ID(::CheckBoxListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 174 - ::CheckBoxListItemData::mListItemName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::CheckBoxListItemData, mListItemName)
    },
    {   // 175 - ::CheckBoxListItemData::mToggleIconSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::CheckBoxListItemData, mToggleIconSwitchIndex)
    },
    {   // 176 - ::RoutePreferenceCheckBoxListItemData
        COURIER_DATA_ITEM_TYPE_ID(::RoutePreferenceCheckBoxListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 177 - ::RoutePreferenceCheckBoxListItemData::mCheckBoxStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RoutePreferenceCheckBoxListItemData, mCheckBoxStatus)
    },
    {   // 178 - ::RoutePreferenceAdjustmentListItemData
        COURIER_DATA_ITEM_TYPE_ID(::RoutePreferenceAdjustmentListItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 179 - ::RoutePreferenceAdjustmentListItemData::mRouteTypeOption
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RoutePreferenceAdjustmentListItemData, mRouteTypeOption)
    },
    {   // 180 - ::RoutePreferenceAdjustmentListItemData::mOptionValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RoutePreferenceAdjustmentListItemData, mOptionValue)
    },
    {   // 181 - ::NavigationGadgetInfoData
        COURIER_DATA_ITEM_TYPE_ID(::NavigationGadgetInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 182 - ::NavigationGadgetInfoData::mIsGuidanceActive
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::NavigationGadgetInfoData, mIsGuidanceActive)
    },
    {   // 183 - ::NavigationGadgetInfoData::mHomeTileStreetStr
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NavigationGadgetInfoData, mHomeTileStreetStr)
    },
    {   // 184 - ::LatLongSpellerPressedKeyInfoData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongSpellerPressedKeyInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 185 - ::LatLongSpellerPressedKeyInfoData::mPressedKey_LatLongEditField
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongSpellerPressedKeyInfoData, mPressedKey_LatLongEditField)
    },
    {   // 186 - ::LatLongSpellerTextReceivedData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongSpellerTextReceivedData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 187 - ::LatLongSpellerTextReceivedData::mTextReceive_LatLongEditField
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongSpellerTextReceivedData, mTextReceive_LatLongEditField)
    },
    {   // 188 - ::LatLongEditFieldBGImageItemData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongEditFieldBGImageItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 189 - ::LatLongEditFieldBGImageItemData::mLatitudeDegreesBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLatitudeDegreesBGBitmap)
    },
    {   // 190 - ::LatLongEditFieldBGImageItemData::mLatitudeMinutesBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLatitudeMinutesBGBitmap)
    },
    {   // 191 - ::LatLongEditFieldBGImageItemData::mLatitudeSecondsBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLatitudeSecondsBGBitmap)
    },
    {   // 192 - ::LatLongEditFieldBGImageItemData::mLatitudeDecimalsBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLatitudeDecimalsBGBitmap)
    },
    {   // 193 - ::LatLongEditFieldBGImageItemData::mLongitudeDegreesBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLongitudeDegreesBGBitmap)
    },
    {   // 194 - ::LatLongEditFieldBGImageItemData::mLongitudeMinutesBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLongitudeMinutesBGBitmap)
    },
    {   // 195 - ::LatLongEditFieldBGImageItemData::mLongitudeSecondsBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLongitudeSecondsBGBitmap)
    },
    {   // 196 - ::LatLongEditFieldBGImageItemData::mLongitudeDecimalsBGBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LatLongEditFieldBGImageItemData, mLongitudeDecimalsBGBitmap)
    },
    {   // 197 - ::LatLongDataValuesData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongDataValuesData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 198 - ::LatLongDataValuesData::mLatDegreesInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLatDegreesInputValues)
    },
    {   // 199 - ::LatLongDataValuesData::mLongDegreesInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLongDegreesInputValues)
    },
    {   // 200 - ::LatLongDataValuesData::mLatMinutesInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLatMinutesInputValues)
    },
    {   // 201 - ::LatLongDataValuesData::mLongMinutesInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLongMinutesInputValues)
    },
    {   // 202 - ::LatLongDataValuesData::mLatSecondsInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLatSecondsInputValues)
    },
    {   // 203 - ::LatLongDataValuesData::mLongSecondsInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLongSecondsInputValues)
    },
    {   // 204 - ::LatLongDataValuesData::mLatDecimalsInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLatDecimalsInputValues)
    },
    {   // 205 - ::LatLongDataValuesData::mLongDecimalsInputValues
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongDataValuesData, mLongDecimalsInputValues)
    },
    {   // 206 - ::LatLongCoordinatesDirectionData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongCoordinatesDirectionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 207 - ::LatLongCoordinatesDirectionData::mNorthSouthEditFieldTxt
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mNorthSouthEditFieldTxt)
    },
    {   // 208 - ::LatLongCoordinatesDirectionData::mEastWestEditFieldTxt
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mEastWestEditFieldTxt)
    },
    {   // 209 - ::LatLongCoordinatesDirectionData::mNorthSouthButtonTxt
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mNorthSouthButtonTxt)
    },
    {   // 210 - ::LatLongCoordinatesDirectionData::mEastWestButtonTxt
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mEastWestButtonTxt)
    },
    {   // 211 - ::LatLongCoordinatesDirectionData::mActiveNorthSouthEditField
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mActiveNorthSouthEditField)
    },
    {   // 212 - ::LatLongCoordinatesDirectionData::mActiveEastWestEditField
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesDirectionData, mActiveEastWestEditField)
    },
    {   // 213 - ::ToggleButtonTextData
        COURIER_DATA_ITEM_TYPE_ID(::ToggleButtonTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 214 - ::ToggleButtonTextData::mSouthNorthButtonText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ToggleButtonTextData, mSouthNorthButtonText)
    },
    {   // 215 - ::ToggleButtonTextData::mEastWestButtonText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ToggleButtonTextData, mEastWestButtonText)
    },
    {   // 216 - ::LatLongCoordinatesFormatData
        COURIER_DATA_ITEM_TYPE_ID(::LatLongCoordinatesFormatData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 217 - ::LatLongCoordinatesFormatData::mLatLongFormatIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::LatLongCoordinatesFormatData, mLatLongFormatIndex)
    },
    {   // 218 - ::EnableSetLatLongButtonData
        COURIER_DATA_ITEM_TYPE_ID(::EnableSetLatLongButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 219 - ::EnableSetLatLongButtonData::mIsButtonVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableSetLatLongButtonData, mIsButtonVisible)
    },
    {   // 220 - ::EnableSetLatLongButtonData::mIsPopUpVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableSetLatLongButtonData, mIsPopUpVisible)
    },
    {   // 221 - ::PickFromMapDataData
        COURIER_DATA_ITEM_TYPE_ID(::PickFromMapDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 222 - ::PickFromMapDataData::mMapPickingImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingImage)
    },
    {   // 223 - ::PickFromMapDataData::mMapPickingType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingType)
    },
    {   // 224 - ::PickFromMapDataData::mMapPickingPhoneNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingPhoneNumber)
    },
    {   // 225 - ::PickFromMapDataData::mSelectedRoad
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mSelectedRoad)
    },
    {   // 226 - ::PickFromMapDataData::mMapPickingInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingInfo)
    },
    {   // 227 - ::PickFromMapDataData::mMapPickingNumber
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingNumber)
    },
    {   // 228 - ::PickFromMapDataData::mMapPickingSize
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingSize)
    },
    {   // 229 - ::PickFromMapDataData::mPhoneNumberAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mPhoneNumberAvailable)
    },
    {   // 230 - ::PickFromMapDataData::mIsValidLocationAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mIsValidLocationAvailable)
    },
    {   // 231 - ::PickFromMapDataData::mMapPickingInfoAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mMapPickingInfoAvailable)
    },
    {   // 232 - ::PickFromMapDataData::mLineSwitchIndex
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mLineSwitchIndex)
    },
    {   // 233 - ::PickFromMapDataData::mFirstLineInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mFirstLineInfo)
    },
    {   // 234 - ::PickFromMapDataData::mSecondLineInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mSecondLineInfo)
    },
    {   // 235 - ::PickFromMapDataData::mEnablePreviousInfoArrow
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mEnablePreviousInfoArrow)
    },
    {   // 236 - ::PickFromMapDataData::mEnableNextInfoArrow
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mEnableNextInfoArrow)
    },
    {   // 237 - ::PickFromMapDataData::mCurrentAndTotalPageNumberDisplay
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mCurrentAndTotalPageNumberDisplay)
    },
    {   // 238 - ::PickFromMapDataData::mWaypointNumber
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mWaypointNumber)
    },
    {   // 239 - ::PickFromMapDataData::mPickedDirection
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mPickedDirection)
    },
    {   // 240 - ::PickFromMapDataData::mPickedDistance
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mPickedDistance)
    },
    {   // 241 - ::PickFromMapDataData::mDetailPickingInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::PickFromMapDataData, mDetailPickingInfo)
    },
    {   // 242 - ::EnableOkButtonData
        COURIER_DATA_ITEM_TYPE_ID(::EnableOkButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 243 - ::EnableOkButtonData::mIsOKButtonVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableOkButtonData, mIsOKButtonVisible)
    },
    {   // 244 - ::EnableOkButtonData::mNaviIconNormal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::EnableOkButtonData, mNaviIconNormal)
    },
    {   // 245 - ::EnableOkButtonData::mNaviIconPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::EnableOkButtonData, mNaviIconPressed)
    },
    {   // 246 - ::EnableOkButtonData::mIsCarModeNaviIconVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableOkButtonData, mIsCarModeNaviIconVisible)
    },
    {   // 247 - ::EnablePhoneButtonData
        COURIER_DATA_ITEM_TYPE_ID(::EnablePhoneButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 248 - ::EnablePhoneButtonData::mIsPhoneButtonVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnablePhoneButtonData, mIsPhoneButtonVisible)
    },
    {   // 249 - ::EnableGuidanceButtonData
        COURIER_DATA_ITEM_TYPE_ID(::EnableGuidanceButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 250 - ::EnableGuidanceButtonData::mIsGuidanceButtonVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableGuidanceButtonData, mIsGuidanceButtonVisible)
    },
    {   // 251 - ::EnableGuidanceButtonData::mIsFavButtonVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableGuidanceButtonData, mIsFavButtonVisible)
    },
    {   // 252 - ::EnableGuidanceButtonData::mBackButtonLevelIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::EnableGuidanceButtonData, mBackButtonLevelIndex)
    },
    {   // 253 - ::EnableGuidanceButtonData::mIsCarModeNaviIconVisible
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EnableGuidanceButtonData, mIsCarModeNaviIconVisible)
    },
    {   // 254 - ::CompassButtonData
        COURIER_DATA_ITEM_TYPE_ID(::CompassButtonData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 255 - ::CompassButtonData::mCompassOrientation
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::CompassButtonData, mCompassOrientation)
    },
    {   // 256 - ::MapoutScreenDataData
        COURIER_DATA_ITEM_TYPE_ID(::MapoutScreenDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 257 - ::MapoutScreenDataData::mETADestination
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mETADestination)
    },
    {   // 258 - ::MapoutScreenDataData::mETAWaypoint
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mETAWaypoint)
    },
    {   // 259 - ::MapoutScreenDataData::mIsWaypointPresent
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mIsWaypointPresent)
    },
    {   // 260 - ::MapoutScreenDataData::mShowEta
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mShowEta)
    },
    {   // 261 - ::MapoutScreenDataData::mDurationCabinOnly
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mDurationCabinOnly)
    },
    {   // 262 - ::MapoutScreenDataData::mETACabinOnly
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mETACabinOnly)
    },
    {   // 263 - ::MapoutScreenDataData::mShowEtaDurationCabinOnly
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapoutScreenDataData, mShowEtaDurationCabinOnly)
    },
    {   // 264 - ::MapScreenDataData
        COURIER_DATA_ITEM_TYPE_ID(::MapScreenDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 265 - ::MapScreenDataData::mPickingResultLatitudeLongitude
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mPickingResultLatitudeLongitude)
    },
    {   // 266 - ::MapScreenDataData::mCurrentStreet
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mCurrentStreet)
    },
    {   // 267 - ::MapScreenDataData::mCurrentCity
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mCurrentCity)
    },
    {   // 268 - ::MapScreenDataData::mDistanceToDestination
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mDistanceToDestination)
    },
    {   // 269 - ::MapScreenDataData::mTimeToDestination
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mTimeToDestination)
    },
    {   // 270 - ::MapScreenDataData::mArrivalTimeToBeShownOnMap
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mArrivalTimeToBeShownOnMap)
    },
    {   // 271 - ::MapScreenDataData::mETATextLabelValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mETATextLabelValue)
    },
    {   // 272 - ::MapScreenDataData::mCompassArrowDirection
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mCompassArrowDirection)
    },
    {   // 273 - ::MapScreenDataData::mCompassArrowDirectionIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mCompassArrowDirectionIcon)
    },
    {   // 274 - ::MapScreenDataData::mZoomLevel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mZoomLevel)
    },
    {   // 275 - ::MapScreenDataData::mZoomSliderCurrentValue
        COURIER_DATA_ITEM_TYPE_ID(Courier::Float),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mZoomSliderCurrentValue)
    },
    {   // 276 - ::MapScreenDataData::mSecMapCompassArrowDirectionIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSecMapCompassArrowDirectionIcon)
    },
    {   // 277 - ::MapScreenDataData::mSecZoomLevel
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSecZoomLevel)
    },
    {   // 278 - ::MapScreenDataData::mScaleImageSwitch
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mScaleImageSwitch)
    },
    {   // 279 - ::MapScreenDataData::mSpeedLimit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSpeedLimit)
    },
    {   // 280 - ::MapScreenDataData::misSpeedLimitPresent
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapScreenDataData, misSpeedLimitPresent)
    },
    {   // 281 - ::MapScreenDataData::misOverSpeedWarning
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapScreenDataData, misOverSpeedWarning)
    },
    {   // 282 - ::MapScreenDataData::mSpeedlimitWithUnit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSpeedlimitWithUnit)
    },
    {   // 283 - ::MapScreenDataData::mSpeedcountryCode
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSpeedcountryCode)
    },
    {   // 284 - ::MapScreenDataData::mSpeedLimitIconPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mSpeedLimitIconPosition)
    },
    {   // 285 - ::MapScreenDataData::mShowMapActiveRGButtons
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mShowMapActiveRGButtons)
    },
    {   // 286 - ::MapScreenDataData::mStartShowMapActiveRGButtonTimer
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mStartShowMapActiveRGButtonTimer)
    },
    {   // 287 - ::MapScreenDataData::mIsGuidanceVoiceEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mIsGuidanceVoiceEnabled)
    },
    {   // 288 - ::MapScreenDataData::mMuteUnmuteText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMuteUnmuteText)
    },
    {   // 289 - ::MapScreenDataData::mMuteUnmuteNormalIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMuteUnmuteNormalIcon)
    },
    {   // 290 - ::MapScreenDataData::mMuteUnmutePressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMuteUnmutePressedIcon)
    },
    {   // 291 - ::MapScreenDataData::mMuteUnmuteDisabledIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMuteUnmuteDisabledIcon)
    },
    {   // 292 - ::MapScreenDataData::mNaviGadgetIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mNaviGadgetIcon)
    },
    {   // 293 - ::MapScreenDataData::mMapActiveRGNaviIconNormal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMapActiveRGNaviIconNormal)
    },
    {   // 294 - ::MapScreenDataData::mMapActiveRGNaviIconPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::MapScreenDataData, mMapActiveRGNaviIconPressed)
    },
    {   // 295 - ::SplitMapScreenDataData
        COURIER_DATA_ITEM_TYPE_ID(::SplitMapScreenDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 296 - ::SplitMapScreenDataData::mLaneGuidanceSplitViewPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::SplitMapScreenDataData, mLaneGuidanceSplitViewPosition)
    },
    {   // 297 - ::SplitMapScreenDataData::mEnableSplitMapItems
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SplitMapScreenDataData, mEnableSplitMapItems)
    },
    {   // 298 - ::MapMainScreenStateData
        COURIER_DATA_ITEM_TYPE_ID(::MapMainScreenStateData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 299 - ::MapMainScreenStateData::mMapMainScreenStateValue
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::MapMainScreenStateData, mMapMainScreenStateValue)
    },
    {   // 300 - ::TurnListETAItemData
        COURIER_DATA_ITEM_TYPE_ID(::TurnListETAItemData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 301 - ::TurnListETAItemData::mDistanceToDestination
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TurnListETAItemData, mDistanceToDestination)
    },
    {   // 302 - ::TurnListETAItemData::mTimeToDestination
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TurnListETAItemData, mTimeToDestination)
    },
    {   // 303 - ::TurnListETAItemData::mDestinationName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TurnListETAItemData, mDestinationName)
    },
    {   // 304 - ::ODRDataData
        COURIER_DATA_ITEM_TYPE_ID(::ODRDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 305 - ::ODRDataData::mTurnToStreet
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ODRDataData, mTurnToStreet)
    },
    {   // 306 - ::ODRDataData::mTurnToStreetWithDistance
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ODRDataData, mTurnToStreetWithDistance)
    },
    {   // 307 - ::ODRDataData::mDistanceToManeuver
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ODRDataData, mDistanceToManeuver)
    },
    {   // 308 - ::ODRDataData::mDistanceToManeuverUnit
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::ODRDataData, mDistanceToManeuverUnit)
    },
    {   // 309 - ::ODRDataData::mManeuverBargraphValue
        COURIER_DATA_ITEM_TYPE_ID(Courier::Float),
        COURIER_ITEM_MEMBER(::ODRDataData, mManeuverBargraphValue)
    },
    {   // 310 - ::ODRDataData::mShowManeuverBargraph
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ODRDataData, mShowManeuverBargraph)
    },
    {   // 311 - ::ODRDataData::mManeuverSymbolIndex
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::ODRDataData, mManeuverSymbolIndex)
    },
    {   // 312 - ::RouteOverviewBtnData
        COURIER_DATA_ITEM_TYPE_ID(::RouteOverviewBtnData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 313 - ::RouteOverviewBtnData::mIsRouteOverviewBtnEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RouteOverviewBtnData, mIsRouteOverviewBtnEnabled)
    },
    {   // 314 - ::MapSettingOthersListIDData
        COURIER_DATA_ITEM_TYPE_ID(::MapSettingOthersListIDData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 315 - ::MapSettingOthersListIDData::mListID
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt32),
        COURIER_ITEM_MEMBER(::MapSettingOthersListIDData, mListID)
    },
    {   // 316 - ::NaviBackButtonLevelData
        COURIER_DATA_ITEM_TYPE_ID(::NaviBackButtonLevelData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 317 - ::NaviBackButtonLevelData::mBackButtonLevel
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt8),
        COURIER_ITEM_MEMBER(::NaviBackButtonLevelData, mBackButtonLevel)
    },
    {   // 318 - ::MapSettingsOthersTitleData
        COURIER_DATA_ITEM_TYPE_ID(::MapSettingsOthersTitleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 319 - ::MapSettingsOthersTitleData::mMapOtherSettingsTitleValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MapSettingsOthersTitleData, mMapOtherSettingsTitleValue)
    },
    {   // 320 - ::ZoomBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ZoomBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 321 - ::ZoomBarInfoData::mIsZoomTimerStart
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ZoomBarInfoData, mIsZoomTimerStart)
    },
    {   // 322 - ::ZoomBarInfoData::mIsZoomBarDisplayed
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ZoomBarInfoData, mIsZoomBarDisplayed)
    },
    {   // 323 - ::MultiLinePopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::MultiLinePopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 324 - ::MultiLinePopupTextData::mThreeLinePopupText1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultiLinePopupTextData, mThreeLinePopupText1)
    },
    {   // 325 - ::MultiLinePopupTextData::mThreeLinePopupText2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultiLinePopupTextData, mThreeLinePopupText2)
    },
    {   // 326 - ::MultiLinePopupTextData::mThreeLinePopupText3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::MultiLinePopupTextData, mThreeLinePopupText3)
    },
    {   // 327 - ::SettingSliderData
        COURIER_DATA_ITEM_TYPE_ID(::SettingSliderData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 328 - ::SettingSliderData::mIncreasable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SettingSliderData, mIncreasable)
    },
    {   // 329 - ::SettingSliderData::mDecreasable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SettingSliderData, mDecreasable)
    },
    {   // 330 - ::SettingSliderData::mCurrentValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::Int),
        COURIER_ITEM_MEMBER(::SettingSliderData, mCurrentValue)
    },
    {   // 331 - ::SettingSliderData::mButtonIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SettingSliderData, mButtonIsActive)
    },
    {   // 332 - ::WhereAmIScreenDataData
        COURIER_DATA_ITEM_TYPE_ID(::WhereAmIScreenDataData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 333 - ::WhereAmIScreenDataData::mCurrentStreetInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::WhereAmIScreenDataData, mCurrentStreetInfo)
    },
    {   // 334 - ::WhereAmIScreenDataData::mCurrentCityInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::WhereAmIScreenDataData, mCurrentCityInfo)
    },
    {   // 335 - ::WhereAmIScreenDataData::mCurrentStreetRoadNrImage
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::WhereAmIScreenDataData, mCurrentStreetRoadNrImage)
    },
    {   // 336 - ::WaypointListInfoData
        COURIER_DATA_ITEM_TYPE_ID(::WaypointListInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 337 - ::WaypointListInfoData::mWaypointListItem
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::WaypointListInfoData, mWaypointListItem)
    },
    {   // 338 - ::WaypointListInfoData::mWaypointNormalIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::WaypointListInfoData, mWaypointNormalIcon)
    },
    {   // 339 - ::WaypointListInfoData::mWaypointPressedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::WaypointListInfoData, mWaypointPressedIcon)
    },
    {   // 340 - ::GPSInfoData
        COURIER_DATA_ITEM_TYPE_ID(::GPSInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 341 - ::GPSInfoData::mDateValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mDateValue)
    },
    {   // 342 - ::GPSInfoData::mAltitudeValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mAltitudeValue)
    },
    {   // 343 - ::GPSInfoData::mCapturedSatelliteNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mCapturedSatelliteNumber)
    },
    {   // 344 - ::GPSInfoData::mSearchingSatelliteNumber
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mSearchingSatelliteNumber)
    },
    {   // 345 - ::GPSInfoData::mGnssModeType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mGnssModeType)
    },
    {   // 346 - ::GPSInfoData::mLatViaSensor
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mLatViaSensor)
    },
    {   // 347 - ::GPSInfoData::mLongViaSensor
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mLongViaSensor)
    },
    {   // 348 - ::GPSInfoData::mVisibleSatellite
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mVisibleSatellite)
    },
    {   // 349 - ::GPSInfoData::mGNSSTypeInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mGNSSTypeInfo)
    },
    {   // 350 - ::GPSInfoData::mTimeInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mTimeInfo)
    },
    {   // 351 - ::GPSInfoData::mHeadingInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mHeadingInfo)
    },
    {   // 352 - ::GPSInfoData::mGPSCoordinate
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::GPSInfoData, mGPSCoordinate)
    },
    {   // 353 - ::GPSInfoData::mGPSUnAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GPSInfoData, mGPSUnAvailable)
    },
    {   // 354 - ::GPSInfoData::mSatelliteIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GPSInfoData, mSatelliteIcon)
    },
    {   // 355 - ::GPSInfoData::mSatelliteIconVisibility
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GPSInfoData, mSatelliteIconVisibility)
    },
    {   // 356 - ::SwitchindexData
        COURIER_DATA_ITEM_TYPE_ID(::SwitchindexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 357 - ::SwitchindexData::mIndexValue
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::SwitchindexData, mIndexValue)
    },
    {   // 358 - ::LaneGuidanceData
        COURIER_DATA_ITEM_TYPE_ID(::LaneGuidanceData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 359 - ::LaneGuidanceData::mBitmapImage1
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage1)
    },
    {   // 360 - ::LaneGuidanceData::mBitmapImage2
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage2)
    },
    {   // 361 - ::LaneGuidanceData::mBitmapImage3
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage3)
    },
    {   // 362 - ::LaneGuidanceData::mBitmapImage4
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage4)
    },
    {   // 363 - ::LaneGuidanceData::mBitmapImage5
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage5)
    },
    {   // 364 - ::LaneGuidanceData::mBitmapImage6
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage6)
    },
    {   // 365 - ::LaneGuidanceData::mBitmapImage7
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage7)
    },
    {   // 366 - ::LaneGuidanceData::mBitmapImage8
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mBitmapImage8)
    },
    {   // 367 - ::LaneGuidanceData::mHovOccupancy
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::LaneGuidanceData, mHovOccupancy)
    },
    {   // 368 - ::RouteGuidancetextImageUpdationData
        COURIER_DATA_ITEM_TYPE_ID(::RouteGuidancetextImageUpdationData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 369 - ::RouteGuidancetextImageUpdationData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteGuidancetextImageUpdationData, mText)
    },
    {   // 370 - ::RouteGuidancetextImageUpdationData::mIcon_Normal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RouteGuidancetextImageUpdationData, mIcon_Normal)
    },
    {   // 371 - ::RouteGuidancetextImageUpdationData::mIcon_Pressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RouteGuidancetextImageUpdationData, mIcon_Pressed)
    },
    {   // 372 - ::TrafficMessagesData
        COURIER_DATA_ITEM_TYPE_ID(::TrafficMessagesData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 373 - ::TrafficMessagesData::mTrafficMessageText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficMessagesData, mTrafficMessageText)
    },
    {   // 374 - ::TrafficMessagesData::mDistanceInfo
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficMessagesData, mDistanceInfo)
    },
    {   // 375 - ::TrafficMessagesData::mDirectionIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::TrafficMessagesData, mDirectionIconActiveBitmap)
    },
    {   // 376 - ::TrafficMessagesData::mTrafficIconActiveBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::TrafficMessagesData, mTrafficIconActiveBitmap)
    },
    {   // 377 - ::POITitleData
        COURIER_DATA_ITEM_TYPE_ID(::POITitleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 378 - ::POITitleData::mPOITitleValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POITitleData, mPOITitleValue)
    },
    {   // 379 - ::POITopCategoryTitleData
        COURIER_DATA_ITEM_TYPE_ID(::POITopCategoryTitleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 380 - ::POITopCategoryTitleData::mPOITopCategoryTitleValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::POITopCategoryTitleData, mPOITopCategoryTitleValue)
    },
    {   // 381 - ::PreviousDestCountData
        COURIER_DATA_ITEM_TYPE_ID(::PreviousDestCountData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 382 - ::PreviousDestCountData::mTotalPreviousDestCount
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::PreviousDestCountData, mTotalPreviousDestCount)
    },
    {   // 383 - ::HeaderTimeData
        COURIER_DATA_ITEM_TYPE_ID(::HeaderTimeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 384 - ::HeaderTimeData::mText
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::HeaderTimeData, mText)
    },
    {   // 385 - ::HardRestrictionData
        COURIER_DATA_ITEM_TYPE_ID(::HardRestrictionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 386 - ::HardRestrictionData::mIsFullRGEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::HardRestrictionData, mIsFullRGEnabled)
    },
    {   // 387 - ::TimeDisplayData
        COURIER_DATA_ITEM_TYPE_ID(::TimeDisplayData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 388 - ::TimeDisplayData::mHour
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TimeDisplayData, mHour)
    },
    {   // 389 - ::TimeDisplayData::mMinute
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TimeDisplayData, mMinute)
    },
    {   // 390 - ::StreamMapContentData
        COURIER_DATA_ITEM_TYPE_ID(::StreamMapContentData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 391 - ::StreamMapContentData::mLatitude
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mLatitude)
    },
    {   // 392 - ::StreamMapContentData::mLongtitude
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mLongtitude)
    },
    {   // 393 - ::StreamMapContentData::mSpeed
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mSpeed)
    },
    {   // 394 - ::StreamMapContentData::mNextMajorStation
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mNextMajorStation)
    },
    {   // 395 - ::StreamMapContentData::mIsLatitudeEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mIsLatitudeEnabled)
    },
    {   // 396 - ::StreamMapContentData::mIsLongtitudeEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mIsLongtitudeEnabled)
    },
    {   // 397 - ::StreamMapContentData::mIsSpeedEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mIsSpeedEnabled)
    },
    {   // 398 - ::StreamMapContentData::mIsNextMajorStationEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StreamMapContentData, mIsNextMajorStationEnabled)
    },
    {   // 399 - ::NavDataPopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::NavDataPopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 400 - ::NavDataPopupTextData::mCurrentNavDataVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mCurrentNavDataVersion)
    },
    {   // 401 - ::NavDataPopupTextData::mNewNavDataVersion
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mNewNavDataVersion)
    },
    {   // 402 - ::NavDataPopupTextData::mEstimatedUpdateTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mEstimatedUpdateTime)
    },
    {   // 403 - ::NavDataPopupTextData::mRemainingTime
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mRemainingTime)
    },
    {   // 404 - ::NavDataPopupTextData::mErrorMsgLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mErrorMsgLine1)
    },
    {   // 405 - ::NavDataPopupTextData::mProgressValue
        COURIER_DATA_ITEM_TYPE_ID(Candera::UInt32),
        COURIER_ITEM_MEMBER(::NavDataPopupTextData, mProgressValue)
    },
    {   // 406 - ::AlternativeRouteItemsData
        COURIER_DATA_ITEM_TYPE_ID(::AlternativeRouteItemsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 407 - ::AlternativeRouteItemsData::mDistanceToDestinationFirst
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mDistanceToDestinationFirst)
    },
    {   // 408 - ::AlternativeRouteItemsData::mDistanceToDestinationSecond
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mDistanceToDestinationSecond)
    },
    {   // 409 - ::AlternativeRouteItemsData::mDistanceToDestinationThird
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mDistanceToDestinationThird)
    },
    {   // 410 - ::AlternativeRouteItemsData::mTimeToDestinationFirst
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mTimeToDestinationFirst)
    },
    {   // 411 - ::AlternativeRouteItemsData::mTimeToDestinationSecond
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mTimeToDestinationSecond)
    },
    {   // 412 - ::AlternativeRouteItemsData::mTimeToDestinationThird
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mTimeToDestinationThird)
    },
    {   // 413 - ::AlternativeRouteItemsData::mMoreRouteFirstBtnActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteFirstBtnActive)
    },
    {   // 414 - ::AlternativeRouteItemsData::mMoreRouteSecondBtnActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteSecondBtnActive)
    },
    {   // 415 - ::AlternativeRouteItemsData::mMoreRouteThirdBtnActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteThirdBtnActive)
    },
    {   // 416 - ::AlternativeRouteItemsData::mMoreRouteFirstBtnEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteFirstBtnEnabled)
    },
    {   // 417 - ::AlternativeRouteItemsData::mMoreRouteSecondBtnEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteSecondBtnEnabled)
    },
    {   // 418 - ::AlternativeRouteItemsData::mMoreRouteThirdBtnEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteThirdBtnEnabled)
    },
    {   // 419 - ::AlternativeRouteItemsData::mMoreRouteFirstBtnLoading
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteFirstBtnLoading)
    },
    {   // 420 - ::AlternativeRouteItemsData::mMoreRouteSecondBtnLoading
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteSecondBtnLoading)
    },
    {   // 421 - ::AlternativeRouteItemsData::mMoreRouteThirdBtnLoading
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteThirdBtnLoading)
    },
    {   // 422 - ::AlternativeRouteItemsData::mMoreRouteFirstBtnTouchable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteFirstBtnTouchable)
    },
    {   // 423 - ::AlternativeRouteItemsData::mMoreRouteSecondBtnTouchable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteSecondBtnTouchable)
    },
    {   // 424 - ::AlternativeRouteItemsData::mMoreRouteThirdBtnTouchable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::AlternativeRouteItemsData, mMoreRouteThirdBtnTouchable)
    },
    {   // 425 - ::RouteSwitchbtnData
        COURIER_DATA_ITEM_TYPE_ID(::RouteSwitchbtnData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 426 - ::RouteSwitchbtnData::mIsAlternativeRouteBtnEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::RouteSwitchbtnData, mIsAlternativeRouteBtnEnabled)
    },
    {   // 427 - ::GuidanceRouteSwitchbtnData
        COURIER_DATA_ITEM_TYPE_ID(::GuidanceRouteSwitchbtnData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 428 - ::GuidanceRouteSwitchbtnData::mButtonIsActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::GuidanceRouteSwitchbtnData, mButtonIsActive)
    },
    {   // 429 - ::GuidanceRouteSwitchbtnData::mNaviIconNormal
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GuidanceRouteSwitchbtnData, mNaviIconNormal)
    },
    {   // 430 - ::GuidanceRouteSwitchbtnData::mNaviIconPressed
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GuidanceRouteSwitchbtnData, mNaviIconPressed)
    },
    {   // 431 - ::GuidanceRouteSwitchbtnData::mNaviIconDisabled
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::GuidanceRouteSwitchbtnData, mNaviIconDisabled)
    },
    {   // 432 - ::TrafficDetourDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::TrafficDetourDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 433 - ::TrafficDetourDetailsData::mTimeDifference
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mTimeDifference)
    },
    {   // 434 - ::TrafficDetourDetailsData::mDistanceDifference
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mDistanceDifference)
    },
    {   // 435 - ::TrafficDetourDetailsData::mDistanceToTraffic
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mDistanceToTraffic)
    },
    {   // 436 - ::TrafficDetourDetailsData::mTrafficIncidentDetails
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mTrafficIncidentDetails)
    },
    {   // 437 - ::TrafficDetourDetailsData::mTrafficIncidentName
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mTrafficIncidentName)
    },
    {   // 438 - ::TrafficDetourDetailsData::mTrafficIncidentIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mTrafficIncidentIcon)
    },
    {   // 439 - ::TrafficDetourDetailsData::mHasTrafficMessageDescription
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::TrafficDetourDetailsData, mHasTrafficMessageDescription)
    },
    {   // 440 - ::XUrgentTrafficMessageData
        COURIER_DATA_ITEM_TYPE_ID(::XUrgentTrafficMessageData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 441 - ::XUrgentTrafficMessageData::mTrafficIncidentIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::XUrgentTrafficMessageData, mTrafficIncidentIcon)
    },
    {   // 442 - ::XUrgentTrafficMessageData::mDirection
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::XUrgentTrafficMessageData, mDirection)
    },
    {   // 443 - ::XUrgentTrafficMessageData::mDistance
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::XUrgentTrafficMessageData, mDistance)
    },
    {   // 444 - ::XUrgentTrafficMessageData::mDetails
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::XUrgentTrafficMessageData, mDetails)
    },
    {   // 445 - ::EngineeringMenuDetailsData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringMenuDetailsData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 446 - ::EngineeringMenuDetailsData::mEngineeringMenuTextDetails
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringMenuDetailsData, mEngineeringMenuTextDetails)
    },
    {   // 447 - ::EngineeringMenuDetailsData::mIsDemoModeEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EngineeringMenuDetailsData, mIsDemoModeEnabled)
    },
    {   // 448 - ::EngineeringMenuTitleData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringMenuTitleData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 449 - ::EngineeringMenuTitleData::mTitleDetail
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::EngineeringMenuTitleData, mTitleDetail)
    },
    {   // 450 - ::EngineeringMenuListCheckData
        COURIER_DATA_ITEM_TYPE_ID(::EngineeringMenuListCheckData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 451 - ::EngineeringMenuListCheckData::mEngineeringMenuListStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EngineeringMenuListCheckData, mEngineeringMenuListStatus)
    },
    {   // 452 - ::EngineeringMenuListCheckData::mEngineeringMenuTopListStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::EngineeringMenuListCheckData, mEngineeringMenuTopListStatus)
    },
    {   // 453 - ::VehicleProfileInfoData
        COURIER_DATA_ITEM_TYPE_ID(::VehicleProfileInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 454 - ::VehicleProfileInfoData::mPosition
        COURIER_DATA_ITEM_TYPE_ID(Candera::Vector2),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mPosition)
    },
    {   // 455 - ::VehicleProfileInfoData::mLength
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mLength)
    },
    {   // 456 - ::VehicleProfileInfoData::mHeight
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mHeight)
    },
    {   // 457 - ::VehicleProfileInfoData::mWidth
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mWidth)
    },
    {   // 458 - ::VehicleProfileInfoData::mTotalWeight
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mTotalWeight)
    },
    {   // 459 - ::VehicleProfileInfoData::mTrailerType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mTrailerType)
    },
    {   // 460 - ::VehicleProfileInfoData::mMaxSpeed
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mMaxSpeed)
    },
    {   // 461 - ::VehicleProfileInfoData::mGoodsType
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mGoodsType)
    },
    {   // 462 - ::VehicleProfileInfoData::mLoadPerAxle
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mLoadPerAxle)
    },
    {   // 463 - ::VehicleProfileInfoData::mIsTruckType
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mIsTruckType)
    },
    {   // 464 - ::VehicleProfileInfoData::mCoachActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mCoachActive)
    },
    {   // 465 - ::VehicleProfileInfoData::mCarActive
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mCarActive)
    },
    {   // 466 - ::VehicleProfileInfoData::mIconNormalBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mIconNormalBitmap)
    },
    {   // 467 - ::VehicleProfileInfoData::mIconPressedBitmap
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::VehicleProfileInfoData, mIconPressedBitmap)
    },
    {   // 468 - ::StreamedMapSettingData
        COURIER_DATA_ITEM_TYPE_ID(::StreamedMapSettingData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 469 - ::StreamedMapSettingData::mStreamedMapTypeSettingStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::StreamedMapSettingData, mStreamedMapTypeSettingStatus)
    },
    {   // 470 - ::MyPOIsAvailabilityData
        COURIER_DATA_ITEM_TYPE_ID(::MyPOIsAvailabilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 471 - ::MyPOIsAvailabilityData::mIsMyPOIsAvailable
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MyPOIsAvailabilityData, mIsMyPOIsAvailable)
    },
    {   // 472 - ::RouteOptionsBorderData
        COURIER_DATA_ITEM_TYPE_ID(::RouteOptionsBorderData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 473 - ::RouteOptionsBorderData::mFastestIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RouteOptionsBorderData, mFastestIcon)
    },
    {   // 474 - ::RouteOptionsBorderData::mShortestIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RouteOptionsBorderData, mShortestIcon)
    },
    {   // 475 - ::RouteOptionsBorderData::mOptimisedIcon
        COURIER_DATA_ITEM_TYPE_ID(Candera::MemoryManagement::SharedPointer<Candera::Image2D>),
        COURIER_ITEM_MEMBER(::RouteOptionsBorderData, mOptimisedIcon)
    },
    {   // 476 - ::RouteRestrictionsPopupTextData
        COURIER_DATA_ITEM_TYPE_ID(::RouteRestrictionsPopupTextData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 477 - ::RouteRestrictionsPopupTextData::mTextLine1
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteRestrictionsPopupTextData, mTextLine1)
    },
    {   // 478 - ::RouteRestrictionsPopupTextData::mTextLine2
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteRestrictionsPopupTextData, mTextLine2)
    },
    {   // 479 - ::RouteRestrictionsPopupTextData::mTextLine3
        COURIER_DATA_ITEM_TYPE_ID(Candera::String),
        COURIER_ITEM_MEMBER(::RouteRestrictionsPopupTextData, mTextLine3)
    },
    {   // 480 - ::SoftRestrictionData
        COURIER_DATA_ITEM_TYPE_ID(::SoftRestrictionData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 481 - ::SoftRestrictionData::mIsSoftPhysicalRestriction
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::SoftRestrictionData, mIsSoftPhysicalRestriction)
    },
    {   // 482 - ::MapOptionOthersSettingData
        COURIER_DATA_ITEM_TYPE_ID(::MapOptionOthersSettingData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 483 - ::MapOptionOthersSettingData::mMapOptionOthersSettingStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::MapOptionOthersSettingData, mMapOptionOthersSettingStatus)
    },
    {   // 484 - ::SwitchVehicleParameterindexData
        COURIER_DATA_ITEM_TYPE_ID(::SwitchVehicleParameterindexData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 485 - ::SwitchVehicleParameterindexData::mIndexValue
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::SwitchVehicleParameterindexData, mIndexValue)
    },
    {   // 486 - ::VehicleProfileTypeData
        COURIER_DATA_ITEM_TYPE_ID(::VehicleProfileTypeData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 487 - ::VehicleProfileTypeData::mProfile
        COURIER_DATA_ITEM_TYPE_ID(Courier::UInt8),
        COURIER_ITEM_MEMBER(::VehicleProfileTypeData, mProfile)
    },
    {   // 488 - ::ListScrollBarInfoData
        COURIER_DATA_ITEM_TYPE_ID(::ListScrollBarInfoData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 489 - ::ListScrollBarInfoData::mEnabled
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::ListScrollBarInfoData, mEnabled)
    },
    {   // 490 - ::CarModeVisibilityData
        COURIER_DATA_ITEM_TYPE_ID(::CarModeVisibilityData),
        COURIER_NULL_ITEM_MEMBER()
    },
    {   // 491 - ::CarModeVisibilityData::mVisibleStatus
        COURIER_DATA_ITEM_TYPE_ID(bool),
        COURIER_ITEM_MEMBER(::CarModeVisibilityData, mVisibleStatus)
    },
};

// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gInvalidHierarchyNodes[InvalidDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00000000, /Invalid),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 0,
        /* mParentIndex        */ 0,    // ItemKey::InvalidItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 0,    // ::InvalidData
        /* mItemKey            */ 0
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSignpostTextHierarchyNodes[SignpostTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x52745DDD, /SignpostText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 1,    // ::SignpostTextData
        /* mItemKey            */ 162
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x22AABE0D, /SignpostText/Signpostfirstline),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 2,    // ::SignpostTextData::mSignpostfirstline
        /* mItemKey            */ 68
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x27F48898, /SignpostText/Signpostsecondline),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 3,    // ::SignpostTextData::mSignpostsecondline
        /* mItemKey            */ 76
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE51A80F0, /SignpostText/TextLinesColor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 4,    // ::SignpostTextData::mTextLinesColor
        /* mItemKey            */ 450
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA5B8DEFA, /SignpostText/BackgroundImageColor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode) | ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::ReadOnly),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 5,    // ::SignpostTextData::mBackgroundImageColor
        /* mItemKey            */ 317
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x346047DC, /SignpostText/ExitNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 6,    // ::SignpostTextData::mExitNumber
        /* mItemKey            */ 101
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x93D23C39, /SignpostText/ExitNumberPositioning),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 7,    // ::SignpostTextData::mExitNumberPositioning
        /* mItemKey            */ 287
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF95648F9, /SignpostText/SignpostActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 8,    // ::SignpostTextData::mSignpostActive
        /* mItemKey            */ 481
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB7DB4322, /SignpostText/ExitNumberExists),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 9,    // ::SignpostTextData::mExitNumberExists
        /* mItemKey            */ 359
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D855A02, /SignpostText/SignpostRegionType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 10,    // ::SignpostTextData::mSignpostRegionType
        /* mItemKey            */ 278
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9E4DBEC3, /SignpostText/SignpostDirectionName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 11,    // ::SignpostTextData::mSignpostDirectionName
        /* mItemKey            */ 302
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x72A406A7, /SignpostText/SignpostPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 1,
        /* mParentIndex        */ 0,    // ItemKey::SignpostTextItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 12,    // ::SignpostTextData::mSignpostPosition
        /* mItemKey            */ 224
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gHlgImageDataHierarchyNodes[HlgImageDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x30F32ACB, /HlgImageData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::HlgImageDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 13,    // ::HlgImageDataData
        /* mItemKey            */ 95
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x39ECAA3D, /HlgImageData/HlgImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::HlgImageDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 14,    // ::HlgImageDataData::mHlgImage
        /* mItemKey            */ 108
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x281DCDCB, /HlgImageData/HlgImageVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::HlgImageDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 15,    // ::HlgImageDataData::mHlgImageVisible
        /* mItemKey            */ 77
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x35962022, /HlgImageData/ToggleLaneGuidanceVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 2,
        /* mParentIndex        */ 0,    // ItemKey::HlgImageDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 16,    // ::HlgImageDataData::mToggleLaneGuidanceVisibility
        /* mItemKey            */ 103
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRoadIconsHierarchyNodes[RoadIconsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1A8717BC, /RoadIcons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::RoadIconsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 17,    // ::RoadIconsData
        /* mItemKey            */ 48
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC540C6E6, /RoadIcons/RoadIconImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 3,
        /* mParentIndex        */ 0,    // ItemKey::RoadIconsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 18,    // ::RoadIconsData::mRoadIconImage
        /* mItemKey            */ 379
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapModeHierarchyNodes[MapModeDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC3BC3D7A, /MapMode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::MapModeItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 19,    // ::MapModeData
        /* mItemKey            */ 375
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD837CD32, /MapMode/IsDayModeActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 4,
        /* mParentIndex        */ 0,    // ItemKey::MapModeItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 20,    // ::MapModeData::mIsDayModeActive
        /* mItemKey            */ 422
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBTTetheringStateHierarchyNodes[BTTetheringStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x204B2DD4, /BTTetheringState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::BTTetheringStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 21,    // ::BTTetheringStateData
        /* mItemKey            */ 60
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x85A98E2C, /BTTetheringState/TetheringIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 5,
        /* mParentIndex        */ 0,    // ItemKey::BTTetheringStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 22,    // ::BTTetheringStateData::mTetheringIndex
        /* mItemKey            */ 262
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressInputValueHierarchyNodes[AddressInputValueDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F0B9513, /AddressInputValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 23,    // ::AddressInputValueData
        /* mItemKey            */ 25
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC31E0032, /AddressInputValue/Country),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 24,    // ::AddressInputValueData::mCountry
        /* mItemKey            */ 372
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC609082B, /AddressInputValue/State),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 25,    // ::AddressInputValueData::mState
        /* mItemKey            */ 382
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAFF2C5B5, /AddressInputValue/City),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 26,    // ::AddressInputValueData::mCity
        /* mItemKey            */ 337
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x82EBDAB7, /AddressInputValue/Street),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 27,    // ::AddressInputValueData::mStreet
        /* mItemKey            */ 258
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0DD5BE05, /AddressInputValue/Housenum),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 28,    // ::AddressInputValueData::mHousenum
        /* mItemKey            */ 22
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AEAE8C1, /AddressInputValue/Intersection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 6,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValueItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 29,    // ::AddressInputValueData::mIntersection
        /* mItemKey            */ 200
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gChangeCountryButtonHierarchyNodes[ChangeCountryButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0235C879, /ChangeCountryButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::ChangeCountryButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 30,    // ::ChangeCountryButtonData
        /* mItemKey            */ 10
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x778B3115, /ChangeCountryButton/IsVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::ChangeCountryButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 31,    // ::ChangeCountryButtonData::mIsVisible
        /* mItemKey            */ 233
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19CD1367, /ChangeCountryButton/CountryIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 7,
        /* mParentIndex        */ 0,    // ItemKey::ChangeCountryButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 32,    // ::ChangeCountryButtonData::mCountryIcon
        /* mItemKey            */ 46
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPreviousDestinationValHierarchyNodes[PreviousDestinationValDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x70A7CCF8, /PreviousDestinationVal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::PreviousDestinationValItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 33,    // ::PreviousDestinationValData
        /* mItemKey            */ 214
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2048C7AB, /PreviousDestinationVal/POIaddress),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 8,
        /* mParentIndex        */ 0,    // ItemKey::PreviousDestinationValItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 34,    // ::PreviousDestinationValData::mPOIaddress
        /* mItemKey            */ 59
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gVariantButtonHierarchyNodes[VariantButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B1AD7A5, /VariantButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::VariantButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 35,    // ::VariantButtonData
        /* mItemKey            */ 203
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB10A9250, /VariantButton/VisibleCountry),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::VariantButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 36,    // ::VariantButtonData::mVisibleCountry
        /* mItemKey            */ 340
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7034CC57, /VariantButton/VisibleState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::VariantButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 37,    // ::VariantButtonData::mVisibleState
        /* mItemKey            */ 212
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF4B1D5C2, /VariantButton/VisibleProvince),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 9,
        /* mParentIndex        */ 0,    // ItemKey::VariantButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 38,    // ::VariantButtonData::mVisibleProvince
        /* mItemKey            */ 472
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gDEDisableButtonHierarchyNodes[DEDisableButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x078C3A08, /DEDisableButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 39,    // ::DEDisableButtonData
        /* mItemKey            */ 16
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6421F8BC, /DEDisableButton/City),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 40,    // ::DEDisableButtonData::mCity
        /* mItemKey            */ 188
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71A7D55C, /DEDisableButton/Street),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 41,    // ::DEDisableButtonData::mStreet
        /* mItemKey            */ 219
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0007E780, /DEDisableButton/InterSection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 42,    // ::DEDisableButtonData::mInterSection
        /* mItemKey            */ 1
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3BDC028, /DEDisableButton/Housenum),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 43,    // ::DEDisableButtonData::mHousenum
        /* mItemKey            */ 416
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEB2F6548, /DEDisableButton/Details),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 44,    // ::DEDisableButtonData::mDetails
        /* mItemKey            */ 458
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x16FD8B47, /DEDisableButton/Guidance),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 45,    // ::DEDisableButtonData::mGuidance
        /* mItemKey            */ 40
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x84F845BD, /DEDisableButton/POISearch),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 10,
        /* mParentIndex        */ 0,    // ItemKey::DEDisableButtonItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 46,    // ::DEDisableButtonData::mPOISearch
        /* mItemKey            */ 261
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressInputValPOIHierarchyNodes[AddressInputValPOIDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD376758A, /AddressInputValPOI),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValPOIItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 47,    // ::AddressInputValPOIData
        /* mItemKey            */ 412
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3F2B10AB, /AddressInputValPOI/Country),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValPOIItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 48,    // ::AddressInputValPOIData::mCountry
        /* mItemKey            */ 118
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F065117, /AddressInputValPOI/City),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValPOIItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 49,    // ::AddressInputValPOIData::mCity
        /* mItemKey            */ 178
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6AF5027F, /AddressInputValPOI/POISearch),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 11,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValPOIItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 50,    // ::AddressInputValPOIData::mPOISearch
        /* mItemKey            */ 201
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressInputValDetailsHierarchyNodes[AddressInputValDetailsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF9CCA6A3, /AddressInputValDetails),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 51,    // ::AddressInputValDetailsData
        /* mItemKey            */ 482
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23CCF648, /AddressInputValDetails/Line1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 52,    // ::AddressInputValDetailsData::mLine1
        /* mItemKey            */ 71
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFD1AA8E4, /AddressInputValDetails/Line2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 53,    // ::AddressInputValDetailsData::mLine2
        /* mItemKey            */ 487
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x47DABE5F, /AddressInputValDetails/Line3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 54,    // ::AddressInputValDetailsData::mLine3
        /* mItemKey            */ 140
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x319B91E1, /AddressInputValDetails/Line4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 55,    // ::AddressInputValDetailsData::mLine4
        /* mItemKey            */ 96
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x21779EF7, /AddressInputValDetails/POIAmbiguousDetails2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 12,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputValDetailsItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 56,    // ::AddressInputValDetailsData::mPOIAmbiguousDetails2
        /* mItemKey            */ 62
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaceInfoButtonsHierarchyNodes[PlaceInfoButtonsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0221B709, /PlaceInfoButtons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoButtonsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 57,    // ::PlaceInfoButtonsData
        /* mItemKey            */ 9
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB22722F4, /PlaceInfoButtons/GoHereVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 13,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoButtonsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 58,    // ::PlaceInfoButtonsData::mGoHereVisibility
        /* mItemKey            */ 343
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPlaceInfoDetailsHierarchyNodes[PlaceInfoDetailsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x550BA81A, /PlaceInfoDetails),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoDetailsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 59,    // ::PlaceInfoDetailsData
        /* mItemKey            */ 163
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA655E75C, /PlaceInfoDetails/Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoDetailsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 60,    // ::PlaceInfoDetailsData::mName
        /* mItemKey            */ 319
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBA19DE07, /PlaceInfoDetails/Address),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoDetailsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 61,    // ::PlaceInfoDetailsData::mAddress
        /* mItemKey            */ 363
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE320E9C1, /PlaceInfoDetails/Phonenumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoDetailsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 62,    // ::PlaceInfoDetailsData::mPhonenumber
        /* mItemKey            */ 445
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44252DA0, /PlaceInfoDetails/Line4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 14,
        /* mParentIndex        */ 0,    // ItemKey::PlaceInfoDetailsItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 63,    // ::PlaceInfoDetailsData::mLine4
        /* mItemKey            */ 126
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTwoLinePopuptextHierarchyNodes[TwoLinePopuptextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9EEF7E37, /TwoLinePopuptext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::TwoLinePopuptextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 64,    // ::TwoLinePopuptextData
        /* mItemKey            */ 303
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC5E33A5E, /TwoLinePopuptext/PopuptextLine1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::TwoLinePopuptextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 65,    // ::TwoLinePopuptextData::mPopuptextLine1
        /* mItemKey            */ 381
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB2751382, /TwoLinePopuptext/PopuptextLine2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 15,
        /* mParentIndex        */ 0,    // ItemKey::TwoLinePopuptextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 66,    // ::TwoLinePopuptextData::mPopuptextLine2
        /* mItemKey            */ 345
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMultiLinePopuptextHierarchyNodes[MultiLinePopuptextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA344AAB6, /MultiLinePopuptext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopuptextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 67,    // ::MultiLinePopuptextData
        /* mItemKey            */ 308
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4CA1E2D3, /MultiLinePopuptext/TextLine1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopuptextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 68,    // ::MultiLinePopuptextData::mTextLine1
        /* mItemKey            */ 150
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x19EE7D69, /MultiLinePopuptext/TextLine2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 16,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopuptextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 69,    // ::MultiLinePopuptextData::mTextLine2
        /* mItemKey            */ 47
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gThreeLinePopuptextHierarchyNodes[ThreeLinePopuptextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x48DC100D, /ThreeLinePopuptext),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ThreeLinePopuptextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 70,    // ::ThreeLinePopuptextData
        /* mItemKey            */ 141
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD1163831, /ThreeLinePopuptext/TextLine1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ThreeLinePopuptextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 71,    // ::ThreeLinePopuptextData::mTextLine1
        /* mItemKey            */ 406
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5198B938, /ThreeLinePopuptext/TextLine2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ThreeLinePopuptextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 72,    // ::ThreeLinePopuptextData::mTextLine2
        /* mItemKey            */ 159
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5FFDD602, /ThreeLinePopuptext/TextLine3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 17,
        /* mParentIndex        */ 0,    // ItemKey::ThreeLinePopuptextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 73,    // ::ThreeLinePopuptextData::mTextLine3
        /* mItemKey            */ 181
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRouteInfoPopupTextHierarchyNodes[RouteInfoPopupTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6EA42EFB, /RouteInfoPopupText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::RouteInfoPopupTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 74,    // ::RouteInfoPopupTextData
        /* mItemKey            */ 210
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x362B463B, /RouteInfoPopupText/TextLine1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::RouteInfoPopupTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 75,    // ::RouteInfoPopupTextData::mTextLine1
        /* mItemKey            */ 105
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x747542D2, /RouteInfoPopupText/TextLine2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 18,
        /* mParentIndex        */ 0,    // ItemKey::RouteInfoPopupTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 76,    // ::RouteInfoPopupTextData::mTextLine2
        /* mItemKey            */ 228
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFourLinePopupTextHierarchyNodes[FourLinePopupTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x77BA0D1F, /FourLinePopupText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::FourLinePopupTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 77,    // ::FourLinePopupTextData
        /* mItemKey            */ 234
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x692B9FF5, /FourLinePopupText/MultiLineText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 19,
        /* mParentIndex        */ 0,    // ItemKey::FourLinePopupTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 78,    // ::FourLinePopupTextData::mMultiLineText
        /* mItemKey            */ 198
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFiveLinePopupTextHierarchyNodes[FiveLinePopupTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC89B6DF3, /FiveLinePopupText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 79,    // ::FiveLinePopupTextData
        /* mItemKey            */ 389
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91AADC8E, /FiveLinePopupText/PopupTextLine1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 80,    // ::FiveLinePopupTextData::mPopupTextLine1
        /* mItemKey            */ 283
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x94FAE32E, /FiveLinePopupText/PopupTextLine2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 81,    // ::FiveLinePopupTextData::mPopupTextLine2
        /* mItemKey            */ 291
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5F7F7824, /FiveLinePopupText/PopupTextLine3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 82,    // ::FiveLinePopupTextData::mPopupTextLine3
        /* mItemKey            */ 179
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF2261D73, /FiveLinePopupText/PopupTextLine4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 83,    // ::FiveLinePopupTextData::mPopupTextLine4
        /* mItemKey            */ 470
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2B090F38, /FiveLinePopupText/PopupTextLine5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 20,
        /* mParentIndex        */ 0,    // ItemKey::FiveLinePopupTextItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 84,    // ::FiveLinePopupTextData::mPopupTextLine5
        /* mItemKey            */ 84
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpellerPressedKeyInfoHierarchyNodes[SpellerPressedKeyInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF7FE67E3, /SpellerPressedKeyInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::SpellerPressedKeyInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 85,    // ::SpellerPressedKeyInfoData
        /* mItemKey            */ 477
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x05DB55E2, /SpellerPressedKeyInfo/PressedKey),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 21,
        /* mParentIndex        */ 0,    // ItemKey::SpellerPressedKeyInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 86,    // ::SpellerPressedKeyInfoData::mPressedKey
        /* mItemKey            */ 12
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpellerPagesHierarchyNodes[SpellerPagesDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x47913912, /SpellerPages),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SpellerPagesItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 87,    // ::SpellerPagesData
        /* mItemKey            */ 139
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8110C3D6, /SpellerPages/SpellerPageNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 22,
        /* mParentIndex        */ 0,    // ItemKey::SpellerPagesItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 88,    // ::SpellerPagesData::mSpellerPageNumber
        /* mItemKey            */ 252
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpellerTextInfoHierarchyNodes[SpellerTextInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9452958C, /SpellerTextInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::SpellerTextInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 89,    // ::SpellerTextInfoData
        /* mItemKey            */ 290
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x60FC3E2F, /SpellerTextInfo/Text),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 23,
        /* mParentIndex        */ 0,    // ItemKey::SpellerTextInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 90,    // ::SpellerTextInfoData::mText
        /* mItemKey            */ 184
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNaviSpellerInfoHierarchyNodes[NaviSpellerInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x14681E39, /NaviSpellerInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::NaviSpellerInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 91,    // ::NaviSpellerInfoData
        /* mItemKey            */ 35
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3ADC5A62, /NaviSpellerInfo/CountryCode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::NaviSpellerInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 92,    // ::NaviSpellerInfoData::mCountryCode
        /* mItemKey            */ 110
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4DF50CDC, /NaviSpellerInfo/LanguageCode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 24,
        /* mParentIndex        */ 0,    // ItemKey::NaviSpellerInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 93,    // ::NaviSpellerInfoData::mLanguageCode
        /* mItemKey            */ 154
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressEntryTitleTextHierarchyNodes[AddressEntryTitleTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x476C723E, /AddressEntryTitleText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::AddressEntryTitleTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 94,    // ::AddressEntryTitleTextData
        /* mItemKey            */ 136
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF50F7A61, /AddressEntryTitleText/TitleValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 25,
        /* mParentIndex        */ 0,    // ItemKey::AddressEntryTitleTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 95,    // ::AddressEntryTitleTextData::mTitleValue
        /* mItemKey            */ 473
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNaviMiddlewareStatusHierarchyNodes[NaviMiddlewareStatusDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x97AB9208, /NaviMiddlewareStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::NaviMiddlewareStatusItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 96,    // ::NaviMiddlewareStatusData
        /* mItemKey            */ 293
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8B0F1898, /NaviMiddlewareStatus/IsNaviMiddlewareActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 26,
        /* mParentIndex        */ 0,    // ItemKey::NaviMiddlewareStatusItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 97,    // ::NaviMiddlewareStatusData::mIsNaviMiddlewareActive
        /* mItemKey            */ 271
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gFreeTextListItemHierarchyNodes[FreeTextListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x650BAA55, /FreeTextListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::FreeTextListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 98,    // ::FreeTextListItemData
        /* mItemKey            */ 190
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD0814681, /FreeTextListItem/Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 27,
        /* mParentIndex        */ 0,    // ItemKey::FreeTextListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 99,    // ::FreeTextListItemData::mName
        /* mItemKey            */ 404
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSpellerEntryTextReceivedInfoHierarchyNodes[SpellerEntryTextReceivedInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4B8D817, /SpellerEntryTextReceivedInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 100,    // ::SpellerEntryTextReceivedInfoData
        /* mItemKey            */ 313
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0C3163A3, /SpellerEntryTextReceivedInfo/EntryText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 101,    // ::SpellerEntryTextReceivedInfoData::mEntryText
        /* mItemKey            */ 21
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEC95DCA3, /SpellerEntryTextReceivedInfo/SuggestedText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 102,    // ::SpellerEntryTextReceivedInfoData::mSuggestedText
        /* mItemKey            */ 460
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x77254C60, /SpellerEntryTextReceivedInfo/ValidChar),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 103,    // ::SpellerEntryTextReceivedInfoData::mValidChar
        /* mItemKey            */ 232
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE1542067, /SpellerEntryTextReceivedInfo/Matches),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 104,    // ::SpellerEntryTextReceivedInfoData::mMatches
        /* mItemKey            */ 440
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x021A764D, /SpellerEntryTextReceivedInfo/EnteredChar),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 105,    // ::SpellerEntryTextReceivedInfoData::mEnteredChar
        /* mItemKey            */ 8
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x62000B0C, /SpellerEntryTextReceivedInfo/CandidateListVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 106,    // ::SpellerEntryTextReceivedInfoData::mCandidateListVisibility
        /* mItemKey            */ 186
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8A3DAD5B, /SpellerEntryTextReceivedInfo/StateNameVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 28,
        /* mParentIndex        */ 0,    // ItemKey::SpellerEntryTextReceivedInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 107,    // ::SpellerEntryTextReceivedInfoData::mStateNameVisibility
        /* mItemKey            */ 268
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressEntryInputMatchesHierarchyNodes[AddressEntryInputMatchesDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD8C37751, /AddressEntryInputMatches),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::AddressEntryInputMatchesItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 108,    // ::AddressEntryInputMatchesData
        /* mItemKey            */ 424
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x931A5E7C, /AddressEntryInputMatches/NoOfMatches),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 29,
        /* mParentIndex        */ 0,    // ItemKey::AddressEntryInputMatchesItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 109,    // ::AddressEntryInputMatchesData::mNoOfMatches
        /* mItemKey            */ 285
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGuidanceBlockUnblockButtonHierarchyNodes[GuidanceBlockUnblockButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF195D6D4, /GuidanceBlockUnblockButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceBlockUnblockButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 110,    // ::GuidanceBlockUnblockButtonData
        /* mItemKey            */ 469
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x57FDEEA0, /GuidanceBlockUnblockButton/BlockUnblockText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceBlockUnblockButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 111,    // ::GuidanceBlockUnblockButtonData::mBlockUnblockText
        /* mItemKey            */ 168
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA76D6275, /GuidanceBlockUnblockButton/BlockUnblockNormalIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceBlockUnblockButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 112,    // ::GuidanceBlockUnblockButtonData::mBlockUnblockNormalIcon
        /* mItemKey            */ 322
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA4E36945, /GuidanceBlockUnblockButton/BlockUnblockPressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceBlockUnblockButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 113,    // ::GuidanceBlockUnblockButtonData::mBlockUnblockPressedIcon
        /* mItemKey            */ 314
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3D3177A6, /GuidanceBlockUnblockButton/BlockUnblockEnable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 30,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceBlockUnblockButtonItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 114,    // ::GuidanceBlockUnblockButtonData::mBlockUnblockEnable
        /* mItemKey            */ 112
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPOICategoryRootItemHierarchyNodes[POICategoryRootItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x55FC1E83, /POICategoryRootItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryRootItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 115,    // ::POICategoryRootItemData
        /* mItemKey            */ 165
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE3CACFE, /POICategoryRootItem/IconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryRootItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 116,    // ::POICategoryRootItemData::mIconNormalBitmap
        /* mItemKey            */ 399
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x39A3F2E0, /POICategoryRootItem/Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 31,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryRootItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 117,    // ::POICategoryRootItemData::mName
        /* mItemKey            */ 107
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gShowPOIsOnMapItemHierarchyNodes[ShowPOIsOnMapItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF7A18B90, /ShowPOIsOnMapItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::ShowPOIsOnMapItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 118,    // ::ShowPOIsOnMapItemData
        /* mItemKey            */ 475
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3E852C85, /ShowPOIsOnMapItem/IconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 32,
        /* mParentIndex        */ 0,    // ItemKey::ShowPOIsOnMapItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 119,    // ::ShowPOIsOnMapItemData::mIconNormalBitmap
        /* mItemKey            */ 115
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gShowRouteListItemHierarchyNodes[ShowRouteListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x55638FC9, /ShowRouteListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 120,    // ::ShowRouteListItemData
        /* mItemKey            */ 164
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x73DCB19F, /ShowRouteListItem/RouteListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 121,    // ::ShowRouteListItemData::mRouteListItem
        /* mItemKey            */ 226
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0F470B4A, /ShowRouteListItem/DistanceInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 122,    // ::ShowRouteListItemData::mDistanceInfo
        /* mItemKey            */ 26
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEE4FF755, /ShowRouteListItem/TurnIconActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 123,    // ::ShowRouteListItemData::mTurnIconActiveBitmap
        /* mItemKey            */ 462
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x453B3CBF, /ShowRouteListItem/RoadIconActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 124,    // ::ShowRouteListItemData::mRoadIconActiveBitmap
        /* mItemKey            */ 133
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00E6D863, /ShowRouteListItem/RouteSelectionActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 125,    // ::ShowRouteListItemData::mRouteSelectionActiveBitmap
        /* mItemKey            */ 5
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8804B275, /ShowRouteListItem/RouteList_BlockUnblockNormalIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 126,    // ::ShowRouteListItemData::mRouteList_BlockUnblockNormalIcon
        /* mItemKey            */ 264
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA375CA75, /ShowRouteListItem/RouteList_BlockUnblockPressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 33,
        /* mParentIndex        */ 0,    // ItemKey::ShowRouteListItemItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 127,    // ::ShowRouteListItemData::mRouteList_BlockUnblockPressedIcon
        /* mItemKey            */ 309
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gBlockRouteListItemHierarchyNodes[BlockRouteListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7DEE3095, /BlockRouteListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::BlockRouteListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 128,    // ::BlockRouteListItemData
        /* mItemKey            */ 247
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7D49BA3C, /BlockRouteListItem/RecalcEnableDisable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::BlockRouteListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 129,    // ::BlockRouteListItemData::mRecalcEnableDisable
        /* mItemKey            */ 245
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE39B085F, /BlockRouteListItem/RecalculateIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 34,
        /* mParentIndex        */ 0,    // ItemKey::BlockRouteListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 130,    // ::BlockRouteListItemData::mRecalculateIcon
        /* mItemKey            */ 446
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPOICategoryListItemHierarchyNodes[POICategoryListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x450AF22B, /POICategoryListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 131,    // ::POICategoryListItemData
        /* mItemKey            */ 130
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1F165AB4, /POICategoryListItem/DirectionIconActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 132,    // ::POICategoryListItemData::mDirectionIconActiveBitmap
        /* mItemKey            */ 55
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7B2207E6, /POICategoryListItem/DirectionIconActiveFocusesBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 133,    // ::POICategoryListItemData::mDirectionIconActiveFocusesBitmap
        /* mItemKey            */ 242
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3534935, /POICategoryListItem/DirectionIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 134,    // ::POICategoryListItemData::mDirectionIconNormalBitmap
        /* mItemKey            */ 411
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D911169, /POICategoryListItem/DirectionIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 135,    // ::POICategoryListItemData::mDirectionIconFocusedBitmap
        /* mItemKey            */ 177
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEED38822, /POICategoryListItem/DirectionIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 136,    // ::POICategoryListItemData::mDirectionIconPressedBitmap
        /* mItemKey            */ 464
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x81B7D342, /POICategoryListItem/Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 137,    // ::POICategoryListItemData::mName
        /* mItemKey            */ 254
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x51D5A993, /POICategoryListItem/Distance),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 138,    // ::POICategoryListItemData::mDistance
        /* mItemKey            */ 160
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8AB89F9E, /POICategoryListItem/Address),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 139,    // ::POICategoryListItemData::mAddress
        /* mItemKey            */ 269
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBEAEBDAA, /POICategoryListItem/Visible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 35,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryListItemItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 140,    // ::POICategoryListItemData::mVisible
        /* mItemKey            */ 367
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPOIDetailedInfoHierarchyNodes[POIDetailedInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC9E1E24, /POIDetailedInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::POIDetailedInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 141,    // ::POIDetailedInfoData
        /* mItemKey            */ 432
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9DDE0C0D, /POIDetailedInfo/Name),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::POIDetailedInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 142,    // ::POIDetailedInfoData::mName
        /* mItemKey            */ 301
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC3A4762C, /POIDetailedInfo/Address),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 36,
        /* mParentIndex        */ 0,    // ItemKey::POIDetailedInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 143,    // ::POIDetailedInfoData::mAddress
        /* mItemKey            */ 374
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPOICategoryBrowseCheckHierarchyNodes[POICategoryBrowseCheckDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1D85F6E3, /POICategoryBrowseCheck),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryBrowseCheckItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 144,    // ::POICategoryBrowseCheckData
        /* mItemKey            */ 53
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB6D640F1, /POICategoryBrowseCheck/POITopCategoryStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryBrowseCheckItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 145,    // ::POICategoryBrowseCheckData::mPOITopCategoryStatus
        /* mItemKey            */ 356
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1867FCC5, /POICategoryBrowseCheck/POIResultListStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 37,
        /* mParentIndex        */ 0,    // ItemKey::POICategoryBrowseCheckItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 146,    // ::POICategoryBrowseCheckData::mPOIResultListStatus
        /* mItemKey            */ 42
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gStoredLocationIconHierarchyNodes[StoredLocationIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x30422702, /StoredLocationIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 147,    // ::StoredLocationIconData
        /* mItemKey            */ 94
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x000EBF6E, /StoredLocationIcon/LocationIconActiveBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 148,    // ::StoredLocationIconData::mLocationIconActiveBitmap
        /* mItemKey            */ 2
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEA6A27B1, /StoredLocationIcon/LocationIconActiveFocusesBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 149,    // ::StoredLocationIconData::mLocationIconActiveFocusesBitmap
        /* mItemKey            */ 456
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3797F2E8, /StoredLocationIcon/LocationIconNormalBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 150,    // ::StoredLocationIconData::mLocationIconNormalBitmap
        /* mItemKey            */ 106
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCDAA47E3, /StoredLocationIcon/LocationIconFocusedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 151,    // ::StoredLocationIconData::mLocationIconFocusedBitmap
        /* mItemKey            */ 398
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4773E0FF, /StoredLocationIcon/LocationIconPressedBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 152,    // ::StoredLocationIconData::mLocationIconPressedBitmap
        /* mItemKey            */ 137
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4BBE37B5, /StoredLocationIcon/LocationNameInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 38,
        /* mParentIndex        */ 0,    // ItemKey::StoredLocationIconItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 153,    // ::StoredLocationIconData::mLocationNameInfo
        /* mItemKey            */ 147
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressDetailedInfoIconHierarchyNodes[AddressDetailedInfoIconDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x638F9EE6, /AddressDetailedInfoIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::AddressDetailedInfoIconItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 154,    // ::AddressDetailedInfoIconData
        /* mItemKey            */ 187
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8B2C279F, /AddressDetailedInfoIcon/Fav_EditNormalIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::AddressDetailedInfoIconItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 155,    // ::AddressDetailedInfoIconData::mFav_EditNormalIcon
        /* mItemKey            */ 272
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2C8DFCB3, /AddressDetailedInfoIcon/Fav_EditPressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::AddressDetailedInfoIconItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 156,    // ::AddressDetailedInfoIconData::mFav_EditPressedIcon
        /* mItemKey            */ 86
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x119A21D2, /AddressDetailedInfoIcon/DeleteIconButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::AddressDetailedInfoIconItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 157,    // ::AddressDetailedInfoIconData::mDeleteIconButtonVisibility
        /* mItemKey            */ 32
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x90BA709B, /AddressDetailedInfoIcon/DeleteAllIconButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 39,
        /* mParentIndex        */ 0,    // ItemKey::AddressDetailedInfoIconItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 158,    // ::AddressDetailedInfoIconData::mDeleteAllIconButtonVisibility
        /* mItemKey            */ 281
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gAddressInputButtonVisibilityHierarchyNodes[AddressInputButtonVisibilityDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x56F7590C, /AddressInputButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputButtonVisibilityItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 159,    // ::AddressInputButtonVisibilityData
        /* mItemKey            */ 166
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2A43CE1A, /AddressInputButtonVisibility/DetailInfoButtonVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputButtonVisibilityItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 160,    // ::AddressInputButtonVisibilityData::mDetailInfoButtonVisibility
        /* mItemKey            */ 82
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC8AA5923, /AddressInputButtonVisibility/Guidance_HomeNormalIconEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputButtonVisibilityItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 161,    // ::AddressInputButtonVisibilityData::mGuidance_HomeNormalIconEnabled
        /* mItemKey            */ 390
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x57248718, /AddressInputButtonVisibility/Guidance_HomePressedIconEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputButtonVisibilityItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 162,    // ::AddressInputButtonVisibilityData::mGuidance_HomePressedIconEnabled
        /* mItemKey            */ 167
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE42D07AB, /AddressInputButtonVisibility/Guidance_HomeIconDisabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 40,
        /* mParentIndex        */ 0,    // ItemKey::AddressInputButtonVisibilityItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 163,    // ::AddressInputButtonVisibilityData::mGuidance_HomeIconDisabled
        /* mItemKey            */ 448
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTrafficIconsHierarchyNodes[TrafficIconsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x79CFAB4F, /TrafficIcons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TrafficIconsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 164,    // ::TrafficIconsData
        /* mItemKey            */ 238
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x78D0461A, /TrafficIcons/TrafficIconName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TrafficIconsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 165,    // ::TrafficIconsData::mTrafficIconName
        /* mItemKey            */ 236
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF6E619E1, /TrafficIcons/TrafficIconImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TrafficIconsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 166,    // ::TrafficIconsData::mTrafficIconImage
        /* mItemKey            */ 474
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9CF148E5, /TrafficIcons/ToggleIconSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 41,
        /* mParentIndex        */ 0,    // ItemKey::TrafficIconsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 167,    // ::TrafficIconsData::mToggleIconSwitchIndex
        /* mItemKey            */ 300
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGuidanceSettingsHierarchyNodes[GuidanceSettingsDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE7FB90B1, /GuidanceSettings),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceSettingsItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 168,    // ::GuidanceSettingsData
        /* mItemKey            */ 455
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x40C6D7F9, /GuidanceSettings/CurrentGuidanceVolume),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceSettingsItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 169,    // ::GuidanceSettingsData::mCurrentGuidanceVolume
        /* mItemKey            */ 124
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB7390EED, /GuidanceSettings/GuidanceVoiceStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceSettingsItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 170,    // ::GuidanceSettingsData::mGuidanceVoiceStatus
        /* mItemKey            */ 358
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x28A586E5, /GuidanceSettings/TrafficAnnouncementStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceSettingsItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 171,    // ::GuidanceSettingsData::mTrafficAnnouncementStatus
        /* mItemKey            */ 79
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC3C21FDF, /GuidanceSettings/TollBothGuideStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 42,
        /* mParentIndex        */ 0,    // ItemKey::GuidanceSettingsItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 172,    // ::GuidanceSettingsData::mTollBothGuideStatus
        /* mItemKey            */ 376
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCheckBoxListItemHierarchyNodes[CheckBoxListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3928E76, /CheckBoxListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 173,    // ::CheckBoxListItemData
        /* mItemKey            */ 413
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE1ED37DF, /CheckBoxListItem/ListItemName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 174,    // ::CheckBoxListItemData::mListItemName
        /* mItemKey            */ 441
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB03A6D2C, /CheckBoxListItem/ToggleIconSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 43,
        /* mParentIndex        */ 0,    // ItemKey::CheckBoxListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 175,    // ::CheckBoxListItemData::mToggleIconSwitchIndex
        /* mItemKey            */ 338
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRoutePreferenceCheckBoxListItemHierarchyNodes[RoutePreferenceCheckBoxListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x712E70BB, /RoutePreferenceCheckBoxListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::RoutePreferenceCheckBoxListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 176,    // ::RoutePreferenceCheckBoxListItemData
        /* mItemKey            */ 215
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x68F50A30, /RoutePreferenceCheckBoxListItem/CheckBoxStatus),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 44,
        /* mParentIndex        */ 0,    // ItemKey::RoutePreferenceCheckBoxListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 177,    // ::RoutePreferenceCheckBoxListItemData::mCheckBoxStatus
        /* mItemKey            */ 196
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRoutePreferenceAdjustmentListItemHierarchyNodes[RoutePreferenceAdjustmentListItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6054B903, /RoutePreferenceAdjustmentListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::RoutePreferenceAdjustmentListItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 178,    // ::RoutePreferenceAdjustmentListItemData
        /* mItemKey            */ 182
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6C47BC57, /RoutePreferenceAdjustmentListItem/RouteTypeOption),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::RoutePreferenceAdjustmentListItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 179,    // ::RoutePreferenceAdjustmentListItemData::mRouteTypeOption
        /* mItemKey            */ 205
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEE37F167, /RoutePreferenceAdjustmentListItem/OptionValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 45,
        /* mParentIndex        */ 0,    // ItemKey::RoutePreferenceAdjustmentListItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 180,    // ::RoutePreferenceAdjustmentListItemData::mOptionValue
        /* mItemKey            */ 461
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNavigationGadgetInfoHierarchyNodes[NavigationGadgetInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF181F790, /NavigationGadgetInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::NavigationGadgetInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 181,    // ::NavigationGadgetInfoData
        /* mItemKey            */ 468
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB45E29F, /NavigationGadgetInfo/IsGuidanceActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::NavigationGadgetInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 182,    // ::NavigationGadgetInfoData::mIsGuidanceActive
        /* mItemKey            */ 395
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4AA2C5B0, /NavigationGadgetInfo/HomeTileStreetStr),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 46,
        /* mParentIndex        */ 0,    // ItemKey::NavigationGadgetInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 183,    // ::NavigationGadgetInfoData::mHomeTileStreetStr
        /* mItemKey            */ 144
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongSpellerPressedKeyInfoHierarchyNodes[LatLongSpellerPressedKeyInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9BA57FC9, /LatLongSpellerPressedKeyInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::LatLongSpellerPressedKeyInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 184,    // ::LatLongSpellerPressedKeyInfoData
        /* mItemKey            */ 299
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x331DC756, /LatLongSpellerPressedKeyInfo/PressedKey_LatLongEditField),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 47,
        /* mParentIndex        */ 0,    // ItemKey::LatLongSpellerPressedKeyInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 185,    // ::LatLongSpellerPressedKeyInfoData::mPressedKey_LatLongEditField
        /* mItemKey            */ 98
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongSpellerTextReceivedHierarchyNodes[LatLongSpellerTextReceivedDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC5A8118C, /LatLongSpellerTextReceived),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::LatLongSpellerTextReceivedItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 186,    // ::LatLongSpellerTextReceivedData
        /* mItemKey            */ 380
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x00AD47DD, /LatLongSpellerTextReceived/TextReceive_LatLongEditField),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 48,
        /* mParentIndex        */ 0,    // ItemKey::LatLongSpellerTextReceivedItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 187,    // ::LatLongSpellerTextReceivedData::mTextReceive_LatLongEditField
        /* mItemKey            */ 4
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongEditFieldBGImageItemHierarchyNodes[LatLongEditFieldBGImageItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB311715B, /LatLongEditFieldBGImageItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 188,    // ::LatLongEditFieldBGImageItemData
        /* mItemKey            */ 346
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x075EB40B, /LatLongEditFieldBGImageItem/LatitudeDegreesBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 189,    // ::LatLongEditFieldBGImageItemData::mLatitudeDegreesBGBitmap
        /* mItemKey            */ 15
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x20409A24, /LatLongEditFieldBGImageItem/LatitudeMinutesBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 190,    // ::LatLongEditFieldBGImageItemData::mLatitudeMinutesBGBitmap
        /* mItemKey            */ 58
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2D44285B, /LatLongEditFieldBGImageItem/LatitudeSecondsBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 191,    // ::LatLongEditFieldBGImageItemData::mLatitudeSecondsBGBitmap
        /* mItemKey            */ 87
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7395E6D5, /LatLongEditFieldBGImageItem/LatitudeDecimalsBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 192,    // ::LatLongEditFieldBGImageItemData::mLatitudeDecimalsBGBitmap
        /* mItemKey            */ 225
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x325F1A18, /LatLongEditFieldBGImageItem/LongitudeDegreesBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 193,    // ::LatLongEditFieldBGImageItemData::mLongitudeDegreesBGBitmap
        /* mItemKey            */ 97
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8210DEFE, /LatLongEditFieldBGImageItem/LongitudeMinutesBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 194,    // ::LatLongEditFieldBGImageItemData::mLongitudeMinutesBGBitmap
        /* mItemKey            */ 255
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB83E74D6, /LatLongEditFieldBGImageItem/LongitudeSecondsBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 195,    // ::LatLongEditFieldBGImageItemData::mLongitudeSecondsBGBitmap
        /* mItemKey            */ 361
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2292DD49, /LatLongEditFieldBGImageItem/LongitudeDecimalsBGBitmap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 49,
        /* mParentIndex        */ 0,    // ItemKey::LatLongEditFieldBGImageItemItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 196,    // ::LatLongEditFieldBGImageItemData::mLongitudeDecimalsBGBitmap
        /* mItemKey            */ 66
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongDataValuesHierarchyNodes[LatLongDataValuesDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA19E3589, /LatLongDataValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 197,    // ::LatLongDataValuesData
        /* mItemKey            */ 306
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x26B44272, /LatLongDataValues/LatDegreesInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 198,    // ::LatLongDataValuesData::mLatDegreesInputValues
        /* mItemKey            */ 73
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1BD18847, /LatLongDataValues/LongDegreesInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 199,    // ::LatLongDataValuesData::mLongDegreesInputValues
        /* mItemKey            */ 51
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x274D9A6B, /LatLongDataValues/LatMinutesInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 200,    // ::LatLongDataValuesData::mLatMinutesInputValues
        /* mItemKey            */ 74
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x74A453C3, /LatLongDataValues/LongMinutesInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 201,    // ::LatLongDataValuesData::mLongMinutesInputValues
        /* mItemKey            */ 230
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEFFDF14F, /LatLongDataValues/LatSecondsInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 202,    // ::LatLongDataValuesData::mLatSecondsInputValues
        /* mItemKey            */ 467
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4B1ED9D, /LatLongDataValues/LongSecondsInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 203,    // ::LatLongDataValuesData::mLongSecondsInputValues
        /* mItemKey            */ 350
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1B455375, /LatLongDataValues/LatDecimalsInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 204,    // ::LatLongDataValuesData::mLatDecimalsInputValues
        /* mItemKey            */ 50
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x004923F1, /LatLongDataValues/LongDecimalsInputValues),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 50,
        /* mParentIndex        */ 0,    // ItemKey::LatLongDataValuesItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 205,    // ::LatLongDataValuesData::mLongDecimalsInputValues
        /* mItemKey            */ 3
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongCoordinatesDirectionHierarchyNodes[LatLongCoordinatesDirectionDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAF4984F2, /LatLongCoordinatesDirection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 206,    // ::LatLongCoordinatesDirectionData
        /* mItemKey            */ 336
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDA2962E3, /LatLongCoordinatesDirection/NorthSouthEditFieldTxt),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 207,    // ::LatLongCoordinatesDirectionData::mNorthSouthEditFieldTxt
        /* mItemKey            */ 427
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x02546399, /LatLongCoordinatesDirection/EastWestEditFieldTxt),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 208,    // ::LatLongCoordinatesDirectionData::mEastWestEditFieldTxt
        /* mItemKey            */ 11
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0FCC5428, /LatLongCoordinatesDirection/NorthSouthButtonTxt),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 209,    // ::LatLongCoordinatesDirectionData::mNorthSouthButtonTxt
        /* mItemKey            */ 27
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF85898EE, /LatLongCoordinatesDirection/EastWestButtonTxt),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 210,    // ::LatLongCoordinatesDirectionData::mEastWestButtonTxt
        /* mItemKey            */ 478
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x275681CA, /LatLongCoordinatesDirection/ActiveNorthSouthEditField),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 211,    // ::LatLongCoordinatesDirectionData::mActiveNorthSouthEditField
        /* mItemKey            */ 75
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB384D0C6, /LatLongCoordinatesDirection/ActiveEastWestEditField),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 51,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesDirectionItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 212,    // ::LatLongCoordinatesDirectionData::mActiveEastWestEditField
        /* mItemKey            */ 347
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gToggleButtonTextHierarchyNodes[ToggleButtonTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6E6F46D2, /ToggleButtonText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::ToggleButtonTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 213,    // ::ToggleButtonTextData
        /* mItemKey            */ 209
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBE64FE0F, /ToggleButtonText/SouthNorthButtonText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::ToggleButtonTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 214,    // ::ToggleButtonTextData::mSouthNorthButtonText
        /* mItemKey            */ 366
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD7A81729, /ToggleButtonText/EastWestButtonText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 52,
        /* mParentIndex        */ 0,    // ItemKey::ToggleButtonTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 215,    // ::ToggleButtonTextData::mEastWestButtonText
        /* mItemKey            */ 421
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLatLongCoordinatesFormatHierarchyNodes[LatLongCoordinatesFormatDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA400A13B, /LatLongCoordinatesFormat),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesFormatItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 216,    // ::LatLongCoordinatesFormatData
        /* mItemKey            */ 310
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71D23C19, /LatLongCoordinatesFormat/LatLongFormatIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 53,
        /* mParentIndex        */ 0,    // ItemKey::LatLongCoordinatesFormatItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 217,    // ::LatLongCoordinatesFormatData::mLatLongFormatIndex
        /* mItemKey            */ 220
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEnableSetLatLongButtonHierarchyNodes[EnableSetLatLongButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE6E9DF8, /EnableSetLatLongButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::EnableSetLatLongButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 218,    // ::EnableSetLatLongButtonData
        /* mItemKey            */ 400
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAD8411B0, /EnableSetLatLongButton/IsButtonVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::EnableSetLatLongButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 219,    // ::EnableSetLatLongButtonData::mIsButtonVisible
        /* mItemKey            */ 332
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2E25EDD0, /EnableSetLatLongButton/IsPopUpVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 54,
        /* mParentIndex        */ 0,    // ItemKey::EnableSetLatLongButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 220,    // ::EnableSetLatLongButtonData::mIsPopUpVisible
        /* mItemKey            */ 91
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gPickFromMapDataHierarchyNodes[PickFromMapDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x16F71000, /PickFromMapData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 221,    // ::PickFromMapDataData
        /* mItemKey            */ 39
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4BE9B800, /PickFromMapData/MapPickingImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 222,    // ::PickFromMapDataData::mMapPickingImage
        /* mItemKey            */ 148
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7FE2180, /PickFromMapData/MapPickingType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 223,    // ::PickFromMapDataData::mMapPickingType
        /* mItemKey            */ 324
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC392DC66, /PickFromMapData/MapPickingPhoneNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 224,    // ::PickFromMapDataData::mMapPickingPhoneNumber
        /* mItemKey            */ 373
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A3C6EC4, /PickFromMapData/SelectedRoad),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 225,    // ::PickFromMapDataData::mSelectedRoad
        /* mItemKey            */ 239
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE5B3B0EE, /PickFromMapData/MapPickingInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 226,    // ::PickFromMapDataData::mMapPickingInfo
        /* mItemKey            */ 452
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0A15A17F, /PickFromMapData/MapPickingNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 227,    // ::PickFromMapDataData::mMapPickingNumber
        /* mItemKey            */ 19
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4520BF09, /PickFromMapData/MapPickingSize),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 228,    // ::PickFromMapDataData::mMapPickingSize
        /* mItemKey            */ 132
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC9EEF1F6, /PickFromMapData/PhoneNumberAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 229,    // ::PickFromMapDataData::mPhoneNumberAvailable
        /* mItemKey            */ 392
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x827AA75B, /PickFromMapData/IsValidLocationAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 230,    // ::PickFromMapDataData::mIsValidLocationAvailable
        /* mItemKey            */ 257
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F3878D9, /PickFromMapData/MapPickingInfoAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 231,    // ::PickFromMapDataData::mMapPickingInfoAvailable
        /* mItemKey            */ 250
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x010DB250, /PickFromMapData/LineSwitchIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 232,    // ::PickFromMapDataData::mLineSwitchIndex
        /* mItemKey            */ 7
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC22AC8D1, /PickFromMapData/FirstLineInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 233,    // ::PickFromMapDataData::mFirstLineInfo
        /* mItemKey            */ 371
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFEBA2A86, /PickFromMapData/SecondLineInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 234,    // ::PickFromMapDataData::mSecondLineInfo
        /* mItemKey            */ 489
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x17D303AE, /PickFromMapData/EnablePreviousInfoArrow),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 235,    // ::PickFromMapDataData::mEnablePreviousInfoArrow
        /* mItemKey            */ 41
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC645DD1F, /PickFromMapData/EnableNextInfoArrow),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 236,    // ::PickFromMapDataData::mEnableNextInfoArrow
        /* mItemKey            */ 383
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9A95F821, /PickFromMapData/CurrentAndTotalPageNumberDisplay),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 237,    // ::PickFromMapDataData::mCurrentAndTotalPageNumberDisplay
        /* mItemKey            */ 297
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x12D6A6D0, /PickFromMapData/WaypointNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 238,    // ::PickFromMapDataData::mWaypointNumber
        /* mItemKey            */ 34
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B0FADD8, /PickFromMapData/PickedDirection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 239,    // ::PickFromMapDataData::mPickedDirection
        /* mItemKey            */ 202
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x71789FBC, /PickFromMapData/PickedDistance),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 240,    // ::PickFromMapDataData::mPickedDistance
        /* mItemKey            */ 218
    },
    { // 20
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB53E6ED6, /PickFromMapData/DetailPickingInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 55,
        /* mParentIndex        */ 0,    // ItemKey::PickFromMapDataItem
        /* mLocalIndex         */ 20,
        /* mDescriptorIndex    */ 241,    // ::PickFromMapDataData::mDetailPickingInfo
        /* mItemKey            */ 352
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEnableOkButtonHierarchyNodes[EnableOkButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x86B0DC47, /EnableOkButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::EnableOkButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 242,    // ::EnableOkButtonData
        /* mItemKey            */ 263
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC8341BC1, /EnableOkButton/IsOKButtonVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::EnableOkButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 243,    // ::EnableOkButtonData::mIsOKButtonVisible
        /* mItemKey            */ 388
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x83C7B1B5, /EnableOkButton/NaviIconNormal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::EnableOkButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 244,    // ::EnableOkButtonData::mNaviIconNormal
        /* mItemKey            */ 259
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x285758A1, /EnableOkButton/NaviIconPressed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::EnableOkButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 245,    // ::EnableOkButtonData::mNaviIconPressed
        /* mItemKey            */ 78
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB2633B93, /EnableOkButton/IsCarModeNaviIconVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 56,
        /* mParentIndex        */ 0,    // ItemKey::EnableOkButtonItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 246,    // ::EnableOkButtonData::mIsCarModeNaviIconVisible
        /* mItemKey            */ 344
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEnablePhoneButtonHierarchyNodes[EnablePhoneButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE2CE3B10, /EnablePhoneButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::EnablePhoneButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 247,    // ::EnablePhoneButtonData
        /* mItemKey            */ 444
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAB0A44DF, /EnablePhoneButton/IsPhoneButtonVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 57,
        /* mParentIndex        */ 0,    // ItemKey::EnablePhoneButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 248,    // ::EnablePhoneButtonData::mIsPhoneButtonVisible
        /* mItemKey            */ 330
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gEnableGuidanceButtonHierarchyNodes[EnableGuidanceButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF90CB0C6, /EnableGuidanceButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::EnableGuidanceButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 249,    // ::EnableGuidanceButtonData
        /* mItemKey            */ 480
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFC56B546, /EnableGuidanceButton/IsGuidanceButtonVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::EnableGuidanceButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 250,    // ::EnableGuidanceButtonData::mIsGuidanceButtonVisible
        /* mItemKey            */ 484
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x357A81A4, /EnableGuidanceButton/IsFavButtonVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::EnableGuidanceButtonItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 251,    // ::EnableGuidanceButtonData::mIsFavButtonVisible
        /* mItemKey            */ 102
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xBF435323, /EnableGuidanceButton/BackButtonLevelIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::EnableGuidanceButtonItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 252,    // ::EnableGuidanceButtonData::mBackButtonLevelIndex
        /* mItemKey            */ 368
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x652006AF, /EnableGuidanceButton/IsCarModeNaviIconVisible),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 58,
        /* mParentIndex        */ 0,    // ItemKey::EnableGuidanceButtonItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 253,    // ::EnableGuidanceButtonData::mIsCarModeNaviIconVisible
        /* mItemKey            */ 191
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gCompassButtonHierarchyNodes[CompassButtonDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x9AF1FBAC, /CompassButton),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::CompassButtonItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 254,    // ::CompassButtonData
        /* mItemKey            */ 298
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x928B4F57, /CompassButton/CompassOrientation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 59,
        /* mParentIndex        */ 0,    // ItemKey::CompassButtonItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 255,    // ::CompassButtonData::mCompassOrientation
        /* mItemKey            */ 284
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapoutScreenDataHierarchyNodes[MapoutScreenDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD27F92AE, /MapoutScreenData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 256,    // ::MapoutScreenDataData
        /* mItemKey            */ 410
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEB78F198, /MapoutScreenData/ETADestination),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 257,    // ::MapoutScreenDataData::mETADestination
        /* mItemKey            */ 459
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x44730265, /MapoutScreenData/ETAWaypoint),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 258,    // ::MapoutScreenDataData::mETAWaypoint
        /* mItemKey            */ 128
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCE8D8D8B, /MapoutScreenData/IsWaypointPresent),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 259,    // ::MapoutScreenDataData::mIsWaypointPresent
        /* mItemKey            */ 401
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2F885532, /MapoutScreenData/ShowEta),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 260,    // ::MapoutScreenDataData::mShowEta
        /* mItemKey            */ 93
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x97EB6DB2, /MapoutScreenData/DurationCabinOnly),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 261,    // ::MapoutScreenDataData::mDurationCabinOnly
        /* mItemKey            */ 294
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xAA6B613A, /MapoutScreenData/ETACabinOnly),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 262,    // ::MapoutScreenDataData::mETACabinOnly
        /* mItemKey            */ 329
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D46583B, /MapoutScreenData/ShowEtaDurationCabinOnly),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 60,
        /* mParentIndex        */ 0,    // ItemKey::MapoutScreenDataItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 263,    // ::MapoutScreenDataData::mShowEtaDurationCabinOnly
        /* mItemKey            */ 207
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapScreenDataHierarchyNodes[MapScreenDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC717682F, /MapScreenData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 264,    // ::MapScreenDataData
        /* mItemKey            */ 384
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC05C1F1F, /MapScreenData/PickingResultLatitudeLongitude),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 265,    // ::MapScreenDataData::mPickingResultLatitudeLongitude
        /* mItemKey            */ 370
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3EE0DABF, /MapScreenData/CurrentStreet),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 266,    // ::MapScreenDataData::mCurrentStreet
        /* mItemKey            */ 117
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC8B3FB84, /MapScreenData/CurrentCity),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 267,    // ::MapScreenDataData::mCurrentCity
        /* mItemKey            */ 391
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7A4BA7C8, /MapScreenData/DistanceToDestination),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 268,    // ::MapScreenDataData::mDistanceToDestination
        /* mItemKey            */ 240
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD3984505, /MapScreenData/TimeToDestination),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 269,    // ::MapScreenDataData::mTimeToDestination
        /* mItemKey            */ 414
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFC86EC94, /MapScreenData/ArrivalTimeToBeShownOnMap),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 270,    // ::MapScreenDataData::mArrivalTimeToBeShownOnMap
        /* mItemKey            */ 486
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3AE2E01B, /MapScreenData/ETATextLabelValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 271,    // ::MapScreenDataData::mETATextLabelValue
        /* mItemKey            */ 111
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1FA8419C, /MapScreenData/CompassArrowDirection),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 272,    // ::MapScreenDataData::mCompassArrowDirection
        /* mItemKey            */ 56
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCCF03A4B, /MapScreenData/CompassArrowDirectionIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 273,    // ::MapScreenDataData::mCompassArrowDirectionIcon
        /* mItemKey            */ 397
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3FC2A9FC, /MapScreenData/ZoomLevel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 274,    // ::MapScreenDataData::mZoomLevel
        /* mItemKey            */ 121
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x713D8DAC, /MapScreenData/ZoomSliderCurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 275,    // ::MapScreenDataData::mZoomSliderCurrentValue
        /* mItemKey            */ 216
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23469A40, /MapScreenData/SecMapCompassArrowDirectionIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 276,    // ::MapScreenDataData::mSecMapCompassArrowDirectionIcon
        /* mItemKey            */ 69
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x010AB96F, /MapScreenData/SecZoomLevel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 277,    // ::MapScreenDataData::mSecZoomLevel
        /* mItemKey            */ 6
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA5D59032, /MapScreenData/ScaleImageSwitch),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 278,    // ::MapScreenDataData::mScaleImageSwitch
        /* mItemKey            */ 318
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x69BD16A7, /MapScreenData/SpeedLimit),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 279,    // ::MapScreenDataData::mSpeedLimit
        /* mItemKey            */ 199
    },
    { // 16
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA528FB8B, /MapScreenData/isSpeedLimitPresent),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 16,
        /* mDescriptorIndex    */ 280,    // ::MapScreenDataData::misSpeedLimitPresent
        /* mItemKey            */ 315
    },
    { // 17
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x702A25C3, /MapScreenData/isOverSpeedWarning),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 17,
        /* mDescriptorIndex    */ 281,    // ::MapScreenDataData::misOverSpeedWarning
        /* mItemKey            */ 211
    },
    { // 18
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6897101D, /MapScreenData/SpeedlimitWithUnit),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 18,
        /* mDescriptorIndex    */ 282,    // ::MapScreenDataData::mSpeedlimitWithUnit
        /* mItemKey            */ 195
    },
    { // 19
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDEDC16B7, /MapScreenData/SpeedcountryCode),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 19,
        /* mDescriptorIndex    */ 283,    // ::MapScreenDataData::mSpeedcountryCode
        /* mItemKey            */ 435
    },
    { // 20
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D23DA5B, /MapScreenData/SpeedLimitIconPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 20,
        /* mDescriptorIndex    */ 284,    // ::MapScreenDataData::mSpeedLimitIconPosition
        /* mItemKey            */ 151
    },
    { // 21
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x93C464C0, /MapScreenData/ShowMapActiveRGButtons),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 21,
        /* mDescriptorIndex    */ 285,    // ::MapScreenDataData::mShowMapActiveRGButtons
        /* mItemKey            */ 286
    },
    { // 22
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4F18D485, /MapScreenData/StartShowMapActiveRGButtonTimer),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 22,
        /* mDescriptorIndex    */ 286,    // ::MapScreenDataData::mStartShowMapActiveRGButtonTimer
        /* mItemKey            */ 156
    },
    { // 23
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB1766D17, /MapScreenData/IsGuidanceVoiceEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 23,
        /* mDescriptorIndex    */ 287,    // ::MapScreenDataData::mIsGuidanceVoiceEnabled
        /* mItemKey            */ 341
    },
    { // 24
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x444EEC0C, /MapScreenData/MuteUnmuteText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 24,
        /* mDescriptorIndex    */ 288,    // ::MapScreenDataData::mMuteUnmuteText
        /* mItemKey            */ 127
    },
    { // 25
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB555FA39, /MapScreenData/MuteUnmuteNormalIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 25,
        /* mDescriptorIndex    */ 289,    // ::MapScreenDataData::mMuteUnmuteNormalIcon
        /* mItemKey            */ 353
    },
    { // 26
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x587FC68A, /MapScreenData/MuteUnmutePressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 26,
        /* mDescriptorIndex    */ 290,    // ::MapScreenDataData::mMuteUnmutePressedIcon
        /* mItemKey            */ 169
    },
    { // 27
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x91121D20, /MapScreenData/MuteUnmuteDisabledIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 27,
        /* mDescriptorIndex    */ 291,    // ::MapScreenDataData::mMuteUnmuteDisabledIcon
        /* mItemKey            */ 282
    },
    { // 28
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0EBF4942, /MapScreenData/NaviGadgetIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 28,
        /* mDescriptorIndex    */ 292,    // ::MapScreenDataData::mNaviGadgetIcon
        /* mItemKey            */ 24
    },
    { // 29
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA476E322, /MapScreenData/MapActiveRGNaviIconNormal),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 29,
        /* mDescriptorIndex    */ 293,    // ::MapScreenDataData::mMapActiveRGNaviIconNormal
        /* mItemKey            */ 312
    },
    { // 30
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDCAFAD4E, /MapScreenData/MapActiveRGNaviIconPressed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 61,
        /* mParentIndex        */ 0,    // ItemKey::MapScreenDataItem
        /* mLocalIndex         */ 30,
        /* mDescriptorIndex    */ 294,    // ::MapScreenDataData::mMapActiveRGNaviIconPressed
        /* mItemKey            */ 434
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSplitMapScreenDataHierarchyNodes[SplitMapScreenDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D411CAD, /SplitMapScreenData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::SplitMapScreenDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 295,    // ::SplitMapScreenDataData
        /* mItemKey            */ 176
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA090438B, /SplitMapScreenData/LaneGuidanceSplitViewPosition),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::SplitMapScreenDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 296,    // ::SplitMapScreenDataData::mLaneGuidanceSplitViewPosition
        /* mItemKey            */ 304
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1ABB8870, /SplitMapScreenData/EnableSplitMapItems),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 62,
        /* mParentIndex        */ 0,    // ItemKey::SplitMapScreenDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 297,    // ::SplitMapScreenDataData::mEnableSplitMapItems
        /* mItemKey            */ 49
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapMainScreenStateHierarchyNodes[MapMainScreenStateDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4A39F047, /MapMainScreenState),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::MapMainScreenStateItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 298,    // ::MapMainScreenStateData
        /* mItemKey            */ 143
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC7C13930, /MapMainScreenState/MapMainScreenStateValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 63,
        /* mParentIndex        */ 0,    // ItemKey::MapMainScreenStateItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 299,    // ::MapMainScreenStateData::mMapMainScreenStateValue
        /* mItemKey            */ 387
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gTurnListETAItemHierarchyNodes[TurnListETAItemDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE20AFBE2, /TurnListETAItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::TurnListETAItemItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 300,    // ::TurnListETAItemData
        /* mItemKey            */ 442
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD0601980, /TurnListETAItem/DistanceToDestination),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::TurnListETAItemItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 301,    // ::TurnListETAItemData::mDistanceToDestination
        /* mItemKey            */ 403
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x59D749B5, /TurnListETAItem/TimeToDestination),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::TurnListETAItemItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 302,    // ::TurnListETAItemData::mTimeToDestination
        /* mItemKey            */ 170
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC03A9C07, /TurnListETAItem/DestinationName),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 64,
        /* mParentIndex        */ 0,    // ItemKey::TurnListETAItemItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 303,    // ::TurnListETAItemData::mDestinationName
        /* mItemKey            */ 369
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gODRDataHierarchyNodes[ODRDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB55EF298, /ODRData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 304,    // ::ODRDataData
        /* mItemKey            */ 354
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA43D5ED1, /ODRData/TurnToStreet),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 305,    // ::ODRDataData::mTurnToStreet
        /* mItemKey            */ 311
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7177843C, /ODRData/TurnToStreetWithDistance),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 306,    // ::ODRDataData::mTurnToStreetWithDistance
        /* mItemKey            */ 217
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xFBA66B75, /ODRData/DistanceToManeuver),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 307,    // ::ODRDataData::mDistanceToManeuver
        /* mItemKey            */ 483
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCF2C2B72, /ODRData/DistanceToManeuverUnit),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 308,    // ::ODRDataData::mDistanceToManeuverUnit
        /* mItemKey            */ 402
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1871AC5D, /ODRData/ManeuverBargraphValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 309,    // ::ODRDataData::mManeuverBargraphValue
        /* mItemKey            */ 43
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC4893063, /ODRData/ShowManeuverBargraph),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 310,    // ::ODRDataData::mShowManeuverBargraph
        /* mItemKey            */ 377
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA9EAE720, /ODRData/ManeuverSymbolIndex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 65,
        /* mParentIndex        */ 0,    // ItemKey::ODRDataItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 311,    // ::ODRDataData::mManeuverSymbolIndex
        /* mItemKey            */ 328
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRouteOverviewBtnHierarchyNodes[RouteOverviewBtnDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x161DC08D, /RouteOverviewBtn),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::RouteOverviewBtnItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 312,    // ::RouteOverviewBtnData
        /* mItemKey            */ 38
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB3B081FE, /RouteOverviewBtn/IsRouteOverviewBtnEnabled),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 66,
        /* mParentIndex        */ 0,    // ItemKey::RouteOverviewBtnItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 313,    // ::RouteOverviewBtnData::mIsRouteOverviewBtnEnabled
        /* mItemKey            */ 348
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapSettingOthersListIDHierarchyNodes[MapSettingOthersListIDDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x23E670FB, /MapSettingOthersListID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::MapSettingOthersListIDItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 314,    // ::MapSettingOthersListIDData
        /* mItemKey            */ 72
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x787C75DB, /MapSettingOthersListID/ListID),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 67,
        /* mParentIndex        */ 0,    // ItemKey::MapSettingOthersListIDItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 315,    // ::MapSettingOthersListIDData::mListID
        /* mItemKey            */ 235
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gNaviBackButtonLevelHierarchyNodes[NaviBackButtonLevelDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x89476CBD, /NaviBackButtonLevel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::NaviBackButtonLevelItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 316,    // ::NaviBackButtonLevelData
        /* mItemKey            */ 266
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1E12F0E6, /NaviBackButtonLevel/BackButtonLevel),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 68,
        /* mParentIndex        */ 0,    // ItemKey::NaviBackButtonLevelItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 317,    // ::NaviBackButtonLevelData::mBackButtonLevel
        /* mItemKey            */ 54
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMapSettingsOthersTitleHierarchyNodes[MapSettingsOthersTitleDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4C56DC27, /MapSettingsOthersTitle),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::MapSettingsOthersTitleItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 318,    // ::MapSettingsOthersTitleData
        /* mItemKey            */ 149
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x1FE60DF0, /MapSettingsOthersTitle/MapOtherSettingsTitleValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 69,
        /* mParentIndex        */ 0,    // ItemKey::MapSettingsOthersTitleItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 319,    // ::MapSettingsOthersTitleData::mMapOtherSettingsTitleValue
        /* mItemKey            */ 57
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gZoomBarInfoHierarchyNodes[ZoomBarInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0E27B2FF, /ZoomBarInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 70,
        /* mParentIndex        */ 0,    // ItemKey::ZoomBarInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 320,    // ::ZoomBarInfoData
        /* mItemKey            */ 23
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3A1B4420, /ZoomBarInfo/IsZoomTimerStart),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 70,
        /* mParentIndex        */ 0,    // ItemKey::ZoomBarInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 321,    // ::ZoomBarInfoData::mIsZoomTimerStart
        /* mItemKey            */ 109
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD6B23B3A, /ZoomBarInfo/IsZoomBarDisplayed),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 70,
        /* mParentIndex        */ 0,    // ItemKey::ZoomBarInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 322,    // ::ZoomBarInfoData::mIsZoomBarDisplayed
        /* mItemKey            */ 418
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gMultiLinePopupTextHierarchyNodes[MultiLinePopupTextDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4786702C, /MultiLinePopupText),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopupTextItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 323,    // ::MultiLinePopupTextData
        /* mItemKey            */ 138
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xCB7815DF, /MultiLinePopupText/ThreeLinePopupText1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopupTextItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 324,    // ::MultiLinePopupTextData::mThreeLinePopupText1
        /* mItemKey            */ 396
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDCAA3843, /MultiLinePopupText/ThreeLinePopupText2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopupTextItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 325,    // ::MultiLinePopupTextData::mThreeLinePopupText2
        /* mItemKey            */ 433
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xEEBCDC68, /MultiLinePopupText/ThreeLinePopupText3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 71,
        /* mParentIndex        */ 0,    // ItemKey::MultiLinePopupTextItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 326,    // ::MultiLinePopupTextData::mThreeLinePopupText3
        /* mItemKey            */ 463
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSettingSliderHierarchyNodes[SettingSliderDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x0BB71EBD, /SettingSlider),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::SettingSliderItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 327,    // ::SettingSliderData
        /* mItemKey            */ 20
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3448416A, /SettingSlider/Increasable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::SettingSliderItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 328,    // ::SettingSliderData::mIncreasable
        /* mItemKey            */ 100
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4DDE9F20, /SettingSlider/Decreasable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::SettingSliderItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 329,    // ::SettingSliderData::mDecreasable
        /* mItemKey            */ 153
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x29AA945F, /SettingSlider/CurrentValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::SettingSliderItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 330,    // ::SettingSliderData::mCurrentValue
        /* mItemKey            */ 81
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5FF11251, /SettingSlider/ButtonIsActive),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 72,
        /* mParentIndex        */ 0,    // ItemKey::SettingSliderItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 331,    // ::SettingSliderData::mButtonIsActive
        /* mItemKey            */ 180
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gWhereAmIScreenDataHierarchyNodes[WhereAmIScreenDataDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD1D748EC, /WhereAmIScreenData),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::WhereAmIScreenDataItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 332,    // ::WhereAmIScreenDataData
        /* mItemKey            */ 408
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x45AFB56D, /WhereAmIScreenData/CurrentStreetInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::WhereAmIScreenDataItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 333,    // ::WhereAmIScreenDataData::mCurrentStreetInfo
        /* mItemKey            */ 135
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE104B803, /WhereAmIScreenData/CurrentCityInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::WhereAmIScreenDataItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 334,    // ::WhereAmIScreenDataData::mCurrentCityInfo
        /* mItemKey            */ 439
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xB4BE6DA7, /WhereAmIScreenData/CurrentStreetRoadNrImage),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 73,
        /* mParentIndex        */ 0,    // ItemKey::WhereAmIScreenDataItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 335,    // ::WhereAmIScreenDataData::mCurrentStreetRoadNrImage
        /* mItemKey            */ 351
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gWaypointListInfoHierarchyNodes[WaypointListInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4D49239E, /WaypointListInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::WaypointListInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 336,    // ::WaypointListInfoData
        /* mItemKey            */ 152
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C0E8E2E, /WaypointListInfo/WaypointListItem),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::WaypointListInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 337,    // ::WaypointListInfoData::mWaypointListItem
        /* mItemKey            */ 172
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x841D463D, /WaypointListInfo/WaypointNormalIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::WaypointListInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 338,    // ::WaypointListInfoData::mWaypointNormalIcon
        /* mItemKey            */ 260
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD6EC15C2, /WaypointListInfo/WaypointPressedIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 74,
        /* mParentIndex        */ 0,    // ItemKey::WaypointListInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 339,    // ::WaypointListInfoData::mWaypointPressedIcon
        /* mItemKey            */ 419
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gGPSInfoHierarchyNodes[GPSInfoDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA14AA7B1, /GPSInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 340,    // ::GPSInfoData
        /* mItemKey            */ 305
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2E0534D6, /GPSInfo/DateValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 341,    // ::GPSInfoData::mDateValue
        /* mItemKey            */ 90
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2B03A00E, /GPSInfo/AltitudeValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 342,    // ::GPSInfoData::mAltitudeValue
        /* mItemKey            */ 83
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x8D0CA2DD, /GPSInfo/CapturedSatelliteNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 343,    // ::GPSInfoData::mCapturedSatelliteNumber
        /* mItemKey            */ 276
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3FA4884A, /GPSInfo/SearchingSatelliteNumber),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 344,    // ::GPSInfoData::mSearchingSatelliteNumber
        /* mItemKey            */ 120
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x67BC63AD, /GPSInfo/GnssModeType),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 345,    // ::GPSInfoData::mGnssModeType
        /* mItemKey            */ 193
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE007E409, /GPSInfo/LatViaSensor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 346,    // ::GPSInfoData::mLatViaSensor
        /* mItemKey            */ 438
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x3DED8AD4, /GPSInfo/LongViaSensor),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 347,    // ::GPSInfoData::mLongViaSensor
        /* mItemKey            */ 114
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5D3BA658, /GPSInfo/VisibleSatellite),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 348,    // ::GPSInfoData::mVisibleSatellite
        /* mItemKey            */ 175
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6B50B8F3, /GPSInfo/GNSSTypeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 349,    // ::GPSInfoData::mGNSSTypeInfo
        /* mItemKey            */ 204
    },
    { // 10
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x647E6610, /GPSInfo/TimeInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 10,
        /* mDescriptorIndex    */ 350,    // ::GPSInfoData::mTimeInfo
        /* mItemKey            */ 189
    },
    { // 11
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDA96D261, /GPSInfo/HeadingInfo),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 11,
        /* mDescriptorIndex    */ 351,    // ::GPSInfoData::mHeadingInfo
        /* mItemKey            */ 429
    },
    { // 12
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x6D0E9315, /GPSInfo/GPSCoordinate),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 12,
        /* mDescriptorIndex    */ 352,    // ::GPSInfoData::mGPSCoordinate
        /* mItemKey            */ 206
    },
    { // 13
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x7F067DB3, /GPSInfo/GPSUnAvailable),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 13,
        /* mDescriptorIndex    */ 353,    // ::GPSInfoData::mGPSUnAvailable
        /* mItemKey            */ 248
    },
    { // 14
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA7A2F3A9, /GPSInfo/SatelliteIcon),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 14,
        /* mDescriptorIndex    */ 354,    // ::GPSInfoData::mSatelliteIcon
        /* mItemKey            */ 323
    },
    { // 15
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xDC29178E, /GPSInfo/SatelliteIconVisibility),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 75,
        /* mParentIndex        */ 0,    // ItemKey::GPSInfoItem
        /* mLocalIndex         */ 15,
        /* mDescriptorIndex    */ 355,    // ::GPSInfoData::mSatelliteIconVisibility
        /* mItemKey            */ 431
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gSwitchindexHierarchyNodes[SwitchindexDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2E436C61, /Switchindex),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 76,
        /* mParentIndex        */ 0,    // ItemKey::SwitchindexItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 356,    // ::SwitchindexData
        /* mItemKey            */ 92
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x09B1189E, /Switchindex/IndexValue),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 76,
        /* mParentIndex        */ 0,    // ItemKey::SwitchindexItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 357,    // ::SwitchindexData::mIndexValue
        /* mItemKey            */ 18
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gLaneGuidanceHierarchyNodes[LaneGuidanceDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xE5BA2218, /LaneGuidance),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 358,    // ::LaneGuidanceData
        /* mItemKey            */ 453
    },
    { // 1
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x4007342E, /LaneGuidance/BitmapImage1),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 1,
        /* mDescriptorIndex    */ 359,    // ::LaneGuidanceData::mBitmapImage1
        /* mItemKey            */ 122
    },
    { // 2
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x2D510EC2, /LaneGuidance/BitmapImage2),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 2,
        /* mDescriptorIndex    */ 360,    // ::LaneGuidanceData::mBitmapImage2
        /* mItemKey            */ 88
    },
    { // 3
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x5C9BED57, /LaneGuidance/BitmapImage3),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 3,
        /* mDescriptorIndex    */ 361,    // ::LaneGuidanceData::mBitmapImage3
        /* mItemKey            */ 173
    },
    { // 4
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xD9DFE7D1, /LaneGuidance/BitmapImage4),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 4,
        /* mDescriptorIndex    */ 362,    // ::LaneGuidanceData::mBitmapImage4
        /* mItemKey            */ 426
    },
    { // 5
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC7A5435C, /LaneGuidance/BitmapImage5),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 5,
        /* mDescriptorIndex    */ 363,    // ::LaneGuidanceData::mBitmapImage5
        /* mItemKey            */ 385
    },
    { // 6
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x740E9C3C, /LaneGuidance/BitmapImage6),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 6,
        /* mDescriptorIndex    */ 364,    // ::LaneGuidanceData::mBitmapImage6
        /* mItemKey            */ 227
    },
    { // 7
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xA24D78B9, /LaneGuidance/BitmapImage7),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 7,
        /* mDescriptorIndex    */ 365,    // ::LaneGuidanceData::mBitmapImage7
        /* mItemKey            */ 307
    },
    { // 8
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xC4D03DBE, /LaneGuidance/BitmapImage8),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 8,
        /* mDescriptorIndex    */ 366,    // ::LaneGuidanceData::mBitmapImage8
        /* mItemKey            */ 378
    },
    { // 9
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0xF8BA8F98, /LaneGuidance/HovOccupancy),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::LeaveNode),
        /* mBindingSourceIndex */ 77,
        /* mParentIndex        */ 0,    // ItemKey::LaneGuidanceItem
        /* mLocalIndex         */ 9,
        /* mDescriptorIndex    */ 367,    // ::LaneGuidanceData::mHovOccupancy
        /* mItemKey            */ 479
    },
};
// =========================================================================
static const ::Courier::Internal::DataBinding::DataItemHierarchyNode gRouteGuidancetextImageUpdationHierarchyNodes[RouteGuidancetextImageUpdationDataBindingSource::cHierarchyNodeCount] = {
    { // 0
        /* mIdent              */ COURIER_IDENTIFIER_STORAGE_INITIALIZER(0x220AF7EE, /RouteGuidancetextImageUpdation),
        /* mFlags              */ ::FeatStd::UInt8(::Courier::Internal::DataBinding::DataItemHierarchyNodeFlags::None),
        /* mBindingSourceIndex */ 78,
        /* mParentIndex        */ 0,    // ItemKey::RouteGuidancetextImageUpdationItem
        /* mLocalIndex         */ 0,
        /* mDescriptorIndex    */ 368,    // ::RouteGuidancetextImageUpdationData
        /* mItemKey            */ 63
    },
    { // 1
        /* mIdent            