/************************************************************************
*FILE: AppHmi_MediaStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_MediaStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed Feb 19 10:59:01 2025
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_MediaStateMachineSEMLibB.h"


#include "AppHmi_MediaStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_BOOL SM_VARIANT_TYPE_VIDEO = 1;

VS_INT g_SM_ActiveMediaActivityID = 0;

VS_UINT8 g_SM_ActiveMediaSource = 0u;

VS_INT g_SM_ActiveRegion = 2;

VS_INT g_SM_ActiveUSBCameraPort = 0;

VS_INT g_SM_Activity_SourceSel = 0;

VS_INT g_SM_BTDeviceStatus = 0;

VS_INT8 g_SM_CarPlayStatus = 0;

VS_UINT32 g_SM_CurrentView = 0ul;

VS_INT g_SM_DevConnTypeChanged = 0;

VS_INT g_SM_InitialTabLoading = 0;

VS_INT g_SM_IsIAPDevice = 0;

VS_INT g_SM_IsSourceCheckState = 0;

VS_INT g_SM_ListType = 255;

VS_INT g_SM_MediaFileType = 1;

VS_INT g_SM_PfoMessage_PopUpActive = 0;

VS_INT g_SM_PrepareDeactivate = 0;

VS_INT g_SM_RequestedView = 0;

VS_INT g_SM_ScreenRecreate = 0;

VS_INT g_SM_SourceSelectStatus = 0;

VS_BOOL g_SM_VARIANT_AUX = 1;

VS_INT g_SM_VideoreRestriction = 0;

VS_INT g_SM_optionselstatus = 0;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_MediaStateMachine::SEM_InitInternalVariables (void)
{
  SMInternal_MediaActivityID = 0.;
}


void AppHmi_MediaStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  switch (EventNo)
  {
  case 27:
    VSDBVar.DB27.VS_INTVar[0] = g_SM_IsSourceCheckState;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_MediaStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 347:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 356:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 357:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 361:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 362:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 363:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 364:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 365:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 366:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 367:
    EventArgsVar.DB367.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 368:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB368.VS_UINT32Var[1] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 369:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 379:
    EventArgsVar.DB368.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 380:
    EventArgsVar.DB381.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 381:
    EventArgsVar.DB381.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 382:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 383:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 384:
    EventArgsVar.DB384.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 385:
    EventArgsVar.DB384.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 386:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 387:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 388:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 389:
    EventArgsVar.DB384.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_MediaStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
  case 1:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
  case 3:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
  case 5:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_UNKNOWN);
  case 6:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_UNKNOWN && g_SM_DevConnTypeChanged == 1);
  case 7:
    return (VS_BOOL)(VSDBVar.DB27.VS_INTVar[0] == 0 && g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN);
  case 8:
    return (VS_BOOL)(g_SM_IsIAPDevice == 0);
  case 9:
    return (VS_BOOL)(g_SM_IsIAPDevice == 1);
  case 10:
    return (VS_BOOL)(g_SM_VARIANT_AUX == 1);
  case 11:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN);
  case 12:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD);
  case 13:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB && g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE);
  case 14:
    return (VS_BOOL)((g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_MTP) && g_SM_MediaFileType != SM_MEDIA_VIDEO_FILE);
  case 15:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_AUX);
  case 16:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_BLUETOOTH);
  case 17:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE);
  case 18:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Enum_MEDIA_GADGET);
  case 19:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPOD && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE);
  case 20:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPOD && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_USB_CAMERAPORT && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_ROUTER_USB);
  case 21:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Enum_MEDIA_GADGET && fnGetVariantType() != Enum_VARIANT_TYPE_CABIN_ONLY);
  case 22:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Enum_MEDIA_GADGET && fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY);
  case 23:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_USB_CAMERAPORT && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_ROUTER_USB);
  case 24:
    return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPHONE && g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_IPOD);
  case 25:
    return (VS_BOOL)(EventArgsVar.DB381.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
  case 26:
    return (VS_BOOL)(IsMediaMessageAvailable() == 1);
  case 27:
    return (VS_BOOL)(VSDBVar.DB27.VS_INTVar[0] == 1);
  case 28:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
  case 29:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
  case 30:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
  case 31:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
  case 32:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
  case 33:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
  case 34:
    return (VS_BOOL)(EventArgsVar.DB368.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
  case 35:
    return (VS_BOOL)(EventArgsVar.DB381.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
  case 36:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB384.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB381.VS_UINT32Var[0] == Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
  case 39:
    return (VS_BOOL)((g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_MTP) && g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE);
  case 40:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI);
  case 41:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI_2);
  case 42:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT_HDMI_3);
  case 43:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB_CAMERAPORT);
  case 44:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPOD && (g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE || g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE));
  case 45:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_AUX && g_SM_VARIANT_AUX == 1);
  case 46:
    return (VS_BOOL)(g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE && (g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB) && SM_VARIANT_TYPE_VIDEO == 1 && g_SM_ActiveRegion == Enum_REGION_COCKPIT);
  case 47:
    return (VS_BOOL)(g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE && (g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD || g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_USB) && SM_VARIANT_TYPE_VIDEO == 1 && g_SM_ActiveRegion == Enum_REGION_CABIN_A);
  case 48:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_IPHONE && (g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE || g_SM_MediaFileType == SM_MEDIA_VIDEO_FILE));
  case 49:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_SD && g_SM_MediaFileType == SM_MEDIA_AUDIO_FILE);
  case 50:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_UNKNOWN && g_SM_PrepareDeactivate == 0);
  case 51:
    return (VS_BOOL)(g_SM_ActiveMediaSource == Enum_FI_EN_E8DTY_ROUTER_USB);
  case 52:
    return (VS_BOOL)(g_SM_ActiveMediaActivityID == SM_MEDIA_ACTIVITYID_SOURCE_SELECTION);
  case 53:
    return (VS_BOOL)(g_SM_BTDeviceStatus == 0);
  case 54:
    return (VS_BOOL)(g_SM_BTDeviceStatus == 1);
  case 55:
    return (VS_BOOL)(g_SM_ListType == SM_MEDIA_LISTTYPE_INVALID);
  case 56:
    return (VS_BOOL)(g_SM_VideoreRestriction == 1);
  }
  return (VS_BOOL)(g_SM_ActiveMediaSource != Enum_FI_EN_E8DTY_USB_CAMERAPORT);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_MediaStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Activate_ButtonMainSrcActivate();
    break;
  case 1:
    Activate_LayerSoundSettingsMsg();
    break;
  case 2:
    Activate_Suz_BTPhoneApplication();
    break;
  case 3:
    Activate_Suz_MirrorLinkApplication();
    break;
  case 4:
    Activate_Suz_NaviApplication();
    break;
  case 7:
    Activate_Suz_TunerApplication();
    break;
  case 8:
    Activate_Suz_TunerNowPlaying();
    break;
  case 9:
    BTBrowseButtonPressed();
    break;
  case 10:
    BrowseButtonPressed();
    break;
  case 13:
    ExternalMediaAllButtonPressUpd();
    break;
  case 14:
    ExternalMediaBackButtonPressUpd();
    break;
  case 15:
    ExternalMediaTabListPageDown();
    break;
  case 16:
    ExternalMediaTabListPageUp();
    break;
  case 17:
    ExternaldvdVideoConnectRequest();
    break;
  case 18:
    ExternaldvdVideodisconnectRequest();
    break;
  case 19:
    HorTabListBtnPageDown();
    break;
  case 20:
    HorTabListBtnPageUp();
    break;
  case 22:
    Notify_Init_Finished();
    break;
  case 25:
    Perform_Activate_Home_Source();
    break;
  case 31:
    Perform_MediaMessage_Popup();
    break;
  case 32:
    Perform_MediaModule_AUX();
    break;
  case 33:
    Perform_MediaModule_BLUETOOTH();
    break;
  case 34:
    Perform_MediaModule_CAMERAPORTHDMI();
    break;
  case 35:
    Perform_MediaModule_CAMERAPORTUSB();
    break;
  case 36:
    Perform_MediaModule_IPOD();
    break;
  case 38:
    Perform_MediaModule_SD();
    break;
  case 39:
    Perform_MediaModule_USB();
    break;
  case 41:
    Perform_MediaModule_USB2();
    break;
  case 42:
    Perform_MediaTabGadget();
    break;
  case 43:
    Perform_MediaToggle();
    break;
  case 45:
    Perform_VideoOnEXTDVDParkingBreakRequestMsg();
    break;
  case 46:
    Perform_VideoOnEXTDVDSpeedRequestMsg();
    break;
  case 47:
    Perform_VideoOnParkingBreakRequestMsg();
    break;
  case 48:
    Perform_VideoOnSpeedRequestMsg();
    break;
  case 49:
    Perform_Video_Timer_Start();
    break;
  case 50:
    Perform_Video_Timer_Stop();
    break;
  case 55:
    RequestPlayBackActionSeek();
    break;
  case 60:
    StartVideoStreaming();
    break;
  case 65:
    StopVideoStreaming();
    break;
  case 67:
    VideoBrowseButtonPressed();
    break;
  case 68:
    VideoDisconnectOnSongRequest();
    break;
  case 69:
    VideoOnsongRequest();
    break;
  case 71:
    acPerform_MediaSettingBackBtnPress();
    break;
  case 86:
    gacWaitAnimationStartReq();
    break;
  case 87:
    gacWaitAnimationStopReq();
    break;
  case 88:
    g_SM_RequestedView = 0;
    break;
  case 89:
    g_SM_Activity_SourceSel = 0;
    break;
  case 90:
    g_SM_IsSourceCheckState = 0;
    break;
  case 91:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_SourceSelection_Media;
    break;
  case 92:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_SourceSelection_Media;
    break;
  case 93:
    g_SM_IsSourceCheckState = 1;
    break;
  case 94:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_AppleDevice;
    break;
  case 95:
    g_SM_DevConnTypeChanged = 0;
    break;
  case 96:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_AppleDevice;
    break;
  case 97:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_IPOD_BT;
    break;
  case 98:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_IPOD_BT;
    break;
  case 99:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_OPT;
    break;
  case 100:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_BT;
    break;
  case 101:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_BT;
    break;
  case 102:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_AUX;
    break;
  case 103:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_AUX;
    break;
  case 104:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USB;
    break;
  case 105:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USB;
    break;
  case 106:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_VideoPlayer;
    break;
  case 107:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_VideoPlayer;
    break;
  case 108:
    SMInternal_MediaActivityID = EventArgsVar.DB368.VS_UINT32Var[0];
    break;
  case 109:
    g_SM_PfoMessage_PopUpActive = 1;
    break;
  case 110:
    g_SM_PfoMessage_PopUpActive = 0;
    break;
  case 111:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_SD;
    break;
  case 112:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_SD;
    break;
  case 113:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_VideoPlayer_FullScreen;
    break;
  case 114:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_VideoPlayer_FullScreen;
    break;
  case 115:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_ExternalDVD;
    break;
  case 116:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_ExternalDVD;
    break;
  case 117:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_ExternalDVD_FullScreen;
    break;
  case 118:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_ExternalDVD_FullScreen;
    break;
  case 119:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USBCAMERAPORT;
    break;
  case 120:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USBCAMERAPORT;
    break;
  case 121:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_USBROUTER;
    break;
  case 122:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_USBROUTER;
    break;
  case 123:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_Album;
    break;
  case 124:
    g_SM_CurrentView = Media_MediaPlayerScenes_M_Album_External;
    break;
  case 125:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_1;
    break;
  case 126:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_2;
    break;
  case 127:
    g_SM_RequestedView = Media_MediaPlayerScenes_M_CAMPORTHDMI_3;
    break;
  case 128:
    g_SM_ActiveUSBCameraPort = 0;
    break;
  case 129:
    gacViewHideReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 130:
    gacViewDestroyReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 131:
    gacViewHideReq(Media_Gadget_Media_MASTER__GADGET_MEDIA_CABIN_ONLY);
    break;
  case 132:
    gacViewDestroyReq(Media_Gadget_Media_MASTER__GADGET_MEDIA_CABIN_ONLY);
    break;
  case 133:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 134:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 135:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 136:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 137:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 138:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 139:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 140:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 141:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 142:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 143:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 144:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 145:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 146:
    gacViewHideAndDestroyReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 147:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 148:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 149:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 150:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 151:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 152:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 153:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 154:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 155:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 156:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 157:
    gacViewHideReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 158:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 159:
    gacViewHideReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 160:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 161:
    gacViewHideReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 162:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 163:
    gacViewHideReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 164:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 165:
    gacViewHideReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 166:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 167:
    gacViewHideReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 168:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 169:
    gacViewHideReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 170:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 171:
    gacViewHideReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 172:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 173:
    gacViewHideReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 174:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 175:
    gacViewHideReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 176:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 177:
    gacViewHideReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 178:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 179:
    gacViewHideReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 180:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 181:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 182:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 183:
    gacViewHideAndDestroyReq(Media_MediaPlayerScenes_M_USBCAMERAPORT);
    break;
  case 184:
    gacViewHideAndDestroyReq(Media_MediaPlayerScenes_M_USBROUTER);
    break;
  case 185:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 186:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 187:
    gacViewHideReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 188:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 189:
    gacViewHideReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 190:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 191:
    gacViewHideReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 192:
    gacViewDestroyReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 193:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 194:
    BrowseListActive(0);
    break;
  case 195:
    Perform_MediaSceneMsg(12);
    break;
  case 196:
    gacViewCreateReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 197:
    gacViewShowReq(Media_MediaPlayerScenes_M_SourceSelection_Media);
    break;
  case 198:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_SOURCESELECTION);
    break;
  case 199:
    gacViewCreateReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 200:
    gacViewShowReq(Media_MediaPlayerScenes_M_AppleDevice);
    break;
  case 201:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_NOWPLAYING);
    break;
  case 202:
    gacViewCreateReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 203:
    gacViewShowReq(Media_MediaPlayerScenes_M_IPOD_BT);
    break;
  case 204:
    Perform_MediaSceneMsg(SM_MEDIA_OPT_SETTINGS);
    break;
  case 205:
    gacViewCreateReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 206:
    gacViewShowReq(Media_MediaPlayerScenes_M_OPT);
    break;
  case 207:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_SETTINGS);
    break;
  case 208:
    gacViewCreateReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 209:
    gacViewShowReq(Media_MediaPlayerScenes_M_BT);
    break;
  case 210:
    gacViewCreateReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 211:
    gacViewShowReq(Media_MediaPlayerScenes_M_AUX);
    break;
  case 212:
    gacViewCreateReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 213:
    gacViewShowReq(Media_MediaPlayerScenes_M_USB);
    break;
  case 214:
    gacViewCreateReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 215:
    gacViewShowReq(Media_MediaPlayerScenes_M_VideoPlayer);
    break;
  case 216:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_NEXT_TRACK, Enum_KEY_RELEASE);
    break;
  case 217:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_PREV_TRACK, Enum_KEY_RELEASE);
    break;
  case 218:
    acPerform_AppleHIDCommandMsg(Enum_HID_PLAY, Enum_KEY_RELEASE);
    break;
  case 219:
    acPerform_AppleHIDCommandMsg(Enum_HID_REPEAT, Enum_KEY_RELEASE);
    break;
  case 220:
    acPerform_AppleHIDCommandMsg(Enum_HID_RANDOM, Enum_KEY_RELEASE);
    break;
  case 221:
    MediaBTOperation(SM_MEDIA_FFWD_STOP);
    break;
  case 222:
    MediaBTOperation(SM_MEDIA_FRWD_STOP);
    break;
  case 223:
    MediaOperation(SM_MEDIA_FFWD_STOP);
    break;
  case 224:
    MediaOperation(SM_MEDIA_FRWD_STOP);
    break;
  case 225:
    MediaOperation(SM_MEDIA_NEXT);
    break;
  case 226:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_PREV_TRACK, Enum_KEY_PRESS);
    break;
  case 227:
    acPerform_AppleHIDCommandMsg(Enum_HID_SCAN_NEXT_TRACK, Enum_KEY_PRESS);
    break;
  case 228:
    acPerform_AppleHIDCommandMsg(Enum_HID_PLAY, Enum_KEY_PRESS);
    break;
  case 229:
    MediaOperation(SM_MEDIA_FFWD);
    break;
  case 230:
    MediaOperation(SM_MEDIA_PREVIOUS);
    break;
  case 231:
    MediaOperation(SM_MEDIA_FRWD);
    break;
  case 232:
    MediaOperation(SM_MEDIA_PLAY);
    break;
  case 233:
    gacViewCreateReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 234:
    gacViewShowReq(Media_Gadget_Media_MASTER__GADGET_MEDIA);
    break;
  case 235:
    gacViewCreateReq(Media_Gadget_Media_MASTER__GADGET_MEDIA_CABIN_ONLY);
    break;
  case 236:
    gacViewShowReq(Media_Gadget_Media_MASTER__GADGET_MEDIA_CABIN_ONLY);
    break;
  case 237:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 238:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 239:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage, 3000);
    break;
  case 240:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 241:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaMessage);
    break;
  case 242:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 243:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 244:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 245:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessage);
    break;
  case 246:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 247:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 248:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 249:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaUnsupportedPopupMessageHUB);
    break;
  case 250:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 251:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 252:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 253:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Successful);
    break;
  case 254:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 255:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 256:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 257:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_system_Pfo_MediaDB_Download_Failure);
    break;
  case 258:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 259:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 260:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 261:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 262:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 263:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 264:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 265:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 266:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 267:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 268:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 269:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 270:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 271:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 272:
    gacViewHideReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 273:
    gacViewClearReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 274:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 275:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 276:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 277:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 278:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 279:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 280:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 281:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 282:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 283:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 284:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 285:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaConfirmBTPairing);
    break;
  case 286:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 287:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_VideoDisableMessage);
    break;
  case 288:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 289:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_WMA_DRM_ProtectedFileMessage);
    break;
  case 290:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 291:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 292:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 293:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaBTStreamingUnavailable);
    break;
  case 294:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 295:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaGlassUnavailableMessage);
    break;
  case 296:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 297:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup);
    break;
  case 298:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_Pfo_NoPlayableContentPopup, 5000);
    break;
  case 299:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 300:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_MediaDB_Download_Error);
    break;
  case 301:
    gacViewCreateReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 302:
    gacViewShowReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 303:
    acStartAppPopupTimer(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError, 5000);
    break;
  case 304:
    gacPopupSBCloseReq(Media_MediaPlayer_Pop_Up_Pfo_SignalRangeError);
    break;
  case 305:
    gacViewCreateReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 306:
    gacViewShowReq(Media_MediaPlayerScenes_M_SD);
    break;
  case 307:
    Perform_MediaSceneMsg(SM_MEDIA_VIDEO_FULLSCREEN);
    break;
  case 308:
    gacViewCreateReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 309:
    gacViewShowReq(Media_MediaPlayerScenes_M_VideoPlayer_FullScreen);
    break;
  case 310:
    gacViewCreateReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 311:
    gacViewShowReq(Media_MediaPlayerScenes_M_ExternalDVD);
    break;
  case 312:
    gacViewCreateReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 313:
    gacViewShowReq(Media_MediaPlayerScenes_M_ExternalDVD_FullScreen);
    break;
  case 314:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 315:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_1);
    break;
  case 316:
    gacViewCreateAndShowReq(Media_MediaPlayerScenes_M_USBCAMERAPORT);
    break;
  case 317:
    gacViewCreateAndShowReq(Media_MediaPlayerScenes_M_USBROUTER);
    break;
  case 318:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 319:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_2);
    break;
  case 320:
    gacViewCreateReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 321:
    gacViewShowReq(Media_MediaPlayerScenes_M_CAMPORTHDMI_3);
    break;
  case 322:
    Perform_MediaSceneMsg(SM_MEDIA_LIST_BROWSE);
    break;
  case 323:
    gacViewCreateReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 324:
    gacViewShowReq(Media_MediaPlayerScenes_M_Album);
    break;
  case 325:
    acPerform_UpdateCurrentMediaState(Enum_MEDIA_STATE_LIST);
    break;
  case 326:
    gacViewCreateReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 327:
    gacViewShowReq(Media_MediaPlayerScenes_M_Album_External);
    break;
  case 328:
    MediaOperation(SM_MEDIA_REPEATOFF);
    break;
  case 329:
    MediaOperation(SM_MEDIA_SHUFFLEOFF);
    break;
  case 330:
    acPerform_AppleHIDCommandMsg(Enum_HID_REPEAT, Enum_KEY_PRESS);
    break;
  case 331:
    acPerform_AppleHIDCommandMsg(Enum_HID_RANDOM, Enum_KEY_PRESS);
    break;
  case 332:
    MediaBTOperation(SM_MEDIA_FFWD);
    break;
  case 333:
    MediaBTOperation(SM_MEDIA_NEXT);
    break;
  case 334:
    MediaBTOperation(SM_MEDIA_PLAY);
    break;
  case 335:
    MediaBTOperation(SM_MEDIA_FRWD);
    break;
  case 336:
    MediaBTOperation(SM_MEDIA_PREVIOUS);
    break;
  case 337:
    MediaBTOperation(SM_MEDIA_REPEATOFF);
    break;
  case 338:
    MediaBTOperation(SM_MEDIA_SHUFFLEOFF);
    break;
  case 339:
    HorListTabButtonItem(EventArgsVar.DB368.VS_UINT32Var[0]);
    break;
  case 340:
    gacPopupCreateAndSBShowReq(Media_MediaPlayer_Pop_Up_Pfo_WaitScene);
    break;
  case 341:
    ExternalBrowseScreenExitUpd(LIST_ID_EXTERNAL_MEDIA_VER);
    break;
  case 342:
    ExternalMediaTabBtnPressUpd(EventArgsVar.DB368.VS_UINT32Var[0]);
    break;
  case 343:
    ExternalMediaListItemPressUpd(EventArgsVar.DB368.VS_UINT32Var[0], EventArgsVar.DB368.VS_UINT32Var[1]);
    break;

  default:
    break;
  }
}
