/************************************************************************
*FILE: AppHmi_MediaTypes.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MediaTypes_h)
#define AppHmi_MediaTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <ProjectBaseTypes.h>
enum tenMsgType {
    EN_MSG_BROWSE_RESP,
    EN_MSG_AUDIO_VIDEO
};
enum tenTraceCommands {
    TRACE_CMD_MEDIA_TEST = 0,
    TRACE_CMD_MEDIA_PLAY,
    TRACE_CMD_MEDIA_PAUSE,
    TRACE_CMD_MEDIA_NEXT,
    TRACE_CMD_MEDIA_PREV,
    TRACE_CMD_MEDIA_FRWD_START,
    TRACE_CMD_MEDIA_FRWD_STOP,
    TRACE_CMD_MEDIA_FFWD_START,
    TRACE_CMD_MEDIA_FFWD_STOP,
    TRACE_CMD_MEDIA_REPEAT_OFF,
    TRACE_CMD_MEDIA_REPEAT_TRACK,
    TRACE_CMD_MEDIA_REPEAT_LIST,
    TRACE_CMD_MEDIA_SHUFFLE_OFF,
    TRACE_CMD_MEDIA_SHUFFLE_ON
};
enum tenDeviceType {
    FI_EN_E8DTY_UNKNOWN = 0,
    FI_EN_E8DTY_USB = 1,
    FI_EN_E8DTY_IPOD = 2,
    FI_EN_E8DTY_SD = 3,
    FI_EN_E8DTY_BLUETOOTH = 4,
    FI_EN_E8DTY_IPHONE = 5,
    FI_EN_E8DTY_MTP = 6,
    FI_EN_E8DTY_AUX = 7,
    FI_EN_E8DTY_MYMEDIA = 9,
    FI_EN_E8DTY_USB_CAMERAPORT = 10,
    FI_EN_E8DTY_USB_CAMERAPORT_HDMI = 11,
    FI_EN_E8DTY_SOURCESELECTIONSCREEN = 12,
    FI_EN_E8DTY_MEDIASETTINGSSCREEN = 13,
    FI_EN_E8DTY_MEDIALISTSCREEN = 14,
    FI_EN_E8DTY_MEDIAVIDEOFULLSCREEN = 15,
    FI_EN_E8DTY_USB2 = 16,
    FI_EN_E8DTY_ROUTER_USB = 17,
    FI_EN_E8DTY_USB_CAMERAPORT_HDMI_2 = 18,
    FI_EN_E8DTY_USB_CAMERAPORT_HDMI_3 = 19
};
enum tenActionType {
    FI_EN_E8PBA_PLAY = 0,
    FI_EN_E8PBA_PAUSE = 1,
    FI_EN_E8PBA_STOP = 2,
    FI_EN_E8PBA_PREV = 3,
    FI_EN_E8PBA_NEXT = 4,
    FI_EN_E8PBA_FREV_START = 5,
    FI_EN_E8PBA_FREV_STOP = 6,
    FI_EN_E8PBA_FFWD_START = 7,
    FI_EN_E8PBA_FFWD_STOP = 8
};
enum tenRepeatType {
    FI_EN_E8RPT_NONE = 0,
    FI_EN_E8RPT_ONE = 1,
    FI_EN_E8RPT_LIST = 2,
    FI_EN_E8RPT_SUBLIST = 3,
    FI_EN_E8RPT_ALL = 4
};
enum tenPlayBackType {
    FI_EN_E8PBM_NORMAL = 0,
    FI_EN_E8PBM_RANDOM = 1
};
enum AudioCallState {
    FI_EN_E8IDLE = 0,
    FI_EN_E8DIALING = 1,
    FI_EN_E8ACTIVE = 2,
    FI_EN_E8ON_HOLD = 3,
    FI_EN_E8DISCONNECTING = 4,
    FI_EN_E8BUSY = 5,
    FI_EN_E8CONFERENCE = 6,
    FI_EN_E8IN_VOICEMAIL = 7,
    FI_EN_E8RINGTONE = 8
};
enum AudioCallInfo {
    u16CallInstance,
    e8CallStatusNotice,
    bUsingVehicleAudio,
    u8CallDurationHr,
    u8CallDurationMin,
    u8CallDurationSec,
    u8DeviceHandle
};
enum tenSourceType {
    FI_EN_E8DTY_SrcSel = 1,
    FI_EN_E8DTY_SrcSel_WONAV = 2
};
enum tenModeSource {
    FI_EN_E8MS_UNDEFINED = 0,
    FI_EN_E8MS_SOURCE = 1,
    FI_EN_E8MS_UTILITY = 2
};
enum tenBTDeviceType {
    FI_EN_E8BT_NON_STREAMING = 0,
    FI_EN_E8BT_NON_IAP2 = 1,
    FI_EN_E8BT_IAP2 = 2,
    FI_EN_E8BT_NOT_CONNECTED = 3
};
enum tenOptionType {
    FI_EN_E8PBA_EXTERNALDVD = 0,
    FI_EN_E8PBA_TA = 1,
    FI_EN_E8PBA_AUX = 2,
    FI_EN_E8PBA_SDCARD = 3
};
enum tenMediaOperationType {
    EN_MEDIA_PLAY,
    EN_MEDIA_PAUSE,
    EN_MEDIA_FASTFORWARD,
    EN_MEDIA_FASTREWIND,
    EN_MEDIA_FASTFORWARD_STOP,
    EN_MEDIA_FASTREWIND_STOP,
    EN_MEDIA_NEXT,
    EN_MEDIA_PREV,
    EN_MEDIA_SHUFFLE_OFF,
    EN_MEDIA_SHUFFLE_LIST,
    EN_MEDIA_REPEAT_OFF,
    EN_MEDIA_REPEAT_TRACK,
    EN_MEDIA_REPEAT_LIST
};
enum enImgType {
    enImgUnknownType,
    enImgBMPType,
    enImgPNGType,
    enImgGIFType,
    enImgJPGType
};
enum btphn_tenBTDeviceStatus {
    BTPHN_EN_DEVICE_CONNECTED = 0,
    BTPHN_EN_DEVICE_CONNECTED_OSD = 1,
    BTPHN_EN_DEVICE_DISCONNECTED = 2,
    BTPHN_EN_DEVICE_CHANGED_TO_OSD = 3,
    BTPHN_EN_DEVICE_DELETED = 4,
    BTPHN_EN_DEVICE_NO_CHANGE = 5
};
enum enMediaFileType {
    FILE_TYPE_MEDIA_UNKNOWN = 0,
    FILE_TYPE_MUSIC_FILE = 1,
    FILE_TYPE_PODCAST = 2,
    FILE_TYPE_AUDIOBOOK = 3,
    FILE_TYPE_VIDEO = 4,
    FILE_TYPE_PLAYLIST = 5,
    FILE_TYPE_AUDIO_STREAM = 6
};
enum enLastEntDeviceConnectedType {
    EN_DEVCONN_MEDIAPLAYER = 1,
    EN_DEVCONN_BLUETOOTH = 2,
    EN_DEVCONN_AUX = 3,
    EN_NONE = 4,
    EN_DEVCONN_SPI = 5
};
enum enMPlayConnectionType {
    FI_EN_E8DCT_UNKNOWN,
    FI_EN_E8DCT_USB,
    FI_EN_E8DCT_BLUETOOTH,
    FI_EN_E8DCT_CDROM,
    FI_EN_E8DCT_FLASH
};
enum ListStatus {
    EN_LISTSTATUS_INACTIVE,
    EN_LISTSTATUS_FORWARD,
    EN_LISTSTATUS_BACKWARD
};
enum ListType {
    EN_LISTTYPE_ROOT,
    EN_LISTTYPE_SUBLIST,
    EN_LISTTYPE_CHANGE,
    EN_LISTTYPE_FOLDERFILE
};
enum enHIDCommands {
    HID_PLAY = 0,
    HID_PAUSE,
    HID_SCAN_NEXT_TRACK,
    HID_SCAN_PREV_TRACK,
    HID_RANDOM,
    HID_REPEAT
};
enum enKeyEvents {
    KEY_PRESS = 0,
    KEY_RELEASE
};
enum enListType {
    LISTTYPE_VALID = 0,
    LISTTYPE_INVALID
};
enum enAnimationReqType {
    ANIMATION_STOP,
    ANIMATION_START
};
enum enCurrentMediaState {
    MEDIA_STATE_BACKGROUND = 0,
    MEDIA_STATE_NOWPLAYING,
    MEDIA_STATE_LIST,
    MEDIA_STATE_SETTINGS,
    MEDIA_STATE_SOURCESELECTION,
    MEDIA_STATE_INVALID
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenMsgType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenMsgType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenTraceCommands >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenTraceCommands const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenDeviceType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenDeviceType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenActionType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenActionType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenRepeatType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenRepeatType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenPlayBackType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenPlayBackType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::AudioCallState >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudioCallState const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::AudioCallInfo >::Append(::FeatStd::StringBuffer& stringBuffer, ::AudioCallInfo const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenSourceType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenSourceType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenModeSource >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenModeSource const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenBTDeviceType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenBTDeviceType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenOptionType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenOptionType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::tenMediaOperationType >::Append(::FeatStd::StringBuffer& stringBuffer, ::tenMediaOperationType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enImgType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enImgType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::btphn_tenBTDeviceStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::btphn_tenBTDeviceStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMediaFileType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMediaFileType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enLastEntDeviceConnectedType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enLastEntDeviceConnectedType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMPlayConnectionType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMPlayConnectionType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::ListStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::ListType >::Append(::FeatStd::StringBuffer& stringBuffer, ::ListType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enHIDCommands >::Append(::FeatStd::StringBuffer& stringBuffer, ::enHIDCommands const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enKeyEvents >::Append(::FeatStd::StringBuffer& stringBuffer, ::enKeyEvents const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enListType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enListType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enAnimationReqType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enAnimationReqType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enCurrentMediaState >::Append(::FeatStd::StringBuffer& stringBuffer, ::enCurrentMediaState const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_MediaTypes_h
