/************************************************************************
*FILE: AppHmi_MasterStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_MasterStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed May 14 17:16:32 2025
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_MasterStateMachineSEMLibB.h"


#include "AppHmi_MasterStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_INT FlyInVisibleStatus = 1;

VS_INT IN_tu8AntitheftStatus = 0;

VS_INT sm_AudioType = 1;

VS_UINT8 sm_IN_bIsAntiTheftActive = 0u;

VS_INT sm_IN_bIsDisclaimerActive = 0;

VS_BOOL sm_IN_bIsSPIConnected = 0;

VS_INT sm_RVCStatus = 0;

VS_BOOL sm_SRC_CockpitStatus = 0;

VS_BOOL sm_SpeechIconPressed = 0;

VS_BOOL sm_SpeechStatus = 0;

VS_BOOL sm_SrcCAbin_Status = 0;

VS_BOOL sm_Src_status = 0;

VS_BOOL sm_Variant_Camera = 1;

VS_BOOL sm_Variant_Coach = 1;

VS_BOOL sm_Variant_Navigation = 1;

VS_INT sm_activeapplicationID = 101;

VS_INT sm_animation_status = 2;


/*
 * VS System Internal Variable Initializing Function.
 */
void AppHmi_MasterStateMachine::SEM_InitInternalVariables (void)
{
  IN_IntraTransitionViewId = 0ul;
  IN_IsHMIAppInitialized = 0;
  IN_IsLastAppActivationRequired = 0;
  IN_IsStartupDone = 0;
  IN_KDSStatus = 255;
  IN_MIC1Status = 0;
  IN_MasterSurface_Foreground = 0;
  IN_ShowFirstHMIAppStatus = 0;
  IN_ShowTempHMIAppStatus = 0;
  IN_bIsAntiTheftAvailable = 1;
  Internal1 = 0;
  StartupTimerCompleted = 0;
}


void AppHmi_MasterStateMachine::BufferVariables (SEM_EVENT_TYPE EventNo)
{
  switch (EventNo)
  {
  case 1:
    VSDBVar.DB1.VS_UINT32Var[0] = IN_IntraTransitionViewId;
    break;
  case 181:
    VSDBVar.DB181.VS_BOOLVar[0] = IN_ShowFirstHMIAppStatus;
    break;
  case 182:
    VSDBVar.DB181.VS_BOOLVar[0] = IN_ShowTempHMIAppStatus;
    break;
  case 213:
    VSDBVar.DB213.VS_UINT32Var[0] = IN_IntraTransitionViewId;
    break;

  default:
    break;
  }
}


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_MasterStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 51:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 52:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 53:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 54:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 55:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 56:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 57:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 58:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 59:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 60:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 61:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 62:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 63:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 64:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 65:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB68.VS_UINT8Var[1] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 66:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB68.VS_UINT8Var[1] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 67:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB68.VS_UINT8Var[1] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 68:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB68.VS_UINT8Var[1] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 69:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 70:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 71:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 72:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 73:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 74:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 75:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 76:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 77:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 78:
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 79:
    EventArgsVar.DB155.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB155.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB155.VS_UINT32Var[1] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB155.VS_UINT32Var[2] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 80:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB68.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 85:
    EventArgsVar.DB155.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 86:
    EventArgsVar.DB155.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 87:
    EventArgsVar.DB88.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    break;

  case 88:
    EventArgsVar.DB88.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB88.VS_BOOLVar[0] = (VS_BOOL) va_arg(ap, VS_INT);
    break;

  case 100:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 124:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 127:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 128:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 134:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 135:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 136:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 137:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 143:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 144:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 145:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 146:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 147:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 148:
    EventArgsVar.DB189.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB189.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    break;

  case 149:
    EventArgsVar.DB149.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 150:
    EventArgsVar.DB189.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    break;

  case 153:
    EventArgsVar.DB153.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB153.VS_INT32Var[1] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB153.VS_INT32Var[2] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB153.VS_INT32Var[3] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB153.VS_INT32Var[4] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    break;

  case 155:
    EventArgsVar.DB155.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB155.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    EventArgsVar.DB155.VS_UINT32Var[1] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    EventArgsVar.DB155.VS_UINT32Var[2] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 158:
    EventArgsVar.DB88.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  case 170:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 177:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 178:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 179:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 180:
    EventArgsVar.DB68.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 188:
    EventArgsVar.DB189.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB189.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 189:
    EventArgsVar.DB189.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB189.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 191:
    EventArgsVar.DB189.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    break;

  case 192:
    EventArgsVar.DB189.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 193:
    EventArgsVar.DB155.VS_UINT8Var[0] = (VS_UINT8) va_arg(ap, VS_INT);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_MasterStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_POWER);
  case 1:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_ONOFF);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_UP);
  case 3:
    return (VS_BOOL)(!VSDBVar.DB181.VS_BOOLVar[0]);
  case 4:
    return (VS_BOOL)(IN_KDSStatus != 0);
  case 5:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Enum_REGION_CABIN_A);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Enum_REGION_COCKPIT);
  case 7:
    return (VS_BOOL)(IN_ShowFirstHMIAppStatus == 1);
  case 8:
    return (VS_BOOL)(IN_KDSStatus == 0);
  case 9:
    return (VS_BOOL)(IN_KDSStatus == 1);
  case 10:
    return (VS_BOOL)(IN_MIC1Status != EventArgsVar.DB88.VS_BOOLVar[0]);
  case 11:
    return (VS_BOOL)(IN_KDSStatus != 0 && !sm_RVCStatus && IN_MIC1Status == 1);
  case 12:
    return (VS_BOOL)(IN_MIC1Status == 0 && IN_KDSStatus != 0 && !sm_RVCStatus);
  case 13:
    return (VS_BOOL)(IN_ShowTempHMIAppStatus == 1);
  case 14:
    return (VS_BOOL)(IN_IsHMIAppInitialized);
  case 15:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_STANDBY);
  case 16:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_OFF);
  case 17:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_ON);
  case 18:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_GOODBYE);
  case 19:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_INFOTAINMENT_OFF);
  case 20:
    return (VS_BOOL)(EventArgsVar.DB88.VS_UINT8Var[0] == Enum_HMI_STATE_INACTIVE);
  case 21:
    return (VS_BOOL)(!IN_IsHMIAppInitialized);
  case 22:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Enum_SURFACEID_MAIN_SURFACE_MASTER);
  case 23:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_hmibase_SURFACESTATE_VISIBLE);
  case 24:
    return (VS_BOOL)(!IN_MasterSurface_Foreground);
  case 25:
    return (VS_BOOL)(IN_IsHMIAppInitialized && IN_MasterSurface_Foreground);
  case 26:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_HK_POWER);
  case 27:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_REMOTECONTROL_ONOFF);
  case 28:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_ENCCODE_LEFT_ENCODER || EventArgsVar.DB189.VS_UINT32Var[0] == Enum_ENCCODE_RIGHT_ENCODER);
  case 29:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_ENCCODE_LEFT_ENCODER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_ENCCODE_RIGHT_ENCODER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_MUTE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_DEMUTE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_MUTE);
  case 30:
    return (VS_BOOL)(!fnIsInf4cvSmartVariant());
  case 31:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_VOLUME_UP || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_VOLUME_DOWN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOLUMEUP || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOLUMEDOWN);
  case 32:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_DOWN || EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_REPEAT);
  case 33:
    return (VS_BOOL)(fnIsInf4cvSmartVariant());
  case 34:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_VOLUME_UP || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_VOLUME_DOWN);
  case 35:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_DOWN);
  case 36:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_SWC_PHONE_PICKUP || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOICE);
  case 37:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[2] > 0);
  case 38:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME);
  case 39:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN);
  case 40:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_HOME);
  case 41:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_POWER_LONGPRESS);
  case 42:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == M1_Scenes_GoodBye);
  case 43:
    return (VS_BOOL)(fnIsAVRoutingAdaperXMLAvailable() == 0);
  case 44:
    return (VS_BOOL)(HMI_SM_C_TRUE == EventArgsVar.DB88.VS_BOOLVar[0]);
  case 45:
    return (VS_BOOL)(Enum_MixSource_MIC2 == EventArgsVar.DB88.VS_UINT8Var[0]);
  case 46:
    return (VS_BOOL)(HMI_SM_C_FALSE == EventArgsVar.DB88.VS_BOOLVar[0]);
  case 47:
    return (VS_BOOL)(Enum_MixSource_MIC3 == EventArgsVar.DB88.VS_UINT8Var[0]);
  case 48:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_SystemStartUpCompletion);
  case 49:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_SystemStartUpMode);
  case 50:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_ENCCODE_RIGHT_ENCODER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_MAP || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_MCP_MON_CABIN);
  case 51:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == 1);
  case 52:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == 0);
  case 53:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_COCKPIT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_NAV || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CAMERA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CABIN_SETTINGS || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TRAFFIC || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_NAVI || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_PHONE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_MEDIA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TUNER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOICE);
  case 54:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Wait_Scene);
  case 55:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_COCKPIT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_NAV || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SETTINGS || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CAMERA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TRAFFIC || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_NAVI || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_PHONE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_MEDIA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TUNER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOICE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_HOME);
  case 56:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_COCKPIT);
  case 57:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_NAV || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CAMERA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TRAFFIC || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_NAVI || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_PHONE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_MEDIA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TUNER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOICE);
  case 58:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SETTINGS);
  case 59:
    return (VS_BOOL)(fnGetRegionId() == Enum_REGION_COCKPIT);
  case 60:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CABIN_SETTINGS);
  case 61:
    return (VS_BOOL)(fnGetRegionId() == Enum_REGION_CABIN_A || fnGetRegionId() == Enum_REGION_CABIN_B);
  case 62:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_CABIN);
  case 63:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SRC_COCKPIT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_NAV || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CAMERA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_PHONE_ACCEPT || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_HOME_CABIN || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TRAFFIC || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_NAVI || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_PHONE || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_MEDIA || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_TUNER || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_VOICE);
  case 64:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_SystemHeat_PopUp);
  case 65:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_SYSTEM_STATUS_DISCONNECTED);
  case 66:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[1] == Enum_SYSTEM_GROUP_CATEGORY_CMG_CABIN);
  case 67:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] != Enum_SYSTEM_STATUS_DISCONNECTED);
  case 68:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[1] == Enum_SYSTEM_GROUP_CATEGORY_CMG_CABIN_MIX);
  case 69:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPAVDECCDisconnected);
  case 70:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMAAVDECCDisconnected);
  case 71:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
  case 72:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMANANOMsgDisconnected);
  case 73:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_KDSCompletion_Status);
  case 74:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_SYSTEM_VOLTAGE_STATUS_OVER_WARNING_ERROR);
  case 75:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] != Enum_SYSTEM_VOLTAGE_STATUS_OVER_WARNING_ERROR);
  case 76:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_SYSTEM_VOLTAGE_STATUS_UNDER_WARNING_ERROR);
  case 77:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] != Enum_SYSTEM_VOLTAGE_STATUS_UNDER_WARNING_ERROR);
  case 78:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_SYSTEM_THERMAL_STATUS_CRITICAL_HIGH_ERROR);
  case 79:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] != Enum_SYSTEM_THERMAL_STATUS_CRITICAL_HIGH_ERROR);
  case 80:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGThermalUnderWarningError);
  case 81:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPThermalUnderWarningError);
  case 82:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCThermalUnderWarningError);
  case 83:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMAThermalUnderWarningError);
  case 84:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
  case 85:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCAVDECCDisconnected);
  case 86:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] == Enum_SYSTEM_THERMAL_STATUS_CRITICAL_LOW_ERROR);
  case 87:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT8Var[0] != Enum_SYSTEM_THERMAL_STATUS_CRITICAL_LOW_ERROR);
  case 88:
    return (VS_BOOL)(sm_IN_bIsAntiTheftActive && IN_bIsAntiTheftAvailable);
  case 89:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
  case 90:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_MIC2CenterActivePopup);
  case 91:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
  case 92:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_MIC3CenterActivePopup);
  case 93:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
  case 94:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_VOLUME_CENTER_POPUP);
  case 95:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_HourLogicMode);
  case 96:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_HomeScreen_CabinAPopup_Expand);
  case 97:
    return (VS_BOOL)(fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY && fnGetRegionId() == Enum_REGION_CABIN_A);
  case 98:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_HomeScreen_CabinBPopup_Expand);
  case 99:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
  case 100:
    return (VS_BOOL)(fnIsInf4cvSmartVariant() && sm_IN_bIsSPIConnected == HMI_SM_C_TRUE);
  case 101:
    return (VS_BOOL)(sm_IN_bIsSPIConnected == HMI_SM_C_TRUE);
  case 102:
    return (VS_BOOL)(fnIsInf4cvSmartVariant() && sm_IN_bIsSPIConnected == HMI_SM_C_FALSE);
  case 103:
    return (VS_BOOL)(sm_IN_bIsSPIConnected == HMI_SM_C_FALSE);
  case 104:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_SRC_Cockpit);
  case 105:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_SRC_Cabin);
  case 106:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGAVDECCDisconnected);
  case 107:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
  case 108:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
  case 109:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
  case 110:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGVoltageOverWarningError);
  case 111:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
  case 112:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
  case 113:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
  case 114:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPVoltageOverWarningError);
  case 115:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
  case 116:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCVoltageOverWarningError);
  case 117:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
  case 118:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMAVoltageOverWarningError);
  case 119:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
  case 120:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGThermalOverWarningError);
  case 121:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
  case 122:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMPThermalOverWarningError);
  case 123:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMCThermalOverWarningError);
  case 124:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMAThermalOverWarningError);
  case 125:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMASystemConnected);
  case 126:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRAVDECCDisconnected);
  case 127:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
  case 128:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRVoltageOverWarningError);
  case 129:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
  case 130:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRThermalOverWarningError);
  case 131:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Popups_Scenes_Pfo_CMRThermalUnderWarningError);
  case 132:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_MASTER);
  case 133:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_NAVIGATION);
  case 134:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_MEDIA);
  case 135:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_CAMERA);
  case 136:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_SYSTEM);
  case 137:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_SPI);
  case 138:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_TESTMODE);
  case 139:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_PHONE);
  case 140:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_TUNER);
  case 141:
    return (VS_BOOL)(EventArgsVar.DB189.VS_UINT32Var[0] == Enum_APPID_APPHMI_SXM);
  case 142:
    return (VS_BOOL)(IN_ShowFirstHMIAppStatus && !IN_IsStartupDone);
  case 143:
    return (VS_BOOL)(IN_ShowFirstHMIAppStatus && IN_IsStartupDone);
  case 144:
    return (VS_BOOL)(IN_MIC1Status && !sm_RVCStatus && IN_KDSStatus != 0);
  case 145:
    return (VS_BOOL)(sm_RVCStatus && IN_KDSStatus != 0);
  case 146:
    return (VS_BOOL)(!sm_RVCStatus && IN_IsLastAppActivationRequired && IN_KDSStatus != 0 && !IN_MIC1Status);
  case 147:
    return (VS_BOOL)(!sm_RVCStatus && !IN_IsLastAppActivationRequired && IN_KDSStatus != 0 && !IN_MIC1Status);
  case 148:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONG1 || EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONGUP);
  case 149:
    return (VS_BOOL)(sm_IN_bIsDisclaimerActive);
  case 150:
    return (VS_BOOL)(!sm_IN_bIsDisclaimerActive);
  case 151:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_UP || EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONG1 || EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONGUP);
  case 152:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_UP || EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONG3);
  case 153:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_ENCCODE_LEFT_ENCODER);
  case 154:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_ENCCODE_RIGHT_ENCODER);
  case 155:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_SWC_VOLUME_UP);
  case 156:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_SWC_VOLUME_DOWN);
  case 157:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_SWC_MUTE);
  case 158:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_SWC_DEMUTE);
  case 159:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_REMOTECONTROL_MUTE);
  case 160:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_REMOTECONTROL_VOLUMEDOWN);
  case 161:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_REMOTECONTROL_VOLUMEUP);
  case 162:
    return (VS_BOOL)(!sm_IN_bIsAntiTheftActive && sm_IN_bIsDisclaimerActive && !sm_RVCStatus);
  case 163:
    return (VS_BOOL)(!sm_IN_bIsAntiTheftActive && sm_IN_bIsDisclaimerActive && sm_RVCStatus);
  case 164:
    return (VS_BOOL)(!sm_IN_bIsAntiTheftActive && !sm_IN_bIsDisclaimerActive);
  case 165:
    return (VS_BOOL)(IN_KDSStatus != 0 && !sm_RVCStatus && !IN_MIC1Status);
  case 166:
    return (VS_BOOL)(IN_KDSStatus != 0 && !sm_RVCStatus && IN_MIC1Status);
  case 167:
    return (VS_BOOL)(fnGetVariantType() != Enum_VARIANT_TYPE_CABIN_ONLY && (VSDBVar.DB213.VS_UINT32Var[0] == M1_Scenes_MasterHome || VSDBVar.DB213.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_COCKPIT));
  case 168:
    return (VS_BOOL)(fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY || VSDBVar.DB213.VS_UINT32Var[0] == M1_Scenes_HomeScreen_CabinA || VSDBVar.DB213.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_CABIN_A);
  case 169:
    return (VS_BOOL)(VSDBVar.DB213.VS_UINT32Var[0] == M1_Scenes_HomeScreen_CabinB || VSDBVar.DB213.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_CABIN_B);
  case 170:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_SETTINGS || EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_REMOTECONTROL_SETUP);
  case 171:
    return (VS_BOOL)(Enum_hmibase_HARDKEYSTATE_LONG1);
  case 172:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_HK_HOME);
  case 173:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_HK_SETTINGS);
  case 174:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] != Enum_HARDKEYCODE_REMOTECONTROL_SETUP);
  case 175:
    return (VS_BOOL)(IN_KDSStatus != 0 && sm_RVCStatus);
  case 176:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT32Var[0] == Enum_HARDKEYCODE_HK_CABIN_SETTINGS && EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_UP);
  case 177:
    return (VS_BOOL)(IN_tu8AntitheftStatus == HMI_SM_C_HU_UNLOCKED && sm_RVCStatus);
  case 178:
    return (VS_BOOL)(IN_tu8AntitheftStatus == HMI_SM_C_HU_UNLOCKED && !sm_RVCStatus && sm_IN_bIsDisclaimerActive);
  case 179:
    return (VS_BOOL)(IN_tu8AntitheftStatus == HMI_SM_C_HU_UNLOCKED && !sm_RVCStatus && !sm_IN_bIsDisclaimerActive);
  case 180:
    return (VS_BOOL)(IN_tu8AntitheftStatus == HMI_SM_C_HU_LOCKED);
  case 181:
    return (VS_BOOL)(IN_tu8AntitheftStatus == HMI_SM_C_VID_MISSING);
  case 182:
    return (VS_BOOL)(fnIsRegionSupported(Enum_REGION_CABIN_B));
  case 183:
    return (VS_BOOL)(EventArgsVar.DB189.VS_INT32Var[0] <= 0);
  case 184:
    return (VS_BOOL)(EventArgsVar.DB155.VS_UINT8Var[0] == Enum_hmibase_HARDKEYSTATE_LONG1);
  case 185:
    return (VS_BOOL)(fnGetLastActiveCabinRegionId() == Enum_REG_A);
  case 186:
    return (VS_BOOL)(fnGetLastActiveCabinRegionId() == Enum_REG_B);
  case 187:
    return (VS_BOOL)(EventArgsVar.DB68.VS_UINT32Var[0] == Enum_REGION_CABIN_B);
  case 188:
    return (VS_BOOL)(EventArgsVar.DB189.VS_INT32Var[0] > 0);
  case 189:
    return (VS_BOOL)(fnIsRegionSupported(Enum_REG_B));
  case 190:
    return (VS_BOOL)(!fnIsRegionSupported(Enum_REG_B));
  case 191:
    return (VS_BOOL)(EventArgsVar.DB189.VS_INT32Var[0] >= 0);
  case 192:
    return (VS_BOOL)(fnGetVariantType() != Enum_VARIANT_TYPE_CABIN_ONLY && (VSDBVar.DB1.VS_UINT32Var[0] == M1_Scenes_MasterHome || VSDBVar.DB1.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_COCKPIT));
  case 193:
    return (VS_BOOL)(fnGetVariantType() == Enum_VARIANT_TYPE_CABIN_ONLY || VSDBVar.DB1.VS_UINT32Var[0] == M1_Scenes_HomeScreen_CabinA || VSDBVar.DB1.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_CABIN_A);
  }
  return (VS_BOOL)(VSDBVar.DB1.VS_UINT32Var[0] == M1_Scenes_HomeScreen_CabinB || VSDBVar.DB1.VS_UINT32Var[0] == 0 && fnGetRegionId() == Enum_REGION_CABIN_B);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_MasterStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    Notify_Init_Finished();
    break;
  case 1:
    acActivateMaster();
    break;
  case 4:
    acClearLastApplication();
    break;
  case 8:
    acHideAppFlyIn();
    break;
  case 9:
    acHideCommonButton();
    break;
  case 10:
    acLastApplicationReq();
    break;
  case 11:
    acNoAction();
    break;
  case 13:
    acReqHMIReadVIN();
    break;
  case 14:
    acReqSpeechSession();
    break;
  case 15:
    acRequestHmiSubState();
    break;
  case 16:
    acRequestReset();
    break;
  case 20:
    acShowAppflyIn();
    break;
  case 21:
    acShowCommonButton();
    break;
  case 22:
    acStartDisclaimerTimerReqMsg();
    break;
  case 23:
    acStopDisclaimerTimerReqMsg();
    break;
  case 24:
    acToggleUserOFF_ON();
    break;
  case 25:
    acUpdateSPM_HMI_ON();
    break;
  case 39:
    gacPopupFilterAllEnableReq();
    break;
  case 40:
    gacPopupFilterDisableReq();
    break;
  case 48:
    sm_Src_status = 0;
    break;
  case 49:
    sm_SrcCAbin_Status = 0;
    break;
  case 50:
    IN_ShowFirstHMIAppStatus = 1;
    break;
  case 51:
    IN_ShowTempHMIAppStatus = 0;
    break;
  case 52:
    IN_ShowTempHMIAppStatus = 1;
    break;
  case 53:
    IN_KDSStatus = EventArgsVar.DB155.VS_UINT8Var[0];
    break;
  case 54:
    IN_MIC1Status = EventArgsVar.DB88.VS_BOOLVar[0];
    break;
  case 55:
    IN_IsLastAppActivationRequired = 1;
    break;
  case 56:
    IN_IsHMIAppInitialized = 1;
    break;
  case 57:
    IN_MasterSurface_Foreground = 1;
    break;
  case 58:
    IN_tu8AntitheftStatus = EventArgsVar.DB155.VS_UINT8Var[0];
    break;
  case 59:
    sm_SpeechIconPressed = 1;
    break;
  case 60:
    sm_SRC_CockpitStatus = 0;
    break;
  case 61:
    sm_SRC_CockpitStatus = 1;
    break;
  case 62:
    sm_Src_status = 1;
    break;
  case 63:
    sm_SrcCAbin_Status = 1;
    break;
  case 64:
    sm_activeapplicationID = Enum_APPID_APPHMI_MASTER;
    break;
  case 65:
    sm_activeapplicationID = Enum_APPID_APPHMI_NAVIGATION;
    break;
  case 66:
    sm_activeapplicationID = Enum_APPID_APPHMI_MEDIA;
    break;
  case 67:
    sm_activeapplicationID = Enum_APPID_APPHMI_CAMERA;
    break;
  case 68:
    sm_activeapplicationID = Enum_APPID_APPHMI_SYSTEM;
    break;
  case 69:
    sm_activeapplicationID = Enum_APPID_APPHMI_SPI;
    break;
  case 70:
    sm_activeapplicationID = Enum_APPID_APPHMI_TESTMODE;
    break;
  case 71:
    sm_activeapplicationID = Enum_APPID_APPHMI_PHONE;
    break;
  case 72:
    sm_activeapplicationID = Enum_APPID_APPHMI_TUNER;
    break;
  case 73:
    sm_activeapplicationID = Enum_APPID_APPHMI_SXM;
    break;
  case 74:
    IN_IsLastAppActivationRequired = 0;
    break;
  case 75:
    IN_IsStartupDone = 1;
    break;
  case 76:
    sm_IN_bIsDisclaimerActive = 0;
    break;
  case 77:
    IN_IntraTransitionViewId = 0;
    break;
  case 78:
    FlyInVisibleStatus = 0;
    break;
  case 79:
    IN_bIsAntiTheftAvailable = 0;
    break;
  case 80:
    IN_IntraTransitionViewId = M1_Scenes_MasterHome;
    break;
  case 81:
    IN_IntraTransitionViewId = M1_Scenes_HomeScreen_CabinA;
    break;
  case 82:
    IN_IntraTransitionViewId = M1_Scenes_HomeScreen_CabinB;
    break;
  case 83:
    acPerformSceneStatusUpd(M1_Scenes_AppFlyIn, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 84:
    gacViewHideAndDestroyReq(M1_Scenes_AppFlyIn);
    break;
  case 85:
    gacViewCreateAndShowReq(M1_Scenes_HMI_OFF);
    break;
  case 86:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 87:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 88:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 89:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 90:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_SystemStartUpCompletion);
    break;
  case 91:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_SystemStartUpMode);
    break;
  case 92:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 93:
    gacViewHideAndDestroyReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 94:
    gacViewHideAndDestroyReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 95:
    gacViewHideAndDestroyReq(Popups_Scenes_Wait_Scene);
    break;
  case 96:
    gacViewHideAndDestroyReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 97:
    gacViewHideAndDestroyReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 98:
    gacViewHideAndDestroyReq(Popups_Scenes_SRC_Cabin);
    break;
  case 99:
    gacViewHideAndDestroyReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 100:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 101:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 102:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 103:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 104:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 105:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 106:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 107:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 108:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 109:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 110:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 111:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 112:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 113:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 114:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 115:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 116:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 117:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 118:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 119:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 120:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 121:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 122:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 123:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 124:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 125:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 126:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 127:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 128:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 129:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 130:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 131:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 132:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 133:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 134:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 135:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 136:
    gacViewHideAndDestroyReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 137:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 138:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 139:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 140:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 141:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 142:
    acExecuteContextSwitchRequest(EventArgsVar.DB153.VS_INT32Var[0], EventArgsVar.DB153.VS_INT32Var[1], EventArgsVar.DB153.VS_INT32Var[2], EventArgsVar.DB153.VS_INT32Var[3], EventArgsVar.DB153.VS_INT32Var[4], Enum_CONTEXT_SWITCH_REQUEST_EXECUTE_CODE_NONE);
    break;
  case 143:
    acExecuteContextSwitchRequest(EventArgsVar.DB153.VS_INT32Var[0], EventArgsVar.DB153.VS_INT32Var[1], EventArgsVar.DB153.VS_INT32Var[2], EventArgsVar.DB153.VS_INT32Var[3], EventArgsVar.DB153.VS_INT32Var[4], Enum_CONTEXT_SWITCH_REQUEST_EXECUTE_CODE_BACKGROUND);
    break;
  case 144:
    acExecuteCommonButtonActivationRequest(Enum_hmibase_Hide);
    break;
  case 145:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC, 0, 0);
    break;
  case 146:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_HOME);
    break;
  case 147:
    acSetSystemMuteRequest(Enum_REGION_COCKPIT, 1);
    break;
  case 148:
    acSetSystemMuteRequest(Enum_REGION_CABIN_A, 1);
    break;
  case 149:
    acSetSystemMuteRequest(Enum_REGION_CABIN_B, 1);
    break;
  case 150:
    acSetHmiStartupMuteRequest(0);
    break;
  case 151:
    acMasterAppFlyInButtonVisibleReq(0);
    break;
  case 152:
    acSetSystemMuteRequest(Enum_REGION_COCKPIT, 0);
    break;
  case 153:
    acSetSystemMuteRequest(Enum_REGION_CABIN_A, 0);
    break;
  case 154:
    acSetSystemMuteRequest(Enum_REGION_CABIN_B, 0);
    break;
  case 155:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 156:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 157:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 158:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 159:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 160:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 161:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 162:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 163:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 164:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 165:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 166:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 167:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_KDS_INPROGRESS);
    break;
  case 168:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_KDS_INPROGRESS, 0, 0);
    break;
  case 169:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 170:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_MIC1);
    break;
  case 171:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_MIC1, 0, 0);
    break;
  case 172:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_MIC1, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_HOME);
    break;
  case 173:
    gacViewClearReq(M1_Scenes_AppFlyIn);
    break;
  case 174:
    acPerformSceneStatusUpd(M1_Scenes_AppFlyIn, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 175:
    gacViewCreateAndShowReq(M1_Scenes_AppFlyIn);
    break;
  case 176:
    gacViewHideAndDestroyReq(M1_Scenes_HMI_OFF);
    break;
  case 177:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_MASTER, Enum_APPID_APPHMI_MASTER);
    break;
  case 178:
    gacViewHideAndDestroyReq(M1_Scenes_HomeScreen_1_POPUP_DEV);
    break;
  case 179:
    acStartAppPopupTimer(M1_Scenes_GoodBye, 10000);
    break;
  case 180:
    gacViewCreateAndShowReq(M1_Scenes_GoodBye);
    break;
  case 181:
    gacViewCreateAndShowReq(M1_Scenes_Infotainment_OFF);
    break;
  case 182:
    gacPopupFilterPrioEnableReq(3);
    break;
  case 183:
    gacViewHideAndDestroyReq(M1_Scenes_M_Diag);
    break;
  case 184:
    acDeactivateApplication(Enum_APPID_APPHMI_TUNER);
    break;
  case 185:
    acDeactivateApplication(Enum_APPID_APPHMI_SYSTEM);
    break;
  case 186:
    acDeactivateApplication(Enum_APPID_APPHMI_MEDIA);
    break;
  case 187:
    acDeactivateApplication(Enum_APPID_APPHMI_PHONE);
    break;
  case 188:
    acDeactivateApplication(Enum_APPID_APPHMI_NAVIGATION);
    break;
  case 189:
    acDeactivateApplication(Enum_APPID_APPHMI_TESTMODE);
    break;
  case 190:
    acDeactivateApplication(Enum_APPID_APPHMI_SPI);
    break;
  case 191:
    acDeactivateApplication(Enum_APPID_APPHMI_CAMERA);
    break;
  case 192:
    acDeactivateApplication(Enum_APPID_APPHMI_SXM);
    break;
  case 193:
    acPerformSceneStatusUpd(M1_Scenes_MasterHome, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 194:
    gacViewHideAndDestroyReq(M1_Scenes_MasterHome);
    break;
  case 195:
    acPerformSceneStatusUpd(M1_Scenes_HomeScreen_CabinA, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 196:
    gacViewHideAndDestroyReq(M1_Scenes_HomeScreen_CabinA);
    break;
  case 197:
    acPerformSceneStatusUpd(M1_Scenes_HomeScreen_CabinB, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 198:
    gacViewHideAndDestroyReq(M1_Scenes_HomeScreen_CabinB);
    break;
  case 199:
    gacViewHideAndDestroyReq(M1_Scenes_RVC_TESTMODE);
    break;
  case 200:
    gacViewHideAndDestroyReq(M1_Scenes_KDSUpdate_Inprogress);
    break;
  case 201:
    gacViewHideAndDestroyReq(M1_Scenes_MIC1);
    break;
  case 202:
    gacViewHideAndDestroyReq(M1_Scenes_Configuration_Required);
    break;
  case 203:
    gacViewHideAndDestroyReq(M1_Scenes_Device_Locked);
    break;
  case 204:
    gacViewHideAndDestroyReq(M1_Scenes_Disclaimer);
    break;
  case 205:
    gacViewClearReq(M1_Scenes_HomeScreen_1_POPUP_DEV);
    break;
  case 206:
    gacViewCreateAndShowReq(M1_Scenes_M_Diag);
    break;
  case 207:
    acExecuteCommonButtonActivationRequest(Enum_hmibase_Show);
    break;
  case 208:
    acEncoderStatusUpdateMsg(EventArgsVar.DB189.VS_UINT32Var[0], EventArgsVar.DB189.VS_INT32Var[0]);
    break;
  case 209:
    acEncoderStatusUpdateMsg(EventArgsVar.DB189.VS_UINT32Var[0], EventArgsVar.DB189.VS_INT32Var[0]);
    break;
  case 210:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 211:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 212:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 213:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 214:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 215:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 216:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_HOME);
    break;
  case 217:
    acContextSwitchWithLastActiveCabinRegion(0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_HOME);
    break;
  case 218:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 219:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 220:
    gacViewHideAndDestroyReq(M1_Scenes_Infotainment_OFF);
    break;
  case 221:
    gacViewHideAndDestroyReq(M1_Scenes_GoodBye);
    break;
  case 222:
    gacViewHideAndDestroyReq(M1_Scenes_AVRoutingAdapter_Failure);
    break;
  case 223:
    gacViewCreateAndShowReq(M1_Scenes_AVRoutingAdapter_Failure);
    break;
  case 224:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 225:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 226:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 227:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 228:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 229:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 230:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 231:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 232:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_SystemStartUpCompletion);
    break;
  case 233:
    gacViewShowReq(Popups_Scenes_Pfo_SystemStartUpCompletion);
    break;
  case 234:
    acStartAppPopupTimer(Popups_Scenes_Pfo_SystemStartUpCompletion, 10000);
    break;
  case 235:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_SystemStartUpMode);
    break;
  case 236:
    acRestartAppPopupTimer(Popups_Scenes_Pfo_SystemStartUpMode);
    break;
  case 237:
    gacViewShowReq(Popups_Scenes_Pfo_SystemStartUpMode);
    break;
  case 238:
    acStartAppPopupTimer(Popups_Scenes_Pfo_SystemStartUpMode, 10000);
    break;
  case 239:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 240:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 241:
    gacPopupSBCloseReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 242:
    gacPopupSBCloseReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 243:
    gacViewShowReq(Popups_Scenes_Wait_Scene);
    break;
  case 244:
    gacPopupSBCloseReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 245:
    gacPopupCreateAndSBShowReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 246:
    gacPopupSBCloseReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 247:
    gacPopupCreateAndSBShowReq(Popups_Scenes_SRC_Cabin);
    break;
  case 248:
    gacPopupSBCloseReq(Popups_Scenes_SRC_Cabin);
    break;
  case 249:
    gacViewHideReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 250:
    gacViewClearReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 251:
    gacViewShowReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 252:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 253:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 254:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 255:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 256:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 257:
    gacViewHideReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 258:
    gacViewClearReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 259:
    gacViewShowReq(Popups_Scenes_Pfo_CMPAVDECCDisconnected);
    break;
  case 260:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPAVDECCDisconnected, 3000);
    break;
  case 261:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 262:
    gacViewHideReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 263:
    gacViewClearReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 264:
    gacViewShowReq(Popups_Scenes_Pfo_CMAAVDECCDisconnected);
    break;
  case 265:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMAAVDECCDisconnected, 3000);
    break;
  case 266:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 267:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 268:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 269:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 270:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 271:
    gacViewHideReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 272:
    gacViewClearReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 273:
    gacViewShowReq(Popups_Scenes_Pfo_CMPNANOMsgDisconnected);
    break;
  case 274:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPNANOMsgDisconnected, 3000);
    break;
  case 275:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 276:
    gacViewHideReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 277:
    gacViewClearReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 278:
    gacViewShowReq(Popups_Scenes_Pfo_CMANANOMsgDisconnected);
    break;
  case 279:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMANANOMsgDisconnected, 3000);
    break;
  case 280:
    gacViewShowReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 281:
    acStartAppPopupTimer(Popups_Scenes_Pfo_KDSCompletion_Status, 5000);
    break;
  case 282:
    acStopAppPopupTimer(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 283:
    gacViewHideReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 284:
    gacViewClearReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 285:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_KDSCompletion_Status);
    break;
  case 286:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 287:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 288:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 289:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 290:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 291:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 292:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 293:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 294:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 295:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 296:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 297:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 298:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 299:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 300:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 301:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 302:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 303:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 304:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 305:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 306:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 307:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 308:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 309:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 310:
    gacViewShowReq(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 311:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGThermalUnderWarningError, 3000);
    break;
  case 312:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 313:
    gacViewHideReq(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 314:
    gacViewClearReq(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 315:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMGThermalUnderWarningError);
    break;
  case 316:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 317:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 318:
    gacViewShowReq(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 319:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPThermalUnderWarningError, 3000);
    break;
  case 320:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 321:
    gacViewHideReq(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 322:
    gacViewClearReq(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 323:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMPThermalUnderWarningError);
    break;
  case 324:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 325:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 326:
    gacViewShowReq(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 327:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCThermalUnderWarningError, 3000);
    break;
  case 328:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 329:
    gacViewHideReq(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 330:
    gacViewClearReq(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 331:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMCThermalUnderWarningError);
    break;
  case 332:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 333:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 334:
    gacViewShowReq(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 335:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMAThermalUnderWarningError, 3000);
    break;
  case 336:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 337:
    gacViewHideReq(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 338:
    gacViewClearReq(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 339:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMAThermalUnderWarningError);
    break;
  case 340:
    gacViewShowReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 341:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCNANOMsgDisconnected, 3000);
    break;
  case 342:
    gacViewHideReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 343:
    gacViewClearReq(Popups_Scenes_Pfo_CMCNANOMsgDisconnected);
    break;
  case 344:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 345:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 346:
    gacViewShowReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 347:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCAVDECCDisconnected, 3000);
    break;
  case 348:
    gacViewHideReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 349:
    gacViewClearReq(Popups_Scenes_Pfo_CMCAVDECCDisconnected);
    break;
  case 350:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 351:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 352:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 353:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 354:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 355:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 356:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 357:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 358:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 359:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 360:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 361:
    gacPopupSBCloseReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 362:
    gacPopupCreateAndSBShowReq(Popups_Scenes_Wait_Scene);
    break;
  case 363:
    gacPopupSBCloseReq(Popups_Scenes_Wait_Scene);
    break;
  case 364:
    gacPopupFilterPrioEnableReq(2);
    break;
  case 365:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC);
    break;
  case 366:
    acStartBeep(Enum_hmibase_BEEPTYPE_CLICK);
    break;
  case 367:
    acStartBeep(Enum_hmibase_BEEPTYPE_ERROR);
    break;
  case 368:
    acStartBeep(Enum_hmibase_BEEPTYPE_ROGER);
    break;
  case 369:
    acStartBeep(Enum_hmibase_BEEPTYPE_WARN);
    break;
  case 370:
    acStartBeep(Enum_hmibase_BEEPTYPE_SPEED_WARN);
    break;
  case 371:
    acStartBeep(Enum_hmibase_BEEPTYPE_POI);
    break;
  case 372:
    acMasterAppFlyInButtonVisibleReq(1);
    break;
  case 373:
    acEncoderStatusUpdateMsg(Enum_ENCCODE_RIGHT_ENCODER, EventArgsVar.DB149.VS_INT8Var[0]);
    break;
  case 374:
    acEncoderStatusUpdateMsg(Enum_ENCCODE_RIGHT_ENCODER, EventArgsVar.DB149.VS_INT8Var[0]);
    break;
  case 375:
    gacPopupCreateAndSBShowReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 376:
    gacPopupCreateAndSBShowReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 377:
    gacPopupCreateAndSBShowReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 378:
    gacPopupSBCloseReq(Popups_Scenes_SystemHeat_PopUp);
    break;
  case 379:
    gacPopupCreateAndSBShowReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 380:
    gacPopupCreateAndSBShowReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 381:
    gacPopupCreateAndSBShowReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 382:
    gacViewCreateAndShowReq(M1_Scenes_HomeScreen_1_POPUP_DEV);
    break;
  case 383:
    gacViewShowReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 384:
    acStartAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA, 3000);
    break;
  case 385:
    acStopAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 386:
    gacViewHideReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 387:
    gacViewClearReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 388:
    gacViewDestroyReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 389:
    acRestartAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 390:
    gacPopupSBCloseReq(Popups_Scenes_VOLUME_CENTER_POPUP_CABINA);
    break;
  case 391:
    gacViewShowReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 392:
    acStartAppPopupTimer(Popups_Scenes_Pfo_MIC2CenterActivePopup, 3000);
    break;
  case 393:
    acStopAppPopupTimer(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 394:
    gacViewHideReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 395:
    gacViewClearReq(Popups_Scenes_Pfo_MIC2CenterActivePopup);
    break;
  case 396:
    gacViewShowReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 397:
    acStartAppPopupTimer(Popups_Scenes_Pfo_MIC2CenterDeactivePopup, 3000);
    break;
  case 398:
    acStopAppPopupTimer(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 399:
    gacViewHideReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 400:
    gacViewClearReq(Popups_Scenes_Pfo_MIC2CenterDeactivePopup);
    break;
  case 401:
    gacViewShowReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 402:
    acStartAppPopupTimer(Popups_Scenes_Pfo_MIC3CenterActivePopup, 3000);
    break;
  case 403:
    acStopAppPopupTimer(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 404:
    gacViewHideReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 405:
    gacViewClearReq(Popups_Scenes_Pfo_MIC3CenterActivePopup);
    break;
  case 406:
    gacViewShowReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 407:
    acStartAppPopupTimer(Popups_Scenes_Pfo_MIC3CenterDeactivePopup, 3000);
    break;
  case 408:
    acStopAppPopupTimer(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 409:
    gacViewHideReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 410:
    gacViewClearReq(Popups_Scenes_Pfo_MIC3CenterDeactivePopup);
    break;
  case 411:
    gacViewShowReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 412:
    acStartAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP, 3000);
    break;
  case 413:
    acStopAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 414:
    gacViewHideReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 415:
    gacViewClearReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 416:
    gacViewDestroyReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 417:
    acRestartAppPopupTimer(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 418:
    gacPopupSBCloseReq(Popups_Scenes_VOLUME_CENTER_POPUP);
    break;
  case 419:
    gacViewShowReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 420:
    acStartAppPopupTimer(Popups_Scenes_Pfo_HourLogicMode, 5000);
    break;
  case 421:
    gacViewHideReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 422:
    gacViewClearReq(Popups_Scenes_Pfo_HourLogicMode);
    break;
  case 423:
    acHourLogicModeStateMsg(1);
    break;
  case 424:
    acHourLogicModeStateMsg(0);
    break;
  case 425:
    gacDeregisterForCloseOnTouchSessionReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 426:
    gacViewHideReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 427:
    gacViewClearReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 428:
    acContextSwitchFromHomeMsg(Enum_REG_A, sm_activeapplicationID, 0, Enum_APPID_APPHMI_MASTER, 80);
    break;
  case 429:
    acHandleSettingsMsg(Enum_REGION_CABIN_A);
    break;
  case 430:
    acContextSwitchFromHomeMsg(Enum_REGION_CABIN_A, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_NONE, Enum_APPID_APPHMI_TESTMODE, eActivityID_TESTMODE_SOURCESELECTION_SCREEN);
    break;
  case 431:
    acVolumeReq(VOLUME_STEP_INCREASE_VALUE, Enum_REGION_CABIN_A);
    break;
  case 432:
    acVolumeReq(VOLUME_STEP_DECREASE_VALUE, Enum_REGION_CABIN_A);
    break;
  case 433:
    acToggleMuteState(Enum_REGION_CABIN_A);
    break;
  case 434:
    acContextSwitchWithActiveRegion(Enum_APPID_APPHMI_MASTER, Enum_eActivityID_NONE, Enum_APPID_APPHMI_SYSTEM, Enum_eActivityID_MONITOR_SETTINGS);
    break;
  case 435:
    acActivateMIC(Enum_REGION_CABIN_A, 1, Enum_MIC_SOFTKEY);
    break;
  case 436:
    gacViewShowReq(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 437:
    gacRegisterForCloseOnTouchSession(Popups_Scenes_HomeScreen_CabinAPopup_Expand);
    break;
  case 438:
    gacDeregisterForCloseOnTouchSessionReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 439:
    gacViewHideReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 440:
    gacViewClearReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 441:
    acContextSwitchFromHomeMsg(Enum_REGION_CABIN_B, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_HOME);
    break;
  case 442:
    acHandleSettingsMsg(Enum_REGION_CABIN_B);
    break;
  case 443:
    acContextSwitchFromHomeMsg(Enum_REGION_CABIN_B, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_NONE, Enum_APPID_APPHMI_TESTMODE, eActivityID_TESTMODE_SOURCESELECTION_SCREEN);
    break;
  case 444:
    acVolumeReq(VOLUME_STEP_DECREASE_VALUE, Enum_REGION_CABIN_B);
    break;
  case 445:
    acVolumeReq(VOLUME_STEP_INCREASE_VALUE, Enum_REGION_CABIN_B);
    break;
  case 446:
    gacViewShowReq(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 447:
    gacRegisterForCloseOnTouchSession(Popups_Scenes_HomeScreen_CabinBPopup_Expand);
    break;
  case 448:
    gacDeregisterForCloseOnTouchSessionReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 449:
    gacViewHideReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 450:
    gacViewClearReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 451:
    acHandleSettingsMsg(Enum_REGION_COCKPIT);
    break;
  case 452:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_NONE, Enum_APPID_APPHMI_TESTMODE, eActivityID_TESTMODE_SOURCESELECTION_SCREEN);
    break;
  case 453:
    acToggleMuteState(Enum_REGION_COCKPIT);
    break;
  case 454:
    acVolumeReq(VOLUME_STEP_INCREASE_VALUE, Enum_REGION_COCKPIT);
    break;
  case 455:
    acVolumeReq(VOLUME_STEP_DECREASE_VALUE, Enum_REGION_COCKPIT);
    break;
  case 456:
    acContextSwitchFromHomeMsg(2, sm_activeapplicationID, 0, Enum_APPID_APPHMI_MASTER, 80);
    break;
  case 457:
    acActivateMIC(Enum_REGION_COCKPIT, 1, Enum_MIC_SOFTKEY);
    break;
  case 458:
    acActivate_Speech_Msg(BUTTONPRESS);
    break;
  case 459:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enPress, Enum_APPID_APPHMI_SPI);
    break;
  case 460:
    acActivate_Speech_Msg(BUTTONPRESSRELEASE);
    break;
  case 461:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enRelease, Enum_APPID_APPHMI_SPI);
    break;
  case 462:
    acActivate_Speech_Msg(BUTTONLONGPRESS);
    break;
  case 463:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enLongPress, Enum_APPID_APPHMI_SPI);
    break;
  case 464:
    acActivate_Speech_Msg(BUTTONLONGPRESSRELEASE);
    break;
  case 465:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enLongPressRelease, Enum_APPID_APPHMI_SPI);
    break;
  case 466:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enRelease, Enum_APPID_APPHMI_PHONE);
    break;
  case 467:
    acControlPanelButtonPressUpdate(Enum_CONTROLPANEL_BUTTON_SPEECH, Enum_enLongPress, Enum_APPID_APPHMI_PHONE);
    break;
  case 468:
    gacViewShowReq(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 469:
    gacRegisterForCloseOnTouchSession(Popups_Scenes_HomeScreen_1_POPUPEXP_DEV);
    break;
  case 470:
    gacDeregisterForCloseOnTouchSessionReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 471:
    acPerformSceneStatusUpd(Popups_Scenes_SRC_Cockpit, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 472:
    gacViewHideReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 473:
    gacViewClearReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 474:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 475:
    gacViewShowReq(Popups_Scenes_SRC_Cockpit);
    break;
  case 476:
    gacRegisterForCloseOnTouchSession(Popups_Scenes_SRC_Cockpit);
    break;
  case 477:
    acPerformSceneStatusUpd(Popups_Scenes_SRC_Cockpit, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 478:
    gacDeregisterForCloseOnTouchSessionReq(Popups_Scenes_SRC_Cabin);
    break;
  case 479:
    acPerformSceneStatusUpd(Popups_Scenes_SRC_Cabin, Enum_SCENE_STATUS_INACTIVE);
    break;
  case 480:
    gacViewHideReq(Popups_Scenes_SRC_Cabin);
    break;
  case 481:
    gacViewClearReq(Popups_Scenes_SRC_Cabin);
    break;
  case 482:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 483:
    gacViewShowReq(Popups_Scenes_SRC_Cabin);
    break;
  case 484:
    gacRegisterForCloseOnTouchSession(Popups_Scenes_SRC_Cabin);
    break;
  case 485:
    acPerformSceneStatusUpd(Popups_Scenes_SRC_Cabin, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 486:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 487:
    gacViewHideReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 488:
    gacViewClearReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 489:
    gacViewShowReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected);
    break;
  case 490:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGAVDECCDisconnected, 3000);
    break;
  case 491:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 492:
    gacViewHideReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 493:
    gacViewClearReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 494:
    gacViewShowReq(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix);
    break;
  case 495:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGAVDECCDisconnected_Mix, 3000);
    break;
  case 496:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 497:
    gacViewHideReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 498:
    gacViewClearReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 499:
    gacViewShowReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected);
    break;
  case 500:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGNANOMsgDisconnected, 3000);
    break;
  case 501:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 502:
    gacViewHideReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 503:
    gacViewClearReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 504:
    gacViewShowReq(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix);
    break;
  case 505:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGNANOMsgDisconnected_Mix, 3000);
    break;
  case 506:
    gacViewShowReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 507:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageOverWarningError, 3000);
    break;
  case 508:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 509:
    gacViewHideReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 510:
    gacViewClearReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError);
    break;
  case 511:
    gacViewShowReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 512:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix, 3000);
    break;
  case 513:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 514:
    gacViewHideReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 515:
    gacViewClearReq(Popups_Scenes_Pfo_CMGVoltageOverWarningError_Mix);
    break;
  case 516:
    gacViewShowReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 517:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageUnderWarningError, 3000);
    break;
  case 518:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 519:
    gacViewHideReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 520:
    gacViewClearReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError);
    break;
  case 521:
    gacViewShowReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 522:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix, 3000);
    break;
  case 523:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 524:
    gacViewHideReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 525:
    gacViewClearReq(Popups_Scenes_Pfo_CMGVoltageUnderWarningError_Mix);
    break;
  case 526:
    gacViewShowReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 527:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPVoltageOverWarningError, 3000);
    break;
  case 528:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 529:
    gacViewHideReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 530:
    gacViewClearReq(Popups_Scenes_Pfo_CMPVoltageOverWarningError);
    break;
  case 531:
    gacViewShowReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 532:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPVoltageUnderWarningError, 3000);
    break;
  case 533:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 534:
    gacViewHideReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 535:
    gacViewClearReq(Popups_Scenes_Pfo_CMPVoltageUnderWarningError);
    break;
  case 536:
    gacViewShowReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 537:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCVoltageOverWarningError, 3000);
    break;
  case 538:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 539:
    gacViewHideReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 540:
    gacViewClearReq(Popups_Scenes_Pfo_CMCVoltageOverWarningError);
    break;
  case 541:
    gacViewShowReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 542:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCVoltageUnderWarningError, 3000);
    break;
  case 543:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 544:
    gacViewHideReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 545:
    gacViewClearReq(Popups_Scenes_Pfo_CMCVoltageUnderWarningError);
    break;
  case 546:
    gacViewShowReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 547:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMAVoltageOverWarningError, 5000);
    break;
  case 548:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 549:
    gacViewHideReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 550:
    gacViewClearReq(Popups_Scenes_Pfo_CMAVoltageOverWarningError);
    break;
  case 551:
    gacViewShowReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 552:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMAVoltageUnderWarningError, 5000);
    break;
  case 553:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 554:
    gacViewHideReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 555:
    gacViewClearReq(Popups_Scenes_Pfo_CMAVoltageUnderWarningError);
    break;
  case 556:
    gacViewShowReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 557:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGThermalOverWarningError, 3000);
    break;
  case 558:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 559:
    gacViewHideReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 560:
    gacViewClearReq(Popups_Scenes_Pfo_CMGThermalOverWarningError);
    break;
  case 561:
    gacViewShowReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 562:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix, 3000);
    break;
  case 563:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 564:
    gacViewHideReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 565:
    gacViewClearReq(Popups_Scenes_Pfo_CMGThermalOverWarningError_Mix);
    break;
  case 566:
    gacViewShowReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 567:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMPThermalOverWarningError, 3000);
    break;
  case 568:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 569:
    gacViewHideReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 570:
    gacViewClearReq(Popups_Scenes_Pfo_CMPThermalOverWarningError);
    break;
  case 571:
    gacViewShowReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 572:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMCThermalOverWarningError, 3000);
    break;
  case 573:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 574:
    gacViewHideReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 575:
    gacViewClearReq(Popups_Scenes_Pfo_CMCThermalOverWarningError);
    break;
  case 576:
    gacViewShowReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 577:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMAThermalOverWarningError, 5000);
    break;
  case 578:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 579:
    gacViewHideReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 580:
    gacViewClearReq(Popups_Scenes_Pfo_CMAThermalOverWarningError);
    break;
  case 581:
    gacViewShowReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 582:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMASystemConnected, 3000);
    break;
  case 583:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 584:
    gacViewHideReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 585:
    gacViewClearReq(Popups_Scenes_Pfo_CMASystemConnected);
    break;
  case 586:
    gacViewShowReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 587:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRAVDECCDisconnected, 3000);
    break;
  case 588:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 589:
    gacViewHideReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 590:
    gacViewClearReq(Popups_Scenes_Pfo_CMRAVDECCDisconnected);
    break;
  case 591:
    gacViewShowReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 592:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRNANOMsgDisconnected, 3000);
    break;
  case 593:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 594:
    gacViewHideReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 595:
    gacViewClearReq(Popups_Scenes_Pfo_CMRNANOMsgDisconnected);
    break;
  case 596:
    gacViewShowReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 597:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRVoltageOverWarningError, 3000);
    break;
  case 598:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 599:
    gacViewHideReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 600:
    gacViewClearReq(Popups_Scenes_Pfo_CMRVoltageOverWarningError);
    break;
  case 601:
    gacViewShowReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 602:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRVoltageUnderWarningError, 3000);
    break;
  case 603:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 604:
    gacViewHideReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 605:
    gacViewClearReq(Popups_Scenes_Pfo_CMRVoltageUnderWarningError);
    break;
  case 606:
    gacViewShowReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 607:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRThermalOverWarningError, 3000);
    break;
  case 608:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 609:
    gacViewHideReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 610:
    gacViewClearReq(Popups_Scenes_Pfo_CMRThermalOverWarningError);
    break;
  case 611:
    gacViewShowReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 612:
    acStartAppPopupTimer(Popups_Scenes_Pfo_CMRThermalUnderWarningError, 3000);
    break;
  case 613:
    acStopAppPopupTimer(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 614:
    gacViewHideReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 615:
    gacViewClearReq(Popups_Scenes_Pfo_CMRThermalUnderWarningError);
    break;
  case 616:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_NAVIGATION, Enum_APPID_APPHMI_NAVIGATION);
    break;
  case 617:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_MEDIA, Enum_APPID_APPHMI_MEDIA);
    break;
  case 618:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_CAMERA, Enum_APPID_APPHMI_CAMERA);
    break;
  case 619:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_SYSTEM, Enum_APPID_APPHMI_SYSTEM);
    break;
  case 620:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_SPI, Enum_APPID_APPHMI_SPI);
    break;
  case 621:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_TESTMODE, Enum_APPID_APPHMI_TESTMODE);
    break;
  case 622:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_PHONE, Enum_APPID_APPHMI_PHONE);
    break;
  case 623:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_TUNER, Enum_APPID_APPHMI_TUNER);
    break;
  case 624:
    acActivateApplication(Enum_SURFACEID_MAIN_SURFACE_SXM, Enum_APPID_APPHMI_SXM);
    break;
  case 625:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 626:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_LEGAL_DISCLAIMER, 0, 0);
    break;
  case 627:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 628:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_LEGAL_DISCLAIMER);
    break;
  case 629:
    gacViewCreateAndShowReq(M1_Scenes_Disclaimer);
    break;
  case 630:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC_EARLY, 0, 0);
    break;
  case 631:
    acConnectAnalogCameraToPluginMsg(Enum_ANA_CAMERA1);
    break;
  case 632:
    acConnectAnalogCameraToPluginMsg(Enum_ANA_CAMERA2);
    break;
  case 633:
    acConnectAnalogCameraToPluginMsg(Enum_ANA_CAMERA3);
    break;
  case 634:
    acConnectAnalogCameraToPluginMsg(Enum_ANA_CAMERA4);
    break;
  case 635:
    acConnectAnalogCameraToPluginMsg(Enum_ANA_CAMERA_OFF);
    break;
  case 636:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 637:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 638:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_SECURITY_APP);
    break;
  case 639:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_LEGAL_DISCLAIMER);
    break;
  case 640:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, 0, 0, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC_EARLY);
    break;
  case 641:
    gacViewCreateAndShowReq(M1_Scenes_RVC_TESTMODE);
    break;
  case 642:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC);
    break;
  case 643:
    gacPopupFilterPrioEnableReq(1);
    break;
  case 644:
    gacViewCreateAndShowReq(M1_Scenes_KDSUpdate_Inprogress);
    break;
  case 645:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_KDS_INPROGRESS);
    break;
  case 646:
    gacViewCreateAndShowReq(M1_Scenes_MIC1);
    break;
  case 647:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_MIC1);
    break;
  case 648:
    acChangeRegion(Enum_REGION_COCKPIT);
    break;
  case 649:
    gacViewCreateAndShowReq(M1_Scenes_MasterHome);
    break;
  case 650:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, 80);
    break;
  case 651:
    acPerformSceneStatusUpd(M1_Scenes_MasterHome, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 652:
    acChangeRegion(Enum_REGION_CABIN_A);
    break;
  case 653:
    gacViewCreateAndShowReq(M1_Scenes_HomeScreen_CabinA);
    break;
  case 654:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_CABIN_A, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_CABINA_HOME);
    break;
  case 655:
    acPerformSceneStatusUpd(M1_Scenes_HomeScreen_CabinA, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 656:
    acChangeRegion(Enum_REGION_CABIN_B);
    break;
  case 657:
    gacViewCreateAndShowReq(M1_Scenes_HomeScreen_CabinB);
    break;
  case 658:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_CABIN_B, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_CABINB_HOME);
    break;
  case 659:
    acPerformSceneStatusUpd(M1_Scenes_HomeScreen_CabinB, Enum_SCENE_STATUS_ACTIVE);
    break;
  case 660:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, 0, Enum_APPID_APPHMI_SYSTEM, eActivityID_RVC_SETTINGS);
    break;
  case 661:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 662:
    acHKStatusUpdateMsg(EventArgsVar.DB155.VS_UINT32Var[0], EventArgsVar.DB155.VS_UINT8Var[0]);
    break;
  case 663:
    acMicVolumeReq(VOLUME_STEP_INCREASE_VALUE);
    break;
  case 664:
    acMicVolumeReq(VOLUME_STEP_DECREASE_VALUE);
    break;
  case 665:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, 0, Enum_APPID_APPHMI_SYSTEM, eActivityID_MIC_SETTINGS);
    break;
  case 666:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_MIC1, Enum_APPID_APPHMI_SYSTEM, eActivityID_MIC_SETTINGS);
    break;
  case 667:
    acActivateMIC(Enum_REGION_COCKPIT, 0, Enum_MIC_SOFTKEY);
    break;
  case 668:
    acStoreContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_RVC_EARLY);
    break;
  case 669:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, Enum_eActivityID_SECURITY_APP, 0, 0);
    break;
  case 670:
    gacViewCreateAndShowReq(M1_Scenes_Device_Locked);
    break;
  case 671:
    gacViewCreateAndShowReq(M1_Scenes_Configuration_Required);
    break;
  case 672:
    acContextSwitchFromHomeMsg(Enum_REGION_COCKPIT, Enum_APPID_APPHMI_MASTER, 0, Enum_APPID_APPHMI_SYSTEM, eActivityID_SETTINGS);
    break;

  default:
    break;
  }
}
