/************************************************************************
*FILE: AppHmi_MasterTypes.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_MasterTypes_h)
#define AppHmi_MasterTypes_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <AppHmi_MasterAudioConnectionTypes.h>
#include <ProjectBaseTypes.h>
enum enDummy {
    DUMMYINFO = 0
};
enum MMIStatesVal {
    MMISTATE_OFF = 0,
    MMISTATE_ON_FULL,
    MMISTATE_ON_FULL_STANDBY,
    MMISTATE_ON_FULL_DARK,
    MMISTATE_ON_PARTIAL,
    MMISTATE_ON_PARTIAL_STANDBY,
    MMISTATE_ON_PARTIAL_DARK,
    MMISTATE_ON_SECURE
};
enum enSceneStatus {
    SCENE_STATUS_NONE = 0,
    SCENE_STATUS_ACTIVE = 1,
    SCENE_STATUS_INACTIVE = 2
};
enum enMasterContexts {
    eActivityID_NONE = 0,
    eActivityID_HOME = 80,
    eActivityID_SECURITY_APP,
    eActivityID_CABINA_HOME,
    eActivityID_LEGAL_DISCLAIMER,
    eActivityID_CABINB_HOME,
    eActivityID_MONITOR_SETTINGS = 194,
    eActivityID_RVC = 240,
    eActivityID_RVC_EARLY = 242,
    eActivityID_KDS_INPROGRESS = 85,
    eActivityID_MIC1 = 86
};
enum enContextSwitchRequestExecuteCode {
    CONTEXT_SWITCH_REQUEST_EXECUTE_CODE_NONE = 0,
    CONTEXT_SWITCH_REQUEST_EXECUTE_CODE_REJECTED,
    CONTEXT_SWITCH_REQUEST_EXECUTE_CODE_BACKGROUND
};
enum enSystemVoltageStatus {
    SYSTEM_VOLTAGE_STATUS_NONE = 0,
    SYSTEM_VOLTAGE_STATUS_ERROR,
    SYSTEM_VOLTAGE_STATUS_NOERROR,
    SYSTEM_VOLTAGE_STATUS_OVER_WARNING_ERROR,
    SYSTEM_VOLTAGE_STATUS_OVER_CRITICAL_ERROR,
    SYSTEM_VOLTAGE_STATUS_UNDER_WARNING_ERROR,
    SYSTEM_VOLTAGE_STATUS_UNDER_CRITICAL_ERROR
};
enum enSystemThermalStatus {
    SYSTEM_THERMAL_STATUS_NONE = 0,
    SYSTEM_THERMAL_STATUS_ERROR,
    SYSTEM_THERMAL_STATUS_NOERROR,
    SYSTEM_THERMAL_STATUS_HIGH_ERROR,
    SYSTEM_THERMAL_STATUS_CRITICAL_HIGH_ERROR,
    SYSTEM_THERMAL_STATUS_OVER_CRITICAL_ERROR,
    SYSTEM_THERMAL_STATUS_LOW_ERROR,
    SYSTEM_THERMAL_STATUS_CRITICAL_LOW_ERROR,
    SYSTEM_THERMAL_STATUS_UNDER_CRITICAL_LOW_ERROR
};
enum enHmiState {
    HMI_STATE_OFF = 0,
    HMI_STATE_ON,
    HMI_STATE_STANDBY,
    HMI_STATE_INACTIVE,
    HMI_STATE_INFOTAINMENT_OFF,
    HMI_STATE_GOODBYE
};
enum enStatusCategory {
    STATUS_CATEGORY_NONE = 0,
    STATUS_CATEGORY_SYSTEM,
    STATUS_CATEGORY_AVDECC,
    STATUS_CATEGORY_NANOMSG,
    STATUS_CATEGORY_VOLTAGE,
    STATUS_CATEGORY_THERMAL,
    STATUS_CATEGORY_POWERMODE,
    STATUS_CATEGORY_HOURLOGIC
};
enum enRegionType {
    REGION_TYPE_UNKNOWN = 255,
    REGION_TYPE_USA = 0,
    REGION_TYPE_CAN = 1,
    REGION_TYPE_MEX = 2,
    REGION_TYPE_UK = 3,
    REGION_TYPE_TKY = 4,
    REGION_TYPE_RUS = 5,
    REGION_TYPE_OTH_EUR = 6,
    REGION_TYPE_PRC = 7,
    REGION_TYPE_TWN = 8,
    REGION_TYPE_HKG_MACAU = 9,
    REGION_TYPE_GCC = 10,
    REGION_TYPE_EGP = 11,
    REGION_TYPE_ASR_NZR = 12,
    REGION_TYPE_BRA = 13,
    REGION_TYPE_AGT = 14,
    REGION_TYPE_OTH_LAC = 15,
    REGION_TYPE_SAF = 16,
    REGION_TYPE_THI = 17,
    REGION_TYPE_SGP = 18,
    REGION_TYPE_MLY = 19,
    REGION_TYPE_BRN = 20,
    REGION_TYPE_INN = 21,
    REGION_TYPE_VNM = 22,
    REGION_TYPE_PHL = 23,
    REGION_TYPE_IND = 24,
    REGION_TYPE_JPN = 25,
    REGION_TYPE_KOR = 26,
    REGION_TYPE_OTH_GOM = 27,
    REGION_TYPE_ISR = 28
};
enum enMixSourceIndex {
    MixSource_UNKNOWN = 0,
    MixSource_MIC2 = 1,
    MixSource_MIC3 = 2,
    MixSource_NO_CARMODE = 3,
    MixSource_MIC2_CARMODE = 4,
    MixSource_MIC3_CARMODE = 5
};
enum enSystemGroupCategory {
    SYSTEM_GROUP_CATEGORY_NONE = 0,
    SYSTEM_GROUP_CATEGORY_CMG_CABIN,
    SYSTEM_GROUP_CATEGORY_CMG_CABIN_MIX
};
enum enMicKeyType {
    MIC_KEY_INVALID = 0,
    MIC_HARDKEY,
    MIC_SOFTKEY
};
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enDummy >::Append(::FeatStd::StringBuffer& stringBuffer, ::enDummy const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::MMIStatesVal >::Append(::FeatStd::StringBuffer& stringBuffer, ::MMIStatesVal const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSceneStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSceneStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMasterContexts >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMasterContexts const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enContextSwitchRequestExecuteCode >::Append(::FeatStd::StringBuffer& stringBuffer, ::enContextSwitchRequestExecuteCode const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSystemVoltageStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSystemVoltageStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSystemThermalStatus >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSystemThermalStatus const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enHmiState >::Append(::FeatStd::StringBuffer& stringBuffer, ::enHmiState const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enStatusCategory >::Append(::FeatStd::StringBuffer& stringBuffer, ::enStatusCategory const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enRegionType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enRegionType const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMixSourceIndex >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMixSourceIndex const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enSystemGroupCategory >::Append(::FeatStd::StringBuffer& stringBuffer, ::enSystemGroupCategory const & object);
    template<> ::FeatStd::UInt32 StringBufferAppender< ::enMicKeyType >::Append(::FeatStd::StringBuffer& stringBuffer, ::enMicKeyType const & object);
} // namespace FeatStd
#endif
#endif // AppHmi_MasterTypes_h
