/************************************************************************
*FILE: AppHmi_CameraStateMachineData.cpp 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/*
 * Id:        AppHmi_CameraStateMachineData.cpp
 *
 * Function:  VS System Data Source File.
 *
 * Generated: Wed Nov 22 14:45:32 2023
 *
 * Coder 7, 3, 2, 2426
 * 
 * This is an automatically generated file. It will be overwritten by the Coder.
 * 
 * DO NOT EDIT THE FILE!
 */


#include "AppHmi_CameraStateMachineSEMLibB.h"


#include "AppHmi_CameraStateMachineData.h"


#include <stdarg.h>


/*
 * VS System External Variable Definitions.
 */
VS_BOOL sm_BlackScreenStatus = 0;

VS_BOOL sm_gCMGStatus = 0;

VS_BOOL sm_gCMPStatus = 0;

VS_UINT8 sm_gCurrentRegion = 2u;

VS_BOOL sm_gRVCStatus = 0;


/*
 * SEM Deduct Function.
 */
unsigned char AppHmi_CameraStateMachine::SEM_Deduct (SEM_EVENT_TYPE EventNo, ...)
{
  va_list ap;

  va_start(ap, EventNo);
  if (SEM.State == 0x00u /* STATE_SEM_NOT_INITIALIZED */)
  {
    return SES_NOT_INITIALIZED;
  }
  if (VS_NOF_EVENTS <= EventNo)
  {
    return (SES_RANGE_ERR);
  }
  switch (EventNo)
  {
  case 83:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 87:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 88:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 89:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 90:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 91:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 92:
    EventArgsVar.DB92.VS_INT8Var[0] = (VS_INT8) va_arg(ap, VS_INT);
    break;

  case 102:
    EventArgsVar.DB103.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 103:
    EventArgsVar.DB103.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 104:
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 105:
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 106:
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 107:
    EventArgsVar.DB107.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 108:
    EventArgsVar.DB107.VS_INT32Var[0] = (VS_INT32) va_arg(ap, VS_INT32_VAARG);
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 109:
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 110:
    EventArgsVar.DB107.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 111:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  case 112:
    EventArgsVar.DB91.VS_UINT32Var[0] = (VS_UINT32) va_arg(ap, VS_UINT32_VAARG);
    break;

  default:
    break;
  }
  if (EventNo == SE_RESET)
  {
    SEM.EventNo = SE_RESET;
    SEM.DIt = 2;
  }
  else
  {
    SEM.EventNo = VS_TRIGGERLESS_TRIGGER;
    SEM.DIt = 0;
  }
  SEM.State = 0x02u; /* STATE_SEM_PREPARE */
  SEM.InitialEventNo = EventNo;

  va_end(ap);
  return (SES_OKAY);
}


/*
 * Guard Expression Functions.
 */
VS_BOOL AppHmi_CameraStateMachine::VSGuard (SEM_GUARD_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    return (VS_BOOL)(sm_gCMPStatus == 1 && sm_gRVCStatus == 0);
  case 1:
    return (VS_BOOL)(sm_gCurrentRegion == REGION_C);
  case 2:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 14);
  case 3:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 13);
  case 4:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
  case 5:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
  case 6:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 11);
  case 7:
    return (VS_BOOL)(EventArgsVar.DB91.VS_UINT32Var[0] == 12);
  }
  return (VS_BOOL)(sm_gCurrentRegion == REGION_A || sm_gCurrentRegion == REGION_B);
}


/*
 * Action Expressions Wrapper Function.
 */
VS_VOID AppHmi_CameraStateMachine::VSAction (SEM_ACTION_EXPRESSION_TYPE i)
{
  switch (i)
  {
  case 0:
    CabinCameraExitmsgRequest();
    break;
  case 2:
    CameraBackButton();
    break;
  case 3:
    CameraBlackScreenStartTimerRequest();
    break;
  case 4:
    CameraExitmsgRequest();
    break;
  case 5:
    CameraSplitStartmsgRequest();
    break;
  case 6:
    CameraStartmsgRequest();
    break;
  case 7:
    CameraStopmsgRequest();
    break;
  case 8:
    Notify_Init_Finished();
    break;
  case 10:
    Perform_Cockpit_Select();
    break;
  case 11:
    Perform_Main_Cabin_CamSrc_Select();
    break;
  case 12:
    Perform_Main_CamSrc_Select();
    break;
  case 13:
    Perform_Mixed_Source();
    break;
  case 14:
    Perform_Next_Camera();
    break;
  case 15:
    Perform_Previous_Camera();
    break;
  case 16:
    Perform_cabin_from_home_Select();
    break;
  case 17:
    SplitViewLeftCamMsgRequest();
    break;
  case 18:
    SplitViewRightCamMsgRequest();
    break;
  case 19:
    VisiblityOfCameraButtons();
    break;
  case 36:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Gadget_Cam_Cabin_Non_Navi_CameraHomeScreen_Cabin_Non_Navi);
    break;
  case 37:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Gadget_Cam_Non_Navi_CAM_GADGET_NON_NAVI);
    break;
  case 38:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 39:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 40:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Gadget_Cam_CAM_GADGET);
    break;
  case 41:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin);
    break;
  case 42:
    gacPopupCreateAndSBShowReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 43:
    gacPopupCreateAndSBShowReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 44:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_C_CameraStream);
    break;
  case 45:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_CameraSelection_list);
    break;
  case 46:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_C_CameraSplitScene);
    break;
  case 47:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_C_CameraFullSplit);
    break;
  case 48:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_C_CameraBlackScreenStream);
    break;
  case 49:
    gacViewHideAndDestroyReq(AppHmi_CameraApp_Scenes_C_CameraBlackScreenStreamforSplit);
    break;
  case 50:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_CameraSelection_list);
    break;
  case 51:
    Perform_Send_Context(250);
    break;
  case 52:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_C_CameraStream);
    break;
  case 53:
    Perform_Send_Context(251);
    break;
  case 54:
    Perform_Send_Context(252);
    break;
  case 55:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_C_CameraBlackScreenStreamforSplit);
    break;
  case 56:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_C_CameraBlackScreenStream);
    break;
  case 57:
    Perform_Send_Context(258);
    break;
  case 58:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_C_CameraSplitScene);
    break;
  case 59:
    gacViewCreateAllReq(AppHmi_CameraApp_Gadget_Cam_Cabin_Non_Navi_CameraHomeScreen_Cabin_Non_Navi);
    break;
  case 60:
    gacViewShowReq(AppHmi_CameraApp_Gadget_Cam_Cabin_Non_Navi_CameraHomeScreen_Cabin_Non_Navi);
    break;
  case 61:
    gacViewCreateReq(AppHmi_CameraApp_Gadget_Cam_Non_Navi_CAM_GADGET_NON_NAVI);
    break;
  case 62:
    gacViewShowReq(AppHmi_CameraApp_Gadget_Cam_Non_Navi_CAM_GADGET_NON_NAVI);
    break;
  case 63:
    gacViewCreateAndShowReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 64:
    gacViewHideReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 65:
    gacViewClearReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 66:
    gacPopupSBCloseReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Warning_Popup);
    break;
  case 67:
    gacViewHideReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 68:
    gacViewClearReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 69:
    gacPopupSBCloseReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 70:
    gacViewCreateAndShowReq(AppHmi_CameraApp_CameraSystemPopups_Camera_Not_configured);
    break;
  case 71:
    gacViewCreateReq(AppHmi_CameraApp_Gadget_Cam_CAM_GADGET);
    break;
  case 72:
    gacViewShowReq(AppHmi_CameraApp_Gadget_Cam_CAM_GADGET);
    break;
  case 73:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Gadget_Cam_Cabin_CameraHomeScreen_Cabin);
    break;
  case 74:
    gacViewCreateAndShowReq(AppHmi_CameraApp_Scenes_C_CameraFullSplit);
    break;

  default:
    break;
  }
}
