/************************************************************************
*FILE: AppHmi_CameraMessages.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(AppHmi_CameraMessages_h)
#define AppHmi_CameraMessages_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <ProjectBaseMsgs.h>
#include <AppHmi_CameraTypes.h>
#include <CanderaWidget/String/String.h>
// ------------------------------------------------------------------------
class SwitchApplicationReq : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SwitchApplicationReq, ::NotifierMessage, 0x8943A2E6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SwitchApplicationReq(enApplicationId const & aApplicationID, enSurfaceId const & aSurfaceID);
        virtual ~SwitchApplicationReq();

        enApplicationId const & GetApplicationID() const { return mApplicationID; }
        void SetApplicationID(enApplicationId const & value) { mApplicationID = value; }
        enSurfaceId const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(enSurfaceId const & value) { mSurfaceID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SwitchApplicationReq);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSwitchApplicationReqMetaData;
        static ::Courier::Message::ModifiableMetadata mSwitchApplicationReqModifiableMetadata;
        static const ::Courier::ComponentId mSwitchApplicationReqSubscriberList[];

        enApplicationId mApplicationID;
        enSurfaceId mSurfaceID;
};

// ------------------------------------------------------------------------
class CameraViewMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraViewMsg, ::NotifierMessage, 0x8AE765F1);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraViewMsg();
        virtual ~CameraViewMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraViewMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraViewMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraViewMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraViewBlackScreenTransistionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraViewBlackScreenTransistionMsg, ::NotifierMessage, 0x45DD8BFD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraViewBlackScreenTransistionMsg();
        virtual ~CameraViewBlackScreenTransistionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraViewBlackScreenTransistionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraViewBlackScreenTransistionMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraViewBlackScreenTransistionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraViewBlackScreenTileTransistionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraViewBlackScreenTileTransistionMsg, ::NotifierMessage, 0xA8C64B72);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CameraViewBlackScreenTileTransistionMsg();
        virtual ~CameraViewBlackScreenTileTransistionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraViewBlackScreenTileTransistionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraViewBlackScreenTileTransistionMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraViewBlackScreenTileTransistionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraBlackScreenStopTriggerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraBlackScreenStopTriggerMsg, ::NotifierMessage, 0x16CC8B3F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraBlackScreenStopTriggerMsg();
        virtual ~CameraBlackScreenStopTriggerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraBlackScreenStopTriggerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraBlackScreenStopTriggerMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraBlackScreenStopTriggerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraBackButtonMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraBackButtonMsg, ::NotifierMessage, 0xB607AE3A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraBackButtonMsg();
        virtual ~CameraBackButtonMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraBackButtonMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraBackButtonMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraBackButtonMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CabinSourceMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CabinSourceMsg, ::NotifierMessage, 0xE23DFF4D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CabinSourceMsg();
        virtual ~CabinSourceMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCabinSourceMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCabinSourceMsgModifiableMetadata;
        static const ::Courier::ComponentId mCabinSourceMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraToggleButton : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraToggleButton, ::NotifierMessage, 0x0B67EFD2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraToggleButton();
        virtual ~CameraToggleButton();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraToggleButtonMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraToggleButtonModifiableMetadata;
        static const ::Courier::ComponentId mCameraToggleButtonSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraExitMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraExitMsg, ::NotifierMessage, 0x04B1ED80);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraExitMsg();
        virtual ~CameraExitMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraExitMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraExitMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraExitMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CabinCameraExitMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CabinCameraExitMsg, ::NotifierMessage, 0x5B047404);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CabinCameraExitMsg();
        virtual ~CabinCameraExitMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCabinCameraExitMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCabinCameraExitMsgModifiableMetadata;
        static const ::Courier::ComponentId mCabinCameraExitMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class NextCameraActivate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NextCameraActivate, ::NotifierMessage, 0xBC2B8711);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        NextCameraActivate();
        virtual ~NextCameraActivate();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNextCameraActivateMetaData;
        static ::Courier::Message::ModifiableMetadata mNextCameraActivateModifiableMetadata;
        static const ::Courier::ComponentId mNextCameraActivateSubscriberList[];
};

// ------------------------------------------------------------------------
class PreviousCameraActivate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PreviousCameraActivate, ::NotifierMessage, 0x6AB78574);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PreviousCameraActivate();
        virtual ~PreviousCameraActivate();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPreviousCameraActivateMetaData;
        static ::Courier::Message::ModifiableMetadata mPreviousCameraActivateModifiableMetadata;
        static const ::Courier::ComponentId mPreviousCameraActivateSubscriberList[];
};

// ------------------------------------------------------------------------
class ButtonMainSrcActivate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ButtonMainSrcActivate, ::NotifierMessage, 0x995B94C5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ButtonMainSrcActivate(Courier::Int8 const & aSrcmode);
        virtual ~ButtonMainSrcActivate();

        Courier::Int8 const & GetSrcmode() const { return mSrcmode; }
        void SetSrcmode(Courier::Int8 const & value) { mSrcmode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ButtonMainSrcActivate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mButtonMainSrcActivateMetaData;
        static ::Courier::Message::ModifiableMetadata mButtonMainSrcActivateModifiableMetadata;
        static const ::Courier::ComponentId mButtonMainSrcActivateSubscriberList[];

        Courier::Int8 mSrcmode;
};

// ------------------------------------------------------------------------
class ButtonMainSrcCabinActivate : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ButtonMainSrcCabinActivate, ::NotifierMessage, 0xFE55CD08);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ButtonMainSrcCabinActivate(Courier::Int8 const & aSrcmode);
        virtual ~ButtonMainSrcCabinActivate();

        Courier::Int8 const & GetSrcmode() const { return mSrcmode; }
        void SetSrcmode(Courier::Int8 const & value) { mSrcmode = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ButtonMainSrcCabinActivate);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mButtonMainSrcCabinActivateMetaData;
        static ::Courier::Message::ModifiableMetadata mButtonMainSrcCabinActivateModifiableMetadata;
        static const ::Courier::ComponentId mButtonMainSrcCabinActivateSubscriberList[];

        Courier::Int8 mSrcmode;
};

// ------------------------------------------------------------------------
class ContextToMaster : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ContextToMaster, ::NotifierMessage, 0x308C6F56);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ContextToMaster(Courier::UInt16 const & aContextScene);
        virtual ~ContextToMaster();

        Courier::UInt16 const & GetContextScene() const { return mContextScene; }
        void SetContextScene(Courier::UInt16 const & value) { mContextScene = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ContextToMaster);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mContextToMasterMetaData;
        static ::Courier::Message::ModifiableMetadata mContextToMasterModifiableMetadata;
        static const ::Courier::ComponentId mContextToMasterSubscriberList[];

        Courier::UInt16 mContextScene;
};

// ------------------------------------------------------------------------
class CameraBlackScreenStartTimerMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraBlackScreenStartTimerMsg, ::NotifierMessage, 0xCB754FA6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraBlackScreenStartTimerMsg();
        virtual ~CameraBlackScreenStartTimerMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraBlackScreenStartTimerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraBlackScreenStartTimerMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraBlackScreenStartTimerMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraSourceSelectionMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraSourceSelectionMsg, ::NotifierMessage, 0x461D8FCC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraSourceSelectionMsg();
        virtual ~CameraSourceSelectionMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraSourceSelectionMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraSourceSelectionMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraSourceSelectionMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateCameraStreamMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateCameraStreamMsg, ::NotifierMessage, 0x27888B1E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateCameraStreamMsg();
        virtual ~ActivateCameraStreamMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateCameraStreamMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateCameraStreamMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateCameraStreamMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateCameraBlackScreenSplitStreamMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateCameraBlackScreenSplitStreamMsg, ::NotifierMessage, 0x2620CAB2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateCameraBlackScreenSplitStreamMsg();
        virtual ~ActivateCameraBlackScreenSplitStreamMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateCameraBlackScreenSplitStreamMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateCameraBlackScreenSplitStreamMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateCameraBlackScreenSplitStreamMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateCameraSplitStreamMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateCameraSplitStreamMsg, ::NotifierMessage, 0x6AEFB684);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateCameraSplitStreamMsg();
        virtual ~ActivateCameraSplitStreamMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateCameraSplitStreamMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateCameraSplitStreamMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateCameraSplitStreamMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateSplitFullScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateSplitFullScreenMsg, ::NotifierMessage, 0x1F2D50AA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateSplitFullScreenMsg();
        virtual ~ActivateSplitFullScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateSplitFullScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateSplitFullScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateSplitFullScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateSplitScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateSplitScreenMsg, ::NotifierMessage, 0xCFE51011);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateSplitScreenMsg();
        virtual ~ActivateSplitScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateSplitScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateSplitScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateSplitScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivateBlackScreenSplitScreenMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateBlackScreenSplitScreenMsg, ::NotifierMessage, 0x66318734);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivateBlackScreenSplitScreenMsg();
        virtual ~ActivateBlackScreenSplitScreenMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateBlackScreenSplitScreenMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateBlackScreenSplitScreenMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateBlackScreenSplitScreenMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraBackMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraBackMsg, ::NotifierMessage, 0xC7327D7F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraBackMsg();
        virtual ~CameraBackMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraBackMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraBackMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraBackMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraSplitStreamStartMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraSplitStreamStartMsg, ::NotifierMessage, 0x32808D35);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraSplitStreamStartMsg();
        virtual ~CameraSplitStreamStartMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraSplitStreamStartMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraSplitStreamStartMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraSplitStreamStartMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraSourceSelectionCabinMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraSourceSelectionCabinMsg, ::NotifierMessage, 0xD9D9C6A2);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraSourceSelectionCabinMsg();
        virtual ~CameraSourceSelectionCabinMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraSourceSelectionCabinMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraSourceSelectionCabinMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraSourceSelectionCabinMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraStreamStopMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraStreamStopMsg, ::NotifierMessage, 0x94750140);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraStreamStopMsg();
        virtual ~CameraStreamStopMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraStreamStopMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraStreamStopMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraStreamStopMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class CameraStreamStartMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CameraStreamStartMsg, ::NotifierMessage, 0xCF676919);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        CameraStreamStartMsg();
        virtual ~CameraStreamStartMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCameraStreamStartMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCameraStreamStartMsgModifiableMetadata;
        static const ::Courier::ComponentId mCameraStreamStartMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ButtonMixedSourceMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ButtonMixedSourceMsg, ::NotifierMessage, 0xF03773AA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ButtonMixedSourceMsg();
        virtual ~ButtonMixedSourceMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mButtonMixedSourceMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mButtonMixedSourceMsgModifiableMetadata;
        static const ::Courier::ComponentId mButtonMixedSourceMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class onHardKeyPress : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(onHardKeyPress, ::NotifierMessage, 0xE34D3E88);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        onHardKeyPress(Courier::UInt32 const & aHKCode, hmibase::HardKeyStateEnum const & aHKState);
        virtual ~onHardKeyPress();

        Courier::UInt32 const & GetHKCode() const { return mHKCode; }
        void SetHKCode(Courier::UInt32 const & value) { mHKCode = value; }
        hmibase::HardKeyStateEnum const & GetHKState() const { return mHKState; }
        void SetHKState(hmibase::HardKeyStateEnum const & value) { mHKState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(onHardKeyPress);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata monHardKeyPressMetaData;
        static ::Courier::Message::ModifiableMetadata monHardKeyPressModifiableMetadata;
        static const ::Courier::ComponentId monHardKeyPressSubscriberList[];

        Courier::UInt32 mHKCode;
        hmibase::HardKeyStateEnum mHKState;
};

// ------------------------------------------------------------------------
class ActiveRenderedView : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActiveRenderedView, ::NotifierMessage, 0xA2BF1EE3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActiveRenderedView(Courier::UInt32 const & aSurfaceId, Candera::String const & aViewName);
        virtual ~ActiveRenderedView();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Candera::String const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::String const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ActiveRenderedView);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActiveRenderedViewMetaData;
        static ::Courier::Message::ModifiableMetadata mActiveRenderedViewModifiableMetadata;
        static const ::Courier::ComponentId mActiveRenderedViewSubscriberList[];

        Courier::UInt32 mSurfaceId;
        Candera::String mViewName;
};

// ------------------------------------------------------------------------
class ActivatePopupMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivatePopupMsg, ::NotifierMessage, 0x4202C8DD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivatePopupMsg();
        virtual ~ActivatePopupMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivatePopupMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivatePopupMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivatePopupMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class ActivatePopupNotConfigMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivatePopupNotConfigMsg, ::NotifierMessage, 0x10D474FD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ActivatePopupNotConfigMsg();
        virtual ~ActivatePopupNotConfigMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivatePopupNotConfigMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivatePopupNotConfigMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivatePopupNotConfigMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SplitViewLeftCamMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SplitViewLeftCamMsg, ::NotifierMessage, 0x0F4F9298);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SplitViewLeftCamMsg();
        virtual ~SplitViewLeftCamMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSplitViewLeftCamMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSplitViewLeftCamMsgModifiableMetadata;
        static const ::Courier::ComponentId mSplitViewLeftCamMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class SplitViewRightCamMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SplitViewRightCamMsg, ::NotifierMessage, 0x53600BB7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SplitViewRightCamMsg();
        virtual ~SplitViewRightCamMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSplitViewRightCamMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSplitViewRightCamMsgModifiableMetadata;
        static const ::Courier::ComponentId mSplitViewRightCamMsgSubscriberList[];
};

#endif // AppHmi_CameraMessages_h
