/************************************************************************
*FILE: GadgetMsgs.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(hmibase_gadget_GadgetMsgs_h)
#define hmibase_gadget_GadgetMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Foundation/FoundationMsgs.h>
#include <BaseContract/generated/GadgetTypes.h>
#include <vector>
#include <Candera/System/Mathematics/Vector2.h>

namespace hmibase {
namespace gadget {
// ------------------------------------------------------------------------
class IdUpdMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(IdUpdMsg, ::Courier::Message, 0xC5FE5DA0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        IdUpdMsg(Courier::UInt32 const & aDrmId);
        virtual ~IdUpdMsg();

        Courier::UInt32 const & GetDrmId() const { return mdrmId; }
        void SetDrmId(Courier::UInt32 const & value) { mdrmId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(IdUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mIdUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mIdUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mIdUpdMsgSubscriberList[];

        Courier::UInt32 mdrmId;
};

// ------------------------------------------------------------------------
class ConsumerMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ConsumerMsg, ::Courier::Message, 0x885C81B5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ConsumerMsg();
        ConsumerMsg(std::vector<Courier::Int32> const & aInstIds, bool const & aReset = false);
        virtual ~ConsumerMsg();

        std::vector<Courier::Int32> const & GetInstIds() const { return minstIds; }
        void SetInstIds(std::vector<Courier::Int32> const & value) { minstIds = value; }
        bool const & GetReset() const { return mReset; }
        void SetReset(bool const & value) { mReset = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mConsumerMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mConsumerMsgModifiableMetadata;
        static const ::Courier::ComponentId mConsumerMsgSubscriberList[];

        std::vector<Courier::Int32> minstIds;
        bool mReset;
};

// ------------------------------------------------------------------------
         /** This message can be used in model and controller to sync with provider udpate
         */
class ProviderUpdateIndicationMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ProviderUpdateIndicationMsg, ::Courier::Message, 0x4F880F2D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ProviderUpdateIndicationMsg(std::vector<Courier::Int32> const & aInstIds);
        virtual ~ProviderUpdateIndicationMsg();

        std::vector<Courier::Int32> const & GetInstIds() const { return minstIds; }
        void SetInstIds(std::vector<Courier::Int32> const & value) { minstIds = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ProviderUpdateIndicationMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mProviderUpdateIndicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mProviderUpdateIndicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mProviderUpdateIndicationMsgSubscriberList[];

        std::vector<Courier::Int32> minstIds;
};

// ------------------------------------------------------------------------
         /** TouchMsg which may be used to forward a touch from a DirectTexture Object to the original maintainer
         */
class TouchForwardReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TouchForwardReqMsg, ::Courier::Message, 0xB5F589C3);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TouchForwardReqMsg(Courier::TouchMsgState::Enum const & aState, Courier::XYDIM const & aXPos, Courier::XYDIM const & aYPos, Courier::UInt32 const & aTimeStamp, Courier::UInt32 const & aInstanceId);
        virtual ~TouchForwardReqMsg();

        Courier::TouchMsgState::Enum const & GetState() const { return mState; }
        void SetState(Courier::TouchMsgState::Enum const & value) { mState = value; }
        Courier::XYDIM const & GetXPos() const { return mXPos; }
        void SetXPos(Courier::XYDIM const & value) { mXPos = value; }
        Courier::XYDIM const & GetYPos() const { return mYPos; }
        void SetYPos(Courier::XYDIM const & value) { mYPos = value; }
        Courier::UInt32 const & GetTimeStamp() const { return mTimeStamp; }
        void SetTimeStamp(Courier::UInt32 const & value) { mTimeStamp = value; }
        Courier::UInt32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::UInt32 const & value) { mInstanceId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchForwardReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTouchForwardReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTouchForwardReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTouchForwardReqMsgSubscriberList[];

        Courier::TouchMsgState::Enum mState;
        Courier::XYDIM mXPos;
        Courier::XYDIM mYPos;
        Courier::UInt32 mTimeStamp;
        Courier::UInt32 mInstanceId;
};

// ------------------------------------------------------------------------
         /** request touch abort from DirectTexture Object to the original maintainer
         */
class TouchAbortReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TouchAbortReqMsg, ::Courier::Message, 0xA60624BC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TouchAbortReqMsg(Courier::UInt32 const & aInstanceId);
        virtual ~TouchAbortReqMsg();

        Courier::UInt32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::UInt32 const & value) { mInstanceId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchAbortReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTouchAbortReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTouchAbortReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTouchAbortReqMsgSubscriberList[];

        Courier::UInt32 mInstanceId;
};

// ------------------------------------------------------------------------
         /** 
         *    don't use deprecated member Activate, use member TargetState instead 
         */
class ActivateImageProviderReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ActivateImageProviderReqMsg, ::Courier::Message, 0xC613E40C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ActivateImageProviderReqMsg();
        ActivateImageProviderReqMsg(Courier::Int32 const & aInstanceId, bool const & aActivate, hmibase::gadget::gadgetSceneStatus const & aTargetState = hmibase::gadget::UNDEFINED);
        virtual ~ActivateImageProviderReqMsg();

        Courier::Int32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::Int32 const & value) { mInstanceId = value; }
        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }
        hmibase::gadget::gadgetSceneStatus const & GetTargetState() const { return mTargetState; }
        void SetTargetState(hmibase::gadget::gadgetSceneStatus const & value) { mTargetState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mActivateImageProviderReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mActivateImageProviderReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mActivateImageProviderReqMsgSubscriberList[];

        Courier::Int32 mInstanceId;
        bool mActivate;
        hmibase::gadget::gadgetSceneStatus mTargetState;
};

// ------------------------------------------------------------------------
          /** request an external image (gadget) to activate/deactivate */
class ExternalImageProviderReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExternalImageProviderReqMsg, ::Courier::Message, 0x5AE67E86);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExternalImageProviderReqMsg();
        ExternalImageProviderReqMsg(Courier::Int32 const & aInstanceId, bool const & aActivate, hmibase::gadget::gadgetSceneStatus const & aTargetState = hmibase::gadget::UNDEFINED);
        virtual ~ExternalImageProviderReqMsg();

        Courier::Int32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::Int32 const & value) { mInstanceId = value; }
        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }
        hmibase::gadget::gadgetSceneStatus const & GetTargetState() const { return mTargetState; }
        void SetTargetState(hmibase::gadget::gadgetSceneStatus const & value) { mTargetState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExternalImageProviderReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExternalImageProviderReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mExternalImageProviderReqMsgSubscriberList[];

        Courier::Int32 mInstanceId;
        bool mActivate;
        hmibase::gadget::gadgetSceneStatus mTargetState;
};

// ------------------------------------------------------------------------
          /** request a group of external images (gadget) to activate/deactivate */
class ExternalImageProviderGroupReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExternalImageProviderGroupReqMsg, ::Courier::Message, 0x95373433);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExternalImageProviderGroupReqMsg();
        ExternalImageProviderGroupReqMsg(std::vector<Courier::Int32> const & aInstanceIds, bool const & aActivate, hmibase::gadget::gadgetSceneStatus const & aTargetState = hmibase::gadget::UNDEFINED);
        virtual ~ExternalImageProviderGroupReqMsg();

        std::vector<Courier::Int32> const & GetInstanceIds() const { return mInstanceIds; }
        void SetInstanceIds(std::vector<Courier::Int32> const & value) { mInstanceIds = value; }
        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }
        hmibase::gadget::gadgetSceneStatus const & GetTargetState() const { return mTargetState; }
        void SetTargetState(hmibase::gadget::gadgetSceneStatus const & value) { mTargetState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExternalImageProviderGroupReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExternalImageProviderGroupReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mExternalImageProviderGroupReqMsgSubscriberList[];

        std::vector<Courier::Int32> mInstanceIds;
        bool mActivate;
        hmibase::gadget::gadgetSceneStatus mTargetState;
};

// ------------------------------------------------------------------------
        /**
        Report status of drm buffer allocation
        */
class DrmAllocationStatusMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DrmAllocationStatusMsg, ::Courier::Message, 0x3266CACA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DrmAllocationStatusMsg();
        DrmAllocationStatusMsg(drmBufferAllocationStatus const & aStatus, Courier::UInt32 const & aSize);
        virtual ~DrmAllocationStatusMsg();

        drmBufferAllocationStatus const & GetStatus() const { return mStatus; }
        void SetStatus(drmBufferAllocationStatus const & value) { mStatus = value; }
        Courier::UInt32 const & GetSize() const { return mSize; }
        void SetSize(Courier::UInt32 const & value) { mSize = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDrmAllocationStatusMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDrmAllocationStatusMsgModifiableMetadata;
        static const ::Courier::ComponentId mDrmAllocationStatusMsgSubscriberList[];

        drmBufferAllocationStatus mStatus;
        Courier::UInt32 mSize;
};

// ------------------------------------------------------------------------
        /**
        Request for drm garbage collection
        */
class DrmGarbageCollectorReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DrmGarbageCollectorReqMsg, ::Courier::Message, 0x69FD8C2C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DrmGarbageCollectorReqMsg();
        virtual ~DrmGarbageCollectorReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDrmGarbageCollectorReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDrmGarbageCollectorReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDrmGarbageCollectorReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DrmGCTimeoutMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DrmGCTimeoutMsg, ::Courier::Message, 0xF7FA81AE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DrmGCTimeoutMsg();
        virtual ~DrmGCTimeoutMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDrmGCTimeoutMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDrmGCTimeoutMsgModifiableMetadata;
        static const ::Courier::ComponentId mDrmGCTimeoutMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class PositionBaseMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PositionBaseMsg, ::Courier::Message, 0xB184780B);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        PositionBaseMsg();
        PositionBaseMsg(Courier::UInt32 const & aInstanceId, bool const & aIPCForwarding);
        virtual ~PositionBaseMsg();

        Courier::UInt32 const & GetInstanceId() const { return minstanceId; }
        void SetInstanceId(Courier::UInt32 const & value) { minstanceId = value; }
        bool const & GetIPCForwarding() const { return mIPCForwarding; }
        void SetIPCForwarding(bool const & value) { mIPCForwarding = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPositionBaseMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPositionBaseMsgModifiableMetadata;
        static const ::Courier::ComponentId mPositionBaseMsgSubscriberList[];

        Courier::UInt32 minstanceId;
        bool mIPCForwarding;
};

// ------------------------------------------------------------------------
class SlaveSurfaceRepositionBaseMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SlaveSurfaceRepositionBaseMsg, ::Courier::Message, 0xDFA54684);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        SlaveSurfaceRepositionBaseMsg();
        SlaveSurfaceRepositionBaseMsg(bool const & aActivate, Courier::UInt32 const & aSlaveSurfaceId, bool const & aIPCForwarding);
        virtual ~SlaveSurfaceRepositionBaseMsg();

        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }
        Courier::UInt32 const & GetSlaveSurfaceId() const { return mSlaveSurfaceId; }
        void SetSlaveSurfaceId(Courier::UInt32 const & value) { mSlaveSurfaceId = value; }
        bool const & GetIPCForwarding() const { return mIPCForwarding; }
        void SetIPCForwarding(bool const & value) { mIPCForwarding = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSlaveSurfaceRepositionBaseMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSlaveSurfaceRepositionBaseMsgModifiableMetadata;
        static const ::Courier::ComponentId mSlaveSurfaceRepositionBaseMsgSubscriberList[];

        bool mActivate;
        Courier::UInt32 mSlaveSurfaceId;
        bool mIPCForwarding;
};

// ------------------------------------------------------------------------
         /** DirectTextureConsumerContentIndicationMsg is used by direct texture consumer widget to notify it's content availability status          */
class DirectTextureConsumerContentIndicationMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DirectTextureConsumerContentIndicationMsg, ::Courier::Message, 0x42091B6F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DirectTextureConsumerContentIndicationMsg();
        DirectTextureConsumerContentIndicationMsg(hmibase::gadget::gadgetContentStatus const & aStatus, Courier::UInt32 const & aInstanceId);
        virtual ~DirectTextureConsumerContentIndicationMsg();

        hmibase::gadget::gadgetContentStatus const & GetStatus() const { return mStatus; }
        void SetStatus(hmibase::gadget::gadgetContentStatus const & value) { mStatus = value; }
        Courier::UInt32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::UInt32 const & value) { mInstanceId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDirectTextureConsumerContentIndicationMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDirectTextureConsumerContentIndicationMsgModifiableMetadata;
        static const ::Courier::ComponentId mDirectTextureConsumerContentIndicationMsgSubscriberList[];

        hmibase::gadget::gadgetContentStatus mStatus;
        Courier::UInt32 mInstanceId;
};

// ------------------------------------------------------------------------
          /**
             Request current position information from DirectTextureConsumer 
          */
class PositionInfoReqMsg : public ::hmibase::gadget::PositionBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PositionInfoReqMsg, ::hmibase::gadget::PositionBaseMsg, 0xFFDDFDE4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PositionInfoReqMsg();
        PositionInfoReqMsg(Courier::UInt32 const & aInstanceId, bool const & aIPCForwarding);
        virtual ~PositionInfoReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPositionInfoReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPositionInfoReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPositionInfoReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
          /**
          Response on PositionInfoReqMsg
          */
class PositionInfoResMsg : public ::hmibase::gadget::PositionBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PositionInfoResMsg, ::hmibase::gadget::PositionBaseMsg, 0x90BC313F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        PositionInfoResMsg();
        PositionInfoResMsg(Courier::UInt32 const & aInstanceId, bool const & aIPCForwarding, Candera::Vector2 const & aPosition);
        virtual ~PositionInfoResMsg();

        Candera::Vector2 const & GetPosition() const { return mPosition; }
        void SetPosition(Candera::Vector2 const & value) { mPosition = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPositionInfoResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPositionInfoResMsgModifiableMetadata;
        static const ::Courier::ComponentId mPositionInfoResMsgSubscriberList[];

        Candera::Vector2 mPosition;
};

// ------------------------------------------------------------------------
          /**
             Request a DirectTextureConsumer to stop/start slaveSurface repositioning
          */
class SlaveSurfaceRepositionReqMsg : public ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SlaveSurfaceRepositionReqMsg, ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 0x3DA202B4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SlaveSurfaceRepositionReqMsg();
        SlaveSurfaceRepositionReqMsg(bool const & aActivate, Courier::UInt32 const & aSlaveSurfaceId, bool const & aIPCForwarding);
        virtual ~SlaveSurfaceRepositionReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSlaveSurfaceRepositionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSlaveSurfaceRepositionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSlaveSurfaceRepositionReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
          /**
          Response on SlaveSurfaceRepositionReqMsg
          */
class SlaveSurfaceRepositionResMsg : public ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SlaveSurfaceRepositionResMsg, ::hmibase::gadget::SlaveSurfaceRepositionBaseMsg, 0x76D32DC5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        SlaveSurfaceRepositionResMsg();
        SlaveSurfaceRepositionResMsg(bool const & aActivate, Courier::UInt32 const & aSlaveSurfaceId, bool const & aIPCForwarding, bool const & aStatus);
        virtual ~SlaveSurfaceRepositionResMsg();

        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSlaveSurfaceRepositionResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSlaveSurfaceRepositionResMsgModifiableMetadata;
        static const ::Courier::ComponentId mSlaveSurfaceRepositionResMsgSubscriberList[];

        bool mStatus;
};
} // namespace gadget
} // namespace hmibase

#endif // hmibase_gadget_GadgetMsgs_h
#include "Gadget/Contract/deprecated.h"
