/************************************************************************
*FILE: BaseMsgs.h 
*SW-COMPONENT: HMI 
*DESCRIPTION: -
*AUTHOR: generated
*COPYRIGHT: (c) Robert Bosch GmbH 2015. All rights reserved, also 
*           regarding any disposal, exploitation, reproduction, editing,
*           distribution, as well as in the event of applications for
*           industrial property rights.
************************************************************************/

/* ------------------------------------------------------------------------ */
/* This file has been generated with a XCDL based generator. If you edit    */
/* this file manually your changes may be overwritten by an automatic code  */
/* generation process.                                                      */
/* ------------------------------------------------------------------------ */

#if !defined(BaseMsgs_h)
#define BaseMsgs_h

#if !defined COURIER_DISABLED
#include <Courier/Base.h>
#endif
#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
#include <Courier/Serialization/BaseSerializer.h>
#endif
#include <Courier/Messaging/Message.h>
#include <Courier/Platform/MessageFactory.h>
#include <Courier/Visualization/VisualizationMsgs.h>
#include <Courier/Foundation/FoundationMsgs.h>
#include <Courier/DataBinding/DataBindingMsgs.h>
#include <BaseContract/generated/BaseConstants.h>
#include <BaseContract/generated/BaseTypes.h>
#include <BaseContract/generated/BaseTouchSessionMsgs.h>
#include <BaseContract/generated/GadgetMsgs.h>
#include <CanderaWidget/String/String.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>
#include <Trace/SurfaceInfoProvider.h>
#include <AppUtils/Timer.h>
#include <vector>
namespace Candera
{
   class Widget2D;
}
namespace Focus
{
   class FSession;
}

class WidgetCheckCallback
{
public:
  virtual ~WidgetCheckCallback() {}
  virtual bool CheckWidget(Candera::Widget2D* widget) = 0;
};
// ------------------------------------------------------------------------
        /* Most of the widgets from a view are stored in a container inside the view.
         * However there are widgets like the list widget which also store some widget internally and not in the view.
         * This message allows to execute a callback for each widget inside a view (those stored directly in the view and those stored inside other containers).
         */
class WidgetCheckReqMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(WidgetCheckReqMsg, ::Courier::Message, 0x37F98268);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        WidgetCheckReqMsg(WidgetCheckCallback* const & aCallback);
        virtual ~WidgetCheckReqMsg();

        WidgetCheckCallback* const & GetCallback() const { return mCallback; }
        void SetCallback(WidgetCheckCallback* const & value) { mCallback = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(WidgetCheckReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mWidgetCheckReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mWidgetCheckReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mWidgetCheckReqMsgSubscriberList[];

        WidgetCheckCallback* mCallback;
};

// ------------------------------------------------------------------------
class NotifierMessage : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(NotifierMessage, ::Courier::Message, 0xB64498A4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        NotifierMessage();
        virtual ~NotifierMessage();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mNotifierMessageMetaData;
        static ::Courier::Message::ModifiableMetadata mNotifierMessageModifiableMetadata;
        static const ::Courier::ComponentId mNotifierMessageSubscriberList[];
};

// ------------------------------------------------------------------------
class TimerExpiredMsg : public ::Courier::Message
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TimerExpiredMsg, ::Courier::Message, 0x09F81AFC);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        TimerExpiredMsg(::Util::Timer* const & aTimer, Courier::UInt32 const & aTimoutCnt, Courier::UInt32 const & aRepeatCnt);
        virtual ~TimerExpiredMsg();

        ::Util::Timer* const & GetTimer() const { return mTimer; }
        void SetTimer(::Util::Timer* const & value) { mTimer = value; }
        Courier::UInt32 const & GetTimoutCnt() const { return mTimoutCnt; }
        void SetTimoutCnt(Courier::UInt32 const & value) { mTimoutCnt = value; }
        Courier::UInt32 const & GetRepeatCnt() const { return mRepeatCnt; }
        void SetRepeatCnt(Courier::UInt32 const & value) { mRepeatCnt = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TimerExpiredMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTimerExpiredMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTimerExpiredMsgModifiableMetadata;
        static const ::Courier::ComponentId mTimerExpiredMsgSubscriberList[];

        ::Util::Timer* mTimer;
        Courier::UInt32 mTimoutCnt;
        Courier::UInt32 mRepeatCnt;
};

// ------------------------------------------------------------------------
class GuiStartupFinishedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(GuiStartupFinishedUpdMsg, ::NotifierMessage, 0xAEBADF2D);

        GuiStartupFinishedUpdMsg();
        virtual ~GuiStartupFinishedUpdMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mGuiStartupFinishedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mGuiStartupFinishedUpdMsgModifiableMetadata;
};

// ------------------------------------------------------------------------
class HKStatusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HKStatusChangedUpdMsg, ::NotifierMessage, 0x04B8AFB9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        HKStatusChangedUpdMsg();
        HKStatusChangedUpdMsg(Courier::UInt32 const & aHKCode, hmibase::HardKeyStateEnum const & aHKState, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY, Courier::UInt32 const & aUserData = 0);
        virtual ~HKStatusChangedUpdMsg();

        Courier::UInt32 const & GetHKCode() const { return mHKCode; }
        void SetHKCode(Courier::UInt32 const & value) { mHKCode = value; }
        hmibase::HardKeyStateEnum const & GetHKState() const { return mHKState; }
        void SetHKState(hmibase::HardKeyStateEnum const & value) { mHKState = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }
        Courier::UInt32 const & GetUserData() const { return mUserData; }
        void SetUserData(Courier::UInt32 const & value) { mUserData = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHKStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHKStatusChangedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mHKStatusChangedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mHKCode;
        hmibase::HardKeyStateEnum mHKState;
        Courier::UInt32 mDisplayID;
        Courier::UInt32 mUserData;
};

// ------------------------------------------------------------------------
class CreateNewDestroyOld : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CreateNewDestroyOld, ::NotifierMessage, 0x9594A891);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CreateNewDestroyOld();
        CreateNewDestroyOld(::Courier::ViewId const & aSourceView, ::Courier::ViewId const & aDestinationView, Courier::UInt32 const & aUserData1 = 0, Courier::Int8 const & aUserData2 = 0);
        virtual ~CreateNewDestroyOld();

        ::Courier::ViewId const & GetSourceView() const { return mSourceView; }
        void SetSourceView(::Courier::ViewId const & value) { mSourceView = value; }
        ::Courier::ViewId const & GetDestinationView() const { return mDestinationView; }
        void SetDestinationView(::Courier::ViewId const & value) { mDestinationView = value; }
        Courier::UInt32 const & GetUserData1() const { return mUserData1; }
        void SetUserData1(Courier::UInt32 const & value) { mUserData1 = value; }
        Courier::Int8 const & GetUserData2() const { return mUserData2; }
        void SetUserData2(Courier::Int8 const & value) { mUserData2 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCreateNewDestroyOldMetaData;
        static ::Courier::Message::ModifiableMetadata mCreateNewDestroyOldModifiableMetadata;
        static const ::Courier::ComponentId mCreateNewDestroyOldSubscriberList[];

        ::Courier::ViewId mSourceView;
        ::Courier::ViewId mDestinationView;
        Courier::UInt32 mUserData1;
        Courier::Int8 mUserData2;
};

// ------------------------------------------------------------------------
          /* Status information about "Enter key" which can come from an encoder, a joystick or a keyboard.
           * The input for it is most likely HKStatusChangedUpdMsg which is translated into a more specific message.
           */
class EnterKeyStatusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EnterKeyStatusChangedUpdMsg, ::NotifierMessage, 0xB59C1C5E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        EnterKeyStatusChangedUpdMsg();
        EnterKeyStatusChangedUpdMsg(hmibase::HardKeyStateEnum const & aState, Courier::UInt32 const & aSource);
        virtual ~EnterKeyStatusChangedUpdMsg();

        hmibase::HardKeyStateEnum const & GetState() const { return mState; }
        void SetState(hmibase::HardKeyStateEnum const & value) { mState = value; }
        Courier::UInt32 const & GetSource() const { return mSource; }
        void SetSource(Courier::UInt32 const & value) { mSource = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEnterKeyStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEnterKeyStatusChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mEnterKeyStatusChangedUpdMsgSubscriberList[];

        hmibase::HardKeyStateEnum mState;
        Courier::UInt32 mSource;
};

// ------------------------------------------------------------------------
          /* Request sent to focus manager to change the current focus information (visibility, timer state and focused view/widget).
          * Show - updates the view and the widget and sets visibility to true. The timer must be explicitelly restarted is desired.
          * Set - updates the view and the widget. The timer must be explicitelly restarted is desired.
          * Hide - sets visibility to false. View and widget are ignored. The Timer must be explicitelly stopped if desired.
          */
class FocusControlReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusControlReqMsg, ::NotifierMessage, 0x9DB887C8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FocusControlReqMsg();
        FocusControlReqMsg(hmibase::enFocusAction const & aAction, hmibase::enFocusTimerAction const & aTimerAction, ::Courier::ViewId const & aView, Candera::String const & aWidget);
        virtual ~FocusControlReqMsg();

        hmibase::enFocusAction const & GetAction() const { return mAction; }
        void SetAction(hmibase::enFocusAction const & value) { mAction = value; }
        hmibase::enFocusTimerAction const & GetTimerAction() const { return mTimerAction; }
        void SetTimerAction(hmibase::enFocusTimerAction const & value) { mTimerAction = value; }
        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        Candera::String const & GetWidget() const { return mWidget; }
        void SetWidget(Candera::String const & value) { mWidget = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusControlReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusControlReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFocusControlReqMsgSubscriberList[];

        hmibase::enFocusAction mAction;
        hmibase::enFocusTimerAction mTimerAction;
        ::Courier::ViewId mView;
        Candera::String mWidget;
};

// ------------------------------------------------------------------------
class FocusGroupReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusGroupReqMsg, ::NotifierMessage, 0x1B10AB78);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FocusGroupReqMsg();
        FocusGroupReqMsg(bool const & aActivate, Candera::String const & aGroup, Courier::Int32 const & aHint = 0);
        virtual ~FocusGroupReqMsg();

        bool const & GetActivate() const { return mActivate; }
        void SetActivate(bool const & value) { mActivate = value; }
        Candera::String const & GetGroup() const { return mGroup; }
        void SetGroup(Candera::String const & value) { mGroup = value; }
        Courier::Int32 const & GetHint() const { return mHint; }
        void SetHint(Courier::Int32 const & value) { mHint = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusGroupReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusGroupReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFocusGroupReqMsgSubscriberList[];

        bool mActivate;
        Candera::String mGroup;
        Courier::Int32 mHint;
};

// ------------------------------------------------------------------------
          /* Request sent to focus manager to update the current session.
          * During update different tasks will be executed (collect focus info, process focus input messages, publish current focus, etc).
          */
class UpdateFocusSessionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(UpdateFocusSessionReqMsg, ::NotifierMessage, 0x579E066D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        UpdateFocusSessionReqMsg();
        virtual ~UpdateFocusSessionReqMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mUpdateFocusSessionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mUpdateFocusSessionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mUpdateFocusSessionReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
          /* Request sent to focus manager to refresh the session. This can happen after list content was updated with new widgets.
          */
class RefreshFocusSessionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RefreshFocusSessionReqMsg, ::NotifierMessage, 0x3A064234);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        RefreshFocusSessionReqMsg();
        RefreshFocusSessionReqMsg(bool const & aRefreshCrtAppInfo);
        virtual ~RefreshFocusSessionReqMsg();

        bool const & GetRefreshCrtAppInfo() const { return mRefreshCrtAppInfo; }
        void SetRefreshCrtAppInfo(bool const & value) { mRefreshCrtAppInfo = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRefreshFocusSessionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRefreshFocusSessionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mRefreshFocusSessionReqMsgSubscriberList[];

        bool mRefreshCrtAppInfo;
};

// ------------------------------------------------------------------------
          /* Update message sent when the current session reached the finish status.
          */
class FocusSessionFinishedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusSessionFinishedUpdMsg, ::NotifierMessage, 0xE852AC9A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FocusSessionFinishedUpdMsg();
        FocusSessionFinishedUpdMsg(Courier::UInt32 const & aTaskExecutionCount);
        virtual ~FocusSessionFinishedUpdMsg();

        Courier::UInt32 const & GetTaskExecutionCount() const { return mTaskExecutionCount; }
        void SetTaskExecutionCount(Courier::UInt32 const & value) { mTaskExecutionCount = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusSessionFinishedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusSessionFinishedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mFocusSessionFinishedUpdMsgSubscriberList[];

        Courier::UInt32 mTaskExecutionCount;
};

// ------------------------------------------------------------------------
          /* Request sent to widgets in the active views to register their focus info to the current session.
          */
class RegisterFocusableWidgetsReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RegisterFocusableWidgetsReqMsg, ::NotifierMessage, 0x7EDA01BA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        RegisterFocusableWidgetsReqMsg();
        RegisterFocusableWidgetsReqMsg(Focus::FSession* const & aSession);
        virtual ~RegisterFocusableWidgetsReqMsg();

        Focus::FSession* const & GetSession() const { return mSession; }
        void SetSession(Focus::FSession* const & value) { mSession = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRegisterFocusableWidgetsReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRegisterFocusableWidgetsReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mRegisterFocusableWidgetsReqMsgSubscriberList[];

        Focus::FSession* mSession;
};

// ------------------------------------------------------------------------
          /* Update message sent when the current focus was changed.
           */
class FocusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusChangedUpdMsg, ::NotifierMessage, 0xD17F125C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        FocusChangedUpdMsg();
        FocusChangedUpdMsg(::Courier::ViewId const & aView, ::Courier::Identifier const & aWidget);
        virtual ~FocusChangedUpdMsg();

        ::Courier::ViewId const & GetView() const { return mView; }
        void SetView(::Courier::ViewId const & value) { mView = value; }
        ::Courier::Identifier const & GetWidget() const { return mWidget; }
        void SetWidget(::Courier::Identifier const & value) { mWidget = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusChangedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mFocusChangedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mView;
        ::Courier::Identifier mWidget;
};

// ------------------------------------------------------------------------
class JoystickStatusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(JoystickStatusChangedUpdMsg, ::NotifierMessage, 0x69810995);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        JoystickStatusChangedUpdMsg();
        JoystickStatusChangedUpdMsg(hmibase::FocusDirectionEnum const & aDirection, Courier::UInt32 const & aSource);
        virtual ~JoystickStatusChangedUpdMsg();

        hmibase::FocusDirectionEnum const & GetDirection() const { return mDirection; }
        void SetDirection(hmibase::FocusDirectionEnum const & value) { mDirection = value; }
        Courier::UInt32 const & GetSource() const { return mSource; }
        void SetSource(Courier::UInt32 const & value) { mSource = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mJoystickStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mJoystickStatusChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mJoystickStatusChangedUpdMsgSubscriberList[];

        hmibase::FocusDirectionEnum mDirection;
        Courier::UInt32 mSource;
};

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
class EncoderStatusChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EncoderStatusChangedUpdMsg, ::NotifierMessage, 0x4FF79763);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        EncoderStatusChangedUpdMsg();
        EncoderStatusChangedUpdMsg(Courier::UInt32 const & aEncCode, Courier::Int32 const & aEncSteps, Courier::UInt32 const & aSurfaceId, Courier::UInt32 const & aUserData);
        virtual ~EncoderStatusChangedUpdMsg();

        Courier::UInt32 const & GetEncCode() const { return mEncCode; }
        void SetEncCode(Courier::UInt32 const & value) { mEncCode = value; }
        Courier::Int32 const & GetEncSteps() const { return mEncSteps; }
        void SetEncSteps(Courier::Int32 const & value) { mEncSteps = value; }
        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::UInt32 const & GetUserData() const { return mUserData; }
        void SetUserData(Courier::UInt32 const & value) { mUserData = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEncoderStatusChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEncoderStatusChangedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mEncoderStatusChangedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mEncCode;
        Courier::Int32 mEncSteps;
        Courier::UInt32 mSurfaceId;
        Courier::UInt32 mUserData;
};

/// @}

// ------------------------------------------------------------------------
class FocusChangedReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FocusChangedReqMsg, ::NotifierMessage, 0x32C4917A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        FocusChangedReqMsg();
        FocusChangedReqMsg(hmibase::FocusReqTypeEnum const & aReqType, hmibase::FocusDirectionEnum const & aDirection, Courier::Int32 const & aValue);
        virtual ~FocusChangedReqMsg();

        hmibase::FocusReqTypeEnum const & GetReqType() const { return mReqType; }
        void SetReqType(hmibase::FocusReqTypeEnum const & value) { mReqType = value; }
        hmibase::FocusDirectionEnum const & GetDirection() const { return mDirection; }
        void SetDirection(hmibase::FocusDirectionEnum const & value) { mDirection = value; }
        Courier::Int32 const & GetValue() const { return mValue; }
        void SetValue(Courier::Int32 const & value) { mValue = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFocusChangedReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFocusChangedReqMsgModifiableMetadata;
        static ::Courier::ComponentId mFocusChangedReqMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        hmibase::FocusReqTypeEnum mReqType;
        hmibase::FocusDirectionEnum mDirection;
        Courier::Int32 mValue;
};

// ------------------------------------------------------------------------
class HMIAppsInitializedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HMIAppsInitializedUpdMsg, ::NotifierMessage, 0xE117DABE);

        HMIAppsInitializedUpdMsg(bool const & aState);
        virtual ~HMIAppsInitializedUpdMsg();

        bool const & GetState() const { return mState; }
        void SetState(bool const & value) { mState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HMIAppsInitializedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHMIAppsInitializedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHMIAppsInitializedUpdMsgModifiableMetadata;

        bool mState;
};

// ------------------------------------------------------------------------
class SurfaceStateChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SurfaceStateChangedUpdMsg, ::NotifierMessage, 0xE2F61D55);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SurfaceStateChangedUpdMsg();
        SurfaceStateChangedUpdMsg(Courier::UInt32 const & aSurfaceId, Courier::Int32 const & aState, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aDisplayId = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~SurfaceStateChangedUpdMsg();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::Int32 const & GetState() const { return mState; }
        void SetState(Courier::Int32 const & value) { mState = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::UInt32 const & GetDisplayId() const { return mDisplayId; }
        void SetDisplayId(Courier::UInt32 const & value) { mDisplayId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSurfaceStateChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSurfaceStateChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mSurfaceStateChangedUpdMsgSubscriberList[];

        Courier::UInt32 mSurfaceId;
        Courier::Int32 mState;
        ::Courier::ViewId mViewId;
        Courier::UInt32 mDisplayId;
};

// ------------------------------------------------------------------------
class LayerStateChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LayerStateChangedUpdMsg, ::NotifierMessage, 0x2A84D4DA);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        LayerStateChangedUpdMsg();
        LayerStateChangedUpdMsg(Courier::UInt32 const & aLayerId, Courier::UInt32 const & aState);
        virtual ~LayerStateChangedUpdMsg();

        Courier::UInt32 const & GetLayerId() const { return mLayerId; }
        void SetLayerId(Courier::UInt32 const & value) { mLayerId = value; }
        Courier::UInt32 const & GetState() const { return mState; }
        void SetState(Courier::UInt32 const & value) { mState = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLayerStateChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLayerStateChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mLayerStateChangedUpdMsgSubscriberList[];

        Courier::UInt32 mLayerId;
        Courier::UInt32 mState;
};

// ------------------------------------------------------------------------
// Windows only to simulate timer controlled popups
class SBPopupTimerExpiryUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SBPopupTimerExpiryUpdMsg, ::NotifierMessage, 0xAC22D6A5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SBPopupTimerExpiryUpdMsg(Courier::UInt32 const & aSurfaceId, Courier::Int32 const & aState, ::Courier::ViewId const & aViewId);
        virtual ~SBPopupTimerExpiryUpdMsg();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::Int32 const & GetState() const { return mState; }
        void SetState(Courier::Int32 const & value) { mState = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SBPopupTimerExpiryUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSBPopupTimerExpiryUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSBPopupTimerExpiryUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mSBPopupTimerExpiryUpdMsgSubscriberList[];

        Courier::UInt32 mSurfaceId;
        Courier::Int32 mState;
        ::Courier::ViewId mViewId;
};

// ------------------------------------------------------------------------
class HMISubStateChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(HMISubStateChangedUpdMsg, ::NotifierMessage, 0x4A69141E);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        HMISubStateChangedUpdMsg(hmibase::HMIStateEnum const & aSubState);
        virtual ~HMISubStateChangedUpdMsg();

        hmibase::HMIStateEnum const & GetSubState() const { return mSubState; }
        void SetSubState(hmibase::HMIStateEnum const & value) { mSubState = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(HMISubStateChangedUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mHMISubStateChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mHMISubStateChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mHMISubStateChangedUpdMsgSubscriberList[];

        hmibase::HMIStateEnum mSubState;
};

// ------------------------------------------------------------------------
class QueryTraceInfoReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(QueryTraceInfoReqMsg, ::NotifierMessage, 0x5ADB1903);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        QueryTraceInfoReqMsg(hmibase::TraceQueryIdEnum const & aQueryId, Courier::UInt32 const & aUserData1, Courier::UInt32 const & aUserData2, Candera::String const & aUserData3, Candera::String const & aUserData4);
        virtual ~QueryTraceInfoReqMsg();

        hmibase::TraceQueryIdEnum const & GetQueryId() const { return mQueryId; }
        void SetQueryId(hmibase::TraceQueryIdEnum const & value) { mQueryId = value; }
        Courier::UInt32 const & GetUserData1() const { return mUserData1; }
        void SetUserData1(Courier::UInt32 const & value) { mUserData1 = value; }
        Courier::UInt32 const & GetUserData2() const { return mUserData2; }
        void SetUserData2(Courier::UInt32 const & value) { mUserData2 = value; }
        Candera::String const & GetUserData3() const { return mUserData3; }
        void SetUserData3(Candera::String const & value) { mUserData3 = value; }
        Candera::String const & GetUserData4() const { return mUserData4; }
        void SetUserData4(Candera::String const & value) { mUserData4 = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(QueryTraceInfoReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mQueryTraceInfoReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mQueryTraceInfoReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mQueryTraceInfoReqMsgSubscriberList[];

        hmibase::TraceQueryIdEnum mQueryId;
        Courier::UInt32 mUserData1;
        Courier::UInt32 mUserData2;
        Candera::String mUserData3;
        Candera::String mUserData4;
};

// ------------------------------------------------------------------------
         /* message to be used for any kind of follow up action.
          * - UserData : to be interpreted based on action type
          * - ActionType : hmibase::followUpAction
          */
class FollowUpActionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(FollowUpActionReqMsg, ::NotifierMessage, 0x03C5043D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        FollowUpActionReqMsg(Courier::UInt32 const & aUserData, hmibase::followUpAction const & aActionType);
        virtual ~FollowUpActionReqMsg();

        Courier::UInt32 const & GetUserData() const { return mUserData; }
        void SetUserData(Courier::UInt32 const & value) { mUserData = value; }
        hmibase::followUpAction const & GetActionType() const { return mActionType; }
        void SetActionType(hmibase::followUpAction const & value) { mActionType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(FollowUpActionReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mFollowUpActionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mFollowUpActionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mFollowUpActionReqMsgSubscriberList[];

        Courier::UInt32 mUserData;
        hmibase::followUpAction mActionType;
};

// ------------------------------------------------------------------------
          /** WidgetPropertySetterReqMsg which may be used for setting the value of a property of a widget.
          * - WidgetName: Name of the widget whose property is to be set.
          * - PropertyName: Name of the property which has to be set.
          * - PropertyValue: Value of the property to be set which is passed as a string value and converted later based on the datatype.
          */
class WidgetPropertySetterReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(WidgetPropertySetterReqMsg, ::NotifierMessage, 0x2E7F28E6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        WidgetPropertySetterReqMsg(Candera::String const & aWidgetName, Candera::String const & aPropertyName, Candera::String const & aPropertyValue);
        virtual ~WidgetPropertySetterReqMsg();

        Candera::String const & GetWidgetName() const { return mWidgetName; }
        void SetWidgetName(Candera::String const & value) { mWidgetName = value; }
        Candera::String const & GetPropertyName() const { return mPropertyName; }
        void SetPropertyName(Candera::String const & value) { mPropertyName = value; }
        Candera::String const & GetPropertyValue() const { return mPropertyValue; }
        void SetPropertyValue(Candera::String const & value) { mPropertyValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(WidgetPropertySetterReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mWidgetPropertySetterReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mWidgetPropertySetterReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mWidgetPropertySetterReqMsgSubscriberList[];

        Candera::String mWidgetName;
        Candera::String mPropertyName;
        Candera::String mPropertyValue;
};

// ------------------------------------------------------------------------
class SimTouchReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SimTouchReqMsg, ::NotifierMessage, 0xE1525182);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SimTouchReqMsg();
        SimTouchReqMsg(hmibase::enSimTouchId const & aIdentifier, hmibase::trace::SurfaceInfoProvider const & aData, Candera::String const & aWidgetIdentifier, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aListId = 0, Courier::UInt32 const & aButtonWidgetIndex = 0);
        virtual ~SimTouchReqMsg();

        hmibase::enSimTouchId const & GetIdentifier() const { return midentifier; }
        void SetIdentifier(hmibase::enSimTouchId const & value) { midentifier = value; }
        hmibase::trace::SurfaceInfoProvider const & GetData() const { return mdata; }
        void SetData(hmibase::trace::SurfaceInfoProvider const & value) { mdata = value; }
        Candera::String const & GetWidgetIdentifier() const { return mwidgetIdentifier; }
        void SetWidgetIdentifier(Candera::String const & value) { mwidgetIdentifier = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::UInt32 const & GetListId() const { return mListId; }
        void SetListId(Courier::UInt32 const & value) { mListId = value; }
        Courier::UInt32 const & GetButtonWidgetIndex() const { return mButtonWidgetIndex; }
        void SetButtonWidgetIndex(Courier::UInt32 const & value) { mButtonWidgetIndex = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSimTouchReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSimTouchReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSimTouchReqMsgSubscriberList[];

        hmibase::enSimTouchId midentifier;
        hmibase::trace::SurfaceInfoProvider mdata;
        Candera::String mwidgetIdentifier;
        ::Courier::ViewId mViewId;
        Courier::UInt32 mListId;
        Courier::UInt32 mButtonWidgetIndex;
};

// ------------------------------------------------------------------------
class CloseOnTouchReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CloseOnTouchReqMsg, ::NotifierMessage, 0xBB653851);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        CloseOnTouchReqMsg();
        CloseOnTouchReqMsg(::Courier::ViewId const & aViewId, Courier::TouchMsgState::Enum const & aTouchState);
        virtual ~CloseOnTouchReqMsg();

        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::TouchMsgState::Enum const & GetTouchState() const { return mTouchState; }
        void SetTouchState(Courier::TouchMsgState::Enum const & value) { mTouchState = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCloseOnTouchReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCloseOnTouchReqMsgModifiableMetadata;
        static ::Courier::ComponentId mCloseOnTouchReqMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        ::Courier::ViewId mViewId;
        Courier::TouchMsgState::Enum mTouchState;
};

// ------------------------------------------------------------------------
class RegisterForCloseOnTouchSessionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RegisterForCloseOnTouchSessionReqMsg, ::NotifierMessage, 0x019C0C3F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        RegisterForCloseOnTouchSessionReqMsg();
        RegisterForCloseOnTouchSessionReqMsg(bool const & aRegister, ::Courier::ViewId const & aViewId);
        virtual ~RegisterForCloseOnTouchSessionReqMsg();

        bool const & GetRegister() const { return mRegister; }
        void SetRegister(bool const & value) { mRegister = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRegisterForCloseOnTouchSessionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRegisterForCloseOnTouchSessionReqMsgModifiableMetadata;
        static ::Courier::ComponentId mRegisterForCloseOnTouchSessionReqMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        bool mRegister;
        ::Courier::ViewId mViewId;
};

// ------------------------------------------------------------------------
class SetClosePopupExternalTouchMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetClosePopupExternalTouchMsg, ::NotifierMessage, 0xA39D4C9F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SetClosePopupExternalTouchMsg();
        SetClosePopupExternalTouchMsg(bool const & aStatus);
        virtual ~SetClosePopupExternalTouchMsg();

        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetClosePopupExternalTouchMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetClosePopupExternalTouchMsgModifiableMetadata;
        static ::Courier::ComponentId mSetClosePopupExternalTouchMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        bool mStatus;
};

// ------------------------------------------------------------------------
class ClosePopupOnExternalTouchReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ClosePopupOnExternalTouchReqMsg, ::NotifierMessage, 0xB3E03EE7);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ClosePopupOnExternalTouchReqMsg();
        ClosePopupOnExternalTouchReqMsg(Courier::TouchMsgState::Enum const & aTouchState, Courier::UInt32 const & aSurfaceId);
        virtual ~ClosePopupOnExternalTouchReqMsg();

        Courier::TouchMsgState::Enum const & GetTouchState() const { return mTouchState; }
        void SetTouchState(Courier::TouchMsgState::Enum const & value) { mTouchState = value; }
        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mClosePopupOnExternalTouchReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mClosePopupOnExternalTouchReqMsgModifiableMetadata;
        static ::Courier::ComponentId mClosePopupOnExternalTouchReqMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::TouchMsgState::Enum mTouchState;
        Courier::UInt32 mSurfaceId;
};

// ------------------------------------------------------------------------
class PlayBeepReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PlayBeepReqMsg, ::NotifierMessage, 0x05DA205F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PlayBeepReqMsg();
        PlayBeepReqMsg(Courier::Int32 const & aBeepType);
        virtual ~PlayBeepReqMsg();

        Courier::Int32 const & GetBeepType() const { return mBeepType; }
        void SetBeepType(Courier::Int32 const & value) { mBeepType = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPlayBeepReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPlayBeepReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPlayBeepReqMsgSubscriberList[];

        Courier::Int32 mBeepType;
};

// ------------------------------------------------------------------------
class ChangeHmiSubStateReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ChangeHmiSubStateReqMsg, ::NotifierMessage, 0x00209171);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ChangeHmiSubStateReqMsg();
        virtual ~ChangeHmiSubStateReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mChangeHmiSubStateReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mChangeHmiSubStateReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mChangeHmiSubStateReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
        /* This Message is used for evaluation of a SubSurface request in Controller of the SubSurface provider
        *  RegionType in this message shall be used to differentiate the various kinds of Surface content.
        *  Values for the Region Type shall be defined in project, ex: STATUS_BAR_MAP, STATUS_BAR_AUDIO
        */
class EvalSubSurfaceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EvalSubSurfaceReqMsg, ::NotifierMessage, 0x2692050D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EvalSubSurfaceReqMsg();
        EvalSubSurfaceReqMsg(Candera::String const & aApplicationName, hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, hmibase::displayStatus const & aDisplayStatus, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~EvalSubSurfaceReqMsg();

        Candera::String const & GetApplicationName() const { return mApplicationName; }
        void SetApplicationName(Candera::String const & value) { mApplicationName = value; }
        hmibase::displayRegion const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(hmibase::displayRegion const & value) { mDisplayRegion = value; }
        Courier::Int32 const & GetDisplayRegionType() const { return mDisplayRegionType; }
        void SetDisplayRegionType(Courier::Int32 const & value) { mDisplayRegionType = value; }
        hmibase::displayStatus const & GetDisplayStatus() const { return mDisplayStatus; }
        void SetDisplayStatus(hmibase::displayStatus const & value) { mDisplayStatus = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEvalSubSurfaceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEvalSubSurfaceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mEvalSubSurfaceReqMsgSubscriberList[];

        Candera::String mApplicationName;
        hmibase::displayRegion mDisplayRegion;
        Courier::Int32 mDisplayRegionType;
        hmibase::displayStatus mDisplayStatus;
        Courier::UInt32 mDisplayID;
};

// ------------------------------------------------------------------------
        /* This Message is used for request for activation of SubSurface in SubSurface provider
        *  RegionType in this message shall be used to differentiate the various kinds of Surface content.
        *  Values for the Region Type shall be defined in project, ex: STATUS_BAR_MAP, STATUS_BAR_AUDIO
        */
class ExecuteSubSurfaceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExecuteSubSurfaceReqMsg, ::NotifierMessage, 0x245DF613);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ExecuteSubSurfaceReqMsg();
        ExecuteSubSurfaceReqMsg(Candera::String const & aApplicationName, hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~ExecuteSubSurfaceReqMsg();

        Candera::String const & GetApplicationName() const { return mApplicationName; }
        void SetApplicationName(Candera::String const & value) { mApplicationName = value; }
        hmibase::displayRegion const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(hmibase::displayRegion const & value) { mDisplayRegion = value; }
        Courier::Int32 const & GetDisplayRegionType() const { return mDisplayRegionType; }
        void SetDisplayRegionType(Courier::Int32 const & value) { mDisplayRegionType = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExecuteSubSurfaceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExecuteSubSurfaceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mExecuteSubSurfaceReqMsgSubscriberList[];

        Candera::String mApplicationName;
        hmibase::displayRegion mDisplayRegion;
        Courier::Int32 mDisplayRegionType;
        Courier::UInt32 mDisplayID;
};

// ------------------------------------------------------------------------
        /* This Message is used for response for activation of SubSurface in SubSurface provider
         */
class ExecuteSubSurfaceResMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExecuteSubSurfaceResMsg, ::NotifierMessage, 0x354A7D3D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        ExecuteSubSurfaceResMsg(Candera::String const & aApplicationName, Courier::Int32 const & aDisplayRegion, Courier::UInt32 const & aDisplayID, bool const & aExecuteResponse);
        virtual ~ExecuteSubSurfaceResMsg();

        Candera::String const & GetApplicationName() const { return mApplicationName; }
        void SetApplicationName(Candera::String const & value) { mApplicationName = value; }
        Courier::Int32 const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(Courier::Int32 const & value) { mDisplayRegion = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }
        bool const & GetExecuteResponse() const { return mExecuteResponse; }
        void SetExecuteResponse(bool const & value) { mExecuteResponse = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ExecuteSubSurfaceResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExecuteSubSurfaceResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExecuteSubSurfaceResMsgModifiableMetadata;
        static const ::Courier::ComponentId mExecuteSubSurfaceResMsgSubscriberList[];

        Candera::String mApplicationName;
        Courier::Int32 mDisplayRegion;
        Courier::UInt32 mDisplayID;
        bool mExecuteResponse;
};

// ------------------------------------------------------------------------
class ExtendedViewReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ExtendedViewReqMsg, ::NotifierMessage, 0x8FED9AC8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ExtendedViewReqMsg(hmibase::views::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aHint);
        virtual ~ExtendedViewReqMsg();

        hmibase::views::CommandEnum const & GetCommand() const { return mCommand; }
        void SetCommand(hmibase::views::CommandEnum const & value) { mCommand = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::UInt32 const & GetHint() const { return mHint; }
        void SetHint(Courier::UInt32 const & value) { mHint = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ExtendedViewReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mExtendedViewReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mExtendedViewReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mExtendedViewReqMsgSubscriberList[];

        hmibase::views::CommandEnum mCommand;
        ::Courier::ViewId mViewId;
        Courier::UInt32 mHint;
};

// ------------------------------------------------------------------------
class LocalizationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(LocalizationReqMsg, ::NotifierMessage, 0x2DBDABED);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        LocalizationReqMsg(Candera::String const & aLocale);
        virtual ~LocalizationReqMsg();

        Candera::String const & GetLocale() const { return mLocale; }
        void SetLocale(Candera::String const & value) { mLocale = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(LocalizationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mLocalizationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mLocalizationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mLocalizationReqMsgSubscriberList[];

        Candera::String mLocale;
};

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
class DecrementActiveAnimationCountMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DecrementActiveAnimationCountMsg, ::NotifierMessage, 0x8C71396A);

        DecrementActiveAnimationCountMsg();
        virtual ~DecrementActiveAnimationCountMsg();

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDecrementActiveAnimationCountMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDecrementActiveAnimationCountMsgModifiableMetadata;
};

/// @}

// ------------------------------------------------------------------------
class PopupReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopupReqMsg, ::NotifierMessage, 0x90C31D28);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PopupReqMsg();
        PopupReqMsg(hmibase::popups::CommandEnum const & aCommand, ::Courier::ViewId const & aViewId, Courier::UInt32 const & aPopupDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~PopupReqMsg();

        hmibase::popups::CommandEnum const & GetCommand() const { return mCommand; }
        void SetCommand(hmibase::popups::CommandEnum const & value) { mCommand = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::UInt32 const & GetPopupDisplayID() const { return mPopupDisplayID; }
        void SetPopupDisplayID(Courier::UInt32 const & value) { mPopupDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopupReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPopupReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPopupReqMsgSubscriberList[];

        hmibase::popups::CommandEnum mCommand;
        ::Courier::ViewId mViewId;
        Courier::UInt32 mPopupDisplayID;
};

// ------------------------------------------------------------------------
class SetApplicationAsMandatoryReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SetApplicationAsMandatoryReqMsg, ::NotifierMessage, 0x18BCB806);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SetApplicationAsMandatoryReqMsg(bool const & aValue);
        virtual ~SetApplicationAsMandatoryReqMsg();

        bool const & GetValue() const { return mValue; }
        void SetValue(bool const & value) { mValue = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(SetApplicationAsMandatoryReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSetApplicationAsMandatoryReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSetApplicationAsMandatoryReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mSetApplicationAsMandatoryReqMsgSubscriberList[];

        bool mValue;
};

// ------------------------------------------------------------------------
class ApplicationStateUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationStateUpdMsg, ::NotifierMessage, 0x3824FE1D);

        ApplicationStateUpdMsg();
        ApplicationStateUpdMsg(hmibase::hmiappstates const & aState, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~ApplicationStateUpdMsg();

        hmibase::hmiappstates const & GetState() const { return mState; }
        void SetState(hmibase::hmiappstates const & value) { mState = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationStateUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationStateUpdMsgModifiableMetadata;

        hmibase::hmiappstates mState;
        Courier::UInt32 mDisplayID;
};

// ------------------------------------------------------------------------
class SubSurfaceUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SubSurfaceUpdMsg, ::NotifierMessage, 0x69FAC6F1);

        SubSurfaceUpdMsg();
        SubSurfaceUpdMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, hmibase::hmiappstates const & aState, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~SubSurfaceUpdMsg();

        hmibase::displayRegion const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(hmibase::displayRegion const & value) { mDisplayRegion = value; }
        Courier::Int32 const & GetDisplayRegionType() const { return mDisplayRegionType; }
        void SetDisplayRegionType(Courier::Int32 const & value) { mDisplayRegionType = value; }
        hmibase::hmiappstates const & GetState() const { return mState; }
        void SetState(hmibase::hmiappstates const & value) { mState = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSubSurfaceUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSubSurfaceUpdMsgModifiableMetadata;

        hmibase::displayRegion mDisplayRegion;
        Courier::Int32 mDisplayRegionType;
        hmibase::hmiappstates mState;
        Courier::UInt32 mDisplayID;
};

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
class ApplicationRenderedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationRenderedUpdMsg, ::NotifierMessage, 0x34A28CEF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ApplicationRenderedUpdMsg();
        ApplicationRenderedUpdMsg(Courier::UInt32 const & aSurfaceID);
        virtual ~ApplicationRenderedUpdMsg();

        Courier::UInt32 const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(Courier::UInt32 const & value) { mSurfaceID = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationRenderedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationRenderedUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mApplicationRenderedUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mSurfaceID;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
class ApplicationSwitchCompleteUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ApplicationSwitchCompleteUpdMsg, ::NotifierMessage, 0x4005E8A8);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        ApplicationSwitchCompleteUpdMsg();
        ApplicationSwitchCompleteUpdMsg(Courier::UInt32 const & aSurfaceID, Courier::UInt32 const & aSurfaceState);
        virtual ~ApplicationSwitchCompleteUpdMsg();

        Courier::UInt32 const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(Courier::UInt32 const & value) { mSurfaceID = value; }
        Courier::UInt32 const & GetSurfaceState() const { return mSurfaceState; }
        void SetSurfaceState(Courier::UInt32 const & value) { mSurfaceState = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mApplicationSwitchCompleteUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mApplicationSwitchCompleteUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mApplicationSwitchCompleteUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mSurfaceID;
        Courier::UInt32 mSurfaceState;
};

/// @}

// ------------------------------------------------------------------------
/// @addtogroup COURIER_FOUNDATION
/// @{
class SubSurfaceSwitchCompleteUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SubSurfaceSwitchCompleteUpdMsg, ::NotifierMessage, 0x6A411BD4);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        SubSurfaceSwitchCompleteUpdMsg();
        SubSurfaceSwitchCompleteUpdMsg(Courier::UInt32 const & aSurfaceID, Courier::UInt32 const & aSurfaceState);
        virtual ~SubSurfaceSwitchCompleteUpdMsg();

        Courier::UInt32 const & GetSurfaceID() const { return mSurfaceID; }
        void SetSurfaceID(Courier::UInt32 const & value) { mSurfaceID = value; }
        Courier::UInt32 const & GetSurfaceState() const { return mSurfaceState; }
        void SetSurfaceState(Courier::UInt32 const & value) { mSurfaceState = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSubSurfaceSwitchCompleteUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSubSurfaceSwitchCompleteUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mSubSurfaceSwitchCompleteUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mSurfaceID;
        Courier::UInt32 mSurfaceState;
};

/// @}

// ------------------------------------------------------------------------
class SbAnimationStateChangedUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SbAnimationStateChangedUpdMsg, ::NotifierMessage, 0xCC0D2AD6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        SbAnimationStateChangedUpdMsg();
        SbAnimationStateChangedUpdMsg(bool const & aAnimStatus, ::Courier::ViewId const & aViewId);
        virtual ~SbAnimationStateChangedUpdMsg();

        bool const & GetAnimStatus() const { return mAnimStatus; }
        void SetAnimStatus(bool const & value) { mAnimStatus = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSbAnimationStateChangedUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSbAnimationStateChangedUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mSbAnimationStateChangedUpdMsgSubscriberList[];

        bool mAnimStatus;
        ::Courier::ViewId mViewId;
};

// ------------------------------------------------------------------------
class SbCurrentStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(SbCurrentStatusUpdMsg, ::NotifierMessage, 0xBDAEBC95);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        SbCurrentStatusUpdMsg();
        SbCurrentStatusUpdMsg(hmibase::TraceQueryIdEnum const & aRequestId, Courier::UInt32 const & aDisplayId, Courier::UInt32 const & aSurfaceId, bool const & aStatus, ::Courier::ViewId const & aViewId);
        virtual ~SbCurrentStatusUpdMsg();

        hmibase::TraceQueryIdEnum const & GetRequestId() const { return mRequestId; }
        void SetRequestId(hmibase::TraceQueryIdEnum const & value) { mRequestId = value; }
        Courier::UInt32 const & GetDisplayId() const { return mDisplayId; }
        void SetDisplayId(Courier::UInt32 const & value) { mDisplayId = value; }
        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        bool const & GetStatus() const { return mStatus; }
        void SetStatus(bool const & value) { mStatus = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mSbCurrentStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mSbCurrentStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mSbCurrentStatusUpdMsgSubscriberList[];

        hmibase::TraceQueryIdEnum mRequestId;
        Courier::UInt32 mDisplayId;
        Courier::UInt32 mSurfaceId;
        bool mStatus;
        ::Courier::ViewId mViewId;
};

// ------------------------------------------------------------------------
class PopupDisplayStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopupDisplayStatusUpdMsg, ::NotifierMessage, 0xBC129E47);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(5);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        PopupDisplayStatusUpdMsg();
        PopupDisplayStatusUpdMsg(hmibase::displayStatus const & aPopupStatus, Courier::UInt32 const & aDisplayId, Courier::UInt32 const & aSurfaceId, Courier::UInt32 const & aLayerId, Courier::UInt32 const & aHashId, ::Courier::ViewId const & aViewId);
        virtual ~PopupDisplayStatusUpdMsg();

        hmibase::displayStatus const & GetPopupStatus() const { return mPopupStatus; }
        void SetPopupStatus(hmibase::displayStatus const & value) { mPopupStatus = value; }
        Courier::UInt32 const & GetDisplayId() const { return mDisplayId; }
        void SetDisplayId(Courier::UInt32 const & value) { mDisplayId = value; }
        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::UInt32 const & GetLayerId() const { return mLayerId; }
        void SetLayerId(Courier::UInt32 const & value) { mLayerId = value; }
        Courier::UInt32 const & GetHashId() const { return mHashId; }
        void SetHashId(Courier::UInt32 const & value) { mHashId = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopupDisplayStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPopupDisplayStatusUpdMsgModifiableMetadata;
        static ::Courier::ComponentId mPopupDisplayStatusUpdMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        hmibase::displayStatus mPopupStatus;
        Courier::UInt32 mDisplayId;
        Courier::UInt32 mSurfaceId;
        Courier::UInt32 mLayerId;
        Courier::UInt32 mHashId;
        ::Courier::ViewId mViewId;
};

// ------------------------------------------------------------------------
        /* This Message is used for request to show or hide SubSurface in SubSurface requester
        *  RegionType in this message shall be used to differentiate the various kinds of Surface content.
        *  Values for the Region Type shall be defined in project, ex: STATUS_BAR_MAP, STATUS_BAR_AUDIO
        *  LockSubSurface value specifies whether to  synchronize the subsurface with respective screen.
        */
class ShowHMISubSurfaceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ShowHMISubSurfaceReqMsg, ::NotifierMessage, 0x84C59E27);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ShowHMISubSurfaceReqMsg();
        ShowHMISubSurfaceReqMsg(hmibase::displayRegion const & aDisplayRegion, Courier::Int32 const & aDisplayRegionType, bool const & aShowSubSurface, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY, bool const & aLockSubSurface = true);
        virtual ~ShowHMISubSurfaceReqMsg();

        hmibase::displayRegion const & GetDisplayRegion() const { return mDisplayRegion; }
        void SetDisplayRegion(hmibase::displayRegion const & value) { mDisplayRegion = value; }
        Courier::Int32 const & GetDisplayRegionType() const { return mDisplayRegionType; }
        void SetDisplayRegionType(Courier::Int32 const & value) { mDisplayRegionType = value; }
        bool const & GetShowSubSurface() const { return mShowSubSurface; }
        void SetShowSubSurface(bool const & value) { mShowSubSurface = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }
        bool const & GetLockSubSurface() const { return mLockSubSurface; }
        void SetLockSubSurface(bool const & value) { mLockSubSurface = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mShowHMISubSurfaceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mShowHMISubSurfaceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mShowHMISubSurfaceReqMsgSubscriberList[];

        hmibase::displayRegion mDisplayRegion;
        Courier::Int32 mDisplayRegionType;
        bool mShowSubSurface;
        Courier::UInt32 mDisplayID;
        bool mLockSubSurface;
};

// ------------------------------------------------------------------------
        /* This Message is used for request to perform layer animation with the provided surface list
		*  and requested animation type.Surface list should not be empty  and layer id and animation 
		*  type should be valid.
        */
class StartLayerAnimationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(StartLayerAnimationReqMsg, ::NotifierMessage, 0x984C92D6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        StartLayerAnimationReqMsg();
        StartLayerAnimationReqMsg(Courier::UInt32 const & aLayerId, std::vector<Courier::UInt32> const & aSurfaceIdList, Courier::UInt32 const & aAnimationType = 0);
        virtual ~StartLayerAnimationReqMsg();

        Courier::UInt32 const & GetLayerId() const { return mLayerId; }
        void SetLayerId(Courier::UInt32 const & value) { mLayerId = value; }
        std::vector<Courier::UInt32> const & GetSurfaceIdList() const { return mSurfaceIdList; }
        void SetSurfaceIdList(std::vector<Courier::UInt32> const & value) { mSurfaceIdList = value; }
        Courier::UInt32 const & GetAnimationType() const { return mAnimationType; }
        void SetAnimationType(Courier::UInt32 const & value) { mAnimationType = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mStartLayerAnimationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mStartLayerAnimationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mStartLayerAnimationReqMsgSubscriberList[];

        Courier::UInt32 mLayerId;
        std::vector<Courier::UInt32> mSurfaceIdList;
        Courier::UInt32 mAnimationType;
};

// ------------------------------------------------------------------------
class PopupFilterPrioEnableReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopupFilterPrioEnableReqMsg, ::NotifierMessage, 0xE438B08A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PopupFilterPrioEnableReqMsg(Courier::UInt32 const & aPrio);
        virtual ~PopupFilterPrioEnableReqMsg();

        Courier::UInt32 const & GetPrio() const { return mPrio; }
        void SetPrio(Courier::UInt32 const & value) { mPrio = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(PopupFilterPrioEnableReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopupFilterPrioEnableReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPopupFilterPrioEnableReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPopupFilterPrioEnableReqMsgSubscriberList[];

        Courier::UInt32 mPrio;
};

// ------------------------------------------------------------------------
class PopupFilterAllEnableReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopupFilterAllEnableReqMsg, ::NotifierMessage, 0x0B750761);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PopupFilterAllEnableReqMsg();
        virtual ~PopupFilterAllEnableReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopupFilterAllEnableReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPopupFilterAllEnableReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPopupFilterAllEnableReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class PopupFilterDisableReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(PopupFilterDisableReqMsg, ::NotifierMessage, 0xB1BA7A2D);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        PopupFilterDisableReqMsg();
        virtual ~PopupFilterDisableReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mPopupFilterDisableReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mPopupFilterDisableReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mPopupFilterDisableReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class MultiDisplayPopupFilterReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(MultiDisplayPopupFilterReqMsg, ::NotifierMessage, 0x3327E090);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        MultiDisplayPopupFilterReqMsg();
        MultiDisplayPopupFilterReqMsg(hmibase::PopupFilterType const & aPopupFilterType, Courier::UInt32 const & aPrio = 0, Courier::UInt32 const & aDisplayID = hmibase::DEFAULT_UNKNOWN_DISPLAY);
        virtual ~MultiDisplayPopupFilterReqMsg();

        hmibase::PopupFilterType const & GetPopupFilterType() const { return mPopupFilterType; }
        void SetPopupFilterType(hmibase::PopupFilterType const & value) { mPopupFilterType = value; }
        Courier::UInt32 const & GetPrio() const { return mPrio; }
        void SetPrio(Courier::UInt32 const & value) { mPrio = value; }
        Courier::UInt32 const & GetDisplayID() const { return mDisplayID; }
        void SetDisplayID(Courier::UInt32 const & value) { mDisplayID = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mMultiDisplayPopupFilterReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mMultiDisplayPopupFilterReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mMultiDisplayPopupFilterReqMsgSubscriberList[];

        hmibase::PopupFilterType mPopupFilterType;
        Courier::UInt32 mPrio;
        Courier::UInt32 mDisplayID;
};

// ------------------------------------------------------------------------
class RestartMenuTimeoutTimerReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RestartMenuTimeoutTimerReqMsg, ::NotifierMessage, 0x5933E5BD);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        RestartMenuTimeoutTimerReqMsg();
        virtual ~RestartMenuTimeoutTimerReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRestartMenuTimeoutTimerReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRestartMenuTimeoutTimerReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mRestartMenuTimeoutTimerReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class RenderingCompleteMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(RenderingCompleteMsg, ::NotifierMessage, 0x4FDD0DFF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        RenderingCompleteMsg(Courier::UInt32 const & aSurfaceId, Candera::String const & aViewName, Candera::DevicePackageDescriptor::UnitCategory const & aRTUnitType, Courier::UInt32 const & aUserData);
        virtual ~RenderingCompleteMsg();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Candera::String const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::String const & value) { mViewName = value; }
        Candera::DevicePackageDescriptor::UnitCategory const & GetRTUnitType() const { return mRTUnitType; }
        void SetRTUnitType(Candera::DevicePackageDescriptor::UnitCategory const & value) { mRTUnitType = value; }
        Courier::UInt32 const & GetUserData() const { return mUserData; }
        void SetUserData(Courier::UInt32 const & value) { mUserData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(RenderingCompleteMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mRenderingCompleteMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mRenderingCompleteMsgModifiableMetadata;
        static ::Courier::ComponentId mRenderingCompleteMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mSurfaceId;
        Candera::String mViewName;
        Candera::DevicePackageDescriptor::UnitCategory mRTUnitType;
        Courier::UInt32 mUserData;
};

// ------------------------------------------------------------------------
class CreateTextMetaDataCollectionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(CreateTextMetaDataCollectionReqMsg, ::NotifierMessage, 0x10BD7C47);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        CreateTextMetaDataCollectionReqMsg();
        virtual ~CreateTextMetaDataCollectionReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mCreateTextMetaDataCollectionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mCreateTextMetaDataCollectionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mCreateTextMetaDataCollectionReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
class DumpScreenReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DumpScreenReqMsg, ::NotifierMessage, 0xE4E22D4C);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DumpScreenReqMsg(Candera::String const & aViewName, bool const & aDumpAll);
        virtual ~DumpScreenReqMsg();

        Candera::String const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::String const & value) { mViewName = value; }
        bool const & GetDumpAll() const { return mDumpAll; }
        void SetDumpAll(bool const & value) { mDumpAll = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DumpScreenReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDumpScreenReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDumpScreenReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDumpScreenReqMsgSubscriberList[];

        Candera::String mViewName;
        bool mDumpAll;
};

// ------------------------------------------------------------------------
class TraverseViewsReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TraverseViewsReqMsg, ::NotifierMessage, 0x0585F6F9);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TraverseViewsReqMsg(Candera::String const & aVisitors, Candera::String const & aViewName);
        virtual ~TraverseViewsReqMsg();

        Candera::String const & GetVisitors() const { return mVisitors; }
        void SetVisitors(Candera::String const & value) { mVisitors = value; }
        Candera::String const & GetViewName() const { return mViewName; }
        void SetViewName(Candera::String const & value) { mViewName = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TraverseViewsReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTraverseViewsReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTraverseViewsReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mTraverseViewsReqMsgSubscriberList[];

        Candera::String mVisitors;
        Candera::String mViewName;
};

// ------------------------------------------------------------------------
/** Request sent by the drag and drop manager to check if the pressed widget is a valid drag and drop source. */
class DragDropCheckSourceReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCheckSourceReqMsg, ::NotifierMessage, 0x01134013);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DragDropCheckSourceReqMsg(Courier::UInt32 const & aSessionId, Courier::UInt32 const & aReqId, ::Courier::ViewId const & aSourceView, ::Courier::Identifier const & aSourceWidget);
        virtual ~DragDropCheckSourceReqMsg();

        Courier::UInt32 const & GetSessionId() const { return mSessionId; }
        void SetSessionId(Courier::UInt32 const & value) { mSessionId = value; }
        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        ::Courier::ViewId const & GetSourceView() const { return mSourceView; }
        void SetSourceView(::Courier::ViewId const & value) { mSourceView = value; }
        ::Courier::Identifier const & GetSourceWidget() const { return mSourceWidget; }
        void SetSourceWidget(::Courier::Identifier const & value) { mSourceWidget = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCheckSourceReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCheckSourceReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCheckSourceReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCheckSourceReqMsgSubscriberList[];

        Courier::UInt32 mSessionId;
        Courier::UInt32 mReqId;
        ::Courier::ViewId mSourceView;
        ::Courier::Identifier mSourceWidget;
};

// ------------------------------------------------------------------------
/** Response sent back to the drag and drop manager to indicate if the checked widget is a valid drag and drop source or not. */
class DragDropCheckSourceResMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCheckSourceResMsg, ::NotifierMessage, 0x3F6DDDAE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DragDropCheckSourceResMsg(Courier::UInt32 const & aReqId, Courier::UInt32 const & aSourceData, bool const & aResult);
        virtual ~DragDropCheckSourceResMsg();

        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        Courier::UInt32 const & GetSourceData() const { return mSourceData; }
        void SetSourceData(Courier::UInt32 const & value) { mSourceData = value; }
        bool const & GetResult() const { return mResult; }
        void SetResult(bool const & value) { mResult = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCheckSourceResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCheckSourceResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCheckSourceResMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCheckSourceResMsgSubscriberList[];

        Courier::UInt32 mReqId;
        Courier::UInt32 mSourceData;
        bool mResult;
};

// ------------------------------------------------------------------------
/** Request sent by the drag and drop manager to check if the widget overlaid by the adorner is a valid drag and drop destination of the current source. */
class DragDropCheckDestinationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCheckDestinationReqMsg, ::NotifierMessage, 0x38D1ACDB);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DragDropCheckDestinationReqMsg(Courier::UInt32 const & aSessionId, Courier::UInt32 const & aReqId, ::Courier::ViewId const & aSourceView, ::Courier::Identifier const & aSourceWidget, Courier::UInt32 const & aSourceData, ::Courier::ViewId const & aDestinationView, ::Courier::Identifier const & aDestinationWidget);
        virtual ~DragDropCheckDestinationReqMsg();

        Courier::UInt32 const & GetSessionId() const { return mSessionId; }
        void SetSessionId(Courier::UInt32 const & value) { mSessionId = value; }
        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        ::Courier::ViewId const & GetSourceView() const { return mSourceView; }
        void SetSourceView(::Courier::ViewId const & value) { mSourceView = value; }
        ::Courier::Identifier const & GetSourceWidget() const { return mSourceWidget; }
        void SetSourceWidget(::Courier::Identifier const & value) { mSourceWidget = value; }
        Courier::UInt32 const & GetSourceData() const { return mSourceData; }
        void SetSourceData(Courier::UInt32 const & value) { mSourceData = value; }
        ::Courier::ViewId const & GetDestinationView() const { return mDestinationView; }
        void SetDestinationView(::Courier::ViewId const & value) { mDestinationView = value; }
        ::Courier::Identifier const & GetDestinationWidget() const { return mDestinationWidget; }
        void SetDestinationWidget(::Courier::Identifier const & value) { mDestinationWidget = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCheckDestinationReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCheckDestinationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCheckDestinationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCheckDestinationReqMsgSubscriberList[];

        Courier::UInt32 mSessionId;
        Courier::UInt32 mReqId;
        ::Courier::ViewId mSourceView;
        ::Courier::Identifier mSourceWidget;
        Courier::UInt32 mSourceData;
        ::Courier::ViewId mDestinationView;
        ::Courier::Identifier mDestinationWidget;
};

// ------------------------------------------------------------------------
/** Response sent back to the drag and drop manager to indicate if the checked widget is a valid drag and drop destination for the current source or not. */
class DragDropCheckDestinationResMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCheckDestinationResMsg, ::NotifierMessage, 0xE682C6B5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DragDropCheckDestinationResMsg(Courier::UInt32 const & aReqId, Courier::UInt32 const & aDestinationData, bool const & aResult);
        virtual ~DragDropCheckDestinationResMsg();

        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        Courier::UInt32 const & GetDestinationData() const { return mDestinationData; }
        void SetDestinationData(Courier::UInt32 const & value) { mDestinationData = value; }
        bool const & GetResult() const { return mResult; }
        void SetResult(bool const & value) { mResult = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCheckDestinationResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCheckDestinationResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCheckDestinationResMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCheckDestinationResMsgSubscriberList[];

        Courier::UInt32 mReqId;
        Courier::UInt32 mDestinationData;
        bool mResult;
};

// ------------------------------------------------------------------------
/** Request sent by the drag and drop manager to complete the current drag and drop operation based on the selected source and the overlaid destination. */
class DragDropCompleteReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCompleteReqMsg, ::NotifierMessage, 0x4B3B43A6);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(2);

        DragDropCompleteReqMsg(Courier::UInt32 const & aSessionId, Courier::UInt32 const & aReqId, ::Courier::ViewId const & aSourceView, ::Courier::Identifier const & aSourceWidget, Courier::UInt32 const & aSourceData, ::Courier::ViewId const & aDestinationView, ::Courier::Identifier const & aDestinationWidget, Courier::UInt32 const & aDestinationData);
        virtual ~DragDropCompleteReqMsg();

        Courier::UInt32 const & GetSessionId() const { return mSessionId; }
        void SetSessionId(Courier::UInt32 const & value) { mSessionId = value; }
        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        ::Courier::ViewId const & GetSourceView() const { return mSourceView; }
        void SetSourceView(::Courier::ViewId const & value) { mSourceView = value; }
        ::Courier::Identifier const & GetSourceWidget() const { return mSourceWidget; }
        void SetSourceWidget(::Courier::Identifier const & value) { mSourceWidget = value; }
        Courier::UInt32 const & GetSourceData() const { return mSourceData; }
        void SetSourceData(Courier::UInt32 const & value) { mSourceData = value; }
        ::Courier::ViewId const & GetDestinationView() const { return mDestinationView; }
        void SetDestinationView(::Courier::ViewId const & value) { mDestinationView = value; }
        ::Courier::Identifier const & GetDestinationWidget() const { return mDestinationWidget; }
        void SetDestinationWidget(::Courier::Identifier const & value) { mDestinationWidget = value; }
        Courier::UInt32 const & GetDestinationData() const { return mDestinationData; }
        void SetDestinationData(Courier::UInt32 const & value) { mDestinationData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCompleteReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCompleteReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCompleteReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCompleteReqMsgSubscriberList[];

        Courier::UInt32 mSessionId;
        Courier::UInt32 mReqId;
        ::Courier::ViewId mSourceView;
        ::Courier::Identifier mSourceWidget;
        Courier::UInt32 mSourceData;
        ::Courier::ViewId mDestinationView;
        ::Courier::Identifier mDestinationWidget;
        Courier::UInt32 mDestinationData;
};

// ------------------------------------------------------------------------
/** Response sent back to the drag and drop manager to indicate the success of the drag and drop operation. */
class DragDropCompleteResMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropCompleteResMsg, ::NotifierMessage, 0x699737AF);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DragDropCompleteResMsg(Courier::UInt32 const & aReqId, bool const & aResult);
        virtual ~DragDropCompleteResMsg();

        Courier::UInt32 const & GetReqId() const { return mReqId; }
        void SetReqId(Courier::UInt32 const & value) { mReqId = value; }
        bool const & GetResult() const { return mResult; }
        void SetResult(bool const & value) { mResult = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropCompleteResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropCompleteResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropCompleteResMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropCompleteResMsgSubscriberList[];

        Courier::UInt32 mReqId;
        bool mResult;
};

// ------------------------------------------------------------------------
/** Request sent to the drag and drop manager to abort the current drag and drop operation. */
class DragDropAbortReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropAbortReqMsg, ::NotifierMessage, 0x79A3B559);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        DragDropAbortReqMsg();
        virtual ~DragDropAbortReqMsg();

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropAbortReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropAbortReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropAbortReqMsgSubscriberList[];
};

// ------------------------------------------------------------------------
/** Update sent by the drag and drop manager to indicate the status of the current drag and drop operation. */
class DragDropStatusUpdMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(DragDropStatusUpdMsg, ::NotifierMessage, 0x2A729CCE);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(3);

        DragDropStatusUpdMsg(hmibase::DragDropStatusEnum const & aStatus, Courier::UInt32 const & aSessionId, ::Courier::ViewId const & aSourceView, ::Courier::Identifier const & aSourceWidget, Courier::UInt32 const & aSourceData, ::Courier::ViewId const & aDestinationView, ::Courier::Identifier const & aDestinationWidget, Courier::UInt32 const & aDestinationData);
        virtual ~DragDropStatusUpdMsg();

        hmibase::DragDropStatusEnum const & GetStatus() const { return mStatus; }
        void SetStatus(hmibase::DragDropStatusEnum const & value) { mStatus = value; }
        Courier::UInt32 const & GetSessionId() const { return mSessionId; }
        void SetSessionId(Courier::UInt32 const & value) { mSessionId = value; }
        ::Courier::ViewId const & GetSourceView() const { return mSourceView; }
        void SetSourceView(::Courier::ViewId const & value) { mSourceView = value; }
        ::Courier::Identifier const & GetSourceWidget() const { return mSourceWidget; }
        void SetSourceWidget(::Courier::Identifier const & value) { mSourceWidget = value; }
        Courier::UInt32 const & GetSourceData() const { return mSourceData; }
        void SetSourceData(Courier::UInt32 const & value) { mSourceData = value; }
        ::Courier::ViewId const & GetDestinationView() const { return mDestinationView; }
        void SetDestinationView(::Courier::ViewId const & value) { mDestinationView = value; }
        ::Courier::Identifier const & GetDestinationWidget() const { return mDestinationWidget; }
        void SetDestinationWidget(::Courier::Identifier const & value) { mDestinationWidget = value; }
        Courier::UInt32 const & GetDestinationData() const { return mDestinationData; }
        void SetDestinationData(Courier::UInt32 const & value) { mDestinationData = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(DragDropStatusUpdMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mDragDropStatusUpdMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mDragDropStatusUpdMsgModifiableMetadata;
        static const ::Courier::ComponentId mDragDropStatusUpdMsgSubscriberList[];

        hmibase::DragDropStatusEnum mStatus;
        Courier::UInt32 mSessionId;
        ::Courier::ViewId mSourceView;
        ::Courier::Identifier mSourceWidget;
        Courier::UInt32 mSourceData;
        ::Courier::ViewId mDestinationView;
        ::Courier::Identifier mDestinationWidget;
        Courier::UInt32 mDestinationData;
};

// ------------------------------------------------------------------------
class ProfileSwitchMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ProfileSwitchMsg, ::NotifierMessage, 0x5786B088);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ProfileSwitchMsg(Courier::UInt32 const & aProfile);
        virtual ~ProfileSwitchMsg();

        Courier::UInt32 const & GetProfile() const { return mProfile; }
        void SetProfile(Courier::UInt32 const & value) { mProfile = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ProfileSwitchMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mProfileSwitchMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mProfileSwitchMsgModifiableMetadata;
        static const ::Courier::ComponentId mProfileSwitchMsgSubscriberList[];

        Courier::UInt32 mProfile;
};

// ------------------------------------------------------------------------
class TransitionMediatorOnDataCompleteMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(TransitionMediatorOnDataCompleteMsg, ::NotifierMessage, 0xF2853645);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        TransitionMediatorOnDataCompleteMsg(Courier::UInt32 const & aHint);
        virtual ~TransitionMediatorOnDataCompleteMsg();

        Courier::UInt32 const & GetHint() const { return mHint; }
        void SetHint(Courier::UInt32 const & value) { mHint = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(TransitionMediatorOnDataCompleteMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mTransitionMediatorOnDataCompleteMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mTransitionMediatorOnDataCompleteMsgModifiableMetadata;
        static const ::Courier::ComponentId mTransitionMediatorOnDataCompleteMsgSubscriberList[];

        Courier::UInt32 mHint;
};

// ------------------------------------------------------------------------
class ManualSceneActionReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ManualSceneActionReqMsg, ::NotifierMessage, 0xD1DE6082);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ManualSceneActionReqMsg(::Courier::ViewId const & aSceneName, hmibase::TraceQueryIdEnum const & aAction);
        virtual ~ManualSceneActionReqMsg();

        ::Courier::ViewId const & GetSceneName() const { return mSceneName; }
        void SetSceneName(::Courier::ViewId const & value) { mSceneName = value; }
        hmibase::TraceQueryIdEnum const & GetAction() const { return mAction; }
        void SetAction(hmibase::TraceQueryIdEnum const & value) { mAction = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(ManualSceneActionReqMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mManualSceneActionReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mManualSceneActionReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mManualSceneActionReqMsgSubscriberList[];

        ::Courier::ViewId mSceneName;
        hmibase::TraceQueryIdEnum mAction;
};

// ------------------------------------------------------------------------
class EglWaitNativeReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EglWaitNativeReqMsg, ::NotifierMessage, 0x41C51D0A);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        EglWaitNativeReqMsg();
        EglWaitNativeReqMsg(Courier::UInt32 const & aSurfaceId, Courier::UInt32 const & aCount);
        virtual ~EglWaitNativeReqMsg();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        Courier::UInt32 const & GetCount() const { return mCount; }
        void SetCount(Courier::UInt32 const & value) { mCount = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEglWaitNativeReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEglWaitNativeReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mEglWaitNativeReqMsgSubscriberList[];

        Courier::UInt32 mSurfaceId;
        Courier::UInt32 mCount;
};

// ------------------------------------------------------------------------
class EglWaitNativeResMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(EglWaitNativeResMsg, ::NotifierMessage, 0x7651E82F);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(4);

        static bool Subscribe(::Courier::ComponentId component, ::Courier::ComponentId before = ::Courier::ComponentType::Invalid);
        static bool Unsubscribe(::Courier::ComponentId component);

        EglWaitNativeResMsg(Courier::UInt32 const & aSurfaceId, bool const & aSuccess, Courier::UInt32 const & aRemaining);
        virtual ~EglWaitNativeResMsg();

        Courier::UInt32 const & GetSurfaceId() const { return mSurfaceId; }
        void SetSurfaceId(Courier::UInt32 const & value) { mSurfaceId = value; }
        bool const & GetSuccess() const { return mSuccess; }
        void SetSuccess(bool const & value) { mSuccess = value; }
        Courier::UInt32 const & GetRemaining() const { return mRemaining; }
        void SetRemaining(Courier::UInt32 const & value) { mRemaining = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        FEATSTD_MAKE_CLASS_STATIC(EglWaitNativeResMsg);
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mEglWaitNativeResMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mEglWaitNativeResMsgModifiableMetadata;
        static ::Courier::ComponentId mEglWaitNativeResMsgSubscriberList[];

        ::Courier::ComponentId mSubscribers[SubscriberListSize];

        Courier::UInt32 mSurfaceId;
        bool mSuccess;
        Courier::UInt32 mRemaining;
};

// ------------------------------------------------------------------------
/** DEPRECATED */
class ResetGadgetCacheReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(ResetGadgetCacheReqMsg, ::NotifierMessage, 0x14412AD5);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        ResetGadgetCacheReqMsg();
        ResetGadgetCacheReqMsg(Courier::Int32 const & aInstanceId, bool const & aResetAll = false);
        virtual ~ResetGadgetCacheReqMsg();

        Courier::Int32 const & GetInstanceId() const { return mInstanceId; }
        void SetInstanceId(Courier::Int32 const & value) { mInstanceId = value; }
        bool const & GetResetAll() const { return mResetAll; }
        void SetResetAll(bool const & value) { mResetAll = value; }

    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mResetGadgetCacheReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mResetGadgetCacheReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mResetGadgetCacheReqMsgSubscriberList[];

        Courier::Int32 mInstanceId;
        bool mResetAll;
};

// ------------------------------------------------------------------------
		/** Starts or stops an attached animation for the specified active view or for the first active view which is found.
		* The main camera of the active view is temporary attached to a framebuffer used as texture in a dedicated view called attached view.
		* The animation animates nodes in this attached view.*/
class AttachedAnimationReqMsg : public ::NotifierMessage
{
    public:
        COURIER_MESSAGE_RTTI_DECLARATION(AttachedAnimationReqMsg, ::NotifierMessage, 0xBDA2E3E0);
        COURIER_MESSAGE_SUBSCRIBER_LIST_SIZE(1);

        AttachedAnimationReqMsg();
        AttachedAnimationReqMsg(::Courier::ViewId const & aAttachedViewId, Candera::String const & aTextureRTNode, ::Courier::ViewId const & aViewId, Courier::AnimationAction::Enum const & aAnimationAction, ::Courier::ItemId const & aAnimationId, Courier::AnimationProperties const & aAnimationProperties);
        virtual ~AttachedAnimationReqMsg();

        ::Courier::ViewId const & GetAttachedViewId() const { return mAttachedViewId; }
        void SetAttachedViewId(::Courier::ViewId const & value) { mAttachedViewId = value; }
        Candera::String const & GetTextureRTNode() const { return mTextureRTNode; }
        void SetTextureRTNode(Candera::String const & value) { mTextureRTNode = value; }
        ::Courier::ViewId const & GetViewId() const { return mViewId; }
        void SetViewId(::Courier::ViewId const & value) { mViewId = value; }
        Courier::AnimationAction::Enum const & GetAnimationAction() const { return mAnimationAction; }
        void SetAnimationAction(Courier::AnimationAction::Enum const & value) { mAnimationAction = value; }
        ::Courier::ItemId const & GetAnimationId() const { return mAnimationId; }
        void SetAnimationId(::Courier::ItemId const & value) { mAnimationId = value; }
        Courier::AnimationProperties const & GetAnimationProperties() const { return mAnimationProperties; }
        void SetAnimationProperties(Courier::AnimationProperties const & value) { mAnimationProperties = value; }

#if defined COURIER_MESSAGE_SERIALIZATION_ENABLED
        virtual const ::Courier::SerializationInfo * GetSerializationInfo() const;
#endif
    protected:
#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
        virtual ::FeatStd::UInt32 AppendTo(::FeatStd::StringBuffer& stringBuffer) const;
#endif
    private:
        virtual const ::Courier::Message::Metadata& GetMetadata() const;
        virtual ::Courier::Message::ModifiableMetadata & GetModifiableMetadata();
        static const ::Courier::Message::Metadata mAttachedAnimationReqMsgMetaData;
        static ::Courier::Message::ModifiableMetadata mAttachedAnimationReqMsgModifiableMetadata;
        static const ::Courier::ComponentId mAttachedAnimationReqMsgSubscriberList[];

        ::Courier::ViewId mAttachedViewId;
        Candera::String mTextureRTNode;
        ::Courier::ViewId mViewId;
        Courier::AnimationAction::Enum mAnimationAction;
        ::Courier::ItemId mAnimationId;
        Courier::AnimationProperties mAnimationProperties;
};

#endif // BaseMsgs_h
