/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define HEATCTRL_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "heatctrl_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 heatctrl_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 heatctrl_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 heatctrl_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 heatctrl_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 heatctrl_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 heatctrl_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 heatctrl_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 heatctrl_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 heatctrl_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 heatctrl_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 heatctrl_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 heatctrl_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& heatctrl_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 heatctrl_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid heatctrl_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tclString::~heatctrl_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

heatctrl_fi_tclString& heatctrl_fi_tclString::operator=(const heatctrl_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

heatctrl_fi_tclString::heatctrl_fi_tclString(const heatctrl_fi_tclString& coRef):heatctrl_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& heatctrl_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool heatctrl_fi_tclString::operator==(const heatctrl_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 heatctrl_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
heatctrl_fi_tclString& heatctrl_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
heatctrl_fi_tclString::heatctrl_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool heatctrl_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

heatctrl_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

heatctrl_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool heatctrl_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar heatctrl_FI_C_U8_NULLCHAR = '\0';

tChar* heatctrl_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* heatctrl_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* heatctrl_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& heatctrl_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}

tChar& heatctrl_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}

tChar& heatctrl_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool heatctrl_fi_tclString::bSet(const heatctrl_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool heatctrl_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString heatctrl_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& heatctrl_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool heatctrl_fi_tclList::operator==(const heatctrl_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 heatctrl_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& heatctrl_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid heatctrl_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tclMultiLanguageString::~heatctrl_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

heatctrl_fi_tclMultiLanguageString& heatctrl_fi_tclMultiLanguageString::operator=(const heatctrl_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

heatctrl_fi_tclMultiLanguageString::heatctrl_fi_tclMultiLanguageString(const heatctrl_fi_tclMultiLanguageString& coRef):heatctrl_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& heatctrl_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool heatctrl_fi_tclMultiLanguageString::operator==(const heatctrl_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 heatctrl_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
heatctrl_fi_tclMultiLanguageString& heatctrl_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
heatctrl_fi_tclMultiLanguageString::heatctrl_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool heatctrl_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

heatctrl_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

heatctrl_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool heatctrl_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* heatctrl_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* heatctrl_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* heatctrl_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& heatctrl_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}

tChar& heatctrl_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}

tChar& heatctrl_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return heatctrl_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool heatctrl_fi_tclMultiLanguageString::bSet(const heatctrl_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool heatctrl_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString heatctrl_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_BinContainer::heatctrl_fi_tcl_BinContainer(const heatctrl_fi_tcl_BinContainer& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
heatctrl_fi_tcl_BinContainer& heatctrl_fi_tcl_BinContainer::operator=(const heatctrl_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

heatctrl_fi_tcl_BinContainer::heatctrl_fi_tcl_BinContainer()

 {}

tS32 heatctrl_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_BINCONTAINER;
}


heatctrl_fi_tcl_BinContainer::~heatctrl_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& heatctrl_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool heatctrl_fi_tcl_BinContainer::operator==(const heatctrl_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

heatctrl_fi_tcl_Reserved::heatctrl_fi_tcl_Reserved()
 {}

tS32 heatctrl_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_RESERVED;
}


heatctrl_fi_tcl_Reserved::~heatctrl_fi_tcl_Reserved()
{}

tU32 heatctrl_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& heatctrl_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u8_Percent::heatctrl_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 heatctrl_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U8_PERCENT;
}


heatctrl_fi_tcl_u8_Percent::~heatctrl_fi_tcl_u8_Percent()
{}

tU32 heatctrl_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_PerThousand::heatctrl_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


heatctrl_fi_tcl_s16_PerThousand::~heatctrl_fi_tcl_s16_PerThousand()
{}

tU32 heatctrl_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_IndexInReferenceList::heatctrl_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


heatctrl_fi_tcl_u16_IndexInReferenceList::~heatctrl_fi_tcl_u16_IndexInReferenceList()
{}

tU32 heatctrl_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_ErrorCode::heatctrl_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_ERRORCODE;
}


heatctrl_fi_tcl_u16_ErrorCode::~heatctrl_fi_tcl_u16_ErrorCode()
{}

tU32 heatctrl_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_RPM::heatctrl_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_RPM;
}


heatctrl_fi_tcl_u16_RPM::~heatctrl_fi_tcl_u16_RPM()
{}

tU32 heatctrl_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Kilogram::heatctrl_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_KILOGRAM;
}


heatctrl_fi_tcl_s32_Kilogram::~heatctrl_fi_tcl_s32_Kilogram()
{}

tU32 heatctrl_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Pound::heatctrl_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_POUND;
}


heatctrl_fi_tcl_s32_Pound::~heatctrl_fi_tcl_s32_Pound()
{}

tU32 heatctrl_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_Meter::heatctrl_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_METER;
}


heatctrl_fi_tcl_s16_Meter::~heatctrl_fi_tcl_s16_Meter()
{}

tU32 heatctrl_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Meter::heatctrl_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_METER;
}


heatctrl_fi_tcl_s32_Meter::~heatctrl_fi_tcl_s32_Meter()
{}

tU32 heatctrl_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Yards::heatctrl_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_YARDS;
}


heatctrl_fi_tcl_s32_Yards::~heatctrl_fi_tcl_s32_Yards()
{}

tU32 heatctrl_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Foot::heatctrl_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_FOOT;
}


heatctrl_fi_tcl_s32_Foot::~heatctrl_fi_tcl_s32_Foot()
{}

tU32 heatctrl_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Centimeter::heatctrl_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_CENTIMETER;
}


heatctrl_fi_tcl_s32_Centimeter::~heatctrl_fi_tcl_s32_Centimeter()
{}

tU32 heatctrl_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Inch::heatctrl_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_INCH;
}


heatctrl_fi_tcl_s32_Inch::~heatctrl_fi_tcl_s32_Inch()
{}

tU32 heatctrl_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Millimeter::heatctrl_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_MILLIMETER;
}


heatctrl_fi_tcl_s32_Millimeter::~heatctrl_fi_tcl_s32_Millimeter()
{}

tU32 heatctrl_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Microliter::heatctrl_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_MICROLITER;
}


heatctrl_fi_tcl_s32_Microliter::~heatctrl_fi_tcl_s32_Microliter()
{}

tU32 heatctrl_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Second::heatctrl_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_SECOND;
}


heatctrl_fi_tcl_s32_Second::~heatctrl_fi_tcl_s32_Second()
{}

tU32 heatctrl_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_MilliSecond::heatctrl_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_MILLISECOND;
}


heatctrl_fi_tcl_u16_MilliSecond::~heatctrl_fi_tcl_u16_MilliSecond()
{}

tU32 heatctrl_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_MilliSecond::heatctrl_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_MILLISECOND;
}


heatctrl_fi_tcl_s32_MilliSecond::~heatctrl_fi_tcl_s32_MilliSecond()
{}

tU32 heatctrl_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_POSIXTime::heatctrl_fi_tcl_POSIXTime(const heatctrl_fi_tcl_POSIXTime& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
heatctrl_fi_tcl_POSIXTime& heatctrl_fi_tcl_POSIXTime::operator=(const heatctrl_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_POSIXTime::heatctrl_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 heatctrl_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_POSIXTIME;
}


heatctrl_fi_tcl_POSIXTime::~heatctrl_fi_tcl_POSIXTime()
{}

tU32 heatctrl_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool heatctrl_fi_tcl_POSIXTime::operator==(const heatctrl_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_DST_State::heatctrl_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 heatctrl_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_DST_STATE;
}


heatctrl_fi_tcl_e8_DST_State::~heatctrl_fi_tcl_e8_DST_State()
{}

tU32 heatctrl_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_TimeZoneElement::heatctrl_fi_tcl_TimeZoneElement(const heatctrl_fi_tcl_TimeZoneElement& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
heatctrl_fi_tcl_TimeZoneElement& heatctrl_fi_tcl_TimeZoneElement::operator=(const heatctrl_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

heatctrl_fi_tcl_TimeZoneElement::heatctrl_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 heatctrl_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


heatctrl_fi_tcl_TimeZoneElement::~heatctrl_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& heatctrl_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool heatctrl_fi_tcl_TimeZoneElement::operator==(const heatctrl_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_KmPerHour::heatctrl_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_KMPERHOUR;
}


heatctrl_fi_tcl_s16_KmPerHour::~heatctrl_fi_tcl_s16_KmPerHour()
{}

tU32 heatctrl_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_MilesPerHour::heatctrl_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


heatctrl_fi_tcl_s16_MilesPerHour::~heatctrl_fi_tcl_s16_MilesPerHour()
{}

tU32 heatctrl_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_Knot::heatctrl_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_KNOT;
}


heatctrl_fi_tcl_s16_Knot::~heatctrl_fi_tcl_s16_Knot()
{}

tU32 heatctrl_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_CentimeterSecond::heatctrl_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


heatctrl_fi_tcl_s16_CentimeterSecond::~heatctrl_fi_tcl_s16_CentimeterSecond()
{}

tU32 heatctrl_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_Kelvin::heatctrl_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_KELVIN;
}


heatctrl_fi_tcl_s16_Kelvin::~heatctrl_fi_tcl_s16_Kelvin()
{}

tU32 heatctrl_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_Fahrenheit::heatctrl_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


heatctrl_fi_tcl_s16_Fahrenheit::~heatctrl_fi_tcl_s16_Fahrenheit()
{}

tU32 heatctrl_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Pascal::heatctrl_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_PASCAL;
}


heatctrl_fi_tcl_s32_Pascal::~heatctrl_fi_tcl_s32_Pascal()
{}

tU32 heatctrl_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Watt::heatctrl_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_WATT;
}


heatctrl_fi_tcl_s32_Watt::~heatctrl_fi_tcl_s32_Watt()
{}

tU32 heatctrl_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_FIVersion::heatctrl_fi_tcl_FIVersion(const heatctrl_fi_tcl_FIVersion& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
heatctrl_fi_tcl_FIVersion& heatctrl_fi_tcl_FIVersion::operator=(const heatctrl_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_FIVersion::heatctrl_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 heatctrl_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_FIVERSION;
}


heatctrl_fi_tcl_FIVersion::~heatctrl_fi_tcl_FIVersion()
{}

tU32 heatctrl_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& heatctrl_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool heatctrl_fi_tcl_FIVersion::operator==(const heatctrl_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Longitude::heatctrl_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_LONGITUDE;
}


heatctrl_fi_tcl_s32_Longitude::~heatctrl_fi_tcl_s32_Longitude()
{}

tU32 heatctrl_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s32_Latitude::heatctrl_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 heatctrl_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S32_LATITUDE;
}


heatctrl_fi_tcl_s32_Latitude::~heatctrl_fi_tcl_s32_Latitude()
{}

tU32 heatctrl_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_PositionWGS84::heatctrl_fi_tcl_PositionWGS84(const heatctrl_fi_tcl_PositionWGS84& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
heatctrl_fi_tcl_PositionWGS84& heatctrl_fi_tcl_PositionWGS84::operator=(const heatctrl_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_PositionWGS84::heatctrl_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 heatctrl_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_POSITIONWGS84;
}


heatctrl_fi_tcl_PositionWGS84::~heatctrl_fi_tcl_PositionWGS84()
{}

tU32 heatctrl_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& heatctrl_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool heatctrl_fi_tcl_PositionWGS84::operator==(const heatctrl_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_RectangleWGS84::heatctrl_fi_tcl_RectangleWGS84(const heatctrl_fi_tcl_RectangleWGS84& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
heatctrl_fi_tcl_RectangleWGS84& heatctrl_fi_tcl_RectangleWGS84::operator=(const heatctrl_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_RectangleWGS84::heatctrl_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 heatctrl_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_RECTANGLEWGS84;
}


heatctrl_fi_tcl_RectangleWGS84::~heatctrl_fi_tcl_RectangleWGS84()
{}

tU32 heatctrl_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& heatctrl_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool heatctrl_fi_tcl_RectangleWGS84::operator==(const heatctrl_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e16_ISOCountryCode::heatctrl_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 heatctrl_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


heatctrl_fi_tcl_e16_ISOCountryCode::~heatctrl_fi_tcl_e16_ISOCountryCode()
{}

tU32 heatctrl_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e16_ISOLanguageCode::heatctrl_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 heatctrl_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


heatctrl_fi_tcl_e16_ISOLanguageCode::~heatctrl_fi_tcl_e16_ISOLanguageCode()
{}

tU32 heatctrl_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_LanguageID::heatctrl_fi_tcl_LanguageID(const heatctrl_fi_tcl_LanguageID& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
heatctrl_fi_tcl_LanguageID& heatctrl_fi_tcl_LanguageID::operator=(const heatctrl_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_LanguageID::heatctrl_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 heatctrl_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_LANGUAGEID;
}


heatctrl_fi_tcl_LanguageID::~heatctrl_fi_tcl_LanguageID()
{}

tU32 heatctrl_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool heatctrl_fi_tcl_LanguageID::operator==(const heatctrl_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u8_DirectionAbsolute::heatctrl_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 heatctrl_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


heatctrl_fi_tcl_u8_DirectionAbsolute::~heatctrl_fi_tcl_u8_DirectionAbsolute()
{}

tU32 heatctrl_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u8_DirectionRelative::heatctrl_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 heatctrl_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


heatctrl_fi_tcl_u8_DirectionRelative::~heatctrl_fi_tcl_u8_DirectionRelative()
{}

tU32 heatctrl_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_CentiDegree::heatctrl_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


heatctrl_fi_tcl_s16_CentiDegree::~heatctrl_fi_tcl_s16_CentiDegree()
{}

tU32 heatctrl_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_Degree::heatctrl_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_DEGREE;
}


heatctrl_fi_tcl_s16_Degree::~heatctrl_fi_tcl_s16_Degree()
{}

tU32 heatctrl_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::~heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::~heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_FuelType::heatctrl_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 heatctrl_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_FUELTYPE;
}


heatctrl_fi_tcl_e8_FuelType::~heatctrl_fi_tcl_e8_FuelType()
{}

tU32 heatctrl_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_DistTimeFuel::heatctrl_fi_tcl_DistTimeFuel(const heatctrl_fi_tcl_DistTimeFuel& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
heatctrl_fi_tcl_DistTimeFuel& heatctrl_fi_tcl_DistTimeFuel::operator=(const heatctrl_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_DistTimeFuel::heatctrl_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 heatctrl_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_DISTTIMEFUEL;
}


heatctrl_fi_tcl_DistTimeFuel::~heatctrl_fi_tcl_DistTimeFuel()
{}

tU32 heatctrl_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& heatctrl_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool heatctrl_fi_tcl_DistTimeFuel::operator==(const heatctrl_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_SensorID::heatctrl_fi_tcl_e8_SensorID():enType(FI_EN_FC_HEATCTRL_SENSORID_UNDEF) {}

tS32 heatctrl_fi_tcl_e8_SensorID::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_SENSORID;
}


heatctrl_fi_tcl_e8_SensorID::~heatctrl_fi_tcl_e8_SensorID()
{}

tU32 heatctrl_fi_tcl_e8_SensorID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_SensorID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_SensorID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_TemperatureQualityType::heatctrl_fi_tcl_e8_TemperatureQualityType():enType(FI_EN_FC_HEATCTRL_TEMPQUALITY_INVALID) {}

tS32 heatctrl_fi_tcl_e8_TemperatureQualityType::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_TEMPERATUREQUALITYTYPE;
}


heatctrl_fi_tcl_e8_TemperatureQualityType::~heatctrl_fi_tcl_e8_TemperatureQualityType()
{}

tU32 heatctrl_fi_tcl_e8_TemperatureQualityType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_TemperatureQualityType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_TemperatureQualityType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_s16_SensorTemperaturValue::heatctrl_fi_tcl_s16_SensorTemperaturValue(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 heatctrl_fi_tcl_s16_SensorTemperaturValue::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_S16_SENSORTEMPERATURVALUE;
}


heatctrl_fi_tcl_s16_SensorTemperaturValue::~heatctrl_fi_tcl_s16_SensorTemperaturValue()
{}

tU32 heatctrl_fi_tcl_s16_SensorTemperaturValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_s16_SensorTemperaturValue::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_s16_SensorTemperaturValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_SensorState::heatctrl_fi_tcl_e8_SensorState():enType(FI_EN_FC_HEATCTRL_UNAVAIL) {}

tS32 heatctrl_fi_tcl_e8_SensorState::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_SENSORSTATE;
}


heatctrl_fi_tcl_e8_SensorState::~heatctrl_fi_tcl_e8_SensorState()
{}

tU32 heatctrl_fi_tcl_e8_SensorState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_SensorState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_SensorState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_SensorTemperature::heatctrl_fi_tcl_SensorTemperature(const heatctrl_fi_tcl_SensorTemperature& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Temperature = coRef.Temperature;
   Quality = coRef.Quality;
   TemperatureMin = coRef.TemperatureMin;
   TemperatureMax = coRef.TemperatureMax;
}
heatctrl_fi_tcl_SensorTemperature& heatctrl_fi_tcl_SensorTemperature::operator=(const heatctrl_fi_tcl_SensorTemperature& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Temperature = coRef.Temperature;
   Quality = coRef.Quality;
   TemperatureMin = coRef.TemperatureMin;
   TemperatureMax = coRef.TemperatureMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_SensorTemperature::heatctrl_fi_tcl_SensorTemperature()
:ID()
,Temperature()
,Quality()
,TemperatureMin()
,TemperatureMax()
 {}

tS32 heatctrl_fi_tcl_SensorTemperature::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_SENSORTEMPERATURE;
}


heatctrl_fi_tcl_SensorTemperature::~heatctrl_fi_tcl_SensorTemperature()
{}

tU32 heatctrl_fi_tcl_SensorTemperature::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& heatctrl_fi_tcl_SensorTemperature::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> Temperature);
   (tVoid) (oIn >> Quality);
   (tVoid) (oIn >> TemperatureMin);
   (tVoid) (oIn >> TemperatureMax);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_SensorTemperature::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << Temperature);
   (tVoid) (oOut << Quality);
   (tVoid) (oOut << TemperatureMin);
   (tVoid) (oOut << TemperatureMax);
   return oOut;
}

tBool heatctrl_fi_tcl_SensorTemperature::operator==(const heatctrl_fi_tcl_SensorTemperature& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (Temperature == roRef.Temperature);
   bResult = bResult && (Quality == roRef.Quality);
   bResult = bResult && (TemperatureMin == roRef.TemperatureMin);
   bResult = bResult && (TemperatureMax == roRef.TemperatureMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_SensorTemperatureList::heatctrl_fi_tcl_SensorTemperatureList(const heatctrl_fi_tcl_SensorTemperatureList& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   SensorTemperatureList = coRef.SensorTemperatureList;
}
heatctrl_fi_tcl_SensorTemperatureList& heatctrl_fi_tcl_SensorTemperatureList::operator=(const heatctrl_fi_tcl_SensorTemperatureList& coRef)
{
   if (this == &coRef) return *this;
   SensorTemperatureList = coRef.SensorTemperatureList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_fi_tcl_SensorTemperatureList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SensorTemperatureList.size(); ++u32Idx)
         SensorTemperatureList[u32Idx].vDestroy();
   SensorTemperatureList.clear();
   }
}

heatctrl_fi_tcl_SensorTemperatureList::heatctrl_fi_tcl_SensorTemperatureList()

 {}

tS32 heatctrl_fi_tcl_SensorTemperatureList::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_SENSORTEMPERATURELIST;
}


heatctrl_fi_tcl_SensorTemperatureList::~heatctrl_fi_tcl_SensorTemperatureList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_fi_tcl_SensorTemperatureList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SensorTemperatureList.size()*8);
}

fi_tclInContext& heatctrl_fi_tcl_SensorTemperatureList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SensorTemperatureList.size(); ++u32Idx)
      {
         SensorTemperatureList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SensorTemperatureList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SensorTemperatureList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_SensorTemperatureList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SensorTemperatureList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SensorTemperatureList.size(); ++u32Idx)
         (tVoid) (oOut << SensorTemperatureList[u32Idx]);
   }
   return oOut;
}

tBool heatctrl_fi_tcl_SensorTemperatureList::operator==(const heatctrl_fi_tcl_SensorTemperatureList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SensorTemperatureList.size() == roRef.SensorTemperatureList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SensorTemperatureList.size()); ++u32Idx)
            bResult = bResult && (SensorTemperatureList[u32Idx] == roRef.SensorTemperatureList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_SensorState::heatctrl_fi_tcl_SensorState(const heatctrl_fi_tcl_SensorState& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   State = coRef.State;
   LastValidState = coRef.LastValidState;
}
heatctrl_fi_tcl_SensorState& heatctrl_fi_tcl_SensorState::operator=(const heatctrl_fi_tcl_SensorState& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   State = coRef.State;
   LastValidState = coRef.LastValidState;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_SensorState::heatctrl_fi_tcl_SensorState()
:ID()
,State()
,LastValidState()
 {}

tS32 heatctrl_fi_tcl_SensorState::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_SENSORSTATE;
}


heatctrl_fi_tcl_SensorState::~heatctrl_fi_tcl_SensorState()
{}

tU32 heatctrl_fi_tcl_SensorState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& heatctrl_fi_tcl_SensorState::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> LastValidState);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_SensorState::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << State);
   (tVoid) (oOut << LastValidState);
   return oOut;
}

tBool heatctrl_fi_tcl_SensorState::operator==(const heatctrl_fi_tcl_SensorState& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (LastValidState == roRef.LastValidState);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_SensorStateList::heatctrl_fi_tcl_SensorStateList(const heatctrl_fi_tcl_SensorStateList& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   SensorStateList = coRef.SensorStateList;
}
heatctrl_fi_tcl_SensorStateList& heatctrl_fi_tcl_SensorStateList::operator=(const heatctrl_fi_tcl_SensorStateList& coRef)
{
   if (this == &coRef) return *this;
   SensorStateList = coRef.SensorStateList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_fi_tcl_SensorStateList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SensorStateList.size(); ++u32Idx)
         SensorStateList[u32Idx].vDestroy();
   SensorStateList.clear();
   }
}

heatctrl_fi_tcl_SensorStateList::heatctrl_fi_tcl_SensorStateList()

 {}

tS32 heatctrl_fi_tcl_SensorStateList::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_SENSORSTATELIST;
}


heatctrl_fi_tcl_SensorStateList::~heatctrl_fi_tcl_SensorStateList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_fi_tcl_SensorStateList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SensorStateList.size()*3);
}

fi_tclInContext& heatctrl_fi_tcl_SensorStateList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SensorStateList.size(); ++u32Idx)
      {
         SensorStateList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SensorStateList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SensorStateList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_SensorStateList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SensorStateList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SensorStateList.size(); ++u32Idx)
         (tVoid) (oOut << SensorStateList[u32Idx]);
   }
   return oOut;
}

tBool heatctrl_fi_tcl_SensorStateList::operator==(const heatctrl_fi_tcl_SensorStateList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SensorStateList.size() == roRef.SensorStateList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SensorStateList.size()); ++u32Idx)
            bResult = bResult && (SensorStateList[u32Idx] == roRef.SensorStateList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_EmergncyFunctionID::heatctrl_fi_tcl_e8_EmergncyFunctionID():enType(FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_SYSTEMSHUTDOWN) {}

tS32 heatctrl_fi_tcl_e8_EmergncyFunctionID::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_EMERGNCYFUNCTIONID;
}


heatctrl_fi_tcl_e8_EmergncyFunctionID::~heatctrl_fi_tcl_e8_EmergncyFunctionID()
{}

tU32 heatctrl_fi_tcl_e8_EmergncyFunctionID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_EmergncyFunctionID::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_EmergncyFunctionID::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_EmergncyFunctionState::heatctrl_fi_tcl_e8_EmergncyFunctionState():enType(FI_EN_FC_HEATCTRL_EMERGENCYFUNCTION_STATE_NORESULT) {}

tS32 heatctrl_fi_tcl_e8_EmergncyFunctionState::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_EMERGNCYFUNCTIONSTATE;
}


heatctrl_fi_tcl_e8_EmergncyFunctionState::~heatctrl_fi_tcl_e8_EmergncyFunctionState()
{}

tU32 heatctrl_fi_tcl_e8_EmergncyFunctionState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_EmergncyFunctionState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_EmergncyFunctionState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_EmergencyFunction::heatctrl_fi_tcl_EmergencyFunction(const heatctrl_fi_tcl_EmergencyFunction& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   State = coRef.State;
}
heatctrl_fi_tcl_EmergencyFunction& heatctrl_fi_tcl_EmergencyFunction::operator=(const heatctrl_fi_tcl_EmergencyFunction& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   State = coRef.State;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_EmergencyFunction::heatctrl_fi_tcl_EmergencyFunction()
:ID()
,State()
 {}

tS32 heatctrl_fi_tcl_EmergencyFunction::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_EMERGENCYFUNCTION;
}


heatctrl_fi_tcl_EmergencyFunction::~heatctrl_fi_tcl_EmergencyFunction()
{}

tU32 heatctrl_fi_tcl_EmergencyFunction::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_EmergencyFunction::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   (tVoid) (oIn >> State);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_EmergencyFunction::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << State);
   return oOut;
}

tBool heatctrl_fi_tcl_EmergencyFunction::operator==(const heatctrl_fi_tcl_EmergencyFunction& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
   bResult = bResult && (State == roRef.State);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_EmergencyFunctionList::heatctrl_fi_tcl_EmergencyFunctionList(const heatctrl_fi_tcl_EmergencyFunctionList& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   EmergencyFunctionList = coRef.EmergencyFunctionList;
}
heatctrl_fi_tcl_EmergencyFunctionList& heatctrl_fi_tcl_EmergencyFunctionList::operator=(const heatctrl_fi_tcl_EmergencyFunctionList& coRef)
{
   if (this == &coRef) return *this;
   EmergencyFunctionList = coRef.EmergencyFunctionList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_fi_tcl_EmergencyFunctionList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < EmergencyFunctionList.size(); ++u32Idx)
         EmergencyFunctionList[u32Idx].vDestroy();
   EmergencyFunctionList.clear();
   }
}

heatctrl_fi_tcl_EmergencyFunctionList::heatctrl_fi_tcl_EmergencyFunctionList()

 {}

tS32 heatctrl_fi_tcl_EmergencyFunctionList::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_EMERGENCYFUNCTIONLIST;
}


heatctrl_fi_tcl_EmergencyFunctionList::~heatctrl_fi_tcl_EmergencyFunctionList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_fi_tcl_EmergencyFunctionList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(EmergencyFunctionList.size()*2);
}

fi_tclInContext& heatctrl_fi_tcl_EmergencyFunctionList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < EmergencyFunctionList.size(); ++u32Idx)
      {
         EmergencyFunctionList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      EmergencyFunctionList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> EmergencyFunctionList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_EmergencyFunctionList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)EmergencyFunctionList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < EmergencyFunctionList.size(); ++u32Idx)
         (tVoid) (oOut << EmergencyFunctionList[u32Idx]);
   }
   return oOut;
}

tBool heatctrl_fi_tcl_EmergencyFunctionList::operator==(const heatctrl_fi_tcl_EmergencyFunctionList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (EmergencyFunctionList.size() == roRef.EmergencyFunctionList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < EmergencyFunctionList.size()); ++u32Idx)
            bResult = bResult && (EmergencyFunctionList[u32Idx] == roRef.EmergencyFunctionList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_FANPowerState::heatctrl_fi_tcl_e8_FANPowerState():enType(FI_EN_FC_HEATCTRL_FANPWRSTATE_INIT) {}

tS32 heatctrl_fi_tcl_e8_FANPowerState::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_FANPOWERSTATE;
}


heatctrl_fi_tcl_e8_FANPowerState::~heatctrl_fi_tcl_e8_FANPowerState()
{}

tU32 heatctrl_fi_tcl_e8_FANPowerState::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_FANPowerState::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_FANPowerState::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u8_FANSpeedValue::heatctrl_fi_tcl_u8_FANSpeedValue(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 heatctrl_fi_tcl_u8_FANSpeedValue::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U8_FANSPEEDVALUE;
}


heatctrl_fi_tcl_u8_FANSpeedValue::~heatctrl_fi_tcl_u8_FANSpeedValue()
{}

tU32 heatctrl_fi_tcl_u8_FANSpeedValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_u8_FANSpeedValue::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u8_FANSpeedValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_u16_FANCurrentValue::heatctrl_fi_tcl_u16_FANCurrentValue(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 heatctrl_fi_tcl_u16_FANCurrentValue::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_U16_FANCURRENTVALUE;
}


heatctrl_fi_tcl_u16_FANCurrentValue::~heatctrl_fi_tcl_u16_FANCurrentValue()
{}

tU32 heatctrl_fi_tcl_u16_FANCurrentValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_u16_FANCurrentValue::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& heatctrl_fi_tcl_u16_FANCurrentValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_FANCtrlMode::heatctrl_fi_tcl_e8_FANCtrlMode():enType(FI_EN_FC_HEATCTRL_FANCTRLMODE_INIT) {}

tS32 heatctrl_fi_tcl_e8_FANCtrlMode::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_FANCTRLMODE;
}


heatctrl_fi_tcl_e8_FANCtrlMode::~heatctrl_fi_tcl_e8_FANCtrlMode()
{}

tU32 heatctrl_fi_tcl_e8_FANCtrlMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_FANCtrlMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_FANCtrlMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_e8_FANCtrlEvent::heatctrl_fi_tcl_e8_FANCtrlEvent():enType(FI_EN_FC_HEATCTRL_FANCTRLEVENT_MANUAL_END) {}

tS32 heatctrl_fi_tcl_e8_FANCtrlEvent::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_E8_FANCTRLEVENT;
}


heatctrl_fi_tcl_e8_FANCtrlEvent::~heatctrl_fi_tcl_e8_FANCtrlEvent()
{}

tU32 heatctrl_fi_tcl_e8_FANCtrlEvent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_e8_FANCtrlEvent::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_e8_FANCtrlEvent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_FAN::heatctrl_fi_tcl_FAN(const heatctrl_fi_tcl_FAN& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   State = coRef.State;
   Speed = coRef.Speed;
   Current = coRef.Current;
}
heatctrl_fi_tcl_FAN& heatctrl_fi_tcl_FAN::operator=(const heatctrl_fi_tcl_FAN& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Speed = coRef.Speed;
   Current = coRef.Current;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_FAN::heatctrl_fi_tcl_FAN()
:State()
,Speed()
,Current()
 {}

tS32 heatctrl_fi_tcl_FAN::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_FAN;
}


heatctrl_fi_tcl_FAN::~heatctrl_fi_tcl_FAN()
{}

tU32 heatctrl_fi_tcl_FAN::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& heatctrl_fi_tcl_FAN::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Speed);
   (tVoid) (oIn >> Current);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_FAN::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << Speed);
   (tVoid) (oOut << Current);
   return oOut;
}

tBool heatctrl_fi_tcl_FAN::operator==(const heatctrl_fi_tcl_FAN& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Speed == roRef.Speed);
   bResult = bResult && (Current == roRef.Current);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_FANReq::heatctrl_fi_tcl_FANReq(const heatctrl_fi_tcl_FANReq& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   State = coRef.State;
   Speed = coRef.Speed;
}
heatctrl_fi_tcl_FANReq& heatctrl_fi_tcl_FANReq::operator=(const heatctrl_fi_tcl_FANReq& coRef)
{
   if (this == &coRef) return *this;
   State = coRef.State;
   Speed = coRef.Speed;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_FANReq::heatctrl_fi_tcl_FANReq()
:State()
,Speed()
 {}

tS32 heatctrl_fi_tcl_FANReq::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_FANREQ;
}


heatctrl_fi_tcl_FANReq::~heatctrl_fi_tcl_FANReq()
{}

tU32 heatctrl_fi_tcl_FANReq::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_fi_tcl_FANReq::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> State);
   (tVoid) (oIn >> Speed);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_FANReq::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << State);
   (tVoid) (oOut << Speed);
   return oOut;
}

tBool heatctrl_fi_tcl_FANReq::operator==(const heatctrl_fi_tcl_FANReq& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (State == roRef.State);
   bResult = bResult && (Speed == roRef.Speed);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_FANCtrl::heatctrl_fi_tcl_FANCtrl(const heatctrl_fi_tcl_FANCtrl& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Mode = coRef.Mode;
}
heatctrl_fi_tcl_FANCtrl& heatctrl_fi_tcl_FANCtrl::operator=(const heatctrl_fi_tcl_FANCtrl& coRef)
{
   if (this == &coRef) return *this;
   Mode = coRef.Mode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_FANCtrl::heatctrl_fi_tcl_FANCtrl()
:Mode()
 {}

tS32 heatctrl_fi_tcl_FANCtrl::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_FANCTRL;
}


heatctrl_fi_tcl_FANCtrl::~heatctrl_fi_tcl_FANCtrl()
{}

tU32 heatctrl_fi_tcl_FANCtrl::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_FANCtrl::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Mode);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_FANCtrl::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Mode);
   return oOut;
}

tBool heatctrl_fi_tcl_FANCtrl::operator==(const heatctrl_fi_tcl_FANCtrl& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Mode == roRef.Mode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_fi_tcl_FANCtrlReq::heatctrl_fi_tcl_FANCtrlReq(const heatctrl_fi_tcl_FANCtrlReq& coRef)
   : heatctrl_fi_tclVisitableTypeBase(coRef)
{
   Event = coRef.Event;
}
heatctrl_fi_tcl_FANCtrlReq& heatctrl_fi_tcl_FANCtrlReq::operator=(const heatctrl_fi_tcl_FANCtrlReq& coRef)
{
   if (this == &coRef) return *this;
   Event = coRef.Event;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_fi_tcl_FANCtrlReq::heatctrl_fi_tcl_FANCtrlReq()
:Event()
 {}

tS32 heatctrl_fi_tcl_FANCtrlReq::s32GetTypeId() const
{
   return (tS32) heatctrl_typesfi_tclToken::EN_FANCTRLREQ;
}


heatctrl_fi_tcl_FANCtrlReq::~heatctrl_fi_tcl_FANCtrlReq()
{}

tU32 heatctrl_fi_tcl_FANCtrlReq::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& heatctrl_fi_tcl_FANCtrlReq::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Event);
   return oIn;
}

fi_tclOutContext& heatctrl_fi_tcl_FANCtrlReq::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Event);
   return oOut;
}

tBool heatctrl_fi_tcl_FANCtrlReq::operator==(const heatctrl_fi_tcl_FANCtrlReq& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Event == roRef.Event);
   return bResult;
}

