/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_TYPES
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_FUNCTIONIDS
#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_SERVICEINFO
#include "heatctrl_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for heatctrl_main_fi message types

fi_tclMessageBase* heatctrl_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODSTART:
         return OSAL_NEW heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart;

      case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODRESULT:
         return OSAL_NEW heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorTemperaturesGet;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorStatesUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorStatesGet;

      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgRealSensorStatesStatus;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorStatesGet;

      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgAbstractSensorStatesStatus;

      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgEmergencyFunctionsGet;

      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgEmergencyFunctionsStatus;

      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgFANControlUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLRELUPREG:
         return OSAL_NEW heatctrl_mainfi_tclMsgFANControlRelUpReg;

      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLGET:
         return OSAL_NEW heatctrl_mainfi_tclMsgFANControlGet;

      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSET:
         return OSAL_NEW heatctrl_mainfi_tclMsgFANControlSet;

      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSTATUS:
         return OSAL_NEW heatctrl_mainfi_tclMsgFANControlStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all heatctrl_mainfifi messages

// common functions

tU16 heatctrl_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return HEATCTRL_MAINFI_C_U16_SERVICE_ID;
}

tU16 heatctrl_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 heatctrl_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& heatctrl_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& heatctrl_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 heatctrl_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& heatctrl_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
}
heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::operator=(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsMode = coRef.DefaultSettingsMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart()
:DefaultSettingsGroup(0)
,DefaultSettingsMode(0)
 {}

tS32 heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODSTART;
}


heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::~heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart()
{}

tU32 heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsMode);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsMode);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart::operator==(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsMode == roRef.DefaultSettingsMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
}
heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::operator=(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefaultSettingsGroup = coRef.DefaultSettingsGroup;
   DefaultSettingsStatus = coRef.DefaultSettingsStatus;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult()
:DefaultSettingsGroup(0)
,DefaultSettingsStatus(0)
 {}

tS32 heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODRESULT;
}


heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::~heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult()
{}

tU32 heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefaultSettingsGroup);
   (tVoid) (oIn >> DefaultSettingsStatus);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefaultSettingsGroup);
   (tVoid) (oOut << DefaultSettingsStatus);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult::operator==(const heatctrl_mainfi_tclMsgFI_FC_HEATCTRL_DEFAULTMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefaultSettingsGroup == roRef.DefaultSettingsGroup);
   bResult = bResult && (DefaultSettingsStatus == roRef.DefaultSettingsStatus);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg::heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESUPREG;
}


heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg::~heatctrl_mainfi_tclMsgRealSensorTemperaturesUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg::heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESRELUPREG;
}


heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg::~heatctrl_mainfi_tclMsgRealSensorTemperaturesRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorTemperaturesGet::heatctrl_mainfi_tclMsgRealSensorTemperaturesGet()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorTemperaturesGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESGET;
}


heatctrl_mainfi_tclMsgRealSensorTemperaturesGet::~heatctrl_mainfi_tclMsgRealSensorTemperaturesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::operator=(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::vDestroy()
{
   List.vDestroy(); 
}

heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus()
:List()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESSTATUS;
}


heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::~heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus::operator==(const heatctrl_mainfi_tclMsgRealSensorTemperaturesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorStatesUpReg::heatctrl_mainfi_tclMsgRealSensorStatesUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorStatesUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESUPREG;
}


heatctrl_mainfi_tclMsgRealSensorStatesUpReg::~heatctrl_mainfi_tclMsgRealSensorStatesUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg::heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESRELUPREG;
}


heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg::~heatctrl_mainfi_tclMsgRealSensorStatesRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgRealSensorStatesGet::heatctrl_mainfi_tclMsgRealSensorStatesGet()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorStatesGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESGET;
}


heatctrl_mainfi_tclMsgRealSensorStatesGet::~heatctrl_mainfi_tclMsgRealSensorStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgRealSensorStatesStatus::heatctrl_mainfi_tclMsgRealSensorStatesStatus(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
heatctrl_mainfi_tclMsgRealSensorStatesStatus& heatctrl_mainfi_tclMsgRealSensorStatesStatus::operator=(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_mainfi_tclMsgRealSensorStatesStatus::vDestroy()
{
   List.vDestroy(); 
}

heatctrl_mainfi_tclMsgRealSensorStatesStatus::heatctrl_mainfi_tclMsgRealSensorStatesStatus()
:List()
 {}

tS32 heatctrl_mainfi_tclMsgRealSensorStatesStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESSTATUS;
}


heatctrl_mainfi_tclMsgRealSensorStatesStatus::~heatctrl_mainfi_tclMsgRealSensorStatesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_mainfi_tclMsgRealSensorStatesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& heatctrl_mainfi_tclMsgRealSensorStatesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgRealSensorStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgRealSensorStatesStatus::operator==(const heatctrl_mainfi_tclMsgRealSensorStatesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg::heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESUPREG;
}


heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg::~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg::heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESRELUPREG;
}


heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg::~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet::heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESGET;
}


heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet::~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::operator=(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::vDestroy()
{
   List.vDestroy(); 
}

heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus()
:List()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESSTATUS;
}


heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::~heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus::operator==(const heatctrl_mainfi_tclMsgAbstractSensorTemperaturesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg::heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESUPREG;
}


heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg::~heatctrl_mainfi_tclMsgAbstractSensorStatesUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg::heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESRELUPREG;
}


heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg::~heatctrl_mainfi_tclMsgAbstractSensorStatesRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgAbstractSensorStatesGet::heatctrl_mainfi_tclMsgAbstractSensorStatesGet()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorStatesGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESGET;
}


heatctrl_mainfi_tclMsgAbstractSensorStatesGet::~heatctrl_mainfi_tclMsgAbstractSensorStatesGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::heatctrl_mainfi_tclMsgAbstractSensorStatesStatus(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::operator=(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::vDestroy()
{
   List.vDestroy(); 
}

heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::heatctrl_mainfi_tclMsgAbstractSensorStatesStatus()
:List()
 {}

tS32 heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESSTATUS;
}


heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::~heatctrl_mainfi_tclMsgAbstractSensorStatesStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgAbstractSensorStatesStatus::operator==(const heatctrl_mainfi_tclMsgAbstractSensorStatesStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg::heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSUPREG;
}


heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg::~heatctrl_mainfi_tclMsgEmergencyFunctionsUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg::heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSRELUPREG;
}


heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg::~heatctrl_mainfi_tclMsgEmergencyFunctionsRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgEmergencyFunctionsGet::heatctrl_mainfi_tclMsgEmergencyFunctionsGet()
 {}

tS32 heatctrl_mainfi_tclMsgEmergencyFunctionsGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSGET;
}


heatctrl_mainfi_tclMsgEmergencyFunctionsGet::~heatctrl_mainfi_tclMsgEmergencyFunctionsGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::heatctrl_mainfi_tclMsgEmergencyFunctionsStatus(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   List = coRef.List;
}
heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::operator=(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& coRef)
{
   if (this == &coRef) return *this;
   List = coRef.List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::vDestroy()
{
   List.vDestroy(); 
}

heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::heatctrl_mainfi_tclMsgEmergencyFunctionsStatus()
:List()
 {}

tS32 heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSSTATUS;
}


heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::~heatctrl_mainfi_tclMsgEmergencyFunctionsStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> List);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << List);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgEmergencyFunctionsStatus::operator==(const heatctrl_mainfi_tclMsgEmergencyFunctionsStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (List == roRef.List);
   return bResult;
}

//=============================================================================

heatctrl_mainfi_tclMsgFANControlUpReg::heatctrl_mainfi_tclMsgFANControlUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgFANControlUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLUPREG;
}


heatctrl_mainfi_tclMsgFANControlUpReg::~heatctrl_mainfi_tclMsgFANControlUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgFANControlRelUpReg::heatctrl_mainfi_tclMsgFANControlRelUpReg()
 {}

tS32 heatctrl_mainfi_tclMsgFANControlRelUpReg::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLRELUPREG;
}


heatctrl_mainfi_tclMsgFANControlRelUpReg::~heatctrl_mainfi_tclMsgFANControlRelUpReg()
{}

//=============================================================================

heatctrl_mainfi_tclMsgFANControlGet::heatctrl_mainfi_tclMsgFANControlGet()
 {}

tS32 heatctrl_mainfi_tclMsgFANControlGet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLGET;
}


heatctrl_mainfi_tclMsgFANControlGet::~heatctrl_mainfi_tclMsgFANControlGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgFANControlSet::heatctrl_mainfi_tclMsgFANControlSet(const heatctrl_mainfi_tclMsgFANControlSet& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   FAN = coRef.FAN;
   FANCtrl = coRef.FANCtrl;
}
heatctrl_mainfi_tclMsgFANControlSet& heatctrl_mainfi_tclMsgFANControlSet::operator=(const heatctrl_mainfi_tclMsgFANControlSet& coRef)
{
   if (this == &coRef) return *this;
   FAN = coRef.FAN;
   FANCtrl = coRef.FANCtrl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_mainfi_tclMsgFANControlSet::heatctrl_mainfi_tclMsgFANControlSet()
:FAN()
,FANCtrl()
 {}

tS32 heatctrl_mainfi_tclMsgFANControlSet::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSET;
}


heatctrl_mainfi_tclMsgFANControlSet::~heatctrl_mainfi_tclMsgFANControlSet()
{}

tU32 heatctrl_mainfi_tclMsgFANControlSet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& heatctrl_mainfi_tclMsgFANControlSet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FAN);
   (tVoid) (oIn >> FANCtrl);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgFANControlSet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FAN);
   (tVoid) (oOut << FANCtrl);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgFANControlSet::operator==(const heatctrl_mainfi_tclMsgFANControlSet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FAN == roRef.FAN);
   bResult = bResult && (FANCtrl == roRef.FANCtrl);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
heatctrl_mainfi_tclMsgFANControlStatus::heatctrl_mainfi_tclMsgFANControlStatus(const heatctrl_mainfi_tclMsgFANControlStatus& coRef)
   : heatctrl_mainfi_tclMsgBaseMessage(coRef)
{
   FAN = coRef.FAN;
   FANCtrl = coRef.FANCtrl;
}
heatctrl_mainfi_tclMsgFANControlStatus& heatctrl_mainfi_tclMsgFANControlStatus::operator=(const heatctrl_mainfi_tclMsgFANControlStatus& coRef)
{
   if (this == &coRef) return *this;
   FAN = coRef.FAN;
   FANCtrl = coRef.FANCtrl;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

heatctrl_mainfi_tclMsgFANControlStatus::heatctrl_mainfi_tclMsgFANControlStatus()
:FAN()
,FANCtrl()
 {}

tS32 heatctrl_mainfi_tclMsgFANControlStatus::s32GetTypeId() const
{
   return (tS32) heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSTATUS;
}


heatctrl_mainfi_tclMsgFANControlStatus::~heatctrl_mainfi_tclMsgFANControlStatus()
{}

tU32 heatctrl_mainfi_tclMsgFANControlStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& heatctrl_mainfi_tclMsgFANControlStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> FAN);
   (tVoid) (oIn >> FANCtrl);
   return oIn;
}

fi_tclOutContext& heatctrl_mainfi_tclMsgFANControlStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << FAN);
   (tVoid) (oOut << FANCtrl);
   return oOut;
}

tBool heatctrl_mainfi_tclMsgFANControlStatus::operator==(const heatctrl_mainfi_tclMsgFANControlStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (FAN == roRef.FAN);
   bResult = bResult && (FANCtrl == roRef.FANCtrl);
   return bResult;
}

