#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define HEATCTRL_FI_S_IMPORT_INTERFACE_HEATCTRL_MAINFI_STDVISITORS
#include "heatctrl_fi_if.h"

tBool heatctrl_mainfi_tclDescription::bInitMessage(heatctrl_mainfi_tclToken::tenType enMsgToken) {
   tBool bResult = TRUE;
   switch (enMsgToken) {
   case heatctrl_mainfi_tclToken::EN_LAST_TOKEN:
   case heatctrl_mainfi_tclToken::EN_LIST:
   case heatctrl_mainfi_tclToken::EN_END_OF_STRUCT:
   case heatctrl_mainfi_tclToken::EN_UNKNOWN:
      bResult=FALSE;   
      break;

   // include the expansions for the messages
   case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODSTART:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8,heatctrl_mainfi_tclSemanticDomain::EN_MSG_DEFAULTSETTINGSMODE)) && bResult;
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8,heatctrl_mainfi_tclSemanticDomain::EN_MSG_DEFAULTSETTINGSGROUP)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODRESULT:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8,heatctrl_mainfi_tclSemanticDomain::EN_MSG_DEFAULTSETTINGSSTATUS)) && bResult;
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8,heatctrl_mainfi_tclSemanticDomain::EN_MSG_DEFAULTSETTINGSGROUP)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURELIST,heatctrl_mainfi_tclSemanticDomain::EN_MSG_LIST)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORSTATELIST,heatctrl_mainfi_tclSemanticDomain::EN_MSG_LIST)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURELIST,heatctrl_mainfi_tclSemanticDomain::EN_MSG_LIST)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORSTATELIST,heatctrl_mainfi_tclSemanticDomain::EN_MSG_LIST)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTIONLIST,heatctrl_mainfi_tclSemanticDomain::EN_MSG_LIST)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSET:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_FANCTRLREQ,heatctrl_mainfi_tclSemanticDomain::EN_MSG_FANCTRL)) && bResult;
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_FANREQ,heatctrl_mainfi_tclSemanticDomain::EN_MSG_FAN)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSTATUS:
   {
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_FANCTRL,heatctrl_mainfi_tclSemanticDomain::EN_MSG_FANCTRL)) && bResult;
      bResult = oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_FAN,heatctrl_mainfi_tclSemanticDomain::EN_MSG_FAN)) && bResult;
   } break;
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESGET:
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESGET:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESGET:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESGET:
   case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSGET:
   case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLRELUPREG:
   case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLGET:
   case heatctrl_mainfi_tclToken::EN_BINCONTAINER:
   case heatctrl_mainfi_tclToken::EN_E8_SENSORID:
   case heatctrl_mainfi_tclToken::EN_E8_TEMPERATUREQUALITYTYPE:
   case heatctrl_mainfi_tclToken::EN_S16_SENSORTEMPERATURVALUE:
   case heatctrl_mainfi_tclToken::EN_E8_SENSORSTATE:
   case heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURE:
   case heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURELIST:
   case heatctrl_mainfi_tclToken::EN_SENSORSTATE:
   case heatctrl_mainfi_tclToken::EN_SENSORSTATELIST:
   case heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONID:
   case heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONSTATE:
   case heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTION:
   case heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTIONLIST:
   case heatctrl_mainfi_tclToken::EN_E8_FANPOWERSTATE:
   case heatctrl_mainfi_tclToken::EN_U8_FANSPEEDVALUE:
   case heatctrl_mainfi_tclToken::EN_U16_FANCURRENTVALUE:
   case heatctrl_mainfi_tclToken::EN_E8_FANCTRLMODE:
   case heatctrl_mainfi_tclToken::EN_E8_FANCTRLEVENT:
   case heatctrl_mainfi_tclToken::EN_FAN:
   case heatctrl_mainfi_tclToken::EN_FANREQ:
   case heatctrl_mainfi_tclToken::EN_FANCTRL:
   case heatctrl_mainfi_tclToken::EN_FANCTRLREQ:
   case heatctrl_mainfi_tclToken::EN_U8:   
   case heatctrl_mainfi_tclToken::EN_S8:   
   case heatctrl_mainfi_tclToken::EN_U16:   
   case heatctrl_mainfi_tclToken::EN_S16:   
   case heatctrl_mainfi_tclToken::EN_U24:   
   case heatctrl_mainfi_tclToken::EN_S24:   
   case heatctrl_mainfi_tclToken::EN_U32:   
   case heatctrl_mainfi_tclToken::EN_S32:   
   case heatctrl_mainfi_tclToken::EN_U64:   
   case heatctrl_mainfi_tclToken::EN_S64:   
   case heatctrl_mainfi_tclToken::EN_F32:   
   case heatctrl_mainfi_tclToken::EN_F64:   
   case heatctrl_mainfi_tclToken::EN_BOOL:   
   case heatctrl_mainfi_tclToken::EN_STRING:   
   case heatctrl_mainfi_tclToken::EN_MULTILANGUAGESTRING:   
   default:
      (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(enMsgToken,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
      bResult = TRUE;
   }	
   return bResult;
}

tBool heatctrl_mainfi_tclDescription::bDoIt(heatctrl_fi_tclVisitableTypeBase& oTypeBase)
{
   // --read or write?
   if (enType==EN_PARSING)
   {
     // --read first, then pass visitor
     (tVoid) ((*poInContext) >> oTypeBase);
     oTypeBase.vTakeVisitor(*poVisitor);
   }
   else
   {
     // --first pass visitor, then stream 
	 oTypeBase.vTakeVisitor(*poVisitor);
     (tVoid) ((*poOutContext) << oTypeBase);
   }
   return poVisitor->bIsValid();
}

tBool heatctrl_mainfi_tclDescription::bProcessMessage() {
   tBool bResult = TRUE;
   tBool bInsideBinContainerVersion = false;
   tU16 u16MajorVersion;
   if (enType == EN_GENERATING)
   {
      u16MajorVersion = poOutContext->u16GetMajorVersion();
   }
   else
   {
      u16MajorVersion = poInContext->u16GetMajorVersion();
   }
   if (u16MajorVersion > 0x8000)
   {
      return FALSE;
   }
   tU16 u16SavedMajorVersion = u16MajorVersion;
   poVisitor->vReleaseBreak();
   while ((oPath.u32Position>0) && 
      bResult &&
      !poVisitor->bBreak() )    {
      // get current context (name, type, list index of next element)
      heatctrl_mainfi_tclKnot oKnot = oPath.oGetIterator().oKnot();
      heatctrl_mainfi_tclSemanticDomain::tenType enSemanticDomain = oKnot.enSemanticDomain;
      heatctrl_mainfi_tclToken::tenType enToken = oKnot.enToken;
      tU32 u32Index = oKnot.u32Index;
      
      // lists need special handling
      if (enSemanticDomain == heatctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT) {
         (tVoid) oPath.bGoUp();
         // has list remaining elements?
         if (u32Index < oPath.oGetIterator().oKnot().u32Index) {
            // create next list element
            (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index+1));
            (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
         } else {
            // remove list, clean up
            (tVoid) oPath.bGoUp();
            (tVoid) oCallStack.bGoUp();
            continue;	
         }
      }
      // push current context on stack for visitor
      (tVoid) oCallStack.bGoDown(heatctrl_mainfi_tclKnot(enToken,enSemanticDomain,u32Index));
      poVisitor->oIterator=oCallStack.oGetIterator();
      
      // now, process element
      switch (enToken) {
      case heatctrl_mainfi_tclToken::EN_END_OF_STRUCT: 
      {
         // clean up after structures
         if (enSemanticDomain == heatctrl_mainfi_tclSemanticDomain::EN_BINCONTAINER)
         {
            u16MajorVersion = u16SavedMajorVersion;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
         (tVoid) oPath.bGoUp();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oCallStack.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_LIST: 
      {
         heatctrl_fi_tclList oList;
         // get list size
         if (!bDoIt(oList)) {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            heatctrl_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
            return FALSE;
         } else {
            // rearrange LIST and LIST_ELEMENT knots
            // pop "old" LIST knot
            (tVoid) oPath.bGoUp();
            // pop and backup LIST_ELEMENT knot
            heatctrl_mainfi_tclKnot saveKnot;
            (tVoid) oPath.bGoUp(saveKnot);
            // push LIST knot
            (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(enToken,enSemanticDomain,oList.u32ListSize));
            // push LIST_ELEMENT knot
            (tVoid) oPath.bGoDown(saveKnot);
         }
      } break;
      case heatctrl_mainfi_tclToken::EN_U8: 
      {
         heatctrl_fi_tclU8 oU8;
         if (!bDoIt(oU8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
         if (bInsideBinContainerVersion)
         {
            bInsideBinContainerVersion = false;
            u16SavedMajorVersion = u16MajorVersion;
            u16MajorVersion = oU8.u8Value;
            if (enType == EN_GENERATING)
            {
               (tVoid) poOutContext->u16SetMajorVersion(u16MajorVersion);
            }
            else
            {
               (tVoid) poInContext->u16SetMajorVersion(u16MajorVersion);
            }
         }
      } break;
      case heatctrl_mainfi_tclToken::EN_U16: 
      {
         heatctrl_fi_tclU16 oU16;
         if (!bDoIt(oU16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_U24: 
      {
         heatctrl_fi_tclU24 oU24;
         if (!bDoIt(oU24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_U32: 
      {
         heatctrl_fi_tclU32 oU32;
         if (!bDoIt(oU32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_U64: 
      {
         heatctrl_fi_tclU64 oU64;
         if (!bDoIt(oU64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S8: 
      {
         heatctrl_fi_tclS8 oS8;
         if (!bDoIt(oS8))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S16: 
      {
         heatctrl_fi_tclS16 oS16;
         if (!bDoIt(oS16))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S24: 
      {
         heatctrl_fi_tclS24 oS24;
         if (!bDoIt(oS24))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S32: 
      {
         heatctrl_fi_tclS32 oS32;
         if (!bDoIt(oS32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S64: 
      {
         heatctrl_fi_tclS64 oS64;
         if (!bDoIt(oS64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_F32: 
      {
         heatctrl_fi_tclF32 oF32;
         if (!bDoIt(oF32))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_F64: 
      {
         heatctrl_fi_tclF64 oF64;
         if (!bDoIt(oF64))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_BOOL: 
      {
         heatctrl_fi_tclBool oBool;
         if (!bDoIt(oBool))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_STRING: 
      {
         heatctrl_fi_tclString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_MULTILANGUAGESTRING: 
      {
         heatctrl_fi_tclMultiLanguageString oString;
         if (!bDoIt(oString)) {
            oString.vDestroy();
            return FALSE;
         }
         oString.vDestroy();
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      // include rest of type expansions/processing
      case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODSTART:
      case heatctrl_mainfi_tclToken::EN_MSG_FI_FC_HEATCTRL_DEFAULTMETHODRESULT:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESGET:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORTEMPERATURESSTATUS:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESGET:
      case heatctrl_mainfi_tclToken::EN_MSG_REALSENSORSTATESSTATUS:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESGET:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORTEMPERATURESSTATUS:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESGET:
      case heatctrl_mainfi_tclToken::EN_MSG_ABSTRACTSENSORSTATESSTATUS:
      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSGET:
      case heatctrl_mainfi_tclToken::EN_MSG_EMERGENCYFUNCTIONSSTATUS:
      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLRELUPREG:
      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLGET:
      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSET:
      case heatctrl_mainfi_tclToken::EN_MSG_FANCONTROLSTATUS:
         (tVoid) bInitMessage(enToken);
         break;
      case heatctrl_mainfi_tclToken::EN_BINCONTAINER:
      {
      if (poVisitor->bDoExpand_BinContainer(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8,heatctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_LIST,heatctrl_mainfi_tclSemanticDomain::EN_CONTAINERDATALIST));
      }
      else
      {
         heatctrl_fi_tcl_BinContainer o_BinContainer;
         if (!bDoIt(o_BinContainer))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_BinContainer.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_SENSORID:
      {
         heatctrl_fi_tcl_e8_SensorID o_e8_SensorID;
         if (!bDoIt(o_e8_SensorID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_TEMPERATUREQUALITYTYPE:
      {
         heatctrl_fi_tcl_e8_TemperatureQualityType o_e8_TemperatureQualityType;
         if (!bDoIt(o_e8_TemperatureQualityType))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_S16_SENSORTEMPERATURVALUE:
      {
         heatctrl_fi_tcl_s16_SensorTemperaturValue o_s16_SensorTemperaturValue;
         if (!bDoIt(o_s16_SensorTemperaturValue))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_SENSORSTATE:
      {
         heatctrl_fi_tcl_e8_SensorState o_e8_SensorState;
         if (!bDoIt(o_e8_SensorState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURE:
      {
      if (poVisitor->bDoExpand_SensorTemperature(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_S16_SENSORTEMPERATURVALUE,heatctrl_mainfi_tclSemanticDomain::EN_TEMPERATUREMAX));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_S16_SENSORTEMPERATURVALUE,heatctrl_mainfi_tclSemanticDomain::EN_TEMPERATUREMIN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_TEMPERATUREQUALITYTYPE,heatctrl_mainfi_tclSemanticDomain::EN_QUALITY));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_S16_SENSORTEMPERATURVALUE,heatctrl_mainfi_tclSemanticDomain::EN_TEMPERATURE));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_SENSORID,heatctrl_mainfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         heatctrl_fi_tcl_SensorTemperature o_SensorTemperature;
         if (!bDoIt(o_SensorTemperature))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorTemperature.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorTemperature.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURELIST:
      {
      if (poVisitor->bDoExpand_SensorTemperatureList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORTEMPERATURE,heatctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_LIST,heatctrl_mainfi_tclSemanticDomain::EN_SENSORTEMPERATURELIST));
      }
      else
      {
         heatctrl_fi_tcl_SensorTemperatureList o_SensorTemperatureList;
         if (!bDoIt(o_SensorTemperatureList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorTemperatureList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorTemperatureList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_SENSORSTATE:
      {
      if (poVisitor->bDoExpand_SensorState(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_SENSORSTATE,heatctrl_mainfi_tclSemanticDomain::EN_LASTVALIDSTATE));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_SENSORSTATE,heatctrl_mainfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_SENSORID,heatctrl_mainfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         heatctrl_fi_tcl_SensorState o_SensorState;
         if (!bDoIt(o_SensorState))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorState.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_SENSORSTATELIST:
      {
      if (poVisitor->bDoExpand_SensorStateList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_SENSORSTATE,heatctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_LIST,heatctrl_mainfi_tclSemanticDomain::EN_SENSORSTATELIST));
      }
      else
      {
         heatctrl_fi_tcl_SensorStateList o_SensorStateList;
         if (!bDoIt(o_SensorStateList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorStateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_SensorStateList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONID:
      {
         heatctrl_fi_tcl_e8_EmergncyFunctionID o_e8_EmergncyFunctionID;
         if (!bDoIt(o_e8_EmergncyFunctionID))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONSTATE:
      {
         heatctrl_fi_tcl_e8_EmergncyFunctionState o_e8_EmergncyFunctionState;
         if (!bDoIt(o_e8_EmergncyFunctionState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTION:
      {
      if (poVisitor->bDoExpand_EmergencyFunction(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONSTATE,heatctrl_mainfi_tclSemanticDomain::EN_STATE));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_EMERGNCYFUNCTIONID,heatctrl_mainfi_tclSemanticDomain::EN_ID));
      }
      else
      {
         heatctrl_fi_tcl_EmergencyFunction o_EmergencyFunction;
         if (!bDoIt(o_EmergencyFunction))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EmergencyFunction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EmergencyFunction.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTIONLIST:
      {
      if (poVisitor->bDoExpand_EmergencyFunctionList(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_EMERGENCYFUNCTION,heatctrl_mainfi_tclSemanticDomain::EN_LIST_ELEMENT,0));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_LIST,heatctrl_mainfi_tclSemanticDomain::EN_EMERGENCYFUNCTIONLIST));
      }
      else
      {
         heatctrl_fi_tcl_EmergencyFunctionList o_EmergencyFunctionList;
         if (!bDoIt(o_EmergencyFunctionList))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EmergencyFunctionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_EmergencyFunctionList.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_FANPOWERSTATE:
      {
         heatctrl_fi_tcl_e8_FANPowerState o_e8_FANPowerState;
         if (!bDoIt(o_e8_FANPowerState))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_U8_FANSPEEDVALUE:
      {
         heatctrl_fi_tcl_u8_FANSpeedValue o_u8_FANSpeedValue;
         if (!bDoIt(o_u8_FANSpeedValue))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_U16_FANCURRENTVALUE:
      {
         heatctrl_fi_tcl_u16_FANCurrentValue o_u16_FANCurrentValue;
         if (!bDoIt(o_u16_FANCurrentValue))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_FANCTRLMODE:
      {
         heatctrl_fi_tcl_e8_FANCtrlMode o_e8_FANCtrlMode;
         if (!bDoIt(o_e8_FANCtrlMode))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_E8_FANCTRLEVENT:
      {
         heatctrl_fi_tcl_e8_FANCtrlEvent o_e8_FANCtrlEvent;
         if (!bDoIt(o_e8_FANCtrlEvent))
            return FALSE;
         (tVoid) oCallStack.bGoUp();
         (tVoid) oPath.bGoUp();
      } break;
      case heatctrl_mainfi_tclToken::EN_FAN:
      {
      if (poVisitor->bDoExpand_FAN(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U16_FANCURRENTVALUE,heatctrl_mainfi_tclSemanticDomain::EN_CURRENT));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8_FANSPEEDVALUE,heatctrl_mainfi_tclSemanticDomain::EN_SPEED));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_FANPOWERSTATE,heatctrl_mainfi_tclSemanticDomain::EN_STATE));
      }
      else
      {
         heatctrl_fi_tcl_FAN o_FAN;
         if (!bDoIt(o_FAN))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FAN.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FAN.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_FANREQ:
      {
      if (poVisitor->bDoExpand_FANReq(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_U8_FANSPEEDVALUE,heatctrl_mainfi_tclSemanticDomain::EN_SPEED));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_FANPOWERSTATE,heatctrl_mainfi_tclSemanticDomain::EN_STATE));
      }
      else
      {
         heatctrl_fi_tcl_FANReq o_FANReq;
         if (!bDoIt(o_FANReq))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANReq.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANReq.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_FANCTRL:
      {
      if (poVisitor->bDoExpand_FANCtrl(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_FANCTRLMODE,heatctrl_mainfi_tclSemanticDomain::EN_MODE));
      }
      else
      {
         heatctrl_fi_tcl_FANCtrl o_FANCtrl;
         if (!bDoIt(o_FANCtrl))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANCtrl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANCtrl.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_FANCTRLREQ:
      {
      if (poVisitor->bDoExpand_FANCtrlReq(enSemanticDomain))
      {
         (tVoid) oPath.bGoUp();
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_END_OF_STRUCT,heatctrl_mainfi_tclSemanticDomain::EN_UNKNOWN));
         (tVoid) oPath.bGoDown(heatctrl_mainfi_tclKnot(heatctrl_mainfi_tclToken::EN_E8_FANCTRLEVENT,heatctrl_mainfi_tclSemanticDomain::EN_EVENT));
      }
      else
      {
         heatctrl_fi_tcl_FANCtrlReq o_FANCtrlReq;
         if (!bDoIt(o_FANCtrlReq))
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANCtrlReq.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            return FALSE;
         }
         else
         {
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
            o_FANCtrlReq.vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
            (tVoid) oCallStack.bGoUp();
            (tVoid) oPath.bGoUp();
         }
      }
      } break;
      case heatctrl_mainfi_tclToken::EN_UNKNOWN:
      case heatctrl_mainfi_tclToken::EN_LAST_TOKEN:         
      default:
         return FALSE;
      }
   }
   return bResult;
}

