#ifndef DIMMING_FIVISITOR_HEADER
#define DIMMING_FIVISITOR_HEADER

// --Basisklasse fuer eine FI-Besucher-Klasse

class dimming_fi_tclOutput {
public:
   dimming_fi_tclOutput();
   virtual ~dimming_fi_tclOutput(){};

   virtual tVoid vPrintLine(tCString coszLine) = 0;
};

class dimming_fi_tclFileOutput : public dimming_fi_tclOutput 
{
public:
   dimming_fi_tclFileOutput(OSAL_tIODescriptor rIOD):fd(rIOD) {}
   virtual tVoid vPrintLine(tCString coszLine);
protected:
   OSAL_tIODescriptor fd;
private:
   dimming_fi_tclFileOutput(); //lint !e1704
   dimming_fi_tclFileOutput& operator=(const dimming_fi_tclFileOutput& coRef);
   dimming_fi_tclFileOutput(const dimming_fi_tclFileOutput& coRef); //lint !e1704
};

class dimming_fi_tclMemOutput : public dimming_fi_tclOutput
{
public:
   dimming_fi_tclMemOutput(tU32 u32MemSize);
   virtual ~dimming_fi_tclMemOutput();
   virtual tVoid vPrintLine(tCString coszLine);
   tString szGetBuffer();
protected:
   tChar* szBuf;
   tChar* szEndBuf;
   tChar* s8BufPos;
private:
   dimming_fi_tclMemOutput(); //lint !e1704
   dimming_fi_tclMemOutput(const dimming_fi_tclMemOutput& coRef); //lint !e1704
   dimming_fi_tclMemOutput& operator=(const dimming_fi_tclMemOutput& coRef); //lint !e1704
};

class MY_DECL dimming_fi_tclVisitorBase {
public:

   // --Konstruktor
   dimming_fi_tclVisitorBase():bBreakNow(FALSE),bIsVisitorValid(FALSE) {}
   virtual ~dimming_fi_tclVisitorBase() {}

   tBool bIsValid() const { return bIsVisitorValid; }
   tVoid vInvalidate() { bIsVisitorValid=FALSE; }
   tVoid vValidate() { bIsVisitorValid=TRUE; }
   tBool bBreak() const { return bBreakNow; }
   tVoid vReleaseBreak() { bBreakNow = FALSE; }
   // --Besuche allgemeine Objekte	
   virtual tVoid vVisitU8(dimming_fi_tclU8& oU8);
   virtual tVoid vVisitS8(dimming_fi_tclS8& oS8);
   virtual tVoid vVisitU16(dimming_fi_tclU16& oU16);
   virtual tVoid vVisitS16(dimming_fi_tclS16& oS16);
   virtual tVoid vVisitU24(dimming_fi_tclU24& oU24);
   virtual tVoid vVisitS24(dimming_fi_tclS24& oS24);
   virtual tVoid vVisitU32(dimming_fi_tclU32& oU32);
   virtual tVoid vVisitS32(dimming_fi_tclS32& oS32);
   virtual tVoid vVisitU64(dimming_fi_tclU64& oU64);
   virtual tVoid vVisitS64(dimming_fi_tclS64& oS64);
   virtual tVoid vVisitF32(dimming_fi_tclF32& oF32);
   virtual tVoid vVisitF64(dimming_fi_tclF64& oF64);
   virtual tVoid vVisitBool(dimming_fi_tclBool& oBool);
   virtual tVoid vVisitString(dimming_fi_tclString& oString);
   virtual tVoid vVisitMultiLanguageString(dimming_fi_tclMultiLanguageString& oString);

   virtual tVoid vVisitList(dimming_fi_tclList& oList);
   virtual tVoid vVisit_BinContainer(dimming_fi_tcl_BinContainer& oBinContainer);

   virtual tVoid vVisit_Reserved(dimming_fi_tcl_Reserved& oReserved);

   virtual tVoid vVisit_u8_Percent(dimming_fi_tcl_u8_Percent& ou8_Percent);

   virtual tVoid vVisit_s16_PerThousand(dimming_fi_tcl_s16_PerThousand& os16_PerThousand);

   virtual tVoid vVisit_u16_IndexInReferenceList(dimming_fi_tcl_u16_IndexInReferenceList& ou16_IndexInReferenceList);

   virtual tVoid vVisit_u16_ErrorCode(dimming_fi_tcl_u16_ErrorCode& ou16_ErrorCode);

   virtual tVoid vVisit_u16_RPM(dimming_fi_tcl_u16_RPM& ou16_RPM);

   virtual tVoid vVisit_s32_Kilogram(dimming_fi_tcl_s32_Kilogram& os32_Kilogram);

   virtual tVoid vVisit_s32_Pound(dimming_fi_tcl_s32_Pound& os32_Pound);

   virtual tVoid vVisit_s16_Meter(dimming_fi_tcl_s16_Meter& os16_Meter);

   virtual tVoid vVisit_s32_Meter(dimming_fi_tcl_s32_Meter& os32_Meter);

   virtual tVoid vVisit_s32_Yards(dimming_fi_tcl_s32_Yards& os32_Yards);

   virtual tVoid vVisit_s32_Foot(dimming_fi_tcl_s32_Foot& os32_Foot);

   virtual tVoid vVisit_s32_Centimeter(dimming_fi_tcl_s32_Centimeter& os32_Centimeter);

   virtual tVoid vVisit_s32_Inch(dimming_fi_tcl_s32_Inch& os32_Inch);

   virtual tVoid vVisit_s32_Millimeter(dimming_fi_tcl_s32_Millimeter& os32_Millimeter);

   virtual tVoid vVisit_s32_Microliter(dimming_fi_tcl_s32_Microliter& os32_Microliter);

   virtual tVoid vVisit_s32_Second(dimming_fi_tcl_s32_Second& os32_Second);

   virtual tVoid vVisit_u16_MilliSecond(dimming_fi_tcl_u16_MilliSecond& ou16_MilliSecond);

   virtual tVoid vVisit_s32_MilliSecond(dimming_fi_tcl_s32_MilliSecond& os32_MilliSecond);

   virtual tVoid vVisit_POSIXTime(dimming_fi_tcl_POSIXTime& oPOSIXTime);

   virtual tVoid vVisit_e8_DST_State(dimming_fi_tcl_e8_DST_State& oe8_DST_State);

   virtual tVoid vVisit_TimeZoneElement(dimming_fi_tcl_TimeZoneElement& oTimeZoneElement);

   virtual tVoid vVisit_s16_KmPerHour(dimming_fi_tcl_s16_KmPerHour& os16_KmPerHour);

   virtual tVoid vVisit_s16_MilesPerHour(dimming_fi_tcl_s16_MilesPerHour& os16_MilesPerHour);

   virtual tVoid vVisit_s16_Knot(dimming_fi_tcl_s16_Knot& os16_Knot);

   virtual tVoid vVisit_s16_CentimeterSecond(dimming_fi_tcl_s16_CentimeterSecond& os16_CentimeterSecond);

   virtual tVoid vVisit_s16_Kelvin(dimming_fi_tcl_s16_Kelvin& os16_Kelvin);

   virtual tVoid vVisit_s16_Fahrenheit(dimming_fi_tcl_s16_Fahrenheit& os16_Fahrenheit);

   virtual tVoid vVisit_s32_Pascal(dimming_fi_tcl_s32_Pascal& os32_Pascal);

   virtual tVoid vVisit_s32_Watt(dimming_fi_tcl_s32_Watt& os32_Watt);

   virtual tVoid vVisit_FIVersion(dimming_fi_tcl_FIVersion& oFIVersion);

   virtual tVoid vVisit_s32_Longitude(dimming_fi_tcl_s32_Longitude& os32_Longitude);

   virtual tVoid vVisit_s32_Latitude(dimming_fi_tcl_s32_Latitude& os32_Latitude);

   virtual tVoid vVisit_PositionWGS84(dimming_fi_tcl_PositionWGS84& oPositionWGS84);

   virtual tVoid vVisit_RectangleWGS84(dimming_fi_tcl_RectangleWGS84& oRectangleWGS84);

   virtual tVoid vVisit_e16_ISOCountryCode(dimming_fi_tcl_e16_ISOCountryCode& oe16_ISOCountryCode);

   virtual tVoid vVisit_e16_ISOLanguageCode(dimming_fi_tcl_e16_ISOLanguageCode& oe16_ISOLanguageCode);

   virtual tVoid vVisit_LanguageID(dimming_fi_tcl_LanguageID& oLanguageID);

   virtual tVoid vVisit_u8_DirectionAbsolute(dimming_fi_tcl_u8_DirectionAbsolute& ou8_DirectionAbsolute);

   virtual tVoid vVisit_u8_DirectionRelative(dimming_fi_tcl_u8_DirectionRelative& ou8_DirectionRelative);

   virtual tVoid vVisit_s16_CentiDegree(dimming_fi_tcl_s16_CentiDegree& os16_CentiDegree);

   virtual tVoid vVisit_s16_Degree(dimming_fi_tcl_s16_Degree& os16_Degree);

   virtual tVoid vVisit_u16_DirectionAbsolute_CentiDegree(dimming_fi_tcl_u16_DirectionAbsolute_CentiDegree& ou16_DirectionAbsolute_CentiDegree);

   virtual tVoid vVisit_s16_DirectionRelative_CentiDegree(dimming_fi_tcl_s16_DirectionRelative_CentiDegree& os16_DirectionRelative_CentiDegree);

   virtual tVoid vVisit_e8_FuelType(dimming_fi_tcl_e8_FuelType& oe8_FuelType);

   virtual tVoid vVisit_DistTimeFuel(dimming_fi_tcl_DistTimeFuel& oDistTimeFuel);

   virtual tVoid vVisit_u8_DIM_LUN(dimming_fi_tcl_u8_DIM_LUN& ou8_DIM_LUN);

   virtual tVoid vVisit_u16_DIM_Permille(dimming_fi_tcl_u16_DIM_Permille& ou16_DIM_Permille);

   virtual tVoid vVisit_e8_DIM_BrightnessLevel(dimming_fi_tcl_e8_DIM_BrightnessLevel& oe8_DIM_BrightnessLevel);

   virtual tVoid vVisit_u8_DIM_Halfclasses(dimming_fi_tcl_u8_DIM_Halfclasses& ou8_DIM_Halfclasses);

   virtual tVoid vVisit_e8_DIM_Variants(dimming_fi_tcl_e8_DIM_Variants& oe8_DIM_Variants);

   virtual tVoid vVisit_e8_DIM_DisplaySize(dimming_fi_tcl_e8_DIM_DisplaySize& oe8_DIM_DisplaySize);

   virtual tVoid vVisit_e8_DIM_Status(dimming_fi_tcl_e8_DIM_Status& oe8_DIM_Status);

   virtual tVoid vVisit_e8_DIM_Mode(dimming_fi_tcl_e8_DIM_Mode& oe8_DIM_Mode);

   virtual tVoid vVisit_e8_DIM_EmulationMode(dimming_fi_tcl_e8_DIM_EmulationMode& oe8_DIM_EmulationMode);

   virtual tVoid vVisit_s16_DIM_Temperature(dimming_fi_tcl_s16_DIM_Temperature& os16_DIM_Temperature);

   virtual tVoid vVisit_e8_DIM_WarningLevel(dimming_fi_tcl_e8_DIM_WarningLevel& oe8_DIM_WarningLevel);

   virtual tVoid vVisit_e8_DIM_InputConfiguration(dimming_fi_tcl_e8_DIM_InputConfiguration& oe8_DIM_InputConfiguration);

   virtual tVoid vVisit_SecondDispFunctionID(dimming_fi_tcl_SecondDispFunctionID& oSecondDispFunctionID);

   virtual tVoid vVisit_SecondDisp_VersionInfo(dimming_fi_tcl_SecondDisp_VersionInfo& oSecondDisp_VersionInfo);


 	fi_tclTraversePath<fi_tclKnot>::tclIterator oIterator;		
	
protected:
	tBool bBreakNow;
	tBool bIsVisitorValid;
private:

};

#endif
