/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define DIAGLOG_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "diaglog_fi_if.h"
// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u8Value);
  return oIn;
}

tU32 diaglog_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s8Value);
  return oIn;
}

tU32 diaglog_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u16Value);
  return oIn;
}

tU32 diaglog_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s16Value);
  return oIn;
}

tU32 diaglog_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u24Value);
  return oIn;
}

tU32 diaglog_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s24Value);
  return oIn;
}

tU32 diaglog_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u32Value);
  return oIn;
}

tU32 diaglog_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(u64Value);
  return oIn;
}

tU32 diaglog_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s32Value);
  return oIn;
}

tU32 diaglog_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(s64Value);
  return oIn;
}

tU32 diaglog_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f32Value);
  return oIn;
}

tU32 diaglog_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(f64Value);
  return oIn;
}

tU32 diaglog_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& diaglog_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(bValue);
  return oIn;
}

tU32 diaglog_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid diaglog_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tclString::~diaglog_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

diaglog_fi_tclString& diaglog_fi_tclString::operator=(const diaglog_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

diaglog_fi_tclString::diaglog_fi_tclString(const diaglog_fi_tclString& coRef):diaglog_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& diaglog_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool diaglog_fi_tclString::operator==(const diaglog_fi_tclString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 diaglog_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
diaglog_fi_tclString& diaglog_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
diaglog_fi_tclString::diaglog_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool diaglog_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

diaglog_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

diaglog_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool diaglog_fi_tclString::operator!=(intptr_t iNULL) const // ADDED
{
   return szValue != (char*)iNULL;
}

static tChar diaglog_FI_C_U8_NULLCHAR = '\0';

tChar* diaglog_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* diaglog_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* diaglog_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& diaglog_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}

tChar& diaglog_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}

tChar& diaglog_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool diaglog_fi_tclString::bSet(const diaglog_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool diaglog_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString diaglog_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   (tVoid) oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& diaglog_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  (tVoid) oIn.oRead(u32ListSize);
  return oIn;
}

tBool diaglog_fi_tclList::operator==(const diaglog_fi_tclList& roRef) const
{
   return roRef.u32ListSize == u32ListSize;
}

tU32 diaglog_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

// -----------------------------------------------------------------------------

fi_tclOutContext& diaglog_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  (tVoid) oOut.oWrite(szValue);
  return oOut;
}

tVoid diaglog_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tclMultiLanguageString::~diaglog_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

diaglog_fi_tclMultiLanguageString& diaglog_fi_tclMultiLanguageString::operator=(const diaglog_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

diaglog_fi_tclMultiLanguageString::diaglog_fi_tclMultiLanguageString(const diaglog_fi_tclMultiLanguageString& coRef):diaglog_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& diaglog_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  (tVoid) oIn.oRead(szValue);
  return oIn;
}

tBool diaglog_fi_tclMultiLanguageString::operator==(const diaglog_fi_tclMultiLanguageString& roRef) const
{
   if ((szValue == OSAL_NULL) || (roRef.szValue == OSAL_NULL))
   {
      if (szValue == roRef.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(roRef.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,roRef.szValue));
   }
}

tU32 diaglog_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
diaglog_fi_tclMultiLanguageString& diaglog_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
diaglog_fi_tclMultiLanguageString::diaglog_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool diaglog_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

diaglog_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

diaglog_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

tBool diaglog_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}

tChar* diaglog_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* diaglog_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* diaglog_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& diaglog_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}

tChar& diaglog_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}

tChar& diaglog_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return diaglog_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool diaglog_fi_tclMultiLanguageString::bSet(const diaglog_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool diaglog_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString diaglog_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_BinContainer::diaglog_fi_tcl_BinContainer(const diaglog_fi_tcl_BinContainer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
diaglog_fi_tcl_BinContainer& diaglog_fi_tcl_BinContainer::operator=(const diaglog_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_BinContainer::vDestroy()
{
   {
   ContainerDataList.clear();
   }
}

diaglog_fi_tcl_BinContainer::diaglog_fi_tcl_BinContainer()

 {}

tS32 diaglog_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_BINCONTAINER;
}


diaglog_fi_tcl_BinContainer::~diaglog_fi_tcl_BinContainer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ContainerDataList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_BinContainer::operator==(const diaglog_fi_tcl_BinContainer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == roRef.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == roRef.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

diaglog_fi_tcl_Reserved::diaglog_fi_tcl_Reserved()
 {}

tS32 diaglog_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_RESERVED;
}


diaglog_fi_tcl_Reserved::~diaglog_fi_tcl_Reserved()
{}

tU32 diaglog_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& diaglog_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u8_Percent::diaglog_fi_tcl_u8_Percent(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 diaglog_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U8_PERCENT;
}


diaglog_fi_tcl_u8_Percent::~diaglog_fi_tcl_u8_Percent()
{}

tU32 diaglog_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& diaglog_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_PerThousand::diaglog_fi_tcl_s16_PerThousand(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_PERTHOUSAND;
}


diaglog_fi_tcl_s16_PerThousand::~diaglog_fi_tcl_s16_PerThousand()
{}

tU32 diaglog_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u16_IndexInReferenceList::diaglog_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 diaglog_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}


diaglog_fi_tcl_u16_IndexInReferenceList::~diaglog_fi_tcl_u16_IndexInReferenceList()
{}

tU32 diaglog_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& diaglog_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u16_ErrorCode::diaglog_fi_tcl_u16_ErrorCode(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 diaglog_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U16_ERRORCODE;
}


diaglog_fi_tcl_u16_ErrorCode::~diaglog_fi_tcl_u16_ErrorCode()
{}

tU32 diaglog_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& diaglog_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u16_RPM::diaglog_fi_tcl_u16_RPM(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 diaglog_fi_tcl_u16_RPM::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U16_RPM;
}


diaglog_fi_tcl_u16_RPM::~diaglog_fi_tcl_u16_RPM()
{}

tU32 diaglog_fi_tcl_u16_RPM::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_u16_RPM::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& diaglog_fi_tcl_u16_RPM::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Kilogram::diaglog_fi_tcl_s32_Kilogram(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_KILOGRAM;
}


diaglog_fi_tcl_s32_Kilogram::~diaglog_fi_tcl_s32_Kilogram()
{}

tU32 diaglog_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Pound::diaglog_fi_tcl_s32_Pound(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_POUND;
}


diaglog_fi_tcl_s32_Pound::~diaglog_fi_tcl_s32_Pound()
{}

tU32 diaglog_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_Meter::diaglog_fi_tcl_s16_Meter(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_METER;
}


diaglog_fi_tcl_s16_Meter::~diaglog_fi_tcl_s16_Meter()
{}

tU32 diaglog_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Meter::diaglog_fi_tcl_s32_Meter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_METER;
}


diaglog_fi_tcl_s32_Meter::~diaglog_fi_tcl_s32_Meter()
{}

tU32 diaglog_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Yards::diaglog_fi_tcl_s32_Yards(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_YARDS;
}


diaglog_fi_tcl_s32_Yards::~diaglog_fi_tcl_s32_Yards()
{}

tU32 diaglog_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Foot::diaglog_fi_tcl_s32_Foot(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Foot::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_FOOT;
}


diaglog_fi_tcl_s32_Foot::~diaglog_fi_tcl_s32_Foot()
{}

tU32 diaglog_fi_tcl_s32_Foot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Foot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Foot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Centimeter::diaglog_fi_tcl_s32_Centimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_CENTIMETER;
}


diaglog_fi_tcl_s32_Centimeter::~diaglog_fi_tcl_s32_Centimeter()
{}

tU32 diaglog_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Inch::diaglog_fi_tcl_s32_Inch(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_INCH;
}


diaglog_fi_tcl_s32_Inch::~diaglog_fi_tcl_s32_Inch()
{}

tU32 diaglog_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Millimeter::diaglog_fi_tcl_s32_Millimeter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_MILLIMETER;
}


diaglog_fi_tcl_s32_Millimeter::~diaglog_fi_tcl_s32_Millimeter()
{}

tU32 diaglog_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Microliter::diaglog_fi_tcl_s32_Microliter(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_MICROLITER;
}


diaglog_fi_tcl_s32_Microliter::~diaglog_fi_tcl_s32_Microliter()
{}

tU32 diaglog_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Second::diaglog_fi_tcl_s32_Second(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_SECOND;
}


diaglog_fi_tcl_s32_Second::~diaglog_fi_tcl_s32_Second()
{}

tU32 diaglog_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u16_MilliSecond::diaglog_fi_tcl_u16_MilliSecond(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 diaglog_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U16_MILLISECOND;
}


diaglog_fi_tcl_u16_MilliSecond::~diaglog_fi_tcl_u16_MilliSecond()
{}

tU32 diaglog_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& diaglog_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_MilliSecond::diaglog_fi_tcl_s32_MilliSecond(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_MILLISECOND;
}


diaglog_fi_tcl_s32_MilliSecond::~diaglog_fi_tcl_s32_MilliSecond()
{}

tU32 diaglog_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_POSIXTime::diaglog_fi_tcl_POSIXTime(const diaglog_fi_tcl_POSIXTime& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
diaglog_fi_tcl_POSIXTime& diaglog_fi_tcl_POSIXTime::operator=(const diaglog_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_POSIXTime::diaglog_fi_tcl_POSIXTime()
:Time(0)
 {}

tS32 diaglog_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_POSIXTIME;
}


diaglog_fi_tcl_POSIXTime::~diaglog_fi_tcl_POSIXTime()
{}

tU32 diaglog_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool diaglog_fi_tcl_POSIXTime::operator==(const diaglog_fi_tcl_POSIXTime& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Time == roRef.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DST_State::diaglog_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

tS32 diaglog_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DST_STATE;
}


diaglog_fi_tcl_e8_DST_State::~diaglog_fi_tcl_e8_DST_State()
{}

tU32 diaglog_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_TimeZoneElement::diaglog_fi_tcl_TimeZoneElement(const diaglog_fi_tcl_TimeZoneElement& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
diaglog_fi_tcl_TimeZoneElement& diaglog_fi_tcl_TimeZoneElement::operator=(const diaglog_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   {
   DST_TimeDomain.clear();
   }
}

diaglog_fi_tcl_TimeZoneElement::diaglog_fi_tcl_TimeZoneElement()
:Abbreviation_StandardTime(0)
,Abbreviation_DST_in_effect(0)
,TimeZoneDifference()
,DST_State()
,DSTDifference()

 {}

tS32 diaglog_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_TIMEZONEELEMENT;
}


diaglog_fi_tcl_TimeZoneElement::~diaglog_fi_tcl_TimeZoneElement()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return 13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+ static_cast<tU32>(DST_TimeDomain.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_TimeZoneElement::operator==(const diaglog_fi_tcl_TimeZoneElement& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == roRef.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == roRef.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == roRef.TimeZoneDifference);
   bResult = bResult && (DST_State == roRef.DST_State);
   bResult = bResult && (DSTDifference == roRef.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == roRef.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == roRef.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_KmPerHour::diaglog_fi_tcl_s16_KmPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_KMPERHOUR;
}


diaglog_fi_tcl_s16_KmPerHour::~diaglog_fi_tcl_s16_KmPerHour()
{}

tU32 diaglog_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_MilesPerHour::diaglog_fi_tcl_s16_MilesPerHour(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_MILESPERHOUR;
}


diaglog_fi_tcl_s16_MilesPerHour::~diaglog_fi_tcl_s16_MilesPerHour()
{}

tU32 diaglog_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_Knot::diaglog_fi_tcl_s16_Knot(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_Knot::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_KNOT;
}


diaglog_fi_tcl_s16_Knot::~diaglog_fi_tcl_s16_Knot()
{}

tU32 diaglog_fi_tcl_s16_Knot::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_Knot::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_Knot::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_CentimeterSecond::diaglog_fi_tcl_s16_CentimeterSecond(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_CentimeterSecond::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_CENTIMETERSECOND;
}


diaglog_fi_tcl_s16_CentimeterSecond::~diaglog_fi_tcl_s16_CentimeterSecond()
{}

tU32 diaglog_fi_tcl_s16_CentimeterSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_CentimeterSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_CentimeterSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_Kelvin::diaglog_fi_tcl_s16_Kelvin(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_KELVIN;
}


diaglog_fi_tcl_s16_Kelvin::~diaglog_fi_tcl_s16_Kelvin()
{}

tU32 diaglog_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_Fahrenheit::diaglog_fi_tcl_s16_Fahrenheit(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_Fahrenheit::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_FAHRENHEIT;
}


diaglog_fi_tcl_s16_Fahrenheit::~diaglog_fi_tcl_s16_Fahrenheit()
{}

tU32 diaglog_fi_tcl_s16_Fahrenheit::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_Fahrenheit::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_Fahrenheit::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Pascal::diaglog_fi_tcl_s32_Pascal(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_PASCAL;
}


diaglog_fi_tcl_s32_Pascal::~diaglog_fi_tcl_s32_Pascal()
{}

tU32 diaglog_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Watt::diaglog_fi_tcl_s32_Watt(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Watt::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_WATT;
}


diaglog_fi_tcl_s32_Watt::~diaglog_fi_tcl_s32_Watt()
{}

tU32 diaglog_fi_tcl_s32_Watt::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Watt::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Watt::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_FIVersion::diaglog_fi_tcl_FIVersion(const diaglog_fi_tcl_FIVersion& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
diaglog_fi_tcl_FIVersion& diaglog_fi_tcl_FIVersion::operator=(const diaglog_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_FIVersion::diaglog_fi_tcl_FIVersion()
:MajorVersion(0)
,MinorVersion(0)
,PatchVersion(0)
 {}

tS32 diaglog_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_FIVERSION;
}


diaglog_fi_tcl_FIVersion::~diaglog_fi_tcl_FIVersion()
{}

tU32 diaglog_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& diaglog_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool diaglog_fi_tcl_FIVersion::operator==(const diaglog_fi_tcl_FIVersion& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == roRef.MajorVersion);
   bResult = bResult && (MinorVersion == roRef.MinorVersion);
   bResult = bResult && (PatchVersion == roRef.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Longitude::diaglog_fi_tcl_s32_Longitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_LONGITUDE;
}


diaglog_fi_tcl_s32_Longitude::~diaglog_fi_tcl_s32_Longitude()
{}

tU32 diaglog_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s32_Latitude::diaglog_fi_tcl_s32_Latitude(tS32 _s32Value)
: s32Value(_s32Value
) {} 

tS32 diaglog_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S32_LATITUDE;
}


diaglog_fi_tcl_s32_Latitude::~diaglog_fi_tcl_s32_Latitude()
{}

tU32 diaglog_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& diaglog_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_PositionWGS84::diaglog_fi_tcl_PositionWGS84(const diaglog_fi_tcl_PositionWGS84& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
diaglog_fi_tcl_PositionWGS84& diaglog_fi_tcl_PositionWGS84::operator=(const diaglog_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_PositionWGS84::diaglog_fi_tcl_PositionWGS84()
:Longitude()
,Latitude()
 {}

tS32 diaglog_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_POSITIONWGS84;
}


diaglog_fi_tcl_PositionWGS84::~diaglog_fi_tcl_PositionWGS84()
{}

tU32 diaglog_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& diaglog_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool diaglog_fi_tcl_PositionWGS84::operator==(const diaglog_fi_tcl_PositionWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == roRef.Longitude);
   bResult = bResult && (Latitude == roRef.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_RectangleWGS84::diaglog_fi_tcl_RectangleWGS84(const diaglog_fi_tcl_RectangleWGS84& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
diaglog_fi_tcl_RectangleWGS84& diaglog_fi_tcl_RectangleWGS84::operator=(const diaglog_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_RectangleWGS84::diaglog_fi_tcl_RectangleWGS84()
:LongitudeMin()
,LatitudeMin()
,LongitudeMax()
,LatitudeMax()
 {}

tS32 diaglog_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_RECTANGLEWGS84;
}


diaglog_fi_tcl_RectangleWGS84::~diaglog_fi_tcl_RectangleWGS84()
{}

tU32 diaglog_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& diaglog_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool diaglog_fi_tcl_RectangleWGS84::operator==(const diaglog_fi_tcl_RectangleWGS84& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == roRef.LongitudeMin);
   bResult = bResult && (LatitudeMin == roRef.LatitudeMin);
   bResult = bResult && (LongitudeMax == roRef.LongitudeMax);
   bResult = bResult && (LatitudeMax == roRef.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e16_ISOCountryCode::diaglog_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

tS32 diaglog_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}


diaglog_fi_tcl_e16_ISOCountryCode::~diaglog_fi_tcl_e16_ISOCountryCode()
{}

tU32 diaglog_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e16_ISOLanguageCode::diaglog_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

tS32 diaglog_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}


diaglog_fi_tcl_e16_ISOLanguageCode::~diaglog_fi_tcl_e16_ISOLanguageCode()
{}

tU32 diaglog_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_LanguageID::diaglog_fi_tcl_LanguageID(const diaglog_fi_tcl_LanguageID& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
diaglog_fi_tcl_LanguageID& diaglog_fi_tcl_LanguageID::operator=(const diaglog_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_LanguageID::diaglog_fi_tcl_LanguageID()
:ISO639_LanguageCode()
,ISO3166_CountryCode()
 {}

tS32 diaglog_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_LANGUAGEID;
}


diaglog_fi_tcl_LanguageID::~diaglog_fi_tcl_LanguageID()
{}

tU32 diaglog_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& diaglog_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool diaglog_fi_tcl_LanguageID::operator==(const diaglog_fi_tcl_LanguageID& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == roRef.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == roRef.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u8_DirectionAbsolute::diaglog_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 diaglog_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}


diaglog_fi_tcl_u8_DirectionAbsolute::~diaglog_fi_tcl_u8_DirectionAbsolute()
{}

tU32 diaglog_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& diaglog_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u8_DirectionRelative::diaglog_fi_tcl_u8_DirectionRelative(tU8 _u8Value)
: u8Value(_u8Value
) {} 

tS32 diaglog_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}


diaglog_fi_tcl_u8_DirectionRelative::~diaglog_fi_tcl_u8_DirectionRelative()
{}

tU32 diaglog_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& diaglog_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_CentiDegree::diaglog_fi_tcl_s16_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_CENTIDEGREE;
}


diaglog_fi_tcl_s16_CentiDegree::~diaglog_fi_tcl_s16_CentiDegree()
{}

tU32 diaglog_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_Degree::diaglog_fi_tcl_s16_Degree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_DEGREE;
}


diaglog_fi_tcl_s16_Degree::~diaglog_fi_tcl_s16_Degree()
{}

tU32 diaglog_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value)
: u16Value(_u16Value
) {} 

tS32 diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}


diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::~diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree()
{}

tU32 diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& diaglog_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::diaglog_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value)
: s16Value(_s16Value
) {} 

tS32 diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}


diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::~diaglog_fi_tcl_s16_DirectionRelative_CentiDegree()
{}

tU32 diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& diaglog_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_FuelType::diaglog_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

tS32 diaglog_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_FUELTYPE;
}


diaglog_fi_tcl_e8_FuelType::~diaglog_fi_tcl_e8_FuelType()
{}

tU32 diaglog_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_DistTimeFuel::diaglog_fi_tcl_DistTimeFuel(const diaglog_fi_tcl_DistTimeFuel& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
}
diaglog_fi_tcl_DistTimeFuel& diaglog_fi_tcl_DistTimeFuel::operator=(const diaglog_fi_tcl_DistTimeFuel& coRef)
{
   if (this == &coRef) return *this;
   Distance = coRef.Distance;
   Time = coRef.Time;
   Fuel = coRef.Fuel;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_DistTimeFuel::diaglog_fi_tcl_DistTimeFuel()
:Distance()
,Time()
,Fuel()
 {}

tS32 diaglog_fi_tcl_DistTimeFuel::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_DISTTIMEFUEL;
}


diaglog_fi_tcl_DistTimeFuel::~diaglog_fi_tcl_DistTimeFuel()
{}

tU32 diaglog_fi_tcl_DistTimeFuel::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 12;
}

fi_tclInContext& diaglog_fi_tcl_DistTimeFuel::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Distance);
   (tVoid) (oIn >> Time);
   (tVoid) (oIn >> Fuel);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_DistTimeFuel::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Distance);
   (tVoid) (oOut << Time);
   (tVoid) (oOut << Fuel);
   return oOut;
}

tBool diaglog_fi_tcl_DistTimeFuel::operator==(const diaglog_fi_tcl_DistTimeFuel& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Distance == roRef.Distance);
   bResult = bResult && (Time == roRef.Time);
   bResult = bResult && (Fuel == roRef.Fuel);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_MethodResultReply::diaglog_fi_tcl_e8_MethodResultReply():enType(FI_EN_ACCEPTED) {}

tS32 diaglog_fi_tcl_e8_MethodResultReply::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_METHODRESULTREPLY;
}


diaglog_fi_tcl_e8_MethodResultReply::~diaglog_fi_tcl_e8_MethodResultReply()
{}

tU32 diaglog_fi_tcl_e8_MethodResultReply::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_MethodResultReply::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_MethodResultReply::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_TestResult::diaglog_fi_tcl_e8_TestResult():enType(FI_EN_PASSED) {}

tS32 diaglog_fi_tcl_e8_TestResult::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_TESTRESULT;
}


diaglog_fi_tcl_e8_TestResult::~diaglog_fi_tcl_e8_TestResult()
{}

tU32 diaglog_fi_tcl_e8_TestResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_TestResult::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_FreezeFrameData::diaglog_fi_tcl_FreezeFrameData(const diaglog_fi_tcl_FreezeFrameData& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ID = coRef.ID;
   Data = coRef.Data;
}
diaglog_fi_tcl_FreezeFrameData& diaglog_fi_tcl_FreezeFrameData::operator=(const diaglog_fi_tcl_FreezeFrameData& coRef)
{
   if (this == &coRef) return *this;
   ID = coRef.ID;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_FreezeFrameData::vDestroy()
{
   {
   Data.clear();
   }
}

diaglog_fi_tcl_FreezeFrameData::diaglog_fi_tcl_FreezeFrameData()
:ID(0)

 {}

tS32 diaglog_fi_tcl_FreezeFrameData::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_FREEZEFRAMEDATA;
}


diaglog_fi_tcl_FreezeFrameData::~diaglog_fi_tcl_FreezeFrameData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_FreezeFrameData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(Data.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_FreezeFrameData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ID);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_FreezeFrameData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ID);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_FreezeFrameData::operator==(const diaglog_fi_tcl_FreezeFrameData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ID == roRef.ID);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_FreezeFrameList::diaglog_fi_tcl_FreezeFrameList(const diaglog_fi_tcl_FreezeFrameList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   FreezeFrameDataList = coRef.FreezeFrameDataList;
}
diaglog_fi_tcl_FreezeFrameList& diaglog_fi_tcl_FreezeFrameList::operator=(const diaglog_fi_tcl_FreezeFrameList& coRef)
{
   if (this == &coRef) return *this;
   FreezeFrameDataList = coRef.FreezeFrameDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_FreezeFrameList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
         FreezeFrameDataList[u32Idx].vDestroy();
   FreezeFrameDataList.clear();
   }
}

diaglog_fi_tcl_FreezeFrameList::diaglog_fi_tcl_FreezeFrameList()

 {}

tS32 diaglog_fi_tcl_FreezeFrameList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_FREEZEFRAMELIST;
}


diaglog_fi_tcl_FreezeFrameList::~diaglog_fi_tcl_FreezeFrameList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_FreezeFrameList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < FreezeFrameDataList.size(); ++u32ListIdx)
      u32DynamicSize += FreezeFrameDataList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& diaglog_fi_tcl_FreezeFrameList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
      {
         FreezeFrameDataList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      FreezeFrameDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> FreezeFrameDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_FreezeFrameList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)FreezeFrameDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < FreezeFrameDataList.size(); ++u32Idx)
         (tVoid) (oOut << FreezeFrameDataList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_FreezeFrameList::operator==(const diaglog_fi_tcl_FreezeFrameList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (FreezeFrameDataList.size() == roRef.FreezeFrameDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < FreezeFrameDataList.size()); ++u32Idx)
            bResult = bResult && (FreezeFrameDataList[u32Idx] == roRef.FreezeFrameDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ReadRequestBuffer::diaglog_fi_tcl_ReadRequestBuffer(const diaglog_fi_tcl_ReadRequestBuffer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ReadRequestBuffer = coRef.ReadRequestBuffer;
}
diaglog_fi_tcl_ReadRequestBuffer& diaglog_fi_tcl_ReadRequestBuffer::operator=(const diaglog_fi_tcl_ReadRequestBuffer& coRef)
{
   if (this == &coRef) return *this;
   ReadRequestBuffer = coRef.ReadRequestBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ReadRequestBuffer::vDestroy()
{
   {
   ReadRequestBuffer.clear();
   }
}

diaglog_fi_tcl_ReadRequestBuffer::diaglog_fi_tcl_ReadRequestBuffer()

 {}

tS32 diaglog_fi_tcl_ReadRequestBuffer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_READREQUESTBUFFER;
}


diaglog_fi_tcl_ReadRequestBuffer::~diaglog_fi_tcl_ReadRequestBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ReadRequestBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ReadRequestBuffer.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ReadRequestBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ReadRequestBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ReadRequestBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ReadRequestBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ReadRequestBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ReadRequestBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ReadRequestBuffer[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ReadRequestBuffer::operator==(const diaglog_fi_tcl_ReadRequestBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ReadRequestBuffer.size() == roRef.ReadRequestBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ReadRequestBuffer.size()); ++u32Idx)
            bResult = bResult && (ReadRequestBuffer[u32Idx] == roRef.ReadRequestBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ReadResultBuffer::diaglog_fi_tcl_ReadResultBuffer(const diaglog_fi_tcl_ReadResultBuffer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ReadResultBuffer = coRef.ReadResultBuffer;
}
diaglog_fi_tcl_ReadResultBuffer& diaglog_fi_tcl_ReadResultBuffer::operator=(const diaglog_fi_tcl_ReadResultBuffer& coRef)
{
   if (this == &coRef) return *this;
   ReadResultBuffer = coRef.ReadResultBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ReadResultBuffer::vDestroy()
{
   {
   ReadResultBuffer.clear();
   }
}

diaglog_fi_tcl_ReadResultBuffer::diaglog_fi_tcl_ReadResultBuffer()

 {}

tS32 diaglog_fi_tcl_ReadResultBuffer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_READRESULTBUFFER;
}


diaglog_fi_tcl_ReadResultBuffer::~diaglog_fi_tcl_ReadResultBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ReadResultBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ReadResultBuffer.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ReadResultBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ReadResultBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ReadResultBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ReadResultBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ReadResultBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ReadResultBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ReadResultBuffer[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ReadResultBuffer::operator==(const diaglog_fi_tcl_ReadResultBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ReadResultBuffer.size() == roRef.ReadResultBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ReadResultBuffer.size()); ++u32Idx)
            bResult = bResult && (ReadResultBuffer[u32Idx] == roRef.ReadResultBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ReadResultStructure::diaglog_fi_tcl_ReadResultStructure(const diaglog_fi_tcl_ReadResultStructure& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
}
diaglog_fi_tcl_ReadResultStructure& diaglog_fi_tcl_ReadResultStructure::operator=(const diaglog_fi_tcl_ReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_ReadResultStructure::diaglog_fi_tcl_ReadResultStructure()
:DTC(0)
,StatusOfDtc(0)
 {}

tS32 diaglog_fi_tcl_ReadResultStructure::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_READRESULTSTRUCTURE;
}


diaglog_fi_tcl_ReadResultStructure::~diaglog_fi_tcl_ReadResultStructure()
{}

tU32 diaglog_fi_tcl_ReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_fi_tcl_ReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   return oOut;
}

tBool diaglog_fi_tcl_ReadResultStructure::operator==(const diaglog_fi_tcl_ReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ReadResultList::diaglog_fi_tcl_ReadResultList(const diaglog_fi_tcl_ReadResultList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
diaglog_fi_tcl_ReadResultList& diaglog_fi_tcl_ReadResultList::operator=(const diaglog_fi_tcl_ReadResultList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         DTCList[u32Idx].vDestroy();
   DTCList.clear();
   }
}

diaglog_fi_tcl_ReadResultList::diaglog_fi_tcl_ReadResultList()

 {}

tS32 diaglog_fi_tcl_ReadResultList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_READRESULTLIST;
}


diaglog_fi_tcl_ReadResultList::~diaglog_fi_tcl_ReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*5);
}

fi_tclInContext& diaglog_fi_tcl_ReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
      {
         DTCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ReadResultList::operator==(const diaglog_fi_tcl_ReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ITC_Information::diaglog_fi_tcl_ITC_Information(const diaglog_fi_tcl_ITC_Information& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ITC = coRef.ITC;
   DTC = coRef.DTC;
   StatusOfItc = coRef.StatusOfItc;
   AgeingCounter = coRef.AgeingCounter;
   OccurenceCounter = coRef.OccurenceCounter;
}
diaglog_fi_tcl_ITC_Information& diaglog_fi_tcl_ITC_Information::operator=(const diaglog_fi_tcl_ITC_Information& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   DTC = coRef.DTC;
   StatusOfItc = coRef.StatusOfItc;
   AgeingCounter = coRef.AgeingCounter;
   OccurenceCounter = coRef.OccurenceCounter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_ITC_Information::diaglog_fi_tcl_ITC_Information()
:ITC(0)
,DTC(0)
,StatusOfItc(0)
,AgeingCounter(0)
,OccurenceCounter(0)
 {}

tS32 diaglog_fi_tcl_ITC_Information::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ITC_INFORMATION;
}


diaglog_fi_tcl_ITC_Information::~diaglog_fi_tcl_ITC_Information()
{}

tU32 diaglog_fi_tcl_ITC_Information::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& diaglog_fi_tcl_ITC_Information::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfItc);
   (tVoid) (oIn >> AgeingCounter);
   (tVoid) (oIn >> OccurenceCounter);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ITC_Information::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfItc);
   (tVoid) (oOut << AgeingCounter);
   (tVoid) (oOut << OccurenceCounter);
   return oOut;
}

tBool diaglog_fi_tcl_ITC_Information::operator==(const diaglog_fi_tcl_ITC_Information& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfItc == roRef.StatusOfItc);
   bResult = bResult && (AgeingCounter == roRef.AgeingCounter);
   bResult = bResult && (OccurenceCounter == roRef.OccurenceCounter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ProductionReadResultStructure::diaglog_fi_tcl_ProductionReadResultStructure(const diaglog_fi_tcl_ProductionReadResultStructure& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ITC = coRef.ITC;
   Status = coRef.Status;
}
diaglog_fi_tcl_ProductionReadResultStructure& diaglog_fi_tcl_ProductionReadResultStructure::operator=(const diaglog_fi_tcl_ProductionReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   ITC = coRef.ITC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_ProductionReadResultStructure::diaglog_fi_tcl_ProductionReadResultStructure()
:ITC(0)
,Status(0)
 {}

tS32 diaglog_fi_tcl_ProductionReadResultStructure::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_PRODUCTIONREADRESULTSTRUCTURE;
}


diaglog_fi_tcl_ProductionReadResultStructure::~diaglog_fi_tcl_ProductionReadResultStructure()
{}

tU32 diaglog_fi_tcl_ProductionReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& diaglog_fi_tcl_ProductionReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ITC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ProductionReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ITC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_fi_tcl_ProductionReadResultStructure::operator==(const diaglog_fi_tcl_ProductionReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ITC == roRef.ITC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ProductionReadResultList::diaglog_fi_tcl_ProductionReadResultList(const diaglog_fi_tcl_ProductionReadResultList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ITCList = coRef.ITCList;
}
diaglog_fi_tcl_ProductionReadResultList& diaglog_fi_tcl_ProductionReadResultList::operator=(const diaglog_fi_tcl_ProductionReadResultList& coRef)
{
   if (this == &coRef) return *this;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ProductionReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         ITCList[u32Idx].vDestroy();
   ITCList.clear();
   }
}

diaglog_fi_tcl_ProductionReadResultList::diaglog_fi_tcl_ProductionReadResultList()

 {}

tS32 diaglog_fi_tcl_ProductionReadResultList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_PRODUCTIONREADRESULTLIST;
}


diaglog_fi_tcl_ProductionReadResultList::~diaglog_fi_tcl_ProductionReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ProductionReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ITCList.size()*3);
}

fi_tclInContext& diaglog_fi_tcl_ProductionReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
      {
         ITCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ProductionReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ProductionReadResultList::operator==(const diaglog_fi_tcl_ProductionReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CustomerReadResultStructure::diaglog_fi_tcl_CustomerReadResultStructure(const diaglog_fi_tcl_CustomerReadResultStructure& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   Status = coRef.Status;
}
diaglog_fi_tcl_CustomerReadResultStructure& diaglog_fi_tcl_CustomerReadResultStructure::operator=(const diaglog_fi_tcl_CustomerReadResultStructure& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_CustomerReadResultStructure::diaglog_fi_tcl_CustomerReadResultStructure()
:DTC(0)
,Status(0)
 {}

tS32 diaglog_fi_tcl_CustomerReadResultStructure::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CUSTOMERREADRESULTSTRUCTURE;
}


diaglog_fi_tcl_CustomerReadResultStructure::~diaglog_fi_tcl_CustomerReadResultStructure()
{}

tU32 diaglog_fi_tcl_CustomerReadResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_fi_tcl_CustomerReadResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CustomerReadResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_fi_tcl_CustomerReadResultStructure::operator==(const diaglog_fi_tcl_CustomerReadResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CustomerReadResultList::diaglog_fi_tcl_CustomerReadResultList(const diaglog_fi_tcl_CustomerReadResultList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
diaglog_fi_tcl_CustomerReadResultList& diaglog_fi_tcl_CustomerReadResultList::operator=(const diaglog_fi_tcl_CustomerReadResultList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_CustomerReadResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         DTCList[u32Idx].vDestroy();
   DTCList.clear();
   }
}

diaglog_fi_tcl_CustomerReadResultList::diaglog_fi_tcl_CustomerReadResultList()

 {}

tS32 diaglog_fi_tcl_CustomerReadResultList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CUSTOMERREADRESULTLIST;
}


diaglog_fi_tcl_CustomerReadResultList::~diaglog_fi_tcl_CustomerReadResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_CustomerReadResultList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*5);
}

fi_tclInContext& diaglog_fi_tcl_CustomerReadResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
      {
         DTCList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CustomerReadResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_CustomerReadResultList::operator==(const diaglog_fi_tcl_CustomerReadResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_Protocol::diaglog_fi_tcl_e8_Protocol():enType(FI_EN_UDS) {}

tS32 diaglog_fi_tcl_e8_Protocol::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_PROTOCOL;
}


diaglog_fi_tcl_e8_Protocol::~diaglog_fi_tcl_e8_Protocol()
{}

tU32 diaglog_fi_tcl_e8_Protocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_Protocol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_Protocol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_TestResult::diaglog_fi_tcl_TestResult(const diaglog_fi_tcl_TestResult& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
   FreezeFrameList = coRef.FreezeFrameList;
}
diaglog_fi_tcl_TestResult& diaglog_fi_tcl_TestResult::operator=(const diaglog_fi_tcl_TestResult& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   Result = coRef.Result;
   FreezeFrameList = coRef.FreezeFrameList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_TestResult::vDestroy()
{
   FreezeFrameList.vDestroy(); 
}

diaglog_fi_tcl_TestResult::diaglog_fi_tcl_TestResult()
:TroubleCode(0)
,Result()
,FreezeFrameList()
 {}

tS32 diaglog_fi_tcl_TestResult::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_TESTRESULT;
}


diaglog_fi_tcl_TestResult::~diaglog_fi_tcl_TestResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_TestResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 5+FreezeFrameList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_fi_tcl_TestResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> Result);
   (tVoid) (oIn >> FreezeFrameList);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_TestResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << Result);
   (tVoid) (oOut << FreezeFrameList);
   return oOut;
}

tBool diaglog_fi_tcl_TestResult::operator==(const diaglog_fi_tcl_TestResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (Result == roRef.Result);
   bResult = bResult && (FreezeFrameList == roRef.FreezeFrameList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_TestResultList::diaglog_fi_tcl_TestResultList(const diaglog_fi_tcl_TestResultList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   TestResultList = coRef.TestResultList;
}
diaglog_fi_tcl_TestResultList& diaglog_fi_tcl_TestResultList::operator=(const diaglog_fi_tcl_TestResultList& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_TestResultList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         TestResultList[u32Idx].vDestroy();
   TestResultList.clear();
   }
}

diaglog_fi_tcl_TestResultList::diaglog_fi_tcl_TestResultList()

 {}

tS32 diaglog_fi_tcl_TestResultList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_TESTRESULTLIST;
}


diaglog_fi_tcl_TestResultList::~diaglog_fi_tcl_TestResultList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_TestResultList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < TestResultList.size(); ++u32ListIdx)
      u32DynamicSize += TestResultList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& diaglog_fi_tcl_TestResultList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
      {
         TestResultList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TestResultList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TestResultList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_TestResultList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TestResultList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TestResultList.size(); ++u32Idx)
         (tVoid) (oOut << TestResultList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_TestResultList::operator==(const diaglog_fi_tcl_TestResultList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TestResultList.size() == roRef.TestResultList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TestResultList.size()); ++u32Idx)
            bResult = bResult && (TestResultList[u32Idx] == roRef.TestResultList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_SnapshotData::diaglog_fi_tcl_SnapshotData(const diaglog_fi_tcl_SnapshotData& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   RecordNumber = coRef.RecordNumber;
   NumberOfData = coRef.NumberOfData;
   Data = coRef.Data;
}
diaglog_fi_tcl_SnapshotData& diaglog_fi_tcl_SnapshotData::operator=(const diaglog_fi_tcl_SnapshotData& coRef)
{
   if (this == &coRef) return *this;
   RecordNumber = coRef.RecordNumber;
   NumberOfData = coRef.NumberOfData;
   Data = coRef.Data;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_SnapshotData::vDestroy()
{
   {
   Data.clear();
   }
}

diaglog_fi_tcl_SnapshotData::diaglog_fi_tcl_SnapshotData()
:RecordNumber(0)
,NumberOfData(0)

 {}

tS32 diaglog_fi_tcl_SnapshotData::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_SNAPSHOTDATA;
}


diaglog_fi_tcl_SnapshotData::~diaglog_fi_tcl_SnapshotData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_SnapshotData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(Data.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_SnapshotData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> RecordNumber);
   (tVoid) (oIn >> NumberOfData);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Data.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Data[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_SnapshotData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << RecordNumber);
   (tVoid) (oOut << NumberOfData);
   (tVoid) (oOut << (tU32)Data.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Data.size(); ++u32Idx)
         (tVoid) (oOut << Data[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_SnapshotData::operator==(const diaglog_fi_tcl_SnapshotData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (RecordNumber == roRef.RecordNumber);
   bResult = bResult && (NumberOfData == roRef.NumberOfData);
      bResult = bResult && (Data.size() == roRef.Data.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Data.size()); ++u32Idx)
            bResult = bResult && (Data[u32Idx] == roRef.Data[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_SnapshotDataList::diaglog_fi_tcl_SnapshotDataList(const diaglog_fi_tcl_SnapshotDataList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   SnapshotData = coRef.SnapshotData;
}
diaglog_fi_tcl_SnapshotDataList& diaglog_fi_tcl_SnapshotDataList::operator=(const diaglog_fi_tcl_SnapshotDataList& coRef)
{
   if (this == &coRef) return *this;
   SnapshotData = coRef.SnapshotData;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_SnapshotDataList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
         SnapshotData[u32Idx].vDestroy();
   SnapshotData.clear();
   }
}

diaglog_fi_tcl_SnapshotDataList::diaglog_fi_tcl_SnapshotDataList()

 {}

tS32 diaglog_fi_tcl_SnapshotDataList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_SNAPSHOTDATALIST;
}


diaglog_fi_tcl_SnapshotDataList::~diaglog_fi_tcl_SnapshotDataList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_SnapshotDataList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < SnapshotData.size(); ++u32ListIdx)
      u32DynamicSize += SnapshotData[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& diaglog_fi_tcl_SnapshotDataList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
      {
         SnapshotData[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SnapshotData.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SnapshotData[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_SnapshotDataList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SnapshotData.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotData.size(); ++u32Idx)
         (tVoid) (oOut << SnapshotData[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_SnapshotDataList::operator==(const diaglog_fi_tcl_SnapshotDataList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SnapshotData.size() == roRef.SnapshotData.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SnapshotData.size()); ++u32Idx)
            bResult = bResult && (SnapshotData[u32Idx] == roRef.SnapshotData[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_SnapshotIdentification::diaglog_fi_tcl_SnapshotIdentification(const diaglog_fi_tcl_SnapshotIdentification& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTC = coRef.DTC;
   RecordNumber = coRef.RecordNumber;
}
diaglog_fi_tcl_SnapshotIdentification& diaglog_fi_tcl_SnapshotIdentification::operator=(const diaglog_fi_tcl_SnapshotIdentification& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   RecordNumber = coRef.RecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_SnapshotIdentification::diaglog_fi_tcl_SnapshotIdentification()
:DTC(0)
,RecordNumber(0)
 {}

tS32 diaglog_fi_tcl_SnapshotIdentification::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_SNAPSHOTIDENTIFICATION;
}


diaglog_fi_tcl_SnapshotIdentification::~diaglog_fi_tcl_SnapshotIdentification()
{}

tU32 diaglog_fi_tcl_SnapshotIdentification::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_fi_tcl_SnapshotIdentification::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> RecordNumber);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_SnapshotIdentification::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << RecordNumber);
   return oOut;
}

tBool diaglog_fi_tcl_SnapshotIdentification::operator==(const diaglog_fi_tcl_SnapshotIdentification& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (RecordNumber == roRef.RecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_SnapshotIdentificationList::diaglog_fi_tcl_SnapshotIdentificationList(const diaglog_fi_tcl_SnapshotIdentificationList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   SnapshotIdentification = coRef.SnapshotIdentification;
}
diaglog_fi_tcl_SnapshotIdentificationList& diaglog_fi_tcl_SnapshotIdentificationList::operator=(const diaglog_fi_tcl_SnapshotIdentificationList& coRef)
{
   if (this == &coRef) return *this;
   SnapshotIdentification = coRef.SnapshotIdentification;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_SnapshotIdentificationList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
         SnapshotIdentification[u32Idx].vDestroy();
   SnapshotIdentification.clear();
   }
}

diaglog_fi_tcl_SnapshotIdentificationList::diaglog_fi_tcl_SnapshotIdentificationList()

 {}

tS32 diaglog_fi_tcl_SnapshotIdentificationList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_SNAPSHOTIDENTIFICATIONLIST;
}


diaglog_fi_tcl_SnapshotIdentificationList::~diaglog_fi_tcl_SnapshotIdentificationList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_SnapshotIdentificationList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(SnapshotIdentification.size()*5);
}

fi_tclInContext& diaglog_fi_tcl_SnapshotIdentificationList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
      {
         SnapshotIdentification[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      SnapshotIdentification.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> SnapshotIdentification[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_SnapshotIdentificationList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)SnapshotIdentification.size());
   {
      for (tU32 u32Idx = 0; u32Idx < SnapshotIdentification.size(); ++u32Idx)
         (tVoid) (oOut << SnapshotIdentification[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_SnapshotIdentificationList::operator==(const diaglog_fi_tcl_SnapshotIdentificationList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (SnapshotIdentification.size() == roRef.SnapshotIdentification.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < SnapshotIdentification.size()); ++u32Idx)
            bResult = bResult && (SnapshotIdentification[u32Idx] == roRef.SnapshotIdentification[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ClearRequestBuffer::diaglog_fi_tcl_ClearRequestBuffer(const diaglog_fi_tcl_ClearRequestBuffer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ClearRequestBuffer = coRef.ClearRequestBuffer;
}
diaglog_fi_tcl_ClearRequestBuffer& diaglog_fi_tcl_ClearRequestBuffer::operator=(const diaglog_fi_tcl_ClearRequestBuffer& coRef)
{
   if (this == &coRef) return *this;
   ClearRequestBuffer = coRef.ClearRequestBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ClearRequestBuffer::vDestroy()
{
   {
   ClearRequestBuffer.clear();
   }
}

diaglog_fi_tcl_ClearRequestBuffer::diaglog_fi_tcl_ClearRequestBuffer()

 {}

tS32 diaglog_fi_tcl_ClearRequestBuffer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CLEARREQUESTBUFFER;
}


diaglog_fi_tcl_ClearRequestBuffer::~diaglog_fi_tcl_ClearRequestBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ClearRequestBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ClearRequestBuffer.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ClearRequestBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ClearRequestBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClearRequestBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ClearRequestBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClearRequestBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClearRequestBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ClearRequestBuffer[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ClearRequestBuffer::operator==(const diaglog_fi_tcl_ClearRequestBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClearRequestBuffer.size() == roRef.ClearRequestBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClearRequestBuffer.size()); ++u32Idx)
            bResult = bResult && (ClearRequestBuffer[u32Idx] == roRef.ClearRequestBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ClearResultBuffer::diaglog_fi_tcl_ClearResultBuffer(const diaglog_fi_tcl_ClearResultBuffer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ClearResultBuffer = coRef.ClearResultBuffer;
}
diaglog_fi_tcl_ClearResultBuffer& diaglog_fi_tcl_ClearResultBuffer::operator=(const diaglog_fi_tcl_ClearResultBuffer& coRef)
{
   if (this == &coRef) return *this;
   ClearResultBuffer = coRef.ClearResultBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ClearResultBuffer::vDestroy()
{
   {
   ClearResultBuffer.clear();
   }
}

diaglog_fi_tcl_ClearResultBuffer::diaglog_fi_tcl_ClearResultBuffer()

 {}

tS32 diaglog_fi_tcl_ClearResultBuffer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CLEARRESULTBUFFER;
}


diaglog_fi_tcl_ClearResultBuffer::~diaglog_fi_tcl_ClearResultBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ClearResultBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ClearResultBuffer.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ClearResultBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ClearResultBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ClearResultBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ClearResultBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ClearResultBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ClearResultBuffer.size(); ++u32Idx)
         (tVoid) (oOut << ClearResultBuffer[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ClearResultBuffer::operator==(const diaglog_fi_tcl_ClearResultBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ClearResultBuffer.size() == roRef.ClearResultBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ClearResultBuffer.size()); ++u32Idx)
            bResult = bResult && (ClearResultBuffer[u32Idx] == roRef.ClearResultBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_ControlParameter::diaglog_fi_tcl_e8_ControlParameter():enType(FI_EN_DISABLELOGGING) {}

tS32 diaglog_fi_tcl_e8_ControlParameter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_CONTROLPARAMETER;
}


diaglog_fi_tcl_e8_ControlParameter::~diaglog_fi_tcl_e8_ControlParameter()
{}

tU32 diaglog_fi_tcl_e8_ControlParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_ControlParameter::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_ControlParameter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ControlList::diaglog_fi_tcl_ControlList(const diaglog_fi_tcl_ControlList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
diaglog_fi_tcl_ControlList& diaglog_fi_tcl_ControlList::operator=(const diaglog_fi_tcl_ControlList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ControlList::vDestroy()
{
   {
   DTCList.clear();
   }
}

diaglog_fi_tcl_ControlList::diaglog_fi_tcl_ControlList()

 {}

tS32 diaglog_fi_tcl_ControlList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CONTROLLIST;
}


diaglog_fi_tcl_ControlList::~diaglog_fi_tcl_ControlList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ControlList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*4);
}

fi_tclInContext& diaglog_fi_tcl_ControlList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ControlList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ControlList::operator==(const diaglog_fi_tcl_ControlList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_ReadValue::diaglog_fi_tcl_e8_ReadValue():enType(FI_EN_DTCSSETBYDIAGNOSTICTEST) {}

tS32 diaglog_fi_tcl_e8_ReadValue::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_READVALUE;
}


diaglog_fi_tcl_e8_ReadValue::~diaglog_fi_tcl_e8_ReadValue()
{}

tU32 diaglog_fi_tcl_e8_ReadValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_ReadValue::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_ReadValue::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_VDLMediaType::diaglog_fi_tcl_e8_VDLMediaType():enType(FI_EN_FFS) {}

tS32 diaglog_fi_tcl_e8_VDLMediaType::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_VDLMEDIATYPE;
}


diaglog_fi_tcl_e8_VDLMediaType::~diaglog_fi_tcl_e8_VDLMediaType()
{}

tU32 diaglog_fi_tcl_e8_VDLMediaType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_VDLMediaType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_VDLMediaType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DiaglogDefsetType::diaglog_fi_tcl_e8_DiaglogDefsetType():enType(FI_EN_CLEAR_ERRMEM) {}

tS32 diaglog_fi_tcl_e8_DiaglogDefsetType::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DIAGLOGDEFSETTYPE;
}


diaglog_fi_tcl_e8_DiaglogDefsetType::~diaglog_fi_tcl_e8_DiaglogDefsetType()
{}

tU32 diaglog_fi_tcl_e8_DiaglogDefsetType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DiaglogDefsetType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DiaglogDefsetType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_SendNextTestResReason::diaglog_fi_tcl_e8_SendNextTestResReason():enType(FI_EN_CLEAR_CODE) {}

tS32 diaglog_fi_tcl_e8_SendNextTestResReason::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_SENDNEXTTESTRESREASON;
}


diaglog_fi_tcl_e8_SendNextTestResReason::~diaglog_fi_tcl_e8_SendNextTestResReason()
{}

tU32 diaglog_fi_tcl_e8_SendNextTestResReason::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_SendNextTestResReason::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_SendNextTestResReason::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_SendNextTestResultStructure::diaglog_fi_tcl_SendNextTestResultStructure(const diaglog_fi_tcl_SendNextTestResultStructure& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Status = coRef.Status;
   SendNextTestResReason = coRef.SendNextTestResReason;
   ITCList = coRef.ITCList;
}
diaglog_fi_tcl_SendNextTestResultStructure& diaglog_fi_tcl_SendNextTestResultStructure::operator=(const diaglog_fi_tcl_SendNextTestResultStructure& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   SendNextTestResReason = coRef.SendNextTestResReason;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_SendNextTestResultStructure::vDestroy()
{
   {
   ITCList.clear();
   }
}

diaglog_fi_tcl_SendNextTestResultStructure::diaglog_fi_tcl_SendNextTestResultStructure()
:Status(0)
,SendNextTestResReason()

 {}

tS32 diaglog_fi_tcl_SendNextTestResultStructure::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_SENDNEXTTESTRESULTSTRUCTURE;
}


diaglog_fi_tcl_SendNextTestResultStructure::~diaglog_fi_tcl_SendNextTestResultStructure()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_SendNextTestResultStructure::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6+ static_cast<tU32>(ITCList.size()*2);
}

fi_tclInContext& diaglog_fi_tcl_SendNextTestResultStructure::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   (tVoid) (oIn >> SendNextTestResReason);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_SendNextTestResultStructure::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   (tVoid) (oOut << SendNextTestResReason);
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_SendNextTestResultStructure::operator==(const diaglog_fi_tcl_SendNextTestResultStructure& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   bResult = bResult && (SendNextTestResReason == roRef.SendNextTestResReason);
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_ErrorCode::diaglog_fi_tcl_e8_ErrorCode():enType(FI_EN_FBLOCKIDNOTAVAILABLE) {}

tS32 diaglog_fi_tcl_e8_ErrorCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_ERRORCODE;
}


diaglog_fi_tcl_e8_ErrorCode::~diaglog_fi_tcl_e8_ErrorCode()
{}

tU32 diaglog_fi_tcl_e8_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_ErrorCode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_GMLnGWDTCFaultType::diaglog_fi_tcl_e8_GMLnGWDTCFaultType():enType(FI_EN_E8NOT_SUPPORTED) {}

tS32 diaglog_fi_tcl_e8_GMLnGWDTCFaultType::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_GMLNGWDTCFAULTTYPE;
}


diaglog_fi_tcl_e8_GMLnGWDTCFaultType::~diaglog_fi_tcl_e8_GMLnGWDTCFaultType()
{}

tU32 diaglog_fi_tcl_e8_GMLnGWDTCFaultType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_GMLnGWDTCFaultType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_GMLnGWDTCFaultType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ActiveDTCList::diaglog_fi_tcl_ActiveDTCList(const diaglog_fi_tcl_ActiveDTCList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   DTCList = coRef.DTCList;
}
diaglog_fi_tcl_ActiveDTCList& diaglog_fi_tcl_ActiveDTCList::operator=(const diaglog_fi_tcl_ActiveDTCList& coRef)
{
   if (this == &coRef) return *this;
   DTCList = coRef.DTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ActiveDTCList::vDestroy()
{
   {
   DTCList.clear();
   }
}

diaglog_fi_tcl_ActiveDTCList::diaglog_fi_tcl_ActiveDTCList()

 {}

tS32 diaglog_fi_tcl_ActiveDTCList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ACTIVEDTCLIST;
}


diaglog_fi_tcl_ActiveDTCList::~diaglog_fi_tcl_ActiveDTCList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ActiveDTCList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(DTCList.size()*4);
}

fi_tclInContext& diaglog_fi_tcl_ActiveDTCList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DTCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DTCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ActiveDTCList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)DTCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DTCList.size(); ++u32Idx)
         (tVoid) (oOut << DTCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ActiveDTCList::operator==(const diaglog_fi_tcl_ActiveDTCList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (DTCList.size() == roRef.DTCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DTCList.size()); ++u32Idx)
            bResult = bResult && (DTCList[u32Idx] == roRef.DTCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_DiagProtocol::diaglog_fi_tcl_DiagProtocol():enType(FI_EN_UNKNOWN) {}

tS32 diaglog_fi_tcl_DiagProtocol::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_DIAGPROTOCOL;
}


diaglog_fi_tcl_DiagProtocol::~diaglog_fi_tcl_DiagProtocol()
{}

tU32 diaglog_fi_tcl_DiagProtocol::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_DiagProtocol::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_DiagProtocol::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_Store::diaglog_fi_tcl_e8_Store():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_Store::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_STORE;
}


diaglog_fi_tcl_e8_Store::~diaglog_fi_tcl_e8_Store()
{}

tU32 diaglog_fi_tcl_e8_Store::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_Store::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_Store::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_RouteCalculationCommand::diaglog_fi_tcl_e8_RouteCalculationCommand():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_RouteCalculationCommand::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_ROUTECALCULATIONCOMMAND;
}


diaglog_fi_tcl_e8_RouteCalculationCommand::~diaglog_fi_tcl_e8_RouteCalculationCommand()
{}

tU32 diaglog_fi_tcl_e8_RouteCalculationCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_RouteCalculationCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_RouteCalculationCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_RouteCalculationStatus::diaglog_fi_tcl_e8_RouteCalculationStatus():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_RouteCalculationStatus::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_ROUTECALCULATIONSTATUS;
}


diaglog_fi_tcl_e8_RouteCalculationStatus::~diaglog_fi_tcl_e8_RouteCalculationStatus()
{}

tU32 diaglog_fi_tcl_e8_RouteCalculationStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_RouteCalculationStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_RouteCalculationStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_Language::diaglog_fi_tcl_e8_Language():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_Language::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_LANGUAGE;
}


diaglog_fi_tcl_e8_Language::~diaglog_fi_tcl_e8_Language()
{}

tU32 diaglog_fi_tcl_e8_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_Language::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_Country::diaglog_fi_tcl_e8_Country():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_Country::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_COUNTRY;
}


diaglog_fi_tcl_e8_Country::~diaglog_fi_tcl_e8_Country()
{}

tU32 diaglog_fi_tcl_e8_Country::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_Country::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_Country::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_LanguageSubsystem::diaglog_fi_tcl_e8_LanguageSubsystem():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_LanguageSubsystem::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_LANGUAGESUBSYSTEM;
}


diaglog_fi_tcl_e8_LanguageSubsystem::~diaglog_fi_tcl_e8_LanguageSubsystem()
{}

tU32 diaglog_fi_tcl_e8_LanguageSubsystem::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_LanguageSubsystem::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_LanguageSubsystem::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_TestScreens::diaglog_fi_tcl_e8_TestScreens():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_TestScreens::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_TESTSCREENS;
}


diaglog_fi_tcl_e8_TestScreens::~diaglog_fi_tcl_e8_TestScreens()
{}

tU32 diaglog_fi_tcl_e8_TestScreens::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_TestScreens::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_TestScreens::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_DisplayStringsList::diaglog_fi_tcl_DisplayStringsList(const diaglog_fi_tcl_DisplayStringsList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   StringList = coRef.StringList;
}
diaglog_fi_tcl_DisplayStringsList& diaglog_fi_tcl_DisplayStringsList::operator=(const diaglog_fi_tcl_DisplayStringsList& coRef)
{
   if (this == &coRef) return *this;
   StringList = coRef.StringList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_DisplayStringsList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         StringList[u32Idx].vDestroy();
   StringList.clear();
   }
}

diaglog_fi_tcl_DisplayStringsList::diaglog_fi_tcl_DisplayStringsList()

 {}

tS32 diaglog_fi_tcl_DisplayStringsList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_DISPLAYSTRINGSLIST;
}


diaglog_fi_tcl_DisplayStringsList::~diaglog_fi_tcl_DisplayStringsList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_DisplayStringsList::u32GetSize(tU16 u16MajorVersion) const
{
   tU32 u32DynamicSize = 0;
   tU32 u32ListIdx;
   for (u32ListIdx = 0; u32ListIdx < StringList.size(); ++u32ListIdx)
      u32DynamicSize += StringList[u32ListIdx].u32GetSize(u16MajorVersion);
   return u32DynamicSize+4;
}

fi_tclInContext& diaglog_fi_tcl_DisplayStringsList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
      {
         StringList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      StringList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> StringList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_DisplayStringsList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)StringList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < StringList.size(); ++u32Idx)
         (tVoid) (oOut << StringList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_DisplayStringsList::operator==(const diaglog_fi_tcl_DisplayStringsList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (StringList.size() == roRef.StringList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < StringList.size()); ++u32Idx)
            bResult = bResult && (StringList[u32Idx] == roRef.StringList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_DisplayData::diaglog_fi_tcl_DisplayData(const diaglog_fi_tcl_DisplayData& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   TestScreen = coRef.TestScreen;
   DisplayStrings = coRef.DisplayStrings;
}
diaglog_fi_tcl_DisplayData& diaglog_fi_tcl_DisplayData::operator=(const diaglog_fi_tcl_DisplayData& coRef)
{
   if (this == &coRef) return *this;
   TestScreen = coRef.TestScreen;
   DisplayStrings = coRef.DisplayStrings;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_DisplayData::vDestroy()
{
   DisplayStrings.vDestroy(); 
}

diaglog_fi_tcl_DisplayData::diaglog_fi_tcl_DisplayData()
:TestScreen()
,DisplayStrings()
 {}

tS32 diaglog_fi_tcl_DisplayData::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_DISPLAYDATA;
}


diaglog_fi_tcl_DisplayData::~diaglog_fi_tcl_DisplayData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_DisplayData::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DisplayStrings.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_fi_tcl_DisplayData::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestScreen);
   (tVoid) (oIn >> DisplayStrings);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_DisplayData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestScreen);
   (tVoid) (oOut << DisplayStrings);
   return oOut;
}

tBool diaglog_fi_tcl_DisplayData::operator==(const diaglog_fi_tcl_DisplayData& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestScreen == roRef.TestScreen);
   bResult = bResult && (DisplayStrings == roRef.DisplayStrings);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_TroubleCodeType::diaglog_fi_tcl_e8_TroubleCodeType():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_TroubleCodeType::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_TROUBLECODETYPE;
}


diaglog_fi_tcl_e8_TroubleCodeType::~diaglog_fi_tcl_e8_TroubleCodeType()
{}

tU32 diaglog_fi_tcl_e8_TroubleCodeType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_TroubleCodeType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_TroubleCodeType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_TestRoutines::diaglog_fi_tcl_e8_TestRoutines():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_TestRoutines::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_TESTROUTINES;
}


diaglog_fi_tcl_e8_TestRoutines::~diaglog_fi_tcl_e8_TestRoutines()
{}

tU32 diaglog_fi_tcl_e8_TestRoutines::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_TestRoutines::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_TestRoutines::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DefaultSettingsCategories::diaglog_fi_tcl_e8_DefaultSettingsCategories():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_DefaultSettingsCategories::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DEFAULTSETTINGSCATEGORIES;
}


diaglog_fi_tcl_e8_DefaultSettingsCategories::~diaglog_fi_tcl_e8_DefaultSettingsCategories()
{}

tU32 diaglog_fi_tcl_e8_DefaultSettingsCategories::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DefaultSettingsCategories::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DefaultSettingsCategories::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CountryLanguage::diaglog_fi_tcl_CountryLanguage(const diaglog_fi_tcl_CountryLanguage& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Country = coRef.Country;
   Language = coRef.Language;
   Subsystem = coRef.Subsystem;
}
diaglog_fi_tcl_CountryLanguage& diaglog_fi_tcl_CountryLanguage::operator=(const diaglog_fi_tcl_CountryLanguage& coRef)
{
   if (this == &coRef) return *this;
   Country = coRef.Country;
   Language = coRef.Language;
   Subsystem = coRef.Subsystem;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_CountryLanguage::diaglog_fi_tcl_CountryLanguage()
:Country()
,Language()
,Subsystem()
 {}

tS32 diaglog_fi_tcl_CountryLanguage::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_COUNTRYLANGUAGE;
}


diaglog_fi_tcl_CountryLanguage::~diaglog_fi_tcl_CountryLanguage()
{}

tU32 diaglog_fi_tcl_CountryLanguage::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& diaglog_fi_tcl_CountryLanguage::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Country);
   (tVoid) (oIn >> Language);
   (tVoid) (oIn >> Subsystem);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CountryLanguage::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Country);
   (tVoid) (oOut << Language);
   (tVoid) (oOut << Subsystem);
   return oOut;
}

tBool diaglog_fi_tcl_CountryLanguage::operator==(const diaglog_fi_tcl_CountryLanguage& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Country == roRef.Country);
   bResult = bResult && (Language == roRef.Language);
   bResult = bResult && (Subsystem == roRef.Subsystem);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CountryLanguageResult::diaglog_fi_tcl_CountryLanguageResult(const diaglog_fi_tcl_CountryLanguageResult& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Success = coRef.Success;
   CountryLanguageList = coRef.CountryLanguageList;
}
diaglog_fi_tcl_CountryLanguageResult& diaglog_fi_tcl_CountryLanguageResult::operator=(const diaglog_fi_tcl_CountryLanguageResult& coRef)
{
   if (this == &coRef) return *this;
   Success = coRef.Success;
   CountryLanguageList = coRef.CountryLanguageList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_CountryLanguageResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
         CountryLanguageList[u32Idx].vDestroy();
   CountryLanguageList.clear();
   }
}

diaglog_fi_tcl_CountryLanguageResult::diaglog_fi_tcl_CountryLanguageResult()
:Success(0)

 {}

tS32 diaglog_fi_tcl_CountryLanguageResult::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_COUNTRYLANGUAGERESULT;
}


diaglog_fi_tcl_CountryLanguageResult::~diaglog_fi_tcl_CountryLanguageResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_CountryLanguageResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(CountryLanguageList.size()*3);
}

fi_tclInContext& diaglog_fi_tcl_CountryLanguageResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Success);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
      {
         CountryLanguageList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      CountryLanguageList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> CountryLanguageList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CountryLanguageResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Success);
   (tVoid) (oOut << (tU32)CountryLanguageList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < CountryLanguageList.size(); ++u32Idx)
         (tVoid) (oOut << CountryLanguageList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_CountryLanguageResult::operator==(const diaglog_fi_tcl_CountryLanguageResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Success == roRef.Success);
      bResult = bResult && (CountryLanguageList.size() == roRef.CountryLanguageList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < CountryLanguageList.size()); ++u32Idx)
            bResult = bResult && (CountryLanguageList[u32Idx] == roRef.CountryLanguageList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_TroubleCodeStatus::diaglog_fi_tcl_e8_TroubleCodeStatus():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_TroubleCodeStatus::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_TROUBLECODESTATUS;
}


diaglog_fi_tcl_e8_TroubleCodeStatus::~diaglog_fi_tcl_e8_TroubleCodeStatus()
{}

tU32 diaglog_fi_tcl_e8_TroubleCodeStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_TroubleCodeStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_TroubleCodeStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_TroubleCode::diaglog_fi_tcl_TroubleCode(const diaglog_fi_tcl_TroubleCode& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   TroubleCode = coRef.TroubleCode;
   Status = coRef.Status;
}
diaglog_fi_tcl_TroubleCode& diaglog_fi_tcl_TroubleCode::operator=(const diaglog_fi_tcl_TroubleCode& coRef)
{
   if (this == &coRef) return *this;
   TroubleCode = coRef.TroubleCode;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_TroubleCode::diaglog_fi_tcl_TroubleCode()
:TroubleCode(0)
,Status()
 {}

tS32 diaglog_fi_tcl_TroubleCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_TROUBLECODE;
}


diaglog_fi_tcl_TroubleCode::~diaglog_fi_tcl_TroubleCode()
{}

tU32 diaglog_fi_tcl_TroubleCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_fi_tcl_TroubleCode::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TroubleCode);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_TroubleCode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TroubleCode);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_fi_tcl_TroubleCode::operator==(const diaglog_fi_tcl_TroubleCode& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TroubleCode == roRef.TroubleCode);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_TroubleCodeList::diaglog_fi_tcl_TroubleCodeList(const diaglog_fi_tcl_TroubleCodeList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   TroubleCodeList = coRef.TroubleCodeList;
}
diaglog_fi_tcl_TroubleCodeList& diaglog_fi_tcl_TroubleCodeList::operator=(const diaglog_fi_tcl_TroubleCodeList& coRef)
{
   if (this == &coRef) return *this;
   TroubleCodeList = coRef.TroubleCodeList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_TroubleCodeList::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
         TroubleCodeList[u32Idx].vDestroy();
   TroubleCodeList.clear();
   }
}

diaglog_fi_tcl_TroubleCodeList::diaglog_fi_tcl_TroubleCodeList()

 {}

tS32 diaglog_fi_tcl_TroubleCodeList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_TROUBLECODELIST;
}


diaglog_fi_tcl_TroubleCodeList::~diaglog_fi_tcl_TroubleCodeList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_TroubleCodeList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(TroubleCodeList.size()*5);
}

fi_tclInContext& diaglog_fi_tcl_TroubleCodeList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
      {
         TroubleCodeList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      TroubleCodeList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> TroubleCodeList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_TroubleCodeList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)TroubleCodeList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < TroubleCodeList.size(); ++u32Idx)
         (tVoid) (oOut << TroubleCodeList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_TroubleCodeList::operator==(const diaglog_fi_tcl_TroubleCodeList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (TroubleCodeList.size() == roRef.TroubleCodeList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < TroubleCodeList.size()); ++u32Idx)
            bResult = bResult && (TroubleCodeList[u32Idx] == roRef.TroubleCodeList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_RouteCalculationStartParameter::diaglog_fi_tcl_RouteCalculationStartParameter(const diaglog_fi_tcl_RouteCalculationStartParameter& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
}
diaglog_fi_tcl_RouteCalculationStartParameter& diaglog_fi_tcl_RouteCalculationStartParameter::operator=(const diaglog_fi_tcl_RouteCalculationStartParameter& coRef)
{
   if (this == &coRef) return *this;
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_RouteCalculationStartParameter::diaglog_fi_tcl_RouteCalculationStartParameter()
:CurrentPositionLongitude(0)
,CurrentPositionLatitude(0)
,DestinationLongitude(0)
,DestinationLatitude(0)
,RouteIndex(0)
,RouteOptimisation(0)
,Command()
 {}

tS32 diaglog_fi_tcl_RouteCalculationStartParameter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ROUTECALCULATIONSTARTPARAMETER;
}


diaglog_fi_tcl_RouteCalculationStartParameter::~diaglog_fi_tcl_RouteCalculationStartParameter()
{}

tU32 diaglog_fi_tcl_RouteCalculationStartParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 19;
}

fi_tclInContext& diaglog_fi_tcl_RouteCalculationStartParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentPositionLongitude);
   (tVoid) (oIn >> CurrentPositionLatitude);
   (tVoid) (oIn >> DestinationLongitude);
   (tVoid) (oIn >> DestinationLatitude);
   (tVoid) (oIn >> RouteIndex);
   (tVoid) (oIn >> RouteOptimisation);
   (tVoid) (oIn >> Command);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_RouteCalculationStartParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentPositionLongitude);
   (tVoid) (oOut << CurrentPositionLatitude);
   (tVoid) (oOut << DestinationLongitude);
   (tVoid) (oOut << DestinationLatitude);
   (tVoid) (oOut << RouteIndex);
   (tVoid) (oOut << RouteOptimisation);
   (tVoid) (oOut << Command);
   return oOut;
}

tBool diaglog_fi_tcl_RouteCalculationStartParameter::operator==(const diaglog_fi_tcl_RouteCalculationStartParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentPositionLongitude == roRef.CurrentPositionLongitude);
   bResult = bResult && (CurrentPositionLatitude == roRef.CurrentPositionLatitude);
   bResult = bResult && (DestinationLongitude == roRef.DestinationLongitude);
   bResult = bResult && (DestinationLatitude == roRef.DestinationLatitude);
   bResult = bResult && (RouteIndex == roRef.RouteIndex);
   bResult = bResult && (RouteOptimisation == roRef.RouteOptimisation);
   bResult = bResult && (Command == roRef.Command);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_RouteCalculationResultParameter::diaglog_fi_tcl_RouteCalculationResultParameter(const diaglog_fi_tcl_RouteCalculationResultParameter& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   RouteCalculationStatus = coRef.RouteCalculationStatus;
   RouteLength = coRef.RouteLength;
   RouteDuration = coRef.RouteDuration;
}
diaglog_fi_tcl_RouteCalculationResultParameter& diaglog_fi_tcl_RouteCalculationResultParameter::operator=(const diaglog_fi_tcl_RouteCalculationResultParameter& coRef)
{
   if (this == &coRef) return *this;
   CurrentPositionLongitude = coRef.CurrentPositionLongitude;
   CurrentPositionLatitude = coRef.CurrentPositionLatitude;
   DestinationLongitude = coRef.DestinationLongitude;
   DestinationLatitude = coRef.DestinationLatitude;
   RouteIndex = coRef.RouteIndex;
   RouteOptimisation = coRef.RouteOptimisation;
   Command = coRef.Command;
   RouteCalculationStatus = coRef.RouteCalculationStatus;
   RouteLength = coRef.RouteLength;
   RouteDuration = coRef.RouteDuration;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_RouteCalculationResultParameter::diaglog_fi_tcl_RouteCalculationResultParameter()
:CurrentPositionLongitude(0)
,CurrentPositionLatitude(0)
,DestinationLongitude(0)
,DestinationLatitude(0)
,RouteIndex(0)
,RouteOptimisation(0)
,Command()
,RouteCalculationStatus()
,RouteLength(0)
,RouteDuration(0)
 {}

tS32 diaglog_fi_tcl_RouteCalculationResultParameter::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ROUTECALCULATIONRESULTPARAMETER;
}


diaglog_fi_tcl_RouteCalculationResultParameter::~diaglog_fi_tcl_RouteCalculationResultParameter()
{}

tU32 diaglog_fi_tcl_RouteCalculationResultParameter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 28;
}

fi_tclInContext& diaglog_fi_tcl_RouteCalculationResultParameter::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CurrentPositionLongitude);
   (tVoid) (oIn >> CurrentPositionLatitude);
   (tVoid) (oIn >> DestinationLongitude);
   (tVoid) (oIn >> DestinationLatitude);
   (tVoid) (oIn >> RouteIndex);
   (tVoid) (oIn >> RouteOptimisation);
   (tVoid) (oIn >> Command);
   (tVoid) (oIn >> RouteCalculationStatus);
   (tVoid) (oIn >> RouteLength);
   (tVoid) (oIn >> RouteDuration);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_RouteCalculationResultParameter::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CurrentPositionLongitude);
   (tVoid) (oOut << CurrentPositionLatitude);
   (tVoid) (oOut << DestinationLongitude);
   (tVoid) (oOut << DestinationLatitude);
   (tVoid) (oOut << RouteIndex);
   (tVoid) (oOut << RouteOptimisation);
   (tVoid) (oOut << Command);
   (tVoid) (oOut << RouteCalculationStatus);
   (tVoid) (oOut << RouteLength);
   (tVoid) (oOut << RouteDuration);
   return oOut;
}

tBool diaglog_fi_tcl_RouteCalculationResultParameter::operator==(const diaglog_fi_tcl_RouteCalculationResultParameter& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CurrentPositionLongitude == roRef.CurrentPositionLongitude);
   bResult = bResult && (CurrentPositionLatitude == roRef.CurrentPositionLatitude);
   bResult = bResult && (DestinationLongitude == roRef.DestinationLongitude);
   bResult = bResult && (DestinationLatitude == roRef.DestinationLatitude);
   bResult = bResult && (RouteIndex == roRef.RouteIndex);
   bResult = bResult && (RouteOptimisation == roRef.RouteOptimisation);
   bResult = bResult && (Command == roRef.Command);
   bResult = bResult && (RouteCalculationStatus == roRef.RouteCalculationStatus);
   bResult = bResult && (RouteLength == roRef.RouteLength);
   bResult = bResult && (RouteDuration == roRef.RouteDuration);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e16_Language::diaglog_fi_tcl_e16_Language():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e16_Language::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E16_LANGUAGE;
}


diaglog_fi_tcl_e16_Language::~diaglog_fi_tcl_e16_Language()
{}

tU32 diaglog_fi_tcl_e16_Language::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_e16_Language::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e16_Language::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e16_SpeedLock::diaglog_fi_tcl_e16_SpeedLock():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e16_SpeedLock::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E16_SPEEDLOCK;
}


diaglog_fi_tcl_e16_SpeedLock::~diaglog_fi_tcl_e16_SpeedLock()
{}

tU32 diaglog_fi_tcl_e16_SpeedLock::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_fi_tcl_e16_SpeedLock::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e16_SpeedLock::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_MessageBuffer::diaglog_fi_tcl_MessageBuffer(const diaglog_fi_tcl_MessageBuffer& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   MessageBuffer = coRef.MessageBuffer;
}
diaglog_fi_tcl_MessageBuffer& diaglog_fi_tcl_MessageBuffer::operator=(const diaglog_fi_tcl_MessageBuffer& coRef)
{
   if (this == &coRef) return *this;
   MessageBuffer = coRef.MessageBuffer;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_MessageBuffer::vDestroy()
{
   {
   MessageBuffer.clear();
   }
}

diaglog_fi_tcl_MessageBuffer::diaglog_fi_tcl_MessageBuffer()

 {}

tS32 diaglog_fi_tcl_MessageBuffer::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_MESSAGEBUFFER;
}


diaglog_fi_tcl_MessageBuffer::~diaglog_fi_tcl_MessageBuffer()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_MessageBuffer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(MessageBuffer.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_MessageBuffer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      MessageBuffer.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> MessageBuffer[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_MessageBuffer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)MessageBuffer.size());
   {
      for (tU32 u32Idx = 0; u32Idx < MessageBuffer.size(); ++u32Idx)
         (tVoid) (oOut << MessageBuffer[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_MessageBuffer::operator==(const diaglog_fi_tcl_MessageBuffer& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (MessageBuffer.size() == roRef.MessageBuffer.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < MessageBuffer.size()); ++u32Idx)
            bResult = bResult && (MessageBuffer[u32Idx] == roRef.MessageBuffer[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DefSetMode::diaglog_fi_tcl_e8_DefSetMode():enType(FI_EN_DEFSET_SRC_NOT_DEF) {}

tS32 diaglog_fi_tcl_e8_DefSetMode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DEFSETMODE;
}


diaglog_fi_tcl_e8_DefSetMode::~diaglog_fi_tcl_e8_DefSetMode()
{}

tU32 diaglog_fi_tcl_e8_DefSetMode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DefSetMode::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DefSetMode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DefSetServiceStatus::diaglog_fi_tcl_e8_DefSetServiceStatus():enType(FI_EN_DEFSET_STATE_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_DefSetServiceStatus::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DEFSETSERVICESTATUS;
}


diaglog_fi_tcl_e8_DefSetServiceStatus::~diaglog_fi_tcl_e8_DefSetServiceStatus()
{}

tU32 diaglog_fi_tcl_e8_DefSetServiceStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DefSetServiceStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DefSetServiceStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DefSetGroups::diaglog_fi_tcl_e8_DefSetGroups():enType(FI_EN_DEFSET_GROUP_UNDEFIEND) {}

tS32 diaglog_fi_tcl_e8_DefSetGroups::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DEFSETGROUPS;
}


diaglog_fi_tcl_e8_DefSetGroups::~diaglog_fi_tcl_e8_DefSetGroups()
{}

tU32 diaglog_fi_tcl_e8_DefSetGroups::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DefSetGroups::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DefSetGroups::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DiagMausSetup::diaglog_fi_tcl_e8_DiagMausSetup():enType(FI_EN_MAUS_STATE_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_DiagMausSetup::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DIAGMAUSSETUP;
}


diaglog_fi_tcl_e8_DiagMausSetup::~diaglog_fi_tcl_e8_DiagMausSetup()
{}

tU32 diaglog_fi_tcl_e8_DiagMausSetup::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DiagMausSetup::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DiagMausSetup::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_SimulatedKeys::diaglog_fi_tcl_e8_SimulatedKeys():enType(FI_EN_KEY_CODE_SOFTKEY_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_SimulatedKeys::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_SIMULATEDKEYS;
}


diaglog_fi_tcl_e8_SimulatedKeys::~diaglog_fi_tcl_e8_SimulatedKeys()
{}

tU32 diaglog_fi_tcl_e8_SimulatedKeys::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_SimulatedKeys::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_SimulatedKeys::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_KDSItemList::diaglog_fi_tcl_KDSItemList(const diaglog_fi_tcl_KDSItemList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
diaglog_fi_tcl_KDSItemList& diaglog_fi_tcl_KDSItemList::operator=(const diaglog_fi_tcl_KDSItemList& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_KDSItemList::vDestroy()
{
   {
   itemList.clear();
   }
}

diaglog_fi_tcl_KDSItemList::diaglog_fi_tcl_KDSItemList()

 {}

tS32 diaglog_fi_tcl_KDSItemList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_KDSITEMLIST;
}


diaglog_fi_tcl_KDSItemList::~diaglog_fi_tcl_KDSItemList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_KDSItemList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_KDSItemList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_KDSItemList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_KDSItemList::operator==(const diaglog_fi_tcl_KDSItemList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ConfigItemList::diaglog_fi_tcl_ConfigItemList(const diaglog_fi_tcl_ConfigItemList& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
diaglog_fi_tcl_ConfigItemList& diaglog_fi_tcl_ConfigItemList::operator=(const diaglog_fi_tcl_ConfigItemList& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ConfigItemList::vDestroy()
{
   {
   itemList.clear();
   }
}

diaglog_fi_tcl_ConfigItemList::diaglog_fi_tcl_ConfigItemList()

 {}

tS32 diaglog_fi_tcl_ConfigItemList::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CONFIGITEMLIST;
}


diaglog_fi_tcl_ConfigItemList::~diaglog_fi_tcl_ConfigItemList()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ConfigItemList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ConfigItemList::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ConfigItemList::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ConfigItemList::operator==(const diaglog_fi_tcl_ConfigItemList& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_RequestDataUDS::diaglog_fi_tcl_RequestDataUDS(const diaglog_fi_tcl_RequestDataUDS& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
diaglog_fi_tcl_RequestDataUDS& diaglog_fi_tcl_RequestDataUDS::operator=(const diaglog_fi_tcl_RequestDataUDS& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_RequestDataUDS::vDestroy()
{
   {
   itemList.clear();
   }
}

diaglog_fi_tcl_RequestDataUDS::diaglog_fi_tcl_RequestDataUDS()

 {}

tS32 diaglog_fi_tcl_RequestDataUDS::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_REQUESTDATAUDS;
}


diaglog_fi_tcl_RequestDataUDS::~diaglog_fi_tcl_RequestDataUDS()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_RequestDataUDS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_RequestDataUDS::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_RequestDataUDS::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_RequestDataUDS::operator==(const diaglog_fi_tcl_RequestDataUDS& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_ResponseDataUDS::diaglog_fi_tcl_ResponseDataUDS(const diaglog_fi_tcl_ResponseDataUDS& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
diaglog_fi_tcl_ResponseDataUDS& diaglog_fi_tcl_ResponseDataUDS::operator=(const diaglog_fi_tcl_ResponseDataUDS& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_ResponseDataUDS::vDestroy()
{
   {
   itemList.clear();
   }
}

diaglog_fi_tcl_ResponseDataUDS::diaglog_fi_tcl_ResponseDataUDS()

 {}

tS32 diaglog_fi_tcl_ResponseDataUDS::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_RESPONSEDATAUDS;
}


diaglog_fi_tcl_ResponseDataUDS::~diaglog_fi_tcl_ResponseDataUDS()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_ResponseDataUDS::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_ResponseDataUDS::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_ResponseDataUDS::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_ResponseDataUDS::operator==(const diaglog_fi_tcl_ResponseDataUDS& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_DiagData::diaglog_fi_tcl_DiagData(const diaglog_fi_tcl_DiagData& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   itemList = coRef.itemList;
}
diaglog_fi_tcl_DiagData& diaglog_fi_tcl_DiagData::operator=(const diaglog_fi_tcl_DiagData& coRef)
{
   if (this == &coRef) return *this;
   itemList = coRef.itemList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_DiagData::vDestroy()
{
   {
   itemList.clear();
   }
}

diaglog_fi_tcl_DiagData::diaglog_fi_tcl_DiagData()

 {}

tS32 diaglog_fi_tcl_DiagData::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_DIAGDATA;
}


diaglog_fi_tcl_DiagData::~diaglog_fi_tcl_DiagData()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_DiagData::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(itemList.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_DiagData::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      itemList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> itemList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_DiagData::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)itemList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < itemList.size(); ++u32Idx)
         (tVoid) (oOut << itemList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_DiagData::operator==(const diaglog_fi_tcl_DiagData& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (itemList.size() == roRef.itemList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < itemList.size()); ++u32Idx)
            bResult = bResult && (itemList[u32Idx] == roRef.itemList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_RCtrlSource::diaglog_fi_tcl_e8_RCtrlSource():enType(FI_EN_RCTRL_SRC_UNKNOWN) {}

tS32 diaglog_fi_tcl_e8_RCtrlSource::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_RCTRLSOURCE;
}


diaglog_fi_tcl_e8_RCtrlSource::~diaglog_fi_tcl_e8_RCtrlSource()
{}

tU32 diaglog_fi_tcl_e8_RCtrlSource::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_RCtrlSource::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_RCtrlSource::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_RCtrlCommand::diaglog_fi_tcl_e8_RCtrlCommand():enType(FI_EN_RCTRL_CMD_DEACTIVATE) {}

tS32 diaglog_fi_tcl_e8_RCtrlCommand::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_RCTRLCOMMAND;
}


diaglog_fi_tcl_e8_RCtrlCommand::~diaglog_fi_tcl_e8_RCtrlCommand()
{}

tU32 diaglog_fi_tcl_e8_RCtrlCommand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_RCtrlCommand::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_RCtrlCommand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_RCtrlSignal::diaglog_fi_tcl_e8_RCtrlSignal():enType(FI_EN_RCTRL_SIG_ALL) {}

tS32 diaglog_fi_tcl_e8_RCtrlSignal::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_RCTRLSIGNAL;
}


diaglog_fi_tcl_e8_RCtrlSignal::~diaglog_fi_tcl_e8_RCtrlSignal()
{}

tU32 diaglog_fi_tcl_e8_RCtrlSignal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_RCtrlSignal::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_RCtrlSignal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_DiagRVCSignal::diaglog_fi_tcl_e8_DiagRVCSignal():enType(FI_EN_EXT_VIDEO_SIGNAL_ON) {}

tS32 diaglog_fi_tcl_e8_DiagRVCSignal::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_DIAGRVCSIGNAL;
}


diaglog_fi_tcl_e8_DiagRVCSignal::~diaglog_fi_tcl_e8_DiagRVCSignal()
{}

tU32 diaglog_fi_tcl_e8_DiagRVCSignal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_DiagRVCSignal::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_DiagRVCSignal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_CalibrationTable::diaglog_fi_tcl_e8_CalibrationTable():enType(FI_EN_CALIBRATION_TABLE_ID_SYSTEM) {}

tS32 diaglog_fi_tcl_e8_CalibrationTable::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_CALIBRATIONTABLE;
}


diaglog_fi_tcl_e8_CalibrationTable::~diaglog_fi_tcl_e8_CalibrationTable()
{}

tU32 diaglog_fi_tcl_e8_CalibrationTable::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_CalibrationTable::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_CalibrationTable::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CalibrationValue::diaglog_fi_tcl_CalibrationValue(const diaglog_fi_tcl_CalibrationValue& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   ByteValue = coRef.ByteValue;
}
diaglog_fi_tcl_CalibrationValue& diaglog_fi_tcl_CalibrationValue::operator=(const diaglog_fi_tcl_CalibrationValue& coRef)
{
   if (this == &coRef) return *this;
   ByteValue = coRef.ByteValue;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_CalibrationValue::vDestroy()
{
   {
   ByteValue.clear();
   }
}

diaglog_fi_tcl_CalibrationValue::diaglog_fi_tcl_CalibrationValue()

 {}

tS32 diaglog_fi_tcl_CalibrationValue::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CALIBRATIONVALUE;
}


diaglog_fi_tcl_CalibrationValue::~diaglog_fi_tcl_CalibrationValue()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_CalibrationValue::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(ByteValue.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_CalibrationValue::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ByteValue.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ByteValue[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CalibrationValue::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ByteValue.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ByteValue.size(); ++u32Idx)
         (tVoid) (oOut << ByteValue[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_CalibrationValue::operator==(const diaglog_fi_tcl_CalibrationValue& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ByteValue.size() == roRef.ByteValue.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ByteValue.size()); ++u32Idx)
            bResult = bResult && (ByteValue[u32Idx] == roRef.ByteValue[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_CalibrationTimeStampMonth::diaglog_fi_tcl_e8_CalibrationTimeStampMonth():enType(FI_EN_UNKNOWN) {}

tS32 diaglog_fi_tcl_e8_CalibrationTimeStampMonth::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_CALIBRATIONTIMESTAMPMONTH;
}


diaglog_fi_tcl_e8_CalibrationTimeStampMonth::~diaglog_fi_tcl_e8_CalibrationTimeStampMonth()
{}

tU32 diaglog_fi_tcl_e8_CalibrationTimeStampMonth::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_CalibrationTimeStampMonth::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_CalibrationTimeStampMonth::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_CalibrationTimeStamp::diaglog_fi_tcl_CalibrationTimeStamp(const diaglog_fi_tcl_CalibrationTimeStamp& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Hours = coRef.Hours;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   Day = coRef.Day;
   Month = coRef.Month;
   Year = coRef.Year;
}
diaglog_fi_tcl_CalibrationTimeStamp& diaglog_fi_tcl_CalibrationTimeStamp::operator=(const diaglog_fi_tcl_CalibrationTimeStamp& coRef)
{
   if (this == &coRef) return *this;
   Hours = coRef.Hours;
   Minutes = coRef.Minutes;
   Seconds = coRef.Seconds;
   Day = coRef.Day;
   Month = coRef.Month;
   Year = coRef.Year;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_CalibrationTimeStamp::diaglog_fi_tcl_CalibrationTimeStamp()
:Hours(0)
,Minutes(0)
,Seconds(0)
,Day(0)
,Month(0)
,Year(0)
 {}

tS32 diaglog_fi_tcl_CalibrationTimeStamp::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_CALIBRATIONTIMESTAMP;
}


diaglog_fi_tcl_CalibrationTimeStamp::~diaglog_fi_tcl_CalibrationTimeStamp()
{}

tU32 diaglog_fi_tcl_CalibrationTimeStamp::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_fi_tcl_CalibrationTimeStamp::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Hours);
   (tVoid) (oIn >> Minutes);
   (tVoid) (oIn >> Seconds);
   (tVoid) (oIn >> Day);
   (tVoid) (oIn >> Month);
   (tVoid) (oIn >> Year);
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_CalibrationTimeStamp::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Hours);
   (tVoid) (oOut << Minutes);
   (tVoid) (oOut << Seconds);
   (tVoid) (oOut << Day);
   (tVoid) (oOut << Month);
   (tVoid) (oOut << Year);
   return oOut;
}

tBool diaglog_fi_tcl_CalibrationTimeStamp::operator==(const diaglog_fi_tcl_CalibrationTimeStamp& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Hours == roRef.Hours);
   bResult = bResult && (Minutes == roRef.Minutes);
   bResult = bResult && (Seconds == roRef.Seconds);
   bResult = bResult && (Day == roRef.Day);
   bResult = bResult && (Month == roRef.Month);
   bResult = bResult && (Year == roRef.Year);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_fi_tcl_AlphaCode::diaglog_fi_tcl_AlphaCode(const diaglog_fi_tcl_AlphaCode& coRef)
   : diaglog_fi_tclVisitableTypeBase(coRef)
{
   Letter = coRef.Letter;
}
diaglog_fi_tcl_AlphaCode& diaglog_fi_tcl_AlphaCode::operator=(const diaglog_fi_tcl_AlphaCode& coRef)
{
   if (this == &coRef) return *this;
   Letter = coRef.Letter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_fi_tcl_AlphaCode::vDestroy()
{
   {
   Letter.clear();
   }
}

diaglog_fi_tcl_AlphaCode::diaglog_fi_tcl_AlphaCode()

 {}

tS32 diaglog_fi_tcl_AlphaCode::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ALPHACODE;
}


diaglog_fi_tcl_AlphaCode::~diaglog_fi_tcl_AlphaCode()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_fi_tcl_AlphaCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4+ static_cast<tU32>(Letter.size()*1);
}

fi_tclInContext& diaglog_fi_tcl_AlphaCode::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      Letter.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> Letter[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_AlphaCode::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)Letter.size());
   {
      for (tU32 u32Idx = 0; u32Idx < Letter.size(); ++u32Idx)
         (tVoid) (oOut << Letter[u32Idx]);
   }
   return oOut;
}

tBool diaglog_fi_tcl_AlphaCode::operator==(const diaglog_fi_tcl_AlphaCode& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (Letter.size() == roRef.Letter.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < Letter.size()); ++u32Idx)
            bResult = bResult && (Letter[u32Idx] == roRef.Letter[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_CalibrationParameterSize::diaglog_fi_tcl_e8_CalibrationParameterSize():enType(FI_EN_CALIBRATION_SIZE_BIT) {}

tS32 diaglog_fi_tcl_e8_CalibrationParameterSize::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_CALIBRATIONPARAMETERSIZE;
}


diaglog_fi_tcl_e8_CalibrationParameterSize::~diaglog_fi_tcl_e8_CalibrationParameterSize()
{}

tU32 diaglog_fi_tcl_e8_CalibrationParameterSize::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_CalibrationParameterSize::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_CalibrationParameterSize::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus():enType(FI_EN_UNDEFINED) {}

tS32 diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_E8_KDSVIAUSBUPDATESTATUS;
}


diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::~diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus()
{}

tU32 diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_e8_KdsViaUsbUpdateStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_fi_tcl_AntiTheftStatus::diaglog_fi_tcl_AntiTheftStatus():enType(FI_EN_HU_UNLOCKED) {}

tS32 diaglog_fi_tcl_AntiTheftStatus::s32GetTypeId() const
{
   return (tS32) diaglog_typesfi_tclToken::EN_ANTITHEFTSTATUS;
}


diaglog_fi_tcl_AntiTheftStatus::~diaglog_fi_tcl_AntiTheftStatus()
{}

tU32 diaglog_fi_tcl_AntiTheftStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_fi_tcl_AntiTheftStatus::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& diaglog_fi_tcl_AntiTheftStatus::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

