/************************************************************************
 
 *FILE:           navifitypes.cpp
 
 *SW-COMPONENT:   NaviFI, Navigation Functional Interface
 
 *DESCRIPTION:    Interface fuer allgemeine Typdefinitionen des Nafi
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define DIAGLOG_FI_S_IMPORT_INTERFACE_DIAGLOG_MAINFI_TYPES
#define DIAGLOG_FI_S_IMPORT_INTERFACE_DIAGLOG_MAINFI_FUNCTIONIDS
#define DIAGLOG_FI_S_IMPORT_INTERFACE_DIAGLOG_MAINFI_SERVICEINFO
#include "diaglog_fi_if.h"

#define CCA_S_IMPORT_INTERFACE_GENERIC
#include "cca_if.h"

// =============================================================================
//
//                Factory for diaglog_main_fi message types

fi_tclMessageBase* diaglog_mainfi_poGetMessageBaseObject(tU16 u16FunctionId, tU8 u8Opcode)
{
   switch (((tU32)u16FunctionId << 16u) + ((tU32)u8Opcode << 8u))
   {
      case diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgSaveTestResultMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgSaveTestResultMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgProductionReadRequestMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgProductionReadRequestMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgCustomerReadRequestMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgCustomerReadRequestMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetItcInformationMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetItcInformationMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgProductionClearRequestMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgProductionClearRequestMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgCustomerClearRequestMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgCustomerClearRequestMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgWriteToMediaMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgWriteToMediaMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetSupportedDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetSupportedDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetStatusByDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetStatusByDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsggetStatusByITCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsggetStatusByITCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_CLEARDTCMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgclearDTCMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgclearDTCMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_CONTROLMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgControlMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_CONTROLMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgControlMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgControlDtcSettingMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgControlDtcSettingMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART:
         return OSAL_NEW diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart;

      case diaglog_mainfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT:
         return OSAL_NEW diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult;

      case diaglog_mainfi_tclToken::EN_MSG_DTCACTIVEGET:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCActiveGet;

      case diaglog_mainfi_tclToken::EN_MSG_DTCACTIVEUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCActiveUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCACTIVERELUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCActiveRelUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCACTIVESTATUS:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCActiveStatus;

      case diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgSendNextTestResultUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgSendNextTestResultRelUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS:
         return OSAL_NEW diaglog_mainfi_tclMsgSendNextTestResultStatus;

      case diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCTriggeredUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCTriggeredRelUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDGET:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCTriggeredGet;

      case diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS:
         return OSAL_NEW diaglog_mainfi_tclMsgDTCTriggeredStatus;

      case diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgSendActiveDTCListUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS:
         return OSAL_NEW diaglog_mainfi_tclMsgSendActiveDTCListStatus;

      case diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDtcStatusChangedUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG:
         return OSAL_NEW diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg;

      case diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS:
         return OSAL_NEW diaglog_mainfi_tclMsgDtcStatusChangedStatus;

      default: 
         return OSAL_NULL;
   }
}

//=============================================================================

// base class for all diaglog_mainfifi messages

// common functions

tU16 diaglog_mainfi_tclMsgBaseMessage::u16GetServiceID() const
{
   return DIAGLOG_MAINFI_C_U16_SERVICE_ID;
}

tU16 diaglog_mainfi_tclMsgBaseMessage::u16GetFunctionID() const
{
   return (tU16) ((((tU32) s32GetTypeId()) >> 16) & 0xFFFF);
}

tU8 diaglog_mainfi_tclMsgBaseMessage::u8GetOpCode() const 
{
   return (tU8) ((((tU32) s32GetTypeId()) >> 8) & 0xFF);
}

const fi_tclTypeBase& diaglog_mainfi_tclMsgBaseMessage::corfoGetTypeBase() const
{
   return *this;
}

fi_tclTypeBase& diaglog_mainfi_tclMsgBaseMessage::rfoGetTypeBase()
{
   return *this;
}

// default implementation directly applicable to all messages without paramenters

tU32 diaglog_mainfi_tclMsgBaseMessage::u32GetSize(tU16 /* u16MajorVersion */ ) const
{
   return 0;
}

fi_tclOutContext& diaglog_mainfi_tclMsgBaseMessage::oWrite(fi_tclOutContext& rfoOut) const
{
   return rfoOut;
}

fi_tclInContext& diaglog_mainfi_tclMsgBaseMessage::oRead(fi_tclInContext& rfoIn)
{
   return rfoIn;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSaveTestResultMethodStart::diaglog_mainfi_tclMsgSaveTestResultMethodStart(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   TestResultList = coRef.TestResultList;
}
diaglog_mainfi_tclMsgSaveTestResultMethodStart& diaglog_mainfi_tclMsgSaveTestResultMethodStart::operator=(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgSaveTestResultMethodStart::vDestroy()
{
   TestResultList.vDestroy(); 
}

diaglog_mainfi_tclMsgSaveTestResultMethodStart::diaglog_mainfi_tclMsgSaveTestResultMethodStart()
:TestResultList()
 {}

tS32 diaglog_mainfi_tclMsgSaveTestResultMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTMETHODSTART;
}


diaglog_mainfi_tclMsgSaveTestResultMethodStart::~diaglog_mainfi_tclMsgSaveTestResultMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgSaveTestResultMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgSaveTestResultMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestResultList);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSaveTestResultMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestResultList);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSaveTestResultMethodStart::operator==(const diaglog_mainfi_tclMsgSaveTestResultMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestResultList == roRef.TestResultList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSaveTestResultMethodResult::diaglog_mainfi_tclMsgSaveTestResultMethodResult(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgSaveTestResultMethodResult& diaglog_mainfi_tclMsgSaveTestResultMethodResult::operator=(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgSaveTestResultMethodResult::diaglog_mainfi_tclMsgSaveTestResultMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgSaveTestResultMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTMETHODRESULT;
}


diaglog_mainfi_tclMsgSaveTestResultMethodResult::~diaglog_mainfi_tclMsgSaveTestResultMethodResult()
{}

tU32 diaglog_mainfi_tclMsgSaveTestResultMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgSaveTestResultMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSaveTestResultMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSaveTestResultMethodResult::operator==(const diaglog_mainfi_tclMsgSaveTestResultMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   TestResultList = coRef.TestResultList;
}
diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::operator=(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   TestResultList = coRef.TestResultList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::vDestroy()
{
   TestResultList.vDestroy(); 
}

diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart()
:TestResultList()
 {}

tS32 diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODSTART;
}


diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::~diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+TestResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> TestResultList);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << TestResultList);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart::operator==(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (TestResultList == roRef.TestResultList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::operator=(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SAVETESTRESULTDYNAMICALDTCMETHODRESULT;
}


diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::~diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult()
{}

tU32 diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult::operator==(const diaglog_mainfi_tclMsgSaveTestResultDynamicalDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgProductionReadRequestMethodStart::diaglog_mainfi_tclMsgProductionReadRequestMethodStart(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   ITCMask = coRef.ITCMask;
   Option = coRef.Option;
}
diaglog_mainfi_tclMsgProductionReadRequestMethodStart& diaglog_mainfi_tclMsgProductionReadRequestMethodStart::operator=(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   ITCMask = coRef.ITCMask;
   Option = coRef.Option;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgProductionReadRequestMethodStart::diaglog_mainfi_tclMsgProductionReadRequestMethodStart()
:Protocol()
,StatusMask(0)
,ITCMask(0)
,Option(0)
 {}

tS32 diaglog_mainfi_tclMsgProductionReadRequestMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODSTART;
}


diaglog_mainfi_tclMsgProductionReadRequestMethodStart::~diaglog_mainfi_tclMsgProductionReadRequestMethodStart()
{}

tU32 diaglog_mainfi_tclMsgProductionReadRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& diaglog_mainfi_tclMsgProductionReadRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Protocol);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> ITCMask);
   (tVoid) (oIn >> Option);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgProductionReadRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Protocol);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << ITCMask);
   (tVoid) (oOut << Option);
   return oOut;
}

tBool diaglog_mainfi_tclMsgProductionReadRequestMethodStart::operator==(const diaglog_mainfi_tclMsgProductionReadRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Protocol == roRef.Protocol);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (ITCMask == roRef.ITCMask);
   bResult = bResult && (Option == roRef.Option);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgProductionReadRequestMethodResult::diaglog_mainfi_tclMsgProductionReadRequestMethodResult(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ProductionReadResultList = coRef.ProductionReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgProductionReadRequestMethodResult& diaglog_mainfi_tclMsgProductionReadRequestMethodResult::operator=(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ProductionReadResultList = coRef.ProductionReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgProductionReadRequestMethodResult::vDestroy()
{
   ProductionReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsgProductionReadRequestMethodResult::diaglog_mainfi_tclMsgProductionReadRequestMethodResult()
:ProductionReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsgProductionReadRequestMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONREADREQUESTMETHODRESULT;
}


diaglog_mainfi_tclMsgProductionReadRequestMethodResult::~diaglog_mainfi_tclMsgProductionReadRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgProductionReadRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ProductionReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgProductionReadRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ProductionReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgProductionReadRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ProductionReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgProductionReadRequestMethodResult::operator==(const diaglog_mainfi_tclMsgProductionReadRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ProductionReadResultList == roRef.ProductionReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::diaglog_mainfi_tclMsgCustomerReadRequestMethodStart(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   Option = coRef.Option;
}
diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::operator=(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Protocol = coRef.Protocol;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   Option = coRef.Option;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::diaglog_mainfi_tclMsgCustomerReadRequestMethodStart()
:Protocol()
,StatusMask(0)
,DTCMask(0)
,Option(0)
 {}

tS32 diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODSTART;
}


diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::~diaglog_mainfi_tclMsgCustomerReadRequestMethodStart()
{}

tU32 diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 10;
}

fi_tclInContext& diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Protocol);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   (tVoid) (oIn >> Option);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Protocol);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   (tVoid) (oOut << Option);
   return oOut;
}

tBool diaglog_mainfi_tclMsgCustomerReadRequestMethodStart::operator==(const diaglog_mainfi_tclMsgCustomerReadRequestMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Protocol == roRef.Protocol);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   bResult = bResult && (Option == roRef.Option);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::diaglog_mainfi_tclMsgCustomerReadRequestMethodResult(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   CustomerReadResultList = coRef.CustomerReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::operator=(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   CustomerReadResultList = coRef.CustomerReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::vDestroy()
{
   CustomerReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::diaglog_mainfi_tclMsgCustomerReadRequestMethodResult()
:CustomerReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CUSTOMERREADREQUESTMETHODRESULT;
}


diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::~diaglog_mainfi_tclMsgCustomerReadRequestMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+CustomerReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> CustomerReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << CustomerReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgCustomerReadRequestMethodResult::operator==(const diaglog_mainfi_tclMsgCustomerReadRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (CustomerReadResultList == roRef.CustomerReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetItcInformationMethodStart::diaglog_mainfi_tclMsggetItcInformationMethodStart(const diaglog_mainfi_tclMsggetItcInformationMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   ITCList = coRef.ITCList;
}
diaglog_mainfi_tclMsggetItcInformationMethodStart& diaglog_mainfi_tclMsggetItcInformationMethodStart::operator=(const diaglog_mainfi_tclMsggetItcInformationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   ITCList = coRef.ITCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetItcInformationMethodStart::vDestroy()
{
   {
   ITCList.clear();
   }
}

diaglog_mainfi_tclMsggetItcInformationMethodStart::diaglog_mainfi_tclMsggetItcInformationMethodStart()
:Group(0)

 {}

tS32 diaglog_mainfi_tclMsggetItcInformationMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODSTART;
}


diaglog_mainfi_tclMsggetItcInformationMethodStart::~diaglog_mainfi_tclMsggetItcInformationMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetItcInformationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ITCList.size()*2);
}

fi_tclInContext& diaglog_mainfi_tclMsggetItcInformationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ITCList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ITCList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetItcInformationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << (tU32)ITCList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ITCList.size(); ++u32Idx)
         (tVoid) (oOut << ITCList[u32Idx]);
   }
   return oOut;
}

tBool diaglog_mainfi_tclMsggetItcInformationMethodStart::operator==(const diaglog_mainfi_tclMsggetItcInformationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
      bResult = bResult && (ITCList.size() == roRef.ITCList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ITCList.size()); ++u32Idx)
            bResult = bResult && (ITCList[u32Idx] == roRef.ITCList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetItcInformationMethodResult::diaglog_mainfi_tclMsggetItcInformationMethodResult(const diaglog_mainfi_tclMsggetItcInformationMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ItcInformationList = coRef.ItcInformationList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetItcInformationMethodResult& diaglog_mainfi_tclMsggetItcInformationMethodResult::operator=(const diaglog_mainfi_tclMsggetItcInformationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ItcInformationList = coRef.ItcInformationList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetItcInformationMethodResult::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
         ItcInformationList[u32Idx].vDestroy();
   ItcInformationList.clear();
   }
}

diaglog_mainfi_tclMsggetItcInformationMethodResult::diaglog_mainfi_tclMsggetItcInformationMethodResult()

:Status()
 {}

tS32 diaglog_mainfi_tclMsggetItcInformationMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETITCINFORMATIONMETHODRESULT;
}


diaglog_mainfi_tclMsggetItcInformationMethodResult::~diaglog_mainfi_tclMsggetItcInformationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetItcInformationMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5+ static_cast<tU32>(ItcInformationList.size()*15);
}

fi_tclInContext& diaglog_mainfi_tclMsggetItcInformationMethodResult::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
      {
         ItcInformationList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      ItcInformationList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ItcInformationList[u32Idx]);
      }
   }
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetItcInformationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ItcInformationList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ItcInformationList.size(); ++u32Idx)
         (tVoid) (oOut << ItcInformationList[u32Idx]);
   }
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetItcInformationMethodResult::operator==(const diaglog_mainfi_tclMsggetItcInformationMethodResult& roRef) const
{
   tBool bResult = true;
      bResult = bResult && (ItcInformationList.size() == roRef.ItcInformationList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ItcInformationList.size()); ++u32Idx)
            bResult = bResult && (ItcInformationList[u32Idx] == roRef.ItcInformationList[u32Idx]);
      }
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgProductionClearRequestMethodStart::diaglog_mainfi_tclMsgProductionClearRequestMethodStart()
 {}

tS32 diaglog_mainfi_tclMsgProductionClearRequestMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODSTART;
}


diaglog_mainfi_tclMsgProductionClearRequestMethodStart::~diaglog_mainfi_tclMsgProductionClearRequestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgProductionClearRequestMethodResult::diaglog_mainfi_tclMsgProductionClearRequestMethodResult(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgProductionClearRequestMethodResult& diaglog_mainfi_tclMsgProductionClearRequestMethodResult::operator=(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgProductionClearRequestMethodResult::diaglog_mainfi_tclMsgProductionClearRequestMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgProductionClearRequestMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_PRODUCTIONCLEARREQUESTMETHODRESULT;
}


diaglog_mainfi_tclMsgProductionClearRequestMethodResult::~diaglog_mainfi_tclMsgProductionClearRequestMethodResult()
{}

tU32 diaglog_mainfi_tclMsgProductionClearRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgProductionClearRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgProductionClearRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgProductionClearRequestMethodResult::operator==(const diaglog_mainfi_tclMsgProductionClearRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgCustomerClearRequestMethodStart::diaglog_mainfi_tclMsgCustomerClearRequestMethodStart()
 {}

tS32 diaglog_mainfi_tclMsgCustomerClearRequestMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODSTART;
}


diaglog_mainfi_tclMsgCustomerClearRequestMethodStart::~diaglog_mainfi_tclMsgCustomerClearRequestMethodStart()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::diaglog_mainfi_tclMsgCustomerClearRequestMethodResult(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::operator=(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::diaglog_mainfi_tclMsgCustomerClearRequestMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CUSTOMERCLEARREQUESTMETHODRESULT;
}


diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::~diaglog_mainfi_tclMsgCustomerClearRequestMethodResult()
{}

tU32 diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgCustomerClearRequestMethodResult::operator==(const diaglog_mainfi_tclMsgCustomerClearRequestMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgWriteToMediaMethodStart::diaglog_mainfi_tclMsgWriteToMediaMethodStart(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Media = coRef.Media;
}
diaglog_mainfi_tclMsgWriteToMediaMethodStart& diaglog_mainfi_tclMsgWriteToMediaMethodStart::operator=(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Media = coRef.Media;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgWriteToMediaMethodStart::diaglog_mainfi_tclMsgWriteToMediaMethodStart()
:Media()
 {}

tS32 diaglog_mainfi_tclMsgWriteToMediaMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_WRITETOMEDIAMETHODSTART;
}


diaglog_mainfi_tclMsgWriteToMediaMethodStart::~diaglog_mainfi_tclMsgWriteToMediaMethodStart()
{}

tU32 diaglog_mainfi_tclMsgWriteToMediaMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgWriteToMediaMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Media);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgWriteToMediaMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Media);
   return oOut;
}

tBool diaglog_mainfi_tclMsgWriteToMediaMethodStart::operator==(const diaglog_mainfi_tclMsgWriteToMediaMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Media == roRef.Media);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgWriteToMediaMethodResult::diaglog_mainfi_tclMsgWriteToMediaMethodResult(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgWriteToMediaMethodResult& diaglog_mainfi_tclMsgWriteToMediaMethodResult::operator=(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgWriteToMediaMethodResult::diaglog_mainfi_tclMsgWriteToMediaMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgWriteToMediaMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_WRITETOMEDIAMETHODRESULT;
}


diaglog_mainfi_tclMsgWriteToMediaMethodResult::~diaglog_mainfi_tclMsgWriteToMediaMethodResult()
{}

tU32 diaglog_mainfi_tclMsgWriteToMediaMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgWriteToMediaMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgWriteToMediaMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgWriteToMediaMethodResult::operator==(const diaglog_mainfi_tclMsgWriteToMediaMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
}
diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::operator=(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart()
:Group(0)
,StatusMask(0)
,DTCMask(0)
 {}

tS32 diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODSTART;
}


diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::~diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart::operator==(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::operator=(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETDTCBYSTATUSMASKMETHODRESULT;
}


diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::~diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult::operator==(const diaglog_mainfi_tclMsggetDTCbyStatusMaskMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::operator=(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart()
:Group(0)
 {}

tS32 diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODSTART;
}


diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::~diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart::operator==(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::operator=(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETLASTCONFIRMEDDTCMETHODRESULT;
}


diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::~diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult::operator==(const diaglog_mainfi_tclMsggetLastConfirmedDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetSupportedDTCMethodStart::diaglog_mainfi_tclMsggetSupportedDTCMethodStart(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
diaglog_mainfi_tclMsggetSupportedDTCMethodStart& diaglog_mainfi_tclMsggetSupportedDTCMethodStart::operator=(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetSupportedDTCMethodStart::diaglog_mainfi_tclMsggetSupportedDTCMethodStart()
:Group(0)
 {}

tS32 diaglog_mainfi_tclMsggetSupportedDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODSTART;
}


diaglog_mainfi_tclMsggetSupportedDTCMethodStart::~diaglog_mainfi_tclMsggetSupportedDTCMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetSupportedDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsggetSupportedDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetSupportedDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetSupportedDTCMethodStart::operator==(const diaglog_mainfi_tclMsggetSupportedDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetSupportedDTCMethodResult::diaglog_mainfi_tclMsggetSupportedDTCMethodResult(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetSupportedDTCMethodResult& diaglog_mainfi_tclMsggetSupportedDTCMethodResult::operator=(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetSupportedDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsggetSupportedDTCMethodResult::diaglog_mainfi_tclMsggetSupportedDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetSupportedDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSUPPORTEDDTCMETHODRESULT;
}


diaglog_mainfi_tclMsggetSupportedDTCMethodResult::~diaglog_mainfi_tclMsggetSupportedDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetSupportedDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetSupportedDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetSupportedDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetSupportedDTCMethodResult::operator==(const diaglog_mainfi_tclMsggetSupportedDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
}
diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::operator=(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   StatusMask = coRef.StatusMask;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart()
:Group(0)
,StatusMask(0)
,DTCMask(0)
 {}

tS32 diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODSTART;
}


diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::~diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> StatusMask);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << StatusMask);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart::operator==(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (StatusMask == roRef.StatusMask);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   NumberOfDTC = coRef.NumberOfDTC;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::operator=(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   NumberOfDTC = coRef.NumberOfDTC;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult()
:StatusAvailabilityMask(0)
,NumberOfDTC(0)
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETNUMBEROFDTCBYSTATUSMASKMETHODRESULT;
}


diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::~diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult()
{}

tU32 diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> NumberOfDTC);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << NumberOfDTC);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult::operator==(const diaglog_mainfi_tclMsggetNumberOfDTCByStatusMaskMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (NumberOfDTC == roRef.NumberOfDTC);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetStatusByDTCMethodStart::diaglog_mainfi_tclMsggetStatusByDTCMethodStart(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
}
diaglog_mainfi_tclMsggetStatusByDTCMethodStart& diaglog_mainfi_tclMsggetStatusByDTCMethodStart::operator=(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetStatusByDTCMethodStart::diaglog_mainfi_tclMsggetStatusByDTCMethodStart()
:Group(0)
,DTCMask(0)
 {}

tS32 diaglog_mainfi_tclMsggetStatusByDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODSTART;
}


diaglog_mainfi_tclMsggetStatusByDTCMethodStart::~diaglog_mainfi_tclMsggetStatusByDTCMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetStatusByDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_mainfi_tclMsggetStatusByDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetStatusByDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetStatusByDTCMethodStart::operator==(const diaglog_mainfi_tclMsggetStatusByDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetStatusByDTCMethodResult::diaglog_mainfi_tclMsggetStatusByDTCMethodResult(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetStatusByDTCMethodResult& diaglog_mainfi_tclMsggetStatusByDTCMethodResult::operator=(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   StatusAvailabilityMask = coRef.StatusAvailabilityMask;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetStatusByDTCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsggetStatusByDTCMethodResult::diaglog_mainfi_tclMsggetStatusByDTCMethodResult()
:StatusAvailabilityMask(0)
,ReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetStatusByDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYDTCMETHODRESULT;
}


diaglog_mainfi_tclMsggetStatusByDTCMethodResult::~diaglog_mainfi_tclMsggetStatusByDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetStatusByDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 2+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetStatusByDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> StatusAvailabilityMask);
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetStatusByDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << StatusAvailabilityMask);
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetStatusByDTCMethodResult::operator==(const diaglog_mainfi_tclMsggetStatusByDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (StatusAvailabilityMask == roRef.StatusAvailabilityMask);
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCExtDataRecordNumber = coRef.DTCExtDataRecordNumber;
}
diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::operator=(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCExtDataRecordNumber = coRef.DTCExtDataRecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart()
:Group(0)
,DTC(0)
,DTCExtDataRecordNumber(0)
 {}

tS32 diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODSTART;
}


diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::~diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCExtDataRecordNumber);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCExtDataRecordNumber);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart::operator==(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCExtDataRecordNumber == roRef.DTCExtDataRecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   FreezeFrameList = coRef.FreezeFrameList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::operator=(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   FreezeFrameList = coRef.FreezeFrameList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::vDestroy()
{
   FreezeFrameList.vDestroy(); 
}

diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult()
:DTC(0)
,StatusOfDtc(0)
,FreezeFrameList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETEXTENDEDDATABYDTCMETHODRESULT;
}


diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::~diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+FreezeFrameList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   (tVoid) (oIn >> FreezeFrameList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   (tVoid) (oOut << FreezeFrameList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult::operator==(const diaglog_mainfi_tclMsggetExtendedDataByDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   bResult = bResult && (FreezeFrameList == roRef.FreezeFrameList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetStatusByITCMethodStart::diaglog_mainfi_tclMsggetStatusByITCMethodStart(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   ITCMask = coRef.ITCMask;
}
diaglog_mainfi_tclMsggetStatusByITCMethodStart& diaglog_mainfi_tclMsggetStatusByITCMethodStart::operator=(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   ITCMask = coRef.ITCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsggetStatusByITCMethodStart::diaglog_mainfi_tclMsggetStatusByITCMethodStart()
:Group(0)
,ITCMask(0)
 {}

tS32 diaglog_mainfi_tclMsggetStatusByITCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODSTART;
}


diaglog_mainfi_tclMsggetStatusByITCMethodStart::~diaglog_mainfi_tclMsggetStatusByITCMethodStart()
{}

tU32 diaglog_mainfi_tclMsggetStatusByITCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_mainfi_tclMsggetStatusByITCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> ITCMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetStatusByITCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << ITCMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetStatusByITCMethodStart::operator==(const diaglog_mainfi_tclMsggetStatusByITCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (ITCMask == roRef.ITCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsggetStatusByITCMethodResult::diaglog_mainfi_tclMsggetStatusByITCMethodResult(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsggetStatusByITCMethodResult& diaglog_mainfi_tclMsggetStatusByITCMethodResult::operator=(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   ReadResultList = coRef.ReadResultList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsggetStatusByITCMethodResult::vDestroy()
{
   ReadResultList.vDestroy(); 
}

diaglog_mainfi_tclMsggetStatusByITCMethodResult::diaglog_mainfi_tclMsggetStatusByITCMethodResult()
:ReadResultList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsggetStatusByITCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_GETSTATUSBYITCMETHODRESULT;
}


diaglog_mainfi_tclMsggetStatusByITCMethodResult::~diaglog_mainfi_tclMsggetStatusByITCMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsggetStatusByITCMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+ReadResultList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsggetStatusByITCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ReadResultList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsggetStatusByITCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ReadResultList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsggetStatusByITCMethodResult::operator==(const diaglog_mainfi_tclMsggetStatusByITCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ReadResultList == roRef.ReadResultList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
}
diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart()
:Group(0)
 {}

tS32 diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODSTART;
}


diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::~diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart()
{}

tU32 diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   return oOut;
}

tBool diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart::operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   SnapshotIdentificationList = coRef.SnapshotIdentificationList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& coRef)
{
   if (this == &coRef) return *this;
   SnapshotIdentificationList = coRef.SnapshotIdentificationList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::vDestroy()
{
   SnapshotIdentificationList.vDestroy(); 
}

diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult()
:SnapshotIdentificationList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTIDENTIFICATIONMETHODRESULT;
}


diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::~diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+SnapshotIdentificationList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> SnapshotIdentificationList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << SnapshotIdentificationList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult::operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotIdentificationMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (SnapshotIdentificationList == roRef.SnapshotIdentificationList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCSnapshotRecordNumber = coRef.DTCSnapshotRecordNumber;
}
diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTC = coRef.DTC;
   DTCSnapshotRecordNumber = coRef.DTCSnapshotRecordNumber;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart()
:Group(0)
,DTC(0)
,DTCSnapshotRecordNumber(0)
 {}

tS32 diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODSTART;
}


diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::~diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart()
{}

tU32 diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCSnapshotRecordNumber);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCSnapshotRecordNumber);
   return oOut;
}

tBool diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart::operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCSnapshotRecordNumber == roRef.DTCSnapshotRecordNumber);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   SnapshotDataList = coRef.SnapshotDataList;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::operator=(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DTC = coRef.DTC;
   StatusOfDtc = coRef.StatusOfDtc;
   SnapshotDataList = coRef.SnapshotDataList;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::vDestroy()
{
   SnapshotDataList.vDestroy(); 
}

diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult()
:DTC(0)
,StatusOfDtc(0)
,SnapshotDataList()
,Status()
 {}

tS32 diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_REPORTDTCSNAPSHOTRECORDBYDTCNUMBERMETHODRESULT;
}


diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::~diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::u32GetSize(tU16 u16MajorVersion) const
{
   return 6+SnapshotDataList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> StatusOfDtc);
   (tVoid) (oIn >> SnapshotDataList);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << StatusOfDtc);
   (tVoid) (oOut << SnapshotDataList);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult::operator==(const diaglog_mainfi_tclMsgreportDTCSnapshotRecordByDTCNumberMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (StatusOfDtc == roRef.StatusOfDtc);
   bResult = bResult && (SnapshotDataList == roRef.SnapshotDataList);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgclearDTCMethodStart::diaglog_mainfi_tclMsgclearDTCMethodStart(const diaglog_mainfi_tclMsgclearDTCMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
}
diaglog_mainfi_tclMsgclearDTCMethodStart& diaglog_mainfi_tclMsgclearDTCMethodStart::operator=(const diaglog_mainfi_tclMsgclearDTCMethodStart& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCMask = coRef.DTCMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgclearDTCMethodStart::diaglog_mainfi_tclMsgclearDTCMethodStart()
:Group(0)
,DTCMask(0)
 {}

tS32 diaglog_mainfi_tclMsgclearDTCMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CLEARDTCMETHODSTART;
}


diaglog_mainfi_tclMsgclearDTCMethodStart::~diaglog_mainfi_tclMsgclearDTCMethodStart()
{}

tU32 diaglog_mainfi_tclMsgclearDTCMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_mainfi_tclMsgclearDTCMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgclearDTCMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsgclearDTCMethodStart::operator==(const diaglog_mainfi_tclMsgclearDTCMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCMask == roRef.DTCMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgclearDTCMethodResult::diaglog_mainfi_tclMsgclearDTCMethodResult(const diaglog_mainfi_tclMsgclearDTCMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgclearDTCMethodResult& diaglog_mainfi_tclMsgclearDTCMethodResult::operator=(const diaglog_mainfi_tclMsgclearDTCMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgclearDTCMethodResult::diaglog_mainfi_tclMsgclearDTCMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgclearDTCMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CLEARDTCMETHODRESULT;
}


diaglog_mainfi_tclMsgclearDTCMethodResult::~diaglog_mainfi_tclMsgclearDTCMethodResult()
{}

tU32 diaglog_mainfi_tclMsgclearDTCMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgclearDTCMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgclearDTCMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgclearDTCMethodResult::operator==(const diaglog_mainfi_tclMsgclearDTCMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgControlMethodStart::diaglog_mainfi_tclMsgControlMethodStart(const diaglog_mainfi_tclMsgControlMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ControlParameter = coRef.ControlParameter;
}
diaglog_mainfi_tclMsgControlMethodStart& diaglog_mainfi_tclMsgControlMethodStart::operator=(const diaglog_mainfi_tclMsgControlMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ControlParameter = coRef.ControlParameter;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgControlMethodStart::diaglog_mainfi_tclMsgControlMethodStart()
:ControlParameter()
 {}

tS32 diaglog_mainfi_tclMsgControlMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CONTROLMETHODSTART;
}


diaglog_mainfi_tclMsgControlMethodStart::~diaglog_mainfi_tclMsgControlMethodStart()
{}

tU32 diaglog_mainfi_tclMsgControlMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgControlMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlParameter);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgControlMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlParameter);
   return oOut;
}

tBool diaglog_mainfi_tclMsgControlMethodStart::operator==(const diaglog_mainfi_tclMsgControlMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlParameter == roRef.ControlParameter);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgControlMethodResult::diaglog_mainfi_tclMsgControlMethodResult(const diaglog_mainfi_tclMsgControlMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgControlMethodResult& diaglog_mainfi_tclMsgControlMethodResult::operator=(const diaglog_mainfi_tclMsgControlMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgControlMethodResult::diaglog_mainfi_tclMsgControlMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgControlMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CONTROLMETHODRESULT;
}


diaglog_mainfi_tclMsgControlMethodResult::~diaglog_mainfi_tclMsgControlMethodResult()
{}

tU32 diaglog_mainfi_tclMsgControlMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgControlMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgControlMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgControlMethodResult::operator==(const diaglog_mainfi_tclMsgControlMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgControlDtcSettingMethodStart::diaglog_mainfi_tclMsgControlDtcSettingMethodStart(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ControlParameter = coRef.ControlParameter;
   DTC_List = coRef.DTC_List;
}
diaglog_mainfi_tclMsgControlDtcSettingMethodStart& diaglog_mainfi_tclMsgControlDtcSettingMethodStart::operator=(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& coRef)
{
   if (this == &coRef) return *this;
   ControlParameter = coRef.ControlParameter;
   DTC_List = coRef.DTC_List;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgControlDtcSettingMethodStart::vDestroy()
{
   DTC_List.vDestroy(); 
}

diaglog_mainfi_tclMsgControlDtcSettingMethodStart::diaglog_mainfi_tclMsgControlDtcSettingMethodStart()
:ControlParameter()
,DTC_List()
 {}

tS32 diaglog_mainfi_tclMsgControlDtcSettingMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODSTART;
}


diaglog_mainfi_tclMsgControlDtcSettingMethodStart::~diaglog_mainfi_tclMsgControlDtcSettingMethodStart()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgControlDtcSettingMethodStart::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+DTC_List.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgControlDtcSettingMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ControlParameter);
   (tVoid) (oIn >> DTC_List);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgControlDtcSettingMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ControlParameter);
   (tVoid) (oOut << DTC_List);
   return oOut;
}

tBool diaglog_mainfi_tclMsgControlDtcSettingMethodStart::operator==(const diaglog_mainfi_tclMsgControlDtcSettingMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ControlParameter == roRef.ControlParameter);
   bResult = bResult && (DTC_List == roRef.DTC_List);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgControlDtcSettingMethodResult::diaglog_mainfi_tclMsgControlDtcSettingMethodResult(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgControlDtcSettingMethodResult& diaglog_mainfi_tclMsgControlDtcSettingMethodResult::operator=(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& coRef)
{
   if (this == &coRef) return *this;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgControlDtcSettingMethodResult::diaglog_mainfi_tclMsgControlDtcSettingMethodResult()
:Status()
 {}

tS32 diaglog_mainfi_tclMsgControlDtcSettingMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_CONTROLDTCSETTINGMETHODRESULT;
}


diaglog_mainfi_tclMsgControlDtcSettingMethodResult::~diaglog_mainfi_tclMsgControlDtcSettingMethodResult()
{}

tU32 diaglog_mainfi_tclMsgControlDtcSettingMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgControlDtcSettingMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgControlDtcSettingMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgControlDtcSettingMethodResult::operator==(const diaglog_mainfi_tclMsgControlDtcSettingMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
}
diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::operator=(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart()
:DefSetStateGroup()
,DefSetStateMode()
 {}

tS32 diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODSTART;
}


diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::~diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart()
{}

tU32 diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart::operator==(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodStart& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
}
diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::operator=(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& coRef)
{
   if (this == &coRef) return *this;
   DefSetStateGroup = coRef.DefSetStateGroup;
   DefSetStateMode = coRef.DefSetStateMode;
   DefSetStateSuccessful = coRef.DefSetStateSuccessful;
   DefSetStateFirstDifferentParameterId = coRef.DefSetStateFirstDifferentParameterId;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult()
:DefSetStateGroup()
,DefSetStateMode()
,DefSetStateSuccessful(0)
,DefSetStateFirstDifferentParameterId(0)
 {}

tS32 diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SETFACTORYSETTINGSNEWMETHODRESULT;
}


diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::~diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult()
{}

tU32 diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DefSetStateGroup);
   (tVoid) (oIn >> DefSetStateMode);
   (tVoid) (oIn >> DefSetStateSuccessful);
   (tVoid) (oIn >> DefSetStateFirstDifferentParameterId);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DefSetStateGroup);
   (tVoid) (oOut << DefSetStateMode);
   (tVoid) (oOut << DefSetStateSuccessful);
   (tVoid) (oOut << DefSetStateFirstDifferentParameterId);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult::operator==(const diaglog_mainfi_tclMsgSetFactorySettingsNewMethodResult& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DefSetStateGroup == roRef.DefSetStateGroup);
   bResult = bResult && (DefSetStateMode == roRef.DefSetStateMode);
   bResult = bResult && (DefSetStateSuccessful == roRef.DefSetStateSuccessful);
   bResult = bResult && (DefSetStateFirstDifferentParameterId == roRef.DefSetStateFirstDifferentParameterId);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDTCActiveGet::diaglog_mainfi_tclMsgDTCActiveGet(const diaglog_mainfi_tclMsgDTCActiveGet& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   IsDTCActive = coRef.IsDTCActive;
}
diaglog_mainfi_tclMsgDTCActiveGet& diaglog_mainfi_tclMsgDTCActiveGet::operator=(const diaglog_mainfi_tclMsgDTCActiveGet& coRef)
{
   if (this == &coRef) return *this;
   IsDTCActive = coRef.IsDTCActive;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDTCActiveGet::diaglog_mainfi_tclMsgDTCActiveGet()
:IsDTCActive(0)
 {}

tS32 diaglog_mainfi_tclMsgDTCActiveGet::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCACTIVEGET;
}


diaglog_mainfi_tclMsgDTCActiveGet::~diaglog_mainfi_tclMsgDTCActiveGet()
{}

tU32 diaglog_mainfi_tclMsgDTCActiveGet::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& diaglog_mainfi_tclMsgDTCActiveGet::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsDTCActive);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDTCActiveGet::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsDTCActive);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDTCActiveGet::operator==(const diaglog_mainfi_tclMsgDTCActiveGet& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsDTCActive == roRef.IsDTCActive);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgDTCActiveUpReg::diaglog_mainfi_tclMsgDTCActiveUpReg()
 {}

tS32 diaglog_mainfi_tclMsgDTCActiveUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCACTIVEUPREG;
}


diaglog_mainfi_tclMsgDTCActiveUpReg::~diaglog_mainfi_tclMsgDTCActiveUpReg()
{}

//=============================================================================

diaglog_mainfi_tclMsgDTCActiveRelUpReg::diaglog_mainfi_tclMsgDTCActiveRelUpReg()
 {}

tS32 diaglog_mainfi_tclMsgDTCActiveRelUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCACTIVERELUPREG;
}


diaglog_mainfi_tclMsgDTCActiveRelUpReg::~diaglog_mainfi_tclMsgDTCActiveRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDTCActiveStatus::diaglog_mainfi_tclMsgDTCActiveStatus(const diaglog_mainfi_tclMsgDTCActiveStatus& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   IsDTCActive = coRef.IsDTCActive;
   DTC = coRef.DTC;
   DTCStatus = coRef.DTCStatus;
   DTCFailureType = coRef.DTCFailureType;
}
diaglog_mainfi_tclMsgDTCActiveStatus& diaglog_mainfi_tclMsgDTCActiveStatus::operator=(const diaglog_mainfi_tclMsgDTCActiveStatus& coRef)
{
   if (this == &coRef) return *this;
   IsDTCActive = coRef.IsDTCActive;
   DTC = coRef.DTC;
   DTCStatus = coRef.DTCStatus;
   DTCFailureType = coRef.DTCFailureType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDTCActiveStatus::diaglog_mainfi_tclMsgDTCActiveStatus()
:IsDTCActive(0)
,DTC(0)
,DTCStatus(0)
,DTCFailureType(0)
 {}

tS32 diaglog_mainfi_tclMsgDTCActiveStatus::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCACTIVESTATUS;
}


diaglog_mainfi_tclMsgDTCActiveStatus::~diaglog_mainfi_tclMsgDTCActiveStatus()
{}

tU32 diaglog_mainfi_tclMsgDTCActiveStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 7;
}

fi_tclInContext& diaglog_mainfi_tclMsgDTCActiveStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> IsDTCActive);
   (tVoid) (oIn >> DTC);
   (tVoid) (oIn >> DTCStatus);
   (tVoid) (oIn >> DTCFailureType);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDTCActiveStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << IsDTCActive);
   (tVoid) (oOut << DTC);
   (tVoid) (oOut << DTCStatus);
   (tVoid) (oOut << DTCFailureType);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDTCActiveStatus::operator==(const diaglog_mainfi_tclMsgDTCActiveStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (IsDTCActive == roRef.IsDTCActive);
   bResult = bResult && (DTC == roRef.DTC);
   bResult = bResult && (DTCStatus == roRef.DTCStatus);
   bResult = bResult && (DTCFailureType == roRef.DTCFailureType);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgSendNextTestResultUpReg::diaglog_mainfi_tclMsgSendNextTestResultUpReg()
 {}

tS32 diaglog_mainfi_tclMsgSendNextTestResultUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTUPREG;
}


diaglog_mainfi_tclMsgSendNextTestResultUpReg::~diaglog_mainfi_tclMsgSendNextTestResultUpReg()
{}

//=============================================================================

diaglog_mainfi_tclMsgSendNextTestResultRelUpReg::diaglog_mainfi_tclMsgSendNextTestResultRelUpReg()
 {}

tS32 diaglog_mainfi_tclMsgSendNextTestResultRelUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTRELUPREG;
}


diaglog_mainfi_tclMsgSendNextTestResultRelUpReg::~diaglog_mainfi_tclMsgSendNextTestResultRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSendNextTestResultStatus::diaglog_mainfi_tclMsgSendNextTestResultStatus(const diaglog_mainfi_tclMsgSendNextTestResultStatus& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   NextTestResultStruct = coRef.NextTestResultStruct;
   Status = coRef.Status;
}
diaglog_mainfi_tclMsgSendNextTestResultStatus& diaglog_mainfi_tclMsgSendNextTestResultStatus::operator=(const diaglog_mainfi_tclMsgSendNextTestResultStatus& coRef)
{
   if (this == &coRef) return *this;
   NextTestResultStruct = coRef.NextTestResultStruct;
   Status = coRef.Status;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgSendNextTestResultStatus::vDestroy()
{
   NextTestResultStruct.vDestroy(); 
}

diaglog_mainfi_tclMsgSendNextTestResultStatus::diaglog_mainfi_tclMsgSendNextTestResultStatus()
:NextTestResultStruct()
,Status(0)
 {}

tS32 diaglog_mainfi_tclMsgSendNextTestResultStatus::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDNEXTTESTRESULTSTATUS;
}


diaglog_mainfi_tclMsgSendNextTestResultStatus::~diaglog_mainfi_tclMsgSendNextTestResultStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgSendNextTestResultStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 1+NextTestResultStruct.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgSendNextTestResultStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> NextTestResultStruct);
   (tVoid) (oIn >> Status);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSendNextTestResultStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << NextTestResultStruct);
   (tVoid) (oOut << Status);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSendNextTestResultStatus::operator==(const diaglog_mainfi_tclMsgSendNextTestResultStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (NextTestResultStruct == roRef.NextTestResultStruct);
   bResult = bResult && (Status == roRef.Status);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgDTCTriggeredUpReg::diaglog_mainfi_tclMsgDTCTriggeredUpReg()
 {}

tS32 diaglog_mainfi_tclMsgDTCTriggeredUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDUPREG;
}


diaglog_mainfi_tclMsgDTCTriggeredUpReg::~diaglog_mainfi_tclMsgDTCTriggeredUpReg()
{}

//=============================================================================

diaglog_mainfi_tclMsgDTCTriggeredRelUpReg::diaglog_mainfi_tclMsgDTCTriggeredRelUpReg()
 {}

tS32 diaglog_mainfi_tclMsgDTCTriggeredRelUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDRELUPREG;
}


diaglog_mainfi_tclMsgDTCTriggeredRelUpReg::~diaglog_mainfi_tclMsgDTCTriggeredRelUpReg()
{}

//=============================================================================

diaglog_mainfi_tclMsgDTCTriggeredGet::diaglog_mainfi_tclMsgDTCTriggeredGet()
 {}

tS32 diaglog_mainfi_tclMsgDTCTriggeredGet::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDGET;
}


diaglog_mainfi_tclMsgDTCTriggeredGet::~diaglog_mainfi_tclMsgDTCTriggeredGet()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDTCTriggeredStatus::diaglog_mainfi_tclMsgDTCTriggeredStatus(const diaglog_mainfi_tclMsgDTCTriggeredStatus& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   bDTCTriggeredFlag = coRef.bDTCTriggeredFlag;
   u8DTCSource = coRef.u8DTCSource;
   u16DTCNumber = coRef.u16DTCNumber;
   u8DTCFailureType = coRef.u8DTCFailureType;
   bDTCWarningIndicatorRequestedStatus = coRef.bDTCWarningIndicatorRequestedStatus;
   bDTCTestFailedSincePowerUpStatus = coRef.bDTCTestFailedSincePowerUpStatus;
   bDTCTestNotPassedSincePowerUpStatus = coRef.bDTCTestNotPassedSincePowerUpStatus;
   bDTCHistoryStatus = coRef.bDTCHistoryStatus;
   bDTCTestFailedSinceCodeClearedStatus = coRef.bDTCTestFailedSinceCodeClearedStatus;
   bDTCTestNotPassedSinceCodeClearedStatus = coRef.bDTCTestNotPassedSinceCodeClearedStatus;
   bDTCCurrentStatus = coRef.bDTCCurrentStatus;
   bDTCCodeSupported = coRef.bDTCCodeSupported;
   e8DTCFaultType = coRef.e8DTCFaultType;
}
diaglog_mainfi_tclMsgDTCTriggeredStatus& diaglog_mainfi_tclMsgDTCTriggeredStatus::operator=(const diaglog_mainfi_tclMsgDTCTriggeredStatus& coRef)
{
   if (this == &coRef) return *this;
   bDTCTriggeredFlag = coRef.bDTCTriggeredFlag;
   u8DTCSource = coRef.u8DTCSource;
   u16DTCNumber = coRef.u16DTCNumber;
   u8DTCFailureType = coRef.u8DTCFailureType;
   bDTCWarningIndicatorRequestedStatus = coRef.bDTCWarningIndicatorRequestedStatus;
   bDTCTestFailedSincePowerUpStatus = coRef.bDTCTestFailedSincePowerUpStatus;
   bDTCTestNotPassedSincePowerUpStatus = coRef.bDTCTestNotPassedSincePowerUpStatus;
   bDTCHistoryStatus = coRef.bDTCHistoryStatus;
   bDTCTestFailedSinceCodeClearedStatus = coRef.bDTCTestFailedSinceCodeClearedStatus;
   bDTCTestNotPassedSinceCodeClearedStatus = coRef.bDTCTestNotPassedSinceCodeClearedStatus;
   bDTCCurrentStatus = coRef.bDTCCurrentStatus;
   bDTCCodeSupported = coRef.bDTCCodeSupported;
   e8DTCFaultType = coRef.e8DTCFaultType;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDTCTriggeredStatus::diaglog_mainfi_tclMsgDTCTriggeredStatus()
:bDTCTriggeredFlag(0)
,u8DTCSource(0)
,u16DTCNumber(0)
,u8DTCFailureType(0)
,bDTCWarningIndicatorRequestedStatus(0)
,bDTCTestFailedSincePowerUpStatus(0)
,bDTCTestNotPassedSincePowerUpStatus(0)
,bDTCHistoryStatus(0)
,bDTCTestFailedSinceCodeClearedStatus(0)
,bDTCTestNotPassedSinceCodeClearedStatus(0)
,bDTCCurrentStatus(0)
,bDTCCodeSupported(0)
,e8DTCFaultType()
 {}

tS32 diaglog_mainfi_tclMsgDTCTriggeredStatus::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCTRIGGEREDSTATUS;
}


diaglog_mainfi_tclMsgDTCTriggeredStatus::~diaglog_mainfi_tclMsgDTCTriggeredStatus()
{}

tU32 diaglog_mainfi_tclMsgDTCTriggeredStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 14;
}

fi_tclInContext& diaglog_mainfi_tclMsgDTCTriggeredStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> bDTCTriggeredFlag);
   (tVoid) (oIn >> u8DTCSource);
   (tVoid) (oIn >> u16DTCNumber);
   (tVoid) (oIn >> u8DTCFailureType);
   (tVoid) (oIn >> bDTCWarningIndicatorRequestedStatus);
   (tVoid) (oIn >> bDTCTestFailedSincePowerUpStatus);
   (tVoid) (oIn >> bDTCTestNotPassedSincePowerUpStatus);
   (tVoid) (oIn >> bDTCHistoryStatus);
   (tVoid) (oIn >> bDTCTestFailedSinceCodeClearedStatus);
   (tVoid) (oIn >> bDTCTestNotPassedSinceCodeClearedStatus);
   (tVoid) (oIn >> bDTCCurrentStatus);
   (tVoid) (oIn >> bDTCCodeSupported);
   (tVoid) (oIn >> e8DTCFaultType);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDTCTriggeredStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << bDTCTriggeredFlag);
   (tVoid) (oOut << u8DTCSource);
   (tVoid) (oOut << u16DTCNumber);
   (tVoid) (oOut << u8DTCFailureType);
   (tVoid) (oOut << bDTCWarningIndicatorRequestedStatus);
   (tVoid) (oOut << bDTCTestFailedSincePowerUpStatus);
   (tVoid) (oOut << bDTCTestNotPassedSincePowerUpStatus);
   (tVoid) (oOut << bDTCHistoryStatus);
   (tVoid) (oOut << bDTCTestFailedSinceCodeClearedStatus);
   (tVoid) (oOut << bDTCTestNotPassedSinceCodeClearedStatus);
   (tVoid) (oOut << bDTCCurrentStatus);
   (tVoid) (oOut << bDTCCodeSupported);
   (tVoid) (oOut << e8DTCFaultType);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDTCTriggeredStatus::operator==(const diaglog_mainfi_tclMsgDTCTriggeredStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (bDTCTriggeredFlag == roRef.bDTCTriggeredFlag);
   bResult = bResult && (u8DTCSource == roRef.u8DTCSource);
   bResult = bResult && (u16DTCNumber == roRef.u16DTCNumber);
   bResult = bResult && (u8DTCFailureType == roRef.u8DTCFailureType);
   bResult = bResult && (bDTCWarningIndicatorRequestedStatus == roRef.bDTCWarningIndicatorRequestedStatus);
   bResult = bResult && (bDTCTestFailedSincePowerUpStatus == roRef.bDTCTestFailedSincePowerUpStatus);
   bResult = bResult && (bDTCTestNotPassedSincePowerUpStatus == roRef.bDTCTestNotPassedSincePowerUpStatus);
   bResult = bResult && (bDTCHistoryStatus == roRef.bDTCHistoryStatus);
   bResult = bResult && (bDTCTestFailedSinceCodeClearedStatus == roRef.bDTCTestFailedSinceCodeClearedStatus);
   bResult = bResult && (bDTCTestNotPassedSinceCodeClearedStatus == roRef.bDTCTestNotPassedSinceCodeClearedStatus);
   bResult = bResult && (bDTCCurrentStatus == roRef.bDTCCurrentStatus);
   bResult = bResult && (bDTCCodeSupported == roRef.bDTCCodeSupported);
   bResult = bResult && (e8DTCFaultType == roRef.e8DTCFaultType);
   return bResult;
}

//=============================================================================

diaglog_mainfi_tclMsgSendActiveDTCListUpReg::diaglog_mainfi_tclMsgSendActiveDTCListUpReg()
 {}

tS32 diaglog_mainfi_tclMsgSendActiveDTCListUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTUPREG;
}


diaglog_mainfi_tclMsgSendActiveDTCListUpReg::~diaglog_mainfi_tclMsgSendActiveDTCListUpReg()
{}

//=============================================================================

diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg::diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg()
 {}

tS32 diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTRELUPREG;
}


diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg::~diaglog_mainfi_tclMsgSendActiveDTCListRelUpReg()
{}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgSendActiveDTCListStatus::diaglog_mainfi_tclMsgSendActiveDTCListStatus(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   ActiveDTCList = coRef.ActiveDTCList;
}
diaglog_mainfi_tclMsgSendActiveDTCListStatus& diaglog_mainfi_tclMsgSendActiveDTCListStatus::operator=(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& coRef)
{
   if (this == &coRef) return *this;
   ActiveDTCList = coRef.ActiveDTCList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tVoid diaglog_mainfi_tclMsgSendActiveDTCListStatus::vDestroy()
{
   ActiveDTCList.vDestroy(); 
}

diaglog_mainfi_tclMsgSendActiveDTCListStatus::diaglog_mainfi_tclMsgSendActiveDTCListStatus()
:ActiveDTCList()
 {}

tS32 diaglog_mainfi_tclMsgSendActiveDTCListStatus::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_SENDACTIVEDTCLISTSTATUS;
}


diaglog_mainfi_tclMsgSendActiveDTCListStatus::~diaglog_mainfi_tclMsgSendActiveDTCListStatus()
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   vDestroy();
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY
}

tU32 diaglog_mainfi_tclMsgSendActiveDTCListStatus::u32GetSize(tU16 u16MajorVersion) const
{
   return 0+ActiveDTCList.u32GetSize(u16MajorVersion);
}

fi_tclInContext& diaglog_mainfi_tclMsgSendActiveDTCListStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ActiveDTCList);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgSendActiveDTCListStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ActiveDTCList);
   return oOut;
}

tBool diaglog_mainfi_tclMsgSendActiveDTCListStatus::operator==(const diaglog_mainfi_tclMsgSendActiveDTCListStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (ActiveDTCList == roRef.ActiveDTCList);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDtcStatusChangedUpReg::diaglog_mainfi_tclMsgDtcStatusChangedUpReg(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
}
diaglog_mainfi_tclMsgDtcStatusChangedUpReg& diaglog_mainfi_tclMsgDtcStatusChangedUpReg::operator=(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDtcStatusChangedUpReg::diaglog_mainfi_tclMsgDtcStatusChangedUpReg()
:Group(0)
,DTCNumber(0)
,DTCStatusBitMask(0)
 {}

tS32 diaglog_mainfi_tclMsgDtcStatusChangedUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDUPREG;
}


diaglog_mainfi_tclMsgDtcStatusChangedUpReg::~diaglog_mainfi_tclMsgDtcStatusChangedUpReg()
{}

tU32 diaglog_mainfi_tclMsgDtcStatusChangedUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsgDtcStatusChangedUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCNumber);
   (tVoid) (oIn >> DTCStatusBitMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDtcStatusChangedUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCNumber);
   (tVoid) (oOut << DTCStatusBitMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDtcStatusChangedUpReg::operator==(const diaglog_mainfi_tclMsgDtcStatusChangedUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCNumber == roRef.DTCNumber);
   bResult = bResult && (DTCStatusBitMask == roRef.DTCStatusBitMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
}
diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::operator=(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& coRef)
{
   if (this == &coRef) return *this;
   Group = coRef.Group;
   DTCNumber = coRef.DTCNumber;
   DTCStatusBitMask = coRef.DTCStatusBitMask;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg()
:Group(0)
,DTCNumber(0)
,DTCStatusBitMask(0)
 {}

tS32 diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDRELUPREG;
}


diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::~diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg()
{}

tU32 diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Group);
   (tVoid) (oIn >> DTCNumber);
   (tVoid) (oIn >> DTCStatusBitMask);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Group);
   (tVoid) (oOut << DTCNumber);
   (tVoid) (oOut << DTCStatusBitMask);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg::operator==(const diaglog_mainfi_tclMsgDtcStatusChangedRelUpReg& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (Group == roRef.Group);
   bResult = bResult && (DTCNumber == roRef.DTCNumber);
   bResult = bResult && (DTCStatusBitMask == roRef.DTCStatusBitMask);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
diaglog_mainfi_tclMsgDtcStatusChangedStatus::diaglog_mainfi_tclMsgDtcStatusChangedStatus(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& coRef)
   : diaglog_mainfi_tclMsgBaseMessage(coRef)
{
   DTCResponse = coRef.DTCResponse;
}
diaglog_mainfi_tclMsgDtcStatusChangedStatus& diaglog_mainfi_tclMsgDtcStatusChangedStatus::operator=(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& coRef)
{
   if (this == &coRef) return *this;
   DTCResponse = coRef.DTCResponse;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

diaglog_mainfi_tclMsgDtcStatusChangedStatus::diaglog_mainfi_tclMsgDtcStatusChangedStatus()
:DTCResponse()
 {}

tS32 diaglog_mainfi_tclMsgDtcStatusChangedStatus::s32GetTypeId() const
{
   return (tS32) diaglog_mainfi_tclToken::EN_MSG_DTCSTATUSCHANGEDSTATUS;
}


diaglog_mainfi_tclMsgDtcStatusChangedStatus::~diaglog_mainfi_tclMsgDtcStatusChangedStatus()
{}

tU32 diaglog_mainfi_tclMsgDtcStatusChangedStatus::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 5;
}

fi_tclInContext& diaglog_mainfi_tclMsgDtcStatusChangedStatus::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> DTCResponse);
   return oIn;
}

fi_tclOutContext& diaglog_mainfi_tclMsgDtcStatusChangedStatus::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << DTCResponse);
   return oOut;
}

tBool diaglog_mainfi_tclMsgDtcStatusChangedStatus::operator==(const diaglog_mainfi_tclMsgDtcStatusChangedStatus& roRef) const
{
   tBool bResult = true;
   bResult = bResult && (DTCResponse == roRef.DTCResponse);
   return bResult;
}

