#ifndef DIAGLOG_MAINFILANGUAGE_HEADER
#define DIAGLOG_MAINFILANGUAGE_HEADER

class diaglog_mainfi_tclInContext;
class diaglog_mainfi_tclOutContext;
class diaglog_mainfi_tclVisitorBase;

class MY_DECL diaglog_mainfi_tclDescription {
 public:
  enum tenType { EN_PARSING, EN_GENERATING };	
  
  diaglog_mainfi_tclDescription(fi_tclInContext* poIn, diaglog_mainfi_tclVisitorBase* poVisit);
  diaglog_mainfi_tclDescription(fi_tclOutContext* poOut, diaglog_mainfi_tclVisitorBase* poVisit);
  
  /* --Hier kommen nun die Methoden, die einzelne Nachrichten entspr. NaFI 
		erzeugen (EN_GENERATING) bzw. einlesen (EN_PARSING). */

  tBool bInitMessage(diaglog_mainfi_tclToken::tenType enMsgToken);
  tBool bProcessMessage();

  // tBool bProcessElement(); 

  tBool bDoIt(diaglog_fi_tclVisitableTypeBase& poBaseType);
#ifndef FI_S_EXTERNAL_FI
  void vEnableSpecialBinContainer() { bUseSpecialBinContainer = true; }
#endif

 private:
  /* default constructor */ diaglog_mainfi_tclDescription();  //lint !e1704 // always use parameters
  tenType enType; //--read or write?

  union {
    fi_tclInContext* poInContext;
    fi_tclOutContext* poOutContext;
  };

  diaglog_mainfi_tclVisitorBase* poVisitor;

  // typedef navifi_tclTraversePath::tclKnot tclKnot;

  tBool bUseSpecialBinContainer;  
  
 public:
  
  // --Traversierungspfad
  fi_tclTraversePath<diaglog_mainfi_tclKnot> oPath;
  //   navifi_tclTraversePath oPath;
  fi_tclTraversePath<diaglog_mainfi_tclKnot> oCallStack;
   //  navifi_tclTraversePath oCallStack;
  
};

// --Inline-Implementierungen
inline diaglog_mainfi_tclDescription::diaglog_mainfi_tclDescription(fi_tclInContext* poIn, diaglog_mainfi_tclVisitorBase* poVisit):
  enType(EN_PARSING),poInContext(poIn),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

inline diaglog_mainfi_tclDescription::diaglog_mainfi_tclDescription(fi_tclOutContext* poOut, diaglog_mainfi_tclVisitorBase* poVisit):
  enType(EN_GENERATING),poOutContext(poOut),poVisitor(poVisit),bUseSpecialBinContainer(false) {}

#endif

