
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclVehDataProfile.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageSyncSource"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataProfileLanguageSyncSource::dp_tclVehDataProfileLanguageSyncSource(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageSyncSource,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataProfileLanguageSyncSource::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageSyncSource",(tS32) 0xa1d05292);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageSyncSource = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataProfileLanguageSyncSource::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageSyncSource", (tS32)0xa1d05292);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageSyncSource, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataProfileLanguageSyncSource::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataProfileLanguageSyncSource::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataProfileLanguageSyncSource::tGetData() {
   vUpdate();
   return tLanguageSyncSource;
};
tS32 dp_tclVehDataProfileLanguageSyncSource::s32GetData(tU8& tLanguageSyncSourceParam) { 
   vUpdate();
   tLanguageSyncSourceParam = tLanguageSyncSource;
   return _s32Status;
}
tS32 dp_tclVehDataProfileLanguageSyncSource::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageSyncSource", (tS32)0xa1d05292);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataProfileLanguageSyncSource::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataProfileLanguageSyncSource::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataProfileLanguageSyncSource::s32SetData(tU8 &tLanguageSyncSourceParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageSyncSource,(tVoid*)&tLanguageSyncSourceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageSyncSourceParam' in function 'dp_tclVehDataProfileLanguageSyncSource::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataProfileLanguageSyncSource::s32SetData(const tU8 &tLanguageSyncSourceParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageSyncSource,(tVoid*)&tLanguageSyncSourceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageSyncSourceParam' in function 'dp_tclVehDataProfileLanguageSyncSource::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataProfileLanguageSyncSource::u8GetData(tU8& tLanguageSyncSourceParam) {  
   vUpdate();
   tLanguageSyncSourceParam = tLanguageSyncSource;
   return _u8DataStatus;
}
tVoid dp_tclVehDataProfileLanguageSyncSource::vSetData(tU8 &tLanguageSyncSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageSyncSource,(tVoid*)&tLanguageSyncSourceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageSyncSourceParam' in function 'dp_tclVehDataProfileLanguageSyncSource::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataProfileLanguageSyncSource::vSetData(const tU8 &tLanguageSyncSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageSyncSource,(tVoid*)&tLanguageSyncSourceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageSyncSourceParam' in function 'dp_tclVehDataProfileLanguageSyncSource::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataProfileLanguageSyncSource::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataProfileLanguageSyncSource::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATAPROFILE, "LanguageSyncSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataProfileLanguageSyncSource::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATAPROFILE, "LanguageSyncSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataProfileLanguageSyncSource::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageSyncSource", DP_U32_POOL_ID_VEHDATAPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATAPROFILE);
   }
   else
   {
      fprintf(stdout,"Element LanguageSyncSource has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Language"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehDataProfileLanguage::dp_tclVehDataProfileLanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguage,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehDataProfileLanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Language",(tS32) 0x783904);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguage = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehDataProfileLanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Language", (tS32)0x783904);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguage, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehDataProfileLanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehDataProfileLanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehDataProfileLanguage::tGetData() {
   vUpdate();
   return tLanguage;
};
tS32 dp_tclVehDataProfileLanguage::s32GetData(tU8& tLanguageParam) { 
   vUpdate();
   tLanguageParam = tLanguage;
   return _s32Status;
}
tS32 dp_tclVehDataProfileLanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Language", (tS32)0x783904);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHDATAPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehDataProfileLanguage::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehDataProfileLanguage::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehDataProfileLanguage::s32SetData(tU8 &tLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tLanguage,(tVoid*)&tLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageParam' in function 'dp_tclVehDataProfileLanguage::vSetData(tU8)' could be made const reference
tS32 dp_tclVehDataProfileLanguage::s32SetData(const tU8 &tLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tLanguage,(tVoid*)&tLanguageParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageParam' in function 'dp_tclVehDataProfileLanguage::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehDataProfileLanguage::u8GetData(tU8& tLanguageParam) {  
   vUpdate();
   tLanguageParam = tLanguage;
   return _u8DataStatus;
}
tVoid dp_tclVehDataProfileLanguage::vSetData(tU8 &tLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguage,(tVoid*)&tLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageParam' in function 'dp_tclVehDataProfileLanguage::vSetData(tU8)' could be made const reference
tVoid dp_tclVehDataProfileLanguage::vSetData(const tU8 &tLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguage,(tVoid*)&tLanguageParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageParam' in function 'dp_tclVehDataProfileLanguage::vSetData(tU8)' could be made const reference
tU8   dp_tclVehDataProfileLanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehDataProfileLanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHDATAPROFILE, "Language", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataProfileLanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHDATAPROFILE, "Language", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehDataProfileLanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Language", DP_U32_POOL_ID_VEHDATAPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHDATAPROFILE);
   }
   else
   {
      fprintf(stdout,"Element Language has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
