#ifndef _DP_FI_VDCLOCKDP_H
#define _DP_FI_VDCLOCKDP_H

extern tVoid vInitVDClockDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclVDClockDpMasterModeOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tMasterModeOffset;
   
public:
   dp_tclVDClockDpMasterModeOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpMasterModeOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tMasterModeOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tMasterModeOffsetParam);
   tS32  s32SetData(const tS64 &tMasterModeOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tMasterModeOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tMasterModeOffsetParam);
   tVoid vSetData(const tS64& tMasterModeOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpAutoModeOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tAutoModeOffset;
   
public:
   dp_tclVDClockDpAutoModeOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpAutoModeOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tAutoModeOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tAutoModeOffsetParam);
   tS32  s32SetData(const tS64 &tAutoModeOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tAutoModeOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tAutoModeOffsetParam);
   tVoid vSetData(const tS64& tAutoModeOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpTimezoneIndex{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tTimezoneIndex;
   
public:
   dp_tclVDClockDpTimezoneIndex(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpTimezoneIndex() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tTimezoneIndexParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tTimezoneIndexParam);
   tS32  s32SetData(const tU16 &tTimezoneIndexParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tTimezoneIndexParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tTimezoneIndexParam);
   tVoid vSetData(const tU16& tTimezoneIndexParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbGPSAutoSync{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbGPSAutoSync;
   
public:
   dp_tclVDClockDpbGPSAutoSync(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbGPSAutoSync() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbGPSAutoSyncParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbGPSAutoSyncParam);
   tS32  s32SetData(const tBool &tbGPSAutoSyncParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbGPSAutoSyncParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbGPSAutoSyncParam);
   tVoid vSetData(const tBool& tbGPSAutoSyncParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbAutoEnabled{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbAutoEnabled;
   
public:
   dp_tclVDClockDpbAutoEnabled(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbAutoEnabled() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbAutoEnabledParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbAutoEnabledParam);
   tS32  s32SetData(const tBool &tbAutoEnabledParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbAutoEnabledParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbAutoEnabledParam);
   tVoid vSetData(const tBool& tbAutoEnabledParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbDST{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbDST;
   
public:
   dp_tclVDClockDpbDST(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbDST() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbDSTParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbDSTParam);
   tS32  s32SetData(const tBool &tbDSTParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbDSTParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbDSTParam);
   tVoid vSetData(const tBool& tbDSTParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbDSTAutoSet{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbDSTAutoSet;
   
public:
   dp_tclVDClockDpbDSTAutoSet(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbDSTAutoSet() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbDSTAutoSetParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbDSTAutoSetParam);
   tS32  s32SetData(const tBool &tbDSTAutoSetParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbDSTAutoSetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbDSTAutoSetParam);
   tVoid vSetData(const tBool& tbDSTAutoSetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpTimeformat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTimeformat;
   
public:
   dp_tclVDClockDpTimeformat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpTimeformat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTimeformatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTimeformatParam);
   tS32  s32SetData(const tU8 &tTimeformatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTimeformatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTimeformatParam);
   tVoid vSetData(const tU8& tTimeformatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpDateformat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDateformat;
   
public:
   dp_tclVDClockDpDateformat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpDateformat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDateformatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDateformatParam);
   tS32  s32SetData(const tU8 &tDateformatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDateformatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDateformatParam);
   tVoid vSetData(const tU8& tDateformatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpSyncmode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSyncmode;
   
public:
   dp_tclVDClockDpSyncmode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpSyncmode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSyncmodeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSyncmodeParam);
   tS32  s32SetData(const tU8 &tSyncmodeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSyncmodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSyncmodeParam);
   tVoid vSetData(const tU8& tSyncmodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbInitialStartup{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbInitialStartup;
   
public:
   dp_tclVDClockDpbInitialStartup(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbInitialStartup() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbInitialStartupParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbInitialStartupParam);
   tS32  s32SetData(const tBool &tbInitialStartupParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbInitialStartupParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbInitialStartupParam);
   tVoid vSetData(const tBool& tbInitialStartupParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpbDefaultSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tbDefaultSetting;
   
public:
   dp_tclVDClockDpbDefaultSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpbDefaultSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tbDefaultSettingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tbDefaultSettingParam);
   tS32  s32SetData(const tBool &tbDefaultSettingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tbDefaultSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tbDefaultSettingParam);
   tVoid vSetData(const tBool& tbDefaultSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpOffset_Hour{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tOffset_Hour;
   
public:
   dp_tclVDClockDpOffset_Hour(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpOffset_Hour() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tOffset_HourParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tOffset_HourParam);
   tS32  s32SetData(const tS64 &tOffset_HourParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tOffset_HourParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tOffset_HourParam);
   tVoid vSetData(const tS64& tOffset_HourParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpOffset_Minute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tOffset_Minute;
   
public:
   dp_tclVDClockDpOffset_Minute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpOffset_Minute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tOffset_MinuteParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tOffset_MinuteParam);
   tS32  s32SetData(const tS64 &tOffset_MinuteParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tOffset_MinuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tOffset_MinuteParam);
   tVoid vSetData(const tS64& tOffset_MinuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpDomain_AutoOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tDomain_AutoOffset;
   
public:
   dp_tclVDClockDpDomain_AutoOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpDomain_AutoOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tDomain_AutoOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tDomain_AutoOffsetParam);
   tS32  s32SetData(const tS64 &tDomain_AutoOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tDomain_AutoOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tDomain_AutoOffsetParam);
   tVoid vSetData(const tS64& tDomain_AutoOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpDomain_ManualOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tDomain_ManualOffset;
   
public:
   dp_tclVDClockDpDomain_ManualOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpDomain_ManualOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tDomain_ManualOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tDomain_ManualOffsetParam);
   tS32  s32SetData(const tS64 &tDomain_ManualOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tDomain_ManualOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tDomain_ManualOffsetParam);
   tVoid vSetData(const tS64& tDomain_ManualOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpDomain_TZOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tDomain_TZOffset;
   
public:
   dp_tclVDClockDpDomain_TZOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpDomain_TZOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tDomain_TZOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tDomain_TZOffsetParam);
   tS32  s32SetData(const tS64 &tDomain_TZOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tDomain_TZOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tDomain_TZOffsetParam);
   tVoid vSetData(const tS64& tDomain_TZOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVDClockDpAutoTZOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tS64 tAutoTZOffset;
   
public:
   dp_tclVDClockDpAutoTZOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVDClockDpAutoTZOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tS64 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tS64& tAutoTZOffsetParam);
   tVoid operator>>(tS64& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tS64 &tAutoTZOffsetParam);
   tS32  s32SetData(const tS64 &tAutoTZOffsetParam);
   tVoid operator<<(tS64 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tS64& tAutoTZOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tS64& tAutoTZOffsetParam);
   tVoid vSetData(const tS64& tAutoTZOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
