#ifndef _DP_FI_TMCTUNERUSRDP_H
#define _DP_FI_TMCTUNERUSRDP_H

extern tVoid vInitTmcTunerUsrDP(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclTmcTunerUsrDPAMAvailability{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAMAvailability;
   
public:
   dp_tclTmcTunerUsrDPAMAvailability(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclTmcTunerUsrDPAMAvailability() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAMAvailabilityParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAMAvailabilityParam);
   tS32  s32SetData(const tBool &tAMAvailabilityParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAMAvailabilityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAMAvailabilityParam);
   tVoid vSetData(const tBool& tAMAvailabilityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
