
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclTmcTunerUsrDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AMAvailability"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerUsrDPAMAvailability::dp_tclTmcTunerUsrDPAMAvailability(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0666;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAMAvailability,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerUsrDPAMAvailability::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AMAvailability",(tS32) 0xea155265);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERUSRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAMAvailability = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerUsrDPAMAvailability::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AMAvailability", (tS32)0xea155265);
   (tVoid)myDpElem.bFillData((tVoid*)&tAMAvailability, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERUSRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerUsrDPAMAvailability::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerUsrDPAMAvailability::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclTmcTunerUsrDPAMAvailability::tGetData() {
   vUpdate();
   return tAMAvailability;
};
tS32 dp_tclTmcTunerUsrDPAMAvailability::s32GetData(tBool& tAMAvailabilityParam) { 
   vUpdate();
   tAMAvailabilityParam = tAMAvailability;
   return _s32Status;
}
tS32 dp_tclTmcTunerUsrDPAMAvailability::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AMAvailability", (tS32)0xea155265);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERUSRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerUsrDPAMAvailability::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerUsrDPAMAvailability::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerUsrDPAMAvailability::s32SetData(tBool &tAMAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tAMAvailability,(tVoid*)&tAMAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAMAvailabilityParam' in function 'dp_tclTmcTunerUsrDPAMAvailability::vSetData(tBool)' could be made const reference
tS32 dp_tclTmcTunerUsrDPAMAvailability::s32SetData(const tBool &tAMAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tAMAvailability,(tVoid*)&tAMAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAMAvailabilityParam' in function 'dp_tclTmcTunerUsrDPAMAvailability::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerUsrDPAMAvailability::u8GetData(tBool& tAMAvailabilityParam) {  
   vUpdate();
   tAMAvailabilityParam = tAMAvailability;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerUsrDPAMAvailability::vSetData(tBool &tAMAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tAMAvailability,(tVoid*)&tAMAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAMAvailabilityParam' in function 'dp_tclTmcTunerUsrDPAMAvailability::vSetData(tBool)' could be made const reference
tVoid dp_tclTmcTunerUsrDPAMAvailability::vSetData(const tBool &tAMAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tAMAvailability,(tVoid*)&tAMAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAMAvailabilityParam' in function 'dp_tclTmcTunerUsrDPAMAvailability::vSetData(tBool)' could be made const reference
tU8   dp_tclTmcTunerUsrDPAMAvailability::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerUsrDPAMAvailability::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERUSRDP, "AMAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerUsrDPAMAvailability::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERUSRDP, "AMAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerUsrDPAMAvailability::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AMAvailability", DP_U32_POOL_ID_TMCTUNERUSRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERUSRDP);
   }
   else
   {
      fprintf(stdout,"Element AMAvailability has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
