
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclTmcTunerDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ADRConfigCRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPADRConfigCRC::dp_tclTmcTunerDPADRConfigCRC(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tADRConfigCRC,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPADRConfigCRC::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ADRConfigCRC",(tS32) 0xf0815909);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tADRConfigCRC = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPADRConfigCRC::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ADRConfigCRC", (tS32)0xf0815909);
   (tVoid)myDpElem.bFillData((tVoid*)&tADRConfigCRC, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPADRConfigCRC::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPADRConfigCRC::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclTmcTunerDPADRConfigCRC::tGetData() {
   vUpdate();
   return tADRConfigCRC;
};
tS32 dp_tclTmcTunerDPADRConfigCRC::s32GetData(tU32& tADRConfigCRCParam) { 
   vUpdate();
   tADRConfigCRCParam = tADRConfigCRC;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPADRConfigCRC::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ADRConfigCRC", (tS32)0xf0815909);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPADRConfigCRC::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPADRConfigCRC::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPADRConfigCRC::s32SetData(tU32 &tADRConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tADRConfigCRC,(tVoid*)&tADRConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tADRConfigCRCParam' in function 'dp_tclTmcTunerDPADRConfigCRC::vSetData(tU32)' could be made const reference
tS32 dp_tclTmcTunerDPADRConfigCRC::s32SetData(const tU32 &tADRConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tADRConfigCRC,(tVoid*)&tADRConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tADRConfigCRCParam' in function 'dp_tclTmcTunerDPADRConfigCRC::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPADRConfigCRC::u8GetData(tU32& tADRConfigCRCParam) {  
   vUpdate();
   tADRConfigCRCParam = tADRConfigCRC;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPADRConfigCRC::vSetData(tU32 &tADRConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tADRConfigCRC,(tVoid*)&tADRConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tADRConfigCRCParam' in function 'dp_tclTmcTunerDPADRConfigCRC::vSetData(tU32)' could be made const reference
tVoid dp_tclTmcTunerDPADRConfigCRC::vSetData(const tU32 &tADRConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tADRConfigCRC,(tVoid*)&tADRConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tADRConfigCRCParam' in function 'dp_tclTmcTunerDPADRConfigCRC::vSetData(tU32)' could be made const reference
tU8   dp_tclTmcTunerDPADRConfigCRC::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPADRConfigCRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "ADRConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPADRConfigCRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "ADRConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPADRConfigCRC::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ADRConfigCRC", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element ADRConfigCRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "KDSConfigCRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPKDSConfigCRC::dp_tclTmcTunerDPKDSConfigCRC(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tKDSConfigCRC,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPKDSConfigCRC::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("KDSConfigCRC",(tS32) 0xdb9bb10);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tKDSConfigCRC = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPKDSConfigCRC::vStore(tVoid) {
   dp_tclBaseElement myDpElem("KDSConfigCRC", (tS32)0xdb9bb10);
   (tVoid)myDpElem.bFillData((tVoid*)&tKDSConfigCRC, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPKDSConfigCRC::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPKDSConfigCRC::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclTmcTunerDPKDSConfigCRC::tGetData() {
   vUpdate();
   return tKDSConfigCRC;
};
tS32 dp_tclTmcTunerDPKDSConfigCRC::s32GetData(tU32& tKDSConfigCRCParam) { 
   vUpdate();
   tKDSConfigCRCParam = tKDSConfigCRC;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPKDSConfigCRC::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("KDSConfigCRC", (tS32)0xdb9bb10);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPKDSConfigCRC::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPKDSConfigCRC::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPKDSConfigCRC::s32SetData(tU32 &tKDSConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tKDSConfigCRC,(tVoid*)&tKDSConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKDSConfigCRCParam' in function 'dp_tclTmcTunerDPKDSConfigCRC::vSetData(tU32)' could be made const reference
tS32 dp_tclTmcTunerDPKDSConfigCRC::s32SetData(const tU32 &tKDSConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tKDSConfigCRC,(tVoid*)&tKDSConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tKDSConfigCRCParam' in function 'dp_tclTmcTunerDPKDSConfigCRC::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPKDSConfigCRC::u8GetData(tU32& tKDSConfigCRCParam) {  
   vUpdate();
   tKDSConfigCRCParam = tKDSConfigCRC;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPKDSConfigCRC::vSetData(tU32 &tKDSConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tKDSConfigCRC,(tVoid*)&tKDSConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tKDSConfigCRCParam' in function 'dp_tclTmcTunerDPKDSConfigCRC::vSetData(tU32)' could be made const reference
tVoid dp_tclTmcTunerDPKDSConfigCRC::vSetData(const tU32 &tKDSConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tKDSConfigCRC,(tVoid*)&tKDSConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tKDSConfigCRCParam' in function 'dp_tclTmcTunerDPKDSConfigCRC::vSetData(tU32)' could be made const reference
tU8   dp_tclTmcTunerDPKDSConfigCRC::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPKDSConfigCRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "KDSConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPKDSConfigCRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "KDSConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPKDSConfigCRC::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: KDSConfigCRC", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element KDSConfigCRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentDate"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPCurrentDate::dp_tclTmcTunerDPCurrentDate(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclTmcTunerDPCurrentDate::s32SetData(tString &tCurrentDateParam) {
   tU32 u32Len = (tU32)strlen(tCurrentDateParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CurrentDate", (tS32)0x37eca66d);
      (tVoid)myDpElem.bFillData((tVoid*)tCurrentDateParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPCurrentDate::s32SetData(const tString &tCurrentDateParam) {
   tU32 u32Len = (tU32)strlen(tCurrentDateParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CurrentDate", (tS32)0x37eca66d);
      (tVoid)myDpElem.bFillData((tVoid*)tCurrentDateParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPCurrentDate::s32GetData(tString &tCurrentDateParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CurrentDate", (tS32)0x37eca66d);
   (tVoid)memset(tCurrentDateParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCurrentDateParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPCurrentDate::s32GetData(const tString &tCurrentDateParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CurrentDate", (tS32)0x37eca66d);
   (tVoid)memset(tCurrentDateParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCurrentDateParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclTmcTunerDPCurrentDate::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclTmcTunerDPCurrentDate::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclTmcTunerDPCurrentDate::u32GetData(tString &tCurrentDateParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCurrentDateParam, u32StringBufLen);
   };
    tU32  dp_tclTmcTunerDPCurrentDate::u32GetData(const tString &tCurrentDateParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCurrentDateParam, u32StringBufLen);
   };
   tVoid dp_tclTmcTunerDPCurrentDate::vSetData(tString &tCurrentDateParam){(tVoid)s32SetData(tCurrentDateParam);};
   tVoid dp_tclTmcTunerDPCurrentDate::vSetData(const tString &tCurrentDateParam){(tVoid)s32SetData(tCurrentDateParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclTmcTunerDPCurrentDate::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "CurrentDate", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclTmcTunerDPCurrentDate::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "CurrentDate", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclTmcTunerDPCurrentDate::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentDate", DP_U32_POOL_ID_TMCTUNERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
		}
		else
		{
			fprintf(stdout,"Element CurrentDate has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AdrConfigCheckSum"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPAdrConfigCheckSum::dp_tclTmcTunerDPAdrConfigCheckSum(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdrConfigCheckSum,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPAdrConfigCheckSum::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AdrConfigCheckSum",(tS32) 0xb42d5830);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAdrConfigCheckSum = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPAdrConfigCheckSum::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AdrConfigCheckSum", (tS32)0xb42d5830);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdrConfigCheckSum, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPAdrConfigCheckSum::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPAdrConfigCheckSum::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclTmcTunerDPAdrConfigCheckSum::tGetData() {
   vUpdate();
   return tAdrConfigCheckSum;
};
tS32 dp_tclTmcTunerDPAdrConfigCheckSum::s32GetData(tU8& tAdrConfigCheckSumParam) { 
   vUpdate();
   tAdrConfigCheckSumParam = tAdrConfigCheckSum;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPAdrConfigCheckSum::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AdrConfigCheckSum", (tS32)0xb42d5830);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPAdrConfigCheckSum::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPAdrConfigCheckSum::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPAdrConfigCheckSum::s32SetData(tU8 &tAdrConfigCheckSumParam) {
   //init parameter
   (tVoid)memcpy(&tAdrConfigCheckSum,(tVoid*)&tAdrConfigCheckSumParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdrConfigCheckSumParam' in function 'dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(tU8)' could be made const reference
tS32 dp_tclTmcTunerDPAdrConfigCheckSum::s32SetData(const tU8 &tAdrConfigCheckSumParam) {
   //init parameter
   (tVoid)memcpy(&tAdrConfigCheckSum,(tVoid*)&tAdrConfigCheckSumParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdrConfigCheckSumParam' in function 'dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPAdrConfigCheckSum::u8GetData(tU8& tAdrConfigCheckSumParam) {  
   vUpdate();
   tAdrConfigCheckSumParam = tAdrConfigCheckSum;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(tU8 &tAdrConfigCheckSumParam) { 
   //init parameter
   (tVoid)memcpy(&tAdrConfigCheckSum,(tVoid*)&tAdrConfigCheckSumParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdrConfigCheckSumParam' in function 'dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(tU8)' could be made const reference
tVoid dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(const tU8 &tAdrConfigCheckSumParam) { 
   //init parameter
   (tVoid)memcpy(&tAdrConfigCheckSum,(tVoid*)&tAdrConfigCheckSumParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAdrConfigCheckSumParam' in function 'dp_tclTmcTunerDPAdrConfigCheckSum::vSetData(tU8)' could be made const reference
tU8   dp_tclTmcTunerDPAdrConfigCheckSum::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPAdrConfigCheckSum::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "AdrConfigCheckSum", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAdrConfigCheckSum::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "AdrConfigCheckSum", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAdrConfigCheckSum::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AdrConfigCheckSum", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element AdrConfigCheckSum has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AdrConfigCRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPAdrConfigCRC::dp_tclTmcTunerDPAdrConfigCRC(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAdrConfigCRC,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPAdrConfigCRC::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AdrConfigCRC",(tS32) 0x6db64c9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tAdrConfigCRC = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPAdrConfigCRC::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AdrConfigCRC", (tS32)0x6db64c9);
   (tVoid)myDpElem.bFillData((tVoid*)&tAdrConfigCRC, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPAdrConfigCRC::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPAdrConfigCRC::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclTmcTunerDPAdrConfigCRC::tGetData() {
   vUpdate();
   return tAdrConfigCRC;
};
tS32 dp_tclTmcTunerDPAdrConfigCRC::s32GetData(tU32& tAdrConfigCRCParam) { 
   vUpdate();
   tAdrConfigCRCParam = tAdrConfigCRC;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPAdrConfigCRC::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AdrConfigCRC", (tS32)0x6db64c9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPAdrConfigCRC::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPAdrConfigCRC::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPAdrConfigCRC::s32SetData(tU32 &tAdrConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tAdrConfigCRC,(tVoid*)&tAdrConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdrConfigCRCParam' in function 'dp_tclTmcTunerDPAdrConfigCRC::vSetData(tU32)' could be made const reference
tS32 dp_tclTmcTunerDPAdrConfigCRC::s32SetData(const tU32 &tAdrConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tAdrConfigCRC,(tVoid*)&tAdrConfigCRCParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAdrConfigCRCParam' in function 'dp_tclTmcTunerDPAdrConfigCRC::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPAdrConfigCRC::u8GetData(tU32& tAdrConfigCRCParam) {  
   vUpdate();
   tAdrConfigCRCParam = tAdrConfigCRC;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPAdrConfigCRC::vSetData(tU32 &tAdrConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tAdrConfigCRC,(tVoid*)&tAdrConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tAdrConfigCRCParam' in function 'dp_tclTmcTunerDPAdrConfigCRC::vSetData(tU32)' could be made const reference
tVoid dp_tclTmcTunerDPAdrConfigCRC::vSetData(const tU32 &tAdrConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tAdrConfigCRC,(tVoid*)&tAdrConfigCRCParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tAdrConfigCRCParam' in function 'dp_tclTmcTunerDPAdrConfigCRC::vSetData(tU32)' could be made const reference
tU8   dp_tclTmcTunerDPAdrConfigCRC::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPAdrConfigCRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "AdrConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAdrConfigCRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "AdrConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAdrConfigCRC::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AdrConfigCRC", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element AdrConfigCRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HWConfigCRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPHWConfigCRC::dp_tclTmcTunerDPHWConfigCRC(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tHWConfigCRC,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPHWConfigCRC::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("HWConfigCRC",(tS32) 0x363da1c9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tHWConfigCRC = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPHWConfigCRC::vStore(tVoid) {
   dp_tclBaseElement myDpElem("HWConfigCRC", (tS32)0x363da1c9);
   (tVoid)myDpElem.bFillData((tVoid*)&tHWConfigCRC, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPHWConfigCRC::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPHWConfigCRC::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclTmcTunerDPHWConfigCRC::tGetData() {
   vUpdate();
   return tHWConfigCRC;
};
tS32 dp_tclTmcTunerDPHWConfigCRC::s32GetData(tU8& tHWConfigCRCParam) { 
   vUpdate();
   tHWConfigCRCParam = tHWConfigCRC;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPHWConfigCRC::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("HWConfigCRC", (tS32)0x363da1c9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPHWConfigCRC::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPHWConfigCRC::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPHWConfigCRC::s32SetData(tU8 &tHWConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tHWConfigCRC,(tVoid*)&tHWConfigCRCParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHWConfigCRCParam' in function 'dp_tclTmcTunerDPHWConfigCRC::vSetData(tU8)' could be made const reference
tS32 dp_tclTmcTunerDPHWConfigCRC::s32SetData(const tU8 &tHWConfigCRCParam) {
   //init parameter
   (tVoid)memcpy(&tHWConfigCRC,(tVoid*)&tHWConfigCRCParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tHWConfigCRCParam' in function 'dp_tclTmcTunerDPHWConfigCRC::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPHWConfigCRC::u8GetData(tU8& tHWConfigCRCParam) {  
   vUpdate();
   tHWConfigCRCParam = tHWConfigCRC;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPHWConfigCRC::vSetData(tU8 &tHWConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tHWConfigCRC,(tVoid*)&tHWConfigCRCParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHWConfigCRCParam' in function 'dp_tclTmcTunerDPHWConfigCRC::vSetData(tU8)' could be made const reference
tVoid dp_tclTmcTunerDPHWConfigCRC::vSetData(const tU8 &tHWConfigCRCParam) { 
   //init parameter
   (tVoid)memcpy(&tHWConfigCRC,(tVoid*)&tHWConfigCRCParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tHWConfigCRCParam' in function 'dp_tclTmcTunerDPHWConfigCRC::vSetData(tU8)' could be made const reference
tU8   dp_tclTmcTunerDPHWConfigCRC::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPHWConfigCRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "HWConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPHWConfigCRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "HWConfigCRC", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPHWConfigCRC::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HWConfigCRC", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element HWConfigCRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ConfigVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPConfigVersion::dp_tclTmcTunerDPConfigVersion(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclTmcTunerDPConfigVersion::s32SetData(tString &tConfigVersionParam) {
   tU32 u32Len = (tU32)strlen(tConfigVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("ConfigVersion", (tS32)0x60f651e8);
      (tVoid)myDpElem.bFillData((tVoid*)tConfigVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPConfigVersion::s32SetData(const tString &tConfigVersionParam) {
   tU32 u32Len = (tU32)strlen(tConfigVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("ConfigVersion", (tS32)0x60f651e8);
      (tVoid)myDpElem.bFillData((tVoid*)tConfigVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPConfigVersion::s32GetData(tString &tConfigVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("ConfigVersion", (tS32)0x60f651e8);
   (tVoid)memset(tConfigVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tConfigVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclTmcTunerDPConfigVersion::s32GetData(const tString &tConfigVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("ConfigVersion", (tS32)0x60f651e8);
   (tVoid)memset(tConfigVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tConfigVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclTmcTunerDPConfigVersion::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclTmcTunerDPConfigVersion::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclTmcTunerDPConfigVersion::u32GetData(tString &tConfigVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tConfigVersionParam, u32StringBufLen);
   };
    tU32  dp_tclTmcTunerDPConfigVersion::u32GetData(const tString &tConfigVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tConfigVersionParam, u32StringBufLen);
   };
   tVoid dp_tclTmcTunerDPConfigVersion::vSetData(tString &tConfigVersionParam){(tVoid)s32SetData(tConfigVersionParam);};
   tVoid dp_tclTmcTunerDPConfigVersion::vSetData(const tString &tConfigVersionParam){(tVoid)s32SetData(tConfigVersionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclTmcTunerDPConfigVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "ConfigVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclTmcTunerDPConfigVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "ConfigVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclTmcTunerDPConfigVersion::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ConfigVersion", DP_U32_POOL_ID_TMCTUNERDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
		}
		else
		{
			fprintf(stdout,"Element ConfigVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VersionIdIsUpdated"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPVersionIdIsUpdated::dp_tclTmcTunerDPVersionIdIsUpdated(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVersionIdIsUpdated,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPVersionIdIsUpdated::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VersionIdIsUpdated",(tS32) 0xfa0c432e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tVersionIdIsUpdated = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPVersionIdIsUpdated::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VersionIdIsUpdated", (tS32)0xfa0c432e);
   (tVoid)myDpElem.bFillData((tVoid*)&tVersionIdIsUpdated, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPVersionIdIsUpdated::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPVersionIdIsUpdated::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclTmcTunerDPVersionIdIsUpdated::tGetData() {
   vUpdate();
   return tVersionIdIsUpdated;
};
tS32 dp_tclTmcTunerDPVersionIdIsUpdated::s32GetData(tBool& tVersionIdIsUpdatedParam) { 
   vUpdate();
   tVersionIdIsUpdatedParam = tVersionIdIsUpdated;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPVersionIdIsUpdated::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VersionIdIsUpdated", (tS32)0xfa0c432e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPVersionIdIsUpdated::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPVersionIdIsUpdated::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPVersionIdIsUpdated::s32SetData(tBool &tVersionIdIsUpdatedParam) {
   //init parameter
   (tVoid)memcpy(&tVersionIdIsUpdated,(tVoid*)&tVersionIdIsUpdatedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVersionIdIsUpdatedParam' in function 'dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(tBool)' could be made const reference
tS32 dp_tclTmcTunerDPVersionIdIsUpdated::s32SetData(const tBool &tVersionIdIsUpdatedParam) {
   //init parameter
   (tVoid)memcpy(&tVersionIdIsUpdated,(tVoid*)&tVersionIdIsUpdatedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVersionIdIsUpdatedParam' in function 'dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPVersionIdIsUpdated::u8GetData(tBool& tVersionIdIsUpdatedParam) {  
   vUpdate();
   tVersionIdIsUpdatedParam = tVersionIdIsUpdated;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(tBool &tVersionIdIsUpdatedParam) { 
   //init parameter
   (tVoid)memcpy(&tVersionIdIsUpdated,(tVoid*)&tVersionIdIsUpdatedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tVersionIdIsUpdatedParam' in function 'dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(tBool)' could be made const reference
tVoid dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(const tBool &tVersionIdIsUpdatedParam) { 
   //init parameter
   (tVoid)memcpy(&tVersionIdIsUpdated,(tVoid*)&tVersionIdIsUpdatedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tVersionIdIsUpdatedParam' in function 'dp_tclTmcTunerDPVersionIdIsUpdated::vSetData(tBool)' could be made const reference
tU8   dp_tclTmcTunerDPVersionIdIsUpdated::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPVersionIdIsUpdated::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "VersionIdIsUpdated", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPVersionIdIsUpdated::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "VersionIdIsUpdated", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPVersionIdIsUpdated::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VersionIdIsUpdated", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element VersionIdIsUpdated has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PresetListID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPPresetListID::dp_tclTmcTunerDPPresetListID(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPresetListID,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPPresetListID::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PresetListID",(tS32) 0x3a3868f4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tPresetListID = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPPresetListID::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PresetListID", (tS32)0x3a3868f4);
   (tVoid)myDpElem.bFillData((tVoid*)&tPresetListID, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPPresetListID::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPPresetListID::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclTmcTunerDPPresetListID::tGetData() {
   vUpdate();
   return tPresetListID;
};
tS32 dp_tclTmcTunerDPPresetListID::s32GetData(tU16& tPresetListIDParam) { 
   vUpdate();
   tPresetListIDParam = tPresetListID;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPPresetListID::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PresetListID", (tS32)0x3a3868f4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPPresetListID::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPPresetListID::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPPresetListID::s32SetData(tU16 &tPresetListIDParam) {
   //init parameter
   (tVoid)memcpy(&tPresetListID,(tVoid*)&tPresetListIDParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPresetListIDParam' in function 'dp_tclTmcTunerDPPresetListID::vSetData(tU16)' could be made const reference
tS32 dp_tclTmcTunerDPPresetListID::s32SetData(const tU16 &tPresetListIDParam) {
   //init parameter
   (tVoid)memcpy(&tPresetListID,(tVoid*)&tPresetListIDParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPresetListIDParam' in function 'dp_tclTmcTunerDPPresetListID::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPPresetListID::u8GetData(tU16& tPresetListIDParam) {  
   vUpdate();
   tPresetListIDParam = tPresetListID;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPPresetListID::vSetData(tU16 &tPresetListIDParam) { 
   //init parameter
   (tVoid)memcpy(&tPresetListID,(tVoid*)&tPresetListIDParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPresetListIDParam' in function 'dp_tclTmcTunerDPPresetListID::vSetData(tU16)' could be made const reference
tVoid dp_tclTmcTunerDPPresetListID::vSetData(const tU16 &tPresetListIDParam) { 
   //init parameter
   (tVoid)memcpy(&tPresetListID,(tVoid*)&tPresetListIDParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tPresetListIDParam' in function 'dp_tclTmcTunerDPPresetListID::vSetData(tU16)' could be made const reference
tU8   dp_tclTmcTunerDPPresetListID::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPPresetListID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "PresetListID", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPPresetListID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "PresetListID", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPPresetListID::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PresetListID", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element PresetListID has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ManualJapanAreaCode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPManualJapanAreaCode::dp_tclTmcTunerDPManualJapanAreaCode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tManualJapanAreaCode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPManualJapanAreaCode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ManualJapanAreaCode",(tS32) 0xe14ce788);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tManualJapanAreaCode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPManualJapanAreaCode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ManualJapanAreaCode", (tS32)0xe14ce788);
   (tVoid)myDpElem.bFillData((tVoid*)&tManualJapanAreaCode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPManualJapanAreaCode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPManualJapanAreaCode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclTmcTunerDPManualJapanAreaCode::tGetData() {
   vUpdate();
   return tManualJapanAreaCode;
};
tS32 dp_tclTmcTunerDPManualJapanAreaCode::s32GetData(tU8& tManualJapanAreaCodeParam) { 
   vUpdate();
   tManualJapanAreaCodeParam = tManualJapanAreaCode;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPManualJapanAreaCode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ManualJapanAreaCode", (tS32)0xe14ce788);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPManualJapanAreaCode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPManualJapanAreaCode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPManualJapanAreaCode::s32SetData(tU8 &tManualJapanAreaCodeParam) {
   //init parameter
   (tVoid)memcpy(&tManualJapanAreaCode,(tVoid*)&tManualJapanAreaCodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tManualJapanAreaCodeParam' in function 'dp_tclTmcTunerDPManualJapanAreaCode::vSetData(tU8)' could be made const reference
tS32 dp_tclTmcTunerDPManualJapanAreaCode::s32SetData(const tU8 &tManualJapanAreaCodeParam) {
   //init parameter
   (tVoid)memcpy(&tManualJapanAreaCode,(tVoid*)&tManualJapanAreaCodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tManualJapanAreaCodeParam' in function 'dp_tclTmcTunerDPManualJapanAreaCode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPManualJapanAreaCode::u8GetData(tU8& tManualJapanAreaCodeParam) {  
   vUpdate();
   tManualJapanAreaCodeParam = tManualJapanAreaCode;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPManualJapanAreaCode::vSetData(tU8 &tManualJapanAreaCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tManualJapanAreaCode,(tVoid*)&tManualJapanAreaCodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tManualJapanAreaCodeParam' in function 'dp_tclTmcTunerDPManualJapanAreaCode::vSetData(tU8)' could be made const reference
tVoid dp_tclTmcTunerDPManualJapanAreaCode::vSetData(const tU8 &tManualJapanAreaCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tManualJapanAreaCode,(tVoid*)&tManualJapanAreaCodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tManualJapanAreaCodeParam' in function 'dp_tclTmcTunerDPManualJapanAreaCode::vSetData(tU8)' could be made const reference
tU8   dp_tclTmcTunerDPManualJapanAreaCode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPManualJapanAreaCode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "ManualJapanAreaCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPManualJapanAreaCode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "ManualJapanAreaCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPManualJapanAreaCode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ManualJapanAreaCode", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element ManualJapanAreaCode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AutomaticJapanAreaCode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPAutomaticJapanAreaCode::dp_tclTmcTunerDPAutomaticJapanAreaCode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAutomaticJapanAreaCode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AutomaticJapanAreaCode",(tS32) 0x72bcd085);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAutomaticJapanAreaCode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AutomaticJapanAreaCode", (tS32)0x72bcd085);
   (tVoid)myDpElem.bFillData((tVoid*)&tAutomaticJapanAreaCode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPAutomaticJapanAreaCode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPAutomaticJapanAreaCode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclTmcTunerDPAutomaticJapanAreaCode::tGetData() {
   vUpdate();
   return tAutomaticJapanAreaCode;
};
tS32 dp_tclTmcTunerDPAutomaticJapanAreaCode::s32GetData(tU8& tAutomaticJapanAreaCodeParam) { 
   vUpdate();
   tAutomaticJapanAreaCodeParam = tAutomaticJapanAreaCode;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPAutomaticJapanAreaCode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AutomaticJapanAreaCode", (tS32)0x72bcd085);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPAutomaticJapanAreaCode::s32SetData(tU8 &tAutomaticJapanAreaCodeParam) {
   //init parameter
   (tVoid)memcpy(&tAutomaticJapanAreaCode,(tVoid*)&tAutomaticJapanAreaCodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutomaticJapanAreaCodeParam' in function 'dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(tU8)' could be made const reference
tS32 dp_tclTmcTunerDPAutomaticJapanAreaCode::s32SetData(const tU8 &tAutomaticJapanAreaCodeParam) {
   //init parameter
   (tVoid)memcpy(&tAutomaticJapanAreaCode,(tVoid*)&tAutomaticJapanAreaCodeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAutomaticJapanAreaCodeParam' in function 'dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPAutomaticJapanAreaCode::u8GetData(tU8& tAutomaticJapanAreaCodeParam) {  
   vUpdate();
   tAutomaticJapanAreaCodeParam = tAutomaticJapanAreaCode;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(tU8 &tAutomaticJapanAreaCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tAutomaticJapanAreaCode,(tVoid*)&tAutomaticJapanAreaCodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAutomaticJapanAreaCodeParam' in function 'dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(tU8)' could be made const reference
tVoid dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(const tU8 &tAutomaticJapanAreaCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tAutomaticJapanAreaCode,(tVoid*)&tAutomaticJapanAreaCodeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAutomaticJapanAreaCodeParam' in function 'dp_tclTmcTunerDPAutomaticJapanAreaCode::vSetData(tU8)' could be made const reference
tU8   dp_tclTmcTunerDPAutomaticJapanAreaCode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPAutomaticJapanAreaCode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "AutomaticJapanAreaCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAutomaticJapanAreaCode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "AutomaticJapanAreaCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPAutomaticJapanAreaCode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AutomaticJapanAreaCode", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element AutomaticJapanAreaCode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "JapanSelectionMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPJapanSelectionMode::dp_tclTmcTunerDPJapanSelectionMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tJapanSelectionMode,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPJapanSelectionMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("JapanSelectionMode",(tS32) 0x425dded5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tJapanSelectionMode = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPJapanSelectionMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("JapanSelectionMode", (tS32)0x425dded5);
   (tVoid)myDpElem.bFillData((tVoid*)&tJapanSelectionMode, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPJapanSelectionMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPJapanSelectionMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclTmcTunerDPJapanSelectionMode::tGetData() {
   vUpdate();
   return tJapanSelectionMode;
};
tS32 dp_tclTmcTunerDPJapanSelectionMode::s32GetData(tBool& tJapanSelectionModeParam) { 
   vUpdate();
   tJapanSelectionModeParam = tJapanSelectionMode;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPJapanSelectionMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("JapanSelectionMode", (tS32)0x425dded5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPJapanSelectionMode::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPJapanSelectionMode::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPJapanSelectionMode::s32SetData(tBool &tJapanSelectionModeParam) {
   //init parameter
   (tVoid)memcpy(&tJapanSelectionMode,(tVoid*)&tJapanSelectionModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tJapanSelectionModeParam' in function 'dp_tclTmcTunerDPJapanSelectionMode::vSetData(tBool)' could be made const reference
tS32 dp_tclTmcTunerDPJapanSelectionMode::s32SetData(const tBool &tJapanSelectionModeParam) {
   //init parameter
   (tVoid)memcpy(&tJapanSelectionMode,(tVoid*)&tJapanSelectionModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tJapanSelectionModeParam' in function 'dp_tclTmcTunerDPJapanSelectionMode::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPJapanSelectionMode::u8GetData(tBool& tJapanSelectionModeParam) {  
   vUpdate();
   tJapanSelectionModeParam = tJapanSelectionMode;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPJapanSelectionMode::vSetData(tBool &tJapanSelectionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tJapanSelectionMode,(tVoid*)&tJapanSelectionModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tJapanSelectionModeParam' in function 'dp_tclTmcTunerDPJapanSelectionMode::vSetData(tBool)' could be made const reference
tVoid dp_tclTmcTunerDPJapanSelectionMode::vSetData(const tBool &tJapanSelectionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tJapanSelectionMode,(tVoid*)&tJapanSelectionModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tJapanSelectionModeParam' in function 'dp_tclTmcTunerDPJapanSelectionMode::vSetData(tBool)' could be made const reference
tU8   dp_tclTmcTunerDPJapanSelectionMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPJapanSelectionMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "JapanSelectionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPJapanSelectionMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "JapanSelectionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPJapanSelectionMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: JapanSelectionMode", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element JapanSelectionMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LatitudeOnShutdown"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPLatitudeOnShutdown::dp_tclTmcTunerDPLatitudeOnShutdown(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLatitudeOnShutdown,0,sizeof(double));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPLatitudeOnShutdown::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LatitudeOnShutdown",(tS32) 0xec0e9c1d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(double)) 
      {
         tLatitudeOnShutdown = *((double*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPLatitudeOnShutdown::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LatitudeOnShutdown", (tS32)0xec0e9c1d);
   (tVoid)myDpElem.bFillData((tVoid*)&tLatitudeOnShutdown, (tU32)sizeof(double));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPLatitudeOnShutdown::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPLatitudeOnShutdown::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
double dp_tclTmcTunerDPLatitudeOnShutdown::tGetData() {
   vUpdate();
   return tLatitudeOnShutdown;
};
tS32 dp_tclTmcTunerDPLatitudeOnShutdown::s32GetData(double& tLatitudeOnShutdownParam) { 
   vUpdate();
   tLatitudeOnShutdownParam = tLatitudeOnShutdown;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPLatitudeOnShutdown::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LatitudeOnShutdown", (tS32)0xec0e9c1d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPLatitudeOnShutdown::operator>>(double& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPLatitudeOnShutdown::operator<<(double oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPLatitudeOnShutdown::s32SetData(double &tLatitudeOnShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tLatitudeOnShutdown,(tVoid*)&tLatitudeOnShutdownParam, sizeof(double));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLatitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(double)' could be made const reference
tS32 dp_tclTmcTunerDPLatitudeOnShutdown::s32SetData(const double &tLatitudeOnShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tLatitudeOnShutdown,(tVoid*)&tLatitudeOnShutdownParam, sizeof(double));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLatitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(double)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPLatitudeOnShutdown::u8GetData(double& tLatitudeOnShutdownParam) {  
   vUpdate();
   tLatitudeOnShutdownParam = tLatitudeOnShutdown;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(double &tLatitudeOnShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&tLatitudeOnShutdown,(tVoid*)&tLatitudeOnShutdownParam, sizeof(double));
   vStore();
}//lint !e1746: parameter 'tLatitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(double)' could be made const reference
tVoid dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(const double &tLatitudeOnShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&tLatitudeOnShutdown,(tVoid*)&tLatitudeOnShutdownParam, sizeof(double));
   vStore();
}//lint !e1746: parameter 'tLatitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLatitudeOnShutdown::vSetData(double)' could be made const reference
tU8   dp_tclTmcTunerDPLatitudeOnShutdown::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPLatitudeOnShutdown::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "LatitudeOnShutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPLatitudeOnShutdown::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "LatitudeOnShutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPLatitudeOnShutdown::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LatitudeOnShutdown", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element LatitudeOnShutdown has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LongitudeOnShutdown"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclTmcTunerDPLongitudeOnShutdown::dp_tclTmcTunerDPLongitudeOnShutdown(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLongitudeOnShutdown,0,sizeof(double));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclTmcTunerDPLongitudeOnShutdown::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LongitudeOnShutdown",(tS32) 0x36915e1c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(double)) 
      {
         tLongitudeOnShutdown = *((double*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclTmcTunerDPLongitudeOnShutdown::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LongitudeOnShutdown", (tS32)0x36915e1c);
   (tVoid)myDpElem.bFillData((tVoid*)&tLongitudeOnShutdown, (tU32)sizeof(double));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclTmcTunerDPLongitudeOnShutdown::s32GetStatus() const {return _s32Status;};
tU8   dp_tclTmcTunerDPLongitudeOnShutdown::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
double dp_tclTmcTunerDPLongitudeOnShutdown::tGetData() {
   vUpdate();
   return tLongitudeOnShutdown;
};
tS32 dp_tclTmcTunerDPLongitudeOnShutdown::s32GetData(double& tLongitudeOnShutdownParam) { 
   vUpdate();
   tLongitudeOnShutdownParam = tLongitudeOnShutdown;
   return _s32Status;
}
tS32 dp_tclTmcTunerDPLongitudeOnShutdown::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LongitudeOnShutdown", (tS32)0x36915e1c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_TMCTUNERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclTmcTunerDPLongitudeOnShutdown::operator>>(double& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclTmcTunerDPLongitudeOnShutdown::operator<<(double oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclTmcTunerDPLongitudeOnShutdown::s32SetData(double &tLongitudeOnShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tLongitudeOnShutdown,(tVoid*)&tLongitudeOnShutdownParam, sizeof(double));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLongitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(double)' could be made const reference
tS32 dp_tclTmcTunerDPLongitudeOnShutdown::s32SetData(const double &tLongitudeOnShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tLongitudeOnShutdown,(tVoid*)&tLongitudeOnShutdownParam, sizeof(double));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLongitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(double)' could be made const reference
// do not use --> old interface
tU8 dp_tclTmcTunerDPLongitudeOnShutdown::u8GetData(double& tLongitudeOnShutdownParam) {  
   vUpdate();
   tLongitudeOnShutdownParam = tLongitudeOnShutdown;
   return _u8DataStatus;
}
tVoid dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(double &tLongitudeOnShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&tLongitudeOnShutdown,(tVoid*)&tLongitudeOnShutdownParam, sizeof(double));
   vStore();
}//lint !e1746: parameter 'tLongitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(double)' could be made const reference
tVoid dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(const double &tLongitudeOnShutdownParam) { 
   //init parameter
   (tVoid)memcpy(&tLongitudeOnShutdown,(tVoid*)&tLongitudeOnShutdownParam, sizeof(double));
   vStore();
}//lint !e1746: parameter 'tLongitudeOnShutdownParam' in function 'dp_tclTmcTunerDPLongitudeOnShutdown::vSetData(double)' could be made const reference
tU8   dp_tclTmcTunerDPLongitudeOnShutdown::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclTmcTunerDPLongitudeOnShutdown::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_TMCTUNERDP, "LongitudeOnShutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPLongitudeOnShutdown::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_TMCTUNERDP, "LongitudeOnShutdown", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclTmcTunerDPLongitudeOnShutdown::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LongitudeOnShutdown", DP_U32_POOL_ID_TMCTUNERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_TMCTUNERDP);
   }
   else
   {
      fprintf(stdout,"Element LongitudeOnShutdown has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
