#ifndef _DP_FI_SRAM_ACCESS_IF_H
#define _DP_FI_SRAM_ACCESS_IF_H

#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif

#define DP_U32_SRAM_MAGIC 0x12345678

class dp_tclSramAccess{
public:
   dp_tclSramAccess(){};
   virtual ~dp_tclSramAccess();

   static tBool bWriteSRamData(tCString strDev, tU8* pu8Buf, tU32 u32Len,const void* pu8BufElement,void* pu8BufPosElement,tU32 u32LenElement);
   static tBool bReadSRamData(tCString strDev, tU8* pu8Buf, tU32 u32Len,void* pu8BufElement,const void* pu8BufPosElement,tU32 u32LenElement);

   struct TSram_fc_spm{
      tU32 u32Magic;
      tU32 tSystemState;
      tBool tUBatDropDetected;
      tU32 tIgnitionOffCount;
      tU32 tLastOsalElapsedTime;
      tU32 tLastVoltageLevel;
      tU16 tLastUbatSense;
      tU16 tLastWakeupReason;
      tU8 tResetSetBySpm;
      tU32 tContinuousResets;
      tBool tShutdownConfirmed;
      tU16 tResetsInShutdown;
      tBool tFakeDeviceConfig;
   };

   static TSram_fc_spm tSram_fc_spm;

};

#endif
