#include <pthread.h>

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC		   
#include "osal_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include "dp_tclSramAccessSPM.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
    #define ETG_DEFAULT_TRACE_CLASS DP_FI_TRACE_CLASS
    #include "trcGenProj/Header/dp_tclSramAccessSPM.cpp.trc.h"
#endif

//mutex for the process for read/write access for static member variables (threadsafe)
//http://cursuri.cs.pub.ro/~apc/2003/resources/pthreads/uguide/users-61.htm
//Mutex initialization using the PTHREAD_MUTEX_INITIALIZER does not immediately initialize the mutex. 
//Instead, on first use, the pthread_mutex_lock() or pthread_mutex_trylock() functions branch into a slow path 
//and cause the initialization of the mutex. 
//Because a mutex isn't just a simple memory object, and requires that some resources be allocated by the system, 
//an attempt to call pthread_mutex_destroy() or pthread_mutex_unlock() on a mutex that has was statically initialized using PTHREAD_MUTEX_INITIALER 
//and was not yet locked will result in an EINVAL error.
static pthread_mutex_t vhMutex = PTHREAD_MUTEX_INITIALIZER;

/*
*PSARCC30-887:Changes of "fc_spm" structure size mismatch b/w old & latest s/w flashed in target was not handled. 
*It caused for reading the wrong value of "tfakedeviceconfig" from PRAM   
*This issue was seen always in PSA project after the s/w update  
*Now this is properly handled 
*/
tBool dp_tclSramAccess::bReadSRamData(tCString strDev, tU8* pu8Buf, tU32 u32Len,void* pu8BufElement,const void* pu8BufPosElement,tU32 u32LenElement) 
{
  tBool bRet = FALSE;
  tBool bUpdateSRAM = FALSE;
  tU32 WrittenSize=0;  
  
  //lock
  if(pthread_mutex_lock(&vhMutex)!=0)
  {
    ETG_TRACE_ERR(("bReadSRamData::pthread_mutex_lock() error"));
  }
  //open PRAM device
    OSAL_tIODescriptor _hDevicePram = OSAL_IOOpen(strDev, OSAL_EN_READWRITE);
    if (OSAL_ERROR != _hDevicePram) 
    {
        tS32 ret = OSAL_s32IOControl(_hDevicePram, OSAL_C_S32_IOCTRL_DEV_PRAM_GET_WRITTEN_SIZE, (intptr_t)&WrittenSize); 
        /*Case 1: OSAL_ERROR  */          
        if (OSAL_ERROR == ret)
        {
            ETG_TRACE_USR4(("bReadSRamData::OSAL_C_S32_IOCTRL_DEV_PRAM_GET_WRITTEN_SIZE returns Error=0x%08x", (unsigned int)OSAL_u32ErrorCode()));
        }
        /*Case2: Target contains the data for "fc_spm" in PRAM..
        Note: Does not handle in Case if there is a Change in Structure is made such that the Used Structure 
        size "fc_spm" is Same*/
        else if (u32Len == (WrittenSize))
        {
            tPS8 Vp8BufRead=(tPS8)malloc(u32Len);
            if(Vp8BufRead==NULL)
            {
                ETG_TRACE_USR4(("bReadSRamData:: malloc fails"));
            }
            else
            {
                ret = OSAL_s32IOControl(_hDevicePram, OSAL_C_S32_IOCTRL_DEV_PRAM_SEEK, 0);     
                if (OSAL_ERROR == ret)
                {
                    ETG_TRACE_ERR(("bReadSRamData::SRAM_SEEK returns error 0x%08x during PRAM read ",(unsigned int)OSAL_u32ErrorCode()));
                }
                else
                {
                    ret = OSAL_s32IORead(_hDevicePram, Vp8BufRead, u32Len); 
                    if ((OSAL_ERROR != ret) && (u32Len == (tU32)ret) && (*(tU32*)Vp8BufRead == DP_U32_SRAM_MAGIC)) //lint !e826: Suspicious pointer-to-pointer conversion (area too small) --> even if pu8Buf < 4 value check will be correct, in this case magic will be wrong
                    {           
                        bRet = TRUE;
                        // copy read data to buffer
                        memmove(pu8Buf,Vp8BufRead,u32Len);
                        //copy element value to buffer
                        memmove(pu8BufElement,pu8BufPosElement,u32LenElement);         
                    }
                    else
                    {
                        if ( (*(tU32*)Vp8BufRead != DP_U32_SRAM_MAGIC))//lint !e826: Suspicious pointer-to-pointer conversion (area too small) 
                        {
                            ETG_TRACE_ERRMEM(("bReadSRamData::DP_U32_SRAM_MAGIC is not valid =0x%08x",(*(unsigned int*)Vp8BufRead)));//lint !e826: Suspicious pointer-to-pointer conversion (area too small) 
                        }
                        else if(OSAL_ERROR== ret)
                        {
                            ETG_TRACE_ERRMEM(("bReadSRamData::Read error.. Error=0x%08x",(unsigned int)OSAL_u32ErrorCode() ));
                        }
                        else if (u32Len != (tU32)ret) /*Unusual Case - Unknown Error */
                        {
                             ETG_TRACE_ERRMEM(("bReadSRamData::Read Len 0x%08x Expected Len 0x%08x", ret,(unsigned int)u32Len));
                        }

						ETG_TRACE_ERRMEM(("bReadSRamData::Update default value or last stored value in RAM buffer to PRAM "));
				        //This error case, have to update the default value or  last stored value in RAM buffer to PRAM 
                        bUpdateSRAM = TRUE;
                    }
                } 
                free(Vp8BufRead);
            }                        
        }
        // Case3: Target does not contain the data for "fc_spm" in PRAM.Consider the power off and then power ON sequence
        else if (0 == (WrittenSize))
        {
            ETG_TRACE_USR4(("bReadSRamData::Creating/updating new default data in PRAM "));
            bUpdateSRAM = TRUE;
        }
        // Case4: changes in "fc_spm"structure b/w the preious s/w and latest s/w flased in target
        else if(u32Len != (WrittenSize))
        {
            ETG_TRACE_USR4(("bReadSRamData::WrittenSize stored in PRAM is 0x%08x Expected Len 0x%08x", WrittenSize,(unsigned int)u32Len));
            ETG_TRACE_USR4(("bReadSRamData::Creating/updating new default data in PRAM due to structure size mismatch b/w old and latest s/w flashed in target"));
            bUpdateSRAM = TRUE;
        }
            
        //This case, have to update the default value or update last stored value in RAM buffer to PRAM 
        if(bUpdateSRAM)
        {
		    /* erase content */
    		ret = OSAL_s32IOControl(_hDevicePram, OSAL_C_S32_IOCTRL_DEV_PRAM_CLEAR, 0);
            
    		if(OSAL_ERROR != ret)
			{
                ret = OSAL_s32IOControl(_hDevicePram, OSAL_C_S32_IOCTRL_DEV_PRAM_SEEK, 0);            
                if (OSAL_ERROR == ret)
                {
                    ETG_TRACE_ERR(("bReadSRamData::SRAM_SEEK returns error 0x%08x during PRAM write",(unsigned int)OSAL_u32ErrorCode()));
                }
                else
                {
                    /*update the default value or update last stored value in buffer to PRAM */
                    ret = OSAL_s32IOWrite(_hDevicePram, (tPS8)pu8Buf, u32Len); 
                
                    if ((OSAL_ERROR != ret) && u32Len == (tU32)ret)
                    {      
                        bRet = TRUE;
                        //copy element value to buffer
                        memmove(pu8BufElement,pu8BufPosElement,u32LenElement); 
                    }
                    else
                    {
                        ETG_TRACE_ERRMEM(("bReadSRamData::SRAM_WRITE ERROR! Error=0x%08x ret=0x%08x", (unsigned int)OSAL_u32ErrorCode(),ret));
                    }
    			}
            }
			else
			{
                ETG_TRACE_ERR(("bReadSRamData::PRAM_CLEAR returns error 0x%08x during PRAM write",(unsigned int)OSAL_u32ErrorCode()));

			}		
                    
        }      
        //close device
        if (OSAL_OK != OSAL_s32IOClose(_hDevicePram)) 
        {

        }
    }
    else
    {
         ETG_TRACE_USR4(("bReadSRamData::PRAM_Open returns Error=0x%08x", (unsigned int)OSAL_u32ErrorCode()));   
    }
   //unlock
  if(pthread_mutex_unlock(&vhMutex)!=0)
  {
    ETG_TRACE_ERR(("bReadSRamData::pthread_mutex_unlock() error"));
  }
  return bRet;
}

tBool dp_tclSramAccess::bWriteSRamData(tCString strDev, tU8* pu8Buf, tU32 u32Len,const void* pu8BufElement,void* pu8BufPosElement,tU32 u32LenElement) 
{
  tBool bRet = FALSE;
  if(pthread_mutex_lock(&vhMutex)!=0)
  {
    ETG_TRACE_ERR(("bReadSRamData::pthread_mutex_lock() error"));
  } 
  //open PRAM device
  OSAL_tIODescriptor _hDevicePram = OSAL_IOOpen(strDev, OSAL_EN_READWRITE);
  
  if (OSAL_ERROR != _hDevicePram) 
  {
    tS32 ret = OSAL_s32IOControl(_hDevicePram, OSAL_C_S32_IOCTRL_DEV_PRAM_SEEK, 0);
    if (OSAL_ERROR == ret)
    {
       ETG_TRACE_USR4(("bWriteSRamData:SRAM_SEEK returns error, sram must be uninialized."));
    }
    else
    { //copy to buffer
      memmove(pu8BufPosElement,pu8BufElement,u32LenElement);     
      ret = OSAL_s32IOWrite(_hDevicePram, (tPS8) pu8Buf, u32Len);
      if ((OSAL_ERROR != ret) && u32Len == (tU32)ret)
      {
        bRet = TRUE;
      }
      else
      {
         ETG_TRACE_ERRMEM(("bWriteSRamData::SRAM_WRITE ERROR! Error=0x%08x ret=0x%08x", (unsigned int)OSAL_u32ErrorCode(),ret));
      }
    }
    //close device
    if (OSAL_OK != OSAL_s32IOClose(_hDevicePram)) 
    {
    }
  }
  //unlock
  if(pthread_mutex_unlock(&vhMutex)!=0)
  {
    ETG_TRACE_ERR(("bReadSRamData::pthread_mutex_unlock() error"));
  }
  return bRet;
}


//generated code for static member variables



dp_tclSramAccess::TSram_fc_spm dp_tclSramAccess::tSram_fc_spm={DP_U32_SRAM_MAGIC, 5, 1, 0, 0, 0, 0, 0, 255, 0, 1, 0, FALSE};
//EOF

