#ifndef _DP_FI_SPMDPINTERNDATA_H
#define _DP_FI_SPMDPINTERNDATA_H

extern tVoid vInitSpmDpInternData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750



#define SYSTEM_S_IMPORT_INTERFACE_DEQUE
#include "stl_pif.h"


class dp_tclSpmDpInternDataSysStateString{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclSpmDpInternDataSysStateString(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataSysStateString() {};

   //read access for pool element 
   tS32  s32GetData(tString &tSysStateStringParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tSysStateStringParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tSysStateStringParam);
   tS32 s32SetData(const tString &tSysStateStringParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tSysStateStringParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tSysStateStringParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tSysStateStringParam);
   tVoid vSetData(const tString &tSysStateStringParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataShutdownCounter{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tShutdownCounter;
   
public:
   dp_tclSpmDpInternDataShutdownCounter(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataShutdownCounter() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tShutdownCounterParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tShutdownCounterParam);
   tS32  s32SetData(const tU32 &tShutdownCounterParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tShutdownCounterParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tShutdownCounterParam);
   tVoid vSetData(const tU32& tShutdownCounterParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataConnectToBattery{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tConnectToBattery;
   
public:
   dp_tclSpmDpInternDataConnectToBattery(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataConnectToBattery() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tConnectToBatteryParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tConnectToBatteryParam);
   tS32  s32SetData(const tBool &tConnectToBatteryParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tConnectToBatteryParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tConnectToBatteryParam);
   tVoid vSetData(const tBool& tConnectToBatteryParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataConnectToBatteryCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tConnectToBatteryCount;
   
public:
   dp_tclSpmDpInternDataConnectToBatteryCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataConnectToBatteryCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tConnectToBatteryCountParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tConnectToBatteryCountParam);
   tS32  s32SetData(const tU16 &tConnectToBatteryCountParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tConnectToBatteryCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tConnectToBatteryCountParam);
   tVoid vSetData(const tU16& tConnectToBatteryCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataNetworkTimeoutCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tNetworkTimeoutCount;
   
public:
   dp_tclSpmDpInternDataNetworkTimeoutCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataNetworkTimeoutCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tNetworkTimeoutCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tNetworkTimeoutCountParam);
   tS32  s32SetData(const tU32 &tNetworkTimeoutCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tNetworkTimeoutCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tNetworkTimeoutCountParam);
   tVoid vSetData(const tU32& tNetworkTimeoutCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataNetworkTimeoutTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tNetworkTimeoutTime;
   
public:
   dp_tclSpmDpInternDataNetworkTimeoutTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataNetworkTimeoutTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tNetworkTimeoutTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tNetworkTimeoutTimeParam);
   tS32  s32SetData(const tU32 &tNetworkTimeoutTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tNetworkTimeoutTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tNetworkTimeoutTimeParam);
   tVoid vSetData(const tU32& tNetworkTimeoutTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataStartupConfig{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStartupConfig;
   
public:
   dp_tclSpmDpInternDataStartupConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataStartupConfig() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStartupConfigParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStartupConfigParam);
   tS32  s32SetData(const tU32 &tStartupConfigParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStartupConfigParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStartupConfigParam);
   tVoid vSetData(const tU32& tStartupConfigParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataEntertainMute{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tEntertainMute;
   
public:
   dp_tclSpmDpInternDataEntertainMute(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataEntertainMute() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tEntertainMuteParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tEntertainMuteParam);
   tS32  s32SetData(const tBool &tEntertainMuteParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tEntertainMuteParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tEntertainMuteParam);
   tVoid vSetData(const tBool& tEntertainMuteParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataMapDlLockApp{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tMapDlLockApp;
   
public:
   dp_tclSpmDpInternDataMapDlLockApp(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataMapDlLockApp() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tMapDlLockAppParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tMapDlLockAppParam);
   tS32  s32SetData(const tU16 &tMapDlLockAppParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tMapDlLockAppParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tMapDlLockAppParam);
   tVoid vSetData(const tU16& tMapDlLockAppParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataEmTraceVers{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TVersionStorage tEmTraceVers;
   
public:
   dp_tclSpmDpInternDataEmTraceVers(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataEmTraceVers() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TVersionStorage tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TVersionStorage& tEmTraceVersParam);
   tVoid operator>>(TVersionStorage& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TVersionStorage &tEmTraceVersParam);
   tS32  s32SetData(const TVersionStorage &tEmTraceVersParam);
   tVoid operator<<(TVersionStorage oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TVersionStorage& tEmTraceVersParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TVersionStorage& tEmTraceVersParam);
   tVoid vSetData(const TVersionStorage& tEmTraceVersParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataCurrentEmergencyOffCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCurrentEmergencyOffCount;
   
public:
   dp_tclSpmDpInternDataCurrentEmergencyOffCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataCurrentEmergencyOffCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCurrentEmergencyOffCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCurrentEmergencyOffCountParam);
   tS32  s32SetData(const tU32 &tCurrentEmergencyOffCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCurrentEmergencyOffCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCurrentEmergencyOffCountParam);
   tVoid vSetData(const tU32& tCurrentEmergencyOffCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataTriggerState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   TTriggerMsg tTriggerState;
   
public:
   dp_tclSpmDpInternDataTriggerState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataTriggerState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   TTriggerMsg tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(TTriggerMsg& tTriggerStateParam);
   tVoid operator>>(TTriggerMsg& oParam);
   
   //write access for pool element 
   tS32  s32SetData(TTriggerMsg &tTriggerStateParam);
   tS32  s32SetData(const TTriggerMsg &tTriggerStateParam);
   tVoid operator<<(TTriggerMsg oParam);
   
   // do not use --> old interface
   tU8   u8GetData(TTriggerMsg& tTriggerStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(TTriggerMsg& tTriggerStateParam);
   tVoid vSetData(const TTriggerMsg& tTriggerStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRestrictedDlLock{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TRestrictedDlLock> TListRestrictedDlLock;
    #else
    typedef std::deque<TRestrictedDlLock> TListRestrictedDlLock;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListRestrictedDlLock _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpInternDataRestrictedDlLock(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpInternDataRestrictedDlLock() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TRestrictedDlLock& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TRestrictedDlLock &tElem);
    tVoid vPushBack(const TRestrictedDlLock &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpInternDataDownloadLockStates{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<TDownloadLockStates> TListDownloadLockStates;
    #else
    typedef std::deque<TDownloadLockStates> TListDownloadLockStates;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListDownloadLockStates _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclSpmDpInternDataDownloadLockStates(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclSpmDpInternDataDownloadLockStates() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, TDownloadLockStates& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(TDownloadLockStates &tElem);
    tVoid vPushBack(const TDownloadLockStates &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclSpmDpInternDataCurrentSystemState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tCurrentSystemState;
   
public:
   dp_tclSpmDpInternDataCurrentSystemState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataCurrentSystemState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tCurrentSystemStateParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tCurrentSystemStateParam);
   tS32  s32SetData(const tU32 &tCurrentSystemStateParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tCurrentSystemStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tCurrentSystemStateParam);
   tVoid vSetData(const tU32& tCurrentSystemStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataSwBlockState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSwBlockState;
   
public:
   dp_tclSpmDpInternDataSwBlockState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataSwBlockState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSwBlockStateParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSwBlockStateParam);
   tS32  s32SetData(const tU32 &tSwBlockStateParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSwBlockStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSwBlockStateParam);
   tVoid vSetData(const tU32& tSwBlockStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRmtHBeatCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tRmtHBeatCount;
   
public:
   dp_tclSpmDpInternDataRmtHBeatCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataRmtHBeatCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tRmtHBeatCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tRmtHBeatCountParam);
   tS32  s32SetData(const tU32 &tRmtHBeatCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tRmtHBeatCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tRmtHBeatCountParam);
   tVoid vSetData(const tU32& tRmtHBeatCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRmtHBeatTotalCount{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tRmtHBeatTotalCount;
   
public:
   dp_tclSpmDpInternDataRmtHBeatTotalCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataRmtHBeatTotalCount() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tRmtHBeatTotalCountParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tRmtHBeatTotalCountParam);
   tS32  s32SetData(const tU32 &tRmtHBeatTotalCountParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tRmtHBeatTotalCountParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tRmtHBeatTotalCountParam);
   tVoid vSetData(const tU32& tRmtHBeatTotalCountParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRmtHBeatTs{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tRmtHBeatTs;
   
public:
   dp_tclSpmDpInternDataRmtHBeatTs(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataRmtHBeatTs() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tRmtHBeatTsParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tRmtHBeatTsParam);
   tS32  s32SetData(const tU32 &tRmtHBeatTsParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tRmtHBeatTsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tRmtHBeatTsParam);
   tVoid vSetData(const tU32& tRmtHBeatTsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRmtStartupState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tRmtStartupState;
   
public:
   dp_tclSpmDpInternDataRmtStartupState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataRmtStartupState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tRmtStartupStateParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tRmtStartupStateParam);
   tS32  s32SetData(const tU32 &tRmtStartupStateParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tRmtStartupStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tRmtStartupStateParam);
   tVoid vSetData(const tU32& tRmtStartupStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataRmtStartupTs{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tRmtStartupTs;
   
public:
   dp_tclSpmDpInternDataRmtStartupTs(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataRmtStartupTs() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tRmtStartupTsParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tRmtStartupTsParam);
   tS32  s32SetData(const tU32 &tRmtStartupTsParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tRmtStartupTsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tRmtStartupTsParam);
   tVoid vSetData(const tU32& tRmtStartupTsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpInternDataSystemState{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU32 tSystemState;
   

public:
   dp_tclSpmDpInternDataSystemState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataSystemState() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU32 &tSystemStateParam);
   tVoid vSetData(const tU32 &tSystemStateParam);
   tVoid operator<<(tU32 oParam);

   tU32 tGetData();
   tU8   u8GetData(tU32& tSystemStateParam);
   tVoid operator>>(tU32& oParam);

};

class dp_tclSpmDpInternDataUBatDropDetected{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tBool tUBatDropDetected;
   

public:
   dp_tclSpmDpInternDataUBatDropDetected(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataUBatDropDetected() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tBool &tUBatDropDetectedParam);
   tVoid vSetData(const tBool &tUBatDropDetectedParam);
   tVoid operator<<(tBool oParam);

   tBool tGetData();
   tU8   u8GetData(tBool& tUBatDropDetectedParam);
   tVoid operator>>(tBool& oParam);

};

class dp_tclSpmDpInternDataIgnitionOffCount{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU32 tIgnitionOffCount;
   

public:
   dp_tclSpmDpInternDataIgnitionOffCount(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataIgnitionOffCount() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU32 &tIgnitionOffCountParam);
   tVoid vSetData(const tU32 &tIgnitionOffCountParam);
   tVoid operator<<(tU32 oParam);

   tU32 tGetData();
   tU8   u8GetData(tU32& tIgnitionOffCountParam);
   tVoid operator>>(tU32& oParam);

};

class dp_tclSpmDpInternDataLastOsalElapsedTime{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU32 tLastOsalElapsedTime;
   

public:
   dp_tclSpmDpInternDataLastOsalElapsedTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataLastOsalElapsedTime() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU32 &tLastOsalElapsedTimeParam);
   tVoid vSetData(const tU32 &tLastOsalElapsedTimeParam);
   tVoid operator<<(tU32 oParam);

   tU32 tGetData();
   tU8   u8GetData(tU32& tLastOsalElapsedTimeParam);
   tVoid operator>>(tU32& oParam);

};

class dp_tclSpmDpInternDataLastVoltageLevel{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU32 tLastVoltageLevel;
   

public:
   dp_tclSpmDpInternDataLastVoltageLevel(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataLastVoltageLevel() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU32 &tLastVoltageLevelParam);
   tVoid vSetData(const tU32 &tLastVoltageLevelParam);
   tVoid operator<<(tU32 oParam);

   tU32 tGetData();
   tU8   u8GetData(tU32& tLastVoltageLevelParam);
   tVoid operator>>(tU32& oParam);

};

class dp_tclSpmDpInternDataLastUbatSense{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU16 tLastUbatSense;
   

public:
   dp_tclSpmDpInternDataLastUbatSense(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataLastUbatSense() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU16 &tLastUbatSenseParam);
   tVoid vSetData(const tU16 &tLastUbatSenseParam);
   tVoid operator<<(tU16 oParam);

   tU16 tGetData();
   tU8   u8GetData(tU16& tLastUbatSenseParam);
   tVoid operator>>(tU16& oParam);

};

class dp_tclSpmDpInternDataLastWakeupReason{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU16 tLastWakeupReason;
   

public:
   dp_tclSpmDpInternDataLastWakeupReason(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataLastWakeupReason() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU16 &tLastWakeupReasonParam);
   tVoid vSetData(const tU16 &tLastWakeupReasonParam);
   tVoid operator<<(tU16 oParam);

   tU16 tGetData();
   tU8   u8GetData(tU16& tLastWakeupReasonParam);
   tVoid operator>>(tU16& oParam);

};

class dp_tclSpmDpInternDataResetSetBySpm{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU8 tResetSetBySpm;
   

public:
   dp_tclSpmDpInternDataResetSetBySpm(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataResetSetBySpm() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU8 &tResetSetBySpmParam);
   tVoid vSetData(const tU8 &tResetSetBySpmParam);
   tVoid operator<<(tU8 oParam);

   tU8 tGetData();
   tU8   u8GetData(tU8& tResetSetBySpmParam);
   tVoid operator>>(tU8& oParam);

};

class dp_tclSpmDpInternDataContinuousResets{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU32 tContinuousResets;
   

public:
   dp_tclSpmDpInternDataContinuousResets(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataContinuousResets() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU32 &tContinuousResetsParam);
   tVoid vSetData(const tU32 &tContinuousResetsParam);
   tVoid operator<<(tU32 oParam);

   tU32 tGetData();
   tU8   u8GetData(tU32& tContinuousResetsParam);
   tVoid operator>>(tU32& oParam);

};

class dp_tclSpmDpInternDataShutdownConfirmed{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tBool tShutdownConfirmed;
   

public:
   dp_tclSpmDpInternDataShutdownConfirmed(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataShutdownConfirmed() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tBool &tShutdownConfirmedParam);
   tVoid vSetData(const tBool &tShutdownConfirmedParam);
   tVoid operator<<(tBool oParam);

   tBool tGetData();
   tU8   u8GetData(tBool& tShutdownConfirmedParam);
   tVoid operator>>(tBool& oParam);

};

class dp_tclSpmDpInternDataResetsInShutdown{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tU16 tResetsInShutdown;
   

public:
   dp_tclSpmDpInternDataResetsInShutdown(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpInternDataResetsInShutdown() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tU16 &tResetsInShutdownParam);
   tVoid vSetData(const tU16 &tResetsInShutdownParam);
   tVoid operator<<(tU16 oParam);

   tU16 tGetData();
   tU8   u8GetData(tU16& tResetsInShutdownParam);
   tVoid operator>>(tU16& oParam);

};

class dp_tclSpmDpInternDataCpuUsageCheckPeriodS{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU8 tCpuUsageCheckPeriodS;
   
public:
   dp_tclSpmDpInternDataCpuUsageCheckPeriodS();
   virtual ~dp_tclSpmDpInternDataCpuUsageCheckPeriodS(){};
   
   tU8 tGetData();
   tU8   u8GetData(tU8& tCpuUsageCheckPeriodSParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU8& oParam);


};

class dp_tclSpmDpInternDataDoApplicationProcessorReset{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tBool tDoApplicationProcessorReset;
   
public:
   dp_tclSpmDpInternDataDoApplicationProcessorReset();
   virtual ~dp_tclSpmDpInternDataDoApplicationProcessorReset(){};
   
   tBool tGetData();
   tU8   u8GetData(tBool& tDoApplicationProcessorResetParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tBool& oParam);


};

class dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU8 tThreadCpuUsagePerCoreThreshold;
   
public:
   dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold();
   virtual ~dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold(){};
   
   tU8 tGetData();
   tU8   u8GetData(tU8& tThreadCpuUsagePerCoreThresholdParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU8& oParam);


};

class dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuUsageNiceTimeoutMs;
   
public:
   dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs();
   virtual ~dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuUsageNiceTimeoutMsParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuUsageRealtimeTimeoutMs;
   
public:
   dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs();
   virtual ~dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuUsageRealtimeTimeoutMsParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpInternDataNicePriority{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tS8 tNicePriority;
   
public:
   dp_tclSpmDpInternDataNicePriority();
   virtual ~dp_tclSpmDpInternDataNicePriority(){};
   
   tS8 tGetData();
   tU8   u8GetData(tS8& tNicePriorityParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tS8& oParam);


};

class dp_tclSpmDpInternDataRealtimePriority{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tS8 tRealtimePriority;
   
public:
   dp_tclSpmDpInternDataRealtimePriority();
   virtual ~dp_tclSpmDpInternDataRealtimePriority(){};
   
   tS8 tGetData();
   tU8   u8GetData(tS8& tRealtimePriorityParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tS8& oParam);


};

class dp_tclSpmDpInternDataHwmCheckEnabled{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tHwmCheckEnabled;
   
public:
   dp_tclSpmDpInternDataHwmCheckEnabled();
   virtual ~dp_tclSpmDpInternDataHwmCheckEnabled(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tHwmCheckEnabledParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

#endif
