
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpInternData.h"

#include "dp_tclSramAccessSPM.h"

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SysStateString"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataSysStateString::dp_tclSpmDpInternDataSysStateString(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclSpmDpInternDataSysStateString::s32SetData(tString &tSysStateStringParam) {
   tU32 u32Len = (tU32)strlen(tSysStateStringParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("SysStateString", (tS32)0x7402b6b);
      (tVoid)myDpElem.bFillData((tVoid*)tSysStateStringParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpmDpInternDataSysStateString::s32SetData(const tString &tSysStateStringParam) {
   tU32 u32Len = (tU32)strlen(tSysStateStringParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("SysStateString", (tS32)0x7402b6b);
      (tVoid)myDpElem.bFillData((tVoid*)tSysStateStringParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpmDpInternDataSysStateString::s32GetData(tString &tSysStateStringParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("SysStateString", (tS32)0x7402b6b);
   (tVoid)memset(tSysStateStringParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tSysStateStringParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclSpmDpInternDataSysStateString::s32GetData(const tString &tSysStateStringParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("SysStateString", (tS32)0x7402b6b);
   (tVoid)memset(tSysStateStringParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tSysStateStringParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclSpmDpInternDataSysStateString::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpmDpInternDataSysStateString::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclSpmDpInternDataSysStateString::u32GetData(tString &tSysStateStringParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tSysStateStringParam, u32StringBufLen);
   };
    tU32  dp_tclSpmDpInternDataSysStateString::u32GetData(const tString &tSysStateStringParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tSysStateStringParam, u32StringBufLen);
   };
   tVoid dp_tclSpmDpInternDataSysStateString::vSetData(tString &tSysStateStringParam){(tVoid)s32SetData(tSysStateStringParam);};
   tVoid dp_tclSpmDpInternDataSysStateString::vSetData(const tString &tSysStateStringParam){(tVoid)s32SetData(tSysStateStringParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclSpmDpInternDataSysStateString::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "SysStateString", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpmDpInternDataSysStateString::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "SysStateString", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpmDpInternDataSysStateString::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SysStateString", DP_U32_POOL_ID_SPMDPINTERNDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
		}
		else
		{
			fprintf(stdout,"Element SysStateString has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ShutdownCounter"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataShutdownCounter::dp_tclSpmDpInternDataShutdownCounter(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tShutdownCounter,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataShutdownCounter::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ShutdownCounter",(tS32) 0xc4e650a8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tShutdownCounter = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataShutdownCounter::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ShutdownCounter", (tS32)0xc4e650a8);
   (tVoid)myDpElem.bFillData((tVoid*)&tShutdownCounter, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataShutdownCounter::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataShutdownCounter::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataShutdownCounter::tGetData() {
   vUpdate();
   return tShutdownCounter;
};
tS32 dp_tclSpmDpInternDataShutdownCounter::s32GetData(tU32& tShutdownCounterParam) { 
   vUpdate();
   tShutdownCounterParam = tShutdownCounter;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataShutdownCounter::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ShutdownCounter", (tS32)0xc4e650a8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataShutdownCounter::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataShutdownCounter::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataShutdownCounter::s32SetData(tU32 &tShutdownCounterParam) {
   //init parameter
   (tVoid)memcpy(&tShutdownCounter,(tVoid*)&tShutdownCounterParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tShutdownCounterParam' in function 'dp_tclSpmDpInternDataShutdownCounter::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataShutdownCounter::s32SetData(const tU32 &tShutdownCounterParam) {
   //init parameter
   (tVoid)memcpy(&tShutdownCounter,(tVoid*)&tShutdownCounterParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tShutdownCounterParam' in function 'dp_tclSpmDpInternDataShutdownCounter::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataShutdownCounter::u8GetData(tU32& tShutdownCounterParam) {  
   vUpdate();
   tShutdownCounterParam = tShutdownCounter;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataShutdownCounter::vSetData(tU32 &tShutdownCounterParam) { 
   //init parameter
   (tVoid)memcpy(&tShutdownCounter,(tVoid*)&tShutdownCounterParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tShutdownCounterParam' in function 'dp_tclSpmDpInternDataShutdownCounter::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataShutdownCounter::vSetData(const tU32 &tShutdownCounterParam) { 
   //init parameter
   (tVoid)memcpy(&tShutdownCounter,(tVoid*)&tShutdownCounterParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tShutdownCounterParam' in function 'dp_tclSpmDpInternDataShutdownCounter::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataShutdownCounter::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataShutdownCounter::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ShutdownCounter", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataShutdownCounter::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ShutdownCounter", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataShutdownCounter::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ShutdownCounter", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element ShutdownCounter has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ConnectToBattery"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataConnectToBattery::dp_tclSpmDpInternDataConnectToBattery(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tConnectToBattery,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataConnectToBattery::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ConnectToBattery",(tS32) 0xc1c13f28);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tConnectToBattery = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataConnectToBattery::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ConnectToBattery", (tS32)0xc1c13f28);
   (tVoid)myDpElem.bFillData((tVoid*)&tConnectToBattery, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataConnectToBattery::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataConnectToBattery::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpInternDataConnectToBattery::tGetData() {
   vUpdate();
   return tConnectToBattery;
};
tS32 dp_tclSpmDpInternDataConnectToBattery::s32GetData(tBool& tConnectToBatteryParam) { 
   vUpdate();
   tConnectToBatteryParam = tConnectToBattery;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataConnectToBattery::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ConnectToBattery", (tS32)0xc1c13f28);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataConnectToBattery::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataConnectToBattery::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataConnectToBattery::s32SetData(tBool &tConnectToBatteryParam) {
   //init parameter
   (tVoid)memcpy(&tConnectToBattery,(tVoid*)&tConnectToBatteryParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectToBatteryParam' in function 'dp_tclSpmDpInternDataConnectToBattery::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpInternDataConnectToBattery::s32SetData(const tBool &tConnectToBatteryParam) {
   //init parameter
   (tVoid)memcpy(&tConnectToBattery,(tVoid*)&tConnectToBatteryParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectToBatteryParam' in function 'dp_tclSpmDpInternDataConnectToBattery::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataConnectToBattery::u8GetData(tBool& tConnectToBatteryParam) {  
   vUpdate();
   tConnectToBatteryParam = tConnectToBattery;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataConnectToBattery::vSetData(tBool &tConnectToBatteryParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectToBattery,(tVoid*)&tConnectToBatteryParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tConnectToBatteryParam' in function 'dp_tclSpmDpInternDataConnectToBattery::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpInternDataConnectToBattery::vSetData(const tBool &tConnectToBatteryParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectToBattery,(tVoid*)&tConnectToBatteryParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tConnectToBatteryParam' in function 'dp_tclSpmDpInternDataConnectToBattery::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpInternDataConnectToBattery::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataConnectToBattery::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ConnectToBattery", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataConnectToBattery::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ConnectToBattery", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataConnectToBattery::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ConnectToBattery", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element ConnectToBattery has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ConnectToBatteryCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataConnectToBatteryCount::dp_tclSpmDpInternDataConnectToBatteryCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tConnectToBatteryCount,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataConnectToBatteryCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ConnectToBatteryCount",(tS32) 0x2bf8db15);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tConnectToBatteryCount = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataConnectToBatteryCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ConnectToBatteryCount", (tS32)0x2bf8db15);
   (tVoid)myDpElem.bFillData((tVoid*)&tConnectToBatteryCount, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataConnectToBatteryCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataConnectToBatteryCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclSpmDpInternDataConnectToBatteryCount::tGetData() {
   vUpdate();
   return tConnectToBatteryCount;
};
tS32 dp_tclSpmDpInternDataConnectToBatteryCount::s32GetData(tU16& tConnectToBatteryCountParam) { 
   vUpdate();
   tConnectToBatteryCountParam = tConnectToBatteryCount;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataConnectToBatteryCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ConnectToBatteryCount", (tS32)0x2bf8db15);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataConnectToBatteryCount::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataConnectToBatteryCount::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataConnectToBatteryCount::s32SetData(tU16 &tConnectToBatteryCountParam) {
   //init parameter
   (tVoid)memcpy(&tConnectToBatteryCount,(tVoid*)&tConnectToBatteryCountParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectToBatteryCountParam' in function 'dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(tU16)' could be made const reference
tS32 dp_tclSpmDpInternDataConnectToBatteryCount::s32SetData(const tU16 &tConnectToBatteryCountParam) {
   //init parameter
   (tVoid)memcpy(&tConnectToBatteryCount,(tVoid*)&tConnectToBatteryCountParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tConnectToBatteryCountParam' in function 'dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataConnectToBatteryCount::u8GetData(tU16& tConnectToBatteryCountParam) {  
   vUpdate();
   tConnectToBatteryCountParam = tConnectToBatteryCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(tU16 &tConnectToBatteryCountParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectToBatteryCount,(tVoid*)&tConnectToBatteryCountParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tConnectToBatteryCountParam' in function 'dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(tU16)' could be made const reference
tVoid dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(const tU16 &tConnectToBatteryCountParam) { 
   //init parameter
   (tVoid)memcpy(&tConnectToBatteryCount,(tVoid*)&tConnectToBatteryCountParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tConnectToBatteryCountParam' in function 'dp_tclSpmDpInternDataConnectToBatteryCount::vSetData(tU16)' could be made const reference
tU8   dp_tclSpmDpInternDataConnectToBatteryCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataConnectToBatteryCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ConnectToBatteryCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataConnectToBatteryCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "ConnectToBatteryCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataConnectToBatteryCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ConnectToBatteryCount", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element ConnectToBatteryCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NetworkTimeoutCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataNetworkTimeoutCount::dp_tclSpmDpInternDataNetworkTimeoutCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNetworkTimeoutCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NetworkTimeoutCount",(tS32) 0x4b03d9ee);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tNetworkTimeoutCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NetworkTimeoutCount", (tS32)0x4b03d9ee);
   (tVoid)myDpElem.bFillData((tVoid*)&tNetworkTimeoutCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataNetworkTimeoutCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataNetworkTimeoutCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataNetworkTimeoutCount::tGetData() {
   vUpdate();
   return tNetworkTimeoutCount;
};
tS32 dp_tclSpmDpInternDataNetworkTimeoutCount::s32GetData(tU32& tNetworkTimeoutCountParam) { 
   vUpdate();
   tNetworkTimeoutCountParam = tNetworkTimeoutCount;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataNetworkTimeoutCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NetworkTimeoutCount", (tS32)0x4b03d9ee);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataNetworkTimeoutCount::s32SetData(tU32 &tNetworkTimeoutCountParam) {
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutCount,(tVoid*)&tNetworkTimeoutCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNetworkTimeoutCountParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataNetworkTimeoutCount::s32SetData(const tU32 &tNetworkTimeoutCountParam) {
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutCount,(tVoid*)&tNetworkTimeoutCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNetworkTimeoutCountParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataNetworkTimeoutCount::u8GetData(tU32& tNetworkTimeoutCountParam) {  
   vUpdate();
   tNetworkTimeoutCountParam = tNetworkTimeoutCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(tU32 &tNetworkTimeoutCountParam) { 
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutCount,(tVoid*)&tNetworkTimeoutCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNetworkTimeoutCountParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(const tU32 &tNetworkTimeoutCountParam) { 
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutCount,(tVoid*)&tNetworkTimeoutCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNetworkTimeoutCountParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataNetworkTimeoutCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataNetworkTimeoutCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "NetworkTimeoutCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataNetworkTimeoutCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "NetworkTimeoutCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataNetworkTimeoutCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NetworkTimeoutCount", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element NetworkTimeoutCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NetworkTimeoutTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataNetworkTimeoutTime::dp_tclSpmDpInternDataNetworkTimeoutTime(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNetworkTimeoutTime,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NetworkTimeoutTime",(tS32) 0xa89a6638);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tNetworkTimeoutTime = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NetworkTimeoutTime", (tS32)0xa89a6638);
   (tVoid)myDpElem.bFillData((tVoid*)&tNetworkTimeoutTime, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataNetworkTimeoutTime::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataNetworkTimeoutTime::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataNetworkTimeoutTime::tGetData() {
   vUpdate();
   return tNetworkTimeoutTime;
};
tS32 dp_tclSpmDpInternDataNetworkTimeoutTime::s32GetData(tU32& tNetworkTimeoutTimeParam) { 
   vUpdate();
   tNetworkTimeoutTimeParam = tNetworkTimeoutTime;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataNetworkTimeoutTime::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NetworkTimeoutTime", (tS32)0xa89a6638);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataNetworkTimeoutTime::s32SetData(tU32 &tNetworkTimeoutTimeParam) {
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutTime,(tVoid*)&tNetworkTimeoutTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNetworkTimeoutTimeParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataNetworkTimeoutTime::s32SetData(const tU32 &tNetworkTimeoutTimeParam) {
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutTime,(tVoid*)&tNetworkTimeoutTimeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNetworkTimeoutTimeParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataNetworkTimeoutTime::u8GetData(tU32& tNetworkTimeoutTimeParam) {  
   vUpdate();
   tNetworkTimeoutTimeParam = tNetworkTimeoutTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(tU32 &tNetworkTimeoutTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutTime,(tVoid*)&tNetworkTimeoutTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNetworkTimeoutTimeParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(const tU32 &tNetworkTimeoutTimeParam) { 
   //init parameter
   (tVoid)memcpy(&tNetworkTimeoutTime,(tVoid*)&tNetworkTimeoutTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tNetworkTimeoutTimeParam' in function 'dp_tclSpmDpInternDataNetworkTimeoutTime::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataNetworkTimeoutTime::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataNetworkTimeoutTime::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "NetworkTimeoutTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataNetworkTimeoutTime::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "NetworkTimeoutTime", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataNetworkTimeoutTime::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NetworkTimeoutTime", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element NetworkTimeoutTime has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "StartupConfig"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataStartupConfig::dp_tclSpmDpInternDataStartupConfig(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tStartupConfig,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataStartupConfig::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("StartupConfig",(tS32) 0x5283862d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tStartupConfig = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataStartupConfig::vStore(tVoid) {
   dp_tclBaseElement myDpElem("StartupConfig", (tS32)0x5283862d);
   (tVoid)myDpElem.bFillData((tVoid*)&tStartupConfig, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataStartupConfig::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataStartupConfig::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataStartupConfig::tGetData() {
   vUpdate();
   return tStartupConfig;
};
tS32 dp_tclSpmDpInternDataStartupConfig::s32GetData(tU32& tStartupConfigParam) { 
   vUpdate();
   tStartupConfigParam = tStartupConfig;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataStartupConfig::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("StartupConfig", (tS32)0x5283862d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataStartupConfig::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataStartupConfig::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataStartupConfig::s32SetData(tU32 &tStartupConfigParam) {
   //init parameter
   (tVoid)memcpy(&tStartupConfig,(tVoid*)&tStartupConfigParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStartupConfigParam' in function 'dp_tclSpmDpInternDataStartupConfig::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataStartupConfig::s32SetData(const tU32 &tStartupConfigParam) {
   //init parameter
   (tVoid)memcpy(&tStartupConfig,(tVoid*)&tStartupConfigParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tStartupConfigParam' in function 'dp_tclSpmDpInternDataStartupConfig::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataStartupConfig::u8GetData(tU32& tStartupConfigParam) {  
   vUpdate();
   tStartupConfigParam = tStartupConfig;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataStartupConfig::vSetData(tU32 &tStartupConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tStartupConfig,(tVoid*)&tStartupConfigParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStartupConfigParam' in function 'dp_tclSpmDpInternDataStartupConfig::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataStartupConfig::vSetData(const tU32 &tStartupConfigParam) { 
   //init parameter
   (tVoid)memcpy(&tStartupConfig,(tVoid*)&tStartupConfigParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tStartupConfigParam' in function 'dp_tclSpmDpInternDataStartupConfig::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataStartupConfig::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataStartupConfig::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "StartupConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataStartupConfig::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "StartupConfig", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataStartupConfig::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: StartupConfig", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element StartupConfig has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EntertainMute"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataEntertainMute::dp_tclSpmDpInternDataEntertainMute(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEntertainMute,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataEntertainMute::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EntertainMute",(tS32) 0x7ecff571);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tEntertainMute = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataEntertainMute::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EntertainMute", (tS32)0x7ecff571);
   (tVoid)myDpElem.bFillData((tVoid*)&tEntertainMute, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataEntertainMute::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataEntertainMute::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpmDpInternDataEntertainMute::tGetData() {
   vUpdate();
   return tEntertainMute;
};
tS32 dp_tclSpmDpInternDataEntertainMute::s32GetData(tBool& tEntertainMuteParam) { 
   vUpdate();
   tEntertainMuteParam = tEntertainMute;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataEntertainMute::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EntertainMute", (tS32)0x7ecff571);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataEntertainMute::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataEntertainMute::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataEntertainMute::s32SetData(tBool &tEntertainMuteParam) {
   //init parameter
   (tVoid)memcpy(&tEntertainMute,(tVoid*)&tEntertainMuteParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEntertainMuteParam' in function 'dp_tclSpmDpInternDataEntertainMute::vSetData(tBool)' could be made const reference
tS32 dp_tclSpmDpInternDataEntertainMute::s32SetData(const tBool &tEntertainMuteParam) {
   //init parameter
   (tVoid)memcpy(&tEntertainMute,(tVoid*)&tEntertainMuteParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEntertainMuteParam' in function 'dp_tclSpmDpInternDataEntertainMute::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataEntertainMute::u8GetData(tBool& tEntertainMuteParam) {  
   vUpdate();
   tEntertainMuteParam = tEntertainMute;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataEntertainMute::vSetData(tBool &tEntertainMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tEntertainMute,(tVoid*)&tEntertainMuteParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tEntertainMuteParam' in function 'dp_tclSpmDpInternDataEntertainMute::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpInternDataEntertainMute::vSetData(const tBool &tEntertainMuteParam) { 
   //init parameter
   (tVoid)memcpy(&tEntertainMute,(tVoid*)&tEntertainMuteParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tEntertainMuteParam' in function 'dp_tclSpmDpInternDataEntertainMute::vSetData(tBool)' could be made const reference
tU8   dp_tclSpmDpInternDataEntertainMute::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataEntertainMute::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "EntertainMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataEntertainMute::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "EntertainMute", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataEntertainMute::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EntertainMute", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element EntertainMute has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MapDlLockApp"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataMapDlLockApp::dp_tclSpmDpInternDataMapDlLockApp(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMapDlLockApp,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataMapDlLockApp::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MapDlLockApp",(tS32) 0x27c81c54);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tMapDlLockApp = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataMapDlLockApp::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MapDlLockApp", (tS32)0x27c81c54);
   (tVoid)myDpElem.bFillData((tVoid*)&tMapDlLockApp, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataMapDlLockApp::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataMapDlLockApp::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclSpmDpInternDataMapDlLockApp::tGetData() {
   vUpdate();
   return tMapDlLockApp;
};
tS32 dp_tclSpmDpInternDataMapDlLockApp::s32GetData(tU16& tMapDlLockAppParam) { 
   vUpdate();
   tMapDlLockAppParam = tMapDlLockApp;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataMapDlLockApp::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MapDlLockApp", (tS32)0x27c81c54);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataMapDlLockApp::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataMapDlLockApp::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataMapDlLockApp::s32SetData(tU16 &tMapDlLockAppParam) {
   //init parameter
   (tVoid)memcpy(&tMapDlLockApp,(tVoid*)&tMapDlLockAppParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMapDlLockAppParam' in function 'dp_tclSpmDpInternDataMapDlLockApp::vSetData(tU16)' could be made const reference
tS32 dp_tclSpmDpInternDataMapDlLockApp::s32SetData(const tU16 &tMapDlLockAppParam) {
   //init parameter
   (tVoid)memcpy(&tMapDlLockApp,(tVoid*)&tMapDlLockAppParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMapDlLockAppParam' in function 'dp_tclSpmDpInternDataMapDlLockApp::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataMapDlLockApp::u8GetData(tU16& tMapDlLockAppParam) {  
   vUpdate();
   tMapDlLockAppParam = tMapDlLockApp;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataMapDlLockApp::vSetData(tU16 &tMapDlLockAppParam) { 
   //init parameter
   (tVoid)memcpy(&tMapDlLockApp,(tVoid*)&tMapDlLockAppParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMapDlLockAppParam' in function 'dp_tclSpmDpInternDataMapDlLockApp::vSetData(tU16)' could be made const reference
tVoid dp_tclSpmDpInternDataMapDlLockApp::vSetData(const tU16 &tMapDlLockAppParam) { 
   //init parameter
   (tVoid)memcpy(&tMapDlLockApp,(tVoid*)&tMapDlLockAppParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tMapDlLockAppParam' in function 'dp_tclSpmDpInternDataMapDlLockApp::vSetData(tU16)' could be made const reference
tU8   dp_tclSpmDpInternDataMapDlLockApp::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataMapDlLockApp::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "MapDlLockApp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataMapDlLockApp::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "MapDlLockApp", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataMapDlLockApp::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MapDlLockApp", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element MapDlLockApp has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EmTraceVers"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataEmTraceVers::dp_tclSpmDpInternDataEmTraceVers(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEmTraceVers,0,sizeof(TVersionStorage));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataEmTraceVers::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EmTraceVers",(tS32) 0x3773db01);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TVersionStorage)) 
      {
         tEmTraceVers = *((TVersionStorage*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataEmTraceVers::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EmTraceVers", (tS32)0x3773db01);
   (tVoid)myDpElem.bFillData((tVoid*)&tEmTraceVers, (tU32)sizeof(TVersionStorage));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataEmTraceVers::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataEmTraceVers::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TVersionStorage dp_tclSpmDpInternDataEmTraceVers::tGetData() {
   vUpdate();
   return tEmTraceVers;
};
tS32 dp_tclSpmDpInternDataEmTraceVers::s32GetData(TVersionStorage& tEmTraceVersParam) { 
   vUpdate();
   tEmTraceVersParam = tEmTraceVers;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataEmTraceVers::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EmTraceVers", (tS32)0x3773db01);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataEmTraceVers::operator>>(TVersionStorage& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataEmTraceVers::operator<<(TVersionStorage oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataEmTraceVers::s32SetData(TVersionStorage &tEmTraceVersParam) {
   //init parameter
   (tVoid)memcpy(&tEmTraceVers,(tVoid*)&tEmTraceVersParam, sizeof(TVersionStorage));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEmTraceVersParam' in function 'dp_tclSpmDpInternDataEmTraceVers::vSetData(TVersionStorage)' could be made const reference
tS32 dp_tclSpmDpInternDataEmTraceVers::s32SetData(const TVersionStorage &tEmTraceVersParam) {
   //init parameter
   (tVoid)memcpy(&tEmTraceVers,(tVoid*)&tEmTraceVersParam, sizeof(TVersionStorage));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEmTraceVersParam' in function 'dp_tclSpmDpInternDataEmTraceVers::vSetData(TVersionStorage)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataEmTraceVers::u8GetData(TVersionStorage& tEmTraceVersParam) {  
   vUpdate();
   tEmTraceVersParam = tEmTraceVers;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataEmTraceVers::vSetData(TVersionStorage &tEmTraceVersParam) { 
   //init parameter
   (tVoid)memcpy(&tEmTraceVers,(tVoid*)&tEmTraceVersParam, sizeof(TVersionStorage));
   vStore();
}//lint !e1746: parameter 'tEmTraceVersParam' in function 'dp_tclSpmDpInternDataEmTraceVers::vSetData(TVersionStorage)' could be made const reference
tVoid dp_tclSpmDpInternDataEmTraceVers::vSetData(const TVersionStorage &tEmTraceVersParam) { 
   //init parameter
   (tVoid)memcpy(&tEmTraceVers,(tVoid*)&tEmTraceVersParam, sizeof(TVersionStorage));
   vStore();
}//lint !e1746: parameter 'tEmTraceVersParam' in function 'dp_tclSpmDpInternDataEmTraceVers::vSetData(TVersionStorage)' could be made const reference
tU8   dp_tclSpmDpInternDataEmTraceVers::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataEmTraceVers::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "EmTraceVers", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataEmTraceVers::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "EmTraceVers", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataEmTraceVers::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EmTraceVers", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element EmTraceVers has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentEmergencyOffCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataCurrentEmergencyOffCount::dp_tclSpmDpInternDataCurrentEmergencyOffCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentEmergencyOffCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentEmergencyOffCount",(tS32) 0x1d7aac4a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentEmergencyOffCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentEmergencyOffCount", (tS32)0x1d7aac4a);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentEmergencyOffCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataCurrentEmergencyOffCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataCurrentEmergencyOffCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataCurrentEmergencyOffCount::tGetData() {
   vUpdate();
   return tCurrentEmergencyOffCount;
};
tS32 dp_tclSpmDpInternDataCurrentEmergencyOffCount::s32GetData(tU32& tCurrentEmergencyOffCountParam) { 
   vUpdate();
   tCurrentEmergencyOffCountParam = tCurrentEmergencyOffCount;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataCurrentEmergencyOffCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentEmergencyOffCount", (tS32)0x1d7aac4a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataCurrentEmergencyOffCount::s32SetData(tU32 &tCurrentEmergencyOffCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentEmergencyOffCount,(tVoid*)&tCurrentEmergencyOffCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentEmergencyOffCountParam' in function 'dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataCurrentEmergencyOffCount::s32SetData(const tU32 &tCurrentEmergencyOffCountParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentEmergencyOffCount,(tVoid*)&tCurrentEmergencyOffCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentEmergencyOffCountParam' in function 'dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataCurrentEmergencyOffCount::u8GetData(tU32& tCurrentEmergencyOffCountParam) {  
   vUpdate();
   tCurrentEmergencyOffCountParam = tCurrentEmergencyOffCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(tU32 &tCurrentEmergencyOffCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentEmergencyOffCount,(tVoid*)&tCurrentEmergencyOffCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentEmergencyOffCountParam' in function 'dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(const tU32 &tCurrentEmergencyOffCountParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentEmergencyOffCount,(tVoid*)&tCurrentEmergencyOffCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentEmergencyOffCountParam' in function 'dp_tclSpmDpInternDataCurrentEmergencyOffCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataCurrentEmergencyOffCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataCurrentEmergencyOffCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "CurrentEmergencyOffCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataCurrentEmergencyOffCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "CurrentEmergencyOffCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataCurrentEmergencyOffCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentEmergencyOffCount", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentEmergencyOffCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TriggerState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataTriggerState::dp_tclSpmDpInternDataTriggerState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTriggerState,0,sizeof(TTriggerMsg));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataTriggerState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TriggerState",(tS32) 0x460cbc05);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TTriggerMsg)) 
      {
         tTriggerState = *((TTriggerMsg*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataTriggerState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TriggerState", (tS32)0x460cbc05);
   (tVoid)myDpElem.bFillData((tVoid*)&tTriggerState, (tU32)sizeof(TTriggerMsg));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataTriggerState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataTriggerState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TTriggerMsg dp_tclSpmDpInternDataTriggerState::tGetData() {
   vUpdate();
   return tTriggerState;
};
tS32 dp_tclSpmDpInternDataTriggerState::s32GetData(TTriggerMsg& tTriggerStateParam) { 
   vUpdate();
   tTriggerStateParam = tTriggerState;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataTriggerState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TriggerState", (tS32)0x460cbc05);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataTriggerState::operator>>(TTriggerMsg& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataTriggerState::operator<<(TTriggerMsg oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataTriggerState::s32SetData(TTriggerMsg &tTriggerStateParam) {
   //init parameter
   (tVoid)memcpy(&tTriggerState,(tVoid*)&tTriggerStateParam, sizeof(TTriggerMsg));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTriggerStateParam' in function 'dp_tclSpmDpInternDataTriggerState::vSetData(TTriggerMsg)' could be made const reference
tS32 dp_tclSpmDpInternDataTriggerState::s32SetData(const TTriggerMsg &tTriggerStateParam) {
   //init parameter
   (tVoid)memcpy(&tTriggerState,(tVoid*)&tTriggerStateParam, sizeof(TTriggerMsg));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTriggerStateParam' in function 'dp_tclSpmDpInternDataTriggerState::vSetData(TTriggerMsg)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataTriggerState::u8GetData(TTriggerMsg& tTriggerStateParam) {  
   vUpdate();
   tTriggerStateParam = tTriggerState;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataTriggerState::vSetData(TTriggerMsg &tTriggerStateParam) { 
   //init parameter
   (tVoid)memcpy(&tTriggerState,(tVoid*)&tTriggerStateParam, sizeof(TTriggerMsg));
   vStore();
}//lint !e1746: parameter 'tTriggerStateParam' in function 'dp_tclSpmDpInternDataTriggerState::vSetData(TTriggerMsg)' could be made const reference
tVoid dp_tclSpmDpInternDataTriggerState::vSetData(const TTriggerMsg &tTriggerStateParam) { 
   //init parameter
   (tVoid)memcpy(&tTriggerState,(tVoid*)&tTriggerStateParam, sizeof(TTriggerMsg));
   vStore();
}//lint !e1746: parameter 'tTriggerStateParam' in function 'dp_tclSpmDpInternDataTriggerState::vSetData(TTriggerMsg)' could be made const reference
tU8   dp_tclSpmDpInternDataTriggerState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataTriggerState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "TriggerState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataTriggerState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "TriggerState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataTriggerState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TriggerState", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element TriggerState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RestrictedDlLock"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRestrictedDlLock::dp_tclSpmDpInternDataRestrictedDlLock(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpInternDataRestrictedDlLock::vStore() {
    dp_tclBaseElement myDpElem("RestrictedDlLock", (tS32)0xbcc8d9a);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TRestrictedDlLock)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListRestrictedDlLock::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TRestrictedDlLock));
                pCurPos += sizeof(TRestrictedDlLock);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TRestrictedDlLock))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpInternDataRestrictedDlLock::vUpdate() {
   dp_tclBaseElement myDpElem("RestrictedDlLock", (tS32)0xbcc8d9a);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TRestrictedDlLock)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TRestrictedDlLock));
         TRestrictedDlLock* pBuffer = (TRestrictedDlLock*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpInternDataRestrictedDlLock::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpInternDataRestrictedDlLock::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpInternDataRestrictedDlLock::s32GetElem(tU32 u32NbElem, TRestrictedDlLock& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpInternDataRestrictedDlLock::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpInternDataRestrictedDlLock::vPushBack(TRestrictedDlLock &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpInternDataRestrictedDlLock::vPushBack(const TRestrictedDlLock &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpInternDataRestrictedDlLock::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpInternDataRestrictedDlLock::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RestrictedDlLock", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpInternDataRestrictedDlLock::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RestrictedDlLock", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpInternDataRestrictedDlLock::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RestrictedDlLock", DP_U32_POOL_ID_SPMDPINTERNDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
		}
		else
		{
			fprintf(stdout,"Element RestrictedDlLock has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DownloadLockStates"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataDownloadLockStates::dp_tclSpmDpInternDataDownloadLockStates(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_DOWNLOAD_LOCK_MAX_NUM;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpInternDataDownloadLockStates::vStore() {
    dp_tclBaseElement myDpElem("DownloadLockStates", (tS32)0xfc6f95dd);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDownloadLockStates)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDownloadLockStates::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDownloadLockStates));
                pCurPos += sizeof(TDownloadLockStates);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDownloadLockStates))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpInternDataDownloadLockStates::vUpdate() {
   dp_tclBaseElement myDpElem("DownloadLockStates", (tS32)0xfc6f95dd);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDownloadLockStates)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDownloadLockStates));
         TDownloadLockStates* pBuffer = (TDownloadLockStates*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpInternDataDownloadLockStates::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpInternDataDownloadLockStates::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpInternDataDownloadLockStates::s32GetElem(tU32 u32NbElem, TDownloadLockStates& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpInternDataDownloadLockStates::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpInternDataDownloadLockStates::vPushBack(TDownloadLockStates &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpInternDataDownloadLockStates::vPushBack(const TDownloadLockStates &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpInternDataDownloadLockStates::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpInternDataDownloadLockStates::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "DownloadLockStates", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpInternDataDownloadLockStates::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "DownloadLockStates", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpInternDataDownloadLockStates::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DownloadLockStates", DP_U32_POOL_ID_SPMDPINTERNDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
		}
		else
		{
			fprintf(stdout,"Element DownloadLockStates has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSystemState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataCurrentSystemState::dp_tclSpmDpInternDataCurrentSystemState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSystemState,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataCurrentSystemState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSystemState",(tS32) 0xd291ce81);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSystemState = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataCurrentSystemState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSystemState", (tS32)0xd291ce81);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSystemState, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataCurrentSystemState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataCurrentSystemState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataCurrentSystemState::tGetData() {
   vUpdate();
   return tCurrentSystemState;
};
tS32 dp_tclSpmDpInternDataCurrentSystemState::s32GetData(tU32& tCurrentSystemStateParam) { 
   vUpdate();
   tCurrentSystemStateParam = tCurrentSystemState;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataCurrentSystemState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSystemState", (tS32)0xd291ce81);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataCurrentSystemState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataCurrentSystemState::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataCurrentSystemState::s32SetData(tU32 &tCurrentSystemStateParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSystemState,(tVoid*)&tCurrentSystemStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSystemStateParam' in function 'dp_tclSpmDpInternDataCurrentSystemState::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataCurrentSystemState::s32SetData(const tU32 &tCurrentSystemStateParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSystemState,(tVoid*)&tCurrentSystemStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSystemStateParam' in function 'dp_tclSpmDpInternDataCurrentSystemState::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataCurrentSystemState::u8GetData(tU32& tCurrentSystemStateParam) {  
   vUpdate();
   tCurrentSystemStateParam = tCurrentSystemState;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataCurrentSystemState::vSetData(tU32 &tCurrentSystemStateParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSystemState,(tVoid*)&tCurrentSystemStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSystemStateParam' in function 'dp_tclSpmDpInternDataCurrentSystemState::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataCurrentSystemState::vSetData(const tU32 &tCurrentSystemStateParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSystemState,(tVoid*)&tCurrentSystemStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSystemStateParam' in function 'dp_tclSpmDpInternDataCurrentSystemState::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataCurrentSystemState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataCurrentSystemState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "CurrentSystemState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataCurrentSystemState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "CurrentSystemState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataCurrentSystemState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSystemState", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element CurrentSystemState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SwBlockState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataSwBlockState::dp_tclSpmDpInternDataSwBlockState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSwBlockState,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataSwBlockState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SwBlockState",(tS32) 0x41a8f8ea);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSwBlockState = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataSwBlockState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SwBlockState", (tS32)0x41a8f8ea);
   (tVoid)myDpElem.bFillData((tVoid*)&tSwBlockState, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataSwBlockState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataSwBlockState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataSwBlockState::tGetData() {
   vUpdate();
   return tSwBlockState;
};
tS32 dp_tclSpmDpInternDataSwBlockState::s32GetData(tU32& tSwBlockStateParam) { 
   vUpdate();
   tSwBlockStateParam = tSwBlockState;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataSwBlockState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SwBlockState", (tS32)0x41a8f8ea);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataSwBlockState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataSwBlockState::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataSwBlockState::s32SetData(tU32 &tSwBlockStateParam) {
   //init parameter
   (tVoid)memcpy(&tSwBlockState,(tVoid*)&tSwBlockStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSwBlockStateParam' in function 'dp_tclSpmDpInternDataSwBlockState::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataSwBlockState::s32SetData(const tU32 &tSwBlockStateParam) {
   //init parameter
   (tVoid)memcpy(&tSwBlockState,(tVoid*)&tSwBlockStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSwBlockStateParam' in function 'dp_tclSpmDpInternDataSwBlockState::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataSwBlockState::u8GetData(tU32& tSwBlockStateParam) {  
   vUpdate();
   tSwBlockStateParam = tSwBlockState;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataSwBlockState::vSetData(tU32 &tSwBlockStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSwBlockState,(tVoid*)&tSwBlockStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSwBlockStateParam' in function 'dp_tclSpmDpInternDataSwBlockState::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataSwBlockState::vSetData(const tU32 &tSwBlockStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSwBlockState,(tVoid*)&tSwBlockStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSwBlockStateParam' in function 'dp_tclSpmDpInternDataSwBlockState::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataSwBlockState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataSwBlockState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "SwBlockState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataSwBlockState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "SwBlockState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataSwBlockState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SwBlockState", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element SwBlockState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RmtHBeatCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRmtHBeatCount::dp_tclSpmDpInternDataRmtHBeatCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRmtHBeatCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataRmtHBeatCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RmtHBeatCount",(tS32) 0x34839a44);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tRmtHBeatCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataRmtHBeatCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RmtHBeatCount", (tS32)0x34839a44);
   (tVoid)myDpElem.bFillData((tVoid*)&tRmtHBeatCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataRmtHBeatCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataRmtHBeatCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataRmtHBeatCount::tGetData() {
   vUpdate();
   return tRmtHBeatCount;
};
tS32 dp_tclSpmDpInternDataRmtHBeatCount::s32GetData(tU32& tRmtHBeatCountParam) { 
   vUpdate();
   tRmtHBeatCountParam = tRmtHBeatCount;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataRmtHBeatCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RmtHBeatCount", (tS32)0x34839a44);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataRmtHBeatCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataRmtHBeatCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataRmtHBeatCount::s32SetData(tU32 &tRmtHBeatCountParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatCount,(tVoid*)&tRmtHBeatCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataRmtHBeatCount::s32SetData(const tU32 &tRmtHBeatCountParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatCount,(tVoid*)&tRmtHBeatCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataRmtHBeatCount::u8GetData(tU32& tRmtHBeatCountParam) {  
   vUpdate();
   tRmtHBeatCountParam = tRmtHBeatCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataRmtHBeatCount::vSetData(tU32 &tRmtHBeatCountParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatCount,(tVoid*)&tRmtHBeatCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataRmtHBeatCount::vSetData(const tU32 &tRmtHBeatCountParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatCount,(tVoid*)&tRmtHBeatCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataRmtHBeatCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataRmtHBeatCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RmtHBeatCount", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element RmtHBeatCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RmtHBeatTotalCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRmtHBeatTotalCount::dp_tclSpmDpInternDataRmtHBeatTotalCount(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRmtHBeatTotalCount,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RmtHBeatTotalCount",(tS32) 0xc70ff4c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tRmtHBeatTotalCount = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RmtHBeatTotalCount", (tS32)0xc70ff4c);
   (tVoid)myDpElem.bFillData((tVoid*)&tRmtHBeatTotalCount, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataRmtHBeatTotalCount::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataRmtHBeatTotalCount::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataRmtHBeatTotalCount::tGetData() {
   vUpdate();
   return tRmtHBeatTotalCount;
};
tS32 dp_tclSpmDpInternDataRmtHBeatTotalCount::s32GetData(tU32& tRmtHBeatTotalCountParam) { 
   vUpdate();
   tRmtHBeatTotalCountParam = tRmtHBeatTotalCount;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataRmtHBeatTotalCount::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RmtHBeatTotalCount", (tS32)0xc70ff4c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataRmtHBeatTotalCount::s32SetData(tU32 &tRmtHBeatTotalCountParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTotalCount,(tVoid*)&tRmtHBeatTotalCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatTotalCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataRmtHBeatTotalCount::s32SetData(const tU32 &tRmtHBeatTotalCountParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTotalCount,(tVoid*)&tRmtHBeatTotalCountParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatTotalCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataRmtHBeatTotalCount::u8GetData(tU32& tRmtHBeatTotalCountParam) {  
   vUpdate();
   tRmtHBeatTotalCountParam = tRmtHBeatTotalCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(tU32 &tRmtHBeatTotalCountParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTotalCount,(tVoid*)&tRmtHBeatTotalCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatTotalCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(const tU32 &tRmtHBeatTotalCountParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTotalCount,(tVoid*)&tRmtHBeatTotalCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatTotalCountParam' in function 'dp_tclSpmDpInternDataRmtHBeatTotalCount::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataRmtHBeatTotalCount::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataRmtHBeatTotalCount::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatTotalCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatTotalCount::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatTotalCount", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatTotalCount::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RmtHBeatTotalCount", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element RmtHBeatTotalCount has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RmtHBeatTs"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRmtHBeatTs::dp_tclSpmDpInternDataRmtHBeatTs(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRmtHBeatTs,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataRmtHBeatTs::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RmtHBeatTs",(tS32) 0xcb5471a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tRmtHBeatTs = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataRmtHBeatTs::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RmtHBeatTs", (tS32)0xcb5471a);
   (tVoid)myDpElem.bFillData((tVoid*)&tRmtHBeatTs, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataRmtHBeatTs::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataRmtHBeatTs::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataRmtHBeatTs::tGetData() {
   vUpdate();
   return tRmtHBeatTs;
};
tS32 dp_tclSpmDpInternDataRmtHBeatTs::s32GetData(tU32& tRmtHBeatTsParam) { 
   vUpdate();
   tRmtHBeatTsParam = tRmtHBeatTs;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataRmtHBeatTs::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RmtHBeatTs", (tS32)0xcb5471a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataRmtHBeatTs::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataRmtHBeatTs::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataRmtHBeatTs::s32SetData(tU32 &tRmtHBeatTsParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTs,(tVoid*)&tRmtHBeatTsParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatTsParam' in function 'dp_tclSpmDpInternDataRmtHBeatTs::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataRmtHBeatTs::s32SetData(const tU32 &tRmtHBeatTsParam) {
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTs,(tVoid*)&tRmtHBeatTsParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtHBeatTsParam' in function 'dp_tclSpmDpInternDataRmtHBeatTs::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataRmtHBeatTs::u8GetData(tU32& tRmtHBeatTsParam) {  
   vUpdate();
   tRmtHBeatTsParam = tRmtHBeatTs;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataRmtHBeatTs::vSetData(tU32 &tRmtHBeatTsParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTs,(tVoid*)&tRmtHBeatTsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatTsParam' in function 'dp_tclSpmDpInternDataRmtHBeatTs::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataRmtHBeatTs::vSetData(const tU32 &tRmtHBeatTsParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtHBeatTs,(tVoid*)&tRmtHBeatTsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtHBeatTsParam' in function 'dp_tclSpmDpInternDataRmtHBeatTs::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataRmtHBeatTs::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataRmtHBeatTs::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatTs", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatTs::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtHBeatTs", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtHBeatTs::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RmtHBeatTs", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element RmtHBeatTs has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RmtStartupState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRmtStartupState::dp_tclSpmDpInternDataRmtStartupState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRmtStartupState,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataRmtStartupState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RmtStartupState",(tS32) 0x5df20fd3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tRmtStartupState = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataRmtStartupState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RmtStartupState", (tS32)0x5df20fd3);
   (tVoid)myDpElem.bFillData((tVoid*)&tRmtStartupState, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataRmtStartupState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataRmtStartupState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataRmtStartupState::tGetData() {
   vUpdate();
   return tRmtStartupState;
};
tS32 dp_tclSpmDpInternDataRmtStartupState::s32GetData(tU32& tRmtStartupStateParam) { 
   vUpdate();
   tRmtStartupStateParam = tRmtStartupState;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataRmtStartupState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RmtStartupState", (tS32)0x5df20fd3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataRmtStartupState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataRmtStartupState::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataRmtStartupState::s32SetData(tU32 &tRmtStartupStateParam) {
   //init parameter
   (tVoid)memcpy(&tRmtStartupState,(tVoid*)&tRmtStartupStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtStartupStateParam' in function 'dp_tclSpmDpInternDataRmtStartupState::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataRmtStartupState::s32SetData(const tU32 &tRmtStartupStateParam) {
   //init parameter
   (tVoid)memcpy(&tRmtStartupState,(tVoid*)&tRmtStartupStateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtStartupStateParam' in function 'dp_tclSpmDpInternDataRmtStartupState::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataRmtStartupState::u8GetData(tU32& tRmtStartupStateParam) {  
   vUpdate();
   tRmtStartupStateParam = tRmtStartupState;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataRmtStartupState::vSetData(tU32 &tRmtStartupStateParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtStartupState,(tVoid*)&tRmtStartupStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtStartupStateParam' in function 'dp_tclSpmDpInternDataRmtStartupState::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataRmtStartupState::vSetData(const tU32 &tRmtStartupStateParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtStartupState,(tVoid*)&tRmtStartupStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtStartupStateParam' in function 'dp_tclSpmDpInternDataRmtStartupState::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataRmtStartupState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataRmtStartupState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtStartupState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtStartupState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtStartupState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtStartupState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RmtStartupState", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element RmtStartupState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RmtStartupTs"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataRmtStartupTs::dp_tclSpmDpInternDataRmtStartupTs(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRmtStartupTs,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpInternDataRmtStartupTs::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("RmtStartupTs",(tS32) 0x3e310a49);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tRmtStartupTs = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpInternDataRmtStartupTs::vStore(tVoid) {
   dp_tclBaseElement myDpElem("RmtStartupTs", (tS32)0x3e310a49);
   (tVoid)myDpElem.bFillData((tVoid*)&tRmtStartupTs, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpInternDataRmtStartupTs::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpInternDataRmtStartupTs::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpInternDataRmtStartupTs::tGetData() {
   vUpdate();
   return tRmtStartupTs;
};
tS32 dp_tclSpmDpInternDataRmtStartupTs::s32GetData(tU32& tRmtStartupTsParam) { 
   vUpdate();
   tRmtStartupTsParam = tRmtStartupTs;
   return _s32Status;
}
tS32 dp_tclSpmDpInternDataRmtStartupTs::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("RmtStartupTs", (tS32)0x3e310a49);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPINTERNDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpInternDataRmtStartupTs::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpInternDataRmtStartupTs::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpInternDataRmtStartupTs::s32SetData(tU32 &tRmtStartupTsParam) {
   //init parameter
   (tVoid)memcpy(&tRmtStartupTs,(tVoid*)&tRmtStartupTsParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtStartupTsParam' in function 'dp_tclSpmDpInternDataRmtStartupTs::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpInternDataRmtStartupTs::s32SetData(const tU32 &tRmtStartupTsParam) {
   //init parameter
   (tVoid)memcpy(&tRmtStartupTs,(tVoid*)&tRmtStartupTsParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRmtStartupTsParam' in function 'dp_tclSpmDpInternDataRmtStartupTs::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpInternDataRmtStartupTs::u8GetData(tU32& tRmtStartupTsParam) {  
   vUpdate();
   tRmtStartupTsParam = tRmtStartupTs;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataRmtStartupTs::vSetData(tU32 &tRmtStartupTsParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtStartupTs,(tVoid*)&tRmtStartupTsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtStartupTsParam' in function 'dp_tclSpmDpInternDataRmtStartupTs::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataRmtStartupTs::vSetData(const tU32 &tRmtStartupTsParam) { 
   //init parameter
   (tVoid)memcpy(&tRmtStartupTs,(tVoid*)&tRmtStartupTsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tRmtStartupTsParam' in function 'dp_tclSpmDpInternDataRmtStartupTs::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpInternDataRmtStartupTs::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpInternDataRmtStartupTs::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtStartupTs", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtStartupTs::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPINTERNDATA, "RmtStartupTs", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpInternDataRmtStartupTs::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: RmtStartupTs", DP_U32_POOL_ID_SPMDPINTERNDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPINTERNDATA);
   }
   else
   {
      fprintf(stdout,"Element RmtStartupTs has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SystemState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataSystemState::dp_tclSpmDpInternDataSystemState(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tSystemState,0,sizeof(tU32));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataSystemState::vSetData(tU32 &tSystemStateParam) {
   //init parameter
   (tVoid)memcpy(&tSystemState,(tVoid*)&tSystemStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemStateParam' in function 'dp_tclSpmDpInternDataSystemState::vSetData(tU32)' could be made const reference

tVoid dp_tclSpmDpInternDataSystemState::vSetData(const tU32 &tSystemStateParam) {
   //init parameter
   (tVoid)memcpy(&tSystemState,(tVoid*)&tSystemStateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemStateParam' in function 'dp_tclSpmDpInternDataSystemState::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataSystemState::operator<<(tU32 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataSystemState::u8GetData(tU32& tSystemStateParam) {
   vUpdate();
   tSystemStateParam = tSystemState;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataSystemState::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataSystemState::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tSystemState, &VtspSram->tSystemState,sizeof(tU32))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataSystemState::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tSystemState,&VtspSram->tSystemState, sizeof(tU32));
}
tU8 dp_tclSpmDpInternDataSystemState::u8DataValid() const {return _u8DataStatus;};

tU32 dp_tclSpmDpInternDataSystemState::tGetData() {
   vUpdate();
   return tSystemState;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "UBatDropDetected"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataUBatDropDetected::dp_tclSpmDpInternDataUBatDropDetected(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tUBatDropDetected,0,sizeof(tBool));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataUBatDropDetected::vSetData(tBool &tUBatDropDetectedParam) {
   //init parameter
   (tVoid)memcpy(&tUBatDropDetected,(tVoid*)&tUBatDropDetectedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tUBatDropDetectedParam' in function 'dp_tclSpmDpInternDataUBatDropDetected::vSetData(tBool)' could be made const reference

tVoid dp_tclSpmDpInternDataUBatDropDetected::vSetData(const tBool &tUBatDropDetectedParam) {
   //init parameter
   (tVoid)memcpy(&tUBatDropDetected,(tVoid*)&tUBatDropDetectedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tUBatDropDetectedParam' in function 'dp_tclSpmDpInternDataUBatDropDetected::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpInternDataUBatDropDetected::operator<<(tBool oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataUBatDropDetected::u8GetData(tBool& tUBatDropDetectedParam) {
   vUpdate();
   tUBatDropDetectedParam = tUBatDropDetected;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataUBatDropDetected::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataUBatDropDetected::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tUBatDropDetected, &VtspSram->tUBatDropDetected,sizeof(tBool))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataUBatDropDetected::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tUBatDropDetected,&VtspSram->tUBatDropDetected, sizeof(tBool));
}
tU8 dp_tclSpmDpInternDataUBatDropDetected::u8DataValid() const {return _u8DataStatus;};

tBool dp_tclSpmDpInternDataUBatDropDetected::tGetData() {
   vUpdate();
   return tUBatDropDetected;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IgnitionOffCount"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataIgnitionOffCount::dp_tclSpmDpInternDataIgnitionOffCount(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tIgnitionOffCount,0,sizeof(tU32));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataIgnitionOffCount::vSetData(tU32 &tIgnitionOffCountParam) {
   //init parameter
   (tVoid)memcpy(&tIgnitionOffCount,(tVoid*)&tIgnitionOffCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tIgnitionOffCountParam' in function 'dp_tclSpmDpInternDataIgnitionOffCount::vSetData(tU32)' could be made const reference

tVoid dp_tclSpmDpInternDataIgnitionOffCount::vSetData(const tU32 &tIgnitionOffCountParam) {
   //init parameter
   (tVoid)memcpy(&tIgnitionOffCount,(tVoid*)&tIgnitionOffCountParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tIgnitionOffCountParam' in function 'dp_tclSpmDpInternDataIgnitionOffCount::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataIgnitionOffCount::operator<<(tU32 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataIgnitionOffCount::u8GetData(tU32& tIgnitionOffCountParam) {
   vUpdate();
   tIgnitionOffCountParam = tIgnitionOffCount;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataIgnitionOffCount::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataIgnitionOffCount::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tIgnitionOffCount, &VtspSram->tIgnitionOffCount,sizeof(tU32))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataIgnitionOffCount::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tIgnitionOffCount,&VtspSram->tIgnitionOffCount, sizeof(tU32));
}
tU8 dp_tclSpmDpInternDataIgnitionOffCount::u8DataValid() const {return _u8DataStatus;};

tU32 dp_tclSpmDpInternDataIgnitionOffCount::tGetData() {
   vUpdate();
   return tIgnitionOffCount;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastOsalElapsedTime"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataLastOsalElapsedTime::dp_tclSpmDpInternDataLastOsalElapsedTime(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tLastOsalElapsedTime,0,sizeof(tU32));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::vSetData(tU32 &tLastOsalElapsedTimeParam) {
   //init parameter
   (tVoid)memcpy(&tLastOsalElapsedTime,(tVoid*)&tLastOsalElapsedTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastOsalElapsedTimeParam' in function 'dp_tclSpmDpInternDataLastOsalElapsedTime::vSetData(tU32)' could be made const reference

tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::vSetData(const tU32 &tLastOsalElapsedTimeParam) {
   //init parameter
   (tVoid)memcpy(&tLastOsalElapsedTime,(tVoid*)&tLastOsalElapsedTimeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastOsalElapsedTimeParam' in function 'dp_tclSpmDpInternDataLastOsalElapsedTime::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::operator<<(tU32 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataLastOsalElapsedTime::u8GetData(tU32& tLastOsalElapsedTimeParam) {
   vUpdate();
   tLastOsalElapsedTimeParam = tLastOsalElapsedTime;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastOsalElapsedTime, &VtspSram->tLastOsalElapsedTime,sizeof(tU32))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataLastOsalElapsedTime::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastOsalElapsedTime,&VtspSram->tLastOsalElapsedTime, sizeof(tU32));
}
tU8 dp_tclSpmDpInternDataLastOsalElapsedTime::u8DataValid() const {return _u8DataStatus;};

tU32 dp_tclSpmDpInternDataLastOsalElapsedTime::tGetData() {
   vUpdate();
   return tLastOsalElapsedTime;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastVoltageLevel"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataLastVoltageLevel::dp_tclSpmDpInternDataLastVoltageLevel(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tLastVoltageLevel,0,sizeof(tU32));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataLastVoltageLevel::vSetData(tU32 &tLastVoltageLevelParam) {
   //init parameter
   (tVoid)memcpy(&tLastVoltageLevel,(tVoid*)&tLastVoltageLevelParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastVoltageLevelParam' in function 'dp_tclSpmDpInternDataLastVoltageLevel::vSetData(tU32)' could be made const reference

tVoid dp_tclSpmDpInternDataLastVoltageLevel::vSetData(const tU32 &tLastVoltageLevelParam) {
   //init parameter
   (tVoid)memcpy(&tLastVoltageLevel,(tVoid*)&tLastVoltageLevelParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastVoltageLevelParam' in function 'dp_tclSpmDpInternDataLastVoltageLevel::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataLastVoltageLevel::operator<<(tU32 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataLastVoltageLevel::u8GetData(tU32& tLastVoltageLevelParam) {
   vUpdate();
   tLastVoltageLevelParam = tLastVoltageLevel;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataLastVoltageLevel::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataLastVoltageLevel::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastVoltageLevel, &VtspSram->tLastVoltageLevel,sizeof(tU32))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataLastVoltageLevel::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastVoltageLevel,&VtspSram->tLastVoltageLevel, sizeof(tU32));
}
tU8 dp_tclSpmDpInternDataLastVoltageLevel::u8DataValid() const {return _u8DataStatus;};

tU32 dp_tclSpmDpInternDataLastVoltageLevel::tGetData() {
   vUpdate();
   return tLastVoltageLevel;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastUbatSense"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataLastUbatSense::dp_tclSpmDpInternDataLastUbatSense(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tLastUbatSense,0,sizeof(tU16));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataLastUbatSense::vSetData(tU16 &tLastUbatSenseParam) {
   //init parameter
   (tVoid)memcpy(&tLastUbatSense,(tVoid*)&tLastUbatSenseParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tLastUbatSenseParam' in function 'dp_tclSpmDpInternDataLastUbatSense::vSetData(tU16)' could be made const reference

tVoid dp_tclSpmDpInternDataLastUbatSense::vSetData(const tU16 &tLastUbatSenseParam) {
   //init parameter
   (tVoid)memcpy(&tLastUbatSense,(tVoid*)&tLastUbatSenseParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tLastUbatSenseParam' in function 'dp_tclSpmDpInternDataLastUbatSense::vSetData(tU16)' could be made const reference
tVoid dp_tclSpmDpInternDataLastUbatSense::operator<<(tU16 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataLastUbatSense::u8GetData(tU16& tLastUbatSenseParam) {
   vUpdate();
   tLastUbatSenseParam = tLastUbatSense;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataLastUbatSense::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataLastUbatSense::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastUbatSense, &VtspSram->tLastUbatSense,sizeof(tU16))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataLastUbatSense::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastUbatSense,&VtspSram->tLastUbatSense, sizeof(tU16));
}
tU8 dp_tclSpmDpInternDataLastUbatSense::u8DataValid() const {return _u8DataStatus;};

tU16 dp_tclSpmDpInternDataLastUbatSense::tGetData() {
   vUpdate();
   return tLastUbatSense;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastWakeupReason"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataLastWakeupReason::dp_tclSpmDpInternDataLastWakeupReason(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tLastWakeupReason,0,sizeof(tU16));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataLastWakeupReason::vSetData(tU16 &tLastWakeupReasonParam) {
   //init parameter
   (tVoid)memcpy(&tLastWakeupReason,(tVoid*)&tLastWakeupReasonParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tLastWakeupReasonParam' in function 'dp_tclSpmDpInternDataLastWakeupReason::vSetData(tU16)' could be made const reference

tVoid dp_tclSpmDpInternDataLastWakeupReason::vSetData(const tU16 &tLastWakeupReasonParam) {
   //init parameter
   (tVoid)memcpy(&tLastWakeupReason,(tVoid*)&tLastWakeupReasonParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tLastWakeupReasonParam' in function 'dp_tclSpmDpInternDataLastWakeupReason::vSetData(tU16)' could be made const reference
tVoid dp_tclSpmDpInternDataLastWakeupReason::operator<<(tU16 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataLastWakeupReason::u8GetData(tU16& tLastWakeupReasonParam) {
   vUpdate();
   tLastWakeupReasonParam = tLastWakeupReason;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataLastWakeupReason::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataLastWakeupReason::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastWakeupReason, &VtspSram->tLastWakeupReason,sizeof(tU16))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataLastWakeupReason::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tLastWakeupReason,&VtspSram->tLastWakeupReason, sizeof(tU16));
}
tU8 dp_tclSpmDpInternDataLastWakeupReason::u8DataValid() const {return _u8DataStatus;};

tU16 dp_tclSpmDpInternDataLastWakeupReason::tGetData() {
   vUpdate();
   return tLastWakeupReason;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetSetBySpm"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataResetSetBySpm::dp_tclSpmDpInternDataResetSetBySpm(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tResetSetBySpm,0,sizeof(tU8));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataResetSetBySpm::vSetData(tU8 &tResetSetBySpmParam) {
   //init parameter
   (tVoid)memcpy(&tResetSetBySpm,(tVoid*)&tResetSetBySpmParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tResetSetBySpmParam' in function 'dp_tclSpmDpInternDataResetSetBySpm::vSetData(tU8)' could be made const reference

tVoid dp_tclSpmDpInternDataResetSetBySpm::vSetData(const tU8 &tResetSetBySpmParam) {
   //init parameter
   (tVoid)memcpy(&tResetSetBySpm,(tVoid*)&tResetSetBySpmParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tResetSetBySpmParam' in function 'dp_tclSpmDpInternDataResetSetBySpm::vSetData(tU8)' could be made const reference
tVoid dp_tclSpmDpInternDataResetSetBySpm::operator<<(tU8 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataResetSetBySpm::u8GetData(tU8& tResetSetBySpmParam) {
   vUpdate();
   tResetSetBySpmParam = tResetSetBySpm;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataResetSetBySpm::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataResetSetBySpm::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tResetSetBySpm, &VtspSram->tResetSetBySpm,sizeof(tU8))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataResetSetBySpm::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tResetSetBySpm,&VtspSram->tResetSetBySpm, sizeof(tU8));
}
tU8 dp_tclSpmDpInternDataResetSetBySpm::u8DataValid() const {return _u8DataStatus;};

tU8 dp_tclSpmDpInternDataResetSetBySpm::tGetData() {
   vUpdate();
   return tResetSetBySpm;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ContinuousResets"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataContinuousResets::dp_tclSpmDpInternDataContinuousResets(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tContinuousResets,0,sizeof(tU32));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataContinuousResets::vSetData(tU32 &tContinuousResetsParam) {
   //init parameter
   (tVoid)memcpy(&tContinuousResets,(tVoid*)&tContinuousResetsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tContinuousResetsParam' in function 'dp_tclSpmDpInternDataContinuousResets::vSetData(tU32)' could be made const reference

tVoid dp_tclSpmDpInternDataContinuousResets::vSetData(const tU32 &tContinuousResetsParam) {
   //init parameter
   (tVoid)memcpy(&tContinuousResets,(tVoid*)&tContinuousResetsParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tContinuousResetsParam' in function 'dp_tclSpmDpInternDataContinuousResets::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpInternDataContinuousResets::operator<<(tU32 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataContinuousResets::u8GetData(tU32& tContinuousResetsParam) {
   vUpdate();
   tContinuousResetsParam = tContinuousResets;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataContinuousResets::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataContinuousResets::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tContinuousResets, &VtspSram->tContinuousResets,sizeof(tU32))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataContinuousResets::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tContinuousResets,&VtspSram->tContinuousResets, sizeof(tU32));
}
tU8 dp_tclSpmDpInternDataContinuousResets::u8DataValid() const {return _u8DataStatus;};

tU32 dp_tclSpmDpInternDataContinuousResets::tGetData() {
   vUpdate();
   return tContinuousResets;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ShutdownConfirmed"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataShutdownConfirmed::dp_tclSpmDpInternDataShutdownConfirmed(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tShutdownConfirmed,0,sizeof(tBool));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataShutdownConfirmed::vSetData(tBool &tShutdownConfirmedParam) {
   //init parameter
   (tVoid)memcpy(&tShutdownConfirmed,(tVoid*)&tShutdownConfirmedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tShutdownConfirmedParam' in function 'dp_tclSpmDpInternDataShutdownConfirmed::vSetData(tBool)' could be made const reference

tVoid dp_tclSpmDpInternDataShutdownConfirmed::vSetData(const tBool &tShutdownConfirmedParam) {
   //init parameter
   (tVoid)memcpy(&tShutdownConfirmed,(tVoid*)&tShutdownConfirmedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tShutdownConfirmedParam' in function 'dp_tclSpmDpInternDataShutdownConfirmed::vSetData(tBool)' could be made const reference
tVoid dp_tclSpmDpInternDataShutdownConfirmed::operator<<(tBool oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataShutdownConfirmed::u8GetData(tBool& tShutdownConfirmedParam) {
   vUpdate();
   tShutdownConfirmedParam = tShutdownConfirmed;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataShutdownConfirmed::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataShutdownConfirmed::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tShutdownConfirmed, &VtspSram->tShutdownConfirmed,sizeof(tBool))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataShutdownConfirmed::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tShutdownConfirmed,&VtspSram->tShutdownConfirmed, sizeof(tBool));
}
tU8 dp_tclSpmDpInternDataShutdownConfirmed::u8DataValid() const {return _u8DataStatus;};

tBool dp_tclSpmDpInternDataShutdownConfirmed::tGetData() {
   vUpdate();
   return tShutdownConfirmed;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ResetsInShutdown"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpInternDataResetsInShutdown::dp_tclSpmDpInternDataResetsInShutdown(tU16 DPid)
{
    _u16AccessId = DPid;
   _u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
   (tVoid)memset(&tResetsInShutdown,0,sizeof(tU16));
   #if !defined(VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK) && !defined(LCM_UNIT_TESTS) //workaround for lcm_utest      
   vUpdate();
   #endif
  
};
tVoid dp_tclSpmDpInternDataResetsInShutdown::vSetData(tU16 &tResetsInShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tResetsInShutdown,(tVoid*)&tResetsInShutdownParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tResetsInShutdownParam' in function 'dp_tclSpmDpInternDataResetsInShutdown::vSetData(tU16)' could be made const reference

tVoid dp_tclSpmDpInternDataResetsInShutdown::vSetData(const tU16 &tResetsInShutdownParam) {
   //init parameter
   (tVoid)memcpy(&tResetsInShutdown,(tVoid*)&tResetsInShutdownParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tResetsInShutdownParam' in function 'dp_tclSpmDpInternDataResetsInShutdown::vSetData(tU16)' could be made const reference
tVoid dp_tclSpmDpInternDataResetsInShutdown::operator<<(tU16 oParam){return vSetData(oParam);};
 
tU8 dp_tclSpmDpInternDataResetsInShutdown::u8GetData(tU16& tResetsInShutdownParam) {
   vUpdate();
   tResetsInShutdownParam = tResetsInShutdown;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpInternDataResetsInShutdown::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

tVoid dp_tclSpmDpInternDataResetsInShutdown::vUpdate(tVoid) 
{
   tU8* pu8SRamBuf = (tU8*)&dp_tclSramAccess::tSram_fc_spm;
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   dp_tclSramAccess::TSram_fc_spm *VtspSram=(dp_tclSramAccess::TSram_fc_spm*)pu8SRamBuf;
   if (dp_tclSramAccess::bReadSRamData("/dev/pram/fc_spm", pu8SRamBuf, sizeof(dp_tclSramAccess::TSram_fc_spm),&tResetsInShutdown, &VtspSram->tResetsInShutdown,sizeof(tU16))) 
   {
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;     
   }
}

tVoid dp_tclSpmDpInternDataResetsInShutdown::vStore(tVoid) const {
   //init parameter 
   dp_tclSramAccess::TSram_fc_spm *VtspSram=&dp_tclSramAccess::tSram_fc_spm;
   dp_tclSramAccess::bWriteSRamData("/dev/pram/fc_spm", (tU8*)VtspSram, sizeof(dp_tclSramAccess::TSram_fc_spm),&tResetsInShutdown,&VtspSram->tResetsInShutdown, sizeof(tU16));
}
tU8 dp_tclSpmDpInternDataResetsInShutdown::u8DataValid() const {return _u8DataStatus;};

tU16 dp_tclSpmDpInternDataResetsInShutdown::tGetData() {
   vUpdate();
   return tResetsInShutdown;
};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuUsageCheckPeriodS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataCpuUsageCheckPeriodS::dp_tclSpmDpInternDataCpuUsageCheckPeriodS() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuUsageCheckPeriodS(10)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataCpuUsageCheckPeriodS::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CPU_USAGE_CHECK_PERIOD_S",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuUsageCheckPeriodS = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataCpuUsageCheckPeriodS::u8GetData(tU8& tCpuUsageCheckPeriodSParam) {
   vUpdate();
   tCpuUsageCheckPeriodSParam = tCpuUsageCheckPeriodS;
   return _u8DataStatus;
}
tU8 dp_tclSpmDpInternDataCpuUsageCheckPeriodS::tGetData() {
   vUpdate();
   return tCpuUsageCheckPeriodS;
};

tU8 dp_tclSpmDpInternDataCpuUsageCheckPeriodS::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataCpuUsageCheckPeriodS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DoApplicationProcessorReset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataDoApplicationProcessorReset::dp_tclSpmDpInternDataDoApplicationProcessorReset() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tDoApplicationProcessorReset(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataDoApplicationProcessorReset::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("DO_APPLICATION_PROCESSOR_RESET",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tDoApplicationProcessorReset = (tBool)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataDoApplicationProcessorReset::u8GetData(tBool& tDoApplicationProcessorResetParam) {
   vUpdate();
   tDoApplicationProcessorResetParam = tDoApplicationProcessorReset;
   return _u8DataStatus;
}
tBool dp_tclSpmDpInternDataDoApplicationProcessorReset::tGetData() {
   vUpdate();
   return tDoApplicationProcessorReset;
};

tU8 dp_tclSpmDpInternDataDoApplicationProcessorReset::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataDoApplicationProcessorReset::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ThreadCpuUsagePerCoreThreshold"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tThreadCpuUsagePerCoreThreshold(95)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("THREAD_CPU_USAGE_PER_CORE_THRESHOLD",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tThreadCpuUsagePerCoreThreshold = (tU8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::u8GetData(tU8& tThreadCpuUsagePerCoreThresholdParam) {
   vUpdate();
   tThreadCpuUsagePerCoreThresholdParam = tThreadCpuUsagePerCoreThreshold;
   return _u8DataStatus;
}
tU8 dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::tGetData() {
   vUpdate();
   return tThreadCpuUsagePerCoreThreshold;
};

tU8 dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataThreadCpuUsagePerCoreThreshold::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuUsageNiceTimeoutMs"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuUsageNiceTimeoutMs(30000)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CPU_USAGE_NICE_TIMEOUT_MS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuUsageNiceTimeoutMs = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::u8GetData(tU32& tCpuUsageNiceTimeoutMsParam) {
   vUpdate();
   tCpuUsageNiceTimeoutMsParam = tCpuUsageNiceTimeoutMs;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::tGetData() {
   vUpdate();
   return tCpuUsageNiceTimeoutMs;
};

tU8 dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataCpuUsageNiceTimeoutMs::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CpuUsageRealtimeTimeoutMs"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tCpuUsageRealtimeTimeoutMs(10000)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("CPU_USAGE_REALTIME_TIMEOUT_MS",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tCpuUsageRealtimeTimeoutMs = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::u8GetData(tU32& tCpuUsageRealtimeTimeoutMsParam) {
   vUpdate();
   tCpuUsageRealtimeTimeoutMsParam = tCpuUsageRealtimeTimeoutMs;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::tGetData() {
   vUpdate();
   return tCpuUsageRealtimeTimeoutMs;
};

tU8 dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataCpuUsageRealtimeTimeoutMs::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NicePriority"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataNicePriority::dp_tclSpmDpInternDataNicePriority() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tNicePriority(19)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataNicePriority::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("NICE_PRIORITY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tNicePriority = (tS8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataNicePriority::u8GetData(tS8& tNicePriorityParam) {
   vUpdate();
   tNicePriorityParam = tNicePriority;
   return _u8DataStatus;
}
tS8 dp_tclSpmDpInternDataNicePriority::tGetData() {
   vUpdate();
   return tNicePriority;
};

tU8 dp_tclSpmDpInternDataNicePriority::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataNicePriority::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "RealtimePriority"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataRealtimePriority::dp_tclSpmDpInternDataRealtimePriority() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tRealtimePriority(-1)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataRealtimePriority::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("REALTIME_PRIORITY",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tRealtimePriority = (tS8)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataRealtimePriority::u8GetData(tS8& tRealtimePriorityParam) {
   vUpdate();
   tRealtimePriorityParam = tRealtimePriority;
   return _u8DataStatus;
}
tS8 dp_tclSpmDpInternDataRealtimePriority::tGetData() {
   vUpdate();
   return tRealtimePriority;
};

tU8 dp_tclSpmDpInternDataRealtimePriority::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataRealtimePriority::operator>>(tS8& oParam){return (tVoid)u8GetData(oParam);};


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HwmCheckEnabled"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------

dp_tclSpmDpInternDataHwmCheckEnabled::dp_tclSpmDpInternDataHwmCheckEnabled() :
_u8DataStatus(DP_U8_ELEM_STATUS_INITVAL),
tHwmCheckEnabled(0)
{
   vUpdate();
}

tVoid dp_tclSpmDpInternDataHwmCheckEnabled::vUpdate(tVoid) {
   reg_tclRegKey  oReg;
   tChar cRegKeyPath[] = "/dev/registry/LOCAL_MACHINE/SOFTWARE/BLAUPUNKT/""PROCESS/BASE/SPM/APP_CONFIG";
   if( oReg.bOpen(cRegKeyPath)) {
      tU32 u32TmpRegVal;
      if (oReg.bQueryU32("HWM_CHECK_ENABLED",    &u32TmpRegVal)) {
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          tHwmCheckEnabled = (tU32)u32TmpRegVal;
      }
   }
}

tU8 dp_tclSpmDpInternDataHwmCheckEnabled::u8GetData(tU32& tHwmCheckEnabledParam) {
   vUpdate();
   tHwmCheckEnabledParam = tHwmCheckEnabled;
   return _u8DataStatus;
}
tU32 dp_tclSpmDpInternDataHwmCheckEnabled::tGetData() {
   vUpdate();
   return tHwmCheckEnabled;
};

tU8 dp_tclSpmDpInternDataHwmCheckEnabled::u8DataValid() const {return _u8DataStatus;};

 tVoid dp_tclSpmDpInternDataHwmCheckEnabled::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

