
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpmDpEngState.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "History"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistory::dp_tclSpmDpEngStateHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistory::vStore() {
    dp_tclBaseElement myDpElem("History", (tS32)0x178b36);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistory::vUpdate() {
   dp_tclBaseElement myDpElem("History", (tS32)0x178b36);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistory::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistory::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistory::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "History", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "History", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: History", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element History has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HistoryStack01"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistoryStack01::dp_tclSpmDpEngStateHistoryStack01(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistoryStack01::vStore() {
    dp_tclBaseElement myDpElem("HistoryStack01", (tS32)0x11194929);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistoryStack01::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistoryStack01::vUpdate() {
   dp_tclBaseElement myDpElem("HistoryStack01", (tS32)0x11194929);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistoryStack01::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistoryStack01::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistoryStack01::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistoryStack01::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistoryStack01::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistoryStack01::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistoryStack01::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistoryStack01::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack01", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistoryStack01::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack01", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistoryStack01::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HistoryStack01", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element HistoryStack01 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HistoryStack02"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistoryStack02::dp_tclSpmDpEngStateHistoryStack02(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistoryStack02::vStore() {
    dp_tclBaseElement myDpElem("HistoryStack02", (tS32)0x1119492a);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistoryStack02::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistoryStack02::vUpdate() {
   dp_tclBaseElement myDpElem("HistoryStack02", (tS32)0x1119492a);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistoryStack02::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistoryStack02::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistoryStack02::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistoryStack02::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistoryStack02::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistoryStack02::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistoryStack02::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistoryStack02::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack02", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistoryStack02::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack02", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistoryStack02::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HistoryStack02", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element HistoryStack02 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HistoryStack03"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistoryStack03::dp_tclSpmDpEngStateHistoryStack03(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistoryStack03::vStore() {
    dp_tclBaseElement myDpElem("HistoryStack03", (tS32)0x1119492b);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistoryStack03::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistoryStack03::vUpdate() {
   dp_tclBaseElement myDpElem("HistoryStack03", (tS32)0x1119492b);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistoryStack03::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistoryStack03::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistoryStack03::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistoryStack03::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistoryStack03::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistoryStack03::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistoryStack03::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistoryStack03::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack03", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistoryStack03::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack03", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistoryStack03::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HistoryStack03", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element HistoryStack03 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HistoryStack04"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistoryStack04::dp_tclSpmDpEngStateHistoryStack04(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistoryStack04::vStore() {
    dp_tclBaseElement myDpElem("HistoryStack04", (tS32)0x1119492c);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistoryStack04::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistoryStack04::vUpdate() {
   dp_tclBaseElement myDpElem("HistoryStack04", (tS32)0x1119492c);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistoryStack04::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistoryStack04::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistoryStack04::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistoryStack04::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistoryStack04::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistoryStack04::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistoryStack04::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistoryStack04::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack04", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistoryStack04::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack04", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistoryStack04::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HistoryStack04", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element HistoryStack04 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HistoryStack05"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateHistoryStack05::dp_tclSpmDpEngStateHistoryStack05(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateHistoryStack05::vStore() {
    dp_tclBaseElement myDpElem("HistoryStack05", (tS32)0x1119492d);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHistoryStack05::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateHistoryStack05::vUpdate() {
   dp_tclBaseElement myDpElem("HistoryStack05", (tS32)0x1119492d);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateHistoryStack05::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateHistoryStack05::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateHistoryStack05::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateHistoryStack05::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateHistoryStack05::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateHistoryStack05::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateHistoryStack05::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateHistoryStack05::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack05", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateHistoryStack05::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "HistoryStack05", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateHistoryStack05::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HistoryStack05", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element HistoryStack05 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastHistoryStack"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateLastHistoryStack::dp_tclSpmDpEngStateLastHistoryStack(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastHistoryStack,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngStateLastHistoryStack::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastHistoryStack",(tS32) 0x425dd110);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLastHistoryStack = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngStateLastHistoryStack::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastHistoryStack", (tS32)0x425dd110);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastHistoryStack, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngStateLastHistoryStack::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngStateLastHistoryStack::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngStateLastHistoryStack::tGetData() {
   vUpdate();
   return tLastHistoryStack;
};
tS32 dp_tclSpmDpEngStateLastHistoryStack::s32GetData(tU32& tLastHistoryStackParam) { 
   vUpdate();
   tLastHistoryStackParam = tLastHistoryStack;
   return _s32Status;
}
tS32 dp_tclSpmDpEngStateLastHistoryStack::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastHistoryStack", (tS32)0x425dd110);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngStateLastHistoryStack::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngStateLastHistoryStack::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngStateLastHistoryStack::s32SetData(tU32 &tLastHistoryStackParam) {
   //init parameter
   (tVoid)memcpy(&tLastHistoryStack,(tVoid*)&tLastHistoryStackParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastHistoryStackParam' in function 'dp_tclSpmDpEngStateLastHistoryStack::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngStateLastHistoryStack::s32SetData(const tU32 &tLastHistoryStackParam) {
   //init parameter
   (tVoid)memcpy(&tLastHistoryStack,(tVoid*)&tLastHistoryStackParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastHistoryStackParam' in function 'dp_tclSpmDpEngStateLastHistoryStack::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngStateLastHistoryStack::u8GetData(tU32& tLastHistoryStackParam) {  
   vUpdate();
   tLastHistoryStackParam = tLastHistoryStack;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngStateLastHistoryStack::vSetData(tU32 &tLastHistoryStackParam) { 
   //init parameter
   (tVoid)memcpy(&tLastHistoryStack,(tVoid*)&tLastHistoryStackParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastHistoryStackParam' in function 'dp_tclSpmDpEngStateLastHistoryStack::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngStateLastHistoryStack::vSetData(const tU32 &tLastHistoryStackParam) { 
   //init parameter
   (tVoid)memcpy(&tLastHistoryStack,(tVoid*)&tLastHistoryStackParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastHistoryStackParam' in function 'dp_tclSpmDpEngStateLastHistoryStack::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngStateLastHistoryStack::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngStateLastHistoryStack::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "LastHistoryStack", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngStateLastHistoryStack::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "LastHistoryStack", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngStateLastHistoryStack::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastHistoryStack", DP_U32_POOL_ID_SPMDPENGSTATE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
   }
   else
   {
      fprintf(stdout,"Element LastHistoryStack has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistory::dp_tclSpmDpEngStateCurrentSWVersionHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistory::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistory", (tS32)0x303ad6fd);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistory::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistory", (tS32)0x303ad6fd);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistory::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistory::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistory::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistory", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistoryStack01"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack01", (tS32)0x9495b224L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistoryStack01::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack01", (tS32)0x9495b224L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack01", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack01", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack01::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistoryStack01", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistoryStack01 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistoryStack02"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack02", (tS32)0x9495b225L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistoryStack02::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack02", (tS32)0x9495b225L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack02", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack02", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack02::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistoryStack02", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistoryStack02 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistoryStack03"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack03", (tS32)0x9495b226L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistoryStack03::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack03", (tS32)0x9495b226L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack03", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack03", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack03::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistoryStack03", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistoryStack03 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistoryStack04"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack04", (tS32)0x9495b227L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistoryStack04::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack04", (tS32)0x9495b227L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack04", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack04", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack04::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistoryStack04", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistoryStack04 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionHistoryStack05"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = SPM_U32_STATISTIC_MAX_ERR_ENTRIES_PER_STACKS;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::vStore() {
    dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack05", (tS32)0x9495b228L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TSpmSystemStateStatisticsData)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCurrentSWVersionHistoryStack05::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TSpmSystemStateStatisticsData));
                pCurPos += sizeof(TSpmSystemStateStatisticsData);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TSpmSystemStateStatisticsData))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::vUpdate() {
   dp_tclBaseElement myDpElem("CurrentSWVersionHistoryStack05", (tS32)0x9495b228L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TSpmSystemStateStatisticsData)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TSpmSystemStateStatisticsData));
         TSpmSystemStateStatisticsData* pBuffer = (TSpmSystemStateStatisticsData*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::s32GetElem(tU32 u32NbElem, TSpmSystemStateStatisticsData& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::vPushBack(TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::vPushBack(const TSpmSystemStateStatisticsData &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack05", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionHistoryStack05", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclSpmDpEngStateCurrentSWVersionHistoryStack05::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionHistoryStack05", DP_U32_POOL_ID_SPMDPENGSTATE);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
		}
		else
		{
			fprintf(stdout,"Element CurrentSWVersionHistoryStack05 has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CurrentSWVersionLastHistoryStack"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCurrentSWVersionLastHistoryStack,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CurrentSWVersionLastHistoryStack",(tS32) 0x19841193L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tCurrentSWVersionLastHistoryStack = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CurrentSWVersionLastHistoryStack", (tS32)0x19841193L);
   (tVoid)myDpElem.bFillData((tVoid*)&tCurrentSWVersionLastHistoryStack, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::tGetData() {
   vUpdate();
   return tCurrentSWVersionLastHistoryStack;
};
tS32 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::s32GetData(tU32& tCurrentSWVersionLastHistoryStackParam) { 
   vUpdate();
   tCurrentSWVersionLastHistoryStackParam = tCurrentSWVersionLastHistoryStack;
   return _s32Status;
}
tS32 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CurrentSWVersionLastHistoryStack", (tS32)0x19841193L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPMDPENGSTATE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::s32SetData(tU32 &tCurrentSWVersionLastHistoryStackParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastHistoryStack,(tVoid*)&tCurrentSWVersionLastHistoryStackParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionLastHistoryStackParam' in function 'dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(tU32)' could be made const reference
tS32 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::s32SetData(const tU32 &tCurrentSWVersionLastHistoryStackParam) {
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastHistoryStack,(tVoid*)&tCurrentSWVersionLastHistoryStackParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCurrentSWVersionLastHistoryStackParam' in function 'dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::u8GetData(tU32& tCurrentSWVersionLastHistoryStackParam) {  
   vUpdate();
   tCurrentSWVersionLastHistoryStackParam = tCurrentSWVersionLastHistoryStack;
   return _u8DataStatus;
}
tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(tU32 &tCurrentSWVersionLastHistoryStackParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastHistoryStack,(tVoid*)&tCurrentSWVersionLastHistoryStackParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionLastHistoryStackParam' in function 'dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(tU32)' could be made const reference
tVoid dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(const tU32 &tCurrentSWVersionLastHistoryStackParam) { 
   //init parameter
   (tVoid)memcpy(&tCurrentSWVersionLastHistoryStack,(tVoid*)&tCurrentSWVersionLastHistoryStackParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tCurrentSWVersionLastHistoryStackParam' in function 'dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::vSetData(tU32)' could be made const reference
tU8   dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionLastHistoryStack", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPMDPENGSTATE, "CurrentSWVersionLastHistoryStack", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpmDpEngStateCurrentSWVersionLastHistoryStack::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CurrentSWVersionLastHistoryStack", DP_U32_POOL_ID_SPMDPENGSTATE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPMDPENGSTATE);
   }
   else
   {
      fprintf(stdout,"Element CurrentSWVersionLastHistoryStack has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
