#ifndef _DP_FI_SPMDPCONFIG_H
#define _DP_FI_SPMDPCONFIG_H

extern tVoid vInitSpmDpConfig(tU8 u8Bank=DP_U8_NO_BANK_ACTION);





//lint -e750
#define SPM_S_IMPORT_INTERFACE_DP_SPM 
#include "spm_if.h"
//lint +e750




class dp_tclSpmDpConfigStandbyTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStandbyTime;
   
public:
   dp_tclSpmDpConfigStandbyTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigStandbyTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStandbyTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStandbyTimeParam);
   tS32  s32SetData(const tU32 &tStandbyTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStandbyTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStandbyTimeParam);
   tVoid vSetData(const tU32& tStandbyTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigDevStandbyTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDevStandbyTime;
   
public:
   dp_tclSpmDpConfigDevStandbyTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigDevStandbyTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDevStandbyTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDevStandbyTimeParam);
   tS32  s32SetData(const tU32 &tDevStandbyTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDevStandbyTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDevStandbyTimeParam);
   tVoid vSetData(const tU32& tDevStandbyTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigStateProfileStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tStateProfileStatus;
   
public:
   dp_tclSpmDpConfigStateProfileStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigStateProfileStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tStateProfileStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tStateProfileStatusParam);
   tS32  s32SetData(const tBool &tStateProfileStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tStateProfileStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tStateProfileStatusParam);
   tVoid vSetData(const tBool& tStateProfileStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigStateProfileTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tStateProfileTime;
   
public:
   dp_tclSpmDpConfigStateProfileTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigStateProfileTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tStateProfileTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tStateProfileTimeParam);
   tS32  s32SetData(const tU32 &tStateProfileTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tStateProfileTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tStateProfileTimeParam);
   tVoid vSetData(const tU32& tStateProfileTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigIgnitionOffTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tIgnitionOffTime;
   
public:
   dp_tclSpmDpConfigIgnitionOffTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigIgnitionOffTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tIgnitionOffTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tIgnitionOffTimeParam);
   tS32  s32SetData(const tU32 &tIgnitionOffTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tIgnitionOffTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tIgnitionOffTimeParam);
   tVoid vSetData(const tU32& tIgnitionOffTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigDisableCyclicResetHandling{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tDisableCyclicResetHandling;
   
public:
   dp_tclSpmDpConfigDisableCyclicResetHandling(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigDisableCyclicResetHandling() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tDisableCyclicResetHandlingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tDisableCyclicResetHandlingParam);
   tS32  s32SetData(const tBool &tDisableCyclicResetHandlingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tDisableCyclicResetHandlingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tDisableCyclicResetHandlingParam);
   tVoid vSetData(const tBool& tDisableCyclicResetHandlingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigSystemStateMachine{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSystemStateMachine;
   
public:
   dp_tclSpmDpConfigSystemStateMachine(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigSystemStateMachine() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSystemStateMachineParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSystemStateMachineParam);
   tS32  s32SetData(const tU32 &tSystemStateMachineParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSystemStateMachineParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSystemStateMachineParam);
   tVoid vSetData(const tU32& tSystemStateMachineParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigNaviStandbyTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tNaviStandbyTime;
   
public:
   dp_tclSpmDpConfigNaviStandbyTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigNaviStandbyTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tNaviStandbyTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tNaviStandbyTimeParam);
   tS32  s32SetData(const tU32 &tNaviStandbyTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tNaviStandbyTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tNaviStandbyTimeParam);
   tVoid vSetData(const tU32& tNaviStandbyTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigBackgroundTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tBackgroundTime;
   
public:
   dp_tclSpmDpConfigBackgroundTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigBackgroundTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tBackgroundTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tBackgroundTimeParam);
   tS32  s32SetData(const tU32 &tBackgroundTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tBackgroundTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tBackgroundTimeParam);
   tVoid vSetData(const tU32& tBackgroundTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigDoorOpenTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDoorOpenTime;
   
public:
   dp_tclSpmDpConfigDoorOpenTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigDoorOpenTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDoorOpenTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDoorOpenTimeParam);
   tS32  s32SetData(const tU32 &tDoorOpenTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDoorOpenTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDoorOpenTimeParam);
   tVoid vSetData(const tU32& tDoorOpenTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigClockDisplayTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tClockDisplayTime;
   
public:
   dp_tclSpmDpConfigClockDisplayTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigClockDisplayTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tClockDisplayTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tClockDisplayTimeParam);
   tS32  s32SetData(const tU32 &tClockDisplayTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tClockDisplayTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tClockDisplayTimeParam);
   tVoid vSetData(const tU32& tClockDisplayTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigDownloadTime{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tDownloadTime;
   
public:
   dp_tclSpmDpConfigDownloadTime(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigDownloadTime() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tDownloadTimeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tDownloadTimeParam);
   tS32  s32SetData(const tU32 &tDownloadTimeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tDownloadTimeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tDownloadTimeParam);
   tVoid vSetData(const tU32& tDownloadTimeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigShutdownLevel{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tShutdownLevel;
   
public:
   dp_tclSpmDpConfigShutdownLevel();
   virtual ~dp_tclSpmDpConfigShutdownLevel(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tShutdownLevelParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigMissingProcRst{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tMissingProcRst;
   
public:
   dp_tclSpmDpConfigMissingProcRst();
   virtual ~dp_tclSpmDpConfigMissingProcRst(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tMissingProcRstParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigEarlyFuncAllowed{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tEarlyFuncAllowed;
   
public:
   dp_tclSpmDpConfigEarlyFuncAllowed();
   virtual ~dp_tclSpmDpConfigEarlyFuncAllowed(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tEarlyFuncAllowedParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigStartupSystemUp{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tStartupSystemUp;
   
public:
   dp_tclSpmDpConfigStartupSystemUp();
   virtual ~dp_tclSpmDpConfigStartupSystemUp(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tStartupSystemUpParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigStartupSystemRunning{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tStartupSystemRunning;
   
public:
   dp_tclSpmDpConfigStartupSystemRunning();
   virtual ~dp_tclSpmDpConfigStartupSystemRunning(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tStartupSystemRunningParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tMaxResetCount2StartMinTargetLcm;
   
public:
   dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm();
   virtual ~dp_tclSpmDpConfigMaxResetCount2StartMinTargetLcm(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tMaxResetCount2StartMinTargetLcmParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tMaxResetCount2StartMinTargetBootloader;
   
public:
   dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader();
   virtual ~dp_tclSpmDpConfigMaxResetCount2StartMinTargetBootloader(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tMaxResetCount2StartMinTargetBootloaderParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigLowVoltageShutdownTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tLowVoltageShutdownTime;
   
public:
   dp_tclSpmDpConfigLowVoltageShutdownTime();
   virtual ~dp_tclSpmDpConfigLowVoltageShutdownTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tLowVoltageShutdownTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCriticalLowVoltageShutdownTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCriticalLowVoltageShutdownTime;
   
public:
   dp_tclSpmDpConfigCriticalLowVoltageShutdownTime();
   virtual ~dp_tclSpmDpConfigCriticalLowVoltageShutdownTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCriticalLowVoltageShutdownTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigInitialSystemState{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tInitialSystemState;
   
public:
   dp_tclSpmDpConfigInitialSystemState();
   virtual ~dp_tclSpmDpConfigInitialSystemState(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tInitialSystemStateParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigInitialTrigger{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tInitialTrigger;
   
public:
   dp_tclSpmDpConfigInitialTrigger();
   virtual ~dp_tclSpmDpConfigInitialTrigger(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tInitialTriggerParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigLongPressEject{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tLongPressEject;
   
public:
   dp_tclSpmDpConfigLongPressEject();
   virtual ~dp_tclSpmDpConfigLongPressEject(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tLongPressEjectParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCpuLoadOverallThreshold{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuLoadOverallThreshold;
   
public:
   dp_tclSpmDpConfigCpuLoadOverallThreshold();
   virtual ~dp_tclSpmDpConfigCpuLoadOverallThreshold(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuLoadOverallThresholdParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCpuLoadProcessThreshold{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuLoadProcessThreshold;
   
public:
   dp_tclSpmDpConfigCpuLoadProcessThreshold();
   virtual ~dp_tclSpmDpConfigCpuLoadProcessThreshold(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuLoadProcessThresholdParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCpuLoadPerWarnTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuLoadPerWarnTime;
   
public:
   dp_tclSpmDpConfigCpuLoadPerWarnTime();
   virtual ~dp_tclSpmDpConfigCpuLoadPerWarnTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuLoadPerWarnTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCpuLoadWarnTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCpuLoadWarnTime;
   
public:
   dp_tclSpmDpConfigCpuLoadWarnTime();
   virtual ~dp_tclSpmDpConfigCpuLoadWarnTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCpuLoadWarnTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCpuLoadWarnInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tCpuLoadWarnInfo;
   
public:
   dp_tclSpmDpConfigCpuLoadWarnInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigCpuLoadWarnInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tCpuLoadWarnInfoParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tCpuLoadWarnInfoParam);
   tS32  s32SetData(const tBool &tCpuLoadWarnInfoParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tCpuLoadWarnInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tCpuLoadWarnInfoParam);
   tVoid vSetData(const tBool& tCpuLoadWarnInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpmDpConfigWdtHeartbeatResetTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tWdtHeartbeatResetTime;
   
public:
   dp_tclSpmDpConfigWdtHeartbeatResetTime();
   virtual ~dp_tclSpmDpConfigWdtHeartbeatResetTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tWdtHeartbeatResetTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigWdtCcaHeartbeatTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tWdtCcaHeartbeatTime;
   
public:
   dp_tclSpmDpConfigWdtCcaHeartbeatTime();
   virtual ~dp_tclSpmDpConfigWdtCcaHeartbeatTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tWdtCcaHeartbeatTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigCcaMsgWaitTimeout{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tCcaMsgWaitTimeout;
   
public:
   dp_tclSpmDpConfigCcaMsgWaitTimeout();
   virtual ~dp_tclSpmDpConfigCcaMsgWaitTimeout(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tCcaMsgWaitTimeoutParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigWatermarkConfigFile{
private:
   tU8 _u8DataStatus;
public:
   dp_tclSpmDpConfigWatermarkConfigFile(): 
       _u8DataStatus(DP_U8_ELEM_STATUS_INITVAL)
   {};
   virtual ~dp_tclSpmDpConfigWatermarkConfigFile(){
   };
   
   tU8   u8GetData(tString &tWatermarkConfigFileParam, tU32 u32StringBufLen);
   tU8   u8GetData(const tString &tWatermarkConfigFileParam, tU32 u32StringBufLen);
   tU8   u8DataValid() const;
   

};

class dp_tclSpmDpConfigNetworkTimeoutErrorCount{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tNetworkTimeoutErrorCount;
   
public:
   dp_tclSpmDpConfigNetworkTimeoutErrorCount();
   virtual ~dp_tclSpmDpConfigNetworkTimeoutErrorCount(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tNetworkTimeoutErrorCountParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigNetworkTimeoutErrorTime{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tNetworkTimeoutErrorTime;
   
public:
   dp_tclSpmDpConfigNetworkTimeoutErrorTime();
   virtual ~dp_tclSpmDpConfigNetworkTimeoutErrorTime(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tNetworkTimeoutErrorTimeParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigResetDisable{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tResetDisable;
   
public:
   dp_tclSpmDpConfigResetDisable();
   virtual ~dp_tclSpmDpConfigResetDisable(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tResetDisableParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigStartupControllerFinish{
private:
   tU8 _u8DataStatus;
   tVoid vUpdate(tVoid);
   tU32 tStartupControllerFinish;
   
public:
   dp_tclSpmDpConfigStartupControllerFinish();
   virtual ~dp_tclSpmDpConfigStartupControllerFinish(){};
   
   tU32 tGetData();
   tU8   u8GetData(tU32& tStartupControllerFinishParam);
   tU8   u8DataValid() const;
   tVoid operator>>(tU32& oParam);


};

class dp_tclSpmDpConfigFakeDeviceConfig{
private:
   tU8   _u8DataStatus;
   tU16  _u16AccessId;
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid) const;
   
   tBool tFakeDeviceConfig;
   

public:
   dp_tclSpmDpConfigFakeDeviceConfig(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpmDpConfigFakeDeviceConfig() {};

   tU8   u8DataValid() const;
   
   tVoid vSetData(tBool &tFakeDeviceConfigParam);
   tVoid vSetData(const tBool &tFakeDeviceConfigParam);
   tVoid operator<<(tBool oParam);

   tBool tGetData();
   tU8   u8GetData(tBool& tFakeDeviceConfigParam);
   tVoid operator>>(tBool& oParam);

};

#endif
