#ifndef _DP_FI_SPIDPINTERNALDATA_H
#define _DP_FI_SPIDPINTERNALDATA_H

extern tVoid vInitSpiDpInternalData(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define SPI_S_IMPORT_INTERFACE_DP_SPI 
#include "smartphoneintegration_if.h"
//lint +e750




class dp_tclSpiDpInternalDataMLNotificationSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMLNotificationSetting;
   
public:
   dp_tclSpiDpInternalDataMLNotificationSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataMLNotificationSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMLNotificationSettingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMLNotificationSettingParam);
   tS32  s32SetData(const tBool &tMLNotificationSettingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMLNotificationSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMLNotificationSettingParam);
   tVoid vSetData(const tBool& tMLNotificationSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataMirrorLinkEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tMirrorLinkEnableSetting;
   
public:
   dp_tclSpiDpInternalDataMirrorLinkEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataMirrorLinkEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tMirrorLinkEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tMirrorLinkEnableSettingParam);
   tS32  s32SetData(const tU8 &tMirrorLinkEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tMirrorLinkEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tMirrorLinkEnableSettingParam);
   tVoid vSetData(const tU8& tMirrorLinkEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataDipoEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDipoEnableSetting;
   
public:
   dp_tclSpiDpInternalDataDipoEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataDipoEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDipoEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDipoEnableSettingParam);
   tS32  s32SetData(const tU8 &tDipoEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDipoEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDipoEnableSettingParam);
   tVoid vSetData(const tU8& tDipoEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataAAPEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAAPEnableSetting;
   
public:
   dp_tclSpiDpInternalDataAAPEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataAAPEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAAPEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAAPEnableSettingParam);
   tS32  s32SetData(const tU8 &tAAPEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAAPEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAAPEnableSettingParam);
   tVoid vSetData(const tU8& tAAPEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDatamySPINEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tmySPINEnableSetting;
   
public:
   dp_tclSpiDpInternalDatamySPINEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDatamySPINEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tmySPINEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tmySPINEnableSettingParam);
   tS32  s32SetData(const tU8 &tmySPINEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tmySPINEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tmySPINEnableSettingParam);
   tVoid vSetData(const tU8& tmySPINEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataCarlifeEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCarlifeEnableSetting;
   
public:
   dp_tclSpiDpInternalDataCarlifeEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataCarlifeEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCarlifeEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCarlifeEnableSettingParam);
   tS32  s32SetData(const tU8 &tCarlifeEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCarlifeEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCarlifeEnableSettingParam);
   tVoid vSetData(const tU8& tCarlifeEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataOnCarEnableSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tOnCarEnableSetting;
   
public:
   dp_tclSpiDpInternalDataOnCarEnableSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataOnCarEnableSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tOnCarEnableSettingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tOnCarEnableSettingParam);
   tS32  s32SetData(const tU8 &tOnCarEnableSettingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tOnCarEnableSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tOnCarEnableSettingParam);
   tVoid vSetData(const tU8& tOnCarEnableSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataBluetoothMACAddress{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclSpiDpInternalDataBluetoothMACAddress(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataBluetoothMACAddress() {};

   //read access for pool element 
   tS32  s32GetData(tString &tBluetoothMACAddressParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tBluetoothMACAddressParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tBluetoothMACAddressParam);
   tS32 s32SetData(const tString &tBluetoothMACAddressParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tBluetoothMACAddressParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tBluetoothMACAddressParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tBluetoothMACAddressParam);
   tVoid vSetData(const tString &tBluetoothMACAddressParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataScreenAttributes{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   trScreenProperties tScreenAttributes;
   
public:
   dp_tclSpiDpInternalDataScreenAttributes(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataScreenAttributes() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   trScreenProperties tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(trScreenProperties& tScreenAttributesParam);
   tVoid operator>>(trScreenProperties& oParam);
   
   //write access for pool element 
   tS32  s32SetData(trScreenProperties &tScreenAttributesParam);
   tS32  s32SetData(const trScreenProperties &tScreenAttributesParam);
   tVoid operator<<(trScreenProperties oParam);
   
   // do not use --> old interface
   tU8   u8GetData(trScreenProperties& tScreenAttributesParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(trScreenProperties& tScreenAttributesParam);
   tVoid vSetData(const trScreenProperties& tScreenAttributesParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tDipoGeneralRestrictionInfo;
   
public:
   dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tDipoGeneralRestrictionInfoParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tDipoGeneralRestrictionInfoParam);
   tS32  s32SetData(const tU16 &tDipoGeneralRestrictionInfoParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tDipoGeneralRestrictionInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tDipoGeneralRestrictionInfoParam);
   tVoid vSetData(const tU16& tDipoGeneralRestrictionInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tAAPGeneralRestrictionInfo;
   
public:
   dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tAAPGeneralRestrictionInfoParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tAAPGeneralRestrictionInfoParam);
   tS32  s32SetData(const tU16 &tAAPGeneralRestrictionInfoParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tAAPGeneralRestrictionInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tAAPGeneralRestrictionInfoParam);
   tVoid vSetData(const tU16& tAAPGeneralRestrictionInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataDiPODriveRestrictionInfo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDiPODriveRestrictionInfo;
   
public:
   dp_tclSpiDpInternalDataDiPODriveRestrictionInfo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataDiPODriveRestrictionInfo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDiPODriveRestrictionInfoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDiPODriveRestrictionInfoParam);
   tS32  s32SetData(const tU8 &tDiPODriveRestrictionInfoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDiPODriveRestrictionInfoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDiPODriveRestrictionInfoParam);
   tVoid vSetData(const tU8& tDiPODriveRestrictionInfoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataSteeringWheelPosition{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tenSteeringWheelPosition tSteeringWheelPosition;
   
public:
   dp_tclSpiDpInternalDataSteeringWheelPosition(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataSteeringWheelPosition() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tenSteeringWheelPosition tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tenSteeringWheelPosition& tSteeringWheelPositionParam);
   tVoid operator>>(tenSteeringWheelPosition& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tenSteeringWheelPosition &tSteeringWheelPositionParam);
   tS32  s32SetData(const tenSteeringWheelPosition &tSteeringWheelPositionParam);
   tVoid operator<<(tenSteeringWheelPosition oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tenSteeringWheelPosition& tSteeringWheelPositionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tenSteeringWheelPosition& tSteeringWheelPositionParam);
   tVoid vSetData(const tenSteeringWheelPosition& tSteeringWheelPositionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataVehicleID{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclSpiDpInternalDataVehicleID(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataVehicleID() {};

   //read access for pool element 
   tS32  s32GetData(tString &tVehicleIDParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tVehicleIDParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tVehicleIDParam);
   tS32 s32SetData(const tString &tVehicleIDParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tVehicleIDParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tVehicleIDParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tVehicleIDParam);
   tVoid vSetData(const tString &tVehicleIDParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAndroidDeviceTechnologyPreference;
   
public:
   dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAndroidDeviceTechnologyPreferenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAndroidDeviceTechnologyPreferenceParam);
   tS32  s32SetData(const tU8 &tAndroidDeviceTechnologyPreferenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAndroidDeviceTechnologyPreferenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAndroidDeviceTechnologyPreferenceParam);
   tVoid vSetData(const tU8& tAndroidDeviceTechnologyPreferenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tAppleDeviceTechnologyPreference;
   
public:
   dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tAppleDeviceTechnologyPreferenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tAppleDeviceTechnologyPreferenceParam);
   tS32  s32SetData(const tU8 &tAppleDeviceTechnologyPreferenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tAppleDeviceTechnologyPreferenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tAppleDeviceTechnologyPreferenceParam);
   tVoid vSetData(const tU8& tAppleDeviceTechnologyPreferenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataSelectionMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSelectionMode;
   
public:
   dp_tclSpiDpInternalDataSelectionMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataSelectionMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSelectionModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSelectionModeParam);
   tS32  s32SetData(const tU8 &tSelectionModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSelectionModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSelectionModeParam);
   tVoid vSetData(const tU8& tSelectionModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataVirginStart{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVirginStart;
   
public:
   dp_tclSpiDpInternalDataVirginStart(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataVirginStart() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVirginStartParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVirginStartParam);
   tS32  s32SetData(const tU8 &tVirginStartParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVirginStartParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVirginStartParam);
   tVoid vSetData(const tU8& tVirginStartParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataSPIVersion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclSpiDpInternalDataSPIVersion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataSPIVersion() {};

   //read access for pool element 
   tS32  s32GetData(tString &tSPIVersionParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tSPIVersionParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tSPIVersionParam);
   tS32 s32SetData(const tString &tSPIVersionParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tSPIVersionParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tSPIVersionParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tSPIVersionParam);
   tVoid vSetData(const tString &tSPIVersionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataVehicleManufacturerInformation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   trVMInfo tVehicleManufacturerInformation;
   
public:
   dp_tclSpiDpInternalDataVehicleManufacturerInformation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataVehicleManufacturerInformation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   trVMInfo tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(trVMInfo& tVehicleManufacturerInformationParam);
   tVoid operator>>(trVMInfo& oParam);
   
   //write access for pool element 
   tS32  s32SetData(trVMInfo &tVehicleManufacturerInformationParam);
   tS32  s32SetData(const trVMInfo &tVehicleManufacturerInformationParam);
   tVoid operator<<(trVMInfo oParam);
   
   // do not use --> old interface
   tU8   u8GetData(trVMInfo& tVehicleManufacturerInformationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(trVMInfo& tVehicleManufacturerInformationParam);
   tVoid vSetData(const trVMInfo& tVehicleManufacturerInformationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataDisplayLastMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tDisplayLastMode;
   
public:
   dp_tclSpiDpInternalDataDisplayLastMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataDisplayLastMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tDisplayLastModeParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tDisplayLastModeParam);
   tS32  s32SetData(const tBool &tDisplayLastModeParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tDisplayLastModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tDisplayLastModeParam);
   tVoid vSetData(const tBool& tDisplayLastModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDataAudioLastMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tAudioLastMode;
   
public:
   dp_tclSpiDpInternalDataAudioLastMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDataAudioLastMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tAudioLastModeParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tAudioLastModeParam);
   tS32  s32SetData(const tBool &tAudioLastModeParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tAudioLastModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tAudioLastModeParam);
   tVoid vSetData(const tBool& tAudioLastModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclSpiDpInternalDatau32AASuppHardKeysArr{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclSpiDpInternalDatau32AASuppHardKeysArr(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDatau32AASuppHardKeysArr() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

class dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   
   
public:
   dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr() {};

   //read access for pool element 
   tS32  s32GetData(tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //write access for pool element 
   tS32 s32SetData(tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize);
   
   //old interface -> change to s32GetData()
   tU16  u16GetData(tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);
};

#endif
