
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclSpiDpInternalData.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MLNotificationSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataMLNotificationSetting::dp_tclSpiDpInternalDataMLNotificationSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMLNotificationSetting,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataMLNotificationSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MLNotificationSetting",(tS32) 0xccf23b4e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMLNotificationSetting = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataMLNotificationSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MLNotificationSetting", (tS32)0xccf23b4e);
   (tVoid)myDpElem.bFillData((tVoid*)&tMLNotificationSetting, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataMLNotificationSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataMLNotificationSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpiDpInternalDataMLNotificationSetting::tGetData() {
   vUpdate();
   return tMLNotificationSetting;
};
tS32 dp_tclSpiDpInternalDataMLNotificationSetting::s32GetData(tBool& tMLNotificationSettingParam) { 
   vUpdate();
   tMLNotificationSettingParam = tMLNotificationSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataMLNotificationSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MLNotificationSetting", (tS32)0xccf23b4e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataMLNotificationSetting::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataMLNotificationSetting::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataMLNotificationSetting::s32SetData(tBool &tMLNotificationSettingParam) {
   //init parameter
   (tVoid)memcpy(&tMLNotificationSetting,(tVoid*)&tMLNotificationSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMLNotificationSettingParam' in function 'dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(tBool)' could be made const reference
tS32 dp_tclSpiDpInternalDataMLNotificationSetting::s32SetData(const tBool &tMLNotificationSettingParam) {
   //init parameter
   (tVoid)memcpy(&tMLNotificationSetting,(tVoid*)&tMLNotificationSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMLNotificationSettingParam' in function 'dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataMLNotificationSetting::u8GetData(tBool& tMLNotificationSettingParam) {  
   vUpdate();
   tMLNotificationSettingParam = tMLNotificationSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(tBool &tMLNotificationSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tMLNotificationSetting,(tVoid*)&tMLNotificationSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMLNotificationSettingParam' in function 'dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(tBool)' could be made const reference
tVoid dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(const tBool &tMLNotificationSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tMLNotificationSetting,(tVoid*)&tMLNotificationSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMLNotificationSettingParam' in function 'dp_tclSpiDpInternalDataMLNotificationSetting::vSetData(tBool)' could be made const reference
tU8   dp_tclSpiDpInternalDataMLNotificationSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataMLNotificationSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "MLNotificationSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataMLNotificationSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "MLNotificationSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataMLNotificationSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MLNotificationSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element MLNotificationSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MirrorLinkEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataMirrorLinkEnableSetting::dp_tclSpiDpInternalDataMirrorLinkEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMirrorLinkEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MirrorLinkEnableSetting",(tS32) 0xfcc56b3a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMirrorLinkEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MirrorLinkEnableSetting", (tS32)0xfcc56b3a);
   (tVoid)myDpElem.bFillData((tVoid*)&tMirrorLinkEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataMirrorLinkEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataMirrorLinkEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::tGetData() {
   vUpdate();
   return tMirrorLinkEnableSetting;
};
tS32 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::s32GetData(tU8& tMirrorLinkEnableSettingParam) { 
   vUpdate();
   tMirrorLinkEnableSettingParam = tMirrorLinkEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MirrorLinkEnableSetting", (tS32)0xfcc56b3a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::s32SetData(tU8 &tMirrorLinkEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tMirrorLinkEnableSetting,(tVoid*)&tMirrorLinkEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMirrorLinkEnableSettingParam' in function 'dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::s32SetData(const tU8 &tMirrorLinkEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tMirrorLinkEnableSetting,(tVoid*)&tMirrorLinkEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMirrorLinkEnableSettingParam' in function 'dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataMirrorLinkEnableSetting::u8GetData(tU8& tMirrorLinkEnableSettingParam) {  
   vUpdate();
   tMirrorLinkEnableSettingParam = tMirrorLinkEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(tU8 &tMirrorLinkEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tMirrorLinkEnableSetting,(tVoid*)&tMirrorLinkEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMirrorLinkEnableSettingParam' in function 'dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(const tU8 &tMirrorLinkEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tMirrorLinkEnableSetting,(tVoid*)&tMirrorLinkEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMirrorLinkEnableSettingParam' in function 'dp_tclSpiDpInternalDataMirrorLinkEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataMirrorLinkEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataMirrorLinkEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "MirrorLinkEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataMirrorLinkEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "MirrorLinkEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataMirrorLinkEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MirrorLinkEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element MirrorLinkEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DipoEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataDipoEnableSetting::dp_tclSpiDpInternalDataDipoEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDipoEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataDipoEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DipoEnableSetting",(tS32) 0x13241699);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDipoEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataDipoEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DipoEnableSetting", (tS32)0x13241699);
   (tVoid)myDpElem.bFillData((tVoid*)&tDipoEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataDipoEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataDipoEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataDipoEnableSetting::tGetData() {
   vUpdate();
   return tDipoEnableSetting;
};
tS32 dp_tclSpiDpInternalDataDipoEnableSetting::s32GetData(tU8& tDipoEnableSettingParam) { 
   vUpdate();
   tDipoEnableSettingParam = tDipoEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataDipoEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DipoEnableSetting", (tS32)0x13241699);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataDipoEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataDipoEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataDipoEnableSetting::s32SetData(tU8 &tDipoEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tDipoEnableSetting,(tVoid*)&tDipoEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDipoEnableSettingParam' in function 'dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataDipoEnableSetting::s32SetData(const tU8 &tDipoEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tDipoEnableSetting,(tVoid*)&tDipoEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDipoEnableSettingParam' in function 'dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataDipoEnableSetting::u8GetData(tU8& tDipoEnableSettingParam) {  
   vUpdate();
   tDipoEnableSettingParam = tDipoEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(tU8 &tDipoEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tDipoEnableSetting,(tVoid*)&tDipoEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDipoEnableSettingParam' in function 'dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(const tU8 &tDipoEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tDipoEnableSetting,(tVoid*)&tDipoEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDipoEnableSettingParam' in function 'dp_tclSpiDpInternalDataDipoEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataDipoEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataDipoEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DipoEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDipoEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DipoEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDipoEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DipoEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element DipoEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AAPEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataAAPEnableSetting::dp_tclSpiDpInternalDataAAPEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAAPEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataAAPEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AAPEnableSetting",(tS32) 0x691ed07b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAAPEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataAAPEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AAPEnableSetting", (tS32)0x691ed07b);
   (tVoid)myDpElem.bFillData((tVoid*)&tAAPEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataAAPEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataAAPEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataAAPEnableSetting::tGetData() {
   vUpdate();
   return tAAPEnableSetting;
};
tS32 dp_tclSpiDpInternalDataAAPEnableSetting::s32GetData(tU8& tAAPEnableSettingParam) { 
   vUpdate();
   tAAPEnableSettingParam = tAAPEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataAAPEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AAPEnableSetting", (tS32)0x691ed07b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataAAPEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataAAPEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataAAPEnableSetting::s32SetData(tU8 &tAAPEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAAPEnableSetting,(tVoid*)&tAAPEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAAPEnableSettingParam' in function 'dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataAAPEnableSetting::s32SetData(const tU8 &tAAPEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tAAPEnableSetting,(tVoid*)&tAAPEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAAPEnableSettingParam' in function 'dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataAAPEnableSetting::u8GetData(tU8& tAAPEnableSettingParam) {  
   vUpdate();
   tAAPEnableSettingParam = tAAPEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(tU8 &tAAPEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAAPEnableSetting,(tVoid*)&tAAPEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAAPEnableSettingParam' in function 'dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(const tU8 &tAAPEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tAAPEnableSetting,(tVoid*)&tAAPEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAAPEnableSettingParam' in function 'dp_tclSpiDpInternalDataAAPEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataAAPEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataAAPEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AAPEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAAPEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AAPEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAAPEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AAPEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element AAPEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "mySPINEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDatamySPINEnableSetting::dp_tclSpiDpInternalDatamySPINEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tmySPINEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("mySPINEnableSetting",(tS32) 0xe8ff2ff1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tmySPINEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("mySPINEnableSetting", (tS32)0xe8ff2ff1);
   (tVoid)myDpElem.bFillData((tVoid*)&tmySPINEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDatamySPINEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDatamySPINEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDatamySPINEnableSetting::tGetData() {
   vUpdate();
   return tmySPINEnableSetting;
};
tS32 dp_tclSpiDpInternalDatamySPINEnableSetting::s32GetData(tU8& tmySPINEnableSettingParam) { 
   vUpdate();
   tmySPINEnableSettingParam = tmySPINEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDatamySPINEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("mySPINEnableSetting", (tS32)0xe8ff2ff1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDatamySPINEnableSetting::s32SetData(tU8 &tmySPINEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tmySPINEnableSetting,(tVoid*)&tmySPINEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tmySPINEnableSettingParam' in function 'dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDatamySPINEnableSetting::s32SetData(const tU8 &tmySPINEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tmySPINEnableSetting,(tVoid*)&tmySPINEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tmySPINEnableSettingParam' in function 'dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDatamySPINEnableSetting::u8GetData(tU8& tmySPINEnableSettingParam) {  
   vUpdate();
   tmySPINEnableSettingParam = tmySPINEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(tU8 &tmySPINEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tmySPINEnableSetting,(tVoid*)&tmySPINEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tmySPINEnableSettingParam' in function 'dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(const tU8 &tmySPINEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tmySPINEnableSetting,(tVoid*)&tmySPINEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tmySPINEnableSettingParam' in function 'dp_tclSpiDpInternalDatamySPINEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDatamySPINEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDatamySPINEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "mySPINEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDatamySPINEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "mySPINEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDatamySPINEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: mySPINEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element mySPINEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CarlifeEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataCarlifeEnableSetting::dp_tclSpiDpInternalDataCarlifeEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCarlifeEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CarlifeEnableSetting",(tS32) 0xa709e7bf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCarlifeEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CarlifeEnableSetting", (tS32)0xa709e7bf);
   (tVoid)myDpElem.bFillData((tVoid*)&tCarlifeEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataCarlifeEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataCarlifeEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataCarlifeEnableSetting::tGetData() {
   vUpdate();
   return tCarlifeEnableSetting;
};
tS32 dp_tclSpiDpInternalDataCarlifeEnableSetting::s32GetData(tU8& tCarlifeEnableSettingParam) { 
   vUpdate();
   tCarlifeEnableSettingParam = tCarlifeEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataCarlifeEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CarlifeEnableSetting", (tS32)0xa709e7bf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataCarlifeEnableSetting::s32SetData(tU8 &tCarlifeEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tCarlifeEnableSetting,(tVoid*)&tCarlifeEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCarlifeEnableSettingParam' in function 'dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataCarlifeEnableSetting::s32SetData(const tU8 &tCarlifeEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tCarlifeEnableSetting,(tVoid*)&tCarlifeEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCarlifeEnableSettingParam' in function 'dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataCarlifeEnableSetting::u8GetData(tU8& tCarlifeEnableSettingParam) {  
   vUpdate();
   tCarlifeEnableSettingParam = tCarlifeEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(tU8 &tCarlifeEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tCarlifeEnableSetting,(tVoid*)&tCarlifeEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCarlifeEnableSettingParam' in function 'dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(const tU8 &tCarlifeEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tCarlifeEnableSetting,(tVoid*)&tCarlifeEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCarlifeEnableSettingParam' in function 'dp_tclSpiDpInternalDataCarlifeEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataCarlifeEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataCarlifeEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "CarlifeEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataCarlifeEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "CarlifeEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataCarlifeEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CarlifeEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element CarlifeEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "OnCarEnableSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataOnCarEnableSetting::dp_tclSpiDpInternalDataOnCarEnableSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tOnCarEnableSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("OnCarEnableSetting",(tS32) 0xf6b36e38);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tOnCarEnableSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("OnCarEnableSetting", (tS32)0xf6b36e38);
   (tVoid)myDpElem.bFillData((tVoid*)&tOnCarEnableSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataOnCarEnableSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataOnCarEnableSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataOnCarEnableSetting::tGetData() {
   vUpdate();
   return tOnCarEnableSetting;
};
tS32 dp_tclSpiDpInternalDataOnCarEnableSetting::s32GetData(tU8& tOnCarEnableSettingParam) { 
   vUpdate();
   tOnCarEnableSettingParam = tOnCarEnableSetting;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataOnCarEnableSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("OnCarEnableSetting", (tS32)0xf6b36e38);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataOnCarEnableSetting::s32SetData(tU8 &tOnCarEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tOnCarEnableSetting,(tVoid*)&tOnCarEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOnCarEnableSettingParam' in function 'dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataOnCarEnableSetting::s32SetData(const tU8 &tOnCarEnableSettingParam) {
   //init parameter
   (tVoid)memcpy(&tOnCarEnableSetting,(tVoid*)&tOnCarEnableSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tOnCarEnableSettingParam' in function 'dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataOnCarEnableSetting::u8GetData(tU8& tOnCarEnableSettingParam) {  
   vUpdate();
   tOnCarEnableSettingParam = tOnCarEnableSetting;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(tU8 &tOnCarEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tOnCarEnableSetting,(tVoid*)&tOnCarEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOnCarEnableSettingParam' in function 'dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(const tU8 &tOnCarEnableSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tOnCarEnableSetting,(tVoid*)&tOnCarEnableSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tOnCarEnableSettingParam' in function 'dp_tclSpiDpInternalDataOnCarEnableSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataOnCarEnableSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataOnCarEnableSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "OnCarEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataOnCarEnableSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "OnCarEnableSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataOnCarEnableSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: OnCarEnableSetting", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element OnCarEnableSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BluetoothMACAddress"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataBluetoothMACAddress::dp_tclSpiDpInternalDataBluetoothMACAddress(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclSpiDpInternalDataBluetoothMACAddress::s32SetData(tString &tBluetoothMACAddressParam) {
   tU32 u32Len = (tU32)strlen(tBluetoothMACAddressParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("BluetoothMACAddress", (tS32)0xdd7d321);
      (tVoid)myDpElem.bFillData((tVoid*)tBluetoothMACAddressParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataBluetoothMACAddress::s32SetData(const tString &tBluetoothMACAddressParam) {
   tU32 u32Len = (tU32)strlen(tBluetoothMACAddressParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("BluetoothMACAddress", (tS32)0xdd7d321);
      (tVoid)myDpElem.bFillData((tVoid*)tBluetoothMACAddressParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataBluetoothMACAddress::s32GetData(tString &tBluetoothMACAddressParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("BluetoothMACAddress", (tS32)0xdd7d321);
   (tVoid)memset(tBluetoothMACAddressParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tBluetoothMACAddressParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataBluetoothMACAddress::s32GetData(const tString &tBluetoothMACAddressParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("BluetoothMACAddress", (tS32)0xdd7d321);
   (tVoid)memset(tBluetoothMACAddressParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tBluetoothMACAddressParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclSpiDpInternalDataBluetoothMACAddress::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDataBluetoothMACAddress::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclSpiDpInternalDataBluetoothMACAddress::u32GetData(tString &tBluetoothMACAddressParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tBluetoothMACAddressParam, u32StringBufLen);
   };
    tU32  dp_tclSpiDpInternalDataBluetoothMACAddress::u32GetData(const tString &tBluetoothMACAddressParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tBluetoothMACAddressParam, u32StringBufLen);
   };
   tVoid dp_tclSpiDpInternalDataBluetoothMACAddress::vSetData(tString &tBluetoothMACAddressParam){(tVoid)s32SetData(tBluetoothMACAddressParam);};
   tVoid dp_tclSpiDpInternalDataBluetoothMACAddress::vSetData(const tString &tBluetoothMACAddressParam){(tVoid)s32SetData(tBluetoothMACAddressParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDataBluetoothMACAddress::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "BluetoothMACAddress", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataBluetoothMACAddress::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "BluetoothMACAddress", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataBluetoothMACAddress::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BluetoothMACAddress", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element BluetoothMACAddress has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ScreenAttributes"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataScreenAttributes::dp_tclSpiDpInternalDataScreenAttributes(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tScreenAttributes,0,sizeof(trScreenProperties));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataScreenAttributes::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ScreenAttributes",(tS32) 0x55c832f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(trScreenProperties)) 
      {
         tScreenAttributes = *((trScreenProperties*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataScreenAttributes::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ScreenAttributes", (tS32)0x55c832f);
   (tVoid)myDpElem.bFillData((tVoid*)&tScreenAttributes, (tU32)sizeof(trScreenProperties));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataScreenAttributes::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataScreenAttributes::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
trScreenProperties dp_tclSpiDpInternalDataScreenAttributes::tGetData() {
   vUpdate();
   return tScreenAttributes;
};
tS32 dp_tclSpiDpInternalDataScreenAttributes::s32GetData(trScreenProperties& tScreenAttributesParam) { 
   vUpdate();
   tScreenAttributesParam = tScreenAttributes;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataScreenAttributes::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ScreenAttributes", (tS32)0x55c832f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataScreenAttributes::operator>>(trScreenProperties& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataScreenAttributes::operator<<(trScreenProperties oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataScreenAttributes::s32SetData(trScreenProperties &tScreenAttributesParam) {
   //init parameter
   (tVoid)memcpy(&tScreenAttributes,(tVoid*)&tScreenAttributesParam, sizeof(trScreenProperties));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tScreenAttributesParam' in function 'dp_tclSpiDpInternalDataScreenAttributes::vSetData(trScreenProperties)' could be made const reference
tS32 dp_tclSpiDpInternalDataScreenAttributes::s32SetData(const trScreenProperties &tScreenAttributesParam) {
   //init parameter
   (tVoid)memcpy(&tScreenAttributes,(tVoid*)&tScreenAttributesParam, sizeof(trScreenProperties));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tScreenAttributesParam' in function 'dp_tclSpiDpInternalDataScreenAttributes::vSetData(trScreenProperties)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataScreenAttributes::u8GetData(trScreenProperties& tScreenAttributesParam) {  
   vUpdate();
   tScreenAttributesParam = tScreenAttributes;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataScreenAttributes::vSetData(trScreenProperties &tScreenAttributesParam) { 
   //init parameter
   (tVoid)memcpy(&tScreenAttributes,(tVoid*)&tScreenAttributesParam, sizeof(trScreenProperties));
   vStore();
}//lint !e1746: parameter 'tScreenAttributesParam' in function 'dp_tclSpiDpInternalDataScreenAttributes::vSetData(trScreenProperties)' could be made const reference
tVoid dp_tclSpiDpInternalDataScreenAttributes::vSetData(const trScreenProperties &tScreenAttributesParam) { 
   //init parameter
   (tVoid)memcpy(&tScreenAttributes,(tVoid*)&tScreenAttributesParam, sizeof(trScreenProperties));
   vStore();
}//lint !e1746: parameter 'tScreenAttributesParam' in function 'dp_tclSpiDpInternalDataScreenAttributes::vSetData(trScreenProperties)' could be made const reference
tU8   dp_tclSpiDpInternalDataScreenAttributes::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataScreenAttributes::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "ScreenAttributes", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataScreenAttributes::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "ScreenAttributes", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataScreenAttributes::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ScreenAttributes", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element ScreenAttributes has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DipoGeneralRestrictionInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDipoGeneralRestrictionInfo,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DipoGeneralRestrictionInfo",(tS32) 0xc54730d8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDipoGeneralRestrictionInfo = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DipoGeneralRestrictionInfo", (tS32)0xc54730d8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDipoGeneralRestrictionInfo, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::tGetData() {
   vUpdate();
   return tDipoGeneralRestrictionInfo;
};
tS32 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::s32GetData(tU16& tDipoGeneralRestrictionInfoParam) { 
   vUpdate();
   tDipoGeneralRestrictionInfoParam = tDipoGeneralRestrictionInfo;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DipoGeneralRestrictionInfo", (tS32)0xc54730d8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::s32SetData(tU16 &tDipoGeneralRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tDipoGeneralRestrictionInfo,(tVoid*)&tDipoGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDipoGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tS32 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::s32SetData(const tU16 &tDipoGeneralRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tDipoGeneralRestrictionInfo,(tVoid*)&tDipoGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDipoGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::u8GetData(tU16& tDipoGeneralRestrictionInfoParam) {  
   vUpdate();
   tDipoGeneralRestrictionInfoParam = tDipoGeneralRestrictionInfo;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(tU16 &tDipoGeneralRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tDipoGeneralRestrictionInfo,(tVoid*)&tDipoGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDipoGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tVoid dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(const tU16 &tDipoGeneralRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tDipoGeneralRestrictionInfo,(tVoid*)&tDipoGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDipoGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tU8   dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DipoGeneralRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DipoGeneralRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDipoGeneralRestrictionInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DipoGeneralRestrictionInfo", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element DipoGeneralRestrictionInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AAPGeneralRestrictionInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAAPGeneralRestrictionInfo,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AAPGeneralRestrictionInfo",(tS32) 0x86a68102);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tAAPGeneralRestrictionInfo = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AAPGeneralRestrictionInfo", (tS32)0x86a68102);
   (tVoid)myDpElem.bFillData((tVoid*)&tAAPGeneralRestrictionInfo, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::tGetData() {
   vUpdate();
   return tAAPGeneralRestrictionInfo;
};
tS32 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::s32GetData(tU16& tAAPGeneralRestrictionInfoParam) { 
   vUpdate();
   tAAPGeneralRestrictionInfoParam = tAAPGeneralRestrictionInfo;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AAPGeneralRestrictionInfo", (tS32)0x86a68102);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::s32SetData(tU16 &tAAPGeneralRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tAAPGeneralRestrictionInfo,(tVoid*)&tAAPGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAAPGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tS32 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::s32SetData(const tU16 &tAAPGeneralRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tAAPGeneralRestrictionInfo,(tVoid*)&tAAPGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAAPGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::u8GetData(tU16& tAAPGeneralRestrictionInfoParam) {  
   vUpdate();
   tAAPGeneralRestrictionInfoParam = tAAPGeneralRestrictionInfo;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(tU16 &tAAPGeneralRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tAAPGeneralRestrictionInfo,(tVoid*)&tAAPGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAAPGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tVoid dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(const tU16 &tAAPGeneralRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tAAPGeneralRestrictionInfo,(tVoid*)&tAAPGeneralRestrictionInfoParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tAAPGeneralRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::vSetData(tU16)' could be made const reference
tU8   dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AAPGeneralRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AAPGeneralRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAAPGeneralRestrictionInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AAPGeneralRestrictionInfo", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element AAPGeneralRestrictionInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DiPODriveRestrictionInfo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::dp_tclSpiDpInternalDataDiPODriveRestrictionInfo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDiPODriveRestrictionInfo,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DiPODriveRestrictionInfo",(tS32) 0x905ca800);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDiPODriveRestrictionInfo = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DiPODriveRestrictionInfo", (tS32)0x905ca800);
   (tVoid)myDpElem.bFillData((tVoid*)&tDiPODriveRestrictionInfo, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::tGetData() {
   vUpdate();
   return tDiPODriveRestrictionInfo;
};
tS32 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::s32GetData(tU8& tDiPODriveRestrictionInfoParam) { 
   vUpdate();
   tDiPODriveRestrictionInfoParam = tDiPODriveRestrictionInfo;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DiPODriveRestrictionInfo", (tS32)0x905ca800);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::s32SetData(tU8 &tDiPODriveRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tDiPODriveRestrictionInfo,(tVoid*)&tDiPODriveRestrictionInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiPODriveRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::s32SetData(const tU8 &tDiPODriveRestrictionInfoParam) {
   //init parameter
   (tVoid)memcpy(&tDiPODriveRestrictionInfo,(tVoid*)&tDiPODriveRestrictionInfoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiPODriveRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::u8GetData(tU8& tDiPODriveRestrictionInfoParam) {  
   vUpdate();
   tDiPODriveRestrictionInfoParam = tDiPODriveRestrictionInfo;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(tU8 &tDiPODriveRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tDiPODriveRestrictionInfo,(tVoid*)&tDiPODriveRestrictionInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiPODriveRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(const tU8 &tDiPODriveRestrictionInfoParam) { 
   //init parameter
   (tVoid)memcpy(&tDiPODriveRestrictionInfo,(tVoid*)&tDiPODriveRestrictionInfoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiPODriveRestrictionInfoParam' in function 'dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DiPODriveRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DiPODriveRestrictionInfo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDiPODriveRestrictionInfo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DiPODriveRestrictionInfo", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element DiPODriveRestrictionInfo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SteeringWheelPosition"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataSteeringWheelPosition::dp_tclSpiDpInternalDataSteeringWheelPosition(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSteeringWheelPosition,0,sizeof(tenSteeringWheelPosition));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SteeringWheelPosition",(tS32) 0x19e08ba3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tenSteeringWheelPosition)) 
      {
         tSteeringWheelPosition = *((tenSteeringWheelPosition*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SteeringWheelPosition", (tS32)0x19e08ba3);
   (tVoid)myDpElem.bFillData((tVoid*)&tSteeringWheelPosition, (tU32)sizeof(tenSteeringWheelPosition));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataSteeringWheelPosition::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataSteeringWheelPosition::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tenSteeringWheelPosition dp_tclSpiDpInternalDataSteeringWheelPosition::tGetData() {
   vUpdate();
   return tSteeringWheelPosition;
};
tS32 dp_tclSpiDpInternalDataSteeringWheelPosition::s32GetData(tenSteeringWheelPosition& tSteeringWheelPositionParam) { 
   vUpdate();
   tSteeringWheelPositionParam = tSteeringWheelPosition;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataSteeringWheelPosition::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SteeringWheelPosition", (tS32)0x19e08ba3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::operator>>(tenSteeringWheelPosition& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::operator<<(tenSteeringWheelPosition oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataSteeringWheelPosition::s32SetData(tenSteeringWheelPosition &tSteeringWheelPositionParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringWheelPosition,(tVoid*)&tSteeringWheelPositionParam, sizeof(tenSteeringWheelPosition));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringWheelPositionParam' in function 'dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(tenSteeringWheelPosition)' could be made const reference
tS32 dp_tclSpiDpInternalDataSteeringWheelPosition::s32SetData(const tenSteeringWheelPosition &tSteeringWheelPositionParam) {
   //init parameter
   (tVoid)memcpy(&tSteeringWheelPosition,(tVoid*)&tSteeringWheelPositionParam, sizeof(tenSteeringWheelPosition));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSteeringWheelPositionParam' in function 'dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(tenSteeringWheelPosition)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataSteeringWheelPosition::u8GetData(tenSteeringWheelPosition& tSteeringWheelPositionParam) {  
   vUpdate();
   tSteeringWheelPositionParam = tSteeringWheelPosition;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(tenSteeringWheelPosition &tSteeringWheelPositionParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringWheelPosition,(tVoid*)&tSteeringWheelPositionParam, sizeof(tenSteeringWheelPosition));
   vStore();
}//lint !e1746: parameter 'tSteeringWheelPositionParam' in function 'dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(tenSteeringWheelPosition)' could be made const reference
tVoid dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(const tenSteeringWheelPosition &tSteeringWheelPositionParam) { 
   //init parameter
   (tVoid)memcpy(&tSteeringWheelPosition,(tVoid*)&tSteeringWheelPositionParam, sizeof(tenSteeringWheelPosition));
   vStore();
}//lint !e1746: parameter 'tSteeringWheelPositionParam' in function 'dp_tclSpiDpInternalDataSteeringWheelPosition::vSetData(tenSteeringWheelPosition)' could be made const reference
tU8   dp_tclSpiDpInternalDataSteeringWheelPosition::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataSteeringWheelPosition::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SteeringWheelPosition", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataSteeringWheelPosition::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SteeringWheelPosition", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataSteeringWheelPosition::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SteeringWheelPosition", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element SteeringWheelPosition has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VehicleID"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataVehicleID::dp_tclSpiDpInternalDataVehicleID(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclSpiDpInternalDataVehicleID::s32SetData(tString &tVehicleIDParam) {
   tU32 u32Len = (tU32)strlen(tVehicleIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("VehicleID", (tS32)0x297ffb9);
      (tVoid)myDpElem.bFillData((tVoid*)tVehicleIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataVehicleID::s32SetData(const tString &tVehicleIDParam) {
   tU32 u32Len = (tU32)strlen(tVehicleIDParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("VehicleID", (tS32)0x297ffb9);
      (tVoid)myDpElem.bFillData((tVoid*)tVehicleIDParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataVehicleID::s32GetData(tString &tVehicleIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("VehicleID", (tS32)0x297ffb9);
   (tVoid)memset(tVehicleIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tVehicleIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataVehicleID::s32GetData(const tString &tVehicleIDParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("VehicleID", (tS32)0x297ffb9);
   (tVoid)memset(tVehicleIDParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tVehicleIDParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclSpiDpInternalDataVehicleID::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDataVehicleID::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclSpiDpInternalDataVehicleID::u32GetData(tString &tVehicleIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tVehicleIDParam, u32StringBufLen);
   };
    tU32  dp_tclSpiDpInternalDataVehicleID::u32GetData(const tString &tVehicleIDParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tVehicleIDParam, u32StringBufLen);
   };
   tVoid dp_tclSpiDpInternalDataVehicleID::vSetData(tString &tVehicleIDParam){(tVoid)s32SetData(tVehicleIDParam);};
   tVoid dp_tclSpiDpInternalDataVehicleID::vSetData(const tString &tVehicleIDParam){(tVoid)s32SetData(tVehicleIDParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDataVehicleID::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VehicleID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataVehicleID::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VehicleID", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataVehicleID::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VehicleID", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element VehicleID has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AndroidDeviceTechnologyPreference"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAndroidDeviceTechnologyPreference,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AndroidDeviceTechnologyPreference",(tS32) 0xf3e909fcL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAndroidDeviceTechnologyPreference = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AndroidDeviceTechnologyPreference", (tS32)0xf3e909fcL);
   (tVoid)myDpElem.bFillData((tVoid*)&tAndroidDeviceTechnologyPreference, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::tGetData() {
   vUpdate();
   return tAndroidDeviceTechnologyPreference;
};
tS32 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::s32GetData(tU8& tAndroidDeviceTechnologyPreferenceParam) { 
   vUpdate();
   tAndroidDeviceTechnologyPreferenceParam = tAndroidDeviceTechnologyPreference;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AndroidDeviceTechnologyPreference", (tS32)0xf3e909fcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::s32SetData(tU8 &tAndroidDeviceTechnologyPreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tAndroidDeviceTechnologyPreference,(tVoid*)&tAndroidDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAndroidDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::s32SetData(const tU8 &tAndroidDeviceTechnologyPreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tAndroidDeviceTechnologyPreference,(tVoid*)&tAndroidDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAndroidDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::u8GetData(tU8& tAndroidDeviceTechnologyPreferenceParam) {  
   vUpdate();
   tAndroidDeviceTechnologyPreferenceParam = tAndroidDeviceTechnologyPreference;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(tU8 &tAndroidDeviceTechnologyPreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tAndroidDeviceTechnologyPreference,(tVoid*)&tAndroidDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAndroidDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(const tU8 &tAndroidDeviceTechnologyPreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tAndroidDeviceTechnologyPreference,(tVoid*)&tAndroidDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAndroidDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AndroidDeviceTechnologyPreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AndroidDeviceTechnologyPreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAndroidDeviceTechnologyPreference::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AndroidDeviceTechnologyPreference", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element AndroidDeviceTechnologyPreference has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AppleDeviceTechnologyPreference"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAppleDeviceTechnologyPreference,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AppleDeviceTechnologyPreference",(tS32) 0x29937e01L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tAppleDeviceTechnologyPreference = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AppleDeviceTechnologyPreference", (tS32)0x29937e01L);
   (tVoid)myDpElem.bFillData((tVoid*)&tAppleDeviceTechnologyPreference, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::tGetData() {
   vUpdate();
   return tAppleDeviceTechnologyPreference;
};
tS32 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::s32GetData(tU8& tAppleDeviceTechnologyPreferenceParam) { 
   vUpdate();
   tAppleDeviceTechnologyPreferenceParam = tAppleDeviceTechnologyPreference;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AppleDeviceTechnologyPreference", (tS32)0x29937e01L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::s32SetData(tU8 &tAppleDeviceTechnologyPreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tAppleDeviceTechnologyPreference,(tVoid*)&tAppleDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAppleDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::s32SetData(const tU8 &tAppleDeviceTechnologyPreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tAppleDeviceTechnologyPreference,(tVoid*)&tAppleDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAppleDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::u8GetData(tU8& tAppleDeviceTechnologyPreferenceParam) {  
   vUpdate();
   tAppleDeviceTechnologyPreferenceParam = tAppleDeviceTechnologyPreference;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(tU8 &tAppleDeviceTechnologyPreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tAppleDeviceTechnologyPreference,(tVoid*)&tAppleDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAppleDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(const tU8 &tAppleDeviceTechnologyPreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tAppleDeviceTechnologyPreference,(tVoid*)&tAppleDeviceTechnologyPreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tAppleDeviceTechnologyPreferenceParam' in function 'dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AppleDeviceTechnologyPreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AppleDeviceTechnologyPreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAppleDeviceTechnologyPreference::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AppleDeviceTechnologyPreference", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element AppleDeviceTechnologyPreference has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SelectionMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataSelectionMode::dp_tclSpiDpInternalDataSelectionMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSelectionMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataSelectionMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SelectionMode",(tS32) 0x2b5930c3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSelectionMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataSelectionMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SelectionMode", (tS32)0x2b5930c3);
   (tVoid)myDpElem.bFillData((tVoid*)&tSelectionMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataSelectionMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataSelectionMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataSelectionMode::tGetData() {
   vUpdate();
   return tSelectionMode;
};
tS32 dp_tclSpiDpInternalDataSelectionMode::s32GetData(tU8& tSelectionModeParam) { 
   vUpdate();
   tSelectionModeParam = tSelectionMode;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataSelectionMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SelectionMode", (tS32)0x2b5930c3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataSelectionMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataSelectionMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataSelectionMode::s32SetData(tU8 &tSelectionModeParam) {
   //init parameter
   (tVoid)memcpy(&tSelectionMode,(tVoid*)&tSelectionModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSelectionModeParam' in function 'dp_tclSpiDpInternalDataSelectionMode::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataSelectionMode::s32SetData(const tU8 &tSelectionModeParam) {
   //init parameter
   (tVoid)memcpy(&tSelectionMode,(tVoid*)&tSelectionModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSelectionModeParam' in function 'dp_tclSpiDpInternalDataSelectionMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataSelectionMode::u8GetData(tU8& tSelectionModeParam) {  
   vUpdate();
   tSelectionModeParam = tSelectionMode;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataSelectionMode::vSetData(tU8 &tSelectionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSelectionMode,(tVoid*)&tSelectionModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSelectionModeParam' in function 'dp_tclSpiDpInternalDataSelectionMode::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataSelectionMode::vSetData(const tU8 &tSelectionModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSelectionMode,(tVoid*)&tSelectionModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSelectionModeParam' in function 'dp_tclSpiDpInternalDataSelectionMode::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataSelectionMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataSelectionMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SelectionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataSelectionMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SelectionMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataSelectionMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SelectionMode", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element SelectionMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VirginStart"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataVirginStart::dp_tclSpiDpInternalDataVirginStart(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVirginStart,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataVirginStart::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VirginStart",(tS32) 0x4189dc45);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVirginStart = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataVirginStart::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VirginStart", (tS32)0x4189dc45);
   (tVoid)myDpElem.bFillData((tVoid*)&tVirginStart, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataVirginStart::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataVirginStart::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclSpiDpInternalDataVirginStart::tGetData() {
   vUpdate();
   return tVirginStart;
};
tS32 dp_tclSpiDpInternalDataVirginStart::s32GetData(tU8& tVirginStartParam) { 
   vUpdate();
   tVirginStartParam = tVirginStart;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataVirginStart::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VirginStart", (tS32)0x4189dc45);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataVirginStart::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataVirginStart::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataVirginStart::s32SetData(tU8 &tVirginStartParam) {
   //init parameter
   (tVoid)memcpy(&tVirginStart,(tVoid*)&tVirginStartParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVirginStartParam' in function 'dp_tclSpiDpInternalDataVirginStart::vSetData(tU8)' could be made const reference
tS32 dp_tclSpiDpInternalDataVirginStart::s32SetData(const tU8 &tVirginStartParam) {
   //init parameter
   (tVoid)memcpy(&tVirginStart,(tVoid*)&tVirginStartParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVirginStartParam' in function 'dp_tclSpiDpInternalDataVirginStart::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataVirginStart::u8GetData(tU8& tVirginStartParam) {  
   vUpdate();
   tVirginStartParam = tVirginStart;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataVirginStart::vSetData(tU8 &tVirginStartParam) { 
   //init parameter
   (tVoid)memcpy(&tVirginStart,(tVoid*)&tVirginStartParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVirginStartParam' in function 'dp_tclSpiDpInternalDataVirginStart::vSetData(tU8)' could be made const reference
tVoid dp_tclSpiDpInternalDataVirginStart::vSetData(const tU8 &tVirginStartParam) { 
   //init parameter
   (tVoid)memcpy(&tVirginStart,(tVoid*)&tVirginStartParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVirginStartParam' in function 'dp_tclSpiDpInternalDataVirginStart::vSetData(tU8)' could be made const reference
tU8   dp_tclSpiDpInternalDataVirginStart::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataVirginStart::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VirginStart", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataVirginStart::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VirginStart", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataVirginStart::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VirginStart", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element VirginStart has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SPIVersion"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataSPIVersion::dp_tclSpiDpInternalDataSPIVersion(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclSpiDpInternalDataSPIVersion::s32SetData(tString &tSPIVersionParam) {
   tU32 u32Len = (tU32)strlen(tSPIVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("SPIVersion", (tS32)0xbf82126);
      (tVoid)myDpElem.bFillData((tVoid*)tSPIVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataSPIVersion::s32SetData(const tString &tSPIVersionParam) {
   tU32 u32Len = (tU32)strlen(tSPIVersionParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("SPIVersion", (tS32)0xbf82126);
      (tVoid)myDpElem.bFillData((tVoid*)tSPIVersionParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataSPIVersion::s32GetData(tString &tSPIVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("SPIVersion", (tS32)0xbf82126);
   (tVoid)memset(tSPIVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tSPIVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDataSPIVersion::s32GetData(const tString &tSPIVersionParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("SPIVersion", (tS32)0xbf82126);
   (tVoid)memset(tSPIVersionParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tSPIVersionParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclSpiDpInternalDataSPIVersion::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDataSPIVersion::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclSpiDpInternalDataSPIVersion::u32GetData(tString &tSPIVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tSPIVersionParam, u32StringBufLen);
   };
    tU32  dp_tclSpiDpInternalDataSPIVersion::u32GetData(const tString &tSPIVersionParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tSPIVersionParam, u32StringBufLen);
   };
   tVoid dp_tclSpiDpInternalDataSPIVersion::vSetData(tString &tSPIVersionParam){(tVoid)s32SetData(tSPIVersionParam);};
   tVoid dp_tclSpiDpInternalDataSPIVersion::vSetData(const tString &tSPIVersionParam){(tVoid)s32SetData(tSPIVersionParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDataSPIVersion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SPIVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataSPIVersion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "SPIVersion", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDataSPIVersion::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SPIVersion", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element SPIVersion has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VehicleManufacturerInformation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataVehicleManufacturerInformation::dp_tclSpiDpInternalDataVehicleManufacturerInformation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVehicleManufacturerInformation,0,sizeof(trVMInfo));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VehicleManufacturerInformation",(tS32) 0x611e512bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(trVMInfo)) 
      {
         tVehicleManufacturerInformation = *((trVMInfo*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VehicleManufacturerInformation", (tS32)0x611e512bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tVehicleManufacturerInformation, (tU32)sizeof(trVMInfo));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataVehicleManufacturerInformation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataVehicleManufacturerInformation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
trVMInfo dp_tclSpiDpInternalDataVehicleManufacturerInformation::tGetData() {
   vUpdate();
   return tVehicleManufacturerInformation;
};
tS32 dp_tclSpiDpInternalDataVehicleManufacturerInformation::s32GetData(trVMInfo& tVehicleManufacturerInformationParam) { 
   vUpdate();
   tVehicleManufacturerInformationParam = tVehicleManufacturerInformation;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataVehicleManufacturerInformation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VehicleManufacturerInformation", (tS32)0x611e512bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::operator>>(trVMInfo& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::operator<<(trVMInfo oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataVehicleManufacturerInformation::s32SetData(trVMInfo &tVehicleManufacturerInformationParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleManufacturerInformation,(tVoid*)&tVehicleManufacturerInformationParam, sizeof(trVMInfo));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleManufacturerInformationParam' in function 'dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(trVMInfo)' could be made const reference
tS32 dp_tclSpiDpInternalDataVehicleManufacturerInformation::s32SetData(const trVMInfo &tVehicleManufacturerInformationParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleManufacturerInformation,(tVoid*)&tVehicleManufacturerInformationParam, sizeof(trVMInfo));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleManufacturerInformationParam' in function 'dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(trVMInfo)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataVehicleManufacturerInformation::u8GetData(trVMInfo& tVehicleManufacturerInformationParam) {  
   vUpdate();
   tVehicleManufacturerInformationParam = tVehicleManufacturerInformation;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(trVMInfo &tVehicleManufacturerInformationParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleManufacturerInformation,(tVoid*)&tVehicleManufacturerInformationParam, sizeof(trVMInfo));
   vStore();
}//lint !e1746: parameter 'tVehicleManufacturerInformationParam' in function 'dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(trVMInfo)' could be made const reference
tVoid dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(const trVMInfo &tVehicleManufacturerInformationParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleManufacturerInformation,(tVoid*)&tVehicleManufacturerInformationParam, sizeof(trVMInfo));
   vStore();
}//lint !e1746: parameter 'tVehicleManufacturerInformationParam' in function 'dp_tclSpiDpInternalDataVehicleManufacturerInformation::vSetData(trVMInfo)' could be made const reference
tU8   dp_tclSpiDpInternalDataVehicleManufacturerInformation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataVehicleManufacturerInformation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VehicleManufacturerInformation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataVehicleManufacturerInformation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "VehicleManufacturerInformation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataVehicleManufacturerInformation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VehicleManufacturerInformation", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element VehicleManufacturerInformation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DisplayLastMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataDisplayLastMode::dp_tclSpiDpInternalDataDisplayLastMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDisplayLastMode,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataDisplayLastMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DisplayLastMode",(tS32) 0x96e39c4f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tDisplayLastMode = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataDisplayLastMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DisplayLastMode", (tS32)0x96e39c4f);
   (tVoid)myDpElem.bFillData((tVoid*)&tDisplayLastMode, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataDisplayLastMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataDisplayLastMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpiDpInternalDataDisplayLastMode::tGetData() {
   vUpdate();
   return tDisplayLastMode;
};
tS32 dp_tclSpiDpInternalDataDisplayLastMode::s32GetData(tBool& tDisplayLastModeParam) { 
   vUpdate();
   tDisplayLastModeParam = tDisplayLastMode;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataDisplayLastMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DisplayLastMode", (tS32)0x96e39c4f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataDisplayLastMode::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataDisplayLastMode::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataDisplayLastMode::s32SetData(tBool &tDisplayLastModeParam) {
   //init parameter
   (tVoid)memcpy(&tDisplayLastMode,(tVoid*)&tDisplayLastModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisplayLastModeParam' in function 'dp_tclSpiDpInternalDataDisplayLastMode::vSetData(tBool)' could be made const reference
tS32 dp_tclSpiDpInternalDataDisplayLastMode::s32SetData(const tBool &tDisplayLastModeParam) {
   //init parameter
   (tVoid)memcpy(&tDisplayLastMode,(tVoid*)&tDisplayLastModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDisplayLastModeParam' in function 'dp_tclSpiDpInternalDataDisplayLastMode::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataDisplayLastMode::u8GetData(tBool& tDisplayLastModeParam) {  
   vUpdate();
   tDisplayLastModeParam = tDisplayLastMode;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataDisplayLastMode::vSetData(tBool &tDisplayLastModeParam) { 
   //init parameter
   (tVoid)memcpy(&tDisplayLastMode,(tVoid*)&tDisplayLastModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDisplayLastModeParam' in function 'dp_tclSpiDpInternalDataDisplayLastMode::vSetData(tBool)' could be made const reference
tVoid dp_tclSpiDpInternalDataDisplayLastMode::vSetData(const tBool &tDisplayLastModeParam) { 
   //init parameter
   (tVoid)memcpy(&tDisplayLastMode,(tVoid*)&tDisplayLastModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tDisplayLastModeParam' in function 'dp_tclSpiDpInternalDataDisplayLastMode::vSetData(tBool)' could be made const reference
tU8   dp_tclSpiDpInternalDataDisplayLastMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataDisplayLastMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DisplayLastMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDisplayLastMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "DisplayLastMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataDisplayLastMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DisplayLastMode", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element DisplayLastMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "AudioLastMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDataAudioLastMode::dp_tclSpiDpInternalDataAudioLastMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tAudioLastMode,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclSpiDpInternalDataAudioLastMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("AudioLastMode",(tS32) 0x4fe03163);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tAudioLastMode = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclSpiDpInternalDataAudioLastMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("AudioLastMode", (tS32)0x4fe03163);
   (tVoid)myDpElem.bFillData((tVoid*)&tAudioLastMode, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclSpiDpInternalDataAudioLastMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclSpiDpInternalDataAudioLastMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclSpiDpInternalDataAudioLastMode::tGetData() {
   vUpdate();
   return tAudioLastMode;
};
tS32 dp_tclSpiDpInternalDataAudioLastMode::s32GetData(tBool& tAudioLastModeParam) { 
   vUpdate();
   tAudioLastModeParam = tAudioLastMode;
   return _s32Status;
}
tS32 dp_tclSpiDpInternalDataAudioLastMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("AudioLastMode", (tS32)0x4fe03163);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclSpiDpInternalDataAudioLastMode::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclSpiDpInternalDataAudioLastMode::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclSpiDpInternalDataAudioLastMode::s32SetData(tBool &tAudioLastModeParam) {
   //init parameter
   (tVoid)memcpy(&tAudioLastMode,(tVoid*)&tAudioLastModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioLastModeParam' in function 'dp_tclSpiDpInternalDataAudioLastMode::vSetData(tBool)' could be made const reference
tS32 dp_tclSpiDpInternalDataAudioLastMode::s32SetData(const tBool &tAudioLastModeParam) {
   //init parameter
   (tVoid)memcpy(&tAudioLastMode,(tVoid*)&tAudioLastModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tAudioLastModeParam' in function 'dp_tclSpiDpInternalDataAudioLastMode::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclSpiDpInternalDataAudioLastMode::u8GetData(tBool& tAudioLastModeParam) {  
   vUpdate();
   tAudioLastModeParam = tAudioLastMode;
   return _u8DataStatus;
}
tVoid dp_tclSpiDpInternalDataAudioLastMode::vSetData(tBool &tAudioLastModeParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioLastMode,(tVoid*)&tAudioLastModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioLastModeParam' in function 'dp_tclSpiDpInternalDataAudioLastMode::vSetData(tBool)' could be made const reference
tVoid dp_tclSpiDpInternalDataAudioLastMode::vSetData(const tBool &tAudioLastModeParam) { 
   //init parameter
   (tVoid)memcpy(&tAudioLastMode,(tVoid*)&tAudioLastModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tAudioLastModeParam' in function 'dp_tclSpiDpInternalDataAudioLastMode::vSetData(tBool)' could be made const reference
tU8   dp_tclSpiDpInternalDataAudioLastMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclSpiDpInternalDataAudioLastMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AudioLastMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAudioLastMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "AudioLastMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclSpiDpInternalDataAudioLastMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: AudioLastMode", DP_U32_POOL_ID_SPIDPINTERNALDATA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
   }
   else
   {
      fprintf(stdout,"Element AudioLastMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "u32AASuppHardKeysArr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDatau32AASuppHardKeysArr::dp_tclSpiDpInternalDatau32AASuppHardKeysArr(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclSpiDpInternalDatau32AASuppHardKeysArr::s32SetData( tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("u32AASuppHardKeysArr", (tS32)0x707dd45c);
   (tVoid)myDpElem.bFillData((tVoid*)tu32AASuppHardKeysArrParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDatau32AASuppHardKeysArr::s32GetData(tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("u32AASuppHardKeysArr", (tS32)0x707dd45c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tu32AASuppHardKeysArrParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclSpiDpInternalDatau32AASuppHardKeysArr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDatau32AASuppHardKeysArr::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclSpiDpInternalDatau32AASuppHardKeysArr::u16GetData(tU32* tu32AASuppHardKeysArrParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tu32AASuppHardKeysArrParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDatau32AASuppHardKeysArr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32AASuppHardKeysArr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDatau32AASuppHardKeysArr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32AASuppHardKeysArr", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclSpiDpInternalDatau32AASuppHardKeysArr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: u32AASuppHardKeysArr", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element u32AASuppHardKeysArr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "u32DiPoSuppHardKeysArr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::s32SetData( tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("u32DiPoSuppHardKeysArr", (tS32)0x4b654a82);
   (tVoid)myDpElem.bFillData((tVoid*)tu32DiPoSuppHardKeysArrParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::s32GetData(tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("u32DiPoSuppHardKeysArr", (tS32)0x4b654a82);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tu32DiPoSuppHardKeysArrParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::u16GetData(tU32* tu32DiPoSuppHardKeysArrParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tu32DiPoSuppHardKeysArrParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32DiPoSuppHardKeysArr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32DiPoSuppHardKeysArr", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclSpiDpInternalDatau32DiPoSuppHardKeysArr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: u32DiPoSuppHardKeysArr", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element u32DiPoSuppHardKeysArr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "u32DiPoSuppSoftKeysArr"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;

      
};
   
tS32 dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::s32SetData( tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize) {
   dp_tclBaseElement myDpElem("u32DiPoSuppSoftKeysArr", (tS32)0x533932ff);
   (tVoid)myDpElem.bFillData((tVoid*)tu32DiPoSuppSoftKeysArrParam, ((tU32)sizeof(tU32))*u32ArraySize);
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   return _s32Status;
}

tS32 dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::s32GetData(tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize) 
{
   dp_tclBaseElement myDpElem("u32DiPoSuppSoftKeysArr", (tS32)0x533932ff);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_SPIDPINTERNALDATA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if ((myDpElem.u32GetDataLength() % sizeof(tU32)) == 0)  
      {
         _s32Status = (tS32)(myDpElem.u32GetDataLength() / sizeof(tU32));
         if (_s32Status > (tS32)u32ArraySize) 
         {
             _s32Status = (tS32)u32ArraySize;
         }
         (tVoid)memcpy((tVoid*)tu32DiPoSuppSoftKeysArrParam, myDpElem.pvGetData(), (tU32)_s32Status*sizeof(tU32));
          _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
          if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	          _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
      } 
      else 
      {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
   //read access for pool element 
   tS32  dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::u8GetElementStatus() const {return _u8DataStatus;};

   //old interface -> change to s32GetData()
   tU16  dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::u16GetData(tU32* tu32DiPoSuppSoftKeysArrParam, tU32 u32ArraySize){
       return (tU16) s32GetData(tu32DiPoSuppSoftKeysArrParam, u32ArraySize);
   };
   
   //notification handling not over processes only for application
   tBool dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32DiPoSuppSoftKeysArr", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_SPIDPINTERNALDATA, "u32DiPoSuppSoftKeysArr", pFunc, u32Event, _u16AccessId);
   }   
   tBool dp_tclSpiDpInternalDatau32DiPoSuppSoftKeysArr::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: u32DiPoSuppSoftKeysArr", DP_U32_POOL_ID_SPIDPINTERNALDATA);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_SPIDPINTERNALDATA);
		}
		else
		{
			fprintf(stdout,"Element u32DiPoSuppSoftKeysArr has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
   }
 

