#ifndef _DP_FI_FC_SDS_ADAPTER_SPEECHSETTINGS_H
#define _DP_FI_FC_SDS_ADAPTER_SPEECHSETTINGS_H

extern tVoid vInitfc_sds_adapter_SpeechSettings(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclfc_sds_adapter_SpeechSettingsVoicePreference{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVoicePreference;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsVoicePreference(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsVoicePreference() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVoicePreferenceParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVoicePreferenceParam);
   tS32  s32SetData(const tU8 &tVoicePreferenceParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVoicePreferenceParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVoicePreferenceParam);
   tVoid vSetData(const tU8& tVoicePreferenceParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsPromptSetting{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tPromptSetting;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsPromptSetting(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsPromptSetting() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tPromptSettingParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tPromptSettingParam);
   tS32  s32SetData(const tBool &tPromptSettingParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tPromptSettingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tPromptSettingParam);
   tVoid vSetData(const tBool& tPromptSettingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tNBestMatchPhoneBook;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tNBestMatchPhoneBookParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tNBestMatchPhoneBookParam);
   tS32  s32SetData(const tBool &tNBestMatchPhoneBookParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tNBestMatchPhoneBookParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tNBestMatchPhoneBookParam);
   tVoid vSetData(const tBool& tNBestMatchPhoneBookParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tNBestMatchAudio;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tNBestMatchAudioParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tNBestMatchAudioParam);
   tS32  s32SetData(const tBool &tNBestMatchAudioParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tNBestMatchAudioParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tNBestMatchAudioParam);
   tVoid vSetData(const tBool& tNBestMatchAudioParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tBeepOnlyMode;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tBeepOnlyModeParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tBeepOnlyModeParam);
   tS32  s32SetData(const tBool &tBeepOnlyModeParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tBeepOnlyModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tBeepOnlyModeParam);
   tVoid vSetData(const tBool& tBeepOnlyModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsSpeechRate{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSpeechRate;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsSpeechRate(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsSpeechRate() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSpeechRateParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSpeechRateParam);
   tS32  s32SetData(const tU32 &tSpeechRateParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSpeechRateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSpeechRateParam);
   tVoid vSetData(const tU32& tSpeechRateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tVoiceBargeIn;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tVoiceBargeInParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tVoiceBargeInParam);
   tS32  s32SetData(const tBool &tVoiceBargeInParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tVoiceBargeInParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tVoiceBargeInParam);
   tVoid vSetData(const tBool& tVoiceBargeInParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tSystemLanguage;
   
public:
   dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tSystemLanguageParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tSystemLanguageParam);
   tS32  s32SetData(const tU32 &tSystemLanguageParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tSystemLanguageParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tSystemLanguageParam);
   tVoid vSetData(const tU32& tSystemLanguageParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
