
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclfc_sds_adapter_SpeechSettings.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VoicePreference"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::dp_tclfc_sds_adapter_SpeechSettingsVoicePreference(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVoicePreference,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VoicePreference",(tS32) 0x225b3485);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVoicePreference = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VoicePreference", (tS32)0x225b3485);
   (tVoid)myDpElem.bFillData((tVoid*)&tVoicePreference, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::tGetData() {
   vUpdate();
   return tVoicePreference;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::s32GetData(tU8& tVoicePreferenceParam) { 
   vUpdate();
   tVoicePreferenceParam = tVoicePreference;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VoicePreference", (tS32)0x225b3485);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::s32SetData(tU8 &tVoicePreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tVoicePreference,(tVoid*)&tVoicePreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoicePreferenceParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(tU8)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::s32SetData(const tU8 &tVoicePreferenceParam) {
   //init parameter
   (tVoid)memcpy(&tVoicePreference,(tVoid*)&tVoicePreferenceParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoicePreferenceParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::u8GetData(tU8& tVoicePreferenceParam) {  
   vUpdate();
   tVoicePreferenceParam = tVoicePreference;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(tU8 &tVoicePreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tVoicePreference,(tVoid*)&tVoicePreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVoicePreferenceParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(tU8)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(const tU8 &tVoicePreferenceParam) { 
   //init parameter
   (tVoid)memcpy(&tVoicePreference,(tVoid*)&tVoicePreferenceParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVoicePreferenceParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::vSetData(tU8)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "VoicePreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "VoicePreference", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsVoicePreference::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VoicePreference", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element VoicePreference has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PromptSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::dp_tclfc_sds_adapter_SpeechSettingsPromptSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPromptSetting,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PromptSetting",(tS32) 0x287c6c00);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tPromptSetting = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PromptSetting", (tS32)0x287c6c00);
   (tVoid)myDpElem.bFillData((tVoid*)&tPromptSetting, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::tGetData() {
   vUpdate();
   return tPromptSetting;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::s32GetData(tBool& tPromptSettingParam) { 
   vUpdate();
   tPromptSettingParam = tPromptSetting;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PromptSetting", (tS32)0x287c6c00);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::s32SetData(tBool &tPromptSettingParam) {
   //init parameter
   (tVoid)memcpy(&tPromptSetting,(tVoid*)&tPromptSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPromptSettingParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(tBool)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::s32SetData(const tBool &tPromptSettingParam) {
   //init parameter
   (tVoid)memcpy(&tPromptSetting,(tVoid*)&tPromptSettingParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPromptSettingParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::u8GetData(tBool& tPromptSettingParam) {  
   vUpdate();
   tPromptSettingParam = tPromptSetting;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(tBool &tPromptSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tPromptSetting,(tVoid*)&tPromptSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPromptSettingParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(tBool)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(const tBool &tPromptSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tPromptSetting,(tVoid*)&tPromptSettingParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tPromptSettingParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::vSetData(tBool)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "PromptSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "PromptSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsPromptSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PromptSetting", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element PromptSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NBestMatchPhoneBook"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNBestMatchPhoneBook,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NBestMatchPhoneBook",(tS32) 0x15053872);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tNBestMatchPhoneBook = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NBestMatchPhoneBook", (tS32)0x15053872);
   (tVoid)myDpElem.bFillData((tVoid*)&tNBestMatchPhoneBook, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::tGetData() {
   vUpdate();
   return tNBestMatchPhoneBook;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::s32GetData(tBool& tNBestMatchPhoneBookParam) { 
   vUpdate();
   tNBestMatchPhoneBookParam = tNBestMatchPhoneBook;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NBestMatchPhoneBook", (tS32)0x15053872);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::s32SetData(tBool &tNBestMatchPhoneBookParam) {
   //init parameter
   (tVoid)memcpy(&tNBestMatchPhoneBook,(tVoid*)&tNBestMatchPhoneBookParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNBestMatchPhoneBookParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(tBool)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::s32SetData(const tBool &tNBestMatchPhoneBookParam) {
   //init parameter
   (tVoid)memcpy(&tNBestMatchPhoneBook,(tVoid*)&tNBestMatchPhoneBookParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNBestMatchPhoneBookParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::u8GetData(tBool& tNBestMatchPhoneBookParam) {  
   vUpdate();
   tNBestMatchPhoneBookParam = tNBestMatchPhoneBook;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(tBool &tNBestMatchPhoneBookParam) { 
   //init parameter
   (tVoid)memcpy(&tNBestMatchPhoneBook,(tVoid*)&tNBestMatchPhoneBookParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNBestMatchPhoneBookParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(tBool)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(const tBool &tNBestMatchPhoneBookParam) { 
   //init parameter
   (tVoid)memcpy(&tNBestMatchPhoneBook,(tVoid*)&tNBestMatchPhoneBookParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNBestMatchPhoneBookParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::vSetData(tBool)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "NBestMatchPhoneBook", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "NBestMatchPhoneBook", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchPhoneBook::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NBestMatchPhoneBook", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element NBestMatchPhoneBook has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "NBestMatchAudio"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tNBestMatchAudio,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("NBestMatchAudio",(tS32) 0xf633e793);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tNBestMatchAudio = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vStore(tVoid) {
   dp_tclBaseElement myDpElem("NBestMatchAudio", (tS32)0xf633e793);
   (tVoid)myDpElem.bFillData((tVoid*)&tNBestMatchAudio, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::tGetData() {
   vUpdate();
   return tNBestMatchAudio;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::s32GetData(tBool& tNBestMatchAudioParam) { 
   vUpdate();
   tNBestMatchAudioParam = tNBestMatchAudio;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("NBestMatchAudio", (tS32)0xf633e793);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::s32SetData(tBool &tNBestMatchAudioParam) {
   //init parameter
   (tVoid)memcpy(&tNBestMatchAudio,(tVoid*)&tNBestMatchAudioParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNBestMatchAudioParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(tBool)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::s32SetData(const tBool &tNBestMatchAudioParam) {
   //init parameter
   (tVoid)memcpy(&tNBestMatchAudio,(tVoid*)&tNBestMatchAudioParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tNBestMatchAudioParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::u8GetData(tBool& tNBestMatchAudioParam) {  
   vUpdate();
   tNBestMatchAudioParam = tNBestMatchAudio;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(tBool &tNBestMatchAudioParam) { 
   //init parameter
   (tVoid)memcpy(&tNBestMatchAudio,(tVoid*)&tNBestMatchAudioParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNBestMatchAudioParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(tBool)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(const tBool &tNBestMatchAudioParam) { 
   //init parameter
   (tVoid)memcpy(&tNBestMatchAudio,(tVoid*)&tNBestMatchAudioParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tNBestMatchAudioParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::vSetData(tBool)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "NBestMatchAudio", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "NBestMatchAudio", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsNBestMatchAudio::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: NBestMatchAudio", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element NBestMatchAudio has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "BeepOnlyMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tBeepOnlyMode,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("BeepOnlyMode",(tS32) 0x9bc83cf);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tBeepOnlyMode = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("BeepOnlyMode", (tS32)0x9bc83cf);
   (tVoid)myDpElem.bFillData((tVoid*)&tBeepOnlyMode, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::tGetData() {
   vUpdate();
   return tBeepOnlyMode;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::s32GetData(tBool& tBeepOnlyModeParam) { 
   vUpdate();
   tBeepOnlyModeParam = tBeepOnlyMode;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("BeepOnlyMode", (tS32)0x9bc83cf);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::s32SetData(tBool &tBeepOnlyModeParam) {
   //init parameter
   (tVoid)memcpy(&tBeepOnlyMode,(tVoid*)&tBeepOnlyModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepOnlyModeParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(tBool)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::s32SetData(const tBool &tBeepOnlyModeParam) {
   //init parameter
   (tVoid)memcpy(&tBeepOnlyMode,(tVoid*)&tBeepOnlyModeParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tBeepOnlyModeParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::u8GetData(tBool& tBeepOnlyModeParam) {  
   vUpdate();
   tBeepOnlyModeParam = tBeepOnlyMode;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(tBool &tBeepOnlyModeParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepOnlyMode,(tVoid*)&tBeepOnlyModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tBeepOnlyModeParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(tBool)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(const tBool &tBeepOnlyModeParam) { 
   //init parameter
   (tVoid)memcpy(&tBeepOnlyMode,(tVoid*)&tBeepOnlyModeParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tBeepOnlyModeParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::vSetData(tBool)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "BeepOnlyMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "BeepOnlyMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsBeepOnlyMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: BeepOnlyMode", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element BeepOnlyMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SpeechRate"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::dp_tclfc_sds_adapter_SpeechSettingsSpeechRate(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSpeechRate,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SpeechRate",(tS32) 0xcdb9010);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSpeechRate = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SpeechRate", (tS32)0xcdb9010);
   (tVoid)myDpElem.bFillData((tVoid*)&tSpeechRate, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::tGetData() {
   vUpdate();
   return tSpeechRate;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::s32GetData(tU32& tSpeechRateParam) { 
   vUpdate();
   tSpeechRateParam = tSpeechRate;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SpeechRate", (tS32)0xcdb9010);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::s32SetData(tU32 &tSpeechRateParam) {
   //init parameter
   (tVoid)memcpy(&tSpeechRate,(tVoid*)&tSpeechRateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSpeechRateParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(tU32)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::s32SetData(const tU32 &tSpeechRateParam) {
   //init parameter
   (tVoid)memcpy(&tSpeechRate,(tVoid*)&tSpeechRateParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSpeechRateParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::u8GetData(tU32& tSpeechRateParam) {  
   vUpdate();
   tSpeechRateParam = tSpeechRate;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(tU32 &tSpeechRateParam) { 
   //init parameter
   (tVoid)memcpy(&tSpeechRate,(tVoid*)&tSpeechRateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSpeechRateParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(tU32)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(const tU32 &tSpeechRateParam) { 
   //init parameter
   (tVoid)memcpy(&tSpeechRate,(tVoid*)&tSpeechRateParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSpeechRateParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::vSetData(tU32)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "SpeechRate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "SpeechRate", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsSpeechRate::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SpeechRate", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element SpeechRate has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VoiceBargeIn"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVoiceBargeIn,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VoiceBargeIn",(tS32) 0x49fcb422);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tVoiceBargeIn = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VoiceBargeIn", (tS32)0x49fcb422);
   (tVoid)myDpElem.bFillData((tVoid*)&tVoiceBargeIn, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::tGetData() {
   vUpdate();
   return tVoiceBargeIn;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::s32GetData(tBool& tVoiceBargeInParam) { 
   vUpdate();
   tVoiceBargeInParam = tVoiceBargeIn;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VoiceBargeIn", (tS32)0x49fcb422);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::s32SetData(tBool &tVoiceBargeInParam) {
   //init parameter
   (tVoid)memcpy(&tVoiceBargeIn,(tVoid*)&tVoiceBargeInParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoiceBargeInParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(tBool)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::s32SetData(const tBool &tVoiceBargeInParam) {
   //init parameter
   (tVoid)memcpy(&tVoiceBargeIn,(tVoid*)&tVoiceBargeInParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVoiceBargeInParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::u8GetData(tBool& tVoiceBargeInParam) {  
   vUpdate();
   tVoiceBargeInParam = tVoiceBargeIn;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(tBool &tVoiceBargeInParam) { 
   //init parameter
   (tVoid)memcpy(&tVoiceBargeIn,(tVoid*)&tVoiceBargeInParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tVoiceBargeInParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(tBool)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(const tBool &tVoiceBargeInParam) { 
   //init parameter
   (tVoid)memcpy(&tVoiceBargeIn,(tVoid*)&tVoiceBargeInParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tVoiceBargeInParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::vSetData(tBool)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "VoiceBargeIn", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "VoiceBargeIn", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsVoiceBargeIn::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VoiceBargeIn", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element VoiceBargeIn has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SystemLanguage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSystemLanguage,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SystemLanguage",(tS32) 0x18ce925d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tSystemLanguage = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SystemLanguage", (tS32)0x18ce925d);
   (tVoid)myDpElem.bFillData((tVoid*)&tSystemLanguage, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::tGetData() {
   vUpdate();
   return tSystemLanguage;
};
tS32 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::s32GetData(tU32& tSystemLanguageParam) { 
   vUpdate();
   tSystemLanguageParam = tSystemLanguage;
   return _s32Status;
}
tS32 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SystemLanguage", (tS32)0x18ce925d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::s32SetData(tU32 &tSystemLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tSystemLanguage,(tVoid*)&tSystemLanguageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemLanguageParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(tU32)' could be made const reference
tS32 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::s32SetData(const tU32 &tSystemLanguageParam) {
   //init parameter
   (tVoid)memcpy(&tSystemLanguage,(tVoid*)&tSystemLanguageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSystemLanguageParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::u8GetData(tU32& tSystemLanguageParam) {  
   vUpdate();
   tSystemLanguageParam = tSystemLanguage;
   return _u8DataStatus;
}
tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(tU32 &tSystemLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemLanguage,(tVoid*)&tSystemLanguageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemLanguageParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(tU32)' could be made const reference
tVoid dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(const tU32 &tSystemLanguageParam) { 
   //init parameter
   (tVoid)memcpy(&tSystemLanguage,(tVoid*)&tSystemLanguageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tSystemLanguageParam' in function 'dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::vSetData(tU32)' could be made const reference
tU8   dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "SystemLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS, "SystemLanguage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclfc_sds_adapter_SpeechSettingsSystemLanguage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SystemLanguage", DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_FC_SDS_ADAPTER_SPEECHSETTINGS);
   }
   else
   {
      fprintf(stdout,"Element SystemLanguage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
