
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclmediaplayerDP.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DiPOCallControlsConfiguration"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclmediaplayerDPDiPOCallControlsConfiguration::dp_tclmediaplayerDPDiPOCallControlsConfiguration(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0046;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDiPOCallControlsConfiguration,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DiPOCallControlsConfiguration",(tS32) 0x906f7c00L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_MEDIAPLAYERDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDiPOCallControlsConfiguration = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DiPOCallControlsConfiguration", (tS32)0x906f7c00L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDiPOCallControlsConfiguration, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_MEDIAPLAYERDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclmediaplayerDPDiPOCallControlsConfiguration::s32GetStatus() const {return _s32Status;};
tU8   dp_tclmediaplayerDPDiPOCallControlsConfiguration::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclmediaplayerDPDiPOCallControlsConfiguration::tGetData() {
   vUpdate();
   return tDiPOCallControlsConfiguration;
};
tS32 dp_tclmediaplayerDPDiPOCallControlsConfiguration::s32GetData(tU8& tDiPOCallControlsConfigurationParam) { 
   vUpdate();
   tDiPOCallControlsConfigurationParam = tDiPOCallControlsConfiguration;
   return _s32Status;
}
tS32 dp_tclmediaplayerDPDiPOCallControlsConfiguration::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DiPOCallControlsConfiguration", (tS32)0x906f7c00L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_MEDIAPLAYERDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclmediaplayerDPDiPOCallControlsConfiguration::s32SetData(tU8 &tDiPOCallControlsConfigurationParam) {
   //init parameter
   (tVoid)memcpy(&tDiPOCallControlsConfiguration,(tVoid*)&tDiPOCallControlsConfigurationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiPOCallControlsConfigurationParam' in function 'dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(tU8)' could be made const reference
tS32 dp_tclmediaplayerDPDiPOCallControlsConfiguration::s32SetData(const tU8 &tDiPOCallControlsConfigurationParam) {
   //init parameter
   (tVoid)memcpy(&tDiPOCallControlsConfiguration,(tVoid*)&tDiPOCallControlsConfigurationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDiPOCallControlsConfigurationParam' in function 'dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclmediaplayerDPDiPOCallControlsConfiguration::u8GetData(tU8& tDiPOCallControlsConfigurationParam) {  
   vUpdate();
   tDiPOCallControlsConfigurationParam = tDiPOCallControlsConfiguration;
   return _u8DataStatus;
}
tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(tU8 &tDiPOCallControlsConfigurationParam) { 
   //init parameter
   (tVoid)memcpy(&tDiPOCallControlsConfiguration,(tVoid*)&tDiPOCallControlsConfigurationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiPOCallControlsConfigurationParam' in function 'dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(tU8)' could be made const reference
tVoid dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(const tU8 &tDiPOCallControlsConfigurationParam) { 
   //init parameter
   (tVoid)memcpy(&tDiPOCallControlsConfiguration,(tVoid*)&tDiPOCallControlsConfigurationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDiPOCallControlsConfigurationParam' in function 'dp_tclmediaplayerDPDiPOCallControlsConfiguration::vSetData(tU8)' could be made const reference
tU8   dp_tclmediaplayerDPDiPOCallControlsConfiguration::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclmediaplayerDPDiPOCallControlsConfiguration::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_MEDIAPLAYERDP, "DiPOCallControlsConfiguration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmediaplayerDPDiPOCallControlsConfiguration::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_MEDIAPLAYERDP, "DiPOCallControlsConfiguration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclmediaplayerDPDiPOCallControlsConfiguration::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DiPOCallControlsConfiguration", DP_U32_POOL_ID_MEDIAPLAYERDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_MEDIAPLAYERDP);
   }
   else
   {
      fprintf(stdout,"Element DiPOCallControlsConfiguration has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
