#ifndef _DP_FI_CMRDP_H
#define _DP_FI_CMRDP_H

extern tVoid vInitCMRDp(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclCMRDpCRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclCMRDpCRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCRC() {};

   //read access for pool element 
   tS32  s32GetData(tString &tCRCParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tCRCParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tCRCParam);
   tS32 s32SetData(const tString &tCRCParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tCRCParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tCRCParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tCRCParam);
   tVoid vSetData(const tString &tCRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpFolderPath{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclCMRDpFolderPath(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpFolderPath() {};

   //read access for pool element 
   tS32  s32GetData(tString &tFolderPathParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tFolderPathParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tFolderPathParam);
   tS32 s32SetData(const tString &tFolderPathParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tFolderPathParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tFolderPathParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tFolderPathParam);
   tVoid vSetData(const tString &tFolderPathParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpListtrackindex{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tListtrackindex;
   
public:
   dp_tclCMRDpListtrackindex(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpListtrackindex() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tListtrackindexParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tListtrackindexParam);
   tS32  s32SetData(const tU16 &tListtrackindexParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tListtrackindexParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tListtrackindexParam);
   tVoid vSetData(const tU16& tListtrackindexParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpListtype{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tListtype;
   
public:
   dp_tclCMRDpListtype(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpListtype() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tListtypeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tListtypeParam);
   tS32  s32SetData(const tU16 &tListtypeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tListtypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tListtypeParam);
   tVoid vSetData(const tU16& tListtypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpPLaybackMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPLaybackMode;
   
public:
   dp_tclCMRDpPLaybackMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpPLaybackMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPLaybackModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPLaybackModeParam);
   tS32  s32SetData(const tU8 &tPLaybackModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPLaybackModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPLaybackModeParam);
   tVoid vSetData(const tU8& tPLaybackModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpRegion{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tRegion;
   
public:
   dp_tclCMRDpRegion(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpRegion() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tRegionParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tRegionParam);
   tS32  s32SetData(const tU16 &tRegionParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tRegionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tRegionParam);
   tVoid vSetData(const tU16& tRegionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpSubSourceType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSubSourceType;
   
public:
   dp_tclCMRDpSubSourceType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpSubSourceType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSubSourceTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSubSourceTypeParam);
   tS32  s32SetData(const tU8 &tSubSourceTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSubSourceTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSubSourceTypeParam);
   tVoid vSetData(const tU8& tSubSourceTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_CRC{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclCMRDpCMP_CRC(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_CRC() {};

   //read access for pool element 
   tS32  s32GetData(tString &tCMP_CRCParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tCMP_CRCParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tCMP_CRCParam);
   tS32 s32SetData(const tString &tCMP_CRCParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tCMP_CRCParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tCMP_CRCParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tCMP_CRCParam);
   tVoid vSetData(const tString &tCMP_CRCParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_FolderPath{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclCMRDpCMP_FolderPath(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_FolderPath() {};

   //read access for pool element 
   tS32  s32GetData(tString &tCMP_FolderPathParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tCMP_FolderPathParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tCMP_FolderPathParam);
   tS32 s32SetData(const tString &tCMP_FolderPathParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tCMP_FolderPathParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tCMP_FolderPathParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tCMP_FolderPathParam);
   tVoid vSetData(const tString &tCMP_FolderPathParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_Listtrackindex{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tCMP_Listtrackindex;
   
public:
   dp_tclCMRDpCMP_Listtrackindex(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_Listtrackindex() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tCMP_ListtrackindexParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tCMP_ListtrackindexParam);
   tS32  s32SetData(const tU16 &tCMP_ListtrackindexParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tCMP_ListtrackindexParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tCMP_ListtrackindexParam);
   tVoid vSetData(const tU16& tCMP_ListtrackindexParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_Listtype{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU16 tCMP_Listtype;
   
public:
   dp_tclCMRDpCMP_Listtype(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_Listtype() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU16 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU16& tCMP_ListtypeParam);
   tVoid operator>>(tU16& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU16 &tCMP_ListtypeParam);
   tS32  s32SetData(const tU16 &tCMP_ListtypeParam);
   tVoid operator<<(tU16 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU16& tCMP_ListtypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU16& tCMP_ListtypeParam);
   tVoid vSetData(const tU16& tCMP_ListtypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_PLaybackMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCMP_PLaybackMode;
   
public:
   dp_tclCMRDpCMP_PLaybackMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_PLaybackMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCMP_PLaybackModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCMP_PLaybackModeParam);
   tS32  s32SetData(const tU8 &tCMP_PLaybackModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCMP_PLaybackModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCMP_PLaybackModeParam);
   tVoid vSetData(const tU8& tCMP_PLaybackModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclCMRDpCMP_SubSourceType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCMP_SubSourceType;
   
public:
   dp_tclCMRDpCMP_SubSourceType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclCMRDpCMP_SubSourceType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCMP_SubSourceTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCMP_SubSourceTypeParam);
   tS32  s32SetData(const tU8 &tCMP_SubSourceTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCMP_SubSourceTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCMP_SubSourceTypeParam);
   tVoid vSetData(const tU8& tCMP_SubSourceTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
