
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclCMRDp.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCRC::dp_tclCMRDpCRC(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclCMRDpCRC::s32SetData(tString &tCRCParam) {
   tU32 u32Len = (tU32)strlen(tCRCParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CRC", (tS32)0x868);
      (tVoid)myDpElem.bFillData((tVoid*)tCRCParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCRC::s32SetData(const tString &tCRCParam) {
   tU32 u32Len = (tU32)strlen(tCRCParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CRC", (tS32)0x868);
      (tVoid)myDpElem.bFillData((tVoid*)tCRCParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCRC::s32GetData(tString &tCRCParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CRC", (tS32)0x868);
   (tVoid)memset(tCRCParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCRCParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCRC::s32GetData(const tString &tCRCParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CRC", (tS32)0x868);
   (tVoid)memset(tCRCParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCRCParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclCMRDpCRC::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclCMRDpCRC::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclCMRDpCRC::u32GetData(tString &tCRCParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCRCParam, u32StringBufLen);
   };
    tU32  dp_tclCMRDpCRC::u32GetData(const tString &tCRCParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCRCParam, u32StringBufLen);
   };
   tVoid dp_tclCMRDpCRC::vSetData(tString &tCRCParam){(tVoid)s32SetData(tCRCParam);};
   tVoid dp_tclCMRDpCRC::vSetData(const tString &tCRCParam){(tVoid)s32SetData(tCRCParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclCMRDpCRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CRC", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CRC", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCRC::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CRC", DP_U32_POOL_ID_CMRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
		}
		else
		{
			fprintf(stdout,"Element CRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FolderPath"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpFolderPath::dp_tclCMRDpFolderPath(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclCMRDpFolderPath::s32SetData(tString &tFolderPathParam) {
   tU32 u32Len = (tU32)strlen(tFolderPathParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("FolderPath", (tS32)0xb5a771d);
      (tVoid)myDpElem.bFillData((tVoid*)tFolderPathParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpFolderPath::s32SetData(const tString &tFolderPathParam) {
   tU32 u32Len = (tU32)strlen(tFolderPathParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("FolderPath", (tS32)0xb5a771d);
      (tVoid)myDpElem.bFillData((tVoid*)tFolderPathParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpFolderPath::s32GetData(tString &tFolderPathParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("FolderPath", (tS32)0xb5a771d);
   (tVoid)memset(tFolderPathParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tFolderPathParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclCMRDpFolderPath::s32GetData(const tString &tFolderPathParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("FolderPath", (tS32)0xb5a771d);
   (tVoid)memset(tFolderPathParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tFolderPathParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclCMRDpFolderPath::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclCMRDpFolderPath::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclCMRDpFolderPath::u32GetData(tString &tFolderPathParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tFolderPathParam, u32StringBufLen);
   };
    tU32  dp_tclCMRDpFolderPath::u32GetData(const tString &tFolderPathParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tFolderPathParam, u32StringBufLen);
   };
   tVoid dp_tclCMRDpFolderPath::vSetData(tString &tFolderPathParam){(tVoid)s32SetData(tFolderPathParam);};
   tVoid dp_tclCMRDpFolderPath::vSetData(const tString &tFolderPathParam){(tVoid)s32SetData(tFolderPathParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclCMRDpFolderPath::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "FolderPath", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpFolderPath::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "FolderPath", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpFolderPath::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FolderPath", DP_U32_POOL_ID_CMRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
		}
		else
		{
			fprintf(stdout,"Element FolderPath has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Listtrackindex"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpListtrackindex::dp_tclCMRDpListtrackindex(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tListtrackindex,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpListtrackindex::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Listtrackindex",(tS32) 0x349efa79);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tListtrackindex = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpListtrackindex::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Listtrackindex", (tS32)0x349efa79);
   (tVoid)myDpElem.bFillData((tVoid*)&tListtrackindex, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpListtrackindex::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpListtrackindex::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclCMRDpListtrackindex::tGetData() {
   vUpdate();
   return tListtrackindex;
};
tS32 dp_tclCMRDpListtrackindex::s32GetData(tU16& tListtrackindexParam) { 
   vUpdate();
   tListtrackindexParam = tListtrackindex;
   return _s32Status;
}
tS32 dp_tclCMRDpListtrackindex::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Listtrackindex", (tS32)0x349efa79);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpListtrackindex::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpListtrackindex::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpListtrackindex::s32SetData(tU16 &tListtrackindexParam) {
   //init parameter
   (tVoid)memcpy(&tListtrackindex,(tVoid*)&tListtrackindexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tListtrackindexParam' in function 'dp_tclCMRDpListtrackindex::vSetData(tU16)' could be made const reference
tS32 dp_tclCMRDpListtrackindex::s32SetData(const tU16 &tListtrackindexParam) {
   //init parameter
   (tVoid)memcpy(&tListtrackindex,(tVoid*)&tListtrackindexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tListtrackindexParam' in function 'dp_tclCMRDpListtrackindex::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpListtrackindex::u8GetData(tU16& tListtrackindexParam) {  
   vUpdate();
   tListtrackindexParam = tListtrackindex;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpListtrackindex::vSetData(tU16 &tListtrackindexParam) { 
   //init parameter
   (tVoid)memcpy(&tListtrackindex,(tVoid*)&tListtrackindexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tListtrackindexParam' in function 'dp_tclCMRDpListtrackindex::vSetData(tU16)' could be made const reference
tVoid dp_tclCMRDpListtrackindex::vSetData(const tU16 &tListtrackindexParam) { 
   //init parameter
   (tVoid)memcpy(&tListtrackindex,(tVoid*)&tListtrackindexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tListtrackindexParam' in function 'dp_tclCMRDpListtrackindex::vSetData(tU16)' could be made const reference
tU8   dp_tclCMRDpListtrackindex::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpListtrackindex::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "Listtrackindex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpListtrackindex::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "Listtrackindex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpListtrackindex::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Listtrackindex", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element Listtrackindex has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Listtype"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpListtype::dp_tclCMRDpListtype(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tListtype,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpListtype::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Listtype",(tS32) 0x7a801a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tListtype = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpListtype::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Listtype", (tS32)0x7a801a);
   (tVoid)myDpElem.bFillData((tVoid*)&tListtype, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpListtype::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpListtype::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclCMRDpListtype::tGetData() {
   vUpdate();
   return tListtype;
};
tS32 dp_tclCMRDpListtype::s32GetData(tU16& tListtypeParam) { 
   vUpdate();
   tListtypeParam = tListtype;
   return _s32Status;
}
tS32 dp_tclCMRDpListtype::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Listtype", (tS32)0x7a801a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpListtype::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpListtype::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpListtype::s32SetData(tU16 &tListtypeParam) {
   //init parameter
   (tVoid)memcpy(&tListtype,(tVoid*)&tListtypeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tListtypeParam' in function 'dp_tclCMRDpListtype::vSetData(tU16)' could be made const reference
tS32 dp_tclCMRDpListtype::s32SetData(const tU16 &tListtypeParam) {
   //init parameter
   (tVoid)memcpy(&tListtype,(tVoid*)&tListtypeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tListtypeParam' in function 'dp_tclCMRDpListtype::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpListtype::u8GetData(tU16& tListtypeParam) {  
   vUpdate();
   tListtypeParam = tListtype;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpListtype::vSetData(tU16 &tListtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tListtype,(tVoid*)&tListtypeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tListtypeParam' in function 'dp_tclCMRDpListtype::vSetData(tU16)' could be made const reference
tVoid dp_tclCMRDpListtype::vSetData(const tU16 &tListtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tListtype,(tVoid*)&tListtypeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tListtypeParam' in function 'dp_tclCMRDpListtype::vSetData(tU16)' could be made const reference
tU8   dp_tclCMRDpListtype::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpListtype::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "Listtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpListtype::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "Listtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpListtype::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Listtype", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element Listtype has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PLaybackMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpPLaybackMode::dp_tclCMRDpPLaybackMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPLaybackMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpPLaybackMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PLaybackMode",(tS32) 0x23bf75c0);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPLaybackMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpPLaybackMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PLaybackMode", (tS32)0x23bf75c0);
   (tVoid)myDpElem.bFillData((tVoid*)&tPLaybackMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpPLaybackMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpPLaybackMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCMRDpPLaybackMode::tGetData() {
   vUpdate();
   return tPLaybackMode;
};
tS32 dp_tclCMRDpPLaybackMode::s32GetData(tU8& tPLaybackModeParam) { 
   vUpdate();
   tPLaybackModeParam = tPLaybackMode;
   return _s32Status;
}
tS32 dp_tclCMRDpPLaybackMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PLaybackMode", (tS32)0x23bf75c0);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpPLaybackMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpPLaybackMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpPLaybackMode::s32SetData(tU8 &tPLaybackModeParam) {
   //init parameter
   (tVoid)memcpy(&tPLaybackMode,(tVoid*)&tPLaybackModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPLaybackModeParam' in function 'dp_tclCMRDpPLaybackMode::vSetData(tU8)' could be made const reference
tS32 dp_tclCMRDpPLaybackMode::s32SetData(const tU8 &tPLaybackModeParam) {
   //init parameter
   (tVoid)memcpy(&tPLaybackMode,(tVoid*)&tPLaybackModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPLaybackModeParam' in function 'dp_tclCMRDpPLaybackMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpPLaybackMode::u8GetData(tU8& tPLaybackModeParam) {  
   vUpdate();
   tPLaybackModeParam = tPLaybackMode;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpPLaybackMode::vSetData(tU8 &tPLaybackModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPLaybackMode,(tVoid*)&tPLaybackModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPLaybackModeParam' in function 'dp_tclCMRDpPLaybackMode::vSetData(tU8)' could be made const reference
tVoid dp_tclCMRDpPLaybackMode::vSetData(const tU8 &tPLaybackModeParam) { 
   //init parameter
   (tVoid)memcpy(&tPLaybackMode,(tVoid*)&tPLaybackModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPLaybackModeParam' in function 'dp_tclCMRDpPLaybackMode::vSetData(tU8)' could be made const reference
tU8   dp_tclCMRDpPLaybackMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpPLaybackMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "PLaybackMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpPLaybackMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "PLaybackMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpPLaybackMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PLaybackMode", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element PLaybackMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Region"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpRegion::dp_tclCMRDpRegion(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tRegion,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpRegion::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Region",(tS32) 0x51eb4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tRegion = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpRegion::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Region", (tS32)0x51eb4);
   (tVoid)myDpElem.bFillData((tVoid*)&tRegion, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpRegion::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpRegion::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclCMRDpRegion::tGetData() {
   vUpdate();
   return tRegion;
};
tS32 dp_tclCMRDpRegion::s32GetData(tU16& tRegionParam) { 
   vUpdate();
   tRegionParam = tRegion;
   return _s32Status;
}
tS32 dp_tclCMRDpRegion::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Region", (tS32)0x51eb4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpRegion::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpRegion::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpRegion::s32SetData(tU16 &tRegionParam) {
   //init parameter
   (tVoid)memcpy(&tRegion,(tVoid*)&tRegionParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRegionParam' in function 'dp_tclCMRDpRegion::vSetData(tU16)' could be made const reference
tS32 dp_tclCMRDpRegion::s32SetData(const tU16 &tRegionParam) {
   //init parameter
   (tVoid)memcpy(&tRegion,(tVoid*)&tRegionParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tRegionParam' in function 'dp_tclCMRDpRegion::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpRegion::u8GetData(tU16& tRegionParam) {  
   vUpdate();
   tRegionParam = tRegion;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpRegion::vSetData(tU16 &tRegionParam) { 
   //init parameter
   (tVoid)memcpy(&tRegion,(tVoid*)&tRegionParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tRegionParam' in function 'dp_tclCMRDpRegion::vSetData(tU16)' could be made const reference
tVoid dp_tclCMRDpRegion::vSetData(const tU16 &tRegionParam) { 
   //init parameter
   (tVoid)memcpy(&tRegion,(tVoid*)&tRegionParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tRegionParam' in function 'dp_tclCMRDpRegion::vSetData(tU16)' could be made const reference
tU8   dp_tclCMRDpRegion::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpRegion::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "Region", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpRegion::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "Region", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpRegion::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Region", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element Region has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SubSourceType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpSubSourceType::dp_tclCMRDpSubSourceType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSubSourceType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpSubSourceType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SubSourceType",(tS32) 0x5249c8f5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSubSourceType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpSubSourceType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SubSourceType", (tS32)0x5249c8f5);
   (tVoid)myDpElem.bFillData((tVoid*)&tSubSourceType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpSubSourceType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpSubSourceType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCMRDpSubSourceType::tGetData() {
   vUpdate();
   return tSubSourceType;
};
tS32 dp_tclCMRDpSubSourceType::s32GetData(tU8& tSubSourceTypeParam) { 
   vUpdate();
   tSubSourceTypeParam = tSubSourceType;
   return _s32Status;
}
tS32 dp_tclCMRDpSubSourceType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SubSourceType", (tS32)0x5249c8f5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpSubSourceType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpSubSourceType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpSubSourceType::s32SetData(tU8 &tSubSourceTypeParam) {
   //init parameter
   (tVoid)memcpy(&tSubSourceType,(tVoid*)&tSubSourceTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubSourceTypeParam' in function 'dp_tclCMRDpSubSourceType::vSetData(tU8)' could be made const reference
tS32 dp_tclCMRDpSubSourceType::s32SetData(const tU8 &tSubSourceTypeParam) {
   //init parameter
   (tVoid)memcpy(&tSubSourceType,(tVoid*)&tSubSourceTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSubSourceTypeParam' in function 'dp_tclCMRDpSubSourceType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpSubSourceType::u8GetData(tU8& tSubSourceTypeParam) {  
   vUpdate();
   tSubSourceTypeParam = tSubSourceType;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpSubSourceType::vSetData(tU8 &tSubSourceTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tSubSourceType,(tVoid*)&tSubSourceTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSubSourceTypeParam' in function 'dp_tclCMRDpSubSourceType::vSetData(tU8)' could be made const reference
tVoid dp_tclCMRDpSubSourceType::vSetData(const tU8 &tSubSourceTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tSubSourceType,(tVoid*)&tSubSourceTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSubSourceTypeParam' in function 'dp_tclCMRDpSubSourceType::vSetData(tU8)' could be made const reference
tU8   dp_tclCMRDpSubSourceType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpSubSourceType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "SubSourceType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpSubSourceType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "SubSourceType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpSubSourceType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SubSourceType", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element SubSourceType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_CRC"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_CRC::dp_tclCMRDpCMP_CRC(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclCMRDpCMP_CRC::s32SetData(tString &tCMP_CRCParam) {
   tU32 u32Len = (tU32)strlen(tCMP_CRCParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CMP_CRC", (tS32)0x149f67);
      (tVoid)myDpElem.bFillData((tVoid*)tCMP_CRCParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_CRC::s32SetData(const tString &tCMP_CRCParam) {
   tU32 u32Len = (tU32)strlen(tCMP_CRCParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CMP_CRC", (tS32)0x149f67);
      (tVoid)myDpElem.bFillData((tVoid*)tCMP_CRCParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_CRC::s32GetData(tString &tCMP_CRCParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CMP_CRC", (tS32)0x149f67);
   (tVoid)memset(tCMP_CRCParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCMP_CRCParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_CRC::s32GetData(const tString &tCMP_CRCParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CMP_CRC", (tS32)0x149f67);
   (tVoid)memset(tCMP_CRCParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCMP_CRCParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclCMRDpCMP_CRC::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclCMRDpCMP_CRC::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclCMRDpCMP_CRC::u32GetData(tString &tCMP_CRCParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCMP_CRCParam, u32StringBufLen);
   };
    tU32  dp_tclCMRDpCMP_CRC::u32GetData(const tString &tCMP_CRCParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCMP_CRCParam, u32StringBufLen);
   };
   tVoid dp_tclCMRDpCMP_CRC::vSetData(tString &tCMP_CRCParam){(tVoid)s32SetData(tCMP_CRCParam);};
   tVoid dp_tclCMRDpCMP_CRC::vSetData(const tString &tCMP_CRCParam){(tVoid)s32SetData(tCMP_CRCParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclCMRDpCMP_CRC::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_CRC", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCMP_CRC::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_CRC", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCMP_CRC::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_CRC", DP_U32_POOL_ID_CMRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
		}
		else
		{
			fprintf(stdout,"Element CMP_CRC has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_FolderPath"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_FolderPath::dp_tclCMRDpCMP_FolderPath(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclCMRDpCMP_FolderPath::s32SetData(tString &tCMP_FolderPathParam) {
   tU32 u32Len = (tU32)strlen(tCMP_FolderPathParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CMP_FolderPath", (tS32)0x96ded0f0);
      (tVoid)myDpElem.bFillData((tVoid*)tCMP_FolderPathParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_FolderPath::s32SetData(const tString &tCMP_FolderPathParam) {
   tU32 u32Len = (tU32)strlen(tCMP_FolderPathParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("CMP_FolderPath", (tS32)0x96ded0f0);
      (tVoid)myDpElem.bFillData((tVoid*)tCMP_FolderPathParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_FolderPath::s32GetData(tString &tCMP_FolderPathParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CMP_FolderPath", (tS32)0x96ded0f0);
   (tVoid)memset(tCMP_FolderPathParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCMP_FolderPathParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclCMRDpCMP_FolderPath::s32GetData(const tString &tCMP_FolderPathParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("CMP_FolderPath", (tS32)0x96ded0f0);
   (tVoid)memset(tCMP_FolderPathParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tCMP_FolderPathParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclCMRDpCMP_FolderPath::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclCMRDpCMP_FolderPath::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclCMRDpCMP_FolderPath::u32GetData(tString &tCMP_FolderPathParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCMP_FolderPathParam, u32StringBufLen);
   };
    tU32  dp_tclCMRDpCMP_FolderPath::u32GetData(const tString &tCMP_FolderPathParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tCMP_FolderPathParam, u32StringBufLen);
   };
   tVoid dp_tclCMRDpCMP_FolderPath::vSetData(tString &tCMP_FolderPathParam){(tVoid)s32SetData(tCMP_FolderPathParam);};
   tVoid dp_tclCMRDpCMP_FolderPath::vSetData(const tString &tCMP_FolderPathParam){(tVoid)s32SetData(tCMP_FolderPathParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclCMRDpCMP_FolderPath::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_FolderPath", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCMP_FolderPath::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_FolderPath", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclCMRDpCMP_FolderPath::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_FolderPath", DP_U32_POOL_ID_CMRDP);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
		}
		else
		{
			fprintf(stdout,"Element CMP_FolderPath has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_Listtrackindex"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_Listtrackindex::dp_tclCMRDpCMP_Listtrackindex(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCMP_Listtrackindex,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpCMP_Listtrackindex::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CMP_Listtrackindex",(tS32) 0xd2be469c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tCMP_Listtrackindex = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpCMP_Listtrackindex::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CMP_Listtrackindex", (tS32)0xd2be469c);
   (tVoid)myDpElem.bFillData((tVoid*)&tCMP_Listtrackindex, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpCMP_Listtrackindex::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpCMP_Listtrackindex::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclCMRDpCMP_Listtrackindex::tGetData() {
   vUpdate();
   return tCMP_Listtrackindex;
};
tS32 dp_tclCMRDpCMP_Listtrackindex::s32GetData(tU16& tCMP_ListtrackindexParam) { 
   vUpdate();
   tCMP_ListtrackindexParam = tCMP_Listtrackindex;
   return _s32Status;
}
tS32 dp_tclCMRDpCMP_Listtrackindex::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CMP_Listtrackindex", (tS32)0xd2be469c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpCMP_Listtrackindex::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpCMP_Listtrackindex::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpCMP_Listtrackindex::s32SetData(tU16 &tCMP_ListtrackindexParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_Listtrackindex,(tVoid*)&tCMP_ListtrackindexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_ListtrackindexParam' in function 'dp_tclCMRDpCMP_Listtrackindex::vSetData(tU16)' could be made const reference
tS32 dp_tclCMRDpCMP_Listtrackindex::s32SetData(const tU16 &tCMP_ListtrackindexParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_Listtrackindex,(tVoid*)&tCMP_ListtrackindexParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_ListtrackindexParam' in function 'dp_tclCMRDpCMP_Listtrackindex::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpCMP_Listtrackindex::u8GetData(tU16& tCMP_ListtrackindexParam) {  
   vUpdate();
   tCMP_ListtrackindexParam = tCMP_Listtrackindex;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpCMP_Listtrackindex::vSetData(tU16 &tCMP_ListtrackindexParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_Listtrackindex,(tVoid*)&tCMP_ListtrackindexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCMP_ListtrackindexParam' in function 'dp_tclCMRDpCMP_Listtrackindex::vSetData(tU16)' could be made const reference
tVoid dp_tclCMRDpCMP_Listtrackindex::vSetData(const tU16 &tCMP_ListtrackindexParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_Listtrackindex,(tVoid*)&tCMP_ListtrackindexParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCMP_ListtrackindexParam' in function 'dp_tclCMRDpCMP_Listtrackindex::vSetData(tU16)' could be made const reference
tU8   dp_tclCMRDpCMP_Listtrackindex::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpCMP_Listtrackindex::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_Listtrackindex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_Listtrackindex::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_Listtrackindex", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_Listtrackindex::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_Listtrackindex", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element CMP_Listtrackindex has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_Listtype"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_Listtype::dp_tclCMRDpCMP_Listtype(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCMP_Listtype,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpCMP_Listtype::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CMP_Listtype",(tS32) 0xfbd1b6e5);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tCMP_Listtype = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpCMP_Listtype::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CMP_Listtype", (tS32)0xfbd1b6e5);
   (tVoid)myDpElem.bFillData((tVoid*)&tCMP_Listtype, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpCMP_Listtype::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpCMP_Listtype::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclCMRDpCMP_Listtype::tGetData() {
   vUpdate();
   return tCMP_Listtype;
};
tS32 dp_tclCMRDpCMP_Listtype::s32GetData(tU16& tCMP_ListtypeParam) { 
   vUpdate();
   tCMP_ListtypeParam = tCMP_Listtype;
   return _s32Status;
}
tS32 dp_tclCMRDpCMP_Listtype::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CMP_Listtype", (tS32)0xfbd1b6e5);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpCMP_Listtype::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpCMP_Listtype::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpCMP_Listtype::s32SetData(tU16 &tCMP_ListtypeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_Listtype,(tVoid*)&tCMP_ListtypeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_ListtypeParam' in function 'dp_tclCMRDpCMP_Listtype::vSetData(tU16)' could be made const reference
tS32 dp_tclCMRDpCMP_Listtype::s32SetData(const tU16 &tCMP_ListtypeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_Listtype,(tVoid*)&tCMP_ListtypeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_ListtypeParam' in function 'dp_tclCMRDpCMP_Listtype::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpCMP_Listtype::u8GetData(tU16& tCMP_ListtypeParam) {  
   vUpdate();
   tCMP_ListtypeParam = tCMP_Listtype;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpCMP_Listtype::vSetData(tU16 &tCMP_ListtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_Listtype,(tVoid*)&tCMP_ListtypeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCMP_ListtypeParam' in function 'dp_tclCMRDpCMP_Listtype::vSetData(tU16)' could be made const reference
tVoid dp_tclCMRDpCMP_Listtype::vSetData(const tU16 &tCMP_ListtypeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_Listtype,(tVoid*)&tCMP_ListtypeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tCMP_ListtypeParam' in function 'dp_tclCMRDpCMP_Listtype::vSetData(tU16)' could be made const reference
tU8   dp_tclCMRDpCMP_Listtype::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpCMP_Listtype::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_Listtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_Listtype::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_Listtype", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_Listtype::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_Listtype", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element CMP_Listtype has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_PLaybackMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_PLaybackMode::dp_tclCMRDpCMP_PLaybackMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCMP_PLaybackMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpCMP_PLaybackMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CMP_PLaybackMode",(tS32) 0xc3ac3b5b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCMP_PLaybackMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpCMP_PLaybackMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CMP_PLaybackMode", (tS32)0xc3ac3b5b);
   (tVoid)myDpElem.bFillData((tVoid*)&tCMP_PLaybackMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpCMP_PLaybackMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpCMP_PLaybackMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCMRDpCMP_PLaybackMode::tGetData() {
   vUpdate();
   return tCMP_PLaybackMode;
};
tS32 dp_tclCMRDpCMP_PLaybackMode::s32GetData(tU8& tCMP_PLaybackModeParam) { 
   vUpdate();
   tCMP_PLaybackModeParam = tCMP_PLaybackMode;
   return _s32Status;
}
tS32 dp_tclCMRDpCMP_PLaybackMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CMP_PLaybackMode", (tS32)0xc3ac3b5b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpCMP_PLaybackMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpCMP_PLaybackMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpCMP_PLaybackMode::s32SetData(tU8 &tCMP_PLaybackModeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_PLaybackMode,(tVoid*)&tCMP_PLaybackModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_PLaybackModeParam' in function 'dp_tclCMRDpCMP_PLaybackMode::vSetData(tU8)' could be made const reference
tS32 dp_tclCMRDpCMP_PLaybackMode::s32SetData(const tU8 &tCMP_PLaybackModeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_PLaybackMode,(tVoid*)&tCMP_PLaybackModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_PLaybackModeParam' in function 'dp_tclCMRDpCMP_PLaybackMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpCMP_PLaybackMode::u8GetData(tU8& tCMP_PLaybackModeParam) {  
   vUpdate();
   tCMP_PLaybackModeParam = tCMP_PLaybackMode;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpCMP_PLaybackMode::vSetData(tU8 &tCMP_PLaybackModeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_PLaybackMode,(tVoid*)&tCMP_PLaybackModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCMP_PLaybackModeParam' in function 'dp_tclCMRDpCMP_PLaybackMode::vSetData(tU8)' could be made const reference
tVoid dp_tclCMRDpCMP_PLaybackMode::vSetData(const tU8 &tCMP_PLaybackModeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_PLaybackMode,(tVoid*)&tCMP_PLaybackModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCMP_PLaybackModeParam' in function 'dp_tclCMRDpCMP_PLaybackMode::vSetData(tU8)' could be made const reference
tU8   dp_tclCMRDpCMP_PLaybackMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpCMP_PLaybackMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_PLaybackMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_PLaybackMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_PLaybackMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_PLaybackMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_PLaybackMode", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element CMP_PLaybackMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CMP_SubSourceType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclCMRDpCMP_SubSourceType::dp_tclCMRDpCMP_SubSourceType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCMP_SubSourceType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclCMRDpCMP_SubSourceType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CMP_SubSourceType",(tS32) 0x71e9a4fc);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCMP_SubSourceType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclCMRDpCMP_SubSourceType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CMP_SubSourceType", (tS32)0x71e9a4fc);
   (tVoid)myDpElem.bFillData((tVoid*)&tCMP_SubSourceType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclCMRDpCMP_SubSourceType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclCMRDpCMP_SubSourceType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclCMRDpCMP_SubSourceType::tGetData() {
   vUpdate();
   return tCMP_SubSourceType;
};
tS32 dp_tclCMRDpCMP_SubSourceType::s32GetData(tU8& tCMP_SubSourceTypeParam) { 
   vUpdate();
   tCMP_SubSourceTypeParam = tCMP_SubSourceType;
   return _s32Status;
}
tS32 dp_tclCMRDpCMP_SubSourceType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CMP_SubSourceType", (tS32)0x71e9a4fc);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_CMRDP, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclCMRDpCMP_SubSourceType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclCMRDpCMP_SubSourceType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclCMRDpCMP_SubSourceType::s32SetData(tU8 &tCMP_SubSourceTypeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_SubSourceType,(tVoid*)&tCMP_SubSourceTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_SubSourceTypeParam' in function 'dp_tclCMRDpCMP_SubSourceType::vSetData(tU8)' could be made const reference
tS32 dp_tclCMRDpCMP_SubSourceType::s32SetData(const tU8 &tCMP_SubSourceTypeParam) {
   //init parameter
   (tVoid)memcpy(&tCMP_SubSourceType,(tVoid*)&tCMP_SubSourceTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCMP_SubSourceTypeParam' in function 'dp_tclCMRDpCMP_SubSourceType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclCMRDpCMP_SubSourceType::u8GetData(tU8& tCMP_SubSourceTypeParam) {  
   vUpdate();
   tCMP_SubSourceTypeParam = tCMP_SubSourceType;
   return _u8DataStatus;
}
tVoid dp_tclCMRDpCMP_SubSourceType::vSetData(tU8 &tCMP_SubSourceTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_SubSourceType,(tVoid*)&tCMP_SubSourceTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCMP_SubSourceTypeParam' in function 'dp_tclCMRDpCMP_SubSourceType::vSetData(tU8)' could be made const reference
tVoid dp_tclCMRDpCMP_SubSourceType::vSetData(const tU8 &tCMP_SubSourceTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tCMP_SubSourceType,(tVoid*)&tCMP_SubSourceTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCMP_SubSourceTypeParam' in function 'dp_tclCMRDpCMP_SubSourceType::vSetData(tU8)' could be made const reference
tU8   dp_tclCMRDpCMP_SubSourceType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclCMRDpCMP_SubSourceType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_CMRDP, "CMP_SubSourceType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_SubSourceType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_CMRDP, "CMP_SubSourceType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclCMRDpCMP_SubSourceType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CMP_SubSourceType", DP_U32_POOL_ID_CMRDP);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_CMRDP);
   }
   else
   {
      fprintf(stdout,"Element CMP_SubSourceType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
