#ifndef _DP_FI_APPHMI_SPI_H
#define _DP_FI_APPHMI_SPI_H

extern tVoid vInitAppHmi_SPI(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define DUMMY 
#include "../../ai_inf4cv_hmi/products/INF4CV/Apps/AppHmi_SPI/App/datapool/apphmi_spi_datapool_if.h"
//lint +e750




class dp_tclAppHmi_SPIPersMemVarsSPI{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   HmiAppSPI::PersMemVars tPersMemVarsSPI;
   
public:
   dp_tclAppHmi_SPIPersMemVarsSPI(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SPIPersMemVarsSPI() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   HmiAppSPI::PersMemVars tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(HmiAppSPI::PersMemVars& tPersMemVarsSPIParam);
   tVoid operator>>(HmiAppSPI::PersMemVars& oParam);
   
   //write access for pool element 
   tS32  s32SetData(HmiAppSPI::PersMemVars &tPersMemVarsSPIParam);
   tS32  s32SetData(const HmiAppSPI::PersMemVars &tPersMemVarsSPIParam);
   tVoid operator<<(HmiAppSPI::PersMemVars oParam);
   
   // do not use --> old interface
   tU8   u8GetData(HmiAppSPI::PersMemVars& tPersMemVarsSPIParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(HmiAppSPI::PersMemVars& tPersMemVarsSPIParam);
   tVoid vSetData(const HmiAppSPI::PersMemVars& tPersMemVarsSPIParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SPIVDLanguageIndexSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDLanguageIndexSystem;
   
public:
   dp_tclAppHmi_SPIVDLanguageIndexSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SPIVDLanguageIndexSystem() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDLanguageIndexSystemParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDLanguageIndexSystemParam);
   tS32  s32SetData(const tU8 &tVDLanguageIndexSystemParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDLanguageIndexSystemParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDLanguageIndexSystemParam);
   tVoid vSetData(const tU8& tVDLanguageIndexSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SPIdummy{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tdummy;
   
public:
   dp_tclAppHmi_SPIdummy(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SPIdummy() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tdummyParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tdummyParam);
   tS32  s32SetData(const tU32 &tdummyParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tdummyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tdummyParam);
   tVoid vSetData(const tU32& tdummyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
