
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_SPI.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PersMemVarsSPI"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SPIPersMemVarsSPI::dp_tclAppHmi_SPIPersMemVarsSPI(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPersMemVarsSPI,0,sizeof(HmiAppSPI::PersMemVars));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SPIPersMemVarsSPI::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PersMemVarsSPI",(tS32) 0x152897a1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(HmiAppSPI::PersMemVars)) 
      {
         tPersMemVarsSPI = *((HmiAppSPI::PersMemVars*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SPIPersMemVarsSPI::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PersMemVarsSPI", (tS32)0x152897a1);
   (tVoid)myDpElem.bFillData((tVoid*)&tPersMemVarsSPI, (tU32)sizeof(HmiAppSPI::PersMemVars));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SPIPersMemVarsSPI::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SPIPersMemVarsSPI::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
HmiAppSPI::PersMemVars dp_tclAppHmi_SPIPersMemVarsSPI::tGetData() {
   vUpdate();
   return tPersMemVarsSPI;
};
tS32 dp_tclAppHmi_SPIPersMemVarsSPI::s32GetData(HmiAppSPI::PersMemVars& tPersMemVarsSPIParam) { 
   vUpdate();
   tPersMemVarsSPIParam = tPersMemVarsSPI;
   return _s32Status;
}
tS32 dp_tclAppHmi_SPIPersMemVarsSPI::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PersMemVarsSPI", (tS32)0x152897a1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SPIPersMemVarsSPI::operator>>(HmiAppSPI::PersMemVars& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SPIPersMemVarsSPI::operator<<(HmiAppSPI::PersMemVars oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SPIPersMemVarsSPI::s32SetData(HmiAppSPI::PersMemVars &tPersMemVarsSPIParam) {
   //init parameter
   (tVoid)memcpy(&tPersMemVarsSPI,(tVoid*)&tPersMemVarsSPIParam, sizeof(HmiAppSPI::PersMemVars));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPersMemVarsSPIParam' in function 'dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(HmiAppSPI::PersMemVars)' could be made const reference
tS32 dp_tclAppHmi_SPIPersMemVarsSPI::s32SetData(const HmiAppSPI::PersMemVars &tPersMemVarsSPIParam) {
   //init parameter
   (tVoid)memcpy(&tPersMemVarsSPI,(tVoid*)&tPersMemVarsSPIParam, sizeof(HmiAppSPI::PersMemVars));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPersMemVarsSPIParam' in function 'dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(HmiAppSPI::PersMemVars)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SPIPersMemVarsSPI::u8GetData(HmiAppSPI::PersMemVars& tPersMemVarsSPIParam) {  
   vUpdate();
   tPersMemVarsSPIParam = tPersMemVarsSPI;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(HmiAppSPI::PersMemVars &tPersMemVarsSPIParam) { 
   //init parameter
   (tVoid)memcpy(&tPersMemVarsSPI,(tVoid*)&tPersMemVarsSPIParam, sizeof(HmiAppSPI::PersMemVars));
   vStore();
}//lint !e1746: parameter 'tPersMemVarsSPIParam' in function 'dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(HmiAppSPI::PersMemVars)' could be made const reference
tVoid dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(const HmiAppSPI::PersMemVars &tPersMemVarsSPIParam) { 
   //init parameter
   (tVoid)memcpy(&tPersMemVarsSPI,(tVoid*)&tPersMemVarsSPIParam, sizeof(HmiAppSPI::PersMemVars));
   vStore();
}//lint !e1746: parameter 'tPersMemVarsSPIParam' in function 'dp_tclAppHmi_SPIPersMemVarsSPI::vSetData(HmiAppSPI::PersMemVars)' could be made const reference
tU8   dp_tclAppHmi_SPIPersMemVarsSPI::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SPIPersMemVarsSPI::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SPI, "PersMemVarsSPI", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIPersMemVarsSPI::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SPI, "PersMemVarsSPI", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIPersMemVarsSPI::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PersMemVarsSPI", DP_U32_POOL_ID_APPHMI_SPI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SPI);
   }
   else
   {
      fprintf(stdout,"Element PersMemVarsSPI has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDLanguageIndexSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SPIVDLanguageIndexSystem::dp_tclAppHmi_SPIVDLanguageIndexSystem(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDLanguageIndexSystem,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem",(tS32) 0x65a084db);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDLanguageIndexSystem = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem", (tS32)0x65a084db);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDLanguageIndexSystem, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SPIVDLanguageIndexSystem::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SPIVDLanguageIndexSystem::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_SPIVDLanguageIndexSystem::tGetData() {
   vUpdate();
   return tVDLanguageIndexSystem;
};
tS32 dp_tclAppHmi_SPIVDLanguageIndexSystem::s32GetData(tU8& tVDLanguageIndexSystemParam) { 
   vUpdate();
   tVDLanguageIndexSystemParam = tVDLanguageIndexSystem;
   return _s32Status;
}
tS32 dp_tclAppHmi_SPIVDLanguageIndexSystem::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem", (tS32)0x65a084db);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SPIVDLanguageIndexSystem::s32SetData(tU8 &tVDLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_SPIVDLanguageIndexSystem::s32SetData(const tU8 &tVDLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SPIVDLanguageIndexSystem::u8GetData(tU8& tVDLanguageIndexSystemParam) {  
   vUpdate();
   tVDLanguageIndexSystemParam = tVDLanguageIndexSystem;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(tU8 &tVDLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(const tU8 &tVDLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_SPIVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_SPIVDLanguageIndexSystem::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SPIVDLanguageIndexSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SPI, "VDLanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIVDLanguageIndexSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SPI, "VDLanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIVDLanguageIndexSystem::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDLanguageIndexSystem", DP_U32_POOL_ID_APPHMI_SPI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SPI);
   }
   else
   {
      fprintf(stdout,"Element VDLanguageIndexSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "dummy"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_SPIdummy::dp_tclAppHmi_SPIdummy(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tdummy,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_SPIdummy::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("dummy",(tS32) 0x13a84);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tdummy = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_SPIdummy::vStore(tVoid) {
   dp_tclBaseElement myDpElem("dummy", (tS32)0x13a84);
   (tVoid)myDpElem.bFillData((tVoid*)&tdummy, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_SPIdummy::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_SPIdummy::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_SPIdummy::tGetData() {
   vUpdate();
   return tdummy;
};
tS32 dp_tclAppHmi_SPIdummy::s32GetData(tU32& tdummyParam) { 
   vUpdate();
   tdummyParam = tdummy;
   return _s32Status;
}
tS32 dp_tclAppHmi_SPIdummy::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("dummy", (tS32)0x13a84);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_SPI, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_SPIdummy::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_SPIdummy::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_SPIdummy::s32SetData(tU32 &tdummyParam) {
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_SPIdummy::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_SPIdummy::s32SetData(const tU32 &tdummyParam) {
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_SPIdummy::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_SPIdummy::u8GetData(tU32& tdummyParam) {  
   vUpdate();
   tdummyParam = tdummy;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_SPIdummy::vSetData(tU32 &tdummyParam) { 
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_SPIdummy::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_SPIdummy::vSetData(const tU32 &tdummyParam) { 
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_SPIdummy::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_SPIdummy::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_SPIdummy::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_SPI, "dummy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIdummy::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_SPI, "dummy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_SPIdummy::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: dummy", DP_U32_POOL_ID_APPHMI_SPI);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_SPI);
   }
   else
   {
      fprintf(stdout,"Element dummy has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
