#ifndef _DP_FI_APPHMI_PHONE_H
#define _DP_FI_APPHMI_PHONE_H

extern tVoid vInitAppHmi_Phone(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclAppHmi_PhoneMessageSettingsDP{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMessageSettingsDP;
   
public:
   dp_tclAppHmi_PhoneMessageSettingsDP(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_PhoneMessageSettingsDP() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMessageSettingsDPParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMessageSettingsDPParam);
   tS32  s32SetData(const tBool &tMessageSettingsDPParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMessageSettingsDPParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMessageSettingsDPParam);
   tVoid vSetData(const tBool& tMessageSettingsDPParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_PhonePhoneRingtoneStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tPhoneRingtoneStatus;
   
public:
   dp_tclAppHmi_PhonePhoneRingtoneStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_PhonePhoneRingtoneStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tPhoneRingtoneStatusParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tPhoneRingtoneStatusParam);
   tS32  s32SetData(const tU8 &tPhoneRingtoneStatusParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tPhoneRingtoneStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tPhoneRingtoneStatusParam);
   tVoid vSetData(const tU8& tPhoneRingtoneStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_PhoneSortOrderValue{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSortOrderValue;
   
public:
   dp_tclAppHmi_PhoneSortOrderValue(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_PhoneSortOrderValue() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSortOrderValueParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSortOrderValueParam);
   tS32  s32SetData(const tU8 &tSortOrderValueParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSortOrderValueParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSortOrderValueParam);
   tVoid vSetData(const tU8& tSortOrderValueParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
