
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Phone.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MessageSettingsDP"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_PhoneMessageSettingsDP::dp_tclAppHmi_PhoneMessageSettingsDP(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMessageSettingsDP,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_PhoneMessageSettingsDP::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MessageSettingsDP",(tS32) 0x4fbd5092);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMessageSettingsDP = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_PhoneMessageSettingsDP::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MessageSettingsDP", (tS32)0x4fbd5092);
   (tVoid)myDpElem.bFillData((tVoid*)&tMessageSettingsDP, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_PhoneMessageSettingsDP::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_PhoneMessageSettingsDP::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_PhoneMessageSettingsDP::tGetData() {
   vUpdate();
   return tMessageSettingsDP;
};
tS32 dp_tclAppHmi_PhoneMessageSettingsDP::s32GetData(tBool& tMessageSettingsDPParam) { 
   vUpdate();
   tMessageSettingsDPParam = tMessageSettingsDP;
   return _s32Status;
}
tS32 dp_tclAppHmi_PhoneMessageSettingsDP::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MessageSettingsDP", (tS32)0x4fbd5092);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_PhoneMessageSettingsDP::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_PhoneMessageSettingsDP::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_PhoneMessageSettingsDP::s32SetData(tBool &tMessageSettingsDPParam) {
   //init parameter
   (tVoid)memcpy(&tMessageSettingsDP,(tVoid*)&tMessageSettingsDPParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMessageSettingsDPParam' in function 'dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_PhoneMessageSettingsDP::s32SetData(const tBool &tMessageSettingsDPParam) {
   //init parameter
   (tVoid)memcpy(&tMessageSettingsDP,(tVoid*)&tMessageSettingsDPParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMessageSettingsDPParam' in function 'dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_PhoneMessageSettingsDP::u8GetData(tBool& tMessageSettingsDPParam) {  
   vUpdate();
   tMessageSettingsDPParam = tMessageSettingsDP;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(tBool &tMessageSettingsDPParam) { 
   //init parameter
   (tVoid)memcpy(&tMessageSettingsDP,(tVoid*)&tMessageSettingsDPParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMessageSettingsDPParam' in function 'dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(const tBool &tMessageSettingsDPParam) { 
   //init parameter
   (tVoid)memcpy(&tMessageSettingsDP,(tVoid*)&tMessageSettingsDPParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMessageSettingsDPParam' in function 'dp_tclAppHmi_PhoneMessageSettingsDP::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_PhoneMessageSettingsDP::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_PhoneMessageSettingsDP::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_PHONE, "MessageSettingsDP", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhoneMessageSettingsDP::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_PHONE, "MessageSettingsDP", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhoneMessageSettingsDP::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MessageSettingsDP", DP_U32_POOL_ID_APPHMI_PHONE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_PHONE);
   }
   else
   {
      fprintf(stdout,"Element MessageSettingsDP has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "PhoneRingtoneStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_PhonePhoneRingtoneStatus::dp_tclAppHmi_PhonePhoneRingtoneStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tPhoneRingtoneStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("PhoneRingtoneStatus",(tS32) 0xd9126c28);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tPhoneRingtoneStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("PhoneRingtoneStatus", (tS32)0xd9126c28);
   (tVoid)myDpElem.bFillData((tVoid*)&tPhoneRingtoneStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_PhonePhoneRingtoneStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_PhonePhoneRingtoneStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_PhonePhoneRingtoneStatus::tGetData() {
   vUpdate();
   return tPhoneRingtoneStatus;
};
tS32 dp_tclAppHmi_PhonePhoneRingtoneStatus::s32GetData(tU8& tPhoneRingtoneStatusParam) { 
   vUpdate();
   tPhoneRingtoneStatusParam = tPhoneRingtoneStatus;
   return _s32Status;
}
tS32 dp_tclAppHmi_PhonePhoneRingtoneStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("PhoneRingtoneStatus", (tS32)0xd9126c28);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_PhonePhoneRingtoneStatus::s32SetData(tU8 &tPhoneRingtoneStatusParam) {
   //init parameter
   (tVoid)memcpy(&tPhoneRingtoneStatus,(tVoid*)&tPhoneRingtoneStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPhoneRingtoneStatusParam' in function 'dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_PhonePhoneRingtoneStatus::s32SetData(const tU8 &tPhoneRingtoneStatusParam) {
   //init parameter
   (tVoid)memcpy(&tPhoneRingtoneStatus,(tVoid*)&tPhoneRingtoneStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tPhoneRingtoneStatusParam' in function 'dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_PhonePhoneRingtoneStatus::u8GetData(tU8& tPhoneRingtoneStatusParam) {  
   vUpdate();
   tPhoneRingtoneStatusParam = tPhoneRingtoneStatus;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(tU8 &tPhoneRingtoneStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tPhoneRingtoneStatus,(tVoid*)&tPhoneRingtoneStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPhoneRingtoneStatusParam' in function 'dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(const tU8 &tPhoneRingtoneStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tPhoneRingtoneStatus,(tVoid*)&tPhoneRingtoneStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tPhoneRingtoneStatusParam' in function 'dp_tclAppHmi_PhonePhoneRingtoneStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_PhonePhoneRingtoneStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_PhonePhoneRingtoneStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_PHONE, "PhoneRingtoneStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhonePhoneRingtoneStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_PHONE, "PhoneRingtoneStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhonePhoneRingtoneStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: PhoneRingtoneStatus", DP_U32_POOL_ID_APPHMI_PHONE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_PHONE);
   }
   else
   {
      fprintf(stdout,"Element PhoneRingtoneStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SortOrderValue"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_PhoneSortOrderValue::dp_tclAppHmi_PhoneSortOrderValue(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSortOrderValue,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_PhoneSortOrderValue::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SortOrderValue",(tS32) 0x820c5251);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSortOrderValue = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_PhoneSortOrderValue::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SortOrderValue", (tS32)0x820c5251);
   (tVoid)myDpElem.bFillData((tVoid*)&tSortOrderValue, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_PhoneSortOrderValue::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_PhoneSortOrderValue::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_PhoneSortOrderValue::tGetData() {
   vUpdate();
   return tSortOrderValue;
};
tS32 dp_tclAppHmi_PhoneSortOrderValue::s32GetData(tU8& tSortOrderValueParam) { 
   vUpdate();
   tSortOrderValueParam = tSortOrderValue;
   return _s32Status;
}
tS32 dp_tclAppHmi_PhoneSortOrderValue::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SortOrderValue", (tS32)0x820c5251);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_PHONE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_PhoneSortOrderValue::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_PhoneSortOrderValue::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_PhoneSortOrderValue::s32SetData(tU8 &tSortOrderValueParam) {
   //init parameter
   (tVoid)memcpy(&tSortOrderValue,(tVoid*)&tSortOrderValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSortOrderValueParam' in function 'dp_tclAppHmi_PhoneSortOrderValue::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_PhoneSortOrderValue::s32SetData(const tU8 &tSortOrderValueParam) {
   //init parameter
   (tVoid)memcpy(&tSortOrderValue,(tVoid*)&tSortOrderValueParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSortOrderValueParam' in function 'dp_tclAppHmi_PhoneSortOrderValue::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_PhoneSortOrderValue::u8GetData(tU8& tSortOrderValueParam) {  
   vUpdate();
   tSortOrderValueParam = tSortOrderValue;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_PhoneSortOrderValue::vSetData(tU8 &tSortOrderValueParam) { 
   //init parameter
   (tVoid)memcpy(&tSortOrderValue,(tVoid*)&tSortOrderValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSortOrderValueParam' in function 'dp_tclAppHmi_PhoneSortOrderValue::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_PhoneSortOrderValue::vSetData(const tU8 &tSortOrderValueParam) { 
   //init parameter
   (tVoid)memcpy(&tSortOrderValue,(tVoid*)&tSortOrderValueParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSortOrderValueParam' in function 'dp_tclAppHmi_PhoneSortOrderValue::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_PhoneSortOrderValue::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_PhoneSortOrderValue::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_PHONE, "SortOrderValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhoneSortOrderValue::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_PHONE, "SortOrderValue", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_PhoneSortOrderValue::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SortOrderValue", DP_U32_POOL_ID_APPHMI_PHONE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_PHONE);
   }
   else
   {
      fprintf(stdout,"Element SortOrderValue has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
