#ifndef _DP_FI_APPHMI_SXM_H
#define _DP_FI_APPHMI_SXM_H

extern tVoid vInitAppHmi_Sxm(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define DP_S_IMPORT_INTERFACE_FI 
#include "../../ai_inf4cv_hmi/products/INF4CV/Apps/AppHmi_Sxm/App/datapool/apphmi_sxm_datapool_if.h"
//lint +e750




class dp_tclAppHmi_SxmSXMAudioAlert{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   HmiAppSxm::AlertSetting tSXMAudioAlert;
   
public:
   dp_tclAppHmi_SxmSXMAudioAlert(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSXMAudioAlert() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   HmiAppSxm::AlertSetting tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(HmiAppSxm::AlertSetting& tSXMAudioAlertParam);
   tVoid operator>>(HmiAppSxm::AlertSetting& oParam);
   
   //write access for pool element 
   tS32  s32SetData(HmiAppSxm::AlertSetting &tSXMAudioAlertParam);
   tS32  s32SetData(const HmiAppSxm::AlertSetting &tSXMAudioAlertParam);
   tVoid operator<<(HmiAppSxm::AlertSetting oParam);
   
   // do not use --> old interface
   tU8   u8GetData(HmiAppSxm::AlertSetting& tSXMAudioAlertParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(HmiAppSxm::AlertSetting& tSXMAudioAlertParam);
   tVoid vSetData(const HmiAppSxm::AlertSetting& tSXMAudioAlertParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmLanguageCodeSXM{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageCodeSXM;
   
public:
   dp_tclAppHmi_SxmLanguageCodeSXM(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmLanguageCodeSXM() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageCodeSXMParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageCodeSXMParam);
   tS32  s32SetData(const tU8 &tLanguageCodeSXMParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageCodeSXMParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageCodeSXMParam);
   tVoid vSetData(const tU8& tLanguageCodeSXMParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSxmAudioTuneStartStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSxmAudioTuneStartStatus;
   
public:
   dp_tclAppHmi_SxmSxmAudioTuneStartStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSxmAudioTuneStartStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSxmAudioTuneStartStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSxmAudioTuneStartStatusParam);
   tS32  s32SetData(const tBool &tSxmAudioTuneStartStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSxmAudioTuneStartStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSxmAudioTuneStartStatusParam);
   tVoid vSetData(const tBool& tSxmAudioTuneStartStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSxmAudioActivePresetBand{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSxmAudioActivePresetBand;
   
public:
   dp_tclAppHmi_SxmSxmAudioActivePresetBand(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSxmAudioActivePresetBand() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSxmAudioActivePresetBandParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSxmAudioActivePresetBandParam);
   tS32  s32SetData(const tU8 &tSxmAudioActivePresetBandParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSxmAudioActivePresetBandParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSxmAudioActivePresetBandParam);
   tVoid vSetData(const tU8& tSxmAudioActivePresetBandParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSxmSportsFlashNotification{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSxmSportsFlashNotification;
   
public:
   dp_tclAppHmi_SxmSxmSportsFlashNotification(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSxmSportsFlashNotification() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSxmSportsFlashNotificationParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSxmSportsFlashNotificationParam);
   tS32  s32SetData(const tBool &tSxmSportsFlashNotificationParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSxmSportsFlashNotificationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSxmSportsFlashNotificationParam);
   tVoid vSetData(const tBool& tSxmSportsFlashNotificationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSXMSportsFlashTeams{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   HmiAppSxm::SXMSportsFlashFavTeams tSXMSportsFlashTeams;
   
public:
   dp_tclAppHmi_SxmSXMSportsFlashTeams(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSXMSportsFlashTeams() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   HmiAppSxm::SXMSportsFlashFavTeams tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam);
   tVoid operator>>(HmiAppSxm::SXMSportsFlashFavTeams& oParam);
   
   //write access for pool element 
   tS32  s32SetData(HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam);
   tS32  s32SetData(const HmiAppSxm::SXMSportsFlashFavTeams &tSXMSportsFlashTeamsParam);
   tVoid operator<<(HmiAppSxm::SXMSportsFlashFavTeams oParam);
   
   // do not use --> old interface
   tU8   u8GetData(HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam);
   tVoid vSetData(const HmiAppSxm::SXMSportsFlashFavTeams& tSXMSportsFlashTeamsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSxmAudioArtistFavoriteStatus;
   
public:
   dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSxmAudioArtistFavoriteStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSxmAudioArtistFavoriteStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSxmAudioArtistFavoriteStatusParam);
   tS32  s32SetData(const tBool &tSxmAudioArtistFavoriteStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSxmAudioArtistFavoriteStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSxmAudioArtistFavoriteStatusParam);
   tVoid vSetData(const tBool& tSxmAudioArtistFavoriteStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tSxmAudioSongFavoriteStatus;
   
public:
   dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_SxmSxmAudioSongFavoriteStatus() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tSxmAudioSongFavoriteStatusParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tSxmAudioSongFavoriteStatusParam);
   tS32  s32SetData(const tBool &tSxmAudioSongFavoriteStatusParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tSxmAudioSongFavoriteStatusParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tSxmAudioSongFavoriteStatusParam);
   tVoid vSetData(const tBool& tSxmAudioSongFavoriteStatusParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
