
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Media.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DPMediaTAOptionsStatus"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MediaDPMediaTAOptionsStatus::dp_tclAppHmi_MediaDPMediaTAOptionsStatus(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDPMediaTAOptionsStatus,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DPMediaTAOptionsStatus",(tS32) 0x3243cadd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDPMediaTAOptionsStatus = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DPMediaTAOptionsStatus", (tS32)0x3243cadd);
   (tVoid)myDpElem.bFillData((tVoid*)&tDPMediaTAOptionsStatus, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MediaDPMediaTAOptionsStatus::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MediaDPMediaTAOptionsStatus::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::tGetData() {
   vUpdate();
   return tDPMediaTAOptionsStatus;
};
tS32 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::s32GetData(tU8& tDPMediaTAOptionsStatusParam) { 
   vUpdate();
   tDPMediaTAOptionsStatusParam = tDPMediaTAOptionsStatus;
   return _s32Status;
}
tS32 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DPMediaTAOptionsStatus", (tS32)0x3243cadd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::s32SetData(tU8 &tDPMediaTAOptionsStatusParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaTAOptionsStatus,(tVoid*)&tDPMediaTAOptionsStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaTAOptionsStatusParam' in function 'dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::s32SetData(const tU8 &tDPMediaTAOptionsStatusParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaTAOptionsStatus,(tVoid*)&tDPMediaTAOptionsStatusParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaTAOptionsStatusParam' in function 'dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MediaDPMediaTAOptionsStatus::u8GetData(tU8& tDPMediaTAOptionsStatusParam) {  
   vUpdate();
   tDPMediaTAOptionsStatusParam = tDPMediaTAOptionsStatus;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(tU8 &tDPMediaTAOptionsStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaTAOptionsStatus,(tVoid*)&tDPMediaTAOptionsStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPMediaTAOptionsStatusParam' in function 'dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(const tU8 &tDPMediaTAOptionsStatusParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaTAOptionsStatus,(tVoid*)&tDPMediaTAOptionsStatusParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDPMediaTAOptionsStatusParam' in function 'dp_tclAppHmi_MediaDPMediaTAOptionsStatus::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_MediaDPMediaTAOptionsStatus::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MediaDPMediaTAOptionsStatus::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaTAOptionsStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaTAOptionsStatus::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaTAOptionsStatus", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaTAOptionsStatus::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DPMediaTAOptionsStatus", DP_U32_POOL_ID_APPHMI_MEDIA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MEDIA);
   }
   else
   {
      fprintf(stdout,"Element DPMediaTAOptionsStatus has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DPMediaLastActiveRouterUSBSource"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDPMediaLastActiveRouterUSBSource,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DPMediaLastActiveRouterUSBSource",(tS32) 0xbee1e16cL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDPMediaLastActiveRouterUSBSource = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DPMediaLastActiveRouterUSBSource", (tS32)0xbee1e16cL);
   (tVoid)myDpElem.bFillData((tVoid*)&tDPMediaLastActiveRouterUSBSource, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::tGetData() {
   vUpdate();
   return tDPMediaLastActiveRouterUSBSource;
};
tS32 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::s32GetData(tU16& tDPMediaLastActiveRouterUSBSourceParam) { 
   vUpdate();
   tDPMediaLastActiveRouterUSBSourceParam = tDPMediaLastActiveRouterUSBSource;
   return _s32Status;
}
tS32 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DPMediaLastActiveRouterUSBSource", (tS32)0xbee1e16cL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::s32SetData(tU16 &tDPMediaLastActiveRouterUSBSourceParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveRouterUSBSource,(tVoid*)&tDPMediaLastActiveRouterUSBSourceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaLastActiveRouterUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(tU16)' could be made const reference
tS32 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::s32SetData(const tU16 &tDPMediaLastActiveRouterUSBSourceParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveRouterUSBSource,(tVoid*)&tDPMediaLastActiveRouterUSBSourceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaLastActiveRouterUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::u8GetData(tU16& tDPMediaLastActiveRouterUSBSourceParam) {  
   vUpdate();
   tDPMediaLastActiveRouterUSBSourceParam = tDPMediaLastActiveRouterUSBSource;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(tU16 &tDPMediaLastActiveRouterUSBSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveRouterUSBSource,(tVoid*)&tDPMediaLastActiveRouterUSBSourceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDPMediaLastActiveRouterUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(tU16)' could be made const reference
tVoid dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(const tU16 &tDPMediaLastActiveRouterUSBSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveRouterUSBSource,(tVoid*)&tDPMediaLastActiveRouterUSBSourceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDPMediaLastActiveRouterUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::vSetData(tU16)' could be made const reference
tU8   dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaLastActiveRouterUSBSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaLastActiveRouterUSBSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaLastActiveRouterUSBSource::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DPMediaLastActiveRouterUSBSource", DP_U32_POOL_ID_APPHMI_MEDIA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MEDIA);
   }
   else
   {
      fprintf(stdout,"Element DPMediaLastActiveRouterUSBSource has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DPMediaLastActiveCamportUSBSource"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDPMediaLastActiveCamportUSBSource,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DPMediaLastActiveCamportUSBSource",(tS32) 0xe0eeec09L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tDPMediaLastActiveCamportUSBSource = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DPMediaLastActiveCamportUSBSource", (tS32)0xe0eeec09L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDPMediaLastActiveCamportUSBSource, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::tGetData() {
   vUpdate();
   return tDPMediaLastActiveCamportUSBSource;
};
tS32 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::s32GetData(tU16& tDPMediaLastActiveCamportUSBSourceParam) { 
   vUpdate();
   tDPMediaLastActiveCamportUSBSourceParam = tDPMediaLastActiveCamportUSBSource;
   return _s32Status;
}
tS32 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DPMediaLastActiveCamportUSBSource", (tS32)0xe0eeec09L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MEDIA, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::s32SetData(tU16 &tDPMediaLastActiveCamportUSBSourceParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveCamportUSBSource,(tVoid*)&tDPMediaLastActiveCamportUSBSourceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaLastActiveCamportUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(tU16)' could be made const reference
tS32 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::s32SetData(const tU16 &tDPMediaLastActiveCamportUSBSourceParam) {
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveCamportUSBSource,(tVoid*)&tDPMediaLastActiveCamportUSBSourceParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDPMediaLastActiveCamportUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::u8GetData(tU16& tDPMediaLastActiveCamportUSBSourceParam) {  
   vUpdate();
   tDPMediaLastActiveCamportUSBSourceParam = tDPMediaLastActiveCamportUSBSource;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(tU16 &tDPMediaLastActiveCamportUSBSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveCamportUSBSource,(tVoid*)&tDPMediaLastActiveCamportUSBSourceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDPMediaLastActiveCamportUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(tU16)' could be made const reference
tVoid dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(const tU16 &tDPMediaLastActiveCamportUSBSourceParam) { 
   //init parameter
   (tVoid)memcpy(&tDPMediaLastActiveCamportUSBSource,(tVoid*)&tDPMediaLastActiveCamportUSBSourceParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tDPMediaLastActiveCamportUSBSourceParam' in function 'dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::vSetData(tU16)' could be made const reference
tU8   dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaLastActiveCamportUSBSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MEDIA, "DPMediaLastActiveCamportUSBSource", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MediaDPMediaLastActiveCamportUSBSource::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DPMediaLastActiveCamportUSBSource", DP_U32_POOL_ID_APPHMI_MEDIA);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MEDIA);
   }
   else
   {
      fprintf(stdout,"Element DPMediaLastActiveCamportUSBSource has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
