#ifndef _DP_FI_APPHMI_NAVIGATION_H
#define _DP_FI_APPHMI_NAVIGATION_H

extern tVoid vInitAppHmi_Navigation(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclAppHmi_NavigationVDLanguageIndexSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDLanguageIndexSystem;
   
public:
   dp_tclAppHmi_NavigationVDLanguageIndexSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationVDLanguageIndexSystem() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDLanguageIndexSystemParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDLanguageIndexSystemParam);
   tS32  s32SetData(const tU8 &tVDLanguageIndexSystemParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDLanguageIndexSystemParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDLanguageIndexSystemParam);
   tVoid vSetData(const tU8& tVDLanguageIndexSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageIndexSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageIndexSystem;
   
public:
   dp_tclAppHmi_NavigationLanguageIndexSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageIndexSystem() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageIndexSystemParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageIndexSystemParam);
   tS32  s32SetData(const tU8 &tLanguageIndexSystemParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageIndexSystemParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageIndexSystemParam);
   tVoid vSetData(const tU8& tLanguageIndexSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageISOCodeSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclAppHmi_NavigationLanguageISOCodeSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageISOCodeSystem() {};

   //read access for pool element 
   tS32  s32GetData(tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tLanguageISOCodeSystemParam);
   tS32 s32SetData(const tString &tLanguageISOCodeSystemParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tLanguageISOCodeSystemParam);
   tVoid vSetData(const tString &tLanguageISOCodeSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationVDLanguageIndexSds{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDLanguageIndexSds;
   
public:
   dp_tclAppHmi_NavigationVDLanguageIndexSds(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationVDLanguageIndexSds() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDLanguageIndexSdsParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDLanguageIndexSdsParam);
   tS32  s32SetData(const tU8 &tVDLanguageIndexSdsParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDLanguageIndexSdsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDLanguageIndexSdsParam);
   tVoid vSetData(const tU8& tVDLanguageIndexSdsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageNaviRelevantFromSds;
   
public:
   dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageNaviRelevantFromSdsParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageNaviRelevantFromSdsParam);
   tS32  s32SetData(const tU8 &tLanguageNaviRelevantFromSdsParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageNaviRelevantFromSdsParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageNaviRelevantFromSdsParam);
   tVoid vSetData(const tU8& tLanguageNaviRelevantFromSdsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds() {};

   //read access for pool element 
   tS32  s32GetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam);
   tS32 s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam);
   tVoid vSetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationVDLanguageIndexCluster{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDLanguageIndexCluster;
   
public:
   dp_tclAppHmi_NavigationVDLanguageIndexCluster(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationVDLanguageIndexCluster() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDLanguageIndexClusterParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDLanguageIndexClusterParam);
   tS32  s32SetData(const tU8 &tVDLanguageIndexClusterParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDLanguageIndexClusterParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDLanguageIndexClusterParam);
   tVoid vSetData(const tU8& tVDLanguageIndexClusterParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageNaviRelevantFromCluster;
   
public:
   dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageNaviRelevantFromClusterParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageNaviRelevantFromClusterParam);
   tS32  s32SetData(const tU8 &tLanguageNaviRelevantFromClusterParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageNaviRelevantFromClusterParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageNaviRelevantFromClusterParam);
   tVoid vSetData(const tU8& tLanguageNaviRelevantFromClusterParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster() {};

   //read access for pool element 
   tS32  s32GetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam);
   tS32 s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam);
   tVoid vSetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationVDLanguageIndexTrafficText{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVDLanguageIndexTrafficText;
   
public:
   dp_tclAppHmi_NavigationVDLanguageIndexTrafficText(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationVDLanguageIndexTrafficText() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVDLanguageIndexTrafficTextParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVDLanguageIndexTrafficTextParam);
   tS32  s32SetData(const tU8 &tVDLanguageIndexTrafficTextParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVDLanguageIndexTrafficTextParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVDLanguageIndexTrafficTextParam);
   tVoid vSetData(const tU8& tVDLanguageIndexTrafficTextParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLanguageNaviRelevantFromTrafficText;
   
public:
   dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLanguageNaviRelevantFromTrafficTextParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLanguageNaviRelevantFromTrafficTextParam);
   tS32  s32SetData(const tU8 &tLanguageNaviRelevantFromTrafficTextParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLanguageNaviRelevantFromTrafficTextParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLanguageNaviRelevantFromTrafficTextParam);
   tVoid vSetData(const tU8& tLanguageNaviRelevantFromTrafficTextParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tS32  _s32Status;
   tU8   _u8DataStatus;
   tU32  _u32MaxStrLen;
   
   
public:
   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText() {};

   //read access for pool element 
   tS32  s32GetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen);
   tS32  s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen);
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;
 
   //write access for pool element 
   tS32 s32SetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   tS32 s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   
   //old interface -> change to s32GetData()
   tU32  u32GetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen);
   tU32  u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen);
   tVoid vSetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   tVoid vSetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationIsGuidanceActive{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tIsGuidanceActive;
   
public:
   dp_tclAppHmi_NavigationIsGuidanceActive(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationIsGuidanceActive() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tIsGuidanceActiveParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tIsGuidanceActiveParam);
   tS32  s32SetData(const tBool &tIsGuidanceActiveParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tIsGuidanceActiveParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tIsGuidanceActiveParam);
   tVoid vSetData(const tBool& tIsGuidanceActiveParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationDateFormat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDateFormat;
   
public:
   dp_tclAppHmi_NavigationDateFormat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationDateFormat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDateFormatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDateFormatParam);
   tS32  s32SetData(const tU8 &tDateFormatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDateFormatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDateFormatParam);
   tVoid vSetData(const tU8& tDateFormatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationTimeFormat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tTimeFormat;
   
public:
   dp_tclAppHmi_NavigationTimeFormat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationTimeFormat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tTimeFormatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tTimeFormatParam);
   tS32  s32SetData(const tU8 &tTimeFormatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tTimeFormatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tTimeFormatParam);
   tVoid vSetData(const tU8& tTimeFormatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLocalTimeOffset{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLocalTimeOffset;
   
public:
   dp_tclAppHmi_NavigationLocalTimeOffset(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLocalTimeOffset() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLocalTimeOffsetParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLocalTimeOffsetParam);
   tS32  s32SetData(const tU32 &tLocalTimeOffsetParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLocalTimeOffsetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLocalTimeOffsetParam);
   tVoid vSetData(const tU32& tLocalTimeOffsetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationClockAutoModeActivated{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tClockAutoModeActivated;
   
public:
   dp_tclAppHmi_NavigationClockAutoModeActivated(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationClockAutoModeActivated() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tClockAutoModeActivatedParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tClockAutoModeActivatedParam);
   tS32  s32SetData(const tBool &tClockAutoModeActivatedParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tClockAutoModeActivatedParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tClockAutoModeActivatedParam);
   tVoid vSetData(const tBool& tClockAutoModeActivatedParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationEstimatedTimeMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEstimatedTimeMode;
   
public:
   dp_tclAppHmi_NavigationEstimatedTimeMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationEstimatedTimeMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEstimatedTimeModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEstimatedTimeModeParam);
   tS32  s32SetData(const tU8 &tEstimatedTimeModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEstimatedTimeModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEstimatedTimeModeParam);
   tVoid vSetData(const tU8& tEstimatedTimeModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationEstimatedTimeType{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tEstimatedTimeType;
   
public:
   dp_tclAppHmi_NavigationEstimatedTimeType(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationEstimatedTimeType() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tEstimatedTimeTypeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tEstimatedTimeTypeParam);
   tS32  s32SetData(const tU8 &tEstimatedTimeTypeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tEstimatedTimeTypeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tEstimatedTimeTypeParam);
   tVoid vSetData(const tU8& tEstimatedTimeTypeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationDistanceUnitSystem{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tDistanceUnitSystem;
   
public:
   dp_tclAppHmi_NavigationDistanceUnitSystem(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationDistanceUnitSystem() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tDistanceUnitSystemParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tDistanceUnitSystemParam);
   tS32  s32SetData(const tU8 &tDistanceUnitSystemParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tDistanceUnitSystemParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tDistanceUnitSystemParam);
   tVoid vSetData(const tU8& tDistanceUnitSystemParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLatitudeCoordinatesDirection{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLatitudeCoordinatesDirection;
   
public:
   dp_tclAppHmi_NavigationLatitudeCoordinatesDirection(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLatitudeCoordinatesDirection() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLatitudeCoordinatesDirectionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLatitudeCoordinatesDirectionParam);
   tS32  s32SetData(const tU8 &tLatitudeCoordinatesDirectionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLatitudeCoordinatesDirectionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLatitudeCoordinatesDirectionParam);
   tVoid vSetData(const tU8& tLatitudeCoordinatesDirectionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLongitudeCoordinatesDirection{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLongitudeCoordinatesDirection;
   
public:
   dp_tclAppHmi_NavigationLongitudeCoordinatesDirection(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLongitudeCoordinatesDirection() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLongitudeCoordinatesDirectionParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLongitudeCoordinatesDirectionParam);
   tS32  s32SetData(const tU8 &tLongitudeCoordinatesDirectionParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLongitudeCoordinatesDirectionParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLongitudeCoordinatesDirectionParam);
   tVoid vSetData(const tU8& tLongitudeCoordinatesDirectionParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationCoordinateDisplayFormat{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tCoordinateDisplayFormat;
   
public:
   dp_tclAppHmi_NavigationCoordinateDisplayFormat(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationCoordinateDisplayFormat() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tCoordinateDisplayFormatParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tCoordinateDisplayFormatParam);
   tS32  s32SetData(const tU8 &tCoordinateDisplayFormatParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tCoordinateDisplayFormatParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tCoordinateDisplayFormatParam);
   tVoid vSetData(const tU8& tCoordinateDisplayFormatParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationLightMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tLightMode;
   
public:
   dp_tclAppHmi_NavigationLightMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationLightMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tLightModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tLightModeParam);
   tS32  s32SetData(const tU8 &tLightModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tLightModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tLightModeParam);
   tVoid vSetData(const tU8& tLightModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationMyPOIsAvailability{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tMyPOIsAvailability;
   
public:
   dp_tclAppHmi_NavigationMyPOIsAvailability(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationMyPOIsAvailability() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tMyPOIsAvailabilityParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tMyPOIsAvailabilityParam);
   tS32  s32SetData(const tBool &tMyPOIsAvailabilityParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tMyPOIsAvailabilityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tMyPOIsAvailabilityParam);
   tVoid vSetData(const tBool& tMyPOIsAvailabilityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationVehicleProfile{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tVehicleProfile;
   
public:
   dp_tclAppHmi_NavigationVehicleProfile(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationVehicleProfile() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tVehicleProfileParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tVehicleProfileParam);
   tS32  s32SetData(const tU8 &tVehicleProfileParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tVehicleProfileParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tVehicleProfileParam);
   tVoid vSetData(const tU8& tVehicleProfileParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tProfileAndGuidanceStateLastWrittenLineNo;
   
public:
   dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tProfileAndGuidanceStateLastWrittenLineNoParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam);
   tS32  s32SetData(const tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tProfileAndGuidanceStateLastWrittenLineNoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tProfileAndGuidanceStateLastWrittenLineNoParam);
   tVoid vSetData(const tU32& tProfileAndGuidanceStateLastWrittenLineNoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationShowETAOnSecMap{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tBool tShowETAOnSecMap;
   
public:
   dp_tclAppHmi_NavigationShowETAOnSecMap(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationShowETAOnSecMap() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tBool tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tBool& tShowETAOnSecMapParam);
   tVoid operator>>(tBool& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tBool &tShowETAOnSecMapParam);
   tS32  s32SetData(const tBool &tShowETAOnSecMapParam);
   tVoid operator<<(tBool oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tBool& tShowETAOnSecMapParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tBool& tShowETAOnSecMapParam);
   tVoid vSetData(const tBool& tShowETAOnSecMapParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationCoachWeight{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tF32 tCoachWeight;
   
public:
   dp_tclAppHmi_NavigationCoachWeight(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationCoachWeight() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tF32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tF32& tCoachWeightParam);
   tVoid operator>>(tF32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tF32 &tCoachWeightParam);
   tS32  s32SetData(const tF32 &tCoachWeightParam);
   tVoid operator<<(tF32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tF32& tCoachWeightParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tF32& tCoachWeightParam);
   tVoid vSetData(const tF32& tCoachWeightParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_NavigationCoachLoadPerAxle{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tF32 tCoachLoadPerAxle;
   
public:
   dp_tclAppHmi_NavigationCoachLoadPerAxle(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_NavigationCoachLoadPerAxle() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tF32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tF32& tCoachLoadPerAxleParam);
   tVoid operator>>(tF32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tF32 &tCoachLoadPerAxleParam);
   tS32  s32SetData(const tF32 &tCoachLoadPerAxleParam);
   tVoid operator<<(tF32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tF32& tCoachLoadPerAxleParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tF32& tCoachLoadPerAxleParam);
   tVoid vSetData(const tF32& tCoachLoadPerAxleParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
