
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Navigation.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDLanguageIndexSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationVDLanguageIndexSystem::dp_tclAppHmi_NavigationVDLanguageIndexSystem(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDLanguageIndexSystem,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem",(tS32) 0x65a084db);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDLanguageIndexSystem = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem", (tS32)0x65a084db);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDLanguageIndexSystem, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationVDLanguageIndexSystem::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationVDLanguageIndexSystem::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationVDLanguageIndexSystem::tGetData() {
   vUpdate();
   return tVDLanguageIndexSystem;
};
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSystem::s32GetData(tU8& tVDLanguageIndexSystemParam) { 
   vUpdate();
   tVDLanguageIndexSystemParam = tVDLanguageIndexSystem;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSystem::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSystem", (tS32)0x65a084db);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSystem::s32SetData(tU8 &tVDLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSystem::s32SetData(const tU8 &tVDLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationVDLanguageIndexSystem::u8GetData(tU8& tVDLanguageIndexSystemParam) {  
   vUpdate();
   tVDLanguageIndexSystemParam = tVDLanguageIndexSystem;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(tU8 &tVDLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(const tU8 &tVDLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSystem,(tVoid*)&tVDLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSystem::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationVDLanguageIndexSystem::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationVDLanguageIndexSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexSystem::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDLanguageIndexSystem", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element VDLanguageIndexSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageIndexSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageIndexSystem::dp_tclAppHmi_NavigationLanguageIndexSystem(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageIndexSystem,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageIndexSystem",(tS32) 0x21c5fc31);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageIndexSystem = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageIndexSystem", (tS32)0x21c5fc31);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageIndexSystem, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLanguageIndexSystem::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLanguageIndexSystem::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLanguageIndexSystem::tGetData() {
   vUpdate();
   return tLanguageIndexSystem;
};
tS32 dp_tclAppHmi_NavigationLanguageIndexSystem::s32GetData(tU8& tLanguageIndexSystemParam) { 
   vUpdate();
   tLanguageIndexSystemParam = tLanguageIndexSystem;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLanguageIndexSystem::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageIndexSystem", (tS32)0x21c5fc31);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLanguageIndexSystem::s32SetData(tU8 &tLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageIndexSystem,(tVoid*)&tLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLanguageIndexSystem::s32SetData(const tU8 &tLanguageIndexSystemParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageIndexSystem,(tVoid*)&tLanguageIndexSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLanguageIndexSystem::u8GetData(tU8& tLanguageIndexSystemParam) {  
   vUpdate();
   tLanguageIndexSystemParam = tLanguageIndexSystem;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(tU8 &tLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageIndexSystem,(tVoid*)&tLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(const tU8 &tLanguageIndexSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageIndexSystem,(tVoid*)&tLanguageIndexSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageIndexSystemParam' in function 'dp_tclAppHmi_NavigationLanguageIndexSystem::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLanguageIndexSystem::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLanguageIndexSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageIndexSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIndexSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageIndexSystem::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageIndexSystem", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LanguageIndexSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageISOCodeSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageISOCodeSystem::dp_tclAppHmi_NavigationLanguageISOCodeSystem(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclAppHmi_NavigationLanguageISOCodeSystem::s32SetData(tString &tLanguageISOCodeSystemParam) {
   tU32 u32Len = (tU32)strlen(tLanguageISOCodeSystemParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageISOCodeSystem", (tS32)0xed6af383);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageISOCodeSystemParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageISOCodeSystem::s32SetData(const tString &tLanguageISOCodeSystemParam) {
   tU32 u32Len = (tU32)strlen(tLanguageISOCodeSystemParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageISOCodeSystem", (tS32)0xed6af383);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageISOCodeSystemParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageISOCodeSystem::s32GetData(tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageISOCodeSystem", (tS32)0xed6af383);
   (tVoid)memset(tLanguageISOCodeSystemParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageISOCodeSystemParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageISOCodeSystem::s32GetData(const tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageISOCodeSystem", (tS32)0xed6af383);
   (tVoid)memset(tLanguageISOCodeSystemParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageISOCodeSystemParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclAppHmi_NavigationLanguageISOCodeSystem::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAppHmi_NavigationLanguageISOCodeSystem::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclAppHmi_NavigationLanguageISOCodeSystem::u32GetData(tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageISOCodeSystemParam, u32StringBufLen);
   };
    tU32  dp_tclAppHmi_NavigationLanguageISOCodeSystem::u32GetData(const tString &tLanguageISOCodeSystemParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageISOCodeSystemParam, u32StringBufLen);
   };
   tVoid dp_tclAppHmi_NavigationLanguageISOCodeSystem::vSetData(tString &tLanguageISOCodeSystemParam){(tVoid)s32SetData(tLanguageISOCodeSystemParam);};
   tVoid dp_tclAppHmi_NavigationLanguageISOCodeSystem::vSetData(const tString &tLanguageISOCodeSystemParam){(tVoid)s32SetData(tLanguageISOCodeSystemParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclAppHmi_NavigationLanguageISOCodeSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageISOCodeSystem", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageISOCodeSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageISOCodeSystem", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageISOCodeSystem::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageISOCodeSystem", DP_U32_POOL_ID_APPHMI_NAVIGATION);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
		}
		else
		{
			fprintf(stdout,"Element LanguageISOCodeSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDLanguageIndexSds"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationVDLanguageIndexSds::dp_tclAppHmi_NavigationVDLanguageIndexSds(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDLanguageIndexSds,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDLanguageIndexSds",(tS32) 0x1963960c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDLanguageIndexSds = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSds", (tS32)0x1963960c);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDLanguageIndexSds, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationVDLanguageIndexSds::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationVDLanguageIndexSds::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationVDLanguageIndexSds::tGetData() {
   vUpdate();
   return tVDLanguageIndexSds;
};
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSds::s32GetData(tU8& tVDLanguageIndexSdsParam) { 
   vUpdate();
   tVDLanguageIndexSdsParam = tVDLanguageIndexSds;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSds::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDLanguageIndexSds", (tS32)0x1963960c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSds::s32SetData(tU8 &tVDLanguageIndexSdsParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSds,(tVoid*)&tVDLanguageIndexSdsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSdsParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationVDLanguageIndexSds::s32SetData(const tU8 &tVDLanguageIndexSdsParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSds,(tVoid*)&tVDLanguageIndexSdsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexSdsParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationVDLanguageIndexSds::u8GetData(tU8& tVDLanguageIndexSdsParam) {  
   vUpdate();
   tVDLanguageIndexSdsParam = tVDLanguageIndexSds;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(tU8 &tVDLanguageIndexSdsParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSds,(tVoid*)&tVDLanguageIndexSdsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSdsParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(const tU8 &tVDLanguageIndexSdsParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexSds,(tVoid*)&tVDLanguageIndexSdsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexSdsParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexSds::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationVDLanguageIndexSds::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationVDLanguageIndexSds::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexSds", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexSds::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexSds", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexSds::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDLanguageIndexSds", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element VDLanguageIndexSds has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageNaviRelevantFromSds"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageNaviRelevantFromSds,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromSds",(tS32) 0xd8eefe31L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageNaviRelevantFromSds = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromSds", (tS32)0xd8eefe31L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageNaviRelevantFromSds, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::tGetData() {
   vUpdate();
   return tLanguageNaviRelevantFromSds;
};
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::s32GetData(tU8& tLanguageNaviRelevantFromSdsParam) { 
   vUpdate();
   tLanguageNaviRelevantFromSdsParam = tLanguageNaviRelevantFromSds;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromSds", (tS32)0xd8eefe31L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::s32SetData(tU8 &tLanguageNaviRelevantFromSdsParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromSds,(tVoid*)&tLanguageNaviRelevantFromSdsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromSdsParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::s32SetData(const tU8 &tLanguageNaviRelevantFromSdsParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromSds,(tVoid*)&tLanguageNaviRelevantFromSdsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromSdsParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::u8GetData(tU8& tLanguageNaviRelevantFromSdsParam) {  
   vUpdate();
   tLanguageNaviRelevantFromSdsParam = tLanguageNaviRelevantFromSds;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(tU8 &tLanguageNaviRelevantFromSdsParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromSds,(tVoid*)&tLanguageNaviRelevantFromSdsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromSdsParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(const tU8 &tLanguageNaviRelevantFromSdsParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromSds,(tVoid*)&tLanguageNaviRelevantFromSdsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromSdsParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromSds", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromSds", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromSds::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageNaviRelevantFromSds", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LanguageNaviRelevantFromSds has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageIsoCodeNaviRelevantFromSds"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::s32SetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromSdsParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromSds", (tS32)0xa477ecfL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromSdsParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromSdsParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromSds", (tS32)0xa477ecfL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromSdsParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::s32GetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromSds", (tS32)0xa477ecfL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromSdsParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromSdsParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromSds", (tS32)0xa477ecfL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromSdsParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromSdsParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::u32GetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromSdsParam, u32StringBufLen);
   };
    tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromSdsParam, u32StringBufLen);
   };
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::vSetData(tString &tLanguageIsoCodeNaviRelevantFromSdsParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromSdsParam);};
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::vSetData(const tString &tLanguageIsoCodeNaviRelevantFromSdsParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromSdsParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromSds", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromSds", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromSds::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageIsoCodeNaviRelevantFromSds", DP_U32_POOL_ID_APPHMI_NAVIGATION);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
		}
		else
		{
			fprintf(stdout,"Element LanguageIsoCodeNaviRelevantFromSds has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDLanguageIndexCluster"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationVDLanguageIndexCluster::dp_tclAppHmi_NavigationVDLanguageIndexCluster(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDLanguageIndexCluster,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDLanguageIndexCluster",(tS32) 0xfc1e2f2c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDLanguageIndexCluster = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDLanguageIndexCluster", (tS32)0xfc1e2f2c);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDLanguageIndexCluster, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationVDLanguageIndexCluster::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationVDLanguageIndexCluster::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationVDLanguageIndexCluster::tGetData() {
   vUpdate();
   return tVDLanguageIndexCluster;
};
tS32 dp_tclAppHmi_NavigationVDLanguageIndexCluster::s32GetData(tU8& tVDLanguageIndexClusterParam) { 
   vUpdate();
   tVDLanguageIndexClusterParam = tVDLanguageIndexCluster;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationVDLanguageIndexCluster::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDLanguageIndexCluster", (tS32)0xfc1e2f2c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationVDLanguageIndexCluster::s32SetData(tU8 &tVDLanguageIndexClusterParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexCluster,(tVoid*)&tVDLanguageIndexClusterParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexClusterParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationVDLanguageIndexCluster::s32SetData(const tU8 &tVDLanguageIndexClusterParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexCluster,(tVoid*)&tVDLanguageIndexClusterParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexClusterParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationVDLanguageIndexCluster::u8GetData(tU8& tVDLanguageIndexClusterParam) {  
   vUpdate();
   tVDLanguageIndexClusterParam = tVDLanguageIndexCluster;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(tU8 &tVDLanguageIndexClusterParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexCluster,(tVoid*)&tVDLanguageIndexClusterParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexClusterParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(const tU8 &tVDLanguageIndexClusterParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexCluster,(tVoid*)&tVDLanguageIndexClusterParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexClusterParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexCluster::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationVDLanguageIndexCluster::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationVDLanguageIndexCluster::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexCluster", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexCluster::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexCluster", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexCluster::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDLanguageIndexCluster", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element VDLanguageIndexCluster has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageNaviRelevantFromCluster"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageNaviRelevantFromCluster,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromCluster",(tS32) 0x9f777181L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageNaviRelevantFromCluster = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromCluster", (tS32)0x9f777181L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageNaviRelevantFromCluster, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::tGetData() {
   vUpdate();
   return tLanguageNaviRelevantFromCluster;
};
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::s32GetData(tU8& tLanguageNaviRelevantFromClusterParam) { 
   vUpdate();
   tLanguageNaviRelevantFromClusterParam = tLanguageNaviRelevantFromCluster;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromCluster", (tS32)0x9f777181L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::s32SetData(tU8 &tLanguageNaviRelevantFromClusterParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromCluster,(tVoid*)&tLanguageNaviRelevantFromClusterParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromClusterParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::s32SetData(const tU8 &tLanguageNaviRelevantFromClusterParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromCluster,(tVoid*)&tLanguageNaviRelevantFromClusterParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromClusterParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::u8GetData(tU8& tLanguageNaviRelevantFromClusterParam) {  
   vUpdate();
   tLanguageNaviRelevantFromClusterParam = tLanguageNaviRelevantFromCluster;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(tU8 &tLanguageNaviRelevantFromClusterParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromCluster,(tVoid*)&tLanguageNaviRelevantFromClusterParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromClusterParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(const tU8 &tLanguageNaviRelevantFromClusterParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromCluster,(tVoid*)&tLanguageNaviRelevantFromClusterParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromClusterParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromCluster", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromCluster", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromCluster::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageNaviRelevantFromCluster", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LanguageNaviRelevantFromCluster has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageIsoCodeNaviRelevantFromCluster"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::s32SetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromClusterParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromCluster", (tS32)0x1889733fL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromClusterParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromClusterParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromCluster", (tS32)0x1889733fL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromClusterParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::s32GetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromCluster", (tS32)0x1889733fL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromClusterParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromClusterParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromCluster", (tS32)0x1889733fL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromClusterParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromClusterParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::u32GetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromClusterParam, u32StringBufLen);
   };
    tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromClusterParam, u32StringBufLen);
   };
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::vSetData(tString &tLanguageIsoCodeNaviRelevantFromClusterParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromClusterParam);};
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::vSetData(const tString &tLanguageIsoCodeNaviRelevantFromClusterParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromClusterParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromCluster", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromCluster", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromCluster::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageIsoCodeNaviRelevantFromCluster", DP_U32_POOL_ID_APPHMI_NAVIGATION);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
		}
		else
		{
			fprintf(stdout,"Element LanguageIsoCodeNaviRelevantFromCluster has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VDLanguageIndexTrafficText"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::dp_tclAppHmi_NavigationVDLanguageIndexTrafficText(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVDLanguageIndexTrafficText,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VDLanguageIndexTrafficText",(tS32) 0x8fbf63daL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVDLanguageIndexTrafficText = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VDLanguageIndexTrafficText", (tS32)0x8fbf63daL);
   (tVoid)myDpElem.bFillData((tVoid*)&tVDLanguageIndexTrafficText, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::tGetData() {
   vUpdate();
   return tVDLanguageIndexTrafficText;
};
tS32 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::s32GetData(tU8& tVDLanguageIndexTrafficTextParam) { 
   vUpdate();
   tVDLanguageIndexTrafficTextParam = tVDLanguageIndexTrafficText;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VDLanguageIndexTrafficText", (tS32)0x8fbf63daL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::s32SetData(tU8 &tVDLanguageIndexTrafficTextParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexTrafficText,(tVoid*)&tVDLanguageIndexTrafficTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexTrafficTextParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::s32SetData(const tU8 &tVDLanguageIndexTrafficTextParam) {
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexTrafficText,(tVoid*)&tVDLanguageIndexTrafficTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVDLanguageIndexTrafficTextParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::u8GetData(tU8& tVDLanguageIndexTrafficTextParam) {  
   vUpdate();
   tVDLanguageIndexTrafficTextParam = tVDLanguageIndexTrafficText;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(tU8 &tVDLanguageIndexTrafficTextParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexTrafficText,(tVoid*)&tVDLanguageIndexTrafficTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexTrafficTextParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(const tU8 &tVDLanguageIndexTrafficTextParam) { 
   //init parameter
   (tVoid)memcpy(&tVDLanguageIndexTrafficText,(tVoid*)&tVDLanguageIndexTrafficTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVDLanguageIndexTrafficTextParam' in function 'dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexTrafficText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VDLanguageIndexTrafficText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVDLanguageIndexTrafficText::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VDLanguageIndexTrafficText", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element VDLanguageIndexTrafficText has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageNaviRelevantFromTrafficText"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageNaviRelevantFromTrafficText,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromTrafficText",(tS32) 0x5caa555fL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLanguageNaviRelevantFromTrafficText = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromTrafficText", (tS32)0x5caa555fL);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageNaviRelevantFromTrafficText, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::tGetData() {
   vUpdate();
   return tLanguageNaviRelevantFromTrafficText;
};
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::s32GetData(tU8& tLanguageNaviRelevantFromTrafficTextParam) { 
   vUpdate();
   tLanguageNaviRelevantFromTrafficTextParam = tLanguageNaviRelevantFromTrafficText;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageNaviRelevantFromTrafficText", (tS32)0x5caa555fL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::s32SetData(tU8 &tLanguageNaviRelevantFromTrafficTextParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromTrafficText,(tVoid*)&tLanguageNaviRelevantFromTrafficTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromTrafficTextParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::s32SetData(const tU8 &tLanguageNaviRelevantFromTrafficTextParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromTrafficText,(tVoid*)&tLanguageNaviRelevantFromTrafficTextParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageNaviRelevantFromTrafficTextParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::u8GetData(tU8& tLanguageNaviRelevantFromTrafficTextParam) {  
   vUpdate();
   tLanguageNaviRelevantFromTrafficTextParam = tLanguageNaviRelevantFromTrafficText;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(tU8 &tLanguageNaviRelevantFromTrafficTextParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromTrafficText,(tVoid*)&tLanguageNaviRelevantFromTrafficTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromTrafficTextParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(const tU8 &tLanguageNaviRelevantFromTrafficTextParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageNaviRelevantFromTrafficText,(tVoid*)&tLanguageNaviRelevantFromTrafficTextParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLanguageNaviRelevantFromTrafficTextParam' in function 'dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromTrafficText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageNaviRelevantFromTrafficText", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLanguageNaviRelevantFromTrafficText::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageNaviRelevantFromTrafficText", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LanguageNaviRelevantFromTrafficText has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageIsoCodeNaviRelevantFromTrafficText"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText(tU16 DPid) 
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_NOT_READ;
	_u32MaxStrLen = 255;    

	      
};
   
tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::s32SetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromTrafficText", (tS32)0xf1a0963dL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromTrafficTextParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::s32SetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam) {
   tU32 u32Len = (tU32)strlen(tLanguageIsoCodeNaviRelevantFromTrafficTextParam);
   if (u32Len < _u32MaxStrLen) {
      dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromTrafficText", (tS32)0xf1a0963dL);
      (tVoid)myDpElem.bFillData((tVoid*)tLanguageIsoCodeNaviRelevantFromTrafficTextParam, u32Len+1);
      _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   } else {
      _s32Status = DP_S32_ERR_WR_BUF_LEN;
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::s32GetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromTrafficText", (tS32)0xf1a0963dL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromTrafficTextParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromTrafficTextParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

tS32 dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::s32GetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen) 
{
   dp_tclBaseElement myDpElem("LanguageIsoCodeNaviRelevantFromTrafficText", (tS32)0xf1a0963dL);
   (tVoid)memset(tLanguageIsoCodeNaviRelevantFromTrafficTextParam, 0, u32StringBufLen);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      _s32Status = (tS32)myDpElem.u32GetDataLength();
      if (_s32Status > (tS32)u32StringBufLen) 
      {
         _s32Status = (tS32)(u32StringBufLen-1);
      }
      (tVoid)memcpy((tVoid*)tLanguageIsoCodeNaviRelevantFromTrafficTextParam, myDpElem.pvGetData(), (tU32)_s32Status);
      _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
      if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
	      _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;	
   }
   return _s32Status;
}

   tS32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::s32GetStatus() const {return _s32Status;};
   tU8   dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::u8GetElementStatus() const {return _u8DataStatus;};
 
   //old interface -> change to s32GetData()
   tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::u32GetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromTrafficTextParam, u32StringBufLen);
   };
    tU32  dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::u32GetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam, tU32 u32StringBufLen){
       return (tU16) s32GetData(tLanguageIsoCodeNaviRelevantFromTrafficTextParam, u32StringBufLen);
   };
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::vSetData(tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromTrafficTextParam);};
   tVoid dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::vSetData(const tString &tLanguageIsoCodeNaviRelevantFromTrafficTextParam){(tVoid)s32SetData(tLanguageIsoCodeNaviRelevantFromTrafficTextParam);};
   
   //notification handling not over processes only for application
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromTrafficText", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LanguageIsoCodeNaviRelevantFromTrafficText", pFunc, u32Event, _u16AccessId);
   }
   tBool dp_tclAppHmi_NavigationLanguageIsoCodeNaviRelevantFromTrafficText::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageIsoCodeNaviRelevantFromTrafficText", DP_U32_POOL_ID_APPHMI_NAVIGATION);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
		}
		else
		{
			fprintf(stdout,"Element LanguageIsoCodeNaviRelevantFromTrafficText has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}   
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "IsGuidanceActive"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationIsGuidanceActive::dp_tclAppHmi_NavigationIsGuidanceActive(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tIsGuidanceActive,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationIsGuidanceActive::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("IsGuidanceActive",(tS32) 0x6db5bfc8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tIsGuidanceActive = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationIsGuidanceActive::vStore(tVoid) {
   dp_tclBaseElement myDpElem("IsGuidanceActive", (tS32)0x6db5bfc8);
   (tVoid)myDpElem.bFillData((tVoid*)&tIsGuidanceActive, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationIsGuidanceActive::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationIsGuidanceActive::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_NavigationIsGuidanceActive::tGetData() {
   vUpdate();
   return tIsGuidanceActive;
};
tS32 dp_tclAppHmi_NavigationIsGuidanceActive::s32GetData(tBool& tIsGuidanceActiveParam) { 
   vUpdate();
   tIsGuidanceActiveParam = tIsGuidanceActive;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationIsGuidanceActive::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("IsGuidanceActive", (tS32)0x6db5bfc8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationIsGuidanceActive::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationIsGuidanceActive::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationIsGuidanceActive::s32SetData(tBool &tIsGuidanceActiveParam) {
   //init parameter
   (tVoid)memcpy(&tIsGuidanceActive,(tVoid*)&tIsGuidanceActiveParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIsGuidanceActiveParam' in function 'dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_NavigationIsGuidanceActive::s32SetData(const tBool &tIsGuidanceActiveParam) {
   //init parameter
   (tVoid)memcpy(&tIsGuidanceActive,(tVoid*)&tIsGuidanceActiveParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tIsGuidanceActiveParam' in function 'dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationIsGuidanceActive::u8GetData(tBool& tIsGuidanceActiveParam) {  
   vUpdate();
   tIsGuidanceActiveParam = tIsGuidanceActive;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(tBool &tIsGuidanceActiveParam) { 
   //init parameter
   (tVoid)memcpy(&tIsGuidanceActive,(tVoid*)&tIsGuidanceActiveParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tIsGuidanceActiveParam' in function 'dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(const tBool &tIsGuidanceActiveParam) { 
   //init parameter
   (tVoid)memcpy(&tIsGuidanceActive,(tVoid*)&tIsGuidanceActiveParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tIsGuidanceActiveParam' in function 'dp_tclAppHmi_NavigationIsGuidanceActive::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_NavigationIsGuidanceActive::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationIsGuidanceActive::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "IsGuidanceActive", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationIsGuidanceActive::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "IsGuidanceActive", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationIsGuidanceActive::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: IsGuidanceActive", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element IsGuidanceActive has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DateFormat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationDateFormat::dp_tclAppHmi_NavigationDateFormat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDateFormat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationDateFormat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DateFormat",(tS32) 0xad3c02b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDateFormat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationDateFormat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DateFormat", (tS32)0xad3c02b);
   (tVoid)myDpElem.bFillData((tVoid*)&tDateFormat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationDateFormat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationDateFormat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationDateFormat::tGetData() {
   vUpdate();
   return tDateFormat;
};
tS32 dp_tclAppHmi_NavigationDateFormat::s32GetData(tU8& tDateFormatParam) { 
   vUpdate();
   tDateFormatParam = tDateFormat;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationDateFormat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DateFormat", (tS32)0xad3c02b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationDateFormat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationDateFormat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationDateFormat::s32SetData(tU8 &tDateFormatParam) {
   //init parameter
   (tVoid)memcpy(&tDateFormat,(tVoid*)&tDateFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDateFormatParam' in function 'dp_tclAppHmi_NavigationDateFormat::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationDateFormat::s32SetData(const tU8 &tDateFormatParam) {
   //init parameter
   (tVoid)memcpy(&tDateFormat,(tVoid*)&tDateFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDateFormatParam' in function 'dp_tclAppHmi_NavigationDateFormat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationDateFormat::u8GetData(tU8& tDateFormatParam) {  
   vUpdate();
   tDateFormatParam = tDateFormat;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationDateFormat::vSetData(tU8 &tDateFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tDateFormat,(tVoid*)&tDateFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDateFormatParam' in function 'dp_tclAppHmi_NavigationDateFormat::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationDateFormat::vSetData(const tU8 &tDateFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tDateFormat,(tVoid*)&tDateFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDateFormatParam' in function 'dp_tclAppHmi_NavigationDateFormat::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationDateFormat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationDateFormat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "DateFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationDateFormat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "DateFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationDateFormat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DateFormat", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element DateFormat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "TimeFormat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationTimeFormat::dp_tclAppHmi_NavigationTimeFormat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tTimeFormat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationTimeFormat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("TimeFormat",(tS32) 0xcd7ed48);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tTimeFormat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationTimeFormat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("TimeFormat", (tS32)0xcd7ed48);
   (tVoid)myDpElem.bFillData((tVoid*)&tTimeFormat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationTimeFormat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationTimeFormat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationTimeFormat::tGetData() {
   vUpdate();
   return tTimeFormat;
};
tS32 dp_tclAppHmi_NavigationTimeFormat::s32GetData(tU8& tTimeFormatParam) { 
   vUpdate();
   tTimeFormatParam = tTimeFormat;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationTimeFormat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("TimeFormat", (tS32)0xcd7ed48);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationTimeFormat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationTimeFormat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationTimeFormat::s32SetData(tU8 &tTimeFormatParam) {
   //init parameter
   (tVoid)memcpy(&tTimeFormat,(tVoid*)&tTimeFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeFormatParam' in function 'dp_tclAppHmi_NavigationTimeFormat::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationTimeFormat::s32SetData(const tU8 &tTimeFormatParam) {
   //init parameter
   (tVoid)memcpy(&tTimeFormat,(tVoid*)&tTimeFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tTimeFormatParam' in function 'dp_tclAppHmi_NavigationTimeFormat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationTimeFormat::u8GetData(tU8& tTimeFormatParam) {  
   vUpdate();
   tTimeFormatParam = tTimeFormat;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationTimeFormat::vSetData(tU8 &tTimeFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeFormat,(tVoid*)&tTimeFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTimeFormatParam' in function 'dp_tclAppHmi_NavigationTimeFormat::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationTimeFormat::vSetData(const tU8 &tTimeFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tTimeFormat,(tVoid*)&tTimeFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tTimeFormatParam' in function 'dp_tclAppHmi_NavigationTimeFormat::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationTimeFormat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationTimeFormat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "TimeFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationTimeFormat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "TimeFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationTimeFormat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: TimeFormat", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element TimeFormat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LocalTimeOffset"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLocalTimeOffset::dp_tclAppHmi_NavigationLocalTimeOffset(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLocalTimeOffset,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLocalTimeOffset::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LocalTimeOffset",(tS32) 0x939b8edd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLocalTimeOffset = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLocalTimeOffset::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LocalTimeOffset", (tS32)0x939b8edd);
   (tVoid)myDpElem.bFillData((tVoid*)&tLocalTimeOffset, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLocalTimeOffset::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLocalTimeOffset::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_NavigationLocalTimeOffset::tGetData() {
   vUpdate();
   return tLocalTimeOffset;
};
tS32 dp_tclAppHmi_NavigationLocalTimeOffset::s32GetData(tU32& tLocalTimeOffsetParam) { 
   vUpdate();
   tLocalTimeOffsetParam = tLocalTimeOffset;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLocalTimeOffset::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LocalTimeOffset", (tS32)0x939b8edd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLocalTimeOffset::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLocalTimeOffset::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLocalTimeOffset::s32SetData(tU32 &tLocalTimeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tLocalTimeOffset,(tVoid*)&tLocalTimeOffsetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLocalTimeOffsetParam' in function 'dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_NavigationLocalTimeOffset::s32SetData(const tU32 &tLocalTimeOffsetParam) {
   //init parameter
   (tVoid)memcpy(&tLocalTimeOffset,(tVoid*)&tLocalTimeOffsetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLocalTimeOffsetParam' in function 'dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLocalTimeOffset::u8GetData(tU32& tLocalTimeOffsetParam) {  
   vUpdate();
   tLocalTimeOffsetParam = tLocalTimeOffset;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(tU32 &tLocalTimeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tLocalTimeOffset,(tVoid*)&tLocalTimeOffsetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLocalTimeOffsetParam' in function 'dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(const tU32 &tLocalTimeOffsetParam) { 
   //init parameter
   (tVoid)memcpy(&tLocalTimeOffset,(tVoid*)&tLocalTimeOffsetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLocalTimeOffsetParam' in function 'dp_tclAppHmi_NavigationLocalTimeOffset::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_NavigationLocalTimeOffset::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLocalTimeOffset::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LocalTimeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLocalTimeOffset::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LocalTimeOffset", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLocalTimeOffset::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LocalTimeOffset", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LocalTimeOffset has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ClockAutoModeActivated"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationClockAutoModeActivated::dp_tclAppHmi_NavigationClockAutoModeActivated(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tClockAutoModeActivated,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ClockAutoModeActivated",(tS32) 0x9dbc0beb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tClockAutoModeActivated = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ClockAutoModeActivated", (tS32)0x9dbc0beb);
   (tVoid)myDpElem.bFillData((tVoid*)&tClockAutoModeActivated, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationClockAutoModeActivated::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationClockAutoModeActivated::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_NavigationClockAutoModeActivated::tGetData() {
   vUpdate();
   return tClockAutoModeActivated;
};
tS32 dp_tclAppHmi_NavigationClockAutoModeActivated::s32GetData(tBool& tClockAutoModeActivatedParam) { 
   vUpdate();
   tClockAutoModeActivatedParam = tClockAutoModeActivated;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationClockAutoModeActivated::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ClockAutoModeActivated", (tS32)0x9dbc0beb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationClockAutoModeActivated::s32SetData(tBool &tClockAutoModeActivatedParam) {
   //init parameter
   (tVoid)memcpy(&tClockAutoModeActivated,(tVoid*)&tClockAutoModeActivatedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClockAutoModeActivatedParam' in function 'dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_NavigationClockAutoModeActivated::s32SetData(const tBool &tClockAutoModeActivatedParam) {
   //init parameter
   (tVoid)memcpy(&tClockAutoModeActivated,(tVoid*)&tClockAutoModeActivatedParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClockAutoModeActivatedParam' in function 'dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationClockAutoModeActivated::u8GetData(tBool& tClockAutoModeActivatedParam) {  
   vUpdate();
   tClockAutoModeActivatedParam = tClockAutoModeActivated;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(tBool &tClockAutoModeActivatedParam) { 
   //init parameter
   (tVoid)memcpy(&tClockAutoModeActivated,(tVoid*)&tClockAutoModeActivatedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tClockAutoModeActivatedParam' in function 'dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(const tBool &tClockAutoModeActivatedParam) { 
   //init parameter
   (tVoid)memcpy(&tClockAutoModeActivated,(tVoid*)&tClockAutoModeActivatedParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tClockAutoModeActivatedParam' in function 'dp_tclAppHmi_NavigationClockAutoModeActivated::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_NavigationClockAutoModeActivated::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationClockAutoModeActivated::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ClockAutoModeActivated", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationClockAutoModeActivated::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ClockAutoModeActivated", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationClockAutoModeActivated::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ClockAutoModeActivated", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element ClockAutoModeActivated has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EstimatedTimeMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationEstimatedTimeMode::dp_tclAppHmi_NavigationEstimatedTimeMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEstimatedTimeMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EstimatedTimeMode",(tS32) 0xce05aa3c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEstimatedTimeMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EstimatedTimeMode", (tS32)0xce05aa3c);
   (tVoid)myDpElem.bFillData((tVoid*)&tEstimatedTimeMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationEstimatedTimeMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationEstimatedTimeMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationEstimatedTimeMode::tGetData() {
   vUpdate();
   return tEstimatedTimeMode;
};
tS32 dp_tclAppHmi_NavigationEstimatedTimeMode::s32GetData(tU8& tEstimatedTimeModeParam) { 
   vUpdate();
   tEstimatedTimeModeParam = tEstimatedTimeMode;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationEstimatedTimeMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EstimatedTimeMode", (tS32)0xce05aa3c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationEstimatedTimeMode::s32SetData(tU8 &tEstimatedTimeModeParam) {
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeMode,(tVoid*)&tEstimatedTimeModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEstimatedTimeModeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationEstimatedTimeMode::s32SetData(const tU8 &tEstimatedTimeModeParam) {
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeMode,(tVoid*)&tEstimatedTimeModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEstimatedTimeModeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationEstimatedTimeMode::u8GetData(tU8& tEstimatedTimeModeParam) {  
   vUpdate();
   tEstimatedTimeModeParam = tEstimatedTimeMode;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(tU8 &tEstimatedTimeModeParam) { 
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeMode,(tVoid*)&tEstimatedTimeModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEstimatedTimeModeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(const tU8 &tEstimatedTimeModeParam) { 
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeMode,(tVoid*)&tEstimatedTimeModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEstimatedTimeModeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeMode::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationEstimatedTimeMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationEstimatedTimeMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "EstimatedTimeMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationEstimatedTimeMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "EstimatedTimeMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationEstimatedTimeMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EstimatedTimeMode", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element EstimatedTimeMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EstimatedTimeType"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationEstimatedTimeType::dp_tclAppHmi_NavigationEstimatedTimeType(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEstimatedTimeType,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationEstimatedTimeType::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EstimatedTimeType",(tS32) 0xce05aedd);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tEstimatedTimeType = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationEstimatedTimeType::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EstimatedTimeType", (tS32)0xce05aedd);
   (tVoid)myDpElem.bFillData((tVoid*)&tEstimatedTimeType, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationEstimatedTimeType::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationEstimatedTimeType::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationEstimatedTimeType::tGetData() {
   vUpdate();
   return tEstimatedTimeType;
};
tS32 dp_tclAppHmi_NavigationEstimatedTimeType::s32GetData(tU8& tEstimatedTimeTypeParam) { 
   vUpdate();
   tEstimatedTimeTypeParam = tEstimatedTimeType;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationEstimatedTimeType::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EstimatedTimeType", (tS32)0xce05aedd);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationEstimatedTimeType::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationEstimatedTimeType::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationEstimatedTimeType::s32SetData(tU8 &tEstimatedTimeTypeParam) {
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeType,(tVoid*)&tEstimatedTimeTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEstimatedTimeTypeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationEstimatedTimeType::s32SetData(const tU8 &tEstimatedTimeTypeParam) {
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeType,(tVoid*)&tEstimatedTimeTypeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEstimatedTimeTypeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationEstimatedTimeType::u8GetData(tU8& tEstimatedTimeTypeParam) {  
   vUpdate();
   tEstimatedTimeTypeParam = tEstimatedTimeType;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(tU8 &tEstimatedTimeTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeType,(tVoid*)&tEstimatedTimeTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEstimatedTimeTypeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(const tU8 &tEstimatedTimeTypeParam) { 
   //init parameter
   (tVoid)memcpy(&tEstimatedTimeType,(tVoid*)&tEstimatedTimeTypeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tEstimatedTimeTypeParam' in function 'dp_tclAppHmi_NavigationEstimatedTimeType::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationEstimatedTimeType::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationEstimatedTimeType::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "EstimatedTimeType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationEstimatedTimeType::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "EstimatedTimeType", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationEstimatedTimeType::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EstimatedTimeType", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element EstimatedTimeType has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DistanceUnitSystem"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationDistanceUnitSystem::dp_tclAppHmi_NavigationDistanceUnitSystem(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistanceUnitSystem,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DistanceUnitSystem",(tS32) 0xc623df98);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDistanceUnitSystem = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DistanceUnitSystem", (tS32)0xc623df98);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistanceUnitSystem, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationDistanceUnitSystem::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationDistanceUnitSystem::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationDistanceUnitSystem::tGetData() {
   vUpdate();
   return tDistanceUnitSystem;
};
tS32 dp_tclAppHmi_NavigationDistanceUnitSystem::s32GetData(tU8& tDistanceUnitSystemParam) { 
   vUpdate();
   tDistanceUnitSystemParam = tDistanceUnitSystem;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationDistanceUnitSystem::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DistanceUnitSystem", (tS32)0xc623df98);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationDistanceUnitSystem::s32SetData(tU8 &tDistanceUnitSystemParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnitSystem,(tVoid*)&tDistanceUnitSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitSystemParam' in function 'dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationDistanceUnitSystem::s32SetData(const tU8 &tDistanceUnitSystemParam) {
   //init parameter
   (tVoid)memcpy(&tDistanceUnitSystem,(tVoid*)&tDistanceUnitSystemParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistanceUnitSystemParam' in function 'dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationDistanceUnitSystem::u8GetData(tU8& tDistanceUnitSystemParam) {  
   vUpdate();
   tDistanceUnitSystemParam = tDistanceUnitSystem;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(tU8 &tDistanceUnitSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnitSystem,(tVoid*)&tDistanceUnitSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitSystemParam' in function 'dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(const tU8 &tDistanceUnitSystemParam) { 
   //init parameter
   (tVoid)memcpy(&tDistanceUnitSystem,(tVoid*)&tDistanceUnitSystemParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistanceUnitSystemParam' in function 'dp_tclAppHmi_NavigationDistanceUnitSystem::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationDistanceUnitSystem::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationDistanceUnitSystem::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "DistanceUnitSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationDistanceUnitSystem::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "DistanceUnitSystem", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationDistanceUnitSystem::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DistanceUnitSystem", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element DistanceUnitSystem has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LatitudeCoordinatesDirection"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::dp_tclAppHmi_NavigationLatitudeCoordinatesDirection(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLatitudeCoordinatesDirection,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LatitudeCoordinatesDirection",(tS32) 0xc06712a8L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLatitudeCoordinatesDirection = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LatitudeCoordinatesDirection", (tS32)0xc06712a8L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLatitudeCoordinatesDirection, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::tGetData() {
   vUpdate();
   return tLatitudeCoordinatesDirection;
};
tS32 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::s32GetData(tU8& tLatitudeCoordinatesDirectionParam) { 
   vUpdate();
   tLatitudeCoordinatesDirectionParam = tLatitudeCoordinatesDirection;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LatitudeCoordinatesDirection", (tS32)0xc06712a8L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::s32SetData(tU8 &tLatitudeCoordinatesDirectionParam) {
   //init parameter
   (tVoid)memcpy(&tLatitudeCoordinatesDirection,(tVoid*)&tLatitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLatitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::s32SetData(const tU8 &tLatitudeCoordinatesDirectionParam) {
   //init parameter
   (tVoid)memcpy(&tLatitudeCoordinatesDirection,(tVoid*)&tLatitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLatitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::u8GetData(tU8& tLatitudeCoordinatesDirectionParam) {  
   vUpdate();
   tLatitudeCoordinatesDirectionParam = tLatitudeCoordinatesDirection;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(tU8 &tLatitudeCoordinatesDirectionParam) { 
   //init parameter
   (tVoid)memcpy(&tLatitudeCoordinatesDirection,(tVoid*)&tLatitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLatitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(const tU8 &tLatitudeCoordinatesDirectionParam) { 
   //init parameter
   (tVoid)memcpy(&tLatitudeCoordinatesDirection,(tVoid*)&tLatitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLatitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LatitudeCoordinatesDirection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LatitudeCoordinatesDirection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLatitudeCoordinatesDirection::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LatitudeCoordinatesDirection", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LatitudeCoordinatesDirection has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LongitudeCoordinatesDirection"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::dp_tclAppHmi_NavigationLongitudeCoordinatesDirection(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLongitudeCoordinatesDirection,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LongitudeCoordinatesDirection",(tS32) 0x2884c1afL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLongitudeCoordinatesDirection = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LongitudeCoordinatesDirection", (tS32)0x2884c1afL);
   (tVoid)myDpElem.bFillData((tVoid*)&tLongitudeCoordinatesDirection, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::tGetData() {
   vUpdate();
   return tLongitudeCoordinatesDirection;
};
tS32 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::s32GetData(tU8& tLongitudeCoordinatesDirectionParam) { 
   vUpdate();
   tLongitudeCoordinatesDirectionParam = tLongitudeCoordinatesDirection;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LongitudeCoordinatesDirection", (tS32)0x2884c1afL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::s32SetData(tU8 &tLongitudeCoordinatesDirectionParam) {
   //init parameter
   (tVoid)memcpy(&tLongitudeCoordinatesDirection,(tVoid*)&tLongitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLongitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::s32SetData(const tU8 &tLongitudeCoordinatesDirectionParam) {
   //init parameter
   (tVoid)memcpy(&tLongitudeCoordinatesDirection,(tVoid*)&tLongitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLongitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::u8GetData(tU8& tLongitudeCoordinatesDirectionParam) {  
   vUpdate();
   tLongitudeCoordinatesDirectionParam = tLongitudeCoordinatesDirection;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(tU8 &tLongitudeCoordinatesDirectionParam) { 
   //init parameter
   (tVoid)memcpy(&tLongitudeCoordinatesDirection,(tVoid*)&tLongitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLongitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(const tU8 &tLongitudeCoordinatesDirectionParam) { 
   //init parameter
   (tVoid)memcpy(&tLongitudeCoordinatesDirection,(tVoid*)&tLongitudeCoordinatesDirectionParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLongitudeCoordinatesDirectionParam' in function 'dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LongitudeCoordinatesDirection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LongitudeCoordinatesDirection", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLongitudeCoordinatesDirection::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LongitudeCoordinatesDirection", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LongitudeCoordinatesDirection has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CoordinateDisplayFormat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationCoordinateDisplayFormat::dp_tclAppHmi_NavigationCoordinateDisplayFormat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCoordinateDisplayFormat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CoordinateDisplayFormat",(tS32) 0x72a8261b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tCoordinateDisplayFormat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CoordinateDisplayFormat", (tS32)0x72a8261b);
   (tVoid)myDpElem.bFillData((tVoid*)&tCoordinateDisplayFormat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationCoordinateDisplayFormat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationCoordinateDisplayFormat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationCoordinateDisplayFormat::tGetData() {
   vUpdate();
   return tCoordinateDisplayFormat;
};
tS32 dp_tclAppHmi_NavigationCoordinateDisplayFormat::s32GetData(tU8& tCoordinateDisplayFormatParam) { 
   vUpdate();
   tCoordinateDisplayFormatParam = tCoordinateDisplayFormat;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationCoordinateDisplayFormat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CoordinateDisplayFormat", (tS32)0x72a8261b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationCoordinateDisplayFormat::s32SetData(tU8 &tCoordinateDisplayFormatParam) {
   //init parameter
   (tVoid)memcpy(&tCoordinateDisplayFormat,(tVoid*)&tCoordinateDisplayFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoordinateDisplayFormatParam' in function 'dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationCoordinateDisplayFormat::s32SetData(const tU8 &tCoordinateDisplayFormatParam) {
   //init parameter
   (tVoid)memcpy(&tCoordinateDisplayFormat,(tVoid*)&tCoordinateDisplayFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoordinateDisplayFormatParam' in function 'dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationCoordinateDisplayFormat::u8GetData(tU8& tCoordinateDisplayFormatParam) {  
   vUpdate();
   tCoordinateDisplayFormatParam = tCoordinateDisplayFormat;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(tU8 &tCoordinateDisplayFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tCoordinateDisplayFormat,(tVoid*)&tCoordinateDisplayFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCoordinateDisplayFormatParam' in function 'dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(const tU8 &tCoordinateDisplayFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tCoordinateDisplayFormat,(tVoid*)&tCoordinateDisplayFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tCoordinateDisplayFormatParam' in function 'dp_tclAppHmi_NavigationCoordinateDisplayFormat::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationCoordinateDisplayFormat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationCoordinateDisplayFormat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoordinateDisplayFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoordinateDisplayFormat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoordinateDisplayFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoordinateDisplayFormat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CoordinateDisplayFormat", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element CoordinateDisplayFormat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LightMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationLightMode::dp_tclAppHmi_NavigationLightMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLightMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationLightMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LightMode",(tS32) 0x260fc65);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tLightMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationLightMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LightMode", (tS32)0x260fc65);
   (tVoid)myDpElem.bFillData((tVoid*)&tLightMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationLightMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationLightMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationLightMode::tGetData() {
   vUpdate();
   return tLightMode;
};
tS32 dp_tclAppHmi_NavigationLightMode::s32GetData(tU8& tLightModeParam) { 
   vUpdate();
   tLightModeParam = tLightMode;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationLightMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LightMode", (tS32)0x260fc65);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationLightMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationLightMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationLightMode::s32SetData(tU8 &tLightModeParam) {
   //init parameter
   (tVoid)memcpy(&tLightMode,(tVoid*)&tLightModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLightModeParam' in function 'dp_tclAppHmi_NavigationLightMode::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationLightMode::s32SetData(const tU8 &tLightModeParam) {
   //init parameter
   (tVoid)memcpy(&tLightMode,(tVoid*)&tLightModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLightModeParam' in function 'dp_tclAppHmi_NavigationLightMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationLightMode::u8GetData(tU8& tLightModeParam) {  
   vUpdate();
   tLightModeParam = tLightMode;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationLightMode::vSetData(tU8 &tLightModeParam) { 
   //init parameter
   (tVoid)memcpy(&tLightMode,(tVoid*)&tLightModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLightModeParam' in function 'dp_tclAppHmi_NavigationLightMode::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationLightMode::vSetData(const tU8 &tLightModeParam) { 
   //init parameter
   (tVoid)memcpy(&tLightMode,(tVoid*)&tLightModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tLightModeParam' in function 'dp_tclAppHmi_NavigationLightMode::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationLightMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationLightMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LightMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLightMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "LightMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationLightMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LightMode", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element LightMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MyPOIsAvailability"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationMyPOIsAvailability::dp_tclAppHmi_NavigationMyPOIsAvailability(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMyPOIsAvailability,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MyPOIsAvailability",(tS32) 0xc7822d84);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMyPOIsAvailability = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MyPOIsAvailability", (tS32)0xc7822d84);
   (tVoid)myDpElem.bFillData((tVoid*)&tMyPOIsAvailability, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationMyPOIsAvailability::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationMyPOIsAvailability::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_NavigationMyPOIsAvailability::tGetData() {
   vUpdate();
   return tMyPOIsAvailability;
};
tS32 dp_tclAppHmi_NavigationMyPOIsAvailability::s32GetData(tBool& tMyPOIsAvailabilityParam) { 
   vUpdate();
   tMyPOIsAvailabilityParam = tMyPOIsAvailability;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationMyPOIsAvailability::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MyPOIsAvailability", (tS32)0xc7822d84);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationMyPOIsAvailability::s32SetData(tBool &tMyPOIsAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tMyPOIsAvailability,(tVoid*)&tMyPOIsAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMyPOIsAvailabilityParam' in function 'dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_NavigationMyPOIsAvailability::s32SetData(const tBool &tMyPOIsAvailabilityParam) {
   //init parameter
   (tVoid)memcpy(&tMyPOIsAvailability,(tVoid*)&tMyPOIsAvailabilityParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMyPOIsAvailabilityParam' in function 'dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationMyPOIsAvailability::u8GetData(tBool& tMyPOIsAvailabilityParam) {  
   vUpdate();
   tMyPOIsAvailabilityParam = tMyPOIsAvailability;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(tBool &tMyPOIsAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tMyPOIsAvailability,(tVoid*)&tMyPOIsAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMyPOIsAvailabilityParam' in function 'dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(const tBool &tMyPOIsAvailabilityParam) { 
   //init parameter
   (tVoid)memcpy(&tMyPOIsAvailability,(tVoid*)&tMyPOIsAvailabilityParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMyPOIsAvailabilityParam' in function 'dp_tclAppHmi_NavigationMyPOIsAvailability::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_NavigationMyPOIsAvailability::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationMyPOIsAvailability::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "MyPOIsAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationMyPOIsAvailability::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "MyPOIsAvailability", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationMyPOIsAvailability::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MyPOIsAvailability", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element MyPOIsAvailability has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VehicleProfile"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationVehicleProfile::dp_tclAppHmi_NavigationVehicleProfile(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVehicleProfile,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationVehicleProfile::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VehicleProfile",(tS32) 0xa979c7a1);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVehicleProfile = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationVehicleProfile::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VehicleProfile", (tS32)0xa979c7a1);
   (tVoid)myDpElem.bFillData((tVoid*)&tVehicleProfile, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationVehicleProfile::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationVehicleProfile::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclAppHmi_NavigationVehicleProfile::tGetData() {
   vUpdate();
   return tVehicleProfile;
};
tS32 dp_tclAppHmi_NavigationVehicleProfile::s32GetData(tU8& tVehicleProfileParam) { 
   vUpdate();
   tVehicleProfileParam = tVehicleProfile;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationVehicleProfile::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VehicleProfile", (tS32)0xa979c7a1);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationVehicleProfile::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationVehicleProfile::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationVehicleProfile::s32SetData(tU8 &tVehicleProfileParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleProfile,(tVoid*)&tVehicleProfileParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleProfileParam' in function 'dp_tclAppHmi_NavigationVehicleProfile::vSetData(tU8)' could be made const reference
tS32 dp_tclAppHmi_NavigationVehicleProfile::s32SetData(const tU8 &tVehicleProfileParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleProfile,(tVoid*)&tVehicleProfileParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleProfileParam' in function 'dp_tclAppHmi_NavigationVehicleProfile::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationVehicleProfile::u8GetData(tU8& tVehicleProfileParam) {  
   vUpdate();
   tVehicleProfileParam = tVehicleProfile;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationVehicleProfile::vSetData(tU8 &tVehicleProfileParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleProfile,(tVoid*)&tVehicleProfileParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleProfileParam' in function 'dp_tclAppHmi_NavigationVehicleProfile::vSetData(tU8)' could be made const reference
tVoid dp_tclAppHmi_NavigationVehicleProfile::vSetData(const tU8 &tVehicleProfileParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleProfile,(tVoid*)&tVehicleProfileParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleProfileParam' in function 'dp_tclAppHmi_NavigationVehicleProfile::vSetData(tU8)' could be made const reference
tU8   dp_tclAppHmi_NavigationVehicleProfile::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationVehicleProfile::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VehicleProfile", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVehicleProfile::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "VehicleProfile", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationVehicleProfile::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VehicleProfile", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element VehicleProfile has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ProfileAndGuidanceStateLastWrittenLineNo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tProfileAndGuidanceStateLastWrittenLineNo,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ProfileAndGuidanceStateLastWrittenLineNo",(tS32) 0x46871b1bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tProfileAndGuidanceStateLastWrittenLineNo = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ProfileAndGuidanceStateLastWrittenLineNo", (tS32)0x46871b1bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tProfileAndGuidanceStateLastWrittenLineNo, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::tGetData() {
   vUpdate();
   return tProfileAndGuidanceStateLastWrittenLineNo;
};
tS32 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::s32GetData(tU32& tProfileAndGuidanceStateLastWrittenLineNoParam) { 
   vUpdate();
   tProfileAndGuidanceStateLastWrittenLineNoParam = tProfileAndGuidanceStateLastWrittenLineNo;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ProfileAndGuidanceStateLastWrittenLineNo", (tS32)0x46871b1bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::s32SetData(tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam) {
   //init parameter
   (tVoid)memcpy(&tProfileAndGuidanceStateLastWrittenLineNo,(tVoid*)&tProfileAndGuidanceStateLastWrittenLineNoParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tProfileAndGuidanceStateLastWrittenLineNoParam' in function 'dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::s32SetData(const tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam) {
   //init parameter
   (tVoid)memcpy(&tProfileAndGuidanceStateLastWrittenLineNo,(tVoid*)&tProfileAndGuidanceStateLastWrittenLineNoParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tProfileAndGuidanceStateLastWrittenLineNoParam' in function 'dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::u8GetData(tU32& tProfileAndGuidanceStateLastWrittenLineNoParam) {  
   vUpdate();
   tProfileAndGuidanceStateLastWrittenLineNoParam = tProfileAndGuidanceStateLastWrittenLineNo;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam) { 
   //init parameter
   (tVoid)memcpy(&tProfileAndGuidanceStateLastWrittenLineNo,(tVoid*)&tProfileAndGuidanceStateLastWrittenLineNoParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tProfileAndGuidanceStateLastWrittenLineNoParam' in function 'dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(const tU32 &tProfileAndGuidanceStateLastWrittenLineNoParam) { 
   //init parameter
   (tVoid)memcpy(&tProfileAndGuidanceStateLastWrittenLineNo,(tVoid*)&tProfileAndGuidanceStateLastWrittenLineNoParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tProfileAndGuidanceStateLastWrittenLineNoParam' in function 'dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ProfileAndGuidanceStateLastWrittenLineNo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ProfileAndGuidanceStateLastWrittenLineNo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationProfileAndGuidanceStateLastWrittenLineNo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ProfileAndGuidanceStateLastWrittenLineNo", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element ProfileAndGuidanceStateLastWrittenLineNo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ShowETAOnSecMap"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationShowETAOnSecMap::dp_tclAppHmi_NavigationShowETAOnSecMap(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tShowETAOnSecMap,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ShowETAOnSecMap",(tS32) 0x5fc3a205);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tShowETAOnSecMap = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ShowETAOnSecMap", (tS32)0x5fc3a205);
   (tVoid)myDpElem.bFillData((tVoid*)&tShowETAOnSecMap, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationShowETAOnSecMap::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationShowETAOnSecMap::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclAppHmi_NavigationShowETAOnSecMap::tGetData() {
   vUpdate();
   return tShowETAOnSecMap;
};
tS32 dp_tclAppHmi_NavigationShowETAOnSecMap::s32GetData(tBool& tShowETAOnSecMapParam) { 
   vUpdate();
   tShowETAOnSecMapParam = tShowETAOnSecMap;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationShowETAOnSecMap::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ShowETAOnSecMap", (tS32)0x5fc3a205);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationShowETAOnSecMap::s32SetData(tBool &tShowETAOnSecMapParam) {
   //init parameter
   (tVoid)memcpy(&tShowETAOnSecMap,(tVoid*)&tShowETAOnSecMapParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tShowETAOnSecMapParam' in function 'dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(tBool)' could be made const reference
tS32 dp_tclAppHmi_NavigationShowETAOnSecMap::s32SetData(const tBool &tShowETAOnSecMapParam) {
   //init parameter
   (tVoid)memcpy(&tShowETAOnSecMap,(tVoid*)&tShowETAOnSecMapParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tShowETAOnSecMapParam' in function 'dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationShowETAOnSecMap::u8GetData(tBool& tShowETAOnSecMapParam) {  
   vUpdate();
   tShowETAOnSecMapParam = tShowETAOnSecMap;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(tBool &tShowETAOnSecMapParam) { 
   //init parameter
   (tVoid)memcpy(&tShowETAOnSecMap,(tVoid*)&tShowETAOnSecMapParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tShowETAOnSecMapParam' in function 'dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(tBool)' could be made const reference
tVoid dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(const tBool &tShowETAOnSecMapParam) { 
   //init parameter
   (tVoid)memcpy(&tShowETAOnSecMap,(tVoid*)&tShowETAOnSecMapParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tShowETAOnSecMapParam' in function 'dp_tclAppHmi_NavigationShowETAOnSecMap::vSetData(tBool)' could be made const reference
tU8   dp_tclAppHmi_NavigationShowETAOnSecMap::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationShowETAOnSecMap::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ShowETAOnSecMap", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationShowETAOnSecMap::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "ShowETAOnSecMap", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationShowETAOnSecMap::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ShowETAOnSecMap", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element ShowETAOnSecMap has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CoachWeight"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationCoachWeight::dp_tclAppHmi_NavigationCoachWeight(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCoachWeight,0,sizeof(tF32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationCoachWeight::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CoachWeight",(tS32) 0x36c22cae);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tF32)) 
      {
         tCoachWeight = *((tF32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationCoachWeight::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CoachWeight", (tS32)0x36c22cae);
   (tVoid)myDpElem.bFillData((tVoid*)&tCoachWeight, (tU32)sizeof(tF32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationCoachWeight::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationCoachWeight::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tF32 dp_tclAppHmi_NavigationCoachWeight::tGetData() {
   vUpdate();
   return tCoachWeight;
};
tS32 dp_tclAppHmi_NavigationCoachWeight::s32GetData(tF32& tCoachWeightParam) { 
   vUpdate();
   tCoachWeightParam = tCoachWeight;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationCoachWeight::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CoachWeight", (tS32)0x36c22cae);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationCoachWeight::operator>>(tF32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationCoachWeight::operator<<(tF32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationCoachWeight::s32SetData(tF32 &tCoachWeightParam) {
   //init parameter
   (tVoid)memcpy(&tCoachWeight,(tVoid*)&tCoachWeightParam, sizeof(tF32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoachWeightParam' in function 'dp_tclAppHmi_NavigationCoachWeight::vSetData(tF32)' could be made const reference
tS32 dp_tclAppHmi_NavigationCoachWeight::s32SetData(const tF32 &tCoachWeightParam) {
   //init parameter
   (tVoid)memcpy(&tCoachWeight,(tVoid*)&tCoachWeightParam, sizeof(tF32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoachWeightParam' in function 'dp_tclAppHmi_NavigationCoachWeight::vSetData(tF32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationCoachWeight::u8GetData(tF32& tCoachWeightParam) {  
   vUpdate();
   tCoachWeightParam = tCoachWeight;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationCoachWeight::vSetData(tF32 &tCoachWeightParam) { 
   //init parameter
   (tVoid)memcpy(&tCoachWeight,(tVoid*)&tCoachWeightParam, sizeof(tF32));
   vStore();
}//lint !e1746: parameter 'tCoachWeightParam' in function 'dp_tclAppHmi_NavigationCoachWeight::vSetData(tF32)' could be made const reference
tVoid dp_tclAppHmi_NavigationCoachWeight::vSetData(const tF32 &tCoachWeightParam) { 
   //init parameter
   (tVoid)memcpy(&tCoachWeight,(tVoid*)&tCoachWeightParam, sizeof(tF32));
   vStore();
}//lint !e1746: parameter 'tCoachWeightParam' in function 'dp_tclAppHmi_NavigationCoachWeight::vSetData(tF32)' could be made const reference
tU8   dp_tclAppHmi_NavigationCoachWeight::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationCoachWeight::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoachWeight", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoachWeight::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoachWeight", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoachWeight::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CoachWeight", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element CoachWeight has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CoachLoadPerAxle"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_NavigationCoachLoadPerAxle::dp_tclAppHmi_NavigationCoachLoadPerAxle(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tCoachLoadPerAxle,0,sizeof(tF32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("CoachLoadPerAxle",(tS32) 0x6ad5df0b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tF32)) 
      {
         tCoachLoadPerAxle = *((tF32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::vStore(tVoid) {
   dp_tclBaseElement myDpElem("CoachLoadPerAxle", (tS32)0x6ad5df0b);
   (tVoid)myDpElem.bFillData((tVoid*)&tCoachLoadPerAxle, (tU32)sizeof(tF32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_NavigationCoachLoadPerAxle::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_NavigationCoachLoadPerAxle::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tF32 dp_tclAppHmi_NavigationCoachLoadPerAxle::tGetData() {
   vUpdate();
   return tCoachLoadPerAxle;
};
tS32 dp_tclAppHmi_NavigationCoachLoadPerAxle::s32GetData(tF32& tCoachLoadPerAxleParam) { 
   vUpdate();
   tCoachLoadPerAxleParam = tCoachLoadPerAxle;
   return _s32Status;
}
tS32 dp_tclAppHmi_NavigationCoachLoadPerAxle::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("CoachLoadPerAxle", (tS32)0x6ad5df0b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_NAVIGATION, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::operator>>(tF32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::operator<<(tF32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_NavigationCoachLoadPerAxle::s32SetData(tF32 &tCoachLoadPerAxleParam) {
   //init parameter
   (tVoid)memcpy(&tCoachLoadPerAxle,(tVoid*)&tCoachLoadPerAxleParam, sizeof(tF32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoachLoadPerAxleParam' in function 'dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(tF32)' could be made const reference
tS32 dp_tclAppHmi_NavigationCoachLoadPerAxle::s32SetData(const tF32 &tCoachLoadPerAxleParam) {
   //init parameter
   (tVoid)memcpy(&tCoachLoadPerAxle,(tVoid*)&tCoachLoadPerAxleParam, sizeof(tF32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tCoachLoadPerAxleParam' in function 'dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(tF32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_NavigationCoachLoadPerAxle::u8GetData(tF32& tCoachLoadPerAxleParam) {  
   vUpdate();
   tCoachLoadPerAxleParam = tCoachLoadPerAxle;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(tF32 &tCoachLoadPerAxleParam) { 
   //init parameter
   (tVoid)memcpy(&tCoachLoadPerAxle,(tVoid*)&tCoachLoadPerAxleParam, sizeof(tF32));
   vStore();
}//lint !e1746: parameter 'tCoachLoadPerAxleParam' in function 'dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(tF32)' could be made const reference
tVoid dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(const tF32 &tCoachLoadPerAxleParam) { 
   //init parameter
   (tVoid)memcpy(&tCoachLoadPerAxle,(tVoid*)&tCoachLoadPerAxleParam, sizeof(tF32));
   vStore();
}//lint !e1746: parameter 'tCoachLoadPerAxleParam' in function 'dp_tclAppHmi_NavigationCoachLoadPerAxle::vSetData(tF32)' could be made const reference
tU8   dp_tclAppHmi_NavigationCoachLoadPerAxle::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_NavigationCoachLoadPerAxle::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoachLoadPerAxle", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoachLoadPerAxle::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_NAVIGATION, "CoachLoadPerAxle", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_NavigationCoachLoadPerAxle::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CoachLoadPerAxle", DP_U32_POOL_ID_APPHMI_NAVIGATION);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_NAVIGATION);
   }
   else
   {
      fprintf(stdout,"Element CoachLoadPerAxle has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
