#ifndef _DP_FI_APPHMI_MASTER_H
#define _DP_FI_APPHMI_MASTER_H

extern tVoid vInitAppHmi_Master(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif



//lint -e750
#define DUMMY 
#include "../../ai_inf4cv_hmi/products/INF4CV/Apps/AppHmi_Master/App/datapool/DpHeaders.h"
//lint +e750



#define SYSTEM_S_IMPORT_INTERFACE_DEQUE
#include "stl_pif.h"


class dp_tclAppHmi_MasterLanguageCode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLanguageCode;
   
public:
   dp_tclAppHmi_MasterLanguageCode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_MasterLanguageCode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLanguageCodeParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLanguageCodeParam);
   tS32  s32SetData(const tU32 &tLanguageCodeParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLanguageCodeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLanguageCodeParam);
   tVoid vSetData(const tU32& tLanguageCodeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_Masterdummy{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tdummy;
   
public:
   dp_tclAppHmi_Masterdummy(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_Masterdummy() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tdummyParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tdummyParam);
   tS32  s32SetData(const tU32 &tdummyParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tdummyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tdummyParam);
   tVoid vSetData(const tU32& tdummyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_MasterLastActiveCockpitAudioGadget{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLastActiveCockpitAudioGadget;
   
public:
   dp_tclAppHmi_MasterLastActiveCockpitAudioGadget(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_MasterLastActiveCockpitAudioGadget() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLastActiveCockpitAudioGadgetParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLastActiveCockpitAudioGadgetParam);
   tS32  s32SetData(const tU32 &tLastActiveCockpitAudioGadgetParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLastActiveCockpitAudioGadgetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLastActiveCockpitAudioGadgetParam);
   tVoid vSetData(const tU32& tLastActiveCockpitAudioGadgetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_MasterLastActiveCabinAAudioGadget{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLastActiveCabinAAudioGadget;
   
public:
   dp_tclAppHmi_MasterLastActiveCabinAAudioGadget(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_MasterLastActiveCabinAAudioGadget() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLastActiveCabinAAudioGadgetParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLastActiveCabinAAudioGadgetParam);
   tS32  s32SetData(const tU32 &tLastActiveCabinAAudioGadgetParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLastActiveCabinAAudioGadgetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLastActiveCabinAAudioGadgetParam);
   tVoid vSetData(const tU32& tLastActiveCabinAAudioGadgetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_MasterLastActiveCabinBAudioGadget{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU32 tLastActiveCabinBAudioGadget;
   
public:
   dp_tclAppHmi_MasterLastActiveCabinBAudioGadget(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclAppHmi_MasterLastActiveCabinBAudioGadget() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU32 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU32& tLastActiveCabinBAudioGadgetParam);
   tVoid operator>>(tU32& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU32 &tLastActiveCabinBAudioGadgetParam);
   tS32  s32SetData(const tU32 &tLastActiveCabinBAudioGadgetParam);
   tVoid operator<<(tU32 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU32& tLastActiveCabinBAudioGadgetParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU32& tLastActiveCabinBAudioGadgetParam);
   tVoid vSetData(const tU32& tLastActiveCabinBAudioGadgetParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclAppHmi_MasterCabinsActivityInfoDP{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<CabinActivityInfoDPHolder> TListCabinsActivityInfoDP;
    #else
    typedef std::deque<CabinActivityInfoDPHolder> TListCabinsActivityInfoDP;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCabinsActivityInfoDP _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclAppHmi_MasterCabinsActivityInfoDP(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclAppHmi_MasterCabinsActivityInfoDP() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, CabinActivityInfoDPHolder& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(CabinActivityInfoDPHolder &tElem);
    tVoid vPushBack(const CabinActivityInfoDPHolder &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

class dp_tclAppHmi_MasterCabinVideoMixDP{
public:
    #ifdef SYSTEM_S_USE_BPSTL
    typedef bpstl::deque<CabinVideoMixInfoHolder> TListCabinVideoMixDP;
    #else
    typedef std::deque<CabinVideoMixInfoHolder> TListCabinVideoMixDP;
    #endif

private:
    tU16 _u16AccessId;
    tU16 _u16AccessType;
    tS32 _s32Status;
    tU32 _u32MaxList;
    TListCabinVideoMixDP _tList;
    

    tVoid vUpdate(tVoid);
    tVoid vStore(tVoid);


public:
    dp_tclAppHmi_MasterCabinVideoMixDP(tU16 DPid DP_DATAPOOL_ID);
    virtual ~dp_tclAppHmi_MasterCabinVideoMixDP() {};

    //read access for pool element 
    tU32  u32GetCount();
    tS32  s32GetElem(tU32 u32NbElem, CabinVideoMixInfoHolder& tElem);

    tS32   s32GetStatus() const;

    //write access for pool element 
    tVoid vPushBack(CabinVideoMixInfoHolder &tElem);
    tVoid vPushBack(const CabinVideoMixInfoHolder &tElem);

    tVoid vClearList();
    
    //notification handling not over processes only for application
    tBool bAddNotification(tVoid* pFunc, tU32 u32Event); 
    tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
	tBool bReloadDpElement(void);
};

#endif
