
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclAppHmi_Master.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LanguageCode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterLanguageCode::dp_tclAppHmi_MasterLanguageCode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLanguageCode,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MasterLanguageCode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LanguageCode",(tS32) 0x258360ab);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLanguageCode = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MasterLanguageCode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LanguageCode", (tS32)0x258360ab);
   (tVoid)myDpElem.bFillData((tVoid*)&tLanguageCode, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MasterLanguageCode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MasterLanguageCode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_MasterLanguageCode::tGetData() {
   vUpdate();
   return tLanguageCode;
};
tS32 dp_tclAppHmi_MasterLanguageCode::s32GetData(tU32& tLanguageCodeParam) { 
   vUpdate();
   tLanguageCodeParam = tLanguageCode;
   return _s32Status;
}
tS32 dp_tclAppHmi_MasterLanguageCode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LanguageCode", (tS32)0x258360ab);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MasterLanguageCode::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MasterLanguageCode::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MasterLanguageCode::s32SetData(tU32 &tLanguageCodeParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageCode,(tVoid*)&tLanguageCodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageCodeParam' in function 'dp_tclAppHmi_MasterLanguageCode::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_MasterLanguageCode::s32SetData(const tU32 &tLanguageCodeParam) {
   //init parameter
   (tVoid)memcpy(&tLanguageCode,(tVoid*)&tLanguageCodeParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLanguageCodeParam' in function 'dp_tclAppHmi_MasterLanguageCode::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MasterLanguageCode::u8GetData(tU32& tLanguageCodeParam) {  
   vUpdate();
   tLanguageCodeParam = tLanguageCode;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MasterLanguageCode::vSetData(tU32 &tLanguageCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageCode,(tVoid*)&tLanguageCodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLanguageCodeParam' in function 'dp_tclAppHmi_MasterLanguageCode::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_MasterLanguageCode::vSetData(const tU32 &tLanguageCodeParam) { 
   //init parameter
   (tVoid)memcpy(&tLanguageCode,(tVoid*)&tLanguageCodeParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLanguageCodeParam' in function 'dp_tclAppHmi_MasterLanguageCode::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_MasterLanguageCode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MasterLanguageCode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LanguageCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLanguageCode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LanguageCode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLanguageCode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LanguageCode", DP_U32_POOL_ID_APPHMI_MASTER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
   }
   else
   {
      fprintf(stdout,"Element LanguageCode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "dummy"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_Masterdummy::dp_tclAppHmi_Masterdummy(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tdummy,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_Masterdummy::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("dummy",(tS32) 0x13a84);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tdummy = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_Masterdummy::vStore(tVoid) {
   dp_tclBaseElement myDpElem("dummy", (tS32)0x13a84);
   (tVoid)myDpElem.bFillData((tVoid*)&tdummy, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_Masterdummy::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_Masterdummy::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_Masterdummy::tGetData() {
   vUpdate();
   return tdummy;
};
tS32 dp_tclAppHmi_Masterdummy::s32GetData(tU32& tdummyParam) { 
   vUpdate();
   tdummyParam = tdummy;
   return _s32Status;
}
tS32 dp_tclAppHmi_Masterdummy::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("dummy", (tS32)0x13a84);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_Masterdummy::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_Masterdummy::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_Masterdummy::s32SetData(tU32 &tdummyParam) {
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_Masterdummy::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_Masterdummy::s32SetData(const tU32 &tdummyParam) {
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_Masterdummy::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_Masterdummy::u8GetData(tU32& tdummyParam) {  
   vUpdate();
   tdummyParam = tdummy;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_Masterdummy::vSetData(tU32 &tdummyParam) { 
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_Masterdummy::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_Masterdummy::vSetData(const tU32 &tdummyParam) { 
   //init parameter
   (tVoid)memcpy(&tdummy,(tVoid*)&tdummyParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tdummyParam' in function 'dp_tclAppHmi_Masterdummy::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_Masterdummy::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_Masterdummy::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "dummy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_Masterdummy::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "dummy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_Masterdummy::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: dummy", DP_U32_POOL_ID_APPHMI_MASTER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
   }
   else
   {
      fprintf(stdout,"Element dummy has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastActiveCockpitAudioGadget"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::dp_tclAppHmi_MasterLastActiveCockpitAudioGadget(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastActiveCockpitAudioGadget,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastActiveCockpitAudioGadget",(tS32) 0x42fd2d33L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLastActiveCockpitAudioGadget = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastActiveCockpitAudioGadget", (tS32)0x42fd2d33L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastActiveCockpitAudioGadget, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::tGetData() {
   vUpdate();
   return tLastActiveCockpitAudioGadget;
};
tS32 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::s32GetData(tU32& tLastActiveCockpitAudioGadgetParam) { 
   vUpdate();
   tLastActiveCockpitAudioGadgetParam = tLastActiveCockpitAudioGadget;
   return _s32Status;
}
tS32 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastActiveCockpitAudioGadget", (tS32)0x42fd2d33L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::s32SetData(tU32 &tLastActiveCockpitAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCockpitAudioGadget,(tVoid*)&tLastActiveCockpitAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCockpitAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::s32SetData(const tU32 &tLastActiveCockpitAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCockpitAudioGadget,(tVoid*)&tLastActiveCockpitAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCockpitAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::u8GetData(tU32& tLastActiveCockpitAudioGadgetParam) {  
   vUpdate();
   tLastActiveCockpitAudioGadgetParam = tLastActiveCockpitAudioGadget;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(tU32 &tLastActiveCockpitAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCockpitAudioGadget,(tVoid*)&tLastActiveCockpitAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCockpitAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(const tU32 &tLastActiveCockpitAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCockpitAudioGadget,(tVoid*)&tLastActiveCockpitAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCockpitAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCockpitAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCockpitAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCockpitAudioGadget::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastActiveCockpitAudioGadget", DP_U32_POOL_ID_APPHMI_MASTER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
   }
   else
   {
      fprintf(stdout,"Element LastActiveCockpitAudioGadget has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastActiveCabinAAudioGadget"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::dp_tclAppHmi_MasterLastActiveCabinAAudioGadget(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastActiveCabinAAudioGadget,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastActiveCabinAAudioGadget",(tS32) 0x1fe77d08L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLastActiveCabinAAudioGadget = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastActiveCabinAAudioGadget", (tS32)0x1fe77d08L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastActiveCabinAAudioGadget, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::tGetData() {
   vUpdate();
   return tLastActiveCabinAAudioGadget;
};
tS32 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::s32GetData(tU32& tLastActiveCabinAAudioGadgetParam) { 
   vUpdate();
   tLastActiveCabinAAudioGadgetParam = tLastActiveCabinAAudioGadget;
   return _s32Status;
}
tS32 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastActiveCabinAAudioGadget", (tS32)0x1fe77d08L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::s32SetData(tU32 &tLastActiveCabinAAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinAAudioGadget,(tVoid*)&tLastActiveCabinAAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCabinAAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::s32SetData(const tU32 &tLastActiveCabinAAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinAAudioGadget,(tVoid*)&tLastActiveCabinAAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCabinAAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::u8GetData(tU32& tLastActiveCabinAAudioGadgetParam) {  
   vUpdate();
   tLastActiveCabinAAudioGadgetParam = tLastActiveCabinAAudioGadget;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(tU32 &tLastActiveCabinAAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinAAudioGadget,(tVoid*)&tLastActiveCabinAAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCabinAAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(const tU32 &tLastActiveCabinAAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinAAudioGadget,(tVoid*)&tLastActiveCabinAAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCabinAAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCabinAAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCabinAAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCabinAAudioGadget::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastActiveCabinAAudioGadget", DP_U32_POOL_ID_APPHMI_MASTER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
   }
   else
   {
      fprintf(stdout,"Element LastActiveCabinAAudioGadget has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "LastActiveCabinBAudioGadget"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::dp_tclAppHmi_MasterLastActiveCabinBAudioGadget(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLastActiveCabinBAudioGadget,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("LastActiveCabinBAudioGadget",(tS32) 0x22d08be5L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tLastActiveCabinBAudioGadget = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vStore(tVoid) {
   dp_tclBaseElement myDpElem("LastActiveCabinBAudioGadget", (tS32)0x22d08be5L);
   (tVoid)myDpElem.bFillData((tVoid*)&tLastActiveCabinBAudioGadget, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::s32GetStatus() const {return _s32Status;};
tU8   dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::tGetData() {
   vUpdate();
   return tLastActiveCabinBAudioGadget;
};
tS32 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::s32GetData(tU32& tLastActiveCabinBAudioGadgetParam) { 
   vUpdate();
   tLastActiveCabinBAudioGadgetParam = tLastActiveCabinBAudioGadget;
   return _s32Status;
}
tS32 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("LastActiveCabinBAudioGadget", (tS32)0x22d08be5L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::s32SetData(tU32 &tLastActiveCabinBAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinBAudioGadget,(tVoid*)&tLastActiveCabinBAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCabinBAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(tU32)' could be made const reference
tS32 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::s32SetData(const tU32 &tLastActiveCabinBAudioGadgetParam) {
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinBAudioGadget,(tVoid*)&tLastActiveCabinBAudioGadgetParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLastActiveCabinBAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::u8GetData(tU32& tLastActiveCabinBAudioGadgetParam) {  
   vUpdate();
   tLastActiveCabinBAudioGadgetParam = tLastActiveCabinBAudioGadget;
   return _u8DataStatus;
}
tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(tU32 &tLastActiveCabinBAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinBAudioGadget,(tVoid*)&tLastActiveCabinBAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCabinBAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(tU32)' could be made const reference
tVoid dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(const tU32 &tLastActiveCabinBAudioGadgetParam) { 
   //init parameter
   (tVoid)memcpy(&tLastActiveCabinBAudioGadget,(tVoid*)&tLastActiveCabinBAudioGadgetParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tLastActiveCabinBAudioGadgetParam' in function 'dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::vSetData(tU32)' could be made const reference
tU8   dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCabinBAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "LastActiveCabinBAudioGadget", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclAppHmi_MasterLastActiveCabinBAudioGadget::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: LastActiveCabinBAudioGadget", DP_U32_POOL_ID_APPHMI_MASTER);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
   }
   else
   {
      fprintf(stdout,"Element LastActiveCabinBAudioGadget has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CabinsActivityInfoDP"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterCabinsActivityInfoDP::dp_tclAppHmi_MasterCabinsActivityInfoDP(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 40;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclAppHmi_MasterCabinsActivityInfoDP::vStore() {
    dp_tclBaseElement myDpElem("CabinsActivityInfoDP", (tS32)0x787209e1);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(CabinActivityInfoDPHolder)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCabinsActivityInfoDP::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(CabinActivityInfoDPHolder));
                pCurPos += sizeof(CabinActivityInfoDPHolder);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(CabinActivityInfoDPHolder))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclAppHmi_MasterCabinsActivityInfoDP::vUpdate() {
   dp_tclBaseElement myDpElem("CabinsActivityInfoDP", (tS32)0x787209e1);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(CabinActivityInfoDPHolder)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(CabinActivityInfoDPHolder));
         CabinActivityInfoDPHolder* pBuffer = (CabinActivityInfoDPHolder*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclAppHmi_MasterCabinsActivityInfoDP::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclAppHmi_MasterCabinsActivityInfoDP::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclAppHmi_MasterCabinsActivityInfoDP::s32GetElem(tU32 u32NbElem, CabinActivityInfoDPHolder& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclAppHmi_MasterCabinsActivityInfoDP::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclAppHmi_MasterCabinsActivityInfoDP::vPushBack(CabinActivityInfoDPHolder &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclAppHmi_MasterCabinsActivityInfoDP::vPushBack(const CabinActivityInfoDPHolder &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclAppHmi_MasterCabinsActivityInfoDP::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclAppHmi_MasterCabinsActivityInfoDP::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "CabinsActivityInfoDP", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclAppHmi_MasterCabinsActivityInfoDP::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "CabinsActivityInfoDP", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclAppHmi_MasterCabinsActivityInfoDP::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CabinsActivityInfoDP", DP_U32_POOL_ID_APPHMI_MASTER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
		}
		else
		{
			fprintf(stdout,"Element CabinsActivityInfoDP has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "CabinVideoMixDP"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclAppHmi_MasterCabinVideoMixDP::dp_tclAppHmi_MasterCabinVideoMixDP(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 40;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclAppHmi_MasterCabinVideoMixDP::vStore() {
    dp_tclBaseElement myDpElem("CabinVideoMixDP", (tS32)0xd8e24906);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(CabinVideoMixInfoHolder)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListCabinVideoMixDP::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(CabinVideoMixInfoHolder));
                pCurPos += sizeof(CabinVideoMixInfoHolder);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(CabinVideoMixInfoHolder))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclAppHmi_MasterCabinVideoMixDP::vUpdate() {
   dp_tclBaseElement myDpElem("CabinVideoMixDP", (tS32)0xd8e24906);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_APPHMI_MASTER, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(CabinVideoMixInfoHolder)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(CabinVideoMixInfoHolder));
         CabinVideoMixInfoHolder* pBuffer = (CabinVideoMixInfoHolder*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclAppHmi_MasterCabinVideoMixDP::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclAppHmi_MasterCabinVideoMixDP::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclAppHmi_MasterCabinVideoMixDP::s32GetElem(tU32 u32NbElem, CabinVideoMixInfoHolder& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclAppHmi_MasterCabinVideoMixDP::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclAppHmi_MasterCabinVideoMixDP::vPushBack(CabinVideoMixInfoHolder &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclAppHmi_MasterCabinVideoMixDP::vPushBack(const CabinVideoMixInfoHolder &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclAppHmi_MasterCabinVideoMixDP::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclAppHmi_MasterCabinVideoMixDP::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_APPHMI_MASTER, "CabinVideoMixDP", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclAppHmi_MasterCabinVideoMixDP::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_APPHMI_MASTER, "CabinVideoMixDP", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclAppHmi_MasterCabinVideoMixDP::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: CabinVideoMixDP", DP_U32_POOL_ID_APPHMI_MASTER);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_APPHMI_MASTER);
		}
		else
		{
			fprintf(stdout,"Element CabinVideoMixDP has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 

