#ifndef _DP_FI_VEHFUNCPROFILE_H
#define _DP_FI_VEHFUNCPROFILE_H

extern tVoid vInitVehFuncProfile(tU8 u8Bank=DP_U8_NO_BANK_ACTION);



#ifndef DP_DATAPOOL_ID
#error("You have to set the define: 'DP_DATAPOOL_ID=OwnCCaID' e.g. 'DP_DATAPOOL_ID=0x0107' for CCA_C_U16_APP_AUDIO")
#endif






class dp_tclVehFuncProfileSettingGearShiftIndicator{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingGearShiftIndicator;
   
public:
   dp_tclVehFuncProfileSettingGearShiftIndicator(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingGearShiftIndicator() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingGearShiftIndicatorParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingGearShiftIndicatorParam);
   tS32  s32SetData(const tU8 &tSettingGearShiftIndicatorParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingGearShiftIndicatorParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingGearShiftIndicatorParam);
   tVoid vSetData(const tU8& tSettingGearShiftIndicatorParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingIkeyBuzzer{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingIkeyBuzzer;
   
public:
   dp_tclVehFuncProfileSettingIkeyBuzzer(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingIkeyBuzzer() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingIkeyBuzzerParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingIkeyBuzzerParam);
   tS32  s32SetData(const tU8 &tSettingIkeyBuzzerParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingIkeyBuzzerParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingIkeyBuzzerParam);
   tVoid vSetData(const tU8& tSettingIkeyBuzzerParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingFrontWiper{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFrontWiper;
   
public:
   dp_tclVehFuncProfileSettingFrontWiper(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingFrontWiper() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFrontWiperParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFrontWiperParam);
   tS32  s32SetData(const tU8 &tSettingFrontWiperParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFrontWiperParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFrontWiperParam);
   tVoid vSetData(const tU8& tSettingFrontWiperParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingMeterVolume{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingMeterVolume;
   
public:
   dp_tclVehFuncProfileSettingMeterVolume(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingMeterVolume() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingMeterVolumeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingMeterVolumeParam);
   tS32  s32SetData(const tU8 &tSettingMeterVolumeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingMeterVolumeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingMeterVolumeParam);
   tVoid vSetData(const tU8& tSettingMeterVolumeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingMotorwayFlashers{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingMotorwayFlashers;
   
public:
   dp_tclVehFuncProfileSettingMotorwayFlashers(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingMotorwayFlashers() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingMotorwayFlashersParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingMotorwayFlashersParam);
   tS32  s32SetData(const tU8 &tSettingMotorwayFlashersParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingMotorwayFlashersParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingMotorwayFlashersParam);
   tVoid vSetData(const tU8& tSettingMotorwayFlashersParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingFrontRearWiperDrop{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFrontRearWiperDrop;
   
public:
   dp_tclVehFuncProfileSettingFrontRearWiperDrop(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingFrontRearWiperDrop() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFrontRearWiperDropParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFrontRearWiperDropParam);
   tS32  s32SetData(const tU8 &tSettingFrontRearWiperDropParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFrontRearWiperDropParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFrontRearWiperDropParam);
   tVoid vSetData(const tU8& tSettingFrontRearWiperDropParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingSilentMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSilentMode;
   
public:
   dp_tclVehFuncProfileSettingSilentMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingSilentMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSilentModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSilentModeParam);
   tS32  s32SetData(const tU8 &tSettingSilentModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSilentModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSilentModeParam);
   tVoid vSetData(const tU8& tSettingSilentModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingAutoFolding{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAutoFolding;
   
public:
   dp_tclVehFuncProfileSettingAutoFolding(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingAutoFolding() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAutoFoldingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAutoFoldingParam);
   tS32  s32SetData(const tU8 &tSettingAutoFoldingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAutoFoldingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAutoFoldingParam);
   tVoid vSetData(const tU8& tSettingAutoFoldingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingFMH{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFMH;
   
public:
   dp_tclVehFuncProfileSettingFMH(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingFMH() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFMHParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFMHParam);
   tS32  s32SetData(const tU8 &tSettingFMHParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFMHParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFMHParam);
   tVoid vSetData(const tU8& tSettingFMHParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingFMHDuration{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingFMHDuration;
   
public:
   dp_tclVehFuncProfileSettingFMHDuration(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingFMHDuration() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingFMHDurationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingFMHDurationParam);
   tS32  s32SetData(const tU8 &tSettingFMHDurationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingFMHDurationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingFMHDurationParam);
   tVoid vSetData(const tU8& tSettingFMHDurationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingWGS{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingWGS;
   
public:
   dp_tclVehFuncProfileSettingWGS(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingWGS() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingWGSParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingWGSParam);
   tS32  s32SetData(const tU8 &tSettingWGSParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingWGSParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingWGSParam);
   tVoid vSetData(const tU8& tSettingWGSParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingAutoLock{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAutoLock;
   
public:
   dp_tclVehFuncProfileSettingAutoLock(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingAutoLock() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAutoLockParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAutoLockParam);
   tS32  s32SetData(const tU8 &tSettingAutoLockParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAutoLockParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAutoLockParam);
   tVoid vSetData(const tU8& tSettingAutoLockParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingWACandAPRUN{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingWACandAPRUN;
   
public:
   dp_tclVehFuncProfileSettingWACandAPRUN(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingWACandAPRUN() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingWACandAPRUNParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingWACandAPRUNParam);
   tS32  s32SetData(const tU8 &tSettingWACandAPRUNParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingWACandAPRUNParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingWACandAPRUNParam);
   tVoid vSetData(const tU8& tSettingWACandAPRUNParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingShockSensitivity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingShockSensitivity;
   
public:
   dp_tclVehFuncProfileSettingShockSensitivity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingShockSensitivity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingShockSensitivityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingShockSensitivityParam);
   tS32  s32SetData(const tU8 &tSettingShockSensitivityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingShockSensitivityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingShockSensitivityParam);
   tVoid vSetData(const tU8& tSettingShockSensitivityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingContinuousRecordLength{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingContinuousRecordLength;
   
public:
   dp_tclVehFuncProfileSettingContinuousRecordLength(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingContinuousRecordLength() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingContinuousRecordLengthParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingContinuousRecordLengthParam);
   tS32  s32SetData(const tU8 &tSettingContinuousRecordLengthParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingContinuousRecordLengthParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingContinuousRecordLengthParam);
   tVoid vSetData(const tU8& tSettingContinuousRecordLengthParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingCustomerRecordLength{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingCustomerRecordLength;
   
public:
   dp_tclVehFuncProfileSettingCustomerRecordLength(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingCustomerRecordLength() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingCustomerRecordLengthParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingCustomerRecordLengthParam);
   tS32  s32SetData(const tU8 &tSettingCustomerRecordLengthParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingCustomerRecordLengthParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingCustomerRecordLengthParam);
   tVoid vSetData(const tU8& tSettingCustomerRecordLengthParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingSoundRecord{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingSoundRecord;
   
public:
   dp_tclVehFuncProfileSettingSoundRecord(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingSoundRecord() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingSoundRecordParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingSoundRecordParam);
   tS32  s32SetData(const tU8 &tSettingSoundRecordParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingSoundRecordParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingSoundRecordParam);
   tVoid vSetData(const tU8& tSettingSoundRecordParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDrivingInfoRecord{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDrivingInfoRecord;
   
public:
   dp_tclVehFuncProfileSettingDrivingInfoRecord(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDrivingInfoRecord() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDrivingInfoRecordParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDrivingInfoRecordParam);
   tS32  s32SetData(const tU8 &tSettingDrivingInfoRecordParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDrivingInfoRecordParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDrivingInfoRecordParam);
   tVoid vSetData(const tU8& tSettingDrivingInfoRecordParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingLocationInfoRecord{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingLocationInfoRecord;
   
public:
   dp_tclVehFuncProfileSettingLocationInfoRecord(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingLocationInfoRecord() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingLocationInfoRecordParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingLocationInfoRecordParam);
   tS32  s32SetData(const tU8 &tSettingLocationInfoRecordParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingLocationInfoRecordParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingLocationInfoRecordParam);
   tVoid vSetData(const tU8& tSettingLocationInfoRecordParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverMassageActivation{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverMassageActivation;
   
public:
   dp_tclVehFuncProfileSettingDriverMassageActivation(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverMassageActivation() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverMassageActivationParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverMassageActivationParam);
   tS32  s32SetData(const tU8 &tSettingDriverMassageActivationParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverMassageActivationParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverMassageActivationParam);
   tVoid vSetData(const tU8& tSettingDriverMassageActivationParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingLDWSensibiltiy{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingLDWSensibiltiy;
   
public:
   dp_tclVehFuncProfileSettingLDWSensibiltiy(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingLDWSensibiltiy() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingLDWSensibiltiyParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingLDWSensibiltiyParam);
   tS32  s32SetData(const tU8 &tSettingLDWSensibiltiyParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingLDWSensibiltiyParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingLDWSensibiltiyParam);
   tVoid vSetData(const tU8& tSettingLDWSensibiltiyParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingLDWVibrationIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingLDWVibrationIntensity;
   
public:
   dp_tclVehFuncProfileSettingLDWVibrationIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingLDWVibrationIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingLDWVibrationIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingLDWVibrationIntensityParam);
   tS32  s32SetData(const tU8 &tSettingLDWVibrationIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingLDWVibrationIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingLDWVibrationIntensityParam);
   tVoid vSetData(const tU8& tSettingLDWVibrationIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingBSW{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingBSW;
   
public:
   dp_tclVehFuncProfileSettingBSW(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingBSW() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingBSWParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingBSWParam);
   tS32  s32SetData(const tU8 &tSettingBSWParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingBSWParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingBSWParam);
   tVoid vSetData(const tU8& tSettingBSWParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingAEB{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAEB;
   
public:
   dp_tclVehFuncProfileSettingAEB(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingAEB() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAEBParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAEBParam);
   tS32  s32SetData(const tU8 &tSettingAEBParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAEBParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAEBParam);
   tVoid vSetData(const tU8& tSettingAEBParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDW{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDW;
   
public:
   dp_tclVehFuncProfileSettingDW(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDW() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDWParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDWParam);
   tS32  s32SetData(const tU8 &tSettingDWParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDWParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDWParam);
   tVoid vSetData(const tU8& tSettingDWParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingOSPTSR{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingOSPTSR;
   
public:
   dp_tclVehFuncProfileSettingOSPTSR(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingOSPTSR() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingOSPTSRParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingOSPTSRParam);
   tS32  s32SetData(const tU8 &tSettingOSPTSRParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingOSPTSRParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingOSPTSRParam);
   tVoid vSetData(const tU8& tSettingOSPTSRParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingUTA{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingUTA;
   
public:
   dp_tclVehFuncProfileSettingUTA(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingUTA() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingUTAParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingUTAParam);
   tS32  s32SetData(const tU8 &tSettingUTAParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingUTAParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingUTAParam);
   tVoid vSetData(const tU8& tSettingUTAParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingIoniserAutoLaunch{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingIoniserAutoLaunch;
   
public:
   dp_tclVehFuncProfileSettingIoniserAutoLaunch(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingIoniserAutoLaunch() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingIoniserAutoLaunchParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingIoniserAutoLaunchParam);
   tS32  s32SetData(const tU8 &tSettingIoniserAutoLaunchParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingIoniserAutoLaunchParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingIoniserAutoLaunchParam);
   tVoid vSetData(const tU8& tSettingIoniserAutoLaunchParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingAQMIoniserMode{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAQMIoniserMode;
   
public:
   dp_tclVehFuncProfileSettingAQMIoniserMode(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingAQMIoniserMode() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAQMIoniserModeParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAQMIoniserModeParam);
   tS32  s32SetData(const tU8 &tSettingAQMIoniserModeParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAQMIoniserModeParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAQMIoniserModeParam);
   tVoid vSetData(const tU8& tSettingAQMIoniserModeParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingAirFreshener{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingAirFreshener;
   
public:
   dp_tclVehFuncProfileSettingAirFreshener(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingAirFreshener() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingAirFreshenerParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingAirFreshenerParam);
   tS32  s32SetData(const tU8 &tSettingAirFreshenerParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingAirFreshenerParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingAirFreshenerParam);
   tVoid vSetData(const tU8& tSettingAirFreshenerParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverMassageProgramState{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverMassageProgramState;
   
public:
   dp_tclVehFuncProfileSettingDriverMassageProgramState(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverMassageProgramState() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverMassageProgramStateParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverMassageProgramStateParam);
   tS32  s32SetData(const tU8 &tSettingDriverMassageProgramStateParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverMassageProgramStateParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverMassageProgramStateParam);
   tVoid vSetData(const tU8& tSettingDriverMassageProgramStateParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverMassageVelocity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverMassageVelocity;
   
public:
   dp_tclVehFuncProfileSettingDriverMassageVelocity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverMassageVelocity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverMassageVelocityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverMassageVelocityParam);
   tS32  s32SetData(const tU8 &tSettingDriverMassageVelocityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverMassageVelocityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverMassageVelocityParam);
   tVoid vSetData(const tU8& tSettingDriverMassageVelocityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverMassageIntensity{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverMassageIntensity;
   
public:
   dp_tclVehFuncProfileSettingDriverMassageIntensity(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverMassageIntensity() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverMassageIntensityParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverMassageIntensityParam);
   tS32  s32SetData(const tU8 &tSettingDriverMassageIntensityParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverMassageIntensityParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverMassageIntensityParam);
   tVoid vSetData(const tU8& tSettingDriverMassageIntensityParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverSeatMemo{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverSeatMemo;
   
public:
   dp_tclVehFuncProfileSettingDriverSeatMemo(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverSeatMemo() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverSeatMemoParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverSeatMemoParam);
   tS32  s32SetData(const tU8 &tSettingDriverSeatMemoParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverSeatMemoParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverSeatMemoParam);
   tVoid vSetData(const tU8& tSettingDriverSeatMemoParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverVentil{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverVentil;
   
public:
   dp_tclVehFuncProfileSettingDriverVentil(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverVentil() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverVentilParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverVentilParam);
   tS32  s32SetData(const tU8 &tSettingDriverVentilParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverVentilParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverVentilParam);
   tVoid vSetData(const tU8& tSettingDriverVentilParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

class dp_tclVehFuncProfileSettingDriverHeating{
private:
   tU16  _u16AccessId;
   tU16  _u16AccessType;
   tU8   _u8DataStatus;
   tS32  _s32Status;
   
   tVoid vUpdate(tVoid);
   tVoid vStore(tVoid);
   
   tU8 tSettingDriverHeating;
   
public:
   dp_tclVehFuncProfileSettingDriverHeating(tU16 DPid DP_DATAPOOL_ID);
   virtual ~dp_tclVehFuncProfileSettingDriverHeating() {};

   //current state of interface
   tS32  s32GetStatus() const;
   tU8   u8GetElementStatus() const;

   //read access for pool element 
   tU8 tGetData();
     
   tS32  s32GetDataRaw(tS8* pData, tU32 u32Len);
   tS32  s32GetData(tU8& tSettingDriverHeatingParam);
   tVoid operator>>(tU8& oParam);
   
   //write access for pool element 
   tS32  s32SetData(tU8 &tSettingDriverHeatingParam);
   tS32  s32SetData(const tU8 &tSettingDriverHeatingParam);
   tVoid operator<<(tU8 oParam);
   
   // do not use --> old interface
   tU8   u8GetData(tU8& tSettingDriverHeatingParam);
   tU8   u8GetStatus() const;
   tVoid vSetData(tU8& tSettingDriverHeatingParam);
   tVoid vSetData(const tU8& tSettingDriverHeatingParam);
   
   //notification handling not over processes only for application
   tBool bAddNotification(tVoid* pFunc, tU32 u32Event);
   tBool bRemoveNotification(tVoid* pFunc, tU32 u32Event);
   tBool bReloadDpElement(void);

};

#endif
