
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclVehFuncProfile.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingGearShiftIndicator"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingGearShiftIndicator::dp_tclVehFuncProfileSettingGearShiftIndicator(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingGearShiftIndicator,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingGearShiftIndicator",(tS32) 0xbbe2c6f8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingGearShiftIndicator = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingGearShiftIndicator", (tS32)0xbbe2c6f8);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingGearShiftIndicator, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingGearShiftIndicator::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingGearShiftIndicator::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingGearShiftIndicator::tGetData() {
   vUpdate();
   return tSettingGearShiftIndicator;
};
tS32 dp_tclVehFuncProfileSettingGearShiftIndicator::s32GetData(tU8& tSettingGearShiftIndicatorParam) { 
   vUpdate();
   tSettingGearShiftIndicatorParam = tSettingGearShiftIndicator;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingGearShiftIndicator::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingGearShiftIndicator", (tS32)0xbbe2c6f8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingGearShiftIndicator::s32SetData(tU8 &tSettingGearShiftIndicatorParam) {
   //init parameter
   (tVoid)memcpy(&tSettingGearShiftIndicator,(tVoid*)&tSettingGearShiftIndicatorParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingGearShiftIndicatorParam' in function 'dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingGearShiftIndicator::s32SetData(const tU8 &tSettingGearShiftIndicatorParam) {
   //init parameter
   (tVoid)memcpy(&tSettingGearShiftIndicator,(tVoid*)&tSettingGearShiftIndicatorParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingGearShiftIndicatorParam' in function 'dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingGearShiftIndicator::u8GetData(tU8& tSettingGearShiftIndicatorParam) {  
   vUpdate();
   tSettingGearShiftIndicatorParam = tSettingGearShiftIndicator;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(tU8 &tSettingGearShiftIndicatorParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingGearShiftIndicator,(tVoid*)&tSettingGearShiftIndicatorParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingGearShiftIndicatorParam' in function 'dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(const tU8 &tSettingGearShiftIndicatorParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingGearShiftIndicator,(tVoid*)&tSettingGearShiftIndicatorParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingGearShiftIndicatorParam' in function 'dp_tclVehFuncProfileSettingGearShiftIndicator::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingGearShiftIndicator::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingGearShiftIndicator::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingGearShiftIndicator", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingGearShiftIndicator::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingGearShiftIndicator", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingGearShiftIndicator::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingGearShiftIndicator", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingGearShiftIndicator has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingIkeyBuzzer"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingIkeyBuzzer::dp_tclVehFuncProfileSettingIkeyBuzzer(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingIkeyBuzzer,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingIkeyBuzzer",(tS32) 0xb6d5b1ba);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingIkeyBuzzer = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingIkeyBuzzer", (tS32)0xb6d5b1ba);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingIkeyBuzzer, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingIkeyBuzzer::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingIkeyBuzzer::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingIkeyBuzzer::tGetData() {
   vUpdate();
   return tSettingIkeyBuzzer;
};
tS32 dp_tclVehFuncProfileSettingIkeyBuzzer::s32GetData(tU8& tSettingIkeyBuzzerParam) { 
   vUpdate();
   tSettingIkeyBuzzerParam = tSettingIkeyBuzzer;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingIkeyBuzzer::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingIkeyBuzzer", (tS32)0xb6d5b1ba);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingIkeyBuzzer::s32SetData(tU8 &tSettingIkeyBuzzerParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIkeyBuzzer,(tVoid*)&tSettingIkeyBuzzerParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIkeyBuzzerParam' in function 'dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingIkeyBuzzer::s32SetData(const tU8 &tSettingIkeyBuzzerParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIkeyBuzzer,(tVoid*)&tSettingIkeyBuzzerParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIkeyBuzzerParam' in function 'dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingIkeyBuzzer::u8GetData(tU8& tSettingIkeyBuzzerParam) {  
   vUpdate();
   tSettingIkeyBuzzerParam = tSettingIkeyBuzzer;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(tU8 &tSettingIkeyBuzzerParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIkeyBuzzer,(tVoid*)&tSettingIkeyBuzzerParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIkeyBuzzerParam' in function 'dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(const tU8 &tSettingIkeyBuzzerParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIkeyBuzzer,(tVoid*)&tSettingIkeyBuzzerParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIkeyBuzzerParam' in function 'dp_tclVehFuncProfileSettingIkeyBuzzer::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingIkeyBuzzer::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingIkeyBuzzer::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingIkeyBuzzer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingIkeyBuzzer::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingIkeyBuzzer", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingIkeyBuzzer::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingIkeyBuzzer", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingIkeyBuzzer has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFrontWiper"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingFrontWiper::dp_tclVehFuncProfileSettingFrontWiper(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFrontWiper,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingFrontWiper::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFrontWiper",(tS32) 0xb6b15ee6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFrontWiper = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingFrontWiper::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFrontWiper", (tS32)0xb6b15ee6);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFrontWiper, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingFrontWiper::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingFrontWiper::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingFrontWiper::tGetData() {
   vUpdate();
   return tSettingFrontWiper;
};
tS32 dp_tclVehFuncProfileSettingFrontWiper::s32GetData(tU8& tSettingFrontWiperParam) { 
   vUpdate();
   tSettingFrontWiperParam = tSettingFrontWiper;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingFrontWiper::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFrontWiper", (tS32)0xb6b15ee6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingFrontWiper::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingFrontWiper::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingFrontWiper::s32SetData(tU8 &tSettingFrontWiperParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontWiper,(tVoid*)&tSettingFrontWiperParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontWiperParam' in function 'dp_tclVehFuncProfileSettingFrontWiper::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingFrontWiper::s32SetData(const tU8 &tSettingFrontWiperParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontWiper,(tVoid*)&tSettingFrontWiperParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontWiperParam' in function 'dp_tclVehFuncProfileSettingFrontWiper::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingFrontWiper::u8GetData(tU8& tSettingFrontWiperParam) {  
   vUpdate();
   tSettingFrontWiperParam = tSettingFrontWiper;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingFrontWiper::vSetData(tU8 &tSettingFrontWiperParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontWiper,(tVoid*)&tSettingFrontWiperParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontWiperParam' in function 'dp_tclVehFuncProfileSettingFrontWiper::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingFrontWiper::vSetData(const tU8 &tSettingFrontWiperParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontWiper,(tVoid*)&tSettingFrontWiperParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontWiperParam' in function 'dp_tclVehFuncProfileSettingFrontWiper::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingFrontWiper::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingFrontWiper::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFrontWiper", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFrontWiper::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFrontWiper", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFrontWiper::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFrontWiper", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingFrontWiper has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingMeterVolume"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingMeterVolume::dp_tclVehFuncProfileSettingMeterVolume(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingMeterVolume,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingMeterVolume::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingMeterVolume",(tS32) 0x94191c43);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingMeterVolume = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingMeterVolume::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingMeterVolume", (tS32)0x94191c43);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingMeterVolume, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingMeterVolume::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingMeterVolume::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingMeterVolume::tGetData() {
   vUpdate();
   return tSettingMeterVolume;
};
tS32 dp_tclVehFuncProfileSettingMeterVolume::s32GetData(tU8& tSettingMeterVolumeParam) { 
   vUpdate();
   tSettingMeterVolumeParam = tSettingMeterVolume;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingMeterVolume::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingMeterVolume", (tS32)0x94191c43);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingMeterVolume::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingMeterVolume::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingMeterVolume::s32SetData(tU8 &tSettingMeterVolumeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingMeterVolume,(tVoid*)&tSettingMeterVolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingMeterVolumeParam' in function 'dp_tclVehFuncProfileSettingMeterVolume::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingMeterVolume::s32SetData(const tU8 &tSettingMeterVolumeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingMeterVolume,(tVoid*)&tSettingMeterVolumeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingMeterVolumeParam' in function 'dp_tclVehFuncProfileSettingMeterVolume::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingMeterVolume::u8GetData(tU8& tSettingMeterVolumeParam) {  
   vUpdate();
   tSettingMeterVolumeParam = tSettingMeterVolume;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingMeterVolume::vSetData(tU8 &tSettingMeterVolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingMeterVolume,(tVoid*)&tSettingMeterVolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingMeterVolumeParam' in function 'dp_tclVehFuncProfileSettingMeterVolume::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingMeterVolume::vSetData(const tU8 &tSettingMeterVolumeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingMeterVolume,(tVoid*)&tSettingMeterVolumeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingMeterVolumeParam' in function 'dp_tclVehFuncProfileSettingMeterVolume::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingMeterVolume::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingMeterVolume::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingMeterVolume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingMeterVolume::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingMeterVolume", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingMeterVolume::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingMeterVolume", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingMeterVolume has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingMotorwayFlashers"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingMotorwayFlashers::dp_tclVehFuncProfileSettingMotorwayFlashers(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingMotorwayFlashers,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingMotorwayFlashers",(tS32) 0xafaffe18);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingMotorwayFlashers = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingMotorwayFlashers", (tS32)0xafaffe18);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingMotorwayFlashers, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingMotorwayFlashers::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingMotorwayFlashers::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingMotorwayFlashers::tGetData() {
   vUpdate();
   return tSettingMotorwayFlashers;
};
tS32 dp_tclVehFuncProfileSettingMotorwayFlashers::s32GetData(tU8& tSettingMotorwayFlashersParam) { 
   vUpdate();
   tSettingMotorwayFlashersParam = tSettingMotorwayFlashers;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingMotorwayFlashers::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingMotorwayFlashers", (tS32)0xafaffe18);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingMotorwayFlashers::s32SetData(tU8 &tSettingMotorwayFlashersParam) {
   //init parameter
   (tVoid)memcpy(&tSettingMotorwayFlashers,(tVoid*)&tSettingMotorwayFlashersParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingMotorwayFlashersParam' in function 'dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingMotorwayFlashers::s32SetData(const tU8 &tSettingMotorwayFlashersParam) {
   //init parameter
   (tVoid)memcpy(&tSettingMotorwayFlashers,(tVoid*)&tSettingMotorwayFlashersParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingMotorwayFlashersParam' in function 'dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingMotorwayFlashers::u8GetData(tU8& tSettingMotorwayFlashersParam) {  
   vUpdate();
   tSettingMotorwayFlashersParam = tSettingMotorwayFlashers;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(tU8 &tSettingMotorwayFlashersParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingMotorwayFlashers,(tVoid*)&tSettingMotorwayFlashersParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingMotorwayFlashersParam' in function 'dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(const tU8 &tSettingMotorwayFlashersParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingMotorwayFlashers,(tVoid*)&tSettingMotorwayFlashersParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingMotorwayFlashersParam' in function 'dp_tclVehFuncProfileSettingMotorwayFlashers::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingMotorwayFlashers::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingMotorwayFlashers::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingMotorwayFlashers", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingMotorwayFlashers::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingMotorwayFlashers", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingMotorwayFlashers::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingMotorwayFlashers", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingMotorwayFlashers has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFrontRearWiperDrop"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingFrontRearWiperDrop::dp_tclVehFuncProfileSettingFrontRearWiperDrop(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFrontRearWiperDrop,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFrontRearWiperDrop",(tS32) 0xd0931f7d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFrontRearWiperDrop = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFrontRearWiperDrop", (tS32)0xd0931f7d);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFrontRearWiperDrop, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingFrontRearWiperDrop::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingFrontRearWiperDrop::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingFrontRearWiperDrop::tGetData() {
   vUpdate();
   return tSettingFrontRearWiperDrop;
};
tS32 dp_tclVehFuncProfileSettingFrontRearWiperDrop::s32GetData(tU8& tSettingFrontRearWiperDropParam) { 
   vUpdate();
   tSettingFrontRearWiperDropParam = tSettingFrontRearWiperDrop;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingFrontRearWiperDrop::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFrontRearWiperDrop", (tS32)0xd0931f7d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingFrontRearWiperDrop::s32SetData(tU8 &tSettingFrontRearWiperDropParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontRearWiperDrop,(tVoid*)&tSettingFrontRearWiperDropParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontRearWiperDropParam' in function 'dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingFrontRearWiperDrop::s32SetData(const tU8 &tSettingFrontRearWiperDropParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFrontRearWiperDrop,(tVoid*)&tSettingFrontRearWiperDropParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFrontRearWiperDropParam' in function 'dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingFrontRearWiperDrop::u8GetData(tU8& tSettingFrontRearWiperDropParam) {  
   vUpdate();
   tSettingFrontRearWiperDropParam = tSettingFrontRearWiperDrop;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(tU8 &tSettingFrontRearWiperDropParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontRearWiperDrop,(tVoid*)&tSettingFrontRearWiperDropParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontRearWiperDropParam' in function 'dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(const tU8 &tSettingFrontRearWiperDropParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFrontRearWiperDrop,(tVoid*)&tSettingFrontRearWiperDropParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFrontRearWiperDropParam' in function 'dp_tclVehFuncProfileSettingFrontRearWiperDrop::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingFrontRearWiperDrop::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingFrontRearWiperDrop::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFrontRearWiperDrop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFrontRearWiperDrop::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFrontRearWiperDrop", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFrontRearWiperDrop::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFrontRearWiperDrop", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingFrontRearWiperDrop has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSilentMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingSilentMode::dp_tclVehFuncProfileSettingSilentMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSilentMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingSilentMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSilentMode",(tS32) 0xb7f95efe);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSilentMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingSilentMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSilentMode", (tS32)0xb7f95efe);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSilentMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingSilentMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingSilentMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingSilentMode::tGetData() {
   vUpdate();
   return tSettingSilentMode;
};
tS32 dp_tclVehFuncProfileSettingSilentMode::s32GetData(tU8& tSettingSilentModeParam) { 
   vUpdate();
   tSettingSilentModeParam = tSettingSilentMode;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingSilentMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSilentMode", (tS32)0xb7f95efe);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingSilentMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingSilentMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingSilentMode::s32SetData(tU8 &tSettingSilentModeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSilentMode,(tVoid*)&tSettingSilentModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSilentModeParam' in function 'dp_tclVehFuncProfileSettingSilentMode::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingSilentMode::s32SetData(const tU8 &tSettingSilentModeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSilentMode,(tVoid*)&tSettingSilentModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSilentModeParam' in function 'dp_tclVehFuncProfileSettingSilentMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingSilentMode::u8GetData(tU8& tSettingSilentModeParam) {  
   vUpdate();
   tSettingSilentModeParam = tSettingSilentMode;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingSilentMode::vSetData(tU8 &tSettingSilentModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSilentMode,(tVoid*)&tSettingSilentModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSilentModeParam' in function 'dp_tclVehFuncProfileSettingSilentMode::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingSilentMode::vSetData(const tU8 &tSettingSilentModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSilentMode,(tVoid*)&tSettingSilentModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSilentModeParam' in function 'dp_tclVehFuncProfileSettingSilentMode::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingSilentMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingSilentMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingSilentMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingSilentMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingSilentMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingSilentMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSilentMode", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingSilentMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAutoFolding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingAutoFolding::dp_tclVehFuncProfileSettingAutoFolding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAutoFolding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingAutoFolding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAutoFolding",(tS32) 0x8efc61ea);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAutoFolding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingAutoFolding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAutoFolding", (tS32)0x8efc61ea);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAutoFolding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingAutoFolding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingAutoFolding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingAutoFolding::tGetData() {
   vUpdate();
   return tSettingAutoFolding;
};
tS32 dp_tclVehFuncProfileSettingAutoFolding::s32GetData(tU8& tSettingAutoFoldingParam) { 
   vUpdate();
   tSettingAutoFoldingParam = tSettingAutoFolding;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingAutoFolding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAutoFolding", (tS32)0x8efc61ea);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingAutoFolding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingAutoFolding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingAutoFolding::s32SetData(tU8 &tSettingAutoFoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoFolding,(tVoid*)&tSettingAutoFoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoFoldingParam' in function 'dp_tclVehFuncProfileSettingAutoFolding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingAutoFolding::s32SetData(const tU8 &tSettingAutoFoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoFolding,(tVoid*)&tSettingAutoFoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoFoldingParam' in function 'dp_tclVehFuncProfileSettingAutoFolding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingAutoFolding::u8GetData(tU8& tSettingAutoFoldingParam) {  
   vUpdate();
   tSettingAutoFoldingParam = tSettingAutoFolding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingAutoFolding::vSetData(tU8 &tSettingAutoFoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoFolding,(tVoid*)&tSettingAutoFoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoFoldingParam' in function 'dp_tclVehFuncProfileSettingAutoFolding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingAutoFolding::vSetData(const tU8 &tSettingAutoFoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoFolding,(tVoid*)&tSettingAutoFoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoFoldingParam' in function 'dp_tclVehFuncProfileSettingAutoFolding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingAutoFolding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingAutoFolding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAutoFolding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAutoFolding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAutoFolding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAutoFolding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAutoFolding", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingAutoFolding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFMH"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingFMH::dp_tclVehFuncProfileSettingFMH(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFMH,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingFMH::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFMH",(tS32) 0xcafd331);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFMH = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingFMH::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFMH", (tS32)0xcafd331);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFMH, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingFMH::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingFMH::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingFMH::tGetData() {
   vUpdate();
   return tSettingFMH;
};
tS32 dp_tclVehFuncProfileSettingFMH::s32GetData(tU8& tSettingFMHParam) { 
   vUpdate();
   tSettingFMHParam = tSettingFMH;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingFMH::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFMH", (tS32)0xcafd331);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingFMH::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingFMH::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingFMH::s32SetData(tU8 &tSettingFMHParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFMH,(tVoid*)&tSettingFMHParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFMHParam' in function 'dp_tclVehFuncProfileSettingFMH::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingFMH::s32SetData(const tU8 &tSettingFMHParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFMH,(tVoid*)&tSettingFMHParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFMHParam' in function 'dp_tclVehFuncProfileSettingFMH::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingFMH::u8GetData(tU8& tSettingFMHParam) {  
   vUpdate();
   tSettingFMHParam = tSettingFMH;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingFMH::vSetData(tU8 &tSettingFMHParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFMH,(tVoid*)&tSettingFMHParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFMHParam' in function 'dp_tclVehFuncProfileSettingFMH::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingFMH::vSetData(const tU8 &tSettingFMHParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFMH,(tVoid*)&tSettingFMHParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFMHParam' in function 'dp_tclVehFuncProfileSettingFMH::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingFMH::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingFMH::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFMH", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFMH::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFMH", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFMH::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFMH", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingFMH has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingFMHDuration"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingFMHDuration::dp_tclVehFuncProfileSettingFMHDuration(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingFMHDuration,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingFMHDuration::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingFMHDuration",(tS32) 0x8c0f1a0b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingFMHDuration = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingFMHDuration::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingFMHDuration", (tS32)0x8c0f1a0b);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingFMHDuration, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingFMHDuration::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingFMHDuration::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingFMHDuration::tGetData() {
   vUpdate();
   return tSettingFMHDuration;
};
tS32 dp_tclVehFuncProfileSettingFMHDuration::s32GetData(tU8& tSettingFMHDurationParam) { 
   vUpdate();
   tSettingFMHDurationParam = tSettingFMHDuration;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingFMHDuration::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingFMHDuration", (tS32)0x8c0f1a0b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingFMHDuration::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingFMHDuration::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingFMHDuration::s32SetData(tU8 &tSettingFMHDurationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFMHDuration,(tVoid*)&tSettingFMHDurationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFMHDurationParam' in function 'dp_tclVehFuncProfileSettingFMHDuration::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingFMHDuration::s32SetData(const tU8 &tSettingFMHDurationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingFMHDuration,(tVoid*)&tSettingFMHDurationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingFMHDurationParam' in function 'dp_tclVehFuncProfileSettingFMHDuration::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingFMHDuration::u8GetData(tU8& tSettingFMHDurationParam) {  
   vUpdate();
   tSettingFMHDurationParam = tSettingFMHDuration;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingFMHDuration::vSetData(tU8 &tSettingFMHDurationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFMHDuration,(tVoid*)&tSettingFMHDurationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFMHDurationParam' in function 'dp_tclVehFuncProfileSettingFMHDuration::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingFMHDuration::vSetData(const tU8 &tSettingFMHDurationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingFMHDuration,(tVoid*)&tSettingFMHDurationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingFMHDurationParam' in function 'dp_tclVehFuncProfileSettingFMHDuration::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingFMHDuration::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingFMHDuration::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFMHDuration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFMHDuration::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingFMHDuration", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingFMHDuration::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingFMHDuration", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingFMHDuration has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingWGS"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingWGS::dp_tclVehFuncProfileSettingWGS(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingWGS,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingWGS::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingWGS",(tS32) 0xcafd4c7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingWGS = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingWGS::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingWGS", (tS32)0xcafd4c7);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingWGS, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingWGS::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingWGS::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingWGS::tGetData() {
   vUpdate();
   return tSettingWGS;
};
tS32 dp_tclVehFuncProfileSettingWGS::s32GetData(tU8& tSettingWGSParam) { 
   vUpdate();
   tSettingWGSParam = tSettingWGS;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingWGS::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingWGS", (tS32)0xcafd4c7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingWGS::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingWGS::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingWGS::s32SetData(tU8 &tSettingWGSParam) {
   //init parameter
   (tVoid)memcpy(&tSettingWGS,(tVoid*)&tSettingWGSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingWGSParam' in function 'dp_tclVehFuncProfileSettingWGS::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingWGS::s32SetData(const tU8 &tSettingWGSParam) {
   //init parameter
   (tVoid)memcpy(&tSettingWGS,(tVoid*)&tSettingWGSParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingWGSParam' in function 'dp_tclVehFuncProfileSettingWGS::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingWGS::u8GetData(tU8& tSettingWGSParam) {  
   vUpdate();
   tSettingWGSParam = tSettingWGS;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingWGS::vSetData(tU8 &tSettingWGSParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingWGS,(tVoid*)&tSettingWGSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingWGSParam' in function 'dp_tclVehFuncProfileSettingWGS::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingWGS::vSetData(const tU8 &tSettingWGSParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingWGS,(tVoid*)&tSettingWGSParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingWGSParam' in function 'dp_tclVehFuncProfileSettingWGS::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingWGS::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingWGS::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingWGS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingWGS::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingWGS", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingWGS::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingWGS", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingWGS has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAutoLock"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingAutoLock::dp_tclVehFuncProfileSettingAutoLock(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAutoLock,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingAutoLock::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAutoLock",(tS32) 0xde53f314);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAutoLock = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingAutoLock::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAutoLock", (tS32)0xde53f314);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAutoLock, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingAutoLock::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingAutoLock::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingAutoLock::tGetData() {
   vUpdate();
   return tSettingAutoLock;
};
tS32 dp_tclVehFuncProfileSettingAutoLock::s32GetData(tU8& tSettingAutoLockParam) { 
   vUpdate();
   tSettingAutoLockParam = tSettingAutoLock;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingAutoLock::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAutoLock", (tS32)0xde53f314);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingAutoLock::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingAutoLock::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingAutoLock::s32SetData(tU8 &tSettingAutoLockParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoLock,(tVoid*)&tSettingAutoLockParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoLockParam' in function 'dp_tclVehFuncProfileSettingAutoLock::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingAutoLock::s32SetData(const tU8 &tSettingAutoLockParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoLock,(tVoid*)&tSettingAutoLockParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoLockParam' in function 'dp_tclVehFuncProfileSettingAutoLock::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingAutoLock::u8GetData(tU8& tSettingAutoLockParam) {  
   vUpdate();
   tSettingAutoLockParam = tSettingAutoLock;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingAutoLock::vSetData(tU8 &tSettingAutoLockParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoLock,(tVoid*)&tSettingAutoLockParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoLockParam' in function 'dp_tclVehFuncProfileSettingAutoLock::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingAutoLock::vSetData(const tU8 &tSettingAutoLockParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoLock,(tVoid*)&tSettingAutoLockParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoLockParam' in function 'dp_tclVehFuncProfileSettingAutoLock::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingAutoLock::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingAutoLock::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAutoLock", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAutoLock::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAutoLock", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAutoLock::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAutoLock", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingAutoLock has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingWACandAPRUN"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingWACandAPRUN::dp_tclVehFuncProfileSettingWACandAPRUN(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingWACandAPRUN,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingWACandAPRUN::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingWACandAPRUN",(tS32) 0x9490b7d2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingWACandAPRUN = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingWACandAPRUN::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingWACandAPRUN", (tS32)0x9490b7d2);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingWACandAPRUN, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingWACandAPRUN::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingWACandAPRUN::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingWACandAPRUN::tGetData() {
   vUpdate();
   return tSettingWACandAPRUN;
};
tS32 dp_tclVehFuncProfileSettingWACandAPRUN::s32GetData(tU8& tSettingWACandAPRUNParam) { 
   vUpdate();
   tSettingWACandAPRUNParam = tSettingWACandAPRUN;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingWACandAPRUN::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingWACandAPRUN", (tS32)0x9490b7d2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingWACandAPRUN::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingWACandAPRUN::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingWACandAPRUN::s32SetData(tU8 &tSettingWACandAPRUNParam) {
   //init parameter
   (tVoid)memcpy(&tSettingWACandAPRUN,(tVoid*)&tSettingWACandAPRUNParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingWACandAPRUNParam' in function 'dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingWACandAPRUN::s32SetData(const tU8 &tSettingWACandAPRUNParam) {
   //init parameter
   (tVoid)memcpy(&tSettingWACandAPRUN,(tVoid*)&tSettingWACandAPRUNParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingWACandAPRUNParam' in function 'dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingWACandAPRUN::u8GetData(tU8& tSettingWACandAPRUNParam) {  
   vUpdate();
   tSettingWACandAPRUNParam = tSettingWACandAPRUN;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(tU8 &tSettingWACandAPRUNParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingWACandAPRUN,(tVoid*)&tSettingWACandAPRUNParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingWACandAPRUNParam' in function 'dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(const tU8 &tSettingWACandAPRUNParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingWACandAPRUN,(tVoid*)&tSettingWACandAPRUNParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingWACandAPRUNParam' in function 'dp_tclVehFuncProfileSettingWACandAPRUN::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingWACandAPRUN::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingWACandAPRUN::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingWACandAPRUN", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingWACandAPRUN::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingWACandAPRUN", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingWACandAPRUN::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingWACandAPRUN", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingWACandAPRUN has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingShockSensitivity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingShockSensitivity::dp_tclVehFuncProfileSettingShockSensitivity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingShockSensitivity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingShockSensitivity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingShockSensitivity",(tS32) 0x1bb5c2c9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingShockSensitivity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingShockSensitivity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingShockSensitivity", (tS32)0x1bb5c2c9);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingShockSensitivity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingShockSensitivity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingShockSensitivity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingShockSensitivity::tGetData() {
   vUpdate();
   return tSettingShockSensitivity;
};
tS32 dp_tclVehFuncProfileSettingShockSensitivity::s32GetData(tU8& tSettingShockSensitivityParam) { 
   vUpdate();
   tSettingShockSensitivityParam = tSettingShockSensitivity;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingShockSensitivity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingShockSensitivity", (tS32)0x1bb5c2c9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingShockSensitivity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingShockSensitivity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingShockSensitivity::s32SetData(tU8 &tSettingShockSensitivityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingShockSensitivity,(tVoid*)&tSettingShockSensitivityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingShockSensitivityParam' in function 'dp_tclVehFuncProfileSettingShockSensitivity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingShockSensitivity::s32SetData(const tU8 &tSettingShockSensitivityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingShockSensitivity,(tVoid*)&tSettingShockSensitivityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingShockSensitivityParam' in function 'dp_tclVehFuncProfileSettingShockSensitivity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingShockSensitivity::u8GetData(tU8& tSettingShockSensitivityParam) {  
   vUpdate();
   tSettingShockSensitivityParam = tSettingShockSensitivity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingShockSensitivity::vSetData(tU8 &tSettingShockSensitivityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingShockSensitivity,(tVoid*)&tSettingShockSensitivityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingShockSensitivityParam' in function 'dp_tclVehFuncProfileSettingShockSensitivity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingShockSensitivity::vSetData(const tU8 &tSettingShockSensitivityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingShockSensitivity,(tVoid*)&tSettingShockSensitivityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingShockSensitivityParam' in function 'dp_tclVehFuncProfileSettingShockSensitivity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingShockSensitivity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingShockSensitivity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingShockSensitivity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingShockSensitivity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingShockSensitivity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingShockSensitivity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingShockSensitivity", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingShockSensitivity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingContinuousRecordLength"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingContinuousRecordLength::dp_tclVehFuncProfileSettingContinuousRecordLength(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingContinuousRecordLength,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingContinuousRecordLength",(tS32) 0x9ca0a956L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingContinuousRecordLength = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingContinuousRecordLength", (tS32)0x9ca0a956L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingContinuousRecordLength, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingContinuousRecordLength::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingContinuousRecordLength::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingContinuousRecordLength::tGetData() {
   vUpdate();
   return tSettingContinuousRecordLength;
};
tS32 dp_tclVehFuncProfileSettingContinuousRecordLength::s32GetData(tU8& tSettingContinuousRecordLengthParam) { 
   vUpdate();
   tSettingContinuousRecordLengthParam = tSettingContinuousRecordLength;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingContinuousRecordLength::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingContinuousRecordLength", (tS32)0x9ca0a956L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingContinuousRecordLength::s32SetData(tU8 &tSettingContinuousRecordLengthParam) {
   //init parameter
   (tVoid)memcpy(&tSettingContinuousRecordLength,(tVoid*)&tSettingContinuousRecordLengthParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingContinuousRecordLengthParam' in function 'dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingContinuousRecordLength::s32SetData(const tU8 &tSettingContinuousRecordLengthParam) {
   //init parameter
   (tVoid)memcpy(&tSettingContinuousRecordLength,(tVoid*)&tSettingContinuousRecordLengthParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingContinuousRecordLengthParam' in function 'dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingContinuousRecordLength::u8GetData(tU8& tSettingContinuousRecordLengthParam) {  
   vUpdate();
   tSettingContinuousRecordLengthParam = tSettingContinuousRecordLength;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(tU8 &tSettingContinuousRecordLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingContinuousRecordLength,(tVoid*)&tSettingContinuousRecordLengthParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingContinuousRecordLengthParam' in function 'dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(const tU8 &tSettingContinuousRecordLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingContinuousRecordLength,(tVoid*)&tSettingContinuousRecordLengthParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingContinuousRecordLengthParam' in function 'dp_tclVehFuncProfileSettingContinuousRecordLength::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingContinuousRecordLength::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingContinuousRecordLength::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingContinuousRecordLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingContinuousRecordLength::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingContinuousRecordLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingContinuousRecordLength::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingContinuousRecordLength", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingContinuousRecordLength has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingCustomerRecordLength"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingCustomerRecordLength::dp_tclVehFuncProfileSettingCustomerRecordLength(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingCustomerRecordLength,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingCustomerRecordLength",(tS32) 0x6834dd99L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingCustomerRecordLength = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingCustomerRecordLength", (tS32)0x6834dd99L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingCustomerRecordLength, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingCustomerRecordLength::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingCustomerRecordLength::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingCustomerRecordLength::tGetData() {
   vUpdate();
   return tSettingCustomerRecordLength;
};
tS32 dp_tclVehFuncProfileSettingCustomerRecordLength::s32GetData(tU8& tSettingCustomerRecordLengthParam) { 
   vUpdate();
   tSettingCustomerRecordLengthParam = tSettingCustomerRecordLength;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingCustomerRecordLength::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingCustomerRecordLength", (tS32)0x6834dd99L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingCustomerRecordLength::s32SetData(tU8 &tSettingCustomerRecordLengthParam) {
   //init parameter
   (tVoid)memcpy(&tSettingCustomerRecordLength,(tVoid*)&tSettingCustomerRecordLengthParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingCustomerRecordLengthParam' in function 'dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingCustomerRecordLength::s32SetData(const tU8 &tSettingCustomerRecordLengthParam) {
   //init parameter
   (tVoid)memcpy(&tSettingCustomerRecordLength,(tVoid*)&tSettingCustomerRecordLengthParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingCustomerRecordLengthParam' in function 'dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingCustomerRecordLength::u8GetData(tU8& tSettingCustomerRecordLengthParam) {  
   vUpdate();
   tSettingCustomerRecordLengthParam = tSettingCustomerRecordLength;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(tU8 &tSettingCustomerRecordLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingCustomerRecordLength,(tVoid*)&tSettingCustomerRecordLengthParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingCustomerRecordLengthParam' in function 'dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(const tU8 &tSettingCustomerRecordLengthParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingCustomerRecordLength,(tVoid*)&tSettingCustomerRecordLengthParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingCustomerRecordLengthParam' in function 'dp_tclVehFuncProfileSettingCustomerRecordLength::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingCustomerRecordLength::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingCustomerRecordLength::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingCustomerRecordLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingCustomerRecordLength::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingCustomerRecordLength", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingCustomerRecordLength::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingCustomerRecordLength", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingCustomerRecordLength has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSoundRecord"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingSoundRecord::dp_tclVehFuncProfileSettingSoundRecord(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSoundRecord,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingSoundRecord::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSoundRecord",(tS32) 0x98ce3fe2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSoundRecord = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingSoundRecord::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSoundRecord", (tS32)0x98ce3fe2);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSoundRecord, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingSoundRecord::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingSoundRecord::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingSoundRecord::tGetData() {
   vUpdate();
   return tSettingSoundRecord;
};
tS32 dp_tclVehFuncProfileSettingSoundRecord::s32GetData(tU8& tSettingSoundRecordParam) { 
   vUpdate();
   tSettingSoundRecordParam = tSettingSoundRecord;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingSoundRecord::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSoundRecord", (tS32)0x98ce3fe2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingSoundRecord::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingSoundRecord::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingSoundRecord::s32SetData(tU8 &tSettingSoundRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSoundRecord,(tVoid*)&tSettingSoundRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSoundRecordParam' in function 'dp_tclVehFuncProfileSettingSoundRecord::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingSoundRecord::s32SetData(const tU8 &tSettingSoundRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSoundRecord,(tVoid*)&tSettingSoundRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSoundRecordParam' in function 'dp_tclVehFuncProfileSettingSoundRecord::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingSoundRecord::u8GetData(tU8& tSettingSoundRecordParam) {  
   vUpdate();
   tSettingSoundRecordParam = tSettingSoundRecord;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingSoundRecord::vSetData(tU8 &tSettingSoundRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSoundRecord,(tVoid*)&tSettingSoundRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSoundRecordParam' in function 'dp_tclVehFuncProfileSettingSoundRecord::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingSoundRecord::vSetData(const tU8 &tSettingSoundRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSoundRecord,(tVoid*)&tSettingSoundRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSoundRecordParam' in function 'dp_tclVehFuncProfileSettingSoundRecord::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingSoundRecord::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingSoundRecord::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingSoundRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingSoundRecord::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingSoundRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingSoundRecord::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSoundRecord", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingSoundRecord has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDrivingInfoRecord"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDrivingInfoRecord::dp_tclVehFuncProfileSettingDrivingInfoRecord(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDrivingInfoRecord,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDrivingInfoRecord",(tS32) 0xbe13a538);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDrivingInfoRecord = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDrivingInfoRecord", (tS32)0xbe13a538);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDrivingInfoRecord, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDrivingInfoRecord::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDrivingInfoRecord::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDrivingInfoRecord::tGetData() {
   vUpdate();
   return tSettingDrivingInfoRecord;
};
tS32 dp_tclVehFuncProfileSettingDrivingInfoRecord::s32GetData(tU8& tSettingDrivingInfoRecordParam) { 
   vUpdate();
   tSettingDrivingInfoRecordParam = tSettingDrivingInfoRecord;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDrivingInfoRecord::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDrivingInfoRecord", (tS32)0xbe13a538);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDrivingInfoRecord::s32SetData(tU8 &tSettingDrivingInfoRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDrivingInfoRecord,(tVoid*)&tSettingDrivingInfoRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDrivingInfoRecordParam' in function 'dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDrivingInfoRecord::s32SetData(const tU8 &tSettingDrivingInfoRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDrivingInfoRecord,(tVoid*)&tSettingDrivingInfoRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDrivingInfoRecordParam' in function 'dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDrivingInfoRecord::u8GetData(tU8& tSettingDrivingInfoRecordParam) {  
   vUpdate();
   tSettingDrivingInfoRecordParam = tSettingDrivingInfoRecord;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(tU8 &tSettingDrivingInfoRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDrivingInfoRecord,(tVoid*)&tSettingDrivingInfoRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDrivingInfoRecordParam' in function 'dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(const tU8 &tSettingDrivingInfoRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDrivingInfoRecord,(tVoid*)&tSettingDrivingInfoRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDrivingInfoRecordParam' in function 'dp_tclVehFuncProfileSettingDrivingInfoRecord::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDrivingInfoRecord::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDrivingInfoRecord::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDrivingInfoRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDrivingInfoRecord::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDrivingInfoRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDrivingInfoRecord::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDrivingInfoRecord", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDrivingInfoRecord has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingLocationInfoRecord"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingLocationInfoRecord::dp_tclVehFuncProfileSettingLocationInfoRecord(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingLocationInfoRecord,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingLocationInfoRecord",(tS32) 0xbe01ee9e);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingLocationInfoRecord = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingLocationInfoRecord", (tS32)0xbe01ee9e);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingLocationInfoRecord, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingLocationInfoRecord::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingLocationInfoRecord::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingLocationInfoRecord::tGetData() {
   vUpdate();
   return tSettingLocationInfoRecord;
};
tS32 dp_tclVehFuncProfileSettingLocationInfoRecord::s32GetData(tU8& tSettingLocationInfoRecordParam) { 
   vUpdate();
   tSettingLocationInfoRecordParam = tSettingLocationInfoRecord;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingLocationInfoRecord::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingLocationInfoRecord", (tS32)0xbe01ee9e);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingLocationInfoRecord::s32SetData(tU8 &tSettingLocationInfoRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLocationInfoRecord,(tVoid*)&tSettingLocationInfoRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLocationInfoRecordParam' in function 'dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingLocationInfoRecord::s32SetData(const tU8 &tSettingLocationInfoRecordParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLocationInfoRecord,(tVoid*)&tSettingLocationInfoRecordParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLocationInfoRecordParam' in function 'dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingLocationInfoRecord::u8GetData(tU8& tSettingLocationInfoRecordParam) {  
   vUpdate();
   tSettingLocationInfoRecordParam = tSettingLocationInfoRecord;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(tU8 &tSettingLocationInfoRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLocationInfoRecord,(tVoid*)&tSettingLocationInfoRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLocationInfoRecordParam' in function 'dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(const tU8 &tSettingLocationInfoRecordParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLocationInfoRecord,(tVoid*)&tSettingLocationInfoRecordParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLocationInfoRecordParam' in function 'dp_tclVehFuncProfileSettingLocationInfoRecord::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingLocationInfoRecord::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingLocationInfoRecord::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLocationInfoRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLocationInfoRecord::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLocationInfoRecord", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLocationInfoRecord::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingLocationInfoRecord", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingLocationInfoRecord has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverMassageActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverMassageActivation::dp_tclVehFuncProfileSettingDriverMassageActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverMassageActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverMassageActivation",(tS32) 0x3e7aae65L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverMassageActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverMassageActivation", (tS32)0x3e7aae65L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverMassageActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverMassageActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverMassageActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverMassageActivation::tGetData() {
   vUpdate();
   return tSettingDriverMassageActivation;
};
tS32 dp_tclVehFuncProfileSettingDriverMassageActivation::s32GetData(tU8& tSettingDriverMassageActivationParam) { 
   vUpdate();
   tSettingDriverMassageActivationParam = tSettingDriverMassageActivation;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverMassageActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverMassageActivation", (tS32)0x3e7aae65L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverMassageActivation::s32SetData(tU8 &tSettingDriverMassageActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivation,(tVoid*)&tSettingDriverMassageActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageActivationParam' in function 'dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverMassageActivation::s32SetData(const tU8 &tSettingDriverMassageActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivation,(tVoid*)&tSettingDriverMassageActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageActivationParam' in function 'dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverMassageActivation::u8GetData(tU8& tSettingDriverMassageActivationParam) {  
   vUpdate();
   tSettingDriverMassageActivationParam = tSettingDriverMassageActivation;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(tU8 &tSettingDriverMassageActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivation,(tVoid*)&tSettingDriverMassageActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageActivationParam' in function 'dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(const tU8 &tSettingDriverMassageActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivation,(tVoid*)&tSettingDriverMassageActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageActivationParam' in function 'dp_tclVehFuncProfileSettingDriverMassageActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverMassageActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverMassageActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverMassageActivation", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverMassageActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingLDWSensibiltiy"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingLDWSensibiltiy::dp_tclVehFuncProfileSettingLDWSensibiltiy(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingLDWSensibiltiy,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingLDWSensibiltiy",(tS32) 0xc777ac48);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingLDWSensibiltiy = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingLDWSensibiltiy", (tS32)0xc777ac48);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingLDWSensibiltiy, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingLDWSensibiltiy::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingLDWSensibiltiy::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingLDWSensibiltiy::tGetData() {
   vUpdate();
   return tSettingLDWSensibiltiy;
};
tS32 dp_tclVehFuncProfileSettingLDWSensibiltiy::s32GetData(tU8& tSettingLDWSensibiltiyParam) { 
   vUpdate();
   tSettingLDWSensibiltiyParam = tSettingLDWSensibiltiy;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingLDWSensibiltiy::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingLDWSensibiltiy", (tS32)0xc777ac48);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingLDWSensibiltiy::s32SetData(tU8 &tSettingLDWSensibiltiyParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLDWSensibiltiy,(tVoid*)&tSettingLDWSensibiltiyParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLDWSensibiltiyParam' in function 'dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingLDWSensibiltiy::s32SetData(const tU8 &tSettingLDWSensibiltiyParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLDWSensibiltiy,(tVoid*)&tSettingLDWSensibiltiyParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLDWSensibiltiyParam' in function 'dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingLDWSensibiltiy::u8GetData(tU8& tSettingLDWSensibiltiyParam) {  
   vUpdate();
   tSettingLDWSensibiltiyParam = tSettingLDWSensibiltiy;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(tU8 &tSettingLDWSensibiltiyParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLDWSensibiltiy,(tVoid*)&tSettingLDWSensibiltiyParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLDWSensibiltiyParam' in function 'dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(const tU8 &tSettingLDWSensibiltiyParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLDWSensibiltiy,(tVoid*)&tSettingLDWSensibiltiyParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLDWSensibiltiyParam' in function 'dp_tclVehFuncProfileSettingLDWSensibiltiy::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingLDWSensibiltiy::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingLDWSensibiltiy::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLDWSensibiltiy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLDWSensibiltiy::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLDWSensibiltiy", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLDWSensibiltiy::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingLDWSensibiltiy", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingLDWSensibiltiy has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingLDWVibrationIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingLDWVibrationIntensity::dp_tclVehFuncProfileSettingLDWVibrationIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingLDWVibrationIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingLDWVibrationIntensity",(tS32) 0xb8db6eaeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingLDWVibrationIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingLDWVibrationIntensity", (tS32)0xb8db6eaeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingLDWVibrationIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingLDWVibrationIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingLDWVibrationIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingLDWVibrationIntensity::tGetData() {
   vUpdate();
   return tSettingLDWVibrationIntensity;
};
tS32 dp_tclVehFuncProfileSettingLDWVibrationIntensity::s32GetData(tU8& tSettingLDWVibrationIntensityParam) { 
   vUpdate();
   tSettingLDWVibrationIntensityParam = tSettingLDWVibrationIntensity;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingLDWVibrationIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingLDWVibrationIntensity", (tS32)0xb8db6eaeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingLDWVibrationIntensity::s32SetData(tU8 &tSettingLDWVibrationIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLDWVibrationIntensity,(tVoid*)&tSettingLDWVibrationIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLDWVibrationIntensityParam' in function 'dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingLDWVibrationIntensity::s32SetData(const tU8 &tSettingLDWVibrationIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLDWVibrationIntensity,(tVoid*)&tSettingLDWVibrationIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLDWVibrationIntensityParam' in function 'dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingLDWVibrationIntensity::u8GetData(tU8& tSettingLDWVibrationIntensityParam) {  
   vUpdate();
   tSettingLDWVibrationIntensityParam = tSettingLDWVibrationIntensity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(tU8 &tSettingLDWVibrationIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLDWVibrationIntensity,(tVoid*)&tSettingLDWVibrationIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLDWVibrationIntensityParam' in function 'dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(const tU8 &tSettingLDWVibrationIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLDWVibrationIntensity,(tVoid*)&tSettingLDWVibrationIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLDWVibrationIntensityParam' in function 'dp_tclVehFuncProfileSettingLDWVibrationIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingLDWVibrationIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingLDWVibrationIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLDWVibrationIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLDWVibrationIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingLDWVibrationIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingLDWVibrationIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingLDWVibrationIntensity", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingLDWVibrationIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingBSW"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingBSW::dp_tclVehFuncProfileSettingBSW(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingBSW,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingBSW::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingBSW",(tS32) 0xcafd2fa);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingBSW = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingBSW::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingBSW", (tS32)0xcafd2fa);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingBSW, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingBSW::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingBSW::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingBSW::tGetData() {
   vUpdate();
   return tSettingBSW;
};
tS32 dp_tclVehFuncProfileSettingBSW::s32GetData(tU8& tSettingBSWParam) { 
   vUpdate();
   tSettingBSWParam = tSettingBSW;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingBSW::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingBSW", (tS32)0xcafd2fa);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingBSW::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingBSW::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingBSW::s32SetData(tU8 &tSettingBSWParam) {
   //init parameter
   (tVoid)memcpy(&tSettingBSW,(tVoid*)&tSettingBSWParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingBSWParam' in function 'dp_tclVehFuncProfileSettingBSW::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingBSW::s32SetData(const tU8 &tSettingBSWParam) {
   //init parameter
   (tVoid)memcpy(&tSettingBSW,(tVoid*)&tSettingBSWParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingBSWParam' in function 'dp_tclVehFuncProfileSettingBSW::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingBSW::u8GetData(tU8& tSettingBSWParam) {  
   vUpdate();
   tSettingBSWParam = tSettingBSW;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingBSW::vSetData(tU8 &tSettingBSWParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingBSW,(tVoid*)&tSettingBSWParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingBSWParam' in function 'dp_tclVehFuncProfileSettingBSW::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingBSW::vSetData(const tU8 &tSettingBSWParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingBSW,(tVoid*)&tSettingBSWParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingBSWParam' in function 'dp_tclVehFuncProfileSettingBSW::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingBSW::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingBSW::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingBSW", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingBSW::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingBSW", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingBSW::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingBSW", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingBSW has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAEB"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingAEB::dp_tclVehFuncProfileSettingAEB(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAEB,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingAEB::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAEB",(tS32) 0xcafd286);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAEB = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingAEB::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAEB", (tS32)0xcafd286);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAEB, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingAEB::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingAEB::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingAEB::tGetData() {
   vUpdate();
   return tSettingAEB;
};
tS32 dp_tclVehFuncProfileSettingAEB::s32GetData(tU8& tSettingAEBParam) { 
   vUpdate();
   tSettingAEBParam = tSettingAEB;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingAEB::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAEB", (tS32)0xcafd286);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingAEB::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingAEB::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingAEB::s32SetData(tU8 &tSettingAEBParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAEB,(tVoid*)&tSettingAEBParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAEBParam' in function 'dp_tclVehFuncProfileSettingAEB::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingAEB::s32SetData(const tU8 &tSettingAEBParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAEB,(tVoid*)&tSettingAEBParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAEBParam' in function 'dp_tclVehFuncProfileSettingAEB::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingAEB::u8GetData(tU8& tSettingAEBParam) {  
   vUpdate();
   tSettingAEBParam = tSettingAEB;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingAEB::vSetData(tU8 &tSettingAEBParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAEB,(tVoid*)&tSettingAEBParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAEBParam' in function 'dp_tclVehFuncProfileSettingAEB::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingAEB::vSetData(const tU8 &tSettingAEBParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAEB,(tVoid*)&tSettingAEBParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAEBParam' in function 'dp_tclVehFuncProfileSettingAEB::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingAEB::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingAEB::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAEB", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAEB::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAEB", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAEB::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAEB", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingAEB has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDW"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDW::dp_tclVehFuncProfileSettingDW(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDW,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDW::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDW",(tS32) 0x2899095);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDW = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDW::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDW", (tS32)0x2899095);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDW, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDW::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDW::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDW::tGetData() {
   vUpdate();
   return tSettingDW;
};
tS32 dp_tclVehFuncProfileSettingDW::s32GetData(tU8& tSettingDWParam) { 
   vUpdate();
   tSettingDWParam = tSettingDW;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDW::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDW", (tS32)0x2899095);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDW::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDW::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDW::s32SetData(tU8 &tSettingDWParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDW,(tVoid*)&tSettingDWParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDWParam' in function 'dp_tclVehFuncProfileSettingDW::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDW::s32SetData(const tU8 &tSettingDWParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDW,(tVoid*)&tSettingDWParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDWParam' in function 'dp_tclVehFuncProfileSettingDW::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDW::u8GetData(tU8& tSettingDWParam) {  
   vUpdate();
   tSettingDWParam = tSettingDW;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDW::vSetData(tU8 &tSettingDWParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDW,(tVoid*)&tSettingDWParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDWParam' in function 'dp_tclVehFuncProfileSettingDW::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDW::vSetData(const tU8 &tSettingDWParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDW,(tVoid*)&tSettingDWParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDWParam' in function 'dp_tclVehFuncProfileSettingDW::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDW::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDW::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDW", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDW::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDW", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDW::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDW", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDW has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingOSPTSR"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingOSPTSR::dp_tclVehFuncProfileSettingOSPTSR(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingOSPTSR,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingOSPTSR::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingOSPTSR",(tS32) 0x31daa97d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingOSPTSR = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingOSPTSR::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingOSPTSR", (tS32)0x31daa97d);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingOSPTSR, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingOSPTSR::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingOSPTSR::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingOSPTSR::tGetData() {
   vUpdate();
   return tSettingOSPTSR;
};
tS32 dp_tclVehFuncProfileSettingOSPTSR::s32GetData(tU8& tSettingOSPTSRParam) { 
   vUpdate();
   tSettingOSPTSRParam = tSettingOSPTSR;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingOSPTSR::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingOSPTSR", (tS32)0x31daa97d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingOSPTSR::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingOSPTSR::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingOSPTSR::s32SetData(tU8 &tSettingOSPTSRParam) {
   //init parameter
   (tVoid)memcpy(&tSettingOSPTSR,(tVoid*)&tSettingOSPTSRParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingOSPTSRParam' in function 'dp_tclVehFuncProfileSettingOSPTSR::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingOSPTSR::s32SetData(const tU8 &tSettingOSPTSRParam) {
   //init parameter
   (tVoid)memcpy(&tSettingOSPTSR,(tVoid*)&tSettingOSPTSRParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingOSPTSRParam' in function 'dp_tclVehFuncProfileSettingOSPTSR::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingOSPTSR::u8GetData(tU8& tSettingOSPTSRParam) {  
   vUpdate();
   tSettingOSPTSRParam = tSettingOSPTSR;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingOSPTSR::vSetData(tU8 &tSettingOSPTSRParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingOSPTSR,(tVoid*)&tSettingOSPTSRParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingOSPTSRParam' in function 'dp_tclVehFuncProfileSettingOSPTSR::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingOSPTSR::vSetData(const tU8 &tSettingOSPTSRParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingOSPTSR,(tVoid*)&tSettingOSPTSRParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingOSPTSRParam' in function 'dp_tclVehFuncProfileSettingOSPTSR::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingOSPTSR::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingOSPTSR::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingOSPTSR", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingOSPTSR::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingOSPTSR", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingOSPTSR::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingOSPTSR", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingOSPTSR has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingUTA"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingUTA::dp_tclVehFuncProfileSettingUTA(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingUTA,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingUTA::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingUTA",(tS32) 0xcafd4c4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingUTA = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingUTA::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingUTA", (tS32)0xcafd4c4);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingUTA, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingUTA::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingUTA::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingUTA::tGetData() {
   vUpdate();
   return tSettingUTA;
};
tS32 dp_tclVehFuncProfileSettingUTA::s32GetData(tU8& tSettingUTAParam) { 
   vUpdate();
   tSettingUTAParam = tSettingUTA;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingUTA::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingUTA", (tS32)0xcafd4c4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingUTA::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingUTA::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingUTA::s32SetData(tU8 &tSettingUTAParam) {
   //init parameter
   (tVoid)memcpy(&tSettingUTA,(tVoid*)&tSettingUTAParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingUTAParam' in function 'dp_tclVehFuncProfileSettingUTA::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingUTA::s32SetData(const tU8 &tSettingUTAParam) {
   //init parameter
   (tVoid)memcpy(&tSettingUTA,(tVoid*)&tSettingUTAParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingUTAParam' in function 'dp_tclVehFuncProfileSettingUTA::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingUTA::u8GetData(tU8& tSettingUTAParam) {  
   vUpdate();
   tSettingUTAParam = tSettingUTA;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingUTA::vSetData(tU8 &tSettingUTAParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingUTA,(tVoid*)&tSettingUTAParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingUTAParam' in function 'dp_tclVehFuncProfileSettingUTA::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingUTA::vSetData(const tU8 &tSettingUTAParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingUTA,(tVoid*)&tSettingUTAParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingUTAParam' in function 'dp_tclVehFuncProfileSettingUTA::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingUTA::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingUTA::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingUTA", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingUTA::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingUTA", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingUTA::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingUTA", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingUTA has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingIoniserAutoLaunch"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingIoniserAutoLaunch::dp_tclVehFuncProfileSettingIoniserAutoLaunch(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingIoniserAutoLaunch,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingIoniserAutoLaunch",(tS32) 0xf5fb9847);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingIoniserAutoLaunch = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingIoniserAutoLaunch", (tS32)0xf5fb9847);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingIoniserAutoLaunch, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingIoniserAutoLaunch::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingIoniserAutoLaunch::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingIoniserAutoLaunch::tGetData() {
   vUpdate();
   return tSettingIoniserAutoLaunch;
};
tS32 dp_tclVehFuncProfileSettingIoniserAutoLaunch::s32GetData(tU8& tSettingIoniserAutoLaunchParam) { 
   vUpdate();
   tSettingIoniserAutoLaunchParam = tSettingIoniserAutoLaunch;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingIoniserAutoLaunch::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingIoniserAutoLaunch", (tS32)0xf5fb9847);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingIoniserAutoLaunch::s32SetData(tU8 &tSettingIoniserAutoLaunchParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIoniserAutoLaunch,(tVoid*)&tSettingIoniserAutoLaunchParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIoniserAutoLaunchParam' in function 'dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingIoniserAutoLaunch::s32SetData(const tU8 &tSettingIoniserAutoLaunchParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIoniserAutoLaunch,(tVoid*)&tSettingIoniserAutoLaunchParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIoniserAutoLaunchParam' in function 'dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingIoniserAutoLaunch::u8GetData(tU8& tSettingIoniserAutoLaunchParam) {  
   vUpdate();
   tSettingIoniserAutoLaunchParam = tSettingIoniserAutoLaunch;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(tU8 &tSettingIoniserAutoLaunchParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIoniserAutoLaunch,(tVoid*)&tSettingIoniserAutoLaunchParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIoniserAutoLaunchParam' in function 'dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(const tU8 &tSettingIoniserAutoLaunchParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIoniserAutoLaunch,(tVoid*)&tSettingIoniserAutoLaunchParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIoniserAutoLaunchParam' in function 'dp_tclVehFuncProfileSettingIoniserAutoLaunch::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingIoniserAutoLaunch::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingIoniserAutoLaunch::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingIoniserAutoLaunch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingIoniserAutoLaunch::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingIoniserAutoLaunch", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingIoniserAutoLaunch::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingIoniserAutoLaunch", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingIoniserAutoLaunch has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAQMIoniserMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingAQMIoniserMode::dp_tclVehFuncProfileSettingAQMIoniserMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAQMIoniserMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAQMIoniserMode",(tS32) 0x427d6ff7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAQMIoniserMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAQMIoniserMode", (tS32)0x427d6ff7);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAQMIoniserMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingAQMIoniserMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingAQMIoniserMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingAQMIoniserMode::tGetData() {
   vUpdate();
   return tSettingAQMIoniserMode;
};
tS32 dp_tclVehFuncProfileSettingAQMIoniserMode::s32GetData(tU8& tSettingAQMIoniserModeParam) { 
   vUpdate();
   tSettingAQMIoniserModeParam = tSettingAQMIoniserMode;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingAQMIoniserMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAQMIoniserMode", (tS32)0x427d6ff7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingAQMIoniserMode::s32SetData(tU8 &tSettingAQMIoniserModeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAQMIoniserMode,(tVoid*)&tSettingAQMIoniserModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAQMIoniserModeParam' in function 'dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingAQMIoniserMode::s32SetData(const tU8 &tSettingAQMIoniserModeParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAQMIoniserMode,(tVoid*)&tSettingAQMIoniserModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAQMIoniserModeParam' in function 'dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingAQMIoniserMode::u8GetData(tU8& tSettingAQMIoniserModeParam) {  
   vUpdate();
   tSettingAQMIoniserModeParam = tSettingAQMIoniserMode;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(tU8 &tSettingAQMIoniserModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAQMIoniserMode,(tVoid*)&tSettingAQMIoniserModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAQMIoniserModeParam' in function 'dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(const tU8 &tSettingAQMIoniserModeParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAQMIoniserMode,(tVoid*)&tSettingAQMIoniserModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAQMIoniserModeParam' in function 'dp_tclVehFuncProfileSettingAQMIoniserMode::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingAQMIoniserMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingAQMIoniserMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAQMIoniserMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAQMIoniserMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAQMIoniserMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAQMIoniserMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAQMIoniserMode", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingAQMIoniserMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAirFreshener"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingAirFreshener::dp_tclVehFuncProfileSettingAirFreshener(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAirFreshener,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingAirFreshener::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAirFreshener",(tS32) 0xc2f43920);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAirFreshener = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingAirFreshener::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAirFreshener", (tS32)0xc2f43920);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAirFreshener, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingAirFreshener::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingAirFreshener::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingAirFreshener::tGetData() {
   vUpdate();
   return tSettingAirFreshener;
};
tS32 dp_tclVehFuncProfileSettingAirFreshener::s32GetData(tU8& tSettingAirFreshenerParam) { 
   vUpdate();
   tSettingAirFreshenerParam = tSettingAirFreshener;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingAirFreshener::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAirFreshener", (tS32)0xc2f43920);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingAirFreshener::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingAirFreshener::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingAirFreshener::s32SetData(tU8 &tSettingAirFreshenerParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAirFreshener,(tVoid*)&tSettingAirFreshenerParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAirFreshenerParam' in function 'dp_tclVehFuncProfileSettingAirFreshener::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingAirFreshener::s32SetData(const tU8 &tSettingAirFreshenerParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAirFreshener,(tVoid*)&tSettingAirFreshenerParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAirFreshenerParam' in function 'dp_tclVehFuncProfileSettingAirFreshener::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingAirFreshener::u8GetData(tU8& tSettingAirFreshenerParam) {  
   vUpdate();
   tSettingAirFreshenerParam = tSettingAirFreshener;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingAirFreshener::vSetData(tU8 &tSettingAirFreshenerParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAirFreshener,(tVoid*)&tSettingAirFreshenerParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAirFreshenerParam' in function 'dp_tclVehFuncProfileSettingAirFreshener::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingAirFreshener::vSetData(const tU8 &tSettingAirFreshenerParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAirFreshener,(tVoid*)&tSettingAirFreshenerParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAirFreshenerParam' in function 'dp_tclVehFuncProfileSettingAirFreshener::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingAirFreshener::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingAirFreshener::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAirFreshener", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAirFreshener::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingAirFreshener", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingAirFreshener::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAirFreshener", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingAirFreshener has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverMassageProgramState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverMassageProgramState::dp_tclVehFuncProfileSettingDriverMassageProgramState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverMassageProgramState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverMassageProgramState",(tS32) 0x4db7d8a4L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverMassageProgramState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverMassageProgramState", (tS32)0x4db7d8a4L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverMassageProgramState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverMassageProgramState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverMassageProgramState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverMassageProgramState::tGetData() {
   vUpdate();
   return tSettingDriverMassageProgramState;
};
tS32 dp_tclVehFuncProfileSettingDriverMassageProgramState::s32GetData(tU8& tSettingDriverMassageProgramStateParam) { 
   vUpdate();
   tSettingDriverMassageProgramStateParam = tSettingDriverMassageProgramState;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverMassageProgramState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverMassageProgramState", (tS32)0x4db7d8a4L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverMassageProgramState::s32SetData(tU8 &tSettingDriverMassageProgramStateParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageProgramState,(tVoid*)&tSettingDriverMassageProgramStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageProgramStateParam' in function 'dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverMassageProgramState::s32SetData(const tU8 &tSettingDriverMassageProgramStateParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageProgramState,(tVoid*)&tSettingDriverMassageProgramStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageProgramStateParam' in function 'dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverMassageProgramState::u8GetData(tU8& tSettingDriverMassageProgramStateParam) {  
   vUpdate();
   tSettingDriverMassageProgramStateParam = tSettingDriverMassageProgramState;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(tU8 &tSettingDriverMassageProgramStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageProgramState,(tVoid*)&tSettingDriverMassageProgramStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageProgramStateParam' in function 'dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(const tU8 &tSettingDriverMassageProgramStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageProgramState,(tVoid*)&tSettingDriverMassageProgramStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageProgramStateParam' in function 'dp_tclVehFuncProfileSettingDriverMassageProgramState::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverMassageProgramState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverMassageProgramState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageProgramState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageProgramState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageProgramState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageProgramState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverMassageProgramState", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverMassageProgramState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverMassageVelocity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverMassageVelocity::dp_tclVehFuncProfileSettingDriverMassageVelocity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverMassageVelocity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverMassageVelocity",(tS32) 0xa66ffafeL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverMassageVelocity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverMassageVelocity", (tS32)0xa66ffafeL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverMassageVelocity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverMassageVelocity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverMassageVelocity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverMassageVelocity::tGetData() {
   vUpdate();
   return tSettingDriverMassageVelocity;
};
tS32 dp_tclVehFuncProfileSettingDriverMassageVelocity::s32GetData(tU8& tSettingDriverMassageVelocityParam) { 
   vUpdate();
   tSettingDriverMassageVelocityParam = tSettingDriverMassageVelocity;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverMassageVelocity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverMassageVelocity", (tS32)0xa66ffafeL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverMassageVelocity::s32SetData(tU8 &tSettingDriverMassageVelocityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageVelocity,(tVoid*)&tSettingDriverMassageVelocityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageVelocityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverMassageVelocity::s32SetData(const tU8 &tSettingDriverMassageVelocityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageVelocity,(tVoid*)&tSettingDriverMassageVelocityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageVelocityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverMassageVelocity::u8GetData(tU8& tSettingDriverMassageVelocityParam) {  
   vUpdate();
   tSettingDriverMassageVelocityParam = tSettingDriverMassageVelocity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(tU8 &tSettingDriverMassageVelocityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageVelocity,(tVoid*)&tSettingDriverMassageVelocityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageVelocityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(const tU8 &tSettingDriverMassageVelocityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageVelocity,(tVoid*)&tSettingDriverMassageVelocityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageVelocityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageVelocity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverMassageVelocity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverMassageVelocity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageVelocity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageVelocity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageVelocity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageVelocity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverMassageVelocity", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverMassageVelocity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverMassageIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverMassageIntensity::dp_tclVehFuncProfileSettingDriverMassageIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverMassageIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverMassageIntensity",(tS32) 0x3feeb25eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverMassageIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverMassageIntensity", (tS32)0x3feeb25eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverMassageIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverMassageIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverMassageIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverMassageIntensity::tGetData() {
   vUpdate();
   return tSettingDriverMassageIntensity;
};
tS32 dp_tclVehFuncProfileSettingDriverMassageIntensity::s32GetData(tU8& tSettingDriverMassageIntensityParam) { 
   vUpdate();
   tSettingDriverMassageIntensityParam = tSettingDriverMassageIntensity;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverMassageIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverMassageIntensity", (tS32)0x3feeb25eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverMassageIntensity::s32SetData(tU8 &tSettingDriverMassageIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageIntensity,(tVoid*)&tSettingDriverMassageIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageIntensityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverMassageIntensity::s32SetData(const tU8 &tSettingDriverMassageIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageIntensity,(tVoid*)&tSettingDriverMassageIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageIntensityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverMassageIntensity::u8GetData(tU8& tSettingDriverMassageIntensityParam) {  
   vUpdate();
   tSettingDriverMassageIntensityParam = tSettingDriverMassageIntensity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(tU8 &tSettingDriverMassageIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageIntensity,(tVoid*)&tSettingDriverMassageIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageIntensityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(const tU8 &tSettingDriverMassageIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageIntensity,(tVoid*)&tSettingDriverMassageIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageIntensityParam' in function 'dp_tclVehFuncProfileSettingDriverMassageIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverMassageIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverMassageIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverMassageIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverMassageIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverMassageIntensity", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverMassageIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverSeatMemo"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverSeatMemo::dp_tclVehFuncProfileSettingDriverSeatMemo(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverSeatMemo,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverSeatMemo",(tS32) 0x677a9999);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverSeatMemo = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverSeatMemo", (tS32)0x677a9999);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverSeatMemo, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverSeatMemo::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverSeatMemo::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverSeatMemo::tGetData() {
   vUpdate();
   return tSettingDriverSeatMemo;
};
tS32 dp_tclVehFuncProfileSettingDriverSeatMemo::s32GetData(tU8& tSettingDriverSeatMemoParam) { 
   vUpdate();
   tSettingDriverSeatMemoParam = tSettingDriverSeatMemo;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverSeatMemo::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverSeatMemo", (tS32)0x677a9999);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverSeatMemo::s32SetData(tU8 &tSettingDriverSeatMemoParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverSeatMemo,(tVoid*)&tSettingDriverSeatMemoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverSeatMemoParam' in function 'dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverSeatMemo::s32SetData(const tU8 &tSettingDriverSeatMemoParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverSeatMemo,(tVoid*)&tSettingDriverSeatMemoParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverSeatMemoParam' in function 'dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverSeatMemo::u8GetData(tU8& tSettingDriverSeatMemoParam) {  
   vUpdate();
   tSettingDriverSeatMemoParam = tSettingDriverSeatMemo;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(tU8 &tSettingDriverSeatMemoParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverSeatMemo,(tVoid*)&tSettingDriverSeatMemoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverSeatMemoParam' in function 'dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(const tU8 &tSettingDriverSeatMemoParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverSeatMemo,(tVoid*)&tSettingDriverSeatMemoParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverSeatMemoParam' in function 'dp_tclVehFuncProfileSettingDriverSeatMemo::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverSeatMemo::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverSeatMemo::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverSeatMemo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverSeatMemo::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverSeatMemo", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverSeatMemo::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverSeatMemo", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverSeatMemo has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverVentil"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverVentil::dp_tclVehFuncProfileSettingDriverVentil(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverVentil,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverVentil::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverVentil",(tS32) 0xd0f097fc);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverVentil = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverVentil::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverVentil", (tS32)0xd0f097fc);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverVentil, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverVentil::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverVentil::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverVentil::tGetData() {
   vUpdate();
   return tSettingDriverVentil;
};
tS32 dp_tclVehFuncProfileSettingDriverVentil::s32GetData(tU8& tSettingDriverVentilParam) { 
   vUpdate();
   tSettingDriverVentilParam = tSettingDriverVentil;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverVentil::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverVentil", (tS32)0xd0f097fc);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverVentil::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverVentil::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverVentil::s32SetData(tU8 &tSettingDriverVentilParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverVentil,(tVoid*)&tSettingDriverVentilParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverVentilParam' in function 'dp_tclVehFuncProfileSettingDriverVentil::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverVentil::s32SetData(const tU8 &tSettingDriverVentilParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverVentil,(tVoid*)&tSettingDriverVentilParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverVentilParam' in function 'dp_tclVehFuncProfileSettingDriverVentil::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverVentil::u8GetData(tU8& tSettingDriverVentilParam) {  
   vUpdate();
   tSettingDriverVentilParam = tSettingDriverVentil;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverVentil::vSetData(tU8 &tSettingDriverVentilParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverVentil,(tVoid*)&tSettingDriverVentilParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverVentilParam' in function 'dp_tclVehFuncProfileSettingDriverVentil::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverVentil::vSetData(const tU8 &tSettingDriverVentilParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverVentil,(tVoid*)&tSettingDriverVentilParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverVentilParam' in function 'dp_tclVehFuncProfileSettingDriverVentil::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverVentil::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverVentil::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverVentil", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverVentil::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverVentil", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverVentil::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverVentil", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverVentil has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverHeating"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncProfileSettingDriverHeating::dp_tclVehFuncProfileSettingDriverHeating(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0446;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverHeating,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncProfileSettingDriverHeating::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverHeating",(tS32) 0x14af8222);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverHeating = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncProfileSettingDriverHeating::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverHeating", (tS32)0x14af8222);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverHeating, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncProfileSettingDriverHeating::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncProfileSettingDriverHeating::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncProfileSettingDriverHeating::tGetData() {
   vUpdate();
   return tSettingDriverHeating;
};
tS32 dp_tclVehFuncProfileSettingDriverHeating::s32GetData(tU8& tSettingDriverHeatingParam) { 
   vUpdate();
   tSettingDriverHeatingParam = tSettingDriverHeating;
   return _s32Status;
}
tS32 dp_tclVehFuncProfileSettingDriverHeating::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverHeating", (tS32)0x14af8222);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNCPROFILE, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncProfileSettingDriverHeating::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncProfileSettingDriverHeating::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncProfileSettingDriverHeating::s32SetData(tU8 &tSettingDriverHeatingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverHeating,(tVoid*)&tSettingDriverHeatingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverHeatingParam' in function 'dp_tclVehFuncProfileSettingDriverHeating::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncProfileSettingDriverHeating::s32SetData(const tU8 &tSettingDriverHeatingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverHeating,(tVoid*)&tSettingDriverHeatingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverHeatingParam' in function 'dp_tclVehFuncProfileSettingDriverHeating::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncProfileSettingDriverHeating::u8GetData(tU8& tSettingDriverHeatingParam) {  
   vUpdate();
   tSettingDriverHeatingParam = tSettingDriverHeating;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncProfileSettingDriverHeating::vSetData(tU8 &tSettingDriverHeatingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverHeating,(tVoid*)&tSettingDriverHeatingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverHeatingParam' in function 'dp_tclVehFuncProfileSettingDriverHeating::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncProfileSettingDriverHeating::vSetData(const tU8 &tSettingDriverHeatingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverHeating,(tVoid*)&tSettingDriverHeatingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverHeatingParam' in function 'dp_tclVehFuncProfileSettingDriverHeating::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncProfileSettingDriverHeating::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncProfileSettingDriverHeating::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverHeating", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverHeating::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNCPROFILE, "SettingDriverHeating", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncProfileSettingDriverHeating::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverHeating", DP_U32_POOL_ID_VEHFUNCPROFILE);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNCPROFILE);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverHeating has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
