
#define OSAL_S_IMPORT_INTERFACE_GENERIC           
#include "osal_if.h"

#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_if.h"

#include "dp_tclVehFunc.h"



//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EcoScoreHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEcoScoreHistory::dp_tclVehFuncEcoScoreHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 100;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncEcoScoreHistory::vStore() {
    dp_tclBaseElement myDpElem("EcoScoreHistory", (tS32)0xbbd72671);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TEcoScoreHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListEcoScoreHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TEcoScoreHistory));
                pCurPos += sizeof(TEcoScoreHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TEcoScoreHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncEcoScoreHistory::vUpdate() {
   dp_tclBaseElement myDpElem("EcoScoreHistory", (tS32)0xbbd72671);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TEcoScoreHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TEcoScoreHistory));
         TEcoScoreHistory* pBuffer = (TEcoScoreHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncEcoScoreHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncEcoScoreHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncEcoScoreHistory::s32GetElem(tU32 u32NbElem, TEcoScoreHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncEcoScoreHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncEcoScoreHistory::vPushBack(TEcoScoreHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncEcoScoreHistory::vPushBack(const TEcoScoreHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncEcoScoreHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncEcoScoreHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EcoScoreHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncEcoScoreHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EcoScoreHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncEcoScoreHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EcoScoreHistory", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element EcoScoreHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "HEVHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncHEVHistory::dp_tclVehFuncHEVHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 100;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncHEVHistory::vStore() {
    dp_tclBaseElement myDpElem("HEVHistory", (tS32)0xa7b1a61);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(THEVConsumptionHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListHEVHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(THEVConsumptionHistory));
                pCurPos += sizeof(THEVConsumptionHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(THEVConsumptionHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncHEVHistory::vUpdate() {
   dp_tclBaseElement myDpElem("HEVHistory", (tS32)0xa7b1a61);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(THEVConsumptionHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(THEVConsumptionHistory));
         THEVConsumptionHistory* pBuffer = (THEVConsumptionHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncHEVHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncHEVHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncHEVHistory::s32GetElem(tU32 u32NbElem, THEVConsumptionHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncHEVHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncHEVHistory::vPushBack(THEVConsumptionHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncHEVHistory::vPushBack(const THEVConsumptionHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncHEVHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncHEVHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "HEVHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncHEVHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "HEVHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncHEVHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: HEVHistory", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element HEVHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MexRestartMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMexRestartMode::dp_tclVehFuncMexRestartMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMexRestartMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMexRestartMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MexRestartMode",(tS32) 0x3c4ca470);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tMexRestartMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMexRestartMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MexRestartMode", (tS32)0x3c4ca470);
   (tVoid)myDpElem.bFillData((tVoid*)&tMexRestartMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMexRestartMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMexRestartMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncMexRestartMode::tGetData() {
   vUpdate();
   return tMexRestartMode;
};
tS32 dp_tclVehFuncMexRestartMode::s32GetData(tU8& tMexRestartModeParam) { 
   vUpdate();
   tMexRestartModeParam = tMexRestartMode;
   return _s32Status;
}
tS32 dp_tclVehFuncMexRestartMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MexRestartMode", (tS32)0x3c4ca470);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMexRestartMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMexRestartMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMexRestartMode::s32SetData(tU8 &tMexRestartModeParam) {
   //init parameter
   (tVoid)memcpy(&tMexRestartMode,(tVoid*)&tMexRestartModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMexRestartModeParam' in function 'dp_tclVehFuncMexRestartMode::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncMexRestartMode::s32SetData(const tU8 &tMexRestartModeParam) {
   //init parameter
   (tVoid)memcpy(&tMexRestartMode,(tVoid*)&tMexRestartModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMexRestartModeParam' in function 'dp_tclVehFuncMexRestartMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMexRestartMode::u8GetData(tU8& tMexRestartModeParam) {  
   vUpdate();
   tMexRestartModeParam = tMexRestartMode;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMexRestartMode::vSetData(tU8 &tMexRestartModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMexRestartMode,(tVoid*)&tMexRestartModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMexRestartModeParam' in function 'dp_tclVehFuncMexRestartMode::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncMexRestartMode::vSetData(const tU8 &tMexRestartModeParam) { 
   //init parameter
   (tVoid)memcpy(&tMexRestartMode,(tVoid*)&tMexRestartModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tMexRestartModeParam' in function 'dp_tclVehFuncMexRestartMode::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncMexRestartMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMexRestartMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MexRestartMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMexRestartMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MexRestartMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMexRestartMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MexRestartMode", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MexRestartMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "VehicleMode"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncVehicleMode::dp_tclVehFuncVehicleMode(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tVehicleMode,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncVehicleMode::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("VehicleMode",(tS32) 0x40d80191);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tVehicleMode = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncVehicleMode::vStore(tVoid) {
   dp_tclBaseElement myDpElem("VehicleMode", (tS32)0x40d80191);
   (tVoid)myDpElem.bFillData((tVoid*)&tVehicleMode, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncVehicleMode::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncVehicleMode::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncVehicleMode::tGetData() {
   vUpdate();
   return tVehicleMode;
};
tS32 dp_tclVehFuncVehicleMode::s32GetData(tU8& tVehicleModeParam) { 
   vUpdate();
   tVehicleModeParam = tVehicleMode;
   return _s32Status;
}
tS32 dp_tclVehFuncVehicleMode::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("VehicleMode", (tS32)0x40d80191);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncVehicleMode::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncVehicleMode::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncVehicleMode::s32SetData(tU8 &tVehicleModeParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleMode,(tVoid*)&tVehicleModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleModeParam' in function 'dp_tclVehFuncVehicleMode::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncVehicleMode::s32SetData(const tU8 &tVehicleModeParam) {
   //init parameter
   (tVoid)memcpy(&tVehicleMode,(tVoid*)&tVehicleModeParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tVehicleModeParam' in function 'dp_tclVehFuncVehicleMode::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncVehicleMode::u8GetData(tU8& tVehicleModeParam) {  
   vUpdate();
   tVehicleModeParam = tVehicleMode;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncVehicleMode::vSetData(tU8 &tVehicleModeParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleMode,(tVoid*)&tVehicleModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleModeParam' in function 'dp_tclVehFuncVehicleMode::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncVehicleMode::vSetData(const tU8 &tVehicleModeParam) { 
   //init parameter
   (tVoid)memcpy(&tVehicleMode,(tVoid*)&tVehicleModeParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tVehicleModeParam' in function 'dp_tclVehFuncVehicleMode::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncVehicleMode::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncVehicleMode::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "VehicleMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncVehicleMode::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "VehicleMode", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncVehicleMode::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: VehicleMode", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element VehicleMode has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EcoTripData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEcoTripData::dp_tclVehFuncEcoTripData(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEcoTripData,0,sizeof(TEcoTripData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncEcoTripData::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EcoTripData",(tS32) 0x36cb6900);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEcoTripData)) 
      {
         tEcoTripData = *((TEcoTripData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncEcoTripData::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EcoTripData", (tS32)0x36cb6900);
   (tVoid)myDpElem.bFillData((tVoid*)&tEcoTripData, (tU32)sizeof(TEcoTripData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncEcoTripData::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncEcoTripData::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEcoTripData dp_tclVehFuncEcoTripData::tGetData() {
   vUpdate();
   return tEcoTripData;
};
tS32 dp_tclVehFuncEcoTripData::s32GetData(TEcoTripData& tEcoTripDataParam) { 
   vUpdate();
   tEcoTripDataParam = tEcoTripData;
   return _s32Status;
}
tS32 dp_tclVehFuncEcoTripData::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EcoTripData", (tS32)0x36cb6900);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncEcoTripData::operator>>(TEcoTripData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncEcoTripData::operator<<(TEcoTripData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncEcoTripData::s32SetData(TEcoTripData &tEcoTripDataParam) {
   //init parameter
   (tVoid)memcpy(&tEcoTripData,(tVoid*)&tEcoTripDataParam, sizeof(TEcoTripData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoTripDataParam' in function 'dp_tclVehFuncEcoTripData::vSetData(TEcoTripData)' could be made const reference
tS32 dp_tclVehFuncEcoTripData::s32SetData(const TEcoTripData &tEcoTripDataParam) {
   //init parameter
   (tVoid)memcpy(&tEcoTripData,(tVoid*)&tEcoTripDataParam, sizeof(TEcoTripData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoTripDataParam' in function 'dp_tclVehFuncEcoTripData::vSetData(TEcoTripData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncEcoTripData::u8GetData(TEcoTripData& tEcoTripDataParam) {  
   vUpdate();
   tEcoTripDataParam = tEcoTripData;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncEcoTripData::vSetData(TEcoTripData &tEcoTripDataParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoTripData,(tVoid*)&tEcoTripDataParam, sizeof(TEcoTripData));
   vStore();
}//lint !e1746: parameter 'tEcoTripDataParam' in function 'dp_tclVehFuncEcoTripData::vSetData(TEcoTripData)' could be made const reference
tVoid dp_tclVehFuncEcoTripData::vSetData(const TEcoTripData &tEcoTripDataParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoTripData,(tVoid*)&tEcoTripDataParam, sizeof(TEcoTripData));
   vStore();
}//lint !e1746: parameter 'tEcoTripDataParam' in function 'dp_tclVehFuncEcoTripData::vSetData(TEcoTripData)' could be made const reference
tU8   dp_tclVehFuncEcoTripData::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncEcoTripData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EcoTripData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoTripData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EcoTripData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoTripData::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EcoTripData", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element EcoTripData has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DrivingEcoData"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDrivingEcoData::dp_tclVehFuncDrivingEcoData(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDrivingEcoData,0,sizeof(TEcoData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncDrivingEcoData::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DrivingEcoData",(tS32) 0x54325984);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEcoData)) 
      {
         tDrivingEcoData = *((TEcoData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncDrivingEcoData::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DrivingEcoData", (tS32)0x54325984);
   (tVoid)myDpElem.bFillData((tVoid*)&tDrivingEcoData, (tU32)sizeof(TEcoData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncDrivingEcoData::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncDrivingEcoData::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEcoData dp_tclVehFuncDrivingEcoData::tGetData() {
   vUpdate();
   return tDrivingEcoData;
};
tS32 dp_tclVehFuncDrivingEcoData::s32GetData(TEcoData& tDrivingEcoDataParam) { 
   vUpdate();
   tDrivingEcoDataParam = tDrivingEcoData;
   return _s32Status;
}
tS32 dp_tclVehFuncDrivingEcoData::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DrivingEcoData", (tS32)0x54325984);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncDrivingEcoData::operator>>(TEcoData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncDrivingEcoData::operator<<(TEcoData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncDrivingEcoData::s32SetData(TEcoData &tDrivingEcoDataParam) {
   //init parameter
   (tVoid)memcpy(&tDrivingEcoData,(tVoid*)&tDrivingEcoDataParam, sizeof(TEcoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDrivingEcoDataParam' in function 'dp_tclVehFuncDrivingEcoData::vSetData(TEcoData)' could be made const reference
tS32 dp_tclVehFuncDrivingEcoData::s32SetData(const TEcoData &tDrivingEcoDataParam) {
   //init parameter
   (tVoid)memcpy(&tDrivingEcoData,(tVoid*)&tDrivingEcoDataParam, sizeof(TEcoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDrivingEcoDataParam' in function 'dp_tclVehFuncDrivingEcoData::vSetData(TEcoData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncDrivingEcoData::u8GetData(TEcoData& tDrivingEcoDataParam) {  
   vUpdate();
   tDrivingEcoDataParam = tDrivingEcoData;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncDrivingEcoData::vSetData(TEcoData &tDrivingEcoDataParam) { 
   //init parameter
   (tVoid)memcpy(&tDrivingEcoData,(tVoid*)&tDrivingEcoDataParam, sizeof(TEcoData));
   vStore();
}//lint !e1746: parameter 'tDrivingEcoDataParam' in function 'dp_tclVehFuncDrivingEcoData::vSetData(TEcoData)' could be made const reference
tVoid dp_tclVehFuncDrivingEcoData::vSetData(const TEcoData &tDrivingEcoDataParam) { 
   //init parameter
   (tVoid)memcpy(&tDrivingEcoData,(tVoid*)&tDrivingEcoDataParam, sizeof(TEcoData));
   vStore();
}//lint !e1746: parameter 'tDrivingEcoDataParam' in function 'dp_tclVehFuncDrivingEcoData::vSetData(TEcoData)' could be made const reference
tU8   dp_tclVehFuncDrivingEcoData::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncDrivingEcoData::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDrivingEcoData::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoData", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDrivingEcoData::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DrivingEcoData", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element DrivingEcoData has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DrivingEcoHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDrivingEcoHistory::dp_tclVehFuncDrivingEcoHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncDrivingEcoHistory::vStore() {
    dp_tclBaseElement myDpElem("DrivingEcoHistory", (tS32)0x1c971fa0);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDrivingEcoHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDrivingEcoHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDrivingEcoHistory));
                pCurPos += sizeof(TDrivingEcoHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDrivingEcoHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncDrivingEcoHistory::vUpdate() {
   dp_tclBaseElement myDpElem("DrivingEcoHistory", (tS32)0x1c971fa0);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDrivingEcoHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDrivingEcoHistory));
         TDrivingEcoHistory* pBuffer = (TDrivingEcoHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncDrivingEcoHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncDrivingEcoHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncDrivingEcoHistory::s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncDrivingEcoHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncDrivingEcoHistory::vPushBack(TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncDrivingEcoHistory::vPushBack(const TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncDrivingEcoHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncDrivingEcoHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncDrivingEcoHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncDrivingEcoHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DrivingEcoHistory", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element DrivingEcoHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DrivingEcoTripHistory_Home_Work"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDrivingEcoTripHistory_Home_Work::dp_tclVehFuncDrivingEcoTripHistory_Home_Work(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncDrivingEcoTripHistory_Home_Work::vStore() {
    dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Home_Work", (tS32)0x90bfc759L);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDrivingEcoHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDrivingEcoTripHistory_Home_Work::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDrivingEcoHistory));
                pCurPos += sizeof(TDrivingEcoHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDrivingEcoHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncDrivingEcoTripHistory_Home_Work::vUpdate() {
   dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Home_Work", (tS32)0x90bfc759L);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDrivingEcoHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDrivingEcoHistory));
         TDrivingEcoHistory* pBuffer = (TDrivingEcoHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncDrivingEcoTripHistory_Home_Work::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncDrivingEcoTripHistory_Home_Work::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncDrivingEcoTripHistory_Home_Work::s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncDrivingEcoTripHistory_Home_Work::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Home_Work::vPushBack(TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Home_Work::vPushBack(const TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncDrivingEcoTripHistory_Home_Work::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncDrivingEcoTripHistory_Home_Work::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Home_Work", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncDrivingEcoTripHistory_Home_Work::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Home_Work", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncDrivingEcoTripHistory_Home_Work::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DrivingEcoTripHistory_Home_Work", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element DrivingEcoTripHistory_Home_Work has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DrivingEcoTripHistory_Journey"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDrivingEcoTripHistory_Journey::dp_tclVehFuncDrivingEcoTripHistory_Journey(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncDrivingEcoTripHistory_Journey::vStore() {
    dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Journey", (tS32)0x61f3c68eL);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDrivingEcoHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDrivingEcoTripHistory_Journey::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDrivingEcoHistory));
                pCurPos += sizeof(TDrivingEcoHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDrivingEcoHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncDrivingEcoTripHistory_Journey::vUpdate() {
   dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Journey", (tS32)0x61f3c68eL);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDrivingEcoHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDrivingEcoHistory));
         TDrivingEcoHistory* pBuffer = (TDrivingEcoHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncDrivingEcoTripHistory_Journey::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncDrivingEcoTripHistory_Journey::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncDrivingEcoTripHistory_Journey::s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncDrivingEcoTripHistory_Journey::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Journey::vPushBack(TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Journey::vPushBack(const TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncDrivingEcoTripHistory_Journey::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncDrivingEcoTripHistory_Journey::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Journey", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncDrivingEcoTripHistory_Journey::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Journey", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncDrivingEcoTripHistory_Journey::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DrivingEcoTripHistory_Journey", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element DrivingEcoTripHistory_Journey has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DrivingEcoTripHistory_Personal"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDrivingEcoTripHistory_Personal::dp_tclVehFuncDrivingEcoTripHistory_Personal(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncDrivingEcoTripHistory_Personal::vStore() {
    dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Personal", (tS32)0xe9c7849eL);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDrivingEcoHistory)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDrivingEcoTripHistory_Personal::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDrivingEcoHistory));
                pCurPos += sizeof(TDrivingEcoHistory);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDrivingEcoHistory))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncDrivingEcoTripHistory_Personal::vUpdate() {
   dp_tclBaseElement myDpElem("DrivingEcoTripHistory_Personal", (tS32)0xe9c7849eL);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDrivingEcoHistory)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDrivingEcoHistory));
         TDrivingEcoHistory* pBuffer = (TDrivingEcoHistory*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncDrivingEcoTripHistory_Personal::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncDrivingEcoTripHistory_Personal::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncDrivingEcoTripHistory_Personal::s32GetElem(tU32 u32NbElem, TDrivingEcoHistory& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncDrivingEcoTripHistory_Personal::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Personal::vPushBack(TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncDrivingEcoTripHistory_Personal::vPushBack(const TDrivingEcoHistory &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncDrivingEcoTripHistory_Personal::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncDrivingEcoTripHistory_Personal::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Personal", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncDrivingEcoTripHistory_Personal::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DrivingEcoTripHistory_Personal", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncDrivingEcoTripHistory_Personal::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DrivingEcoTripHistory_Personal", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element DrivingEcoTripHistory_Personal has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EcoChallengeData_Home_Work"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEcoChallengeData_Home_Work::dp_tclVehFuncEcoChallengeData_Home_Work(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEcoChallengeData_Home_Work,0,sizeof(TEcoChallengeScreenData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncEcoChallengeData_Home_Work::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EcoChallengeData_Home_Work",(tS32) 0x13eb2af6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEcoChallengeScreenData)) 
      {
         tEcoChallengeData_Home_Work = *((TEcoChallengeScreenData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncEcoChallengeData_Home_Work::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Home_Work", (tS32)0x13eb2af6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tEcoChallengeData_Home_Work, (tU32)sizeof(TEcoChallengeScreenData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncEcoChallengeData_Home_Work::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncEcoChallengeData_Home_Work::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEcoChallengeScreenData dp_tclVehFuncEcoChallengeData_Home_Work::tGetData() {
   vUpdate();
   return tEcoChallengeData_Home_Work;
};
tS32 dp_tclVehFuncEcoChallengeData_Home_Work::s32GetData(TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam) { 
   vUpdate();
   tEcoChallengeData_Home_WorkParam = tEcoChallengeData_Home_Work;
   return _s32Status;
}
tS32 dp_tclVehFuncEcoChallengeData_Home_Work::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Home_Work", (tS32)0x13eb2af6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncEcoChallengeData_Home_Work::operator>>(TEcoChallengeScreenData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncEcoChallengeData_Home_Work::operator<<(TEcoChallengeScreenData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncEcoChallengeData_Home_Work::s32SetData(TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Home_Work,(tVoid*)&tEcoChallengeData_Home_WorkParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_Home_WorkParam' in function 'dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(TEcoChallengeScreenData)' could be made const reference
tS32 dp_tclVehFuncEcoChallengeData_Home_Work::s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Home_Work,(tVoid*)&tEcoChallengeData_Home_WorkParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_Home_WorkParam' in function 'dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(TEcoChallengeScreenData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncEcoChallengeData_Home_Work::u8GetData(TEcoChallengeScreenData& tEcoChallengeData_Home_WorkParam) {  
   vUpdate();
   tEcoChallengeData_Home_WorkParam = tEcoChallengeData_Home_Work;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Home_Work,(tVoid*)&tEcoChallengeData_Home_WorkParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_Home_WorkParam' in function 'dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(TEcoChallengeScreenData)' could be made const reference
tVoid dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(const TEcoChallengeScreenData &tEcoChallengeData_Home_WorkParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Home_Work,(tVoid*)&tEcoChallengeData_Home_WorkParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_Home_WorkParam' in function 'dp_tclVehFuncEcoChallengeData_Home_Work::vSetData(TEcoChallengeScreenData)' could be made const reference
tU8   dp_tclVehFuncEcoChallengeData_Home_Work::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncEcoChallengeData_Home_Work::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Home_Work", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Home_Work::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Home_Work", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Home_Work::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EcoChallengeData_Home_Work", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element EcoChallengeData_Home_Work has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EcoChallengeData_Journey"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEcoChallengeData_Journey::dp_tclVehFuncEcoChallengeData_Journey(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEcoChallengeData_Journey,0,sizeof(TEcoChallengeScreenData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncEcoChallengeData_Journey::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EcoChallengeData_Journey",(tS32) 0x9a6626b3);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEcoChallengeScreenData)) 
      {
         tEcoChallengeData_Journey = *((TEcoChallengeScreenData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncEcoChallengeData_Journey::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Journey", (tS32)0x9a6626b3);
   (tVoid)myDpElem.bFillData((tVoid*)&tEcoChallengeData_Journey, (tU32)sizeof(TEcoChallengeScreenData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncEcoChallengeData_Journey::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncEcoChallengeData_Journey::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEcoChallengeScreenData dp_tclVehFuncEcoChallengeData_Journey::tGetData() {
   vUpdate();
   return tEcoChallengeData_Journey;
};
tS32 dp_tclVehFuncEcoChallengeData_Journey::s32GetData(TEcoChallengeScreenData& tEcoChallengeData_JourneyParam) { 
   vUpdate();
   tEcoChallengeData_JourneyParam = tEcoChallengeData_Journey;
   return _s32Status;
}
tS32 dp_tclVehFuncEcoChallengeData_Journey::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Journey", (tS32)0x9a6626b3);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncEcoChallengeData_Journey::operator>>(TEcoChallengeScreenData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncEcoChallengeData_Journey::operator<<(TEcoChallengeScreenData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncEcoChallengeData_Journey::s32SetData(TEcoChallengeScreenData &tEcoChallengeData_JourneyParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Journey,(tVoid*)&tEcoChallengeData_JourneyParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_JourneyParam' in function 'dp_tclVehFuncEcoChallengeData_Journey::vSetData(TEcoChallengeScreenData)' could be made const reference
tS32 dp_tclVehFuncEcoChallengeData_Journey::s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_JourneyParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Journey,(tVoid*)&tEcoChallengeData_JourneyParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_JourneyParam' in function 'dp_tclVehFuncEcoChallengeData_Journey::vSetData(TEcoChallengeScreenData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncEcoChallengeData_Journey::u8GetData(TEcoChallengeScreenData& tEcoChallengeData_JourneyParam) {  
   vUpdate();
   tEcoChallengeData_JourneyParam = tEcoChallengeData_Journey;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncEcoChallengeData_Journey::vSetData(TEcoChallengeScreenData &tEcoChallengeData_JourneyParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Journey,(tVoid*)&tEcoChallengeData_JourneyParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_JourneyParam' in function 'dp_tclVehFuncEcoChallengeData_Journey::vSetData(TEcoChallengeScreenData)' could be made const reference
tVoid dp_tclVehFuncEcoChallengeData_Journey::vSetData(const TEcoChallengeScreenData &tEcoChallengeData_JourneyParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Journey,(tVoid*)&tEcoChallengeData_JourneyParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_JourneyParam' in function 'dp_tclVehFuncEcoChallengeData_Journey::vSetData(TEcoChallengeScreenData)' could be made const reference
tU8   dp_tclVehFuncEcoChallengeData_Journey::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncEcoChallengeData_Journey::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Journey", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Journey::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Journey", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Journey::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EcoChallengeData_Journey", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element EcoChallengeData_Journey has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EcoChallengeData_Personal"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEcoChallengeData_Personal::dp_tclVehFuncEcoChallengeData_Personal(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEcoChallengeData_Personal,0,sizeof(TEcoChallengeScreenData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncEcoChallengeData_Personal::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EcoChallengeData_Personal",(tS32) 0x4036557);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TEcoChallengeScreenData)) 
      {
         tEcoChallengeData_Personal = *((TEcoChallengeScreenData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncEcoChallengeData_Personal::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Personal", (tS32)0x4036557);
   (tVoid)myDpElem.bFillData((tVoid*)&tEcoChallengeData_Personal, (tU32)sizeof(TEcoChallengeScreenData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncEcoChallengeData_Personal::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncEcoChallengeData_Personal::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TEcoChallengeScreenData dp_tclVehFuncEcoChallengeData_Personal::tGetData() {
   vUpdate();
   return tEcoChallengeData_Personal;
};
tS32 dp_tclVehFuncEcoChallengeData_Personal::s32GetData(TEcoChallengeScreenData& tEcoChallengeData_PersonalParam) { 
   vUpdate();
   tEcoChallengeData_PersonalParam = tEcoChallengeData_Personal;
   return _s32Status;
}
tS32 dp_tclVehFuncEcoChallengeData_Personal::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EcoChallengeData_Personal", (tS32)0x4036557);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncEcoChallengeData_Personal::operator>>(TEcoChallengeScreenData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncEcoChallengeData_Personal::operator<<(TEcoChallengeScreenData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncEcoChallengeData_Personal::s32SetData(TEcoChallengeScreenData &tEcoChallengeData_PersonalParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Personal,(tVoid*)&tEcoChallengeData_PersonalParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_PersonalParam' in function 'dp_tclVehFuncEcoChallengeData_Personal::vSetData(TEcoChallengeScreenData)' could be made const reference
tS32 dp_tclVehFuncEcoChallengeData_Personal::s32SetData(const TEcoChallengeScreenData &tEcoChallengeData_PersonalParam) {
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Personal,(tVoid*)&tEcoChallengeData_PersonalParam, sizeof(TEcoChallengeScreenData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEcoChallengeData_PersonalParam' in function 'dp_tclVehFuncEcoChallengeData_Personal::vSetData(TEcoChallengeScreenData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncEcoChallengeData_Personal::u8GetData(TEcoChallengeScreenData& tEcoChallengeData_PersonalParam) {  
   vUpdate();
   tEcoChallengeData_PersonalParam = tEcoChallengeData_Personal;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncEcoChallengeData_Personal::vSetData(TEcoChallengeScreenData &tEcoChallengeData_PersonalParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Personal,(tVoid*)&tEcoChallengeData_PersonalParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_PersonalParam' in function 'dp_tclVehFuncEcoChallengeData_Personal::vSetData(TEcoChallengeScreenData)' could be made const reference
tVoid dp_tclVehFuncEcoChallengeData_Personal::vSetData(const TEcoChallengeScreenData &tEcoChallengeData_PersonalParam) { 
   //init parameter
   (tVoid)memcpy(&tEcoChallengeData_Personal,(tVoid*)&tEcoChallengeData_PersonalParam, sizeof(TEcoChallengeScreenData));
   vStore();
}//lint !e1746: parameter 'tEcoChallengeData_PersonalParam' in function 'dp_tclVehFuncEcoChallengeData_Personal::vSetData(TEcoChallengeScreenData)' could be made const reference
tU8   dp_tclVehFuncEcoChallengeData_Personal::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncEcoChallengeData_Personal::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Personal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Personal::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EcoChallengeData_Personal", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEcoChallengeData_Personal::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EcoChallengeData_Personal", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element EcoChallengeData_Personal has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Last_EcoTrip_Reset_Time"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncLast_EcoTrip_Reset_Time::dp_tclVehFuncLast_EcoTrip_Reset_Time(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tLast_EcoTrip_Reset_Time,0,sizeof(TLastResetTime));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Last_EcoTrip_Reset_Time",(tS32) 0xb1cdd14d);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TLastResetTime)) 
      {
         tLast_EcoTrip_Reset_Time = *((TLastResetTime*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Last_EcoTrip_Reset_Time", (tS32)0xb1cdd14d);
   (tVoid)myDpElem.bFillData((tVoid*)&tLast_EcoTrip_Reset_Time, (tU32)sizeof(TLastResetTime));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncLast_EcoTrip_Reset_Time::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncLast_EcoTrip_Reset_Time::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TLastResetTime dp_tclVehFuncLast_EcoTrip_Reset_Time::tGetData() {
   vUpdate();
   return tLast_EcoTrip_Reset_Time;
};
tS32 dp_tclVehFuncLast_EcoTrip_Reset_Time::s32GetData(TLastResetTime& tLast_EcoTrip_Reset_TimeParam) { 
   vUpdate();
   tLast_EcoTrip_Reset_TimeParam = tLast_EcoTrip_Reset_Time;
   return _s32Status;
}
tS32 dp_tclVehFuncLast_EcoTrip_Reset_Time::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Last_EcoTrip_Reset_Time", (tS32)0xb1cdd14d);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::operator>>(TLastResetTime& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::operator<<(TLastResetTime oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncLast_EcoTrip_Reset_Time::s32SetData(TLastResetTime &tLast_EcoTrip_Reset_TimeParam) {
   //init parameter
   (tVoid)memcpy(&tLast_EcoTrip_Reset_Time,(tVoid*)&tLast_EcoTrip_Reset_TimeParam, sizeof(TLastResetTime));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLast_EcoTrip_Reset_TimeParam' in function 'dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(TLastResetTime)' could be made const reference
tS32 dp_tclVehFuncLast_EcoTrip_Reset_Time::s32SetData(const TLastResetTime &tLast_EcoTrip_Reset_TimeParam) {
   //init parameter
   (tVoid)memcpy(&tLast_EcoTrip_Reset_Time,(tVoid*)&tLast_EcoTrip_Reset_TimeParam, sizeof(TLastResetTime));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tLast_EcoTrip_Reset_TimeParam' in function 'dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(TLastResetTime)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncLast_EcoTrip_Reset_Time::u8GetData(TLastResetTime& tLast_EcoTrip_Reset_TimeParam) {  
   vUpdate();
   tLast_EcoTrip_Reset_TimeParam = tLast_EcoTrip_Reset_Time;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(TLastResetTime &tLast_EcoTrip_Reset_TimeParam) { 
   //init parameter
   (tVoid)memcpy(&tLast_EcoTrip_Reset_Time,(tVoid*)&tLast_EcoTrip_Reset_TimeParam, sizeof(TLastResetTime));
   vStore();
}//lint !e1746: parameter 'tLast_EcoTrip_Reset_TimeParam' in function 'dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(TLastResetTime)' could be made const reference
tVoid dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(const TLastResetTime &tLast_EcoTrip_Reset_TimeParam) { 
   //init parameter
   (tVoid)memcpy(&tLast_EcoTrip_Reset_Time,(tVoid*)&tLast_EcoTrip_Reset_TimeParam, sizeof(TLastResetTime));
   vStore();
}//lint !e1746: parameter 'tLast_EcoTrip_Reset_TimeParam' in function 'dp_tclVehFuncLast_EcoTrip_Reset_Time::vSetData(TLastResetTime)' could be made const reference
tU8   dp_tclVehFuncLast_EcoTrip_Reset_Time::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncLast_EcoTrip_Reset_Time::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "Last_EcoTrip_Reset_Time", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncLast_EcoTrip_Reset_Time::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "Last_EcoTrip_Reset_Time", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncLast_EcoTrip_Reset_Time::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Last_EcoTrip_Reset_Time", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element Last_EcoTrip_Reset_Time has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MainInfoData_OilFilter"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMainInfoData_OilFilter::dp_tclVehFuncMainInfoData_OilFilter(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMainInfoData_OilFilter,0,sizeof(TMainInfoData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMainInfoData_OilFilter::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MainInfoData_OilFilter",(tS32) 0x9212e914);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TMainInfoData)) 
      {
         tMainInfoData_OilFilter = *((TMainInfoData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMainInfoData_OilFilter::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MainInfoData_OilFilter", (tS32)0x9212e914);
   (tVoid)myDpElem.bFillData((tVoid*)&tMainInfoData_OilFilter, (tU32)sizeof(TMainInfoData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMainInfoData_OilFilter::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMainInfoData_OilFilter::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TMainInfoData dp_tclVehFuncMainInfoData_OilFilter::tGetData() {
   vUpdate();
   return tMainInfoData_OilFilter;
};
tS32 dp_tclVehFuncMainInfoData_OilFilter::s32GetData(TMainInfoData& tMainInfoData_OilFilterParam) { 
   vUpdate();
   tMainInfoData_OilFilterParam = tMainInfoData_OilFilter;
   return _s32Status;
}
tS32 dp_tclVehFuncMainInfoData_OilFilter::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MainInfoData_OilFilter", (tS32)0x9212e914);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMainInfoData_OilFilter::operator>>(TMainInfoData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMainInfoData_OilFilter::operator<<(TMainInfoData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMainInfoData_OilFilter::s32SetData(TMainInfoData &tMainInfoData_OilFilterParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_OilFilter,(tVoid*)&tMainInfoData_OilFilterParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_OilFilterParam' in function 'dp_tclVehFuncMainInfoData_OilFilter::vSetData(TMainInfoData)' could be made const reference
tS32 dp_tclVehFuncMainInfoData_OilFilter::s32SetData(const TMainInfoData &tMainInfoData_OilFilterParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_OilFilter,(tVoid*)&tMainInfoData_OilFilterParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_OilFilterParam' in function 'dp_tclVehFuncMainInfoData_OilFilter::vSetData(TMainInfoData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMainInfoData_OilFilter::u8GetData(TMainInfoData& tMainInfoData_OilFilterParam) {  
   vUpdate();
   tMainInfoData_OilFilterParam = tMainInfoData_OilFilter;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMainInfoData_OilFilter::vSetData(TMainInfoData &tMainInfoData_OilFilterParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_OilFilter,(tVoid*)&tMainInfoData_OilFilterParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_OilFilterParam' in function 'dp_tclVehFuncMainInfoData_OilFilter::vSetData(TMainInfoData)' could be made const reference
tVoid dp_tclVehFuncMainInfoData_OilFilter::vSetData(const TMainInfoData &tMainInfoData_OilFilterParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_OilFilter,(tVoid*)&tMainInfoData_OilFilterParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_OilFilterParam' in function 'dp_tclVehFuncMainInfoData_OilFilter::vSetData(TMainInfoData)' could be made const reference
tU8   dp_tclVehFuncMainInfoData_OilFilter::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMainInfoData_OilFilter::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_OilFilter", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_OilFilter::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_OilFilter", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_OilFilter::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MainInfoData_OilFilter", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MainInfoData_OilFilter has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MainInfoData_Tire"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMainInfoData_Tire::dp_tclVehFuncMainInfoData_Tire(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMainInfoData_Tire,0,sizeof(TMainInfoData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMainInfoData_Tire::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MainInfoData_Tire",(tS32) 0xfc1d57ee);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TMainInfoData)) 
      {
         tMainInfoData_Tire = *((TMainInfoData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMainInfoData_Tire::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MainInfoData_Tire", (tS32)0xfc1d57ee);
   (tVoid)myDpElem.bFillData((tVoid*)&tMainInfoData_Tire, (tU32)sizeof(TMainInfoData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMainInfoData_Tire::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMainInfoData_Tire::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TMainInfoData dp_tclVehFuncMainInfoData_Tire::tGetData() {
   vUpdate();
   return tMainInfoData_Tire;
};
tS32 dp_tclVehFuncMainInfoData_Tire::s32GetData(TMainInfoData& tMainInfoData_TireParam) { 
   vUpdate();
   tMainInfoData_TireParam = tMainInfoData_Tire;
   return _s32Status;
}
tS32 dp_tclVehFuncMainInfoData_Tire::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MainInfoData_Tire", (tS32)0xfc1d57ee);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMainInfoData_Tire::operator>>(TMainInfoData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMainInfoData_Tire::operator<<(TMainInfoData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMainInfoData_Tire::s32SetData(TMainInfoData &tMainInfoData_TireParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Tire,(tVoid*)&tMainInfoData_TireParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_TireParam' in function 'dp_tclVehFuncMainInfoData_Tire::vSetData(TMainInfoData)' could be made const reference
tS32 dp_tclVehFuncMainInfoData_Tire::s32SetData(const TMainInfoData &tMainInfoData_TireParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Tire,(tVoid*)&tMainInfoData_TireParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_TireParam' in function 'dp_tclVehFuncMainInfoData_Tire::vSetData(TMainInfoData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMainInfoData_Tire::u8GetData(TMainInfoData& tMainInfoData_TireParam) {  
   vUpdate();
   tMainInfoData_TireParam = tMainInfoData_Tire;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMainInfoData_Tire::vSetData(TMainInfoData &tMainInfoData_TireParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Tire,(tVoid*)&tMainInfoData_TireParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_TireParam' in function 'dp_tclVehFuncMainInfoData_Tire::vSetData(TMainInfoData)' could be made const reference
tVoid dp_tclVehFuncMainInfoData_Tire::vSetData(const TMainInfoData &tMainInfoData_TireParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Tire,(tVoid*)&tMainInfoData_TireParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_TireParam' in function 'dp_tclVehFuncMainInfoData_Tire::vSetData(TMainInfoData)' could be made const reference
tU8   dp_tclVehFuncMainInfoData_Tire::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMainInfoData_Tire::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_Tire", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_Tire::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_Tire", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_Tire::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MainInfoData_Tire", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MainInfoData_Tire has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MainInfoData_User"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMainInfoData_User::dp_tclVehFuncMainInfoData_User(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMainInfoData_User,0,sizeof(TMainInfoData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMainInfoData_User::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MainInfoData_User",(tS32) 0xfc1d5931);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TMainInfoData)) 
      {
         tMainInfoData_User = *((TMainInfoData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMainInfoData_User::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MainInfoData_User", (tS32)0xfc1d5931);
   (tVoid)myDpElem.bFillData((tVoid*)&tMainInfoData_User, (tU32)sizeof(TMainInfoData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMainInfoData_User::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMainInfoData_User::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TMainInfoData dp_tclVehFuncMainInfoData_User::tGetData() {
   vUpdate();
   return tMainInfoData_User;
};
tS32 dp_tclVehFuncMainInfoData_User::s32GetData(TMainInfoData& tMainInfoData_UserParam) { 
   vUpdate();
   tMainInfoData_UserParam = tMainInfoData_User;
   return _s32Status;
}
tS32 dp_tclVehFuncMainInfoData_User::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MainInfoData_User", (tS32)0xfc1d5931);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMainInfoData_User::operator>>(TMainInfoData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMainInfoData_User::operator<<(TMainInfoData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMainInfoData_User::s32SetData(TMainInfoData &tMainInfoData_UserParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_User,(tVoid*)&tMainInfoData_UserParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_UserParam' in function 'dp_tclVehFuncMainInfoData_User::vSetData(TMainInfoData)' could be made const reference
tS32 dp_tclVehFuncMainInfoData_User::s32SetData(const TMainInfoData &tMainInfoData_UserParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_User,(tVoid*)&tMainInfoData_UserParam, sizeof(TMainInfoData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_UserParam' in function 'dp_tclVehFuncMainInfoData_User::vSetData(TMainInfoData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMainInfoData_User::u8GetData(TMainInfoData& tMainInfoData_UserParam) {  
   vUpdate();
   tMainInfoData_UserParam = tMainInfoData_User;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMainInfoData_User::vSetData(TMainInfoData &tMainInfoData_UserParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_User,(tVoid*)&tMainInfoData_UserParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_UserParam' in function 'dp_tclVehFuncMainInfoData_User::vSetData(TMainInfoData)' could be made const reference
tVoid dp_tclVehFuncMainInfoData_User::vSetData(const TMainInfoData &tMainInfoData_UserParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_User,(tVoid*)&tMainInfoData_UserParam, sizeof(TMainInfoData));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_UserParam' in function 'dp_tclVehFuncMainInfoData_User::vSetData(TMainInfoData)' could be made const reference
tU8   dp_tclVehFuncMainInfoData_User::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMainInfoData_User::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_User", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_User::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_User", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_User::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MainInfoData_User", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MainInfoData_User has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MainInfoData_Mileage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMainInfoData_Mileage::dp_tclVehFuncMainInfoData_Mileage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMainInfoData_Mileage,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMainInfoData_Mileage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MainInfoData_Mileage",(tS32) 0x1a524132);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tMainInfoData_Mileage = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMainInfoData_Mileage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MainInfoData_Mileage", (tS32)0x1a524132);
   (tVoid)myDpElem.bFillData((tVoid*)&tMainInfoData_Mileage, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMainInfoData_Mileage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMainInfoData_Mileage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclVehFuncMainInfoData_Mileage::tGetData() {
   vUpdate();
   return tMainInfoData_Mileage;
};
tS32 dp_tclVehFuncMainInfoData_Mileage::s32GetData(tU32& tMainInfoData_MileageParam) { 
   vUpdate();
   tMainInfoData_MileageParam = tMainInfoData_Mileage;
   return _s32Status;
}
tS32 dp_tclVehFuncMainInfoData_Mileage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MainInfoData_Mileage", (tS32)0x1a524132);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMainInfoData_Mileage::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMainInfoData_Mileage::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMainInfoData_Mileage::s32SetData(tU32 &tMainInfoData_MileageParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Mileage,(tVoid*)&tMainInfoData_MileageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_MileageParam' in function 'dp_tclVehFuncMainInfoData_Mileage::vSetData(tU32)' could be made const reference
tS32 dp_tclVehFuncMainInfoData_Mileage::s32SetData(const tU32 &tMainInfoData_MileageParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Mileage,(tVoid*)&tMainInfoData_MileageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoData_MileageParam' in function 'dp_tclVehFuncMainInfoData_Mileage::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMainInfoData_Mileage::u8GetData(tU32& tMainInfoData_MileageParam) {  
   vUpdate();
   tMainInfoData_MileageParam = tMainInfoData_Mileage;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMainInfoData_Mileage::vSetData(tU32 &tMainInfoData_MileageParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Mileage,(tVoid*)&tMainInfoData_MileageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_MileageParam' in function 'dp_tclVehFuncMainInfoData_Mileage::vSetData(tU32)' could be made const reference
tVoid dp_tclVehFuncMainInfoData_Mileage::vSetData(const tU32 &tMainInfoData_MileageParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoData_Mileage,(tVoid*)&tMainInfoData_MileageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tMainInfoData_MileageParam' in function 'dp_tclVehFuncMainInfoData_Mileage::vSetData(tU32)' could be made const reference
tU8   dp_tclVehFuncMainInfoData_Mileage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMainInfoData_Mileage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_Mileage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_Mileage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoData_Mileage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoData_Mileage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MainInfoData_Mileage", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MainInfoData_Mileage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "MainInfoResetFlag"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncMainInfoResetFlag::dp_tclVehFuncMainInfoResetFlag(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tMainInfoResetFlag,0,sizeof(tBool));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncMainInfoResetFlag::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("MainInfoResetFlag",(tS32) 0xfc75af22);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tBool)) 
      {
         tMainInfoResetFlag = *((tBool*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncMainInfoResetFlag::vStore(tVoid) {
   dp_tclBaseElement myDpElem("MainInfoResetFlag", (tS32)0xfc75af22);
   (tVoid)myDpElem.bFillData((tVoid*)&tMainInfoResetFlag, (tU32)sizeof(tBool));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncMainInfoResetFlag::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncMainInfoResetFlag::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tBool dp_tclVehFuncMainInfoResetFlag::tGetData() {
   vUpdate();
   return tMainInfoResetFlag;
};
tS32 dp_tclVehFuncMainInfoResetFlag::s32GetData(tBool& tMainInfoResetFlagParam) { 
   vUpdate();
   tMainInfoResetFlagParam = tMainInfoResetFlag;
   return _s32Status;
}
tS32 dp_tclVehFuncMainInfoResetFlag::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("MainInfoResetFlag", (tS32)0xfc75af22);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncMainInfoResetFlag::operator>>(tBool& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncMainInfoResetFlag::operator<<(tBool oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncMainInfoResetFlag::s32SetData(tBool &tMainInfoResetFlagParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoResetFlag,(tVoid*)&tMainInfoResetFlagParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoResetFlagParam' in function 'dp_tclVehFuncMainInfoResetFlag::vSetData(tBool)' could be made const reference
tS32 dp_tclVehFuncMainInfoResetFlag::s32SetData(const tBool &tMainInfoResetFlagParam) {
   //init parameter
   (tVoid)memcpy(&tMainInfoResetFlag,(tVoid*)&tMainInfoResetFlagParam, sizeof(tBool));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tMainInfoResetFlagParam' in function 'dp_tclVehFuncMainInfoResetFlag::vSetData(tBool)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncMainInfoResetFlag::u8GetData(tBool& tMainInfoResetFlagParam) {  
   vUpdate();
   tMainInfoResetFlagParam = tMainInfoResetFlag;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncMainInfoResetFlag::vSetData(tBool &tMainInfoResetFlagParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoResetFlag,(tVoid*)&tMainInfoResetFlagParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMainInfoResetFlagParam' in function 'dp_tclVehFuncMainInfoResetFlag::vSetData(tBool)' could be made const reference
tVoid dp_tclVehFuncMainInfoResetFlag::vSetData(const tBool &tMainInfoResetFlagParam) { 
   //init parameter
   (tVoid)memcpy(&tMainInfoResetFlag,(tVoid*)&tMainInfoResetFlagParam, sizeof(tBool));
   vStore();
}//lint !e1746: parameter 'tMainInfoResetFlagParam' in function 'dp_tclVehFuncMainInfoResetFlag::vSetData(tBool)' could be made const reference
tU8   dp_tclVehFuncMainInfoResetFlag::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncMainInfoResetFlag::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoResetFlag", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoResetFlag::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "MainInfoResetFlag", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncMainInfoResetFlag::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: MainInfoResetFlag", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element MainInfoResetFlag has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ClinoMeter_AngleValues"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncClinoMeter_AngleValues::dp_tclVehFuncClinoMeter_AngleValues(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tClinoMeter_AngleValues,0,sizeof(TClinometerAngleData));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncClinoMeter_AngleValues::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("ClinoMeter_AngleValues",(tS32) 0x6a37bd7c);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TClinometerAngleData)) 
      {
         tClinoMeter_AngleValues = *((TClinometerAngleData*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncClinoMeter_AngleValues::vStore(tVoid) {
   dp_tclBaseElement myDpElem("ClinoMeter_AngleValues", (tS32)0x6a37bd7c);
   (tVoid)myDpElem.bFillData((tVoid*)&tClinoMeter_AngleValues, (tU32)sizeof(TClinometerAngleData));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncClinoMeter_AngleValues::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncClinoMeter_AngleValues::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TClinometerAngleData dp_tclVehFuncClinoMeter_AngleValues::tGetData() {
   vUpdate();
   return tClinoMeter_AngleValues;
};
tS32 dp_tclVehFuncClinoMeter_AngleValues::s32GetData(TClinometerAngleData& tClinoMeter_AngleValuesParam) { 
   vUpdate();
   tClinoMeter_AngleValuesParam = tClinoMeter_AngleValues;
   return _s32Status;
}
tS32 dp_tclVehFuncClinoMeter_AngleValues::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("ClinoMeter_AngleValues", (tS32)0x6a37bd7c);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncClinoMeter_AngleValues::operator>>(TClinometerAngleData& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncClinoMeter_AngleValues::operator<<(TClinometerAngleData oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncClinoMeter_AngleValues::s32SetData(TClinometerAngleData &tClinoMeter_AngleValuesParam) {
   //init parameter
   (tVoid)memcpy(&tClinoMeter_AngleValues,(tVoid*)&tClinoMeter_AngleValuesParam, sizeof(TClinometerAngleData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClinoMeter_AngleValuesParam' in function 'dp_tclVehFuncClinoMeter_AngleValues::vSetData(TClinometerAngleData)' could be made const reference
tS32 dp_tclVehFuncClinoMeter_AngleValues::s32SetData(const TClinometerAngleData &tClinoMeter_AngleValuesParam) {
   //init parameter
   (tVoid)memcpy(&tClinoMeter_AngleValues,(tVoid*)&tClinoMeter_AngleValuesParam, sizeof(TClinometerAngleData));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tClinoMeter_AngleValuesParam' in function 'dp_tclVehFuncClinoMeter_AngleValues::vSetData(TClinometerAngleData)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncClinoMeter_AngleValues::u8GetData(TClinometerAngleData& tClinoMeter_AngleValuesParam) {  
   vUpdate();
   tClinoMeter_AngleValuesParam = tClinoMeter_AngleValues;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncClinoMeter_AngleValues::vSetData(TClinometerAngleData &tClinoMeter_AngleValuesParam) { 
   //init parameter
   (tVoid)memcpy(&tClinoMeter_AngleValues,(tVoid*)&tClinoMeter_AngleValuesParam, sizeof(TClinometerAngleData));
   vStore();
}//lint !e1746: parameter 'tClinoMeter_AngleValuesParam' in function 'dp_tclVehFuncClinoMeter_AngleValues::vSetData(TClinometerAngleData)' could be made const reference
tVoid dp_tclVehFuncClinoMeter_AngleValues::vSetData(const TClinometerAngleData &tClinoMeter_AngleValuesParam) { 
   //init parameter
   (tVoid)memcpy(&tClinoMeter_AngleValues,(tVoid*)&tClinoMeter_AngleValuesParam, sizeof(TClinometerAngleData));
   vStore();
}//lint !e1746: parameter 'tClinoMeter_AngleValuesParam' in function 'dp_tclVehFuncClinoMeter_AngleValues::vSetData(TClinometerAngleData)' could be made const reference
tU8   dp_tclVehFuncClinoMeter_AngleValues::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncClinoMeter_AngleValues::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "ClinoMeter_AngleValues", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncClinoMeter_AngleValues::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "ClinoMeter_AngleValues", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncClinoMeter_AngleValues::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ClinoMeter_AngleValues", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element ClinoMeter_AngleValues has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "DriverAssistMemDisState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDriverAssistMemDisState::dp_tclVehFuncDriverAssistMemDisState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDriverAssistMemDisState,0,sizeof(TDriverAssistMemDisState));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncDriverAssistMemDisState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("DriverAssistMemDisState",(tS32) 0x2b73f81b);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(TDriverAssistMemDisState)) 
      {
         tDriverAssistMemDisState = *((TDriverAssistMemDisState*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncDriverAssistMemDisState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("DriverAssistMemDisState", (tS32)0x2b73f81b);
   (tVoid)myDpElem.bFillData((tVoid*)&tDriverAssistMemDisState, (tU32)sizeof(TDriverAssistMemDisState));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncDriverAssistMemDisState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncDriverAssistMemDisState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
TDriverAssistMemDisState dp_tclVehFuncDriverAssistMemDisState::tGetData() {
   vUpdate();
   return tDriverAssistMemDisState;
};
tS32 dp_tclVehFuncDriverAssistMemDisState::s32GetData(TDriverAssistMemDisState& tDriverAssistMemDisStateParam) { 
   vUpdate();
   tDriverAssistMemDisStateParam = tDriverAssistMemDisState;
   return _s32Status;
}
tS32 dp_tclVehFuncDriverAssistMemDisState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("DriverAssistMemDisState", (tS32)0x2b73f81b);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncDriverAssistMemDisState::operator>>(TDriverAssistMemDisState& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncDriverAssistMemDisState::operator<<(TDriverAssistMemDisState oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncDriverAssistMemDisState::s32SetData(TDriverAssistMemDisState &tDriverAssistMemDisStateParam) {
   //init parameter
   (tVoid)memcpy(&tDriverAssistMemDisState,(tVoid*)&tDriverAssistMemDisStateParam, sizeof(TDriverAssistMemDisState));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverAssistMemDisStateParam' in function 'dp_tclVehFuncDriverAssistMemDisState::vSetData(TDriverAssistMemDisState)' could be made const reference
tS32 dp_tclVehFuncDriverAssistMemDisState::s32SetData(const TDriverAssistMemDisState &tDriverAssistMemDisStateParam) {
   //init parameter
   (tVoid)memcpy(&tDriverAssistMemDisState,(tVoid*)&tDriverAssistMemDisStateParam, sizeof(TDriverAssistMemDisState));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDriverAssistMemDisStateParam' in function 'dp_tclVehFuncDriverAssistMemDisState::vSetData(TDriverAssistMemDisState)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncDriverAssistMemDisState::u8GetData(TDriverAssistMemDisState& tDriverAssistMemDisStateParam) {  
   vUpdate();
   tDriverAssistMemDisStateParam = tDriverAssistMemDisState;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncDriverAssistMemDisState::vSetData(TDriverAssistMemDisState &tDriverAssistMemDisStateParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverAssistMemDisState,(tVoid*)&tDriverAssistMemDisStateParam, sizeof(TDriverAssistMemDisState));
   vStore();
}//lint !e1746: parameter 'tDriverAssistMemDisStateParam' in function 'dp_tclVehFuncDriverAssistMemDisState::vSetData(TDriverAssistMemDisState)' could be made const reference
tVoid dp_tclVehFuncDriverAssistMemDisState::vSetData(const TDriverAssistMemDisState &tDriverAssistMemDisStateParam) { 
   //init parameter
   (tVoid)memcpy(&tDriverAssistMemDisState,(tVoid*)&tDriverAssistMemDisStateParam, sizeof(TDriverAssistMemDisState));
   vStore();
}//lint !e1746: parameter 'tDriverAssistMemDisStateParam' in function 'dp_tclVehFuncDriverAssistMemDisState::vSetData(TDriverAssistMemDisState)' could be made const reference
tU8   dp_tclVehFuncDriverAssistMemDisState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncDriverAssistMemDisState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "DriverAssistMemDisState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDriverAssistMemDisState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "DriverAssistMemDisState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDriverAssistMemDisState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: DriverAssistMemDisState", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element DriverAssistMemDisState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "FuelConsumptionAverage"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncFuelConsumptionAverage::dp_tclVehFuncFuelConsumptionAverage(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tFuelConsumptionAverage,0,sizeof(tU32));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncFuelConsumptionAverage::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("FuelConsumptionAverage",(tS32) 0x97ba3fc2);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU32)) 
      {
         tFuelConsumptionAverage = *((tU32*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncFuelConsumptionAverage::vStore(tVoid) {
   dp_tclBaseElement myDpElem("FuelConsumptionAverage", (tS32)0x97ba3fc2);
   (tVoid)myDpElem.bFillData((tVoid*)&tFuelConsumptionAverage, (tU32)sizeof(tU32));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncFuelConsumptionAverage::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncFuelConsumptionAverage::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU32 dp_tclVehFuncFuelConsumptionAverage::tGetData() {
   vUpdate();
   return tFuelConsumptionAverage;
};
tS32 dp_tclVehFuncFuelConsumptionAverage::s32GetData(tU32& tFuelConsumptionAverageParam) { 
   vUpdate();
   tFuelConsumptionAverageParam = tFuelConsumptionAverage;
   return _s32Status;
}
tS32 dp_tclVehFuncFuelConsumptionAverage::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("FuelConsumptionAverage", (tS32)0x97ba3fc2);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncFuelConsumptionAverage::operator>>(tU32& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncFuelConsumptionAverage::operator<<(tU32 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncFuelConsumptionAverage::s32SetData(tU32 &tFuelConsumptionAverageParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionAverage,(tVoid*)&tFuelConsumptionAverageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionAverageParam' in function 'dp_tclVehFuncFuelConsumptionAverage::vSetData(tU32)' could be made const reference
tS32 dp_tclVehFuncFuelConsumptionAverage::s32SetData(const tU32 &tFuelConsumptionAverageParam) {
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionAverage,(tVoid*)&tFuelConsumptionAverageParam, sizeof(tU32));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tFuelConsumptionAverageParam' in function 'dp_tclVehFuncFuelConsumptionAverage::vSetData(tU32)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncFuelConsumptionAverage::u8GetData(tU32& tFuelConsumptionAverageParam) {  
   vUpdate();
   tFuelConsumptionAverageParam = tFuelConsumptionAverage;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncFuelConsumptionAverage::vSetData(tU32 &tFuelConsumptionAverageParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionAverage,(tVoid*)&tFuelConsumptionAverageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionAverageParam' in function 'dp_tclVehFuncFuelConsumptionAverage::vSetData(tU32)' could be made const reference
tVoid dp_tclVehFuncFuelConsumptionAverage::vSetData(const tU32 &tFuelConsumptionAverageParam) { 
   //init parameter
   (tVoid)memcpy(&tFuelConsumptionAverage,(tVoid*)&tFuelConsumptionAverageParam, sizeof(tU32));
   vStore();
}//lint !e1746: parameter 'tFuelConsumptionAverageParam' in function 'dp_tclVehFuncFuelConsumptionAverage::vSetData(tU32)' could be made const reference
tU8   dp_tclVehFuncFuelConsumptionAverage::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncFuelConsumptionAverage::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "FuelConsumptionAverage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncFuelConsumptionAverage::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "FuelConsumptionAverage", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncFuelConsumptionAverage::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: FuelConsumptionAverage", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element FuelConsumptionAverage has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "ConsumptionHistory"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncConsumptionHistory::dp_tclVehFuncConsumptionHistory(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 100;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncConsumptionHistory::vStore() {
    dp_tclBaseElement myDpElem("ConsumptionHistory", (tS32)0x2be2c121);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TVehFuncConsumption)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListConsumptionHistory::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TVehFuncConsumption));
                pCurPos += sizeof(TVehFuncConsumption);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TVehFuncConsumption))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncConsumptionHistory::vUpdate() {
   dp_tclBaseElement myDpElem("ConsumptionHistory", (tS32)0x2be2c121);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TVehFuncConsumption)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TVehFuncConsumption));
         TVehFuncConsumption* pBuffer = (TVehFuncConsumption*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncConsumptionHistory::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncConsumptionHistory::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncConsumptionHistory::s32GetElem(tU32 u32NbElem, TVehFuncConsumption& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncConsumptionHistory::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncConsumptionHistory::vPushBack(TVehFuncConsumption &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncConsumptionHistory::vPushBack(const TVehFuncConsumption &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncConsumptionHistory::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncConsumptionHistory::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "ConsumptionHistory", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncConsumptionHistory::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "ConsumptionHistory", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncConsumptionHistory::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: ConsumptionHistory", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element ConsumptionHistory has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Distance_Without_Acc_Current_Trip"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDistance_Without_Acc_Current_Trip::dp_tclVehFuncDistance_Without_Acc_Current_Trip(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tDistance_Without_Acc_Current_Trip,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("Distance_Without_Acc_Current_Trip",(tS32) 0x8e790518L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tDistance_Without_Acc_Current_Trip = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::vStore(tVoid) {
   dp_tclBaseElement myDpElem("Distance_Without_Acc_Current_Trip", (tS32)0x8e790518L);
   (tVoid)myDpElem.bFillData((tVoid*)&tDistance_Without_Acc_Current_Trip, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncDistance_Without_Acc_Current_Trip::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncDistance_Without_Acc_Current_Trip::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncDistance_Without_Acc_Current_Trip::tGetData() {
   vUpdate();
   return tDistance_Without_Acc_Current_Trip;
};
tS32 dp_tclVehFuncDistance_Without_Acc_Current_Trip::s32GetData(tU8& tDistance_Without_Acc_Current_TripParam) { 
   vUpdate();
   tDistance_Without_Acc_Current_TripParam = tDistance_Without_Acc_Current_Trip;
   return _s32Status;
}
tS32 dp_tclVehFuncDistance_Without_Acc_Current_Trip::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("Distance_Without_Acc_Current_Trip", (tS32)0x8e790518L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncDistance_Without_Acc_Current_Trip::s32SetData(tU8 &tDistance_Without_Acc_Current_TripParam) {
   //init parameter
   (tVoid)memcpy(&tDistance_Without_Acc_Current_Trip,(tVoid*)&tDistance_Without_Acc_Current_TripParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistance_Without_Acc_Current_TripParam' in function 'dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncDistance_Without_Acc_Current_Trip::s32SetData(const tU8 &tDistance_Without_Acc_Current_TripParam) {
   //init parameter
   (tVoid)memcpy(&tDistance_Without_Acc_Current_Trip,(tVoid*)&tDistance_Without_Acc_Current_TripParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tDistance_Without_Acc_Current_TripParam' in function 'dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncDistance_Without_Acc_Current_Trip::u8GetData(tU8& tDistance_Without_Acc_Current_TripParam) {  
   vUpdate();
   tDistance_Without_Acc_Current_TripParam = tDistance_Without_Acc_Current_Trip;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(tU8 &tDistance_Without_Acc_Current_TripParam) { 
   //init parameter
   (tVoid)memcpy(&tDistance_Without_Acc_Current_Trip,(tVoid*)&tDistance_Without_Acc_Current_TripParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistance_Without_Acc_Current_TripParam' in function 'dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(const tU8 &tDistance_Without_Acc_Current_TripParam) { 
   //init parameter
   (tVoid)memcpy(&tDistance_Without_Acc_Current_Trip,(tVoid*)&tDistance_Without_Acc_Current_TripParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tDistance_Without_Acc_Current_TripParam' in function 'dp_tclVehFuncDistance_Without_Acc_Current_Trip::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncDistance_Without_Acc_Current_Trip::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncDistance_Without_Acc_Current_Trip::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "Distance_Without_Acc_Current_Trip", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDistance_Without_Acc_Current_Trip::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "Distance_Without_Acc_Current_Trip", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncDistance_Without_Acc_Current_Trip::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Distance_Without_Acc_Current_Trip", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element Distance_Without_Acc_Current_Trip has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "Distance_Without_Acc_History"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncDistance_Without_Acc_History::dp_tclVehFuncDistance_Without_Acc_History(tU16 DPid)
{
    _u16AccessId = DPid;
    _u16AccessType = 0x0006;
    _s32Status = DP_S32_ERR_IDLE;
    _u32MaxList = 	10;     
    
          
    _tList.clear();
    #ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
    vUpdate();
    #endif
};
tVoid dp_tclVehFuncDistance_Without_Acc_History::vStore() {
    dp_tclBaseElement myDpElem("Distance_Without_Acc_History", (tS32)0x6af4245dL);

    if (_tList.size()) 
    {
        tU8* pBuffer;
        try
        {
            pBuffer = new tU8[sizeof(TDistance_WO_Acc_History)*_tList.size()];
        }
        catch(const std::bad_alloc&)
        {
            pBuffer = NULL;
        }
        
        //TListDistance_Without_Acc_History::iterator pos;
        tU8* pCurPos = pBuffer;
        if (pCurPos != NULL) 
        {
            for (tU32 i = 0; i < _tList.size(); i++) 
            {
                (tVoid)memcpy(pCurPos, (tVoid*)&_tList[i], sizeof(TDistance_WO_Acc_History));
                pCurPos += sizeof(TDistance_WO_Acc_History);
            }
            (tVoid)myDpElem.bFillData((tVoid*)pBuffer, ((tU32)sizeof(TDistance_WO_Acc_History))*_tList.size());
            delete[] pBuffer;
            pBuffer = NULL; /*Bug 123144: Safe handling*/
            _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
        }
    }
    else 
    {
        (tVoid)myDpElem.bFillData(NULL, 0);
        _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
    }
}

tVoid dp_tclVehFuncDistance_Without_Acc_History::vUpdate() {
   dp_tclBaseElement myDpElem("Distance_Without_Acc_History", (tS32)0x6af4245dL);
   tU32 u32NbElements = 0;
   _tList.clear();
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) {
      if (myDpElem.u32GetDataLength() == 0) {
         //empty list
      } else if ((myDpElem.u32GetDataLength() % sizeof(TDistance_WO_Acc_History)) == 0) {
         u32NbElements = (tU32)(myDpElem.u32GetDataLength() / sizeof(TDistance_WO_Acc_History));
         TDistance_WO_Acc_History* pBuffer = (TDistance_WO_Acc_History*)myDpElem.pvGetData();
         for(tU32 i=0; i<u32NbElements; i++) {
            _tList.push_back(pBuffer[i]);
         }
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
}
    //read access for pool element 
    //tU32  dp_tclVehFuncDistance_Without_Acc_History::u32GetCount() const {return (tU32)_tList.size();};

    tU32  dp_tclVehFuncDistance_Without_Acc_History::u32GetCount(){
    vUpdate();
    return (tU32)_tList.size();
    };
    
    tS32  dp_tclVehFuncDistance_Without_Acc_History::s32GetElem(tU32 u32NbElem, TDistance_WO_Acc_History& tElem){
        vUpdate();
        if (_tList.size() > u32NbElem) {
            tElem = _tList[u32NbElem];
        } else {
            _s32Status = DP_S32_ERR_NO_ELEMENT;
        }
        return _s32Status;
    };

    tS32 dp_tclVehFuncDistance_Without_Acc_History::s32GetStatus() const {return _s32Status;};

    //write access for pool element 
    tVoid dp_tclVehFuncDistance_Without_Acc_History::vPushBack(TDistance_WO_Acc_History &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 
    
    tVoid dp_tclVehFuncDistance_Without_Acc_History::vPushBack(const TDistance_WO_Acc_History &tElem){
        vUpdate();
        if (_tList.size() == _u32MaxList) {
            _tList.pop_front();
        }
        _tList.push_back(tElem);
        vStore();
    }//lint !e1746 

    tVoid dp_tclVehFuncDistance_Without_Acc_History::vClearList(){
        _tList.clear();
        vStore();
    }
    //notification handling not over processes only for application
    tBool dp_tclVehFuncDistance_Without_Acc_History::bAddNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "Distance_Without_Acc_History", pFunc, u32Event, _u16AccessId);
    }
    tBool dp_tclVehFuncDistance_Without_Acc_History::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
        return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "Distance_Without_Acc_History", pFunc, u32Event, _u16AccessId);
    }
	tBool dp_tclVehFuncDistance_Without_Acc_History::bReloadDpElement(void) {
      tBool bRet = FALSE;
		if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
		{
			fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: Distance_Without_Acc_History", DP_U32_POOL_ID_VEHFUNC);
			bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
		}
		else
		{
			fprintf(stdout,"Element Distance_Without_Acc_History has no shared access type");//Reload only for shared dpelement, otherwise returns false
		}
      return bRet;
	}
 


//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "EV_CatalogBatteryCharge"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncEV_CatalogBatteryCharge::dp_tclVehFuncEV_CatalogBatteryCharge(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tEV_CatalogBatteryCharge,0,sizeof(tU16));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncEV_CatalogBatteryCharge::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("EV_CatalogBatteryCharge",(tS32) 0xa40831aa);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU16)) 
      {
         tEV_CatalogBatteryCharge = *((tU16*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncEV_CatalogBatteryCharge::vStore(tVoid) {
   dp_tclBaseElement myDpElem("EV_CatalogBatteryCharge", (tS32)0xa40831aa);
   (tVoid)myDpElem.bFillData((tVoid*)&tEV_CatalogBatteryCharge, (tU32)sizeof(tU16));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncEV_CatalogBatteryCharge::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncEV_CatalogBatteryCharge::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU16 dp_tclVehFuncEV_CatalogBatteryCharge::tGetData() {
   vUpdate();
   return tEV_CatalogBatteryCharge;
};
tS32 dp_tclVehFuncEV_CatalogBatteryCharge::s32GetData(tU16& tEV_CatalogBatteryChargeParam) { 
   vUpdate();
   tEV_CatalogBatteryChargeParam = tEV_CatalogBatteryCharge;
   return _s32Status;
}
tS32 dp_tclVehFuncEV_CatalogBatteryCharge::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("EV_CatalogBatteryCharge", (tS32)0xa40831aa);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncEV_CatalogBatteryCharge::operator>>(tU16& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncEV_CatalogBatteryCharge::operator<<(tU16 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncEV_CatalogBatteryCharge::s32SetData(tU16 &tEV_CatalogBatteryChargeParam) {
   //init parameter
   (tVoid)memcpy(&tEV_CatalogBatteryCharge,(tVoid*)&tEV_CatalogBatteryChargeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEV_CatalogBatteryChargeParam' in function 'dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(tU16)' could be made const reference
tS32 dp_tclVehFuncEV_CatalogBatteryCharge::s32SetData(const tU16 &tEV_CatalogBatteryChargeParam) {
   //init parameter
   (tVoid)memcpy(&tEV_CatalogBatteryCharge,(tVoid*)&tEV_CatalogBatteryChargeParam, sizeof(tU16));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tEV_CatalogBatteryChargeParam' in function 'dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(tU16)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncEV_CatalogBatteryCharge::u8GetData(tU16& tEV_CatalogBatteryChargeParam) {  
   vUpdate();
   tEV_CatalogBatteryChargeParam = tEV_CatalogBatteryCharge;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(tU16 &tEV_CatalogBatteryChargeParam) { 
   //init parameter
   (tVoid)memcpy(&tEV_CatalogBatteryCharge,(tVoid*)&tEV_CatalogBatteryChargeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tEV_CatalogBatteryChargeParam' in function 'dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(tU16)' could be made const reference
tVoid dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(const tU16 &tEV_CatalogBatteryChargeParam) { 
   //init parameter
   (tVoid)memcpy(&tEV_CatalogBatteryCharge,(tVoid*)&tEV_CatalogBatteryChargeParam, sizeof(tU16));
   vStore();
}//lint !e1746: parameter 'tEV_CatalogBatteryChargeParam' in function 'dp_tclVehFuncEV_CatalogBatteryCharge::vSetData(tU16)' could be made const reference
tU8   dp_tclVehFuncEV_CatalogBatteryCharge::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncEV_CatalogBatteryCharge::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "EV_CatalogBatteryCharge", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEV_CatalogBatteryCharge::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "EV_CatalogBatteryCharge", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncEV_CatalogBatteryCharge::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: EV_CatalogBatteryCharge", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element EV_CatalogBatteryCharge has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingResetActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingResetActivation::dp_tclVehFuncSettingResetActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingResetActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingResetActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingResetActivation",(tS32) 0x9c35fb7f);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingResetActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingResetActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingResetActivation", (tS32)0x9c35fb7f);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingResetActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingResetActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingResetActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingResetActivation::tGetData() {
   vUpdate();
   return tSettingResetActivation;
};
tS32 dp_tclVehFuncSettingResetActivation::s32GetData(tU8& tSettingResetActivationParam) { 
   vUpdate();
   tSettingResetActivationParam = tSettingResetActivation;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingResetActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingResetActivation", (tS32)0x9c35fb7f);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingResetActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingResetActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingResetActivation::s32SetData(tU8 &tSettingResetActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingResetActivation,(tVoid*)&tSettingResetActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingResetActivationParam' in function 'dp_tclVehFuncSettingResetActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingResetActivation::s32SetData(const tU8 &tSettingResetActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingResetActivation,(tVoid*)&tSettingResetActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingResetActivationParam' in function 'dp_tclVehFuncSettingResetActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingResetActivation::u8GetData(tU8& tSettingResetActivationParam) {  
   vUpdate();
   tSettingResetActivationParam = tSettingResetActivation;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingResetActivation::vSetData(tU8 &tSettingResetActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingResetActivation,(tVoid*)&tSettingResetActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingResetActivationParam' in function 'dp_tclVehFuncSettingResetActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingResetActivation::vSetData(const tU8 &tSettingResetActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingResetActivation,(tVoid*)&tSettingResetActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingResetActivationParam' in function 'dp_tclVehFuncSettingResetActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingResetActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingResetActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingResetActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingResetActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingResetActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingResetActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingResetActivation", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingResetActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingADB"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingADB::dp_tclVehFuncSettingADB(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingADB,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingADB::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingADB",(tS32) 0xcafd281);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingADB = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingADB::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingADB", (tS32)0xcafd281);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingADB, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingADB::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingADB::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingADB::tGetData() {
   vUpdate();
   return tSettingADB;
};
tS32 dp_tclVehFuncSettingADB::s32GetData(tU8& tSettingADBParam) { 
   vUpdate();
   tSettingADBParam = tSettingADB;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingADB::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingADB", (tS32)0xcafd281);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingADB::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingADB::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingADB::s32SetData(tU8 &tSettingADBParam) {
   //init parameter
   (tVoid)memcpy(&tSettingADB,(tVoid*)&tSettingADBParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingADBParam' in function 'dp_tclVehFuncSettingADB::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingADB::s32SetData(const tU8 &tSettingADBParam) {
   //init parameter
   (tVoid)memcpy(&tSettingADB,(tVoid*)&tSettingADBParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingADBParam' in function 'dp_tclVehFuncSettingADB::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingADB::u8GetData(tU8& tSettingADBParam) {  
   vUpdate();
   tSettingADBParam = tSettingADB;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingADB::vSetData(tU8 &tSettingADBParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingADB,(tVoid*)&tSettingADBParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingADBParam' in function 'dp_tclVehFuncSettingADB::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingADB::vSetData(const tU8 &tSettingADBParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingADB,(tVoid*)&tSettingADBParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingADBParam' in function 'dp_tclVehFuncSettingADB::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingADB::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingADB::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingADB", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingADB::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingADB", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingADB::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingADB", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingADB has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDrivingSide"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingDrivingSide::dp_tclVehFuncSettingDrivingSide(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDrivingSide,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingDrivingSide::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDrivingSide",(tS32) 0x90310186);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDrivingSide = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingDrivingSide::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDrivingSide", (tS32)0x90310186);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDrivingSide, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingDrivingSide::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingDrivingSide::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingDrivingSide::tGetData() {
   vUpdate();
   return tSettingDrivingSide;
};
tS32 dp_tclVehFuncSettingDrivingSide::s32GetData(tU8& tSettingDrivingSideParam) { 
   vUpdate();
   tSettingDrivingSideParam = tSettingDrivingSide;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingDrivingSide::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDrivingSide", (tS32)0x90310186);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingDrivingSide::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingDrivingSide::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingDrivingSide::s32SetData(tU8 &tSettingDrivingSideParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDrivingSide,(tVoid*)&tSettingDrivingSideParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDrivingSideParam' in function 'dp_tclVehFuncSettingDrivingSide::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingDrivingSide::s32SetData(const tU8 &tSettingDrivingSideParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDrivingSide,(tVoid*)&tSettingDrivingSideParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDrivingSideParam' in function 'dp_tclVehFuncSettingDrivingSide::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingDrivingSide::u8GetData(tU8& tSettingDrivingSideParam) {  
   vUpdate();
   tSettingDrivingSideParam = tSettingDrivingSide;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingDrivingSide::vSetData(tU8 &tSettingDrivingSideParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDrivingSide,(tVoid*)&tSettingDrivingSideParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDrivingSideParam' in function 'dp_tclVehFuncSettingDrivingSide::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingDrivingSide::vSetData(const tU8 &tSettingDrivingSideParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDrivingSide,(tVoid*)&tSettingDrivingSideParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDrivingSideParam' in function 'dp_tclVehFuncSettingDrivingSide::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingDrivingSide::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingDrivingSide::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDrivingSide", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDrivingSide::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDrivingSide", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDrivingSide::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDrivingSide", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingDrivingSide has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingRearWiper"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingRearWiper::dp_tclVehFuncSettingRearWiper(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingRearWiper,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingRearWiper::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingRearWiper",(tS32) 0x57f1b6ff);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingRearWiper = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingRearWiper::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingRearWiper", (tS32)0x57f1b6ff);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingRearWiper, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingRearWiper::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingRearWiper::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingRearWiper::tGetData() {
   vUpdate();
   return tSettingRearWiper;
};
tS32 dp_tclVehFuncSettingRearWiper::s32GetData(tU8& tSettingRearWiperParam) { 
   vUpdate();
   tSettingRearWiperParam = tSettingRearWiper;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingRearWiper::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingRearWiper", (tS32)0x57f1b6ff);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingRearWiper::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingRearWiper::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingRearWiper::s32SetData(tU8 &tSettingRearWiperParam) {
   //init parameter
   (tVoid)memcpy(&tSettingRearWiper,(tVoid*)&tSettingRearWiperParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingRearWiperParam' in function 'dp_tclVehFuncSettingRearWiper::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingRearWiper::s32SetData(const tU8 &tSettingRearWiperParam) {
   //init parameter
   (tVoid)memcpy(&tSettingRearWiper,(tVoid*)&tSettingRearWiperParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingRearWiperParam' in function 'dp_tclVehFuncSettingRearWiper::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingRearWiper::u8GetData(tU8& tSettingRearWiperParam) {  
   vUpdate();
   tSettingRearWiperParam = tSettingRearWiper;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingRearWiper::vSetData(tU8 &tSettingRearWiperParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingRearWiper,(tVoid*)&tSettingRearWiperParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingRearWiperParam' in function 'dp_tclVehFuncSettingRearWiper::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingRearWiper::vSetData(const tU8 &tSettingRearWiperParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingRearWiper,(tVoid*)&tSettingRearWiperParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingRearWiperParam' in function 'dp_tclVehFuncSettingRearWiper::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingRearWiper::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingRearWiper::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingRearWiper", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingRearWiper::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingRearWiper", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingRearWiper::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingRearWiper", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingRearWiper has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAutoRelock"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAutoRelock::dp_tclVehFuncSettingAutoRelock(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAutoRelock,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAutoRelock::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAutoRelock",(tS32) 0xb632f4eb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAutoRelock = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAutoRelock::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAutoRelock", (tS32)0xb632f4eb);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAutoRelock, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAutoRelock::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAutoRelock::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAutoRelock::tGetData() {
   vUpdate();
   return tSettingAutoRelock;
};
tS32 dp_tclVehFuncSettingAutoRelock::s32GetData(tU8& tSettingAutoRelockParam) { 
   vUpdate();
   tSettingAutoRelockParam = tSettingAutoRelock;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAutoRelock::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAutoRelock", (tS32)0xb632f4eb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAutoRelock::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAutoRelock::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAutoRelock::s32SetData(tU8 &tSettingAutoRelockParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoRelock,(tVoid*)&tSettingAutoRelockParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoRelockParam' in function 'dp_tclVehFuncSettingAutoRelock::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAutoRelock::s32SetData(const tU8 &tSettingAutoRelockParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoRelock,(tVoid*)&tSettingAutoRelockParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoRelockParam' in function 'dp_tclVehFuncSettingAutoRelock::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAutoRelock::u8GetData(tU8& tSettingAutoRelockParam) {  
   vUpdate();
   tSettingAutoRelockParam = tSettingAutoRelock;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAutoRelock::vSetData(tU8 &tSettingAutoRelockParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoRelock,(tVoid*)&tSettingAutoRelockParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoRelockParam' in function 'dp_tclVehFuncSettingAutoRelock::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAutoRelock::vSetData(const tU8 &tSettingAutoRelockParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoRelock,(tVoid*)&tSettingAutoRelockParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoRelockParam' in function 'dp_tclVehFuncSettingAutoRelock::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAutoRelock::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAutoRelock::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAutoRelock", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAutoRelock::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAutoRelock", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAutoRelock::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAutoRelock", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAutoRelock has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingIkeyAccess"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingIkeyAccess::dp_tclVehFuncSettingIkeyAccess(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingIkeyAccess,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingIkeyAccess::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingIkeyAccess",(tS32) 0xb6d56c92);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingIkeyAccess = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingIkeyAccess::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingIkeyAccess", (tS32)0xb6d56c92);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingIkeyAccess, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingIkeyAccess::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingIkeyAccess::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingIkeyAccess::tGetData() {
   vUpdate();
   return tSettingIkeyAccess;
};
tS32 dp_tclVehFuncSettingIkeyAccess::s32GetData(tU8& tSettingIkeyAccessParam) { 
   vUpdate();
   tSettingIkeyAccessParam = tSettingIkeyAccess;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingIkeyAccess::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingIkeyAccess", (tS32)0xb6d56c92);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingIkeyAccess::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingIkeyAccess::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingIkeyAccess::s32SetData(tU8 &tSettingIkeyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIkeyAccess,(tVoid*)&tSettingIkeyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIkeyAccessParam' in function 'dp_tclVehFuncSettingIkeyAccess::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingIkeyAccess::s32SetData(const tU8 &tSettingIkeyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingIkeyAccess,(tVoid*)&tSettingIkeyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingIkeyAccessParam' in function 'dp_tclVehFuncSettingIkeyAccess::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingIkeyAccess::u8GetData(tU8& tSettingIkeyAccessParam) {  
   vUpdate();
   tSettingIkeyAccessParam = tSettingIkeyAccess;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingIkeyAccess::vSetData(tU8 &tSettingIkeyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIkeyAccess,(tVoid*)&tSettingIkeyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIkeyAccessParam' in function 'dp_tclVehFuncSettingIkeyAccess::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingIkeyAccess::vSetData(const tU8 &tSettingIkeyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingIkeyAccess,(tVoid*)&tSettingIkeyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingIkeyAccessParam' in function 'dp_tclVehFuncSettingIkeyAccess::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingIkeyAccess::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingIkeyAccess::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingIkeyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingIkeyAccess::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingIkeyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingIkeyAccess::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingIkeyAccess", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingIkeyAccess has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSingleDoorOpening"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSingleDoorOpening::dp_tclVehFuncSettingSingleDoorOpening(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSingleDoorOpening,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSingleDoorOpening::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSingleDoorOpening",(tS32) 0x8c8aa350);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSingleDoorOpening = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSingleDoorOpening::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSingleDoorOpening", (tS32)0x8c8aa350);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSingleDoorOpening, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSingleDoorOpening::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSingleDoorOpening::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSingleDoorOpening::tGetData() {
   vUpdate();
   return tSettingSingleDoorOpening;
};
tS32 dp_tclVehFuncSettingSingleDoorOpening::s32GetData(tU8& tSettingSingleDoorOpeningParam) { 
   vUpdate();
   tSettingSingleDoorOpeningParam = tSettingSingleDoorOpening;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSingleDoorOpening::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSingleDoorOpening", (tS32)0x8c8aa350);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSingleDoorOpening::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSingleDoorOpening::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSingleDoorOpening::s32SetData(tU8 &tSettingSingleDoorOpeningParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSingleDoorOpening,(tVoid*)&tSettingSingleDoorOpeningParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSingleDoorOpeningParam' in function 'dp_tclVehFuncSettingSingleDoorOpening::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSingleDoorOpening::s32SetData(const tU8 &tSettingSingleDoorOpeningParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSingleDoorOpening,(tVoid*)&tSettingSingleDoorOpeningParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSingleDoorOpeningParam' in function 'dp_tclVehFuncSettingSingleDoorOpening::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSingleDoorOpening::u8GetData(tU8& tSettingSingleDoorOpeningParam) {  
   vUpdate();
   tSettingSingleDoorOpeningParam = tSettingSingleDoorOpening;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSingleDoorOpening::vSetData(tU8 &tSettingSingleDoorOpeningParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSingleDoorOpening,(tVoid*)&tSettingSingleDoorOpeningParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSingleDoorOpeningParam' in function 'dp_tclVehFuncSettingSingleDoorOpening::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSingleDoorOpening::vSetData(const tU8 &tSettingSingleDoorOpeningParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSingleDoorOpening,(tVoid*)&tSettingSingleDoorOpeningParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSingleDoorOpeningParam' in function 'dp_tclVehFuncSettingSingleDoorOpening::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSingleDoorOpening::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSingleDoorOpening::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSingleDoorOpening", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSingleDoorOpening::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSingleDoorOpening", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSingleDoorOpening::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSingleDoorOpening", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSingleDoorOpening has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingStorageFormat"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingStorageFormat::dp_tclVehFuncSettingStorageFormat(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingStorageFormat,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingStorageFormat::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingStorageFormat",(tS32) 0xf7b07368);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingStorageFormat = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingStorageFormat::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingStorageFormat", (tS32)0xf7b07368);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingStorageFormat, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingStorageFormat::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingStorageFormat::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingStorageFormat::tGetData() {
   vUpdate();
   return tSettingStorageFormat;
};
tS32 dp_tclVehFuncSettingStorageFormat::s32GetData(tU8& tSettingStorageFormatParam) { 
   vUpdate();
   tSettingStorageFormatParam = tSettingStorageFormat;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingStorageFormat::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingStorageFormat", (tS32)0xf7b07368);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingStorageFormat::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingStorageFormat::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingStorageFormat::s32SetData(tU8 &tSettingStorageFormatParam) {
   //init parameter
   (tVoid)memcpy(&tSettingStorageFormat,(tVoid*)&tSettingStorageFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingStorageFormatParam' in function 'dp_tclVehFuncSettingStorageFormat::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingStorageFormat::s32SetData(const tU8 &tSettingStorageFormatParam) {
   //init parameter
   (tVoid)memcpy(&tSettingStorageFormat,(tVoid*)&tSettingStorageFormatParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingStorageFormatParam' in function 'dp_tclVehFuncSettingStorageFormat::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingStorageFormat::u8GetData(tU8& tSettingStorageFormatParam) {  
   vUpdate();
   tSettingStorageFormatParam = tSettingStorageFormat;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingStorageFormat::vSetData(tU8 &tSettingStorageFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingStorageFormat,(tVoid*)&tSettingStorageFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingStorageFormatParam' in function 'dp_tclVehFuncSettingStorageFormat::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingStorageFormat::vSetData(const tU8 &tSettingStorageFormatParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingStorageFormat,(tVoid*)&tSettingStorageFormatParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingStorageFormatParam' in function 'dp_tclVehFuncSettingStorageFormat::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingStorageFormat::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingStorageFormat::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingStorageFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingStorageFormat::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingStorageFormat", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingStorageFormat::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingStorageFormat", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingStorageFormat has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingDayIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingDayIntensity::dp_tclVehFuncSettingAmbientLightingDayIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingDayIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingDayIntensity",(tS32) 0x99ce86fdL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingDayIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingDayIntensity", (tS32)0x99ce86fdL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingDayIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingDayIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingDayIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingDayIntensity::tGetData() {
   vUpdate();
   return tSettingAmbientLightingDayIntensity;
};
tS32 dp_tclVehFuncSettingAmbientLightingDayIntensity::s32GetData(tU8& tSettingAmbientLightingDayIntensityParam) { 
   vUpdate();
   tSettingAmbientLightingDayIntensityParam = tSettingAmbientLightingDayIntensity;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingDayIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingDayIntensity", (tS32)0x99ce86fdL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingDayIntensity::s32SetData(tU8 &tSettingAmbientLightingDayIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingDayIntensity,(tVoid*)&tSettingAmbientLightingDayIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingDayIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingDayIntensity::s32SetData(const tU8 &tSettingAmbientLightingDayIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingDayIntensity,(tVoid*)&tSettingAmbientLightingDayIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingDayIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingDayIntensity::u8GetData(tU8& tSettingAmbientLightingDayIntensityParam) {  
   vUpdate();
   tSettingAmbientLightingDayIntensityParam = tSettingAmbientLightingDayIntensity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(tU8 &tSettingAmbientLightingDayIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingDayIntensity,(tVoid*)&tSettingAmbientLightingDayIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingDayIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(const tU8 &tSettingAmbientLightingDayIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingDayIntensity,(tVoid*)&tSettingAmbientLightingDayIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingDayIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingDayIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingDayIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingDayIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingDayIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingDayIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingDayIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingDayIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingDayIntensity", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingDayIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingNightIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingNightIntensity::dp_tclVehFuncSettingAmbientLightingNightIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingNightIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingNightIntensity",(tS32) 0x2e946409L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingNightIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingNightIntensity", (tS32)0x2e946409L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingNightIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingNightIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingNightIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingNightIntensity::tGetData() {
   vUpdate();
   return tSettingAmbientLightingNightIntensity;
};
tS32 dp_tclVehFuncSettingAmbientLightingNightIntensity::s32GetData(tU8& tSettingAmbientLightingNightIntensityParam) { 
   vUpdate();
   tSettingAmbientLightingNightIntensityParam = tSettingAmbientLightingNightIntensity;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingNightIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingNightIntensity", (tS32)0x2e946409L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingNightIntensity::s32SetData(tU8 &tSettingAmbientLightingNightIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingNightIntensity,(tVoid*)&tSettingAmbientLightingNightIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingNightIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingNightIntensity::s32SetData(const tU8 &tSettingAmbientLightingNightIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingNightIntensity,(tVoid*)&tSettingAmbientLightingNightIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingNightIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingNightIntensity::u8GetData(tU8& tSettingAmbientLightingNightIntensityParam) {  
   vUpdate();
   tSettingAmbientLightingNightIntensityParam = tSettingAmbientLightingNightIntensity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(tU8 &tSettingAmbientLightingNightIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingNightIntensity,(tVoid*)&tSettingAmbientLightingNightIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingNightIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(const tU8 &tSettingAmbientLightingNightIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingNightIntensity,(tVoid*)&tSettingAmbientLightingNightIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingNightIntensityParam' in function 'dp_tclVehFuncSettingAmbientLightingNightIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingNightIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingNightIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingNightIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingNightIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingNightIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingNightIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingNightIntensity", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingNightIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingArea1"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingArea1::dp_tclVehFuncSettingAmbientLightingArea1(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingArea1,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingArea1::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea1",(tS32) 0x543b6ae2L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingArea1 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingArea1::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea1", (tS32)0x543b6ae2L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingArea1, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingArea1::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingArea1::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingArea1::tGetData() {
   vUpdate();
   return tSettingAmbientLightingArea1;
};
tS32 dp_tclVehFuncSettingAmbientLightingArea1::s32GetData(tU8& tSettingAmbientLightingArea1Param) { 
   vUpdate();
   tSettingAmbientLightingArea1Param = tSettingAmbientLightingArea1;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingArea1::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea1", (tS32)0x543b6ae2L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea1::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingArea1::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingArea1::s32SetData(tU8 &tSettingAmbientLightingArea1Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea1,(tVoid*)&tSettingAmbientLightingArea1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea1Param' in function 'dp_tclVehFuncSettingAmbientLightingArea1::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingArea1::s32SetData(const tU8 &tSettingAmbientLightingArea1Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea1,(tVoid*)&tSettingAmbientLightingArea1Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea1Param' in function 'dp_tclVehFuncSettingAmbientLightingArea1::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingArea1::u8GetData(tU8& tSettingAmbientLightingArea1Param) {  
   vUpdate();
   tSettingAmbientLightingArea1Param = tSettingAmbientLightingArea1;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea1::vSetData(tU8 &tSettingAmbientLightingArea1Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea1,(tVoid*)&tSettingAmbientLightingArea1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea1Param' in function 'dp_tclVehFuncSettingAmbientLightingArea1::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingArea1::vSetData(const tU8 &tSettingAmbientLightingArea1Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea1,(tVoid*)&tSettingAmbientLightingArea1Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea1Param' in function 'dp_tclVehFuncSettingAmbientLightingArea1::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingArea1::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingArea1::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea1::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea1", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea1::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingArea1", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingArea1 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingArea2"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingArea2::dp_tclVehFuncSettingAmbientLightingArea2(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingArea2,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingArea2::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea2",(tS32) 0x543b6ae3L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingArea2 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingArea2::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea2", (tS32)0x543b6ae3L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingArea2, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingArea2::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingArea2::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingArea2::tGetData() {
   vUpdate();
   return tSettingAmbientLightingArea2;
};
tS32 dp_tclVehFuncSettingAmbientLightingArea2::s32GetData(tU8& tSettingAmbientLightingArea2Param) { 
   vUpdate();
   tSettingAmbientLightingArea2Param = tSettingAmbientLightingArea2;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingArea2::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea2", (tS32)0x543b6ae3L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea2::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingArea2::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingArea2::s32SetData(tU8 &tSettingAmbientLightingArea2Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea2,(tVoid*)&tSettingAmbientLightingArea2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea2Param' in function 'dp_tclVehFuncSettingAmbientLightingArea2::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingArea2::s32SetData(const tU8 &tSettingAmbientLightingArea2Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea2,(tVoid*)&tSettingAmbientLightingArea2Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea2Param' in function 'dp_tclVehFuncSettingAmbientLightingArea2::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingArea2::u8GetData(tU8& tSettingAmbientLightingArea2Param) {  
   vUpdate();
   tSettingAmbientLightingArea2Param = tSettingAmbientLightingArea2;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea2::vSetData(tU8 &tSettingAmbientLightingArea2Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea2,(tVoid*)&tSettingAmbientLightingArea2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea2Param' in function 'dp_tclVehFuncSettingAmbientLightingArea2::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingArea2::vSetData(const tU8 &tSettingAmbientLightingArea2Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea2,(tVoid*)&tSettingAmbientLightingArea2Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea2Param' in function 'dp_tclVehFuncSettingAmbientLightingArea2::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingArea2::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingArea2::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea2::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea2", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea2::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingArea2", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingArea2 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingArea3"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingArea3::dp_tclVehFuncSettingAmbientLightingArea3(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingArea3,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingArea3::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea3",(tS32) 0x543b6ae4L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingArea3 = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingArea3::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea3", (tS32)0x543b6ae4L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingArea3, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingArea3::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingArea3::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingArea3::tGetData() {
   vUpdate();
   return tSettingAmbientLightingArea3;
};
tS32 dp_tclVehFuncSettingAmbientLightingArea3::s32GetData(tU8& tSettingAmbientLightingArea3Param) { 
   vUpdate();
   tSettingAmbientLightingArea3Param = tSettingAmbientLightingArea3;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingArea3::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingArea3", (tS32)0x543b6ae4L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea3::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingArea3::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingArea3::s32SetData(tU8 &tSettingAmbientLightingArea3Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea3,(tVoid*)&tSettingAmbientLightingArea3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea3Param' in function 'dp_tclVehFuncSettingAmbientLightingArea3::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingArea3::s32SetData(const tU8 &tSettingAmbientLightingArea3Param) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea3,(tVoid*)&tSettingAmbientLightingArea3Param, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingArea3Param' in function 'dp_tclVehFuncSettingAmbientLightingArea3::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingArea3::u8GetData(tU8& tSettingAmbientLightingArea3Param) {  
   vUpdate();
   tSettingAmbientLightingArea3Param = tSettingAmbientLightingArea3;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingArea3::vSetData(tU8 &tSettingAmbientLightingArea3Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea3,(tVoid*)&tSettingAmbientLightingArea3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea3Param' in function 'dp_tclVehFuncSettingAmbientLightingArea3::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingArea3::vSetData(const tU8 &tSettingAmbientLightingArea3Param) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingArea3,(tVoid*)&tSettingAmbientLightingArea3Param, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingArea3Param' in function 'dp_tclVehFuncSettingAmbientLightingArea3::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingArea3::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingArea3::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea3::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingArea3", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingArea3::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingArea3", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingArea3 has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingPattern"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingPattern::dp_tclVehFuncSettingAmbientLightingPattern(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingPattern,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingPattern::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingPattern",(tS32) 0x39d069b6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingPattern = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingPattern::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingPattern", (tS32)0x39d069b6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingPattern, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingPattern::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingPattern::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingPattern::tGetData() {
   vUpdate();
   return tSettingAmbientLightingPattern;
};
tS32 dp_tclVehFuncSettingAmbientLightingPattern::s32GetData(tU8& tSettingAmbientLightingPatternParam) { 
   vUpdate();
   tSettingAmbientLightingPatternParam = tSettingAmbientLightingPattern;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingPattern::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingPattern", (tS32)0x39d069b6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingPattern::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingPattern::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingPattern::s32SetData(tU8 &tSettingAmbientLightingPatternParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingPattern,(tVoid*)&tSettingAmbientLightingPatternParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingPatternParam' in function 'dp_tclVehFuncSettingAmbientLightingPattern::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingPattern::s32SetData(const tU8 &tSettingAmbientLightingPatternParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingPattern,(tVoid*)&tSettingAmbientLightingPatternParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingPatternParam' in function 'dp_tclVehFuncSettingAmbientLightingPattern::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingPattern::u8GetData(tU8& tSettingAmbientLightingPatternParam) {  
   vUpdate();
   tSettingAmbientLightingPatternParam = tSettingAmbientLightingPattern;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingPattern::vSetData(tU8 &tSettingAmbientLightingPatternParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingPattern,(tVoid*)&tSettingAmbientLightingPatternParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingPatternParam' in function 'dp_tclVehFuncSettingAmbientLightingPattern::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingPattern::vSetData(const tU8 &tSettingAmbientLightingPatternParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingPattern,(tVoid*)&tSettingAmbientLightingPatternParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingPatternParam' in function 'dp_tclVehFuncSettingAmbientLightingPattern::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingPattern::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingPattern::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingPattern", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingPattern::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingPattern", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingPattern::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingPattern", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingPattern has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingActivation::dp_tclVehFuncSettingAmbientLightingActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingActivation",(tS32) 0x390e971eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingActivation", (tS32)0x390e971eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingActivation::tGetData() {
   vUpdate();
   return tSettingAmbientLightingActivation;
};
tS32 dp_tclVehFuncSettingAmbientLightingActivation::s32GetData(tU8& tSettingAmbientLightingActivationParam) { 
   vUpdate();
   tSettingAmbientLightingActivationParam = tSettingAmbientLightingActivation;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingActivation", (tS32)0x390e971eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingActivation::s32SetData(tU8 &tSettingAmbientLightingActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingActivation,(tVoid*)&tSettingAmbientLightingActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingActivationParam' in function 'dp_tclVehFuncSettingAmbientLightingActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingActivation::s32SetData(const tU8 &tSettingAmbientLightingActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingActivation,(tVoid*)&tSettingAmbientLightingActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingActivationParam' in function 'dp_tclVehFuncSettingAmbientLightingActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingActivation::u8GetData(tU8& tSettingAmbientLightingActivationParam) {  
   vUpdate();
   tSettingAmbientLightingActivationParam = tSettingAmbientLightingActivation;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingActivation::vSetData(tU8 &tSettingAmbientLightingActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingActivation,(tVoid*)&tSettingAmbientLightingActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingActivationParam' in function 'dp_tclVehFuncSettingAmbientLightingActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingActivation::vSetData(const tU8 &tSettingAmbientLightingActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingActivation,(tVoid*)&tSettingAmbientLightingActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingActivationParam' in function 'dp_tclVehFuncSettingAmbientLightingActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingActivation", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAmbientLightingColor"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAmbientLightingColor::dp_tclVehFuncSettingAmbientLightingColor(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAmbientLightingColor,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAmbientLightingColor::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAmbientLightingColor",(tS32) 0x543b6f83L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAmbientLightingColor = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAmbientLightingColor::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingColor", (tS32)0x543b6f83L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAmbientLightingColor, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAmbientLightingColor::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAmbientLightingColor::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAmbientLightingColor::tGetData() {
   vUpdate();
   return tSettingAmbientLightingColor;
};
tS32 dp_tclVehFuncSettingAmbientLightingColor::s32GetData(tU8& tSettingAmbientLightingColorParam) { 
   vUpdate();
   tSettingAmbientLightingColorParam = tSettingAmbientLightingColor;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAmbientLightingColor::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAmbientLightingColor", (tS32)0x543b6f83L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAmbientLightingColor::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAmbientLightingColor::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAmbientLightingColor::s32SetData(tU8 &tSettingAmbientLightingColorParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingColor,(tVoid*)&tSettingAmbientLightingColorParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingColorParam' in function 'dp_tclVehFuncSettingAmbientLightingColor::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAmbientLightingColor::s32SetData(const tU8 &tSettingAmbientLightingColorParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingColor,(tVoid*)&tSettingAmbientLightingColorParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAmbientLightingColorParam' in function 'dp_tclVehFuncSettingAmbientLightingColor::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAmbientLightingColor::u8GetData(tU8& tSettingAmbientLightingColorParam) {  
   vUpdate();
   tSettingAmbientLightingColorParam = tSettingAmbientLightingColor;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAmbientLightingColor::vSetData(tU8 &tSettingAmbientLightingColorParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingColor,(tVoid*)&tSettingAmbientLightingColorParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingColorParam' in function 'dp_tclVehFuncSettingAmbientLightingColor::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAmbientLightingColor::vSetData(const tU8 &tSettingAmbientLightingColorParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAmbientLightingColor,(tVoid*)&tSettingAmbientLightingColorParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAmbientLightingColorParam' in function 'dp_tclVehFuncSettingAmbientLightingColor::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAmbientLightingColor::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAmbientLightingColor::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingColor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingColor::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAmbientLightingColor", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAmbientLightingColor::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAmbientLightingColor", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAmbientLightingColor has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingClusterSkin"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingClusterSkin::dp_tclVehFuncSettingClusterSkin(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingClusterSkin,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingClusterSkin::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingClusterSkin",(tS32) 0x8f2f6de9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingClusterSkin = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingClusterSkin::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingClusterSkin", (tS32)0x8f2f6de9);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingClusterSkin, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingClusterSkin::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingClusterSkin::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingClusterSkin::tGetData() {
   vUpdate();
   return tSettingClusterSkin;
};
tS32 dp_tclVehFuncSettingClusterSkin::s32GetData(tU8& tSettingClusterSkinParam) { 
   vUpdate();
   tSettingClusterSkinParam = tSettingClusterSkin;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingClusterSkin::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingClusterSkin", (tS32)0x8f2f6de9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingClusterSkin::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingClusterSkin::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingClusterSkin::s32SetData(tU8 &tSettingClusterSkinParam) {
   //init parameter
   (tVoid)memcpy(&tSettingClusterSkin,(tVoid*)&tSettingClusterSkinParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingClusterSkinParam' in function 'dp_tclVehFuncSettingClusterSkin::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingClusterSkin::s32SetData(const tU8 &tSettingClusterSkinParam) {
   //init parameter
   (tVoid)memcpy(&tSettingClusterSkin,(tVoid*)&tSettingClusterSkinParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingClusterSkinParam' in function 'dp_tclVehFuncSettingClusterSkin::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingClusterSkin::u8GetData(tU8& tSettingClusterSkinParam) {  
   vUpdate();
   tSettingClusterSkinParam = tSettingClusterSkin;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingClusterSkin::vSetData(tU8 &tSettingClusterSkinParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingClusterSkin,(tVoid*)&tSettingClusterSkinParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingClusterSkinParam' in function 'dp_tclVehFuncSettingClusterSkin::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingClusterSkin::vSetData(const tU8 &tSettingClusterSkinParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingClusterSkin,(tVoid*)&tSettingClusterSkinParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingClusterSkinParam' in function 'dp_tclVehFuncSettingClusterSkin::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingClusterSkin::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingClusterSkin::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingClusterSkin", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingClusterSkin::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingClusterSkin", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingClusterSkin::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingClusterSkin", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingClusterSkin has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSailingActivationIdle"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSailingActivationIdle::dp_tclVehFuncSettingSailingActivationIdle(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSailingActivationIdle,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSailingActivationIdle::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSailingActivationIdle",(tS32) 0xb3c46621L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSailingActivationIdle = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSailingActivationIdle::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSailingActivationIdle", (tS32)0xb3c46621L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSailingActivationIdle, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSailingActivationIdle::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSailingActivationIdle::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSailingActivationIdle::tGetData() {
   vUpdate();
   return tSettingSailingActivationIdle;
};
tS32 dp_tclVehFuncSettingSailingActivationIdle::s32GetData(tU8& tSettingSailingActivationIdleParam) { 
   vUpdate();
   tSettingSailingActivationIdleParam = tSettingSailingActivationIdle;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSailingActivationIdle::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSailingActivationIdle", (tS32)0xb3c46621L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSailingActivationIdle::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSailingActivationIdle::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSailingActivationIdle::s32SetData(tU8 &tSettingSailingActivationIdleParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSailingActivationIdle,(tVoid*)&tSettingSailingActivationIdleParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSailingActivationIdleParam' in function 'dp_tclVehFuncSettingSailingActivationIdle::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSailingActivationIdle::s32SetData(const tU8 &tSettingSailingActivationIdleParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSailingActivationIdle,(tVoid*)&tSettingSailingActivationIdleParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSailingActivationIdleParam' in function 'dp_tclVehFuncSettingSailingActivationIdle::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSailingActivationIdle::u8GetData(tU8& tSettingSailingActivationIdleParam) {  
   vUpdate();
   tSettingSailingActivationIdleParam = tSettingSailingActivationIdle;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSailingActivationIdle::vSetData(tU8 &tSettingSailingActivationIdleParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSailingActivationIdle,(tVoid*)&tSettingSailingActivationIdleParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSailingActivationIdleParam' in function 'dp_tclVehFuncSettingSailingActivationIdle::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSailingActivationIdle::vSetData(const tU8 &tSettingSailingActivationIdleParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSailingActivationIdle,(tVoid*)&tSettingSailingActivationIdleParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSailingActivationIdleParam' in function 'dp_tclVehFuncSettingSailingActivationIdle::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSailingActivationIdle::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSailingActivationIdle::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSailingActivationIdle", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSailingActivationIdle::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSailingActivationIdle", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSailingActivationIdle::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSailingActivationIdle", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSailingActivationIdle has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingLKA"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingLKA::dp_tclVehFuncSettingLKA(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingLKA,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingLKA::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingLKA",(tS32) 0xcafd3b6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingLKA = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingLKA::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingLKA", (tS32)0xcafd3b6);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingLKA, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingLKA::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingLKA::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingLKA::tGetData() {
   vUpdate();
   return tSettingLKA;
};
tS32 dp_tclVehFuncSettingLKA::s32GetData(tU8& tSettingLKAParam) { 
   vUpdate();
   tSettingLKAParam = tSettingLKA;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingLKA::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingLKA", (tS32)0xcafd3b6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingLKA::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingLKA::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingLKA::s32SetData(tU8 &tSettingLKAParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLKA,(tVoid*)&tSettingLKAParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLKAParam' in function 'dp_tclVehFuncSettingLKA::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingLKA::s32SetData(const tU8 &tSettingLKAParam) {
   //init parameter
   (tVoid)memcpy(&tSettingLKA,(tVoid*)&tSettingLKAParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingLKAParam' in function 'dp_tclVehFuncSettingLKA::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingLKA::u8GetData(tU8& tSettingLKAParam) {  
   vUpdate();
   tSettingLKAParam = tSettingLKA;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingLKA::vSetData(tU8 &tSettingLKAParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLKA,(tVoid*)&tSettingLKAParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLKAParam' in function 'dp_tclVehFuncSettingLKA::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingLKA::vSetData(const tU8 &tSettingLKAParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingLKA,(tVoid*)&tSettingLKAParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingLKAParam' in function 'dp_tclVehFuncSettingLKA::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingLKA::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingLKA::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingLKA", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingLKA::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingLKA", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingLKA::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingLKA", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingLKA has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingAutoInternalLights"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingAutoInternalLights::dp_tclVehFuncSettingAutoInternalLights(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingAutoInternalLights,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingAutoInternalLights::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingAutoInternalLights",(tS32) 0xb7c03afb);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingAutoInternalLights = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingAutoInternalLights::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingAutoInternalLights", (tS32)0xb7c03afb);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingAutoInternalLights, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingAutoInternalLights::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingAutoInternalLights::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingAutoInternalLights::tGetData() {
   vUpdate();
   return tSettingAutoInternalLights;
};
tS32 dp_tclVehFuncSettingAutoInternalLights::s32GetData(tU8& tSettingAutoInternalLightsParam) { 
   vUpdate();
   tSettingAutoInternalLightsParam = tSettingAutoInternalLights;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingAutoInternalLights::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingAutoInternalLights", (tS32)0xb7c03afb);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingAutoInternalLights::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingAutoInternalLights::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingAutoInternalLights::s32SetData(tU8 &tSettingAutoInternalLightsParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoInternalLights,(tVoid*)&tSettingAutoInternalLightsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoInternalLightsParam' in function 'dp_tclVehFuncSettingAutoInternalLights::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingAutoInternalLights::s32SetData(const tU8 &tSettingAutoInternalLightsParam) {
   //init parameter
   (tVoid)memcpy(&tSettingAutoInternalLights,(tVoid*)&tSettingAutoInternalLightsParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingAutoInternalLightsParam' in function 'dp_tclVehFuncSettingAutoInternalLights::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingAutoInternalLights::u8GetData(tU8& tSettingAutoInternalLightsParam) {  
   vUpdate();
   tSettingAutoInternalLightsParam = tSettingAutoInternalLights;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingAutoInternalLights::vSetData(tU8 &tSettingAutoInternalLightsParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoInternalLights,(tVoid*)&tSettingAutoInternalLightsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoInternalLightsParam' in function 'dp_tclVehFuncSettingAutoInternalLights::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingAutoInternalLights::vSetData(const tU8 &tSettingAutoInternalLightsParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingAutoInternalLights,(tVoid*)&tSettingAutoInternalLightsParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingAutoInternalLightsParam' in function 'dp_tclVehFuncSettingAutoInternalLights::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingAutoInternalLights::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingAutoInternalLights::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAutoInternalLights", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAutoInternalLights::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingAutoInternalLights", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingAutoInternalLights::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingAutoInternalLights", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingAutoInternalLights has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverMassageActivationSetting"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingDriverMassageActivationSetting::dp_tclVehFuncSettingDriverMassageActivationSetting(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverMassageActivationSetting,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverMassageActivationSetting",(tS32) 0x2570f83bL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverMassageActivationSetting = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverMassageActivationSetting", (tS32)0x2570f83bL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverMassageActivationSetting, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingDriverMassageActivationSetting::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingDriverMassageActivationSetting::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingDriverMassageActivationSetting::tGetData() {
   vUpdate();
   return tSettingDriverMassageActivationSetting;
};
tS32 dp_tclVehFuncSettingDriverMassageActivationSetting::s32GetData(tU8& tSettingDriverMassageActivationSettingParam) { 
   vUpdate();
   tSettingDriverMassageActivationSettingParam = tSettingDriverMassageActivationSetting;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingDriverMassageActivationSetting::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverMassageActivationSetting", (tS32)0x2570f83bL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingDriverMassageActivationSetting::s32SetData(tU8 &tSettingDriverMassageActivationSettingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivationSetting,(tVoid*)&tSettingDriverMassageActivationSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageActivationSettingParam' in function 'dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingDriverMassageActivationSetting::s32SetData(const tU8 &tSettingDriverMassageActivationSettingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivationSetting,(tVoid*)&tSettingDriverMassageActivationSettingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverMassageActivationSettingParam' in function 'dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingDriverMassageActivationSetting::u8GetData(tU8& tSettingDriverMassageActivationSettingParam) {  
   vUpdate();
   tSettingDriverMassageActivationSettingParam = tSettingDriverMassageActivationSetting;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(tU8 &tSettingDriverMassageActivationSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivationSetting,(tVoid*)&tSettingDriverMassageActivationSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageActivationSettingParam' in function 'dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(const tU8 &tSettingDriverMassageActivationSettingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverMassageActivationSetting,(tVoid*)&tSettingDriverMassageActivationSettingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverMassageActivationSettingParam' in function 'dp_tclVehFuncSettingDriverMassageActivationSetting::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingDriverMassageActivationSetting::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingDriverMassageActivationSetting::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDriverMassageActivationSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDriverMassageActivationSetting::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDriverMassageActivationSetting", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDriverMassageActivationSetting::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverMassageActivationSetting", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverMassageActivationSetting has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingDriverEasyAccess"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingDriverEasyAccess::dp_tclVehFuncSettingDriverEasyAccess(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingDriverEasyAccess,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingDriverEasyAccess::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingDriverEasyAccess",(tS32) 0x1955f8b6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingDriverEasyAccess = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingDriverEasyAccess::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingDriverEasyAccess", (tS32)0x1955f8b6);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingDriverEasyAccess, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingDriverEasyAccess::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingDriverEasyAccess::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingDriverEasyAccess::tGetData() {
   vUpdate();
   return tSettingDriverEasyAccess;
};
tS32 dp_tclVehFuncSettingDriverEasyAccess::s32GetData(tU8& tSettingDriverEasyAccessParam) { 
   vUpdate();
   tSettingDriverEasyAccessParam = tSettingDriverEasyAccess;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingDriverEasyAccess::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingDriverEasyAccess", (tS32)0x1955f8b6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingDriverEasyAccess::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingDriverEasyAccess::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingDriverEasyAccess::s32SetData(tU8 &tSettingDriverEasyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverEasyAccess,(tVoid*)&tSettingDriverEasyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverEasyAccessParam' in function 'dp_tclVehFuncSettingDriverEasyAccess::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingDriverEasyAccess::s32SetData(const tU8 &tSettingDriverEasyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingDriverEasyAccess,(tVoid*)&tSettingDriverEasyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingDriverEasyAccessParam' in function 'dp_tclVehFuncSettingDriverEasyAccess::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingDriverEasyAccess::u8GetData(tU8& tSettingDriverEasyAccessParam) {  
   vUpdate();
   tSettingDriverEasyAccessParam = tSettingDriverEasyAccess;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingDriverEasyAccess::vSetData(tU8 &tSettingDriverEasyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverEasyAccess,(tVoid*)&tSettingDriverEasyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverEasyAccessParam' in function 'dp_tclVehFuncSettingDriverEasyAccess::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingDriverEasyAccess::vSetData(const tU8 &tSettingDriverEasyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingDriverEasyAccess,(tVoid*)&tSettingDriverEasyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingDriverEasyAccessParam' in function 'dp_tclVehFuncSettingDriverEasyAccess::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingDriverEasyAccess::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingDriverEasyAccess::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDriverEasyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDriverEasyAccess::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingDriverEasyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingDriverEasyAccess::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingDriverEasyAccess", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingDriverEasyAccess has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerMassageActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerMassageActivation::dp_tclVehFuncSettingPassengerMassageActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerMassageActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerMassageActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerMassageActivation",(tS32) 0x9079737dL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerMassageActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerMassageActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageActivation", (tS32)0x9079737dL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerMassageActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerMassageActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerMassageActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerMassageActivation::tGetData() {
   vUpdate();
   return tSettingPassengerMassageActivation;
};
tS32 dp_tclVehFuncSettingPassengerMassageActivation::s32GetData(tU8& tSettingPassengerMassageActivationParam) { 
   vUpdate();
   tSettingPassengerMassageActivationParam = tSettingPassengerMassageActivation;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerMassageActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageActivation", (tS32)0x9079737dL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerMassageActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerMassageActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerMassageActivation::s32SetData(tU8 &tSettingPassengerMassageActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageActivation,(tVoid*)&tSettingPassengerMassageActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageActivationParam' in function 'dp_tclVehFuncSettingPassengerMassageActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerMassageActivation::s32SetData(const tU8 &tSettingPassengerMassageActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageActivation,(tVoid*)&tSettingPassengerMassageActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageActivationParam' in function 'dp_tclVehFuncSettingPassengerMassageActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerMassageActivation::u8GetData(tU8& tSettingPassengerMassageActivationParam) {  
   vUpdate();
   tSettingPassengerMassageActivationParam = tSettingPassengerMassageActivation;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerMassageActivation::vSetData(tU8 &tSettingPassengerMassageActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageActivation,(tVoid*)&tSettingPassengerMassageActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageActivationParam' in function 'dp_tclVehFuncSettingPassengerMassageActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerMassageActivation::vSetData(const tU8 &tSettingPassengerMassageActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageActivation,(tVoid*)&tSettingPassengerMassageActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageActivationParam' in function 'dp_tclVehFuncSettingPassengerMassageActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerMassageActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerMassageActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerMassageActivation", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerMassageActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerMassageProgramState"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerMassageProgramState::dp_tclVehFuncSettingPassengerMassageProgramState(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerMassageProgramState,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerMassageProgramState::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerMassageProgramState",(tS32) 0x4f9917fcL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerMassageProgramState = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerMassageProgramState::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageProgramState", (tS32)0x4f9917fcL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerMassageProgramState, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerMassageProgramState::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerMassageProgramState::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerMassageProgramState::tGetData() {
   vUpdate();
   return tSettingPassengerMassageProgramState;
};
tS32 dp_tclVehFuncSettingPassengerMassageProgramState::s32GetData(tU8& tSettingPassengerMassageProgramStateParam) { 
   vUpdate();
   tSettingPassengerMassageProgramStateParam = tSettingPassengerMassageProgramState;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerMassageProgramState::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageProgramState", (tS32)0x4f9917fcL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerMassageProgramState::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerMassageProgramState::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerMassageProgramState::s32SetData(tU8 &tSettingPassengerMassageProgramStateParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageProgramState,(tVoid*)&tSettingPassengerMassageProgramStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageProgramStateParam' in function 'dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerMassageProgramState::s32SetData(const tU8 &tSettingPassengerMassageProgramStateParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageProgramState,(tVoid*)&tSettingPassengerMassageProgramStateParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageProgramStateParam' in function 'dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerMassageProgramState::u8GetData(tU8& tSettingPassengerMassageProgramStateParam) {  
   vUpdate();
   tSettingPassengerMassageProgramStateParam = tSettingPassengerMassageProgramState;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(tU8 &tSettingPassengerMassageProgramStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageProgramState,(tVoid*)&tSettingPassengerMassageProgramStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageProgramStateParam' in function 'dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(const tU8 &tSettingPassengerMassageProgramStateParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageProgramState,(tVoid*)&tSettingPassengerMassageProgramStateParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageProgramStateParam' in function 'dp_tclVehFuncSettingPassengerMassageProgramState::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerMassageProgramState::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerMassageProgramState::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageProgramState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageProgramState::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageProgramState", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageProgramState::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerMassageProgramState", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerMassageProgramState has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerMassageVelocity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerMassageVelocity::dp_tclVehFuncSettingPassengerMassageVelocity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerMassageVelocity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerMassageVelocity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerMassageVelocity",(tS32) 0x9f7a2bd6L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerMassageVelocity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerMassageVelocity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageVelocity", (tS32)0x9f7a2bd6L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerMassageVelocity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerMassageVelocity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerMassageVelocity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerMassageVelocity::tGetData() {
   vUpdate();
   return tSettingPassengerMassageVelocity;
};
tS32 dp_tclVehFuncSettingPassengerMassageVelocity::s32GetData(tU8& tSettingPassengerMassageVelocityParam) { 
   vUpdate();
   tSettingPassengerMassageVelocityParam = tSettingPassengerMassageVelocity;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerMassageVelocity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageVelocity", (tS32)0x9f7a2bd6L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerMassageVelocity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerMassageVelocity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerMassageVelocity::s32SetData(tU8 &tSettingPassengerMassageVelocityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageVelocity,(tVoid*)&tSettingPassengerMassageVelocityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageVelocityParam' in function 'dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerMassageVelocity::s32SetData(const tU8 &tSettingPassengerMassageVelocityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageVelocity,(tVoid*)&tSettingPassengerMassageVelocityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageVelocityParam' in function 'dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerMassageVelocity::u8GetData(tU8& tSettingPassengerMassageVelocityParam) {  
   vUpdate();
   tSettingPassengerMassageVelocityParam = tSettingPassengerMassageVelocity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(tU8 &tSettingPassengerMassageVelocityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageVelocity,(tVoid*)&tSettingPassengerMassageVelocityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageVelocityParam' in function 'dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(const tU8 &tSettingPassengerMassageVelocityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageVelocity,(tVoid*)&tSettingPassengerMassageVelocityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageVelocityParam' in function 'dp_tclVehFuncSettingPassengerMassageVelocity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerMassageVelocity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerMassageVelocity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageVelocity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageVelocity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageVelocity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageVelocity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerMassageVelocity", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerMassageVelocity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerMassageIntensity"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerMassageIntensity::dp_tclVehFuncSettingPassengerMassageIntensity(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerMassageIntensity,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerMassageIntensity::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerMassageIntensity",(tS32) 0x1d21a696L);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerMassageIntensity = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerMassageIntensity::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageIntensity", (tS32)0x1d21a696L);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerMassageIntensity, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerMassageIntensity::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerMassageIntensity::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerMassageIntensity::tGetData() {
   vUpdate();
   return tSettingPassengerMassageIntensity;
};
tS32 dp_tclVehFuncSettingPassengerMassageIntensity::s32GetData(tU8& tSettingPassengerMassageIntensityParam) { 
   vUpdate();
   tSettingPassengerMassageIntensityParam = tSettingPassengerMassageIntensity;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerMassageIntensity::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerMassageIntensity", (tS32)0x1d21a696L);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerMassageIntensity::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerMassageIntensity::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerMassageIntensity::s32SetData(tU8 &tSettingPassengerMassageIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageIntensity,(tVoid*)&tSettingPassengerMassageIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageIntensityParam' in function 'dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerMassageIntensity::s32SetData(const tU8 &tSettingPassengerMassageIntensityParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageIntensity,(tVoid*)&tSettingPassengerMassageIntensityParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerMassageIntensityParam' in function 'dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerMassageIntensity::u8GetData(tU8& tSettingPassengerMassageIntensityParam) {  
   vUpdate();
   tSettingPassengerMassageIntensityParam = tSettingPassengerMassageIntensity;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(tU8 &tSettingPassengerMassageIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageIntensity,(tVoid*)&tSettingPassengerMassageIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageIntensityParam' in function 'dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(const tU8 &tSettingPassengerMassageIntensityParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerMassageIntensity,(tVoid*)&tSettingPassengerMassageIntensityParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerMassageIntensityParam' in function 'dp_tclVehFuncSettingPassengerMassageIntensity::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerMassageIntensity::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerMassageIntensity::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageIntensity::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerMassageIntensity", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerMassageIntensity::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerMassageIntensity", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerMassageIntensity has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerVentil"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerVentil::dp_tclVehFuncSettingPassengerVentil(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerVentil,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerVentil::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerVentil",(tS32) 0xc6db03f4);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerVentil = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerVentil::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerVentil", (tS32)0xc6db03f4);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerVentil, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerVentil::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerVentil::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerVentil::tGetData() {
   vUpdate();
   return tSettingPassengerVentil;
};
tS32 dp_tclVehFuncSettingPassengerVentil::s32GetData(tU8& tSettingPassengerVentilParam) { 
   vUpdate();
   tSettingPassengerVentilParam = tSettingPassengerVentil;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerVentil::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerVentil", (tS32)0xc6db03f4);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerVentil::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerVentil::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerVentil::s32SetData(tU8 &tSettingPassengerVentilParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerVentil,(tVoid*)&tSettingPassengerVentilParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerVentilParam' in function 'dp_tclVehFuncSettingPassengerVentil::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerVentil::s32SetData(const tU8 &tSettingPassengerVentilParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerVentil,(tVoid*)&tSettingPassengerVentilParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerVentilParam' in function 'dp_tclVehFuncSettingPassengerVentil::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerVentil::u8GetData(tU8& tSettingPassengerVentilParam) {  
   vUpdate();
   tSettingPassengerVentilParam = tSettingPassengerVentil;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerVentil::vSetData(tU8 &tSettingPassengerVentilParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerVentil,(tVoid*)&tSettingPassengerVentilParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerVentilParam' in function 'dp_tclVehFuncSettingPassengerVentil::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerVentil::vSetData(const tU8 &tSettingPassengerVentilParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerVentil,(tVoid*)&tSettingPassengerVentilParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerVentilParam' in function 'dp_tclVehFuncSettingPassengerVentil::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerVentil::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerVentil::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerVentil", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerVentil::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerVentil", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerVentil::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerVentil", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerVentil has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerHeating"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerHeating::dp_tclVehFuncSettingPassengerHeating(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerHeating,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerHeating::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerHeating",(tS32) 0xe2439dfa);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerHeating = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerHeating::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerHeating", (tS32)0xe2439dfa);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerHeating, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerHeating::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerHeating::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerHeating::tGetData() {
   vUpdate();
   return tSettingPassengerHeating;
};
tS32 dp_tclVehFuncSettingPassengerHeating::s32GetData(tU8& tSettingPassengerHeatingParam) { 
   vUpdate();
   tSettingPassengerHeatingParam = tSettingPassengerHeating;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerHeating::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerHeating", (tS32)0xe2439dfa);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerHeating::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerHeating::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerHeating::s32SetData(tU8 &tSettingPassengerHeatingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerHeating,(tVoid*)&tSettingPassengerHeatingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerHeatingParam' in function 'dp_tclVehFuncSettingPassengerHeating::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerHeating::s32SetData(const tU8 &tSettingPassengerHeatingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerHeating,(tVoid*)&tSettingPassengerHeatingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerHeatingParam' in function 'dp_tclVehFuncSettingPassengerHeating::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerHeating::u8GetData(tU8& tSettingPassengerHeatingParam) {  
   vUpdate();
   tSettingPassengerHeatingParam = tSettingPassengerHeating;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerHeating::vSetData(tU8 &tSettingPassengerHeatingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerHeating,(tVoid*)&tSettingPassengerHeatingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerHeatingParam' in function 'dp_tclVehFuncSettingPassengerHeating::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerHeating::vSetData(const tU8 &tSettingPassengerHeatingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerHeating,(tVoid*)&tSettingPassengerHeatingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerHeatingParam' in function 'dp_tclVehFuncSettingPassengerHeating::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerHeating::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerHeating::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerHeating", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerHeating::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerHeating", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerHeating::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerHeating", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerHeating has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingPassengerEasyAccess"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingPassengerEasyAccess::dp_tclVehFuncSettingPassengerEasyAccess(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingPassengerEasyAccess,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingPassengerEasyAccess::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingPassengerEasyAccess",(tS32) 0x7aa7912eL);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingPassengerEasyAccess = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingPassengerEasyAccess::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingPassengerEasyAccess", (tS32)0x7aa7912eL);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingPassengerEasyAccess, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingPassengerEasyAccess::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingPassengerEasyAccess::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingPassengerEasyAccess::tGetData() {
   vUpdate();
   return tSettingPassengerEasyAccess;
};
tS32 dp_tclVehFuncSettingPassengerEasyAccess::s32GetData(tU8& tSettingPassengerEasyAccessParam) { 
   vUpdate();
   tSettingPassengerEasyAccessParam = tSettingPassengerEasyAccess;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingPassengerEasyAccess::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingPassengerEasyAccess", (tS32)0x7aa7912eL);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingPassengerEasyAccess::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingPassengerEasyAccess::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingPassengerEasyAccess::s32SetData(tU8 &tSettingPassengerEasyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerEasyAccess,(tVoid*)&tSettingPassengerEasyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerEasyAccessParam' in function 'dp_tclVehFuncSettingPassengerEasyAccess::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingPassengerEasyAccess::s32SetData(const tU8 &tSettingPassengerEasyAccessParam) {
   //init parameter
   (tVoid)memcpy(&tSettingPassengerEasyAccess,(tVoid*)&tSettingPassengerEasyAccessParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingPassengerEasyAccessParam' in function 'dp_tclVehFuncSettingPassengerEasyAccess::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingPassengerEasyAccess::u8GetData(tU8& tSettingPassengerEasyAccessParam) {  
   vUpdate();
   tSettingPassengerEasyAccessParam = tSettingPassengerEasyAccess;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingPassengerEasyAccess::vSetData(tU8 &tSettingPassengerEasyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerEasyAccess,(tVoid*)&tSettingPassengerEasyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerEasyAccessParam' in function 'dp_tclVehFuncSettingPassengerEasyAccess::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingPassengerEasyAccess::vSetData(const tU8 &tSettingPassengerEasyAccessParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingPassengerEasyAccess,(tVoid*)&tSettingPassengerEasyAccessParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingPassengerEasyAccessParam' in function 'dp_tclVehFuncSettingPassengerEasyAccess::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingPassengerEasyAccess::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingPassengerEasyAccess::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerEasyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerEasyAccess::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingPassengerEasyAccess", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingPassengerEasyAccess::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingPassengerEasyAccess", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingPassengerEasyAccess has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSeat1_Folding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSeat1_Folding::dp_tclVehFuncSettingSeat1_Folding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSeat1_Folding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSeat1_Folding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSeat1_Folding",(tS32) 0xc2f0e416);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSeat1_Folding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSeat1_Folding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSeat1_Folding", (tS32)0xc2f0e416);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSeat1_Folding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSeat1_Folding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSeat1_Folding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSeat1_Folding::tGetData() {
   vUpdate();
   return tSettingSeat1_Folding;
};
tS32 dp_tclVehFuncSettingSeat1_Folding::s32GetData(tU8& tSettingSeat1_FoldingParam) { 
   vUpdate();
   tSettingSeat1_FoldingParam = tSettingSeat1_Folding;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSeat1_Folding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSeat1_Folding", (tS32)0xc2f0e416);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSeat1_Folding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSeat1_Folding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSeat1_Folding::s32SetData(tU8 &tSettingSeat1_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat1_Folding,(tVoid*)&tSettingSeat1_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat1_FoldingParam' in function 'dp_tclVehFuncSettingSeat1_Folding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSeat1_Folding::s32SetData(const tU8 &tSettingSeat1_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat1_Folding,(tVoid*)&tSettingSeat1_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat1_FoldingParam' in function 'dp_tclVehFuncSettingSeat1_Folding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSeat1_Folding::u8GetData(tU8& tSettingSeat1_FoldingParam) {  
   vUpdate();
   tSettingSeat1_FoldingParam = tSettingSeat1_Folding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSeat1_Folding::vSetData(tU8 &tSettingSeat1_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat1_Folding,(tVoid*)&tSettingSeat1_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat1_FoldingParam' in function 'dp_tclVehFuncSettingSeat1_Folding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSeat1_Folding::vSetData(const tU8 &tSettingSeat1_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat1_Folding,(tVoid*)&tSettingSeat1_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat1_FoldingParam' in function 'dp_tclVehFuncSettingSeat1_Folding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSeat1_Folding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSeat1_Folding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat1_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat1_Folding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat1_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat1_Folding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSeat1_Folding", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSeat1_Folding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSeat2_Folding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSeat2_Folding::dp_tclVehFuncSettingSeat2_Folding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSeat2_Folding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSeat2_Folding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSeat2_Folding",(tS32) 0xc2f6d9f7);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSeat2_Folding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSeat2_Folding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSeat2_Folding", (tS32)0xc2f6d9f7);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSeat2_Folding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSeat2_Folding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSeat2_Folding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSeat2_Folding::tGetData() {
   vUpdate();
   return tSettingSeat2_Folding;
};
tS32 dp_tclVehFuncSettingSeat2_Folding::s32GetData(tU8& tSettingSeat2_FoldingParam) { 
   vUpdate();
   tSettingSeat2_FoldingParam = tSettingSeat2_Folding;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSeat2_Folding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSeat2_Folding", (tS32)0xc2f6d9f7);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSeat2_Folding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSeat2_Folding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSeat2_Folding::s32SetData(tU8 &tSettingSeat2_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat2_Folding,(tVoid*)&tSettingSeat2_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat2_FoldingParam' in function 'dp_tclVehFuncSettingSeat2_Folding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSeat2_Folding::s32SetData(const tU8 &tSettingSeat2_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat2_Folding,(tVoid*)&tSettingSeat2_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat2_FoldingParam' in function 'dp_tclVehFuncSettingSeat2_Folding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSeat2_Folding::u8GetData(tU8& tSettingSeat2_FoldingParam) {  
   vUpdate();
   tSettingSeat2_FoldingParam = tSettingSeat2_Folding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSeat2_Folding::vSetData(tU8 &tSettingSeat2_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat2_Folding,(tVoid*)&tSettingSeat2_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat2_FoldingParam' in function 'dp_tclVehFuncSettingSeat2_Folding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSeat2_Folding::vSetData(const tU8 &tSettingSeat2_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat2_Folding,(tVoid*)&tSettingSeat2_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat2_FoldingParam' in function 'dp_tclVehFuncSettingSeat2_Folding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSeat2_Folding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSeat2_Folding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat2_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat2_Folding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat2_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat2_Folding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSeat2_Folding", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSeat2_Folding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSeat3_Folding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSeat3_Folding::dp_tclVehFuncSettingSeat3_Folding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSeat3_Folding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSeat3_Folding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSeat3_Folding",(tS32) 0xc2fccfd8);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSeat3_Folding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSeat3_Folding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSeat3_Folding", (tS32)0xc2fccfd8);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSeat3_Folding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSeat3_Folding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSeat3_Folding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSeat3_Folding::tGetData() {
   vUpdate();
   return tSettingSeat3_Folding;
};
tS32 dp_tclVehFuncSettingSeat3_Folding::s32GetData(tU8& tSettingSeat3_FoldingParam) { 
   vUpdate();
   tSettingSeat3_FoldingParam = tSettingSeat3_Folding;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSeat3_Folding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSeat3_Folding", (tS32)0xc2fccfd8);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSeat3_Folding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSeat3_Folding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSeat3_Folding::s32SetData(tU8 &tSettingSeat3_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat3_Folding,(tVoid*)&tSettingSeat3_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat3_FoldingParam' in function 'dp_tclVehFuncSettingSeat3_Folding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSeat3_Folding::s32SetData(const tU8 &tSettingSeat3_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat3_Folding,(tVoid*)&tSettingSeat3_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat3_FoldingParam' in function 'dp_tclVehFuncSettingSeat3_Folding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSeat3_Folding::u8GetData(tU8& tSettingSeat3_FoldingParam) {  
   vUpdate();
   tSettingSeat3_FoldingParam = tSettingSeat3_Folding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSeat3_Folding::vSetData(tU8 &tSettingSeat3_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat3_Folding,(tVoid*)&tSettingSeat3_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat3_FoldingParam' in function 'dp_tclVehFuncSettingSeat3_Folding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSeat3_Folding::vSetData(const tU8 &tSettingSeat3_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat3_Folding,(tVoid*)&tSettingSeat3_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat3_FoldingParam' in function 'dp_tclVehFuncSettingSeat3_Folding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSeat3_Folding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSeat3_Folding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat3_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat3_Folding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat3_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat3_Folding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSeat3_Folding", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSeat3_Folding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSeat4_Folding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSeat4_Folding::dp_tclVehFuncSettingSeat4_Folding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSeat4_Folding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSeat4_Folding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSeat4_Folding",(tS32) 0xc302c5b9);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSeat4_Folding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSeat4_Folding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSeat4_Folding", (tS32)0xc302c5b9);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSeat4_Folding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSeat4_Folding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSeat4_Folding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSeat4_Folding::tGetData() {
   vUpdate();
   return tSettingSeat4_Folding;
};
tS32 dp_tclVehFuncSettingSeat4_Folding::s32GetData(tU8& tSettingSeat4_FoldingParam) { 
   vUpdate();
   tSettingSeat4_FoldingParam = tSettingSeat4_Folding;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSeat4_Folding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSeat4_Folding", (tS32)0xc302c5b9);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSeat4_Folding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSeat4_Folding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSeat4_Folding::s32SetData(tU8 &tSettingSeat4_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat4_Folding,(tVoid*)&tSettingSeat4_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat4_FoldingParam' in function 'dp_tclVehFuncSettingSeat4_Folding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSeat4_Folding::s32SetData(const tU8 &tSettingSeat4_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat4_Folding,(tVoid*)&tSettingSeat4_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat4_FoldingParam' in function 'dp_tclVehFuncSettingSeat4_Folding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSeat4_Folding::u8GetData(tU8& tSettingSeat4_FoldingParam) {  
   vUpdate();
   tSettingSeat4_FoldingParam = tSettingSeat4_Folding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSeat4_Folding::vSetData(tU8 &tSettingSeat4_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat4_Folding,(tVoid*)&tSettingSeat4_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat4_FoldingParam' in function 'dp_tclVehFuncSettingSeat4_Folding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSeat4_Folding::vSetData(const tU8 &tSettingSeat4_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat4_Folding,(tVoid*)&tSettingSeat4_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat4_FoldingParam' in function 'dp_tclVehFuncSettingSeat4_Folding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSeat4_Folding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSeat4_Folding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat4_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat4_Folding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat4_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat4_Folding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSeat4_Folding", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSeat4_Folding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingSeat5_Folding"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingSeat5_Folding::dp_tclVehFuncSettingSeat5_Folding(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingSeat5_Folding,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingSeat5_Folding::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingSeat5_Folding",(tS32) 0xc308bb9a);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingSeat5_Folding = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingSeat5_Folding::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingSeat5_Folding", (tS32)0xc308bb9a);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingSeat5_Folding, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingSeat5_Folding::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingSeat5_Folding::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingSeat5_Folding::tGetData() {
   vUpdate();
   return tSettingSeat5_Folding;
};
tS32 dp_tclVehFuncSettingSeat5_Folding::s32GetData(tU8& tSettingSeat5_FoldingParam) { 
   vUpdate();
   tSettingSeat5_FoldingParam = tSettingSeat5_Folding;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingSeat5_Folding::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingSeat5_Folding", (tS32)0xc308bb9a);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingSeat5_Folding::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingSeat5_Folding::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingSeat5_Folding::s32SetData(tU8 &tSettingSeat5_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat5_Folding,(tVoid*)&tSettingSeat5_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat5_FoldingParam' in function 'dp_tclVehFuncSettingSeat5_Folding::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingSeat5_Folding::s32SetData(const tU8 &tSettingSeat5_FoldingParam) {
   //init parameter
   (tVoid)memcpy(&tSettingSeat5_Folding,(tVoid*)&tSettingSeat5_FoldingParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingSeat5_FoldingParam' in function 'dp_tclVehFuncSettingSeat5_Folding::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingSeat5_Folding::u8GetData(tU8& tSettingSeat5_FoldingParam) {  
   vUpdate();
   tSettingSeat5_FoldingParam = tSettingSeat5_Folding;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingSeat5_Folding::vSetData(tU8 &tSettingSeat5_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat5_Folding,(tVoid*)&tSettingSeat5_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat5_FoldingParam' in function 'dp_tclVehFuncSettingSeat5_Folding::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingSeat5_Folding::vSetData(const tU8 &tSettingSeat5_FoldingParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingSeat5_Folding,(tVoid*)&tSettingSeat5_FoldingParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingSeat5_FoldingParam' in function 'dp_tclVehFuncSettingSeat5_Folding::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingSeat5_Folding::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingSeat5_Folding::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat5_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat5_Folding::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingSeat5_Folding", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingSeat5_Folding::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingSeat5_Folding", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingSeat5_Folding has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 

//--------------------------------------------------------------------------------------------------------------
//---------------       access class datapool element "SettingCourtesyActivation"   -----------------------------------
//--------------------------------------------------------------------------------------------------------------
dp_tclVehFuncSettingCourtesyActivation::dp_tclVehFuncSettingCourtesyActivation(tU16 DPid)
{
    _u16AccessId = DPid;
	_u16AccessType = 0x0006;
	_s32Status = DP_S32_ERR_IDLE;
	_u8DataStatus = DP_U8_ELEM_STATUS_INITVAL;
	     
	       
	(tVoid)memset(&tSettingCourtesyActivation,0,sizeof(tU8));
#ifndef VARIANT_S_FTR_ENABLE_DATAPOOL_MOCK
	vUpdate();
#endif
};
tVoid dp_tclVehFuncSettingCourtesyActivation::vUpdate(tVoid) 
{
   dp_tclBaseElement myDpElem("SettingCourtesyActivation",(tS32) 0xea7b04c6);
   _u8DataStatus = DP_U8_ELEM_STATUS_INVALID;
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (DP_S32_NO_ERR == _s32Status) 
   {
      if (myDpElem.u32GetDataLength() == sizeof(tU8)) 
      {
         tSettingCourtesyActivation = *((tU8*)myDpElem.pvGetData());
         _u8DataStatus = DP_U8_ELEM_STATUS_VALID;
         if(myDpElem.eGetElementState()==dp_tclBaseElement::eDpElemInit)
		       _u8DataStatus=DP_U8_ELEM_STATUS_INITVAL;		  
      }
   }
}

tVoid dp_tclVehFuncSettingCourtesyActivation::vStore(tVoid) {
   dp_tclBaseElement myDpElem("SettingCourtesyActivation", (tS32)0xea7b04c6);
   (tVoid)myDpElem.bFillData((tVoid*)&tSettingCourtesyActivation, (tU32)sizeof(tU8));
   _s32Status = DP_s32SetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
}
//current state of interface
tS32  dp_tclVehFuncSettingCourtesyActivation::s32GetStatus() const {return _s32Status;};
tU8   dp_tclVehFuncSettingCourtesyActivation::u8GetElementStatus() const {return _u8DataStatus;};

//read access for pool element 
tU8 dp_tclVehFuncSettingCourtesyActivation::tGetData() {
   vUpdate();
   return tSettingCourtesyActivation;
};
tS32 dp_tclVehFuncSettingCourtesyActivation::s32GetData(tU8& tSettingCourtesyActivationParam) { 
   vUpdate();
   tSettingCourtesyActivationParam = tSettingCourtesyActivation;
   return _s32Status;
}
tS32 dp_tclVehFuncSettingCourtesyActivation::s32GetDataRaw(tS8* pData, tU32 u32Len) {
   dp_tclBaseElement myDpElem("SettingCourtesyActivation", (tS32)0xea7b04c6);
   _s32Status = DP_s32GetElement(DP_U32_POOL_ID_VEHFUNC, &myDpElem, _u16AccessId);
   if (_s32Status == DP_S32_NO_ERR) {
      if (myDpElem.u32GetDataLength() < u32Len) {
         (tVoid)memcpy(pData, myDpElem.pvGetData(), myDpElem.u32GetDataLength());
         _s32Status = (tS32)myDpElem.u32GetDataLength();
      } else {
         _s32Status = DP_S32_ERR_RD_BUF_LEN;
      }
   }
   return _s32Status;
}
tVoid dp_tclVehFuncSettingCourtesyActivation::operator>>(tU8& oParam){return (tVoid)u8GetData(oParam);};

//write access for pool element
tVoid dp_tclVehFuncSettingCourtesyActivation::operator<<(tU8 oParam){
   return vSetData(oParam);
};//lint !e1746
tS32 dp_tclVehFuncSettingCourtesyActivation::s32SetData(tU8 &tSettingCourtesyActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingCourtesyActivation,(tVoid*)&tSettingCourtesyActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingCourtesyActivationParam' in function 'dp_tclVehFuncSettingCourtesyActivation::vSetData(tU8)' could be made const reference
tS32 dp_tclVehFuncSettingCourtesyActivation::s32SetData(const tU8 &tSettingCourtesyActivationParam) {
   //init parameter
   (tVoid)memcpy(&tSettingCourtesyActivation,(tVoid*)&tSettingCourtesyActivationParam, sizeof(tU8));
   vStore();
   return _s32Status;
}//lint !e1746: parameter 'tSettingCourtesyActivationParam' in function 'dp_tclVehFuncSettingCourtesyActivation::vSetData(tU8)' could be made const reference
// do not use --> old interface
tU8 dp_tclVehFuncSettingCourtesyActivation::u8GetData(tU8& tSettingCourtesyActivationParam) {  
   vUpdate();
   tSettingCourtesyActivationParam = tSettingCourtesyActivation;
   return _u8DataStatus;
}
tVoid dp_tclVehFuncSettingCourtesyActivation::vSetData(tU8 &tSettingCourtesyActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingCourtesyActivation,(tVoid*)&tSettingCourtesyActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingCourtesyActivationParam' in function 'dp_tclVehFuncSettingCourtesyActivation::vSetData(tU8)' could be made const reference
tVoid dp_tclVehFuncSettingCourtesyActivation::vSetData(const tU8 &tSettingCourtesyActivationParam) { 
   //init parameter
   (tVoid)memcpy(&tSettingCourtesyActivation,(tVoid*)&tSettingCourtesyActivationParam, sizeof(tU8));
   vStore();
}//lint !e1746: parameter 'tSettingCourtesyActivationParam' in function 'dp_tclVehFuncSettingCourtesyActivation::vSetData(tU8)' could be made const reference
tU8   dp_tclVehFuncSettingCourtesyActivation::u8GetStatus() const {return _u8DataStatus;};

//notification handling not over processes only for application
tBool dp_tclVehFuncSettingCourtesyActivation::bAddNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bAddNotification(DP_U32_POOL_ID_VEHFUNC, "SettingCourtesyActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingCourtesyActivation::bRemoveNotification(tVoid* pFunc, tU32 u32Event) {
    return DP_bRemoveNotification(DP_U32_POOL_ID_VEHFUNC, "SettingCourtesyActivation", pFunc, u32Event, _u16AccessId);
}
tBool dp_tclVehFuncSettingCourtesyActivation::bReloadDpElement(void) {
   tBool bRet = FALSE; 
   if ((_u16AccessType == 0x0666) || (_u16AccessType == 0x0446))
   {
      fprintf(stdout,"bReloadDpElement(): pool id:0x%4x and Element: SettingCourtesyActivation", DP_U32_POOL_ID_VEHFUNC);
      bRet = DP_bReloadPool(DP_U32_POOL_ID_VEHFUNC);
   }
   else
   {
      fprintf(stdout,"Element SettingCourtesyActivation has no shared access type");//Reload only for shared dpelement, otherwise returns false
   }
   return bRet;
}
 
 
